"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtobufValidateEncodeProgrammer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const IdentifierFactory_1 = require("../../factories/IdentifierFactory");
const StatementFactory_1 = require("../../factories/StatementFactory");
const TypeFactory_1 = require("../../factories/TypeFactory");
const FeatureProgrammer_1 = require("../FeatureProgrammer");
const ValidateProgrammer_1 = require("../ValidateProgrammer");
const FunctionProgrammer_1 = require("../helpers/FunctionProgrammer");
const ProtobufEncodeProgrammer_1 = require("./ProtobufEncodeProgrammer");
var ProtobufValidateEncodeProgrammer;
(function (ProtobufValidateEncodeProgrammer) {
    ProtobufValidateEncodeProgrammer.decompose = (props) => {
        var _a;
        const validate = ValidateProgrammer_1.ValidateProgrammer.decompose(Object.assign(Object.assign({}, props), { context: Object.assign(Object.assign({}, props.context), { options: Object.assign(Object.assign({}, props.context.options), { functional: false, numeric: true }) }), config: {
                equals: false,
            } }));
        const encode = ProtobufEncodeProgrammer_1.ProtobufEncodeProgrammer.decompose(props);
        return {
            functions: Object.assign(Object.assign({}, validate.functions), encode.functions),
            statements: [
                ...validate.statements,
                ...encode.statements,
                StatementFactory_1.StatementFactory.constant({
                    name: "__validate",
                    value: validate.arrow,
                }),
                StatementFactory_1.StatementFactory.constant({
                    name: "__encode",
                    value: encode.arrow,
                }),
            ],
            arrow: typescript_1.default.factory.createArrowFunction(undefined, undefined, [IdentifierFactory_1.IdentifierFactory.parameter("input", TypeFactory_1.TypeFactory.keyword("any"))], props.context.importer.type({
                file: "typia",
                name: "IValidation",
                arguments: [
                    (_a = encode.arrow.type) !== null && _a !== void 0 ? _a : typescript_1.default.factory.createTypeReferenceNode("Uint8Array"),
                ],
            }), undefined, typescript_1.default.factory.createBlock([
                StatementFactory_1.StatementFactory.constant({
                    name: "result",
                    value: typescript_1.default.factory.createAsExpression(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__validate"), undefined, [typescript_1.default.factory.createIdentifier("input")]), TypeFactory_1.TypeFactory.keyword("any")),
                }),
                typescript_1.default.factory.createIfStatement(typescript_1.default.factory.createIdentifier("result.success"), typescript_1.default.factory.createExpressionStatement(typescript_1.default.factory.createBinaryExpression(typescript_1.default.factory.createIdentifier("result.data"), typescript_1.default.SyntaxKind.EqualsToken, typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("__encode"), undefined, [typescript_1.default.factory.createIdentifier("input")])))),
                typescript_1.default.factory.createReturnStatement(typescript_1.default.factory.createIdentifier("result")),
            ], true)),
        };
    };
    ProtobufValidateEncodeProgrammer.write = (props) => {
        const functor = new FunctionProgrammer_1.FunctionProgrammer(props.modulo.getText());
        const result = ProtobufValidateEncodeProgrammer.decompose(Object.assign(Object.assign({}, props), { functor }));
        return FeatureProgrammer_1.FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(ProtobufValidateEncodeProgrammer || (exports.ProtobufValidateEncodeProgrammer = ProtobufValidateEncodeProgrammer = {}));
//# sourceMappingURL=ProtobufValidateEncodeProgrammer.js.map