import ts from 'typescript';
import { IdentifierFactory } from '../../factories/IdentifierFactory.mjs';
import { StatementFactory } from '../../factories/StatementFactory.mjs';
import { TypeFactory } from '../../factories/TypeFactory.mjs';
import { AssertProgrammer } from '../AssertProgrammer.mjs';
import { FeatureProgrammer } from '../FeatureProgrammer.mjs';
import { FunctionProgrammer } from '../helpers/FunctionProgrammer.mjs';
import { ProtobufEncodeProgrammer } from './ProtobufEncodeProgrammer.mjs';

var ProtobufAssertEncodeProgrammer;
(function (ProtobufAssertEncodeProgrammer) {
    ProtobufAssertEncodeProgrammer.decompose = (props) => {
        const assert = AssertProgrammer.decompose({
            ...props,
            context: {
                ...props.context,
                options: {
                    ...props.context.options,
                    functional: false,
                    numeric: true,
                },
            },
            config: {
                equals: false,
                guard: false,
            },
        });
        const encode = ProtobufEncodeProgrammer.decompose(props);
        return {
            functions: {
                ...assert.functions,
                ...encode.functions,
            },
            statements: [
                ...assert.statements,
                ...encode.statements,
                StatementFactory.constant({
                    name: "__assert",
                    value: assert.arrow,
                }),
                StatementFactory.constant({
                    name: "__encode",
                    value: encode.arrow,
                }),
            ],
            arrow: ts.factory.createArrowFunction(undefined, undefined, [
                IdentifierFactory.parameter("input", TypeFactory.keyword("any")),
                AssertProgrammer.Guardian.parameter({
                    context: props.context,
                    init: props.init,
                }),
            ], encode.arrow.type, undefined, ts.factory.createCallExpression(ts.factory.createIdentifier("__encode"), undefined, [
                ts.factory.createCallExpression(ts.factory.createIdentifier("__assert"), undefined, [
                    ts.factory.createIdentifier("input"),
                    AssertProgrammer.Guardian.identifier(),
                ]),
            ])),
        };
    };
    ProtobufAssertEncodeProgrammer.write = (props) => {
        const functor = new FunctionProgrammer(props.modulo.getText());
        const result = ProtobufAssertEncodeProgrammer.decompose({
            ...props,
            functor,
        });
        return FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(ProtobufAssertEncodeProgrammer || (ProtobufAssertEncodeProgrammer = {}));

export { ProtobufAssertEncodeProgrammer };
//# sourceMappingURL=ProtobufAssertEncodeProgrammer.mjs.map
