import ts from 'typescript';
import { IdentifierFactory } from '../../factories/IdentifierFactory.mjs';
import { StatementFactory } from '../../factories/StatementFactory.mjs';
import { TypeFactory } from '../../factories/TypeFactory.mjs';
import { AssertProgrammer } from '../AssertProgrammer.mjs';
import { FeatureProgrammer } from '../FeatureProgrammer.mjs';
import { FunctionProgrammer } from '../helpers/FunctionProgrammer.mjs';
import { MiscCloneProgrammer } from './MiscCloneProgrammer.mjs';

var MiscAssertCloneProgrammer;
(function (MiscAssertCloneProgrammer) {
    MiscAssertCloneProgrammer.decompose = (props) => {
        const assert = AssertProgrammer.decompose({
            ...props,
            config: {
                equals: false,
                guard: false,
            },
        });
        const clone = MiscCloneProgrammer.decompose({
            ...props,
            validated: true,
        });
        return {
            functions: {
                ...assert.functions,
                ...clone.functions,
            },
            statements: [
                ...assert.statements,
                ...clone.statements,
                StatementFactory.constant({
                    name: "__assert",
                    value: assert.arrow,
                }),
                StatementFactory.constant({
                    name: "__clone",
                    value: clone.arrow,
                }),
            ],
            arrow: ts.factory.createArrowFunction(undefined, undefined, [
                IdentifierFactory.parameter("input", TypeFactory.keyword("any")),
                AssertProgrammer.Guardian.parameter({
                    context: props.context,
                    init: props.init,
                }),
            ], clone.arrow.type, undefined, ts.factory.createCallExpression(ts.factory.createIdentifier("__clone"), undefined, [
                ts.factory.createCallExpression(ts.factory.createIdentifier("__assert"), undefined, [
                    ts.factory.createIdentifier("input"),
                    AssertProgrammer.Guardian.identifier(),
                ]),
            ])),
        };
    };
    MiscAssertCloneProgrammer.write = (props) => {
        const functor = new FunctionProgrammer(props.modulo.getText());
        const result = MiscAssertCloneProgrammer.decompose({
            ...props,
            functor,
        });
        return FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(MiscAssertCloneProgrammer || (MiscAssertCloneProgrammer = {}));

export { MiscAssertCloneProgrammer };
//# sourceMappingURL=MiscAssertCloneProgrammer.mjs.map
