import { OpenApiTypeChecker } from '@samchon/openapi';
import { LlmSchemaComposer } from '@samchon/openapi/lib/composers/LlmSchemaComposer.mjs';
import { TransformerError } from '../../transformers/TransformerError.mjs';
import { JsonSchemasProgrammer } from '../json/JsonSchemasProgrammer.mjs';
import { LlmSchemaProgrammer } from './LlmSchemaProgrammer.mjs';

var LlmParametersProgrammer;
(function (LlmParametersProgrammer) {
    LlmParametersProgrammer.write = (props) => {
        const collection = JsonSchemasProgrammer.write({
            version: "3.1",
            metadatas: [props.metadata],
        });
        const schema = (() => {
            const schema = collection.schemas[0];
            if (OpenApiTypeChecker.isObject(schema))
                return schema;
            else if (OpenApiTypeChecker.isReference(schema)) {
                const last = collection.components.schemas?.[schema.$ref.split("/").pop()];
                if (last && OpenApiTypeChecker.isObject(last))
                    return last;
            }
            throw new Error("Unreachable code. Failed to find the object schema.");
        })();
        const result = LlmSchemaComposer.parameters(props.model)({
            config: {
                ...LlmSchemaComposer.defaultConfig(props.model),
                ...props.config,
            },
            components: collection.components,
            schema,
        });
        if (result.success === false)
            throw new TransformerError({
                code: "typia.llm.parameters",
                message: "failed to convert JSON schema to LLM schema.\n\n" +
                    result.error.reasons
                        .map((r) => `  - ${r.accessor}: ${r.message}`)
                        .join("\n"),
            });
        return result.value;
    };
    LlmParametersProgrammer.validate = (props) => (metadata, explore) => {
        const output = [];
        if (explore.top === true) {
            if (metadata.objects.length === 0)
                output.push("LLM parameters must be an object type.");
            else if (metadata.objects.length !== 1 || metadata.size() > 1)
                output.push("LLM parameters must be a single object type.");
            else {
                if (metadata.objects[0].type.properties.some((p) => p.key.isSoleLiteral() === false))
                    output.push("LLM parameters must not have dynamic keys.");
                if (metadata.nullable)
                    output.push("LLM parameters must be a non-nullable object type.");
                if (metadata.isRequired() === false)
                    output.push("LLM parameters must be a non-undefined object type.");
            }
        }
        output.push(...LlmSchemaProgrammer.validate(props)(metadata));
        return output;
    };
})(LlmParametersProgrammer || (LlmParametersProgrammer = {}));

export { LlmParametersProgrammer };
//# sourceMappingURL=LlmParametersProgrammer.mjs.map
