"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LlmParametersProgrammer = void 0;
const openapi_1 = require("@samchon/openapi");
const LlmSchemaComposer_1 = require("@samchon/openapi/lib/composers/LlmSchemaComposer");
const TransformerError_1 = require("../../transformers/TransformerError");
const JsonSchemasProgrammer_1 = require("../json/JsonSchemasProgrammer");
const LlmSchemaProgrammer_1 = require("./LlmSchemaProgrammer");
var LlmParametersProgrammer;
(function (LlmParametersProgrammer) {
    LlmParametersProgrammer.write = (props) => {
        const collection = JsonSchemasProgrammer_1.JsonSchemasProgrammer.write({
            version: "3.1",
            metadatas: [props.metadata],
        });
        const schema = (() => {
            var _a;
            const schema = collection.schemas[0];
            if (openapi_1.OpenApiTypeChecker.isObject(schema))
                return schema;
            else if (openapi_1.OpenApiTypeChecker.isReference(schema)) {
                const last = (_a = collection.components.schemas) === null || _a === void 0 ? void 0 : _a[schema.$ref.split("/").pop()];
                if (last && openapi_1.OpenApiTypeChecker.isObject(last))
                    return last;
            }
            throw new Error("Unreachable code. Failed to find the object schema.");
        })();
        const result = LlmSchemaComposer_1.LlmSchemaComposer.parameters(props.model)({
            config: Object.assign(Object.assign({}, LlmSchemaComposer_1.LlmSchemaComposer.defaultConfig(props.model)), props.config),
            components: collection.components,
            schema,
        });
        if (result.success === false)
            throw new TransformerError_1.TransformerError({
                code: "typia.llm.parameters",
                message: "failed to convert JSON schema to LLM schema.\n\n" +
                    result.error.reasons
                        .map((r) => `  - ${r.accessor}: ${r.message}`)
                        .join("\n"),
            });
        return result.value;
    };
    LlmParametersProgrammer.validate = (props) => (metadata, explore) => {
        const output = [];
        if (explore.top === true) {
            if (metadata.objects.length === 0)
                output.push("LLM parameters must be an object type.");
            else if (metadata.objects.length !== 1 || metadata.size() > 1)
                output.push("LLM parameters must be a single object type.");
            else {
                if (metadata.objects[0].type.properties.some((p) => p.key.isSoleLiteral() === false))
                    output.push("LLM parameters must not have dynamic keys.");
                if (metadata.nullable)
                    output.push("LLM parameters must be a non-nullable object type.");
                if (metadata.isRequired() === false)
                    output.push("LLM parameters must be a non-undefined object type.");
            }
        }
        output.push(...LlmSchemaProgrammer_1.LlmSchemaProgrammer.validate(props)(metadata));
        return output;
    };
})(LlmParametersProgrammer || (exports.LlmParametersProgrammer = LlmParametersProgrammer = {}));
//# sourceMappingURL=LlmParametersProgrammer.js.map