import { ILlmApplication, ILlmSchema } from "@samchon/openapi";
import ts from "typescript";
import { MetadataFactory } from "../../factories/MetadataFactory";
import { Metadata } from "../../schemas/metadata/Metadata";
import { ITypiaContext } from "../../transformers/ITypiaContext";
export declare namespace LlmApplicationProgrammer {
    const validate: <Model extends ILlmSchema.Model>(props: {
        model: Model;
        config?: Partial<ILlmSchema.ModelConfig[Model]>;
    }) => (metadata: Metadata, explore: MetadataFactory.IExplore) => string[];
    const write: <Model extends ILlmSchema.Model>(props: {
        model: Model;
        context: ITypiaContext;
        modulo: ts.LeftHandSideExpression;
        metadata: Metadata;
        config?: Partial<ILlmSchema.ModelConfig[Model] & {
            equals: boolean;
        }>;
        name?: string;
    }) => ILlmApplication<Model>;
}
