import ts from 'typescript';
import { IdentifierFactory } from '../../factories/IdentifierFactory.mjs';
import { StatementFactory } from '../../factories/StatementFactory.mjs';
import { TypeFactory } from '../../factories/TypeFactory.mjs';
import { FeatureProgrammer } from '../FeatureProgrammer.mjs';
import { IsProgrammer } from '../IsProgrammer.mjs';
import { FunctionProgrammer } from '../helpers/FunctionProgrammer.mjs';
import { JsonStringifyProgrammer } from './JsonStringifyProgrammer.mjs';

var JsonIsStringifyProgrammer;
(function (JsonIsStringifyProgrammer) {
    JsonIsStringifyProgrammer.decompose = (props) => {
        const is = IsProgrammer.decompose({
            ...props,
            context: {
                ...props.context,
                options: {
                    ...props.context.options,
                    functional: false,
                    numeric: true,
                },
            },
            config: {
                equals: false,
            },
        });
        const stringify = JsonStringifyProgrammer.decompose({
            ...props,
            context: {
                ...props.context,
                options: {
                    ...props.context.options,
                    functional: false,
                    numeric: true,
                },
            },
            validated: true,
        });
        return {
            functions: {
                ...is.functions,
                ...stringify.functions,
            },
            statements: [
                ...is.statements,
                ...stringify.statements,
                StatementFactory.constant({
                    name: "__is",
                    value: is.arrow,
                }),
                StatementFactory.constant({
                    name: "__stringify",
                    value: stringify.arrow,
                }),
            ],
            arrow: ts.factory.createArrowFunction(undefined, undefined, [IdentifierFactory.parameter("input", TypeFactory.keyword("any"))], ts.factory.createUnionTypeNode([
                stringify.arrow.type ?? TypeFactory.keyword("string"),
                ts.factory.createLiteralTypeNode(ts.factory.createNull()),
            ]), undefined, ts.factory.createConditionalExpression(ts.factory.createCallExpression(ts.factory.createIdentifier("__is"), undefined, [ts.factory.createIdentifier("input")]), undefined, ts.factory.createCallExpression(ts.factory.createIdentifier("__stringify"), undefined, [ts.factory.createIdentifier("input")]), undefined, ts.factory.createNull())),
        };
    };
    JsonIsStringifyProgrammer.write = (props) => {
        const functor = new FunctionProgrammer(props.modulo.getText());
        const result = JsonIsStringifyProgrammer.decompose({
            ...props,
            functor,
        });
        return FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(JsonIsStringifyProgrammer || (JsonIsStringifyProgrammer = {}));

export { JsonIsStringifyProgrammer };
//# sourceMappingURL=JsonIsStringifyProgrammer.mjs.map
