import ts from 'typescript';
import { IdentifierFactory } from '../../factories/IdentifierFactory.mjs';
import { StatementFactory } from '../../factories/StatementFactory.mjs';
import { TypeFactory } from '../../factories/TypeFactory.mjs';
import { AssertProgrammer } from '../AssertProgrammer.mjs';
import { FeatureProgrammer } from '../FeatureProgrammer.mjs';
import { FunctionProgrammer } from '../helpers/FunctionProgrammer.mjs';
import { JsonStringifyProgrammer } from './JsonStringifyProgrammer.mjs';

var JsonAssertStringifyProgrammer;
(function (JsonAssertStringifyProgrammer) {
    JsonAssertStringifyProgrammer.decompose = (props) => {
        const assert = AssertProgrammer.decompose({
            ...props,
            context: {
                ...props.context,
                options: {
                    ...props.context.options,
                    functional: false,
                    numeric: true,
                },
            },
            config: {
                equals: false,
                guard: false,
            },
        });
        const stringify = JsonStringifyProgrammer.decompose({
            ...props,
            validated: true,
        });
        return {
            functions: {
                ...assert.functions,
                ...stringify.functions,
            },
            statements: [
                ...assert.statements,
                ...stringify.statements,
                StatementFactory.constant({
                    name: "__assert",
                    value: assert.arrow,
                }),
                StatementFactory.constant({
                    name: "__stringify",
                    value: stringify.arrow,
                }),
            ],
            arrow: ts.factory.createArrowFunction(undefined, undefined, [
                IdentifierFactory.parameter("input", TypeFactory.keyword("any")),
                AssertProgrammer.Guardian.parameter({
                    context: props.context,
                    init: props.init,
                }),
            ], stringify.arrow.type, undefined, ts.factory.createBlock([
                ts.factory.createExpressionStatement(ts.factory.createCallExpression(ts.factory.createIdentifier("__assert"), undefined, [
                    ts.factory.createIdentifier("input"),
                    AssertProgrammer.Guardian.identifier(),
                ])),
                ts.factory.createReturnStatement(ts.factory.createCallExpression(ts.factory.createIdentifier("__stringify"), undefined, [ts.factory.createIdentifier("input")])),
            ], true)),
        };
    };
    JsonAssertStringifyProgrammer.write = (props) => {
        const functor = new FunctionProgrammer(props.modulo.getText());
        const result = JsonAssertStringifyProgrammer.decompose({
            context: props.context,
            functor,
            type: props.type,
            name: props.name,
            init: props.init,
        });
        return FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
})(JsonAssertStringifyProgrammer || (JsonAssertStringifyProgrammer = {}));

export { JsonAssertStringifyProgrammer };
//# sourceMappingURL=JsonAssertStringifyProgrammer.mjs.map
