import { Metadata } from '../../schemas/metadata/Metadata.mjs';
import { JsonSchemasProgrammer } from './JsonSchemasProgrammer.mjs';

var JsonApplicationProgrammer;
(function (JsonApplicationProgrammer) {
    JsonApplicationProgrammer.validate = (metadata, explore) => {
        if (explore.top === false)
            return JsonSchemasProgrammer.validate(metadata);
        const output = [];
        const valid = metadata.size() === 1 &&
            metadata.objects.length === 1 &&
            metadata.isRequired() === true &&
            metadata.nullable === false;
        if (valid === false)
            output.push("JSON application's generic argument must be a class/interface type.");
        const object = metadata.objects[0]?.type;
        if (object !== undefined) {
            if (object.properties.some((p) => p.key.isSoleLiteral() === false))
                output.push("JSON application does not allow dynamic keys.");
            let least = false;
            for (const p of object.properties) {
                const value = p.value;
                if (value.functions.length) {
                    least ||= true;
                    if (valid === false) {
                        if (value.functions.length !== 1 || value.size() !== 1)
                            output.push("JSON application's function type does not allow union type.");
                        if (value.isRequired() === false)
                            output.push("JSON application's function type must be required.");
                        if (value.nullable === true)
                            output.push("JSON application's function type must not be nullable.");
                    }
                }
            }
            if (least === false)
                output.push("JSON application's target type must have at least a function type.");
        }
        return output;
    };
    JsonApplicationProgrammer.write = (props) => {
        const object = props.metadata.objects[0].type;
        const definitions = [];
        const setters = [];
        const collect = (metadata, setter) => {
            definitions.push(metadata);
            setters.push(setter);
        };
        const functions = object.properties
            .filter((p) => p.key.isSoleLiteral() &&
            p.value.size() === 1 &&
            p.value.nullable === false &&
            p.value.isRequired() === true &&
            Metadata.unalias(p.value).functions.length === 1)
            .filter((p) => p.jsDocTags.find((tag) => tag.name === "hidden" || tag.name === "internal") === undefined &&
            (props.filter === undefined || props.filter(p) === true))
            .map((r) => collectFunction({
            version: props.version,
            name: r.key.getSoleLiteral(),
            function: Metadata.unalias(r.value).functions[0],
            description: r.description,
            jsDocTags: r.jsDocTags,
            collect,
        }));
        const { components, schemas } = JsonSchemasProgrammer.write({
            version: props.version,
            metadatas: definitions,
        });
        schemas.forEach((s, i) => setters[i]?.(s));
        return {
            version: props.version,
            components: components,
            functions,
        };
    };
    JsonApplicationProgrammer.writeDescription = (props) => {
        const title = (() => {
            const [explicit] = getJsDocTexts({
                jsDocTags: props.jsDocTags,
                name: props.kind,
            });
            if (explicit?.length)
                return explicit;
            else if (!props.description?.length)
                return undefined;
            const index = props.description.indexOf("\n");
            const top = (index === -1 ? props.description : props.description.substring(0, index)).trim();
            return top.endsWith(".") ? top.substring(0, top.length - 1) : undefined;
        })();
        return {
            [props.kind]: title,
            description: props.description?.length ? props.description : undefined,
        };
    };
    const collectFunction = (props) => {
        const deprecated = props.jsDocTags.some((tag) => tag.name === "deprecated");
        const tags = props.jsDocTags
            .map((tag) => tag.name === "tag"
            ? (tag.text?.filter((elem) => elem.kind === "text") ?? [])
            : [])
            .flat()
            .map((elem) => elem.text)
            .map((str) => str.trim().split(" ")[0] ?? "")
            .filter((str) => !!str.length);
        return {
            name: props.name,
            async: props.function.async,
            parameters: props.function.parameters.map((param) => {
                const appParam = {
                    name: param.name,
                    ...JsonApplicationProgrammer.writeDescription({
                        description: param.description ??
                            param.jsDocTags.find((tag) => tag.name === "description")
                                ?.text?.[0]?.text ??
                            props.jsDocTags
                                .find((tag) => tag.name === "param" && tag.text?.[0]?.text === param.name)
                                ?.text?.map((e) => e.text)
                                .join("")
                                .substring(param.name.length) ??
                            null,
                        jsDocTags: props.jsDocTags,
                        kind: "title",
                    }),
                    required: param.type.isRequired(),
                    schema: null,
                };
                props.collect(param.type, (schema) => (appParam.schema = schema));
                return appParam;
            }),
            output: props.function.output.size()
                ? (() => {
                    const appOutput = {
                        schema: null,
                        required: props.function.output.isRequired(),
                        description: writeDescriptionFromJsDocTag({
                            jsDocTags: props.jsDocTags,
                            name: "return",
                        }) ??
                            writeDescriptionFromJsDocTag({
                                jsDocTags: props.jsDocTags,
                                name: "returns",
                            }) ??
                            undefined,
                    };
                    props.collect(props.function.output, (schema) => (appOutput.schema = schema));
                    return appOutput;
                })()
                : undefined,
            description: props.description ?? undefined,
            deprecated: deprecated || undefined,
            tags: tags.length ? tags : undefined,
        };
    };
})(JsonApplicationProgrammer || (JsonApplicationProgrammer = {}));
const writeDescriptionFromJsDocTag = (props) => {
    const parametric = props.parameter
        ? (tag) => tag.text.find((elem) => elem.kind === "parameterName" && elem.text === props.parameter) !== undefined
        : () => true;
    const tag = props.jsDocTags.find((tag) => tag.name === props.name && tag.text && parametric(tag));
    return tag && tag.text
        ? (tag.text.find((elem) => elem.kind === "text")?.text ?? null)
        : null;
};
const getJsDocTexts = (props) => props.jsDocTags
    .filter((tag) => tag.name === props.name &&
    tag.text &&
    tag.text.find((elem) => elem.kind === "text" && elem.text.length) !==
        undefined)
    .map((tag) => tag.text.find((elem) => elem.kind === "text").text);

export { JsonApplicationProgrammer };
//# sourceMappingURL=JsonApplicationProgrammer.mjs.map
