import { Metadata } from '../../schemas/metadata/Metadata.mjs';
import { MetadataArray } from '../../schemas/metadata/MetadataArray.mjs';
import { MetadataArrayType } from '../../schemas/metadata/MetadataArrayType.mjs';

/** @internal */
const wrap_metadata_rest_tuple = (rest) => {
    const wrapper = Metadata.initialize();
    wrapper.arrays.push(MetadataArray.create({
        type: MetadataArrayType.create({
            name: `...${rest.getName()}`,
            value: rest,
            nullables: [],
            recursive: false,
            index: null,
        }),
        tags: [],
    }));
    return wrapper;
};

export { wrap_metadata_rest_tuple };
//# sourceMappingURL=wrap_metadata_rest_tuple.mjs.map
