import { OpenApiTypeChecker } from '@samchon/openapi';
import { json_schema_station } from './json_schema_station.mjs';

/** @internal */
const json_schema_escaped = (props) => {
    const output = json_schema_station({
        blockNever: false,
        components: props.components,
        metadata: props.escaped.returns,
        attribute: {},
    });
    if (output === null)
        return [];
    if (is_date({
        visited: new Set(),
        metadata: props.escaped.original,
    })) {
        const string = OpenApiTypeChecker.isString(output)
            ? output
            : OpenApiTypeChecker.isOneOf(output)
                ? output.oneOf.find(OpenApiTypeChecker.isString)
                : undefined;
        if (string !== undefined &&
            string.format !== "date" &&
            string.format !== "date-time")
            string.format = "date-time";
    }
    return OpenApiTypeChecker.isOneOf(output)
        ? output.oneOf
        : [output];
};
/** @internal */
const is_date = (props) => {
    if (props.visited.has(props.metadata))
        return false;
    props.visited.add(props.metadata);
    return (props.metadata.natives.some((native) => native.name === "Date") ||
        props.metadata.arrays.some((array) => is_date({
            visited: props.visited,
            metadata: array.type.value,
        })) ||
        props.metadata.tuples.some((tuple) => tuple.type.elements.some((e) => is_date({
            visited: props.visited,
            metadata: e,
        }))) ||
        props.metadata.aliases.some((alias) => is_date({
            visited: props.visited,
            metadata: alias.type.value,
        })));
};

export { json_schema_escaped };
//# sourceMappingURL=json_schema_escaped.mjs.map
