"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.feature_object_entries = void 0;
const typescript_1 = __importDefault(require("typescript"));
const IdentifierFactory_1 = require("../../factories/IdentifierFactory");
const Escaper_1 = require("../../utils/Escaper");
/** @internal */
const feature_object_entries = (props) => props.object.properties.map((next) => {
    var _a;
    const sole = next.key.getSoleLiteral();
    const propInput = sole === null
        ? typescript_1.default.factory.createIdentifier("value")
        : Escaper_1.Escaper.variable(sole)
            ? typescript_1.default.factory.createPropertyAccessExpression(props.input, typescript_1.default.factory.createIdentifier(sole))
            : typescript_1.default.factory.createElementAccessExpression(props.input, typescript_1.default.factory.createStringLiteral(sole));
    return {
        input: propInput,
        key: next.key,
        meta: next.value,
        expression: props.config.decoder({
            input: propInput,
            metadata: next.value,
            explore: {
                tracable: props.config.path || props.config.trace,
                source: "function",
                from: (_a = props.from) !== null && _a !== void 0 ? _a : "object",
                postfix: props.config.trace
                    ? sole !== null
                        ? IdentifierFactory_1.IdentifierFactory.postfix(sole)
                        : (() => {
                            props.context.importer.internal(ACCESSOR);
                            return `${props.context.importer.getInternalText(ACCESSOR)}(key)`;
                        })()
                    : "",
            },
        }),
    };
});
exports.feature_object_entries = feature_object_entries;
const ACCESSOR = "accessExpressionAsString";
//# sourceMappingURL=feature_object_entries.js.map