import ts from 'typescript';
import { ExpressionFactory } from '../../factories/ExpressionFactory.mjs';

/** @internal */
const check_string = (props) => {
    const conditions = check_string_type_tags(props);
    return {
        expected: props.atomic.getName(),
        expression: ts.factory.createStrictEquality(ts.factory.createStringLiteral("string"), ts.factory.createTypeOfExpression(props.input)),
        conditions,
    };
};
/** @internal */
const check_string_type_tags = (props) => props.atomic.tags
    .map((row) => row.filter((tag) => !!tag.validate))
    .filter((row) => !!row.length)
    .map((row) => row.map((tag) => ({
    expected: `string & ${tag.name}`,
    expression: ExpressionFactory.transpile({
        transformer: props.context.transformer,
        importer: props.context.importer,
        script: tag.validate,
    })(props.input),
})));

export { check_string };
//# sourceMappingURL=check_string.mjs.map
