import ts from 'typescript';
import { ExpressionFactory } from '../../factories/ExpressionFactory.mjs';

/** @internal */
const check_native = (props) => {
    const instanceOf = ExpressionFactory.isInstanceOf(props.name, props.input);
    return ATOMIC_LIKE.has(props.name)
        ? ts.factory.createLogicalOr(ts.factory.createStrictEquality(ts.factory.createStringLiteral(props.name.toLowerCase()), ts.factory.createTypeOfExpression(props.input)), instanceOf)
        : instanceOf;
};
/** @internal */
const ATOMIC_LIKE = new Set(["Boolean", "Number", "String"]);

export { check_native };
//# sourceMappingURL=check_native.mjs.map
