"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.check_dynamic_properties = void 0;
const typescript_1 = __importDefault(require("typescript"));
const ExpressionFactory_1 = require("../../factories/ExpressionFactory");
const IdentifierFactory_1 = require("../../factories/IdentifierFactory");
const StatementFactory_1 = require("../../factories/StatementFactory");
const check_dynamic_key_1 = require("./check_dynamic_key");
const check_everything_1 = require("./check_everything");
/** @internal */
const check_dynamic_properties = (props) => {
    const length = IdentifierFactory_1.IdentifierFactory.access(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("Object.keys"), undefined, [props.input]), "length");
    const left = props.config.equals === true && props.dynamic.length === 0
        ? props.config.undefined === true ||
            props.regular.every((r) => r.meta.isRequired())
            ? typescript_1.default.factory.createStrictEquality(ExpressionFactory_1.ExpressionFactory.number(props.regular.filter((r) => r.meta.isRequired()).length), length)
            : typescript_1.default.factory.createCallExpression(props.context.importer.internal("isBetween"), [], [
                length,
                ExpressionFactory_1.ExpressionFactory.number(props.regular.filter((r) => r.meta.isRequired()).length),
                ExpressionFactory_1.ExpressionFactory.number(props.regular.length),
            ])
        : null;
    if (left !== null &&
        props.config.undefined === false &&
        props.regular.every((r) => r.meta.isRequired()))
        return left;
    const criteria = props.config.entries
        ? typescript_1.default.factory.createCallExpression(props.config.entries, undefined, [
            typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("Object.keys"), undefined, [props.input]),
            check_dynamic_property(props),
        ])
        : typescript_1.default.factory.createCallExpression(IdentifierFactory_1.IdentifierFactory.access(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("Object.keys"), undefined, [props.input]), props.config.assert ? "every" : "map"), undefined, [check_dynamic_property(props)]);
    const right = (props.config.halt || ((elem) => elem))(props.config.assert ? criteria : (0, check_everything_1.check_everything)(criteria));
    return left
        ? (props.config.undefined
            ? typescript_1.default.factory.createLogicalOr
            : typescript_1.default.factory.createLogicalAnd)(left, right)
        : right;
};
exports.check_dynamic_properties = check_dynamic_properties;
/** @internal */
const check_dynamic_property = (props) => {
    //----
    // IF CONDITIONS
    //----
    // PREPARE ASSETS
    const key = typescript_1.default.factory.createIdentifier("key");
    const value = typescript_1.default.factory.createIdentifier("value");
    const statements = [];
    const add = (expression, output) => statements.push(typescript_1.default.factory.createIfStatement(expression, typescript_1.default.factory.createReturnStatement(output)));
    const broken = { value: false };
    // GATHER CONDITIONS
    if (props.regular.length)
        add(is_regular_property(props.regular), props.config.positive);
    statements.push(StatementFactory_1.StatementFactory.constant({
        name: "value",
        value: typescript_1.default.factory.createElementAccessExpression(props.input, key),
    }));
    if (props.config.undefined === true)
        add(typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createIdentifier("undefined"), value), props.config.positive);
    for (const entry of props.dynamic) {
        const condition = (0, check_dynamic_key_1.check_dynamic_key)({
            context: props.context,
            metadata: entry.key,
            input: key,
        });
        if (condition.kind === typescript_1.default.SyntaxKind.TrueKeyword) {
            statements.push(typescript_1.default.factory.createReturnStatement(entry.expression));
            broken.value = true;
            break;
        }
        else
            add(condition, entry.expression);
    }
    //----
    // FUNCTION BODY
    //----
    // CLOSURE BLOCK
    const block = typescript_1.default.factory.createBlock([
        ...statements,
        ...(broken.value
            ? []
            : [
                typescript_1.default.factory.createReturnStatement(props.config.equals === true
                    ? props.config.superfluous(value, typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createPropertyAccessExpression(typescript_1.default.factory.createArrayLiteralExpression([
                        typescript_1.default.factory.createTemplateExpression(typescript_1.default.factory.createTemplateHead("The property `"), [
                            typescript_1.default.factory.createTemplateSpan(typescript_1.default.factory.createIdentifier("key"), typescript_1.default.factory.createTemplateTail("` is not defined in the object type.")),
                        ]),
                        typescript_1.default.factory.createStringLiteral(""),
                        typescript_1.default.factory.createStringLiteral("Please remove the property next time."),
                    ], true), "join"), undefined, [typescript_1.default.factory.createStringLiteral("\n")]))
                    : props.config.positive),
            ]),
    ], true);
    // RETURNS
    return typescript_1.default.factory.createArrowFunction(undefined, undefined, [IdentifierFactory_1.IdentifierFactory.parameter("key")], undefined, undefined, block);
};
/** @internal */
const is_regular_property = (regular) => typescript_1.default.factory.createCallExpression(IdentifierFactory_1.IdentifierFactory.access(typescript_1.default.factory.createArrayLiteralExpression(regular.map((entry) => typescript_1.default.factory.createStringLiteral(entry.key.getSoleLiteral()))), "some"), undefined, [
    typescript_1.default.factory.createArrowFunction(undefined, undefined, [IdentifierFactory_1.IdentifierFactory.parameter("prop")], undefined, undefined, typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createIdentifier("key"), typescript_1.default.factory.createIdentifier("prop"))),
]);
//# sourceMappingURL=check_dynamic_properties.js.map