"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.check_dynamic_key = void 0;
const typescript_1 = __importDefault(require("typescript"));
const check_bigint_1 = require("./check_bigint");
const check_number_1 = require("./check_number");
const check_string_1 = require("./check_string");
const check_template_1 = require("./check_template");
/** @internal */
const check_dynamic_key = (props) => {
    // IF PURE STRING EXISTS, THEN SKIP VALIDATION
    if ((props.metadata.atomics.length !== 0 &&
        props.metadata.atomics.some((a) => a.type === "string" &&
            a.tags.filter((row) => row.every((t) => t.validate !== undefined))
                .length === 0)) ||
        (props.metadata.natives.length !== 0 &&
            props.metadata.natives.some((native) => native.name === "String")))
        return typescript_1.default.factory.createTrue();
    const conditions = [];
    // NULLISH COALESCING
    if (props.metadata.nullable === true)
        conditions.push(typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral("null"), props.input));
    if (props.metadata.isRequired() === false)
        conditions.push(typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral("undefined"), props.input));
    // ATOMICS
    for (const atom of props.metadata.atomics)
        if (atom.type === "boolean")
            conditions.push(typescript_1.default.factory.createLogicalOr(typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral("false"), props.input), typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral("true"), props.input)));
        else if (atom.type === "bigint")
            conditions.push(typescript_1.default.factory.createLogicalAnd(typescript_1.default.factory.createCallExpression(props.context.importer.internal("isBigintString"), undefined, [props.input]), atomist((0, check_bigint_1.check_bigint)({
                context: props.context,
                atomic: atom,
                input: typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("BigInt"), undefined, [props.input]),
            }))));
        else if (atom.type === "number")
            conditions.push(atomist((0, check_number_1.check_number)({
                context: props.context,
                numeric: true,
                atomic: atom,
                input: typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("Number"), undefined, [props.input]),
            })));
        else
            conditions.push(atomist((0, check_string_1.check_string)({
                context: props.context,
                atomic: atom,
                input: props.input,
            })));
    // CONSTANTS
    for (const constant of props.metadata.constants)
        for (const { value } of constant.values)
            conditions.push(typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral(String(value)), props.input));
    // TEMPLATES
    if (!!props.metadata.templates.length)
        conditions.push(atomist((0, check_template_1.check_template)({
            templates: props.metadata.templates,
            input: props.input,
        })));
    // NATIVES
    for (const native of props.metadata.natives)
        if (native.name === "Boolean")
            conditions.push(typescript_1.default.factory.createLogicalOr(typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral("false"), props.input), typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral("true"), props.input)));
        else if (native.name === "BigInt")
            conditions.push(typescript_1.default.factory.createCallExpression(props.context.importer.internal("isBigintString"), undefined, [props.input]));
        else if (native.name === "Number")
            conditions.push(typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createFalse(), typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("Number.isNaN"), undefined, [
                typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier("Number"), undefined, [props.input]),
            ])));
    return conditions.length === 0
        ? typescript_1.default.factory.createTrue()
        : conditions.length === 1
            ? conditions[0]
            : conditions.reduce(typescript_1.default.factory.createLogicalOr);
};
exports.check_dynamic_key = check_dynamic_key;
/** @internal */
const atomist = (entry) => [
    ...(entry.expression ? [entry.expression] : []),
    ...(entry.conditions.length === 0
        ? []
        : [
            entry.conditions
                .map((set) => set
                .map((s) => s.expression)
                .reduce((a, b) => typescript_1.default.factory.createLogicalAnd(a, b)))
                .reduce((a, b) => typescript_1.default.factory.createLogicalOr(a, b)),
        ]),
].reduce((x, y) => typescript_1.default.factory.createLogicalAnd(x, y));
//# sourceMappingURL=check_dynamic_key.js.map