"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.check_bigint = void 0;
const typescript_1 = __importDefault(require("typescript"));
const ExpressionFactory_1 = require("../../factories/ExpressionFactory");
/** @internal */
const check_bigint = (props) => {
    const conditions = check_bigint_type_tags(props);
    return {
        expected: props.atomic.getName(),
        expression: typescript_1.default.factory.createStrictEquality(typescript_1.default.factory.createStringLiteral("bigint"), typescript_1.default.factory.createTypeOfExpression(props.input)),
        conditions,
    };
};
exports.check_bigint = check_bigint;
/** @internal */
const check_bigint_type_tags = (props) => props.atomic.tags
    .map((row) => row.filter((tag) => !!tag.validate))
    .filter((row) => !!row.length)
    .map((row) => row.map((tag) => ({
    expected: `bigint & ${tag.name}`,
    expression: ExpressionFactory_1.ExpressionFactory.transpile({
        transformer: props.context.transformer,
        importer: props.context.importer,
        script: tag.validate,
    })(props.input),
})));
//# sourceMappingURL=check_bigint.js.map