"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RandomProgrammer = void 0;
const typescript_1 = __importDefault(require("typescript"));
const ExpressionFactory_1 = require("../factories/ExpressionFactory");
const IdentifierFactory_1 = require("../factories/IdentifierFactory");
const LiteralFactory_1 = require("../factories/LiteralFactory");
const MetadataCollection_1 = require("../factories/MetadataCollection");
const MetadataCommentTagFactory_1 = require("../factories/MetadataCommentTagFactory");
const MetadataFactory_1 = require("../factories/MetadataFactory");
const StatementFactory_1 = require("../factories/StatementFactory");
const TemplateFactory_1 = require("../factories/TemplateFactory");
const TypeFactory_1 = require("../factories/TypeFactory");
const Metadata_1 = require("../schemas/metadata/Metadata");
const MetadataArray_1 = require("../schemas/metadata/MetadataArray");
const MetadataArrayType_1 = require("../schemas/metadata/MetadataArrayType");
const MetadataAtomic_1 = require("../schemas/metadata/MetadataAtomic");
const MetadataTuple_1 = require("../schemas/metadata/MetadataTuple");
const MetadataTupleType_1 = require("../schemas/metadata/MetadataTupleType");
const TransformerError_1 = require("../transformers/TransformerError");
const StringUtil_1 = require("../utils/StringUtil");
const FeatureProgrammer_1 = require("./FeatureProgrammer");
const FunctionProgrammer_1 = require("./helpers/FunctionProgrammer");
const RandomJoiner_1 = require("./helpers/RandomJoiner");
const json_schema_array_1 = require("./internal/json_schema_array");
const json_schema_bigint_1 = require("./internal/json_schema_bigint");
const json_schema_boolean_1 = require("./internal/json_schema_boolean");
const json_schema_number_1 = require("./internal/json_schema_number");
const json_schema_string_1 = require("./internal/json_schema_string");
var RandomProgrammer;
(function (RandomProgrammer) {
    RandomProgrammer.decompose = (props) => {
        var _a, _b;
        const collection = new MetadataCollection_1.MetadataCollection();
        const result = MetadataFactory_1.MetadataFactory.analyze({
            checker: props.context.checker,
            transformer: props.context.transformer,
            options: {
                escape: false,
                constant: true,
                absorb: true,
                validate: (meta) => {
                    const output = [];
                    if (meta.natives.some((native) => native.name === "WeakSet"))
                        output.push(`WeakSet is not supported.`);
                    else if (meta.natives.some((native) => native.name === "WeakMap"))
                        output.push(`WeakMap is not supported.`);
                    return output;
                },
            },
            collection,
            type: props.type,
        });
        if (result.success === false)
            throw TransformerError_1.TransformerError.from({
                code: props.functor.method,
                errors: result.errors,
            });
        // GENERATE FUNCTION
        const functions = Object.fromEntries([
            ...write_object_functions({
                context: props.context,
                functor: props.functor,
                collection,
            }).map((v, i) => [Prefix.object(i), v]),
            ...write_array_functions({
                context: props.context,
                functor: props.functor,
                collection,
            }).map((v, i) => [Prefix.array(i), v]),
            ...write_tuple_functions({
                context: props.context,
                functor: props.functor,
                collection,
            }).map((v, i) => [Prefix.tuple(i), v]),
        ]);
        const arrow = typescript_1.default.factory.createArrowFunction(undefined, undefined, [
            IdentifierFactory_1.IdentifierFactory.parameter("generator", typescript_1.default.factory.createTypeReferenceNode("Partial", [
                props.context.importer.type({
                    file: "typia",
                    name: "IRandomGenerator",
                }),
            ]), (_a = props.init) !== null && _a !== void 0 ? _a : typescript_1.default.factory.createToken(typescript_1.default.SyntaxKind.QuestionToken)),
        ], props.context.importer.type({
            file: "typia",
            name: "Resolved",
            arguments: [
                typescript_1.default.factory.createTypeReferenceNode((_b = props.name) !== null && _b !== void 0 ? _b : TypeFactory_1.TypeFactory.getFullName({
                    checker: props.context.checker,
                    type: props.type,
                })),
            ],
        }), undefined, typescript_1.default.factory.createBlock([
            typescript_1.default.factory.createExpressionStatement(typescript_1.default.factory.createBinaryExpression(typescript_1.default.factory.createIdentifier("_generator"), typescript_1.default.SyntaxKind.EqualsToken, typescript_1.default.factory.createIdentifier("generator"))),
            typescript_1.default.factory.createReturnStatement(decode({
                context: props.context,
                functor: props.functor,
                explore: {
                    function: false,
                    recursive: false,
                },
                metadata: result.data,
            })),
        ], true));
        return {
            functions,
            statements: [
                StatementFactory_1.StatementFactory.mut({
                    name: "_generator",
                    type: typescript_1.default.factory.createUnionTypeNode([
                        typescript_1.default.factory.createTypeReferenceNode("Partial", [
                            props.context.importer.type({
                                file: "typia",
                                name: "IRandomGenerator",
                            }),
                        ]),
                        typescript_1.default.factory.createTypeReferenceNode("undefined"),
                    ]),
                }),
            ],
            arrow,
        };
    };
    RandomProgrammer.write = (props) => {
        const functor = new FunctionProgrammer_1.FunctionProgrammer(props.modulo.getText());
        const result = RandomProgrammer.decompose(Object.assign(Object.assign({}, props), { functor }));
        return FeatureProgrammer_1.FeatureProgrammer.writeDecomposed({
            modulo: props.modulo,
            functor,
            result,
        });
    };
    const write_object_functions = (props) => props.collection.objects().map((obj, i) => StatementFactory_1.StatementFactory.constant({
        name: Prefix.object(i),
        value: typescript_1.default.factory.createArrowFunction(undefined, undefined, [
            IdentifierFactory_1.IdentifierFactory.parameter("_recursive", TypeFactory_1.TypeFactory.keyword("boolean"), typescript_1.default.factory.createIdentifier(String(obj.recursive))),
            IdentifierFactory_1.IdentifierFactory.parameter("_depth", TypeFactory_1.TypeFactory.keyword("number"), ExpressionFactory_1.ExpressionFactory.number(0)),
        ], TypeFactory_1.TypeFactory.keyword("any"), undefined, RandomJoiner_1.RandomJoiner.object({
            decode: (metadata) => decode({
                context: props.context,
                functor: props.functor,
                explore: {
                    recursive: obj.recursive,
                    function: true,
                },
                metadata,
            }),
            object: obj,
        })),
    }));
    const write_array_functions = (props) => props.collection
        .arrays()
        .filter((a) => a.recursive)
        .map((array, i) => StatementFactory_1.StatementFactory.constant({
        name: Prefix.array(i),
        value: typescript_1.default.factory.createArrowFunction(undefined, undefined, [
            IdentifierFactory_1.IdentifierFactory.parameter("_schema", TypeFactory_1.TypeFactory.keyword("boolean")),
            IdentifierFactory_1.IdentifierFactory.parameter("_recursive", TypeFactory_1.TypeFactory.keyword("boolean"), typescript_1.default.factory.createTrue()),
            IdentifierFactory_1.IdentifierFactory.parameter("_depth", TypeFactory_1.TypeFactory.keyword("number"), ExpressionFactory_1.ExpressionFactory.number(0)),
        ], TypeFactory_1.TypeFactory.keyword("any"), undefined, RandomJoiner_1.RandomJoiner.array({
            decode: (metadata) => decode({
                context: props.context,
                functor: props.functor,
                explore: {
                    recursive: true,
                    function: true,
                },
                metadata,
            }),
            recursive: true,
            expression: coalesce({
                context: props.context,
                method: "array",
                internal: "randomArray",
            }),
            array,
            schema: undefined,
        })),
    }));
    const write_tuple_functions = (props) => props.collection
        .tuples()
        .filter((a) => a.recursive)
        .map((tuple, i) => StatementFactory_1.StatementFactory.constant({
        name: Prefix.tuple(i),
        value: typescript_1.default.factory.createArrowFunction(undefined, undefined, [
            IdentifierFactory_1.IdentifierFactory.parameter("_recursive", TypeFactory_1.TypeFactory.keyword("boolean"), typescript_1.default.factory.createTrue()),
            IdentifierFactory_1.IdentifierFactory.parameter("_depth", TypeFactory_1.TypeFactory.keyword("number"), ExpressionFactory_1.ExpressionFactory.number(0)),
        ], TypeFactory_1.TypeFactory.keyword("any"), undefined, RandomJoiner_1.RandomJoiner.tuple({
            decode: (metadata) => decode({
                context: props.context,
                functor: props.functor,
                explore: {
                    function: true,
                    recursive: true,
                },
                metadata,
            }),
            elements: tuple.elements,
        })),
    }));
    /* -----------------------------------------------------------
      DECODERS
    ----------------------------------------------------------- */
    const decode = (props) => {
        const expressions = [];
        if (props.metadata.any === true)
            expressions.push(typescript_1.default.factory.createStringLiteral("any type used..."));
        // NULL COALESCING
        if (props.metadata.isRequired() === false ||
            props.metadata.functions.length !== 0)
            expressions.push(typescript_1.default.factory.createIdentifier("undefined"));
        if (props.metadata.nullable === true)
            expressions.push(typescript_1.default.factory.createNull());
        // CONSTANT TYPES
        for (const constant of props.metadata.constants)
            for (const { value } of constant.values)
                expressions.push(constant.type === "boolean"
                    ? value === true
                        ? typescript_1.default.factory.createTrue()
                        : typescript_1.default.factory.createFalse()
                    : constant.type === "bigint"
                        ? ExpressionFactory_1.ExpressionFactory.bigint(value)
                        : constant.type === "number"
                            ? ExpressionFactory_1.ExpressionFactory.number(value)
                            : typescript_1.default.factory.createStringLiteral(value));
        // ATOMIC VARIABLES
        for (const template of props.metadata.templates)
            expressions.push(decode_template(Object.assign(Object.assign({}, props), { template })));
        for (const atomic of props.metadata.atomics)
            expressions.push(...decode_atomic({
                context: props.context,
                atomic,
            }));
        // INSTANCE TYPES
        if (props.metadata.escaped)
            expressions.push(decode(Object.assign(Object.assign({}, props), { metadata: props.metadata.escaped.returns })));
        for (const array of props.metadata.arrays)
            expressions.push(...decode_array(Object.assign(Object.assign({}, props), { array })));
        for (const tuple of props.metadata.tuples)
            expressions.push(decode_tuple(Object.assign(Object.assign({}, props), { tuple })));
        for (const object of props.metadata.objects)
            expressions.push(decode_object(Object.assign(Object.assign({}, props), { object: object.type })));
        for (const native of props.metadata.natives)
            expressions.push(decode_native({
                context: props.context,
                functor: props.functor,
                explore: props.explore,
                name: native.name,
            }));
        for (const set of props.metadata.sets)
            expressions.push(decode_set(Object.assign(Object.assign({}, props), { set })));
        for (const entry of props.metadata.maps)
            expressions.push(decode_map(Object.assign(Object.assign({}, props), { map: entry })));
        // PICK UP A TYPE
        if (expressions.length === 1)
            return expressions[0];
        return typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createCallExpression(props.context.importer.internal("randomPick"), undefined, [
            typescript_1.default.factory.createArrayLiteralExpression(expressions.map((expr) => typescript_1.default.factory.createArrowFunction(undefined, undefined, [], undefined, undefined, expr)), true),
        ]), undefined, undefined);
    };
    const decode_atomic = (props) => {
        const schemaList = props.atomic.type === "boolean"
            ? (0, json_schema_boolean_1.json_schema_boolean)(props.atomic)
            : props.atomic.type === "string"
                ? (0, json_schema_string_1.json_schema_string)(props.atomic)
                : props.atomic.type === "bigint"
                    ? (0, json_schema_bigint_1.json_schema_bigint)(props.atomic)
                    : (0, json_schema_number_1.json_schema_number)(props.atomic);
        return schemaList.map((schema) => {
            const composed = (() => {
                if (props.atomic.type === "string") {
                    const string = schema;
                    if (string.format !== undefined) {
                        const format = string.format;
                        if (format === "date-time")
                            return {
                                method: "datetime",
                                internal: "randomFormatDatetime",
                                arguments: [],
                            };
                        return {
                            method: format
                                .split("-")
                                .map((s, i) => (i === 0 ? s : StringUtil_1.StringUtil.capitalize(s)))
                                .join(""),
                            internal: `randomFormat${format
                                .split("-")
                                .map(StringUtil_1.StringUtil.capitalize)
                                .join("")}`,
                            arguments: [],
                        };
                    }
                    else if (string.pattern !== undefined)
                        return {
                            method: "pattern",
                            internal: "randomPattern",
                            arguments: [
                                typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("RegExp"), undefined, [
                                    typescript_1.default.factory.createStringLiteral(schema.pattern),
                                ]),
                            ],
                        };
                }
                else if (props.atomic.type === "number") {
                    const number = schema;
                    if (number.type === "integer")
                        return {
                            method: "integer",
                            internal: "randomInteger",
                            arguments: [LiteralFactory_1.LiteralFactory.write(schema)],
                        };
                }
                else if (props.atomic.type === "boolean")
                    return {
                        method: props.atomic.type,
                        internal: "randomBoolean",
                        arguments: [],
                    };
                return {
                    method: props.atomic.type,
                    internal: `random${StringUtil_1.StringUtil.capitalize(props.atomic.type)}`,
                    arguments: [LiteralFactory_1.LiteralFactory.write(schema)],
                };
            })();
            return typescript_1.default.factory.createCallExpression(ExpressionFactory_1.ExpressionFactory.coalesce(typescript_1.default.factory.createPropertyAccessChain(typescript_1.default.factory.createIdentifier("_generator"), typescript_1.default.factory.createToken(typescript_1.default.SyntaxKind.QuestionDotToken), typescript_1.default.factory.createIdentifier(composed.method)), props.context.importer.internal(composed.internal)), undefined, composed.arguments);
        });
    };
    const decode_template = (props) => TemplateFactory_1.TemplateFactory.generate(props.template.row.map((metadata) => decode(Object.assign(Object.assign({}, props), { metadata }))));
    const decode_array = (props) => {
        const components = {};
        const schemaList = (0, json_schema_array_1.json_schema_array)({
            components,
            array: props.array,
        });
        if (props.array.type.recursive)
            return schemaList.map((schema) => typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier(props.functor.useLocal(Prefix.array(props.array.type.index))), undefined, [
                typescript_1.default.factory.createObjectLiteralExpression(Object.entries(schema)
                    .filter(([key]) => key !== "items")
                    .map(([key, value]) => typescript_1.default.factory.createPropertyAssignment(key, LiteralFactory_1.LiteralFactory.write(value))), true),
            ]));
        return schemaList.map((schema) => RandomJoiner_1.RandomJoiner.array({
            decode: (metadata) => decode(Object.assign(Object.assign({}, props), { metadata })),
            expression: coalesce({
                context: props.context,
                method: "array",
                internal: "randomArray",
            }),
            array: props.array.type,
            recursive: props.explore.recursive,
            schema,
        }));
    };
    const decode_tuple = (props) => props.tuple.type.recursive
        ? typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier(props.functor.useLocal(Prefix.tuple(props.tuple.type.index))), undefined, [
            typescript_1.default.factory.createTrue(),
            props.explore.recursive
                ? typescript_1.default.factory.createAdd(ExpressionFactory_1.ExpressionFactory.number(1), typescript_1.default.factory.createIdentifier("_depth"))
                : ExpressionFactory_1.ExpressionFactory.number(0),
        ])
        : RandomJoiner_1.RandomJoiner.tuple({
            decode: (metadata) => decode(Object.assign(Object.assign({}, props), { metadata })),
            elements: props.tuple.type.elements,
        });
    const decode_object = (props) => typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createIdentifier(props.functor.useLocal(Prefix.object(props.object.index))), undefined, props.explore.function
        ? [
            props.explore.recursive
                ? typescript_1.default.factory.createTrue()
                : typescript_1.default.factory.createIdentifier("_recursive"),
            typescript_1.default.factory.createConditionalExpression(typescript_1.default.factory.createIdentifier("_recursive"), undefined, typescript_1.default.factory.createAdd(ExpressionFactory_1.ExpressionFactory.number(1), typescript_1.default.factory.createIdentifier("_depth")), undefined, typescript_1.default.factory.createIdentifier("_depth")),
        ]
        : undefined);
    /* -----------------------------------------------------------
      NATIVE CLASSES
    ----------------------------------------------------------- */
    const decode_set = (props) => typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("Set"), undefined, [
        decode_array(Object.assign(Object.assign({}, props), { array: MetadataArray_1.MetadataArray.create({
                tags: [],
                type: MetadataArrayType_1.MetadataArrayType.create({
                    value: props.set.value,
                    recursive: false,
                    index: null,
                    nullables: [],
                    name: props.set.getName(),
                }),
            }) }))[0],
    ]);
    const decode_map = (props) => typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("Map"), undefined, [
        decode_array(Object.assign(Object.assign({}, props), { array: MetadataArray_1.MetadataArray.create({
                tags: [],
                type: MetadataArrayType_1.MetadataArrayType.create({
                    name: props.map.getName(),
                    index: null,
                    recursive: false,
                    nullables: [],
                    value: Metadata_1.Metadata.create(Object.assign(Object.assign({}, Metadata_1.Metadata.initialize()), { tuples: [
                            (() => {
                                const type = MetadataTupleType_1.MetadataTupleType.create({
                                    name: `[${props.map.key.getName()}, ${props.map.value.getName()}]`,
                                    index: null,
                                    recursive: false,
                                    nullables: [],
                                    elements: [props.map.key, props.map.value],
                                });
                                type.of_map = true;
                                return MetadataTuple_1.MetadataTuple.create({
                                    type,
                                    tags: [],
                                });
                            })(),
                        ] })),
                }),
            }) }))[0],
    ]);
    const decode_native = (props) => {
        if (props.name === "Boolean" ||
            props.name === "Number" ||
            props.name === "BigInt" ||
            props.name === "String")
            return decode_atomic({
                context: props.context,
                atomic: MetadataAtomic_1.MetadataAtomic.create({
                    type: props.name.toLowerCase(),
                    tags: [],
                }),
            })[0];
        else if (props.name === "Date")
            return decode_native_date(props.context);
        else if (props.name === "Uint8Array" ||
            props.name === "Uint8ClampedArray" ||
            props.name === "Uint16Array" ||
            props.name === "Uint32Array" ||
            props.name === "BigUint64Array" ||
            props.name === "Int8Array" ||
            props.name === "Int16Array" ||
            props.name === "Int32Array" ||
            props.name === "BigInt64Array" ||
            props.name === "Float32Array" ||
            props.name === "Float64Array")
            return decode_native_byte_array(Object.assign(Object.assign({}, props), { name: props.name }));
        else if (props.name === "ArrayBuffer" || props.name === "SharedArrayBuffer")
            return decode_native_array_buffer(Object.assign(Object.assign({}, props), { name: props.name }));
        else if (props.name === "DataView")
            return decode_native_data_view(props);
        else if (props.name === "Blob")
            return decode_native_blob(props);
        else if (props.name === "File")
            return decode_native_file(props);
        else if (props.name === "RegExp")
            return decode_regexp(props.context);
        else
            return typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier(props.name), undefined, []);
    };
    const decode_native_date = (context) => typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("Date"), undefined, [
        typescript_1.default.factory.createCallExpression(coalesce({
            context,
            method: "datetime",
            internal: "randomFormatDatetime",
        }), undefined, []),
    ]);
    const decode_native_byte_array = (props) => {
        new BigInt64Array();
        const [type, minimum, maximum] = (() => {
            if (props.name === "Uint8Array" || props.name === "Uint8ClampedArray")
                return ["uint32", 0, 255];
            else if (props.name === "Uint16Array")
                return ["uint32", 0, 65535];
            else if (props.name === "Uint32Array")
                return ["uint32", 0, 4294967295];
            else if (props.name === "BigUint64Array")
                return ["uint64", 0, 18446744073709551615];
            else if (props.name === "Int8Array")
                return ["int32", -128, 127];
            else if (props.name === "Int16Array")
                return ["int32", -32768, 32767];
            else if (props.name === "Int32Array")
                return ["int32", -2147483648, 2147483647];
            else if (props.name === "BigInt64Array")
                return ["uint64", -9223372036854775808, 9223372036854775807];
            else if (props.name === "Float32Array")
                return ["float", -1.175494351e38, 3.4028235e38];
            return ["double", Number.MIN_VALUE, Number.MAX_VALUE];
        })();
        const atomic = props.name === "BigInt64Array" || props.name === "BigUint64Array"
            ? "bigint"
            : "number";
        const value = Metadata_1.Metadata.create(Object.assign(Object.assign({}, Metadata_1.Metadata.initialize()), { atomics: [
                MetadataAtomic_1.MetadataAtomic.create({
                    type: atomic,
                    tags: [
                        [
                            ...MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                                kind: "type",
                                type: atomic,
                                value: type,
                            }),
                            ...MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                                kind: "minimum",
                                type: "number",
                                value: minimum.toString(),
                            }),
                            ...MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                                kind: "maximum",
                                type: "number",
                                value: maximum.toString(),
                            }),
                        ],
                    ],
                }),
            ] }));
        return typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier(props.name), [], decode_array({
            context: props.context,
            functor: props.functor,
            explore: props.explore,
            array: MetadataArray_1.MetadataArray.create({
                tags: [],
                type: MetadataArrayType_1.MetadataArrayType.create({
                    name: `${props.name}<${atomic}>`,
                    value,
                    recursive: false,
                    index: null,
                    nullables: [],
                }),
            }),
        }));
    };
    const decode_native_blob = (props) => typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("Blob"), undefined, [
        typescript_1.default.factory.createArrayLiteralExpression([
            decode_native_byte_array({
                context: props.context,
                functor: props.functor,
                explore: props.explore,
                name: "Uint8Array",
            }),
        ], true),
    ]);
    const decode_native_file = (props) => typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("File"), undefined, [
        typescript_1.default.factory.createArrayLiteralExpression([
            decode_native_byte_array({
                context: props.context,
                functor: props.functor,
                explore: props.explore,
                name: "Uint8Array",
            }),
        ], true),
        typescript_1.default.factory.createTemplateExpression(typescript_1.default.factory.createTemplateHead(""), [
            typescript_1.default.factory.createTemplateSpan(writeRangedString({
                context: props.context,
                minLength: 1,
                maxLength: 8,
            }), typescript_1.default.factory.createTemplateMiddle(".")),
            typescript_1.default.factory.createTemplateSpan(writeRangedString({
                context: props.context,
                minLength: 3,
                maxLength: 3,
            }), typescript_1.default.factory.createTemplateTail("")),
        ]),
    ]);
    const decode_native_array_buffer = (props) => props.name === "ArrayBuffer"
        ? IdentifierFactory_1.IdentifierFactory.access(decode_native_byte_array({
            context: props.context,
            functor: props.functor,
            explore: props.explore,
            name: "Uint8Array",
        }), "buffer")
        : ExpressionFactory_1.ExpressionFactory.selfCall(typescript_1.default.factory.createBlock([
            StatementFactory_1.StatementFactory.constant({
                name: "length",
                value: decode_atomic({
                    context: props.context,
                    atomic: MetadataAtomic_1.MetadataAtomic.create({
                        type: "number",
                        tags: [
                            MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                                type: "number",
                                kind: "type",
                                value: "uint32",
                            }),
                        ],
                    }),
                })[0],
            }),
            StatementFactory_1.StatementFactory.constant({
                name: "buffer",
                value: typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("SharedArrayBuffer"), [], [typescript_1.default.factory.createIdentifier("length")]),
            }),
            StatementFactory_1.StatementFactory.constant({
                name: "bytes",
                value: typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("Uint8Array"), [], [typescript_1.default.factory.createIdentifier("buffer")]),
            }),
            typescript_1.default.factory.createExpressionStatement(typescript_1.default.factory.createCallExpression(IdentifierFactory_1.IdentifierFactory.access(typescript_1.default.factory.createIdentifier("bytes"), "set"), undefined, [
                typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createPropertyAccessExpression(typescript_1.default.factory.createCallExpression(typescript_1.default.factory.createPropertyAccessExpression(typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("Array"), undefined, [typescript_1.default.factory.createIdentifier("length")]), typescript_1.default.factory.createIdentifier("fill")), undefined, [typescript_1.default.factory.createNumericLiteral("0")]), typescript_1.default.factory.createIdentifier("map")), undefined, [
                    typescript_1.default.factory.createArrowFunction(undefined, undefined, [], undefined, undefined, decode_atomic({
                        context: props.context,
                        atomic: MetadataAtomic_1.MetadataAtomic.create({
                            type: "number",
                            tags: [
                                [
                                    ...MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                                        kind: "type",
                                        type: "number",
                                        value: "uint32",
                                    }),
                                    ...MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                                        kind: "minimum",
                                        type: "number",
                                        value: "0",
                                    }),
                                    ...MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                                        kind: "maximum",
                                        type: "number",
                                        value: "255",
                                    }),
                                ],
                            ],
                        }),
                    })[0]),
                ]),
                ExpressionFactory_1.ExpressionFactory.number(0),
            ])),
            typescript_1.default.factory.createReturnStatement(typescript_1.default.factory.createIdentifier("buffer")),
        ], true));
    const decode_native_data_view = (props) => typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("DataView"), [], [
        IdentifierFactory_1.IdentifierFactory.access(decode_native_byte_array({
            context: props.context,
            functor: props.functor,
            explore: props.explore,
            name: "Uint8Array",
        }), "buffer"),
    ]);
    const decode_regexp = (context) => typescript_1.default.factory.createNewExpression(typescript_1.default.factory.createIdentifier("RegExp"), [], [
        typescript_1.default.factory.createCallExpression(coalesce({
            context,
            method: "regex",
            internal: "randomFormatRegex",
        }), undefined, undefined),
    ]);
    const writeRangedString = (props) => decode_atomic({
        context: props.context,
        atomic: MetadataAtomic_1.MetadataAtomic.create({
            type: "string",
            tags: [
                [
                    ...MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                        kind: "minLength",
                        type: "string",
                        value: props.minLength.toString(),
                    }),
                    ...MetadataCommentTagFactory_1.MetadataCommentTagFactory.get({
                        kind: "maxLength",
                        type: "string",
                        value: props.maxLength.toString(),
                    }),
                ],
            ],
        }),
    })[0];
})(RandomProgrammer || (exports.RandomProgrammer = RandomProgrammer = {}));
const coalesce = (props) => ExpressionFactory_1.ExpressionFactory.coalesce(typescript_1.default.factory.createPropertyAccessChain(typescript_1.default.factory.createIdentifier("_generator"), typescript_1.default.factory.createToken(typescript_1.default.SyntaxKind.QuestionDotToken), typescript_1.default.factory.createIdentifier(props.method)), props.context.importer.internal(props.internal));
const Prefix = {
    object: (i) => `_ro${i}`,
    array: (i) => `_ra${i}`,
    tuple: (i) => `_rt${i}`,
};
//# sourceMappingURL=RandomProgrammer.js.map