import ts from 'typescript';
import { MapUtil } from '../utils/MapUtil.mjs';

class ImportProgrammer {
    assets_ = new Map();
    options_;
    constructor(options) {
        this.options_ = {
            internalPrefix: options?.internalPrefix ?? "",
        };
    }
    /* -----------------------------------------------------------
      ENROLLMENTS
    ----------------------------------------------------------- */
    default(props) {
        const asset = this.take(props.file);
        asset.default ??= props;
        asset.default.type ||= props.type;
        return ts.factory.createIdentifier(asset.default.name);
    }
    instance(props) {
        const alias = props.alias ?? props.name;
        const asset = this.take(props.file);
        MapUtil.take(asset.instances, alias, () => props);
        return ts.factory.createIdentifier(alias);
    }
    namespace(props) {
        const asset = this.take(props.file);
        asset.namespace ??= props;
        return ts.factory.createIdentifier(asset.namespace.name);
    }
    type(props) {
        return ts.factory.createImportTypeNode(ts.factory.createLiteralTypeNode(ts.factory.createStringLiteral(props.file)), undefined, typeof props.name === "string"
            ? ts.factory.createIdentifier(props.name)
            : props.name, props.arguments);
    }
    /** @internal */
    internal(name) {
        if (name.startsWith("_") === false)
            name = `_${name}`;
        return ts.factory.createPropertyAccessExpression(this.namespace({
            file: `typia/lib/internal/${name}.js`,
            name: this.alias(name),
        }), name);
    }
    /** @internal */
    getInternalText(name) {
        if (name.startsWith("_") === false)
            name = `_${name}`;
        const asset = this.take(`typia/lib/internal/${name}.js`);
        if (!asset?.namespace)
            throw new Error(`Internal asset not found: ${name}`);
        return `${asset.namespace.name}.${name}`;
    }
    /** @internal */
    take(file) {
        return MapUtil.take(this.assets_, file, () => ({
            file,
            default: null,
            namespace: null,
            instances: new Map(),
        }));
    }
    alias(name) {
        return `__${this.options_.internalPrefix}${name}`;
    }
    /* -----------------------------------------------------------
      PROGRAM STATEMENTS
    ----------------------------------------------------------- */
    toStatements() {
        const statements = [];
        for (const asset of this.assets_.values()) {
            if (asset.namespace !== null)
                statements.push(ts.factory.createImportDeclaration(undefined, ts.factory.createImportClause(false, undefined, ts.factory.createNamespaceImport(ts.factory.createIdentifier(asset.namespace.name))), ts.factory.createStringLiteral(asset.file)));
            if (asset.default !== null)
                statements.push(ts.factory.createImportDeclaration(undefined, ts.factory.createImportClause(asset.default.type, ts.factory.createIdentifier(asset.default.name), undefined), ts.factory.createStringLiteral(asset.file)));
            if (asset.instances.size > 0)
                statements.push(ts.factory.createImportDeclaration(undefined, ts.factory.createImportClause(false, undefined, asset.instances.size > 0
                    ? ts.factory.createNamedImports([...asset.instances.values()].map((ins) => ts.factory.createImportSpecifier(false, ins.alias || ins.alias === ins.name
                        ? ts.factory.createIdentifier(ins.name)
                        : undefined, ts.factory.createIdentifier(ins.alias ?? ins.name))))
                    : undefined), ts.factory.createStringLiteral(asset.file), undefined));
        }
        return statements;
    }
}

export { ImportProgrammer };
//# sourceMappingURL=ImportProgrammer.mjs.map
