import { Atomic } from "./typings/Atomic";
import { IValidation } from "./IValidation";
import { Resolved } from "./Resolved";
import { TypeGuardError } from "./TypeGuardError";
/**
 * > You must configure the generic argument `T`.
 *
 * Union literal type to array.
 *
 * Converts a union literal type to an array of its members.
 *
 * ```typescript
 * literals<"A" | "B" | 1>; // ["A", "B", 1]
 * ```
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Union literal type
 * @returns Array of union literal type's members
 */
export declare function literals(): never;
/**
 * Union literal type to array.
 *
 * Converts a union literal type to an array of its members.
 *
 * ```typescript
 * literals<"A" | "B" | 1>; // ["A", "B", 1]
 * ```
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Union literal type
 * @returns Array of union literal type's members
 */
export declare function literals<T extends Atomic.Type | null>(): T[];
/**
 * Clone data.
 *
 * Clones an instance following type `T`. If the target _input_ value or its
 * member variable contains a class instance having methods, those methods would
 * not be cloned.
 *
 * For reference, this `typia.misc.clone()` function does not validate the input
 * value type. It just believes that the input value is following the type `T`.
 * Therefore, if you can't ensure the input value type, it would be better to
 * call {@link assertClone} function instead.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input A value to be cloned
 * @returns Cloned data
 */
export declare function clone<T>(input: T): Resolved<T>;
/**
 * Clone data with type assertion.
 *
 * Clones an instance following type `T`, with type assertion. If the target
 * `input` value or its member variable contains a class instance having
 * methods, those methods would not be cloned.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * throws an {@link TypeGuardError} or custom error generated by _errorFactory_.
 * Otherwise, there's no problem on the `input` value, cloned data would be
 * returned.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input A value to be cloned
 * @param errorFactory Custom error factory. Default is `TypeGuardError`
 * @returns Cloned data
 */
export declare function assertClone<T>(input: T, errorFactory?: undefined | ((props: TypeGuardError.IProps) => Error)): Resolved<T>;
/**
 * Clone data with type assertion.
 *
 * Clones an instance following type `T`, with type assertion. If the target
 * `input` value or its member variable contains a class instance having
 * methods, those methods would not be cloned.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * throws an {@link TypeGuardError} or custom error generated by _errorFactory_.
 * Otherwise, there's no problem on the `input` value, cloned data would be
 * returned.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input A value to be cloned
 * @param errorFactory Custom error factory. Default is `TypeGuardError`
 * @returns Cloned data
 */
export declare function assertClone<T>(input: unknown, errorFactory?: undefined | ((props: TypeGuardError.IProps) => Error)): Resolved<T>;
/**
 * Clone data with type checking.
 *
 * Clones an instance following type `T`, with type checking. If the target
 * `input` value or its member variable contains a class instance having
 * methods, those methods would not be cloned.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * returns `null` value instead. Otherwise, there's no problem on the `input`
 * value, cloned data would be returned.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input A value to be cloned
 * @returns Cloned data when exact type, otherwise null
 */
export declare function isClone<T>(input: T): Resolved<T> | null;
/**
 * Clone data with type checking.
 *
 * Clones an instance following type `T`, with type checking. If the target
 * `input` value or its member variable contains a class instance having
 * methods, those methods would not be cloned.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * returns `null` value instead. Otherwise, there's no problem on the `input`
 * value, cloned data would be returned.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input A value to be cloned
 * @returns Cloned data when exact type, otherwise null
 */
export declare function isClone<T>(input: unknown): Resolved<T> | null;
/**
 * Clone data with detailed type validation.
 *
 * Clones an instance following type `T`, with detailed type validation. If the
 * target `input` value or its member variable contains a class instance having
 * methods, those methods would not be cloned.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * returns {@link IValidation.Failure} value. Otherwise, there's no problem on
 * the `input` value, cloned data would be stored in `data` property of the
 * output {@link IValidation.Success} instance.
 *
 * @template T Type of the input value
 * @param input A value to be cloned
 * @returns Validation result with cloned value
 */
export declare function validateClone<T>(input: T): IValidation<Resolved<T>>;
/**
 * Clone data with detailed type validation.
 *
 * Clones an instance following type `T`, with detailed type validation. If the
 * target `input` value or its member variable contains a class instance having
 * methods, those methods would not be cloned.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * returns {@link IValidation.Failure} value. Otherwise, there's no problem on
 * the `input` value, cloned data would be stored in `data` property of the
 * output {@link IValidation.Success} instance.
 *
 * @template T Type of the input value
 * @param input A value to be cloned
 * @returns Validation result with cloned value
 */
export declare function validateClone<T>(input: unknown): IValidation<Resolved<T>>;
/**
 * Prune, erase superfluous properties.
 *
 * Remove all superfluous properties from the `input` object, even including
 * nested objects. Note that, as all superfluous properties would be deleted,
 * you never can read those superfluous properties after calling this `prune()`
 * function.
 *
 * For reference, this `typia.misc.prune()` function does not validate the input
 * value type. It just believes that the input value is following the type `T`.
 * Therefore, if you can't ensure the input value type, it would better to call
 * one of below functions instead.
 *
 * - {@link assertPrune}
 * - {@link isPrune}
 * - {@link validatePrune}
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input Target instance to prune
 */
export declare function prune<T extends object>(input: T): void;
/**
 * Prune, erase superfluous properties, with type assertion.
 *
 * `typia.misc.assertPrune()` is a combination function of {@link assert} and
 * {@link prune}. Therefore, it removes all superfluous properties from the
 * `input` object including nested objects, with type assertion.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * throws an {@link TypeGuardError} or custom error generated by _errorFactory_.
 * Otherwise, there's no problem on the `input` value, its all superfluous
 * properties would be removed, including nested objects.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input Target instance to assert and prune
 * @param errorFactory Custom error factory. Default is `TypeGuardError`
 */
export declare function assertPrune<T>(input: T, errorFactory?: undefined | ((props: TypeGuardError.IProps) => Error)): T;
/**
 * Prune, erase superfluous properties, with type assertion.
 *
 * `typia.misc.assertPrune()` is a combination function of {@link assert} and
 * {@link prune}. Therefore, it removes all superfluous properties from the
 * `input` object including nested objects, with type assertion.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * throws an {@link TypeGuardError} or custom error generated by _errorFactory_.
 * Otherwise, there's no problem on the `input` value, its all superfluous
 * properties would be removed, including nested objects.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input Target instance to assert and prune
 * @param errorFactory Custom error factory. Default is `TypeGuardError`
 */
export declare function assertPrune<T>(input: unknown, errorFactory?: undefined | ((props: TypeGuardError.IProps) => Error)): T;
/**
 * Prune, erase superfluous properties, with type checking.
 *
 * `typia.misc.isPrune()` is a combination function of {@link is} and
 * {@link prune}. Therefore, it removes all superfluous properties from the
 * `input` object including nested objects, with type checking.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * returns `false` value. Otherwise, there's no problem on the `input` value, it
 * returns `true` after removing all superfluous properties, including nested
 * objects.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input Target instance to check and prune
 * @returns Whether the parametric value is following the type `T` or not
 */
export declare function isPrune<T>(input: T): input is T;
/**
 * Prune, erase superfluous properties, with type checking.
 *
 * `typia.misc.isPrune()` is a combination function of {@link is} and
 * {@link prune}. Therefore, it removes all superfluous properties from the
 * `input` object including nested objects, with type checking.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * returns `false` value. Otherwise, there's no problem on the `input` value, it
 * returns `true` after removing all superfluous properties, including nested
 * objects.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input Target instance to check and prune
 * @returns Whether the parametric value is following the type `T` or not
 */
export declare function isPrune<T>(input: unknown): input is T;
/**
 * Prune, erase superfluous properties, with type validation.
 *
 * `typia.misc.validatePrune()` is a combination function of {@link validate} and
 * {@link prune}. Therefore, it removes all superfluous properties from the
 * `input` object including nested objects, with type validation.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * returns {@link IValidation.IFailure} value with detailed error reasons.
 * Otherwise, there's no problem on the `input` value, it returns
 * {@link IValidation.ISuccess} value after removing all superfluous properties,
 * including nested objects.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input Target instance to validate and prune
 * @returns Validation result
 */
export declare function validatePrune<T>(input: T): IValidation<T>;
/**
 * Prune, erase superfluous properties, with type validation.
 *
 * `typia.misc.validatePrune()` is a combination function of {@link validate} and
 * {@link prune}. Therefore, it removes all superfluous properties from the
 * `input` object including nested objects, with type validation.
 *
 * In such reason, when `input` value is not matched with the type `T`, it
 * returns {@link IValidation.IFailure} value with detailed error reasons.
 * Otherwise, there's no problem on the `input` value, it returns
 * {@link IValidation.ISuccess} value after removing all superfluous properties,
 * including nested objects.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param input Target instance to validate and prune
 * @returns Validation result
 */
export declare function validatePrune<T>(input: unknown): IValidation<T>;
/**
 * Creates a reusable {@link clone} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @returns Nothing until you configure the generic argument `T`
 * @throws Compile error
 * @danger You must configure the generic argument `T`
 */
export declare function createClone(): never;
/**
 * Creates a reusable {@link clone} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @returns A reusable `clone` function
 */
export declare function createClone<T>(): (input: T) => Resolved<T>;
/**
 * Creates a reusable {@link assertClone} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @param errorFactory Custom error factory. Default is `TypeGuardError`
 * @returns Nothing until you configure the generic argument `T`
 * @throws Compile error
 * @danger You must configure the generic argument `T`
 */
export declare function createAssertClone(errorFactory?: undefined | ((props: TypeGuardError.IProps) => Error)): never;
/**
 * Creates a reusable {@link assertClone} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param errorFactory Custom error factory. Default is `TypeGuardError`
 * @returns A reusable `clone` function
 */
export declare function createAssertClone<T>(errorFactory?: undefined | ((props: TypeGuardError.IProps) => Error)): (input: unknown) => Resolved<T>;
/**
 * Creates a reusable {@link isClone} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @returns Nothing until you configure the generic argument `T`
 * @throws Compile error
 * @danger You must configure the generic argument `T`
 */
export declare function createIsClone(): never;
/**
 * Creates a reusable {@link isClone} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @returns A reusable `clone` function
 */
export declare function createIsClone<T>(): (input: unknown) => Resolved<T> | null;
/**
 * Creates a reusable {@link validateClone} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @returns Nothing until you configure the generic argument `T`
 * @throws Compile error
 * @danger You must configure the generic argument `T`
 */
export declare function createValidateClone(): never;
/**
 * Creates a reusable {@link validateClone} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @returns A reusable `clone` function
 */
export declare function createValidateClone<T>(): (input: unknown) => IValidation<Resolved<T>>;
/**
 * Creates a reusable {@link prune} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @returns Nothing until you configure the generic argument `T`
 * @throws Compile error
 * @danger You must configure the generic argument `T`
 */
export declare function createPrune(): never;
/**
 * Creates a reusable {@link prune} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @returns A reusable `prune` function
 */
export declare function createPrune<T extends object>(): (input: T) => void;
/**
 * Creates a reusable {@link assertPrune} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @param errorFactory Custom error factory. Default is `TypeGuardError`
 * @returns Nothing until you configure the generic argument `T`
 * @throws Compile error
 * @danger You must configure the generic argument `T`
 */
export declare function createAssertPrune(errorFactory?: undefined | ((props: TypeGuardError.IProps) => Error)): never;
/**
 * Creates a reusable {@link assertPrune} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @param errorFactory Custom error factory. Default is `TypeGuardError`
 * @returns A reusable `isPrune` function
 */
export declare function createAssertPrune<T extends object>(errorFactory?: undefined | ((props: TypeGuardError.IProps) => Error)): (input: T) => T;
/**
 * Creates a reusable {@link isPrune} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @returns Nothing until you configure the generic argument `T`
 * @throws Compile error
 * @danger You must configure the generic argument `T`
 */
export declare function createIsPrune(): never;
/**
 * Creates a reusable {@link isPrune} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @returns A reusable `isPrune` function
 */
export declare function createIsPrune<T extends object>(): (input: T) => input is T;
/**
 * Creates a reusable {@link validatePrune} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @returns Nothing until you configure the generic argument `T`
 * @throws Compile error
 * @danger You must configure the generic argument `T`
 */
export declare function createValidatePrune(): never;
/**
 * Creates a reusable {@link validatePrune} function.
 *
 * @author Jeongho Nam - https://github.com/samchon
 * @template T Type of the input value
 * @returns A reusable `validatePrune` function
 */
export declare function createValidatePrune<T extends object>(): (input: T) => IValidation<T>;
