import { LlmSchemaComposer } from '@samchon/openapi/lib/composers/LlmSchemaComposer.mjs';

const _llmApplicationFinalize = (app, options) => {
    app.options = {
        ...LlmSchemaComposer.defaultConfig(app.model),
        separate: options?.separate ?? null,
        validate: options?.validate ?? null,
    };
    if (app.options.separate !== null)
        for (const func of app.functions)
            func.separated = LlmSchemaComposer.separateParameters(app.model)({
                parameters: func.parameters,
                predicate: app.options
                    .separate,
                equals: options?.equals ?? false,
            });
    if (app.options.validate !== null)
        for (const func of app.functions)
            if (typeof app.options.validate?.[func.name] === "function")
                func.validate = app.options.validate[func.name];
};

export { _llmApplicationFinalize };
//# sourceMappingURL=_llmApplicationFinalize.mjs.map
