"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.iterate_metadata_set = void 0;
const MetadataSet_1 = require("../../../schemas/metadata/MetadataSet");
const ArrayUtil_1 = require("../../../utils/ArrayUtil");
const TypeFactory_1 = require("../../TypeFactory");
const explore_metadata_1 = require("./explore_metadata");
const iterate_metadata_set = (props) => {
    const type = props.checker.getApparentType(props.type);
    const name = TypeFactory_1.TypeFactory.getFullName({
        checker: props.checker,
        type: type,
        symbol: type.getSymbol(),
        aliasTypeArguments: false,
    });
    const generic = props.checker.getTypeArguments(type);
    if (name.substring(0, 4) !== "Set<" || (generic === null || generic === void 0 ? void 0 : generic.length) !== 1)
        return false;
    const key = generic[0];
    const value = (0, explore_metadata_1.explore_metadata)(Object.assign(Object.assign({}, props), { type: key, explore: Object.assign(Object.assign({}, props.explore), { escaped: false, aliased: false }), intersected: false }));
    ArrayUtil_1.ArrayUtil.take(props.metadata.sets, (elem) => elem.value.getName() === value.getName(), () => MetadataSet_1.MetadataSet.create({
        value: (0, explore_metadata_1.explore_metadata)(Object.assign(Object.assign({}, props), { type: key, explore: Object.assign(Object.assign({}, props.explore), { escaped: false, aliased: false }), intersected: false })),
        tags: [],
    }));
    return true;
};
exports.iterate_metadata_set = iterate_metadata_set;
//# sourceMappingURL=iterate_metadata_set.js.map