import { MetadataMap } from '../../../schemas/metadata/MetadataMap.mjs';
import { ArrayUtil } from '../../../utils/ArrayUtil.mjs';
import { TypeFactory } from '../../TypeFactory.mjs';
import { explore_metadata } from './explore_metadata.mjs';

const iterate_metadata_map = (props) => {
    const type = props.checker.getApparentType(props.type);
    const name = TypeFactory.getFullName({
        checker: props.checker,
        type,
        symbol: type.getSymbol(),
        aliasTypeArguments: false,
    });
    const generic = props.checker.getTypeArguments(type);
    if (name.substring(0, 4) !== "Map<" || generic?.length !== 2)
        return false;
    const key = generic[0];
    const value = generic[1];
    ArrayUtil.set(props.metadata.maps, MetadataMap.create({
        key: explore_metadata({
            ...props,
            type: key,
            explore: {
                ...props.explore,
                escaped: false,
                aliased: false,
            },
            intersected: false,
        }),
        value: explore_metadata({
            ...props,
            type: value,
            explore: {
                ...props.explore,
                escaped: false,
                aliased: false,
            },
            intersected: false,
        }),
        tags: [],
    }), (elem) => `Map<${elem.key.getName()}, ${elem.value.getName()}>`);
    return true;
};

export { iterate_metadata_map };
//# sourceMappingURL=iterate_metadata_map.mjs.map
