"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.iterate_metadata_map = void 0;
const MetadataMap_1 = require("../../../schemas/metadata/MetadataMap");
const ArrayUtil_1 = require("../../../utils/ArrayUtil");
const TypeFactory_1 = require("../../TypeFactory");
const explore_metadata_1 = require("./explore_metadata");
const iterate_metadata_map = (props) => {
    const type = props.checker.getApparentType(props.type);
    const name = TypeFactory_1.TypeFactory.getFullName({
        checker: props.checker,
        type,
        symbol: type.getSymbol(),
        aliasTypeArguments: false,
    });
    const generic = props.checker.getTypeArguments(type);
    if (name.substring(0, 4) !== "Map<" || (generic === null || generic === void 0 ? void 0 : generic.length) !== 2)
        return false;
    const key = generic[0];
    const value = generic[1];
    ArrayUtil_1.ArrayUtil.set(props.metadata.maps, MetadataMap_1.MetadataMap.create({
        key: (0, explore_metadata_1.explore_metadata)(Object.assign(Object.assign({}, props), { type: key, explore: Object.assign(Object.assign({}, props.explore), { escaped: false, aliased: false }), intersected: false })),
        value: (0, explore_metadata_1.explore_metadata)(Object.assign(Object.assign({}, props), { type: value, explore: Object.assign(Object.assign({}, props.explore), { escaped: false, aliased: false }), intersected: false })),
        tags: [],
    }), (elem) => `Map<${elem.key.getName()}, ${elem.value.getName()}>`);
    return true;
};
exports.iterate_metadata_map = iterate_metadata_map;
//# sourceMappingURL=iterate_metadata_map.js.map