"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.emplace_metadata_object = void 0;
const typescript_1 = __importDefault(require("typescript"));
const MetadataProperty_1 = require("../../../schemas/metadata/MetadataProperty");
const Writable_1 = require("../../../typings/Writable");
const ArrayUtil_1 = require("../../../utils/ArrayUtil");
const CommentFactory_1 = require("../../CommentFactory");
const MetadataHelper_1 = require("./MetadataHelper");
const explore_metadata_1 = require("./explore_metadata");
const iterate_metadata_coalesce_1 = require("./iterate_metadata_coalesce");
const emplace_metadata_object = (props) => {
    var _a, _b;
    // EMPLACE OBJECT
    const [obj, newbie] = props.collection.emplace(props.checker, props.type);
    ArrayUtil_1.ArrayUtil.add(obj.nullables, props.metadata.nullable, (elem) => elem === props.metadata.nullable);
    if (newbie === false)
        return obj;
    // PREPARE ASSETS
    const isClass = props.type.isClass();
    const isProperty = significant(!!props.options.functional);
    const pred = isClass
        ? (node) => {
            const capsuled = node
                .getChildren()
                .some((c) => c
                .getChildren()
                .some((n) => n.kind === typescript_1.default.SyntaxKind.PrivateKeyword ||
                n.kind === typescript_1.default.SyntaxKind.ProtectedKeyword));
            return capsuled === false && isProperty(node);
        }
        : (node) => isProperty(node);
    const insert = (props) => {
        var _a, _b, _c, _d;
        // COMMENTS AND TAGS
        const description = props.symbol
            ? ((_a = CommentFactory_1.CommentFactory.description(props.symbol)) !== null && _a !== void 0 ? _a : null)
            : null;
        const jsDocTags = ((_c = (_b = props.symbol) === null || _b === void 0 ? void 0 : _b.getJsDocTags()) !== null && _c !== void 0 ? _c : []).filter((_d = props.filter) !== null && _d !== void 0 ? _d : (() => true));
        // THE PROPERTY
        const property = MetadataProperty_1.MetadataProperty.create({
            key: props.key,
            value: props.value,
            description,
            jsDocTags,
        });
        obj.properties.push(property);
        return property;
    };
    //----
    // REGULAR PROPERTIES
    //----
    for (const symbol of props.type.getApparentProperties()) {
        // CHECK INTERNAL TAG
        if (((_a = symbol.getJsDocTags(props.checker)) !== null && _a !== void 0 ? _a : []).find((tag) => tag.name === "internal") !== undefined)
            continue;
        // CHECK NODE IS A FORMAL PROPERTY
        const [node, type] = (() => {
            var _a;
            const node = (_a = symbol.getDeclarations()) === null || _a === void 0 ? void 0 : _a[0];
            const type = node
                ? props.checker.getTypeOfSymbolAtLocation(symbol, node)
                : props.checker.getTypeOfPropertyOfType(props.type, symbol.name);
            return [node, type];
        })();
        if ((node && pred(node) === false) || type === undefined)
            continue;
        // GET EXACT TYPE
        const key = MetadataHelper_1.MetadataHelper.literal_to_metadata(symbol.name);
        const value = (0, explore_metadata_1.explore_metadata)(Object.assign(Object.assign({}, props), { type, explore: {
                top: false,
                object: obj,
                property: symbol.name,
                parameter: null,
                nested: null,
                aliased: false,
                escaped: false,
                output: false,
            }, intersected: false }));
        (0, Writable_1.Writable)(value).optional = (symbol.flags & typescript_1.default.SymbolFlags.Optional) !== 0;
        insert({
            key,
            value,
            symbol,
        });
    }
    //----
    // DYNAMIC PROPERTIES
    //----
    for (const index of props.checker.getIndexInfosOfType(props.type)) {
        // GET EXACT TYPE
        const analyzer = (type) => (property) => (0, explore_metadata_1.explore_metadata)(Object.assign(Object.assign({}, props), { type, explore: {
                top: false,
                object: obj,
                property,
                parameter: null,
                nested: null,
                aliased: false,
                escaped: false,
                output: false,
            }, intersected: false }));
        const key = analyzer(index.keyType)(null);
        const value = analyzer(index.type)({});
        if (key.atomics.length +
            key.constants.map((c) => c.values.length).reduce((a, b) => a + b, 0) +
            key.templates.length +
            key.natives.filter((native) => native.name === "Boolean" ||
                native.name === "BigInt" ||
                native.name === "Number" ||
                native.name === "String").length !==
            key.size())
            props.errors.push({
                name: key.getName(),
                explore: {
                    top: false,
                    object: obj,
                    property: "[key]",
                    parameter: null,
                    nested: null,
                    aliased: false,
                    escaped: false,
                    output: false,
                },
                messages: [],
            });
        // INSERT WITH REQUIRED CONFIGURATION
        insert({
            key,
            value,
            symbol: ((_b = index.declaration) === null || _b === void 0 ? void 0 : _b.parent)
                ? props.checker.getSymbolAtLocation(index.declaration.parent)
                : undefined,
            filter: (doc) => doc.name !== "default",
        });
    }
    return obj;
};
exports.emplace_metadata_object = emplace_metadata_object;
const significant = (functional) => functional
    ? (node) => !typescript_1.default.isAccessor(node)
    : (node) => typescript_1.default.isParameter(node) ||
        typescript_1.default.isPropertyDeclaration(node) ||
        typescript_1.default.isPropertyAssignment(node) ||
        typescript_1.default.isPropertySignature(node) ||
        typescript_1.default.isTypeLiteralNode(node) ||
        typescript_1.default.isShorthandPropertyAssignment(node);
const iterate_optional_coalesce = (props) => {
    if (props.type.isUnionOrIntersection())
        props.type.types.forEach((child) => iterate_optional_coalesce({
            metadata: props.metadata,
            type: child,
        }));
    else
        (0, iterate_metadata_coalesce_1.iterate_metadata_coalesce)(props);
};
//# sourceMappingURL=emplace_metadata_object.js.map