(function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
const {
    CryptographyKey,
    Ed25519PublicKey,
    Ed25519SecretKey,
    SodiumError,
    SodiumPlus,
    SodiumPolyfill,
    SodiumUtil,
    X25519PublicKey,
    X25519SecretKey
} = require('./index');

// Load dependencies into window
(async function(){
    window.CryptographyKey = CryptographyKey;
    window.Ed25519PublicKey = Ed25519PublicKey;
    window.Ed25519SecretKey = Ed25519SecretKey;
    window.SodiumError = SodiumError;
    window.SodiumPlus = SodiumPlus;
    window.SodiumPolyfill = SodiumPolyfill;
    window.SodiumUtil = SodiumUtil;
    window.X25519PublicKey = X25519PublicKey;
    window.X25519SecretKey = X25519SecretKey;
    window.sodium = await SodiumPlus.auto();
})();

},{"./index":2}],2:[function(require,module,exports){
module.exports = {
    /**
     * This is only meant to be used for advanced users.
     *
     * A backend object can be passed to the SodiumPlus constructor.
     *
     * @param {string} type
     * @return {Backend}
     * @throws {SodiumError}
     * @throws {Error}
     */
    getBackendObject: (type = '') => {
        if (type === 'SodiumNative') {
            // This one may error out. You should catch it in your code.
            // We won't here. Use the `await SodiumPlus.auto()` API instead!
            return require('./lib/backend/sodiumnative');
        } else if (type === 'LibsodiumWrappers') {
            return require('./lib/backend/libsodium-wrappers');
        } else if (type.length === 0) {
            return require('./lib/backend');
        }

        // Default: Throw a SodiumError
        let SodiumError = require('./lib/sodium-error');
        throw new SodiumError(`Unrecognized backend type: ${type}`);
    },
    CryptographyKey: require('./lib/cryptography-key'),
    Ed25519PublicKey: require('./lib/keytypes/ed25519pk'),
    Ed25519SecretKey: require('./lib/keytypes/ed25519sk'),
    SodiumError: require('./lib/sodium-error'),
    SodiumPlus: require('./lib/sodiumplus'),
    SodiumPolyfill: require('./lib/polyfill'),
    SodiumUtil: require('./lib/util'),
    X25519PublicKey: require('./lib/keytypes/x25519pk'),
    X25519SecretKey: require('./lib/keytypes/x25519sk')
};

},{"./lib/backend":3,"./lib/backend/libsodium-wrappers":4,"./lib/backend/sodiumnative":5,"./lib/cryptography-key":6,"./lib/keytypes/ed25519pk":7,"./lib/keytypes/ed25519sk":8,"./lib/keytypes/x25519pk":9,"./lib/keytypes/x25519sk":10,"./lib/polyfill":11,"./lib/sodium-error":12,"./lib/sodiumplus":13,"./lib/util":14}],3:[function(require,module,exports){
(function (Buffer){
const CryptographyKey = require('./cryptography-key');
/* istanbul ignore if */
if (typeof (Buffer) === 'undefined') {
    let Buffer = require('buffer/').Buffer;
}

module.exports = class Backend {
    constructor() {
        // NOP
        this.backendName = 'UndefinedBackend';
    }

    /**
     * @param {CryptographyKey} sKey
     * @param {CryptographyKey} pKey
     * @return {Promise<CryptographyKey>}
     */
    async crypto_box_keypair_from_secretkey_and_publickey(sKey, pKey) {
        /* istanbul ignore if */
        if (sKey.getLength() !== 32) {
            throw new Error('Secret key must be 32 bytes');
        }
        /* istanbul ignore if */
        if (pKey.getLength() !== 32) {
            throw new Error('Public key must be 32 bytes');
        }
        const keypair = Buffer.alloc(64);
        sKey.getBuffer().copy(keypair, 0, 0, 32);
        pKey.getBuffer().copy(keypair, 32, 0, 32);
        return new CryptographyKey(Buffer.from(keypair));
    }
};

}).call(this,require("buffer").Buffer)
},{"./cryptography-key":6,"buffer":74,"buffer/":17}],4:[function(require,module,exports){
(function (Buffer){
const _sodium = require('libsodium-wrappers');
const Backend = require('../backend');
const CryptographyKey = require('../cryptography-key');
const Polyfill = require('../polyfill');
const Util = require('../util');
const SodiumError = require('../sodium-error');
const toBuffer = require('typedarray-to-buffer');
/* istanbul ignore if */
if (typeof (Buffer) === 'undefined') {
    let Buffer = require('buffer/').Buffer;
}

/* istanbul ignore next */
module.exports = class LibsodiumWrappersBackend extends Backend {
    constructor(lib) {
        super(lib);
        this.sodium = lib;
        this.backendName = 'LibsodiumWrappersBackend';
    }

    static async init() {
        await _sodium.ready;
        return new LibsodiumWrappersBackend(_sodium);
    }

    /**
     *
     * @param {String|Buffer} ciphertext
     * @param {String|Buffer} assocData
     * @param {String|Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_aead_xchacha20poly1305_ietf_decrypt(ciphertext, assocData, nonce, key) {
        return toBuffer(
            this.sodium.crypto_aead_xchacha20poly1305_ietf_decrypt(
                null,
                ciphertext,
                assocData,
                nonce,
                key.getBuffer()
            )
        );
    }

    /**
     *
     * @param {String|Buffer} plaintext
     * @param {String|Buffer} assocData
     * @param {String|Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_aead_xchacha20poly1305_ietf_encrypt(plaintext, assocData, nonce, key) {
        return toBuffer(
            this.sodium.crypto_aead_xchacha20poly1305_ietf_encrypt(
                plaintext,
                assocData,
                null,
                nonce,
                key.getBuffer()
            )
        );
    }

    /**
     * @param {String|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<buffer>}
     */
    async crypto_auth(message, key) {
        return toBuffer(
            this.sodium.crypto_auth(
                message,
                key.getBuffer()
            )
        );
    }

    /**
     * @param {Buffer} mac
     * @param {String|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<boolean>}
     */
    async crypto_auth_verify(mac, message, key) {
        return this.sodium.crypto_auth_verify(
            mac,
            message,
            key.getBuffer()
        );
    }

    /**
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} sk
     * @param {CryptographyKey} pk
     * @return {Promise<Buffer>}
     *
     */
    async crypto_box(plaintext, nonce, sk, pk) {
        return Util.toBuffer(
            await this.sodium.crypto_box_easy(
                await Util.toBuffer(plaintext),
                await Util.toBuffer(nonce),
                pk.getBuffer(),
                sk.getBuffer()
            )
        );
    }

    /**
     * @param {Buffer} ciphertext
     * @param {Buffer} nonce
     * @param {CryptographyKey} sk
     * @param {CryptographyKey} pk
     * @return {Promise<Buffer>}
     */
    async crypto_box_open(ciphertext, nonce, sk, pk) {
        return Util.toBuffer(
            await this.sodium.crypto_box_open_easy(
                await Util.toBuffer(ciphertext),
                await Util.toBuffer(nonce),
                pk.getBuffer(),
                sk.getBuffer()
            )
        );
    }

    /**
     * @param {string|Buffer} plaintext
     * @param {CryptographyKey} pk
     * @return {Promise<Buffer>}
     *
     */
    async crypto_box_seal(plaintext, pk) {
        return Util.toBuffer(
            await this.sodium.crypto_box_seal(
                await Util.toBuffer(plaintext),
                pk.getBuffer()
            )
        );
    }

    /**
     * @param {Buffer} ciphertext
     * @param {CryptographyKey} pk
     * @param {CryptographyKey} sk
     * @return {Promise<Buffer>}
     */
    async crypto_box_seal_open(ciphertext, pk, sk) {
        return Util.toBuffer(
            await this.sodium.crypto_box_seal_open(
                await Util.toBuffer(ciphertext),
                pk.getBuffer(),
                sk.getBuffer()
            )
        );
    }

    /**
     * @return {Promise<CryptographyKey>}
     */
    async crypto_box_keypair() {
        const obj = this.sodium.crypto_box_keypair();
        return new CryptographyKey(
            Buffer.concat([
                await Util.toBuffer(obj.privateKey),
                await Util.toBuffer(obj.publicKey)
            ])
        );
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey|null} key
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash(message, key = null, outputLength = 32) {
        if (key) {
            return Util.toBuffer(
                this.sodium.crypto_generichash(
                    outputLength,
                    await Util.toBuffer(message),
                    key.getBuffer()
                )
            );
        }
        return Util.toBuffer(
            this.sodium.crypto_generichash(
                outputLength,
                await Util.toBuffer(message)
            )
        );
    }

    /**
     * @param {CryptographyKey|null} key
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash_init(key = null, outputLength = 32) {
        if (key) {
            return this.sodium.crypto_generichash_init(key.getBuffer(), outputLength);
        }
        return this.sodium.crypto_generichash_init(null, outputLength);
    }

    /**
     * @param {*} state
     * @param {string|Buffer} message
     * @return {Promise<*>}
     */
    async crypto_generichash_update(state, message) {
        return this.sodium.crypto_generichash_update(state, await Util.toBuffer(message));
    }

    /**
     * @param {*} state
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash_final(state, outputLength = 32) {
        return Util.toBuffer(
            this.sodium.crypto_generichash_final(state, outputLength)
        );
    }

    /**
     * @param {X25519PublicKey} clientPublicKey
     * @param {X25519SecretKey} clientSecretKey
     * @param {X25519PublicKey} serverPublicKey
     * @return {Promise<CryptographyKey[]>}
     */
    async crypto_kx_client_session_keys(clientPublicKey, clientSecretKey, serverPublicKey) {
        const gen = this.sodium.crypto_kx_client_session_keys(
            clientPublicKey.getBuffer(),
            clientSecretKey.getBuffer(),
            serverPublicKey.getBuffer(),
        );
        return [
            new CryptographyKey(await Util.toBuffer(gen.sharedRx)),
            new CryptographyKey(await Util.toBuffer(gen.sharedTx))
        ];
    }

    /**
     * @param {X25519PublicKey} serverPublicKey
     * @param {X25519SecretKey} serverSecretKey
     * @param {X25519PublicKey} clientPublicKey
     * @return {Promise<CryptographyKey[]>}
     */
    async crypto_kx_server_session_keys(serverPublicKey, serverSecretKey, clientPublicKey) {
        const gen = this.sodium.crypto_kx_server_session_keys(
            serverPublicKey.getBuffer(),
            serverSecretKey.getBuffer(),
            clientPublicKey.getBuffer(),
        );
        return [
            new CryptographyKey(await Util.toBuffer(gen.sharedRx)),
            new CryptographyKey(await Util.toBuffer(gen.sharedTx))
        ];
    }

    /**
     * @param {number} length
     * @param {number} subKeyId
     * @param {string|Buffer} context
     * @param {CryptographyKey} key
     * @return {Promise<CryptographyKey>}
     */
    async crypto_kdf_derive_from_key(length, subKeyId, context, key) {
        return new CryptographyKey(
            await Util.toBuffer(
                this.sodium.crypto_kdf_derive_from_key(
                    length,
                    subKeyId | 0,
                    context,
                    key.getBuffer()
                )
            )
        );
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_onetimeauth(message, key) {
        if (typeof this.sodium.crypto_onetimeauth === 'undefined') {
            return Polyfill.crypto_onetimeauth(
                await Util.toBuffer(message),
                key
            );
        }
        return this.sodium.crypto_onetimeauth(
            await Util.toBuffer(message),
            key.getBuffer()
        );
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @param {Buffer} tag
     * @return {Promise<boolean>}
     */
    async crypto_onetimeauth_verify(message, key, tag) {
        if (typeof this.sodium.crypto_onetimeauth_verify === 'undefined') {
            return Polyfill.crypto_onetimeauth_verify(
                await Util.toBuffer(message),
                key,
                tag
            );
        }
        return this.sodium.crypto_onetimeauth_verify(
            tag,
            await Util.toBuffer(message),
            key.getBuffer()
        );
    }

    /**
     * @param {number} length
     * @param {string|Buffer} password
     * @param {Buffer} salt
     * @param {number} opslimit
     * @param {number} memlimit
     * @param {number} algorithm
     * @return {Promise<Buffer>}
     */
    async crypto_pwhash(length, password, salt, opslimit, memlimit, algorithm) {
        return Util.toBuffer(
            this.sodium.crypto_pwhash(
                length,
                await Util.toBuffer(password),
                await Util.toBuffer(salt),
                opslimit,
                memlimit,
                algorithm
            )
        );
    }

    /**
     * @param {string|Buffer} password
     * @param {number} opslimit
     * @param {number} memlimit
     * @return {Promise<string>}
     */
    async crypto_pwhash_str(password, opslimit, memlimit) {
        return (await Util.toBuffer(
            this.sodium.crypto_pwhash_str(
                await Util.toBuffer(password),
                opslimit,
                memlimit
            ))
        ).toString('utf-8');
    }

    /**
     * @param {string|Buffer} password
     * @param {string|Buffer} hash
     * @return {Promise<boolean>}
     */
    async crypto_pwhash_str_verify(password, hash) {
        return this.sodium.crypto_pwhash_str_verify(
            hash.toString('utf-8'),
            await Util.toBuffer(password)
        );
    }

    /**
     * @param {string|Buffer} hash
     * @param {number} opslimit
     * @param {number} memlimit
     * @return {Promise<boolean>}
     */
    async crypto_pwhash_str_needs_rehash(hash, opslimit, memlimit) {
        if (typeof (this.sodium.crypto_pwhash_str_needs_rehash) !== 'function') {
            return await Polyfill.crypto_pwhash_str_needs_rehash(hash, opslimit, memlimit);
        }
        return this.sodium.crypto_pwhash_str_needs_rehash(hash, opslimit, memlimit);
    }

    /**
     * @param {X25519SecretKey} secretKey
     * @param {X25519PublicKey} publicKey
     * @return {Promise<CryptographyKey>}
     */
    async crypto_scalarmult(secretKey, publicKey) {
        return new CryptographyKey(
            await Util.toBuffer(
                this.sodium.crypto_scalarmult(secretKey.getBuffer(), publicKey.getBuffer())
            )
        );
    }

    /**
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_secretbox(plaintext, nonce, key) {
        return Util.toBuffer(
            this.sodium.crypto_secretbox_easy(
                await Util.toBuffer(plaintext),
                nonce,
                key.getBuffer()
            )
        );
    }

    /**
     * @param {Buffer} ciphertext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_secretbox_open(ciphertext, nonce, key) {
        return Util.toBuffer(
            this.sodium.crypto_secretbox_open_easy(
                await Util.toBuffer(ciphertext),
                nonce,
                key.getBuffer()
            )
        );
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_shorthash(message, key) {
        return Util.toBuffer(
            this.sodium.crypto_shorthash(
                await Util.toBuffer(message),
                key.getBuffer()
            )
        );
    }

    /**
     * @param {string|Buffer} message,
     * @param {Ed25519SecretKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign(message, secretKey) {
        return Util.toBuffer(
            this.sodium.crypto_sign(
                await Util.toBuffer(message),
                secretKey.getBuffer()
            )
        );
    }

    /**
     * @param {string|Buffer} message,
     * @param {Ed25519PublicKey} publicKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign_open(message, publicKey) {
        return Util.toBuffer(
            this.sodium.crypto_sign_open(
                message,
                publicKey.getBuffer()
            )
        );
    }
    /**
     * @param {string|Buffer} message,
     * @param {Ed25519SecretKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign_detached(message, secretKey) {
        return Util.toBuffer(
            this.sodium.crypto_sign_detached(
                await Util.toBuffer(message),
                secretKey.getBuffer()
            )
        );
    }

    /**
     * @param {string|Buffer} message,
     * @param {Ed25519PublicKey} publicKey
     * @param {Buffer} signature
     * @return {Promise<Buffer>}
     */
    async crypto_sign_verify_detached(message, publicKey, signature) {
        return this.sodium.crypto_sign_verify_detached(
            signature,
            await Util.toBuffer(message),
            publicKey.getBuffer()
        );
    }

    /**
     * @return {Promise<CryptographyKey>}
     */
    async crypto_sign_keypair() {
        const obj = this.sodium.crypto_sign_keypair();
        return new CryptographyKey(
            Buffer.concat([
                await Util.toBuffer(obj.privateKey),
                await Util.toBuffer(obj.publicKey)
            ])
        );
    }

    /**
     * @param {Buffer} seed
     * @return {Promise<CryptographyKey>}
     */
    async crypto_sign_seed_keypair(seed) {
        const obj = this.sodium.crypto_sign_seed_keypair(seed);
        return new CryptographyKey(
            Buffer.concat([
                await Util.toBuffer(obj.privateKey),
                await Util.toBuffer(obj.publicKey)
            ])
        );
    }

    /**
     * @param {Ed25519SecretKey} sk
     * @return {Promise<Buffer>}
     */
    async crypto_sign_ed25519_sk_to_curve25519(sk) {
        return Util.toBuffer(
            this.sodium.crypto_sign_ed25519_sk_to_curve25519(sk.getBuffer())
        );
    }

    /**
     * @param {Ed25519PublicKey} pk
     * @return {Promise<Buffer>}
     */
    async crypto_sign_ed25519_pk_to_curve25519(pk) {
        return Util.toBuffer(
            this.sodium.crypto_sign_ed25519_pk_to_curve25519(pk.getBuffer())
        );
    }


    /**
     * @param {number} length
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_stream(length, nonce, key) {
        if (typeof (this.sodium.crypto_stream_xor) === 'undefined') {
            return Polyfill.crypto_stream_xor(
                Buffer.alloc(length, 0),
                await Util.toBuffer(nonce),
                key
            );
        }
        return this.sodium.crypto_stream(
            length,
            await Util.toBuffer(nonce),
            key.getBuffer()
        );
    }

    /**
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_stream_xor(plaintext, nonce, key) {
        if (typeof (this.sodium.crypto_stream_xor) === 'undefined') {
            return Polyfill.crypto_stream_xor(
                await Util.toBuffer(plaintext),
                await Util.toBuffer(nonce),
                key
            )
        }
        return this.sodium.crypto_stream_xor(
            await Util.toBuffer(plaintext),
            await Util.toBuffer(nonce),
            key.getBuffer()
        );
    }

    /**
     *
     * @param {CryptographyKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_scalarmult_base(secretKey) {
        return Util.toBuffer(
            this.sodium.crypto_scalarmult_base(secretKey.getBuffer())
        );
    }

    /**
     * @param {CryptographyKey} key
     * @return {Promise<array>} [state, header]
     */
    async crypto_secretstream_xchacha20poly1305_init_push(key) {
        const res = this.sodium.crypto_secretstream_xchacha20poly1305_init_push(key.getBuffer());
        return [res.state, await Util.toBuffer(res.header)];
    }

    /**
     * @param {Buffer} header
     * @param {CryptographyKey} key
     * @return {Promise<*>} Returns the opaque state object
     */
    async crypto_secretstream_xchacha20poly1305_init_pull(header, key) {
        if (header.length !== this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_HEADERBYTES) {
            throw new SodiumError(`Header must be ${this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_HEADERBYTES} bytes long`);
        }
        return this.sodium.crypto_secretstream_xchacha20poly1305_init_pull(header, key.getBuffer());
    }

    /**
     * @param {*} state
     * @param {string|Buffer} message
     * @param {string|Buffer} ad
     * @param {number} tag
     * @return {Promise<Buffer>}
     */
    async crypto_secretstream_xchacha20poly1305_push(state, message, ad = '', tag = 0) {
        return Util.toBuffer(
            this.sodium.crypto_secretstream_xchacha20poly1305_push(
                state,
                await Util.toBuffer(message),
                ad.length > 0 ? (await Util.toBuffer(ad)) : null,
                tag
            )
        );
    }

    /**
     * @param {*} state
     * @param {Buffer} ciphertext
     * @param {string|Buffer} ad
     * @param {number} tag
     * @return {Promise<Buffer>}
     */
    async crypto_secretstream_xchacha20poly1305_pull(state, ciphertext, ad = '', tag = 0) {
        if (ciphertext.length < this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_ABYTES) {
            throw new SodiumError('Invalid ciphertext size');
        }
        const out = this.sodium.crypto_secretstream_xchacha20poly1305_pull(
            state,
            await Util.toBuffer(ciphertext),
            ad.length > 0 ? (await Util.toBuffer(ad)) : null,
            tag
        );
        if (tag !== out.tag) {
            throw new SodiumError(`Invalid tag (Given: ${tag}; Expected: ${out.tag})`);
        }
        return Util.toBuffer(out.message);
    }

    /**
     * @param {*} state
     * @return {Promise<void>}
     */
    async crypto_secretstream_xchacha20poly1305_rekey(state) {
        this.sodium.crypto_secretstream_xchacha20poly1305_rekey(state);
    }

    /**
     * @param {number} number
     * @return {Promise<Buffer>}
     */
    async randombytes_buf(number) {
        return Util.toBuffer(await this.sodium.randombytes_buf(number));
    }

    /**
     * @param {number} upperBound
     * @return {Promise<number>}
     */
    async randombytes_uniform(upperBound) {
        return this.sodium.randombytes_uniform(upperBound);
    }

    /**
     * @param {Uint8Array} val
     * @param {Uint8Array} addv
     * @return {Promise<Buffer>}
     */
    async sodium_add(val, addv) {
        const buf = await Util.cloneBuffer(val);
        this.sodium.add(buf, addv);
        return buf;
    }

    /**
     * @param {Buffer} buf
     * @return {Promise<string>}
     */
    async sodium_bin2hex(buf) {
        return this.sodium.to_hex(buf);
    }

    /**
     * @param {Buffer} b1
     * @param {Buffer} b2
     * @return {Promise<number>}
     */
    async sodium_compare(b1, b2) {
        return this.sodium.compare(b1, b2);
    }

    /**
     * @param {Buffer|string} encoded
     * @return {Promise<Buffer>}
     */
    async sodium_hex2bin(encoded) {
        return Buffer.from(this.sodium.from_hex(encoded));
    }

    /**
     * @param {Buffer} buf
     * @return {Promise<Buffer>}
     */
    async sodium_increment(buf) {
        return this.sodium.increment(buf);
    }

    /**
     * @param {Buffer} buf
     * @param {number} len
     * @return {Promise<Buffer>}
     */
    async sodium_is_zero(buf, len) {
        return this.sodium.is_zero(buf, len);
    }

    /**
     * @param {Buffer} b1
     * @param {Buffer} b2
     * @return {Promise<boolean>}
     */
    async sodium_memcmp(b1, b2) {
        return this.sodium.memcmp(b1, b2);
    }

    /**
     * @param {Buffer} buf
     * @return {Promise<void>}
     */
    async sodium_memzero(buf) {
        this.sodium.memzero(buf);
    }


    /**
     *
     * @param {string|Buffer} buf
     * @param {number} blockSize
     * @return {Promise<Buffer>}
     */
    async sodium_pad(buf, blockSize) {
        return Util.toBuffer(
            this.sodium.pad(await Util.toBuffer(buf), blockSize)
        );
    }

    /**
     *
     * @param {string|Buffer} buf
     * @param {number} blockSize
     * @return {Promise<Buffer>}
     */
    async sodium_unpad(buf, blockSize) {
        return Util.toBuffer(this.sodium.unpad(buf, blockSize));
    }
};

}).call(this,require("buffer").Buffer)
},{"../backend":3,"../cryptography-key":6,"../polyfill":11,"../sodium-error":12,"../util":14,"buffer":74,"buffer/":17,"libsodium-wrappers":20,"typedarray-to-buffer":25}],5:[function(require,module,exports){
(function (Buffer){
let loaded = false;
let _sodium = {};
const Backend = require('../backend');
const CryptographyKey = require('../cryptography-key');
const SodiumError = require('../sodium-error');
const Util = require('../util');
const toBuffer = require('typedarray-to-buffer');
/* istanbul ignore if */
if (typeof (Buffer) === 'undefined') {
    let Buffer = require('buffer/').Buffer;
}

/* istanbul ignore next */
module.exports = class SodiumNativeBackend extends Backend {
    constructor(lib) {
        super(lib);
        this.sodium = lib;
        this.backendName = 'SodiumNativeBackend';
    }

    static async init() {
        if (!loaded) {
            throw new SodiumError('sodium-native not installed');
        }
        return new SodiumNativeBackend(_sodium);
    }

    /**
     *
     * @param {String|Buffer} ciphertext
     * @param {String|Buffer} assocData
     * @param {String|Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_aead_xchacha20poly1305_ietf_decrypt(ciphertext, assocData, nonce, key) {
        const plaintext = Buffer.alloc(ciphertext.length - 16, 0);
        this.sodium.crypto_aead_xchacha20poly1305_ietf_decrypt(
            plaintext,
            null,
            await Util.toBuffer(ciphertext),
            await Util.toBuffer(assocData),
            await Util.toBuffer(nonce),
            key.getBuffer()
        );
        return plaintext;
    }

    /**
     *
     * @param {String|Buffer} plaintext
     * @param {String|Buffer} assocData
     * @param {String|Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_aead_xchacha20poly1305_ietf_encrypt(plaintext, assocData, nonce, key) {
        const ciphertext = Buffer.alloc(plaintext.length + 16, 0);
        this.sodium.crypto_aead_xchacha20poly1305_ietf_encrypt(
            ciphertext,
            await Util.toBuffer(plaintext),
            await Util.toBuffer(assocData),
            null,
            await Util.toBuffer(nonce),
            key.getBuffer()
        );
        return ciphertext;
    }

    /**
     * @param {String|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<buffer>}
     */
    async crypto_auth(message, key) {
        const output = Buffer.alloc(32);
        this.sodium.crypto_auth(
            output,
            await Util.toBuffer(message),
            key.getBuffer()
        );
        return toBuffer(output);
    }

    /**
     * @param {Buffer} mac
     * @param {String|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<boolean>}
     */
    async crypto_auth_verify(mac, message, key) {
        return this.sodium.crypto_auth_verify(
            mac,
            await Util.toBuffer(message),
            key.getBuffer()
        );
    }

    /**
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} sk
     * @param {CryptographyKey} pk
     * @return {Promise<Buffer>}
     *
     */
    async crypto_box(plaintext, nonce, sk, pk) {
        const ciphertext = Buffer.alloc(plaintext.length + 16);
        this.sodium.crypto_box_easy(
            ciphertext,
            await Util.toBuffer(plaintext),
            nonce,
            pk.getBuffer(),
            sk.getBuffer()
        );
        return Util.toBuffer(ciphertext);
    }

    /**
     * @param {Buffer} ciphertext
     * @param {Buffer} nonce
     * @param {CryptographyKey} sk
     * @param {CryptographyKey} pk
     * @return {Promise<Buffer>}
     */
    async crypto_box_open(ciphertext, nonce, sk, pk) {
        const plaintext = Buffer.alloc(ciphertext.length - 16);
        const success = this.sodium.crypto_box_open_easy(
            plaintext,
            ciphertext,
            nonce,
            pk.getBuffer(),
            sk.getBuffer()
        );
        if (!success) {
            throw new SodiumError('Decryption failed');
        }
        return Util.toBuffer(plaintext);
    }

    /**
     * @param {string|Buffer} plaintext
     * @param {CryptographyKey} pk
     * @return {Promise<Buffer>}
     *
     */
    async crypto_box_seal(plaintext, pk) {
        const ciphertext = Buffer.alloc(plaintext.length + 48);
        this.sodium.crypto_box_seal(
            ciphertext,
            await Util.toBuffer(plaintext),
            pk.getBuffer()
        );
        return Util.toBuffer(ciphertext);
    }

    /**
     * @param {Buffer} ciphertext
     * @param {CryptographyKey} pk
     * @param {CryptographyKey} sk
     * @return {Promise<Buffer>}
     */
    async crypto_box_seal_open(ciphertext, pk, sk) {
        const plaintext = Buffer.alloc(ciphertext.length - 48);
        const success = this.sodium.crypto_box_seal_open(
            plaintext,
            await Util.toBuffer(ciphertext),
            pk.getBuffer(),
            sk.getBuffer()
        );
        if (!success) {
            throw new SodiumError('Decryption failed');
        }
        return Util.toBuffer(plaintext);
    }

    /**
     * @return {Promise<CryptographyKey>}
     */
    async crypto_box_keypair() {
        const sK = Buffer.alloc(32, 0);
        const pK = Buffer.alloc(32, 0);
        this.sodium.crypto_box_keypair(sK, pK);
        return new CryptographyKey(
            Buffer.concat([pK, sK])
        );
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey|null} key
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash(message, key = null, outputLength = 32) {
        const hash = Buffer.alloc(outputLength);
        if (key) {
            this.sodium.crypto_generichash(hash, await Util.toBuffer(message), key.getBuffer());
        } else {
            this.sodium.crypto_generichash(hash, await Util.toBuffer(message));
        }
        return hash;
    }

    /**
     * @param {CryptographyKey|null} key
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash_init(key = null, outputLength = 32) {
        const state = Buffer.alloc(this.CRYPTO_GENERICHASH_STATEBYTES);
        if (key) {
            this.sodium.crypto_generichash_init(state, key.getBuffer(), outputLength);
        } else {
            this.sodium.crypto_generichash_init(state, null, outputLength);
        }
        return state;
    }

    /**
     * @param {*} state
     * @param {string|Buffer} message
     * @return {Promise<*>}
     */
    async crypto_generichash_update(state, message) {
        this.sodium.crypto_generichash_update(state, await Util.toBuffer(message));
        return state;
    }

    /**
     * @param {*} state
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash_final(state, outputLength = 32) {
        const output = Buffer.alloc(outputLength);
        this.sodium.crypto_generichash_final(state, output);
        return output;
    }

    /**
     * @param {number} length
     * @param {number} subKeyId
     * @param {string|Buffer} context
     * @param {CryptographyKey} key
     * @return {Promise<CryptographyKey>}
     */
    async crypto_kdf_derive_from_key(length, subKeyId, context, key) {
        const subkey = Buffer.alloc(length, 0);
        this.sodium.crypto_kdf_derive_from_key(
            subkey,
            subKeyId | 0,
            await Util.toBuffer(context),
            key.getBuffer()
        );
        return new CryptographyKey(subkey);
    }

    /**
     * @param {X25519PublicKey} clientPublicKey
     * @param {X25519SecretKey} clientSecretKey
     * @param {X25519PublicKey} serverPublicKey
     * @return {Promise<CryptographyKey[]>}
     */
    async crypto_kx_client_session_keys(clientPublicKey, clientSecretKey, serverPublicKey) {
        const rx = Buffer.alloc(this.CRYPTO_KX_SESSIONKEYBYTES);
        const tx = Buffer.alloc(this.CRYPTO_KX_SESSIONKEYBYTES);
        this.sodium.crypto_kx_client_session_keys(
            rx,
            tx,
            clientPublicKey.getBuffer(),
            clientSecretKey.getBuffer(),
            serverPublicKey.getBuffer(),
        );
        return [
            new CryptographyKey(rx),
            new CryptographyKey(tx)
        ];
    }

    /**
     * @param {X25519PublicKey} serverPublicKey
     * @param {X25519SecretKey} serverSecretKey
     * @param {X25519PublicKey} clientPublicKey
     * @return {Promise<CryptographyKey[]>}
     */
    async crypto_kx_server_session_keys(serverPublicKey, serverSecretKey, clientPublicKey) {
        const rx = Buffer.alloc(this.CRYPTO_KX_SESSIONKEYBYTES);
        const tx = Buffer.alloc(this.CRYPTO_KX_SESSIONKEYBYTES);
        this.sodium.crypto_kx_server_session_keys(
            rx,
            tx,
            serverPublicKey.getBuffer(),
            serverSecretKey.getBuffer(),
            clientPublicKey.getBuffer(),
        );
        return [
            new CryptographyKey(rx),
            new CryptographyKey(tx)
        ];
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_onetimeauth(message, key) {
        const output = Buffer.alloc(16);
        this.sodium.crypto_onetimeauth(
            output,
            await Util.toBuffer(message),
            key.getBuffer()
        );
        return output;
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @param {Buffer} tag
     * @return {Promise<boolean>}
     */
    async crypto_onetimeauth_verify(message, key, tag) {
        return this.sodium.crypto_onetimeauth_verify(
            tag,
            await Util.toBuffer(message),
            key.getBuffer()
        );
    }

    /**
     * @param {number} length
     * @param {string|Buffer} password
     * @param {Buffer} salt
     * @param {number} opslimit
     * @param {number} memlimit
     * @param {number} algorithm
     * @return {Promise<Buffer>}
     */
    async crypto_pwhash(length, password, salt, opslimit, memlimit, algorithm) {
        const hashed = Buffer.alloc(length, 0);
        const bufPass = await Util.toBuffer(password);
        const bufSalt = await Util.toBuffer(salt);
        await new Promise((resolve, reject) => {
            this.sodium.crypto_pwhash_async(
                hashed,
                bufPass,
                bufSalt,
                opslimit,
                memlimit,
                algorithm,
                (e, res) => {
                    if (e) return reject(e);
                    return resolve(res);
                }
            );
        });
        return hashed;
    }

    /**
     * @param {string|Buffer} password
     * @param {number} opslimit
     * @param {number} memlimit
     * @return {Promise<string>}
     */
    async crypto_pwhash_str(password, opslimit, memlimit) {
        const hashed = Buffer.alloc(128, 0);
        const bufPass = await Util.toBuffer(password);
        await new Promise((resolve, reject) => {
            this.sodium.crypto_pwhash_str_async(
                hashed,
                bufPass,
                opslimit,
                memlimit,
                (e, res) => {
                    if (e) return reject(e);
                    return resolve(res);
                }
            );
        });
        return hashed.toString();

    }

    /**
     * @param {string|Buffer} password
     * @param {string|Buffer} hash
     * @return {Promise<boolean>}
     */
    async crypto_pwhash_str_verify(password, hash) {
        const allocated = Buffer.alloc(128, 0);
        (await Util.toBuffer(hash)).copy(allocated, 0, 0);
        const bufPass = await Util.toBuffer(password);
        return new Promise((resolve, reject) => {
            this.sodium.crypto_pwhash_str_verify_async(
                allocated,
                bufPass,
                (e, res) => {
                    if (e) return reject(e);
                    return resolve(res);
                }
            );
        });
    }

    /**
     * @param {string|Buffer} hash
     * @param {number} opslimit
     * @param {number} memlimit
     * @return {Promise<boolean>}
     */
    async crypto_pwhash_str_needs_rehash(hash, opslimit, memlimit) {
        const allocated = Buffer.alloc(128, 0);
        (await Util.toBuffer(hash)).copy(allocated, 0, 0);
        return this.sodium.crypto_pwhash_str_needs_rehash(
            allocated,
            opslimit,
            memlimit
        );
    }

    /**
     * @param {X25519SecretKey} secretKey
     * @param {X25519PublicKey} publicKey
     * @return {Promise<CryptographyKey>}
     */
    async crypto_scalarmult(secretKey, publicKey) {
        const shared = Buffer.alloc(32);
        this.sodium.crypto_scalarmult(shared, secretKey.getBuffer(), publicKey.getBuffer());
        return new CryptographyKey(
            await Util.toBuffer(shared)
        );
    }

    /**
     *
     * @param {CryptographyKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_scalarmult_base(secretKey) {
        const buf = Buffer.alloc(32);
        this.sodium.crypto_scalarmult_base(buf, secretKey.getBuffer());
        return buf;
    }


    /**
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_secretbox(plaintext, nonce, key) {
        const encrypted = Buffer.alloc(plaintext.length + 16);
        this.sodium.crypto_secretbox_easy(
            encrypted,
            await Util.toBuffer(plaintext),
            nonce,
            key.getBuffer()
        );
        return encrypted;
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_shorthash(message, key) {
        const output = Buffer.alloc(8);
        this.sodium.crypto_shorthash(
            output,
            await Util.toBuffer(message),
            key.getBuffer()
        );
        return output;
    }

    /**
     * @param {Buffer} ciphertext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_secretbox_open(ciphertext, nonce, key) {
        const decrypted = Buffer.alloc(ciphertext.length - 16);
        if (!this.sodium.crypto_secretbox_open_easy(
            decrypted,
            ciphertext,
            nonce,
            key.getBuffer()
        )) {
            throw new SodiumError('Decryption failure');
        }
        return decrypted;
    }

    /**
     * @param {CryptographyKey} key
     * @return {Promise<array>} [state, header]
     */
    async crypto_secretstream_xchacha20poly1305_init_push(key) {
        const state = Buffer.alloc(this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_STATEBYTES);
        const header = Buffer.alloc(this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_HEADERBYTES);
        this.sodium.randombytes_buf(header);
        this.sodium.crypto_secretstream_xchacha20poly1305_init_push(state, header, key.getBuffer());
        return [state, header];
    }

    /**
     * @param {Buffer} header
     * @param {CryptographyKey} key
     * @return {Promise<*>} Returns the opaque state object
     */
    async crypto_secretstream_xchacha20poly1305_init_pull(header, key) {
        if (header.length !== this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_HEADERBYTES) {
            throw new SodiumError(`Header must be ${this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_HEADERBYTES} bytes long`);
        }
        const state = Buffer.alloc(this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_STATEBYTES);
        this.sodium.crypto_secretstream_xchacha20poly1305_init_pull(state, header, key.getBuffer());
        return state;
    }

    /**
     * @param {*} state
     * @param {string|Buffer} message
     * @param {string|Buffer} ad
     * @param {number} tag
     * @return {Promise<Buffer>}
     */
    async crypto_secretstream_xchacha20poly1305_push(state, message, ad = '', tag = 0) {
        const ciphertext = Buffer.alloc(message.length + this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_ABYTES);
        this.sodium.crypto_secretstream_xchacha20poly1305_push(
            state,
            ciphertext,
            await Util.toBuffer(message),
            ad.length > 0 ? (await Util.toBuffer(ad)) : null,
            Buffer.from([tag])
        );
        return ciphertext;
    }

    /**
     * @param {*} state
     * @param {Buffer} ciphertext
     * @param {string|Buffer} ad
     * @param {number} tag
     * @return {Promise<Buffer>}
     */
    async crypto_secretstream_xchacha20poly1305_pull(state, ciphertext, ad = '', tag = 0) {
        if (ciphertext.length < this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_ABYTES) {
            throw new SodiumError('Invalid ciphertext size');
        }
        const plaintext = Buffer.alloc(ciphertext.length - this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_ABYTES);
        this.sodium.crypto_secretstream_xchacha20poly1305_pull(
            state,
            plaintext,
            Buffer.from([tag]),
            ciphertext,
            ad.length > 0 ? (await Util.toBuffer(ad)) : null
        );
        return plaintext;
    }

    /**
     * @param {*} state
     * @return {Promise<void>}
     */
    async crypto_secretstream_xchacha20poly1305_rekey(state) {
        this.sodium.crypto_secretstream_xchacha20poly1305_rekey(state);
    }

    /**
     * @param {string|Buffer} message,
     * @param {Ed25519SecretKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign(message, secretKey) {
        const signed = Buffer.alloc(message.length + 64);
        this.sodium.crypto_sign(signed, await Util.toBuffer(message), secretKey.getBuffer());
        return signed;
    }

    /**
     * @param {Buffer} signedMessage,
     * @param {Ed25519PublicKey} publicKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign_open(signedMessage, publicKey) {
        const original = Buffer.alloc(signedMessage.length - 64);
        this.sodium.crypto_sign_open(original, await Util.toBuffer(signedMessage), publicKey.getBuffer());
        return original;
    }

    /**
     * @param {string|Buffer} message,
     * @param {Ed25519SecretKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign_detached(message, secretKey) {
        const signature = Buffer.alloc(64);
        this.sodium.crypto_sign_detached(signature, await Util.toBuffer(message), secretKey.getBuffer());
        return signature;
    }

    /**
     * @param {string|Buffer} message,
     * @param {Ed25519PublicKey} publicKey
     * @param {Buffer} signature
     * @return {Promise<Buffer>}
     */
    async crypto_sign_verify_detached(message, publicKey, signature) {
        return this.sodium.crypto_sign_verify_detached(
            signature,
            await Util.toBuffer(message),
            publicKey.getBuffer()
        );
    }

    /**
     * @return {Promise<CryptographyKey>}
     */
    async crypto_sign_keypair() {
        const sK = Buffer.alloc(64, 0);
        const pK = Buffer.alloc(32, 0);
        this.sodium.crypto_sign_keypair(pK, sK);
        return new CryptographyKey(
            Buffer.concat([sK, pK])
        );
    }

    /**
     * @param {Buffer} seed
     * @return {Promise<CryptographyKey>}
     */
    async crypto_sign_seed_keypair(seed) {
        const sK = Buffer.alloc(64, 0);
        const pK = Buffer.alloc(32, 0);
        this.sodium.crypto_sign_seed_keypair(pK, sK, seed);
        return new CryptographyKey(
            Buffer.concat([sK, pK])
        );
    }

    /**
     * @param {Ed25519SecretKey} sk
     * @return {Promise<Buffer>}
     */
    async crypto_sign_ed25519_sk_to_curve25519(sk) {
        const xsk = Buffer.alloc(32);
        this.sodium.crypto_sign_ed25519_sk_to_curve25519(xsk, sk.getBuffer());
        return xsk;
    }

    /**
     * @param {Ed25519PublicKey} pk
     * @return {Promise<Buffer>}
     */
    async crypto_sign_ed25519_pk_to_curve25519(pk) {
        const xpk = Buffer.alloc(32);
        this.sodium.crypto_sign_ed25519_pk_to_curve25519(xpk, pk.getBuffer());
        return xpk;
    }

    /**
     * @param {number} length
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_stream(length, nonce, key) {
        const output = Buffer.alloc(length);
        this.sodium.crypto_stream(
            output,
            await Util.toBuffer(nonce),
            key.getBuffer()
        );
        return output;
    }

    /**
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_stream_xor(plaintext, nonce, key) {
        const output = Buffer.alloc(plaintext.length);
        this.sodium.crypto_stream_xor(
            output,
            await Util.toBuffer(plaintext),
            await Util.toBuffer(nonce),
            key.getBuffer()
        );
        return output;
    }

    /**
     * @param {number} number
     * @return {Promise<Buffer>}
     */
    async randombytes_buf(number) {
        let buf = Buffer.alloc(number);
        this.sodium.randombytes_buf(buf);
        return buf;
    }

    /**
     * @param {number} upperBound
     * @return {Promise<number>}
     */
    async randombytes_uniform(upperBound) {
        return this.sodium.randombytes_uniform(upperBound);
    }

    /**
     * @param {Uint8Array} val
     * @param {Uint8Array} addv
     * @return {Promise<Buffer>}
     */
    async sodium_add(val, addv) {
        const buf = await Util.cloneBuffer(val);
        this.sodium.sodium_add(buf, addv);
        return buf;
    }

    /**
     * @param {Buffer} input
     * @return {Promise<string>}
     */
    async sodium_bin2hex(input) {
        let str = "", b, c, x;
        for (let i = 0; i < input.length; i++) {
            c = input[i] & 0xf;
            b = input[i] >>> 4;
            x =
                ((87 + c + (((c - 10) >> 8) & ~38)) << 8) |
                (87 + b + (((b - 10) >> 8) & ~38));
            str += String.fromCharCode(x & 0xff) + String.fromCharCode(x >>> 8);
        }
        return str;
    }

    /**
     * @param {Buffer} b1
     * @param {Buffer} b2
     * @return {Promise<number>}
     */
    async sodium_compare(b1, b2) {
        return this.sodium.sodium_compare(b1, b2);
    }

    /**
     * @param {Buffer|string} hex
     * @param {string|null} ignore
     * @return {Promise<Buffer>}
     */
    async sodium_hex2bin(hex, ignore = null) {
        let bin_pos = 0,
            hex_pos = 0,
            c = 0,
            c_acc = 0,
            c_alpha0 = 0,
            c_alpha = 0,
            c_num0 = 0,
            c_num = 0,
            c_val = 0,
            state = 0;
        const bin = Buffer.alloc(hex.length >> 1, 0);

        while (hex_pos < hex.length) {
            c = hex.charCodeAt(hex_pos);
            c_num = c ^ 48;
            c_num0 = (c_num - 10) >> 8;
            c_alpha = (c & ~32) - 55;
            c_alpha0 = ((c_alpha - 10) ^ (c_alpha - 16)) >> 8;
            if ((c_num0 | c_alpha0) === 0) {
                if (ignore && state === 0 && ignore.indexOf(c) >= 0) {
                    hex_pos++;
                    continue;
                }
                break;
            }
            c_val = (c_num0 & c_num) | (c_alpha0 & c_alpha);
            if (state === 0) {
                c_acc = c_val * 16;
            } else {
                bin[bin_pos++] = c_acc | c_val;
            }
            state = ~state;
            hex_pos++;
        }
        return bin;
    }

    /**
     * @param {Buffer} buf
     * @return {Promise<Buffer>}
     */
    async sodium_increment(buf) {
        return this.sodium.sodium_increment(buf);
    }

    /**
     * @param {Buffer} buf
     * @param {number} len
     * @return {Promise<Buffer>}
     */
    async sodium_is_zero(buf, len) {
        return this.sodium.sodium_is_zero(buf, len);
    }

    /**
     * @param {Buffer} b1
     * @param {Buffer} b2
     * @return {Promise<boolean>}
     */
    async sodium_memcmp(b1, b2) {
        return this.sodium.sodium_memcmp(b1, b2);
    }

    /**
     * @param {Buffer} buf
     * @return {Promise<void>}
     */
    async sodium_memzero(buf) {
        this.sodium.sodium_memzero(buf);
    }

    /**
     * @param {string|Buffer} buf
     * @param {number} blockSize
     * @return {Promise<Buffer>}
     */
    async sodium_pad(buf, blockSize) {
        buf = await Util.toBuffer(buf);
        let length = buf.length + (buf.length % blockSize);
        if (length < blockSize) {
            length += blockSize;
        }
        const padded = Buffer.alloc(length + 100);
        buf.copy(padded, 0, 0);
        const sliceto = this.sodium.sodium_pad(padded, buf.length, blockSize);
        return padded.slice(0, sliceto);
    }

    /**
     *
     * @param {string|Buffer} buf
     * @param {number} blockSize
     * @return {Promise<Buffer>}
     */
    async sodium_unpad(buf, blockSize) {
        const outlen = this.sodium.sodium_unpad(buf, buf.length, blockSize);
        return buf.slice(0, outlen);
    }
};

}).call(this,require("buffer").Buffer)
},{"../backend":3,"../cryptography-key":6,"../sodium-error":12,"../util":14,"buffer":74,"buffer/":17,"typedarray-to-buffer":25}],6:[function(require,module,exports){
(function (Buffer){
"use strict";

/* istanbul ignore if */
if (typeof (Buffer) === 'undefined') {
    let Buffer = require('buffer/').Buffer;
}
module.exports = class CryptographyKey {
    /**
     * Note: We use Object.defineProperty() to hide the buffer inside of the
     * CryptographyKey object to prevent accidental leaks.
     *
     * @param {Buffer} buf
     */
    constructor(buf) {
        if (!Buffer.isBuffer(buf)) {
            throw new TypeError('Argument 1 must be an instance of Buffer.');
        }
        Object.defineProperty(this, 'buffer', {
            enumerable: false,
            value: buf.slice()
        });
    }

    /**
     * @return {CryptographyKey}
     */
    static from() {
        return new CryptographyKey(Buffer.from(...arguments));
    }

    /**
     * @return {boolean}
     */
    isEd25519Key() {
        return false;
    }

    /**
     * @return {boolean}
     */
    isX25519Key() {
        return false;
    }

    /**
     * @return {boolean}
     */
    isPublicKey() {
        return false;
    }

    /**
     * @return {Number}
     */
    getLength() {
        return this.buffer.length;
    }

    /**
     * @return {Buffer}
     */
    getBuffer() {
        return this.buffer;
    }

    /**
     * @param {string} encoding
     */
    toString(encoding = 'utf-8') {
        /* istanbul ignore if */
        return this.getBuffer().toString(encoding);
    }

    /**
     * @return {Buffer}
     */
    slice() {
        return this.buffer.slice(...arguments);
    }
};

}).call(this,require("buffer").Buffer)
},{"buffer":74,"buffer/":17}],7:[function(require,module,exports){
(function (Buffer){
const CryptographyKey = require('../cryptography-key');

class Ed25519PublicKey extends CryptographyKey {
    constructor(buf) {
        if (buf.length !== 32) {
            throw new Error('Ed25519 public keys must be 32 bytes long');
        }
        super(buf);
        this.keyType = 'ed25519';
        this.publicKey = true;
    }
    /**
     * @return {Ed25519PublicKey}
     */
    static from() {
        return new Ed25519PublicKey(Buffer.from(...arguments));
    }

    isEd25519Key() {
        return true;
    }

    isPublicKey() {
        return true;
    }
}

module.exports = Ed25519PublicKey;

}).call(this,require("buffer").Buffer)
},{"../cryptography-key":6,"buffer":74}],8:[function(require,module,exports){
(function (Buffer){
const CryptographyKey = require('../cryptography-key');

class Ed25519SecretKey extends CryptographyKey {
    constructor(buf) {
        if (buf.length !== 64) {
            throw new Error('Ed25519 secret keys must be 64 bytes long');
        }
        super(buf);
        this.keyType = 'ed25519';
        this.publicKey = false;
    }

    /**
     * @return {Ed25519SecretKey}
     */
    static from() {
        return new Ed25519SecretKey(Buffer.from(...arguments));
    }

    isEd25519Key() {
        return true;
    }

    isPublicKey() {
        return false;
    }
}

module.exports = Ed25519SecretKey;
}).call(this,require("buffer").Buffer)
},{"../cryptography-key":6,"buffer":74}],9:[function(require,module,exports){
(function (Buffer){
const CryptographyKey = require('../cryptography-key');

class X25519PublicKey extends CryptographyKey {
    constructor(buf) {
        if (buf.length !== 32) {
            throw new Error('X25519 public keys must be 32 bytes long');
        }
        super(buf);
        this.keyType = 'x25519';
        this.publicKey = true;
    }

    /**
     * @return {X25519PublicKey}
     */
    static from() {
        return new X25519PublicKey(Buffer.from(...arguments));
    }

    isX25519Key() {
        return true;
    }

    isPublicKey() {
        return true;
    }
}

module.exports = X25519PublicKey;

}).call(this,require("buffer").Buffer)
},{"../cryptography-key":6,"buffer":74}],10:[function(require,module,exports){
(function (Buffer){
const CryptographyKey = require('../cryptography-key');

class X25519SecretKey extends CryptographyKey {
    constructor(buf) {
        if (buf.length !== 32) {
            throw new Error('X25519 secret keys must be 32 bytes long');
        }
        super(buf);
        this.keyType = 'x25519';
        this.publicKey = false;
    }

    /**
     * @return {X25519SecretKey}
     */
    static from() {
        return new X25519SecretKey(Buffer.from(...arguments));
    }

    isX25519Key() {
        return true;
    }

    isPublicKey() {
        return false;
    }
}

module.exports = X25519SecretKey;

}).call(this,require("buffer").Buffer)
},{"../cryptography-key":6,"buffer":74}],11:[function(require,module,exports){
(function (Buffer){
"use strict";
const crypto = require('crypto');
const Poly1305 = require('poly1305-js');
const Util = require('./util');
const XSalsa20 = require('xsalsa20');

/* istanbul ignore if */
if (typeof (Buffer) === 'undefined') {
    let Buffer = require('buffer/').Buffer;
}

module.exports = class SodiumPolyfill {

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    static async crypto_onetimeauth(message, key) {
        return Poly1305.onetimeauth(
            await Util.toBuffer(message),
            key.getBuffer()
        );
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @param {Buffer} tag
     * @return {Promise<boolean>}
     */
    static async crypto_onetimeauth_verify(message, key, tag) {
        return Poly1305.onetimeauth_verify(
            await Util.toBuffer(message),
            key.getBuffer(),
            await Util.toBuffer(tag)
        );
    }

    /**
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    static async crypto_stream_xor(plaintext, nonce, key) {
        const stream = XSalsa20(nonce, key.getBuffer());
        const output = stream.update(plaintext);
        stream.finalize();
        return Util.toBuffer(output);
    }

    /**
     * Polyfill crypto_pwhash_str_needs_rehash() for bindings that don't
     * include this (somewhat new) helper function.
     *
     * @param {string|Buffer} hash
     * @param {number} opslimit
     * @param {number} memlimit
     * @return {Promise<boolean>}
     */
    static async crypto_pwhash_str_needs_rehash(hash, opslimit, memlimit) {
        const pwhash = (await Util.toBuffer(hash)).toString('utf-8');
        const pieces = pwhash.split('$');
        const expect = 'm=' + (memlimit >> 10) + ',t=' + opslimit + ',p=1';
        if (expect.length !== pieces[3].length) {
            return true;
        }
        return !crypto.timingSafeEqual(
            await Util.toBuffer(expect),
            await Util.toBuffer(pieces[3])
        );
    }
};

}).call(this,require("buffer").Buffer)
},{"./util":14,"buffer":74,"buffer/":17,"crypto":82,"poly1305-js":22,"xsalsa20":26}],12:[function(require,module,exports){
module.exports = class SodiumError extends Error {};

},{}],13:[function(require,module,exports){
(function (Buffer){
const Backend = require('./backend');
const CryptographyKey = require('./cryptography-key');
const Ed25519SecretKey = require('./keytypes/ed25519sk');
const Ed25519PublicKey = require('./keytypes/ed25519pk');
const LibsodiumWrappersBackend = require('./backend/libsodium-wrappers');
const SodiumError = require('./sodium-error');
const X25519PublicKey = require('./keytypes/x25519pk');
const X25519SecretKey = require('./keytypes/x25519sk');
const Util = require('./util');

/* istanbul ignore if */
if (typeof (Buffer) === 'undefined') {
    let Buffer = require('buffer/').Buffer;
}

class SodiumPlus {
    constructor(backend) {
        /* istanbul ignore if */
        if (!(backend instanceof Backend)) {
            throw new TypeError('Backend object must implement the backend function');
        }
        this.backend = backend;
        Util.populateConstants(this);
    }

    /**
     * Returns the name of the current active backend.
     * This method is NOT async.
     *
     * @return {string}
     */
    getBackendName() {
        return this.backend.backendName;
    }

    /**
     * Is this powered by sodium-native?
     * This method is NOT async.
     *
     * @return {boolean}
     */
    isSodiumNative() {
        return false;
    }

    /**
     * Is this powered by libsodium-wrappers?
     * This method is NOT async.
     *
     * @return {boolean}
     */
    isLibsodiumWrappers() {
        return (this.backend instanceof LibsodiumWrappersBackend);
    }

    /**
     * Automatically select a backend.
     *
     * @return {Promise<SodiumPlus>}
     */
    static async auto() {
        let backend = await LibsodiumWrappersBackend.init();
        Util.populateConstants(backend);
        return new SodiumPlus(backend);
    }

    /**
     * If our backend isn't defined, it will trigger an autoload.
     *
     * Mostly used internally. `await SodiumPlus.auto()` provides the same
     * exact guarantee as this method.
     *
     * @return {Promise<void>}
     */
    async ensureLoaded() {
        /* istanbul ignore if */
        if (typeof (this.backend) === 'undefined') {
            try {
                await SodiumPlus.auto();
            } catch (e) {
                this.backend = await LibsodiumWrappersBackend.init();
            }
        }
    }

    /**
     * Decrypt a message (and optional associated data) with XChaCha20-Poly1305
     *
     * @param {String|Buffer} ciphertext
     * @param {String|Buffer} nonce
     * @param {CryptographyKey} key
     * @param {String|Buffer} assocData
     * @return {Promise<Buffer>}
     * @throws {SodiumError}
     */
    async crypto_aead_xchacha20poly1305_ietf_decrypt(ciphertext, nonce, key, assocData = '') {
        await this.ensureLoaded();
        if (nonce.length !== 24) {
            throw new SodiumError('Argument 2 must be 24 bytes');
        }
        if (!(key instanceof CryptographyKey)) {
            throw new TypeError('Argument 3 must be an instance of CryptographyKey');
        }
        return await this.backend.crypto_aead_xchacha20poly1305_ietf_decrypt(
            await Util.toBuffer(ciphertext),
            assocData.length > 0 ? await Util.toBuffer(assocData) : null,
            await Util.toBuffer(nonce),
            key
        );
    }

    /**
     * Encrypt a message (and optional associated data) with XChaCha20-Poly1305.
     *
     * Throws a SodiumError if an invalid ciphertext/AAD is provided for this
     * nonce and key.
     *
     * @param {String|Buffer} plaintext
     * @param {String|Buffer} nonce
     * @param {CryptographyKey} key
     * @param {String|Buffer} assocData
     * @return {Promise<Buffer>}
     * @throws {SodiumError}
     */
    async crypto_aead_xchacha20poly1305_ietf_encrypt(plaintext, nonce, key, assocData = '') {
        await this.ensureLoaded();
        if (nonce.length !== 24) {
            throw new SodiumError('Argument 2 must be 24 bytes');
        }
        if (!(key instanceof CryptographyKey)) {
            throw new TypeError('Argument 3 must be an instance of CryptographyKey');
        }

        return await this.backend.crypto_aead_xchacha20poly1305_ietf_encrypt(
            await Util.toBuffer(plaintext),
            assocData.length > 0 ? await Util.toBuffer(assocData) : null,
            await Util.toBuffer(nonce),
            key
        );
    }

    /**
     * Generate an XChaCha20-Poly1305 key.
     *
     * @return {Promise<CryptographyKey>}
     */
    async crypto_aead_xchacha20poly1305_ietf_keygen() {
        return new CryptographyKey(await this.backend.randombytes_buf(32));
    }

    /**
     * Get an authenticator for a message for a given key.
     *
     * Algorithm: HMAC-SHA512 truncated to 32 bytes.
     *
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_auth(message, key) {
        await this.ensureLoaded();
        if (!(key instanceof CryptographyKey)) {
            throw new TypeError('Argument 2 must be an instance of CryptographyKey');
        }
        await this.ensureLoaded();
        return await this.backend.crypto_auth(
            await Util.toBuffer(message),
            key
        );
    }

    /**
     * @return {Promise<CryptographyKey>}
     */
    async crypto_auth_keygen() {
        return new CryptographyKey(await this.backend.randombytes_buf(32));
    }

    /**
     * Verify an authenticator for a message for a given key.
     *
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @param {Buffer} mac
     * @return {Promise<boolean>}
     */
    async crypto_auth_verify(message, key, mac) {
        await this.ensureLoaded();
        if (!(key instanceof CryptographyKey)) {
            throw new TypeError('Argument 2 must be an instance of CryptographyKey');
        }
        await this.ensureLoaded();
        return await this.backend.crypto_auth_verify(
            await Util.toBuffer(mac),
            await Util.toBuffer(message),
            key
        );
    }

    /**
     * Public-key authenticated encryption.
     *
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {X25519SecretKey} myPrivateKey
     * @param {X25519PublicKey} theirPublicKey
     * @return {Promise<Buffer>}
     */
    async crypto_box(plaintext, nonce, myPrivateKey, theirPublicKey) {
        await this.ensureLoaded();
        if (!(myPrivateKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 3 must be an instance of X25519SecretKey');
        }
        if (!(theirPublicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 4 must be an instance of X25519PublicKey');
        }
        nonce = await Util.toBuffer(nonce);
        if (nonce.length !== 24) {
            throw new SodiumError('Nonce must be a buffer of exactly 24 bytes');
        }
        return this.backend.crypto_box(
            await Util.toBuffer(plaintext),
            await Util.toBuffer(nonce),
            myPrivateKey,
            theirPublicKey
        );
    }

    /**
     * Public-key authenticated decryption.
     *
     * @param {Buffer} ciphertext
     * @param {Buffer} nonce
     * @param {X25519SecretKey} myPrivateKey
     * @param {X25519PublicKey} theirPublicKey
     * @return {Promise<Buffer>}
     */
    async crypto_box_open(ciphertext, nonce, myPrivateKey, theirPublicKey) {
        await this.ensureLoaded();
        if (!(myPrivateKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 3 must be an instance of X25519SecretKey');
        }
        if (!(theirPublicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 4 must be an instance of X25519PublicKey');
        }
        ciphertext = await Util.toBuffer(ciphertext);
        if (ciphertext.length < 16) {
            throw new SodiumError('Ciphertext must be a buffer of at least 16 bytes');
        }
        nonce = await Util.toBuffer(nonce);
        if (nonce.length !== 24) {
            throw new SodiumError('Nonce must be a buffer of exactly 24 bytes');
        }
        return this.backend.crypto_box_open(
            ciphertext,
            nonce,
            myPrivateKey,
            theirPublicKey
        );
    }

    /**
     * @return {Promise<CryptographyKey>}
     */
    async crypto_box_keypair() {
        await this.ensureLoaded();
        return this.backend.crypto_box_keypair();
    }

    /**
     * Combine two X25519 keys (secret, public) into a keypair object.
     *
     * @param {X25519SecretKey} sKey
     * @param {X25519PublicKey} pKey
     * @return {Promise<CryptographyKey>}
     */
    async crypto_box_keypair_from_secretkey_and_publickey(sKey, pKey) {
        await this.ensureLoaded();
        if (!(sKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 1 must be an instance of X25519SecretKey');
        }
        if (!(pKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 2 must be an instance of X25519PublicKey');
        }
        return await this.backend.crypto_box_keypair_from_secretkey_and_publickey(sKey, pKey);
    }

    /**
     * Extract the secret key from an X25519 keypair object.
     *
     * @param {CryptographyKey} keypair
     * @return {Promise<X25519SecretKey>}
     */
    async crypto_box_secretkey(keypair) {
        if (keypair.getLength()!== 64) {
            throw new SodiumError('Keypair must be 64 bytes');
        }
        return new X25519SecretKey(
            Buffer.from(keypair.getBuffer().slice(0, 32))
        );
    }

    /**
     * Extract the public key from an X25519 keypair object.
     *
     * @param {CryptographyKey} keypair
     * @return {Promise<X25519PublicKey>}
     */
    async crypto_box_publickey(keypair) {
        if (keypair.getLength() !== 64) {
            throw new SodiumError('Keypair must be 64 bytes');
        }
        return new X25519PublicKey(
            Buffer.from(keypair.getBuffer().slice(32, 64))
        );
    }

    /**
     * Derive the public key from a given X25519 secret key.
     *
     * @param {X25519SecretKey} secretKey
     * @return {Promise<X25519PublicKey>}
     */
    async crypto_box_publickey_from_secretkey(secretKey) {
        await this.ensureLoaded();
        if (!(secretKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 1 must be an instance of X25519SecretKey');
        }
        return new X25519PublicKey(
            await this.backend.crypto_scalarmult_base(secretKey)
        );
    }

    /**
     * Anonymous public-key encryption. (Message integrity is still assured.)
     *
     * @param {string|Buffer} plaintext
     * @param {X25519PublicKey} publicKey
     * @return {Promise<Buffer>}
     */
    async crypto_box_seal(plaintext, publicKey) {
        await this.ensureLoaded();
        if (!(publicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 2 must be an instance of X25519PublicKey');
        }
        return await this.backend.crypto_box_seal(plaintext, publicKey);
    }

    /**
     * Anonymous public-key decryption. (Message integrity is still assured.)
     *
     * @param {Buffer} ciphertext
     * @param {X25519PublicKey} publicKey
     * @param {X25519SecretKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_box_seal_open(ciphertext, publicKey, secretKey) {
        await this.ensureLoaded();
        if (!(publicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 2 must be an instance of X25519PublicKey');
        }
        if (!(secretKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 3 must be an instance of X25519SecretKey');
        }
        return await this.backend.crypto_box_seal_open(
            await Util.toBuffer(ciphertext),
            publicKey,
            secretKey
        );
    }

    /**
     * Generic-purpose cryptographic hash.
     *
     * @param {string|Buffer} message
     * @param {CryptographyKey|null} key
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash(message, key = null, outputLength = 32) {
        await this.ensureLoaded();
        return await this.backend.crypto_generichash(message, key, outputLength);
    }

    /**
     * Initialize a BLAKE2 hash context for stream hashing.
     *
     * @param {CryptographyKey|null} key
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash_init(key = null, outputLength = 32) {
        await this.ensureLoaded();
        return await this.backend.crypto_generichash_init(key, outputLength);
    }


    /**
     * Update the BLAKE2 hash state with a block of data.
     *
     * @param {*} state
     * @param {string|Buffer} message
     * @return {Promise<*>}
     */
    async crypto_generichash_update(state, message) {
        await this.ensureLoaded();
        return await this.backend.crypto_generichash_update(state, message);
    }

    /**
     * Obtain the final BLAKE2 hash output.
     *
     * @param {*} state
     * @param {number} outputLength
     * @return {Promise<Buffer>}
     */
    async crypto_generichash_final(state, outputLength = 32) {
        await this.ensureLoaded();
        return await this.backend.crypto_generichash_final(state, outputLength);
    }

    /**
     * Generate a 256-bit random key for BLAKE2.
     *
     * @return {Promise<CryptographyKey>}
     */
    async crypto_generichash_keygen() {
        return new CryptographyKey(
            await this.backend.randombytes_buf(this.CRYPTO_GENERICHASH_KEYBYTES)
        );
    }

    /**
     * Derive a subkey from a master key.
     *
     * @param {number} length
     * @param {number} subKeyId
     * @param {string|Buffer} context
     * @param {CryptographyKey} key
     * @return {Promise<CryptographyKey>}
     */
    async crypto_kdf_derive_from_key(length, subKeyId, context, key) {
        await this.ensureLoaded();
        if (length < 1) {
            throw new SodiumError('Length must be a positive integer.');
        }
        if (subKeyId < 0) {
            throw new SodiumError('Key ID must be an unsigned integer');
        }
        return await this.backend.crypto_kdf_derive_from_key(
            length,
            subKeyId,
            context,
            key
        );
    }

    /**
     * Generate a 256-bit random key for our KDF.
     *
     * @return {Promise<CryptographyKey>}
     */
    async crypto_kdf_keygen() {
        return new CryptographyKey(
            await this.backend.randombytes_buf(this.CRYPTO_KDF_KEYBYTES)
        );
    }

    /**
     * This is functionally identical to crypto_box_keypair().
     *
     * @return {Promise<CryptographyKey>}
     */
    async crypto_kx_keypair() {
        return this.crypto_box_keypair();
    }

    /**
     * Generate an X25519 keypair from a seed.
     *
     * @param {string|Buffer} seed
     * @return {Promise<CryptographyKey>}
     */
    async crypto_kx_seed_keypair(seed) {
        await this.ensureLoaded();
        const sk = await this.backend.crypto_generichash(seed, null, this.CRYPTO_KX_SECRETKEYBYTES);
        const pk = await this.backend.crypto_scalarmult_base(new CryptographyKey(sk));
        return new CryptographyKey(Buffer.concat([sk, pk]));
    }

    /**
     * Perform a key exchange from the client's perspective.
     *
     * Returns an array of two CryptographyKey objects.
     *
     * The first is meant for data sent from the server to the client (incoming decryption).
     * The second is meant for data sent from the client to the server (outgoing encryption).
     *
     * @param {X25519PublicKey} clientPublicKey
     * @param {X25519SecretKey} clientSecretKey
     * @param {X25519PublicKey} serverPublicKey
     * @return {Promise<CryptographyKey[]>}
     */
    async crypto_kx_client_session_keys(clientPublicKey, clientSecretKey, serverPublicKey) {
        await this.ensureLoaded();
        if (!(clientPublicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 1 must be an instance of X25519PublicKey');
        }
        if (!(clientSecretKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 2 must be an instance of X25519SecretKey');
        }
        if (!(serverPublicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 3 must be an instance of X25519PublicKey');
        }
        return this.backend.crypto_kx_client_session_keys(clientPublicKey, clientSecretKey, serverPublicKey);
    }

    /**
     * Perform a key exchange from the server's perspective.
     *
     * Returns an array of two CryptographyKey objects.
     *
     * The first is meant for data sent from the client to the server (incoming decryption).
     * The second is meant for data sent from the server to the client (outgoing encryption).
     *
     * @param {X25519PublicKey} serverPublicKey
     * @param {X25519SecretKey} serverSecretKey
     * @param {X25519PublicKey} clientPublicKey
     * @return {Promise<CryptographyKey[]>}
     */
    async crypto_kx_server_session_keys(serverPublicKey, serverSecretKey, clientPublicKey) {
        await this.ensureLoaded();
        if (!(serverPublicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 1 must be an instance of X25519PublicKey');
        }
        if (!(serverSecretKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 2 must be an instance of X25519SecretKey');
        }
        if (!(clientPublicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 3 must be an instance of X25519PublicKey');
        }
        return this.backend.crypto_kx_server_session_keys(serverPublicKey, serverSecretKey, clientPublicKey);
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_onetimeauth(message, key) {
        if (!(key instanceof CryptographyKey)) {
            throw new TypeError('Argument 2 must be an instance of CryptographyKey');
        }
        return await this.backend.crypto_onetimeauth(await Util.toBuffer(message), key);
    }

    /**
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @param {Buffer} tag
     * @return {Promise<boolean>}
     */
    async crypto_onetimeauth_verify(message, key, tag) {
        if (!(key instanceof CryptographyKey)) {
            throw new TypeError('Argument 2 must be an instance of CryptographyKey');
        }
        return await this.backend.crypto_onetimeauth_verify(
            await Util.toBuffer(message),
            key,
            await Util.toBuffer(tag)
        );
    }

    /**
     * @return {Promise<CryptographyKey>}
     */
    async crypto_onetimeauth_keygen() {
        return new CryptographyKey(
            await this.backend.randombytes_buf(32)
        );
    }

    /**
     * Derive a cryptography key from a password and salt.
     *
     * @param {number} length
     * @param {string|Buffer} password
     * @param {Buffer} salt
     * @param {number} opslimit
     * @param {number} memlimit
     * @param {number|null} algorithm
     * @return {Promise<CryptographyKey>}
     */
    async crypto_pwhash(length, password, salt, opslimit, memlimit, algorithm = null) {
        await this.ensureLoaded();
        /* istanbul ignore if */
        if (!algorithm) {
            algorithm = this.CRYPTO_PWHASH_ALG_DEFAULT;
        }
        return new CryptographyKey(
            await this.backend.crypto_pwhash(
                length,
                await Util.toBuffer(password),
                await Util.toBuffer(salt),
                opslimit,
                memlimit,
                algorithm
            )
        );
    }

    /**
     * Get a password hash (in a safe-for-storage format)
     *
     * @param {string|Buffer} password
     * @param {number} opslimit
     * @param {number} memlimit
     * @return {Promise<string>}
     */
    async crypto_pwhash_str(password, opslimit, memlimit) {
        await this.ensureLoaded();
        return await this.backend.crypto_pwhash_str(password, opslimit, memlimit);
    }

    /**
     * Verify a password against a known password hash
     *
     * @param {string|Buffer} password
     * @param {string|Buffer} hash
     * @return {Promise<boolean>}
     */
    async crypto_pwhash_str_verify(password, hash) {
        await this.ensureLoaded();
        return await this.backend.crypto_pwhash_str_verify(password, hash);
    }

    /**
     * Does this password need to be rehashed?
     *
     * @param {string|Buffer} hash
     * @param {number} opslimit
     * @param {number} memlimit
     * @return {Promise<boolean>}
     */
    async crypto_pwhash_str_needs_rehash(hash, opslimit, memlimit) {
        await this.ensureLoaded();
        return await this.backend.crypto_pwhash_str_needs_rehash(hash, opslimit, memlimit);
    }

    /**
     * Elliptic Curve Diffie-Hellman key exchange
     *
     * @param {X25519SecretKey} secretKey
     * @param {X25519PublicKey} publicKey
     * @return {Promise<CryptographyKey>}
     */
    async crypto_scalarmult(secretKey, publicKey) {
        await this.ensureLoaded();
        if (!(secretKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 1 must be an instance of X25519SecretKey');
        }
        if (!(publicKey instanceof X25519PublicKey)) {
            throw new TypeError('Argument 2 must be an instance of X25519PublicKey');
        }
        return await this.backend.crypto_scalarmult(secretKey, publicKey);
    }

    /**
     * Generate an X25519PublicKey from an X25519SecretKey
     *
     * @param {X25519SecretKey} secretKey
     * @return {Promise<X25519PublicKey>}
     */
    async crypto_scalarmult_base(secretKey) {
        await this.ensureLoaded();
        if (!(secretKey instanceof X25519SecretKey)) {
            throw new TypeError('Argument 1 must be an instance of X25519SecretKey');
        }
        return new X25519PublicKey(
            await this.backend.crypto_scalarmult_base(secretKey)
        );
    }

    /**
     * Shared-key authenticated encryption
     *
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_secretbox(plaintext, nonce, key) {
        await this.ensureLoaded();
        if (key.isEd25519Key() || key.isX25519Key()) {
            throw new TypeError('Argument 3 must not be an asymmetric key');
        }
        nonce = await Util.toBuffer(nonce);
        if (nonce.length !== 24) {
            throw new SodiumError('Nonce must be a buffer of exactly 24 bytes');
        }

        return await this.backend.crypto_secretbox(
            plaintext,
            nonce,
            key
        );
    }

    /**
     * Shared-key authenticated decryption
     *
     * @param {Buffer} ciphertext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_secretbox_open(ciphertext, nonce, key) {
        await this.ensureLoaded();
        if (key.isEd25519Key() || key.isX25519Key()) {
            throw new TypeError('Argument 3 must not be an asymmetric key');
        }
        ciphertext = await Util.toBuffer(ciphertext);
        if (ciphertext.length < 16) {
            throw new SodiumError('Ciphertext must be a buffer of at least 16 bytes');
        }
        nonce = await Util.toBuffer(nonce);
        if (nonce.length !== 24) {
            throw new SodiumError('Nonce must be a buffer of exactly 24 bytes');
        }
        return await this.backend.crypto_secretbox_open(
            ciphertext,
            nonce,
            key
        );
    }

    /**
     * Generate a key for shared-key authenticated encryption.
     *
     * @return {Promise<CryptographyKey>}
     */
    async crypto_secretbox_keygen() {
        return new CryptographyKey(
            await this.backend.randombytes_buf(this.CRYPTO_SECRETBOX_KEYBYTES)
        );
    }

    /**
     * Internalize the internal state and a random header for stream encryption.
     *
     * @param {CryptographyKey} key
     * @return {Promise<array>}
     */
    async crypto_secretstream_xchacha20poly1305_init_push(key) {
        await this.ensureLoaded();
        if (!(key instanceof CryptographyKey)) {
            throw new TypeError('Key must be an instance of CryptographyKey');
        }
        if (key.getLength() !== 32) {
            throw new SodiumError('crypto_secretstream keys must be 32 bytes long');
        }
        const [state, header] = await this.backend.crypto_secretstream_xchacha20poly1305_init_push(key);
        return Object.freeze({
            header: header,
            push: this.crypto_secretstream_xchacha20poly1305_push.bind(this, state),
            rekey: this.crypto_secretstream_xchacha20poly1305_rekey.bind(this, state)
        });
    }

    /**
     * Initialize the internal state for stream decryption.
     *
     * @param {Buffer} header
     * @param {CryptographyKey} key
     * @return {Promise<*>}
     */
    async crypto_secretstream_xchacha20poly1305_init_pull(key, header) {
        await this.ensureLoaded();
        header = await Util.toBuffer(header);
        if (header.length !== 24) {
            throw new SodiumError('crypto_secretstream headers must be 24 bytes long');
        }
        if (!(key instanceof CryptographyKey)) {
            throw new TypeError('Key must be an instance of CryptographyKey');
        }
        if (key.getLength() !== 32) {
            throw new SodiumError('crypto_secretstream keys must be 32 bytes long');
        }
        const state = await this.backend.crypto_secretstream_xchacha20poly1305_init_pull(header, key);
        return Object.freeze({
            pull: this.crypto_secretstream_xchacha20poly1305_pull.bind(this, state)
        });
    }

    /**
     * Stream encryption.
     *
     * @param {*} state
     * @param {string|Buffer} message
     * @param {string|Buffer} ad
     * @param {number} tag
     * @return {Promise<Buffer>}
     */
    async crypto_secretstream_xchacha20poly1305_push(state, message, ad = '', tag = 0) {
        await this.ensureLoaded();
        return this.backend.crypto_secretstream_xchacha20poly1305_push(state, message, ad, tag);
    }

    /**
     * Stream decryption.
     *
     * @param {*} state
     * @param {Buffer} ciphertext
     * @param {string|Buffer} ad
     * @param {number} tag
     * @return {Promise<Buffer>}
     */
    async crypto_secretstream_xchacha20poly1305_pull(state, ciphertext, ad = '', tag = 0) {
        await this.ensureLoaded();
        return this.backend.crypto_secretstream_xchacha20poly1305_pull(state, ciphertext, ad, tag);
    }

    /**
     * Deterministic rekeying.
     *
     * @param {*} state
     * @return {Promise<void>}
     */
    async crypto_secretstream_xchacha20poly1305_rekey(state) {
        await this.ensureLoaded();
        await this.backend.crypto_secretstream_xchacha20poly1305_rekey(state);
    }

    /**
     * Generate a key for shared-key authenticated encryption.
     *
     * @return {Promise<CryptographyKey>}
     */
    async crypto_secretstream_xchacha20poly1305_keygen() {
        return new CryptographyKey(
            await this.backend.randombytes_buf(this.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_KEYBYTES)
        );
    }

    /**
     * Calculate a fast hash for short inputs.
     *
     * Algorithm: SipHash-2-4
     *
     * @param {string|Buffer} message
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_shorthash(message, key) {
        await this.ensureLoaded();
        return await this.backend.crypto_shorthash(await Util.toBuffer(message), key);
    }

    /**
     * @return {Promise<CryptographyKey>}
     */
    async crypto_shorthash_keygen() {
        return new CryptographyKey(
            await this.backend.randombytes_buf(this.CRYPTO_SHORTHASH_KEYBYTES)
        );
    }

    /**
     * Returns a signed message.
     *
     * @param {string|Buffer} message,
     * @param {Ed25519SecretKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign(message, secretKey) {
        await this.ensureLoaded();
        if (!(secretKey instanceof Ed25519SecretKey)) {
            throw new TypeError('Argument 2 must be an instance of Ed25519SecretKey');
        }
        return this.backend.crypto_sign(message, secretKey);
    }

    /**
     * Given a signed message, verify the Ed25519 signature. If it matches, return the
     * bare message (no signature).
     *
     * @param {string|Buffer} message,
     * @param {Ed25519PublicKey} publicKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign_open(message, publicKey) {
        await this.ensureLoaded();
        if (!(publicKey instanceof Ed25519PublicKey)) {
            throw new TypeError('Argument 2 must be an instance of Ed25519PublicKey');
        }
        return this.backend.crypto_sign_open(message, publicKey);
    }

    /**
     * Returns the Ed25519 signature of the message, for the given secret key.
     *
     * @param {string|Buffer} message,
     * @param {Ed25519SecretKey} secretKey
     * @return {Promise<Buffer>}
     */
    async crypto_sign_detached(message, secretKey) {
        await this.ensureLoaded();
        if (!(secretKey instanceof Ed25519SecretKey)) {
            throw new TypeError('Argument 2 must be an instance of Ed25519SecretKey');
        }
        return this.backend.crypto_sign_detached(message, secretKey);
    }

    /**
     * Returns true if the Ed25519 signature is valid for a given message and public key.
     *
     * @param {string|Buffer} message,
     * @param {Ed25519PublicKey} publicKey
     * @param {Buffer} signature
     * @return {Promise<boolean>}
     */
    async crypto_sign_verify_detached(message, publicKey, signature) {
        await this.ensureLoaded();
        if (!(publicKey instanceof Ed25519PublicKey)) {
            throw new TypeError('Argument 2 must be an instance of Ed25519PublicKey');
        }
        return this.backend.crypto_sign_verify_detached(message, publicKey, signature);
    }

    /**
     * Extract the secret key from an Ed25519 keypair object.
     *
     * @param {CryptographyKey} keypair
     * @return {Promise<Ed25519SecretKey>}
     */
    async crypto_sign_secretkey(keypair) {
        if (keypair.getLength() !== 96) {
            throw new SodiumError('Keypair must be 96 bytes');
        }
        return new Ed25519SecretKey(
            await Util.toBuffer(
                keypair.getBuffer().slice(0, 64)
            )
        );
    }

    /**
     * Extract the public key from an Ed25519 keypair object.
     *
     * @param {CryptographyKey} keypair
     * @return {Promise<Ed25519PublicKey>}
     */
    async crypto_sign_publickey(keypair) {
        if (keypair.getLength() !== 96) {
            throw new SodiumError('Keypair must be 96 bytes');
        }
        return new Ed25519PublicKey(
            keypair.getBuffer().slice(64, 96)
        );
    }

    /**
     * Generate an Ed25519 keypair object.
     *
     * @return {Promise<CryptographyKey>}
     */
    async crypto_sign_keypair() {
        await this.ensureLoaded();
        return this.backend.crypto_sign_keypair();
    }

    /**
     * Generate an Ed25519 keypair object from a seed.
     *
     * @param {Buffer} seed
     * @return {Promise<CryptographyKey>}
     */
    async crypto_sign_seed_keypair(seed) {
        await this.ensureLoaded();
        if (seed instanceof CryptographyKey) {
            seed = seed.getBuffer();
        }
        seed = await Util.toBuffer(seed);
        if (seed.length !== 32) {
            throw new SodiumError(`Seed must be 32 bytes long; got ${seed.length}`);
        }
        return this.backend.crypto_sign_seed_keypair(seed);
    }

    /**
     * Obtain a birationally equivalent X25519 secret key,
     * given an Ed25519 secret key.
     *
     * @param {Ed25519SecretKey} sk
     * @return {Promise<X25519SecretKey>}
     */
    async crypto_sign_ed25519_sk_to_curve25519(sk) {
        await this.ensureLoaded();
        return new X25519SecretKey(
            await this.backend.crypto_sign_ed25519_sk_to_curve25519(sk)
        );
    }

    /**
     * Obtain a birationally equivalent X25519 public key,
     * given an Ed25519 public key.
     *
     * @param {Ed25519PublicKey} pk
     * @return {Promise<X25519PublicKey>}
     */
    async crypto_sign_ed25519_pk_to_curve25519(pk) {
        await this.ensureLoaded();
        return new X25519PublicKey(
            await this.backend.crypto_sign_ed25519_pk_to_curve25519(pk)
        );
    }

    /**
     * Generate an arbitrary number of pseudorandom bytes from a given
     * nonce and key.
     *
     * @param {number} length
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_stream(length, nonce, key) {
        await this.ensureLoaded();
        return this.backend.crypto_stream(length, nonce, key);
    }

    /**
     * Encrypts a string (without authentication).
     *
     * @param {string|Buffer} plaintext
     * @param {Buffer} nonce
     * @param {CryptographyKey} key
     * @return {Promise<Buffer>}
     */
    async crypto_stream_xor(plaintext, nonce, key) {
        await this.ensureLoaded();
        return this.backend.crypto_stream_xor(plaintext, nonce, key);
    }
    /**
     * Generate a key for stream ciphers.
     *
     * @return {Promise<CryptographyKey>}
     */
    async crypto_stream_keygen() {
        return new CryptographyKey(
            await this.backend.randombytes_buf(this.CRYPTO_STREAM_KEYBYTES)
        );
    }

    /**
     * Returns a buffer filled with random bytes.
     *
     * @param {number} num
     * @return {Promise<Buffer>}
     */
    async randombytes_buf(num) {
        await this.ensureLoaded();
        return await this.backend.randombytes_buf(num);
    }

    /**
     * Generate an integer between 0 and upperBound (non-inclusive).
     *
     * For example, randombytes_uniform(10) returns an integer between 0 and 9.
     *
     * @param {number} upperBound
     * @return {Promise<number>}
     */
    async randombytes_uniform(upperBound) {
        await this.ensureLoaded();
        return this.backend.randombytes_uniform(upperBound);
    }

    /**
     * Add two buffers (little-endian). Returns the value.
     *
     * @param {Buffer} val
     * @param {Buffer} addv
     * @return {Promise<Buffer>}
     */
    async sodium_add(val, addv) {
        await this.ensureLoaded();
        return await this.backend.sodium_add(
            await Util.toBuffer(val),
            await Util.toBuffer(addv)
        );
    }

    /**
     * Convert to hex.
     *
     * @param {Buffer} decoded
     * @return {Promise<Buffer>}
     */
    async sodium_bin2hex(decoded) {
        await this.ensureLoaded();
        return this.backend.sodium_bin2hex(decoded);
    }

    /**
     * Compare two buffers in constant time.
     *
     * Returns -1 if b1 is less than b2.
     * Returns  1 if b1 is greater than b2.
     * Returns  0 if b1 is equal to b2.
     *
     * @param {Buffer} b1
     * @param {Buffer} b2
     * @return {Promise<number>}
     */
    async sodium_compare(b1, b2) {
        await this.ensureLoaded();
        return this.backend.sodium_compare(b1, b2);
    }
    /**
     * Convert to hex.
     *
     * @param {Buffer|string} encoded
     * @return {Promise<string>}
     */
    async sodium_hex2bin(encoded) {
        await this.ensureLoaded();
        return this.backend.sodium_hex2bin(encoded);
    }

    /**
     * Increment a buffer (little endian). Overwrites the buffer in-place.
     *
     * @param {Buffer} buf
     * @return {Promise<Buffer>}
     */
    async sodium_increment(buf) {
        await this.ensureLoaded();
        return this.backend.sodium_increment(buf);
    }

    /**
     * Returns true if the buffer is zero.
     *
     * @param {Buffer} buf
     * @param {number} len
     * @return {Promise<Buffer>}
     */
    async sodium_is_zero(buf, len) {
        await this.ensureLoaded();
        return this.backend.sodium_is_zero(buf, len);
    }

    /**
     * Timing-safe buffer comparison.
     *
     * @param {Buffer} b1
     * @param {Buffer} b2
     * @return {Promise<boolean>}
     */
    async sodium_memcmp(b1, b2) {
        await this.ensureLoaded();
        return this.backend.sodium_memcmp(b1, b2);
    }

    /**
     * Zero out a buffer. Overwrites the buffer in-place.
     *
     * @param {Buffer} buf
     * @return {Promise<void>}
     */
    async sodium_memzero(buf) {
        await this.ensureLoaded();
        await this.backend.sodium_memzero(buf);
    }

    /**
     * Pad a string.
     *
     * @param {string|Buffer} buf
     * @param {number} blockSize
     * @return {Promise<Buffer>}
     */
    async sodium_pad(buf, blockSize) {
        await this.ensureLoaded();
        return this.backend.sodium_pad(buf, blockSize);
    }

    /**
     * Unpad a string.
     *
     * @param {string|Buffer} buf
     * @param {number} blockSize
     * @return {Promise<Buffer>}
     */
    async sodium_unpad(buf, blockSize) {
        await this.ensureLoaded();
        return this.backend.sodium_unpad(buf, blockSize);
    }
}

module.exports = SodiumPlus;

}).call(this,require("buffer").Buffer)
},{"./backend":3,"./backend/libsodium-wrappers":4,"./cryptography-key":6,"./keytypes/ed25519pk":7,"./keytypes/ed25519sk":8,"./keytypes/x25519pk":9,"./keytypes/x25519sk":10,"./sodium-error":12,"./util":14,"buffer":74,"buffer/":17}],14:[function(require,module,exports){
(function (Buffer){
"use strict";

/* istanbul ignore if */
if (typeof (Buffer) === 'undefined') {
    let Buffer = require('buffer/').Buffer;
}

const arrayToBuffer = require('typedarray-to-buffer');

module.exports = class Util
{
    static async cloneBuffer(buf) {
        return Buffer.from(buf);
    }

    /**
     * Define the sodium constants
     *
     * @param {object} anyobject
     * @return {object}
     */
    static populateConstants(anyobject) {
        anyobject.LIBRARY_VERSION_MAJOR = 10;
        anyobject.LIBRARY_VERSION_MINOR = 2;
        anyobject.VERSION_STRING = '1.0.17';
        anyobject.BASE64_VARIANT_ORIGINAL = 1;
        anyobject.BASE64_VARIANT_ORIGINAL_NO_PADDING = 3;
        anyobject.BASE64_VARIANT_URLSAFE = 5;
        anyobject.BASE64_VARIANT_URLSAFE_NO_PADDING = 7;
        anyobject.CRYPTO_AEAD_AES256GCM_KEYBYTES = 32;
        anyobject.CRYPTO_AEAD_AES256GCM_NSECBYTES = 0;
        anyobject.CRYPTO_AEAD_AES256GCM_NPUBBYTES = 12;
        anyobject.CRYPTO_AEAD_AES256GCM_ABYTES = 16;
        anyobject.CRYPTO_AEAD_CHACHA20POLY1305_KEYBYTES = 32;
        anyobject.CRYPTO_AEAD_CHACHA20POLY1305_NSECBYTES = 0;
        anyobject.CRYPTO_AEAD_CHACHA20POLY1305_NPUBBYTES = 8;
        anyobject.CRYPTO_AEAD_CHACHA20POLY1305_ABYTES = 16;
        anyobject.CRYPTO_AEAD_CHACHA20POLY1305_IETF_KEYBYTES = 32;
        anyobject.CRYPTO_AEAD_CHACHA20POLY1305_IETF_NSECBYTES = 0;
        anyobject.CRYPTO_AEAD_CHACHA20POLY1305_IETF_NPUBBYTES = 12;
        anyobject.CRYPTO_AEAD_CHACHA20POLY1305_IETF_ABYTES = 16;
        anyobject.CRYPTO_AEAD_XCHACHA20POLY1305_IETF_KEYBYTES = 32;
        anyobject.CRYPTO_AEAD_XCHACHA20POLY1305_IETF_NSECBYTES = 0;
        anyobject.CRYPTO_AEAD_XCHACHA20POLY1305_IETF_NPUBBYTES = 24;
        anyobject.CRYPTO_AEAD_XCHACHA20POLY1305_IETF_ABYTES = 16;
        anyobject.CRYPTO_AUTH_BYTES = 32;
        anyobject.CRYPTO_AUTH_KEYBYTES = 32;
        anyobject.CRYPTO_BOX_SEALBYTES = 16;
        anyobject.CRYPTO_BOX_SECRETKEYBYTES = 32;
        anyobject.CRYPTO_BOX_PUBLICKEYBYTES = 32;
        anyobject.CRYPTO_BOX_KEYPAIRBYTES = 64;
        anyobject.CRYPTO_BOX_MACBYTES = 16;
        anyobject.CRYPTO_BOX_NONCEBYTES = 24;
        anyobject.CRYPTO_BOX_SEEDBYTES = 32;
        anyobject.CRYPTO_KDF_BYTES_MIN = 16;
        anyobject.CRYPTO_KDF_BYTES_MAX = 64;
        anyobject.CRYPTO_KDF_CONTEXTBYTES = 8;
        anyobject.CRYPTO_KDF_KEYBYTES = 32;
        anyobject.CRYPTO_KX_BYTES = 32;
        anyobject.CRYPTO_KX_PRIMITIVE = 'x25519blake2b';
        anyobject.CRYPTO_KX_SEEDBYTES = 32;
        anyobject.CRYPTO_KX_KEYPAIRBYTES = 64;
        anyobject.CRYPTO_KX_PUBLICKEYBYTES = 32;
        anyobject.CRYPTO_KX_SECRETKEYBYTES = 32;
        anyobject.CRYPTO_KX_SESSIONKEYBYTES = 32;
        anyobject.CRYPTO_GENERICHASH_BYTES = 32;
        anyobject.CRYPTO_GENERICHASH_BYTES_MIN = 16;
        anyobject.CRYPTO_GENERICHASH_BYTES_MAX = 64;
        anyobject.CRYPTO_GENERICHASH_KEYBYTES = 32;
        anyobject.CRYPTO_GENERICHASH_KEYBYTES_MIN = 16;
        anyobject.CRYPTO_GENERICHASH_KEYBYTES_MAX = 64;
        anyobject.CRYPTO_GENERICHASH_STATEBYTES = 384;
        anyobject.CRYPTO_PWHASH_SALTBYTES = 16;
        anyobject.CRYPTO_PWHASH_STRPREFIX = '$argon2id$';
        anyobject.CRYPTO_PWHASH_ALG_ARGON2I13 = 1;
        anyobject.CRYPTO_PWHASH_ALG_ARGON2ID13 = 2;
        anyobject.CRYPTO_PWHASH_ALG_DEFAULT = anyobject.CRYPTO_PWHASH_ALG_ARGON2ID13;
        anyobject.CRYPTO_PWHASH_OPSLIMIT_INTERACTIVE = 2;
        anyobject.CRYPTO_PWHASH_MEMLIMIT_INTERACTIVE = 67108864;
        anyobject.CRYPTO_PWHASH_OPSLIMIT_MODERATE = 3;
        anyobject.CRYPTO_PWHASH_MEMLIMIT_MODERATE = 268435456;
        anyobject.CRYPTO_PWHASH_OPSLIMIT_SENSITIVE = 4;
        anyobject.CRYPTO_PWHASH_MEMLIMIT_SENSITIVE = 1073741824;
        anyobject.CRYPTO_PWHASH_SCRYPTSALSA208SHA256_SALTBYTES = 32;
        anyobject.CRYPTO_SCALARMULT_BYTES = 32;
        anyobject.CRYPTO_SCALARMULT_SCALARBYTES = 32;
        anyobject.CRYPTO_SHORTHASH_BYTES = 8;
        anyobject.CRYPTO_SHORTHASH_KEYBYTES = 16;
        anyobject.CRYPTO_SECRETBOX_KEYBYTES = 32;
        anyobject.CRYPTO_SECRETBOX_MACBYTES = 16;
        anyobject.CRYPTO_SECRETBOX_NONCEBYTES = 24;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_STATEBYTES = 52;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_ABYTES = 17;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_HEADERBYTES = 24;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_KEYBYTES = 32;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_TAG_PUSH = 0;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_TAG_PULL = 1;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_TAG_REKEY = 2;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_TAG_FINAL = 3;
        anyobject.CRYPTO_SECRETSTREAM_XCHACHA20POLY1305_MESSAGEBYTES_MAX = 0x3fffffff80;
        anyobject.CRYPTO_SIGN_BYTES = 64;
        anyobject.CRYPTO_SIGN_SEEDBYTES = 32;
        anyobject.CRYPTO_SIGN_PUBLICKEYBYTES = 32;
        anyobject.CRYPTO_SIGN_SECRETKEYBYTES = 64;
        anyobject.CRYPTO_SIGN_KEYPAIRBYTES = 96;
        anyobject.CRYPTO_STREAM_KEYBYTES = 32;
        anyobject.CRYPTO_STREAM_NONCEBYTES = 24;
        return anyobject;
    }

    /**
     * Coerce input to a Buffer, throwing a TypeError if it cannot be coerced.
     *
     * @param {string|Buffer|Uint8Array|Promise<Buffer>} stringOrBuffer
     * @returns {Buffer}
     */
    static async toBuffer(stringOrBuffer)
    {
        if (Buffer.isBuffer(stringOrBuffer)) {
            return stringOrBuffer;
        } else if (stringOrBuffer === null) {
            return null;
        } else if (typeof(stringOrBuffer) === 'string') {
            return Buffer.from(stringOrBuffer, 'binary');
        } else if (stringOrBuffer instanceof Uint8Array) {
            return arrayToBuffer(stringOrBuffer);
        } else if (stringOrBuffer instanceof Promise) {
            return await stringOrBuffer;
        } else {
            throw new TypeError('Invalid type; string or buffer expected');
        }
    }
};

}).call(this,require("buffer").Buffer)
},{"buffer":74,"buffer/":17,"typedarray-to-buffer":25}],15:[function(require,module,exports){
'use strict'

exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(
      uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)
    ))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}

},{}],16:[function(require,module,exports){
var bigInt = (function (undefined) {
    "use strict";

    var BASE = 1e7,
        LOG_BASE = 7,
        MAX_INT = 9007199254740992,
        MAX_INT_ARR = smallToArray(MAX_INT),
        DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";

    var supportsNativeBigInt = typeof BigInt === "function";

    function Integer(v, radix, alphabet, caseSensitive) {
        if (typeof v === "undefined") return Integer[0];
        if (typeof radix !== "undefined") return +radix === 10 && !alphabet ? parseValue(v) : parseBase(v, radix, alphabet, caseSensitive);
        return parseValue(v);
    }

    function BigInteger(value, sign) {
        this.value = value;
        this.sign = sign;
        this.isSmall = false;
    }
    BigInteger.prototype = Object.create(Integer.prototype);

    function SmallInteger(value) {
        this.value = value;
        this.sign = value < 0;
        this.isSmall = true;
    }
    SmallInteger.prototype = Object.create(Integer.prototype);

    function NativeBigInt(value) {
        this.value = value;
    }
    NativeBigInt.prototype = Object.create(Integer.prototype);

    function isPrecise(n) {
        return -MAX_INT < n && n < MAX_INT;
    }

    function smallToArray(n) { // For performance reasons doesn't reference BASE, need to change this function if BASE changes
        if (n < 1e7)
            return [n];
        if (n < 1e14)
            return [n % 1e7, Math.floor(n / 1e7)];
        return [n % 1e7, Math.floor(n / 1e7) % 1e7, Math.floor(n / 1e14)];
    }

    function arrayToSmall(arr) { // If BASE changes this function may need to change
        trim(arr);
        var length = arr.length;
        if (length < 4 && compareAbs(arr, MAX_INT_ARR) < 0) {
            switch (length) {
                case 0: return 0;
                case 1: return arr[0];
                case 2: return arr[0] + arr[1] * BASE;
                default: return arr[0] + (arr[1] + arr[2] * BASE) * BASE;
            }
        }
        return arr;
    }

    function trim(v) {
        var i = v.length;
        while (v[--i] === 0);
        v.length = i + 1;
    }

    function createArray(length) { // function shamelessly stolen from Yaffle's library https://github.com/Yaffle/BigInteger
        var x = new Array(length);
        var i = -1;
        while (++i < length) {
            x[i] = 0;
        }
        return x;
    }

    function truncate(n) {
        if (n > 0) return Math.floor(n);
        return Math.ceil(n);
    }

    function add(a, b) { // assumes a and b are arrays with a.length >= b.length
        var l_a = a.length,
            l_b = b.length,
            r = new Array(l_a),
            carry = 0,
            base = BASE,
            sum, i;
        for (i = 0; i < l_b; i++) {
            sum = a[i] + b[i] + carry;
            carry = sum >= base ? 1 : 0;
            r[i] = sum - carry * base;
        }
        while (i < l_a) {
            sum = a[i] + carry;
            carry = sum === base ? 1 : 0;
            r[i++] = sum - carry * base;
        }
        if (carry > 0) r.push(carry);
        return r;
    }

    function addAny(a, b) {
        if (a.length >= b.length) return add(a, b);
        return add(b, a);
    }

    function addSmall(a, carry) { // assumes a is array, carry is number with 0 <= carry < MAX_INT
        var l = a.length,
            r = new Array(l),
            base = BASE,
            sum, i;
        for (i = 0; i < l; i++) {
            sum = a[i] - base + carry;
            carry = Math.floor(sum / base);
            r[i] = sum - carry * base;
            carry += 1;
        }
        while (carry > 0) {
            r[i++] = carry % base;
            carry = Math.floor(carry / base);
        }
        return r;
    }

    BigInteger.prototype.add = function (v) {
        var n = parseValue(v);
        if (this.sign !== n.sign) {
            return this.subtract(n.negate());
        }
        var a = this.value, b = n.value;
        if (n.isSmall) {
            return new BigInteger(addSmall(a, Math.abs(b)), this.sign);
        }
        return new BigInteger(addAny(a, b), this.sign);
    };
    BigInteger.prototype.plus = BigInteger.prototype.add;

    SmallInteger.prototype.add = function (v) {
        var n = parseValue(v);
        var a = this.value;
        if (a < 0 !== n.sign) {
            return this.subtract(n.negate());
        }
        var b = n.value;
        if (n.isSmall) {
            if (isPrecise(a + b)) return new SmallInteger(a + b);
            b = smallToArray(Math.abs(b));
        }
        return new BigInteger(addSmall(b, Math.abs(a)), a < 0);
    };
    SmallInteger.prototype.plus = SmallInteger.prototype.add;

    NativeBigInt.prototype.add = function (v) {
        return new NativeBigInt(this.value + parseValue(v).value);
    }
    NativeBigInt.prototype.plus = NativeBigInt.prototype.add;

    function subtract(a, b) { // assumes a and b are arrays with a >= b
        var a_l = a.length,
            b_l = b.length,
            r = new Array(a_l),
            borrow = 0,
            base = BASE,
            i, difference;
        for (i = 0; i < b_l; i++) {
            difference = a[i] - borrow - b[i];
            if (difference < 0) {
                difference += base;
                borrow = 1;
            } else borrow = 0;
            r[i] = difference;
        }
        for (i = b_l; i < a_l; i++) {
            difference = a[i] - borrow;
            if (difference < 0) difference += base;
            else {
                r[i++] = difference;
                break;
            }
            r[i] = difference;
        }
        for (; i < a_l; i++) {
            r[i] = a[i];
        }
        trim(r);
        return r;
    }

    function subtractAny(a, b, sign) {
        var value;
        if (compareAbs(a, b) >= 0) {
            value = subtract(a, b);
        } else {
            value = subtract(b, a);
            sign = !sign;
        }
        value = arrayToSmall(value);
        if (typeof value === "number") {
            if (sign) value = -value;
            return new SmallInteger(value);
        }
        return new BigInteger(value, sign);
    }

    function subtractSmall(a, b, sign) { // assumes a is array, b is number with 0 <= b < MAX_INT
        var l = a.length,
            r = new Array(l),
            carry = -b,
            base = BASE,
            i, difference;
        for (i = 0; i < l; i++) {
            difference = a[i] + carry;
            carry = Math.floor(difference / base);
            difference %= base;
            r[i] = difference < 0 ? difference + base : difference;
        }
        r = arrayToSmall(r);
        if (typeof r === "number") {
            if (sign) r = -r;
            return new SmallInteger(r);
        } return new BigInteger(r, sign);
    }

    BigInteger.prototype.subtract = function (v) {
        var n = parseValue(v);
        if (this.sign !== n.sign) {
            return this.add(n.negate());
        }
        var a = this.value, b = n.value;
        if (n.isSmall)
            return subtractSmall(a, Math.abs(b), this.sign);
        return subtractAny(a, b, this.sign);
    };
    BigInteger.prototype.minus = BigInteger.prototype.subtract;

    SmallInteger.prototype.subtract = function (v) {
        var n = parseValue(v);
        var a = this.value;
        if (a < 0 !== n.sign) {
            return this.add(n.negate());
        }
        var b = n.value;
        if (n.isSmall) {
            return new SmallInteger(a - b);
        }
        return subtractSmall(b, Math.abs(a), a >= 0);
    };
    SmallInteger.prototype.minus = SmallInteger.prototype.subtract;

    NativeBigInt.prototype.subtract = function (v) {
        return new NativeBigInt(this.value - parseValue(v).value);
    }
    NativeBigInt.prototype.minus = NativeBigInt.prototype.subtract;

    BigInteger.prototype.negate = function () {
        return new BigInteger(this.value, !this.sign);
    };
    SmallInteger.prototype.negate = function () {
        var sign = this.sign;
        var small = new SmallInteger(-this.value);
        small.sign = !sign;
        return small;
    };
    NativeBigInt.prototype.negate = function () {
        return new NativeBigInt(-this.value);
    }

    BigInteger.prototype.abs = function () {
        return new BigInteger(this.value, false);
    };
    SmallInteger.prototype.abs = function () {
        return new SmallInteger(Math.abs(this.value));
    };
    NativeBigInt.prototype.abs = function () {
        return new NativeBigInt(this.value >= 0 ? this.value : -this.value);
    }


    function multiplyLong(a, b) {
        var a_l = a.length,
            b_l = b.length,
            l = a_l + b_l,
            r = createArray(l),
            base = BASE,
            product, carry, i, a_i, b_j;
        for (i = 0; i < a_l; ++i) {
            a_i = a[i];
            for (var j = 0; j < b_l; ++j) {
                b_j = b[j];
                product = a_i * b_j + r[i + j];
                carry = Math.floor(product / base);
                r[i + j] = product - carry * base;
                r[i + j + 1] += carry;
            }
        }
        trim(r);
        return r;
    }

    function multiplySmall(a, b) { // assumes a is array, b is number with |b| < BASE
        var l = a.length,
            r = new Array(l),
            base = BASE,
            carry = 0,
            product, i;
        for (i = 0; i < l; i++) {
            product = a[i] * b + carry;
            carry = Math.floor(product / base);
            r[i] = product - carry * base;
        }
        while (carry > 0) {
            r[i++] = carry % base;
            carry = Math.floor(carry / base);
        }
        return r;
    }

    function shiftLeft(x, n) {
        var r = [];
        while (n-- > 0) r.push(0);
        return r.concat(x);
    }

    function multiplyKaratsuba(x, y) {
        var n = Math.max(x.length, y.length);

        if (n <= 30) return multiplyLong(x, y);
        n = Math.ceil(n / 2);

        var b = x.slice(n),
            a = x.slice(0, n),
            d = y.slice(n),
            c = y.slice(0, n);

        var ac = multiplyKaratsuba(a, c),
            bd = multiplyKaratsuba(b, d),
            abcd = multiplyKaratsuba(addAny(a, b), addAny(c, d));

        var product = addAny(addAny(ac, shiftLeft(subtract(subtract(abcd, ac), bd), n)), shiftLeft(bd, 2 * n));
        trim(product);
        return product;
    }

    // The following function is derived from a surface fit of a graph plotting the performance difference
    // between long multiplication and karatsuba multiplication versus the lengths of the two arrays.
    function useKaratsuba(l1, l2) {
        return -0.012 * l1 - 0.012 * l2 + 0.000015 * l1 * l2 > 0;
    }

    BigInteger.prototype.multiply = function (v) {
        var n = parseValue(v),
            a = this.value, b = n.value,
            sign = this.sign !== n.sign,
            abs;
        if (n.isSmall) {
            if (b === 0) return Integer[0];
            if (b === 1) return this;
            if (b === -1) return this.negate();
            abs = Math.abs(b);
            if (abs < BASE) {
                return new BigInteger(multiplySmall(a, abs), sign);
            }
            b = smallToArray(abs);
        }
        if (useKaratsuba(a.length, b.length)) // Karatsuba is only faster for certain array sizes
            return new BigInteger(multiplyKaratsuba(a, b), sign);
        return new BigInteger(multiplyLong(a, b), sign);
    };

    BigInteger.prototype.times = BigInteger.prototype.multiply;

    function multiplySmallAndArray(a, b, sign) { // a >= 0
        if (a < BASE) {
            return new BigInteger(multiplySmall(b, a), sign);
        }
        return new BigInteger(multiplyLong(b, smallToArray(a)), sign);
    }
    SmallInteger.prototype._multiplyBySmall = function (a) {
        if (isPrecise(a.value * this.value)) {
            return new SmallInteger(a.value * this.value);
        }
        return multiplySmallAndArray(Math.abs(a.value), smallToArray(Math.abs(this.value)), this.sign !== a.sign);
    };
    BigInteger.prototype._multiplyBySmall = function (a) {
        if (a.value === 0) return Integer[0];
        if (a.value === 1) return this;
        if (a.value === -1) return this.negate();
        return multiplySmallAndArray(Math.abs(a.value), this.value, this.sign !== a.sign);
    };
    SmallInteger.prototype.multiply = function (v) {
        return parseValue(v)._multiplyBySmall(this);
    };
    SmallInteger.prototype.times = SmallInteger.prototype.multiply;

    NativeBigInt.prototype.multiply = function (v) {
        return new NativeBigInt(this.value * parseValue(v).value);
    }
    NativeBigInt.prototype.times = NativeBigInt.prototype.multiply;

    function square(a) {
        //console.assert(2 * BASE * BASE < MAX_INT);
        var l = a.length,
            r = createArray(l + l),
            base = BASE,
            product, carry, i, a_i, a_j;
        for (i = 0; i < l; i++) {
            a_i = a[i];
            carry = 0 - a_i * a_i;
            for (var j = i; j < l; j++) {
                a_j = a[j];
                product = 2 * (a_i * a_j) + r[i + j] + carry;
                carry = Math.floor(product / base);
                r[i + j] = product - carry * base;
            }
            r[i + l] = carry;
        }
        trim(r);
        return r;
    }

    BigInteger.prototype.square = function () {
        return new BigInteger(square(this.value), false);
    };

    SmallInteger.prototype.square = function () {
        var value = this.value * this.value;
        if (isPrecise(value)) return new SmallInteger(value);
        return new BigInteger(square(smallToArray(Math.abs(this.value))), false);
    };

    NativeBigInt.prototype.square = function (v) {
        return new NativeBigInt(this.value * this.value);
    }

    function divMod1(a, b) { // Left over from previous version. Performs faster than divMod2 on smaller input sizes.
        var a_l = a.length,
            b_l = b.length,
            base = BASE,
            result = createArray(b.length),
            divisorMostSignificantDigit = b[b_l - 1],
            // normalization
            lambda = Math.ceil(base / (2 * divisorMostSignificantDigit)),
            remainder = multiplySmall(a, lambda),
            divisor = multiplySmall(b, lambda),
            quotientDigit, shift, carry, borrow, i, l, q;
        if (remainder.length <= a_l) remainder.push(0);
        divisor.push(0);
        divisorMostSignificantDigit = divisor[b_l - 1];
        for (shift = a_l - b_l; shift >= 0; shift--) {
            quotientDigit = base - 1;
            if (remainder[shift + b_l] !== divisorMostSignificantDigit) {
                quotientDigit = Math.floor((remainder[shift + b_l] * base + remainder[shift + b_l - 1]) / divisorMostSignificantDigit);
            }
            // quotientDigit <= base - 1
            carry = 0;
            borrow = 0;
            l = divisor.length;
            for (i = 0; i < l; i++) {
                carry += quotientDigit * divisor[i];
                q = Math.floor(carry / base);
                borrow += remainder[shift + i] - (carry - q * base);
                carry = q;
                if (borrow < 0) {
                    remainder[shift + i] = borrow + base;
                    borrow = -1;
                } else {
                    remainder[shift + i] = borrow;
                    borrow = 0;
                }
            }
            while (borrow !== 0) {
                quotientDigit -= 1;
                carry = 0;
                for (i = 0; i < l; i++) {
                    carry += remainder[shift + i] - base + divisor[i];
                    if (carry < 0) {
                        remainder[shift + i] = carry + base;
                        carry = 0;
                    } else {
                        remainder[shift + i] = carry;
                        carry = 1;
                    }
                }
                borrow += carry;
            }
            result[shift] = quotientDigit;
        }
        // denormalization
        remainder = divModSmall(remainder, lambda)[0];
        return [arrayToSmall(result), arrayToSmall(remainder)];
    }

    function divMod2(a, b) { // Implementation idea shamelessly stolen from Silent Matt's library http://silentmatt.com/biginteger/
        // Performs faster than divMod1 on larger input sizes.
        var a_l = a.length,
            b_l = b.length,
            result = [],
            part = [],
            base = BASE,
            guess, xlen, highx, highy, check;
        while (a_l) {
            part.unshift(a[--a_l]);
            trim(part);
            if (compareAbs(part, b) < 0) {
                result.push(0);
                continue;
            }
            xlen = part.length;
            highx = part[xlen - 1] * base + part[xlen - 2];
            highy = b[b_l - 1] * base + b[b_l - 2];
            if (xlen > b_l) {
                highx = (highx + 1) * base;
            }
            guess = Math.ceil(highx / highy);
            do {
                check = multiplySmall(b, guess);
                if (compareAbs(check, part) <= 0) break;
                guess--;
            } while (guess);
            result.push(guess);
            part = subtract(part, check);
        }
        result.reverse();
        return [arrayToSmall(result), arrayToSmall(part)];
    }

    function divModSmall(value, lambda) {
        var length = value.length,
            quotient = createArray(length),
            base = BASE,
            i, q, remainder, divisor;
        remainder = 0;
        for (i = length - 1; i >= 0; --i) {
            divisor = remainder * base + value[i];
            q = truncate(divisor / lambda);
            remainder = divisor - q * lambda;
            quotient[i] = q | 0;
        }
        return [quotient, remainder | 0];
    }

    function divModAny(self, v) {
        var value, n = parseValue(v);
        if (supportsNativeBigInt) {
            return [new NativeBigInt(self.value / n.value), new NativeBigInt(self.value % n.value)];
        }
        var a = self.value, b = n.value;
        var quotient;
        if (b === 0) throw new Error("Cannot divide by zero");
        if (self.isSmall) {
            if (n.isSmall) {
                return [new SmallInteger(truncate(a / b)), new SmallInteger(a % b)];
            }
            return [Integer[0], self];
        }
        if (n.isSmall) {
            if (b === 1) return [self, Integer[0]];
            if (b == -1) return [self.negate(), Integer[0]];
            var abs = Math.abs(b);
            if (abs < BASE) {
                value = divModSmall(a, abs);
                quotient = arrayToSmall(value[0]);
                var remainder = value[1];
                if (self.sign) remainder = -remainder;
                if (typeof quotient === "number") {
                    if (self.sign !== n.sign) quotient = -quotient;
                    return [new SmallInteger(quotient), new SmallInteger(remainder)];
                }
                return [new BigInteger(quotient, self.sign !== n.sign), new SmallInteger(remainder)];
            }
            b = smallToArray(abs);
        }
        var comparison = compareAbs(a, b);
        if (comparison === -1) return [Integer[0], self];
        if (comparison === 0) return [Integer[self.sign === n.sign ? 1 : -1], Integer[0]];

        // divMod1 is faster on smaller input sizes
        if (a.length + b.length <= 200)
            value = divMod1(a, b);
        else value = divMod2(a, b);

        quotient = value[0];
        var qSign = self.sign !== n.sign,
            mod = value[1],
            mSign = self.sign;
        if (typeof quotient === "number") {
            if (qSign) quotient = -quotient;
            quotient = new SmallInteger(quotient);
        } else quotient = new BigInteger(quotient, qSign);
        if (typeof mod === "number") {
            if (mSign) mod = -mod;
            mod = new SmallInteger(mod);
        } else mod = new BigInteger(mod, mSign);
        return [quotient, mod];
    }

    BigInteger.prototype.divmod = function (v) {
        var result = divModAny(this, v);
        return {
            quotient: result[0],
            remainder: result[1]
        };
    };
    NativeBigInt.prototype.divmod = SmallInteger.prototype.divmod = BigInteger.prototype.divmod;


    BigInteger.prototype.divide = function (v) {
        return divModAny(this, v)[0];
    };
    NativeBigInt.prototype.over = NativeBigInt.prototype.divide = function (v) {
        return new NativeBigInt(this.value / parseValue(v).value);
    };
    SmallInteger.prototype.over = SmallInteger.prototype.divide = BigInteger.prototype.over = BigInteger.prototype.divide;

    BigInteger.prototype.mod = function (v) {
        return divModAny(this, v)[1];
    };
    NativeBigInt.prototype.mod = NativeBigInt.prototype.remainder = function (v) {
        return new NativeBigInt(this.value % parseValue(v).value);
    };
    SmallInteger.prototype.remainder = SmallInteger.prototype.mod = BigInteger.prototype.remainder = BigInteger.prototype.mod;

    BigInteger.prototype.pow = function (v) {
        var n = parseValue(v),
            a = this.value,
            b = n.value,
            value, x, y;
        if (b === 0) return Integer[1];
        if (a === 0) return Integer[0];
        if (a === 1) return Integer[1];
        if (a === -1) return n.isEven() ? Integer[1] : Integer[-1];
        if (n.sign) {
            return Integer[0];
        }
        if (!n.isSmall) throw new Error("The exponent " + n.toString() + " is too large.");
        if (this.isSmall) {
            if (isPrecise(value = Math.pow(a, b)))
                return new SmallInteger(truncate(value));
        }
        x = this;
        y = Integer[1];
        while (true) {
            if (b & 1 === 1) {
                y = y.times(x);
                --b;
            }
            if (b === 0) break;
            b /= 2;
            x = x.square();
        }
        return y;
    };
    SmallInteger.prototype.pow = BigInteger.prototype.pow;

    NativeBigInt.prototype.pow = function (v) {
        var n = parseValue(v);
        var a = this.value, b = n.value;
        var _0 = BigInt(0), _1 = BigInt(1), _2 = BigInt(2);
        if (b === _0) return Integer[1];
        if (a === _0) return Integer[0];
        if (a === _1) return Integer[1];
        if (a === BigInt(-1)) return n.isEven() ? Integer[1] : Integer[-1];
        if (n.isNegative()) return new NativeBigInt(_0);
        var x = this;
        var y = Integer[1];
        while (true) {
            if ((b & _1) === _1) {
                y = y.times(x);
                --b;
            }
            if (b === _0) break;
            b /= _2;
            x = x.square();
        }
        return y;
    }

    BigInteger.prototype.modPow = function (exp, mod) {
        exp = parseValue(exp);
        mod = parseValue(mod);
        if (mod.isZero()) throw new Error("Cannot take modPow with modulus 0");
        var r = Integer[1],
            base = this.mod(mod);
        if (exp.isNegative()) {
            exp = exp.multiply(Integer[-1]);
            base = base.modInv(mod);
        }
        while (exp.isPositive()) {
            if (base.isZero()) return Integer[0];
            if (exp.isOdd()) r = r.multiply(base).mod(mod);
            exp = exp.divide(2);
            base = base.square().mod(mod);
        }
        return r;
    };
    NativeBigInt.prototype.modPow = SmallInteger.prototype.modPow = BigInteger.prototype.modPow;

    function compareAbs(a, b) {
        if (a.length !== b.length) {
            return a.length > b.length ? 1 : -1;
        }
        for (var i = a.length - 1; i >= 0; i--) {
            if (a[i] !== b[i]) return a[i] > b[i] ? 1 : -1;
        }
        return 0;
    }

    BigInteger.prototype.compareAbs = function (v) {
        var n = parseValue(v),
            a = this.value,
            b = n.value;
        if (n.isSmall) return 1;
        return compareAbs(a, b);
    };
    SmallInteger.prototype.compareAbs = function (v) {
        var n = parseValue(v),
            a = Math.abs(this.value),
            b = n.value;
        if (n.isSmall) {
            b = Math.abs(b);
            return a === b ? 0 : a > b ? 1 : -1;
        }
        return -1;
    };
    NativeBigInt.prototype.compareAbs = function (v) {
        var a = this.value;
        var b = parseValue(v).value;
        a = a >= 0 ? a : -a;
        b = b >= 0 ? b : -b;
        return a === b ? 0 : a > b ? 1 : -1;
    }

    BigInteger.prototype.compare = function (v) {
        // See discussion about comparison with Infinity:
        // https://github.com/peterolson/BigInteger.js/issues/61
        if (v === Infinity) {
            return -1;
        }
        if (v === -Infinity) {
            return 1;
        }

        var n = parseValue(v),
            a = this.value,
            b = n.value;
        if (this.sign !== n.sign) {
            return n.sign ? 1 : -1;
        }
        if (n.isSmall) {
            return this.sign ? -1 : 1;
        }
        return compareAbs(a, b) * (this.sign ? -1 : 1);
    };
    BigInteger.prototype.compareTo = BigInteger.prototype.compare;

    SmallInteger.prototype.compare = function (v) {
        if (v === Infinity) {
            return -1;
        }
        if (v === -Infinity) {
            return 1;
        }

        var n = parseValue(v),
            a = this.value,
            b = n.value;
        if (n.isSmall) {
            return a == b ? 0 : a > b ? 1 : -1;
        }
        if (a < 0 !== n.sign) {
            return a < 0 ? -1 : 1;
        }
        return a < 0 ? 1 : -1;
    };
    SmallInteger.prototype.compareTo = SmallInteger.prototype.compare;

    NativeBigInt.prototype.compare = function (v) {
        if (v === Infinity) {
            return -1;
        }
        if (v === -Infinity) {
            return 1;
        }
        var a = this.value;
        var b = parseValue(v).value;
        return a === b ? 0 : a > b ? 1 : -1;
    }
    NativeBigInt.prototype.compareTo = NativeBigInt.prototype.compare;

    BigInteger.prototype.equals = function (v) {
        return this.compare(v) === 0;
    };
    NativeBigInt.prototype.eq = NativeBigInt.prototype.equals = SmallInteger.prototype.eq = SmallInteger.prototype.equals = BigInteger.prototype.eq = BigInteger.prototype.equals;

    BigInteger.prototype.notEquals = function (v) {
        return this.compare(v) !== 0;
    };
    NativeBigInt.prototype.neq = NativeBigInt.prototype.notEquals = SmallInteger.prototype.neq = SmallInteger.prototype.notEquals = BigInteger.prototype.neq = BigInteger.prototype.notEquals;

    BigInteger.prototype.greater = function (v) {
        return this.compare(v) > 0;
    };
    NativeBigInt.prototype.gt = NativeBigInt.prototype.greater = SmallInteger.prototype.gt = SmallInteger.prototype.greater = BigInteger.prototype.gt = BigInteger.prototype.greater;

    BigInteger.prototype.lesser = function (v) {
        return this.compare(v) < 0;
    };
    NativeBigInt.prototype.lt = NativeBigInt.prototype.lesser = SmallInteger.prototype.lt = SmallInteger.prototype.lesser = BigInteger.prototype.lt = BigInteger.prototype.lesser;

    BigInteger.prototype.greaterOrEquals = function (v) {
        return this.compare(v) >= 0;
    };
    NativeBigInt.prototype.geq = NativeBigInt.prototype.greaterOrEquals = SmallInteger.prototype.geq = SmallInteger.prototype.greaterOrEquals = BigInteger.prototype.geq = BigInteger.prototype.greaterOrEquals;

    BigInteger.prototype.lesserOrEquals = function (v) {
        return this.compare(v) <= 0;
    };
    NativeBigInt.prototype.leq = NativeBigInt.prototype.lesserOrEquals = SmallInteger.prototype.leq = SmallInteger.prototype.lesserOrEquals = BigInteger.prototype.leq = BigInteger.prototype.lesserOrEquals;

    BigInteger.prototype.isEven = function () {
        return (this.value[0] & 1) === 0;
    };
    SmallInteger.prototype.isEven = function () {
        return (this.value & 1) === 0;
    };
    NativeBigInt.prototype.isEven = function () {
        return (this.value & BigInt(1)) === BigInt(0);
    }

    BigInteger.prototype.isOdd = function () {
        return (this.value[0] & 1) === 1;
    };
    SmallInteger.prototype.isOdd = function () {
        return (this.value & 1) === 1;
    };
    NativeBigInt.prototype.isOdd = function () {
        return (this.value & BigInt(1)) === BigInt(1);
    }

    BigInteger.prototype.isPositive = function () {
        return !this.sign;
    };
    SmallInteger.prototype.isPositive = function () {
        return this.value > 0;
    };
    NativeBigInt.prototype.isPositive = SmallInteger.prototype.isPositive;

    BigInteger.prototype.isNegative = function () {
        return this.sign;
    };
    SmallInteger.prototype.isNegative = function () {
        return this.value < 0;
    };
    NativeBigInt.prototype.isNegative = SmallInteger.prototype.isNegative;

    BigInteger.prototype.isUnit = function () {
        return false;
    };
    SmallInteger.prototype.isUnit = function () {
        return Math.abs(this.value) === 1;
    };
    NativeBigInt.prototype.isUnit = function () {
        return this.abs().value === BigInt(1);
    }

    BigInteger.prototype.isZero = function () {
        return false;
    };
    SmallInteger.prototype.isZero = function () {
        return this.value === 0;
    };
    NativeBigInt.prototype.isZero = function () {
        return this.value === BigInt(0);
    }

    BigInteger.prototype.isDivisibleBy = function (v) {
        var n = parseValue(v);
        if (n.isZero()) return false;
        if (n.isUnit()) return true;
        if (n.compareAbs(2) === 0) return this.isEven();
        return this.mod(n).isZero();
    };
    NativeBigInt.prototype.isDivisibleBy = SmallInteger.prototype.isDivisibleBy = BigInteger.prototype.isDivisibleBy;

    function isBasicPrime(v) {
        var n = v.abs();
        if (n.isUnit()) return false;
        if (n.equals(2) || n.equals(3) || n.equals(5)) return true;
        if (n.isEven() || n.isDivisibleBy(3) || n.isDivisibleBy(5)) return false;
        if (n.lesser(49)) return true;
        // we don't know if it's prime: let the other functions figure it out
    }

    function millerRabinTest(n, a) {
        var nPrev = n.prev(),
            b = nPrev,
            r = 0,
            d, t, i, x;
        while (b.isEven()) b = b.divide(2), r++;
        next: for (i = 0; i < a.length; i++) {
            if (n.lesser(a[i])) continue;
            x = bigInt(a[i]).modPow(b, n);
            if (x.isUnit() || x.equals(nPrev)) continue;
            for (d = r - 1; d != 0; d--) {
                x = x.square().mod(n);
                if (x.isUnit()) return false;
                if (x.equals(nPrev)) continue next;
            }
            return false;
        }
        return true;
    }

    // Set "strict" to true to force GRH-supported lower bound of 2*log(N)^2
    BigInteger.prototype.isPrime = function (strict) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined) return isPrime;
        var n = this.abs();
        var bits = n.bitLength();
        if (bits <= 64)
            return millerRabinTest(n, [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]);
        var logN = Math.log(2) * bits.toJSNumber();
        var t = Math.ceil((strict === true) ? (2 * Math.pow(logN, 2)) : logN);
        for (var a = [], i = 0; i < t; i++) {
            a.push(bigInt(i + 2));
        }
        return millerRabinTest(n, a);
    };
    NativeBigInt.prototype.isPrime = SmallInteger.prototype.isPrime = BigInteger.prototype.isPrime;

    BigInteger.prototype.isProbablePrime = function (iterations, rng) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined) return isPrime;
        var n = this.abs();
        var t = iterations === undefined ? 5 : iterations;
        for (var a = [], i = 0; i < t; i++) {
            a.push(bigInt.randBetween(2, n.minus(2), rng));
        }
        return millerRabinTest(n, a);
    };
    NativeBigInt.prototype.isProbablePrime = SmallInteger.prototype.isProbablePrime = BigInteger.prototype.isProbablePrime;

    BigInteger.prototype.modInv = function (n) {
        var t = bigInt.zero, newT = bigInt.one, r = parseValue(n), newR = this.abs(), q, lastT, lastR;
        while (!newR.isZero()) {
            q = r.divide(newR);
            lastT = t;
            lastR = r;
            t = newT;
            r = newR;
            newT = lastT.subtract(q.multiply(newT));
            newR = lastR.subtract(q.multiply(newR));
        }
        if (!r.isUnit()) throw new Error(this.toString() + " and " + n.toString() + " are not co-prime");
        if (t.compare(0) === -1) {
            t = t.add(n);
        }
        if (this.isNegative()) {
            return t.negate();
        }
        return t;
    };

    NativeBigInt.prototype.modInv = SmallInteger.prototype.modInv = BigInteger.prototype.modInv;

    BigInteger.prototype.next = function () {
        var value = this.value;
        if (this.sign) {
            return subtractSmall(value, 1, this.sign);
        }
        return new BigInteger(addSmall(value, 1), this.sign);
    };
    SmallInteger.prototype.next = function () {
        var value = this.value;
        if (value + 1 < MAX_INT) return new SmallInteger(value + 1);
        return new BigInteger(MAX_INT_ARR, false);
    };
    NativeBigInt.prototype.next = function () {
        return new NativeBigInt(this.value + BigInt(1));
    }

    BigInteger.prototype.prev = function () {
        var value = this.value;
        if (this.sign) {
            return new BigInteger(addSmall(value, 1), true);
        }
        return subtractSmall(value, 1, this.sign);
    };
    SmallInteger.prototype.prev = function () {
        var value = this.value;
        if (value - 1 > -MAX_INT) return new SmallInteger(value - 1);
        return new BigInteger(MAX_INT_ARR, true);
    };
    NativeBigInt.prototype.prev = function () {
        return new NativeBigInt(this.value - BigInt(1));
    }

    var powersOfTwo = [1];
    while (2 * powersOfTwo[powersOfTwo.length - 1] <= BASE) powersOfTwo.push(2 * powersOfTwo[powersOfTwo.length - 1]);
    var powers2Length = powersOfTwo.length, highestPower2 = powersOfTwo[powers2Length - 1];

    function shift_isSmall(n) {
        return Math.abs(n) <= BASE;
    }

    BigInteger.prototype.shiftLeft = function (v) {
        var n = parseValue(v).toJSNumber();
        if (!shift_isSmall(n)) {
            throw new Error(String(n) + " is too large for shifting.");
        }
        if (n < 0) return this.shiftRight(-n);
        var result = this;
        if (result.isZero()) return result;
        while (n >= powers2Length) {
            result = result.multiply(highestPower2);
            n -= powers2Length - 1;
        }
        return result.multiply(powersOfTwo[n]);
    };
    NativeBigInt.prototype.shiftLeft = SmallInteger.prototype.shiftLeft = BigInteger.prototype.shiftLeft;

    BigInteger.prototype.shiftRight = function (v) {
        var remQuo;
        var n = parseValue(v).toJSNumber();
        if (!shift_isSmall(n)) {
            throw new Error(String(n) + " is too large for shifting.");
        }
        if (n < 0) return this.shiftLeft(-n);
        var result = this;
        while (n >= powers2Length) {
            if (result.isZero() || (result.isNegative() && result.isUnit())) return result;
            remQuo = divModAny(result, highestPower2);
            result = remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
            n -= powers2Length - 1;
        }
        remQuo = divModAny(result, powersOfTwo[n]);
        return remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
    };
    NativeBigInt.prototype.shiftRight = SmallInteger.prototype.shiftRight = BigInteger.prototype.shiftRight;

    function bitwise(x, y, fn) {
        y = parseValue(y);
        var xSign = x.isNegative(), ySign = y.isNegative();
        var xRem = xSign ? x.not() : x,
            yRem = ySign ? y.not() : y;
        var xDigit = 0, yDigit = 0;
        var xDivMod = null, yDivMod = null;
        var result = [];
        while (!xRem.isZero() || !yRem.isZero()) {
            xDivMod = divModAny(xRem, highestPower2);
            xDigit = xDivMod[1].toJSNumber();
            if (xSign) {
                xDigit = highestPower2 - 1 - xDigit; // two's complement for negative numbers
            }

            yDivMod = divModAny(yRem, highestPower2);
            yDigit = yDivMod[1].toJSNumber();
            if (ySign) {
                yDigit = highestPower2 - 1 - yDigit; // two's complement for negative numbers
            }

            xRem = xDivMod[0];
            yRem = yDivMod[0];
            result.push(fn(xDigit, yDigit));
        }
        var sum = fn(xSign ? 1 : 0, ySign ? 1 : 0) !== 0 ? bigInt(-1) : bigInt(0);
        for (var i = result.length - 1; i >= 0; i -= 1) {
            sum = sum.multiply(highestPower2).add(bigInt(result[i]));
        }
        return sum;
    }

    BigInteger.prototype.not = function () {
        return this.negate().prev();
    };
    NativeBigInt.prototype.not = SmallInteger.prototype.not = BigInteger.prototype.not;

    BigInteger.prototype.and = function (n) {
        return bitwise(this, n, function (a, b) { return a & b; });
    };
    NativeBigInt.prototype.and = SmallInteger.prototype.and = BigInteger.prototype.and;

    BigInteger.prototype.or = function (n) {
        return bitwise(this, n, function (a, b) { return a | b; });
    };
    NativeBigInt.prototype.or = SmallInteger.prototype.or = BigInteger.prototype.or;

    BigInteger.prototype.xor = function (n) {
        return bitwise(this, n, function (a, b) { return a ^ b; });
    };
    NativeBigInt.prototype.xor = SmallInteger.prototype.xor = BigInteger.prototype.xor;

    var LOBMASK_I = 1 << 30, LOBMASK_BI = (BASE & -BASE) * (BASE & -BASE) | LOBMASK_I;
    function roughLOB(n) { // get lowestOneBit (rough)
        // SmallInteger: return Min(lowestOneBit(n), 1 << 30)
        // BigInteger: return Min(lowestOneBit(n), 1 << 14) [BASE=1e7]
        var v = n.value,
            x = typeof v === "number" ? v | LOBMASK_I :
                typeof v === "bigint" ? v | BigInt(LOBMASK_I) :
                    v[0] + v[1] * BASE | LOBMASK_BI;
        return x & -x;
    }

    function integerLogarithm(value, base) {
        if (base.compareTo(value) <= 0) {
            var tmp = integerLogarithm(value, base.square(base));
            var p = tmp.p;
            var e = tmp.e;
            var t = p.multiply(base);
            return t.compareTo(value) <= 0 ? { p: t, e: e * 2 + 1 } : { p: p, e: e * 2 };
        }
        return { p: bigInt(1), e: 0 };
    }

    BigInteger.prototype.bitLength = function () {
        var n = this;
        if (n.compareTo(bigInt(0)) < 0) {
            n = n.negate().subtract(bigInt(1));
        }
        if (n.compareTo(bigInt(0)) === 0) {
            return bigInt(0);
        }
        return bigInt(integerLogarithm(n, bigInt(2)).e).add(bigInt(1));
    }
    NativeBigInt.prototype.bitLength = SmallInteger.prototype.bitLength = BigInteger.prototype.bitLength;

    function max(a, b) {
        a = parseValue(a);
        b = parseValue(b);
        return a.greater(b) ? a : b;
    }
    function min(a, b) {
        a = parseValue(a);
        b = parseValue(b);
        return a.lesser(b) ? a : b;
    }
    function gcd(a, b) {
        a = parseValue(a).abs();
        b = parseValue(b).abs();
        if (a.equals(b)) return a;
        if (a.isZero()) return b;
        if (b.isZero()) return a;
        var c = Integer[1], d, t;
        while (a.isEven() && b.isEven()) {
            d = min(roughLOB(a), roughLOB(b));
            a = a.divide(d);
            b = b.divide(d);
            c = c.multiply(d);
        }
        while (a.isEven()) {
            a = a.divide(roughLOB(a));
        }
        do {
            while (b.isEven()) {
                b = b.divide(roughLOB(b));
            }
            if (a.greater(b)) {
                t = b; b = a; a = t;
            }
            b = b.subtract(a);
        } while (!b.isZero());
        return c.isUnit() ? a : a.multiply(c);
    }
    function lcm(a, b) {
        a = parseValue(a).abs();
        b = parseValue(b).abs();
        return a.divide(gcd(a, b)).multiply(b);
    }
    function randBetween(a, b, rng) {
        a = parseValue(a);
        b = parseValue(b);
        var usedRNG = rng || Math.random;
        var low = min(a, b), high = max(a, b);
        var range = high.subtract(low).add(1);
        if (range.isSmall) return low.add(Math.floor(usedRNG() * range));
        var digits = toBase(range, BASE).value;
        var result = [], restricted = true;
        for (var i = 0; i < digits.length; i++) {
            var top = restricted ? digits[i] : BASE;
            var digit = truncate(usedRNG() * top);
            result.push(digit);
            if (digit < top) restricted = false;
        }
        return low.add(Integer.fromArray(result, BASE, false));
    }

    var parseBase = function (text, base, alphabet, caseSensitive) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        text = String(text);
        if (!caseSensitive) {
            text = text.toLowerCase();
            alphabet = alphabet.toLowerCase();
        }
        var length = text.length;
        var i;
        var absBase = Math.abs(base);
        var alphabetValues = {};
        for (i = 0; i < alphabet.length; i++) {
            alphabetValues[alphabet[i]] = i;
        }
        for (i = 0; i < length; i++) {
            var c = text[i];
            if (c === "-") continue;
            if (c in alphabetValues) {
                if (alphabetValues[c] >= absBase) {
                    if (c === "1" && absBase === 1) continue;
                    throw new Error(c + " is not a valid digit in base " + base + ".");
                }
            }
        }
        base = parseValue(base);
        var digits = [];
        var isNegative = text[0] === "-";
        for (i = isNegative ? 1 : 0; i < text.length; i++) {
            var c = text[i];
            if (c in alphabetValues) digits.push(parseValue(alphabetValues[c]));
            else if (c === "<") {
                var start = i;
                do { i++; } while (text[i] !== ">" && i < text.length);
                digits.push(parseValue(text.slice(start + 1, i)));
            }
            else throw new Error(c + " is not a valid character");
        }
        return parseBaseFromArray(digits, base, isNegative);
    };

    function parseBaseFromArray(digits, base, isNegative) {
        var val = Integer[0], pow = Integer[1], i;
        for (i = digits.length - 1; i >= 0; i--) {
            val = val.add(digits[i].times(pow));
            pow = pow.times(base);
        }
        return isNegative ? val.negate() : val;
    }

    function stringify(digit, alphabet) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        if (digit < alphabet.length) {
            return alphabet[digit];
        }
        return "<" + digit + ">";
    }

    function toBase(n, base) {
        base = bigInt(base);
        if (base.isZero()) {
            if (n.isZero()) return { value: [0], isNegative: false };
            throw new Error("Cannot convert nonzero numbers to base 0.");
        }
        if (base.equals(-1)) {
            if (n.isZero()) return { value: [0], isNegative: false };
            if (n.isNegative())
                return {
                    value: [].concat.apply([], Array.apply(null, Array(-n.toJSNumber()))
                        .map(Array.prototype.valueOf, [1, 0])
                    ),
                    isNegative: false
                };

            var arr = Array.apply(null, Array(n.toJSNumber() - 1))
                .map(Array.prototype.valueOf, [0, 1]);
            arr.unshift([1]);
            return {
                value: [].concat.apply([], arr),
                isNegative: false
            };
        }

        var neg = false;
        if (n.isNegative() && base.isPositive()) {
            neg = true;
            n = n.abs();
        }
        if (base.isUnit()) {
            if (n.isZero()) return { value: [0], isNegative: false };

            return {
                value: Array.apply(null, Array(n.toJSNumber()))
                    .map(Number.prototype.valueOf, 1),
                isNegative: neg
            };
        }
        var out = [];
        var left = n, divmod;
        while (left.isNegative() || left.compareAbs(base) >= 0) {
            divmod = left.divmod(base);
            left = divmod.quotient;
            var digit = divmod.remainder;
            if (digit.isNegative()) {
                digit = base.minus(digit).abs();
                left = left.next();
            }
            out.push(digit.toJSNumber());
        }
        out.push(left.toJSNumber());
        return { value: out.reverse(), isNegative: neg };
    }

    function toBaseString(n, base, alphabet) {
        var arr = toBase(n, base);
        return (arr.isNegative ? "-" : "") + arr.value.map(function (x) {
            return stringify(x, alphabet);
        }).join('');
    }

    BigInteger.prototype.toArray = function (radix) {
        return toBase(this, radix);
    };

    SmallInteger.prototype.toArray = function (radix) {
        return toBase(this, radix);
    };

    NativeBigInt.prototype.toArray = function (radix) {
        return toBase(this, radix);
    };

    BigInteger.prototype.toString = function (radix, alphabet) {
        if (radix === undefined) radix = 10;
        if (radix !== 10) return toBaseString(this, radix, alphabet);
        var v = this.value, l = v.length, str = String(v[--l]), zeros = "0000000", digit;
        while (--l >= 0) {
            digit = String(v[l]);
            str += zeros.slice(digit.length) + digit;
        }
        var sign = this.sign ? "-" : "";
        return sign + str;
    };

    SmallInteger.prototype.toString = function (radix, alphabet) {
        if (radix === undefined) radix = 10;
        if (radix != 10) return toBaseString(this, radix, alphabet);
        return String(this.value);
    };

    NativeBigInt.prototype.toString = SmallInteger.prototype.toString;

    NativeBigInt.prototype.toJSON = BigInteger.prototype.toJSON = SmallInteger.prototype.toJSON = function () { return this.toString(); }

    BigInteger.prototype.valueOf = function () {
        return parseInt(this.toString(), 10);
    };
    BigInteger.prototype.toJSNumber = BigInteger.prototype.valueOf;

    SmallInteger.prototype.valueOf = function () {
        return this.value;
    };
    SmallInteger.prototype.toJSNumber = SmallInteger.prototype.valueOf;
    NativeBigInt.prototype.valueOf = NativeBigInt.prototype.toJSNumber = function () {
        return parseInt(this.toString(), 10);
    }

    function parseStringValue(v) {
        if (isPrecise(+v)) {
            var x = +v;
            if (x === truncate(x))
                return supportsNativeBigInt ? new NativeBigInt(BigInt(x)) : new SmallInteger(x);
            throw new Error("Invalid integer: " + v);
        }
        var sign = v[0] === "-";
        if (sign) v = v.slice(1);
        var split = v.split(/e/i);
        if (split.length > 2) throw new Error("Invalid integer: " + split.join("e"));
        if (split.length === 2) {
            var exp = split[1];
            if (exp[0] === "+") exp = exp.slice(1);
            exp = +exp;
            if (exp !== truncate(exp) || !isPrecise(exp)) throw new Error("Invalid integer: " + exp + " is not a valid exponent.");
            var text = split[0];
            var decimalPlace = text.indexOf(".");
            if (decimalPlace >= 0) {
                exp -= text.length - decimalPlace - 1;
                text = text.slice(0, decimalPlace) + text.slice(decimalPlace + 1);
            }
            if (exp < 0) throw new Error("Cannot include negative exponent part for integers");
            text += (new Array(exp + 1)).join("0");
            v = text;
        }
        var isValid = /^([0-9][0-9]*)$/.test(v);
        if (!isValid) throw new Error("Invalid integer: " + v);
        if (supportsNativeBigInt) {
            return new NativeBigInt(BigInt(sign ? "-" + v : v));
        }
        var r = [], max = v.length, l = LOG_BASE, min = max - l;
        while (max > 0) {
            r.push(+v.slice(min, max));
            min -= l;
            if (min < 0) min = 0;
            max -= l;
        }
        trim(r);
        return new BigInteger(r, sign);
    }

    function parseNumberValue(v) {
        if (supportsNativeBigInt) {
            return new NativeBigInt(BigInt(v));
        }
        if (isPrecise(v)) {
            if (v !== truncate(v)) throw new Error(v + " is not an integer.");
            return new SmallInteger(v);
        }
        return parseStringValue(v.toString());
    }

    function parseValue(v) {
        if (typeof v === "number") {
            return parseNumberValue(v);
        }
        if (typeof v === "string") {
            return parseStringValue(v);
        }
        if (typeof v === "bigint") {
            return new NativeBigInt(v);
        }
        return v;
    }
    // Pre-define numbers in range [-999,999]
    for (var i = 0; i < 1000; i++) {
        Integer[i] = parseValue(i);
        if (i > 0) Integer[-i] = parseValue(-i);
    }
    // Backwards compatibility
    Integer.one = Integer[1];
    Integer.zero = Integer[0];
    Integer.minusOne = Integer[-1];
    Integer.max = max;
    Integer.min = min;
    Integer.gcd = gcd;
    Integer.lcm = lcm;
    Integer.isInstance = function (x) { return x instanceof BigInteger || x instanceof SmallInteger || x instanceof NativeBigInt; };
    Integer.randBetween = randBetween;

    Integer.fromArray = function (digits, base, isNegative) {
        return parseBaseFromArray(digits.map(parseValue), parseValue(base || 10), isNegative);
    };

    return Integer;
})();

// Node.js check
if (typeof module !== "undefined" && module.hasOwnProperty("exports")) {
    module.exports = bigInt;
}

//amd check
if (typeof define === "function" && define.amd) {
    define( function () {
        return bigInt;
    });
}

},{}],17:[function(require,module,exports){
(function (Buffer){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */

'use strict'

var base64 = require('base64-js')
var ieee754 = require('ieee754')
var customInspectSymbol =
  (typeof Symbol === 'function' && typeof Symbol.for === 'function')
    ? Symbol.for('nodejs.util.inspect.custom')
    : null

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

var K_MAX_LENGTH = 0x7fffffff
exports.kMaxLength = K_MAX_LENGTH

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport()

if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
    typeof console.error === 'function') {
  console.error(
    'This browser lacks typed array (Uint8Array) support which is required by ' +
    '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
  )
}

function typedArraySupport () {
  // Can typed array instances can be augmented?
  try {
    var arr = new Uint8Array(1)
    var proto = { foo: function () { return 42 } }
    Object.setPrototypeOf(proto, Uint8Array.prototype)
    Object.setPrototypeOf(arr, proto)
    return arr.foo() === 42
  } catch (e) {
    return false
  }
}

Object.defineProperty(Buffer.prototype, 'parent', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.buffer
  }
})

Object.defineProperty(Buffer.prototype, 'offset', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.byteOffset
  }
})

function createBuffer (length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"')
  }
  // Return an augmented `Uint8Array` instance
  var buf = new Uint8Array(length)
  Object.setPrototypeOf(buf, Buffer.prototype)
  return buf
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new TypeError(
        'The "string" argument must be of type string. Received type number'
      )
    }
    return allocUnsafe(arg)
  }
  return from(arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

function from (value, encodingOrOffset, length) {
  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset)
  }

  if (ArrayBuffer.isView(value)) {
    return fromArrayLike(value)
  }

  if (value == null) {
    throw new TypeError(
      'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
      'or Array-like Object. Received type ' + (typeof value)
    )
  }

  if (isInstance(value, ArrayBuffer) ||
      (value && isInstance(value.buffer, ArrayBuffer))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof SharedArrayBuffer !== 'undefined' &&
      (isInstance(value, SharedArrayBuffer) ||
      (value && isInstance(value.buffer, SharedArrayBuffer)))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof value === 'number') {
    throw new TypeError(
      'The "value" argument must not be of type number. Received type number'
    )
  }

  var valueOf = value.valueOf && value.valueOf()
  if (valueOf != null && valueOf !== value) {
    return Buffer.from(valueOf, encodingOrOffset, length)
  }

  var b = fromObject(value)
  if (b) return b

  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
      typeof value[Symbol.toPrimitive] === 'function') {
    return Buffer.from(
      value[Symbol.toPrimitive]('string'), encodingOrOffset, length
    )
  }

  throw new TypeError(
    'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
    'or Array-like Object. Received type ' + (typeof value)
  )
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length)
}

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype)
Object.setPrototypeOf(Buffer, Uint8Array)

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be of type number')
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"')
  }
}

function alloc (size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(size).fill(fill, encoding)
      : createBuffer(size).fill(fill)
  }
  return createBuffer(size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(size, fill, encoding)
}

function allocUnsafe (size) {
  assertSize(size)
  return createBuffer(size < 0 ? 0 : checked(size) | 0)
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(size)
}

function fromString (string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('Unknown encoding: ' + encoding)
  }

  var length = byteLength(string, encoding) | 0
  var buf = createBuffer(length)

  var actual = buf.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    buf = buf.slice(0, actual)
  }

  return buf
}

function fromArrayLike (array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  var buf = createBuffer(length)
  for (var i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255
  }
  return buf
}

function fromArrayBuffer (array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds')
  }

  var buf
  if (byteOffset === undefined && length === undefined) {
    buf = new Uint8Array(array)
  } else if (length === undefined) {
    buf = new Uint8Array(array, byteOffset)
  } else {
    buf = new Uint8Array(array, byteOffset, length)
  }

  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(buf, Buffer.prototype)

  return buf
}

function fromObject (obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    var buf = createBuffer(len)

    if (buf.length === 0) {
      return buf
    }

    obj.copy(buf, 0, 0, len)
    return buf
  }

  if (obj.length !== undefined) {
    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
      return createBuffer(0)
    }
    return fromArrayLike(obj)
  }

  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data)
  }
}

function checked (length) {
  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= K_MAX_LENGTH) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return b != null && b._isBuffer === true &&
    b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
}

Buffer.compare = function compare (a, b) {
  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength)
  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength)
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError(
      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
    )
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (isInstance(buf, Uint8Array)) {
      buf = Buffer.from(buf)
    }
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    throw new TypeError(
      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
      'Received type ' + typeof string
    )
  }

  var len = string.length
  var mustMatch = (arguments.length > 2 && arguments[2] === true)
  if (!mustMatch && len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
        }
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.toLocaleString = Buffer.prototype.toString

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim()
  if (this.length > max) str += ' ... '
  return '<Buffer ' + str + '>'
}
if (customInspectSymbol) {
  Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (isInstance(target, Uint8Array)) {
    target = Buffer.from(target, target.offset, target.byteLength)
  }
  if (!Buffer.isBuffer(target)) {
    throw new TypeError(
      'The "target" argument must be one of type Buffer or Uint8Array. ' +
      'Received type ' + (typeof target)
    )
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset // Coerce to Number.
  if (numberIsNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [val], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  var strLen = string.length

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (numberIsNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset >>> 0
    if (isFinite(length)) {
      length = length >>> 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
        : (firstByte > 0xBF) ? 2
          : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += hexSliceLookupTable[buf[i]]
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + (bytes[i + 1] * 256))
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf = this.subarray(start, end)
  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(newBuf, Buffer.prototype)

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  offset = offset >>> 0
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  byteLength = byteLength >>> 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  this[offset] = (value >>> 8)
  this[offset + 1] = (value & 0xff)
  return offset + 2
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  this[offset + 3] = (value >>> 24)
  this[offset + 2] = (value >>> 16)
  this[offset + 1] = (value >>> 8)
  this[offset] = (value & 0xff)
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  this[offset] = (value >>> 24)
  this[offset + 1] = (value >>> 16)
  this[offset + 2] = (value >>> 8)
  this[offset + 3] = (value & 0xff)
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    var limit = Math.pow(2, (8 * byteLength) - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    var limit = Math.pow(2, (8 * byteLength) - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  this[offset] = (value >>> 8)
  this[offset + 1] = (value & 0xff)
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  this[offset] = (value & 0xff)
  this[offset + 1] = (value >>> 8)
  this[offset + 2] = (value >>> 16)
  this[offset + 3] = (value >>> 24)
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  this[offset] = (value >>> 24)
  this[offset + 1] = (value >>> 16)
  this[offset + 2] = (value >>> 8)
  this[offset + 3] = (value & 0xff)
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  value = +value
  offset = offset >>> 0
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer')
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('Index out of range')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start

  if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
    // Use built-in when available, missing from IE11
    this.copyWithin(targetStart, start, end)
  } else if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (var i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, end),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if ((encoding === 'utf8' && code < 128) ||
          encoding === 'latin1') {
        // Fast path: If `val` fits into a single byte, use that numeric value.
        val = code
      }
    }
  } else if (typeof val === 'number') {
    val = val & 255
  } else if (typeof val === 'boolean') {
    val = Number(val)
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : Buffer.from(val, encoding)
    var len = bytes.length
    if (len === 0) {
      throw new TypeError('The value "' + val +
        '" is invalid for argument "value"')
    }
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node takes equal signs as end of the Base64 encoding
  str = str.split('=')[0]
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = str.trim().replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

// ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
// the `instanceof` check but they should be treated as of that type.
// See: https://github.com/feross/buffer/issues/166
function isInstance (obj, type) {
  return obj instanceof type ||
    (obj != null && obj.constructor != null && obj.constructor.name != null &&
      obj.constructor.name === type.name)
}
function numberIsNaN (obj) {
  // For IE11 support
  return obj !== obj // eslint-disable-line no-self-compare
}

// Create lookup table for `toString('hex')`
// See: https://github.com/feross/buffer/issues/219
var hexSliceLookupTable = (function () {
  var alphabet = '0123456789abcdef'
  var table = new Array(256)
  for (var i = 0; i < 16; ++i) {
    var i16 = i * 16
    for (var j = 0; j < 16; ++j) {
      table[i16 + j] = alphabet[i] + alphabet[j]
    }
  }
  return table
})()

}).call(this,require("buffer").Buffer)
},{"base64-js":15,"buffer":74,"ieee754":18}],18:[function(require,module,exports){
exports.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var nBits = -7
  var i = isLE ? (nBytes - 1) : 0
  var d = isLE ? -1 : 1
  var s = buffer[offset + i]

  i += d

  e = s & ((1 << (-nBits)) - 1)
  s >>= (-nBits)
  nBits += eLen
  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1)
  e >>= (-nBits)
  nBits += mLen
  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen)
    e = e - eBias
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
}

exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
  var i = isLE ? 0 : (nBytes - 1)
  var d = isLE ? 1 : -1
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0

  value = Math.abs(value)

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0
    e = eMax
  } else {
    e = Math.floor(Math.log(value) / Math.LN2)
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--
      c *= 2
    }
    if (e + eBias >= 1) {
      value += rt / c
    } else {
      value += rt * Math.pow(2, 1 - eBias)
    }
    if (value * c >= 2) {
      e++
      c /= 2
    }

    if (e + eBias >= eMax) {
      m = 0
      e = eMax
    } else if (e + eBias >= 1) {
      m = ((value * c) - 1) * Math.pow(2, mLen)
      e = e + eBias
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
      e = 0
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m
  eLen += mLen
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128
}

},{}],19:[function(require,module,exports){
module.exports      = isTypedArray
isTypedArray.strict = isStrictTypedArray
isTypedArray.loose  = isLooseTypedArray

var toString = Object.prototype.toString
var names = {
    '[object Int8Array]': true
  , '[object Int16Array]': true
  , '[object Int32Array]': true
  , '[object Uint8Array]': true
  , '[object Uint8ClampedArray]': true
  , '[object Uint16Array]': true
  , '[object Uint32Array]': true
  , '[object Float32Array]': true
  , '[object Float64Array]': true
}

function isTypedArray(arr) {
  return (
       isStrictTypedArray(arr)
    || isLooseTypedArray(arr)
  )
}

function isStrictTypedArray(arr) {
  return (
       arr instanceof Int8Array
    || arr instanceof Int16Array
    || arr instanceof Int32Array
    || arr instanceof Uint8Array
    || arr instanceof Uint8ClampedArray
    || arr instanceof Uint16Array
    || arr instanceof Uint32Array
    || arr instanceof Float32Array
    || arr instanceof Float64Array
  )
}

function isLooseTypedArray(arr) {
  return names[toString.call(arr)]
}

},{}],20:[function(require,module,exports){
!function(e){function t(e,t){"use strict";var r,a="uint8array",_=t.ready.then(function(){function a(){if(0!==r._sodium_init())throw new Error("libsodium was not correctly initialized.");for(var t=["crypto_aead_chacha20poly1305_decrypt","crypto_aead_chacha20poly1305_decrypt_detached","crypto_aead_chacha20poly1305_encrypt","crypto_aead_chacha20poly1305_encrypt_detached","crypto_aead_chacha20poly1305_ietf_decrypt","crypto_aead_chacha20poly1305_ietf_decrypt_detached","crypto_aead_chacha20poly1305_ietf_encrypt","crypto_aead_chacha20poly1305_ietf_encrypt_detached","crypto_aead_chacha20poly1305_ietf_keygen","crypto_aead_chacha20poly1305_keygen","crypto_aead_xchacha20poly1305_ietf_decrypt","crypto_aead_xchacha20poly1305_ietf_decrypt_detached","crypto_aead_xchacha20poly1305_ietf_encrypt","crypto_aead_xchacha20poly1305_ietf_encrypt_detached","crypto_aead_xchacha20poly1305_ietf_keygen","crypto_auth","crypto_auth_hmacsha256","crypto_auth_hmacsha256_keygen","crypto_auth_hmacsha256_verify","crypto_auth_hmacsha512","crypto_auth_hmacsha512_keygen","crypto_auth_hmacsha512_verify","crypto_auth_keygen","crypto_auth_verify","crypto_box_beforenm","crypto_box_curve25519xchacha20poly1305_keypair","crypto_box_curve25519xchacha20poly1305_seal","crypto_box_curve25519xchacha20poly1305_seal_open","crypto_box_detached","crypto_box_easy","crypto_box_easy_afternm","crypto_box_keypair","crypto_box_open_detached","crypto_box_open_easy","crypto_box_open_easy_afternm","crypto_box_seal","crypto_box_seal_open","crypto_box_seed_keypair","crypto_core_ristretto255_add","crypto_core_ristretto255_from_hash","crypto_core_ristretto255_is_valid_point","crypto_core_ristretto255_random","crypto_core_ristretto255_scalar_add","crypto_core_ristretto255_scalar_complement","crypto_core_ristretto255_scalar_invert","crypto_core_ristretto255_scalar_mul","crypto_core_ristretto255_scalar_negate","crypto_core_ristretto255_scalar_random","crypto_core_ristretto255_scalar_reduce","crypto_core_ristretto255_scalar_sub","crypto_core_ristretto255_sub","crypto_generichash","crypto_generichash_blake2b_salt_personal","crypto_generichash_final","crypto_generichash_init","crypto_generichash_keygen","crypto_generichash_update","crypto_hash","crypto_hash_sha256","crypto_hash_sha512","crypto_kdf_derive_from_key","crypto_kdf_keygen","crypto_kx_client_session_keys","crypto_kx_keypair","crypto_kx_seed_keypair","crypto_kx_server_session_keys","crypto_onetimeauth","crypto_onetimeauth_final","crypto_onetimeauth_init","crypto_onetimeauth_keygen","crypto_onetimeauth_update","crypto_onetimeauth_verify","crypto_pwhash","crypto_pwhash_scryptsalsa208sha256","crypto_pwhash_scryptsalsa208sha256_ll","crypto_pwhash_scryptsalsa208sha256_str","crypto_pwhash_scryptsalsa208sha256_str_verify","crypto_pwhash_str","crypto_pwhash_str_verify","crypto_scalarmult","crypto_scalarmult_base","crypto_scalarmult_ristretto255","crypto_scalarmult_ristretto255_base","crypto_secretbox_detached","crypto_secretbox_easy","crypto_secretbox_keygen","crypto_secretbox_open_detached","crypto_secretbox_open_easy","crypto_secretstream_xchacha20poly1305_init_pull","crypto_secretstream_xchacha20poly1305_init_push","crypto_secretstream_xchacha20poly1305_keygen","crypto_secretstream_xchacha20poly1305_pull","crypto_secretstream_xchacha20poly1305_push","crypto_secretstream_xchacha20poly1305_rekey","crypto_shorthash","crypto_shorthash_keygen","crypto_shorthash_siphashx24","crypto_sign","crypto_sign_detached","crypto_sign_ed25519_pk_to_curve25519","crypto_sign_ed25519_sk_to_curve25519","crypto_sign_ed25519_sk_to_pk","crypto_sign_ed25519_sk_to_seed","crypto_sign_final_create","crypto_sign_final_verify","crypto_sign_init","crypto_sign_keypair","crypto_sign_open","crypto_sign_seed_keypair","crypto_sign_update","crypto_sign_verify_detached","crypto_stream_chacha20","crypto_stream_chacha20_ietf_xor","crypto_stream_chacha20_ietf_xor_ic","crypto_stream_chacha20_keygen","crypto_stream_chacha20_xor","crypto_stream_chacha20_xor_ic","crypto_stream_keygen","crypto_stream_xchacha20_keygen","crypto_stream_xchacha20_xor","crypto_stream_xchacha20_xor_ic","randombytes_buf","randombytes_buf_deterministic","randombytes_close","randombytes_random","randombytes_set_implementation","randombytes_stir","randombytes_uniform","sodium_version_string"],a=[x,E,w,S,T,Y,A,B,K,I,M,L,N,U,O,R,P,C,G,D,X,V,F,H,z,j,q,W,J,Q,Z,$,ee,te,re,ae,_e,ne,se,ce,he,oe,pe,ye,ie,le,ue,ve,de,ge,be,fe,me,ke,xe,Ee,we,Se,Te,Ye,Ae,Be,Ke,Ie,Me,Le,Ne,Ue,Oe,Re,Pe,Ce,Ge,De,Xe,Ve,Fe,He,ze,je,qe,We,Je,Qe,Ze,$e,et,tt,rt,at,_t,nt,st,ct,ht,ot,pt,yt,it,lt,ut,vt,dt,gt,bt,ft,mt,kt,xt,Et,wt,St,Tt,Yt,At,Bt,Kt,It,Mt,Lt,Nt,Ut,Ot,Rt,Pt,Ct,Gt,Dt,Xt],_=0;_<a.length;_++)"function"==typeof r["_"+t[_]]&&(e[t[_]]=a[_]);var n=["SODIUM_LIBRARY_VERSION_MAJOR","SODIUM_LIBRARY_VERSION_MINOR","crypto_aead_chacha20poly1305_ABYTES","crypto_aead_chacha20poly1305_KEYBYTES","crypto_aead_chacha20poly1305_MESSAGEBYTES_MAX","crypto_aead_chacha20poly1305_NPUBBYTES","crypto_aead_chacha20poly1305_NSECBYTES","crypto_aead_chacha20poly1305_ietf_ABYTES","crypto_aead_chacha20poly1305_ietf_KEYBYTES","crypto_aead_chacha20poly1305_ietf_MESSAGEBYTES_MAX","crypto_aead_chacha20poly1305_ietf_NPUBBYTES","crypto_aead_chacha20poly1305_ietf_NSECBYTES","crypto_aead_xchacha20poly1305_ietf_ABYTES","crypto_aead_xchacha20poly1305_ietf_KEYBYTES","crypto_aead_xchacha20poly1305_ietf_MESSAGEBYTES_MAX","crypto_aead_xchacha20poly1305_ietf_NPUBBYTES","crypto_aead_xchacha20poly1305_ietf_NSECBYTES","crypto_auth_BYTES","crypto_auth_KEYBYTES","crypto_auth_hmacsha256_BYTES","crypto_auth_hmacsha256_KEYBYTES","crypto_auth_hmacsha512_BYTES","crypto_auth_hmacsha512_KEYBYTES","crypto_box_BEFORENMBYTES","crypto_box_MACBYTES","crypto_box_MESSAGEBYTES_MAX","crypto_box_NONCEBYTES","crypto_box_PUBLICKEYBYTES","crypto_box_SEALBYTES","crypto_box_SECRETKEYBYTES","crypto_box_SEEDBYTES","crypto_box_curve25519xchacha20poly1305_NONCEBYTES","crypto_box_curve25519xchacha20poly1305_PUBLICKEYBYTES","crypto_box_curve25519xchacha20poly1305_SECRETKEYBYTES","crypto_core_hchacha20_CONSTBYTES","crypto_core_hchacha20_INPUTBYTES","crypto_core_hchacha20_KEYBYTES","crypto_core_hchacha20_OUTPUTBYTES","crypto_core_ristretto255_BYTES","crypto_core_ristretto255_HASHBYTES","crypto_core_ristretto255_NONREDUCEDSCALARBYTES","crypto_core_ristretto255_SCALARBYTES","crypto_generichash_BYTES","crypto_generichash_BYTES_MAX","crypto_generichash_BYTES_MIN","crypto_generichash_KEYBYTES","crypto_generichash_KEYBYTES_MAX","crypto_generichash_KEYBYTES_MIN","crypto_generichash_blake2b_BYTES","crypto_generichash_blake2b_BYTES_MAX","crypto_generichash_blake2b_BYTES_MIN","crypto_generichash_blake2b_KEYBYTES","crypto_generichash_blake2b_KEYBYTES_MAX","crypto_generichash_blake2b_KEYBYTES_MIN","crypto_generichash_blake2b_PERSONALBYTES","crypto_generichash_blake2b_SALTBYTES","crypto_hash_BYTES","crypto_hash_sha256_BYTES","crypto_hash_sha512_BYTES","crypto_kdf_BYTES_MAX","crypto_kdf_BYTES_MIN","crypto_kdf_CONTEXTBYTES","crypto_kdf_KEYBYTES","crypto_kx_PUBLICKEYBYTES","crypto_kx_SECRETKEYBYTES","crypto_kx_SEEDBYTES","crypto_kx_SESSIONKEYBYTES","crypto_onetimeauth_BYTES","crypto_onetimeauth_KEYBYTES","crypto_pwhash_ALG_ARGON2I13","crypto_pwhash_ALG_ARGON2ID13","crypto_pwhash_ALG_DEFAULT","crypto_pwhash_BYTES_MAX","crypto_pwhash_BYTES_MIN","crypto_pwhash_MEMLIMIT_INTERACTIVE","crypto_pwhash_MEMLIMIT_MAX","crypto_pwhash_MEMLIMIT_MIN","crypto_pwhash_MEMLIMIT_MODERATE","crypto_pwhash_MEMLIMIT_SENSITIVE","crypto_pwhash_OPSLIMIT_INTERACTIVE","crypto_pwhash_OPSLIMIT_MAX","crypto_pwhash_OPSLIMIT_MIN","crypto_pwhash_OPSLIMIT_MODERATE","crypto_pwhash_OPSLIMIT_SENSITIVE","crypto_pwhash_PASSWD_MAX","crypto_pwhash_PASSWD_MIN","crypto_pwhash_SALTBYTES","crypto_pwhash_STRBYTES","crypto_pwhash_STR_VERIFY","crypto_pwhash_scryptsalsa208sha256_BYTES_MAX","crypto_pwhash_scryptsalsa208sha256_BYTES_MIN","crypto_pwhash_scryptsalsa208sha256_MEMLIMIT_INTERACTIVE","crypto_pwhash_scryptsalsa208sha256_MEMLIMIT_MAX","crypto_pwhash_scryptsalsa208sha256_MEMLIMIT_MIN","crypto_pwhash_scryptsalsa208sha256_MEMLIMIT_SENSITIVE","crypto_pwhash_scryptsalsa208sha256_OPSLIMIT_INTERACTIVE","crypto_pwhash_scryptsalsa208sha256_OPSLIMIT_MAX","crypto_pwhash_scryptsalsa208sha256_OPSLIMIT_MIN","crypto_pwhash_scryptsalsa208sha256_OPSLIMIT_SENSITIVE","crypto_pwhash_scryptsalsa208sha256_SALTBYTES","crypto_pwhash_scryptsalsa208sha256_STRBYTES","crypto_pwhash_scryptsalsa208sha256_STR_VERIFY","crypto_scalarmult_BYTES","crypto_scalarmult_SCALARBYTES","crypto_scalarmult_ristretto255_BYTES","crypto_scalarmult_ristretto255_SCALARBYTES","crypto_secretbox_KEYBYTES","crypto_secretbox_MACBYTES","crypto_secretbox_MESSAGEBYTES_MAX","crypto_secretbox_NONCEBYTES","crypto_secretstream_xchacha20poly1305_ABYTES","crypto_secretstream_xchacha20poly1305_HEADERBYTES","crypto_secretstream_xchacha20poly1305_KEYBYTES","crypto_secretstream_xchacha20poly1305_MESSAGEBYTES_MAX","crypto_secretstream_xchacha20poly1305_MESSAGESBYTES_MAX","crypto_secretstream_xchacha20poly1305_NPUBBYTES","crypto_secretstream_xchacha20poly1305_TAG_FINAL","crypto_secretstream_xchacha20poly1305_TAG_MESSAGE","crypto_secretstream_xchacha20poly1305_TAG_PUSH","crypto_secretstream_xchacha20poly1305_TAG_REKEY","crypto_shorthash_BYTES","crypto_shorthash_KEYBYTES","crypto_shorthash_siphashx24_BYTES","crypto_shorthash_siphashx24_KEYBYTES","crypto_sign_BYTES","crypto_sign_MESSAGEBYTES_MAX","crypto_sign_PUBLICKEYBYTES","crypto_sign_SECRETKEYBYTES","crypto_sign_SEEDBYTES","crypto_stream_KEYBYTES","crypto_stream_MESSAGEBYTES_MAX","crypto_stream_NONCEBYTES","crypto_stream_chacha20_KEYBYTES","crypto_stream_chacha20_NONCEBYTES","crypto_stream_chacha20_ietf_KEYBYTES","crypto_stream_chacha20_ietf_MESSAGEBYTES_MAX","crypto_stream_chacha20_ietf_NONCEBYTES","crypto_stream_xchacha20_KEYBYTES","crypto_stream_xchacha20_MESSAGEBYTES_MAX","crypto_stream_xchacha20_NONCEBYTES","randombytes_SEEDBYTES"];for(_=0;_<n.length;_++)"function"==typeof(c=r["_"+n[_].toLowerCase()])&&(e[n[_]]=c());var s=["SODIUM_VERSION_STRING","crypto_pwhash_STRPREFIX","crypto_pwhash_scryptsalsa208sha256_STRPREFIX"];for(_=0;_<s.length;_++){var c;"function"==typeof(c=r["_"+s[_].toLowerCase()])&&(e[s[_]]=r.UTF8ToString(c()))}}r=t;try{a();var _=new Uint8Array([98,97,108,108,115]),n=e.randombytes_buf(e.crypto_secretbox_NONCEBYTES),s=e.randombytes_buf(e.crypto_secretbox_KEYBYTES),c=e.crypto_secretbox_easy(_,n,s),h=e.crypto_secretbox_open_easy(c,n,s);if(e.memcmp(_,h))return}catch(e){if(null==r.useBackupModule)throw new Error("Both wasm and asm failed to load"+e)}r.useBackupModule(),a()});function n(e){if("function"==typeof TextEncoder)return(new TextEncoder).encode(e);e=unescape(encodeURIComponent(e));for(var t=new Uint8Array(e.length),r=0,a=e.length;r<a;r++)t[r]=e.charCodeAt(r);return t}function s(e){if("function"==typeof TextDecoder)return new TextDecoder("utf-8",{fatal:!0}).decode(e);var t=Math.ceil(e.length/8192);if(t<=1)try{return decodeURIComponent(escape(String.fromCharCode.apply(null,e)))}catch(e){throw new TypeError("The encoded data was not valid.")}for(var r="",a=0,_=0;_<t;_++){var n=Array.prototype.slice.call(e,8192*_+a,8192*(_+1)+a);if(0!=n.length){var c,h=n.length,o=0;do{var p=n[--h];p>=240?(o=4,c=!0):p>=224?(o=3,c=!0):p>=192?(o=2,c=!0):p<128&&(o=1,c=!0)}while(!c);for(var y=o-(n.length-h),i=0;i<y;i++)a--,n.pop();r+=s(n)}}return r}function c(e){e=k(null,e,"input");for(var t,r,a,_="",n=0;n<e.length;n++)a=87+(r=15&e[n])+(r-10>>8&-39)<<8|87+(t=e[n]>>>4)+(t-10>>8&-39),_+=String.fromCharCode(255&a)+String.fromCharCode(a>>>8);return _}var h={ORIGINAL:1,ORIGINAL_NO_PADDING:3,URLSAFE:5,URLSAFE_NO_PADDING:7};function o(e){if(null==e)return h.URLSAFE_NO_PADDING;if(e!==h.ORIGINAL&&e!==h.ORIGINAL_NO_PADDING&&e!==h.URLSAFE&&e!=h.URLSAFE_NO_PADDING)throw new Error("unsupported base64 variant");return e}function p(e,t){t=o(t),e=k(_,e,"input");var a,_=[],n=0|Math.floor(e.length/3),c=e.length-3*n,h=4*n+(0!==c?0==(2&t)?4:2+(c>>>1):0),p=new u(h+1),y=v(e);return _.push(y),_.push(p.address),0===r._sodium_bin2base64(p.address,p.length,y,e.length,t)&&b(_,"conversion failed"),p.length=h,a=s(p.to_Uint8Array()),g(_),a}function y(e,t){var r=t||a;if(!i(r))throw new Error(r+" output format is not available");if(e instanceof u){if("uint8array"===r)return e.to_Uint8Array();if("text"===r)return s(e.to_Uint8Array());if("hex"===r)return c(e.to_Uint8Array());if("base64"===r)return p(e.to_Uint8Array(),h.URLSAFE_NO_PADDING);throw new Error('What is output format "'+r+'"?')}if("object"==typeof e){for(var _=Object.keys(e),n={},o=0;o<_.length;o++)n[_[o]]=y(e[_[o]],r);return n}if("string"==typeof e)return e;throw new TypeError("Cannot format output")}function i(e){for(var t=["uint8array","text","hex","base64"],r=0;r<t.length;r++)if(t[r]===e)return!0;return!1}function l(e){if(e){if("string"!=typeof e)throw new TypeError("When defined, the output format must be a string");if(!i(e))throw new Error(e+" is not a supported output format")}}function u(e){this.length=e,this.address=d(e)}function v(e){var t=d(e.length);return r.HEAPU8.set(e,t),t}function d(e){var t=r._malloc(e);if(0===t)throw{message:"_malloc() failed",length:e};return t}function g(e){if(e)for(var t=0;t<e.length;t++)a=e[t],r._free(a);var a}function b(e,t){throw g(e),new Error(t)}function f(e,t){throw g(e),new TypeError(t)}function m(e,t,r){null==t&&f(e,r+" cannot be null or undefined")}function k(e,t,r){return m(e,t,r),t instanceof Uint8Array?t:"string"==typeof t?n(t):void f(e,"unsupported input type for "+r)}function x(e,t,a,_,n,s){var c=[];l(s);var h=null;null!=e&&(h=v(e=k(c,e,"secret_nonce")),e.length,c.push(h)),t=k(c,t,"ciphertext");var o,p=r._crypto_aead_chacha20poly1305_abytes(),i=t.length;i<p&&f(c,"ciphertext is too short"),o=v(t),c.push(o);var d=null,m=0;null!=a&&(d=v(a=k(c,a,"additional_data")),m=a.length,c.push(d)),_=k(c,_,"public_nonce");var x,E=0|r._crypto_aead_chacha20poly1305_npubbytes();_.length!==E&&f(c,"invalid public_nonce length"),x=v(_),c.push(x),n=k(c,n,"key");var w,S=0|r._crypto_aead_chacha20poly1305_keybytes();n.length!==S&&f(c,"invalid key length"),w=v(n),c.push(w);var T=new u(i-r._crypto_aead_chacha20poly1305_abytes()|0),Y=T.address;if(c.push(Y),0===r._crypto_aead_chacha20poly1305_decrypt(Y,null,h,o,i,0,d,m,0,x,w)){var A=y(T,s);return g(c),A}b(c,"ciphertext cannot be decrypted using that key")}function E(e,t,a,_,n,s,c){var h=[];l(c);var o=null;null!=e&&(o=v(e=k(h,e,"secret_nonce")),e.length,h.push(o));var p=v(t=k(h,t,"ciphertext")),i=t.length;h.push(p),a=k(h,a,"mac");var d,m=0|r._crypto_box_macbytes();a.length!==m&&f(h,"invalid mac length"),d=v(a),h.push(d);var x=null,E=0;null!=_&&(x=v(_=k(h,_,"additional_data")),E=_.length,h.push(x)),n=k(h,n,"public_nonce");var w,S=0|r._crypto_aead_chacha20poly1305_npubbytes();n.length!==S&&f(h,"invalid public_nonce length"),w=v(n),h.push(w),s=k(h,s,"key");var T,Y=0|r._crypto_aead_chacha20poly1305_keybytes();s.length!==Y&&f(h,"invalid key length"),T=v(s),h.push(T);var A=new u(0|i),B=A.address;if(h.push(B),0===r._crypto_aead_chacha20poly1305_decrypt_detached(B,o,p,i,0,d,x,E,0,w,T)){var K=y(A,c);return g(h),K}b(h,"ciphertext cannot be decrypted using that key")}function w(e,t,a,_,n,s){var c=[];l(s);var h=v(e=k(c,e,"message")),o=e.length;c.push(h);var p=null,i=0;null!=t&&(p=v(t=k(c,t,"additional_data")),i=t.length,c.push(p));var d=null;null!=a&&(d=v(a=k(c,a,"secret_nonce")),a.length,c.push(d)),_=k(c,_,"public_nonce");var m,x=0|r._crypto_aead_chacha20poly1305_npubbytes();_.length!==x&&f(c,"invalid public_nonce length"),m=v(_),c.push(m),n=k(c,n,"key");var E,w=0|r._crypto_aead_chacha20poly1305_keybytes();n.length!==w&&f(c,"invalid key length"),E=v(n),c.push(E);var S=new u(o+r._crypto_aead_chacha20poly1305_abytes()|0),T=S.address;if(c.push(T),0===r._crypto_aead_chacha20poly1305_encrypt(T,null,h,o,0,p,i,0,d,m,E)){var Y=y(S,s);return g(c),Y}b(c,"invalid usage")}function S(e,t,a,_,n,s){var c=[];l(s);var h=v(e=k(c,e,"message")),o=e.length;c.push(h);var p=null,i=0;null!=t&&(p=v(t=k(c,t,"additional_data")),i=t.length,c.push(p));var d=null;null!=a&&(d=v(a=k(c,a,"secret_nonce")),a.length,c.push(d)),_=k(c,_,"public_nonce");var m,x=0|r._crypto_aead_chacha20poly1305_npubbytes();_.length!==x&&f(c,"invalid public_nonce length"),m=v(_),c.push(m),n=k(c,n,"key");var E,w=0|r._crypto_aead_chacha20poly1305_keybytes();n.length!==w&&f(c,"invalid key length"),E=v(n),c.push(E);var S=new u(0|o),T=S.address;c.push(T);var Y=new u(0|r._crypto_aead_chacha20poly1305_abytes()),A=Y.address;if(c.push(A),0===r._crypto_aead_chacha20poly1305_encrypt_detached(T,A,null,h,o,0,p,i,0,d,m,E)){var B=y({ciphertext:S,mac:Y},s);return g(c),B}b(c,"invalid usage")}function T(e,t,a,_,n,s){var c=[];l(s);var h=null;null!=e&&(h=v(e=k(c,e,"secret_nonce")),e.length,c.push(h)),t=k(c,t,"ciphertext");var o,p=r._crypto_aead_chacha20poly1305_ietf_abytes(),i=t.length;i<p&&f(c,"ciphertext is too short"),o=v(t),c.push(o);var d=null,m=0;null!=a&&(d=v(a=k(c,a,"additional_data")),m=a.length,c.push(d)),_=k(c,_,"public_nonce");var x,E=0|r._crypto_aead_chacha20poly1305_ietf_npubbytes();_.length!==E&&f(c,"invalid public_nonce length"),x=v(_),c.push(x),n=k(c,n,"key");var w,S=0|r._crypto_aead_chacha20poly1305_ietf_keybytes();n.length!==S&&f(c,"invalid key length"),w=v(n),c.push(w);var T=new u(i-r._crypto_aead_chacha20poly1305_ietf_abytes()|0),Y=T.address;if(c.push(Y),0===r._crypto_aead_chacha20poly1305_ietf_decrypt(Y,null,h,o,i,0,d,m,0,x,w)){var A=y(T,s);return g(c),A}b(c,"ciphertext cannot be decrypted using that key")}function Y(e,t,a,_,n,s,c){var h=[];l(c);var o=null;null!=e&&(o=v(e=k(h,e,"secret_nonce")),e.length,h.push(o));var p=v(t=k(h,t,"ciphertext")),i=t.length;h.push(p),a=k(h,a,"mac");var d,m=0|r._crypto_box_macbytes();a.length!==m&&f(h,"invalid mac length"),d=v(a),h.push(d);var x=null,E=0;null!=_&&(x=v(_=k(h,_,"additional_data")),E=_.length,h.push(x)),n=k(h,n,"public_nonce");var w,S=0|r._crypto_aead_chacha20poly1305_ietf_npubbytes();n.length!==S&&f(h,"invalid public_nonce length"),w=v(n),h.push(w),s=k(h,s,"key");var T,Y=0|r._crypto_aead_chacha20poly1305_ietf_keybytes();s.length!==Y&&f(h,"invalid key length"),T=v(s),h.push(T);var A=new u(0|i),B=A.address;if(h.push(B),0===r._crypto_aead_chacha20poly1305_ietf_decrypt_detached(B,o,p,i,0,d,x,E,0,w,T)){var K=y(A,c);return g(h),K}b(h,"ciphertext cannot be decrypted using that key")}function A(e,t,a,_,n,s){var c=[];l(s);var h=v(e=k(c,e,"message")),o=e.length;c.push(h);var p=null,i=0;null!=t&&(p=v(t=k(c,t,"additional_data")),i=t.length,c.push(p));var d=null;null!=a&&(d=v(a=k(c,a,"secret_nonce")),a.length,c.push(d)),_=k(c,_,"public_nonce");var m,x=0|r._crypto_aead_chacha20poly1305_ietf_npubbytes();_.length!==x&&f(c,"invalid public_nonce length"),m=v(_),c.push(m),n=k(c,n,"key");var E,w=0|r._crypto_aead_chacha20poly1305_ietf_keybytes();n.length!==w&&f(c,"invalid key length"),E=v(n),c.push(E);var S=new u(o+r._crypto_aead_chacha20poly1305_ietf_abytes()|0),T=S.address;if(c.push(T),0===r._crypto_aead_chacha20poly1305_ietf_encrypt(T,null,h,o,0,p,i,0,d,m,E)){var Y=y(S,s);return g(c),Y}b(c,"invalid usage")}function B(e,t,a,_,n,s){var c=[];l(s);var h=v(e=k(c,e,"message")),o=e.length;c.push(h);var p=null,i=0;null!=t&&(p=v(t=k(c,t,"additional_data")),i=t.length,c.push(p));var d=null;null!=a&&(d=v(a=k(c,a,"secret_nonce")),a.length,c.push(d)),_=k(c,_,"public_nonce");var m,x=0|r._crypto_aead_chacha20poly1305_ietf_npubbytes();_.length!==x&&f(c,"invalid public_nonce length"),m=v(_),c.push(m),n=k(c,n,"key");var E,w=0|r._crypto_aead_chacha20poly1305_ietf_keybytes();n.length!==w&&f(c,"invalid key length"),E=v(n),c.push(E);var S=new u(0|o),T=S.address;c.push(T);var Y=new u(0|r._crypto_aead_chacha20poly1305_ietf_abytes()),A=Y.address;if(c.push(A),0===r._crypto_aead_chacha20poly1305_ietf_encrypt_detached(T,A,null,h,o,0,p,i,0,d,m,E)){var B=y({ciphertext:S,mac:Y},s);return g(c),B}b(c,"invalid usage")}function K(e){var t=[];l(e);var a=new u(0|r._crypto_aead_chacha20poly1305_ietf_keybytes()),_=a.address;t.push(_),r._crypto_aead_chacha20poly1305_ietf_keygen(_);var n=y(a,e);return g(t),n}function I(e){var t=[];l(e);var a=new u(0|r._crypto_aead_chacha20poly1305_keybytes()),_=a.address;t.push(_),r._crypto_aead_chacha20poly1305_keygen(_);var n=y(a,e);return g(t),n}function M(e,t,a,_,n,s){var c=[];l(s);var h=null;null!=e&&(h=v(e=k(c,e,"secret_nonce")),e.length,c.push(h)),t=k(c,t,"ciphertext");var o,p=r._crypto_aead_xchacha20poly1305_ietf_abytes(),i=t.length;i<p&&f(c,"ciphertext is too short"),o=v(t),c.push(o);var d=null,m=0;null!=a&&(d=v(a=k(c,a,"additional_data")),m=a.length,c.push(d)),_=k(c,_,"public_nonce");var x,E=0|r._crypto_aead_xchacha20poly1305_ietf_npubbytes();_.length!==E&&f(c,"invalid public_nonce length"),x=v(_),c.push(x),n=k(c,n,"key");var w,S=0|r._crypto_aead_xchacha20poly1305_ietf_keybytes();n.length!==S&&f(c,"invalid key length"),w=v(n),c.push(w);var T=new u(i-r._crypto_aead_xchacha20poly1305_ietf_abytes()|0),Y=T.address;if(c.push(Y),0===r._crypto_aead_xchacha20poly1305_ietf_decrypt(Y,null,h,o,i,0,d,m,0,x,w)){var A=y(T,s);return g(c),A}b(c,"ciphertext cannot be decrypted using that key")}function L(e,t,a,_,n,s,c){var h=[];l(c);var o=null;null!=e&&(o=v(e=k(h,e,"secret_nonce")),e.length,h.push(o));var p=v(t=k(h,t,"ciphertext")),i=t.length;h.push(p),a=k(h,a,"mac");var d,m=0|r._crypto_box_macbytes();a.length!==m&&f(h,"invalid mac length"),d=v(a),h.push(d);var x=null,E=0;null!=_&&(x=v(_=k(h,_,"additional_data")),E=_.length,h.push(x)),n=k(h,n,"public_nonce");var w,S=0|r._crypto_aead_xchacha20poly1305_ietf_npubbytes();n.length!==S&&f(h,"invalid public_nonce length"),w=v(n),h.push(w),s=k(h,s,"key");var T,Y=0|r._crypto_aead_xchacha20poly1305_ietf_keybytes();s.length!==Y&&f(h,"invalid key length"),T=v(s),h.push(T);var A=new u(0|i),B=A.address;if(h.push(B),0===r._crypto_aead_xchacha20poly1305_ietf_decrypt_detached(B,o,p,i,0,d,x,E,0,w,T)){var K=y(A,c);return g(h),K}b(h,"ciphertext cannot be decrypted using that key")}function N(e,t,a,_,n,s){var c=[];l(s);var h=v(e=k(c,e,"message")),o=e.length;c.push(h);var p=null,i=0;null!=t&&(p=v(t=k(c,t,"additional_data")),i=t.length,c.push(p));var d=null;null!=a&&(d=v(a=k(c,a,"secret_nonce")),a.length,c.push(d)),_=k(c,_,"public_nonce");var m,x=0|r._crypto_aead_xchacha20poly1305_ietf_npubbytes();_.length!==x&&f(c,"invalid public_nonce length"),m=v(_),c.push(m),n=k(c,n,"key");var E,w=0|r._crypto_aead_xchacha20poly1305_ietf_keybytes();n.length!==w&&f(c,"invalid key length"),E=v(n),c.push(E);var S=new u(o+r._crypto_aead_xchacha20poly1305_ietf_abytes()|0),T=S.address;if(c.push(T),0===r._crypto_aead_xchacha20poly1305_ietf_encrypt(T,null,h,o,0,p,i,0,d,m,E)){var Y=y(S,s);return g(c),Y}b(c,"invalid usage")}function U(e,t,a,_,n,s){var c=[];l(s);var h=v(e=k(c,e,"message")),o=e.length;c.push(h);var p=null,i=0;null!=t&&(p=v(t=k(c,t,"additional_data")),i=t.length,c.push(p));var d=null;null!=a&&(d=v(a=k(c,a,"secret_nonce")),a.length,c.push(d)),_=k(c,_,"public_nonce");var m,x=0|r._crypto_aead_xchacha20poly1305_ietf_npubbytes();_.length!==x&&f(c,"invalid public_nonce length"),m=v(_),c.push(m),n=k(c,n,"key");var E,w=0|r._crypto_aead_xchacha20poly1305_ietf_keybytes();n.length!==w&&f(c,"invalid key length"),E=v(n),c.push(E);var S=new u(0|o),T=S.address;c.push(T);var Y=new u(0|r._crypto_aead_xchacha20poly1305_ietf_abytes()),A=Y.address;if(c.push(A),0===r._crypto_aead_xchacha20poly1305_ietf_encrypt_detached(T,A,null,h,o,0,p,i,0,d,m,E)){var B=y({ciphertext:S,mac:Y},s);return g(c),B}b(c,"invalid usage")}function O(e){var t=[];l(e);var a=new u(0|r._crypto_aead_xchacha20poly1305_ietf_keybytes()),_=a.address;t.push(_),r._crypto_aead_xchacha20poly1305_ietf_keygen(_);var n=y(a,e);return g(t),n}function R(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"key");var c,h=0|r._crypto_auth_keybytes();t.length!==h&&f(_,"invalid key length"),c=v(t),_.push(c);var o=new u(0|r._crypto_auth_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_auth(p,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function P(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"key");var c,h=0|r._crypto_auth_hmacsha256_keybytes();t.length!==h&&f(_,"invalid key length"),c=v(t),_.push(c);var o=new u(0|r._crypto_auth_hmacsha256_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_auth_hmacsha256(p,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function C(e){var t=[];l(e);var a=new u(0|r._crypto_auth_hmacsha256_keybytes()),_=a.address;t.push(_),r._crypto_auth_hmacsha256_keygen(_);var n=y(a,e);return g(t),n}function G(e,t,a){var _=[];e=k(_,e,"tag");var n,s=0|r._crypto_auth_hmacsha256_bytes();e.length!==s&&f(_,"invalid tag length"),n=v(e),_.push(n);var c=v(t=k(_,t,"message")),h=t.length;_.push(c),a=k(_,a,"key");var o,p=0|r._crypto_auth_hmacsha256_keybytes();a.length!==p&&f(_,"invalid key length"),o=v(a),_.push(o);var y=0==(0|r._crypto_auth_hmacsha256_verify(n,c,h,0,o));return g(_),y}function D(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"key");var c,h=0|r._crypto_auth_hmacsha512_keybytes();t.length!==h&&f(_,"invalid key length"),c=v(t),_.push(c);var o=new u(0|r._crypto_auth_hmacsha512_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_auth_hmacsha512(p,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function X(e){var t=[];l(e);var a=new u(0|r._crypto_auth_hmacsha512_keybytes()),_=a.address;t.push(_),r._crypto_auth_hmacsha512_keygen(_);var n=y(a,e);return g(t),n}function V(e,t,a){var _=[];e=k(_,e,"tag");var n,s=0|r._crypto_auth_hmacsha512_bytes();e.length!==s&&f(_,"invalid tag length"),n=v(e),_.push(n);var c=v(t=k(_,t,"message")),h=t.length;_.push(c),a=k(_,a,"key");var o,p=0|r._crypto_auth_hmacsha512_keybytes();a.length!==p&&f(_,"invalid key length"),o=v(a),_.push(o);var y=0==(0|r._crypto_auth_hmacsha512_verify(n,c,h,0,o));return g(_),y}function F(e){var t=[];l(e);var a=new u(0|r._crypto_auth_keybytes()),_=a.address;t.push(_),r._crypto_auth_keygen(_);var n=y(a,e);return g(t),n}function H(e,t,a){var _=[];e=k(_,e,"tag");var n,s=0|r._crypto_auth_bytes();e.length!==s&&f(_,"invalid tag length"),n=v(e),_.push(n);var c=v(t=k(_,t,"message")),h=t.length;_.push(c),a=k(_,a,"key");var o,p=0|r._crypto_auth_keybytes();a.length!==p&&f(_,"invalid key length"),o=v(a),_.push(o);var y=0==(0|r._crypto_auth_verify(n,c,h,0,o));return g(_),y}function z(e,t,a){var _=[];l(a),e=k(_,e,"publicKey");var n,s=0|r._crypto_box_publickeybytes();e.length!==s&&f(_,"invalid publicKey length"),n=v(e),_.push(n),t=k(_,t,"privateKey");var c,h=0|r._crypto_box_secretkeybytes();t.length!==h&&f(_,"invalid privateKey length"),c=v(t),_.push(c);var o=new u(0|r._crypto_box_beforenmbytes()),p=o.address;if(_.push(p),0==(0|r._crypto_box_beforenm(p,n,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function j(e){var t=[];l(e);var a=new u(0|r._crypto_box_curve25519xchacha20poly1305_publickeybytes()),_=a.address;t.push(_);var n=new u(0|r._crypto_box_curve25519xchacha20poly1305_secretkeybytes()),s=n.address;t.push(s),r._crypto_box_curve25519xchacha20poly1305_keypair(_,s);var c=y({publicKey:a,privateKey:n,keyType:"curve25519"},e);return g(t),c}function q(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"publicKey");var c,h=0|r._crypto_box_curve25519xchacha20poly1305_publickeybytes();t.length!==h&&f(_,"invalid publicKey length"),c=v(t),_.push(c);var o=new u(s+r._crypto_box_curve25519xchacha20poly1305_sealbytes()|0),p=o.address;_.push(p),r._crypto_box_curve25519xchacha20poly1305_seal(p,n,s,0,c);var i=y(o,a);return g(_),i}function W(e,t,a,_){var n=[];l(_),e=k(n,e,"ciphertext");var s,c=r._crypto_box_curve25519xchacha20poly1305_sealbytes(),h=e.length;h<c&&f(n,"ciphertext is too short"),s=v(e),n.push(s),t=k(n,t,"publicKey");var o,p=0|r._crypto_box_curve25519xchacha20poly1305_publickeybytes();t.length!==p&&f(n,"invalid publicKey length"),o=v(t),n.push(o),a=k(n,a,"secretKey");var i,d=0|r._crypto_box_curve25519xchacha20poly1305_secretkeybytes();a.length!==d&&f(n,"invalid secretKey length"),i=v(a),n.push(i);var b=new u(h-r._crypto_box_curve25519xchacha20poly1305_sealbytes()|0),m=b.address;n.push(m),r._crypto_box_curve25519xchacha20poly1305_seal_open(m,s,h,0,o,i);var x=y(b,_);return g(n),x}function J(e,t,a,_,n){var s=[];l(n);var c=v(e=k(s,e,"message")),h=e.length;s.push(c),t=k(s,t,"nonce");var o,p=0|r._crypto_box_noncebytes();t.length!==p&&f(s,"invalid nonce length"),o=v(t),s.push(o),a=k(s,a,"publicKey");var i,d=0|r._crypto_box_publickeybytes();a.length!==d&&f(s,"invalid publicKey length"),i=v(a),s.push(i),_=k(s,_,"privateKey");var m,x=0|r._crypto_box_secretkeybytes();_.length!==x&&f(s,"invalid privateKey length"),m=v(_),s.push(m);var E=new u(0|h),w=E.address;s.push(w);var S=new u(0|r._crypto_box_macbytes()),T=S.address;if(s.push(T),0==(0|r._crypto_box_detached(w,T,c,h,0,o,i,m))){var Y=y({ciphertext:E,mac:S},n);return g(s),Y}b(s,"invalid usage")}function Q(e,t,a,_,n){var s=[];l(n);var c=v(e=k(s,e,"message")),h=e.length;s.push(c),t=k(s,t,"nonce");var o,p=0|r._crypto_box_noncebytes();t.length!==p&&f(s,"invalid nonce length"),o=v(t),s.push(o),a=k(s,a,"publicKey");var i,d=0|r._crypto_box_publickeybytes();a.length!==d&&f(s,"invalid publicKey length"),i=v(a),s.push(i),_=k(s,_,"privateKey");var m,x=0|r._crypto_box_secretkeybytes();_.length!==x&&f(s,"invalid privateKey length"),m=v(_),s.push(m);var E=new u(h+r._crypto_box_macbytes()|0),w=E.address;if(s.push(w),0==(0|r._crypto_box_easy(w,c,h,0,o,i,m))){var S=y(E,n);return g(s),S}b(s,"invalid usage")}function Z(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"message")),c=e.length;n.push(s),t=k(n,t,"nonce");var h,o=0|r._crypto_box_noncebytes();t.length!==o&&f(n,"invalid nonce length"),h=v(t),n.push(h),a=k(n,a,"sharedKey");var p,i=0|r._crypto_box_beforenmbytes();a.length!==i&&f(n,"invalid sharedKey length"),p=v(a),n.push(p);var d=new u(c+r._crypto_box_macbytes()|0),m=d.address;if(n.push(m),0==(0|r._crypto_box_easy_afternm(m,s,c,0,h,p))){var x=y(d,_);return g(n),x}b(n,"invalid usage")}function $(e){var t=[];l(e);var a=new u(0|r._crypto_box_publickeybytes()),_=a.address;t.push(_);var n=new u(0|r._crypto_box_secretkeybytes()),s=n.address;if(t.push(s),0==(0|r._crypto_box_keypair(_,s))){var c={publicKey:y(a,e),privateKey:y(n,e),keyType:"x25519"};return g(t),c}b(t,"internal error")}function ee(e,t,a,_,n,s){var c=[];l(s);var h=v(e=k(c,e,"ciphertext")),o=e.length;c.push(h),t=k(c,t,"mac");var p,i=0|r._crypto_box_macbytes();t.length!==i&&f(c,"invalid mac length"),p=v(t),c.push(p),a=k(c,a,"nonce");var d,m=0|r._crypto_box_noncebytes();a.length!==m&&f(c,"invalid nonce length"),d=v(a),c.push(d),_=k(c,_,"publicKey");var x,E=0|r._crypto_box_publickeybytes();_.length!==E&&f(c,"invalid publicKey length"),x=v(_),c.push(x),n=k(c,n,"privateKey");var w,S=0|r._crypto_box_secretkeybytes();n.length!==S&&f(c,"invalid privateKey length"),w=v(n),c.push(w);var T=new u(0|o),Y=T.address;if(c.push(Y),0==(0|r._crypto_box_open_detached(Y,h,p,o,0,d,x,w))){var A=y(T,s);return g(c),A}b(c,"incorrect key pair for the given ciphertext")}function te(e,t,a,_,n){var s=[];l(n),e=k(s,e,"ciphertext");var c,h=r._crypto_box_macbytes(),o=e.length;o<h&&f(s,"ciphertext is too short"),c=v(e),s.push(c),t=k(s,t,"nonce");var p,i=0|r._crypto_box_noncebytes();t.length!==i&&f(s,"invalid nonce length"),p=v(t),s.push(p),a=k(s,a,"publicKey");var d,m=0|r._crypto_box_publickeybytes();a.length!==m&&f(s,"invalid publicKey length"),d=v(a),s.push(d),_=k(s,_,"privateKey");var x,E=0|r._crypto_box_secretkeybytes();_.length!==E&&f(s,"invalid privateKey length"),x=v(_),s.push(x);var w=new u(o-r._crypto_box_macbytes()|0),S=w.address;if(s.push(S),0==(0|r._crypto_box_open_easy(S,c,o,0,p,d,x))){var T=y(w,n);return g(s),T}b(s,"incorrect key pair for the given ciphertext")}function re(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"ciphertext")),c=e.length;n.push(s),t=k(n,t,"nonce");var h,o=0|r._crypto_box_noncebytes();t.length!==o&&f(n,"invalid nonce length"),h=v(t),n.push(h),a=k(n,a,"sharedKey");var p,i=0|r._crypto_box_beforenmbytes();a.length!==i&&f(n,"invalid sharedKey length"),p=v(a),n.push(p);var d=new u(c-r._crypto_box_macbytes()|0),m=d.address;if(n.push(m),0==(0|r._crypto_box_open_easy_afternm(m,s,c,0,h,p))){var x=y(d,_);return g(n),x}b(n,"incorrect secret key for the given ciphertext")}function ae(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"publicKey");var c,h=0|r._crypto_box_publickeybytes();t.length!==h&&f(_,"invalid publicKey length"),c=v(t),_.push(c);var o=new u(s+r._crypto_box_sealbytes()|0),p=o.address;if(_.push(p),0==(0|r._crypto_box_seal(p,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function _e(e,t,a,_){var n=[];l(_),e=k(n,e,"ciphertext");var s,c=r._crypto_box_sealbytes(),h=e.length;h<c&&f(n,"ciphertext is too short"),s=v(e),n.push(s),t=k(n,t,"publicKey");var o,p=0|r._crypto_box_publickeybytes();t.length!==p&&f(n,"invalid publicKey length"),o=v(t),n.push(o),a=k(n,a,"privateKey");var i,d=0|r._crypto_box_secretkeybytes();a.length!==d&&f(n,"invalid privateKey length"),i=v(a),n.push(i);var m=new u(h-r._crypto_box_sealbytes()|0),x=m.address;if(n.push(x),0==(0|r._crypto_box_seal_open(x,s,h,0,o,i))){var E=y(m,_);return g(n),E}b(n,"incorrect key pair for the given ciphertext")}function ne(e,t){var a=[];l(t),e=k(a,e,"seed");var _,n=0|r._crypto_box_seedbytes();e.length!==n&&f(a,"invalid seed length"),_=v(e),a.push(_);var s=new u(0|r._crypto_box_publickeybytes()),c=s.address;a.push(c);var h=new u(0|r._crypto_box_secretkeybytes()),o=h.address;if(a.push(o),0==(0|r._crypto_box_seed_keypair(c,o,_))){var p={publicKey:y(s,t),privateKey:y(h,t),keyType:"x25519"};return g(a),p}b(a,"invalid usage")}function se(e,t,a){var _=[];l(a),e=k(_,e,"p");var n,s=0|r._crypto_core_ristretto255_bytes();e.length!==s&&f(_,"invalid p length"),n=v(e),_.push(n),t=k(_,t,"q");var c,h=0|r._crypto_core_ristretto255_bytes();t.length!==h&&f(_,"invalid q length"),c=v(t),_.push(c);var o=new u(0|r._crypto_core_ristretto255_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_core_ristretto255_add(p,n,c))){var i=y(o,a);return g(_),i}b(_,"inputs is invalid element")}function ce(e,t){var a=[];l(t);var _=v(e=k(a,e,"r"));e.length,a.push(_);var n=new u(0|r._crypto_core_ristretto255_bytes()),s=n.address;if(a.push(s),0==(0|r._crypto_core_ristretto255_from_hash(s,_))){var c=y(n,t);return g(a),c}b(a,"invalid usage")}function he(e,t){var a=[];l(t);var _=v(e=k(a,e,"point"));e.length,a.push(_);var n=1==(0|r._crypto_core_ristretto255_is_valid_point(_));return g(a),n}function oe(e){var t=[];l(e);var a=new u(0|r._crypto_core_ristretto255_bytes()),_=a.address;t.push(_),r._crypto_core_ristretto255_random(_);var n=y(a,e);return g(t),n}function pe(e,t,a){var _=[];l(a),e=k(_,e,"x");var n,s=0|r._crypto_core_ristretto255_scalarbytes();e.length!==s&&f(_,"invalid x length"),n=v(e),_.push(n),t=k(_,t,"y");var c,h=0|r._crypto_core_ristretto255_scalarbytes();t.length!==h&&f(_,"invalid y length"),c=v(t),_.push(c);var o=new u(0|r._crypto_core_ristretto255_scalarbytes()),p=o.address;_.push(p),r._crypto_core_ristretto255_scalar_add(p,n,c);var i=y(o,a);return g(_),i}function ye(e,t){var a=[];l(t);var _=v(e=k(a,e,"s"));e.length,a.push(_);var n=new u(0|r._crypto_core_ristretto255_scalarbytes()),s=n.address;a.push(s),r._crypto_core_ristretto255_scalar_complement(s,_);var c=y(n,t);return g(a),c}function ie(e,t){var a=[];l(t);var _=v(e=k(a,e,"s"));e.length,a.push(_);var n=new u(0|r._crypto_core_ristretto255_scalarbytes()),s=n.address;if(a.push(s),0==(0|r._crypto_core_ristretto255_scalar_invert(s,_))){var c=y(n,t);return g(a),c}b(a,"invalid reciprocate")}function le(e,t,a){var _=[];l(a),e=k(_,e,"x");var n,s=0|r._crypto_core_ristretto255_scalarbytes();e.length!==s&&f(_,"invalid x length"),n=v(e),_.push(n),t=k(_,t,"y");var c,h=0|r._crypto_core_ristretto255_scalarbytes();t.length!==h&&f(_,"invalid y length"),c=v(t),_.push(c);var o=new u(0|r._crypto_core_ristretto255_scalarbytes()),p=o.address;_.push(p),r._crypto_core_ristretto255_scalar_mul(p,n,c);var i=y(o,a);return g(_),i}function ue(e,t){var a=[];l(t);var _=v(e=k(a,e,"s"));e.length,a.push(_);var n=new u(0|r._crypto_core_ristretto255_scalarbytes()),s=n.address;a.push(s),r._crypto_core_ristretto255_scalar_negate(s,_);var c=y(n,t);return g(a),c}function ve(e){var t=[];l(e);var a=new u(0|r._crypto_core_ristretto255_scalarbytes()),_=a.address;t.push(_),r._crypto_core_ristretto255_random(_);var n=y(a,e);return g(t),n}function de(e,t){var a=[];l(t);var _=v(e=k(a,e,"sample"));e.length,a.push(_);var n=new u(0|r._crypto_core_ristretto255_scalarbytes()),s=n.address;a.push(s),r._crypto_core_ristretto255_scalar_reduce(s,_);var c=y(n,t);return g(a),c}function ge(e,t,a){var _=[];l(a),e=k(_,e,"x");var n,s=0|r._crypto_core_ristretto255_scalarbytes();e.length!==s&&f(_,"invalid x length"),n=v(e),_.push(n),t=k(_,t,"y");var c,h=0|r._crypto_core_ristretto255_scalarbytes();t.length!==h&&f(_,"invalid y length"),c=v(t),_.push(c);var o=new u(0|r._crypto_core_ristretto255_scalarbytes()),p=o.address;_.push(p),r._crypto_core_ristretto255_scalar_sub(p,n,c);var i=y(o,a);return g(_),i}function be(e,t,a){var _=[];l(a),e=k(_,e,"p");var n,s=0|r._crypto_core_ristretto255_bytes();e.length!==s&&f(_,"invalid p length"),n=v(e),_.push(n),t=k(_,t,"q");var c,h=0|r._crypto_core_ristretto255_bytes();t.length!==h&&f(_,"invalid q length"),c=v(t),_.push(c);var o=new u(0|r._crypto_core_ristretto255_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_core_ristretto255_sub(p,n,c))){var i=y(o,a);return g(_),i}b(_,"inputs is invalid element")}function fe(e,t,a,_){var n=[];l(_),m(n,e,"hash_length"),("number"!=typeof e||(0|e)!==e||e<0)&&f(n,"hash_length must be an unsigned integer");var s=v(t=k(n,t,"message")),c=t.length;n.push(s);var h=null,o=0;null!=a&&(h=v(a=k(n,a,"key")),o=a.length,n.push(h));var p=new u(e|=0),i=p.address;if(n.push(i),0==(0|r._crypto_generichash(i,e,s,c,0,h,o))){var d=y(p,_);return g(n),d}b(n,"invalid usage")}function me(e,t,a,_,n){var s=[];l(n),m(s,e,"subkey_len"),("number"!=typeof e||(0|e)!==e||e<0)&&f(s,"subkey_len must be an unsigned integer");var c=null,h=0;null!=t&&(c=v(t=k(s,t,"key")),h=t.length,s.push(c)),a=k(s,a,"id");var o,p=0|r._crypto_generichash_blake2b_saltbytes();a.length!==p&&f(s,"invalid id length"),o=v(a),s.push(o),_=k(s,_,"ctx");var i,d=0|r._crypto_generichash_blake2b_personalbytes();_.length!==d&&f(s,"invalid ctx length"),i=v(_),s.push(i);var x=new u(0|e),E=x.address;if(s.push(E),0==(0|r._crypto_generichash_blake2b_salt_personal(E,e,null,0,0,c,h,o,i))){var w=y(x,n);return g(s),w}b(s,"invalid usage")}function ke(e,t,a){var _=[];l(a),m(_,e,"state_address"),m(_,t,"hash_length"),("number"!=typeof t||(0|t)!==t||t<0)&&f(_,"hash_length must be an unsigned integer");var n=new u(t|=0),s=n.address;if(_.push(s),0==(0|r._crypto_generichash_final(e,s,t))){var c=(r._free(e),y(n,a));return g(_),c}b(_,"invalid usage")}function xe(e,t,a){var _=[];l(a);var n=null,s=0;null!=e&&(n=v(e=k(_,e,"key")),s=e.length,_.push(n)),m(_,t,"hash_length"),("number"!=typeof t||(0|t)!==t||t<0)&&f(_,"hash_length must be an unsigned integer");var c=new u(357).address;if(0==(0|r._crypto_generichash_init(c,n,s,t))){var h=c;return g(_),h}b(_,"invalid usage")}function Ee(e){var t=[];l(e);var a=new u(0|r._crypto_generichash_keybytes()),_=a.address;t.push(_),r._crypto_generichash_keygen(_);var n=y(a,e);return g(t),n}function we(e,t,a){var _=[];l(a),m(_,e,"state_address");var n=v(t=k(_,t,"message_chunk")),s=t.length;_.push(n),0!=(0|r._crypto_generichash_update(e,n,s))&&b(_,"invalid usage"),g(_)}function Se(e,t){var a=[];l(t);var _=v(e=k(a,e,"message")),n=e.length;a.push(_);var s=new u(0|r._crypto_hash_bytes()),c=s.address;if(a.push(c),0==(0|r._crypto_hash(c,_,n,0))){var h=y(s,t);return g(a),h}b(a,"invalid usage")}function Te(e,t){var a=[];l(t);var _=v(e=k(a,e,"message")),n=e.length;a.push(_);var s=new u(0|r._crypto_hash_sha256_bytes()),c=s.address;if(a.push(c),0==(0|r._crypto_hash_sha256(c,_,n,0))){var h=y(s,t);return g(a),h}b(a,"invalid usage")}function Ye(e,t){var a=[];l(t);var _=v(e=k(a,e,"message")),n=e.length;a.push(_);var s=new u(0|r._crypto_hash_sha512_bytes()),c=s.address;if(a.push(c),0==(0|r._crypto_hash_sha512(c,_,n,0))){var h=y(s,t);return g(a),h}b(a,"invalid usage")}function Ae(e,t,a,_,s){var c=[];l(s),m(c,e,"subkey_len"),("number"!=typeof e||(0|e)!==e||e<0)&&f(c,"subkey_len must be an unsigned integer"),m(c,t,"subkey_id"),("number"!=typeof t||(0|t)!==t||t<0)&&f(c,"subkey_id must be an unsigned integer"),"string"!=typeof a&&f(c,"ctx must be a string");var h=v(a=n(a+"\0"));a.length,c.push(h),_=k(c,_,"key");var o,p=0|r._crypto_kdf_keybytes();_.length!==p&&f(c,"invalid key length"),o=v(_),c.push(o);var i=new u(0|e),d=i.address;c.push(d),r._crypto_kdf_derive_from_key(d,e,t,t>>>24>>>8,h,o);var b=y(i,s);return g(c),b}function Be(e){var t=[];l(e);var a=new u(0|r._crypto_kdf_keybytes()),_=a.address;t.push(_),r._crypto_kdf_keygen(_);var n=y(a,e);return g(t),n}function Ke(e,t,a,_){var n=[];l(_),e=k(n,e,"clientPublicKey");var s,c=0|r._crypto_kx_publickeybytes();e.length!==c&&f(n,"invalid clientPublicKey length"),s=v(e),n.push(s),t=k(n,t,"clientSecretKey");var h,o=0|r._crypto_kx_secretkeybytes();t.length!==o&&f(n,"invalid clientSecretKey length"),h=v(t),n.push(h),a=k(n,a,"serverPublicKey");var p,i=0|r._crypto_kx_publickeybytes();a.length!==i&&f(n,"invalid serverPublicKey length"),p=v(a),n.push(p);var d=new u(0|r._crypto_kx_sessionkeybytes()),m=d.address;n.push(m);var x=new u(0|r._crypto_kx_sessionkeybytes()),E=x.address;if(n.push(E),0==(0|r._crypto_kx_client_session_keys(m,E,s,h,p))){var w=y({sharedRx:d,sharedTx:x},_);return g(n),w}b(n,"invalid usage")}function Ie(e){var t=[];l(e);var a=new u(0|r._crypto_kx_publickeybytes()),_=a.address;t.push(_);var n=new u(0|r._crypto_kx_secretkeybytes()),s=n.address;if(t.push(s),0==(0|r._crypto_kx_keypair(_,s))){var c={publicKey:y(a,e),privateKey:y(n,e),keyType:"x25519"};return g(t),c}b(t,"internal error")}function Me(e,t){var a=[];l(t),e=k(a,e,"seed");var _,n=0|r._crypto_kx_seedbytes();e.length!==n&&f(a,"invalid seed length"),_=v(e),a.push(_);var s=new u(0|r._crypto_kx_publickeybytes()),c=s.address;a.push(c);var h=new u(0|r._crypto_kx_secretkeybytes()),o=h.address;if(a.push(o),0==(0|r._crypto_kx_seed_keypair(c,o,_))){var p={publicKey:y(s,t),privateKey:y(h,t),keyType:"x25519"};return g(a),p}b(a,"internal error")}function Le(e,t,a,_){var n=[];l(_),e=k(n,e,"serverPublicKey");var s,c=0|r._crypto_kx_publickeybytes();e.length!==c&&f(n,"invalid serverPublicKey length"),s=v(e),n.push(s),t=k(n,t,"serverSecretKey");var h,o=0|r._crypto_kx_secretkeybytes();t.length!==o&&f(n,"invalid serverSecretKey length"),h=v(t),n.push(h),a=k(n,a,"clientPublicKey");var p,i=0|r._crypto_kx_publickeybytes();a.length!==i&&f(n,"invalid clientPublicKey length"),p=v(a),n.push(p);var d=new u(0|r._crypto_kx_sessionkeybytes()),m=d.address;n.push(m);var x=new u(0|r._crypto_kx_sessionkeybytes()),E=x.address;if(n.push(E),0==(0|r._crypto_kx_server_session_keys(m,E,s,h,p))){var w=y({sharedRx:d,sharedTx:x},_);return g(n),w}b(n,"invalid usage")}function Ne(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"key");var c,h=0|r._crypto_onetimeauth_keybytes();t.length!==h&&f(_,"invalid key length"),c=v(t),_.push(c);var o=new u(0|r._crypto_onetimeauth_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_onetimeauth(p,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function Ue(e,t){var a=[];l(t),m(a,e,"state_address");var _=new u(0|r._crypto_onetimeauth_bytes()),n=_.address;if(a.push(n),0==(0|r._crypto_onetimeauth_final(e,n))){var s=(r._free(e),y(_,t));return g(a),s}b(a,"invalid usage")}function Oe(e,t){var a=[];l(t);var _=null;null!=e&&(_=v(e=k(a,e,"key")),e.length,a.push(_));var n=new u(144).address;if(0==(0|r._crypto_onetimeauth_init(n,_))){var s=n;return g(a),s}b(a,"invalid usage")}function Re(e){var t=[];l(e);var a=new u(0|r._crypto_onetimeauth_keybytes()),_=a.address;t.push(_),r._crypto_onetimeauth_keygen(_);var n=y(a,e);return g(t),n}function Pe(e,t,a){var _=[];l(a),m(_,e,"state_address");var n=v(t=k(_,t,"message_chunk")),s=t.length;_.push(n),0!=(0|r._crypto_onetimeauth_update(e,n,s))&&b(_,"invalid usage"),g(_)}function Ce(e,t,a){var _=[];e=k(_,e,"hash");var n,s=0|r._crypto_onetimeauth_bytes();e.length!==s&&f(_,"invalid hash length"),n=v(e),_.push(n);var c=v(t=k(_,t,"message")),h=t.length;_.push(c),a=k(_,a,"key");var o,p=0|r._crypto_onetimeauth_keybytes();a.length!==p&&f(_,"invalid key length"),o=v(a),_.push(o);var y=0==(0|r._crypto_onetimeauth_verify(n,c,h,0,o));return g(_),y}function Ge(e,t,a,_,n,s,c){var h=[];l(c),m(h,e,"keyLength"),("number"!=typeof e||(0|e)!==e||e<0)&&f(h,"keyLength must be an unsigned integer");var o=v(t=k(h,t,"password")),p=t.length;h.push(o),a=k(h,a,"salt");var i,d=0|r._crypto_pwhash_saltbytes();a.length!==d&&f(h,"invalid salt length"),i=v(a),h.push(i),m(h,_,"opsLimit"),("number"!=typeof _||(0|_)!==_||_<0)&&f(h,"opsLimit must be an unsigned integer"),m(h,n,"memLimit"),("number"!=typeof n||(0|n)!==n||n<0)&&f(h,"memLimit must be an unsigned integer"),m(h,s,"algorithm"),("number"!=typeof s||(0|s)!==s||s<0)&&f(h,"algorithm must be an unsigned integer");var x=new u(0|e),E=x.address;if(h.push(E),0==(0|r._crypto_pwhash(E,e,0,o,p,0,i,_,0,n,s))){var w=y(x,c);return g(h),w}b(h,"invalid usage")}function De(e,t,a,_,n,s){var c=[];l(s),m(c,e,"keyLength"),("number"!=typeof e||(0|e)!==e||e<0)&&f(c,"keyLength must be an unsigned integer");var h=v(t=k(c,t,"password")),o=t.length;c.push(h),a=k(c,a,"salt");var p,i=0|r._crypto_pwhash_scryptsalsa208sha256_saltbytes();a.length!==i&&f(c,"invalid salt length"),p=v(a),c.push(p),m(c,_,"opsLimit"),("number"!=typeof _||(0|_)!==_||_<0)&&f(c,"opsLimit must be an unsigned integer"),m(c,n,"memLimit"),("number"!=typeof n||(0|n)!==n||n<0)&&f(c,"memLimit must be an unsigned integer");var d=new u(0|e),x=d.address;if(c.push(x),0==(0|r._crypto_pwhash_scryptsalsa208sha256(x,e,0,h,o,0,p,_,0,n))){var E=y(d,s);return g(c),E}b(c,"invalid usage")}function Xe(e,t,a,_,n,s,c){var h=[];l(c);var o=v(e=k(h,e,"password")),p=e.length;h.push(o);var i=v(t=k(h,t,"salt")),d=t.length;h.push(i),m(h,a,"opsLimit"),("number"!=typeof a||(0|a)!==a||a<0)&&f(h,"opsLimit must be an unsigned integer"),m(h,_,"r"),("number"!=typeof _||(0|_)!==_||_<0)&&f(h,"r must be an unsigned integer"),m(h,n,"p"),("number"!=typeof n||(0|n)!==n||n<0)&&f(h,"p must be an unsigned integer"),m(h,s,"keyLength"),("number"!=typeof s||(0|s)!==s||s<0)&&f(h,"keyLength must be an unsigned integer");var x=new u(0|s),E=x.address;if(h.push(E),0==(0|r._crypto_pwhash_scryptsalsa208sha256_ll(o,p,i,d,a,0,_,n,E,s))){var w=y(x,c);return g(h),w}b(h,"invalid usage")}function Ve(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"password")),c=e.length;n.push(s),m(n,t,"opsLimit"),("number"!=typeof t||(0|t)!==t||t<0)&&f(n,"opsLimit must be an unsigned integer"),m(n,a,"memLimit"),("number"!=typeof a||(0|a)!==a||a<0)&&f(n,"memLimit must be an unsigned integer");var h=new u(0|r._crypto_pwhash_scryptsalsa208sha256_strbytes()).address;if(n.push(h),0==(0|r._crypto_pwhash_scryptsalsa208sha256_str(h,s,c,0,t,0,a))){var o=r.UTF8ToString(h);return g(n),o}b(n,"invalid usage")}function Fe(e,t,a){var _=[];l(a),"string"!=typeof e&&f(_,"hashed_password must be a string");var s=v(e=n(e+"\0"));e.length,_.push(s);var c=v(t=k(_,t,"password")),h=t.length;_.push(c);var o=0==(0|r._crypto_pwhash_scryptsalsa208sha256_str_verify(s,c,h,0));return g(_),o}function He(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"password")),c=e.length;n.push(s),m(n,t,"opsLimit"),("number"!=typeof t||(0|t)!==t||t<0)&&f(n,"opsLimit must be an unsigned integer"),m(n,a,"memLimit"),("number"!=typeof a||(0|a)!==a||a<0)&&f(n,"memLimit must be an unsigned integer");var h=new u(0|r._crypto_pwhash_strbytes()).address;if(n.push(h),0==(0|r._crypto_pwhash_str(h,s,c,0,t,0,a))){var o=r.UTF8ToString(h);return g(n),o}b(n,"invalid usage")}function ze(e,t,a){var _=[];l(a),"string"!=typeof e&&f(_,"hashed_password must be a string");var s=v(e=n(e+"\0"));e.length,_.push(s);var c=v(t=k(_,t,"password")),h=t.length;_.push(c);var o=0==(0|r._crypto_pwhash_str_verify(s,c,h,0));return g(_),o}function je(e,t,a){var _=[];l(a),e=k(_,e,"privateKey");var n,s=0|r._crypto_scalarmult_scalarbytes();e.length!==s&&f(_,"invalid privateKey length"),n=v(e),_.push(n),t=k(_,t,"publicKey");var c,h=0|r._crypto_scalarmult_scalarbytes();t.length!==h&&f(_,"invalid publicKey length"),c=v(t),_.push(c);var o=new u(0|r._crypto_scalarmult_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_scalarmult(p,n,c))){var i=y(o,a);return g(_),i}b(_,"weak public key")}function qe(e,t){var a=[];l(t),e=k(a,e,"privateKey");var _,n=0|r._crypto_scalarmult_scalarbytes();e.length!==n&&f(a,"invalid privateKey length"),_=v(e),a.push(_);var s=new u(0|r._crypto_scalarmult_scalarbytes()),c=s.address;if(a.push(c),0==(0|r._crypto_scalarmult_base(c,_))){var h=y(s,t);return g(a),h}b(a,"insecure scalar")}function We(e,t,a){var _=[];l(a),e=k(_,e,"scalar");var n,s=0|r._crypto_scalarmult_ristretto255_scalarbytes();e.length!==s&&f(_,"invalid scalar length"),n=v(e),_.push(n),t=k(_,t,"privateKey");var c,h=0|r._crypto_scalarmult_ristretto255_bytes();t.length!==h&&f(_,"invalid privateKey length"),c=v(t),_.push(c);var o=new u(0|r._crypto_scalarmult_ristretto255_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_scalarmult_ristretto255(p,n,c))){var i=y(o,a);return g(_),i}b(_,"input is zero element")}function Je(e,t){var a=[];l(t);var _=v(e=k(a,e,"scalar"));e.length,a.push(_);var n=new u(0|r._crypto_core_ristretto255_bytes()),s=n.address;if(a.push(s),0==(0|r._crypto_scalarmult_ristretto255_base(s,_))){var c=y(n,t);return g(a),c}b(a,"scalar is 0")}function Qe(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"message")),c=e.length;n.push(s),t=k(n,t,"nonce");var h,o=0|r._crypto_secretbox_noncebytes();t.length!==o&&f(n,"invalid nonce length"),h=v(t),n.push(h),a=k(n,a,"key");var p,i=0|r._crypto_secretbox_keybytes();a.length!==i&&f(n,"invalid key length"),p=v(a),n.push(p);var d=new u(0|c),m=d.address;n.push(m);var x=new u(0|r._crypto_secretbox_macbytes()),E=x.address;if(n.push(E),0==(0|r._crypto_secretbox_detached(m,E,s,c,0,h,p))){var w=y({mac:x,cipher:d},_);return g(n),w}b(n,"invalid usage")}function Ze(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"message")),c=e.length;n.push(s),t=k(n,t,"nonce");var h,o=0|r._crypto_secretbox_noncebytes();t.length!==o&&f(n,"invalid nonce length"),h=v(t),n.push(h),a=k(n,a,"key");var p,i=0|r._crypto_secretbox_keybytes();a.length!==i&&f(n,"invalid key length"),p=v(a),n.push(p);var d=new u(c+r._crypto_secretbox_macbytes()|0),m=d.address;if(n.push(m),0==(0|r._crypto_secretbox_easy(m,s,c,0,h,p))){var x=y(d,_);return g(n),x}b(n,"invalid usage")}function $e(e){var t=[];l(e);var a=new u(0|r._crypto_secretbox_keybytes()),_=a.address;t.push(_),r._crypto_secretbox_keygen(_);var n=y(a,e);return g(t),n}function et(e,t,a,_,n){var s=[];l(n);var c=v(e=k(s,e,"ciphertext")),h=e.length;s.push(c),t=k(s,t,"mac");var o,p=0|r._crypto_secretbox_macbytes();t.length!==p&&f(s,"invalid mac length"),o=v(t),s.push(o),a=k(s,a,"nonce");var i,d=0|r._crypto_secretbox_noncebytes();a.length!==d&&f(s,"invalid nonce length"),i=v(a),s.push(i),_=k(s,_,"key");var m,x=0|r._crypto_secretbox_keybytes();_.length!==x&&f(s,"invalid key length"),m=v(_),s.push(m);var E=new u(0|h),w=E.address;if(s.push(w),0==(0|r._crypto_secretbox_open_detached(w,c,o,h,0,i,m))){var S=y(E,n);return g(s),S}b(s,"wrong secret key for the given ciphertext")}function tt(e,t,a,_){var n=[];l(_),e=k(n,e,"ciphertext");var s,c=r._crypto_secretbox_macbytes(),h=e.length;h<c&&f(n,"ciphertext is too short"),s=v(e),n.push(s),t=k(n,t,"nonce");var o,p=0|r._crypto_secretbox_noncebytes();t.length!==p&&f(n,"invalid nonce length"),o=v(t),n.push(o),a=k(n,a,"key");var i,d=0|r._crypto_secretbox_keybytes();a.length!==d&&f(n,"invalid key length"),i=v(a),n.push(i);var m=new u(h-r._crypto_secretbox_macbytes()|0),x=m.address;if(n.push(x),0==(0|r._crypto_secretbox_open_easy(x,s,h,0,o,i))){var E=y(m,_);return g(n),E}b(n,"wrong secret key for the given ciphertext")}function rt(e,t,a){var _=[];l(a),e=k(_,e,"header");var n,s=0|r._crypto_secretstream_xchacha20poly1305_headerbytes();e.length!==s&&f(_,"invalid header length"),n=v(e),_.push(n),t=k(_,t,"key");var c,h=0|r._crypto_secretstream_xchacha20poly1305_keybytes();t.length!==h&&f(_,"invalid key length"),c=v(t),_.push(c);var o=new u(52).address;if(0==(0|r._crypto_secretstream_xchacha20poly1305_init_pull(o,n,c))){var p=o;return g(_),p}b(_,"invalid usage")}function at(e,t){var a=[];l(t),e=k(a,e,"key");var _,n=0|r._crypto_secretstream_xchacha20poly1305_keybytes();e.length!==n&&f(a,"invalid key length"),_=v(e),a.push(_);var s=new u(52).address,c=new u(0|r._crypto_secretstream_xchacha20poly1305_headerbytes()),h=c.address;if(a.push(h),0==(0|r._crypto_secretstream_xchacha20poly1305_init_push(s,h,_))){var o={state:s,header:y(c,t)};return g(a),o}b(a,"invalid usage")}function _t(e){var t=[];l(e);var a=new u(0|r._crypto_secretstream_xchacha20poly1305_keybytes()),_=a.address;t.push(_),r._crypto_secretstream_xchacha20poly1305_keygen(_);var n=y(a,e);return g(t),n}function nt(e,t,a,_){var n=[];l(_),m(n,e,"state_address"),t=k(n,t,"cipher");var s,c=r._crypto_secretstream_xchacha20poly1305_abytes(),h=t.length;h<c&&f(n,"cipher is too short"),s=v(t),n.push(s);var o=null,p=0;null!=a&&(o=v(a=k(n,a,"ad")),p=a.length,n.push(o));var i=new u(h-r._crypto_secretstream_xchacha20poly1305_abytes()|0),b=i.address;n.push(b);var x,E=(x=d(1),n.push(x),(E=0===r._crypto_secretstream_xchacha20poly1305_pull(e,b,0,x,s,h,0,o,p)&&{tag:r.HEAPU8[x],message:i})&&{message:y(E.message,_),tag:E.tag});return g(n),E}function st(e,t,a,_,n){var s=[];l(n),m(s,e,"state_address");var c=v(t=k(s,t,"message_chunk")),h=t.length;s.push(c);var o=null,p=0;null!=a&&(o=v(a=k(s,a,"ad")),p=a.length,s.push(o)),m(s,_,"tag"),("number"!=typeof _||(0|_)!==_||_<0)&&f(s,"tag must be an unsigned integer");var i=new u(h+r._crypto_secretstream_xchacha20poly1305_abytes()|0),d=i.address;if(s.push(d),0==(0|r._crypto_secretstream_xchacha20poly1305_push(e,d,0,c,h,0,o,p,0,_))){var x=y(i,n);return g(s),x}b(s,"invalid usage")}function ct(e,t){var a=[];return l(t),m(a,e,"state_address"),r._crypto_secretstream_xchacha20poly1305_rekey(e),g(a),!0}function ht(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"key");var c,h=0|r._crypto_shorthash_keybytes();t.length!==h&&f(_,"invalid key length"),c=v(t),_.push(c);var o=new u(0|r._crypto_shorthash_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_shorthash(p,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function ot(e){var t=[];l(e);var a=new u(0|r._crypto_shorthash_keybytes()),_=a.address;t.push(_),r._crypto_shorthash_keygen(_);var n=y(a,e);return g(t),n}function pt(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"key");var c,h=0|r._crypto_shorthash_siphashx24_keybytes();t.length!==h&&f(_,"invalid key length"),c=v(t),_.push(c);var o=new u(0|r._crypto_shorthash_siphashx24_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_shorthash_siphashx24(p,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function yt(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"privateKey");var c,h=0|r._crypto_sign_secretkeybytes();t.length!==h&&f(_,"invalid privateKey length"),c=v(t),_.push(c);var o=new u(e.length+r._crypto_sign_bytes()|0),p=o.address;if(_.push(p),0==(0|r._crypto_sign(p,null,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function it(e,t,a){var _=[];l(a);var n=v(e=k(_,e,"message")),s=e.length;_.push(n),t=k(_,t,"privateKey");var c,h=0|r._crypto_sign_secretkeybytes();t.length!==h&&f(_,"invalid privateKey length"),c=v(t),_.push(c);var o=new u(0|r._crypto_sign_bytes()),p=o.address;if(_.push(p),0==(0|r._crypto_sign_detached(p,null,n,s,0,c))){var i=y(o,a);return g(_),i}b(_,"invalid usage")}function lt(e,t){var a=[];l(t),e=k(a,e,"edPk");var _,n=0|r._crypto_sign_publickeybytes();e.length!==n&&f(a,"invalid edPk length"),_=v(e),a.push(_);var s=new u(0|r._crypto_scalarmult_scalarbytes()),c=s.address;if(a.push(c),0==(0|r._crypto_sign_ed25519_pk_to_curve25519(c,_))){var h=y(s,t);return g(a),h}b(a,"invalid key")}function ut(e,t){var a=[];l(t),e=k(a,e,"edSk");var _,n=0|r._crypto_sign_secretkeybytes();e.length!==n&&f(a,"invalid edSk length"),_=v(e),a.push(_);var s=new u(0|r._crypto_scalarmult_scalarbytes()),c=s.address;if(a.push(c),0==(0|r._crypto_sign_ed25519_sk_to_curve25519(c,_))){var h=y(s,t);return g(a),h}b(a,"invalid key")}function vt(e,t){var a=[];l(t),e=k(a,e,"privateKey");var _,n=0|r._crypto_sign_secretkeybytes();e.length!==n&&f(a,"invalid privateKey length"),_=v(e),a.push(_);var s=new u(0|r._crypto_sign_publickeybytes()),c=s.address;if(a.push(c),0==(0|r._crypto_sign_ed25519_sk_to_pk(c,_))){var h=y(s,t);return g(a),h}b(a,"invalid key")}function dt(e,t){var a=[];l(t),e=k(a,e,"privateKey");var _,n=0|r._crypto_sign_secretkeybytes();e.length!==n&&f(a,"invalid privateKey length"),_=v(e),a.push(_);var s=new u(0|r._crypto_sign_seedbytes()),c=s.address;if(a.push(c),0==(0|r._crypto_sign_ed25519_sk_to_seed(c,_))){var h=y(s,t);return g(a),h}b(a,"invalid key")}function gt(e,t,a){var _=[];l(a),m(_,e,"state_address"),t=k(_,t,"privateKey");var n,s=0|r._crypto_sign_secretkeybytes();t.length!==s&&f(_,"invalid privateKey length"),n=v(t),_.push(n);var c=new u(0|r._crypto_sign_bytes()),h=c.address;if(_.push(h),0==(0|r._crypto_sign_final_create(e,h,null,n))){var o=(r._free(e),y(c,a));return g(_),o}b(_,"invalid usage")}function bt(e,t,a,_){var n=[];l(_),m(n,e,"state_address"),t=k(n,t,"signature");var s,c=0|r._crypto_sign_bytes();t.length!==c&&f(n,"invalid signature length"),s=v(t),n.push(s),a=k(n,a,"publicKey");var h,o=0|r._crypto_sign_publickeybytes();a.length!==o&&f(n,"invalid publicKey length"),h=v(a),n.push(h);var p=0==(0|r._crypto_sign_final_verify(e,s,h));return g(n),p}function ft(e){var t=[];l(e);var a=new u(208).address;if(0==(0|r._crypto_sign_init(a))){var _=a;return g(t),_}b(t,"internal error")}function mt(e){var t=[];l(e);var a=new u(0|r._crypto_sign_publickeybytes()),_=a.address;t.push(_);var n=new u(0|r._crypto_sign_secretkeybytes()),s=n.address;if(t.push(s),0==(0|r._crypto_sign_keypair(_,s))){var c={publicKey:y(a,e),privateKey:y(n,e),keyType:"ed25519"};return g(t),c}b(t,"internal error")}function kt(e,t,a){var _=[];l(a),e=k(_,e,"signedMessage");var n,s=r._crypto_sign_bytes(),c=e.length;c<s&&f(_,"signedMessage is too short"),n=v(e),_.push(n),t=k(_,t,"publicKey");var h,o=0|r._crypto_sign_publickeybytes();t.length!==o&&f(_,"invalid publicKey length"),h=v(t),_.push(h);var p=new u(c-r._crypto_sign_bytes()|0),i=p.address;if(_.push(i),0==(0|r._crypto_sign_open(i,null,n,c,0,h))){var d=y(p,a);return g(_),d}b(_,"incorrect signature for the given public key")}function xt(e,t){var a=[];l(t),e=k(a,e,"seed");var _,n=0|r._crypto_sign_seedbytes();e.length!==n&&f(a,"invalid seed length"),_=v(e),a.push(_);var s=new u(0|r._crypto_sign_publickeybytes()),c=s.address;a.push(c);var h=new u(0|r._crypto_sign_secretkeybytes()),o=h.address;if(a.push(o),0==(0|r._crypto_sign_seed_keypair(c,o,_))){var p={publicKey:y(s,t),privateKey:y(h,t),keyType:"ed25519"};return g(a),p}b(a,"invalid usage")}function Et(e,t,a){var _=[];l(a),m(_,e,"state_address");var n=v(t=k(_,t,"message_chunk")),s=t.length;_.push(n),0!=(0|r._crypto_sign_update(e,n,s))&&b(_,"invalid usage"),g(_)}function wt(e,t,a){var _=[];e=k(_,e,"signature");var n,s=0|r._crypto_sign_bytes();e.length!==s&&f(_,"invalid signature length"),n=v(e),_.push(n);var c=v(t=k(_,t,"message")),h=t.length;_.push(c),a=k(_,a,"publicKey");var o,p=0|r._crypto_sign_publickeybytes();a.length!==p&&f(_,"invalid publicKey length"),o=v(a),_.push(o);var y=0==(0|r._crypto_sign_verify_detached(n,c,h,0,o));return g(_),y}function St(e,t,a,_){var n=[];l(_),m(n,e,"outLength"),("number"!=typeof e||(0|e)!==e||e<0)&&f(n,"outLength must be an unsigned integer"),t=k(n,t,"key");var s,c=0|r._crypto_stream_chacha20_keybytes();t.length!==c&&f(n,"invalid key length"),s=v(t),n.push(s),a=k(n,a,"nonce");var h,o=0|r._crypto_stream_chacha20_noncebytes();a.length!==o&&f(n,"invalid nonce length"),h=v(a),n.push(h);var p=new u(0|e),i=p.address;n.push(i),r._crypto_stream_chacha20(i,e,0,h,s);var d=y(p,_);return g(n),d}function Tt(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"input_message")),c=e.length;n.push(s),t=k(n,t,"nonce");var h,o=0|r._crypto_stream_chacha20_ietf_noncebytes();t.length!==o&&f(n,"invalid nonce length"),h=v(t),n.push(h),a=k(n,a,"key");var p,i=0|r._crypto_stream_chacha20_ietf_keybytes();a.length!==i&&f(n,"invalid key length"),p=v(a),n.push(p);var d=new u(0|c),m=d.address;if(n.push(m),0===r._crypto_stream_chacha20_ietf_xor(m,s,c,0,h,p)){var x=y(d,_);return g(n),x}b(n,"invalid usage")}function Yt(e,t,a,_,n){var s=[];l(n);var c=v(e=k(s,e,"input_message")),h=e.length;s.push(c),t=k(s,t,"nonce");var o,p=0|r._crypto_stream_chacha20_ietf_noncebytes();t.length!==p&&f(s,"invalid nonce length"),o=v(t),s.push(o),m(s,a,"nonce_increment"),("number"!=typeof a||(0|a)!==a||a<0)&&f(s,"nonce_increment must be an unsigned integer"),_=k(s,_,"key");var i,d=0|r._crypto_stream_chacha20_ietf_keybytes();_.length!==d&&f(s,"invalid key length"),i=v(_),s.push(i);var x=new u(0|h),E=x.address;if(s.push(E),0===r._crypto_stream_chacha20_ietf_xor_ic(E,c,h,0,o,a,0,i)){var w=y(x,n);return g(s),w}b(s,"invalid usage")}function At(e){var t=[];l(e);var a=new u(0|r._crypto_stream_chacha20_keybytes()),_=a.address;t.push(_),r._crypto_stream_chacha20_keygen(_);var n=y(a,e);return g(t),n}function Bt(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"input_message")),c=e.length;n.push(s),t=k(n,t,"nonce");var h,o=0|r._crypto_stream_chacha20_noncebytes();t.length!==o&&f(n,"invalid nonce length"),h=v(t),n.push(h),a=k(n,a,"key");var p,i=0|r._crypto_stream_chacha20_keybytes();a.length!==i&&f(n,"invalid key length"),p=v(a),n.push(p);var d=new u(0|c),m=d.address;if(n.push(m),0===r._crypto_stream_chacha20_xor(m,s,c,0,h,p)){var x=y(d,_);return g(n),x}b(n,"invalid usage")}function Kt(e,t,a,_,n){var s=[];l(n);var c=v(e=k(s,e,"input_message")),h=e.length;s.push(c),t=k(s,t,"nonce");var o,p=0|r._crypto_stream_chacha20_noncebytes();t.length!==p&&f(s,"invalid nonce length"),o=v(t),s.push(o),m(s,a,"nonce_increment"),("number"!=typeof a||(0|a)!==a||a<0)&&f(s,"nonce_increment must be an unsigned integer"),_=k(s,_,"key");var i,d=0|r._crypto_stream_chacha20_keybytes();_.length!==d&&f(s,"invalid key length"),i=v(_),s.push(i);var x=new u(0|h),E=x.address;if(s.push(E),0===r._crypto_stream_chacha20_xor_ic(E,c,h,0,o,a,0,i)){var w=y(x,n);return g(s),w}b(s,"invalid usage")}function It(e){var t=[];l(e);var a=new u(0|r._crypto_stream_keybytes()),_=a.address;t.push(_),r._crypto_stream_keygen(_);var n=y(a,e);return g(t),n}function Mt(e){var t=[];l(e);var a=new u(0|r._crypto_stream_xchacha20_keybytes()),_=a.address;t.push(_),r._crypto_stream_xchacha20_keygen(_);var n=y(a,e);return g(t),n}function Lt(e,t,a,_){var n=[];l(_);var s=v(e=k(n,e,"input_message")),c=e.length;n.push(s),t=k(n,t,"nonce");var h,o=0|r._crypto_stream_xchacha20_noncebytes();t.length!==o&&f(n,"invalid nonce length"),h=v(t),n.push(h),a=k(n,a,"key");var p,i=0|r._crypto_stream_xchacha20_keybytes();a.length!==i&&f(n,"invalid key length"),p=v(a),n.push(p);var d=new u(0|c),m=d.address;if(n.push(m),0===r._crypto_stream_xchacha20_xor(m,s,c,0,h,p)){var x=y(d,_);return g(n),x}b(n,"invalid usage")}function Nt(e,t,a,_,n){var s=[];l(n);var c=v(e=k(s,e,"input_message")),h=e.length;s.push(c),t=k(s,t,"nonce");var o,p=0|r._crypto_stream_xchacha20_noncebytes();t.length!==p&&f(s,"invalid nonce length"),o=v(t),s.push(o),m(s,a,"nonce_increment"),("number"!=typeof a||(0|a)!==a||a<0)&&f(s,"nonce_increment must be an unsigned integer"),_=k(s,_,"key");var i,d=0|r._crypto_stream_xchacha20_keybytes();_.length!==d&&f(s,"invalid key length"),i=v(_),s.push(i);var x=new u(0|h),E=x.address;if(s.push(E),0===r._crypto_stream_xchacha20_xor_ic(E,c,h,0,o,a,0,i)){var w=y(x,n);return g(s),w}b(s,"invalid usage")}function Ut(e,t){var a=[];l(t),m(a,e,"length"),("number"!=typeof e||(0|e)!==e||e<0)&&f(a,"length must be an unsigned integer");var _=new u(0|e),n=_.address;a.push(n),r._randombytes_buf(n,e);var s=y(_,t);return g(a),s}function Ot(e,t,a){var _=[];l(a),m(_,e,"length"),("number"!=typeof e||(0|e)!==e||e<0)&&f(_,"length must be an unsigned integer"),t=k(_,t,"seed");var n,s=0|r._randombytes_seedbytes();t.length!==s&&f(_,"invalid seed length"),n=v(t),_.push(n);var c=new u(0|e),h=c.address;_.push(h),r._randombytes_buf_deterministic(h,e,n);var o=y(c,a);return g(_),o}function Rt(e){l(e),r._randombytes_close()}function Pt(e){l(e);var t=r._randombytes_random()>>>0;return g([]),t}function Ct(e,t){var a=[];l(t);for(var _=r._malloc(24),n=0;n<6;n++)r.setValue(_+4*n,r.Runtime.addFunction(e[["implementation_name","random","stir","uniform","buf","close"][n]]),"i32");0!=(0|r._randombytes_set_implementation(_))&&b(a,"unsupported implementation"),g(a)}function Gt(e){l(e),r._randombytes_stir()}function Dt(e,t){var a=[];l(t),m(a,e,"upper_bound"),("number"!=typeof e||(0|e)!==e||e<0)&&f(a,"upper_bound must be an unsigned integer");var _=r._randombytes_uniform(e)>>>0;return g(a),_}function Xt(){var e=r._sodium_version_string(),t=r.UTF8ToString(e);return g([]),t}return u.prototype.to_Uint8Array=function(){var e=new Uint8Array(this.length);return e.set(r.HEAPU8.subarray(this.address,this.address+this.length)),e},e.add=function(e,t){if(!(e instanceof Uint8Array&&t instanceof Uint8Array))throw new TypeError("Only Uint8Array instances can added");var r=e.length,a=0,_=0;if(t.length!=e.length)throw new TypeError("Arguments must have the same length");for(_=0;_<r;_++)a>>=8,a+=e[_]+t[_],e[_]=255&a},e.base64_variants=h,e.compare=function(e,t){if(!(e instanceof Uint8Array&&t instanceof Uint8Array))throw new TypeError("Only Uint8Array instances can be compared");if(e.length!==t.length)throw new TypeError("Only instances of identical length can be compared");for(var r=0,a=1,_=e.length;_-- >0;)r|=t[_]-e[_]>>8&a,a&=(t[_]^e[_])-1>>8;return r+r+a-1},e.from_base64=function(e,t){t=o(t);var a,_=[],n=new u(3*(e=k(_,e,"input")).length/4),s=v(e),c=d(4),h=d(4);return _.push(s),_.push(n.address),_.push(n.result_bin_len_p),_.push(n.b64_end_p),0!==r._sodium_base642bin(n.address,n.length,s,e.length,0,c,h,t)&&b(_,"invalid input"),r.getValue(h,"i32")-s!==e.length&&b(_,"incomplete input"),n.length=r.getValue(c,"i32"),a=n.to_Uint8Array(),g(_),a},e.from_hex=function(e){var t,a=[],_=new u((e=k(a,e,"input")).length/2),n=v(e),s=d(4);return a.push(n),a.push(_.address),a.push(_.hex_end_p),0!==r._sodium_hex2bin(_.address,_.length,n,e.length,0,0,s)&&b(a,"invalid input"),r.getValue(s,"i32")-n!==e.length&&b(a,"incomplete input"),t=_.to_Uint8Array(),g(a),t},e.from_string=n,e.increment=function(e){if(!(e instanceof Uint8Array))throw new TypeError("Only Uint8Array instances can be incremented");for(var t=256,r=0,a=e.length;r<a;r++)t>>=8,t+=e[r],e[r]=255&t},e.is_zero=function(e){if(!(e instanceof Uint8Array))throw new TypeError("Only Uint8Array instances can be checked");for(var t=0,r=0,a=e.length;r<a;r++)t|=e[r];return 0===t},e.libsodium=t,e.memcmp=function(e,t){if(!(e instanceof Uint8Array&&t instanceof Uint8Array))throw new TypeError("Only Uint8Array instances can be compared");if(e.length!==t.length)throw new TypeError("Only instances of identical length can be compared");for(var r=0,a=0,_=e.length;a<_;a++)r|=e[a]^t[a];return 0===r},e.memzero=function(e){if(!(e instanceof Uint8Array))throw new TypeError("Only Uint8Array instances can be wiped");for(var t=0,r=e.length;t<r;t++)e[t]=0},e.output_formats=function(){return["uint8array","text","hex","base64"]},e.pad=function(e,t){if(!(e instanceof Uint8Array))throw new TypeError("buffer must be a Uint8Array");if((t|=0)<=0)throw new Error("block size must be > 0");var a,_=[],n=d(4),s=1,c=0,h=0|e.length,o=new u(h+t);_.push(n),_.push(o.address);for(var p=o.address,y=o.address+h+t;p<y;p++)r.HEAPU8[p]=e[c],c+=s=1&~((65535&((h-=s)>>>48|h>>>32|h>>>16|h))-1>>16);return 0!==r._sodium_pad(n,o.address,e.length,t,o.length)&&b(_,"internal error"),o.length=r.getValue(n,"i32"),a=o.to_Uint8Array(),g(_),a},e.unpad=function(e,t){if(!(e instanceof Uint8Array))throw new TypeError("buffer must be a Uint8Array");if((t|=0)<=0)throw new Error("block size must be > 0");var a=[],_=v(e),n=d(4);return a.push(_),a.push(n),0!==r._sodium_unpad(n,_,e.length,t)&&b(a,"unsupported/invalid padding"),e=(e=new Uint8Array(e)).subarray(0,r.getValue(n,"i32")),g(a),e},e.ready=_,e.symbols=function(){return Object.keys(e).sort()},e.to_base64=p,e.to_hex=c,e.to_string=s,e}var r="object"==typeof e.sodium&&"function"==typeof e.sodium.onload?e.sodium.onload:null;"function"==typeof define&&define.amd?define(["exports","libsodium"],t):"object"==typeof exports&&"string"!=typeof exports.nodeName?t(exports,require("libsodium")):e.sodium=t(e.commonJsStrict={},e.libsodium),r&&e.sodium.ready.then(function(){r(e.sodium)})}(this);

},{"libsodium":21}],21:[function(require,module,exports){
(function (process,global,Buffer,__argument0,__argument1,__argument2,__argument3,__dirname){
!function(A){function I(A){"use strict";var I;void 0===(I=A)&&(I={});var g=I;"object"!=typeof g.sodium&&("object"==typeof global?g=global:"object"==typeof window&&(g=window)),"object"==typeof g.sodium&&"number"==typeof g.sodium.totalMemory&&(I.TOTAL_MEMORY=g.sodium.totalMemory);var B=I;return I.ready=new Promise(function(A,I){(C=B).onAbort=I,C.print=function(A){},C.printErr=function(A){},C.onRuntimeInitialized=function(){try{C._crypto_secretbox_keybytes(),A()}catch(A){I(A)}},C.useBackupModule=function(){var A,I=void 0!==(I={})?I:{},g={};for(A in I)I.hasOwnProperty(A)&&(g[A]=I[A]);var C,Q,E,i,e=[],o=!1;C="object"==typeof window,Q="function"==typeof importScripts,E="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node,o=E&&!C&&!Q,i=!C&&!o&&!Q;var c,a,n,r,t,f="";o?(f=__dirname+"/",c=function(A,I){var g;return(g=iA(A))||(r||(r=require("fs")),t||(t=require("path")),A=t.normalize(A),g=r.readFileSync(A)),I?g:g.toString()},n=function(A){var I=c(A,!0);return I.buffer||(I=new Uint8Array(I)),D(I.buffer),I},process.argv.length>1&&process.argv[1].replace(/\\/g,"/"),e=process.argv.slice(2),"undefined"!=typeof module&&(module.exports=I),process.on("unhandledRejection",j),I.inspect=function(){return"[Emscripten Module object]"}):i?("undefined"!=typeof read&&(c=function(A){var I=iA(A);return I?QA(I):read(A)}),n=function(A){var I;return(I=iA(A))?I:"function"==typeof readbuffer?new Uint8Array(readbuffer(A)):(D("object"==typeof(I=read(A,"binary"))),I)},"undefined"!=typeof scriptArgs?e=scriptArgs:void 0!==arguments&&(e=arguments),"undefined"!=typeof print&&("undefined"==typeof console&&(console={}),console.log=print,console.warn=console.error="undefined"!=typeof printErr?printErr:print)):(C||Q)&&(Q?f=self.location.href:document.currentScript&&(f=document.currentScript.src),f=0!==f.indexOf("blob:")?f.substr(0,f.lastIndexOf("/")+1):"",c=function(A){try{var I=new XMLHttpRequest;return I.open("GET",A,!1),I.send(null),I.responseText}catch(I){var g=iA(A);if(g)return QA(g);throw I}},Q&&(n=function(A){try{var I=new XMLHttpRequest;return I.open("GET",A,!1),I.responseType="arraybuffer",I.send(null),new Uint8Array(I.response)}catch(I){var g=iA(A);if(g)return g;throw I}}),a=function(A,I,g){var B=new XMLHttpRequest;B.open("GET",A,!0),B.responseType="arraybuffer",B.onload=function(){if(200==B.status||0==B.status&&B.response)I(B.response);else{var C=iA(A);C?I(C.buffer):g()}},B.onerror=g,B.send(null)});var w=I.print||void 0,y=I.printErr||void 0;for(A in g)g.hasOwnProperty(A)&&(I[A]=g[A]);g=null,I.arguments&&(e=I.arguments),I.thisProgram&&I.thisProgram,I.quit&&I.quit,new Array(8);var s=0;I.wasmBinary&&I.wasmBinary,I.noExitRuntime&&I.noExitRuntime;var h=!1;function D(A,I){A||j("Assertion failed: "+I)}var F,p,u,H,k,l,_,G="undefined"!=typeof TextDecoder?new TextDecoder("utf8"):void 0;function d(A,I){return A?function(A,I,g){for(var B=I+g,C=I;A[C]&&!(C>=B);)++C;if(C-I>16&&A.subarray&&G)return G.decode(A.subarray(I,C));for(var Q="";I<C;){var E=A[I++];if(128&E){var i=63&A[I++];if(192!=(224&E)){var e=63&A[I++];if((E=224==(240&E)?(15&E)<<12|i<<6|e:(7&E)<<18|i<<12|e<<6|63&A[I++])<65536)Q+=String.fromCharCode(E);else{var o=E-65536;Q+=String.fromCharCode(55296|o>>10,56320|1023&o)}}else Q+=String.fromCharCode((31&E)<<6|i)}else Q+=String.fromCharCode(E)}return Q}(u,A,I):""}function Y(A,I){return A%I>0&&(A+=I-A%I),A}function M(A){F=A,I.HEAP8=p=new Int8Array(A),I.HEAP16=H=new Int16Array(A),I.HEAP32=k=new Int32Array(A),I.HEAPU8=u=new Uint8Array(A),I.HEAPU16=new Uint16Array(A),I.HEAPU32=new Uint32Array(A),I.HEAPF32=l=new Float32Array(A),I.HEAPF64=_=new Float64Array(A)}"undefined"!=typeof TextDecoder&&new TextDecoder("utf-16le");var S=I.TOTAL_MEMORY||16777216;function U(A){for(;A.length>0;){var g=A.shift();if("function"!=typeof g){var B=g.func;"number"==typeof B?void 0===g.arg?I.dynCall_v(B):I.dynCall_vi(B,g.arg):B(void 0===g.arg?null:g.arg)}else g()}}S=(F=I.buffer?I.buffer:new ArrayBuffer(S)).byteLength,M(F),k[8808]=5278304;var v=[],b=[],J=[],P=[],R=Math.abs,N=Math.ceil,m=Math.floor,L=Math.min,x=0,K=null,X=null;function j(A){throw I.onAbort&&I.onAbort(A),w(A+=""),y(A),h=!0,"abort("+A+"). Build with -s ASSERTIONS=1 for more info."}I.preloadedImages={},I.preloadedAudios={};var T,q,V=null,z="data:application/octet-stream;base64,";function W(A){return String.prototype.startsWith?A.startsWith(z):0===A.indexOf(z)}var O=[function(){return I.getRandomValue()},function(){if(void 0===I.getRandomValue)try{var A="object"==typeof window?window:self,g=void 0!==A.crypto?A.crypto:A.msCrypto,B=function(){var A=new Uint32Array(1);return g.getRandomValues(A),A[0]>>>0};B(),I.getRandomValue=B}catch(A){try{var C=require("crypto"),Q=function(){var A=C.randomBytes(4);return(A[0]<<24|A[1]<<16|A[2]<<8|A[3])>>>0};Q(),I.getRandomValue=Q}catch(A){throw"No secure random number generator found"}}}];function Z(A){return A}function $(A){return A.replace(/\b__Z[\w\d_]+/g,function(A){var I=Z(A);return A===I?A:I+" ["+A+"]"})}function AA(){var A=new Error;if(!A.stack){try{throw new Error(0)}catch(I){A=I}if(!A.stack)return"(no stack trace available)"}return A.stack.toString()}function IA(){return p.length}function gA(A){try{var I=new ArrayBuffer(A);if(I.byteLength!=A)return;return new Int8Array(I).set(p),aA(I),M(I),1}catch(A){}}function BA(A){return I.___errno_location&&(k[I.___errno_location()>>2]=A),A}V="data:application/octet-stream;base64,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";var CA=!1;function QA(A){for(var I=[],g=0;g<A.length;g++){var B=A[g];B>255&&(CA&&D(!1,"Character code "+B+" ("+String.fromCharCode(B)+")  at offset "+g+" not in 0x00-0xFF."),B&=255),I.push(String.fromCharCode(B))}return I.join("")}var EA="function"==typeof atob?atob:function(A){var I,g,B,C,Q,E,i="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",e="",o=0;A=A.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{I=i.indexOf(A.charAt(o++))<<2|(C=i.indexOf(A.charAt(o++)))>>4,g=(15&C)<<4|(Q=i.indexOf(A.charAt(o++)))>>2,B=(3&Q)<<6|(E=i.indexOf(A.charAt(o++))),e+=String.fromCharCode(I),64!==Q&&(e+=String.fromCharCode(g)),64!==E&&(e+=String.fromCharCode(B))}while(o<A.length);return e};function iA(A){if(W(A))return function(A){if("boolean"==typeof o&&o){var I;try{I=Buffer.from(A,"base64")}catch(g){I=new Buffer(A,"base64")}return new Uint8Array(I.buffer,I.byteOffset,I.byteLength)}try{for(var g=EA(A),B=new Uint8Array(g.length),C=0;C<g.length;++C)B[C]=g.charCodeAt(C);return B}catch(A){throw new Error("Converting base64 string to bytes failed.")}}(A.slice(z.length))}var eA,oA,cA=function(A,I,g){"almost asm";var B=new A.Int8Array(g),C=new A.Int32Array(g),Q=new A.Uint8Array(g),E=A.Math.imul,i=A.Math.clz32,e=I.b,o=I.c,c=I.d,a=I.f,n=I.g,r=I.h,t=I.i,f=I.j,w=I.k,y=35424;function s(A,I){A|=0,I|=0;var g,E,i,e,c,a,n=0,r=0,t=0,f=0,w=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0,m=0,L=0,x=0,K=0,X=0,j=0,T=0,q=0,V=0,z=0,W=0,O=0,Z=0,$=0,AA=0,IA=0,gA=0,BA=0,CA=0,QA=0,EA=0,iA=0,eA=0,oA=0,cA=0,aA=0,nA=0,rA=0,tA=0,fA=0,wA=0,yA=0,sA=0;g=y,E=y=y+63&-64,y=y+256|0,n=0;do{f=0|qI(I+(n<<3)|0),t=0|o(),C[(r=E+128+(n<<3)|0)>>2]=f,C[r+4>>2]=t,n=n+1|0}while(16!=(0|n));n=A,r=(I=E)+64|0;do{B[I>>0]=0|B[n>>0],I=I+1|0,n=n+1|0}while((0|I)<(0|r));for(C[E+88>>2]=1595750129,C[E+88+4>>2]=-1521486534,X=-1377402159^(Q[A+64>>0]|Q[A+64+1>>0]<<8|Q[A+64+2>>0]<<16|Q[A+64+3>>0]<<24),K=1359893119^(Q[A+64+4>>0]|Q[A+64+4+1>>0]<<8|Q[A+64+4+2>>0]<<16|Q[A+64+4+3>>0]<<24),S=725511199^(Q[A+72>>0]|Q[A+72+1>>0]<<8|Q[A+72+2>>0]<<16|Q[A+72+3>>0]<<24),U=-1694144372^(Q[A+72+4>>0]|Q[A+72+4+1>>0]<<8|Q[A+72+4+2>>0]<<16|Q[A+72+4+3>>0]<<24),u=-79577749^(Q[A+80>>0]|Q[A+80+1>>0]<<8|Q[A+80+2>>0]<<16|Q[A+80+3>>0]<<24),H=528734635^(Q[A+80+4>>0]|Q[A+80+4+1>>0]<<8|Q[A+80+4+2>>0]<<16|Q[A+80+4+3>>0]<<24),AA=327033209^(Q[A+88>>0]|Q[A+88+1>>0]<<8|Q[A+88+2>>0]<<16|Q[A+88+3>>0]<<24),$=1541459225^(Q[A+88+4>>0]|Q[A+88+4+1>>0]<<8|Q[A+88+4+2>>0]<<16|Q[A+88+4+3>>0]<<24),h=0|C[E+32>>2],D=0|C[E+32+4>>2],D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(yA=0|vg(0|(j=0|C[E+128>>2]),0|(T=0|C[E+128+4>>2]),0|h,0|D)),0|(wA=0|o()),0|C[E>>2],0|C[E+4>>2]))^X,(yA=0|o())^K,32)),0|(X=0|o()),-205731576,1779033703))^h,(f=0|o())^D,24),h=0|o(),IA=0|C[E+128+8>>2],gA=0|C[E+128+8+4>>2],X=0|ZI((yA=0|vg(0|(yA=0|vg(0|D,0|h,0|wA,0|yA)),0|o(),0|IA,0|gA))^K,(wA=0|o())^X,16),K=0|o(),C[E+96>>2]=X,C[E+96+4>>2]=K,f=0|vg(0|X,0|K,0|I,0|f),I=0|o(),C[E+64>>2]=f,C[E+64+4>>2]=I,h=0|ZI(f^D,I^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,W=0|C[E+40>>2],O=0|C[E+40+4>>2],O=0|ZI((s=0|vg(0|(U=0|ZI((nA=0|vg(0|(aA=0|vg(0|(r=0|C[E+128+16>>2]),0|(n=0|C[E+128+16+4>>2]),0|W,0|O)),0|(nA=0|o()),0|C[E+8>>2],0|C[E+8+4>>2]))^S,(aA=0|o())^U,32)),0|(S=0|o()),-2067093701,-1150833019))^W,(F=0|o())^O,24),W=0|o(),p=0|C[E+128+24>>2],k=0|C[E+128+24+4>>2],S=0|ZI((aA=0|vg(0|(aA=0|vg(0|O,0|W,0|nA,0|aA)),0|o(),0|p,0|k))^U,(nA=0|o())^S,16),U=0|o(),C[E+104>>2]=S,C[E+104+4>>2]=U,F=0|vg(0|S,0|U,0|s,0|F),s=0|o(),C[E+72>>2]=F,C[E+72+4>>2]=s,W=0|ZI(F^O,s^W,63),O=0|o(),m=0|C[E+48>>2],L=0|C[E+48+4>>2],L=0|ZI((z=0|vg(0|(H=0|ZI((oA=0|vg(0|(eA=0|vg(0|(a=0|C[E+128+32>>2]),0|(rA=0|C[E+128+32+4>>2]),0|m,0|L)),0|(oA=0|o()),0|C[E+16>>2],0|C[E+16+4>>2]))^u,(eA=0|o())^H,32)),0|(u=0|o()),-23791573,1013904242))^m,(Z=0|o())^L,24),m=0|o(),i=0|C[E+128+40>>2],G=0|C[E+128+40+4>>2],m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|L,0|m,0|oA,0|eA)),0|o(),0|i,0|G))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),Y=0|C[E+56>>2],d=0|C[E+56+4>>2],d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(QA=0|vg(0|(_=0|C[E+128+48>>2]),0|(l=0|C[E+128+48+4>>2]),0|Y,0|d)),0|(EA=0|o()),0|C[E+24>>2],0|C[E+24+4>>2]))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),1595750129,-1521486534))^Y,(x=0|o())^d,24),Y=0|o(),M=0|C[E+128+56>>2],v=0|C[E+128+56+4>>2],Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|d,0|Y,0|EA,0|QA)),0|o(),0|M,0|v))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),q=0|C[E+128+64>>2],V=0|C[E+128+64+4>>2],O=0|ZI((z=0|vg(0|($=0|ZI((wA=0|vg(0|(wA=0|vg(0|W,0|O,0|yA,0|wA)),0|o(),0|q,0|V))^AA,(yA=0|o())^$,32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),c=0|C[E+128+72>>2],cA=0|C[E+128+72+4>>2],AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|O,0|W,0|wA,0|yA)),0|o(),0|c,0|cA))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,Z=0|vg(0|AA,0|$,0|z,0|Z),z=0|o(),C[E+80>>2]=Z,C[E+80+4>>2]=z,W=0|ZI(Z^O,z^W,63),O=0|o(),BA=0|C[E+128+80>>2],CA=0|C[E+128+80+4>>2],L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|m,0|L,0|aA,0|nA)),0|o(),0|BA,0|CA))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),b=0|C[E+128+88>>2],J=0|C[E+128+88+4>>2],m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|L,0|m,0|nA,0|aA)),0|o(),0|b,0|J))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),t=0|C[E+128+96>>2],w=0|C[E+128+96+4>>2],d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|Y,0|d,0|eA,0|oA)),0|o(),0|t,0|w))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),e=0|C[E+128+104>>2],iA=0|C[E+128+104+4>>2],Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|d,0|Y,0|oA,0|eA)),0|o(),0|e,0|iA))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),tA=0|C[E+128+112>>2],fA=0|C[E+128+112+4>>2],D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(EA=0|vg(0|QA,0|EA,0|h,0|D)),0|o(),0|tA,0|fA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),P=0|C[E+128+120>>2],R=0|C[E+128+120+4>>2],h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|D,0|h,0|EA,0|QA)),0|o(),0|P,0|R))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|tA,0|fA,0|yA,0|wA)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|BA,0|CA)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|a,0|rA)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|q,0|V)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|c,0|cA)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|P,0|R,0|oA,0|eA)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|e,0|iA)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|_,0|l)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|IA,0|gA)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|t,0|w)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|j,0|T)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|r,0|n)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|b,0|J)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|M,0|v)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|i,0|G)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|p,0|k)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|b,0|J)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|q,0|V)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|t,0|w)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|j,0|T)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|i,0|G)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|r,0|n)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|P,0|R)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|e,0|iA)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|BA,0|CA)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|tA,0|fA)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|p,0|k)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|_,0|l)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|M,0|v)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|IA,0|gA)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|c,0|cA)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|a,0|rA)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|M,0|v)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|c,0|cA)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|p,0|k)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|IA,0|gA)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|e,0|iA)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|t,0|w)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|b,0|J)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|tA,0|fA)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|r,0|n)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|_,0|l)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|i,0|G)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|BA,0|CA)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|a,0|rA)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|j,0|T)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|P,0|R)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|q,0|V)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|c,0|cA)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|j,0|T)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|i,0|G)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|M,0|v)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|r,0|n)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|a,0|rA)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|BA,0|CA)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|P,0|R)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|tA,0|fA)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|IA,0|gA)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|b,0|J)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|t,0|w)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|_,0|l)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|q,0|V)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|p,0|k)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|e,0|iA)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|r,0|n)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|t,0|w)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|_,0|l)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|BA,0|CA)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|j,0|T)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|b,0|J)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|q,0|V)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|p,0|k)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|a,0|rA)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|e,0|iA)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|M,0|v)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|i,0|G)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|P,0|R)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|tA,0|fA)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|IA,0|gA)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|c,0|cA)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|t,0|w)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|i,0|G)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|IA,0|gA)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|P,0|R)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|tA,0|fA)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|e,0|iA)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|a,0|rA)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|BA,0|CA)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|j,0|T)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|M,0|v)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|_,0|l)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|p,0|k)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|c,0|cA)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|r,0|n)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|q,0|V)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|b,0|J)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|e,0|iA)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|b,0|J)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|M,0|v)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|tA,0|fA)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|t,0|w)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|IA,0|gA)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|p,0|k)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|c,0|cA)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|i,0|G)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|j,0|T)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|P,0|R)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|a,0|rA)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|q,0|V)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|_,0|l)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|r,0|n)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|BA,0|CA)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|_,0|l)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|P,0|R)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|tA,0|fA)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|c,0|cA)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|b,0|J)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|p,0|k)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|j,0|T)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|q,0|V)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|t,0|w)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|r,0|n)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|e,0|iA)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|M,0|v)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|IA,0|gA)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|a,0|rA)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|BA,0|CA)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|i,0|G)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|BA,0|CA)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|r,0|n)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|q,0|V)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|a,0|rA)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|M,0|v)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|_,0|l)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|IA,0|gA)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|i,0|G)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|P,0|R)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|b,0|J)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|c,0|cA)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|tA,0|fA)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|p,0|k)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|t,0|w)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|e,0|iA)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|j,0|T)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|j,0|T)),0|o(),0|h,0|D))^X,(yA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|IA,0|gA)),0|o(),0|D,0|h))^K,(wA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(sA=0|vg(0|W,0|O,0|r,0|n)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|p,0|k)),0|o(),0|O,0|W))^U,(nA=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(sA=0|vg(0|m,0|L,0|a,0|rA)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|i,0|G)),0|o(),0|L,0|m))^H,(oA=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(sA=0|vg(0|Y,0|d,0|_,0|l)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|M,0|v)),0|o(),0|d,0|Y))^$,(EA=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(wA=0|vg(0|(wA=0|vg(0|yA,0|wA,0|q,0|V)),0|o(),0|W,0|O)),$^(yA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),AA=0|ZI((yA=0|vg(0|(yA=0|vg(0|wA,0|yA,0|c,0|cA)),0|o(),0|O,0|W))^$,(wA=0|o())^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,W=0|ZI((Z=0|vg(0|AA,0|$,0|z,0|Z))^O,(z=0|o())^W,63),O=0|o(),L=0|ZI((N=0|vg(0|(K=0|ZI((nA=0|vg(0|(nA=0|vg(0|aA,0|nA,0|BA,0|CA)),0|o(),0|m,0|L))^X,(aA=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),m=0|ZI((x=0|vg(0|(X=0|ZI((aA=0|vg(0|(aA=0|vg(0|nA,0|aA,0|b,0|J)),0|o(),0|L,0|m))^K,(nA=0|o())^X,16)),0|(K=0|o()),0|N,0|x))^L,(N=0|o())^m,63),L=0|o(),d=0|ZI((I=0|vg(0|(U=0|ZI((oA=0|vg(0|(oA=0|vg(0|eA,0|oA,0|t,0|w)),0|o(),0|Y,0|d))^S,(eA=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),Y=0|ZI((f=0|vg(0|(S=0|ZI((eA=0|vg(0|(eA=0|vg(0|oA,0|eA,0|e,0|iA)),0|o(),0|d,0|Y))^U,(oA=0|o())^S,16)),0|(U=0|o()),0|I,0|f))^d,(I=0|o())^Y,63),d=0|o(),D=0|ZI((s=0|vg(0|(H=0|ZI((EA=0|vg(0|(sA=0|vg(0|h,0|D,0|tA,0|fA)),0|o(),0|QA,0|EA))^u,(QA=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),h=0|ZI((F=0|vg(0|(u=0|ZI((QA=0|vg(0|(QA=0|vg(0|EA,0|QA,0|P,0|R)),0|o(),0|D,0|h))^H,(EA=0|o())^u,16)),0|(H=0|o()),0|s,0|F))^D,(s=0|o())^h,63),D=0|o(),D=0|ZI((I=0|vg(0|(K=0|ZI((fA=0|vg(0|(fA=0|vg(0|yA,0|wA,0|tA,0|fA)),0|o(),0|h,0|D))^X,(tA=0|o())^K,32)),0|(X=0|o()),0|f,0|I))^h,(f=0|o())^D,24),h=0|o(),h=0|ZI((f=0|vg(0|(X=0|ZI((CA=0|vg(0|(CA=0|vg(0|fA,0|tA,0|BA,0|CA)),0|o(),0|D,0|h))^K,(BA=0|o())^X,16)),0|(K=0|o()),0|I,0|f))^D,(I=0|o())^h,63),D=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=D,O=0|ZI((s=0|vg(0|(U=0|ZI(S^(nA=0|vg(0|(rA=0|vg(0|W,0|O,0|a,0|rA)),0|o(),0|aA,0|nA)),U^(aA=0|o()),32)),0|(S=0|o()),0|F,0|s))^W,(F=0|o())^O,24),W=0|o(),W=0|ZI((F=0|vg(0|(S=0|ZI((V=0|vg(0|(V=0|vg(0|nA,0|aA,0|q,0|V)),0|o(),0|O,0|W))^U,(q=0|o())^S,16)),0|(U=0|o()),0|s,0|F))^O,(s=0|o())^W,63),O=0|o(),L=0|ZI((z=0|vg(0|(H=0|ZI(u^(oA=0|vg(0|(cA=0|vg(0|m,0|L,0|c,0|cA)),0|o(),0|eA,0|oA)),H^(eA=0|o()),32)),0|(u=0|o()),0|Z,0|z))^m,(Z=0|o())^L,24),m=0|o(),m=0|ZI((Z=0|vg(0|(u=0|ZI((R=0|vg(0|(R=0|vg(0|oA,0|eA,0|P,0|R)),0|o(),0|L,0|m))^H,(P=0|o())^u,16)),0|(H=0|o()),0|z,0|Z))^L,(z=0|o())^m,63),L=0|o(),d=0|ZI((N=0|vg(0|($=0|ZI((EA=0|vg(0|(iA=0|vg(0|Y,0|d,0|e,0|iA)),0|o(),0|QA,0|EA))^AA,(QA=0|o())^$,32)),0|(AA=0|o()),0|x,0|N))^Y,(x=0|o())^d,24),Y=0|o(),Y=0|ZI((x=0|vg(0|(AA=0|ZI((l=0|vg(0|(l=0|vg(0|EA,0|QA,0|_,0|l)),0|o(),0|d,0|Y))^$,(_=0|o())^AA,16)),0|($=0|o()),0|N,0|x))^d,(N=0|o())^Y,63),d=0|o(),O=0|ZI((z=0|vg(0|($=0|ZI(AA^(gA=0|vg(0|(gA=0|vg(0|CA,0|BA,0|IA,0|gA)),0|o(),0|W,0|O)),$^(IA=0|o()),32)),0|(AA=0|o()),0|Z,0|z))^W,(Z=0|o())^O,24),W=0|o(),w=0|vg(0|(w=0|vg(0|gA,0|IA,0|t,0|w)),0|o(),0|O,0|W),t=0|o(),C[E>>2]=w,C[E+4>>2]=t,AA=0|ZI(w^$,t^AA,16),$=0|o(),C[E+120>>2]=AA,C[E+120+4>>2]=$,Z=0|vg(0|AA,0|$,0|z,0|Z),z=0|o(),C[E+80>>2]=Z,C[E+80+4>>2]=z,W=0|ZI(Z^O,z^W,63),z=0|o(),C[E+40>>2]=W,C[E+40+4>>2]=z,L=0|ZI((N=0|vg(0|(K=0|ZI((T=0|vg(0|(T=0|vg(0|V,0|q,0|j,0|T)),0|o(),0|m,0|L))^X,(j=0|o())^K,32)),0|(X=0|o()),0|x,0|N))^m,(x=0|o())^L,24),m=0|o(),n=0|vg(0|(n=0|vg(0|T,0|j,0|r,0|n)),0|o(),0|L,0|m),r=0|o(),C[E+8>>2]=n,C[E+8+4>>2]=r,X=0|ZI(n^K,r^X,16),K=0|o(),C[E+96>>2]=X,C[E+96+4>>2]=K,x=0|vg(0|X,0|K,0|N,0|x),N=0|o(),C[E+88>>2]=x,C[E+88+4>>2]=N,m=0|ZI(x^L,N^m,63),N=0|o(),C[E+48>>2]=m,C[E+48+4>>2]=N,d=0|ZI((I=0|vg(0|(U=0|ZI((J=0|vg(0|(J=0|vg(0|R,0|P,0|b,0|J)),0|o(),0|Y,0|d))^S,(b=0|o())^U,32)),0|(S=0|o()),0|f,0|I))^Y,(f=0|o())^d,24),Y=0|o(),v=0|vg(0|(v=0|vg(0|J,0|b,0|M,0|v)),0|o(),0|d,0|Y),M=0|o(),C[E+16>>2]=v,C[E+16+4>>2]=M,S=0|ZI(v^U,M^S,16),M=0|o(),C[E+104>>2]=S,C[E+104+4>>2]=M,f=0|vg(0|S,0|M,0|I,0|f),I=0|o(),C[E+64>>2]=f,C[E+64+4>>2]=I,Y=0|ZI(f^d,I^Y,63),d=0|o(),C[E+56>>2]=Y,C[E+56+4>>2]=d,D=0|ZI((s=0|vg(0|(H=0|ZI((_=0|vg(0|(G=0|vg(0|h,0|D,0|i,0|G)),0|o(),0|l,0|_))^u,(l=0|o())^H,32)),0|(u=0|o()),0|F,0|s))^h,(F=0|o())^D,24),h=0|o(),k=0|vg(0|(k=0|vg(0|_,0|l,0|p,0|k)),0|o(),0|D,0|h),p=0|o(),C[E+24>>2]=k,C[E+24+4>>2]=p,u=0|ZI(k^H,p^u,16),p=0|o(),C[E+112>>2]=u,C[E+112+4>>2]=p,F=0|vg(0|u,0|p,0|s,0|F),s=0|o(),C[E+72>>2]=F,C[E+72+4>>2]=s,h=0|ZI(F^D,s^h,63),s=0|o(),C[E+32>>2]=h,C[E+32+4>>2]=s,f=w^(Q[A>>0]|Q[A+1>>0]<<8|Q[A+2>>0]<<16|Q[A+3>>0]<<24)^f,I=t^(Q[A+4>>0]|Q[A+4+1>>0]<<8|Q[A+4+2>>0]<<16|Q[A+4+3>>0]<<24)^I,B[A>>0]=f,B[A+1>>0]=f>>8,B[A+2>>0]=f>>16,B[A+3>>0]=f>>24,B[A+4>>0]=I,B[A+4+1>>0]=I>>8,B[A+4+2>>0]=I>>16,B[A+4+3>>0]=I>>24,I=1;yA=E+(I+8<<3)|0,wA=n^(Q[(sA=A+(I<<3)|0)>>0]|Q[sA+1>>0]<<8|Q[sA+2>>0]<<16|Q[sA+3>>0]<<24)^C[yA>>2],yA=r^(Q[sA+4>>0]|Q[sA+4+1>>0]<<8|Q[sA+4+2>>0]<<16|Q[sA+4+3>>0]<<24)^C[yA+4>>2],B[sA>>0]=wA,B[sA+1>>0]=wA>>8,B[sA+2>>0]=wA>>16,B[sA+3>>0]=wA>>24,B[sA+4>>0]=yA,B[sA+4+1>>0]=yA>>8,B[sA+4+2>>0]=yA>>16,B[sA+4+3>>0]=yA>>24,8!=(0|(I=I+1|0));)n=0|C[E+(I<<3)>>2],r=0|C[E+(I<<3)+4>>2];y=g}function h(A,I,g,C){A|=0,g|=0,C|=0;var Q,E,i,e,c,a,n,r,t,f,w,y,s,h,D,F,p,u,H,k,l,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0,m=0,L=0,x=0,K=0,X=0,j=0,T=0,q=0,V=0,z=0,W=0,O=0,Z=0,$=0,AA=0,IA=0,gA=0,BA=0,CA=0,QA=0,EA=0,iA=0,eA=0,oA=0,cA=0,aA=0,nA=0,rA=0,tA=0,fA=0,wA=0,yA=0,sA=0,hA=0,DA=0,FA=0,pA=0,uA=0,HA=0,kA=0,lA=0,_A=0,GA=0,dA=0,YA=0,MA=0,SA=0,UA=0,vA=0,bA=0,JA=0,PA=0,RA=0,NA=0,mA=0,LA=0,xA=0,KA=0,XA=0,jA=0,TA=0,qA=0,VA=0,zA=0,WA=0,OA=0,ZA=0,$A=0,AI=0,II=0,gI=0,BI=0,CI=0,QI=0,EI=0,iI=0,eI=0,oI=0,cI=0,aI=0,nI=0,rI=0,tI=0,fI=0,wI=0,yI=0,sI=0,hI=0,DI=0,FI=0,pI=0,uI=0,HI=0,lI=0,_I=0,GI=0,dI=0,YI=0,MI=0,SI=0,UI=0,vI=0,bI=0,JI=0,PI=0,RI=0,NI=0,mI=0,LI=0,xI=0,KI=0,XI=0,jI=0,TI=0,qI=0,VI=0,zI=0,WI=0,OI=0,ZI=0,$I=0,Ag=0,Ig=0,gg=0,Cg=0,Eg=0,eg=0,og=0,cg=0,ag=0,ng=0,tg=0,fg=0,wg=0,sg=0,hg=0,Dg=0,Fg=0,pg=0,ug=0;wA=0|Bg(0|B[(I|=0)>>0],0|B[I+1>>0],0|B[I+2>>0]),o(),UI=0|yg(0|(UI=0|kI(I+2|0)),0|o(),5),o(),uI=0|yg(0|(uI=0|Bg(0|B[I+5>>0],0|B[I+6>>0],0|B[I+7>>0])),0|o(),2),o(),SI=0|yg(0|(SI=0|kI(I+7|0)),0|o(),7),o(),yI=0|yg(0|(yI=0|kI(I+10|0)),0|o(),4),o(),CA=0|yg(0|(CA=0|Bg(0|B[I+13>>0],0|B[I+14>>0],0|B[I+15>>0])),0|o(),1),o(),FA=0|yg(0|(FA=0|kI(I+15|0)),0|o(),6),o(),_=0|yg(0|(_=0|Bg(0|B[I+18>>0],0|B[I+19>>0],0|B[I+20>>0])),0|o(),3),o(),QA=0|Bg(0|B[I+21>>0],0|B[I+22>>0],0|B[I+23>>0]),o(),q=0|yg(0|(q=0|kI(I+23|0)),0|o(),5),o(),HA=0|yg(0|(HA=0|Bg(0|B[I+26>>0],0|B[I+27>>0],0|B[I+28>>0])),0|o(),2),o(),GA=0|yg(0|(GA=0|kI(I+28|0)),0|o(),7),dA=0|o(),XI=0|Bg(0|B[g>>0],0|B[g+1>>0],0|B[g+2>>0]),o(),hI=0|yg(0|(hI=0|kI(g+2|0)),0|o(),5),o(),gI=0|yg(0|(gI=0|Bg(0|B[g+5>>0],0|B[g+6>>0],0|B[g+7>>0])),0|o(),2),o(),G=0|yg(0|(G=0|kI(g+7|0)),0|o(),7),o(),d=0|yg(0|(d=0|kI(g+10|0)),0|o(),4),o(),x=0|yg(0|(x=0|Bg(0|B[g+13>>0],0|B[g+14>>0],0|B[g+15>>0])),0|o(),1),o(),zA=0|yg(0|(zA=0|kI(g+15|0)),0|o(),6),o(),sA=0|yg(0|(sA=0|Bg(0|B[g+18>>0],0|B[g+19>>0],0|B[g+20>>0])),0|o(),3),o(),RA=0|Bg(0|B[g+21>>0],0|B[g+22>>0],0|B[g+23>>0]),o(),IA=0|yg(0|(IA=0|kI(g+23|0)),0|o(),5),o(),NI=0|yg(0|(NI=0|Bg(0|B[g+26>>0],0|B[g+27>>0],0|B[g+28>>0])),0|o(),2),o(),rA=0|yg(0|(rA=0|kI(g+28|0)),0|o(),7),nA=0|o(),LA=0|Bg(0|B[C>>0],0|B[C+1>>0],0|B[C+2>>0]),o(),BA=0|yg(0|(BA=0|kI(C+2|0)),0|o(),5),o(),KA=0|yg(0|(KA=0|Bg(0|B[C+5>>0],0|B[C+6>>0],0|B[C+7>>0])),0|o(),2),o(),bA=0|yg(0|(bA=0|kI(C+7|0)),0|o(),7),o(),PA=0|yg(0|(PA=0|kI(C+10|0)),0|o(),4),o(),WA=0|yg(0|(WA=0|Bg(0|B[C+13>>0],0|B[C+14>>0],0|B[C+15>>0])),0|o(),1),o(),_I=0|yg(0|(_I=0|kI(C+15|0)),0|o(),6),o(),U=0|yg(0|(U=0|Bg(0|B[C+18>>0],0|B[C+19>>0],0|B[C+20>>0])),0|o(),3),o(),cI=0|Bg(0|B[C+21>>0],0|B[C+22>>0],0|B[C+23>>0]),o(),TA=0|yg(0|(TA=0|kI(C+23|0)),0|o(),5),o(),tA=0|yg(0|(tA=0|Bg(0|B[C+26>>0],0|B[C+27>>0],0|B[C+28>>0])),0|o(),2),o(),FI=0|yg(0|(FI=0|kI(C+28|0)),0|o(),7),GI=0|o(),mA=0|vg(2097151&LA|0,0,0|(mA=0|Qg(2097151&XI|0,0,2097151&wA|0,0)),0|o()),LA=0|o(),F=0|Qg(2097151&hI|0,0,2097151&wA|0,0),D=0|o(),h=0|Qg(2097151&XI|0,0,2097151&UI|0,0),$A=0|o(),Z=0|Qg(2097151&gI|0,0,2097151&wA|0,0),xA=0|o(),KA=0|vg(0|(xA=0|vg(0|(vA=0|vg(0|(O=0|Qg(2097151&hI|0,0,2097151&UI|0,0)),0|o(),0|(vA=0|Qg(2097151&XI|0,0,2097151&uI|0,0)),0|o())),0|o(),0|Z,0|xA)),0|o(),2097151&KA|0,0),xA=0|o(),Z=0|Qg(2097151&G|0,0,2097151&wA|0,0),vA=0|o(),l=0|Qg(2097151&gI|0,0,2097151&UI|0,0),O=0|o(),s=0|Qg(2097151&hI|0,0,2097151&uI|0,0),y=0|o(),w=0|Qg(2097151&XI|0,0,2097151&SI|0,0),ug=0|o(),aA=0|Qg(2097151&d|0,0,2097151&wA|0,0),JA=0|o(),sg=0|Qg(2097151&G|0,0,2097151&UI|0,0),OA=0|o(),Dg=0|Qg(2097151&gI|0,0,2097151&uI|0,0),P=0|o(),PA=0|vg(0|(JA=0|vg(0|(OA=0|vg(0|(P=0|vg(0|(hg=0|vg(0|(Fg=0|Qg(2097151&hI|0,0,2097151&SI|0,0)),0|o(),0|(hg=0|Qg(2097151&XI|0,0,2097151&yI|0,0)),0|o())),0|o(),0|Dg,0|P)),0|o(),0|sg,0|OA)),0|o(),0|aA,0|JA)),0|o(),2097151&PA|0,0),JA=0|o(),aA=0|Qg(2097151&x|0,0,2097151&wA|0,0),OA=0|o(),sg=0|Qg(2097151&d|0,0,2097151&UI|0,0),P=0|o(),Dg=0|Qg(2097151&G|0,0,2097151&uI|0,0),hg=0|o(),k=0|Qg(2097151&gI|0,0,2097151&SI|0,0),Fg=0|o(),f=0|Qg(2097151&hI|0,0,2097151&yI|0,0),t=0|o(),r=0|Qg(2097151&XI|0,0,2097151&CA|0,0),pg=0|o(),I=0|Qg(2097151&zA|0,0,2097151&wA|0,0),DI=0|o(),Eg=0|Qg(2097151&x|0,0,2097151&UI|0,0),Y=0|o(),og=0|Qg(2097151&d|0,0,2097151&uI|0,0),S=0|o(),ag=0|Qg(2097151&G|0,0,2097151&SI|0,0),eg=0|o(),tg=0|Qg(2097151&gI|0,0,2097151&yI|0,0),cg=0|o(),_I=0|vg(0|(DI=0|vg(0|(Y=0|vg(0|(S=0|vg(0|(eg=0|vg(0|(cg=0|vg(0|(ng=0|vg(0|(fg=0|Qg(2097151&hI|0,0,2097151&CA|0,0)),0|o(),0|(ng=0|Qg(2097151&XI|0,0,2097151&FA|0,0)),0|o())),0|o(),0|tg,0|cg)),0|o(),0|ag,0|eg)),0|o(),0|og,0|S)),0|o(),0|Eg,0|Y)),0|o(),0|I,0|DI)),0|o(),2097151&_I|0,0),DI=0|o(),I=0|Qg(2097151&sA|0,0,2097151&wA|0,0),Y=0|o(),Eg=0|Qg(2097151&zA|0,0,2097151&UI|0,0),S=0|o(),og=0|Qg(2097151&x|0,0,2097151&uI|0,0),eg=0|o(),ag=0|Qg(2097151&d|0,0,2097151&SI|0,0),cg=0|o(),tg=0|Qg(2097151&G|0,0,2097151&yI|0,0),ng=0|o(),H=0|Qg(2097151&gI|0,0,2097151&CA|0,0),fg=0|o(),n=0|Qg(2097151&hI|0,0,2097151&FA|0,0),a=0|o(),c=0|Qg(2097151&XI|0,0,2097151&_|0,0),wg=0|o(),qI=0|Qg(2097151&RA|0,0,2097151&wA|0,0),M=0|o(),T=0|Qg(2097151&sA|0,0,2097151&UI|0,0),aI=0|o(),jI=0|Qg(2097151&zA|0,0,2097151&uI|0,0),TI=0|o(),zI=0|Qg(2097151&x|0,0,2097151&SI|0,0),j=0|o(),OI=0|Qg(2097151&d|0,0,2097151&yI|0,0),VI=0|o(),$I=0|Qg(2097151&G|0,0,2097151&CA|0,0),WI=0|o(),Ig=0|Qg(2097151&gI|0,0,2097151&FA|0,0),ZI=0|o(),cI=0|vg(0|(aI=0|vg(0|(M=0|vg(0|(TI=0|vg(0|(j=0|vg(0|(VI=0|vg(0|(WI=0|vg(0|(ZI=0|vg(0|(Ag=0|vg(0|(gg=0|Qg(2097151&hI|0,0,2097151&_|0,0)),0|o(),0|(Ag=0|Qg(2097151&XI|0,0,2097151&QA|0,0)),0|o())),0|o(),0|Ig,0|ZI)),0|o(),0|$I,0|WI)),0|o(),0|OI,0|VI)),0|o(),0|zI,0|j)),0|o(),0|jI,0|TI)),0|o(),0|qI,0|M)),0|o(),0|T,0|aI)),0|o(),2097151&cI|0,0),aI=0|o(),T=0|Qg(2097151&IA|0,0,2097151&wA|0,0),M=0|o(),qI=0|Qg(2097151&RA|0,0,2097151&UI|0,0),TI=0|o(),jI=0|Qg(2097151&sA|0,0,2097151&uI|0,0),j=0|o(),zI=0|Qg(2097151&zA|0,0,2097151&SI|0,0),VI=0|o(),OI=0|Qg(2097151&x|0,0,2097151&yI|0,0),WI=0|o(),$I=0|Qg(2097151&d|0,0,2097151&CA|0,0),ZI=0|o(),Ig=0|Qg(2097151&G|0,0,2097151&FA|0,0),Ag=0|o(),u=0|Qg(2097151&gI|0,0,2097151&_|0,0),gg=0|o(),e=0|Qg(2097151&hI|0,0,2097151&QA|0,0),i=0|o(),E=0|Qg(2097151&XI|0,0,2097151&q|0,0),Cg=0|o(),yA=0|Qg(2097151&NI|0,0,2097151&wA|0,0),fA=0|o(),W=0|Qg(2097151&IA|0,0,2097151&UI|0,0),z=0|o(),iI=0|Qg(2097151&RA|0,0,2097151&uI|0,0),EI=0|o(),JI=0|Qg(2097151&sA|0,0,2097151&SI|0,0),bI=0|o(),EA=0|Qg(2097151&zA|0,0,2097151&yI|0,0),b=0|o(),lI=0|Qg(2097151&x|0,0,2097151&CA|0,0),HI=0|o(),II=0|Qg(2097151&d|0,0,2097151&FA|0,0),AI=0|o(),rI=0|Qg(2097151&G|0,0,2097151&_|0,0),nI=0|o(),V=0|Qg(2097151&gI|0,0,2097151&QA|0,0),C=0|o(),tA=0|vg(0|(fA=0|vg(0|(z=0|vg(0|(bI=0|vg(0|(EI=0|vg(0|(b=0|vg(0|(HI=0|vg(0|(AI=0|vg(0|(nI=0|vg(0|(C=0|vg(0|(xI=0|vg(0|Qg(2097151&hI|0,0,2097151&q|0,0),0|(LI=0|o()),0|(xI=0|Qg(2097151&XI|0,0,2097151&HA|0,0)),0|o())),0|o(),0|V,0|C)),0|o(),0|rI,0|nI)),0|o(),0|II,0|AI)),0|o(),0|lI,0|HI)),0|o(),0|EA,0|b)),0|o(),0|iI,0|EI)),0|o(),0|JI,0|bI)),0|o(),0|W,0|z)),0|o(),0|yA,0|fA)),0|o(),2097151&tA|0,0),fA=0|o(),wA=0|Qg(0|rA,0|nA,2097151&wA|0,0),yA=0|o(),z=0|Qg(2097151&NI|0,0,2097151&UI|0,0),W=0|o(),bI=0|Qg(2097151&IA|0,0,2097151&uI|0,0),JI=0|o(),EI=0|Qg(2097151&RA|0,0,2097151&SI|0,0),iI=0|o(),b=0|Qg(2097151&sA|0,0,2097151&yI|0,0),EA=0|o(),HI=0|Qg(2097151&zA|0,0,2097151&CA|0,0),lI=0|o(),AI=0|Qg(2097151&x|0,0,2097151&FA|0,0),II=0|o(),nI=0|Qg(2097151&d|0,0,2097151&_|0,0),rI=0|o(),C=0|Qg(2097151&G|0,0,2097151&QA|0,0),V=0|o(),xI=0|Qg(2097151&gI|0,0,2097151&q|0,0),LI=0|o(),p=0|Qg(2097151&hI|0,0,2097151&HA|0,0),Q=0|o(),XI=0|Qg(2097151&XI|0,0,0|GA,0|dA),KI=0|o(),UI=0|Qg(0|rA,0|nA,2097151&UI|0,0),vI=0|o(),hA=0|Qg(2097151&NI|0,0,2097151&uI|0,0),pI=0|o(),PI=0|Qg(2097151&IA|0,0,2097151&SI|0,0),N=0|o(),uA=0|Qg(2097151&RA|0,0,2097151&yI|0,0),cA=0|o(),oA=0|Qg(2097151&sA|0,0,2097151&CA|0,0),RI=0|o(),SA=0|Qg(2097151&zA|0,0,2097151&FA|0,0),L=0|o(),kA=0|Qg(2097151&x|0,0,2097151&_|0,0),UA=0|o(),fI=0|Qg(2097151&d|0,0,2097151&QA|0,0),YA=0|o(),sI=0|Qg(2097151&G|0,0,2097151&q|0,0),tI=0|o(),vI=0|vg(0|(pI=0|vg(0|(N=0|vg(0|(RI=0|vg(0|(cA=0|vg(0|(L=0|vg(0|(UA=0|vg(0|(YA=0|vg(0|(tI=0|vg(0|(hI=0|vg(0|(MI=0|Qg(2097151&gI|0,0,2097151&HA|0,0)),0|(BI=0|o()),0|(hI=0|Qg(2097151&hI|0,0,0|GA,0|dA)),0|o())),0|o(),0|sI,0|tI)),0|o(),0|fI,0|YA)),0|o(),0|kA,0|UA)),0|o(),0|SA,0|L)),0|o(),0|uA,0|cA)),0|o(),0|oA,0|RI)),0|o(),0|PI,0|N)),0|o(),0|hA,0|pI)),0|o(),0|UI,0|vI),UI=0|o(),uI=0|Qg(0|rA,0|nA,2097151&uI|0,0),pI=0|o(),hA=0|Qg(2097151&NI|0,0,2097151&SI|0,0),N=0|o(),PI=0|Qg(2097151&IA|0,0,2097151&yI|0,0),RI=0|o(),oA=0|Qg(2097151&RA|0,0,2097151&CA|0,0),cA=0|o(),uA=0|Qg(2097151&sA|0,0,2097151&FA|0,0),L=0|o(),SA=0|Qg(2097151&zA|0,0,2097151&_|0,0),UA=0|o(),kA=0|Qg(2097151&x|0,0,2097151&QA|0,0),YA=0|o(),fI=0|Qg(2097151&d|0,0,2097151&q|0,0),tI=0|o(),sI=0|Qg(2097151&G|0,0,2097151&HA|0,0),hI=0|o(),gI=0|Qg(2097151&gI|0,0,0|GA,0|dA),BI=0|o(),SI=0|Qg(0|rA,0|nA,2097151&SI|0,0),MI=0|o(),dI=0|Qg(2097151&NI|0,0,2097151&yI|0,0),wI=0|o(),K=0|Qg(2097151&IA|0,0,2097151&CA|0,0),YI=0|o(),qA=0|Qg(2097151&RA|0,0,2097151&FA|0,0),$=0|o(),J=0|Qg(2097151&sA|0,0,2097151&_|0,0),g=0|o(),v=0|Qg(2097151&zA|0,0,2097151&QA|0,0),ZA=0|o(),pA=0|Qg(2097151&x|0,0,2097151&q|0,0),DA=0|o(),MI=0|vg(0|(wI=0|vg(0|(YI=0|vg(0|(g=0|vg(0|($=0|vg(0|(ZA=0|vg(0|(DA=0|vg(0|(G=0|vg(0|(mI=0|Qg(2097151&d|0,0,2097151&HA|0,0)),0|(m=0|o()),0|(G=0|Qg(2097151&G|0,0,0|GA,0|dA)),0|o())),0|o(),0|pA,0|DA)),0|o(),0|v,0|ZA)),0|o(),0|qA,0|$)),0|o(),0|J,0|g)),0|o(),0|K,0|YI)),0|o(),0|dI,0|wI)),0|o(),0|SI,0|MI),SI=0|o(),yI=0|Qg(0|rA,0|nA,2097151&yI|0,0),wI=0|o(),dI=0|Qg(2097151&NI|0,0,2097151&CA|0,0),YI=0|o(),K=0|Qg(2097151&IA|0,0,2097151&FA|0,0),g=0|o(),J=0|Qg(2097151&RA|0,0,2097151&_|0,0),$=0|o(),qA=0|Qg(2097151&sA|0,0,2097151&QA|0,0),ZA=0|o(),v=0|Qg(2097151&zA|0,0,2097151&q|0,0),DA=0|o(),pA=0|Qg(2097151&x|0,0,2097151&HA|0,0),G=0|o(),d=0|Qg(2097151&d|0,0,0|GA,0|dA),m=0|o(),CA=0|Qg(0|rA,0|nA,2097151&CA|0,0),mI=0|o(),QI=0|Qg(2097151&NI|0,0,2097151&FA|0,0),gA=0|o(),_A=0|Qg(2097151&IA|0,0,2097151&_|0,0),CI=0|o(),X=0|Qg(2097151&RA|0,0,2097151&QA|0,0),iA=0|o(),eA=0|Qg(2097151&sA|0,0,2097151&q|0,0),lA=0|o(),mI=0|vg(0|(gA=0|vg(0|(CI=0|vg(0|(lA=0|vg(0|(iA=0|vg(0|(x=0|vg(0|(R=0|Qg(2097151&zA|0,0,2097151&HA|0,0)),0|(VA=0|o()),0|(x=0|Qg(2097151&x|0,0,0|GA,0|dA)),0|o())),0|o(),0|X,0|iA)),0|o(),0|eA,0|lA)),0|o(),0|_A,0|CI)),0|o(),0|QI,0|gA)),0|o(),0|CA,0|mI),CA=0|o(),FA=0|Qg(0|rA,0|nA,2097151&FA|0,0),gA=0|o(),QI=0|Qg(2097151&NI|0,0,2097151&_|0,0),CI=0|o(),_A=0|Qg(2097151&IA|0,0,2097151&QA|0,0),lA=0|o(),eA=0|Qg(2097151&RA|0,0,2097151&q|0,0),iA=0|o(),X=0|Qg(2097151&sA|0,0,2097151&HA|0,0),x=0|o(),zA=0|Qg(2097151&zA|0,0,0|GA,0|dA),VA=0|o(),_=0|Qg(0|rA,0|nA,2097151&_|0,0),R=0|o(),XA=0|Qg(2097151&NI|0,0,2097151&QA|0,0),AA=0|o(),oI=0|Qg(2097151&IA|0,0,2097151&q|0,0),jA=0|o(),NA=0|Qg(2097151&RA|0,0,2097151&HA|0,0),eI=0|o(),R=0|vg(0|(AA=0|vg(0|(jA=0|vg(0|(eI=0|vg(0|(sA=0|Qg(2097151&sA|0,0,0|GA,0|dA)),0|o(),0|NA,0|eI)),0|o(),0|oI,0|jA)),0|o(),0|XA,0|AA)),0|o(),0|_,0|R),_=0|o(),QA=0|Qg(0|rA,0|nA,2097151&QA|0,0),AA=0|o(),XA=0|Qg(2097151&NI|0,0,2097151&q|0,0),jA=0|o(),oI=0|Qg(2097151&IA|0,0,2097151&HA|0,0),eI=0|o(),RA=0|Qg(2097151&RA|0,0,0|GA,0|dA),NA=0|o(),q=0|Qg(0|rA,0|nA,2097151&q|0,0),sA=0|o(),sA=0|vg(0|(IA=0|vg(0|Qg(2097151&NI|0,0,2097151&HA|0,0),0|(MA=0|o()),0|(IA=0|Qg(2097151&IA|0,0,0|GA,0|dA)),0|o())),0|o(),0|q,0|sA),q=0|o(),NI=0|vg(0|(HA=0|Qg(0|rA,0|nA,2097151&HA|0,0)),0|(IA=0|o()),0|(NI=0|Qg(2097151&NI|0,0,0|GA,0|dA)),0|o()),IA=0|o(),dA=0|Qg(0|rA,0|nA,0|GA,0|dA),GA=0|o(),HA=0|yg(0|(nA=0|vg(0|mA,0|LA,1048576,0)),0|(rA=0|o()),21),MA=0|o(),MA=0|vg(0|(BA=0|vg(0|($A=0|vg(0|F,0|D,0|h,0|$A)),0|o(),2097151&BA|0,0)),0|o(),0|HA,0|MA),HA=0|o(),rA=0|Ug(0|mA,0|LA,-2097152&nA|0,4095&rA|0),nA=0|o(),BA=0|yg(0|(LA=0|vg(0|KA,0|xA,1048576,0)),0|(mA=0|o()),21),$A=0|o(),$A=0|vg(0|(bA=0|vg(0|(vA=0|vg(0|(O=0|vg(0|(ug=0|vg(0|s,0|y,0|w,0|ug)),0|o(),0|l,0|O)),0|o(),0|Z,0|vA)),0|o(),2097151&bA|0,0)),0|o(),0|BA,0|$A),BA=0|o(),Z=0|ig(0|(bA=0|vg(0|PA,0|JA,1048576,0)),0|(vA=0|o()),21),O=0|o(),O=0|vg(0|(WA=0|vg(0|(OA=0|vg(0|(P=0|vg(0|(hg=0|vg(0|(Fg=0|vg(0|(pg=0|vg(0|f,0|t,0|r,0|pg)),0|o(),0|k,0|Fg)),0|o(),0|Dg,0|hg)),0|o(),0|sg,0|P)),0|o(),0|aA,0|OA)),0|o(),2097151&WA|0,0)),0|o(),0|Z,0|O),Z=0|o(),aA=0|ig(0|(WA=0|vg(0|_I,0|DI,1048576,0)),0|(OA=0|o()),21),P=0|o(),P=0|vg(0|(U=0|vg(0|(Y=0|vg(0|(S=0|vg(0|(eg=0|vg(0|(cg=0|vg(0|(ng=0|vg(0|(fg=0|vg(0|(wg=0|vg(0|n,0|a,0|c,0|wg)),0|o(),0|H,0|fg)),0|o(),0|tg,0|ng)),0|o(),0|ag,0|cg)),0|o(),0|og,0|eg)),0|o(),0|Eg,0|S)),0|o(),0|I,0|Y)),0|o(),2097151&U|0,0)),0|o(),0|aA,0|P),aA=0|o(),I=0|ig(0|(U=0|vg(0|cI,0|aI,1048576,0)),0|(Y=0|o()),21),S=0|o(),S=0|vg(0|(TA=0|vg(0|(M=0|vg(0|(j=0|vg(0|(TI=0|vg(0|(VI=0|vg(0|(WI=0|vg(0|(ZI=0|vg(0|(Ag=0|vg(0|(gg=0|vg(0|(Cg=0|vg(0|e,0|i,0|E,0|Cg)),0|o(),0|u,0|gg)),0|o(),0|Ig,0|Ag)),0|o(),0|$I,0|ZI)),0|o(),0|OI,0|WI)),0|o(),0|zI,0|VI)),0|o(),0|qI,0|TI)),0|o(),0|jI,0|j)),0|o(),0|T,0|M)),0|o(),2097151&TA|0,0)),0|o(),0|I,0|S),I=0|o(),T=0|ig(0|(TA=0|vg(0|tA,0|fA,1048576,0)),0|(M=0|o()),21),j=0|o(),j=0|vg(0|(GI=0|vg(0|(W=0|vg(0|(yA=0|vg(0|(JI=0|vg(0|(EA=0|vg(0|(iI=0|vg(0|(lI=0|vg(0|(II=0|vg(0|(rI=0|vg(0|(V=0|vg(0|(LI=0|vg(0|(KI=0|vg(0|p,0|Q,0|XI,0|KI)),0|o(),0|xI,0|LI)),0|o(),0|C,0|V)),0|o(),0|nI,0|rI)),0|o(),0|AI,0|II)),0|o(),0|HI,0|lI)),0|o(),0|EI,0|iI)),0|o(),0|b,0|EA)),0|o(),0|bI,0|JI)),0|o(),0|wA,0|yA)),0|o(),0|z,0|W)),0|o(),0|FI,0|GI)),0|o(),0|T,0|j),T=0|o(),W=0|ig(0|(GI=0|vg(0|vI,0|UI,1048576,0)),0|(FI=0|o()),21),z=0|o(),z=0|vg(0|(pI=0|vg(0|(N=0|vg(0|(RI=0|vg(0|(L=0|vg(0|(cA=0|vg(0|(UA=0|vg(0|(YA=0|vg(0|(tI=0|vg(0|(BI=0|vg(0|sI,0|hI,0|gI,0|BI)),0|o(),0|fI,0|tI)),0|o(),0|kA,0|YA)),0|o(),0|SA,0|UA)),0|o(),0|oA,0|cA)),0|o(),0|uA,0|L)),0|o(),0|PI,0|RI)),0|o(),0|hA,0|N)),0|o(),0|uI,0|pI)),0|o(),0|W,0|z),W=0|o(),N=0|ig(0|(pI=0|vg(0|MI,0|SI,1048576,0)),0|(uI=0|o()),21),hA=0|o(),hA=0|vg(0|(wI=0|vg(0|(YI=0|vg(0|(g=0|vg(0|(ZA=0|vg(0|($=0|vg(0|(DA=0|vg(0|(m=0|vg(0|pA,0|G,0|d,0|m)),0|o(),0|v,0|DA)),0|o(),0|J,0|$)),0|o(),0|qA,0|ZA)),0|o(),0|K,0|g)),0|o(),0|dI,0|YI)),0|o(),0|yI,0|wI)),0|o(),0|N,0|hA),N=0|o(),YI=0|ig(0|(wI=0|vg(0|mI,0|CA,1048576,0)),0|(yI=0|o()),21),dI=0|o(),dI=0|vg(0|(gA=0|vg(0|(CI=0|vg(0|(lA=0|vg(0|(x=0|vg(0|(VA=0|vg(0|eA,0|iA,0|zA,0|VA)),0|o(),0|X,0|x)),0|o(),0|_A,0|lA)),0|o(),0|QI,0|CI)),0|o(),0|FA,0|gA)),0|o(),0|YI,0|dI),YI=0|o(),CI=0|ig(0|(gA=0|vg(0|R,0|_,1048576,0)),0|(FA=0|o()),21),QI=0|o(),QI=0|vg(0|(AA=0|vg(0|(jA=0|vg(0|(NA=0|vg(0|oI,0|eI,0|RA,0|NA)),0|o(),0|XA,0|jA)),0|o(),0|QA,0|AA)),0|o(),0|CI,0|QI),CI=0|o(),FA=0|Ug(0|R,0|_,-2097152&gA|0,0|FA),gA=0|o(),AA=0|vg(0|NI,0|IA,0|(AA=0|ig(0|(_=0|vg(0|sA,0|q,1048576,0)),0|(R=0|o()),21)),0|o()),IA=0|o(),R=0|Ug(0|sA,0|q,-2097152&_|0,0|R),_=0|o(),NI=0|ig(0|(q=0|vg(0|dA,0|GA,1048576,0)),0|(sA=0|o()),21),QA=0|o(),sA=0|Ug(0|dA,0|GA,-2097152&q|0,0|sA),q=0|o(),jA=0|yg(0|(GA=0|vg(0|MA,0|HA,1048576,0)),0|(dA=0|o()),21),XA=0|o(),dA=0|Ug(0|MA,0|HA,-2097152&GA|0,0|dA),GA=0|o(),NA=0|ig(0|(HA=0|vg(0|$A,0|BA,1048576,0)),0|(MA=0|o()),21),RA=0|o(),MA=0|Ug(0|$A,0|BA,-2097152&HA|0,0|MA),HA=0|o(),eI=0|ig(0|(BA=0|vg(0|O,0|Z,1048576,0)),0|($A=0|o()),21),oI=0|o(),$A=0|Ug(0|O,0|Z,-2097152&BA|0,0|$A),BA=0|o(),lA=0|ig(0|(Z=0|vg(0|P,0|aA,1048576,0)),0|(O=0|o()),21),_A=0|o(),VA=0|ig(0|(x=0|vg(0|S,0|I,1048576,0)),0|(X=0|o()),21),zA=0|o(),g=0|ig(0|(iA=0|vg(0|j,0|T,1048576,0)),0|(eA=0|o()),21),K=0|o(),$=0|ig(0|(ZA=0|vg(0|z,0|W,1048576,0)),0|(qA=0|o()),21),J=0|o(),m=0|ig(0|(DA=0|vg(0|hA,0|N,1048576,0)),0|(v=0|o()),21),d=0|o(),gA=0|vg(0|(RI=0|ig(0|(G=0|vg(0|dI,0|YI,1048576,0)),0|(pA=0|o()),21)),0|o(),0|FA,0|gA),FA=0|o(),pA=0|Ug(0|dI,0|YI,-2097152&G|0,0|pA),G=0|o(),_=0|vg(0|(RI=0|ig(0|(YI=0|vg(0|QI,0|CI,1048576,0)),0|(dI=0|o()),21)),0|o(),0|R,0|_),R=0|o(),dI=0|Ug(0|QI,0|CI,-2097152&YI|0,0|dI),YI=0|o(),q=0|vg(0|(RI=0|ig(0|(CI=0|vg(0|AA,0|IA,1048576,0)),0|(QI=0|o()),21)),0|o(),0|sA,0|q),sA=0|o(),QI=0|Ug(0|AA,0|IA,-2097152&CI|0,0|QI),CI=0|o(),IA=0|Qg(0|NI,0|QA,666643,0),AA=0|o(),RI=0|Qg(0|NI,0|QA,470296,0),PI=0|o(),L=0|Qg(0|NI,0|QA,654183,0),uA=0|o(),cA=0|Qg(0|NI,0|QA,-997805,-1),oA=0|o(),UA=0|Qg(0|NI,0|QA,136657,0),SA=0|o(),d=0|vg(0|(yI=0|Ug(0|(QA=0|vg(0|mI,0|CA,0|(QA=0|Qg(0|NI,0|QA,-683901,-1)),0|o())),0|o(),-2097152&wI|0,0|yI)),0|o(),0|m,0|d),m=0|o(),yI=0|Qg(0|q,0|sA,666643,0),wI=0|o(),QA=0|Qg(0|q,0|sA,470296,0),CA=0|o(),mI=0|Qg(0|q,0|sA,654183,0),NI=0|o(),YA=0|Qg(0|q,0|sA,-997805,-1),kA=0|o(),tI=0|Qg(0|q,0|sA,136657,0),fI=0|o(),sA=0|Qg(0|q,0|sA,-683901,-1),q=0|o(),BI=0|Qg(0|QI,0|CI,666643,0),gI=0|o(),hI=0|Qg(0|QI,0|CI,470296,0),sI=0|o(),yA=0|Qg(0|QI,0|CI,654183,0),wA=0|o(),JI=0|Qg(0|QI,0|CI,-997805,-1),bI=0|o(),EA=0|Qg(0|QI,0|CI,136657,0),b=0|o(),CI=0|Qg(0|QI,0|CI,-683901,-1),QI=0|o(),J=0|vg(0|(uI=0|Ug(0|(QI=0|vg(0|(fI=0|vg(0|(oA=0|vg(0|MI,0|SI,0|cA,0|oA)),0|o(),0|tI,0|fI)),0|o(),0|CI,0|QI)),0|o(),-2097152&pI|0,0|uI)),0|o(),0|$,0|J),$=0|o(),uI=0|Qg(0|_,0|R,666643,0),pI=0|o(),QI=0|Qg(0|_,0|R,470296,0),CI=0|o(),fI=0|Qg(0|_,0|R,654183,0),tI=0|o(),oA=0|Qg(0|_,0|R,-997805,-1),cA=0|o(),SI=0|Qg(0|_,0|R,136657,0),MI=0|o(),R=0|Qg(0|_,0|R,-683901,-1),_=0|o(),iI=0|Qg(0|dI,0|YI,666643,0),EI=0|o(),lI=0|Qg(0|dI,0|YI,470296,0),HI=0|o(),II=0|Qg(0|dI,0|YI,654183,0),AI=0|o(),rI=0|Qg(0|dI,0|YI,-997805,-1),nI=0|o(),V=0|Qg(0|dI,0|YI,136657,0),C=0|o(),YI=0|Qg(0|dI,0|YI,-683901,-1),dI=0|o(),K=0|vg(0|(FI=0|Ug(0|(dI=0|vg(0|(MI=0|vg(0|(UI=0|vg(0|(bI=0|vg(0|(PI=0|vg(0|mI,0|NI,0|RI,0|PI)),0|o(),0|JI,0|bI)),0|o(),0|vI,0|UI)),0|o(),0|SI,0|MI)),0|o(),0|YI,0|dI)),0|o(),-2097152&GI|0,0|FI)),0|o(),0|g,0|K),g=0|o(),OA=0|Ug(0|(oI=0|vg(0|(FI=0|vg(0|_I,0|DI,0|(FI=0|Qg(0|gA,0|FA,666643,0)),0|o())),0|o(),0|eI,0|oI)),0|o(),-2097152&WA|0,0|OA),WA=0|o(),oI=0|Qg(0|gA,0|FA,470296,0),eI=0|o(),FI=0|Qg(0|gA,0|FA,654183,0),DI=0|o(),_A=0|vg(0|(Y=0|Ug(0|(aI=0|vg(0|(DI=0|vg(0|(pI=0|vg(0|lI,0|HI,0|uI,0|pI)),0|o(),0|FI,0|DI)),0|o(),0|cI,0|aI)),0|o(),-2097152&U|0,0|Y)),0|o(),0|lA,0|_A),lA=0|o(),Y=0|Qg(0|gA,0|FA,-997805,-1),U=0|o(),aI=0|Qg(0|gA,0|FA,136657,0),cI=0|o(),M=0|Ug(0|(zA=0|vg(0|(fA=0|vg(0|(cI=0|vg(0|(nI=0|vg(0|(tI=0|vg(0|(wI=0|vg(0|hI,0|sI,0|yI,0|wI)),0|o(),0|fI,0|tI)),0|o(),0|rI,0|nI)),0|o(),0|aI,0|cI)),0|o(),0|tA,0|fA)),0|o(),0|VA,0|zA)),0|o(),-2097152&TA|0,0|M),TA=0|o(),FA=0|Qg(0|gA,0|FA,-683901,-1),gA=0|o(),fA=0|ig(0|(zA=0|vg(0|OA,0|WA,1048576,0)),0|(VA=0|o()),21),tA=0|o(),tA=0|vg(0|(O=0|Ug(0|(aA=0|vg(0|(EI=0|vg(0|oI,0|eI,0|iI,0|EI)),0|o(),0|P,0|aA)),0|o(),-2097152&Z|0,0|O)),0|o(),0|fA,0|tA),fA=0|o(),aA=0|ig(0|(O=0|vg(0|_A,0|lA,1048576,0)),0|(Z=0|o()),21),P=0|o(),P=0|vg(0|(X=0|Ug(0|(I=0|vg(0|(U=0|vg(0|(AI=0|vg(0|(gI=0|vg(0|QI,0|CI,0|BI,0|gI)),0|o(),0|II,0|AI)),0|o(),0|Y,0|U)),0|o(),0|S,0|I)),0|o(),-2097152&x|0,0|X)),0|o(),0|aA,0|P),aA=0|o(),I=0|ig(0|(X=0|vg(0|M,0|TA,1048576,0)),0|(x=0|o()),21),S=0|o(),S=0|vg(0|(eA=0|Ug(0|(T=0|vg(0|(gA=0|vg(0|(C=0|vg(0|(cA=0|vg(0|(wA=0|vg(0|(AA=0|vg(0|QA,0|CA,0|IA,0|AA)),0|o(),0|yA,0|wA)),0|o(),0|oA,0|cA)),0|o(),0|V,0|C)),0|o(),0|FA,0|gA)),0|o(),0|j,0|T)),0|o(),-2097152&iA|0,0|eA)),0|o(),0|I,0|S),I=0|o(),T=0|ig(0|(eA=0|vg(0|K,0|g,1048576,0)),0|(iA=0|o()),21),j=0|o(),j=0|vg(0|(qA=0|Ug(0|(W=0|vg(0|(_=0|vg(0|(b=0|vg(0|(uA=0|vg(0|YA,0|kA,0|L,0|uA)),0|o(),0|EA,0|b)),0|o(),0|R,0|_)),0|o(),0|z,0|W)),0|o(),-2097152&ZA|0,0|qA)),0|o(),0|T,0|j),T=0|o(),iA=0|Ug(0|K,0|g,-2097152&eA|0,0|iA),eA=0|o(),qA=0|ig(0|(g=0|vg(0|J,0|$,1048576,0)),0|(K=0|o()),21),ZA=0|o(),ZA=0|vg(0|(v=0|Ug(0|(N=0|vg(0|(SA=0|vg(0|sA,0|q,0|UA,0|SA)),0|o(),0|hA,0|N)),0|o(),-2097152&DA|0,0|v)),0|o(),0|qA,0|ZA),qA=0|o(),K=0|Ug(0|J,0|$,-2097152&g|0,0|K),g=0|o(),G=0|vg(0|(v=0|ig(0|($=0|vg(0|d,0|m,1048576,0)),0|(J=0|o()),21)),0|o(),0|pA,0|G),pA=0|o(),J=0|Ug(0|d,0|m,-2097152&$|0,0|J),$=0|o(),v=0|ig(0|(m=0|vg(0|tA,0|fA,1048576,0)),0|(d=0|o()),21),DA=0|o(),SA=0|ig(0|(N=0|vg(0|P,0|aA,1048576,0)),0|(hA=0|o()),21),UA=0|o(),eA=0|vg(0|(W=0|ig(0|(q=0|vg(0|S,0|I,1048576,0)),0|(sA=0|o()),21)),0|o(),0|iA,0|eA),iA=0|o(),sA=0|Ug(0|S,0|I,-2097152&q|0,0|sA),q=0|o(),g=0|vg(0|(W=0|ig(0|(I=0|vg(0|j,0|T,1048576,0)),0|(S=0|o()),21)),0|o(),0|K,0|g),K=0|o(),S=0|Ug(0|j,0|T,-2097152&I|0,0|S),I=0|o(),$=0|vg(0|(W=0|ig(0|(T=0|vg(0|ZA,0|qA,1048576,0)),0|(j=0|o()),21)),0|o(),0|J,0|$),J=0|o(),j=0|Ug(0|ZA,0|qA,-2097152&T|0,0|j),T=0|o(),qA=0|vg(0|$A,0|BA,0|(qA=0|Qg(0|G,0|pA,666643,0)),0|o()),BA=0|o(),$A=0|Qg(0|G,0|pA,470296,0),ZA=0|o(),W=0|Qg(0|G,0|pA,654183,0),z=0|o(),_=0|Qg(0|G,0|pA,-997805,-1),R=0|o(),b=0|Qg(0|G,0|pA,136657,0),EA=0|o(),x=0|Ug(0|(UA=0|vg(0|(pA=0|vg(0|M,0|TA,0|(pA=0|Qg(0|G,0|pA,-683901,-1)),0|o())),0|o(),0|SA,0|UA)),0|o(),-2097152&X|0,0|x),X=0|o(),UA=0|Qg(0|$,0|J,666643,0),SA=0|o(),pA=0|vg(0|qA,0|BA,0|(pA=0|Qg(0|$,0|J,470296,0)),0|o()),BA=0|o(),qA=0|Qg(0|$,0|J,654183,0),TA=0|o(),M=0|Qg(0|$,0|J,-997805,-1),G=0|o(),uA=0|Qg(0|$,0|J,136657,0),L=0|o(),J=0|Qg(0|$,0|J,-683901,-1),$=0|o(),kA=0|vg(0|MA,0|HA,0|(kA=0|Qg(0|j,0|T,666643,0)),0|o()),HA=0|o(),MA=0|Qg(0|j,0|T,470296,0),YA=0|o(),gA=0|vg(0|pA,0|BA,0|(gA=0|Qg(0|j,0|T,654183,0)),0|o()),BA=0|o(),pA=0|Qg(0|j,0|T,-997805,-1),FA=0|o(),C=0|Qg(0|j,0|T,136657,0),V=0|o(),T=0|Qg(0|j,0|T,-683901,-1),j=0|o(),j=0|vg(0|(L=0|vg(0|(Z=0|Ug(0|(DA=0|vg(0|(R=0|vg(0|_A,0|lA,0|_,0|R)),0|o(),0|v,0|DA)),0|o(),-2097152&O|0,0|Z)),0|o(),0|uA,0|L)),0|o(),0|T,0|j),T=0|o(),L=0|Qg(0|g,0|K,666643,0),uA=0|o(),Z=0|Qg(0|g,0|K,470296,0),O=0|o(),DA=0|Qg(0|g,0|K,654183,0),v=0|o(),R=0|Qg(0|g,0|K,-997805,-1),_=0|o(),lA=0|Qg(0|g,0|K,136657,0),_A=0|o(),K=0|Qg(0|g,0|K,-683901,-1),g=0|o(),cA=0|Qg(0|S,0|I,666643,0),oA=0|o(),wA=0|Qg(0|S,0|I,470296,0),yA=0|o(),AA=0|Qg(0|S,0|I,654183,0),IA=0|o(),CA=0|Qg(0|S,0|I,-997805,-1),QA=0|o(),U=0|Qg(0|S,0|I,136657,0),Y=0|o(),I=0|Qg(0|S,0|I,-683901,-1),S=0|o(),S=0|vg(0|(_A=0|vg(0|(FA=0|vg(0|(TA=0|vg(0|(VA=0|Ug(0|(WA=0|vg(0|$A,0|ZA,0|OA,0|WA)),0|o(),-2097152&zA|0,0|VA)),0|o(),0|qA,0|TA)),0|o(),0|pA,0|FA)),0|o(),0|lA,0|_A)),0|o(),0|I,0|S),I=0|o(),nA=0|vg(0|(_A=0|Qg(0|eA,0|iA,666643,0)),0|o(),0|rA,0|nA),rA=0|o(),_A=0|Qg(0|eA,0|iA,470296,0),lA=0|o(),FA=0|Qg(0|eA,0|iA,654183,0),pA=0|o(),yA=0|vg(0|(uA=0|vg(0|(pA=0|vg(0|(mA=0|Ug(0|(xA=0|vg(0|jA,0|XA,0|KA,0|xA)),0|o(),-2097152&LA|0,0|mA)),0|o(),0|FA,0|pA)),0|o(),0|L,0|uA)),0|o(),0|wA,0|yA),wA=0|o(),uA=0|Qg(0|eA,0|iA,-997805,-1),L=0|o(),pA=0|Qg(0|eA,0|iA,136657,0),FA=0|o(),QA=0|vg(0|(v=0|vg(0|(FA=0|vg(0|(YA=0|vg(0|(SA=0|vg(0|(vA=0|Ug(0|(JA=0|vg(0|NA,0|RA,0|PA,0|JA)),0|o(),-2097152&bA|0,0|vA)),0|o(),0|UA,0|SA)),0|o(),0|MA,0|YA)),0|o(),0|pA,0|FA)),0|o(),0|DA,0|v)),0|o(),0|CA,0|QA),CA=0|o(),iA=0|Qg(0|eA,0|iA,-683901,-1),eA=0|o(),FA=0|ig(0|(v=0|vg(0|nA,0|rA,1048576,0)),0|(DA=0|o()),21),pA=0|o(),pA=0|vg(0|(oA=0|vg(0|(lA=0|vg(0|dA,0|GA,0|_A,0|lA)),0|o(),0|cA,0|oA)),0|o(),0|FA,0|pA),FA=0|o(),DA=0|Ug(0|nA,0|rA,-2097152&v|0,0|DA),v=0|o(),oA=0|ig(0|(rA=0|vg(0|yA,0|wA,1048576,0)),0|(nA=0|o()),21),cA=0|o(),cA=0|vg(0|(IA=0|vg(0|(O=0|vg(0|(L=0|vg(0|kA,0|HA,0|uA,0|L)),0|o(),0|Z,0|O)),0|o(),0|AA,0|IA)),0|o(),0|oA,0|cA),oA=0|o(),O=0|ig(0|(IA=0|vg(0|QA,0|CA,1048576,0)),0|(AA=0|o()),21),Z=0|o(),Z=0|vg(0|(Y=0|vg(0|(_=0|vg(0|(eA=0|vg(0|gA,0|BA,0|iA,0|eA)),0|o(),0|R,0|_)),0|o(),0|U,0|Y)),0|o(),0|O,0|Z),O=0|o(),_=0|ig(0|(Y=0|vg(0|S,0|I,1048576,0)),0|(U=0|o()),21),R=0|o(),R=0|vg(0|(g=0|vg(0|(V=0|vg(0|(G=0|vg(0|(d=0|Ug(0|(z=0|vg(0|tA,0|fA,0|W,0|z)),0|o(),-2097152&m|0,0|d)),0|o(),0|M,0|G)),0|o(),0|C,0|V)),0|o(),0|K,0|g)),0|o(),0|_,0|R),_=0|o(),U=0|Ug(0|S,0|I,-2097152&Y|0,0|U),Y=0|o(),g=0|ig(0|(I=0|vg(0|j,0|T,1048576,0)),0|(S=0|o()),21),K=0|o(),K=0|vg(0|(hA=0|Ug(0|(aA=0|vg(0|(EA=0|vg(0|J,0|$,0|b,0|EA)),0|o(),0|P,0|aA)),0|o(),-2097152&N|0,0|hA)),0|o(),0|g,0|K),g=0|o(),S=0|Ug(0|j,0|T,-2097152&I|0,0|S),I=0|o(),hA=0|vg(0|sA,0|q,0|(hA=0|ig(0|(T=0|vg(0|x,0|X,1048576,0)),0|(j=0|o()),21)),0|o()),q=0|o(),aA=0|ig(0|(sA=0|vg(0|pA,0|FA,1048576,0)),0|(N=0|o()),21),P=0|o(),$=0|ig(0|(EA=0|vg(0|cA,0|oA,1048576,0)),0|(b=0|o()),21),J=0|o(),G=0|vg(0|U,0|Y,0|(G=0|ig(0|(V=0|vg(0|Z,0|O,1048576,0)),0|(C=0|o()),21)),0|o()),Y=0|o(),d=0|vg(0|S,0|I,0|(d=0|ig(0|(U=0|vg(0|R,0|_,1048576,0)),0|(M=0|o()),21)),0|o()),I=0|o(),M=0|Ug(0|R,0|_,-2097152&U|0,0|M),U=0|o(),S=0|ig(0|(_=0|vg(0|K,0|g,1048576,0)),0|(R=0|o()),21),m=0|o(),R=0|Ug(0|K,0|g,-2097152&_|0,0|R),_=0|o(),z=0|ig(0|(g=0|vg(0|hA,0|q,1048576,0)),0|(K=0|o()),21),W=0|o(),K=0|Ug(0|hA,0|q,-2097152&g|0,0|K),g=0|o(),q=0|vg(0|DA,0|v,0|(q=0|Qg(0|z,0|W,666643,0)),0|o()),v=0|o(),DA=0|Qg(0|z,0|W,470296,0),hA=0|o(),fA=0|Qg(0|z,0|W,654183,0),tA=0|o(),eA=0|Qg(0|z,0|W,-997805,-1),iA=0|o(),BA=0|Qg(0|z,0|W,136657,0),gA=0|o(),W=0|Qg(0|z,0|W,-683901,-1),z=0|o(),v=0|ig(0|q,0|v,21),L=0|o(),v=0|ig(0|(L=0|vg(0|(N=0|Ug(0|(hA=0|vg(0|pA,0|FA,0|DA,0|hA)),0|o(),-2097152&sA|0,0|N)),0|o(),0|v,0|L)),0|o(),21),N=0|o(),v=0|ig(0|(N=0|vg(0|(P=0|vg(0|(nA=0|Ug(0|(tA=0|vg(0|yA,0|wA,0|fA,0|tA)),0|o(),-2097152&rA|0,0|nA)),0|o(),0|aA,0|P)),0|o(),0|v,0|N)),0|o(),21),P=0|o(),v=0|ig(0|(P=0|vg(0|(b=0|Ug(0|(iA=0|vg(0|cA,0|oA,0|eA,0|iA)),0|o(),-2097152&EA|0,0|b)),0|o(),0|v,0|P)),0|o(),21),b=0|o(),v=0|ig(0|(b=0|vg(0|(J=0|vg(0|(AA=0|Ug(0|(gA=0|vg(0|QA,0|CA,0|BA,0|gA)),0|o(),-2097152&IA|0,0|AA)),0|o(),0|$,0|J)),0|o(),0|v,0|b)),0|o(),21),J=0|o(),R=0|ig(0|(_=0|vg(0|(I=0|ig(0|(M=0|vg(0|d,0|I,0|(M=0|ig(0|(U=0|vg(0|(Y=0|ig(0|(v=0|vg(0|G,0|Y,0|(v=0|ig(0|(J=0|vg(0|(C=0|Ug(0|(z=0|vg(0|Z,0|O,0|W,0|z)),0|o(),-2097152&V|0,0|C)),0|o(),0|v,0|J)),0|o(),21)),0|o())),0|o(),21)),0|o(),0|M,0|U)),0|o(),21)),0|o())),0|o(),21)),0|o(),0|R,0|_)),0|o(),21),I=0|o(),q=0|vg(0|(j=0|Qg(0|(K=0|ig(0|(g=0|vg(0|(R=0|ig(0|(I=0|vg(0|(j=0|Ug(0|(X=0|vg(0|S,0|m,0|x,0|X)),0|o(),-2097152&T|0,0|j)),0|o(),0|R,0|I)),0|o(),21)),0|o(),0|K,0|g)),0|o(),21)),0|(R=0|o()),666643,0)),0|o(),2097151&q|0,0),j=0|o(),L=0|vg(0|(T=0|Qg(0|K,0|R,470296,0)),0|o(),2097151&L|0,0),T=0|o(),N=0|vg(0|(X=0|Qg(0|K,0|R,654183,0)),0|o(),2097151&N|0,0),X=0|o(),P=0|vg(0|(x=0|Qg(0|K,0|R,-997805,-1)),0|o(),2097151&P|0,0),x=0|o(),b=0|vg(0|(m=0|Qg(0|K,0|R,136657,0)),0|o(),2097151&b|0,0),m=0|o(),g=0|vg(0|(C=0|ig(0|(I=0|vg(0|(G=0|ig(0|(_=0|vg(0|(Y=0|ig(0|(M=0|vg(0|(d=0|ig(0|(U=0|vg(0|(S=0|ig(0|(v=0|vg(0|(J=0|ig(0|(b=0|vg(0|(J=0|vg(0|(R=0|Qg(0|K,0|R,-683901,-1)),0|o(),2097151&J|0,0)),0|(R=0|o()),0|(b=0|ig(0|(P=0|vg(0|b,0|m,0|(P=0|ig(0|(N=0|vg(0|P,0|x,0|(N=0|ig(0|(L=0|vg(0|N,0|X,0|(L=0|ig(0|(K=0|vg(0|L,0|T,0|(K=0|ig(0|q,0|j,21)),0|o())),0|(T=0|o()),21)),0|o())),0|(X=0|o()),21)),0|o())),0|(x=0|o()),21)),0|o())),0|(m=0|o()),21)),0|o())),0|(R=0|o()),21)),0|o(),2097151&v|0,0)),0|(J=0|o()),21)),0|o(),2097151&U|0,0)),0|(S=0|o()),21)),0|o(),2097151&M|0,0)),0|(d=0|o()),21)),0|o(),2097151&_|0,0)),0|(Y=0|o()),21)),0|o(),2097151&I|0,0)),0|(G=0|o()),21)),0|o(),2097151&g|0,0),C=0|o(),B[A>>0]=q,V=0|yg(0|q,0|j,8),o(),B[A+1>>0]=V,j=0|yg(0|q,0|j,16),o(),q=0|rg(2097151&K|0,0,5),o(),B[A+2>>0]=q|31&j,j=0|yg(0|K,0|T,3),o(),B[A+3>>0]=j,T=0|yg(0|K,0|T,11),o(),B[A+4>>0]=T,K=0|yg(2097151&K|0,0,19),T=0|o(),j=0|rg(2097151&L|0,0,2),o(),B[A+5>>0]=j|K,X=0|yg(0|L,0|X,6),o(),B[A+6>>0]=X,L=0|yg(2097151&L|0,0,14),X=0|o(),K=0|rg(2097151&N|0,0,7),o(),B[A+7>>0]=K|L,L=0|yg(0|N,0|x,1),o(),B[A+8>>0]=L,x=0|yg(0|N,0|x,9),o(),B[A+9>>0]=x,N=0|yg(2097151&N|0,0,17),x=0|o(),L=0|rg(2097151&P|0,0,4),o(),B[A+10>>0]=L|N,N=0|yg(0|P,0|m,4),o(),B[A+11>>0]=N,m=0|yg(0|P,0|m,12),o(),B[A+12>>0]=m,P=0|yg(2097151&P|0,0,20),m=0|o(),N=0|rg(2097151&b|0,0,1),o(),B[A+13>>0]=N|P,R=0|yg(0|b,0|R,7),o(),B[A+14>>0]=R,b=0|yg(2097151&b|0,0,15),R=0|o(),P=0|rg(2097151&v|0,0,6),o(),B[A+15>>0]=P|b,b=0|yg(0|v,0|J,2),o(),B[A+16>>0]=b,J=0|yg(0|v,0|J,10),o(),B[A+17>>0]=J,v=0|yg(2097151&v|0,0,18),J=0|o(),b=0|rg(0|U,0|S,3),o(),B[A+18>>0]=b|v,v=0|yg(0|U,0|S,5),o(),B[A+19>>0]=v,S=0|yg(0|U,0|S,13),o(),B[A+20>>0]=S,B[A+21>>0]=M,S=0|yg(0|M,0|d,8),o(),B[A+22>>0]=S,d=0|yg(0|M,0|d,16),o(),M=0|rg(2097151&_|0,0,5),o(),B[A+23>>0]=M|31&d,d=0|yg(0|_,0|Y,3),o(),B[A+24>>0]=d,Y=0|yg(0|_,0|Y,11),o(),B[A+25>>0]=Y,_=0|yg(2097151&_|0,0,19),Y=0|o(),d=0|rg(2097151&I|0,0,2),o(),B[A+26>>0]=d|_,G=0|yg(0|I,0|G,6),o(),B[A+27>>0]=G,I=0|yg(2097151&I|0,0,14),G=0|o(),_=0|rg(0|g,0|C,7),o(),B[A+28>>0]=_|I,I=0|yg(0|g,0|C,1),o(),B[A+29>>0]=I,I=0|yg(0|g,0|C,9),o(),B[A+30>>0]=I,C=0|ig(0|g,0|C,17),o(),B[A+31>>0]=C}function D(A,I,g,B){A|=0,B|=0;var Q=0,E=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0,m=0,L=0,x=0,K=0,X=0;!function(A,I){A|=0,I|=0;var g=0,B=0,Q=0,E=0;g=0;do{E=0|jA(I+(g<<3)|0),Q=0|o(),C[(B=A+(g<<3)|0)>>2]=E,C[B+4>>2]=Q,g=g+1|0}while(16!=(0|g))}(g|=0,I|=0),Q=A,E=(I=B)+64|0;do{C[I>>2]=C[Q>>2],I=I+4|0,Q=Q+4|0}while((0|I)<(0|E));I=0|C[g>>2],Q=0|C[g+4>>2],D=0;do{if(y=0|ZI(H=0|C[B+32>>2],e=0|C[B+32+4>>2],14),r=0|o(),G=0|ZI(H,e,18),r=(0|o())^r,L=0|ZI(H,e,41),r^=0|o(),b=0|C[B+40>>2],i=0|C[B+40+4>>2],h=0|C[B+48>>2],E=0|C[B+48+4>>2],c=0|C[(P=32416+(D<<3)|0)>>2],P=0|C[P+4>>2],t=0|C[B+56>>2],u=0|C[B+56+4>>2],P=0|vg(0|(u=0|vg(0|(P=0|vg(0|(P=0|vg(0|(r=0|vg(0|I,0|Q,G^y^L|0,0|r)),0|o(),0|c,0|P)),0|o(),(h^b)&H^h|0,(E^i)&e^E|0)),0|o(),0|t,0|u)),0|(t=0|o()),0|C[B+24>>2],0|C[B+24+4>>2]),c=0|o(),C[B+24>>2]=P,C[B+24+4>>2]=c,y=0|ZI(r=0|C[B>>2],L=0|C[B+4>>2],28),I=0|o(),G=0|ZI(r,L,34),I=(0|o())^I,U=0|ZI(r,L,39),I^=0|o(),n=0|C[B+8>>2],m=0|C[B+8+4>>2],a=0|C[B+16>>2],N=0|C[B+16+4>>2],t=0|vg(0|(t=0|vg(G^y^U|0,0|I,0|u,0|t)),0|o(),(a|n)&r|a&n|0,(N|m)&L|N&m|0),u=0|o(),C[B+56>>2]=t,C[B+56+4>>2]=u,I=0|ZI(P,c,14),U=0|o(),y=0|ZI(P,c,18),U=(0|o())^U,G=0|ZI(P,c,41),U^=0|o(),f=0|C[g+((w=1|D)<<3)>>2],Q=0|C[g+(w<<3)+4>>2],s=0|C[32416+(w<<3)>>2],d=0|C[32416+(w<<3)+4>>2],N=0|vg(0|(d=0|vg(0|(Q=0|vg(0|(U=0|vg(0|(E=0|vg(P&(b^H)^b|0,c&(i^e)^i|0,0|h,0|E)),0|o(),y^I^G|0,0|U)),0|o(),0|f,0|Q)),0|o(),0|s,0|d)),0|(s=0|o()),0|a,0|N),a=0|o(),C[B+16>>2]=N,C[B+16+4>>2]=a,Q=0|ZI(t,u,28),f=0|o(),U=0|ZI(t,u,34),f=(0|o())^f,G=0|ZI(t,u,39),f^=0|o(),f=0|vg(0|(s=0|vg(0|d,0|s,t&(n|r)|n&r|0,u&(m|L)|m&L|0)),0|o(),U^Q^G|0,0|f),G=0|o(),C[B+48>>2]=f,C[B+48+4>>2]=G,Q=0|ZI(N,a,14),U=0|o(),s=0|ZI(N,a,18),U=(0|o())^U,d=0|ZI(N,a,41),U^=0|o(),y=0|C[g+((I=2|D)<<3)>>2],E=0|C[g+(I<<3)+4>>2],h=0|C[32416+(I<<3)>>2],Y=0|C[32416+(I<<3)+4>>2],m=0|vg(0|(Y=0|vg(0|(E=0|vg(0|(U=0|vg(0|(i=0|vg(N&(P^H)^H|0,a&(c^e)^e|0,0|b,0|i)),0|o(),s^Q^d|0,0|U)),0|o(),0|y,0|E)),0|o(),0|h,0|Y)),0|(h=0|o()),0|n,0|m),n=0|o(),C[B+8>>2]=m,C[B+8+4>>2]=n,E=0|ZI(f,G,28),y=0|o(),U=0|ZI(f,G,34),y=(0|o())^y,d=0|ZI(f,G,39),y^=0|o(),y=0|vg(0|(h=0|vg(0|Y,0|h,f&(t|r)|t&r|0,G&(u|L)|u&L|0)),0|o(),U^E^d|0,0|y),d=0|o(),C[B+40>>2]=y,C[B+40+4>>2]=d,E=0|ZI(m,n,14),U=0|o(),h=0|ZI(m,n,18),U=(0|o())^U,Y=0|ZI(m,n,41),U^=0|o(),s=0|C[g+((Q=3|D)<<3)>>2],i=0|C[g+(Q<<3)+4>>2],b=0|C[32416+(Q<<3)>>2],F=0|C[32416+(Q<<3)+4>>2],L=0|vg(0|(F=0|vg(0|(i=0|vg(0|(U=0|vg(0|(e=0|vg(m&(N^P)^P|0,n&(a^c)^c|0,0|H,0|e)),0|o(),h^E^Y|0,0|U)),0|o(),0|s,0|i)),0|o(),0|b,0|F)),0|(b=0|o()),0|r,0|L),r=0|o(),C[B>>2]=L,C[B+4>>2]=r,i=0|ZI(y,d,28),s=0|o(),U=0|ZI(y,d,34),s=(0|o())^s,Y=0|ZI(y,d,39),s^=0|o(),s=0|vg(0|(b=0|vg(0|F,0|b,y&(f|t)|f&t|0,d&(G|u)|G&u|0)),0|o(),U^i^Y|0,0|s),Y=0|o(),C[B+32>>2]=s,C[B+32+4>>2]=Y,i=0|ZI(L,r,14),U=0|o(),b=0|ZI(L,r,18),U=(0|o())^U,F=0|ZI(L,r,41),U^=0|o(),h=0|C[g+((E=4|D)<<3)>>2],e=0|C[g+(E<<3)+4>>2],H=0|C[32416+(E<<3)>>2],J=0|C[32416+(E<<3)+4>>2],u=0|vg(0|(J=0|vg(0|(e=0|vg(0|(U=0|vg(0|(c=0|vg(L&(m^N)^N|0,r&(n^a)^a|0,0|P,0|c)),0|o(),b^i^F|0,0|U)),0|o(),0|h,0|e)),0|o(),0|H,0|J)),0|(H=0|o()),0|t,0|u),t=0|o(),C[B+56>>2]=u,C[B+56+4>>2]=t,e=0|ZI(s,Y,28),h=0|o(),U=0|ZI(s,Y,34),h=(0|o())^h,F=0|ZI(s,Y,39),h^=0|o(),h=0|vg(0|(H=0|vg(0|J,0|H,s&(y|f)|y&f|0,Y&(d|G)|d&G|0)),0|o(),U^e^F|0,0|h),F=0|o(),C[B+24>>2]=h,C[B+24+4>>2]=F,e=0|ZI(u,t,14),U=0|o(),H=0|ZI(u,t,18),U=(0|o())^U,J=0|ZI(u,t,41),U^=0|o(),b=0|C[g+((i=5|D)<<3)>>2],c=0|C[g+(i<<3)+4>>2],P=0|C[32416+(i<<3)>>2],M=0|C[32416+(i<<3)+4>>2],G=0|vg(0|(M=0|vg(0|(c=0|vg(0|(U=0|vg(0|(a=0|vg(u&(L^m)^m|0,t&(r^n)^n|0,0|N,0|a)),0|o(),H^e^J|0,0|U)),0|o(),0|b,0|c)),0|o(),0|P,0|M)),0|(P=0|o()),0|f,0|G),f=0|o(),C[B+48>>2]=G,C[B+48+4>>2]=f,c=0|ZI(h,F,28),b=0|o(),U=0|ZI(h,F,34),b=(0|o())^b,J=0|ZI(h,F,39),b^=0|o(),b=0|vg(0|(P=0|vg(0|M,0|P,h&(s|y)|s&y|0,F&(Y|d)|Y&d|0)),0|o(),U^c^J|0,0|b),J=0|o(),C[B+16>>2]=b,C[B+16+4>>2]=J,c=0|ZI(G,f,14),U=0|o(),P=0|ZI(G,f,18),U=(0|o())^U,M=0|ZI(G,f,41),U^=0|o(),H=0|C[g+((e=6|D)<<3)>>2],a=0|C[g+(e<<3)+4>>2],N=0|C[32416+(e<<3)>>2],R=0|C[32416+(e<<3)+4>>2],d=0|vg(0|(R=0|vg(0|(a=0|vg(0|(U=0|vg(0|(n=0|vg(G&(u^L)^L|0,f&(t^r)^r|0,0|m,0|n)),0|o(),P^c^M|0,0|U)),0|o(),0|H,0|a)),0|o(),0|N,0|R)),0|(N=0|o()),0|y,0|d),y=0|o(),C[B+40>>2]=d,C[B+40+4>>2]=y,a=0|ZI(b,J,28),H=0|o(),U=0|ZI(b,J,34),H=(0|o())^H,M=0|ZI(b,J,39),H^=0|o(),H=0|vg(0|(N=0|vg(0|R,0|N,b&(h|s)|h&s|0,J&(F|Y)|F&Y|0)),0|o(),U^a^M|0,0|H),M=0|o(),C[B+8>>2]=H,C[B+8+4>>2]=M,a=0|ZI(d,y,14),U=0|o(),N=0|ZI(d,y,18),U=(0|o())^U,R=0|ZI(d,y,41),U^=0|o(),P=0|C[g+((c=7|D)<<3)>>2],n=0|C[g+(c<<3)+4>>2],m=0|C[32416+(c<<3)>>2],x=0|C[32416+(c<<3)+4>>2],Y=0|vg(0|(x=0|vg(0|(n=0|vg(0|(U=0|vg(0|(r=0|vg(d&(G^u)^u|0,y&(f^t)^t|0,0|L,0|r)),0|o(),N^a^R|0,0|U)),0|o(),0|P,0|n)),0|o(),0|m,0|x)),0|(m=0|o()),0|s,0|Y),s=0|o(),C[B+32>>2]=Y,C[B+32+4>>2]=s,n=0|ZI(H,M,28),P=0|o(),U=0|ZI(H,M,34),P=(0|o())^P,R=0|ZI(H,M,39),P^=0|o(),P=0|vg(0|(m=0|vg(0|x,0|m,H&(b|h)|b&h|0,M&(J|F)|J&F|0)),0|o(),U^n^R|0,0|P),R=0|o(),C[B>>2]=P,C[B+4>>2]=R,n=0|ZI(Y,s,14),U=0|o(),m=0|ZI(Y,s,18),U=(0|o())^U,x=0|ZI(Y,s,41),U^=0|o(),N=0|C[g+((a=8|D)<<3)>>2],r=0|C[g+(a<<3)+4>>2],L=0|C[32416+(a<<3)>>2],K=0|C[32416+(a<<3)+4>>2],F=0|vg(0|(K=0|vg(0|(r=0|vg(0|(U=0|vg(0|(t=0|vg(Y&(d^G)^G|0,s&(y^f)^f|0,0|u,0|t)),0|o(),m^n^x|0,0|U)),0|o(),0|N,0|r)),0|o(),0|L,0|K)),0|(L=0|o()),0|h,0|F),h=0|o(),C[B+24>>2]=F,C[B+24+4>>2]=h,r=0|ZI(P,R,28),N=0|o(),U=0|ZI(P,R,34),N=(0|o())^N,x=0|ZI(P,R,39),N^=0|o(),N=0|vg(0|(L=0|vg(0|K,0|L,P&(H|b)|H&b|0,R&(M|J)|M&J|0)),0|o(),U^r^x|0,0|N),x=0|o(),C[B+56>>2]=N,C[B+56+4>>2]=x,r=0|ZI(F,h,14),U=0|o(),L=0|ZI(F,h,18),U=(0|o())^U,K=0|ZI(F,h,41),U^=0|o(),m=0|C[g+((n=9|D)<<3)>>2],t=0|C[g+(n<<3)+4>>2],u=0|C[32416+(n<<3)>>2],X=0|C[32416+(n<<3)+4>>2],J=0|vg(0|(X=0|vg(0|(t=0|vg(0|(U=0|vg(0|(f=0|vg(F&(Y^d)^d|0,h&(s^y)^y|0,0|G,0|f)),0|o(),L^r^K|0,0|U)),0|o(),0|m,0|t)),0|o(),0|u,0|X)),0|(u=0|o()),0|b,0|J),b=0|o(),C[B+16>>2]=J,C[B+16+4>>2]=b,t=0|ZI(N,x,28),m=0|o(),U=0|ZI(N,x,34),m=(0|o())^m,K=0|ZI(N,x,39),m^=0|o(),m=0|vg(0|(u=0|vg(0|X,0|u,N&(P|H)|P&H|0,x&(R|M)|R&M|0)),0|o(),U^t^K|0,0|m),K=0|o(),C[B+48>>2]=m,C[B+48+4>>2]=K,t=0|ZI(J,b,14),U=0|o(),u=0|ZI(J,b,18),U=(0|o())^U,X=0|ZI(J,b,41),U^=0|o(),L=0|C[g+((r=10|D)<<3)>>2],f=0|C[g+(r<<3)+4>>2],G=0|C[32416+(r<<3)>>2],p=0|C[32416+(r<<3)+4>>2],M=0|vg(0|(p=0|vg(0|(f=0|vg(0|(U=0|vg(0|(y=0|vg(J&(F^Y)^Y|0,b&(h^s)^s|0,0|d,0|y)),0|o(),u^t^X|0,0|U)),0|o(),0|L,0|f)),0|o(),0|G,0|p)),0|(G=0|o()),0|H,0|M),H=0|o(),C[B+8>>2]=M,C[B+8+4>>2]=H,f=0|ZI(m,K,28),L=0|o(),U=0|ZI(m,K,34),L=(0|o())^L,X=0|ZI(m,K,39),L^=0|o(),L=0|vg(0|(G=0|vg(0|p,0|G,m&(N|P)|N&P|0,K&(x|R)|x&R|0)),0|o(),U^f^X|0,0|L),X=0|o(),C[B+40>>2]=L,C[B+40+4>>2]=X,f=0|ZI(M,H,14),U=0|o(),G=0|ZI(M,H,18),U=(0|o())^U,p=0|ZI(M,H,41),U^=0|o(),u=0|C[g+((t=11|D)<<3)>>2],y=0|C[g+(t<<3)+4>>2],d=0|C[32416+(t<<3)>>2],k=0|C[32416+(t<<3)+4>>2],R=0|vg(0|(k=0|vg(0|(y=0|vg(0|(U=0|vg(0|(s=0|vg(M&(J^F)^F|0,H&(b^h)^h|0,0|Y,0|s)),0|o(),G^f^p|0,0|U)),0|o(),0|u,0|y)),0|o(),0|d,0|k)),0|(d=0|o()),0|P,0|R),P=0|o(),C[B>>2]=R,C[B+4>>2]=P,y=0|ZI(L,X,28),u=0|o(),U=0|ZI(L,X,34),u=(0|o())^u,p=0|ZI(L,X,39),u^=0|o(),u=0|vg(0|(d=0|vg(0|k,0|d,L&(m|N)|m&N|0,X&(K|x)|K&x|0)),0|o(),U^y^p|0,0|u),p=0|o(),C[B+32>>2]=u,C[B+32+4>>2]=p,y=0|ZI(R,P,14),U=0|o(),d=0|ZI(R,P,18),U=(0|o())^U,k=0|ZI(R,P,41),U^=0|o(),G=0|C[g+((f=12|D)<<3)>>2],s=0|C[g+(f<<3)+4>>2],Y=0|C[32416+(f<<3)>>2],l=0|C[32416+(f<<3)+4>>2],x=0|vg(0|(l=0|vg(0|(s=0|vg(0|(U=0|vg(0|(h=0|vg(R&(M^J)^J|0,P&(H^b)^b|0,0|F,0|h)),0|o(),d^y^k|0,0|U)),0|o(),0|G,0|s)),0|o(),0|Y,0|l)),0|(Y=0|o()),0|N,0|x),N=0|o(),C[B+56>>2]=x,C[B+56+4>>2]=N,s=0|ZI(u,p,28),G=0|o(),U=0|ZI(u,p,34),G=(0|o())^G,k=0|ZI(u,p,39),G^=0|o(),G=0|vg(0|(Y=0|vg(0|l,0|Y,u&(L|m)|L&m|0,p&(X|K)|X&K|0)),0|o(),U^s^k|0,0|G),k=0|o(),C[B+24>>2]=G,C[B+24+4>>2]=k,s=0|ZI(x,N,14),U=0|o(),Y=0|ZI(x,N,18),U=(0|o())^U,l=0|ZI(x,N,41),U^=0|o(),d=0|C[g+((y=13|D)<<3)>>2],h=0|C[g+(y<<3)+4>>2],F=0|C[32416+(y<<3)>>2],_=0|C[32416+(y<<3)+4>>2],K=0|vg(0|(_=0|vg(0|(h=0|vg(0|(U=0|vg(0|(b=0|vg(x&(R^M)^M|0,N&(P^H)^H|0,0|J,0|b)),0|o(),Y^s^l|0,0|U)),0|o(),0|d,0|h)),0|o(),0|F,0|_)),0|(F=0|o()),0|m,0|K),m=0|o(),C[B+48>>2]=K,C[B+48+4>>2]=m,h=0|ZI(G,k,28),d=0|o(),U=0|ZI(G,k,34),d=(0|o())^d,l=0|ZI(G,k,39),d^=0|o(),d=0|vg(0|(F=0|vg(0|_,0|F,G&(u|L)|u&L|0,k&(p|X)|p&X|0)),0|o(),U^h^l|0,0|d),l=0|o(),C[B+16>>2]=d,C[B+16+4>>2]=l,h=0|ZI(K,m,14),U=0|o(),F=0|ZI(K,m,18),U=(0|o())^U,_=0|ZI(K,m,41),U^=0|o(),Y=0|C[g+((s=14|D)<<3)>>2],b=0|C[g+(s<<3)+4>>2],J=0|C[32416+(s<<3)>>2],v=0|C[32416+(s<<3)+4>>2],X=0|vg(0|(v=0|vg(0|(b=0|vg(0|(U=0|vg(0|(H=0|vg(K&(x^R)^R|0,m&(N^P)^P|0,0|M,0|H)),0|o(),F^h^_|0,0|U)),0|o(),0|Y,0|b)),0|o(),0|J,0|v)),0|(J=0|o()),0|L,0|X),L=0|o(),C[B+40>>2]=X,C[B+40+4>>2]=L,b=0|ZI(d,l,28),Y=0|o(),U=0|ZI(d,l,34),Y=(0|o())^Y,_=0|ZI(d,l,39),Y^=0|o(),Y=0|vg(0|(J=0|vg(0|v,0|J,d&(G|u)|G&u|0,l&(k|p)|k&p|0)),0|o(),U^b^_|0,0|Y),_=0|o(),C[B+8>>2]=Y,C[B+8+4>>2]=_,b=0|ZI(X,L,14),U=0|o(),J=0|ZI(X,L,18),U=(0|o())^U,v=0|ZI(X,L,41),U^=0|o(),F=0|C[g+((h=15|D)<<3)>>2],H=0|C[g+(h<<3)+4>>2],M=0|C[32416+(h<<3)>>2],S=0|C[32416+(h<<3)+4>>2],p=0|vg(0|(S=0|vg(0|(H=0|vg(0|(U=0|vg(0|(P=0|vg(X&(K^x)^x|0,L&(m^N)^N|0,0|R,0|P)),0|o(),J^b^v|0,0|U)),0|o(),0|F,0|H)),0|o(),0|M,0|S)),0|(M=0|o()),0|u,0|p),u=0|o(),C[B+32>>2]=p,C[B+32+4>>2]=u,u=0|ZI(Y,_,28),p=0|o(),H=0|ZI(Y,_,34),p=(0|o())^p,F=0|ZI(Y,_,39),p^=0|o(),p=0|vg(0|(k=0|vg(0|S,0|M,Y&(d|G)|d&G|0,_&(l|k)|l&k|0)),0|o(),H^u^F|0,0|p),F=0|o(),C[B>>2]=p,C[B+4>>2]=F,64==(0|D))break;d=0|ZI(K=0|C[g+(s<<3)>>2],X=0|C[g+(s<<3)+4>>2],19),N=0|o(),H=0|ZI(K,X,61),k=0|o(),k=0|vg((R=0|yg(0|K,0|X,6))^d^H|0,0|(k=(0|o())^N^k),0|(N=0|C[g+(n<<3)>>2]),0|(Y=0|C[g+(n<<3)+4>>2])),H=0|o(),b=0|ZI(d=0|C[g+(w<<3)>>2],R=0|C[g+(w<<3)+4>>2],1),p=0|o(),m=0|ZI(d,R,8),P=0|o(),J=0|yg(0|d,0|R,7),P=(0|o())^p^P,P=0|vg(0|(p=0|vg(0|k,0|H,0|C[(p=g+(D<<3)|0)>>2],0|C[p+4>>2])),0|o(),J^b^m|0,0|P),m=0|o(),C[(b=g+((D=D+16|0)<<3)|0)>>2]=P,C[b+4>>2]=m,p=0|ZI(b=0|C[g+(h<<3)>>2],J=0|C[g+(h<<3)+4>>2],19),H=0|o(),k=0|ZI(b,J,61),l=0|o(),F=0|yg(0|b,0|J,6),l=(0|o())^H^l,H=0|C[g+(w+9<<3)>>2],L=0|C[g+(w+9<<3)+4>>2],u=0|ZI(_=0|C[g+(w+1<<3)>>2],M=0|C[g+(w+1<<3)+4>>2],1),U=0|o(),G=0|ZI(_,M,8),S=0|o(),v=0|yg(0|_,0|M,7),S=(0|o())^U^S,S=0|vg(0|(l=0|vg(0|(R=0|vg(0|H,0|L,0|d,0|R)),0|o(),F^p^k|0,0|l)),0|o(),v^u^G|0,0|S),G=0|o(),C[g+(w+16<<3)>>2]=S,C[g+(w+16<<3)+4>>2]=G,u=0|ZI(P,m,19),v=0|o(),l=0|ZI(P,m,61),w=0|o(),w=0|vg((m=0|yg(0|P,0|m,6))^u^l|0,0|(w=(0|o())^v^w),0|(v=0|C[g+(t<<3)>>2]),0|(P=0|C[g+(t<<3)+4>>2])),l=0|o(),k=0|ZI(u=0|C[g+(Q<<3)>>2],m=0|C[g+(Q<<3)+4>>2],1),p=0|o(),F=0|ZI(u,m,8),R=0|o(),d=0|yg(0|u,0|m,7),R=(0|o())^p^R,R=0|vg(0|(M=0|vg(0|w,0|l,0|_,0|M)),0|o(),d^k^F|0,0|R),F=0|o(),C[g+(I+16<<3)>>2]=R,C[g+(I+16<<3)+4>>2]=F,k=0|ZI(S,G,19),d=0|o(),M=0|ZI(S,G,61),_=0|o(),G=0|yg(0|S,0|G,6),_=(0|o())^d^_,d=0|C[g+(Q+9<<3)>>2],S=0|C[g+(Q+9<<3)+4>>2],w=0|ZI(l=0|C[g+(Q+1<<3)>>2],I=0|C[g+(Q+1<<3)+4>>2],1),p=0|o(),L=0|ZI(l,I,8),H=0|o(),U=0|yg(0|l,0|I,7),H=(0|o())^p^H,H=0|vg(0|(_=0|vg(0|(m=0|vg(0|d,0|S,0|u,0|m)),0|o(),G^k^M|0,0|_)),0|o(),U^w^L|0,0|H),L=0|o(),C[g+(Q+16<<3)>>2]=H,C[g+(Q+16<<3)+4>>2]=L,w=0|ZI(R,F,19),U=0|o(),_=0|ZI(R,F,61),M=0|o(),M=0|vg((F=0|yg(0|R,0|F,6))^w^_|0,0|(M=(0|o())^U^M),0|(U=0|C[g+(y<<3)>>2]),0|(R=0|C[g+(y<<3)+4>>2])),_=0|o(),k=0|ZI(w=0|C[g+(i<<3)>>2],F=0|C[g+(i<<3)+4>>2],1),G=0|o(),m=0|ZI(w,F,8),u=0|o(),S=0|yg(0|w,0|F,7),u=(0|o())^G^u,u=0|vg(0|(I=0|vg(0|M,0|_,0|l,0|I)),0|o(),S^k^m|0,0|u),m=0|o(),C[g+(E+16<<3)>>2]=u,C[g+(E+16<<3)+4>>2]=m,k=0|ZI(H,L,19),S=0|o(),I=0|ZI(H,L,61),l=0|o(),L=0|yg(0|H,0|L,6),l=(0|o())^S^l,S=0|C[g+(i+9<<3)>>2],H=0|C[g+(i+9<<3)+4>>2],G=0|ZI(_=0|C[g+(i+1<<3)>>2],M=0|C[g+(i+1<<3)+4>>2],1),d=0|o(),p=0|ZI(_,M,8),x=0|o(),Q=0|yg(0|_,0|M,7),x=(0|o())^d^x,x=0|vg(0|(l=0|vg(0|(F=0|vg(0|S,0|H,0|w,0|F)),0|o(),L^k^I|0,0|l)),0|o(),Q^G^p|0,0|x),p=0|o(),C[g+(i+16<<3)>>2]=x,C[g+(i+16<<3)+4>>2]=p,G=0|ZI(u,m,19),Q=0|o(),l=0|ZI(u,m,61),I=0|o(),I=0|vg((m=0|yg(0|u,0|m,6))^G^l|0,(0|o())^Q^I|0,0|b,0|J),Q=0|o(),m=0|ZI(l=0|C[g+(c<<3)>>2],G=0|C[g+(c<<3)+4>>2],1),u=0|o(),k=0|ZI(l,G,8),L=0|o(),F=0|yg(0|l,0|G,7),L=(0|o())^u^L,L=0|vg(0|(M=0|vg(0|I,0|Q,0|_,0|M)),0|o(),F^m^k|0,0|L),k=0|o(),C[g+(e+16<<3)>>2]=L,C[g+(e+16<<3)+4>>2]=k,m=0|ZI(x,p,19),F=0|o(),M=0|ZI(x,p,61),_=0|o(),p=0|yg(0|x,0|p,6),_=(0|o())^F^_,F=0|C[g+(c+9<<3)>>2],x=0|C[g+(c+9<<3)+4>>2],u=0|ZI(Q=0|C[g+(c+1<<3)>>2],I=0|C[g+(c+1<<3)+4>>2],1),w=0|o(),H=0|ZI(Q,I,8),S=0|o(),d=0|yg(0|Q,0|I,7),S=(0|o())^w^S,S=0|vg(0|(_=0|vg(0|(G=0|vg(0|F,0|x,0|l,0|G)),0|o(),p^m^M|0,0|_)),0|o(),d^u^H|0,0|S),H=0|o(),C[g+(c+16<<3)>>2]=S,C[g+(c+16<<3)+4>>2]=H,u=0|ZI(L,k,19),d=0|o(),_=0|ZI(L,k,61),M=0|o(),M=0|vg((k=0|yg(0|L,0|k,6))^u^_|0,0|(M=(0|o())^d^M),0|C[g+(a+9<<3)>>2],0|C[g+(a+9<<3)+4>>2]),_=0|o(),u=0|ZI(N,Y,1),k=0|o(),d=0|ZI(N,Y,8),L=0|o(),m=0|yg(0|N,0|Y,7),L=k^(0|o())^L,L=0|vg(0|(I=0|vg(0|M,0|_,0|Q,0|I)),0|o(),u^m^d|0,0|L),d=0|o(),C[g+(a+16<<3)>>2]=L,C[g+(a+16<<3)+4>>2]=d,m=0|ZI(S,H,19),u=0|o(),I=0|ZI(S,H,61),Q=0|o(),H=0|yg(0|S,0|H,6),Q=(0|o())^u^Q,u=0|C[g+(n+9<<3)>>2],S=0|C[g+(n+9<<3)+4>>2],k=0|ZI(_=0|C[g+(n+1<<3)>>2],M=0|C[g+(n+1<<3)+4>>2],1),p=0|o(),G=0|ZI(_,M,8),l=0|o(),x=0|yg(0|_,0|M,7),l=(0|o())^p^l,l=0|vg(0|(Q=0|vg(0|(Y=0|vg(0|u,0|S,0|N,0|Y)),0|o(),H^m^I|0,0|Q)),0|o(),x^k^G|0,0|l),G=0|o(),C[g+(n+16<<3)>>2]=l,C[g+(n+16<<3)+4>>2]=G,k=0|ZI(L,d,19),x=0|o(),Q=0|ZI(L,d,61),I=0|o(),I=0|vg((d=0|yg(0|L,0|d,6))^k^Q|0,0|(I=(0|o())^x^I),0|C[g+(r+9<<3)>>2],0|C[g+(r+9<<3)+4>>2]),Q=0|o(),k=0|ZI(v,P,1),d=0|o(),x=0|ZI(v,P,8),L=0|o(),m=0|yg(0|v,0|P,7),L=d^(0|o())^L,L=0|vg(0|(M=0|vg(0|I,0|Q,0|_,0|M)),0|o(),k^m^x|0,0|L),x=0|o(),C[g+(r+16<<3)>>2]=L,C[g+(r+16<<3)+4>>2]=x,m=0|ZI(l,G,19),k=0|o(),M=0|ZI(l,G,61),_=0|o(),G=0|yg(0|l,0|G,6),_=(0|o())^k^_,k=0|C[g+(t+9<<3)>>2],l=0|C[g+(t+9<<3)+4>>2],d=0|ZI(Q=0|C[g+(t+1<<3)>>2],I=0|C[g+(t+1<<3)+4>>2],1),H=0|o(),Y=0|ZI(Q,I,8),N=0|o(),S=0|yg(0|Q,0|I,7),N=(0|o())^H^N,N=0|vg(0|(_=0|vg(0|(P=0|vg(0|k,0|l,0|v,0|P)),0|o(),G^m^M|0,0|_)),0|o(),S^d^Y|0,0|N),Y=0|o(),C[g+(t+16<<3)>>2]=N,C[g+(t+16<<3)+4>>2]=Y,d=0|ZI(L,x,19),S=0|o(),_=0|ZI(L,x,61),M=0|o(),M=0|vg((x=0|yg(0|L,0|x,6))^d^_|0,0|(M=(0|o())^S^M),0|C[g+(f+9<<3)>>2],0|C[g+(f+9<<3)+4>>2]),_=0|o(),d=0|ZI(U,R,1),x=0|o(),S=0|ZI(U,R,8),L=0|o(),m=0|yg(0|U,0|R,7),L=x^(0|o())^L,L=0|vg(0|(I=0|vg(0|M,0|_,0|Q,0|I)),0|o(),d^m^S|0,0|L),S=0|o(),C[g+(f+16<<3)>>2]=L,C[g+(f+16<<3)+4>>2]=S,m=0|ZI(N,Y,19),d=0|o(),I=0|ZI(N,Y,61),Q=0|o(),Y=0|yg(0|N,0|Y,6),Q=(0|o())^d^Q,d=0|C[g+(y+9<<3)>>2],N=0|C[g+(y+9<<3)+4>>2],x=0|ZI(_=0|C[g+(y+1<<3)>>2],M=0|C[g+(y+1<<3)+4>>2],1),G=0|o(),P=0|ZI(_,M,8),v=0|o(),M=0|yg(0|_,0|M,7),v=(0|o())^G^v,v=0|vg(0|(Q=0|vg(0|(R=0|vg(0|d,0|N,0|U,0|R)),0|o(),Y^m^I|0,0|Q)),0|o(),M^x^P|0,0|v),P=0|o(),C[g+(y+16<<3)>>2]=v,C[g+(y+16<<3)+4>>2]=P,x=0|ZI(L,S,19),M=0|o(),Q=0|ZI(L,S,61),I=0|o(),S=0|yg(0|L,0|S,6),I=(0|o())^M^I,M=0|C[g+(s+9<<3)>>2],L=0|C[g+(s+9<<3)+4>>2],m=0|ZI(b,J,1),Y=0|o(),R=0|ZI(b,J,8),U=0|o(),N=0|yg(0|b,0|J,7),U=Y^(0|o())^U,U=0|vg(0|(I=0|vg(0|(X=0|vg(0|M,0|L,0|K,0|X)),0|o(),S^x^Q|0,0|I)),0|o(),m^N^R|0,0|U),R=0|o(),C[g+(s+16<<3)>>2]=U,C[g+(s+16<<3)+4>>2]=R,R=0|ZI(v,P,19),U=0|o(),N=0|ZI(v,P,61),m=0|o(),P=0|yg(0|v,0|P,6),m=(0|o())^U^m,U=0|C[g+(h+9<<3)>>2],v=0|C[g+(h+9<<3)+4>>2],x=0|ZI(I=0|C[g+(h+1<<3)>>2],Q=0|C[g+(h+1<<3)+4>>2],1),S=0|o(),X=0|ZI(I,Q,8),K=0|o(),L=0|yg(0|I,0|Q,7),K=(0|o())^S^K,K=0|vg(0|(m=0|vg(0|(J=0|vg(0|U,0|v,0|b,0|J)),0|o(),P^R^N|0,0|m)),0|o(),L^x^X|0,0|K),X=0|o(),C[g+(h+16<<3)>>2]=K,C[g+(h+16<<3)+4>>2]=X}while(D>>>0<80);I=0;do{x=B+(I<<3)|0,x=0|vg(0|C[(X=A+(I<<3)|0)>>2],0|C[X+4>>2],0|C[x>>2],0|C[x+4>>2]),K=0|o(),C[X>>2]=x,C[X+4>>2]=K,I=I+1|0}while(8!=(0|I))}function F(A){A|=0;var I,g=0,B=0,Q=0,E=0,i=0,e=0,o=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,s=0,h=0,D=0,F=0,p=0,u=0;I=y,f=y=y+63&-64,y=y+16|0;do{if(A>>>0<245){if(t=A>>>0<11?16:A+11&-8,(n=0|C[8679])>>>(t>>>3)&3|0)return A=0|C[8+(B=34756+((n>>>(t>>>3)&1^1)+(t>>>3)<<1<<2)|0)>>2],(0|(g=0|C[A+8>>2]))==(0|B)?C[8679]=n&~(1<<(n>>>(t>>>3)&1^1)+(t>>>3)):(C[g+12>>2]=B,C[B+8>>2]=g),u=(n>>>(t>>>3)&1^1)+(t>>>3)<<3,C[A+4>>2]=3|u,C[A+u+4>>2]=1|C[A+u+4>>2],y=I,0|A+8;if(t>>>0>(r=0|C[8681])>>>0){if(n>>>(t>>>3)|0)return Q=0|C[34756+((E=((Q=(((A=n>>>(t>>>3)<<(t>>>3)&(2<<(t>>>3)|0-(2<<(t>>>3))))&0-A)-1|0)>>>(((A&0-A)-1|0)>>>12&16))>>>5&8|((A&0-A)-1|0)>>>12&16|Q>>>(Q>>>5&8)>>>2&4|(E=Q>>>(Q>>>5&8)>>>(Q>>>(Q>>>5&8)>>>2&4))>>>1&2|E>>>(E>>>1&2)>>>1&1)+(E>>>(E>>>1&2)>>>(E>>>(E>>>1&2)>>>1&1))|0)<<1<<2)+8>>2],(0|(A=0|C[Q+8>>2]))==(34756+(E<<1<<2)|0)?(C[8679]=n&~(1<<E),A=n&~(1<<E)):(C[A+12>>2]=34756+(E<<1<<2),C[34756+(E<<1<<2)+8>>2]=A,A=n),C[Q+4>>2]=3|t,C[Q+t+4>>2]=(E<<3)-t|1,C[Q+(E<<3)>>2]=(E<<3)-t,0|r&&(B=0|C[8684],A&1<<(r>>>3)?(A=34756+(r>>>3<<1<<2)+8|0,g=0|C[34756+(r>>>3<<1<<2)+8>>2]):(C[8679]=A|1<<(r>>>3),A=34756+(r>>>3<<1<<2)+8|0,g=34756+(r>>>3<<1<<2)|0),C[A>>2]=B,C[g+12>>2]=B,C[B+8>>2]=g,C[B+12>>2]=34756+(r>>>3<<1<<2)),C[8681]=(E<<3)-t,C[8684]=Q+t,y=I,0|Q+8;if(e=0|C[8680]){for(a=0|C[35020+(((c=((e&0-e)-1|0)>>>(((e&0-e)-1|0)>>>12&16))>>>5&8|((e&0-e)-1|0)>>>12&16|c>>>(c>>>5&8)>>>2&4|(a=c>>>(c>>>5&8)>>>(c>>>(c>>>5&8)>>>2&4))>>>1&2|a>>>(a>>>1&2)>>>1&1)+(a>>>(a>>>1&2)>>>(a>>>(a>>>1&2)>>>1&1))<<2)>>2],c=(-8&C[a+4>>2])-t|0,g=a;(A=0|C[g+16>>2])||(A=0|C[g+20>>2]);)c=(o=(g=(-8&C[A+4>>2])-t|0)>>>0<c>>>0)?g:c,g=A,a=o?A:a;if((o=a+t|0)>>>0>a>>>0){E=0|C[a+24>>2],A=0|C[a+12>>2];do{if((0|A)==(0|a)){if(!(A=0|C[(g=a+20|0)>>2])&&!(A=0|C[(g=a+16|0)>>2])){g=0;break}for(;;)if(B=0|C[(Q=A+20|0)>>2])A=B,g=Q;else{if(!(B=0|C[(Q=A+16|0)>>2]))break;A=B,g=Q}C[g>>2]=0,g=A}else g=0|C[a+8>>2],C[g+12>>2]=A,C[A+8>>2]=g,g=A}while(0);do{if(0|E){if(A=0|C[a+28>>2],(0|a)==(0|C[35020+(A<<2)>>2])){if(C[35020+(A<<2)>>2]=g,!g){C[8680]=e&~(1<<A);break}}else if(C[((0|C[E+16>>2])==(0|a)?E+16|0:E+20|0)>>2]=g,!g)break;C[g+24>>2]=E,0|(A=0|C[a+16>>2])&&(C[g+16>>2]=A,C[A+24>>2]=g),0|(A=0|C[a+20>>2])&&(C[g+20>>2]=A,C[A+24>>2]=g)}}while(0);return c>>>0<16?(u=c+t|0,C[a+4>>2]=3|u,C[(u=a+u+4|0)>>2]=1|C[u>>2]):(C[a+4>>2]=3|t,C[o+4>>2]=1|c,C[o+c>>2]=c,0|r&&(B=0|C[8684],1<<(r>>>3)&n?(A=34756+(r>>>3<<1<<2)+8|0,g=0|C[34756+(r>>>3<<1<<2)+8>>2]):(C[8679]=1<<(r>>>3)|n,A=34756+(r>>>3<<1<<2)+8|0,g=34756+(r>>>3<<1<<2)|0),C[A>>2]=B,C[g+12>>2]=B,C[B+8>>2]=g,C[B+12>>2]=34756+(r>>>3<<1<<2)),C[8681]=c,C[8684]=o),y=I,0|a+8}}}}else if(A>>>0<=4294967231){if(t=A+11&-8,Q=0|C[8680]){c=(A+11|0)>>>8?t>>>0>16777215?31:t>>>(7+(c=14-((520192+(c=(A+11|0)>>>8<<((1048320+((A+11|0)>>>8)|0)>>>16&8))|0)>>>16&4|(1048320+((A+11|0)>>>8)|0)>>>16&8|(245760+(c<<((c+520192|0)>>>16&4))|0)>>>16&2)+(c<<((c+520192|0)>>>16&4)<<((245760+(c<<((c+520192|0)>>>16&4))|0)>>>16&2)>>>15)|0)|0)&1|c<<1:0,A=0|C[35020+(c<<2)>>2];A:do{if(A)for(B=0-t|0,g=0,o=t<<(31==(0|c)?0:25-(c>>>1)|0),e=0;;){if((E=(-8&C[A+4>>2])-t|0)>>>0<B>>>0){if(!E){B=0,g=A,h=65;break A}B=E,e=A}if(g=0==(0|(h=0|C[A+20>>2]))|(0|h)==(0|(A=0|C[A+16+(o>>>31<<2)>>2]))?g:h,!A){A=e,h=61;break}o<<=1}else B=0-t|0,g=0,A=0,h=61}while(0);if(61==(0|h)){if(0==(0|g)&0==(0|A)){if(!(((A=2<<c)|0-A)&Q))break;g=0|C[35020+(((r=((A|0-A)&Q&0-((A|0-A)&Q))-1|0)>>>(r>>>12&16)>>>5&8|r>>>12&16|(A=r>>>(r>>>12&16)>>>(r>>>(r>>>12&16)>>>5&8))>>>2&4|A>>>(A>>>2&4)>>>1&2|(g=A>>>(A>>>2&4)>>>(A>>>(A>>>2&4)>>>1&2))>>>1&1)+(g>>>(g>>>1&1))<<2)>>2],A=0}g?h=65:(e=B,o=A)}if(65==(0|h))for(;;){if(B=(E=(r=(-8&C[g+4>>2])-t|0)>>>0<B>>>0)?r:B,E=E?g:A,(A=0|C[g+16>>2])||(A=0|C[g+20>>2]),!A){e=B,o=E;break}g=A,A=E}if(0!=(0|o)&&e>>>0<((0|C[8681])-t|0)>>>0&&(a=o+t|0)>>>0>o>>>0){i=0|C[o+24>>2],A=0|C[o+12>>2];do{if((0|A)==(0|o)){if(!(A=0|C[(g=o+20|0)>>2])&&!(A=0|C[(g=o+16|0)>>2])){A=0;break}for(;;)if(B=0|C[(E=A+20|0)>>2])A=B,g=E;else{if(!(B=0|C[(E=A+16|0)>>2]))break;A=B,g=E}C[g>>2]=0}else u=0|C[o+8>>2],C[u+12>>2]=A,C[A+8>>2]=u}while(0);do{if(i){if(g=0|C[o+28>>2],(0|o)==(0|C[35020+(g<<2)>>2])){if(C[35020+(g<<2)>>2]=A,!A){C[8680]=Q&~(1<<g),Q&=~(1<<g);break}}else if(C[((0|C[i+16>>2])==(0|o)?i+16|0:i+20|0)>>2]=A,!A)break;C[A+24>>2]=i,0|(g=0|C[o+16>>2])&&(C[A+16>>2]=g,C[g+24>>2]=A),(g=0|C[o+20>>2])&&(C[A+20>>2]=g,C[g+24>>2]=A)}}while(0);A:do{if(e>>>0<16)u=e+t|0,C[o+4>>2]=3|u,C[(u=o+u+4|0)>>2]=1|C[u>>2];else{if(C[o+4>>2]=3|t,C[a+4>>2]=1|e,C[a+e>>2]=e,B=e>>>3,e>>>0<256){(A=0|C[8679])&1<<B?(A=34756+(B<<1<<2)+8|0,g=0|C[34756+(B<<1<<2)+8>>2]):(C[8679]=A|1<<B,A=34756+(B<<1<<2)+8|0,g=34756+(B<<1<<2)|0),C[A>>2]=a,C[g+12>>2]=a,C[a+8>>2]=g,C[a+12>>2]=34756+(B<<1<<2);break}if(A=35020+((B=(A=e>>>8)?e>>>0>16777215?31:e>>>(7+(B=14-((520192+(A<<((A+1048320|0)>>>16&8))|0)>>>16&4|(A+1048320|0)>>>16&8|(245760+(B=A<<((A+1048320|0)>>>16&8)<<((520192+(A<<((A+1048320|0)>>>16&8))|0)>>>16&4))|0)>>>16&2)+(B<<((B+245760|0)>>>16&2)>>>15)|0)|0)&1|B<<1:0)<<2)|0,C[a+28>>2]=B,C[a+16+4>>2]=0,C[a+16>>2]=0,!(Q&(g=1<<B))){C[8680]=Q|g,C[A>>2]=a,C[a+24>>2]=A,C[a+12>>2]=a,C[a+8>>2]=a;break}A=0|C[A>>2];I:do{if((-8&C[A+4>>2]|0)!=(0|e)){for(Q=e<<(31==(0|B)?0:25-(B>>>1)|0);g=0|C[(B=A+16+(Q>>>31<<2)|0)>>2];){if((-8&C[g+4>>2]|0)==(0|e)){A=g;break I}Q<<=1,A=g}C[B>>2]=a,C[a+24>>2]=A,C[a+12>>2]=a,C[a+8>>2]=a;break A}}while(0);u=0|C[(p=A+8|0)>>2],C[u+12>>2]=a,C[p>>2]=a,C[a+8>>2]=u,C[a+12>>2]=A,C[a+24>>2]=0}}while(0);return y=I,0|o+8}}}else t=-1}while(0);if((B=0|C[8681])>>>0>=t>>>0)return g=B-t|0,A=0|C[8684],g>>>0>15?(u=A+t|0,C[8684]=u,C[8681]=g,C[u+4>>2]=1|g,C[A+B>>2]=g,C[A+4>>2]=3|t):(C[8681]=0,C[8684]=0,C[A+4>>2]=3|B,C[A+B+4>>2]=1|C[A+B+4>>2]),y=I,0|A+8;if((E=0|C[8682])>>>0>t>>>0)return F=E-t|0,C[8682]=F,p=(u=0|C[8685])+t|0,C[8685]=p,C[p+4>>2]=1|F,C[u+4>>2]=3|t,y=I,0|u+8;if(0|C[8797]?A=0|C[8799]:(C[8799]=4096,C[8798]=4096,C[8800]=-1,C[8801]=-1,C[8802]=0,C[8790]=0,C[8797]=-16&f^1431655768,A=4096),e=t+48|0,((a=A+(o=t+47|0)|0)&(c=0-A|0))>>>0<=t>>>0)return y=I,0;if(0|(A=0|C[8789])&&(((f=0|C[8787])+(a&c)|0)>>>0<=f>>>0||(f+(a&c)|0)>>>0>A>>>0))return y=I,0;A:do{if(4&C[8790])A=0,h=143;else{g=0|C[8685];I:do{if(g){for(B=35164;!((A=0|C[B>>2])>>>0<=g>>>0&&(A+(0|C[(s=B+4|0)>>2])|0)>>>0>g>>>0);){if(!(A=0|C[B+8>>2])){h=128;break I}B=A}if((a-E&c)>>>0<2147483647)if((0|(A=0|bI(a-E&c)))==((0|C[B>>2])+(0|C[s>>2])|0)){if(-1!=(0|A)){e=A,i=a-E&c,h=145;break A}A=a-E&c}else Q=A,B=a-E&c,h=136;else A=0}else h=128}while(0);do{if(128==(0|h))if(-1!=(0|(g=0|bI(0)))&&(i=(0==((i=0|C[8798])-1&g|0)?0:(i+-1+g&0-i)-g|0)+(a&c)|0,w=0|C[8787],i>>>0>t>>>0&i>>>0<2147483647)){if(0|(s=0|C[8789])&&(i+w|0)>>>0<=w>>>0|(i+w|0)>>>0>s>>>0){A=0;break}if((0|(A=0|bI(i)))==(0|g)){e=g,h=145;break A}Q=A,B=i,h=136}else A=0}while(0);do{if(136==(0|h)){if(g=0-B|0,!(e>>>0>B>>>0&B>>>0<2147483647&-1!=(0|Q))){if(-1==(0|Q)){A=0;break}e=Q,i=B,h=145;break A}if((A=o-B+(A=0|C[8799])&0-A)>>>0>=2147483647){e=Q,i=B,h=145;break A}if(-1==(0|bI(A))){bI(g),A=0;break}e=Q,i=A+B|0,h=145;break A}}while(0);C[8790]=4|C[8790],h=143}}while(0);if(143==(0|h)&&(a&c)>>>0<2147483647&&!(-1==(0|(D=0|bI(a&c)))|1^(p=((F=0|bI(0))-D|0)>>>0>(t+40|0)>>>0)|D>>>0<F>>>0&-1!=(0|D)&-1!=(0|F)^1)&&(e=D,i=p?F-D|0:A,h=145),145==(0|h)){A=(0|C[8787])+i|0,C[8787]=A,A>>>0>(0|C[8788])>>>0&&(C[8788]=A),c=0|C[8685];A:do{if(c){for(E=35164;;){if((0|e)==((A=0|C[E>>2])+(g=0|C[(Q=E+4|0)>>2])|0)){h=154;break}if(!(B=0|C[E+8>>2]))break;E=B}if(154==(0|h)&&0==(8&C[E+12>>2]|0)&&e>>>0>c>>>0&A>>>0<=c>>>0){C[Q>>2]=g+i,u=(0|C[8682])+i|0,p=0==(c+8&7|0)?0:0-(c+8)&7,C[8685]=c+p,C[8682]=u-p,C[c+p+4>>2]=u-p|1,C[c+u+4>>2]=40,C[8686]=C[8801];break}for(e>>>0<(0|C[8683])>>>0&&(C[8683]=e),B=e+i|0,g=35164;;){if((0|C[g>>2])==(0|B)){h=162;break}if(!(A=0|C[g+8>>2]))break;g=A}if(162==(0|h)&&0==(8&C[g+12>>2]|0)){C[g>>2]=e,C[(n=g+4|0)>>2]=(0|C[n>>2])+i,a=(n=e+(0==(7&(n=e+8|0)|0)?0:0-n&7)|0)+t|0,o=(A=B+(0==(B+8&7|0)?0:0-(B+8)&7)|0)-n-t|0,C[n+4>>2]=3|t;I:do{if((0|c)==(0|A))u=(0|C[8682])+o|0,C[8682]=u,C[8685]=a,C[a+4>>2]=1|u;else{if((0|C[8684])==(0|A)){u=(0|C[8681])+o|0,C[8681]=u,C[8684]=a,C[a+4>>2]=1|u,C[a+u>>2]=u;break}if(1==(3&(e=0|C[A+4>>2])|0)){g:do{if(e>>>0<256){if(g=0|C[A+8>>2],(0|(B=0|C[A+12>>2]))==(0|g)){C[8679]=C[8679]&~(1<<(e>>>3));break}C[g+12>>2]=B,C[B+8>>2]=g;break}i=0|C[A+24>>2],g=0|C[A+12>>2];do{if((0|g)==(0|A)){if(g=0|C[A+16+4>>2])B=A+16+4|0;else{if(!(g=0|C[A+16>>2])){g=0;break}B=A+16|0}for(;;)if(Q=0|C[(E=g+20|0)>>2])g=Q,B=E;else{if(!(Q=0|C[(E=g+16|0)>>2]))break;g=Q,B=E}C[B>>2]=0}else u=0|C[A+8>>2],C[u+12>>2]=g,C[g+8>>2]=u}while(0);if(!i)break;B=0|C[A+28>>2];do{if((0|C[35020+(B<<2)>>2])==(0|A)){if(C[35020+(B<<2)>>2]=g,0|g)break;C[8680]=C[8680]&~(1<<B);break g}if(C[((0|C[i+16>>2])==(0|A)?i+16|0:i+20|0)>>2]=g,!g)break g}while(0);if(C[g+24>>2]=i,0|(B=0|C[A+16>>2])&&(C[g+16>>2]=B,C[B+24>>2]=g),!(B=0|C[A+16+4>>2]))break;C[g+20>>2]=B,C[B+24>>2]=g}while(0);A=A+(-8&e)|0,E=(-8&e)+o|0}else E=o;if(C[(B=A+4|0)>>2]=-2&C[B>>2],C[a+4>>2]=1|E,C[a+E>>2]=E,B=E>>>3,E>>>0<256){(A=0|C[8679])&1<<B?(A=34756+(B<<1<<2)+8|0,g=0|C[34756+(B<<1<<2)+8>>2]):(C[8679]=A|1<<B,A=34756+(B<<1<<2)+8|0,g=34756+(B<<1<<2)|0),C[A>>2]=a,C[g+12>>2]=a,C[a+8>>2]=g,C[a+12>>2]=34756+(B<<1<<2);break}A=E>>>8;do{if(A){if(E>>>0>16777215){Q=31;break}Q=E>>>(7+(Q=14-((520192+(A<<((A+1048320|0)>>>16&8))|0)>>>16&4|(A+1048320|0)>>>16&8|(245760+(Q=A<<((A+1048320|0)>>>16&8)<<((520192+(A<<((A+1048320|0)>>>16&8))|0)>>>16&4))|0)>>>16&2)+(Q<<((Q+245760|0)>>>16&2)>>>15)|0)|0)&1|Q<<1}else Q=0}while(0);if(g=35020+(Q<<2)|0,C[a+28>>2]=Q,C[a+16+4>>2]=0,C[a+16>>2]=0,!((A=0|C[8680])&(B=1<<Q))){C[8680]=A|B,C[g>>2]=a,C[a+24>>2]=g,C[a+12>>2]=a,C[a+8>>2]=a;break}A=0|C[g>>2];g:do{if((-8&C[A+4>>2]|0)!=(0|E)){for(Q=E<<(31==(0|Q)?0:25-(Q>>>1)|0);g=0|C[(B=A+16+(Q>>>31<<2)|0)>>2];){if((-8&C[g+4>>2]|0)==(0|E)){A=g;break g}Q<<=1,A=g}C[B>>2]=a,C[a+24>>2]=A,C[a+12>>2]=a,C[a+8>>2]=a;break I}}while(0);u=0|C[(p=A+8|0)>>2],C[u+12>>2]=a,C[p>>2]=a,C[a+8>>2]=u,C[a+12>>2]=A,C[a+24>>2]=0}}while(0);return y=I,0|n+8}for(g=35164;!((A=0|C[g>>2])>>>0<=c>>>0&&(u=A+(0|C[g+4>>2])|0)>>>0>c>>>0);)g=0|C[g+8>>2];E=(E=u+-47+(0==(u+-47+8&7|0)?0:0-(u+-47+8)&7)|0)>>>0<(c+16|0)>>>0?c:E,A=i+-40|0,p=e+(F=0==(7&(F=e+8|0)|0)?0:0-F&7)|0,C[8685]=p,C[8682]=A-F,C[p+4>>2]=A-F|1,C[e+A+4>>2]=40,C[8686]=C[8801],C[E+4>>2]=27,C[E+8>>2]=C[8791],C[E+8+4>>2]=C[8792],C[E+8+8>>2]=C[8793],C[E+8+12>>2]=C[8794],C[8791]=e,C[8792]=i,C[8794]=0,C[8793]=E+8,A=E+24|0;do{p=A,C[(A=A+4|0)>>2]=7}while((p+8|0)>>>0<u>>>0);if((0|E)!=(0|c)){if(C[E+4>>2]=-2&C[E+4>>2],C[c+4>>2]=E-c|1,C[E>>2]=E-c,(E-c|0)>>>0<256){B=34756+((E-c|0)>>>3<<1<<2)|0,(A=0|C[8679])&1<<((E-c|0)>>>3)?(A=B+8|0,g=0|C[B+8>>2]):(C[8679]=A|1<<((E-c|0)>>>3),A=B+8|0,g=B),C[A>>2]=c,C[g+12>>2]=c,C[c+8>>2]=g,C[c+12>>2]=B;break}if(g=35020+((Q=(E-c|0)>>>8?(E-c|0)>>>0>16777215?31:(E-c|0)>>>(7+(Q=14-((520192+(Q=(E-c|0)>>>8<<((1048320+((E-c|0)>>>8)|0)>>>16&8))|0)>>>16&4|(1048320+((E-c|0)>>>8)|0)>>>16&8|(245760+(Q<<((Q+520192|0)>>>16&4))|0)>>>16&2)+(Q<<((Q+520192|0)>>>16&4)<<((245760+(Q<<((Q+520192|0)>>>16&4))|0)>>>16&2)>>>15)|0)|0)&1|Q<<1:0)<<2)|0,C[c+28>>2]=Q,C[c+20>>2]=0,C[c+16>>2]=0,!((A=0|C[8680])&(B=1<<Q))){C[8680]=A|B,C[g>>2]=c,C[c+24>>2]=g,C[c+12>>2]=c,C[c+8>>2]=c;break}A=0|C[g>>2];I:do{if((-8&C[A+4>>2]|0)!=(E-c|0)){for(Q=E-c<<(31==(0|Q)?0:25-(Q>>>1)|0);g=0|C[(B=A+16+(Q>>>31<<2)|0)>>2];){if((-8&C[g+4>>2]|0)==(E-c|0)){A=g;break I}Q<<=1,A=g}C[B>>2]=c,C[c+24>>2]=A,C[c+12>>2]=c,C[c+8>>2]=c;break A}}while(0);u=0|C[(p=A+8|0)>>2],C[u+12>>2]=c,C[p>>2]=c,C[c+8>>2]=u,C[c+12>>2]=A,C[c+24>>2]=0}}else 0==(0|(u=0|C[8683]))|e>>>0<u>>>0&&(C[8683]=e),C[8791]=e,C[8792]=i,C[8794]=0,C[8688]=C[8797],C[8687]=-1,C[8692]=34756,C[8691]=34756,C[8694]=34764,C[8693]=34764,C[8696]=34772,C[8695]=34772,C[8698]=34780,C[8697]=34780,C[8700]=34788,C[8699]=34788,C[8702]=34796,C[8701]=34796,C[8704]=34804,C[8703]=34804,C[8706]=34812,C[8705]=34812,C[8708]=34820,C[8707]=34820,C[8710]=34828,C[8709]=34828,C[8712]=34836,C[8711]=34836,C[8714]=34844,C[8713]=34844,C[8716]=34852,C[8715]=34852,C[8718]=34860,C[8717]=34860,C[8720]=34868,C[8719]=34868,C[8722]=34876,C[8721]=34876,C[8724]=34884,C[8723]=34884,C[8726]=34892,C[8725]=34892,C[8728]=34900,C[8727]=34900,C[8730]=34908,C[8729]=34908,C[8732]=34916,C[8731]=34916,C[8734]=34924,C[8733]=34924,C[8736]=34932,C[8735]=34932,C[8738]=34940,C[8737]=34940,C[8740]=34948,C[8739]=34948,C[8742]=34956,C[8741]=34956,C[8744]=34964,C[8743]=34964,C[8746]=34972,C[8745]=34972,C[8748]=34980,C[8747]=34980,C[8750]=34988,C[8749]=34988,C[8752]=34996,C[8751]=34996,C[8754]=35004,C[8753]=35004,u=i+-40|0,p=e+(F=0==(7&(F=e+8|0)|0)?0:0-F&7)|0,C[8685]=p,C[8682]=u-F,C[p+4>>2]=u-F|1,C[e+u+4>>2]=40,C[8686]=C[8801]}while(0);if((A=0|C[8682])>>>0>t>>>0)return F=A-t|0,C[8682]=F,p=(u=0|C[8685])+t|0,C[8685]=p,C[p+4>>2]=1|F,C[u+4>>2]=3|t,y=I,0|u+8}return C[8678]=48,y=I,0}function p(A){var I,g,C,Q,E=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0,m=0,L=0,x=0,K=0,X=0,j=0,T=0,q=0,V=0,z=0,W=0,O=0,Z=0,$=0,AA=0,IA=0,gA=0,BA=0,CA=0,QA=0,EA=0,iA=0,eA=0,oA=0,cA=0,aA=0,nA=0,rA=0,tA=0,fA=0,wA=0,yA=0;j=0|Bg(0|B[(A|=0)>>0],0|B[A+1>>0],0|B[A+2>>0]),o(),V=0|yg(0|(V=0|kI(A+2|0)),0|o(),5),o(),J=0|yg(0|(J=0|Bg(0|B[A+5>>0],0|B[A+6>>0],0|B[A+7>>0])),0|o(),2),o(),y=0|yg(0|(y=0|kI(A+7|0)),0|o(),7),o(),T=0|yg(0|(T=0|kI(A+10|0)),0|o(),4),o(),Z=0|yg(0|(Z=0|Bg(0|B[A+13>>0],0|B[A+14>>0],0|B[A+15>>0])),0|o(),1),o(),l=0|yg(0|(l=0|kI(A+15|0)),0|o(),6),o(),oA=0|yg(0|(oA=0|Bg(0|B[A+18>>0],0|B[A+19>>0],0|B[A+20>>0])),0|o(),3),o(),rA=0|Bg(0|B[A+21>>0],0|B[A+22>>0],0|B[A+23>>0]),o(),EA=0|yg(0|(EA=0|kI(A+23|0)),0|o(),5),o(),nA=0|yg(0|(nA=0|Bg(0|B[A+26>>0],0|B[A+27>>0],0|B[A+28>>0])),0|o(),2),o(),gA=0|yg(0|(gA=0|kI(A+28|0)),0|o(),7),o(),wA=0|yg(0|(wA=0|kI(A+31|0)),0|o(),4),o(),Y=0|yg(0|(Y=0|Bg(0|B[A+34>>0],0|B[A+35>>0],0|B[A+36>>0])),0|o(),1),o(),K=0|yg(0|(K=0|kI(A+36|0)),0|o(),6),o(),p=0|yg(0|(p=0|Bg(0|B[A+39>>0],0|B[A+40>>0],0|B[A+41>>0])),0|o(),3),o(),e=0|Bg(0|B[A+42>>0],0|B[A+43>>0],0|B[A+44>>0]),o(),L=0|yg(0|(L=0|kI(A+44|0)),0|o(),5),o(),CA=0|yg(0|(CA=0|Bg(0|B[A+47>>0],0|B[A+48>>0],0|B[A+49>>0])),0|o(),2),o(),yA=0|yg(0|(yA=0|kI(A+49|0)),0|o(),7),o(),f=0|yg(0|(f=0|kI(A+52|0)),0|o(),4),o(),G=0|yg(0|(G=0|Bg(0|B[A+55>>0],0|B[A+56>>0],0|B[A+57>>0])),0|o(),1),o(),U=0|yg(0|(U=0|kI(A+57|0)),0|o(),6),o(),r=0|Qg(0|(q=0|yg(0|(q=0|kI(A+60|0)),0|o(),3)),0|(c=0|o()),666643,0),F=0|o(),aA=0|Qg(0|q,0|c,470296,0),u=0|o(),M=0|Qg(0|q,0|c,654183,0),a=0|o(),_=0|Qg(0|q,0|c,-997805,-1),t=0|o(),p=0|vg(0|(E=0|Qg(0|q,0|c,136657,0)),0|o(),2097151&p|0,0),E=0|o(),e=0|vg(0|(c=0|Qg(0|q,0|c,-683901,-1)),0|o(),2097151&e|0,0),c=0|o(),q=0|Qg(2097151&U|0,0,666643,0),x=0|o(),k=0|Qg(2097151&U|0,0,470296,0),IA=0|o(),v=0|Qg(2097151&U|0,0,654183,0),i=0|o(),W=0|Qg(2097151&U|0,0,-997805,-1),z=0|o(),X=0|Qg(2097151&U|0,0,136657,0),D=0|o(),U=0|vg(0|p,0|E,0|(U=0|Qg(2097151&U|0,0,-683901,-1)),0|o()),E=0|o(),p=0|Qg(2097151&G|0,0,666643,0),O=0|o(),d=0|Qg(2097151&G|0,0,470296,0),BA=0|o(),m=0|Qg(2097151&G|0,0,654183,0),n=0|o(),tA=0|Qg(2097151&G|0,0,-997805,-1),cA=0|o(),AA=0|Qg(2097151&G|0,0,136657,0),b=0|o(),D=0|vg(0|(t=0|vg(0|(K=0|vg(0|(G=0|Qg(2097151&G|0,0,-683901,-1)),0|o(),2097151&K|0,0)),0|o(),0|_,0|t)),0|o(),0|X,0|D),X=0|o(),t=0|Qg(2097151&f|0,0,666643,0),_=0|o(),K=0|Qg(2097151&f|0,0,470296,0),G=0|o(),s=0|Qg(2097151&f|0,0,654183,0),$=0|o(),P=0|Qg(2097151&f|0,0,-997805,-1),R=0|o(),Q=0|Qg(2097151&f|0,0,136657,0),fA=0|o(),f=0|Qg(2097151&f|0,0,-683901,-1),w=0|o(),h=0|Qg(2097151&yA|0,0,666643,0),S=0|o(),iA=0|Qg(2097151&yA|0,0,470296,0),eA=0|o(),g=0|Qg(2097151&yA|0,0,654183,0),QA=0|o(),C=0|Qg(2097151&yA|0,0,-997805,-1),N=0|o(),I=0|Qg(2097151&yA|0,0,136657,0),H=0|o(),i=0|vg(0|(u=0|vg(0|(cA=0|vg(0|(fA=0|vg(0|(wA=0|vg(0|(yA=0|Qg(2097151&yA|0,0,-683901,-1)),0|o(),2097151&wA|0,0)),0|o(),0|Q,0|fA)),0|o(),0|tA,0|cA)),0|o(),0|aA,0|u)),0|o(),0|v,0|i),v=0|o(),l=0|vg(0|(u=0|Qg(2097151&CA|0,0,666643,0)),0|o(),2097151&l|0,0),u=0|o(),aA=0|Qg(2097151&CA|0,0,470296,0),cA=0|o(),_=0|vg(0|(eA=0|vg(0|(rA=0|vg(0|(tA=0|Qg(2097151&CA|0,0,654183,0)),0|o(),2097151&rA|0,0)),0|o(),0|iA,0|eA)),0|o(),0|t,0|_),t=0|o(),eA=0|Qg(2097151&CA|0,0,-997805,-1),iA=0|o(),x=0|vg(0|(BA=0|vg(0|($=0|vg(0|(N=0|vg(0|(nA=0|vg(0|(rA=0|Qg(2097151&CA|0,0,136657,0)),0|o(),2097151&nA|0,0)),0|o(),0|C,0|N)),0|o(),0|s,0|$)),0|o(),0|d,0|BA)),0|o(),0|q,0|x),q=0|o(),CA=0|Qg(2097151&CA|0,0,-683901,-1),BA=0|o(),s=0|yg(0|(d=0|vg(0|l,0|u,1048576,0)),0|($=0|o()),21),N=0|o(),N=0|vg(0|(S=0|vg(0|(oA=0|vg(0|aA,0|cA,2097151&oA|0,0)),0|o(),0|h,0|S)),0|o(),0|s,0|N),s=0|o(),$=0|Ug(0|l,0|u,-2097152&d|0,2047&$|0),d=0|o(),S=0|yg(0|(u=0|vg(0|_,0|t,1048576,0)),0|(l=0|o()),21),h=0|o(),h=0|vg(0|(O=0|vg(0|(G=0|vg(0|(QA=0|vg(0|(EA=0|vg(0|eA,0|iA,2097151&EA|0,0)),0|o(),0|g,0|QA)),0|o(),0|K,0|G)),0|o(),0|p,0|O)),0|o(),0|S,0|h),S=0|o(),G=0|ig(0|(O=0|vg(0|x,0|q,1048576,0)),0|(p=0|o()),21),K=0|o(),K=0|vg(0|(IA=0|vg(0|(F=0|vg(0|(n=0|vg(0|(R=0|vg(0|(H=0|vg(0|(gA=0|vg(0|CA,0|BA,2097151&gA|0,0)),0|o(),0|I,0|H)),0|o(),0|P,0|R)),0|o(),0|m,0|n)),0|o(),0|r,0|F)),0|o(),0|k,0|IA)),0|o(),0|G,0|K),G=0|o(),F=0|ig(0|(IA=0|vg(0|i,0|v,1048576,0)),0|(k=0|o()),21),r=0|o(),r=0|vg(0|(z=0|vg(0|(a=0|vg(0|(b=0|vg(0|(Y=0|vg(0|f,0|w,2097151&Y|0,0)),0|o(),0|AA,0|b)),0|o(),0|M,0|a)),0|o(),0|W,0|z)),0|o(),0|F,0|r),F=0|o(),k=0|Ug(0|i,0|v,-2097152&IA|0,0|k),IA=0|o(),z=0|vg(0|U,0|E,0|(z=0|ig(0|(v=0|vg(0|D,0|X,1048576,0)),0|(i=0|o()),21)),0|o()),E=0|o(),i=0|Ug(0|D,0|X,-2097152&v|0,0|i),v=0|o(),L=0|vg(0|(U=0|ig(0|(X=0|vg(0|e,0|c,1048576,0)),0|(D=0|o()),21)),0|o(),2097151&L|0,0),U=0|o(),D=0|Ug(0|e,0|c,-2097152&X|0,0|D),X=0|o(),W=0|yg(0|(c=0|vg(0|N,0|s,1048576,0)),0|(e=0|o()),21),a=0|o(),e=0|Ug(0|N,0|s,-2097152&c|0,0|e),c=0|o(),M=0|ig(0|(s=0|vg(0|h,0|S,1048576,0)),0|(N=0|o()),21),b=0|o(),IA=0|vg(0|(w=0|ig(0|(AA=0|vg(0|K,0|G,1048576,0)),0|(Y=0|o()),21)),0|o(),0|k,0|IA),k=0|o(),Y=0|Ug(0|K,0|G,-2097152&AA|0,0|Y),AA=0|o(),v=0|vg(0|(w=0|ig(0|(G=0|vg(0|r,0|F,1048576,0)),0|(K=0|o()),21)),0|o(),0|i,0|v),i=0|o(),K=0|Ug(0|r,0|F,-2097152&G|0,0|K),G=0|o(),X=0|vg(0|(w=0|ig(0|(F=0|vg(0|z,0|E,1048576,0)),0|(r=0|o()),21)),0|o(),0|D,0|X),D=0|o(),r=0|Ug(0|z,0|E,-2097152&F|0,0|r),F=0|o(),Z=0|vg(0|(E=0|Qg(0|L,0|U,666643,0)),0|o(),2097151&Z|0,0),E=0|o(),z=0|vg(0|$,0|d,0|(z=0|Qg(0|L,0|U,470296,0)),0|o()),d=0|o(),$=0|vg(0|e,0|c,0|($=0|Qg(0|L,0|U,654183,0)),0|o()),c=0|o(),e=0|Qg(0|L,0|U,-997805,-1),w=0|o(),f=0|Qg(0|L,0|U,136657,0),n=0|o(),p=0|Ug(0|(b=0|vg(0|(q=0|vg(0|(U=0|Qg(0|L,0|U,-683901,-1)),0|o(),0|x,0|q)),0|o(),0|M,0|b)),0|o(),-2097152&O|0,0|p),O=0|o(),T=0|vg(0|(b=0|Qg(0|X,0|D,666643,0)),0|o(),2097151&T|0,0),b=0|o(),M=0|vg(0|Z,0|E,0|(M=0|Qg(0|X,0|D,470296,0)),0|o()),E=0|o(),Z=0|vg(0|z,0|d,0|(Z=0|Qg(0|X,0|D,654183,0)),0|o()),d=0|o(),z=0|vg(0|$,0|c,0|(z=0|Qg(0|X,0|D,-997805,-1)),0|o()),c=0|o(),$=0|Qg(0|X,0|D,136657,0),q=0|o(),D=0|Qg(0|X,0|D,-683901,-1),X=0|o(),y=0|vg(0|(x=0|Qg(0|r,0|F,666643,0)),0|o(),2097151&y|0,0),x=0|o(),U=0|vg(0|T,0|b,0|(U=0|Qg(0|r,0|F,470296,0)),0|o()),b=0|o(),T=0|vg(0|M,0|E,0|(T=0|Qg(0|r,0|F,654183,0)),0|o()),E=0|o(),M=0|vg(0|Z,0|d,0|(M=0|Qg(0|r,0|F,-997805,-1)),0|o()),d=0|o(),Z=0|vg(0|z,0|c,0|(Z=0|Qg(0|r,0|F,136657,0)),0|o()),c=0|o(),F=0|Qg(0|r,0|F,-683901,-1),r=0|o(),r=0|vg(0|(q=0|vg(0|(w=0|vg(0|(l=0|Ug(0|(t=0|vg(0|W,0|a,0|_,0|t)),0|o(),-2097152&u|0,0|l)),0|o(),0|e,0|w)),0|o(),0|$,0|q)),0|o(),0|F,0|r),F=0|o(),J=0|vg(0|(q=0|Qg(0|v,0|i,666643,0)),0|o(),2097151&J|0,0),q=0|o(),$=0|vg(0|y,0|x,0|($=0|Qg(0|v,0|i,470296,0)),0|o()),x=0|o(),y=0|vg(0|U,0|b,0|(y=0|Qg(0|v,0|i,654183,0)),0|o()),b=0|o(),U=0|vg(0|T,0|E,0|(U=0|Qg(0|v,0|i,-997805,-1)),0|o()),E=0|o(),T=0|vg(0|M,0|d,0|(T=0|Qg(0|v,0|i,136657,0)),0|o()),d=0|o(),i=0|vg(0|Z,0|c,0|(i=0|Qg(0|v,0|i,-683901,-1)),0|o()),c=0|o(),V=0|vg(0|(Z=0|Qg(0|K,0|G,666643,0)),0|o(),2097151&V|0,0),Z=0|o(),v=0|vg(0|J,0|q,0|(v=0|Qg(0|K,0|G,470296,0)),0|o()),q=0|o(),J=0|vg(0|$,0|x,0|(J=0|Qg(0|K,0|G,654183,0)),0|o()),x=0|o(),$=0|vg(0|y,0|b,0|($=0|Qg(0|K,0|G,-997805,-1)),0|o()),b=0|o(),y=0|vg(0|U,0|E,0|(y=0|Qg(0|K,0|G,136657,0)),0|o()),E=0|o(),G=0|vg(0|T,0|d,0|(G=0|Qg(0|K,0|G,-683901,-1)),0|o()),d=0|o(),j=0|vg(0|(T=0|Qg(0|IA,0|k,666643,0)),0|o(),2097151&j|0,0),T=0|o(),K=0|vg(0|V,0|Z,0|(K=0|Qg(0|IA,0|k,470296,0)),0|o()),Z=0|o(),V=0|vg(0|v,0|q,0|(V=0|Qg(0|IA,0|k,654183,0)),0|o()),q=0|o(),v=0|vg(0|J,0|x,0|(v=0|Qg(0|IA,0|k,-997805,-1)),0|o()),x=0|o(),J=0|vg(0|$,0|b,0|(J=0|Qg(0|IA,0|k,136657,0)),0|o()),b=0|o(),k=0|vg(0|y,0|E,0|(k=0|Qg(0|IA,0|k,-683901,-1)),0|o()),E=0|o(),$=0|vg(0|K,0|Z,0|($=0|ig(0|(y=0|vg(0|j,0|T,1048576,0)),0|(IA=0|o()),21)),0|o()),Z=0|o(),IA=0|Ug(0|j,0|T,-2097152&y|0,0|IA),y=0|o(),K=0|vg(0|v,0|x,0|(K=0|ig(0|(T=0|vg(0|V,0|q,1048576,0)),0|(j=0|o()),21)),0|o()),x=0|o(),M=0|vg(0|k,0|E,0|(M=0|ig(0|(v=0|vg(0|J,0|b,1048576,0)),0|(U=0|o()),21)),0|o()),E=0|o(),e=0|vg(0|i,0|c,0|(e=0|ig(0|(k=0|vg(0|G,0|d,1048576,0)),0|(w=0|o()),21)),0|o()),c=0|o(),w=0|Ug(0|G,0|d,-2097152&k|0,0|w),k=0|o(),i=0|ig(0|(d=0|vg(0|r,0|F,1048576,0)),0|(G=0|o()),21),l=0|o(),l=0|vg(0|(X=0|vg(0|(N=0|Ug(0|(S=0|vg(0|f,0|n,0|h,0|S)),0|o(),-2097152&s|0,0|N)),0|o(),0|D,0|X)),0|o(),0|i,0|l),i=0|o(),G=0|Ug(0|r,0|F,-2097152&d|0,0|G),d=0|o(),AA=0|vg(0|(X=0|ig(0|(F=0|vg(0|p,0|O,1048576,0)),0|(r=0|o()),21)),0|o(),0|Y,0|AA),Y=0|o(),r=0|Ug(0|p,0|O,-2097152&F|0,0|r),F=0|o(),X=0|ig(0|(O=0|vg(0|$,0|Z,1048576,0)),0|(p=0|o()),21),D=0|o(),S=0|ig(0|(N=0|vg(0|K,0|x,1048576,0)),0|(s=0|o()),21),h=0|o(),u=0|vg(0|w,0|k,0|(u=0|ig(0|(n=0|vg(0|M,0|E,1048576,0)),0|(f=0|o()),21)),0|o()),k=0|o(),_=0|vg(0|G,0|d,0|(_=0|ig(0|(w=0|vg(0|e,0|c,1048576,0)),0|(t=0|o()),21)),0|o()),d=0|o(),t=0|Ug(0|e,0|c,-2097152&w|0,0|t),w=0|o(),G=0|vg(0|r,0|F,0|(G=0|ig(0|(c=0|vg(0|l,0|i,1048576,0)),0|(e=0|o()),21)),0|o()),F=0|o(),e=0|Ug(0|l,0|i,-2097152&c|0,0|e),c=0|o(),r=0|ig(0|(i=0|vg(0|AA,0|Y,1048576,0)),0|(l=0|o()),21),a=0|o(),l=0|Ug(0|AA,0|Y,-2097152&i|0,0|l),i=0|o(),Y=0|vg(0|IA,0|y,0|(Y=0|Qg(0|r,0|a,666643,0)),0|o()),y=0|o(),IA=0|Qg(0|r,0|a,470296,0),AA=0|o(),W=0|Qg(0|r,0|a,654183,0),z=0|o(),L=0|Qg(0|r,0|a,-997805,-1),m=0|o(),R=0|Qg(0|r,0|a,136657,0),P=0|o(),a=0|Qg(0|r,0|a,-683901,-1),r=0|o(),y=0|ig(0|Y,0|y,21),H=0|o(),y=0|ig(0|(H=0|vg(0|(p=0|Ug(0|(Z=0|vg(0|IA,0|AA,0|$,0|Z)),0|o(),-2097152&O|0,0|p)),0|o(),0|y,0|H)),0|o(),21),p=0|o(),y=0|ig(0|(p=0|vg(0|(D=0|vg(0|(j=0|Ug(0|(q=0|vg(0|W,0|z,0|V,0|q)),0|o(),-2097152&T|0,0|j)),0|o(),0|X,0|D)),0|o(),0|y,0|p)),0|o(),21),D=0|o(),y=0|ig(0|(D=0|vg(0|(s=0|Ug(0|(m=0|vg(0|K,0|x,0|L,0|m)),0|o(),-2097152&N|0,0|s)),0|o(),0|y,0|D)),0|o(),21),s=0|o(),y=0|ig(0|(s=0|vg(0|(h=0|vg(0|(U=0|Ug(0|(b=0|vg(0|R,0|P,0|J,0|b)),0|o(),-2097152&v|0,0|U)),0|o(),0|S,0|h)),0|o(),0|y,0|s)),0|o(),21),h=0|o(),Y=0|vg(0|(G=0|Qg(0|(l=0|ig(0|(i=0|vg(0|(F=0|ig(0|(e=0|vg(0|G,0|F,0|(e=0|ig(0|(c=0|vg(0|(d=0|ig(0|(t=0|vg(0|_,0|d,0|(t=0|ig(0|(w=0|vg(0|(k=0|ig(0|(y=0|vg(0|u,0|k,0|(y=0|ig(0|(h=0|vg(0|(f=0|Ug(0|(r=0|vg(0|M,0|E,0|a,0|r)),0|o(),-2097152&n|0,0|f)),0|o(),0|y,0|h)),0|o(),21)),0|o())),0|o(),21)),0|o(),0|t,0|w)),0|o(),21)),0|o())),0|o(),21)),0|o(),0|e,0|c)),0|o(),21)),0|o())),0|o(),21)),0|o(),0|l,0|i)),0|o(),21)),0|(F=0|o()),666643,0)),0|o(),2097151&Y|0,0),G=0|o(),H=0|vg(0|(d=0|Qg(0|l,0|F,470296,0)),0|o(),2097151&H|0,0),d=0|o(),p=0|vg(0|(_=0|Qg(0|l,0|F,654183,0)),0|o(),2097151&p|0,0),_=0|o(),D=0|vg(0|(k=0|Qg(0|l,0|F,-997805,-1)),0|o(),2097151&D|0,0),k=0|o(),s=0|vg(0|(u=0|Qg(0|l,0|F,136657,0)),0|o(),2097151&s|0,0),u=0|o(),i=0|vg(0|(E=0|ig(0|(e=0|vg(0|(a=0|ig(0|(c=0|vg(0|(r=0|ig(0|(t=0|vg(0|(n=0|ig(0|(w=0|vg(0|(f=0|ig(0|(y=0|vg(0|(h=0|ig(0|(s=0|vg(0|(h=0|vg(0|(F=0|Qg(0|l,0|F,-683901,-1)),0|o(),2097151&h|0,0)),0|(F=0|o()),0|(s=0|ig(0|(D=0|vg(0|s,0|u,0|(D=0|ig(0|(p=0|vg(0|D,0|k,0|(p=0|ig(0|(H=0|vg(0|p,0|_,0|(H=0|ig(0|(l=0|vg(0|H,0|d,0|(l=0|ig(0|Y,0|G,21)),0|o())),0|(d=0|o()),21)),0|o())),0|(_=0|o()),21)),0|o())),0|(k=0|o()),21)),0|o())),0|(u=0|o()),21)),0|o())),0|(F=0|o()),21)),0|o(),2097151&y|0,0)),0|(h=0|o()),21)),0|o(),2097151&w|0,0)),0|(f=0|o()),21)),0|o(),2097151&t|0,0)),0|(n=0|o()),21)),0|o(),2097151&c|0,0)),0|(r=0|o()),21)),0|o(),2097151&e|0,0)),0|(a=0|o()),21)),0|o(),2097151&i|0,0),E=0|o(),B[A>>0]=Y,M=0|yg(0|Y,0|G,8),o(),B[A+1>>0]=M,G=0|yg(0|Y,0|G,16),o(),Y=0|rg(2097151&l|0,0,5),o(),B[A+2>>0]=Y|31&G,G=0|yg(0|l,0|d,3),o(),B[A+3>>0]=G,d=0|yg(0|l,0|d,11),o(),B[A+4>>0]=d,l=0|yg(2097151&l|0,0,19),d=0|o(),G=0|rg(2097151&H|0,0,2),o(),B[A+5>>0]=G|l,_=0|yg(0|H,0|_,6),o(),B[A+6>>0]=_,H=0|yg(2097151&H|0,0,14),_=0|o(),l=0|rg(2097151&p|0,0,7),o(),B[A+7>>0]=l|H,H=0|yg(0|p,0|k,1),o(),B[A+8>>0]=H,k=0|yg(0|p,0|k,9),o(),B[A+9>>0]=k,p=0|yg(2097151&p|0,0,17),k=0|o(),H=0|rg(2097151&D|0,0,4),o(),B[A+10>>0]=H|p,p=0|yg(0|D,0|u,4),o(),B[A+11>>0]=p,u=0|yg(0|D,0|u,12),o(),B[A+12>>0]=u,D=0|yg(2097151&D|0,0,20),u=0|o(),p=0|rg(2097151&s|0,0,1),o(),B[A+13>>0]=p|D,F=0|yg(0|s,0|F,7),o(),B[A+14>>0]=F,s=0|yg(2097151&s|0,0,15),F=0|o(),D=0|rg(2097151&y|0,0,6),o(),B[A+15>>0]=D|s,s=0|yg(0|y,0|h,2),o(),B[A+16>>0]=s,h=0|yg(0|y,0|h,10),o(),B[A+17>>0]=h,y=0|yg(2097151&y|0,0,18),h=0|o(),s=0|rg(0|w,0|f,3),o(),B[A+18>>0]=s|y,y=0|yg(0|w,0|f,5),o(),B[A+19>>0]=y,f=0|yg(0|w,0|f,13),o(),B[A+20>>0]=f,B[A+21>>0]=t,f=0|yg(0|t,0|n,8),o(),B[A+22>>0]=f,n=0|yg(0|t,0|n,16),o(),t=0|rg(2097151&c|0,0,5),o(),B[A+23>>0]=t|31&n,n=0|yg(0|c,0|r,3),o(),B[A+24>>0]=n,r=0|yg(0|c,0|r,11),o(),B[A+25>>0]=r,c=0|yg(2097151&c|0,0,19),r=0|o(),n=0|rg(2097151&e|0,0,2),o(),B[A+26>>0]=n|c,a=0|yg(0|e,0|a,6),o(),B[A+27>>0]=a,e=0|yg(2097151&e|0,0,14),a=0|o(),c=0|rg(0|i,0|E,7),o(),B[A+28>>0]=c|e,e=0|yg(0|i,0|E,1),o(),B[A+29>>0]=e,e=0|yg(0|i,0|E,9),o(),B[A+30>>0]=e,E=0|ig(0|i,0|E,17),o(),B[A+31>>0]=E}function u(A,I,g){A|=0,g|=0;var B,Q,E,i,e,c,a,n,r,t,f,w,y,s,h,D,F,p,u,H,k,l,_,G,d,Y,M,S,U,v,b,J,P,R,N,m,L,x,K,X,j,T,q,V,z,W,O,Z,$,AA,IA,gA,BA,CA,QA,EA,iA,eA,oA,cA,aA,nA,rA,tA,fA,wA,yA,sA,hA,DA,FA,pA,uA,HA,kA,lA,_A,GA,dA,YA,MA,SA,UA,vA,bA,JA,PA,RA,NA,mA=0,LA=0,xA=0,KA=0,XA=0,jA=0,TA=0,qA=0,VA=0,zA=0,WA=0,OA=0,ZA=0,$A=0,AI=0,II=0,gI=0,BI=0,CI=0,QI=0,EI=0,iI=0,eI=0,oI=0,cI=0,aI=0,nI=0,rI=0,tI=0,fI=0,wI=0,yI=0,sI=0,hI=0,DI=0,FI=0,pI=0,uI=0,HI=0,kI=0,lI=0,_I=0,GI=0,dI=0,YI=0,MI=0,SI=0,UI=0,vI=0,bI=0,JI=0,PI=0,RI=0,NI=0,mI=0,LI=0,xI=0,KI=0,XI=0,jI=0,TI=0,qI=0,VI=0,zI=0,WI=0,OI=0,ZI=0,$I=0,Ag=0,Ig=0,gg=0,Bg=0,Cg=0,Eg=0,eg=0,og=0,cg=0,ag=0,ng=0,rg=0,tg=0,fg=0,wg=0,sg=0,hg=0,Dg=0,Fg=0,pg=0,ug=0,Hg=0,kg=0,lg=0,_g=0,Gg=0,dg=0,Yg=0,Mg=0,Sg=0,bg=0,Jg=0,Pg=0,Rg=0,Ng=0,mg=0,Lg=0,xg=0,Kg=0,Xg=0,jg=0,Tg=0;AI=0|C[(I|=0)>>2],qA=0|C[I+4>>2],jA=0|C[I+8>>2],ZA=0|C[I+12>>2],SI=0|C[I+16>>2],OA=0|C[I+20>>2],eg=0|C[I+24>>2],mA=0|C[I+28>>2],pI=0|C[I+32>>2],nI=0|C[I+36>>2],oI=0|C[g>>2],Tg=0|C[g+4>>2],lg=0|C[g+8>>2],Bg=0|C[g+12>>2],RI=0|C[g+16>>2],Yg=0|C[g+20>>2],ag=0|C[g+24>>2],KI=0|C[g+28>>2],uI=0|C[g+32>>2],NA=0|C[g+36>>2],PA=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),jg=0|o(),dA=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),GA=0|o(),gA=0|Qg(0|lg,((0|lg)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),Cg=0|o(),P=0|Qg(0|Bg,((0|Bg)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),NI=0|o(),pA=0|Qg(0|RI,((0|RI)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),Sg=0|o(),eA=0|Qg(0|Yg,((0|Yg)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),rg=0|o(),K=0|Qg(0|ag,((0|ag)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),jI=0|o(),H=0|Qg(0|KI,((0|KI)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),kI=0|o(),t=0|Qg(0|uI,((0|uI)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),rI=0|o(),AI=0|Qg(0|NA,((0|NA)<0)<<31>>31|0,0|AI,((0|AI)<0)<<31>>31|0),$A=0|o(),_g=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|qA,((0|qA)<0)<<31>>31|0),Gg=0|o(),QA=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,qA<<1|0,((qA<<1|0)<0)<<31>>31|0),CA=0|o(),R=0|Qg(0|lg,((0|lg)<0)<<31>>31|0,0|qA,((0|qA)<0)<<31>>31|0),mI=0|o(),uA=0|Qg(0|Bg,((0|Bg)<0)<<31>>31|0,qA<<1|0,((qA<<1|0)<0)<<31>>31|0),bg=0|o(),oA=0|Qg(0|RI,((0|RI)<0)<<31>>31|0,0|qA,((0|qA)<0)<<31>>31|0),tg=0|o(),X=0|Qg(0|Yg,((0|Yg)<0)<<31>>31|0,qA<<1|0,((qA<<1|0)<0)<<31>>31|0),TI=0|o(),k=0|Qg(0|ag,((0|ag)<0)<<31>>31|0,0|qA,((0|qA)<0)<<31>>31|0),lI=0|o(),f=0|Qg(0|KI,((0|KI)<0)<<31>>31|0,qA<<1|0,((qA<<1|0)<0)<<31>>31|0),tI=0|o(),B=0|Qg(0|uI,((0|uI)<0)<<31>>31|0,0|qA,((0|qA)<0)<<31>>31|0),II=0|o(),qA=0|Qg(19*NA|0,0|(aI=((19*NA|0)<0)<<31>>31),qA<<1|0,((qA<<1|0)<0)<<31>>31|0),I=0|o(),BA=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|jA,((0|jA)<0)<<31>>31|0),Eg=0|o(),L=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,0|jA,((0|jA)<0)<<31>>31|0),m=0|o(),HA=0|Qg(0|lg,((0|lg)<0)<<31>>31|0,0|jA,((0|jA)<0)<<31>>31|0),Jg=0|o(),cA=0|Qg(0|Bg,((0|Bg)<0)<<31>>31|0,0|jA,((0|jA)<0)<<31>>31|0),fg=0|o(),j=0|Qg(0|RI,((0|RI)<0)<<31>>31|0,0|jA,((0|jA)<0)<<31>>31|0),qI=0|o(),l=0|Qg(0|Yg,((0|Yg)<0)<<31>>31|0,0|jA,((0|jA)<0)<<31>>31|0),_I=0|o(),w=0|Qg(0|ag,((0|ag)<0)<<31>>31|0,0|jA,((0|jA)<0)<<31>>31|0),fI=0|o(),Q=0|Qg(0|KI,((0|KI)<0)<<31>>31|0,0|jA,((0|jA)<0)<<31>>31|0),gI=0|o(),YA=0|Qg(19*uI|0,0|(HI=((19*uI|0)<0)<<31>>31),0|jA,((0|jA)<0)<<31>>31|0),Rg=0|o(),jA=0|Qg(19*NA|0,0|aI,0|jA,((0|jA)<0)<<31>>31|0),TA=0|o(),N=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|ZA,((0|ZA)<0)<<31>>31|0),LI=0|o(),_A=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,ZA<<1|0,((ZA<<1|0)<0)<<31>>31|0),lA=0|o(),aA=0|Qg(0|lg,((0|lg)<0)<<31>>31|0,0|ZA,((0|ZA)<0)<<31>>31|0),wg=0|o(),T=0|Qg(0|Bg,((0|Bg)<0)<<31>>31|0,ZA<<1|0,((ZA<<1|0)<0)<<31>>31|0),VI=0|o(),_=0|Qg(0|RI,((0|RI)<0)<<31>>31|0,0|ZA,((0|ZA)<0)<<31>>31|0),GI=0|o(),y=0|Qg(0|Yg,((0|Yg)<0)<<31>>31|0,ZA<<1|0,((ZA<<1|0)<0)<<31>>31|0),wI=0|o(),E=0|Qg(0|ag,((0|ag)<0)<<31>>31|0,0|ZA,((0|ZA)<0)<<31>>31|0),BI=0|o(),MA=0|Qg(19*KI|0,0|(XI=((19*KI|0)<0)<<31>>31),ZA<<1|0,((ZA<<1|0)<0)<<31>>31|0),Ng=0|o(),fA=0|Qg(19*uI|0,0|HI,0|ZA,((0|ZA)<0)<<31>>31|0),hg=0|o(),ZA=0|Qg(19*NA|0,0|aI,ZA<<1|0,((ZA<<1|0)<0)<<31>>31|0),XA=0|o(),kA=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|SI,((0|SI)<0)<<31>>31|0),Pg=0|o(),tA=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,0|SI,((0|SI)<0)<<31>>31|0),rA=0|o(),q=0|Qg(0|lg,((0|lg)<0)<<31>>31|0,0|SI,((0|SI)<0)<<31>>31|0),zI=0|o(),G=0|Qg(0|Bg,((0|Bg)<0)<<31>>31|0,0|SI,((0|SI)<0)<<31>>31|0),dI=0|o(),s=0|Qg(0|RI,((0|RI)<0)<<31>>31|0,0|SI,((0|SI)<0)<<31>>31|0),yI=0|o(),i=0|Qg(0|Yg,((0|Yg)<0)<<31>>31|0,0|SI,((0|SI)<0)<<31>>31|0),CI=0|o(),SA=0|Qg(19*ag|0,0|(ng=((19*ag|0)<0)<<31>>31),0|SI,((0|SI)<0)<<31>>31|0),mg=0|o(),wA=0|Qg(19*KI|0,0|XI,0|SI,((0|SI)<0)<<31>>31|0),Dg=0|o(),O=0|Qg(19*uI|0,0|HI,0|SI,((0|SI)<0)<<31>>31|0),OI=0|o(),SI=0|Qg(19*NA|0,0|aI,0|SI,((0|SI)<0)<<31>>31|0),xA=0|o(),nA=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|OA,((0|OA)<0)<<31>>31|0),sg=0|o(),W=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,OA<<1|0,((OA<<1|0)<0)<<31>>31|0),z=0|o(),d=0|Qg(0|lg,((0|lg)<0)<<31>>31|0,0|OA,((0|OA)<0)<<31>>31|0),YI=0|o(),h=0|Qg(0|Bg,((0|Bg)<0)<<31>>31|0,OA<<1|0,((OA<<1|0)<0)<<31>>31|0),sI=0|o(),e=0|Qg(0|RI,((0|RI)<0)<<31>>31|0,0|OA,((0|OA)<0)<<31>>31|0),QI=0|o(),UA=0|Qg(19*Yg|0,0|(Mg=((19*Yg|0)<0)<<31>>31),OA<<1|0,((OA<<1|0)<0)<<31>>31|0),Lg=0|o(),yA=0|Qg(19*ag|0,0|ng,0|OA,((0|OA)<0)<<31>>31|0),Fg=0|o(),Z=0|Qg(19*KI|0,0|XI,OA<<1|0,((OA<<1|0)<0)<<31>>31|0),ZI=0|o(),U=0|Qg(19*uI|0,0|HI,0|OA,((0|OA)<0)<<31>>31|0),UI=0|o(),OA=0|Qg(19*NA|0,0|aI,OA<<1|0,((OA<<1|0)<0)<<31>>31|0),LA=0|o(),V=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|eg,((0|eg)<0)<<31>>31|0),WI=0|o(),S=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,0|eg,((0|eg)<0)<<31>>31|0),M=0|o(),D=0|Qg(0|lg,((0|lg)<0)<<31>>31|0,0|eg,((0|eg)<0)<<31>>31|0),hI=0|o(),c=0|Qg(0|Bg,((0|Bg)<0)<<31>>31|0,0|eg,((0|eg)<0)<<31>>31|0),EI=0|o(),vA=0|Qg(19*RI|0,((19*RI|0)<0)<<31>>31|0,0|eg,((0|eg)<0)<<31>>31|0),xg=0|o(),sA=0|Qg(19*Yg|0,0|Mg,0|eg,((0|eg)<0)<<31>>31|0),pg=0|o(),$=0|Qg(19*ag|0,0|ng,0|eg,((0|eg)<0)<<31>>31|0),$I=0|o(),v=0|Qg(19*KI|0,0|XI,0|eg,((0|eg)<0)<<31>>31|0),vI=0|o(),VA=0|Qg(19*uI|0,0|HI,0|eg,((0|eg)<0)<<31>>31|0),zA=0|o(),eg=0|Qg(19*NA|0,0|aI,0|eg,((0|eg)<0)<<31>>31|0),KA=0|o(),Y=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|mA,((0|mA)<0)<<31>>31|0),MI=0|o(),u=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,mA<<1|0,((mA<<1|0)<0)<<31>>31|0),p=0|o(),a=0|Qg(0|lg,((0|lg)<0)<<31>>31|0,0|mA,((0|mA)<0)<<31>>31|0),iI=0|o(),bA=0|Qg(19*Bg|0,((19*Bg|0)<0)<<31>>31|0,mA<<1|0,((mA<<1|0)<0)<<31>>31|0),Kg=0|o(),hA=0|Qg(19*RI|0,((19*RI|0)<0)<<31>>31|0,0|mA,((0|mA)<0)<<31>>31|0),ug=0|o(),AA=0|Qg(19*Yg|0,0|Mg,mA<<1|0,((mA<<1|0)<0)<<31>>31|0),Ag=0|o(),b=0|Qg(19*ag|0,0|ng,0|mA,((0|mA)<0)<<31>>31|0),bI=0|o(),cI=0|Qg(19*KI|0,0|XI,mA<<1|0,((mA<<1|0)<0)<<31>>31|0),WA=0|o(),EA=0|Qg(19*uI|0,0|HI,0|mA,((0|mA)<0)<<31>>31|0),og=0|o(),g=0|Qg(19*NA|0,0|aI,mA<<1|0,((mA<<1|0)<0)<<31>>31|0),mA=0|o(),F=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|pI,((0|pI)<0)<<31>>31|0),DI=0|o(),r=0|Qg(0|Tg,((0|Tg)<0)<<31>>31|0,0|pI,((0|pI)<0)<<31>>31|0),n=0|o(),JA=0|Qg(19*lg|0,((19*lg|0)<0)<<31>>31|0,0|pI,((0|pI)<0)<<31>>31|0),Xg=0|o(),DA=0|Qg(19*Bg|0,((19*Bg|0)<0)<<31>>31|0,0|pI,((0|pI)<0)<<31>>31|0),Hg=0|o(),IA=0|Qg(19*RI|0,((19*RI|0)<0)<<31>>31|0,0|pI,((0|pI)<0)<<31>>31|0),Ig=0|o(),J=0|Qg(19*Yg|0,0|Mg,0|pI,((0|pI)<0)<<31>>31|0),JI=0|o(),FA=0|Qg(19*ag|0,0|ng,0|pI,((0|pI)<0)<<31>>31|0),dg=0|o(),iA=0|Qg(19*KI|0,0|XI,0|pI,((0|pI)<0)<<31>>31|0),cg=0|o(),x=0|Qg(19*uI|0,0|HI,0|pI,((0|pI)<0)<<31>>31|0),xI=0|o(),pI=0|Qg(19*NA|0,0|aI,0|pI,((0|pI)<0)<<31>>31|0),FI=0|o(),oI=0|Qg(0|oI,((0|oI)<0)<<31>>31|0,0|nI,((0|nI)<0)<<31>>31|0),eI=0|o(),Tg=0|Qg(19*Tg|0,((19*Tg|0)<0)<<31>>31|0,nI<<1|0,((nI<<1|0)<0)<<31>>31|0),RA=0|o(),lg=0|Qg(19*lg|0,((19*lg|0)<0)<<31>>31|0,0|nI,((0|nI)<0)<<31>>31|0),kg=0|o(),Bg=0|Qg(19*Bg|0,((19*Bg|0)<0)<<31>>31|0,nI<<1|0,((nI<<1|0)<0)<<31>>31|0),gg=0|o(),RI=0|Qg(19*RI|0,((19*RI|0)<0)<<31>>31|0,0|nI,((0|nI)<0)<<31>>31|0),PI=0|o(),Mg=0|Qg(19*Yg|0,0|Mg,nI<<1|0,((nI<<1|0)<0)<<31>>31|0),Yg=0|o(),ng=0|Qg(19*ag|0,0|ng,0|nI,((0|nI)<0)<<31>>31|0),ag=0|o(),XI=0|Qg(19*KI|0,0|XI,nI<<1|0,((nI<<1|0)<0)<<31>>31|0),KI=0|o(),HI=0|Qg(19*uI|0,0|HI,0|nI,((0|nI)<0)<<31>>31|0),uI=0|o(),nI=0|Qg(19*NA|0,0|aI,nI<<1|0,((nI<<1|0)<0)<<31>>31|0),aI=0|o(),I=0|vg(0|(Rg=0|vg(0|(Ng=0|vg(0|(mg=0|vg(0|(Lg=0|vg(0|(xg=0|vg(0|(Kg=0|vg(0|(Xg=0|vg(0|(jg=0|vg(0|Tg,0|RA,0|PA,0|jg)),0|o(),0|JA,0|Xg)),0|o(),0|bA,0|Kg)),0|o(),0|vA,0|xg)),0|o(),0|UA,0|Lg)),0|o(),0|SA,0|mg)),0|o(),0|MA,0|Ng)),0|o(),0|YA,0|Rg)),0|o(),0|qA,0|I),qA=0|o(),Gg=0|vg(0|dA,0|GA,0|_g,0|Gg),_g=0|o(),LA=0|vg(0|(zA=0|vg(0|(WA=0|vg(0|(dg=0|vg(0|(Yg=0|vg(0|(Sg=0|vg(0|(bg=0|vg(0|(Jg=0|vg(0|(Pg=0|vg(0|_A,0|lA,0|kA,0|Pg)),0|o(),0|HA,0|Jg)),0|o(),0|uA,0|bg)),0|o(),0|pA,0|Sg)),0|o(),0|Mg,0|Yg)),0|o(),0|FA,0|dg)),0|o(),0|cI,0|WA)),0|o(),0|VA,0|zA)),0|o(),0|OA,0|LA),OA=0|o(),WA=0|ig(0|(zA=0|vg(0|I,0|qA,33554432,0)),0|(VA=0|o()),26),cI=0|o(),cI=0|vg(0|(TA=0|vg(0|(hg=0|vg(0|(Dg=0|vg(0|(Fg=0|vg(0|(pg=0|vg(0|(ug=0|vg(0|(Hg=0|vg(0|(kg=0|vg(0|Gg,0|_g,0|lg,0|kg)),0|o(),0|DA,0|Hg)),0|o(),0|hA,0|ug)),0|o(),0|sA,0|pg)),0|o(),0|yA,0|Fg)),0|o(),0|wA,0|Dg)),0|o(),0|fA,0|hg)),0|o(),0|jA,0|TA)),0|o(),0|WA,0|cI),WA=0|o(),VA=0|Ug(0|I,0|qA,-67108864&zA|0,0|VA),zA=0|o(),TA=0|ig(0|(qA=0|vg(0|LA,0|OA,33554432,0)),0|(I=0|o()),26),jA=0|o(),jA=0|vg(0|(KA=0|vg(0|(og=0|vg(0|(cg=0|vg(0|(ag=0|vg(0|(rg=0|vg(0|(tg=0|vg(0|(fg=0|vg(0|(wg=0|vg(0|(sg=0|vg(0|tA,0|rA,0|nA,0|sg)),0|o(),0|aA,0|wg)),0|o(),0|cA,0|fg)),0|o(),0|oA,0|tg)),0|o(),0|eA,0|rg)),0|o(),0|ng,0|ag)),0|o(),0|iA,0|cg)),0|o(),0|EA,0|og)),0|o(),0|eg,0|KA)),0|o(),0|TA,0|jA),TA=0|o(),I=0|Ug(0|LA,0|OA,-67108864&qA|0,0|I),qA=0|o(),LA=0|ig(0|(OA=0|vg(0|cI,0|WA,16777216,0)),0|o(),25),KA=0|o(),KA=0|vg(0|(XA=0|vg(0|(OI=0|vg(0|(ZI=0|vg(0|($I=0|vg(0|(Ag=0|vg(0|(Ig=0|vg(0|(gg=0|vg(0|(Cg=0|vg(0|(Eg=0|vg(0|QA,0|CA,0|BA,0|Eg)),0|o(),0|gA,0|Cg)),0|o(),0|Bg,0|gg)),0|o(),0|IA,0|Ig)),0|o(),0|AA,0|Ag)),0|o(),0|$,0|$I)),0|o(),0|Z,0|ZI)),0|o(),0|O,0|OI)),0|o(),0|ZA,0|XA)),0|o(),0|LA,0|KA),LA=0|o(),OA=0|Ug(0|cI,0|WA,-33554432&OA|0,0),WA=0|o(),XA=0|ig(0|(cI=0|vg(0|jA,0|TA,16777216,0)),0|o(),25),ZA=0|o(),ZA=0|vg(0|(mA=0|vg(0|(xI=0|vg(0|(KI=0|vg(0|(jI=0|vg(0|(TI=0|vg(0|(qI=0|vg(0|(VI=0|vg(0|(zI=0|vg(0|(WI=0|vg(0|W,0|z,0|V,0|WI)),0|o(),0|q,0|zI)),0|o(),0|T,0|VI)),0|o(),0|j,0|qI)),0|o(),0|X,0|TI)),0|o(),0|K,0|jI)),0|o(),0|XI,0|KI)),0|o(),0|x,0|xI)),0|o(),0|g,0|mA)),0|o(),0|XA,0|ZA),XA=0|o(),cI=0|Ug(0|jA,0|TA,-33554432&cI|0,0),TA=0|o(),mA=0|ig(0|(jA=0|vg(0|KA,0|LA,33554432,0)),0|o(),26),g=0|o(),g=0|vg(0|(xA=0|vg(0|(UI=0|vg(0|(vI=0|vg(0|(bI=0|vg(0|(JI=0|vg(0|(PI=0|vg(0|(NI=0|vg(0|(mI=0|vg(0|(LI=0|vg(0|L,0|m,0|N,0|LI)),0|o(),0|R,0|mI)),0|o(),0|P,0|NI)),0|o(),0|RI,0|PI)),0|o(),0|J,0|JI)),0|o(),0|b,0|bI)),0|o(),0|v,0|vI)),0|o(),0|U,0|UI)),0|o(),0|SI,0|xA)),0|o(),0|mA,0|g),mA=0|o(),jA=0|Ug(0|KA,0|LA,-67108864&jA|0,0),o(),KA=0|ig(0|(LA=0|vg(0|ZA,0|XA,33554432,0)),0|o(),26),xA=0|o(),xA=0|vg(0|(FI=0|vg(0|(uI=0|vg(0|(kI=0|vg(0|(lI=0|vg(0|(_I=0|vg(0|(GI=0|vg(0|(dI=0|vg(0|(YI=0|vg(0|(MI=0|vg(0|S,0|M,0|Y,0|MI)),0|o(),0|d,0|YI)),0|o(),0|G,0|dI)),0|o(),0|_,0|GI)),0|o(),0|l,0|_I)),0|o(),0|k,0|lI)),0|o(),0|H,0|kI)),0|o(),0|HI,0|uI)),0|o(),0|pI,0|FI)),0|o(),0|KA,0|xA),KA=0|o(),LA=0|Ug(0|ZA,0|XA,-67108864&LA|0,0),o(),qA=0|vg(0|(ZA=0|ig(0|(XA=0|vg(0|g,0|mA,16777216,0)),0|o(),25)),0|o(),0|I,0|qA),I=0|o(),XA=0|Ug(0|g,0|mA,-33554432&XA|0,0),o(),g=0|ig(0|(mA=0|vg(0|xA,0|KA,16777216,0)),0|o(),25),ZA=0|o(),ZA=0|vg(0|(aI=0|vg(0|(rI=0|vg(0|(tI=0|vg(0|(fI=0|vg(0|(wI=0|vg(0|(yI=0|vg(0|(sI=0|vg(0|(hI=0|vg(0|(DI=0|vg(0|u,0|p,0|F,0|DI)),0|o(),0|D,0|hI)),0|o(),0|h,0|sI)),0|o(),0|s,0|yI)),0|o(),0|y,0|wI)),0|o(),0|w,0|fI)),0|o(),0|f,0|tI)),0|o(),0|t,0|rI)),0|o(),0|nI,0|aI)),0|o(),0|g,0|ZA),g=0|o(),mA=0|Ug(0|xA,0|KA,-33554432&mA|0,0),o(),xA=0|vg(0|cI,0|TA,0|(xA=0|yg(0|(KA=0|vg(0|qA,0|I,33554432,0)),0|o(),26)),0|o()),o(),KA=0|Ug(0|qA,0|I,-67108864&KA|0,0),o(),qA=0|ig(0|(I=0|vg(0|ZA,0|g,33554432,0)),0|o(),26),TA=0|o(),TA=0|vg(0|($A=0|vg(0|(II=0|vg(0|(gI=0|vg(0|(BI=0|vg(0|(CI=0|vg(0|(QI=0|vg(0|(EI=0|vg(0|(iI=0|vg(0|(eI=0|vg(0|r,0|n,0|oI,0|eI)),0|o(),0|a,0|iI)),0|o(),0|c,0|EI)),0|o(),0|e,0|QI)),0|o(),0|i,0|CI)),0|o(),0|E,0|BI)),0|o(),0|Q,0|gI)),0|o(),0|B,0|II)),0|o(),0|AI,0|$A)),0|o(),0|qA,0|TA),qA=0|o(),I=0|Ug(0|ZA,0|g,-67108864&I|0,0),o(),zA=0|vg(0|(ZA=0|Qg(0|(ZA=0|ig(0|(g=0|vg(0|TA,0|qA,16777216,0)),0|o(),25)),0|o(),19,0)),0|o(),0|VA,0|zA),VA=0|o(),g=0|Ug(0|TA,0|qA,-33554432&g|0,0),o(),TA=0|vg(0|OA,0|WA,0|(TA=0|yg(0|(qA=0|vg(0|zA,0|VA,33554432,0)),0|o(),26)),0|o()),o(),qA=0|Ug(0|zA,0|VA,-67108864&qA|0,0),o(),C[A>>2]=qA,C[A+4>>2]=TA,C[A+8>>2]=jA,C[A+12>>2]=XA,C[A+16>>2]=KA,C[A+20>>2]=xA,C[A+24>>2]=LA,C[A+28>>2]=mA,C[A+32>>2]=I,C[A+36>>2]=g}function H(A,I,g){A|=0,g|=0;var B,Q,E=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0;B=y,Q=y=y+63&-64,y=y+2048|0,fB(Q+1024|0,I|=0),SI(Q+1024|0,A),fB(Q,Q+1024|0),SI(Q,g),A=0;do{i=0|C[Q+1024+((4|(I=A<<4))<<3)>>2],e=0|C[Q+1024+((4|I)<<3)+4>>2],b=0|uI(0|C[Q+1024+(I<<3)>>2],0|C[Q+1024+(I<<3)+4>>2],i,e),N=0|o(),Y=0|ZI(C[Q+1024+((12|I)<<3)>>2]^b,C[Q+1024+((12|I)<<3)+4>>2]^N,32),H=0|o(),H=0|ZI((N=0|uI(b,N,e=0|ZI((F=0|uI(0|C[Q+1024+((8|I)<<3)>>2],0|C[Q+1024+((8|I)<<3)+4>>2],Y,H))^i,(D=0|o())^e,24),i=0|o()))^Y,(b=0|o())^H,16),Y=0|o(),C[Q+1024+((12|I)<<3)>>2]=H,C[Q+1024+((12|I)<<3)+4>>2]=Y,D=0|uI(F,D,H,Y),F=0|o(),C[Q+1024+((8|I)<<3)>>2]=D,C[Q+1024+((8|I)<<3)+4>>2]=F,i=0|ZI(D^e,F^i,63),e=0|o(),C[Q+1024+((4|I)<<3)>>2]=i,C[Q+1024+((4|I)<<3)+4>>2]=e,U=0|C[Q+1024+((5|I)<<3)>>2],v=0|C[Q+1024+((5|I)<<3)+4>>2],_=0|uI(0|C[Q+1024+((1|I)<<3)>>2],0|C[Q+1024+((1|I)<<3)+4>>2],U,v),M=0|o(),p=0|ZI(C[Q+1024+((13|I)<<3)>>2]^_,C[Q+1024+((13|I)<<3)+4>>2]^M,32),f=0|o(),a=0|uI(n=0|uI(0|C[Q+1024+((9|I)<<3)>>2],0|C[Q+1024+((9|I)<<3)+4>>2],p,f),a=0|o(),f=0|ZI((M=0|uI(_,M,v=0|ZI(n^U,a^v,24),U=0|o()))^p,(_=0|o())^f,16),p=0|o()),n=0|o(),C[Q+1024+((9|I)<<3)>>2]=a,C[Q+1024+((9|I)<<3)+4>>2]=n,U=0|ZI(a^v,n^U,63),v=0|o(),k=0|C[Q+1024+((6|I)<<3)>>2],l=0|C[Q+1024+((6|I)<<3)+4>>2],h=0|uI(0|C[Q+1024+((2|I)<<3)>>2],0|C[Q+1024+((2|I)<<3)+4>>2],k,l),u=0|o(),r=0|ZI(C[Q+1024+((14|I)<<3)>>2]^h,C[Q+1024+((14|I)<<3)+4>>2]^u,32),E=0|o(),k=0|ZI((J=0|uI(P=0|uI(0|C[Q+1024+((10|I)<<3)>>2],0|C[Q+1024+((10|I)<<3)+4>>2],r,E),J=0|o(),E=0|ZI((u=0|uI(h,u,l=0|ZI(P^k,J^l,24),k=0|o()))^r,(h=0|o())^E,16),r=0|o()))^l,(P=0|o())^k,63),l=0|o(),w=0|C[Q+1024+((7|I)<<3)>>2],s=0|C[Q+1024+((7|I)<<3)+4>>2],c=0|uI(0|C[Q+1024+((3|I)<<3)>>2],0|C[Q+1024+((3|I)<<3)+4>>2],w,s),t=0|o(),R=0|ZI(C[Q+1024+((15|I)<<3)>>2]^c,C[Q+1024+((15|I)<<3)+4>>2]^t,32),S=0|o(),w=0|ZI((G=0|uI(d=0|uI(0|C[Q+1024+((11|I)<<3)>>2],0|C[Q+1024+((11|I)<<3)+4>>2],R,S),G=0|o(),S=0|ZI((t=0|uI(c,t,s=0|ZI(d^w,G^s,24),w=0|o()))^R,(c=0|o())^S,16),R=0|o()))^s,(d=0|o())^w,63),s=0|o(),N=0|uI(b=0|uI(N,b,U,v),N=0|o(),v=0|ZI((P=0|uI(J,P,R=0|ZI(b^S,N^R,32),S=0|o()))^U,(J=0|o())^v,24),U=0|o()),b=0|o(),C[Q+1024+(I<<3)>>2]=N,C[Q+1024+(I<<3)+4>>2]=b,S=0|ZI(N^R,b^S,16),b=0|o(),C[Q+1024+((15|I)<<3)>>2]=S,C[Q+1024+((15|I)<<3)+4>>2]=b,b=0|uI(P,J,S,b),S=0|o(),C[Q+1024+((10|I)<<3)>>2]=b,C[Q+1024+((10|I)<<3)+4>>2]=S,U=0|ZI(b^v,S^U,63),S=0|o(),C[Q+1024+((5|I)<<3)>>2]=U,C[Q+1024+((5|I)<<3)+4>>2]=S,M=0|uI(_=0|uI(M,_,k,l),M=0|o(),l=0|ZI((d=0|uI(G,d,Y=0|ZI(_^H,M^Y,32),H=0|o()))^k,(G=0|o())^l,24),k=0|o()),_=0|o(),C[Q+1024+((1|I)<<3)>>2]=M,C[Q+1024+((1|I)<<3)+4>>2]=_,H=0|ZI(M^Y,_^H,16),_=0|o(),C[Q+1024+((12|I)<<3)>>2]=H,C[Q+1024+((12|I)<<3)+4>>2]=_,_=0|uI(d,G,H,_),H=0|o(),C[Q+1024+((11|I)<<3)>>2]=_,C[Q+1024+((11|I)<<3)+4>>2]=H,k=0|ZI(_^l,H^k,63),H=0|o(),C[Q+1024+((6|I)<<3)>>2]=k,C[Q+1024+((6|I)<<3)+4>>2]=H,u=0|uI(h=0|uI(u,h,w,s),u=0|o(),s=0|ZI((F=0|uI(D,F,p=0|ZI(h^f,u^p,32),f=0|o()))^w,(D=0|o())^s,24),w=0|o()),h=0|o(),C[Q+1024+((2|I)<<3)>>2]=u,C[Q+1024+((2|I)<<3)+4>>2]=h,f=0|ZI(u^p,h^f,16),h=0|o(),C[Q+1024+((13|I)<<3)>>2]=f,C[Q+1024+((13|I)<<3)+4>>2]=h,h=0|uI(F,D,f,h),f=0|o(),C[Q+1024+((8|I)<<3)>>2]=h,C[Q+1024+((8|I)<<3)+4>>2]=f,w=0|ZI(h^s,f^w,63),f=0|o(),C[Q+1024+((7|I)<<3)>>2]=w,C[Q+1024+((7|I)<<3)+4>>2]=f,t=0|uI(c=0|uI(t,c,i,e),t=0|o(),e=0|ZI((n=0|uI(a,n,r=0|ZI(c^E,t^r,32),E=0|o()))^i,(a=0|o())^e,24),i=0|o()),c=0|o(),C[Q+1024+((3|I)<<3)>>2]=t,C[Q+1024+((3|I)<<3)+4>>2]=c,E=0|ZI(t^r,c^E,16),c=0|o(),C[Q+1024+((14|I)<<3)>>2]=E,C[Q+1024+((14|I)<<3)+4>>2]=c,c=0|uI(n,a,E,c),E=0|o(),C[Q+1024+((9|I)<<3)>>2]=c,C[Q+1024+((9|I)<<3)+4>>2]=E,i=0|ZI(c^e,E^i,63),E=0|o(),C[Q+1024+((4|I)<<3)>>2]=i,C[Q+1024+((4|I)<<3)+4>>2]=E,A=A+1|0}while(8!=(0|A));A=0;do{P=0|C[(J=Q+1024+(32+(N=A<<1)<<3)|0)>>2],J=0|C[J+4>>2],c=0|uI(0|C[Q+1024+(N<<3)>>2],0|C[Q+1024+(N<<3)+4>>2],P,J),I=0|o(),f=0|ZI(C[(f=Q+1024+(N+96<<3)|0)>>2]^c,C[f+4>>2]^I,32),F=0|o(),F=0|ZI((I=0|uI(c,I,J=0|ZI((k=0|uI(0|C[(k=Q+1024+(N+64<<3)|0)>>2],0|C[k+4>>2],f,F))^P,(l=0|o())^J,24),P=0|o()))^f,(c=0|o())^F,16),f=0|o(),C[(r=Q+1024+(N+96<<3)|0)>>2]=F,C[r+4>>2]=f,l=0|uI(k,l,F,f),k=0|o(),C[(r=Q+1024+(N+64<<3)|0)>>2]=l,C[r+4>>2]=k,P=0|ZI(l^J,k^P,63),J=0|o(),C[(r=Q+1024+(N+32<<3)|0)>>2]=P,C[r+4>>2]=J,a=0|C[(r=Q+1024+(N+33<<3)|0)>>2],r=0|C[r+4>>2],h=0|uI(0|C[Q+1024+((1|N)<<3)>>2],0|C[Q+1024+((1|N)<<3)+4>>2],a,r),t=0|o(),H=0|ZI(C[(H=Q+1024+(N+97<<3)|0)>>2]^h,C[H+4>>2]^t,32),d=0|o(),v=0|uI(U=0|uI(0|C[(U=Q+1024+(N+65<<3)|0)>>2],0|C[U+4>>2],H,d),v=0|o(),d=0|ZI((t=0|uI(h,t,r=0|ZI(U^a,v^r,24),a=0|o()))^H,(h=0|o())^d,16),H=0|o()),U=0|o(),C[(_=Q+1024+(N+65<<3)|0)>>2]=v,C[_+4>>2]=U,a=0|ZI(v^r,U^a,63),r=0|o(),_=Q+1024+(N+16<<3)|0,D=0|C[(p=Q+1024+(N+48<<3)|0)>>2],p=0|C[p+4>>2],_=0|uI(0|C[_>>2],0|C[_+4>>2],D,p),u=0|o(),S=0|ZI(C[(S=Q+1024+(N+112<<3)|0)>>2]^_,C[S+4>>2]^u,32),R=0|o(),D=0|ZI((e=0|uI(i=0|uI(0|C[(i=Q+1024+(N+80<<3)|0)>>2],0|C[i+4>>2],S,R),e=0|o(),R=0|ZI((u=0|uI(_,u,p=0|ZI(i^D,e^p,24),D=0|o()))^S,(_=0|o())^R,16),S=0|o()))^p,(i=0|o())^D,63),p=0|o(),b=Q+1024+(N+17<<3)|0,G=0|C[(Y=Q+1024+(N+49<<3)|0)>>2],Y=0|C[Y+4>>2],b=0|uI(0|C[b>>2],0|C[b+4>>2],G,Y),M=0|o(),E=0|ZI(C[(E=Q+1024+(N+113<<3)|0)>>2]^b,C[E+4>>2]^M,32),n=0|o(),G=0|ZI((s=0|uI(w=0|uI(0|C[(w=Q+1024+(N+81<<3)|0)>>2],0|C[w+4>>2],E,n),s=0|o(),n=0|ZI((M=0|uI(b,M,Y=0|ZI(w^G,s^Y,24),G=0|o()))^E,(b=0|o())^n,16),E=0|o()))^Y,(w=0|o())^G,63),Y=0|o(),I=0|uI(c=0|uI(I,c,a,r),I=0|o(),r=0|ZI((i=0|uI(e,i,E=0|ZI(c^n,I^E,32),n=0|o()))^a,(e=0|o())^r,24),a=0|o()),c=0|o(),C[Q+1024+(N<<3)>>2]=I,C[Q+1024+(N<<3)+4>>2]=c,n=0|ZI(I^E,c^n,16),c=0|o(),C[(E=Q+1024+(N+113<<3)|0)>>2]=n,C[E+4>>2]=c,c=0|uI(i,e,n,c),n=0|o(),C[(e=Q+1024+(N+80<<3)|0)>>2]=c,C[e+4>>2]=n,a=0|ZI(c^r,n^a,63),n=0|o(),C[(r=Q+1024+(N+33<<3)|0)>>2]=a,C[r+4>>2]=n,t=0|uI(h=0|uI(t,h,D,p),t=0|o(),p=0|ZI((w=0|uI(s,w,f=0|ZI(h^F,t^f,32),F=0|o()))^D,(s=0|o())^p,24),D=0|o()),h=0|o(),C[Q+1024+((1|N)<<3)>>2]=t,C[Q+1024+((1|N)<<3)+4>>2]=h,F=0|ZI(t^f,h^F,16),h=0|o(),C[(f=Q+1024+(N+96<<3)|0)>>2]=F,C[f+4>>2]=h,h=0|uI(w,s,F,h),F=0|o(),C[(s=Q+1024+(N+81<<3)|0)>>2]=h,C[s+4>>2]=F,D=0|ZI(h^p,F^D,63),F=0|o(),C[(p=Q+1024+(N+48<<3)|0)>>2]=D,C[p+4>>2]=F,u=0|uI(_=0|uI(u,_,G,Y),u=0|o(),Y=0|ZI((k=0|uI(l,k,H=0|ZI(_^d,u^H,32),d=0|o()))^G,(l=0|o())^Y,24),G=0|o()),_=0|o(),C[(p=Q+1024+(N+16<<3)|0)>>2]=u,C[p+4>>2]=_,d=0|ZI(u^H,_^d,16),_=0|o(),C[(H=Q+1024+(N+97<<3)|0)>>2]=d,C[H+4>>2]=_,_=0|uI(k,l,d,_),d=0|o(),C[(l=Q+1024+(N+64<<3)|0)>>2]=_,C[l+4>>2]=d,G=0|ZI(_^Y,d^G,63),d=0|o(),C[(Y=Q+1024+(N+49<<3)|0)>>2]=G,C[Y+4>>2]=d,M=0|uI(b=0|uI(M,b,P,J),M=0|o(),J=0|ZI((U=0|uI(v,U,S=0|ZI(b^R,M^S,32),R=0|o()))^P,(v=0|o())^J,24),P=0|o()),b=0|o(),C[(Y=Q+1024+(N+17<<3)|0)>>2]=M,C[Y+4>>2]=b,R=0|ZI(M^S,b^R,16),b=0|o(),C[(S=Q+1024+(N+112<<3)|0)>>2]=R,C[S+4>>2]=b,b=0|uI(U,v,R,b),R=0|o(),C[(v=Q+1024+(N+65<<3)|0)>>2]=b,C[v+4>>2]=R,P=0|ZI(b^J,R^P,63),R=0|o(),C[(N=Q+1024+(N+32<<3)|0)>>2]=P,C[N+4>>2]=R,A=A+1|0}while(8!=(0|A));fB(g,Q),SI(g,Q+1024|0),y=B}function k(A,I,g){A|=0,g|=0;var B,Q,E=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0;B=y,Q=y=y+63&-64,y=y+2048|0,fB(Q+1024|0,I|=0),SI(Q+1024|0,A),fB(Q,Q+1024|0),A=0;do{i=0|C[Q+1024+((4|(I=A<<4))<<3)>>2],e=0|C[Q+1024+((4|I)<<3)+4>>2],b=0|uI(0|C[Q+1024+(I<<3)>>2],0|C[Q+1024+(I<<3)+4>>2],i,e),N=0|o(),Y=0|ZI(C[Q+1024+((12|I)<<3)>>2]^b,C[Q+1024+((12|I)<<3)+4>>2]^N,32),H=0|o(),H=0|ZI((N=0|uI(b,N,e=0|ZI((F=0|uI(0|C[Q+1024+((8|I)<<3)>>2],0|C[Q+1024+((8|I)<<3)+4>>2],Y,H))^i,(D=0|o())^e,24),i=0|o()))^Y,(b=0|o())^H,16),Y=0|o(),C[Q+1024+((12|I)<<3)>>2]=H,C[Q+1024+((12|I)<<3)+4>>2]=Y,D=0|uI(F,D,H,Y),F=0|o(),C[Q+1024+((8|I)<<3)>>2]=D,C[Q+1024+((8|I)<<3)+4>>2]=F,i=0|ZI(D^e,F^i,63),e=0|o(),C[Q+1024+((4|I)<<3)>>2]=i,C[Q+1024+((4|I)<<3)+4>>2]=e,U=0|C[Q+1024+((5|I)<<3)>>2],v=0|C[Q+1024+((5|I)<<3)+4>>2],_=0|uI(0|C[Q+1024+((1|I)<<3)>>2],0|C[Q+1024+((1|I)<<3)+4>>2],U,v),M=0|o(),p=0|ZI(C[Q+1024+((13|I)<<3)>>2]^_,C[Q+1024+((13|I)<<3)+4>>2]^M,32),f=0|o(),a=0|uI(n=0|uI(0|C[Q+1024+((9|I)<<3)>>2],0|C[Q+1024+((9|I)<<3)+4>>2],p,f),a=0|o(),f=0|ZI((M=0|uI(_,M,v=0|ZI(n^U,a^v,24),U=0|o()))^p,(_=0|o())^f,16),p=0|o()),n=0|o(),C[Q+1024+((9|I)<<3)>>2]=a,C[Q+1024+((9|I)<<3)+4>>2]=n,U=0|ZI(a^v,n^U,63),v=0|o(),k=0|C[Q+1024+((6|I)<<3)>>2],l=0|C[Q+1024+((6|I)<<3)+4>>2],h=0|uI(0|C[Q+1024+((2|I)<<3)>>2],0|C[Q+1024+((2|I)<<3)+4>>2],k,l),u=0|o(),r=0|ZI(C[Q+1024+((14|I)<<3)>>2]^h,C[Q+1024+((14|I)<<3)+4>>2]^u,32),E=0|o(),k=0|ZI((J=0|uI(P=0|uI(0|C[Q+1024+((10|I)<<3)>>2],0|C[Q+1024+((10|I)<<3)+4>>2],r,E),J=0|o(),E=0|ZI((u=0|uI(h,u,l=0|ZI(P^k,J^l,24),k=0|o()))^r,(h=0|o())^E,16),r=0|o()))^l,(P=0|o())^k,63),l=0|o(),w=0|C[Q+1024+((7|I)<<3)>>2],s=0|C[Q+1024+((7|I)<<3)+4>>2],c=0|uI(0|C[Q+1024+((3|I)<<3)>>2],0|C[Q+1024+((3|I)<<3)+4>>2],w,s),t=0|o(),R=0|ZI(C[Q+1024+((15|I)<<3)>>2]^c,C[Q+1024+((15|I)<<3)+4>>2]^t,32),S=0|o(),w=0|ZI((G=0|uI(d=0|uI(0|C[Q+1024+((11|I)<<3)>>2],0|C[Q+1024+((11|I)<<3)+4>>2],R,S),G=0|o(),S=0|ZI((t=0|uI(c,t,s=0|ZI(d^w,G^s,24),w=0|o()))^R,(c=0|o())^S,16),R=0|o()))^s,(d=0|o())^w,63),s=0|o(),N=0|uI(b=0|uI(N,b,U,v),N=0|o(),v=0|ZI((P=0|uI(J,P,R=0|ZI(b^S,N^R,32),S=0|o()))^U,(J=0|o())^v,24),U=0|o()),b=0|o(),C[Q+1024+(I<<3)>>2]=N,C[Q+1024+(I<<3)+4>>2]=b,S=0|ZI(N^R,b^S,16),b=0|o(),C[Q+1024+((15|I)<<3)>>2]=S,C[Q+1024+((15|I)<<3)+4>>2]=b,b=0|uI(P,J,S,b),S=0|o(),C[Q+1024+((10|I)<<3)>>2]=b,C[Q+1024+((10|I)<<3)+4>>2]=S,U=0|ZI(b^v,S^U,63),S=0|o(),C[Q+1024+((5|I)<<3)>>2]=U,C[Q+1024+((5|I)<<3)+4>>2]=S,M=0|uI(_=0|uI(M,_,k,l),M=0|o(),l=0|ZI((d=0|uI(G,d,Y=0|ZI(_^H,M^Y,32),H=0|o()))^k,(G=0|o())^l,24),k=0|o()),_=0|o(),C[Q+1024+((1|I)<<3)>>2]=M,C[Q+1024+((1|I)<<3)+4>>2]=_,H=0|ZI(M^Y,_^H,16),_=0|o(),C[Q+1024+((12|I)<<3)>>2]=H,C[Q+1024+((12|I)<<3)+4>>2]=_,_=0|uI(d,G,H,_),H=0|o(),C[Q+1024+((11|I)<<3)>>2]=_,C[Q+1024+((11|I)<<3)+4>>2]=H,k=0|ZI(_^l,H^k,63),H=0|o(),C[Q+1024+((6|I)<<3)>>2]=k,C[Q+1024+((6|I)<<3)+4>>2]=H,u=0|uI(h=0|uI(u,h,w,s),u=0|o(),s=0|ZI((F=0|uI(D,F,p=0|ZI(h^f,u^p,32),f=0|o()))^w,(D=0|o())^s,24),w=0|o()),h=0|o(),C[Q+1024+((2|I)<<3)>>2]=u,C[Q+1024+((2|I)<<3)+4>>2]=h,f=0|ZI(u^p,h^f,16),h=0|o(),C[Q+1024+((13|I)<<3)>>2]=f,C[Q+1024+((13|I)<<3)+4>>2]=h,h=0|uI(F,D,f,h),f=0|o(),C[Q+1024+((8|I)<<3)>>2]=h,C[Q+1024+((8|I)<<3)+4>>2]=f,w=0|ZI(h^s,f^w,63),f=0|o(),C[Q+1024+((7|I)<<3)>>2]=w,C[Q+1024+((7|I)<<3)+4>>2]=f,t=0|uI(c=0|uI(t,c,i,e),t=0|o(),e=0|ZI((n=0|uI(a,n,r=0|ZI(c^E,t^r,32),E=0|o()))^i,(a=0|o())^e,24),i=0|o()),c=0|o(),C[Q+1024+((3|I)<<3)>>2]=t,C[Q+1024+((3|I)<<3)+4>>2]=c,E=0|ZI(t^r,c^E,16),c=0|o(),C[Q+1024+((14|I)<<3)>>2]=E,C[Q+1024+((14|I)<<3)+4>>2]=c,c=0|uI(n,a,E,c),E=0|o(),C[Q+1024+((9|I)<<3)>>2]=c,C[Q+1024+((9|I)<<3)+4>>2]=E,i=0|ZI(c^e,E^i,63),E=0|o(),C[Q+1024+((4|I)<<3)>>2]=i,C[Q+1024+((4|I)<<3)+4>>2]=E,A=A+1|0}while(8!=(0|A));A=0;do{P=0|C[(J=Q+1024+(32+(N=A<<1)<<3)|0)>>2],J=0|C[J+4>>2],c=0|uI(0|C[Q+1024+(N<<3)>>2],0|C[Q+1024+(N<<3)+4>>2],P,J),I=0|o(),f=0|ZI(C[(f=Q+1024+(N+96<<3)|0)>>2]^c,C[f+4>>2]^I,32),F=0|o(),F=0|ZI((I=0|uI(c,I,J=0|ZI((k=0|uI(0|C[(k=Q+1024+(N+64<<3)|0)>>2],0|C[k+4>>2],f,F))^P,(l=0|o())^J,24),P=0|o()))^f,(c=0|o())^F,16),f=0|o(),C[(r=Q+1024+(N+96<<3)|0)>>2]=F,C[r+4>>2]=f,l=0|uI(k,l,F,f),k=0|o(),C[(r=Q+1024+(N+64<<3)|0)>>2]=l,C[r+4>>2]=k,P=0|ZI(l^J,k^P,63),J=0|o(),C[(r=Q+1024+(N+32<<3)|0)>>2]=P,C[r+4>>2]=J,a=0|C[(r=Q+1024+(N+33<<3)|0)>>2],r=0|C[r+4>>2],h=0|uI(0|C[Q+1024+((1|N)<<3)>>2],0|C[Q+1024+((1|N)<<3)+4>>2],a,r),t=0|o(),H=0|ZI(C[(H=Q+1024+(N+97<<3)|0)>>2]^h,C[H+4>>2]^t,32),d=0|o(),v=0|uI(U=0|uI(0|C[(U=Q+1024+(N+65<<3)|0)>>2],0|C[U+4>>2],H,d),v=0|o(),d=0|ZI((t=0|uI(h,t,r=0|ZI(U^a,v^r,24),a=0|o()))^H,(h=0|o())^d,16),H=0|o()),U=0|o(),C[(_=Q+1024+(N+65<<3)|0)>>2]=v,C[_+4>>2]=U,a=0|ZI(v^r,U^a,63),r=0|o(),_=Q+1024+(N+16<<3)|0,D=0|C[(p=Q+1024+(N+48<<3)|0)>>2],p=0|C[p+4>>2],_=0|uI(0|C[_>>2],0|C[_+4>>2],D,p),u=0|o(),S=0|ZI(C[(S=Q+1024+(N+112<<3)|0)>>2]^_,C[S+4>>2]^u,32),R=0|o(),D=0|ZI((e=0|uI(i=0|uI(0|C[(i=Q+1024+(N+80<<3)|0)>>2],0|C[i+4>>2],S,R),e=0|o(),R=0|ZI((u=0|uI(_,u,p=0|ZI(i^D,e^p,24),D=0|o()))^S,(_=0|o())^R,16),S=0|o()))^p,(i=0|o())^D,63),p=0|o(),b=Q+1024+(N+17<<3)|0,G=0|C[(Y=Q+1024+(N+49<<3)|0)>>2],Y=0|C[Y+4>>2],b=0|uI(0|C[b>>2],0|C[b+4>>2],G,Y),M=0|o(),E=0|ZI(C[(E=Q+1024+(N+113<<3)|0)>>2]^b,C[E+4>>2]^M,32),n=0|o(),G=0|ZI((s=0|uI(w=0|uI(0|C[(w=Q+1024+(N+81<<3)|0)>>2],0|C[w+4>>2],E,n),s=0|o(),n=0|ZI((M=0|uI(b,M,Y=0|ZI(w^G,s^Y,24),G=0|o()))^E,(b=0|o())^n,16),E=0|o()))^Y,(w=0|o())^G,63),Y=0|o(),I=0|uI(c=0|uI(I,c,a,r),I=0|o(),r=0|ZI((i=0|uI(e,i,E=0|ZI(c^n,I^E,32),n=0|o()))^a,(e=0|o())^r,24),a=0|o()),c=0|o(),C[Q+1024+(N<<3)>>2]=I,C[Q+1024+(N<<3)+4>>2]=c,n=0|ZI(I^E,c^n,16),c=0|o(),C[(E=Q+1024+(N+113<<3)|0)>>2]=n,C[E+4>>2]=c,c=0|uI(i,e,n,c),n=0|o(),C[(e=Q+1024+(N+80<<3)|0)>>2]=c,C[e+4>>2]=n,a=0|ZI(c^r,n^a,63),n=0|o(),C[(r=Q+1024+(N+33<<3)|0)>>2]=a,C[r+4>>2]=n,t=0|uI(h=0|uI(t,h,D,p),t=0|o(),p=0|ZI((w=0|uI(s,w,f=0|ZI(h^F,t^f,32),F=0|o()))^D,(s=0|o())^p,24),D=0|o()),h=0|o(),C[Q+1024+((1|N)<<3)>>2]=t,C[Q+1024+((1|N)<<3)+4>>2]=h,F=0|ZI(t^f,h^F,16),h=0|o(),C[(f=Q+1024+(N+96<<3)|0)>>2]=F,C[f+4>>2]=h,h=0|uI(w,s,F,h),F=0|o(),C[(s=Q+1024+(N+81<<3)|0)>>2]=h,C[s+4>>2]=F,D=0|ZI(h^p,F^D,63),F=0|o(),C[(p=Q+1024+(N+48<<3)|0)>>2]=D,C[p+4>>2]=F,u=0|uI(_=0|uI(u,_,G,Y),u=0|o(),Y=0|ZI((k=0|uI(l,k,H=0|ZI(_^d,u^H,32),d=0|o()))^G,(l=0|o())^Y,24),G=0|o()),_=0|o(),C[(p=Q+1024+(N+16<<3)|0)>>2]=u,C[p+4>>2]=_,d=0|ZI(u^H,_^d,16),_=0|o(),C[(H=Q+1024+(N+97<<3)|0)>>2]=d,C[H+4>>2]=_,_=0|uI(k,l,d,_),d=0|o(),C[(l=Q+1024+(N+64<<3)|0)>>2]=_,C[l+4>>2]=d,G=0|ZI(_^Y,d^G,63),d=0|o(),C[(Y=Q+1024+(N+49<<3)|0)>>2]=G,C[Y+4>>2]=d,M=0|uI(b=0|uI(M,b,P,J),M=0|o(),J=0|ZI((U=0|uI(v,U,S=0|ZI(b^R,M^S,32),R=0|o()))^P,(v=0|o())^J,24),P=0|o()),b=0|o(),C[(Y=Q+1024+(N+17<<3)|0)>>2]=M,C[Y+4>>2]=b,R=0|ZI(M^S,b^R,16),b=0|o(),C[(S=Q+1024+(N+112<<3)|0)>>2]=R,C[S+4>>2]=b,b=0|uI(U,v,R,b),R=0|o(),C[(v=Q+1024+(N+65<<3)|0)>>2]=b,C[v+4>>2]=R,P=0|ZI(b^J,R^P,63),R=0|o(),C[(N=Q+1024+(N+32<<3)|0)>>2]=P,C[N+4>>2]=R,A=A+1|0}while(8!=(0|A));fB(g,Q),SI(g,Q+1024|0),y=B}function l(A,I){A|=0;var g,B,Q,E,i,e,c,a,n,r,t,f,w,y,s,h,D,F,p,u,H,k,l,_,G,d,Y,M,S,U,v,b,J,P,R,N,m,L,x,K,X,j,T,q,V,z,W,O,Z,$,AA,IA,gA=0,BA=0,CA=0,QA=0,EA=0,iA=0,eA=0,oA=0,cA=0,aA=0,nA=0,rA=0,tA=0,fA=0,wA=0,yA=0,sA=0,hA=0,DA=0,FA=0,pA=0,uA=0,HA=0,kA=0,lA=0,_A=0,GA=0,dA=0,YA=0,MA=0,SA=0,UA=0,vA=0,bA=0,JA=0,PA=0,RA=0,NA=0,mA=0,LA=0,xA=0,KA=0,XA=0,jA=0,TA=0,qA=0,VA=0,zA=0,WA=0,OA=0,ZA=0,$A=0,AI=0,II=0,gI=0,BI=0,CI=0;oA=0|C[(I|=0)>>2],wA=0|C[I+4>>2],rA=0|C[I+8>>2],FA=0|C[I+12>>2],BA=0|C[I+16>>2],pA=0|C[I+20>>2],yA=0|C[I+24>>2],iA=0|C[I+28>>2],EA=0|C[I+32>>2],I=0|C[I+36>>2],$=0|Qg(0|oA,((0|oA)<0)<<31>>31|0,0|oA,((0|oA)<0)<<31>>31|0),CI=0|o(),q=0|Qg(oA<<1|0,0|(cA=((oA<<1|0)<0)<<31>>31),0|wA,((0|wA)<0)<<31>>31|0),AI=0|o(),X=0|Qg(0|rA,((0|rA)<0)<<31>>31|0,oA<<1|0,0|cA),K=0|o(),R=0|Qg(0|FA,((0|FA)<0)<<31>>31|0,oA<<1|0,0|cA),P=0|o(),Y=0|Qg(0|BA,((0|BA)<0)<<31>>31|0,oA<<1|0,0|cA),KA=0|o(),k=0|Qg(0|pA,((0|pA)<0)<<31>>31|0,oA<<1|0,0|cA),RA=0|o(),h=0|Qg(0|yA,((0|yA)<0)<<31>>31|0,oA<<1|0,0|cA),vA=0|o(),t=0|Qg(0|iA,((0|iA)<0)<<31>>31|0,oA<<1|0,0|cA),dA=0|o(),i=0|Qg(0|EA,((0|EA)<0)<<31>>31|0,oA<<1|0,0|cA),kA=0|o(),cA=0|Qg(0|I,((0|I)<0)<<31>>31|0,oA<<1|0,0|cA),oA=0|o(),x=0|Qg(wA<<1|0,0|(gA=((wA<<1|0)<0)<<31>>31),0|wA,((0|wA)<0)<<31>>31|0),OA=0|o(),J=0|Qg(wA<<1|0,0|gA,0|rA,((0|rA)<0)<<31>>31|0),qA=0|o(),U=0|Qg(FA<<1|0,0|(CA=((FA<<1|0)<0)<<31>>31),wA<<1|0,0|gA),S=0|o(),G=0|Qg(0|BA,((0|BA)<0)<<31>>31|0,wA<<1|0,0|gA),_=0|o(),D=0|Qg(pA<<1|0,((pA<<1|0)<0)<<31>>31|0,wA<<1|0,0|gA),bA=0|o(),f=0|Qg(0|yA,((0|yA)<0)<<31>>31|0,wA<<1|0,0|gA),YA=0|o(),e=0|Qg(iA<<1|0,((iA<<1|0)<0)<<31>>31|0,wA<<1|0,0|gA),lA=0|o(),aA=0|Qg(0|EA,((0|EA)<0)<<31>>31|0,wA<<1|0,0|gA),nA=0|o(),gA=0|Qg(38*I|0,0|(fA=((38*I|0)<0)<<31>>31),wA<<1|0,0|gA),wA=0|o(),M=0|Qg(0|rA,((0|rA)<0)<<31>>31|0,0|rA,((0|rA)<0)<<31>>31|0),XA=0|o(),l=0|Qg(rA<<1|0,((rA<<1|0)<0)<<31>>31|0,0|FA,((0|FA)<0)<<31>>31|0),NA=0|o(),F=0|Qg(0|BA,((0|BA)<0)<<31>>31|0,rA<<1|0,((rA<<1|0)<0)<<31>>31|0),JA=0|o(),s=0|Qg(0|pA,((0|pA)<0)<<31>>31|0,rA<<1|0,((rA<<1|0)<0)<<31>>31|0),y=0|o(),r=0|Qg(0|yA,((0|yA)<0)<<31>>31|0,rA<<1|0,((rA<<1|0)<0)<<31>>31|0),n=0|o(),g=0|Qg(0|iA,((0|iA)<0)<<31>>31|0,rA<<1|0,((rA<<1|0)<0)<<31>>31|0),uA=0|o(),W=0|Qg(19*EA|0,0|(UA=((19*EA|0)<0)<<31>>31),rA<<1|0,((rA<<1|0)<0)<<31>>31|0),II=0|o(),rA=0|Qg(38*I|0,0|fA,0|rA,((0|rA)<0)<<31>>31|0),sA=0|o(),u=0|Qg(FA<<1|0,0|CA,0|FA,((0|FA)<0)<<31>>31|0),p=0|o(),w=0|Qg(FA<<1|0,0|CA,0|BA,((0|BA)<0)<<31>>31|0),MA=0|o(),c=0|Qg(pA<<1|0,((pA<<1|0)<0)<<31>>31|0,FA<<1|0,0|CA),_A=0|o(),E=0|Qg(0|yA,((0|yA)<0)<<31>>31|0,FA<<1|0,0|CA),Q=0|o(),O=0|Qg(38*iA|0,0|(xA=((38*iA|0)<0)<<31>>31),FA<<1|0,0|CA),gI=0|o(),j=0|Qg(19*EA|0,0|UA,FA<<1|0,0|CA),ZA=0|o(),CA=0|Qg(38*I|0,0|fA,FA<<1|0,0|CA),FA=0|o(),a=0|Qg(0|BA,((0|BA)<0)<<31>>31|0,0|BA,((0|BA)<0)<<31>>31|0),GA=0|o(),B=0|Qg(BA<<1|0,((BA<<1|0)<0)<<31>>31|0,0|pA,((0|pA)<0)<<31>>31|0),HA=0|o(),Z=0|Qg(19*yA|0,((19*yA|0)<0)<<31>>31|0,BA<<1|0,((BA<<1|0)<0)<<31>>31|0),BI=0|o(),T=0|Qg(38*iA|0,0|xA,0|BA,((0|BA)<0)<<31>>31|0),$A=0|o(),N=0|Qg(19*EA|0,0|UA,BA<<1|0,((BA<<1|0)<0)<<31>>31|0),VA=0|o(),BA=0|Qg(38*I|0,0|fA,0|BA,((0|BA)<0)<<31>>31|0),hA=0|o(),IA=0|Qg(38*pA|0,((38*pA|0)<0)<<31>>31|0,0|pA,((0|pA)<0)<<31>>31|0),AA=0|o(),z=0|Qg(19*yA|0,((19*yA|0)<0)<<31>>31|0,pA<<1|0,((pA<<1|0)<0)<<31>>31|0),V=0|o(),m=0|Qg(38*iA|0,0|xA,pA<<1|0,((pA<<1|0)<0)<<31>>31|0),zA=0|o(),v=0|Qg(19*EA|0,0|UA,pA<<1|0,((pA<<1|0)<0)<<31>>31|0),jA=0|o(),pA=0|Qg(38*I|0,0|fA,pA<<1|0,((pA<<1|0)<0)<<31>>31|0),tA=0|o(),L=0|Qg(19*yA|0,((19*yA|0)<0)<<31>>31|0,0|yA,((0|yA)<0)<<31>>31|0),WA=0|o(),b=0|Qg(38*iA|0,0|xA,0|yA,((0|yA)<0)<<31>>31|0),TA=0|o(),d=0|Qg(19*EA|0,0|UA,yA<<1|0,((yA<<1|0)<0)<<31>>31|0),mA=0|o(),yA=0|Qg(38*I|0,0|fA,0|yA,((0|yA)<0)<<31>>31|0),eA=0|o(),xA=0|Qg(38*iA|0,0|xA,0|iA,((0|iA)<0)<<31>>31|0),LA=0|o(),H=0|Qg(19*EA|0,0|UA,iA<<1|0,((iA<<1|0)<0)<<31>>31|0),PA=0|o(),iA=0|Qg(38*I|0,0|fA,iA<<1|0,((iA<<1|0)<0)<<31>>31|0),DA=0|o(),UA=0|Qg(19*EA|0,0|UA,0|EA,((0|EA)<0)<<31>>31|0),SA=0|o(),EA=0|Qg(38*I|0,0|fA,0|EA,((0|EA)<0)<<31>>31|0),QA=0|o(),I=0|Qg(38*I|0,0|fA,0|I,((0|I)<0)<<31>>31|0),fA=0|o(),wA=0|vg(0|(II=0|vg(0|(gI=0|vg(0|(BI=0|vg(0|(CI=0|vg(0|IA,0|AA,0|$,0|CI)),0|o(),0|Z,0|BI)),0|o(),0|O,0|gI)),0|o(),0|W,0|II)),0|o(),0|gA,0|wA),gA=0|o(),sA=0|vg(0|(ZA=0|vg(0|($A=0|vg(0|(AI=0|vg(0|z,0|V,0|q,0|AI)),0|o(),0|T,0|$A)),0|o(),0|j,0|ZA)),0|o(),0|rA,0|sA),rA=0|o(),FA=0|vg(0|(VA=0|vg(0|(zA=0|vg(0|(WA=0|vg(0|(OA=0|vg(0|X,0|K,0|x,0|OA)),0|o(),0|L,0|WA)),0|o(),0|m,0|zA)),0|o(),0|N,0|VA)),0|o(),0|CA,0|FA),CA=0|o(),hA=0|vg(0|(jA=0|vg(0|(TA=0|vg(0|(qA=0|vg(0|R,0|P,0|J,0|qA)),0|o(),0|b,0|TA)),0|o(),0|v,0|jA)),0|o(),0|BA,0|hA),BA=0|o(),tA=0|vg(0|(mA=0|vg(0|(LA=0|vg(0|(KA=0|vg(0|(XA=0|vg(0|U,0|S,0|M,0|XA)),0|o(),0|Y,0|KA)),0|o(),0|xA,0|LA)),0|o(),0|d,0|mA)),0|o(),0|pA,0|tA),pA=0|o(),eA=0|vg(0|(PA=0|vg(0|(RA=0|vg(0|(NA=0|vg(0|G,0|_,0|l,0|NA)),0|o(),0|k,0|RA)),0|o(),0|H,0|PA)),0|o(),0|yA,0|eA),yA=0|o(),DA=0|vg(0|(SA=0|vg(0|(vA=0|vg(0|(bA=0|vg(0|(JA=0|vg(0|u,0|p,0|F,0|JA)),0|o(),0|D,0|bA)),0|o(),0|h,0|vA)),0|o(),0|UA,0|SA)),0|o(),0|iA,0|DA),iA=0|o(),QA=0|vg(0|(dA=0|vg(0|(YA=0|vg(0|(MA=0|vg(0|s,0|y,0|w,0|MA)),0|o(),0|f,0|YA)),0|o(),0|t,0|dA)),0|o(),0|EA,0|QA),EA=0|o(),fA=0|vg(0|(kA=0|vg(0|(lA=0|vg(0|(_A=0|vg(0|(GA=0|vg(0|r,0|n,0|a,0|GA)),0|o(),0|c,0|_A)),0|o(),0|e,0|lA)),0|o(),0|i,0|kA)),0|o(),0|I,0|fA),I=0|o(),oA=0|vg(0|(nA=0|vg(0|(uA=0|vg(0|(HA=0|vg(0|E,0|Q,0|B,0|HA)),0|o(),0|g,0|uA)),0|o(),0|aA,0|nA)),0|o(),0|cA,0|oA),cA=0|o(),gA=0|rg(0|wA,0|gA,1),wA=0|o(),rA=0|rg(0|sA,0|rA,1),sA=0|o(),CA=0|rg(0|FA,0|CA,1),FA=0|o(),BA=0|rg(0|hA,0|BA,1),hA=0|o(),pA=0|rg(0|tA,0|pA,1),tA=0|o(),yA=0|rg(0|eA,0|yA,1),eA=0|o(),iA=0|rg(0|DA,0|iA,1),DA=0|o(),EA=0|rg(0|QA,0|EA,1),QA=0|o(),I=0|rg(0|fA,0|I,1),fA=0|o(),cA=0|rg(0|oA,0|cA,1),oA=0|o(),sA=0|vg(0|(uA=0|ig(0|(nA=0|vg(0|gA,0|wA,33554432,0)),0|(aA=0|o()),26)),0|o(),0|rA,0|sA),rA=0|o(),aA=0|Ug(0|gA,0|wA,-67108864&nA|0,0|aA),nA=0|o(),eA=0|vg(0|(uA=0|ig(0|(wA=0|vg(0|pA,0|tA,33554432,0)),0|(gA=0|o()),26)),0|o(),0|yA,0|eA),yA=0|o(),gA=0|Ug(0|pA,0|tA,-67108864&wA|0,0|gA),wA=0|o(),FA=0|vg(0|(pA=0|ig(0|(tA=0|vg(0|sA,0|rA,16777216,0)),0|o(),25)),0|o(),0|CA,0|FA),CA=0|o(),tA=0|Ug(0|sA,0|rA,-33554432&tA|0,0),rA=0|o(),DA=0|vg(0|(pA=0|ig(0|(sA=0|vg(0|eA,0|yA,16777216,0)),0|o(),25)),0|o(),0|iA,0|DA),iA=0|o(),sA=0|Ug(0|eA,0|yA,-33554432&sA|0,0),yA=0|o(),hA=0|vg(0|(pA=0|ig(0|(eA=0|vg(0|FA,0|CA,33554432,0)),0|o(),26)),0|o(),0|BA,0|hA),BA=0|o(),eA=0|Ug(0|FA,0|CA,-67108864&eA|0,0),o(),QA=0|vg(0|(FA=0|ig(0|(CA=0|vg(0|DA,0|iA,33554432,0)),0|o(),26)),0|o(),0|EA,0|QA),EA=0|o(),CA=0|Ug(0|DA,0|iA,-67108864&CA|0,0),o(),wA=0|vg(0|(DA=0|ig(0|(iA=0|vg(0|hA,0|BA,16777216,0)),0|o(),25)),0|o(),0|gA,0|wA),gA=0|o(),iA=0|Ug(0|hA,0|BA,-33554432&iA|0,0),o(),fA=0|vg(0|(hA=0|ig(0|(BA=0|vg(0|QA,0|EA,16777216,0)),0|o(),25)),0|o(),0|I,0|fA),I=0|o(),BA=0|Ug(0|QA,0|EA,-33554432&BA|0,0),o(),QA=0|vg(0|sA,0|yA,0|(QA=0|yg(0|(EA=0|vg(0|wA,0|gA,33554432,0)),0|o(),26)),0|o()),o(),EA=0|Ug(0|wA,0|gA,-67108864&EA|0,0),o(),oA=0|vg(0|(wA=0|ig(0|(gA=0|vg(0|fA,0|I,33554432,0)),0|o(),26)),0|o(),0|cA,0|oA),cA=0|o(),gA=0|Ug(0|fA,0|I,-67108864&gA|0,0),o(),nA=0|vg(0|(fA=0|Qg(0|(fA=0|ig(0|(I=0|vg(0|oA,0|cA,16777216,0)),0|o(),25)),0|o(),19,0)),0|o(),0|aA,0|nA),aA=0|o(),I=0|Ug(0|oA,0|cA,-33554432&I|0,0),o(),oA=0|vg(0|tA,0|rA,0|(oA=0|yg(0|(cA=0|vg(0|nA,0|aA,33554432,0)),0|o(),26)),0|o()),o(),cA=0|Ug(0|nA,0|aA,-67108864&cA|0,0),o(),C[A>>2]=cA,C[A+4>>2]=oA,C[A+8>>2]=eA,C[A+12>>2]=iA,C[A+16>>2]=EA,C[A+20>>2]=QA,C[A+24>>2]=CA,C[A+28>>2]=BA,C[A+32>>2]=gA,C[A+36>>2]=I}function _(A,I){A|=0;var g,B,Q,E,i,e,c,a,n,r,t,f,w,y,s,h,D,F,p,u,H,k,l,_,G,d,Y,M,S,U,v,b,J,P,R,N,m,L,x,K,X,j,T,q,V,z,W,O,Z,$,AA=0,IA=0,gA=0,BA=0,CA=0,QA=0,EA=0,iA=0,eA=0,oA=0,cA=0,aA=0,nA=0,rA=0,tA=0,fA=0,wA=0,yA=0,sA=0,hA=0,DA=0,FA=0,pA=0,uA=0,HA=0,kA=0,lA=0,_A=0,GA=0,dA=0,YA=0,MA=0,SA=0,UA=0,vA=0,bA=0,JA=0,PA=0,RA=0,NA=0,mA=0,LA=0,xA=0,KA=0,XA=0,jA=0,TA=0,qA=0,VA=0,zA=0,WA=0,OA=0,ZA=0,$A=0,AI=0,II=0,gI=0,BI=0,CI=0;tA=0|C[(I|=0)>>2],AA=0|C[I+4>>2],EA=0|C[I+8>>2],QA=0|C[I+12>>2],MA=0|C[I+16>>2],nA=0|C[I+20>>2],TA=0|C[I+24>>2],IA=0|C[I+28>>2],_A=0|C[I+32>>2],FA=0|C[I+36>>2],O=0|Qg(0|tA,((0|tA)<0)<<31>>31|0,0|tA,((0|tA)<0)<<31>>31|0),CI=0|o(),P=0|Qg(tA<<1|0,0|(fA=((tA<<1|0)<0)<<31>>31),0|AA,((0|AA)<0)<<31>>31|0),ZA=0|o(),q=0|Qg(0|EA,((0|EA)<0)<<31>>31|0,tA<<1|0,0|fA),T=0|o(),j=0|Qg(0|QA,((0|QA)<0)<<31>>31|0,tA<<1|0,0|fA),X=0|o(),m=0|Qg(0|MA,((0|MA)<0)<<31>>31|0,tA<<1|0,0|fA),$A=0|o(),M=0|Qg(0|nA,((0|nA)<0)<<31>>31|0,tA<<1|0,0|fA),VA=0|o(),p=0|Qg(0|TA,((0|TA)<0)<<31>>31|0,tA<<1|0,0|fA),RA=0|o(),f=0|Qg(0|IA,((0|IA)<0)<<31>>31|0,tA<<1|0,0|fA),GA=0|o(),e=0|Qg(0|_A,((0|_A)<0)<<31>>31|0,tA<<1|0,0|fA),pA=0|o(),fA=0|Qg(0|FA,((0|FA)<0)<<31>>31|0,tA<<1|0,0|fA),tA=0|o(),XA=0|Qg(AA<<1|0,0|(eA=((AA<<1|0)<0)<<31>>31),0|AA,((0|AA)<0)<<31>>31|0),jA=0|o(),vA=0|Qg(AA<<1|0,0|eA,0|EA,((0|EA)<0)<<31>>31|0),bA=0|o(),K=0|Qg(QA<<1|0,0|(rA=((QA<<1|0)<0)<<31>>31),AA<<1|0,0|eA),x=0|o(),v=0|Qg(0|MA,((0|MA)<0)<<31>>31|0,AA<<1|0,0|eA),U=0|o(),u=0|Qg(nA<<1|0,((nA<<1|0)<0)<<31>>31|0,AA<<1|0,0|eA),NA=0|o(),w=0|Qg(0|TA,((0|TA)<0)<<31>>31|0,AA<<1|0,0|eA),dA=0|o(),c=0|Qg(IA<<1|0,((IA<<1|0)<0)<<31>>31|0,AA<<1|0,0|eA),uA=0|o(),g=0|Qg(0|_A,((0|_A)<0)<<31>>31|0,AA<<1|0,0|eA),wA=0|o(),eA=0|Qg(38*FA|0,0|(DA=((38*FA|0)<0)<<31>>31),AA<<1|0,0|eA),AA=0|o(),L=0|Qg(0|EA,((0|EA)<0)<<31>>31|0,0|EA,((0|EA)<0)<<31>>31|0),AI=0|o(),S=0|Qg(EA<<1|0,((EA<<1|0)<0)<<31>>31|0,0|QA,((0|QA)<0)<<31>>31|0),zA=0|o(),H=0|Qg(0|MA,((0|MA)<0)<<31>>31|0,EA<<1|0,((EA<<1|0)<0)<<31>>31|0),mA=0|o(),h=0|Qg(0|nA,((0|nA)<0)<<31>>31|0,EA<<1|0,((EA<<1|0)<0)<<31>>31|0),s=0|o(),t=0|Qg(0|TA,((0|TA)<0)<<31>>31|0,EA<<1|0,((EA<<1|0)<0)<<31>>31|0),r=0|o(),B=0|Qg(0|IA,((0|IA)<0)<<31>>31|0,EA<<1|0,((EA<<1|0)<0)<<31>>31|0),yA=0|o(),V=0|Qg(19*_A|0,0|(PA=((19*_A|0)<0)<<31>>31),EA<<1|0,((EA<<1|0)<0)<<31>>31|0),II=0|o(),EA=0|Qg(38*FA|0,0|DA,0|EA,((0|EA)<0)<<31>>31|0),iA=0|o(),l=0|Qg(QA<<1|0,0|rA,0|QA,((0|QA)<0)<<31>>31|0),k=0|o(),y=0|Qg(QA<<1|0,0|rA,0|MA,((0|MA)<0)<<31>>31|0),YA=0|o(),a=0|Qg(nA<<1|0,((nA<<1|0)<0)<<31>>31|0,QA<<1|0,0|rA),HA=0|o(),i=0|Qg(0|TA,((0|TA)<0)<<31>>31|0,QA<<1|0,0|rA),E=0|o(),z=0|Qg(38*IA|0,0|(hA=((38*IA|0)<0)<<31>>31),QA<<1|0,0|rA),gI=0|o(),b=0|Qg(19*_A|0,0|PA,QA<<1|0,0|rA),WA=0|o(),rA=0|Qg(38*FA|0,0|DA,QA<<1|0,0|rA),QA=0|o(),n=0|Qg(0|MA,((0|MA)<0)<<31>>31|0,0|MA,((0|MA)<0)<<31>>31|0),kA=0|o(),Q=0|Qg(MA<<1|0,((MA<<1|0)<0)<<31>>31|0,0|nA,((0|nA)<0)<<31>>31|0),sA=0|o(),W=0|Qg(19*TA|0,((19*TA|0)<0)<<31>>31|0,MA<<1|0,((MA<<1|0)<0)<<31>>31|0),BI=0|o(),J=0|Qg(38*IA|0,0|hA,0|MA,((0|MA)<0)<<31>>31|0),OA=0|o(),_=0|Qg(19*_A|0,0|PA,MA<<1|0,((MA<<1|0)<0)<<31>>31|0),LA=0|o(),MA=0|Qg(38*FA|0,0|DA,0|MA,((0|MA)<0)<<31>>31|0),BA=0|o(),$=0|Qg(38*nA|0,((38*nA|0)<0)<<31>>31|0,0|nA,((0|nA)<0)<<31>>31|0),Z=0|o(),N=0|Qg(19*TA|0,((19*TA|0)<0)<<31>>31|0,nA<<1|0,((nA<<1|0)<0)<<31>>31|0),R=0|o(),G=0|Qg(38*IA|0,0|hA,nA<<1|0,((nA<<1|0)<0)<<31>>31|0),xA=0|o(),D=0|Qg(19*_A|0,0|PA,nA<<1|0,((nA<<1|0)<0)<<31>>31|0),SA=0|o(),nA=0|Qg(38*FA|0,0|DA,nA<<1|0,((nA<<1|0)<0)<<31>>31|0),gA=0|o(),d=0|Qg(19*TA|0,((19*TA|0)<0)<<31>>31|0,0|TA,((0|TA)<0)<<31>>31|0),KA=0|o(),F=0|Qg(38*IA|0,0|hA,0|TA,((0|TA)<0)<<31>>31|0),UA=0|o(),oA=0|Qg(19*_A|0,0|PA,TA<<1|0,((TA<<1|0)<0)<<31>>31|0),cA=0|o(),TA=0|Qg(38*FA|0,0|DA,0|TA,((0|TA)<0)<<31>>31|0),CA=0|o(),hA=0|Qg(38*IA|0,0|hA,0|IA,((0|IA)<0)<<31>>31|0),aA=0|o(),Y=0|Qg(19*_A|0,0|PA,IA<<1|0,((IA<<1|0)<0)<<31>>31|0),qA=0|o(),I=0|Qg(38*FA|0,0|DA,IA<<1|0,((IA<<1|0)<0)<<31>>31|0),IA=0|o(),PA=0|Qg(19*_A|0,0|PA,0|_A,((0|_A)<0)<<31>>31|0),JA=0|o(),_A=0|Qg(38*FA|0,0|DA,0|_A,((0|_A)<0)<<31>>31|0),lA=0|o(),FA=0|Qg(38*FA|0,0|DA,0|FA,((0|FA)<0)<<31>>31|0),DA=0|o(),AA=0|vg(0|(II=0|vg(0|(gI=0|vg(0|(BI=0|vg(0|(CI=0|vg(0|$,0|Z,0|O,0|CI)),0|o(),0|W,0|BI)),0|o(),0|z,0|gI)),0|o(),0|V,0|II)),0|o(),0|eA,0|AA),eA=0|o(),jA=0|vg(0|q,0|T,0|XA,0|jA),XA=0|o(),bA=0|vg(0|j,0|X,0|vA,0|bA),vA=0|o(),gA=0|vg(0|(cA=0|vg(0|(aA=0|vg(0|($A=0|vg(0|(AI=0|vg(0|K,0|x,0|L,0|AI)),0|o(),0|m,0|$A)),0|o(),0|hA,0|aA)),0|o(),0|oA,0|cA)),0|o(),0|nA,0|gA),nA=0|o(),aA=0|ig(0|(cA=0|vg(0|AA,0|eA,33554432,0)),0|(oA=0|o()),26),hA=0|o(),hA=0|vg(0|(iA=0|vg(0|(WA=0|vg(0|(OA=0|vg(0|(ZA=0|vg(0|N,0|R,0|P,0|ZA)),0|o(),0|J,0|OA)),0|o(),0|b,0|WA)),0|o(),0|EA,0|iA)),0|o(),0|aA,0|hA),aA=0|o(),oA=0|Ug(0|AA,0|eA,-67108864&cA|0,0|oA),cA=0|o(),iA=0|ig(0|(eA=0|vg(0|gA,0|nA,33554432,0)),0|(AA=0|o()),26),EA=0|o(),EA=0|vg(0|(CA=0|vg(0|(qA=0|vg(0|(VA=0|vg(0|(zA=0|vg(0|v,0|U,0|S,0|zA)),0|o(),0|M,0|VA)),0|o(),0|Y,0|qA)),0|o(),0|TA,0|CA)),0|o(),0|iA,0|EA),iA=0|o(),AA=0|Ug(0|gA,0|nA,-67108864&eA|0,0|AA),eA=0|o(),gA=0|ig(0|(nA=0|vg(0|hA,0|aA,16777216,0)),0|o(),25),CA=0|o(),CA=0|vg(0|(QA=0|vg(0|(LA=0|vg(0|(xA=0|vg(0|(KA=0|vg(0|jA,0|XA,0|d,0|KA)),0|o(),0|G,0|xA)),0|o(),0|_,0|LA)),0|o(),0|rA,0|QA)),0|o(),0|gA,0|CA),gA=0|o(),nA=0|Ug(0|hA,0|aA,-33554432&nA|0,0),aA=0|o(),QA=0|ig(0|(hA=0|vg(0|EA,0|iA,16777216,0)),0|o(),25),rA=0|o(),rA=0|vg(0|(IA=0|vg(0|(JA=0|vg(0|(RA=0|vg(0|(NA=0|vg(0|(mA=0|vg(0|l,0|k,0|H,0|mA)),0|o(),0|u,0|NA)),0|o(),0|p,0|RA)),0|o(),0|PA,0|JA)),0|o(),0|I,0|IA)),0|o(),0|QA,0|rA),QA=0|o(),hA=0|Ug(0|EA,0|iA,-33554432&hA|0,0),iA=0|o(),IA=0|ig(0|(EA=0|vg(0|CA,0|gA,33554432,0)),0|o(),26),I=0|o(),I=0|vg(0|(BA=0|vg(0|(SA=0|vg(0|(UA=0|vg(0|bA,0|vA,0|F,0|UA)),0|o(),0|D,0|SA)),0|o(),0|MA,0|BA)),0|o(),0|IA,0|I),IA=0|o(),EA=0|Ug(0|CA,0|gA,-67108864&EA|0,0),o(),CA=0|ig(0|(gA=0|vg(0|rA,0|QA,33554432,0)),0|o(),26),BA=0|o(),BA=0|vg(0|(lA=0|vg(0|(GA=0|vg(0|(dA=0|vg(0|(YA=0|vg(0|h,0|s,0|y,0|YA)),0|o(),0|w,0|dA)),0|o(),0|f,0|GA)),0|o(),0|_A,0|lA)),0|o(),0|CA,0|BA),CA=0|o(),gA=0|Ug(0|rA,0|QA,-67108864&gA|0,0),o(),eA=0|vg(0|(rA=0|ig(0|(QA=0|vg(0|I,0|IA,16777216,0)),0|o(),25)),0|o(),0|AA,0|eA),AA=0|o(),QA=0|Ug(0|I,0|IA,-33554432&QA|0,0),o(),I=0|ig(0|(IA=0|vg(0|BA,0|CA,16777216,0)),0|o(),25),rA=0|o(),rA=0|vg(0|(DA=0|vg(0|(pA=0|vg(0|(uA=0|vg(0|(HA=0|vg(0|(kA=0|vg(0|t,0|r,0|n,0|kA)),0|o(),0|a,0|HA)),0|o(),0|c,0|uA)),0|o(),0|e,0|pA)),0|o(),0|FA,0|DA)),0|o(),0|I,0|rA),I=0|o(),IA=0|Ug(0|BA,0|CA,-33554432&IA|0,0),o(),BA=0|vg(0|hA,0|iA,0|(BA=0|yg(0|(CA=0|vg(0|eA,0|AA,33554432,0)),0|o(),26)),0|o()),o(),CA=0|Ug(0|eA,0|AA,-67108864&CA|0,0),o(),eA=0|ig(0|(AA=0|vg(0|rA,0|I,33554432,0)),0|o(),26),iA=0|o(),iA=0|vg(0|(tA=0|vg(0|(wA=0|vg(0|(yA=0|vg(0|(sA=0|vg(0|i,0|E,0|Q,0|sA)),0|o(),0|B,0|yA)),0|o(),0|g,0|wA)),0|o(),0|fA,0|tA)),0|o(),0|eA,0|iA),eA=0|o(),AA=0|Ug(0|rA,0|I,-67108864&AA|0,0),o(),cA=0|vg(0|(rA=0|Qg(0|(rA=0|ig(0|(I=0|vg(0|iA,0|eA,16777216,0)),0|o(),25)),0|o(),19,0)),0|o(),0|oA,0|cA),oA=0|o(),I=0|Ug(0|iA,0|eA,-33554432&I|0,0),o(),iA=0|vg(0|nA,0|aA,0|(iA=0|yg(0|(eA=0|vg(0|cA,0|oA,33554432,0)),0|o(),26)),0|o()),o(),eA=0|Ug(0|cA,0|oA,-67108864&eA|0,0),o(),C[A>>2]=eA,C[A+4>>2]=iA,C[A+8>>2]=EA,C[A+12>>2]=QA,C[A+16>>2]=CA,C[A+20>>2]=BA,C[A+24>>2]=gA,C[A+28>>2]=IA,C[A+32>>2]=AA,C[A+36>>2]=I}function G(A,I,g,B,C){A|=0,I|=0,g|=0,B|=0;var E=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0;if(n=0|qI(C|=0),t=0|o(),E=0|qI(C+8|0),i=0|o(),B=0|rg(0|g,0|B,56),C=0|o(),(I+g+(0-(7&g))|0)==(0|I))y=2037671283^E,e=1952801890^i,w=1886610805^n,r=1936682341^t,a=1852075885^E,c=1685025377^i,F=1852142177^n,E=1819895653^t,i=I;else for(D=2037671283^E,e=1952801890^i,y=1886610805^n,r=1936682341^t,a=1852075885^E,c=1685025377^i,i=1852142177^n,E=1819895653^t,w=I;;){if(u=(s=0|qI(w))^D,e^=h=0|o(),F=0|vg(0|y,0|r,0|a,0|c),D=0|o(),n=0|$I(a,c,13),a=(0|o())^D,c=0|$I(F,D,32),D=0|o(),t=0|vg(0|u,0|e,0|i,0|E),f=0|o(),D=0|vg((e=0|$I(u,e,16))^t|0,0|(i=(0|o())^f),0|c,0|D),c=0|o(),i=0|$I(e^t,i,21),e=c^(0|o()),f=0|vg(0|t,0|f,n^F|0,0|a),t=0|o(),a=0|$I(n^F,a,17),E=(0|o())^t,t=0|$I(f,t,32),F=0|o(),c=0|vg(a^f|0,0|E,0|D,0|c),n=0|o(),E=0|$I(a^f,E,13),f=(0|o())^n,n=0|$I(c,n,32),a=0|o(),F=0|vg(0|t,0|F,D^i|0,0|e),t=0|o(),a=0|vg((e=0|$I(D^i,e,16))^F|0,0|(i=(0|o())^t),0|n,0|a),n=0|o(),i=0|$I(e^F,i,21),e=n^(0|o()),t=0|vg(E^c|0,0|f,0|F,0|t),F=0|o(),f=0|$I(E^c,f,17),c=(0|o())^F,F=0|$I(t,F,32),E=0|o(),(0|(w=w+8|0))==(I+g+(0-(7&g))|0)){y=a^i,w=a^s,r=n^h,a=f^t,i=I+g+(0-(7&g))|0;break}D=a^i,y=a^s,r=n^h,a=f^t,i=F}switch(7&g){case 7:p=0|rg(0|Q[i+6>>0],0,48),C=0|o()|C,B|=p,p=6;break;case 6:p=6;break;case 5:p=7;break;case 4:p=8;break;case 3:p=9;break;case 2:p=10;break;case 1:p=11}6==(0|p)&&(u=0|rg(0|Q[i+5>>0],0,40),C=0|o()|C,B|=u,p=7),7==(0|p)&&(C=0|Q[i+4>>0]|C,p=8),8==(0|p)&&(B|=u=0|rg(0|Q[i+3>>0],0,24),C=0|o()|C,p=9),9==(0|p)&&(B|=u=0|rg(0|Q[i+2>>0],0,16),C=0|o()|C,p=10),10==(0|p)&&(B|=u=0|rg(0|Q[i+1>>0],0,8),C=0|o()|C,p=11),11==(0|p)&&(B=0|B|Q[i>>0]),g=B^y,h=C^e,w=0|vg(0|w,0|r,0|a,0|c),y=0|o(),s=0|$I(a,c,13),I=(0|o())^y,y=0|$I(w,y,32),p=0|o(),F=0|vg(0|g,0|h,0|F,0|E),u=0|o(),p=0|vg((h=0|$I(g,h,16))^F|0,0|(g=(0|o())^u),0|y,0|p),y=0|o(),g=0|$I(h^F,g,21),h=y^(0|o()),u=0|vg(0|F,0|u,s^w|0,0|I),F=0|o(),I=0|$I(s^w,I,17),w=(0|o())^F,F=0|$I(u,F,32),s=0|o(),y=0|vg(I^u|0,0|w,0|p,0|y),D=0|o(),w=0|$I(I^u,w,13),u=(0|o())^D,D=0|$I(y,D,32),I=0|o(),s=0|vg(0|F,0|s,p^g|0,0|h),F=0|o(),I=0|vg((h=0|$I(p^g,h,16))^s|0,0|(g=(0|o())^F),0|D,0|I),D=0|o(),g=0|$I(h^s,g,21),h=D^(0|o()),F=0|vg(w^y|0,0|u,0|s,0|F),s=0|o(),u=0|$I(w^y,u,17),y=(0|o())^s,s=0|$I(F,s,32),w=0|o(),D=0|vg(I^B|0,D^C|0,u^F|0,0|y),p=0|o(),y=0|$I(u^F,y,13),F=(0|o())^p,p=0|$I(D,p,32),u=0|o(),w=0|vg(255^s|0,0|w,I^g|0,0|h),s=0|o(),u=0|vg((h=0|$I(I^g,h,16))^w|0,0|(g=(0|o())^s),0|p,0|u),p=0|o(),g=0|$I(h^w,g,21),h=p^(0|o()),s=0|vg(0|w,0|s,y^D|0,0|F),w=0|o(),F=0|$I(y^D,F,17),D=(0|o())^w,w=0|$I(s,w,32),y=0|o(),p=0|vg(F^s|0,0|D,0|u,0|p),I=0|o(),D=0|$I(F^s,D,13),s=(0|o())^I,I=0|$I(p,I,32),F=0|o(),y=0|vg(0|w,0|y,u^g|0,0|h),w=0|o(),F=0|vg((h=0|$I(u^g,h,16))^y|0,0|(g=(0|o())^w),0|I,0|F),I=0|o(),g=0|$I(h^y,g,21),h=I^(0|o()),w=0|vg(D^p|0,0|s,0|y,0|w),y=0|o(),s=0|$I(D^p,s,17),p=(0|o())^y,y=0|$I(w,y,32),D=0|o(),I=0|vg(s^w|0,0|p,0|F,0|I),u=0|o(),p=0|$I(s^w,p,13),w=(0|o())^u,u=0|$I(I,u,32),s=0|o(),D=0|vg(0|y,0|D,F^g|0,0|h),y=0|o(),s=0|vg((h=0|$I(F^g,h,16))^D|0,0|(g=(0|o())^y),0|u,0|s),u=0|o(),g=0|$I(h^D,g,21),h=u^(0|o()),y=0|vg(p^I|0,0|w,0|D,0|y),D=0|o(),w=0|$I(p^I,w,17),I=(0|o())^D,D=0|$I(y,D,32),p=0|o(),u=0|vg(w^y|0,0|I,0|s,0|u),F=0|o(),I=0|$I(w^y,I,13),F=(0|o())^F,p=0|vg(0|D,0|p,s^g|0,0|h),D=0|o(),h=0|$I((h=0|$I(s^g,h,16))^p,(0|o())^D,21),g=0|o(),D=0|vg(I^u|0,0|F,0|p,0|D),p=0|o(),F=0|$I(I^u,F,17),u=0|o(),LI(A,h^D^F^(I=0|$I(D,p,32)),g^p^u^(0|o()))}function d(A){var I=0,g=0,B=0,Q=0,E=0,i=0,e=0,o=0,c=0;if(A|=0){I=0|C[8683],c=A+-8+(-8&(g=0|C[A+-4>>2]))|0;do{if(1&g)e=A+-8|0,o=A+-8|0,A=-8&g;else{if(B=0|C[A+-8>>2],!(3&g))return;if(i=B+(-8&g)|0,(E=A+-8+(0-B)|0)>>>0<I>>>0)return;if((0|C[8684])==(0|E)){if(3!=(3&(A=0|C[c+4>>2])|0)){e=E,o=E,A=i;break}return C[8681]=i,C[c+4>>2]=-2&A,C[E+4>>2]=1|i,void(C[E+i>>2]=i)}if(B>>>0<256){if(A=0|C[E+8>>2],(0|(I=0|C[E+12>>2]))==(0|A)){C[8679]=C[8679]&~(1<<(B>>>3)),e=E,o=E,A=i;break}C[A+12>>2]=I,C[I+8>>2]=A,e=E,o=E,A=i;break}Q=0|C[E+24>>2],A=0|C[E+12>>2];do{if((0|A)==(0|E)){if(A=0|C[E+16+4>>2])I=E+16+4|0;else{if(!(A=0|C[E+16>>2])){A=0;break}I=E+16|0}for(;;)if(g=0|C[(B=A+20|0)>>2])A=g,I=B;else{if(!(g=0|C[(B=A+16|0)>>2]))break;A=g,I=B}C[I>>2]=0}else o=0|C[E+8>>2],C[o+12>>2]=A,C[A+8>>2]=o}while(0);if(Q){if(I=0|C[E+28>>2],(0|C[35020+(I<<2)>>2])==(0|E)){if(C[35020+(I<<2)>>2]=A,!A){C[8680]=C[8680]&~(1<<I),e=E,o=E,A=i;break}}else if(C[((0|C[Q+16>>2])==(0|E)?Q+16|0:Q+20|0)>>2]=A,!A){e=E,o=E,A=i;break}C[A+24>>2]=Q,0|(I=0|C[E+16>>2])&&(C[A+16>>2]=I,C[I+24>>2]=A),(I=0|C[E+16+4>>2])?(C[A+20>>2]=I,C[I+24>>2]=A,e=E,o=E,A=i):(e=E,o=E,A=i)}else e=E,o=E,A=i}}while(0);if(!(e>>>0>=c>>>0)&&1&(g=0|C[c+4>>2])){if(2&g)C[c+4>>2]=-2&g,C[o+4>>2]=1|A,C[e+A>>2]=A,Q=A;else{if((0|C[8685])==(0|c)){if(c=(0|C[8682])+A|0,C[8682]=c,C[8685]=o,C[o+4>>2]=1|c,(0|o)!=(0|C[8684]))return;return C[8684]=0,void(C[8681]=0)}if((0|C[8684])==(0|c))return c=(0|C[8681])+A|0,C[8681]=c,C[8684]=e,C[o+4>>2]=1|c,void(C[e+c>>2]=c);Q=(-8&g)+A|0;do{if(g>>>0<256){if(I=0|C[c+8>>2],(0|(A=0|C[c+12>>2]))==(0|I)){C[8679]=C[8679]&~(1<<(g>>>3));break}C[I+12>>2]=A,C[A+8>>2]=I;break}E=0|C[c+24>>2],A=0|C[c+12>>2];do{if((0|A)==(0|c)){if(A=0|C[c+16+4>>2])I=c+16+4|0;else{if(!(A=0|C[c+16>>2])){I=0;break}I=c+16|0}for(;;)if(g=0|C[(B=A+20|0)>>2])A=g,I=B;else{if(!(g=0|C[(B=A+16|0)>>2]))break;A=g,I=B}C[I>>2]=0,I=A}else I=0|C[c+8>>2],C[I+12>>2]=A,C[A+8>>2]=I,I=A}while(0);if(0|E){if(A=0|C[c+28>>2],(0|C[35020+(A<<2)>>2])==(0|c)){if(C[35020+(A<<2)>>2]=I,!I){C[8680]=C[8680]&~(1<<A);break}}else if(C[((0|C[E+16>>2])==(0|c)?E+16|0:E+20|0)>>2]=I,!I)break;C[I+24>>2]=E,0|(A=0|C[c+16>>2])&&(C[I+16>>2]=A,C[A+24>>2]=I),0|(A=0|C[c+16+4>>2])&&(C[I+20>>2]=A,C[A+24>>2]=I)}}while(0);if(C[o+4>>2]=1|Q,C[e+Q>>2]=Q,(0|o)==(0|C[8684]))return void(C[8681]=Q)}if(g=Q>>>3,Q>>>0<256)return(A=0|C[8679])&1<<g?(A=34756+(g<<1<<2)+8|0,I=0|C[34756+(g<<1<<2)+8>>2]):(C[8679]=A|1<<g,A=34756+(g<<1<<2)+8|0,I=34756+(g<<1<<2)|0),C[A>>2]=o,C[I+12>>2]=o,C[o+8>>2]=I,void(C[o+12>>2]=34756+(g<<1<<2));I=35020+((B=(A=Q>>>8)?Q>>>0>16777215?31:Q>>>(7+(B=14-((520192+(A<<((A+1048320|0)>>>16&8))|0)>>>16&4|(A+1048320|0)>>>16&8|(245760+(B=A<<((A+1048320|0)>>>16&8)<<((520192+(A<<((A+1048320|0)>>>16&8))|0)>>>16&4))|0)>>>16&2)+(B<<((B+245760|0)>>>16&2)>>>15)|0)|0)&1|B<<1:0)<<2)|0,C[o+28>>2]=B,C[o+20>>2]=0,C[o+16>>2]=0,A=0|C[8680],g=1<<B;A:do{if(A&g){A=0|C[I>>2];I:do{if((-8&C[A+4>>2]|0)!=(0|Q)){for(B=Q<<(31==(0|B)?0:25-(B>>>1)|0);I=0|C[(g=A+16+(B>>>31<<2)|0)>>2];){if((-8&C[I+4>>2]|0)==(0|Q)){A=I;break I}B<<=1,A=I}C[g>>2]=o,C[o+24>>2]=A,C[o+12>>2]=o,C[o+8>>2]=o;break A}}while(0);c=0|C[(e=A+8|0)>>2],C[c+12>>2]=o,C[e>>2]=o,C[o+8>>2]=c,C[o+12>>2]=A,C[o+24>>2]=0}else C[8680]=A|g,C[I>>2]=o,C[o+24>>2]=I,C[o+12>>2]=o,C[o+8>>2]=o}while(0);if(c=(0|C[8687])-1|0,C[8687]=c,!(0|c)){for(A=35172;A=0|C[A>>2];)A=A+8|0;C[8687]=-1}}}}function Y(A,I){I|=0;var g=0,B=0,Q=0,E=0,i=0,e=0,o=0;g=0|C[4+(A|=0)>>2];do{if(1&g)o=A,g=I;else{if(e=0|C[A>>2],!(3&g))return;if((0|C[8684])==(A+(0-e)|0)){if(3!=(3&(g=0|C[A+I+4>>2])|0)){o=A+(0-e)|0,g=e+I|0;break}return C[8681]=e+I,C[A+I+4>>2]=-2&g,C[A+(0-e)+4>>2]=e+I|1,void(C[A+I>>2]=e+I)}if(e>>>0<256){if(g=0|C[A+(0-e)+8>>2],(0|(B=0|C[A+(0-e)+12>>2]))==(0|g)){C[8679]=C[8679]&~(1<<(e>>>3)),o=A+(0-e)|0,g=e+I|0;break}C[g+12>>2]=B,C[B+8>>2]=g,o=A+(0-e)|0,g=e+I|0;break}i=0|C[A+(0-e)+24>>2],g=0|C[A+(0-e)+12>>2];do{if((0|g)==(A+(0-e)|0)){if(g=0|C[4+(B=A+(0-e)+16|0)>>2])B=B+4|0;else if(!(g=0|C[B>>2])){B=0;break}for(;;)if(Q=0|C[(E=g+20|0)>>2])g=Q,B=E;else{if(!(Q=0|C[(E=g+16|0)>>2]))break;g=Q,B=E}C[B>>2]=0,B=g}else B=0|C[A+(0-e)+8>>2],C[B+12>>2]=g,C[g+8>>2]=B,B=g}while(0);if(i){if(g=0|C[A+(0-e)+28>>2],(0|C[35020+(g<<2)>>2])==(A+(0-e)|0)){if(C[35020+(g<<2)>>2]=B,!B){C[8680]=C[8680]&~(1<<g),o=A+(0-e)|0,g=e+I|0;break}}else if(C[((0|C[i+16>>2])==(A+(0-e)|0)?i+16|0:i+20|0)>>2]=B,!B){o=A+(0-e)|0,g=e+I|0;break}C[B+24>>2]=i,0|(g=0|C[A+(0-e)+16>>2])&&(C[B+16>>2]=g,C[g+24>>2]=B),(g=0|C[A+(0-e)+16+4>>2])?(C[B+20>>2]=g,C[g+24>>2]=B,o=A+(0-e)|0,g=e+I|0):(o=A+(0-e)|0,g=e+I|0)}else o=A+(0-e)|0,g=e+I|0}}while(0);if(2&(Q=0|C[A+I+4>>2]))C[A+I+4>>2]=-2&Q,C[o+4>>2]=1|g,C[o+g>>2]=g,i=g;else{if((0|C[8685])==(A+I|0)){if(I=(0|C[8682])+g|0,C[8682]=I,C[8685]=o,C[o+4>>2]=1|I,(0|o)!=(0|C[8684]))return;return C[8684]=0,void(C[8681]=0)}if((0|C[8684])==(A+I|0))return I=(0|C[8681])+g|0,C[8681]=I,C[8684]=o,C[o+4>>2]=1|I,void(C[o+I>>2]=I);i=(-8&Q)+g|0;do{if(Q>>>0<256){if(B=0|C[A+I+8>>2],(0|(g=0|C[A+I+12>>2]))==(0|B)){C[8679]=C[8679]&~(1<<(Q>>>3));break}C[B+12>>2]=g,C[g+8>>2]=B;break}e=0|C[A+I+24>>2],g=0|C[A+I+12>>2];do{if((0|g)==(A+I|0)){if(g=0|C[A+I+16+4>>2])B=A+I+16+4|0;else{if(!(g=0|C[A+I+16>>2])){B=0;break}B=A+I+16|0}for(;;)if(Q=0|C[(E=g+20|0)>>2])g=Q,B=E;else{if(!(Q=0|C[(E=g+16|0)>>2]))break;g=Q,B=E}C[B>>2]=0,B=g}else B=0|C[A+I+8>>2],C[B+12>>2]=g,C[g+8>>2]=B,B=g}while(0);if(0|e){if(g=0|C[A+I+28>>2],(0|C[35020+(g<<2)>>2])==(A+I|0)){if(C[35020+(g<<2)>>2]=B,!B){C[8680]=C[8680]&~(1<<g);break}}else if(C[((0|C[e+16>>2])==(A+I|0)?e+16|0:e+20|0)>>2]=B,!B)break;C[B+24>>2]=e,0|(g=0|C[A+I+16>>2])&&(C[B+16>>2]=g,C[g+24>>2]=B),0|(g=0|C[A+I+16+4>>2])&&(C[B+20>>2]=g,C[g+24>>2]=B)}}while(0);if(C[o+4>>2]=1|i,C[o+i>>2]=i,(0|o)==(0|C[8684]))return void(C[8681]=i)}if(Q=i>>>3,i>>>0<256)return(g=0|C[8679])&1<<Q?(g=34756+(Q<<1<<2)+8|0,B=0|C[34756+(Q<<1<<2)+8>>2]):(C[8679]=g|1<<Q,g=34756+(Q<<1<<2)+8|0,B=34756+(Q<<1<<2)|0),C[g>>2]=o,C[B+12>>2]=o,C[o+8>>2]=B,void(C[o+12>>2]=34756+(Q<<1<<2));if(B=35020+((E=(g=i>>>8)?i>>>0>16777215?31:i>>>(7+(E=14-((520192+(g<<((g+1048320|0)>>>16&8))|0)>>>16&4|(g+1048320|0)>>>16&8|(245760+(E=g<<((g+1048320|0)>>>16&8)<<((520192+(g<<((g+1048320|0)>>>16&8))|0)>>>16&4))|0)>>>16&2)+(E<<((E+245760|0)>>>16&2)>>>15)|0)|0)&1|E<<1:0)<<2)|0,C[o+28>>2]=E,C[o+20>>2]=0,C[o+16>>2]=0,!((g=0|C[8680])&(Q=1<<E)))return C[8680]=g|Q,C[B>>2]=o,C[o+24>>2]=B,C[o+12>>2]=o,void(C[o+8>>2]=o);g=0|C[B>>2];A:do{if((-8&C[g+4>>2]|0)!=(0|i)){for(E=i<<(31==(0|E)?0:25-(E>>>1)|0);B=0|C[(Q=g+16+(E>>>31<<2)|0)>>2];){if((-8&C[B+4>>2]|0)==(0|i)){g=B;break A}E<<=1,g=B}return C[Q>>2]=o,C[o+24>>2]=g,C[o+12>>2]=o,void(C[o+8>>2]=o)}}while(0);I=0|C[(A=g+8|0)>>2],C[I+12>>2]=o,C[A>>2]=o,C[o+8>>2]=I,C[o+12>>2]=g,C[o+24>>2]=0}function M(A,I,g,Q,E){A|=0,I|=0,g|=0;var i,e,c=0,a=0,n=0,r=0,t=0,f=0,w=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0,m=0,L=0,x=0,K=0,X=0,j=0,T=0,q=0,V=0,z=0,W=0,O=0,Z=0,$=0,AA=0,IA=0,gA=0,BA=0,CA=0,QA=0,EA=0,iA=0,eA=0,oA=0,cA=0,aA=0,nA=0,rA=0;if(e=y,i=y=y+63&-64,y=y+64|0,!(0==(0|(Q|=0))&0==(0|(E|=0)))){for(L=0|C[A>>2],x=0|C[A+4>>2],K=0|C[A+8>>2],X=0|C[A+12>>2],j=0|C[A+16>>2],S=0|C[A+20>>2],U=0|C[A+24>>2],v=0|C[A+28>>2],b=0|C[A+32>>2],J=0|C[A+36>>2],P=0|C[A+40>>2],R=0|C[A+44>>2],N=0|C[A+56>>2],m=0|C[A+60>>2],a=0,Y=0|C[A+48>>2],M=0|C[A+52>>2],n=I;;){if(d=E>>>0<0|0==(0|E)&Q>>>0<64){c=(I=i)+64|0;do{C[I>>2]=0,I=I+4|0}while((0|I)<(0|c));I=0;do{B[i+I>>0]=0|B[n+I>>0],I=I+1|0}while(E>>>0>0|0==(0|E)&Q>>>0>I>>>0);G=i,a=g,n=i}else G=g;g=20,I=L,c=x,r=P,t=R,f=Y,w=M,s=N,h=m,D=K,F=X,p=j,u=S,H=U,k=v,l=b,_=J;do{W=0|wB((AA=0|wB((nA=0|wB(($=(AA=0|wB((aA=I+p|0)^f,16))+l|0)^p,12))+aA^AA,8))+$^nA,7),rA=0|wB((V=0|wB((eA=0|wB((q=(V=0|wB((iA=c+u|0)^w,16))+_|0)^u,12))+iA^V,8))+q^eA,7),oA=0|wB((z=0|wB((BA=0|wB((IA=(z=0|wB((gA=D+H|0)^s,16))+r|0)^H,12))+gA^z,8))+IA^BA,7),CA=0|wB((QA=0|wB((Z=0|wB((T=(QA=0|wB((O=F+k|0)^h,16))+t|0)^k,12))+O^QA,8))+T^Z,7),u=0|wB((r=(h=0|wB((I=(EA=0|wB((cA=0|wB(QA^rA+(nA+aA),16))+(z+IA)^rA,12))+(rA+(nA+aA))|0)^cA,8))+(cA+(z+IA))|0)^EA,7),H=0|wB((t=(f=0|wB((c=(IA=0|wB((EA=0|wB(oA+(eA+iA)^AA,16))+(QA+T)^oA,12))+(oA+(eA+iA))|0)^EA,8))+(EA+(QA+T))|0)^IA,7),k=0|wB((l=(w=0|wB((D=(T=0|wB((IA=0|wB(CA+(BA+gA)^V,16))+(AA+$)^CA,12))+(CA+(BA+gA))|0)^IA,8))+(IA+(AA+$))|0)^T,7),p=0|wB((_=(s=0|wB((F=(T=0|wB((z=0|wB(Z+O+W^z,16))+(V+q)^W,12))+(Z+O+W)|0)^z,8))+(z+(V+q))|0)^T,7),g=g+-2|0}while(0!=(0|g));if(Z=(0|Vg(n))^I+L,$=(0|Vg(n+4|0))^c+x,AA=(0|Vg(n+8|0))^D+K,IA=(0|Vg(n+12|0))^F+X,gA=(0|Vg(n+16|0))^p+j,BA=(0|Vg(n+20|0))^u+S,CA=(0|Vg(n+24|0))^H+U,QA=(0|Vg(n+28|0))^k+v,EA=(0|Vg(n+32|0))^l+b,iA=(0|Vg(n+36|0))^_+J,eA=(0|Vg(n+40|0))^r+P,oA=(0|Vg(n+44|0))^t+R,cA=(0|Vg(n+48|0))^f+Y,aA=(0|Vg(n+52|0))^w+M,nA=(0|Vg(n+56|0))^s+N,rA=(0|Vg(n+60|0))^h+m,c=M+(0==(0|(I=Y+1|0))&1)|0,Pg(G,Z),Pg(G+4|0,$),Pg(G+8|0,AA),Pg(G+12|0,IA),Pg(G+16|0,gA),Pg(G+20|0,BA),Pg(G+24|0,CA),Pg(G+28|0,QA),Pg(G+32|0,EA),Pg(G+36|0,iA),Pg(G+40|0,eA),Pg(G+44|0,oA),Pg(G+48|0,cA),Pg(G+52|0,aA),Pg(G+56|0,nA),Pg(G+60|0,rA),E>>>0<0|0==(0|E)&Q>>>0<65)break;g=0|vg(0|Q,0|E,-64,-1),E=0|o(),Q=g,g=G+64|0,Y=I,M=c,n=n+64|0}if(d&&0|Q){E=0;do{B[a+E>>0]=0|B[G+E>>0],E=E+1|0}while((0|E)!=(0|Q))}C[A+48>>2]=I,C[A+52>>2]=c}y=e}function S(A,I,g,Q){I|=0,g|=0,Q|=0;var E,i,e,c,a,n=0,r=0,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0;if(a=0==(0|B[80+(A|=0)>>0])?16777216:0,E=0|C[A+4>>2],i=0|C[A+8>>2],e=0|C[A+12>>2],c=0|C[A+16>>2],w=0|C[A+20>>2],f=0|C[A+24>>2],t=0|C[A+28>>2],r=0|C[A+32>>2],n=0|C[A+36>>2],Q>>>0>0|0==(0|Q)&g>>>0>15)for(D=0|C[A>>2];;){if(k=(67108863&(0|Vg(I)))+w|0,l=((0|Vg(I+3|0))>>>2&67108863)+f|0,H=((0|Vg(I+6|0))>>>4&67108863)+t|0,u=((0|Vg(I+9|0))>>>6)+r|0,w=((0|Vg(I+12|0))>>>8|a)+n|0,n=0|Qg(0|k,0,0|D,0),y=0|o(),t=0|vg(0|(y=0|vg(0|(t=0|vg(0|(y=0|vg(0|(t=0|Qg(0|l,0,5*c|0,0)),0|o(),0|n,0|y)),0|(n=0|o()),0|(t=0|Qg(0|H,0,5*e|0,0)),0|o())),0|(n=0|o()),0|(y=0|Qg(0|u,0,5*i|0,0)),0|o())),0|(n=0|o()),0|(t=0|Qg(0|w,0,5*E|0,0)),0|o()),n=0|o(),y=0|Qg(0|k,0,0|E,0),s=0|o(),p=0|vg(0|(s=0|vg(0|(p=0|vg(0|(s=0|vg(0|(p=0|Qg(0|l,0,0|D,0)),0|o(),0|y,0|s)),0|(y=0|o()),0|(p=0|Qg(0|H,0,5*c|0,0)),0|o())),0|(y=0|o()),0|(s=0|Qg(0|u,0,5*e|0,0)),0|o())),0|(y=0|o()),0|(p=0|Qg(0|w,0,5*i|0,0)),0|o()),y=0|o(),s=0|Qg(0|k,0,0|i,0),h=0|o(),F=0|vg(0|(h=0|vg(0|(F=0|vg(0|(h=0|vg(0|(F=0|Qg(0|l,0,0|E,0)),0|o(),0|s,0|h)),0|(s=0|o()),0|(F=0|Qg(0|H,0,0|D,0)),0|o())),0|(s=0|o()),0|(h=0|Qg(0|u,0,5*c|0,0)),0|o())),0|(s=0|o()),0|(F=0|Qg(0|w,0,5*e|0,0)),0|o()),s=0|o(),h=0|Qg(0|k,0,0|e,0),r=0|o(),f=0|vg(0|(r=0|vg(0|(f=0|vg(0|(r=0|vg(0|(f=0|Qg(0|l,0,0|i,0)),0|o(),0|h,0|r)),0|(h=0|o()),0|(f=0|Qg(0|H,0,0|E,0)),0|o())),0|(h=0|o()),0|(r=0|Qg(0|u,0,0|D,0)),0|o())),0|(h=0|o()),0|(f=0|Qg(0|w,0,5*c|0,0)),0|o()),h=0|o(),r=0|Qg(0|k,0,0|c,0),k=0|o(),w=0|vg(0|(u=0|vg(0|(H=0|vg(0|(k=0|vg(0|(l=0|Qg(0|l,0,0|e,0)),0|o(),0|r,0|k)),0|(r=0|o()),0|(H=0|Qg(0|H,0,0|i,0)),0|o())),0|(r=0|o()),0|(u=0|Qg(0|u,0,0|E,0)),0|o())),0|(r=0|o()),0|(w=0|Qg(0|w,0,0|D,0)),0|o()),r=0|o(),n=0|yg(0|t,0|n,26),o(),y=0|yg(0|(n=0|vg(0|p,0|y,0|n,0)),0|o(),26),o(),s=0|yg(0|(y=0|vg(0|F,0|s,0|y,0)),0|o(),26),o(),h=0|yg(0|(s=0|vg(0|f,0|h,0|s,0)),0|o(),26),o(),r=0|yg(0|(h=0|vg(0|w,0|r,0|h,0)),0|o(),26),o(),g=0|vg(0|g,0|Q,-16,-1),!((Q=0|o())>>>0>0|0==(0|Q)&g>>>0>15)){g=(5*r|0)+(67108863&t)&67108863,f=(((5*r|0)+(67108863&t)|0)>>>26)+(67108863&n)|0,t=67108863&y,r=67108863&s,n=67108863&h;break}w=(5*r|0)+(67108863&t)&67108863,f=(((5*r|0)+(67108863&t)|0)>>>26)+(67108863&n)|0,t=67108863&y,r=67108863&s,n=67108863&h,I=I+16|0}else g=w;C[A+20>>2]=g,C[A+24>>2]=f,C[A+28>>2]=t,C[A+32>>2]=r,C[A+36>>2]=n}function U(A,I){A|=0;var g=0,Q=0,E=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0;a=0|kI(I|=0),c=0|o(),u=0|rg(0|(u=0|Bg(0|B[I+4>>0],0|B[I+5>>0],0|B[I+6>>0])),0|o(),6),H=0|o(),e=0|rg(0|(e=0|Bg(0|B[I+7>>0],0|B[I+8>>0],0|B[I+9>>0])),0|o(),5),i=0|o(),F=0|rg(0|(F=0|Bg(0|B[I+10>>0],0|B[I+11>>0],0|B[I+12>>0])),0|o(),3),p=0|o(),E=0|rg(0|(E=0|Bg(0|B[I+13>>0],0|B[I+14>>0],0|B[I+15>>0])),0|o(),2),Q=0|o(),h=0|kI(I+16|0),D=0|o(),n=0|rg(0|(n=0|Bg(0|B[I+20>>0],0|B[I+21>>0],0|B[I+22>>0])),0|o(),7),g=0|o(),r=0|rg(0|(r=0|Bg(0|B[I+23>>0],0|B[I+24>>0],0|B[I+25>>0])),0|o(),5),s=0|o(),t=0|rg(0|(t=0|Bg(0|B[I+26>>0],0|B[I+27>>0],0|B[I+28>>0])),0|o(),4),f=0|o(),w=0|rg(0|(w=0|Bg(0|B[I+29>>0],0|B[I+30>>0],0|B[I+31>>0])),0|o(),2),o(),k=0|Ug(0,0,0|(k=0|yg(0|(y=0|vg(33554428&w|0,0,16777216,0)),0|o(),25)),0|o()),o(),c=0|vg(19&k|0,0,0|a,0|c),a=0|o(),y=0|Ug(33554428&w|0,0,33554432&y|0,0),w=0|o(),i=0|vg(0|(I=0|ig(0|(k=0|vg(0|u,0|H,16777216,0)),0|o(),25)),0|o(),0|e,0|i),e=0|o(),k=0|Ug(0|u,0|H,-33554432&k|0,0),H=0|o(),Q=0|vg(0|(I=0|ig(0|(u=0|vg(0|F,0|p,16777216,0)),0|o(),25)),0|o(),0|E,0|Q),E=0|o(),u=0|Ug(0|F,0|p,-33554432&u|0,0),p=0|o(),I=0|vg(0|n,0|g,0|(I=0|ig(0|(F=0|vg(0|h,0|D,16777216,0)),0|o(),25)),0|o()),g=0|o(),F=0|Ug(0|h,0|D,-33554432&F|0,0),D=0|o(),f=0|vg(0|(n=0|ig(0|(h=0|vg(0|r,0|s,16777216,0)),0|o(),25)),0|o(),0|t,0|f),t=0|o(),h=0|Ug(0|r,0|s,-33554432&h|0,0),s=0|o(),n=0|vg(0|k,0|H,0|(n=0|yg(0|(r=0|vg(0|c,0|a,33554432,0)),0|o(),26)),0|o()),o(),r=0|Ug(0|c,0|a,-67108864&r|0,0),o(),c=0|vg(0|u,0|p,0|(c=0|yg(0|(a=0|vg(0|i,0|e,33554432,0)),0|o(),26)),0|o()),o(),a=0|Ug(0|i,0|e,-67108864&a|0,0),o(),i=0|vg(0|F,0|D,0|(i=0|yg(0|(e=0|vg(0|Q,0|E,33554432,0)),0|o(),26)),0|o()),o(),e=0|Ug(0|Q,0|E,-67108864&e|0,0),o(),Q=0|vg(0|h,0|s,0|(Q=0|yg(0|(E=0|vg(0|I,0|g,33554432,0)),0|o(),26)),0|o()),o(),E=0|Ug(0|I,0|g,-67108864&E|0,0),o(),I=0|vg(0|y,0|w,0|(I=0|yg(0|(g=0|vg(0|f,0|t,33554432,0)),0|o(),26)),0|o()),o(),g=0|Ug(0|f,0|t,-67108864&g|0,0),o(),C[A>>2]=r,C[A+4>>2]=n,C[A+8>>2]=a,C[A+12>>2]=c,C[A+16>>2]=e,C[A+20>>2]=i,C[A+24>>2]=E,C[A+28>>2]=Q,C[A+32>>2]=g,C[A+36>>2]=I}function v(A,I){A|=0;var g=0,B=0,Q=0,E=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0;c=0|C[(I|=0)>>2],p=0|C[I+4>>2],i=0|C[I+8>>2],D=0|C[I+12>>2],Q=0|C[I+16>>2],s=0|C[I+20>>2],g=0|C[I+24>>2],n=0|C[I+28>>2],r=0|C[I+32>>2],H=0|C[I+36>>2],c=0|Qg(0|c,((0|c)<0)<<31>>31|0,121666,0),e=0|o(),p=0|Qg(0|p,((0|p)<0)<<31>>31|0,121666,0),u=0|o(),i=0|Qg(0|i,((0|i)<0)<<31>>31|0,121666,0),E=0|o(),D=0|Qg(0|D,((0|D)<0)<<31>>31|0,121666,0),F=0|o(),Q=0|Qg(0|Q,((0|Q)<0)<<31>>31|0,121666,0),B=0|o(),s=0|Qg(0|s,((0|s)<0)<<31>>31|0,121666,0),h=0|o(),g=0|Qg(0|g,((0|g)<0)<<31>>31|0,121666,0),I=0|o(),n=0|Qg(0|n,((0|n)<0)<<31>>31|0,121666,0),y=0|o(),r=0|Qg(0|r,((0|r)<0)<<31>>31|0,121666,0),t=0|o(),e=0|vg(0|(a=0|Qg(0|(a=0|ig(0|(w=0|vg(0|(H=0|Qg(0|H,((0|H)<0)<<31>>31|0,121666,0)),0|(f=0|o()),16777216,0)),0|o(),25)),0|o(),19,0)),0|o(),0|c,0|e),c=0|o(),w=0|Ug(0|H,0|f,-33554432&w|0,0),f=0|o(),E=0|vg(0|(a=0|ig(0|(H=0|vg(0|p,0|u,16777216,0)),0|o(),25)),0|o(),0|i,0|E),i=0|o(),H=0|Ug(0|p,0|u,-33554432&H|0,0),u=0|o(),B=0|vg(0|(a=0|ig(0|(p=0|vg(0|D,0|F,16777216,0)),0|o(),25)),0|o(),0|Q,0|B),Q=0|o(),p=0|Ug(0|D,0|F,-33554432&p|0,0),F=0|o(),I=0|vg(0|(a=0|ig(0|(D=0|vg(0|s,0|h,16777216,0)),0|o(),25)),0|o(),0|g,0|I),g=0|o(),D=0|Ug(0|s,0|h,-33554432&D|0,0),h=0|o(),t=0|vg(0|(a=0|ig(0|(s=0|vg(0|n,0|y,16777216,0)),0|o(),25)),0|o(),0|r,0|t),r=0|o(),s=0|Ug(0|n,0|y,-33554432&s|0,0),y=0|o(),a=0|vg(0|H,0|u,0|(a=0|yg(0|(n=0|vg(0|e,0|c,33554432,0)),0|o(),26)),0|o()),o(),n=0|Ug(0|e,0|c,-67108864&n|0,0),o(),e=0|vg(0|p,0|F,0|(e=0|yg(0|(c=0|vg(0|E,0|i,33554432,0)),0|o(),26)),0|o()),o(),c=0|Ug(0|E,0|i,-67108864&c|0,0),o(),E=0|vg(0|D,0|h,0|(E=0|yg(0|(i=0|vg(0|B,0|Q,33554432,0)),0|o(),26)),0|o()),o(),i=0|Ug(0|B,0|Q,-67108864&i|0,0),o(),B=0|vg(0|s,0|y,0|(B=0|yg(0|(Q=0|vg(0|I,0|g,33554432,0)),0|o(),26)),0|o()),o(),Q=0|Ug(0|I,0|g,-67108864&Q|0,0),o(),I=0|vg(0|w,0|f,0|(I=0|yg(0|(g=0|vg(0|t,0|r,33554432,0)),0|o(),26)),0|o()),o(),g=0|Ug(0|t,0|r,-67108864&g|0,0),o(),C[A>>2]=n,C[A+4>>2]=a,C[A+8>>2]=c,C[A+12>>2]=e,C[A+16>>2]=i,C[A+20>>2]=E,C[A+24>>2]=Q,C[A+28>>2]=B,C[A+32>>2]=g,C[A+36>>2]=I}function b(A,I,g){A|=0,I|=0;var C,E,i=0,e=0,o=0;if(E=y,C=y=y+63&-64,y=y+64|0,(g|=0)<<24>>24&&(255&g)<=64){if(0|function(A,I){return 1&(0!=(0|(A|=0))|0!=(0|(I|=0)))|0}(Q[A+80>>0]|Q[A+80+1>>0]<<8|Q[A+80+2>>0]<<16|Q[A+80+3>>0]<<24,Q[A+80+4>>0]|Q[A+80+4+1>>0]<<8|Q[A+80+4+2>>0]<<16|Q[A+80+4+3>>0]<<24))i=-1;else{i=Q[A+352>>0]|Q[A+352+1>>0]<<8|Q[A+352+2>>0]<<16|Q[A+352+3>>0]<<24;do{if(i>>>0>128){if(aA(A,128,0),s(A,A+96|0),i=(Q[A+352>>0]|Q[A+352+1>>0]<<8|Q[A+352+2>>0]<<16|Q[A+352+3>>0]<<24)-128|0,B[A+352>>0]=i,B[A+352+1>>0]=i>>8,B[A+352+2>>0]=i>>16,B[A+352+3>>0]=i>>24,i>>>0<129){BA(A+96|0,A+224|0,0|i),e=Q[A+352>>0]|Q[A+352+1>>0]<<8|Q[A+352+2>>0]<<16|Q[A+352+3>>0]<<24,o=A+96|0;break}c(33456,33488,306,33533)}else e=i,o=A+96|0}while(0);aA(A,e,0),function(A){0|B[356+(A|=0)>>0]&&function(A){B[88+(A|=0)>>0]=-1,B[A+88+1>>0]=-1,B[A+88+2>>0]=-1,B[A+88+3>>0]=-1,B[A+88+4>>0]=-1,B[A+88+4+1>>0]=-1,B[A+88+4+2>>0]=-1,B[A+88+4+3>>0]=-1}(A),B[A+80>>0]=-1,B[A+80+1>>0]=-1,B[A+80+2>>0]=-1,B[A+80+3>>0]=-1,B[A+80+4>>0]=-1,B[A+80+4+1>>0]=-1,B[A+80+4+2>>0]=-1,B[A+80+4+3>>0]=-1}(A),YA(A+96+(i=Q[A+352>>0]|Q[A+352+1>>0]<<8|Q[A+352+2>>0]<<16|Q[A+352+3>>0]<<24)|0,0,256-i|0),s(A,o),LI(C,Q[A>>0]|Q[A+1>>0]<<8|Q[A+2>>0]<<16|Q[A+3>>0]<<24,Q[A+4>>0]|Q[A+4+1>>0]<<8|Q[A+4+2>>0]<<16|Q[A+4+3>>0]<<24),LI(C+8|0,Q[A+8>>0]|Q[A+8+1>>0]<<8|Q[A+8+2>>0]<<16|Q[A+8+3>>0]<<24,Q[A+8+4>>0]|Q[A+8+4+1>>0]<<8|Q[A+8+4+2>>0]<<16|Q[A+8+4+3>>0]<<24),LI(C+16|0,Q[A+16>>0]|Q[A+16+1>>0]<<8|Q[A+16+2>>0]<<16|Q[A+16+3>>0]<<24,Q[A+16+4>>0]|Q[A+16+4+1>>0]<<8|Q[A+16+4+2>>0]<<16|Q[A+16+4+3>>0]<<24),LI(C+24|0,Q[A+24>>0]|Q[A+24+1>>0]<<8|Q[A+24+2>>0]<<16|Q[A+24+3>>0]<<24,Q[A+24+4>>0]|Q[A+24+4+1>>0]<<8|Q[A+24+4+2>>0]<<16|Q[A+24+4+3>>0]<<24),LI(C+32|0,Q[A+32>>0]|Q[A+32+1>>0]<<8|Q[A+32+2>>0]<<16|Q[A+32+3>>0]<<24,Q[A+32+4>>0]|Q[A+32+4+1>>0]<<8|Q[A+32+4+2>>0]<<16|Q[A+32+4+3>>0]<<24),LI(C+40|0,Q[A+40>>0]|Q[A+40+1>>0]<<8|Q[A+40+2>>0]<<16|Q[A+40+3>>0]<<24,Q[A+40+4>>0]|Q[A+40+4+1>>0]<<8|Q[A+40+4+2>>0]<<16|Q[A+40+4+3>>0]<<24),LI(C+48|0,Q[A+48>>0]|Q[A+48+1>>0]<<8|Q[A+48+2>>0]<<16|Q[A+48+3>>0]<<24,Q[A+48+4>>0]|Q[A+48+4+1>>0]<<8|Q[A+48+4+2>>0]<<16|Q[A+48+4+3>>0]<<24),LI(C+56|0,Q[A+56>>0]|Q[A+56+1>>0]<<8|Q[A+56+2>>0]<<16|Q[A+56+3>>0]<<24,Q[A+56+4>>0]|Q[A+56+4+1>>0]<<8|Q[A+56+4+2>>0]<<16|Q[A+56+4+3>>0]<<24),BA(0|I,0|C,255&g|0),MI(A,64),MI(o,256),i=0}return y=E,0|i}return SB(),0}function J(A,I,g,Q){A|=0,I|=0,g|=0;var E,i,e=0,o=0,c=0,a=0,n=0,r=0;switch(i=y,E=y=y+63&-64,y=y+16|0,0|(Q|=0)){case 2:if(I>>>0<13)Q=-31;else{e=33688,o=(Q=A)+13|0;do{B[Q>>0]=0|B[e>>0],Q=Q+1|0,e=e+1|0}while((0|Q)<(0|o));A=A+12|0,o=I+-12|0,e=6}break;case 1:if(I>>>0<12)Q=-31;else{e=33701,o=(Q=A)+12|0;do{B[Q>>0]=0|B[e>>0],Q=Q+1|0,e=e+1|0}while((0|Q)<(0|o));A=A+11|0,o=I+-11|0,e=6}break;default:Q=-31}do{if(6==(0|e)&&!(Q=0|oA(g))){if(cI(E,19),e=A+(Q=0|ZA(E))|0,a=o-Q|0,o>>>0<=Q>>>0){Q=-31;break}if(BA(0|A,0|E,Q+1|0),a>>>0>=4){if(B[e>>0]=36,B[e+1>>0]=109,B[e+2>>0]=61,B[e+3>>0]=0,cI(E,0|C[g+44>>2]),o=e+3+(A=0|ZA(E))|0,(a+-3|0)>>>0<=A>>>0){Q=-31;break}if(BA(e+3|0,0|E,A+1|0),(a+-3-A|0)>>>0>=4){if(B[o>>0]=44,B[o+1>>0]=116,B[o+2>>0]=61,B[o+3>>0]=0,cI(E,0|C[g+40>>2]),I=o+3+(Q=0|ZA(E))|0,c=a+-3-A-3-Q|0,(a+-3-A-3|0)>>>0<=Q>>>0){Q=-31;break}if(BA(o+3|0,0|E,Q+1|0),c>>>0>=4){if(B[I>>0]=44,B[I+1>>0]=112,B[I+2>>0]=61,B[I+3>>0]=0,cI(E,0|C[g+48>>2]),(c+-3|0)>>>0<=(e=0|ZA(E))>>>0){Q=-31;break}if(BA(I+3|0,0|E,e+1|0),Q=I+3+e+1|0,(c+-3-e|0)>>>0>=2&&(B[I+3+e>>0]=36,B[I+3+e+1>>0]=0,q(Q,c+-3-e-1|0,0|C[g+16>>2],0|C[g+20>>2],3),(r=c+-3-e-1-(n=0|ZA(Q))|0)>>>0>=2))return B[Q+n>>0]=36,B[Q+n+1>>0]=0,q(Q+n+1|0,r+-1|0,0|C[g>>2],0|C[g+4>>2],3),y=i,0;Q=-31}else Q=-31}else Q=-31}else Q=-31}}while(0);return y=i,0|Q}function P(A,I,g,Q){A|=0,I|=0,g|=0,Q|=0;var E,i,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,s=0;i=y,E=y=y+63&-64,y=y+704|0;A:do{if(!(0==(0|g)&0==(0|Q))){if(r=0|yg(0|(s=0|C[A+72>>2]),0|(f=0|C[A+72+4>>2]),3),o(),t=0|rg(0|g,0|Q,3),w=0|o(),a=0|yg(0|g,0|Q,61),n=0|o(),f=0|vg(0|s,0|f,0|t,0|w),s=0|o(),C[A+72>>2]=f,C[A+72+4>>2]=s,e=0|C[A+64>>2],c=0|C[A+64+4>>2],s>>>0<w>>>0|(0|s)==(0|w)&f>>>0<t>>>0&&(e=0|vg(0|e,0|c,1,0),c=0|o(),C[A+64>>2]=e,C[A+64+4>>2]=c),e=0|vg(0|e,0|c,0|a,0|n),n=0|o(),C[A+64>>2]=e,C[A+64+4>>2]=n,n=0|Ug(128,0,127&r|0,0),(e=0|o())>>>0>Q>>>0|(0|e)==(0|Q)&n>>>0>g>>>0)for(e=0,c=0;;)if(w=0|B[I+e>>0],s=0|vg(0|e,0|c,127&r|0,0),o(),B[A+80+s>>0]=w,e=0|vg(0|e,0|c,1,0),!((c=0|o())>>>0<Q>>>0|(0|c)==(0|Q)&e>>>0<g>>>0))break A;if(!(0==(0|n)&0==(0|e))){c=0,a=0;do{w=0|B[I+c>>0],s=0|vg(0|c,0|a,127&r|0,0),o(),B[A+80+s>>0]=w,c=0|vg(0|c,0|a,1,0),a=0|o()}while(a>>>0<e>>>0|(0|a)==(0|e)&c>>>0<n>>>0)}if(D(A,A+80|0,E,E+640|0),e=0|Ug(0|g,0|Q,0|n,0|e),(a=0|o())>>>0>0|0==(0|a)&e>>>0>127){c=I+n|0;do{D(A,c,E,E+640|0),c=c+128|0,e=0|vg(0|e,0|a,-128,-1),a=0|o()}while(a>>>0>0|0==(0|a)&e>>>0>127)}else c=I+n|0;if(!(0==(0|(n=127&e))&!0)){e=0,a=0;do{B[A+80+e>>0]=0|B[c+e>>0],e=0|vg(0|e,0|a,1,0),a=0|o()}while(a>>>0<0|0==(0|a)&e>>>0<n>>>0)}MI(E,704)}}while(0);y=i}function R(A,I,g){A|=0,I|=0;var B=0,C=0,Q=0,E=0,i=0,e=0,o=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0;C=0|Vg(g|=0),Q=0|Vg(g+4|0),E=0|Vg(g+8|0),i=0|Vg(g+12|0),e=0|Vg(g+16|0),o=0|Vg(g+20|0),r=0|Vg(g+24|0),t=0|Vg(g+28|0),f=0|Vg(I),w=0|Vg(I+4|0),y=0|Vg(I+8|0),c=0,a=1634760805,n=857760878,g=0|Vg(I+12|0),I=2036477234,B=1797285236;do{p=0|wB((l=0|wB((R=0|wB((k=(l=0|wB(f^(P=C+a|0),16))+e|0)^C,12))+P^l,8))+k^R,7),N=0|wB((D=0|wB((v=0|wB((h=(D=0|wB(w^(U=Q+n|0),16))+o|0)^Q,12))+U^D,8))+h^v,7),b=0|wB((F=0|wB((d=0|wB((_=(F=0|wB(y^(G=E+I|0),16))+r|0)^E,12))+G^F,8))+_^d,7),Y=0|wB((M=0|wB((H=0|wB((s=(M=0|wB(g^(u=i+B|0),16))+t|0)^i,12))+u^M,8))+s^H,7),Q=0|wB((r=(g=0|wB((a=(S=0|wB((J=0|wB(M^N+(R+P),16))+(F+_)^N,12))+(N+(R+P))|0)^J,8))+(J+(F+_))|0)^S,7),E=0|wB((t=(f=0|wB((n=(_=0|wB((S=0|wB(b+(v+U)^l,16))+(M+s)^b,12))+(b+(v+U))|0)^S,8))+(S+(M+s))|0)^_,7),i=0|wB((e=(w=0|wB((I=(s=0|wB((_=0|wB(Y+(d+G)^D,16))+(l+k)^Y,12))+(Y+(d+G))|0)^_,8))+(_+(l+k))|0)^s,7),C=0|wB((o=(y=0|wB((B=(s=0|wB((F=0|wB(H+u+p^F,16))+(D+h)^p,12))+(H+u+p)|0)^F,8))+(F+(D+h))|0)^s,7),c=c+1|0}while(10!=(0|c));Pg(A,a),Pg(A+4|0,n),Pg(A+8|0,I),Pg(A+12|0,B),Pg(A+16|0,f),Pg(A+20|0,w),Pg(A+24|0,y),Pg(A+28|0,g)}function N(A,I,g,C){A|=0,g|=0,C|=0;var Q,E,i=0,e=0;for(Q=y,E=y=y+63&-64,y=y+2272|0,yA(E+1536|0,I|=0),yA(E+1280|0,C),eg(E,g),og(E+2112|0,g),Eg(E+1792|0,E+2112|0),gI(E+2112|0,E+1792|0,E),Eg(E+1952|0,E+2112|0),eg(E+160|0,E+1952|0),gI(E+2112|0,E+1792|0,E+160|0),Eg(E+1952|0,E+2112|0),eg(E+320|0,E+1952|0),gI(E+2112|0,E+1792|0,E+320|0),Eg(E+1952|0,E+2112|0),eg(E+480|0,E+1952|0),gI(E+2112|0,E+1792|0,E+480|0),Eg(E+1952|0,E+2112|0),eg(E+640|0,E+1952|0),gI(E+2112|0,E+1792|0,E+640|0),Eg(E+1952|0,E+2112|0),eg(E+800|0,E+1952|0),gI(E+2112|0,E+1792|0,E+800|0),Eg(E+1952|0,E+2112|0),eg(E+960|0,E+1952|0),gI(E+2112|0,E+1792|0,E+960|0),Eg(E+1952|0,E+2112|0),eg(E+1120|0,E+1952|0),function(A){Kg(A|=0),Sg(A+40|0),Sg(A+80|0)}(A),g=255;;){if(0|B[E+1536+g>>0]){i=g,e=5;break}if(0|B[E+1280+g>>0]){i=g,e=5;break}if(!g)break;g=g+-1|0}if(5==(0|e)&&(0|i)>-1)for(;aI(E+2112|0,A),(g=0|B[E+1536+i>>0])<<24>>24<=0?g<<24>>24<0&&(Eg(E+1952|0,E+2112|0),II(E+2112|0,E+1952|0,E+(160*(((g<<24>>24)/-2|0)<<24>>24)|0)|0)):(Eg(E+1952|0,E+2112|0),gI(E+2112|0,E+1952|0,E+(160*((255&g)>>>1&255)|0)|0)),(g=0|B[E+1280+i>>0])<<24>>24<=0?g<<24>>24<0&&(Eg(E+1952|0,E+2112|0),BI(E+2112|0,E+1952|0,160+(120*(((g<<24>>24)/-2|0)<<24>>24)|0)|0)):(Eg(E+1952|0,E+2112|0),CI(E+2112|0,E+1952|0,160+(120*((255&g)>>>1&255)|0)|0)),Hg(A,E+2112|0),(0|i)>0;)i=i+-1|0;y=Q}function m(A,I,g,Q,E,i,e,o){A|=0,I|=0,g|=0,Q|=0,E|=0,i|=0,e|=0,o|=0;var c,a,n=0,r=0,t=0,f=0,w=0,s=0,h=0;if(a=y,c=y=y+63&-64,y=y+16|0,C[c>>2]=0,EB(o),Q){f=0,r=0,t=0,n=0;A:for(;;){for(s=n;n=0|B[g+s>>0],255==(0|(w=4&o?0|VA(n):0|zA(n)));){if(!E){w=18;break A}if(!(0|qg(E,n))){w=19;break A}if(!((n=s+1|0)>>>0<Q>>>0)){w=17;break A}s=n}if(f=w+(f<<6)|0,(n=r+6|0)>>>0>7){if(r=r+-2|0,t>>>0>=I>>>0){w=13;break}B[A+t>>0]=f>>>r,t=t+1|0}else r=n;if((n=s+1|0)>>>0>=Q>>>0){w=16;break}}13==(0|w)?(C[c>>2]=s,C[8678]=68,n=-1):16==(0|w)?(C[c>>2]=n,n=0):17==(0|w)?(C[c>>2]=n,n=0):18==(0|w)?(C[c>>2]=s,n=0):19==(0|w)&&(C[c>>2]=s,n=0),r>>>0>4?(t=0,n=-1):w=21}else f=0,r=0,t=0,n=0,w=21;do{if(21==(0|w))if((1<<r)-1&f)t=0,n=-1;else if(n|2&o||(n=0|mA(g,Q,c,E,r>>>1)),n)t=0;else if(0!=(0|E)&&(h=0|C[c>>2])>>>0<Q>>>0){for(n=h;;){if(!(0|qg(E,0|B[g+n>>0]))){w=31;break}if((n=n+1|0)>>>0>=Q>>>0){w=30;break}}if(30==(0|w)){C[c>>2]=n,n=0;break}if(31==(0|w)){C[c>>2]=n,n=0;break}}else n=0}while(0);return r=0|C[c>>2],e?C[e>>2]=g+r:(0|r)!=(0|Q)&&(C[8678]=28,n=-1),0|i&&(C[i>>2]=t),y=a,0|n}function L(A,I,g){I|=0,g|=0;var Q,E,i,e=0,o=0,c=0;switch(i=y,E=y=y+63&-64,y=y+16|0,c=0|C[20+(A|=0)>>2],Q=0|C[A+4>>2],C[A+20>>2]=0,C[A+4>>2]=0,0|g){case 2:0|oI(I,33653,9)?I=-32:(I=I+9|0,o=4);break;case 1:0|oI(I,33663,8)?I=-32:(I=I+8|0,o=4);break;default:I=-26}do{if(4==(0|o))if(0==(0|oI(I,33672,3))&&0!=(0|(e=0|qA(I+3|0,E+4|0))))if(19==(0|C[E+4>>2]))if(0|oI(e,33676,3))I=-32;else{if(!(I=0|qA(e+3|0,E+4|0))){I=-32;break}if(C[A+44>>2]=C[E+4>>2],0|oI(I,33680,3))I=-32;else{if(!(I=0|qA(I+3|0,E+4|0))){I=-32;break}if(C[A+40>>2]=C[E+4>>2],0|oI(I,33684,3))I=-32;else{if(!(I=0|qA(I+3|0,E+4|0))){I=-32;break}if(o=0|C[E+4>>2],C[A+48>>2]=o,C[A+52>>2]=o,I=(o=36==(0|B[I>>0]))?I+1|0:I,o){if(C[E+4>>2]=c,0|m(o=0|C[A+16>>2],c,I,0|ZA(I),0,E+4|0,E,3)){I=-32;break}if(C[A+20>>2]=C[E+4>>2],I=0|C[E>>2],I=(c=36==(0|B[I>>0]))?I+1|0:I,c){if(C[E+4>>2]=Q,0|m(c=0|C[A>>2],Q,I,0|ZA(I),0,E+4|0,E,3)){I=-32;break}C[A+4>>2]=C[E+4>>2],g=0|C[E>>2],(I=0|oA(A))||(I=0==(0|B[g>>0])?0:-32)}else I=-32}else I=-32}}}else I=-26;else I=-32}while(0);return y=i,0|I}function x(A,I,g){A|=0,I|=0;var B=0,C=0,Q=0,E=0,i=0,e=0,o=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0;Q=0|Vg(g|=0),n=0|Vg(g+4|0),r=0|Vg(g+8|0),t=0|Vg(g+12|0),i=0|Vg(g+16|0),e=0|Vg(g+20|0),o=0|Vg(g+24|0),c=0|Vg(g+28|0),w=0|Vg(I),y=0|Vg(I+4|0),s=0|Vg(I+8|0),B=20,C=1634760805,E=2036477234,a=1797285236,f=857760878,g=0|Vg(I+12|0);do{Y=(0|wB((F=(0|wB((H=(0|wB((_=(0|wB(e+C|0,7))^t)+C|0,9))^s)+_|0,13))^e)+H|0,18))^C,l=(0|wB((U=(0|wB((D=(0|wB((u=(0|wB(f+Q|0,7))^g)+f|0,9))^o)+u|0,13))^Q)+D|0,18))^f,p=(0|wB((d=(0|wB((S=(0|wB((h=(0|wB(E+w|0,7))^c)+E|0,9))^n)+h|0,13))^w)+S|0,18))^E,I=(0|wB((k=(0|wB((G=(0|wB((M=(0|wB(a+i|0,7))^r)+a|0,9))^y)+M|0,13))^i)+G|0,18))^a,C=(0|wB((r=(0|wB((n=(0|wB((Q=(0|wB(M+Y|0,7))^U)+Y|0,9))^S)+Q|0,13))^M)+n|0,18))^Y,f=(0|wB((t=(0|wB((y=(0|wB((w=(0|wB(l+_|0,7))^d)+l|0,9))^G)+w|0,13))^_)+y|0,18))^l,E=(0|wB((g=(0|wB((s=(0|wB((i=(0|wB(p+u|0,7))^k)+p|0,9))^H)+i|0,13))^u)+s|0,18))^p,a=(0|wB((c=(0|wB((o=(0|wB((e=(0|wB(I+h|0,7))^F)+I|0,9))^D)+e|0,13))^h)+o|0,18))^I,B=B+-2|0}while(0!=(0|B));Pg(A,C),Pg(A+4|0,f),Pg(A+8|0,E),Pg(A+12|0,a),Pg(A+16|0,w),Pg(A+20|0,y),Pg(A+24|0,s),Pg(A+28|0,g)}function K(A,I,g,Q){I|=0,g|=0,Q|=0;var E=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0;if(0==(0|(i=0|C[56+(A|=0)>>2]))&0==(0|(E=0|C[A+56+4>>2])))r=7;else{if(c=0|Ug(16,0,0|i,0|E),!(0==(0|(n=(a=0|o())>>>0>Q>>>0|(0|a)==(0|Q)&c>>>0>g>>>0?g:c))&0==(0|(a=a>>>0>Q>>>0|(0|a)==(0|Q)&c>>>0>g>>>0?Q:a)))){c=0,e=0;do{t=0|B[I+c>>0],i=0|vg(0|i,0|E,0|c,0|e),o(),B[A+64+i>>0]=t,c=0|vg(0|c,0|e,1,0),e=0|o(),i=0|C[A+56>>2],E=0|C[A+56+4>>2]}while(e>>>0<a>>>0|(0|e)==(0|a)&c>>>0<n>>>0)}t=0|vg(0|i,0|E,0|n,0|a),c=0|o(),C[A+56>>2]=t,C[A+56+4>>2]=c,c>>>0<0|0==(0|c)&t>>>0<16||(g=0|Ug(0|g,0|Q,0|n,0|a),Q=0|o(),S(A,A+64|0,16,0),C[A+56>>2]=0,C[A+56+4>>2]=0,I=I+n|0,r=7)}if(7==(0|r)&&(E=-16&g,Q>>>0>0|0==(0|Q)&g>>>0>15?(i=0|Ug(0|g,0|Q,0|E,0|Q),t=0|o(),S(A,I,E,Q),Q=t,I=I+E|0):i=g,!(0==(0|i)&0==(0|Q)))){E=0,g=0;do{r=0|B[I+E>>0],t=0|vg(0|C[A+56>>2],0|C[A+56+4>>2],0|E,0|g),o(),B[A+64+t>>0]=r,E=0|vg(0|E,0|g,1,0),g=0|o()}while(g>>>0<Q>>>0|(0|g)==(0|Q)&E>>>0<i>>>0);r=0|vg(0|C[A+56>>2],0|C[A+56+4>>2],0|i,0|Q),t=0|o(),C[A+56>>2]=r,C[A+56+4>>2]=t}}function X(A,I){A|=0,I|=0;var g=0,i=0,e=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0;A:do{if(0|A){do{if(2==(0|C[A+36>>2])){if(0==(0|(g=0|C[I>>2]))&&(0|Q[I+8>>0])<=1){i=6;break}t=0|C[A+4>>2],r=0}else i=6}while(0);if(6==(0|i)&&(QA(A,I,t=0|C[A+4>>2]),g=0|C[I>>2],r=1),g=0==(0|g)&(e=0|B[I+8>>0])<<24>>24==0?2:0,i=0|C[A+24>>2],a=0|E(i,0|C[I+4>>2]),n=0|C[A+20>>2],e=a+g+(0|E(n,255&e))|0,g>>>0<n>>>0)for(c=i,n=e,i=(0==(0|(e>>>0)%(i>>>0))?i+-1|0:-1)+e|0;;){if(a=1==(0|(n>>>0)%(c>>>0))?n+-1|0:i,i=r?t+(g<<3)|0:(0|C[4+(0|C[A>>2])>>2])+(a<<10)|0,y=0|C[(c=i)>>2],c=0|Ag(0|C[c+4>>2],0,0|C[A+28>>2],0),e=0|o(),f=0|C[I>>2],i=0|B[I+8>>0],w=0|C[I+4>>2],c=0==(0|f)&i<<24>>24==0?w:c,C[I+12>>2]=g,e=0|DA(A,f,i,g,y,1&((0|c)==(0|w)?0==(0|(0==(0|f)&i<<24>>24==0?0:e)):0)),e=(i=0|C[4+(0|C[A>>2])>>2])+((0|E(0|C[A+24>>2],c))<<10)+(e<<10)|0,c=i+(n<<10)|0,f?H(i+(a<<10)|0,e,c):k(i+(a<<10)|0,e,c),(g=g+1|0)>>>0>=(0|C[A+20>>2])>>>0)break A;c=0|C[A+24>>2],n=n+1|0,i=a+1|0}}}while(0)}function j(A,I,g){var B,Q;g|=0,B=y,Q=y=y+63&-64,y=y+400|0,0==(0|(A|=0))|0==(0|(I|=0))||(HI(Q,0,0,64),Pg(Q+384|0,0|C[I+48>>2]),Xg(Q,Q+384|0,4,0),Pg(Q+384|0,0|C[I+4>>2]),Xg(Q,Q+384|0,4,0),Pg(Q+384|0,0|C[I+44>>2]),Xg(Q,Q+384|0,4,0),Pg(Q+384|0,0|C[I+40>>2]),Xg(Q,Q+384|0,4,0),Pg(Q+384|0,19),Xg(Q,Q+384|0,4,0),Pg(Q+384|0,g),Xg(Q,Q+384|0,4,0),Pg(Q+384|0,0|C[I+12>>2]),Xg(Q,Q+384|0,4,0),0|(g=0|C[I+8>>2])&&(Xg(Q,g,0|C[I+12>>2],0),1&C[I+56>>2]|0)&&(MI(0|C[I+8>>2],0|C[I+12>>2]),C[I+12>>2]=0),Pg(Q+384|0,0|C[I+20>>2]),Xg(Q,Q+384|0,4,0),0|(g=0|C[I+16>>2])&&Xg(Q,g,0|C[I+20>>2],0),Pg(Q+384|0,0|C[I+28>>2]),Xg(Q,Q+384|0,4,0),0|(g=0|C[I+24>>2])&&(Xg(Q,g,0|C[I+28>>2],0),2&C[I+56>>2]|0)&&(MI(0|C[I+24>>2],0|C[I+28>>2]),C[I+28>>2]=0),Pg(Q+384|0,0|C[I+36>>2]),Xg(Q,Q+384|0,4,0),0|(g=0|C[I+32>>2])&&Xg(Q,g,0|C[I+36>>2],0),fg(Q,A,64)),y=B}function T(A,I,g,Q){A|=0,I|=0,g|=0,Q|=0;var E,i,e=0,o=0,c=0;if(E=y,i=y=y+63&-64,y=y+528|0,C[i+512>>2]=0,Pg(i+512|0,I),I>>>0<65)(0|HI(i,0,0,I))>=0&&(Xg(i,i+512|0,4,0),Xg(i,g,Q,0),fg(i,A,I));else A:do{if((0|HI(i,0,0,64))>=0&&(Xg(i,i+512|0,4,0),Xg(i,g,Q,0),(0|fg(i,i+448|0,64))>=0)){o=i+448|0,c=(e=A)+32|0;do{B[e>>0]=0|B[o>>0],e=e+1|0,o=o+1|0}while((0|e)<(0|c));o=i+448|0,c=64+(e=i+384|0)|0;do{C[e>>2]=C[o>>2],e=e+4|0,o=o+4|0}while((0|e)<(0|c));if((I+-32|0)>>>0>64){Q=A+32|0,g=I+-32|0;do{if((0|TI(i+448|0,64,i+384|0,64,0,0,0))<0)break A;o=i+448|0,c=(e=Q)+32|0;do{B[e>>0]=0|B[o>>0],e=e+1|0,o=o+1|0}while((0|e)<(0|c));g=g+-32|0,Q=Q+32|0,o=i+448|0,c=64+(e=i+384|0)|0;do{C[e>>2]=C[o>>2],e=e+4|0,o=o+4|0}while((0|e)<(0|c))}while(g>>>0>64)}else Q=A+32|0,g=I+-32|0;(0|TI(i+448|0,g,i+384|0,64,0,0,0))>=0&&BA(0|Q,i+448|0,0|g)}}while(0);MI(i,384),y=E}function q(A,I,g,C,i){A|=0,I|=0,g|=0,C|=0;var e=0,o=0,a=0,n=0,r=0,t=0;EB(i|=0),o=(0|E((C>>>0)/3|0,-3))+C|0,e=((C>>>0)/3|0)<<2;do{if(o){if(2&i){e=(2|e)+(o>>>1)|0;break}e=e+4|0;break}}while(0);if(e>>>0>=I>>>0&&SB(),4&i)if(0|C){n=0,i=0,o=0,r=0;do{if(t=r,r=r+1|0,n=n<<8|0|Q[g+t>>0],(i=i+8|0)>>>0>5)for(;;){if(t=255&(0|XI(n>>>(i=i+-6|0)&63)),a=o+1|0,B[A+o>>0]=t,!(i>>>0>5)){o=a;break}o=a}}while((0|r)!=(0|C));i&&(t=255&(0|XI(n<<6-i&63)),B[A+o>>0]=t,o=o+1|0)}else o=0;else if(0|C){n=0,i=0,o=0,r=0;do{if(a=r,r=r+1|0,n=n<<8|0|Q[g+a>>0],(i=i+8|0)>>>0>5)for(;;){if(t=255&(0|jI(n>>>(i=i+-6|0)&63)),a=o+1|0,B[A+o>>0]=t,!(i>>>0>5)){o=a;break}o=a}}while((0|r)!=(0|C));i&&(t=255&(0|jI(n<<6-i&63)),B[A+o>>0]=t,o=o+1|0)}else o=0;return e>>>0<o>>>0&&c(34564,34583,230,34599),e>>>0>o>>>0?YA(A+o|0,61,e-o|0):e=o,YA(A+e|0,0,((t=e+1|0)>>>0<I>>>0?I:t)-e|0),0|A}function V(A,I,g,E,i,e,c,a){A|=0,I|=0,i|=0,e|=0,c|=0,a|=0;var n,r,t=0,f=0;if(n=y,r=y=y+63&-64,y=y+112|0,!(0==(0|(g|=0))&0==(0|(E|=0)))){t=(f=r)+32|0;do{B[f>>0]=0|B[a>>0],f=f+1|0,a=a+1|0}while((0|f)<(0|t));a=Q[i+4>>0]|Q[i+4+1>>0]<<8|Q[i+4+2>>0]<<16|Q[i+4+3>>0]<<24,C[r+96>>2]=Q[i>>0]|Q[i+1>>0]<<8|Q[i+2>>0]<<16|Q[i+3>>0]<<24,C[r+96+4>>2]=a,a=8;do{B[r+96+a>>0]=e,e=0|yg(0|e,0|c,8),c=0|o(),a=a+1|0}while(16!=(0|a));if(E>>>0>0|0==(0|E)&g>>>0>63)for(e=E;;){iB(r+32|0,r+96|0,r),c=0;do{B[A+c>>0]=B[r+32+c>>0]^B[I+c>>0],c=c+1|0}while(64!=(0|c));for(a=8,c=1;c=c+(0|Q[(E=r+96+a|0)>>0])|0,B[E>>0]=c,16!=(0|(a=a+1|0));)c>>>=8;if(c=0|vg(0|g,0|e,-64,-1),A=A+64|0,I=I+64|0,!((a=0|o())>>>0>0|0==(0|a)&c>>>0>63)){e=c;break}g=c,e=a}else e=g,a=E;if(!(0==(0|e)&0==(0|a))&&(iB(r+32|0,r+96|0,r),0|e)){c=0;do{B[A+c>>0]=B[r+32+c>>0]^B[I+c>>0],c=c+1|0}while((0|c)!=(0|e))}MI(r+32|0,64),MI(r,32)}y=n}function z(A,I){I|=0;var g,Q,E,i,e,c,a=0,n=0,r=0,t=0;0==(0|(n=0|C[56+(A|=0)>>2]))&0==(0|(a=0|C[A+56+4>>2]))||(B[A+64+n>>0]=1,a=0|vg(0|n,0|a,1,0),(r=0|o())>>>0<0|0==(0|r)&a>>>0<16&&YA(A+64+a|0,0,14-n+1|0),B[A+80>>0]=1,S(A,A+64|0,16,0)),n=0|C[A+24>>2],t=(E=(-67108864|(Q=((t=((r=(0|C[A+28>>2])+(n>>>26)|0)>>>26)+(0|C[A+32>>2])|0)>>>26)+(0|C[A+36>>2])|0))+((((((i=((c=(5*(Q>>>26)|0)+(0|C[A+20>>2])|0)>>>26)+(67108863&n)+((5+(67108863&c)|0)>>>26)|0)>>>26)+(67108863&r)|0)>>>26)+(67108863&t)|0)>>>26)|0)>>31&67108863&t|(e=(E>>>31)-1&67108863)&(((i>>>26)+(67108863&r)|0)>>>26)+(67108863&t),g=0|vg(E>>31&67108863&c|e&5+(67108863&c)|(E>>31&(c>>>26)+(67108863&n)|e&i)<<26|0,0,0|C[A+40>>2],0),a=0|o(),a=0|vg(0|(n=0|vg((E>>31&(c>>>26)+(67108863&n)|e&i)>>>6|(E>>31&67108863&r|e&(i>>>26)+(67108863&r))<<20|0,0,0|C[A+44>>2],0)),0|o(),0|a,0),n=0|o(),n=0|vg(0|(r=0|vg((E>>31&67108863&r|e&(i>>>26)+(67108863&r))>>>12|t<<14|0,0,0|C[A+48>>2],0)),0|o(),0|n,0),r=0|o(),r=0|vg(0|(t=0|vg(((E>>>31)-1&E|E>>31&Q)<<8|t>>>18|0,0,0|C[A+52>>2],0)),0|o(),0|r,0),o(),Pg(I,g),Pg(I+4|0,a),Pg(I+8|0,n),Pg(I+12|0,r),MI(A,88)}function W(A,I){var g,B;A|=0,g=y,B=y=y+63&-64,y=y+192|0,_(B+144|0,I|=0),_(B+96|0,B+144|0),_(B+96|0,B+96|0),u(B+96|0,I,B+96|0),u(B+144|0,B+144|0,B+96|0),_(B+48|0,B+144|0),u(B+96|0,B+96|0,B+48|0),_(B+48|0,B+96|0),I=1;do{_(B+48|0,B+48|0),I=I+1|0}while(5!=(0|I));u(B+96|0,B+48|0,B+96|0),_(B+48|0,B+96|0),I=1;do{_(B+48|0,B+48|0),I=I+1|0}while(10!=(0|I));u(B+48|0,B+48|0,B+96|0),_(B,B+48|0),I=1;do{_(B,B),I=I+1|0}while(20!=(0|I));u(B+48|0,B,B+48|0),_(B+48|0,B+48|0),I=1;do{_(B+48|0,B+48|0),I=I+1|0}while(10!=(0|I));u(B+96|0,B+48|0,B+96|0),_(B+48|0,B+96|0),I=1;do{_(B+48|0,B+48|0),I=I+1|0}while(50!=(0|I));u(B+48|0,B+48|0,B+96|0),_(B,B+48|0),I=1;do{_(B,B),I=I+1|0}while(100!=(0|I));u(B+48|0,B,B+48|0),_(B+48|0,B+48|0),I=1;do{_(B+48|0,B+48|0),I=I+1|0}while(50!=(0|I));u(B+96|0,B+48|0,B+96|0),_(B+96|0,B+96|0),I=1;do{_(B+96|0,B+96|0),I=I+1|0}while(5!=(0|I));u(A,B+96|0,B+144|0),y=g}function O(A,I){A|=0;var g,C,Q=0;for(g=y,C=y=y+63&-64,y=y+1760|0,eg(C,I|=0),og(C+1600|0,I),Eg(C+1280|0,C+1600|0),gI(C+1600|0,C+1280|0,C),Eg(C+1440|0,C+1600|0),eg(C+160|0,C+1440|0),gI(C+1600|0,C+1280|0,C+160|0),Eg(C+1440|0,C+1600|0),eg(C+320|0,C+1440|0),gI(C+1600|0,C+1280|0,C+320|0),Eg(C+1440|0,C+1600|0),eg(C+480|0,C+1440|0),gI(C+1600|0,C+1280|0,C+480|0),Eg(C+1440|0,C+1600|0),eg(C+640|0,C+1440|0),gI(C+1600|0,C+1280|0,C+640|0),Eg(C+1440|0,C+1600|0),eg(C+800|0,C+1440|0),gI(C+1600|0,C+1280|0,C+800|0),Eg(C+1440|0,C+1600|0),eg(C+960|0,C+1440|0),gI(C+1600|0,C+1280|0,C+960|0),Eg(C+1440|0,C+1600|0),eg(C+1120|0,C+1440|0),Og(A),Q=252;og(C+1600|0,A),(I=0|B[31840+Q>>0])<<24>>24<=0?I<<24>>24<0&&(Eg(C+1440|0,C+1600|0),II(C+1600|0,C+1440|0,C+(160*(((I<<24>>24)/-2|0)<<24>>24)|0)|0)):(Eg(C+1440|0,C+1600|0),gI(C+1600|0,C+1440|0,C+(160*((255&I)>>>1&255)|0)|0)),Eg(A,C+1600|0),Q;)Q=Q+-1|0;y=g}function Z(A,I,g,B,Q,E,i){A|=0,I|=0,g|=0,B|=0,Q|=0;var e,c,a=0,n=0;return e=y,c=y=y+63&-64,y=y+352|0,x(c,E|=0,i|=0),A>>>0>g>>>0&&0<Q>>>0|0==(0|Q)&(A-g|0)>>>0<B>>>0?n=5:g>>>0>A>>>0&&0<Q>>>0|0==(0|Q)&(g-A|0)>>>0<B>>>0?n=5:a=g,5==(0|n)&&(YI(0|A,0|g,0|B),a=A),C[c+32>>2]=0,C[c+32+4>>2]=0,C[c+32+8>>2]=0,C[c+32+12>>2]=0,C[c+32+16>>2]=0,C[c+32+20>>2]=0,C[c+32+24>>2]=0,C[c+32+28>>2]=0,0==(0|(i=Q>>>0>0|0==(0|Q)&B>>>0>32?32:B))&0==(0|(g=Q>>>0>0|0==(0|Q)&B>>>0>32?0:Q))||BA(c+32+32|0,0|a,-2-(n=~Q>>>0>4294967295|-1==(0|~Q)&~B>>>0>4294967263?~B:-33)+1|0),Yg(c+32|0,c+32|0,n=0|vg(0|i,0|g,32,0),0|o(),E+16|0,c),gB(c+96|0,c+32|0),0==(0|i)&0==(0|g)||BA(0|A,c+32+32|0,-2-(n=~Q>>>0>4294967295|-1==(0|~Q)&~B>>>0>4294967263?~B:-33)+1|0),MI(c+32|0,64),Q>>>0>0|0==(0|Q)&B>>>0>32&&_g(A+i|0,a+i|0,n=0|Ug(0|B,0|Q,0|i,0|g),0|o(),E+16|0,c),MI(c,32),bg(c+96|0,A,B,Q),IB(c+96|0,I),MI(c+96|0,256),y=e,0}function $(A,I,g,C){A|=0,I|=0,g|=0,C|=0;var E=0,i=0,e=0,c=0;A:do{if(!(0==(0|g)&0==(0|C))){for(E=Q[A+352>>0]|Q[A+352+1>>0]<<8|Q[A+352+2>>0]<<16|Q[A+352+3>>0]<<24,e=I;I=A+96+E|0,C>>>0>0|0==(0|C)&g>>>0>(c=256-E|0)>>>0;){BA(0|I,0|e,0|c),I=(Q[A+352>>0]|Q[A+352+1>>0]<<8|Q[A+352+2>>0]<<16|Q[A+352+3>>0]<<24)+c|0,B[A+352>>0]=I,B[A+352+1>>0]=I>>8,B[A+352+2>>0]=I>>16,B[A+352+3>>0]=I>>24,aA(A,128,0),s(A,A+96|0),E=A+224|0,i=128+(I=A+96|0)|0;do{B[I>>0]=0|B[E>>0],I=I+1|0,E=E+1|0}while((0|I)<(0|i));if(E=(Q[A+352>>0]|Q[A+352+1>>0]<<8|Q[A+352+2>>0]<<16|Q[A+352+3>>0]<<24)-128|0,B[A+352>>0]=E,B[A+352+1>>0]=E>>8,B[A+352+2>>0]=E>>16,B[A+352+3>>0]=E>>24,0==(0|(g=0|Ug(0|g,0|C,0|c,0)))&0==(0|(C=0|o())))break A;e=e+c|0}BA(0|I,0|e,0|g),c=(Q[A+352>>0]|Q[A+352+1>>0]<<8|Q[A+352+2>>0]<<16|Q[A+352+3>>0]<<24)+g|0,B[A+352>>0]=c,B[A+352+1>>0]=c>>8,B[A+352+2>>0]=c>>16,B[A+352+3>>0]=c>>24}}while(0)}function AA(A,I,g){var B,Q,E,i,e,o,c,a,n,r,t,f,w,y,s,h,D,F,p,u;I|=0,g|=0,u=0|C[(A|=0)>>2],F=0|C[A+4>>2],h=0|C[A+8>>2],y=0|C[A+12>>2],f=0|C[A+16>>2],r=0|C[A+20>>2],a=0|C[A+24>>2],o=0|C[A+28>>2],i=0|C[A+32>>2],Q=0|C[A+36>>2],p=0|C[I>>2],D=0|C[I+4>>2],s=0|C[I+8>>2],w=0|C[I+12>>2],t=0|C[I+16>>2],n=0|C[I+20>>2],c=0|C[I+24>>2],e=0|C[I+28>>2],E=0|C[I+32>>2],B=0|C[I+36>>2],C[A>>2]=(p^u)&0-g^u,C[A+4>>2]=(D^F)&0-g^F,C[A+8>>2]=(s^h)&0-g^h,C[A+12>>2]=(w^y)&0-g^y,C[A+16>>2]=(t^f)&0-g^f,C[A+20>>2]=(n^r)&0-g^r,C[A+24>>2]=(c^a)&0-g^a,C[A+28>>2]=(e^o)&0-g^o,C[A+32>>2]=(E^i)&0-g^i,C[A+36>>2]=(B^Q)&0-g^Q,C[I>>2]=(p^u)&0-g^p,C[I+4>>2]=(D^F)&0-g^D,C[I+8>>2]=(s^h)&0-g^s,C[I+12>>2]=(w^y)&0-g^w,C[I+16>>2]=(t^f)&0-g^t,C[I+20>>2]=(n^r)&0-g^n,C[I+24>>2]=(c^a)&0-g^c,C[I+28>>2]=(e^o)&0-g^e,C[I+32>>2]=(E^i)&0-g^E,C[I+36>>2]=(B^Q)&0-g^B}function IA(A,I,g,E,i){A|=0,E|=0,i|=0;var e,c,a=0,n=0,r=0,t=0,f=0;if(e=y,c=y=y+63&-64,y=y+112|0,!(0==(0|(I|=0))&0==(0|(g|=0)))){a=(n=c)+32|0;do{B[n>>0]=0|B[i>>0],n=n+1|0,i=i+1|0}while((0|n)<(0|a));if(n=Q[E+4>>0]|Q[E+4+1>>0]<<8|Q[E+4+2>>0]<<16|Q[E+4+3>>0]<<24,C[c+96>>2]=Q[E>>0]|Q[E+1>>0]<<8|Q[E+2>>0]<<16|Q[E+3>>0]<<24,C[c+96+4>>2]=n,C[c+96+8>>2]=0,C[c+96+8+4>>2]=0,g>>>0>0|0==(0|g)&I>>>0>63){do{for(iB(A,c+96|0,c),a=8,i=1;i=i+(0|Q[(n=c+96+a|0)>>0])|0,B[n>>0]=i,16!=(0|(a=a+1|0));)i>>>=8;I=0|vg(0|I,0|g,-64,-1),g=0|o(),A=A+64|0}while(g>>>0>0|0==(0|g)&I>>>0>63);0==(0|I)&0==(0|g)||(t=A,f=I,r=8)}else t=A,f=I,r=8;if(8==(0|r)&&(iB(c+32|0,c+96|0,c),0|f)){i=0;do{B[t+i>>0]=0|B[c+32+i>>0],i=i+1|0}while((0|i)!=(0|f))}MI(c+32|0,64),MI(c,32)}y=e}function gA(A,I,g,B,C,Q,E){A|=0,I|=0,g|=0,B|=0,C|=0;var i,e,c=0;return e=y,i=y=y+63&-64,y=y+96|0,x(i,Q|=0,E|=0),function(A,I,g){IA(A|=0,32,0,I|=0,g|=0)}(i+32|0,Q+16|0,i),0|function(A,I,g,B,C){return 0|function(A,I,g,B,C){var Q,E;return A|=0,Q=y,E=y=y+63&-64,y=y+16|0,function(A,I,g,B,C){var Q,E;A|=0,I|=0,g|=0,B|=0,Q=y,E=y=y+63&-64,y=y+96|0,MA(E,C|=0),K(E,I,g,B),z(E,A),y=Q}(E,I|=0,g|=0,B|=0,C|=0),C=0|tB(A,E),y=Q,0|C}(A|=0,I|=0,g|=0,B|=0,C|=0)}(g,I,B,C,i+32|0)?(MI(i,32),I=-1):A?(I>>>0>=A>>>0&&0<C>>>0|0==(0|C)&(I-A|0)>>>0<B>>>0?c=8:A>>>0>=I>>>0&&0<C>>>0|0==(0|C)&(A-I|0)>>>0<B>>>0?c=8:g=I,8==(0|c)&&(YI(0|A,0|I,0|B),g=A),0==(0|(I=C>>>0>0|0==(0|C)&B>>>0>32?32:B))&0==(0|(E=C>>>0>0|0==(0|C)&B>>>0>32?0:C))?Yg(i+32|0,i+32|0,32,0,Q+16|0,i):(BA(i+32+32|0,0|g,-2-(c=~C>>>0>4294967295|-1==(0|~C)&~B>>>0>4294967263?~B:-33)+1|0),Yg(i+32|0,i+32|0,0|vg(0|I,0|E,32,0),0|o(),Q+16|0,i),BA(0|A,i+32+32|0,-2-c+1|0)),C>>>0>0|0==(0|C)&B>>>0>32&&_g(A+I|0,g+I|0,0|Ug(0|B,0|C,0|I,0|E),0|o(),Q+16|0,i),MI(i,32),I=0):I=0,y=e,0|I}function BA(A,I,g){A|=0,I|=0;var Q,E,i=0;if((0|(g|=0))>=8192)return t(0|A,0|I,0|g),0|A;if(E=0|A,Q=A+g|0,(3&A)==(3&I)){for(;3&A;){if(!g)return 0|E;B[A>>0]=0|B[I>>0],A=A+1|0,I=I+1|0,g=g-1|0}for(i=(g=-4&Q|0)-64|0;(0|A)<=(0|i);)C[A>>2]=C[I>>2],C[A+4>>2]=C[I+4>>2],C[A+8>>2]=C[I+8>>2],C[A+12>>2]=C[I+12>>2],C[A+16>>2]=C[I+16>>2],C[A+20>>2]=C[I+20>>2],C[A+24>>2]=C[I+24>>2],C[A+28>>2]=C[I+28>>2],C[A+32>>2]=C[I+32>>2],C[A+36>>2]=C[I+36>>2],C[A+40>>2]=C[I+40>>2],C[A+44>>2]=C[I+44>>2],C[A+48>>2]=C[I+48>>2],C[A+52>>2]=C[I+52>>2],C[A+56>>2]=C[I+56>>2],C[A+60>>2]=C[I+60>>2],A=A+64|0,I=I+64|0;for(;(0|A)<(0|g);)C[A>>2]=C[I>>2],A=A+4|0,I=I+4|0}else for(g=Q-4|0;(0|A)<(0|g);)B[A>>0]=0|B[I>>0],B[A+1>>0]=0|B[I+1>>0],B[A+2>>0]=0|B[I+2>>0],B[A+3>>0]=0|B[I+3>>0],A=A+4|0,I=I+4|0;for(;(0|A)<(0|Q);)B[A>>0]=0|B[I>>0],A=A+1|0,I=I+1|0;return 0|E}function CA(A,I){A|=0;var g,Q,E=0;g=y,Q=y=y+63&-64,y=y+48|0,function(A,I){var g,B,Q,E,i,e,o,c,a,n,r;A|=0,a=0|C[(I|=0)>>2],r=0|C[I+4>>2],o=0|C[I+8>>2],e=0|C[I+12>>2],i=0|C[I+16>>2],n=0|C[I+20>>2],Q=0|C[I+24>>2],B=0|C[I+28>>2],g=0|C[I+32>>2],E=(((((c=((19*((((((((((((16777216+(19*(I=0|C[I+36>>2])|0)|0)>>>25)+a>>26)+r>>25)+o>>26)+e>>25)+i>>26)+n>>25)+Q>>26)+B>>25)+g>>26)+I>>25)|0)+a>>26)+r|0)>>25)+o>>26)+e>>25)+i>>26)+n|0,C[A>>2]=(19*((((((((((((16777216+(19*I|0)|0)>>>25)+a>>26)+r>>25)+o>>26)+e>>25)+i>>26)+n>>25)+Q>>26)+B>>25)+g>>26)+I>>25)|0)+a&67108863,C[A+4>>2]=33554431&c,C[A+8>>2]=(c>>25)+o&67108863,C[A+12>>2]=((c>>25)+o>>26)+e&33554431,C[A+16>>2]=(((c>>25)+o>>26)+e>>25)+i&67108863,C[A+20>>2]=33554431&E,C[A+24>>2]=(E>>25)+Q&67108863,C[A+28>>2]=((E>>25)+Q>>26)+B&33554431,C[A+32>>2]=(((E>>25)+Q>>26)+B>>25)+g&67108863,C[A+36>>2]=((((E>>25)+Q>>26)+B>>25)+g>>26)+I&33554431}(Q,I|=0),I=0|C[Q>>2],B[A>>0]=I,B[A+1>>0]=I>>>8,B[A+2>>0]=I>>>16,E=0|C[Q+4>>2],B[A+3>>0]=E<<2|I>>>24,B[A+4>>0]=E>>>6,B[A+5>>0]=E>>>14,I=0|C[Q+8>>2],B[A+6>>0]=I<<3|E>>>22,B[A+7>>0]=I>>>5,B[A+8>>0]=I>>>13,E=0|C[Q+12>>2],B[A+9>>0]=E<<5|I>>>21,B[A+10>>0]=E>>>3,B[A+11>>0]=E>>>11,I=0|C[Q+16>>2],B[A+12>>0]=I<<6|E>>>19,B[A+13>>0]=I>>>2,B[A+14>>0]=I>>>10,B[A+15>>0]=I>>>18,I=0|C[Q+20>>2],B[A+16>>0]=I,B[A+17>>0]=I>>>8,B[A+18>>0]=I>>>16,E=0|C[Q+24>>2],B[A+19>>0]=E<<1|I>>>24,B[A+20>>0]=E>>>7,B[A+21>>0]=E>>>15,I=0|C[Q+28>>2],B[A+22>>0]=I<<3|E>>>23,B[A+23>>0]=I>>>5,B[A+24>>0]=I>>>13,E=0|C[Q+32>>2],B[A+25>>0]=E<<4|I>>>21,B[A+26>>0]=E>>>4,B[A+27>>0]=E>>>12,I=0|C[Q+36>>2],B[A+28>>0]=I<<6|E>>>20,B[A+29>>0]=I>>>2,B[A+30>>0]=I>>>10,B[A+31>>0]=I>>>18,y=g}function QA(A,I,g){A|=0,I|=0,g|=0;var B,E,i=0,e=0,c=0;if(B=y,E=y=y+63&-64,y=y+4096|0,yB(E+3072|0),yB(E+2048|0),0!=(0|A)&0!=(0|I)&&(C[E+2048>>2]=C[I>>2],C[E+2048+4>>2]=0,C[E+2048+8>>2]=C[I+4>>2],C[E+2048+8+4>>2]=0,C[E+2048+16>>2]=Q[I+8>>0],C[E+2048+16+4>>2]=0,C[E+2048+24>>2]=C[A+16>>2],C[E+2048+24+4>>2]=0,C[E+2048+32>>2]=C[A+8>>2],C[E+2048+32+4>>2]=0,C[E+2048+40>>2]=C[A+36>>2],C[E+2048+40+4>>2]=0,0|C[A+20>>2])){I=0;do{(i=127&I)||(c=0|vg(0|C[E+2048+48>>2],0|C[E+2048+48+4>>2],1,0),e=0|o(),C[E+2048+48>>2]=c,C[E+2048+48+4>>2]=e,yB(E),yB(E+1024|0),H(E+3072|0,E+2048|0,E),H(E+3072|0,E,E+1024|0)),e=0|C[E+1024+(i<<3)+4>>2],C[(c=g+(I<<3)|0)>>2]=C[E+1024+(i<<3)>>2],C[c+4>>2]=e,I=I+1|0}while(I>>>0<(0|C[A+20>>2])>>>0)}y=B}function EA(A,I,g,B){A|=0,I|=0,g|=0,B|=0;var Q,E,i,e,o=0,c=0,a=0;e=y,i=y=y+63&-64,y=y+64|0,c=52+(o=i+8|0)|0;do{C[o>>2]=0,o=o+4|0}while((0|o)<(0|c));o=0|ZA(A),C[i+36>>2]=o,C[i+20>>2]=o,C[i+4>>2]=o,c=0|F(o),C[i+32>>2]=c,Q=0|F(o),C[i+16>>2]=Q,E=0|F(o),C[i>>2]=E;do{if(0==(0|c)|0==(0|Q)|0==(0|E))d(c),d(Q),d(E),o=-22;else{if(!(a=0|F(o))){d(c),d(Q),d(E),o=-22;break}if(0|(o=0|L(i,A,B))){d(0|C[i+32>>2]),d(0|C[i+16>>2]),d(0|C[i>>2]),d(a);break}B=0|nA(0|C[i+40>>2],0|C[i+44>>2],0|C[i+52>>2],I,g,0|C[i+16>>2],0|C[i+20>>2],a,0|C[i+4>>2],0,0,B),d(0|C[i+32>>2]),d(0|C[i+16>>2]),o=0==(0|B)&&0==(0|EI(a,0|C[i>>2],0|C[i+4>>2]))?0:-35,d(a),d(0|C[i>>2])}}while(0);return y=e,0|o}function iA(A,I){A|=0,I|=0;var g,C,E=0,i=0,e=0;g=y,C=y=y+63&-64,y=y+464|0,E=0;do{e=0|B[I+E>>0],B[C+(i=E<<1)>>0]=15&e,B[C+(1|i)>>0]=(255&e)>>>4,E=E+1|0}while(32!=(0|E));I=0,E=0;do{I=134217728+((i=I+(0|Q[(e=C+E|0)>>0])|0)<<24)>>28,B[e>>0]=i-(I<<4),E=E+1|0}while(63!=(0|E));B[C+63>>0]=I+(0|Q[C+63>>0]),Og(A),I=1;do{$g(C+64|0,I>>>1,0|B[C+I>>0]),CI(C+304|0,A,C+64|0),Eg(A,C+304|0),I=I+2|0}while(I>>>0<64);og(C+304|0,A),Hg(C+184|0,C+304|0),aI(C+304|0,C+184|0),Hg(C+184|0,C+304|0),aI(C+304|0,C+184|0),Hg(C+184|0,C+304|0),aI(C+304|0,C+184|0),Eg(A,C+304|0),I=0;do{$g(C+64|0,I>>>1,0|B[C+I>>0]),CI(C+304|0,A,C+64|0),Eg(A,C+304|0),I=I+2|0}while(I>>>0<64);y=g}function eA(A,I,g,B,C,Q,E,i,e,c,a){var n;A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,E|=0,i|=0,e|=0,n=y,y=y+352|0,OI(n+16|0,64,0,c|=0,a|=0),gB(n+80|0,n+16|0),MI(n+16|0,64),bg(n+80|0,E,i,e),I=0|Ug(0,0,0|i,0|e),o(),bg(n+80|0,34624,15&I,0),bg(n+80|0,g,B,C),I=0|Ug(0,0,0|B,0|C),o(),bg(n+80|0,34624,15&I,0),LI(n+336|0,i,e),bg(n+80|0,n+336|0,8,0),LI(n+336|0,B,C),bg(n+80|0,n+336|0,8,0),IB(n+80|0,n),MI(n+80|0,256),I=0|tB(n,Q),MI(n,16);do{if(A){if(I){YA(0|A,0,0|B),I=-1;break}rI(A,g,B,C,c,1,a),I=0;break}}while(0);return y=n,0|I}function oA(A){A|=0;var I=0,g=0;do{if(A)if(0|C[A>>2])if((0|C[A+4>>2])>>>0>=16){if(0==(0|C[A+8>>2])&&0|C[A+12>>2]){I=-18;break}if(I=0|C[A+20>>2],!(0|C[A+16>>2]))return 0|(0==(0|I)?-6:-19);if(I>>>0>=8){if(0==(0|C[A+24>>2])&&0|C[A+28>>2]){I=-20;break}if(0==(0|C[A+32>>2])&&0|C[A+36>>2]){I=-21;break}if((I=0|C[A+44>>2])>>>0>=8)if(I>>>0<=2097152)if(I>>>0>=(g=0|C[A+48>>2])<<3>>>0)if(0|C[A+40>>2])if(g){if(!(g>>>0>16777215))return 0|(0==(0|(A=0|C[A+52>>2]))?-28:A>>>0>16777215?-29:0);I=-17}else I=-16;else I=-12;else I=-14;else I=-15;else I=-14}else I=-6}else I=-2;else I=-1;else I=-25}while(0);return 0|I}function cA(A,I,g,Q,E){var i,e;A|=0,g|=0,Q|=0,E|=0,i=y,e=y=y+63&-64,y=y+192|0,((I|=0)-1&255)>63&&SB(),g||SB(),B[e+128>>0]=I,B[e+128+1>>0]=32,B[e+128+2>>0]=1,B[e+128+3>>0]=1,Wg(e+128+4|0),LI(e+128+8|0,0,0),C[e+128+16>>2]=0,C[e+128+16+4>>2]=0,C[e+128+16+8>>2]=0,C[e+128+16+12>>2]=0,Q?function(A,I){I|=0;var g=0;A=16+(g=32+(A|=0)|0)|0;do{B[g>>0]=0|B[I>>0],g=g+1|0,I=I+1|0}while((0|g)<(0|A))}(e+128|0,Q):(C[e+128+32>>2]=0,C[e+128+32+4>>2]=0,C[e+128+32+8>>2]=0,C[e+128+32+12>>2]=0),E?function(A,I){I|=0;var g=0;A=16+(g=48+(A|=0)|0)|0;do{B[g>>0]=0|B[I>>0],g=g+1|0,I=I+1|0}while((0|g)<(0|A))}(e+128|0,E):(C[e+128+48>>2]=0,C[e+128+48+4>>2]=0,C[e+128+48+8>>2]=0,C[e+128+48+12>>2]=0),XA(A,e+128|0),E=96+(I=e+32|0)|0;do{C[I>>2]=0,I=I+4|0}while((0|I)<(0|E));E=(I=e)+32|0;do{B[I>>0]=0|B[g>>0],I=I+1|0,g=g+1|0}while((0|I)<(0|E));$(A,e,128,0),MI(e,128),y=i}function aA(A,I,g){var C,E;I|=0,g|=0,C=0|vg(Q[64+(A|=0)>>0]|Q[A+64+1>>0]<<8|Q[A+64+2>>0]<<16|Q[A+64+3>>0]<<24|0,Q[A+64+4>>0]|Q[A+64+4+1>>0]<<8|Q[A+64+4+2>>0]<<16|Q[A+64+4+3>>0]<<24|0,0|I,0|g),E=0|o(),B[A+64>>0]=C,B[A+64+1>>0]=C>>8,B[A+64+2>>0]=C>>16,B[A+64+3>>0]=C>>24,B[A+64+4>>0]=E,B[A+64+4+1>>0]=E>>8,B[A+64+4+2>>0]=E>>16,B[A+64+4+3>>0]=E>>24,I=0|vg(Q[A+72>>0]|Q[A+72+1>>0]<<8|Q[A+72+2>>0]<<16|Q[A+72+3>>0]<<24|0,Q[A+72+4>>0]|Q[A+72+4+1>>0]<<8|Q[A+72+4+2>>0]<<16|Q[A+72+4+3>>0]<<24|0,1&(E>>>0<g>>>0|(0|E)==(0|g)&C>>>0<I>>>0)|0,0),g=0|o(),B[A+72>>0]=I,B[A+72+1>>0]=I>>8,B[A+72+2>>0]=I>>16,B[A+72+3>>0]=I>>24,B[A+72+4>>0]=g,B[A+72+4+1>>0]=g>>8,B[A+72+4+2>>0]=g>>16,B[A+72+4+3>>0]=g>>24}function nA(A,I,g,B,Q,E,i,e,o,c,a,n){var r,t,f;A|=0,I|=0,g|=0,B|=0,Q|=0,E|=0,i|=0,e|=0,c|=0,a|=0,n|=0,f=y,t=y=y+63&-64,y=y+64|0,r=0|F(o|=0);do{if(r){if(C[t>>2]=r,C[t+4>>2]=o,C[t+8>>2]=B,C[t+12>>2]=Q,C[t+16>>2]=E,C[t+20>>2]=i,C[t+24>>2]=0,C[t+24+4>>2]=0,C[t+24+8>>2]=0,C[t+24+12>>2]=0,C[t+40>>2]=A,C[t+44>>2]=I,C[t+48>>2]=g,C[t+52>>2]=g,C[t+56>>2]=0,0|(I=0|pA(t,n))){MI(r,o),d(r);break}if(0|e&&BA(0|e,0|r,0|o),0!=(0|c)&0!=(0|a)&&0|J(c,a,t,n)){MI(r,o),MI(c,a),d(r),I=-31;break}MI(r,o),d(r),I=0}else I=-22}while(0);return y=f,0|I}function rA(A,I){var g,B,C=0;return B=y,g=y=y+63&-64,y=y+288|0,U(40+(A|=0)|0,I|=0),Sg(A+80|0),_(g+240|0,A+40|0),u(g+192|0,g+240|0,16),lA(g+240|0,g+240|0,A+80|0),_A(g+192|0,g+192|0,A+80|0),_(g+144|0,g+192|0),u(g+144|0,g+144|0,g+192|0),_(A,g+144|0),u(A,A,g+192|0),u(A,A,g+240|0),function(A,I){A|=0;var g,B,C=0;g=y,B=y=y+63&-64,y=y+144|0,_(B+96|0,I|=0),_(B+48|0,B+96|0),_(B+48|0,B+48|0),u(B+48|0,I,B+48|0),u(B+96|0,B+96|0,B+48|0),_(B+96|0,B+96|0),u(B+96|0,B+48|0,B+96|0),_(B+48|0,B+96|0),C=1;do{_(B+48|0,B+48|0),C=C+1|0}while(5!=(0|C));u(B+96|0,B+48|0,B+96|0),_(B+48|0,B+96|0),C=1;do{_(B+48|0,B+48|0),C=C+1|0}while(10!=(0|C));u(B+48|0,B+48|0,B+96|0),_(B,B+48|0),C=1;do{_(B,B),C=C+1|0}while(20!=(0|C));u(B+48|0,B,B+48|0),_(B+48|0,B+48|0),C=1;do{_(B+48|0,B+48|0),C=C+1|0}while(10!=(0|C));u(B+96|0,B+48|0,B+96|0),_(B+48|0,B+96|0),C=1;do{_(B+48|0,B+48|0),C=C+1|0}while(50!=(0|C));u(B+48|0,B+48|0,B+96|0),_(B,B+48|0),C=1;do{_(B,B),C=C+1|0}while(100!=(0|C));u(B+48|0,B,B+48|0),_(B+48|0,B+48|0),C=1;do{_(B+48|0,B+48|0),C=C+1|0}while(50!=(0|C));u(B+96|0,B+48|0,B+96|0),_(B+96|0,B+96|0),_(B+96|0,B+96|0),u(A,B+96|0,I),y=g}(A,A),u(A,A,g+144|0),u(A,A,g+240|0),_(g+96|0,A),u(g+96|0,g+96|0,g+192|0),lA(g+48|0,g+96|0,g+240|0),0|cg(g+48|0)?C=4:(_A(g,g+96|0,g+240|0),0|cg(g)?(u(A,A,64),C=4):A=-1),4==(0|C)&&((0|(C=0|sg(A)))==((0|Q[I+31>>0])>>>7|0)&&xA(A,A),u(A+120|0,A,A+40|0),A=0),y=B,0|A}function tA(A,I,g){var B,Q,E,i,e,o,c,a,n,r,t,f,w,y,s,h,D,F,p;I|=0,g|=0,p=0|C[(A|=0)>>2],D=0|C[A+4>>2],s=0|C[A+8>>2],w=0|C[A+12>>2],t=0|C[A+16>>2],n=0|C[A+20>>2],c=0|C[A+24>>2],e=0|C[A+28>>2],E=0|C[A+32>>2],B=0|C[A+36>>2],F=(C[I+4>>2]^D)&0-g,h=(C[I+8>>2]^s)&0-g,y=(C[I+12>>2]^w)&0-g,f=(C[I+16>>2]^t)&0-g,r=(C[I+20>>2]^n)&0-g,a=(C[I+24>>2]^c)&0-g,o=(C[I+28>>2]^e)&0-g,i=(C[I+32>>2]^E)&0-g,Q=(C[I+36>>2]^B)&0-g,C[A>>2]=(C[I>>2]^p)&0-g^p,C[A+4>>2]=F^D,C[A+8>>2]=h^s,C[A+12>>2]=y^w,C[A+16>>2]=f^t,C[A+20>>2]=r^n,C[A+24>>2]=a^c,C[A+28>>2]=o^e,C[A+32>>2]=i^E,C[A+36>>2]=Q^B}function fA(A,I,g,B,Q,E,i,e,c,a,n,r){return A|=0,I|=0,g|=0,B|=0,Q|=0,E|=0,i|=0,e|=0,c|=0,a|=0,a=y,y=y+336|0,OI(a,64,0,n|=0,r|=0),gB(a+64|0,a),MI(a,64),bg(a+64|0,i,e,c),i=0|Ug(0,0,0|e,0|c),o(),bg(a+64|0,34624,15&i,0),rI(A,B,Q,E,n,1,r),bg(a+64|0,A,Q,E),n=0|Ug(0,0,0|Q,0|E),o(),bg(a+64|0,34624,15&n,0),LI(a+320|0,e,c),bg(a+64|0,a+320|0,8,0),LI(a+320|0,Q,E),bg(a+64|0,a+320|0,8,0),IB(a+64|0,I),MI(a+64|0,256),0|g&&(C[g>>2]=16,C[g+4>>2]=0),y=a,0}function wA(A){var I,g,E=0,i=0,e=0;I=y,g=y=y+63&-64,y=y+48|0,i=A|=0,e=(E=g)+32|0;do{B[E>>0]=0|B[i>>0],E=E+1|0,i=i+1|0}while((0|E)<(0|e));E=Q[A+36+4>>0]|Q[A+36+4+1>>0]<<8|Q[A+36+4+2>>0]<<16|Q[A+36+4+3>>0]<<24,C[g+32>>2]=Q[A+36>>0]|Q[A+36+1>>0]<<8|Q[A+36+2>>0]<<16|Q[A+36+3>>0]<<24,C[g+32+4>>2]=E,function(A,I,g,B){!function(A,I,g,B){fI(A|=0,I|=0,40,0,g|=0,0,B|=0)}(A|=0,I|=0,g|=0,B|=0)}(g,g,A+32|0,A),i=g,e=(E=A)+32|0;do{B[E>>0]=0|B[i>>0],E=E+1|0,i=i+1|0}while((0|E)<(0|e));i=0|C[g+32>>2],e=0|C[g+32+4>>2],B[A+36>>0]=i,B[A+36+1>>0]=i>>8,B[A+36+2>>0]=i>>16,B[A+36+3>>0]=i>>24,B[A+36+4>>0]=e,B[A+36+4+1>>0]=e>>8,B[A+36+4+2>>0]=e>>16,B[A+36+4+3>>0]=e>>24,Mg(A),y=I}function yA(A,I){A|=0,I|=0;var g=0,C=0,E=0,i=0,e=0;g=0;do{B[A+g>>0]=(0|Q[I+(g>>>3)>>0])>>>(7&g)&1,g=g+1|0}while(256!=(0|g));e=0;do{E=A+e|0;A:do{if(0|B[E>>0]){i=1;do{if((g=i+e|0)>>>0>=256)break A;I=0|B[A+g>>0];I:do{if(I<<24>>24){if(((C=I<<24>>24<<i)+(I=0|B[E>>0])|0)<16){B[E>>0]=C+I,B[A+g>>0]=0;break}if((I-C|0)<-15)break A;for(B[E>>0]=I-C;0|B[(I=A+g|0)>>0];)if(B[I>>0]=0,(g=g+1|0)>>>0>=256)break I;B[I>>0]=1}}while(0);i=i+1|0}while(i>>>0<7)}}while(0);e=e+1|0}while(256!=(0|e))}function sA(A,I,g,B,C,Q,E,i,e,o,c){var a;A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,E|=0,i|=0,e|=0,a=y,y=y+352|0,QB(a+16|0,o|=0,c|=0),gB(a+80|0,a+16|0),MI(a+16|0,64),bg(a+80|0,E,i,e),LI(a+336|0,i,e),bg(a+80|0,a+336|0,8,0),bg(a+80|0,g,B,C),LI(a+336|0,B,C),bg(a+80|0,a+336|0,8,0),IB(a+80|0,a),MI(a+80|0,256),I=0|tB(a,Q),MI(a,16);do{if(A){if(I){YA(0|A,0,0|B),I=-1;break}zI(A,g,B,C,o,c),I=0;break}}while(0);return y=a,0|I}function hA(A,I,g,B,Q,E,i){var e,o;A|=0,I|=0,g|=0,B|=0,Q|=0,E|=0,e=y,o=y=y+63&-64,y=y+560|0,Jg(o+192|0,i|=0),RI(o+128|0,E,32,0),P(o+192|0,o+128+32|0,32,0),P(o+192|0,g,B,Q),VI(o+192|0,o+64|0),YI(A+32|0,E+32|0,32),p(o+64|0),iA(o+400|0,o+64|0),sI(A,o+400|0),Jg(o+192|0,i),P(o+192|0,A,64,0),P(o+192|0,g,B,Q),VI(o+192|0,o),p(o),Tg(o+128|0),h(A+32|0,o,o+128|0,o+64|0),MI(o+128|0,64),MI(o+64|0,64),0|I&&(C[I>>2]=64,C[I+4>>2]=0),y=e}function DA(A,I,g,B,Q,i){A|=0,I|=0,g|=0,B|=0,Q|=0,i|=0;var e=0;do{if(I){if(e=(0|C[A+24>>2])-(0|C[A+20>>2])|0,i){e=B+-1+e|0;break}e=e+((0==(0|B))<<31>>31)|0;break}if(!(g<<24>>24)){e=B+-1|0;break}if(e=0|E(0|C[A+20>>2],255&g),i){e=B+-1+e|0;break}e=e+((0==(0|B))<<31>>31)|0;break}while(0);return Qg(0|Q,0,0|Q,0),Qg(0|o(),0,0|e,0),i=0|Ug(e+-1|0,0,0|o(),0),Q=0|o(),0==(0|I)|g<<24>>24==3?(e=0,B=0):(e=0|E(0|C[A+20>>2],1+(255&g)|0),B=0),A=0|Ag(0|(I=0|vg(0|i,0|Q,0|e,0|B)),0|(g=0|o()),0|C[A+24>>2],0),o(),0|A}function FA(A,I,g,B,Q){B|=0,Q|=0;var E,i,e,o=0;if(e=y,i=y=y+63&-64,y=y+64|0,(g|=0)>>>0>0|0==(0|g)&(I|=0)>>>0>4294967295|(E=0|ZA(A|=0))>>>0>127)C[8678]=28,g=-1;else{o=(g=i)+60|0;do{C[g>>2]=0,g=g+4|0}while((0|g)<(0|o));(o=0|function(A){var I;return(I=0|F(A|=0))&&3&C[I+-4>>2]?(YA(0|I,0,0|A),0|I):0|I}(E))?(C[i+16>>2]=o,C[i+8>>2]=o,C[i>>2]=o,C[i+20>>2]=E,C[i+12>>2]=E,C[i+4>>2]=E,C[i+24>>2]=0,C[i+24+4>>2]=0,C[i+24+8>>2]=0,C[i+24+12>>2]=0,0|L(i,A,Q)?(C[8678]=28,g=-1):g=(0|C[i+40>>2])==(0|I)?(0|C[i+44>>2])!=(B>>>10|0)&1:1,d(o)):g=-1}return y=e,0|g}function pA(A,I){I|=0;var g,B,Q=0,i=0,e=0;if(B=y,g=y=y+63&-64,y=y+48|0,!(Q=0|oA(A|=0)))if((I+-1|0)>>>0<=1){if(i=0|C[A+44>>2],Q=0|C[A+48>>2],e=0|E(i=((i>>>0<Q<<3>>>0?Q<<3:i)>>>0)/(Q<<2>>>0)|0,Q<<2),C[g>>2]=0,C[g+8>>2]=C[A+40>>2],C[g+12>>2]=-1,C[g+16>>2]=e,C[g+20>>2]=i,C[g+24>>2]=i<<2,C[g+28>>2]=Q,C[g+32>>2]=C[A+52>>2],C[g+36>>2]=I,!(Q=0|function(A,I){A|=0,I|=0;var g,B,Q=0;B=y,g=y=y+63&-64,y=y+80|0;do{if(0==(0|A)|0==(0|I))Q=-25;else{if(Q=0|F(C[A+20>>2]<<3),C[A+4>>2]=Q,Q){if(Q=0|bA(A,0|C[A+16>>2])){ug(A,0|C[I+56>>2]);break}j(g,I,0|C[A+36>>2]),MI(g+64|0,8),KA(g,A),MI(g,72),Q=0;break}Q=-22}}while(0);return y=B,0|Q}(g,A))){if(0|C[g+8>>2]){Q=0;do{UA(g,Q),Q=Q+1|0}while(Q>>>0<(0|C[g+8>>2])>>>0)}!function(A,I){var g,B,Q=0,i=0;if(g=y,B=y=y+63&-64,y=y+2048|0,0!=(0|(A|=0))&0!=(0|(I|=0))){if(fB(B+1024|0,(0|C[4+(0|C[I>>2])>>2])+(C[I+24>>2]<<10)-1024|0),(0|C[I+28>>2])>>>0>1){Q=1;do{i=(i=0|C[I+24>>2])-1+(0|E(i,Q))|0,SI(B+1024|0,(0|C[4+(0|C[I>>2])>>2])+(i<<10)|0),Q=Q+1|0}while(Q>>>0<(0|C[I+28>>2])>>>0)}!function(A,I){A|=0,I|=0;var g=0,B=0;g=0;do{LI(A+(g<<3)|0,0|C[(B=I+(g<<3)|0)>>2],0|C[B+4>>2]),g=g+1|0}while(128!=(0|g))}(B,B+1024|0),T(0|C[A>>2],0|C[A+4>>2],B,1024),MI(B+1024|0,1024),MI(B,1024),ug(I,0|C[A+56>>2])}y=g}(A,g),Q=0}}else Q=-26;return y=B,0|Q}function uA(A,I,g,B,C,Q){var E,i;return I|=0,g|=0,B|=0,C|=0,Q|=0,i=y,E=y=y+63&-64,y=y+592|0,0!=(0|pI(32+(A|=0)|0))&&0==(0|GA(A))&&0!=(0|WI(C))&&0==(0|GA(C))&&0==(0|rA(E+424|0,C))?(Jg(E+96|0,Q),P(E+96|0,A,32,0),P(E+96|0,C,32,0),P(E+96|0,I,g,B),VI(E+96|0,E+32|0),p(E+32|0),N(E+304|0,E+32|0,E+424|0,A+32|0),sI(E,E+304|0),g=0|rB(E,A),g=0|((0|E)==(0|A)?-1:g)|EI(A,E,32)):g=-1,y=i,0|g}function HA(A,I){A|=0,I|=0;var g=0,Q=0;A:do{if(255&I){if(3&A)do{if((Q=0|B[A>>0])<<24>>24==0||Q<<24>>24==(255&I)<<24>>24)break A;A=A+1|0}while(0!=(3&A|0));Q=0|E(255&I,16843009),g=0|C[A>>2];I:do{if(!((-2139062144&g^-2139062144)&g+-16843009))do{if((-2139062144&(g^=Q)^-2139062144)&g+-16843009|0)break I;g=0|C[(A=A+4|0)>>2]}while(!((-2139062144&g^-2139062144)&g+-16843009|0))}while(0);for(;(Q=0|B[A>>0])<<24>>24!=0&&Q<<24>>24!=(255&I)<<24>>24;)A=A+1|0}else A=A+(0|ZA(A))|0}while(0);return 0|A}function kA(A,I){I|=0;var g,Q=0,E=0;g=y,y=y+192|0,PI(A|=0),E=128+(Q=g+64|0)|0;do{C[Q>>2]=909522486,Q=Q+4|0}while((0|Q)<(0|E));B[g+64>>0]=54^B[I>>0],Q=1;do{B[(E=g+64+Q|0)>>0]=B[E>>0]^B[I+Q>>0],Q=Q+1|0}while(32!=(0|Q));P(A,g+64|0,128,0),PI(A+208|0),E=128+(Q=g+64|0)|0;do{C[Q>>2]=1549556828,Q=Q+4|0}while((0|Q)<(0|E));B[g+64>>0]=92^B[I>>0],Q=1;do{B[(E=g+64+Q|0)>>0]=B[E>>0]^B[I+Q>>0],Q=Q+1|0}while(32!=(0|Q));P(A+208|0,g+64|0,128,0),MI(g+64|0,128),MI(g,64),y=g}function lA(A,I,g){var B,Q,E,i,e,o,c,a,n;A|=0,g|=0,n=(0|C[4+(I|=0)>>2])-(0|C[g+4>>2])|0,a=(0|C[I+8>>2])-(0|C[g+8>>2])|0,c=(0|C[I+12>>2])-(0|C[g+12>>2])|0,o=(0|C[I+16>>2])-(0|C[g+16>>2])|0,e=(0|C[I+20>>2])-(0|C[g+20>>2])|0,i=(0|C[I+24>>2])-(0|C[g+24>>2])|0,E=(0|C[I+28>>2])-(0|C[g+28>>2])|0,Q=(0|C[I+32>>2])-(0|C[g+32>>2])|0,B=(0|C[I+36>>2])-(0|C[g+36>>2])|0,C[A>>2]=(0|C[I>>2])-(0|C[g>>2]),C[A+4>>2]=n,C[A+8>>2]=a,C[A+12>>2]=c,C[A+16>>2]=o,C[A+20>>2]=e,C[A+24>>2]=i,C[A+28>>2]=E,C[A+32>>2]=Q,C[A+36>>2]=B}function _A(A,I,g){var B,Q,E,i,e,o,c,a,n;A|=0,I|=0,n=(0|C[4+(g|=0)>>2])+(0|C[I+4>>2])|0,a=(0|C[g+8>>2])+(0|C[I+8>>2])|0,c=(0|C[g+12>>2])+(0|C[I+12>>2])|0,o=(0|C[g+16>>2])+(0|C[I+16>>2])|0,e=(0|C[g+20>>2])+(0|C[I+20>>2])|0,i=(0|C[g+24>>2])+(0|C[I+24>>2])|0,E=(0|C[g+28>>2])+(0|C[I+28>>2])|0,Q=(0|C[g+32>>2])+(0|C[I+32>>2])|0,B=(0|C[g+36>>2])+(0|C[I+36>>2])|0,C[A>>2]=(0|C[g>>2])+(0|C[I>>2]),C[A+4>>2]=n,C[A+8>>2]=a,C[A+12>>2]=c,C[A+16>>2]=o,C[A+20>>2]=e,C[A+24>>2]=i,C[A+28>>2]=E,C[A+32>>2]=Q,C[A+36>>2]=B}function GA(A){A|=0;var I,g,C=0,E=0,i=0,e=0;I=y,g=y=y+63&-64,y=y+16|0,B[g>>0]=0,B[g+1>>0]=0,B[g+2>>0]=0,B[g+3>>0]=0,B[g+4>>0]=0,B[g+5>>0]=0,B[g+6>>0]=0,i=0;do{C=0|B[A+i>>0],E=0;do{B[(e=g+E|0)>>0]=B[e>>0]|B[32096+(E<<5)+i>>0]^C,E=E+1|0}while(7!=(0|E));i=i+1|0}while(31!=(0|i));C=127&B[A+31>>0],E=0;do{B[(e=g+E|0)>>0]=B[e>>0]|C^B[32096+(E<<5)+31>>0],E=E+1|0}while(7!=(0|E));C=0,E=0;do{E=(0|Q[g+C>>0])-1|E,C=C+1|0}while(7!=(0|C));return y=I,E>>>8&1|0}function dA(A,I,g,B,Q,E,i,e,o,c,a,n){return A|=0,I|=0,g|=0,B|=0,Q|=0,E|=0,i|=0,e|=0,o|=0,c|=0,c=y,y=y+336|0,QB(c,a|=0,n|=0),gB(c+64|0,c),MI(c,64),bg(c+64|0,i,e,o),LI(c+320|0,e,o),bg(c+64|0,c+320|0,8,0),zI(A,B,Q,E,a,n),bg(c+64|0,A,Q,E),LI(c+320|0,Q,E),bg(c+64|0,c+320|0,8,0),IB(c+64|0,I),MI(c+64|0,256),0|g&&(C[g>>2]=16,C[g+4>>2]=0),y=c,0}function YA(A,I,g){I|=0;var Q,E=0;if(Q=(A|=0)+(g|=0)|0,I&=255,(0|g)>=67){for(;3&A;)B[A>>0]=I,A=A+1|0;for(E=I|I<<8|I<<16|I<<24;(0|A)<=((-4&Q)-64|0);)C[A>>2]=E,C[A+4>>2]=E,C[A+8>>2]=E,C[A+12>>2]=E,C[A+16>>2]=E,C[A+20>>2]=E,C[A+24>>2]=E,C[A+28>>2]=E,C[A+32>>2]=E,C[A+36>>2]=E,C[A+40>>2]=E,C[A+44>>2]=E,C[A+48>>2]=E,C[A+52>>2]=E,C[A+56>>2]=E,C[A+60>>2]=E,A=A+64|0;for(;(0|A)<(-4&Q|0);)C[A>>2]=E,A=A+4|0}for(;(0|A)<(0|Q);)B[A>>0]=I,A=A+1|0;return Q-g|0}function MA(A,I){A|=0;var g=0;g=67108863&(0|Vg(I|=0)),C[A>>2]=g,g=(0|Vg(I+3|0))>>>2&67108611,C[A+4>>2]=g,g=(0|Vg(I+6|0))>>>4&67092735,C[A+8>>2]=g,g=(0|Vg(I+9|0))>>>6&66076671,C[A+12>>2]=g,g=(0|Vg(I+12|0))>>>8&1048575,C[A+16>>2]=g,C[A+20>>2]=0,C[A+20+4>>2]=0,C[A+20+8>>2]=0,C[A+20+12>>2]=0,C[A+20+16>>2]=0,g=0|Vg(I+16|0),C[A+40>>2]=g,g=0|Vg(I+20|0),C[A+44>>2]=g,g=0|Vg(I+24|0),C[A+48>>2]=g,I=0|Vg(I+28|0),C[A+52>>2]=I,C[A+56>>2]=0,C[A+56+4>>2]=0,B[A+80>>0]=0}function SA(A,I,g,B,Q,E){A|=0,I|=0,g|=0,B|=0,Q|=0,E|=0;var i=0,e=0,c=0;do{if(Q>>>0<0|0==(0|Q)&B>>>0<64||(i=0|vg(0|B,0|Q,-64,-1),(e=0|o())>>>0>0|0==(0|e)&i>>>0>4294967231))c=10;else{if(0|dg(g,g+64|0,i,e,E)){if(!A){c=10;break}YA(0|A,0,0|i),c=10;break}0|I&&(C[I>>2]=i,C[I+4>>2]=e),A?(YI(0|A,g+64|0,0|i),B=0):B=0}}while(0);return 10==(0|c)&&(I?(C[I>>2]=0,C[I+4>>2]=0,B=-1):B=-1),0|B}function UA(A,I){I|=0;var g,Q,E=0,i=0;if(g=y,Q=y=y+63&-64,y=y+32|0,0|(A|=0)&&0|(E=0|C[A+28>>2])){C[Q>>2]=I,i=0;do{if(B[Q+8>>0]=i,E){I=0;do{C[Q+4>>2]=I,C[Q+12>>2]=0,C[Q+16>>2]=C[Q>>2],C[Q+16+4>>2]=C[Q+4>>2],C[Q+16+8>>2]=C[Q+8>>2],C[Q+16+12>>2]=C[Q+12>>2],X(A,Q+16|0),I=I+1|0,E=0|C[A+28>>2]}while(I>>>0<E>>>0)}else E=0;i=i+1|0}while(4!=(0|i))}y=g}function vA(A,I,g,Q){A|=0,g|=0,Q|=0;var E,i,e=0;if(E=y,i=y=y+63&-64,y=y+192|0,((I|=0)-1&255)>63&&SB(),!((Q+-1&255)>63|0==(0|g))){B[i+128>>0]=I,B[i+128+1>>0]=Q,B[i+128+2>>0]=1,B[i+128+3>>0]=1,Wg(i+128+4|0),LI(i+128+8|0,0,0),e=48+(I=i+128+16|0)|0;do{C[I>>2]=0,I=I+4|0}while((0|I)<(0|e));return XA(A,i+128|0),YA(i+(255&Q)|0,0,128-(255&Q)|0),BA(0|i,0|g,255&Q|0),$(A,i,128,0),MI(i,128),void(y=E)}SB()}function bA(A,I){A|=0,I|=0;var g,B,Q=0;B=y,g=y=y+63&-64,y=y+16|0;do{if(0!=(0|A)&&0!=(0|I)&&1024==(0|(I<<10>>>0)/(I>>>0))&&(Q=0|F(12),C[A>>2]=Q,0!=(0|Q))){if(C[Q+4>>2]=0,C[Q>>2]=0,Q=0|wg(g,I<<10),C[8678]=Q,Q)C[g>>2]=0;else if(0|(Q=0|C[g>>2])){C[C[A>>2]>>2]=Q,C[4+(0|C[A>>2])>>2]=Q,C[8+(0|C[A>>2])>>2]=I<<10,Q=0;break}d(0|C[A>>2]),C[A>>2]=0,Q=-22}else Q=-22}while(0);return y=B,0|Q}function JA(A,I,g,B,E,i){var e,o,c;return A|=0,I|=0,g|=0,B|=0,i|=0,o=y,e=y=y+63&-64,y=y+32|0,c=Q[4+(E|=0)>>0]|Q[E+4+1>>0]<<8|Q[E+4+2>>0]<<16|Q[E+4+3>>0]<<24,C[e+16>>2]=Q[E>>0]|Q[E+1>>0]<<8|Q[E+2>>0]<<16|Q[E+3>>0]<<24,C[e+16+4>>2]=c,C[e+16+8>>2]=0,C[e+16+8+4>>2]=0,LI(e,g,B),C[e+8>>2]=0,C[e+8+4>>2]=0,(I+-16|0)>>>0>48?(C[8678]=28,g=-1):g=0|function(A,I,g,B,C){return g|=0,((I|=0)-1|0)>>>0>63?g=-1:(function(A,I,g,B,C){var Q,E;if(I|=0,g|=0,B|=0,C|=0,Q=y,E=y=y+63&-64,y=y+368|0,(A|=0)||SB(),(g+-1&255)>63&&SB(),I)return cA(E,g,I,B,C),$(E,0,0,0),b(E,A,g),void(y=Q);SB()}(A|=0,g,255&I,B|=0,C|=0),g=0),0|g}(A,I,i,e,e+16|0),y=o,0|g}function PA(A,I,g,B,E,i,e,c,a,n,r){var t;return A|=0,I|=0,g|=0,B|=0,E|=0,i|=0,e|=0,c|=0,a|=0,n|=0,r|=0,t=y,y=y+48|0,C[t+32>>2]=0,R(t,n,r),I=Q[n+16+4>>0]|Q[n+16+4+1>>0]<<8|Q[n+16+4+2>>0]<<16|Q[n+16+4+3>>0]<<24,C[t+32+4>>2]=Q[n+16>>0]|Q[n+16+1>>0]<<8|Q[n+16+2>>0]<<16|Q[n+16+3>>0]<<24,C[t+32+4+4>>2]=I,I=0|function(A,I,g,B,C,Q,E,i,e,c){var a;A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,E|=0,i|=0,a=y,y=y+352|0,gg(a+16|0,64,0,e|=0,c|=0),gB(a+80|0,a+16|0),MI(a+16|0,64),bg(a+80|0,Q,E,i),Q=0|Ug(0,0,0|E,0|i),o(),bg(a+80|0,34640,15&Q,0),bg(a+80|0,I,g,B),Q=0|Ug(0,0,0|g,0|B),o(),bg(a+80|0,34640,15&Q,0),LI(a+336|0,E,i),bg(a+80|0,a+336|0,8,0),LI(a+336|0,g,B),bg(a+80|0,a+336|0,8,0),IB(a+80|0,a),MI(a+80|0,256),E=0|tB(a,C),MI(a,16);do{if(A){if(E){YA(0|A,0,0|g),E=-1;break}mI(A,I,g,B,e,1,c),E=0;break}}while(0);return y=a,0|E}(A,g,B,E,i,e,c,a,t+32|0,t),MI(t,32),y=t,0|I}function RA(A,I,g,Q,E,i,e){I|=0,g|=0,Q|=0,E|=0,i|=0,e|=0;var o,c,a,n=0;a=y,o=y=y+63&-64,y=y+16|0,c=128+(n=A|=0)|0;do{B[n>>0]=0,n=n+1|0}while((0|n)<(0|c));do{if(!((i|Q)>>>0>0|0==(i|Q|0)&(E|g)>>>0>4294967295|e>>>0>2147483648)){if(i>>>0<0|0==(0|i)&E>>>0<3|e>>>0<8192){C[8678]=28,g=-1;break}Cg(o,16),g=(0!=(0|Gg(E,e>>>10,I,g,o,A)))<<31>>31;break}C[8678]=22,g=-1}while(0);return y=a,0|g}function NA(A,I,g,B,E,i,e,c,a,n,r,t){return A|=0,I|=0,g|=0,B|=0,E|=0,i|=0,e|=0,c|=0,a|=0,n|=0,r|=0,t|=0,n=y,y=y+48|0,C[n+32>>2]=0,R(n,r,t),t=Q[r+16+4>>0]|Q[r+16+4+1>>0]<<8|Q[r+16+4+2>>0]<<16|Q[r+16+4+3>>0]<<24,C[n+32+4>>2]=Q[r+16>>0]|Q[r+16+1>>0]<<8|Q[r+16+2>>0]<<16|Q[r+16+3>>0]<<24,C[n+32+4+4>>2]=t,function(A,I,g,B,Q,E,i,e,c,a,n){var r;A|=0,I|=0,g|=0,B|=0,Q|=0,E|=0,i|=0,e|=0,c|=0,r=y,y=y+336|0,gg(r,64,0,a|=0,n|=0),gB(r+64|0,r),MI(r,64),bg(r+64|0,i,e,c),i=0|Ug(0,0,0|e,0|c),o(),bg(r+64|0,34640,15&i,0),mI(A,B,Q,E,a,1,n),bg(r+64|0,A,Q,E),a=0|Ug(0,0,0|Q,0|E),o(),bg(r+64|0,34640,15&a,0),LI(r+320|0,e,c),bg(r+64|0,r+320|0,8,0),LI(r+320|0,Q,E),bg(r+64|0,r+320|0,8,0),IB(r+64|0,I),MI(r+64|0,256),0|g&&(C[g>>2]=16,C[g+4>>2]=0),y=r}(A,I,g,B,E,i,e,c,a,n+32|0,n),MI(n,32),y=n,0}function mA(A,I,g,Q,E){A|=0,I|=0,g|=0,Q|=0,E|=0;var i=0,e=0;A:do{if(E){for(e=0|C[g>>2];;){if(e>>>0>=I>>>0){i=4;break}if((i=0|B[A+e>>0])<<24>>24!=61){if(!Q){i=9;break}if(!(0|qg(Q,i<<24>>24))){i=9;break}}else E=E+-1|0;if(e=e+1|0,C[g>>2]=e,!E){E=0;break A}}if(4==(0|i)){C[8678]=68,E=-1;break}if(9==(0|i)){C[8678]=28,E=-1;break}}else E=0}while(0);return 0|E}function LA(A,I,g,Q,E,i,e){I|=0,g|=0,Q|=0,E|=0,i|=0,e|=0;var o,c,a,n=0;a=y,o=y=y+63&-64,y=y+16|0,c=128+(n=A|=0)|0;do{B[n>>0]=0,n=n+1|0}while((0|n)<(0|c));do{if(!((i|Q)>>>0>0|0==(i|Q|0)&(E|g)>>>0>4294967295|e>>>0>2147483648)){if(0==(0|E)&0==(0|i)|e>>>0<8192){C[8678]=28,g=-1;break}Cg(o,16),g=(0!=(0|lg(E,e>>>10,I,g,o,A)))<<31>>31;break}C[8678]=22,g=-1}while(0);return y=a,0|g}function xA(A,I){var g,B,Q,E,i,e,o,c,a;A|=0,a=0-(0|C[4+(I|=0)>>2])|0,c=0-(0|C[I+8>>2])|0,o=0-(0|C[I+12>>2])|0,e=0-(0|C[I+16>>2])|0,i=0-(0|C[I+20>>2])|0,E=0-(0|C[I+24>>2])|0,Q=0-(0|C[I+28>>2])|0,B=0-(0|C[I+32>>2])|0,g=0-(0|C[I+36>>2])|0,C[A>>2]=0-(0|C[I>>2]),C[A+4>>2]=a,C[A+8>>2]=c,C[A+12>>2]=o,C[A+16>>2]=e,C[A+20>>2]=i,C[A+24>>2]=E,C[A+28>>2]=Q,C[A+32>>2]=B,C[A+36>>2]=g}function KA(A,I){A|=0;var g,B,Q=0;if(g=y,B=y=y+63&-64,y=y+1024|0,0|C[28+(I|=0)>>2]){Q=0;do{Pg(A+64|0,0),Pg(A+68|0,Q),T(B,1024,A,72),xI((0|C[4+(0|C[I>>2])>>2])+((0|E(0|C[I+24>>2],Q))<<10)|0,B),Pg(A+64|0,1),T(B,1024,A,72),xI((0|C[4+(0|C[I>>2])>>2])+(1+(0|E(0|C[I+24>>2],Q))<<10)|0,B),Q=Q+1|0}while(Q>>>0<(0|C[I+28>>2])>>>0)}MI(B,1024),y=g}function XA(A,I){I|=0;var g=0,C=0,E=0,i=0;!function(A){var I,g=0,C=0;C=32352,I=64+(g=A|=0)|0;do{B[g>>0]=0|B[C>>0],g=g+1|0,C=C+1|0}while((0|g)<(0|I));YA(A+64|0,0,293)}(A|=0),g=0;do{i=0|qI(I+(g<<3)|0),E=0|o(),i=(Q[(C=A+(g<<3)|0)>>0]|Q[C+1>>0]<<8|Q[C+2>>0]<<16|Q[C+3>>0]<<24)^i,E=(Q[C+4>>0]|Q[C+4+1>>0]<<8|Q[C+4+2>>0]<<16|Q[C+4+3>>0]<<24)^E,B[C>>0]=i,B[C+1>>0]=i>>8,B[C+2>>0]=i>>16,B[C+3>>0]=i>>24,B[C+4>>0]=E,B[C+4+1>>0]=E>>8,B[C+4+2>>0]=E>>16,B[C+4+3>>0]=E>>24,g=g+1|0}while(8!=(0|g))}function jA(A){var I,g,B,C,E,i,c=0;return E=0|Q[7+(A|=0)>>0],i=0|rg(0|Q[A+6>>0],0,8),c=0|o(),C=0|rg(0|Q[A+5>>0],0,16),c=0|c|o(),B=0|rg(0|Q[A+4>>0],0,24),c=0|(c=0|c|o())|Q[A+3>>0],g=0|rg(0|Q[A+2>>0],0,40),c=0|c|o(),I=0|rg(0|Q[A+1>>0],0,48),c=0|c|o(),A=0|rg(0|Q[A>>0],0,56),e(0|c|o()|0),i|E|C|B|g|I|A|0}function TA(A,I,g,B,Q,E){I|=0,Q|=0,E|=0;var i,e=0;return i=y,e=y=y+63&-64,y=y+16|0,YI(64+(A|=0)|0,0|(g|=0),0|(B|=0)),kg(A,e,A+64|0,B,Q,E),64==(0|C[e>>2])&0==(0|C[e+4>>2])?0|I?(e=0|vg(0|B,0|Q,64,0),B=0|o(),C[I>>2]=e,C[I+4>>2]=B,B=0):B=0:(0|I&&(C[I>>2]=0,C[I+4>>2]=0),YA(0|A,0,B+64|0),B=-1),y=i,0|B}function qA(A,I){I|=0;var g,Q=0,E=0,i=0,e=0;g=0|B[(A|=0)>>0];A:do{if((g+-48&255)<=9){for(E=g,i=0,e=A;;){if(!(i>>>0<429496730&((E=(E<<24>>24)-48|0)>>>0>~(Q=10*i|0)>>>0^1))){Q=0;break A}if(i=(E>>>0>~Q>>>0?0:E)+Q|0,((E=0|B[(Q=e+1|0)>>0])-48&255)>9)break;e=Q}(0|Q)!=(0|A)&&(0|e)==(0|A)|g<<24>>24!=48?C[I>>2]=i:Q=0}else Q=0}while(0);return 0|Q}function VA(A){return((0-((0-(95^(A|=0))|0)>>>8&63^63|(0-(45^A)|0)>>>8&62^62|((A+65439|0)>>>8^255)&A+185&((122-A|0)>>>8&255^255)|((A+-65|0)>>>8^255)&A+-65&((90-A|0)>>>8&255^255)|((A+65488|0)>>>8^255)&A+4&((57-A|0)>>>8&255^255))|0)>>>8&255^255)&(0-(65^A)|0)>>>8|(0-(95^A)|0)>>>8&63^63|(0-(45^A)|0)>>>8&62^62|((A+65439|0)>>>8^255)&A+185&((122-A|0)>>>8&255^255)|((A+-65|0)>>>8^255)&A+-65&((90-A|0)>>>8&255^255)|((A+65488|0)>>>8^255)&A+4&((57-A|0)>>>8&255^255)|0}function zA(A){return((0-((0-(47^(A|=0))|0)>>>8&63^63|(0-(43^A)|0)>>>8&62^62|((A+65439|0)>>>8^255)&A+185&((122-A|0)>>>8&255^255)|((A+-65|0)>>>8^255)&A+-65&((90-A|0)>>>8&255^255)|((A+65488|0)>>>8^255)&A+4&((57-A|0)>>>8&255^255))|0)>>>8&255^255)&(0-(65^A)|0)>>>8|(0-(47^A)|0)>>>8&63^63|(0-(43^A)|0)>>>8&62^62|((A+65439|0)>>>8^255)&A+185&((122-A|0)>>>8&255^255)|((A+-65|0)>>>8^255)&A+-65&((90-A|0)>>>8&255^255)|((A+65488|0)>>>8^255)&A+4&((57-A|0)>>>8&255^255)|0}function WA(A,I){I|=0;var g=0,B=0;if(g=0|yg(0|C[72+(A|=0)>>2],0|C[A+72+4>>2],3),o(),(127&g)>>>0<112)112-(127&g)|0&&BA(A+80+(127&g)|0,33056,112-(127&g)|0);else{128-(127&g)|0&&BA(A+80+(127&g)|0,33056,128-(127&g)|0),D(A,A+80|0,I,I+640|0),B=112+(g=A+80|0)|0;do{C[g>>2]=0,g=g+4|0}while((0|g)<(0|B))}NI(A+192|0,A+64|0,16),D(A,A+80|0,I,I+640|0)}function OA(A,I){var g,B,Q,E,i,e,o,c,a;A|=0,a=0|C[4+(I|=0)>>2],c=0|C[I+8>>2],o=0|C[I+12>>2],e=0|C[I+16>>2],i=0|C[I+20>>2],E=0|C[I+24>>2],Q=0|C[I+28>>2],B=0|C[I+32>>2],g=0|C[I+36>>2],C[A>>2]=C[I>>2],C[A+4>>2]=a,C[A+8>>2]=c,C[A+12>>2]=o,C[A+16>>2]=e,C[A+20>>2]=i,C[A+24>>2]=E,C[A+28>>2]=Q,C[A+32>>2]=B,C[A+36>>2]=g}function ZA(A){A|=0;var I=0,g=0,Q=0;A:do{if(3&A)for(I=A,g=A;;){if(!(0|B[g>>0]))break A;if(!(3&(I=g=g+1|0))){I=g,Q=5;break}}else I=A,Q=5}while(0);if(5==(0|Q)){for(;!((-2139062144&(g=0|C[I>>2])^-2139062144)&g+-16843009);)I=I+4|0;if((255&g)<<24>>24)do{I=I+1|0}while(0!=(0|B[I>>0]))}return I-A|0}function $A(A,I){I|=0;var g=0;C[(A|=0)>>2]=1634760805,C[A+4>>2]=857760878,C[A+8>>2]=2036477234,C[A+12>>2]=1797285236,g=0|Vg(I),C[A+16>>2]=g,g=0|Vg(I+4|0),C[A+20>>2]=g,g=0|Vg(I+8|0),C[A+24>>2]=g,g=0|Vg(I+12|0),C[A+28>>2]=g,g=0|Vg(I+16|0),C[A+32>>2]=g,g=0|Vg(I+20|0),C[A+36>>2]=g,g=0|Vg(I+24|0),C[A+40>>2]=g,I=0|Vg(I+28|0),C[A+44>>2]=I}function AI(A,I,g){I|=0,g|=0;var C=0;B[7+(A|=0)>>0]=I,C=0|yg(0|I,0|g,8),o(),B[A+6>>0]=C,C=0|yg(0|I,0|g,16),o(),B[A+5>>0]=C,C=0|yg(0|I,0|g,24),o(),B[A+4>>0]=C,B[A+3>>0]=g,C=0|yg(0|I,0|g,40),o(),B[A+2>>0]=C,C=0|yg(0|I,0|g,48),o(),B[A+1>>0]=C,g=0|yg(0|I,0|g,56),o(),B[A>>0]=g}function II(A,I,g){var B,C;g|=0,B=y,C=y=y+63&-64,y=y+48|0,_A(A|=0,40+(I|=0)|0,I),lA(A+40|0,I+40|0,I),u(A+80|0,A,g+40|0),u(A+40|0,A+40|0,g),u(A+120|0,g+120|0,I+120|0),u(A,I+80|0,g+80|0),_A(C,A,A),lA(A,A+80|0,A+40|0),_A(A+40|0,A+80|0,A+40|0),lA(A+80|0,C,A+120|0),_A(A+120|0,C,A+120|0),y=B}function gI(A,I,g){var B,C;g|=0,B=y,C=y=y+63&-64,y=y+48|0,_A(A|=0,40+(I|=0)|0,I),lA(A+40|0,I+40|0,I),u(A+80|0,A,g),u(A+40|0,A+40|0,g+40|0),u(A+120|0,g+120|0,I+120|0),u(A,I+80|0,g+80|0),_A(C,A,A),lA(A,A+80|0,A+40|0),_A(A+40|0,A+80|0,A+40|0),_A(A+80|0,C,A+120|0),lA(A+120|0,C,A+120|0),y=B}function BI(A,I,g){var B,C;g|=0,B=y,C=y=y+63&-64,y=y+48|0,_A(A|=0,40+(I|=0)|0,I),lA(A+40|0,I+40|0,I),u(A+80|0,A,g+40|0),u(A+40|0,A+40|0,g),u(A+120|0,g+80|0,I+120|0),_A(C,I+80|0,I+80|0),lA(A,A+80|0,A+40|0),_A(A+40|0,A+80|0,A+40|0),lA(A+80|0,C,A+120|0),_A(A+120|0,C,A+120|0),y=B}function CI(A,I,g){var B,C;g|=0,B=y,C=y=y+63&-64,y=y+48|0,_A(A|=0,40+(I|=0)|0,I),lA(A+40|0,I+40|0,I),u(A+80|0,A,g),u(A+40|0,A+40|0,g+40|0),u(A+120|0,g+80|0,I+120|0),_A(C,I+80|0,I+80|0),lA(A,A+80|0,A+40|0),_A(A+40|0,A+80|0,A+40|0),_A(A+80|0,C,A+120|0),lA(A+120|0,C,A+120|0),y=B}function QI(A,I){A|=0,I|=0;var g,C,Q=0;g=y,C=y=y+63&-64,y=y+208|0,Q=0;do{B[A+Q>>0]=0|B[I+Q>>0],Q=Q+1|0}while(32!=(0|Q));return B[A>>0]=-8&B[A>>0],B[A+31>>0]=63&B[A+31>>0]|64,iA(C+40|0,A),function(A,I,g){var B,C;A|=0,B=y,C=y=y+63&-64,y=y+96|0,_A(C+48|0,g|=0,I|=0),lA(C,g,I),W(C,C),u(A,C+48|0,C),y=B}(C,C+40+40|0,C+40+80|0),CA(A,C),y=g,0}function EI(A,I,g){var E,i;if(A|=0,I|=0,g|=0,E=y,i=y=y+63&-64,y=y+16|0,C[i+4>>2]=A,C[i>>2]=I,B[i+8>>0]=0,0|g){A=0;do{B[i+8>>0]=B[i+8>>0]|B[(0|C[i>>2])+A>>0]^B[(0|C[i+4>>2])+A>>0],A=A+1|0}while((0|A)!=(0|g))}return y=E,((511+(0|Q[i+8>>0])|0)>>>8&1)-1|0}function iI(A,I){A|=0;var g,Q,E=0;if(g=y,Q=y=y+63&-64,y=y+64|0,!(((I|=0)-1&255)>63)){B[Q>>0]=I,B[Q+1>>0]=0,B[Q+2>>0]=1,B[Q+3>>0]=1,Wg(Q+4|0),LI(Q+8|0,0,0),E=48+(I=Q+16|0)|0;do{C[I>>2]=0,I=I+4|0}while((0|I)<(0|E));return XA(A,Q),void(y=g)}SB()}function eI(A,I,g){var Q,E;A|=0,I|=0,g|=0,Q=y,E=y=y+63&-64,y=y+16|0,C[E+8>>2]=A,C[E+4>>2]=I,C[E>>2]=0,A=0;do{C[E>>2]=C[E>>2]|255&(B[(0|C[E+4>>2])+A>>0]^B[(0|C[E+8>>2])+A>>0]),A=A+1|0}while((0|A)!=(0|g));return y=Q,((511+(0|C[E>>2])|0)>>>8&1)-1|0}function oI(A,I,g){I|=0,g|=0;var C=0,E=0;C=0|B[(A|=0)>>0];A:do{if(C<<24>>24)for(;;){if(g=g+-1|0,!(C<<24>>24==(E=0|B[I>>0])<<24>>24&0!=(0|g)&E<<24>>24!=0))break A;if(I=I+1|0,!((C=0|B[(A=A+1|0)>>0])<<24>>24)){C=0;break}}else C=0}while(0);return(255&C)-(0|Q[I>>0])|0}function cI(A,I){A|=0,I|=0;var g,C,Q=0,i=0,e=0,o=0;for(g=y,C=y=y+63&-64,y=y+16|0,i=10;o=255&((e=I)+(0|E(I=(I>>>0)/10|0,-10))|48),B[C+(Q=i+-1|0)>>0]=o,e>>>0>9&0!=(0|Q);)i=Q;BA(0|A,C+Q|0,0|(o=11-i|0)),B[A+o>>0]=0,y=g}function aI(A,I){var g,B;g=y,B=y=y+63&-64,y=y+48|0,_(A|=0,I|=0),_(A+80|0,I+40|0),l(A+120|0,I+80|0),_A(A+40|0,I,I+40|0),_(B,A+40|0),_A(A+40|0,A+80|0,A),lA(A+80|0,A+80|0,A),lA(A,B,A+40|0),lA(A+120|0,A+120|0,A+80|0),y=g}function nI(A,I,g){var C,E;if(A|=0,I|=0,g|=0,E=y,C=y=y+63&-64,y=y+16|0,B[C>>0]=0,0|function(A,I,g){A|=0,I|=0;var C,E,i=0;if(E=y,C=y=y+63&-64,y=y+336|0,0|function(A){A|=0;var I,g,C=0,E=0,i=0,e=0;I=y,g=y=y+63&-64,y=y+16|0,B[g>>0]=0,B[g+1>>0]=0,B[g+2>>0]=0,B[g+3>>0]=0,B[g+4>>0]=0,B[g+5>>0]=0,B[g+6>>0]=0,i=0;do{C=0|B[A+i>>0],E=0;do{B[(e=g+E|0)>>0]=B[e>>0]|B[33184+(E<<5)+i>>0]^C,E=E+1|0}while(7!=(0|E));i=i+1|0}while(31!=(0|i));C=127&B[A+31>>0],E=0;do{B[(e=g+E|0)>>0]=B[e>>0]|C^B[33184+(E<<5)+31>>0],E=E+1|0}while(7!=(0|E));C=0,E=0;do{E=(0|Q[g+C>>0])-1|E,C=C+1|0}while(7!=(0|C));return y=I,E>>>8&1|0}(g|=0))i=-1;else{i=0;do{B[A+i>>0]=0|B[I+i>>0],i=i+1|0}while(32!=(0|i));for(B[A>>0]=-8&B[A>>0],B[A+31>>0]=63&B[A+31>>0]|64,U(C+288|0,g),Sg(C+240|0),Kg(C+192|0),OA(C+144|0,C+288|0),Sg(C+96|0),i=254,I=0;g=I,AA(C+240|0,C+144|0,g^=I=(0|Q[A+(i>>>3)>>0])>>>(7&i)&1),AA(C+192|0,C+96|0,g),lA(C+48|0,C+144|0,C+96|0),lA(C,C+240|0,C+192|0),_A(C+240|0,C+240|0,C+192|0),_A(C+192|0,C+144|0,C+96|0),u(C+96|0,C+48|0,C+240|0),u(C+192|0,C+192|0,C),_(C+48|0,C),_(C,C+240|0),_A(C+144|0,C+96|0,C+192|0),lA(C+192|0,C+96|0,C+192|0),u(C+240|0,C,C+48|0),lA(C,C,C+48|0),_(C+192|0,C+192|0),v(C+96|0,C),_(C+144|0,C+144|0),_A(C+48|0,C+48|0,C+96|0),u(C+96|0,C+288|0,C+192|0),u(C+192|0,C,C+48|0),i;)i=i+-1|0;AA(C+240|0,C+144|0,I),AA(C+192|0,C+96|0,I),W(C+192|0,C+192|0),u(C+240|0,C+240|0,C+192|0),CA(A,C+240|0),i=0}return y=E,0|i}(A,I,g))I=-1;else{I=0;do{B[C>>0]=B[C>>0]|B[A+I>>0],I=I+1|0}while(32!=(0|I));I=0-((511+(0|Q[C>>0])|0)>>>8&1)|0}return y=E,0|I}function rI(A,I,g,B,C,Q,E){A|=0,I|=0,C|=0,Q|=0,E|=0;var i,e=0;e=0|Ug(0,1,0|(e=0|yg(0|(e=0|vg(0|(g|=0),0|(B|=0),63,0)),0|o(),6)),0|o()),(i=0|o())>>>0<0|0==(0|i)&e>>>0<Q>>>0?SB():mI(A,I,g,B,C,Q,E)}function tI(A,I,g){A|=0,I|=0;var C,Q,E=0,i=0;Q=y,i=y=y+63&-64,y=y+64|0,RI(i,g|=0,32,0),E=i,C=(g=I)+32|0;do{B[g>>0]=0|B[E>>0],g=g+1|0,E=E+1|0}while((0|g)<(0|C));return MI(i,64),i=0|AB(A,I),y=Q,0|i}function fI(A,I,g,B,C,Q,E){var i,e;A|=0,I|=0,C|=0,E|=0,i=y,e=y=y+63&-64,y=y+80|0,0==(0|(g|=0))&0==(0|(B|=0))||(Pg(e+64|0,Q|=0),$A(e,E),UI(e,C,e+64|0),M(e,I,A,g,B),MI(e,64)),y=i}function wI(A,I,g){var C,Q;A|=0,C=y,Q=y=y+63&-64,y=y+160|0,RI(I|=0,g|=0,32,0),B[I>>0]=-8&B[I>>0],B[I+31>>0]=63&B[I+31>>0]|64,iA(Q,I),sI(A,Q),YI(0|I,0|g,32),YI(I+32|0,0|A,32),y=C}function yI(A,I,g,B){A|=0,I|=0,g|=0,B|=0;A:do{if(B>>>0>0|0==(0|B)&g>>>0>4294967295)C[8678]=22,g=-1;else{switch(0|oB(A,I,g)){case 0:g=0;break A;case-35:C[8678]=28}g=-1}}while(0);return 0|g}function sI(A,I){var g,C;A|=0,g=y,C=y=y+63&-64,y=y+144|0,W(C+96|0,80+(I|=0)|0),u(C+48|0,I,C+96|0),u(C,I+40|0,C+96|0),CA(A,C),I=(0|sg(C+48|0))<<7,B[A+31>>0]=I^(0|Q[A+31>>0]),y=g}function hI(A,I,g,B){A|=0,I|=0,g|=0,B|=0;A:do{if(B>>>0>0|0==(0|B)&g>>>0>4294967295)C[8678]=22,g=-1;else{switch(0|cB(A,I,g)){case 0:g=0;break A;case-35:C[8678]=28}g=-1}}while(0);return 0|g}function DI(A,I,g,B,C,Q,E,i){var e;return A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,e=y,y=y+32|0,0|jg(e,E|=0,i|=0)?B=-1:(B=0|ng(A,I,g,B,C,Q,e),MI(e,32)),y=e,0|B}function FI(A,I,g,B,C,Q,E,i){var e;return A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,e=y,y=y+32|0,0|jg(e,E|=0,i|=0)?B=-1:(tg(A,I,g,B,C,Q,e),MI(e,32),B=0),y=e,0|B}function pI(A){A|=0;var I=0,g=0,C=0,Q=0,E=0;for(Q=0,E=32,I=1;Q=(255&(g=0|B[A+(E=E+-1|0)>>0]))-(255&(C=0|B[32320+E>>0]))>>8&(I&=255)|255&Q,E;)I&=(65535+(255&(C^g))|0)>>>8;return 0!=(0|Q)|0}function uI(A,I,g,B){return B=0|vg(0|vg(0|(g|=0),0|(B|=0),0|(A|=0),0|(I|=0)),0|o(),0|(B=0|Qg(-2&(B=0|rg(0|A,0|I,1))|0,1&(0|o())|0,0|g,0)),0|o()),e(0|o()),0|B}function HI(A,I,g,B){A|=0,I|=0,g|=0,B|=0;do{if(!(g>>>0>64|(B+-1|0)>>>0>63)){if(0==(0|I)|0==(0|g)){iI(A,255&B),I=0;break}vA(A,255&B,I,255&g),I=0;break}I=-1}while(0);return 0|I}function kI(A){var I,g,B,C=0;return g=0|Q[(A|=0)>>0],B=0|rg(0|Q[A+1>>0],0,8),C=0|o(),I=0|rg(0|Q[A+2>>0],0,16),C=0|C|o(),A=0|rg(0|Q[A+3>>0],0,24),e(0|C|o()|0),B|g|I|A|0}function lI(A,I){A|=0,I|=0;var g,C,E=0;g=y,C=y=y+63&-64,y=y+16|0,B[C>>0]=0,E=0;do{B[C>>0]=B[C>>0]|B[A+E>>0],E=E+1|0}while((0|E)!=(0|I));return y=g,(511+(0|Q[C>>0])|0)>>>8&1|0}function _I(A,I,g){A|=0,I|=0;var B=0;(g|=0)?(B=0|Vg(g),C[A+48>>2]=B,g=0|Vg(g+4|0)):(C[A+48>>2]=0,g=0),C[A+52>>2]=g,B=0|Vg(I),C[A+56>>2]=B,B=0|Vg(I+4|0),C[A+60>>2]=B}function GI(A,I,g){var B,C;A|=0,I|=0,g|=0,B=y,C=y=y+63&-64,y=y+384|0,Lg(C,0,0,24),Rg(C,I,32,0),Rg(C,g,32,0),zg(C,A,24),y=B}function dI(A,I,g,B,C,Q,E){return I|=0,C|=0,Q|=0,E|=0,0|((B|=0)>>>0<0|0==(0|B)&(g|=0)>>>0<16?-1:0|DI(A|=0,I+16|0,I,g=0|vg(0|g,0|B,-16,-1),0|o(),C,Q,E))}function YI(A,I,g){var C=0;if((0|(I|=0))<(0|(A|=0))&(0|A)<(I+(g|=0)|0)){for(C=A,I=I+g|0,A=A+g|0;(0|g)>0;)I=I-1|0,g=g-1|0,B[(A=A-1|0)>>0]=0|B[I>>0];A=C}else BA(A,I,g);return 0|A}function MI(A,I){var g,Q;if(A|=0,I|=0,g=y,Q=y=y+63&-64,y=y+16|0,C[Q>>2]=A,0|I){A=0;do{B[(0|C[Q>>2])+A>>0]=0,A=A+1|0}while((0|A)!=(0|I))}y=g}function SI(A,I){A|=0,I|=0;var g=0,B=0,Q=0,E=0;g=0;do{E=I+(g<<3)|0,Q=C[4+(B=A+(g<<3)|0)>>2]^C[E+4>>2],C[B>>2]=C[B>>2]^C[E>>2],C[B+4>>2]=Q,g=g+1|0}while(128!=(0|g))}function UI(A,I,g){A|=0,I|=0,g=(g|=0)?0|Vg(g):0,C[A+48>>2]=g,g=0|Vg(I),C[A+52>>2]=g,g=0|Vg(I+4|0),C[A+56>>2]=g,I=0|Vg(I+8|0),C[A+60>>2]=I}function vI(A,I){var g,C;I|=0,C=y,y=y+64|0,function(A,I){var g;I|=0,g=y,y=y+64|0,VI(A|=0,g),P(A+208|0,g,64,0),VI(A+208|0,I),MI(g,64),y=g}(A|=0,C),A=C,g=I+32|0;do{B[I>>0]=0|B[A>>0],I=I+1|0,A=A+1|0}while((0|I)<(0|g));y=C}function bI(A){var I;return A|=0,((I=0|C[8808])+A|0)>>>0>(0|r())>>>0&&0==(0|f(I+A|0))?(C[8678]=48,0|(A=-1)):(C[8808]=I+A,0|(A=I))}function JI(A,I,g,B,C){var Q;A|=0,I|=0,g|=0,B|=0,Q=y,y=y+416|0,function(A,I){kA(A|=0,I|=0)}(Q,C|=0),function(A,I,g,B){xg(A|=0,I|=0,g|=0,B|=0)}(Q,I,g,B),vI(Q,A),y=Q}function PI(A){var I,g=0;C[64+(A|=0)>>2]=0,C[A+64+4>>2]=0,C[A+64+8>>2]=0,C[A+64+12>>2]=0,g=32352,I=A+64|0;do{C[A>>2]=C[g>>2],A=A+4|0,g=g+4|0}while((0|A)<(0|I))}function RI(A,I,g,B){var C,Q;A|=0,I|=0,g|=0,B|=0,C=y,Q=y=y+63&-64,y=y+208|0,PI(Q),P(Q,I,g,B),VI(Q,A),y=C}function NI(A,I,g){A|=0,I|=0;var B=0,Q=0;if((g|=0)>>>3|0){B=0;do{AI(A+(B<<3)|0,0|C[(Q=I+(B<<3)|0)>>2],0|C[Q+4>>2]),B=B+1|0}while((0|B)!=(g>>>3|0))}}function mI(A,I,g,B,C,Q,E){A|=0,I|=0,C|=0,Q|=0,E|=0,(B|=0)>>>0>0|0==(0|B)&(g|=0)>>>0>4294967295?SB():fI(A,I,g,B,C,Q,E)}function LI(A,I,g){I|=0,g|=0,B[(A|=0)>>0]=I,B[A+1>>0]=I>>8,B[A+2>>0]=I>>16,B[A+3>>0]=I>>24,B[A+4>>0]=g,B[A+4+1>>0]=g>>8,B[A+4+2>>0]=g>>16,B[A+4+3>>0]=g>>24}function xI(A,I){A|=0,I|=0;var g=0,B=0,Q=0,E=0;g=0;do{E=0|qI(I+(g<<3)|0),Q=0|o(),C[(B=A+(g<<3)|0)>>2]=E,C[B+4>>2]=Q,g=g+1|0}while(128!=(0|g))}function KI(A,I,g,B,C,Q,E){return A|=0,I|=0,C|=0,Q|=0,E|=0,(B|=0)>>>0>0|0==(0|B)&(g|=0)>>>0>4294967279?(SB(),0):0|FI(A+16|0,A,I,g,B,C,Q,E)}function XI(A){return(0-(62^(A|=0))|0)>>>8&45^45|(A+65510|0)>>>8&255&A+65|(0-(63^A)|0)>>>8&95^95|(A+65484|0)>>>8&A+71&((A+65510|0)>>>8&255^255)|(A+65474|0)>>>8&A+252&((A+65484|0)>>>8&255^255)|0}function jI(A){return(0-(62^(A|=0))|0)>>>8&43^43|(A+65510|0)>>>8&255&A+65|(0-(63^A)|0)>>>8&47^47|(A+65484|0)>>>8&A+71&((A+65510|0)>>>8&255^255)|(A+65474|0)>>>8&A+252&((A+65484|0)>>>8&255^255)|0}function TI(A,I,g,B,C,Q,E){return B|=0,((I|=0)-1|0)>>>0>63|(E|=0)>>>0>64?B=-1:(function(A,I,g,B,C,Q,E){var i,e;A|=0,g|=0,B|=0,E|=0,i=y,e=y=y+63&-64,y=y+368|0,0==(0|(I|=0))&(0!=(0|(C|=0))|0!=(0|(Q|=0)))&&SB(),A||SB(),(B+-1&255)>63&&SB(),0!=(0|g)|E<<24>>24==0||SB(),(255&E)>64&&SB(),E<<24>>24?vA(e,B,g,E):iI(e,B),$(e,I,C,Q),b(e,A,B),y=i}(A|=0,g|=0,Q|=0,255&I,B,C|=0,255&E),B=0),0|B}function qI(A){var I;return I=Q[(A|=0)>>0]|Q[A+1>>0]<<8|Q[A+2>>0]<<16|Q[A+3>>0]<<24,e(Q[A+4>>0]|Q[A+4+1>>0]<<8|Q[A+4+2>>0]<<16|Q[A+4+3>>0]<<24|0),0|I}function VI(A,I){var g,B;I|=0,g=y,B=y=y+63&-64,y=y+704|0,WA(A|=0,B),NI(I,A,64),MI(B,704),MI(A,208),y=g}function zI(A,I,g,B,C,Q){A|=0,I|=0,C|=0,Q|=0,(B|=0)>>>0>0|0==(0|B)&(g|=0)>>>0>4294967295?SB():function(A,I,g,B,C,Q,E,i){var e,o;A|=0,I|=0,C|=0,i|=0,e=y,o=y=y+63&-64,y=y+80|0,0==(0|(g|=0))&0==(0|(B|=0))||(Pg(o+64|0,1),Pg(o+64+4|0,0),$A(o,i),_I(o,C,o+64|0),M(o,I,A,g,B),MI(o,64)),y=e}(A,I,g,B,C,0,0,Q)}function WI(A){var I=0,g=0;I=127&B[31+(A|=0)>>0]^127,g=30;do{I|=~B[A+g>>0],g=g+-1|0}while(0!=(0|g));return(236-(0|Q[A>>0])&511+(255&I))>>>8&1^1|0}function OI(A,I,g,B,C){A|=0,B|=0,C|=0,(g|=0)>>>0>0|0==(0|g)&(I|=0)>>>0>4294967295?SB():gg(A,I,g,B,C)}function ZI(A,I,g){var B,C;return B=0|yg(0|(A|=0),0|(I|=0),0|(g|=0)),C=0|o(),g=0|rg(0|A,0|I,64-g|0),e(0|o()|C|0),g|B|0}function $I(A,I,g){var B,C;return B=0|rg(0|(A|=0),0|(I|=0),0|(g|=0)),C=0|o(),g=0|yg(0|A,0|I,64-g|0),e(0|o()|C|0),g|B|0}function Ag(A,I,g,B){var Q;return Q=y,y=y+16|0,function(A,I,g,B,Q){A|=0,g|=0,B|=0,Q|=0;var E=0,c=0,a=0,n=0,r=0,t=0,f=0,w=0,y=0,s=0;if(!(I|=0))return B?Q?(C[Q>>2]=0|A,C[Q+4>>2]=0&I,Q=0,0|(e(0|(B=0)),Q)):(Q=0,0|(e(0|(B=0)),Q)):(0|Q&&(C[Q>>2]=(A>>>0)%(g>>>0),C[Q+4>>2]=0),Q=(A>>>0)/(g>>>0)>>>0,0|(e(0|(B=0)),Q));do{if(g){if(0|B){if((c=(0|i(0|B))-(0|i(0|I))|0)>>>0<=31){w=c+1|0,a=A>>>((c+1|0)>>>0)&c-31>>31|I<<31-c,f=I>>>((c+1|0)>>>0)&c-31>>31,E=0,c=A<<31-c;break}return Q?(C[Q>>2]=0|A,C[Q+4>>2]=I|0&I,Q=0,0|(e(0|(B=0)),Q)):(Q=0,0|(e(0|(B=0)),Q))}if(g-1&g|0){w=c=33+(0|i(0|g))-(0|i(0|I))|0,a=32-c-1>>31&I>>>((c-32|0)>>>0)|(I<<32-c|A>>>(c>>>0))&c-32>>31,f=c-32>>31&I>>>(c>>>0),E=A<<64-c&32-c>>31,c=(I<<64-c|A>>>((c-32|0)>>>0))&32-c>>31|A<<32-c&c-33>>31;break}return 0|Q&&(C[Q>>2]=g-1&A,C[Q+4>>2]=0),1==(0|g)?(Q=0|A,0|(e(0|(B=I|0&I)),Q)):(B=I>>>((Q=0|nB(0|g))>>>0)|0,Q=I<<32-Q|A>>>(Q>>>0)|0,0|(e(0|B),Q))}if(!B)return 0|Q&&(C[Q>>2]=(I>>>0)%(g>>>0),C[Q+4>>2]=0),Q=(I>>>0)/(g>>>0)>>>0,0|(e(0|(B=0)),Q);if(!A)return 0|Q&&(C[Q>>2]=0,C[Q+4>>2]=(I>>>0)%(B>>>0)),Q=(I>>>0)/(B>>>0)>>>0,0|(e(0|(g=0)),Q);if(!(B-1&B))return 0|Q&&(C[Q>>2]=0|A,C[Q+4>>2]=B-1&I|0&I),g=0,Q=I>>>((0|nB(0|B))>>>0),0|(e(0|g),Q);if((c=(0|i(0|B))-(0|i(0|I))|0)>>>0<=30){w=c+1|0,a=I<<31-c|A>>>((c+1|0)>>>0),f=I>>>((c+1|0)>>>0),E=0,c=A<<31-c;break}return Q?(C[Q>>2]=0|A,C[Q+4>>2]=I|0&I,Q=0,0|(e(0|(B=0)),Q)):(Q=0,0|(e(0|(B=0)),Q))}while(0);if(w){r=0|vg(0|g,B|0&B|0,-1,-1),t=0|o(),n=c,I=f,A=w,c=0;do{s=n,n=E>>>31|n<<1,E=c|E<<1,Ug(0|r,0|t,0|(s=a<<1|s>>>31|0),0|(y=a>>>31|I<<1|0)),c=1&(f=(w=0|o())>>31|((0|w)<0?-1:0)<<1),a=0|Ug(0|s,0|y,f&(0|g)|0,(((0|w)<0?-1:0)>>31|((0|w)<0?-1:0)<<1)&(B|0&B)|0),I=0|o(),A=A-1|0}while(0!=(0|A));A=0}else n=c,I=f,A=0,c=0;0|Q&&(C[Q>>2]=a,C[Q+4>>2]=I),s=-2&(E<<1|0)|c,e(0|(y=(0|E)>>>31|n<<1|0&(0|E>>>31)|A))}(A|=0,I|=0,g|=0,B|=0,0|Q),y=Q,0|(e(0|C[Q+4>>2]),0|C[Q>>2])}function Ig(A){A|=0;var I=0,g=0,C=0;for(I=1,g=0;I=I+(0|Q[(C=A+g|0)>>0])|0,B[C>>0]=I,4!=(0|(g=g+1|0));)I>>>=8}function gg(A,I,g,B,C){A|=0,B|=0,C|=0,(g|=0)>>>0>0|0==(0|g)&(I|=0)>>>0>4294967295?SB():function(A,I,g,B,C){var Q,E;A|=0,B|=0,Q=y,E=y=y+63&-64,y=y+64|0,0==(0|(I|=0))&0==(0|(g|=0))||($A(E,C|=0),UI(E,B,0),YA(0|A,0,0|I),M(E,A,A,I,g),MI(E,64)),y=Q}(A,I,g,B,C)}function Bg(A,I,g){var B;return A|=0,g|=0,I=0|rg(255&(I|=0)|0,0,8),B=0|o(),g=0|rg(255&g|0,0,16),e(0|B|o()|0),I|255&A|g|0}function Cg(A,I){A|=0;var g=0,C=0;if(0|(I|=0)){g=0;do{C=255&(0|DB()),B[A+g>>0]=C,g=g+1|0}while((0|g)!=(0|I))}}function Qg(A,I,g,B){var C,Q;return I|=0,B|=0,C=0|function(A,I){var g,B,C;return C=((g=0|E(65535&(I|=0),65535&(A|=0)))>>>16)+(0|E(65535&I,A>>>16))|0,B=0|E(I>>>16,65535&A),0|(e((C>>>16)+(0|E(I>>>16,A>>>16))+(((65535&C)+B|0)>>>16)|0),C+B<<16|65535&g|0)}(A|=0,g|=0),Q=0|o(),0|(e((0|E(I,g))+(0|E(B,A))+Q|0&Q|0),0|C)}function Eg(A,I){u(A|=0,I|=0,I+120|0),u(A+40|0,I+40|0,I+80|0),u(A+80|0,I+80|0,I+120|0),u(A+120|0,I,I+40|0)}function ig(A,I,g){return A|=0,I|=0,(0|(g|=0))<32?(e(I>>g|0),A>>>g|(I&(1<<g)-1)<<32-g):(e(0|((0|I)<0?-1:0)),I>>g-32|0)}function eg(A,I){_A(A|=0,40+(I|=0)|0,I),lA(A+40|0,I+40|0,I),OA(A+80|0,I+80|0),u(A+120|0,I+120|0,112)}function og(A,I){var g,B;A|=0,g=y,B=y=y+63&-64,y=y+128|0,function(A,I){OA(A|=0,I|=0),OA(A+40|0,I+40|0),OA(A+80|0,I+80|0)}(B,I|=0),aI(A,B),y=g}function cg(A){var I,g;return I=y,g=y=y+63&-64,y=y+32|0,CA(g,A|=0),A=0|lI(g,32),y=I,0|A}function ag(A,I){A|=0,I|=0;var g=0,C=0;g=0;do{B[(C=A+g|0)>>0]=B[C>>0]^B[I+g>>0],g=g+1|0}while(8!=(0|g))}function ng(A,I,g,B,C,Q,E){return 0|gA(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,E|=0)}function rg(A,I,g){return A|=0,(0|(g|=0))<32?(e((I|=0)<<g|(A&(1<<g)-1<<32-g)>>>32-g|0),A<<g):(e(A<<g-32|0),0)}function tg(A,I,g,B,C,Q,E){return Z(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,E|=0),0}function fg(A,I,g){return(g|=0)>>>0<256?0|b(A|=0,I|=0,255&g):(c(33547,33567,107,33620),0)}function wg(A,I){A|=0;var g=0;return(I|=0)>>>0<=4294967168&&0!=(0|(g=0|function(A){var I,g=0,B=0,Q=0,E=0;if((A|=0)>>>0>=4294967168)return C[8678]=48,0;if(!(B=0|F(76+(I=A>>>0<11?16:A+11&-8)|0)))return 0;do{if(63&B){if(g=(Q=((B+63&-64)-8-(B+-8)|0)>>>0>15?(B+63&-64)-8|0:56+(B+63&-64)|0)-(B+-8)|0,3&(A=0|C[B+-4>>2])){C[Q+4>>2]=(-8&A)-g|1&C[Q+4>>2]|2,C[Q+((-8&A)-g)+4>>2]=1|C[Q+((-8&A)-g)+4>>2],C[B+-4>>2]=g|1&C[B+-4>>2]|2,C[Q+4>>2]=1|C[Q+4>>2],Y(B+-8|0,g),E=Q,A=Q;break}C[Q>>2]=(0|C[B+-8>>2])+g,C[Q+4>>2]=(-8&A)-g,E=Q,A=Q;break}E=B+-8|0,A=B+-8|0}while(0);return 3&(A=0|C[(g=A+4|0)>>2])|0&&(-8&A)>>>0>(I+16|0)>>>0&&(Q=E+I|0,C[g>>2]=I|1&A|2,C[Q+4>>2]=(-8&A)-I|3,C[(B=E+(-8&A)+4|0)>>2]=1|C[B>>2],Y(Q,(-8&A)-I|0)),0|E+8}(I)))?(C[A>>2]=g,I=0):I=48,0|I}function yg(A,I,g){return A|=0,I|=0,(0|(g|=0))<32?(e(I>>>g|0),A>>>g|(I&(1<<g)-1)<<32-g):(e(0),I>>>g-32|0)}function sg(A){var I,g;return g=y,I=y=y+63&-64,y=y+32|0,CA(I,A|=0),y=g,1&B[I>>0]|0}function hg(A,I,g){tA(A|=0,I|=0,255&(g|=0)),tA(A+40|0,I+40|0,255&g),tA(A+80|0,I+80|0,255&g)}function Dg(A,I,g,B,C,Q,E){return 0|TI(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,E|=0)}function Fg(A,I,g,B,C,Q,E){return 0|nA(A|=0,I|=0,1,g|=0,B|=0,C|=0,16,Q|=0,E|=0,0,0,2)}function pg(A,I,g,B,C,Q,E){return 0|nA(A|=0,I|=0,1,g|=0,B|=0,C|=0,16,Q|=0,E|=0,0,0,1)}function ug(A,I){(function(A,I){A|=0,0|(I|=0)&&(0|(I=0|C[A>>2])&&MI(0|C[I+4>>2],C[A+16>>2]<<10),0|(I=0|C[A+4>>2])&&MI(I,C[A+20>>2]<<3))})(A|=0,4&(I|=0)),d(0|C[A+4>>2]),C[A+4>>2]=0,function(A){var I=0;0|(A|=0)&&0|(I=0|C[A>>2])&&d(I),d(A)}(0|C[A>>2]),C[A>>2]=0}function Hg(A,I){u(A|=0,I|=0,I+120|0),u(A+40|0,I+40|0,I+80|0),u(A+80|0,I+80|0,I+120|0)}function kg(A,I,g,B,C,Q){hA(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,0)}function lg(A,I,g,B,C,Q){return 0|nA(A|=0,I|=0,1,g|=0,B|=0,C|=0,16,0,32,Q|=0,128,2)}function _g(A,I,g,B,C,Q){V(A|=0,I|=0,g|=0,B|=0,C|=0,1,0,Q|=0)}function Gg(A,I,g,B,C,Q){return 0|nA(A|=0,I|=0,1,g|=0,B|=0,C|=0,16,0,32,Q|=0,128,1)}function dg(A,I,g,B,C){return 0|uA(A|=0,I|=0,g|=0,B|=0,C|=0,0)}function Yg(A,I,g,B,C,Q){V(A|=0,I|=0,g|=0,B|=0,C|=0,0,0,Q|=0)}function Mg(A){B[32+(A|=0)>>0]=1,B[A+32+1>>0]=0,B[A+32+2>>0]=0,B[A+32+3>>0]=0}function Sg(A){var I;C[(A|=0)>>2]=1,I=36+(A=A+4|0)|0;do{C[A>>2]=0,A=A+4|0}while((0|A)<(0|I))}function Ug(A,I,g,B){return 0|(e(0|(B=(I|=0)-(B|=0)-((g|=0)>>>0>(A|=0)>>>0|0)>>>0)),A-g>>>0|0)}function vg(A,I,g,B){return 0|(e((I|=0)+(B|=0)+((A|=0)+(g|=0)>>>0>>>0<A>>>0|0)>>>0|0),A+g>>>0|0)}function bg(A,I,g,B){!function(A,I,g,B){K(A|=0,I|=0,g|=0,B|=0)}(A|=0,I|=0,g|=0,B|=0)}function Jg(A,I){I|=0,PI(A|=0),0|I&&P(A,33408,34,0)}function Pg(A,I){I|=0,B[(A|=0)>>0]=I,B[A+1>>0]=I>>8,B[A+2>>0]=I>>16,B[A+3>>0]=I>>24}function Rg(A,I,g,B){return Xg(A|=0,I|=0,g|=0,B|=0),0}function Ng(A,I,g,B){return 0|FA(A|=0,I|=0,g|=0,B|=0,2)}function mg(A,I,g,B){return 0|FA(A|=0,I|=0,g|=0,B|=0,1)}function Lg(A,I,g,B){return 0|HI(A|=0,I|=0,g|=0,B|=0)}function xg(A,I,g,B){P(A|=0,I|=0,g|=0,B|=0)}function Kg(A){var I;I=40+(A|=0)|0;do{C[A>>2]=0,A=A+4|0}while((0|A)<(0|I))}function Xg(A,I,g,B){$(A|=0,I|=0,g|=0,B|=0)}function jg(A,I,g){return 0|function(A,I,g){var B,C;return A|=0,C=y,B=y=y+63&-64,y=y+32|0,0|nI(B,g|=0,I|=0)?A=-1:(x(A,34656,B),A=0),y=C,0|A}(A|=0,I|=0,g|=0)}function Tg(A){B[(A|=0)>>0]=-8&B[A>>0],B[A+31>>0]=63&B[A+31>>0]|64}function qg(A,I){return A=0|HA(A|=0,I|=0),0|((0|B[A>>0])==(255&I)<<24>>24?A:0)}function Vg(A){return Q[(A|=0)>>0]|Q[A+1>>0]<<8|Q[A+2>>0]<<16|Q[A+3>>0]<<24|0}function zg(A,I,g){return 0|fg(A|=0,I|=0,g|=0)}function Wg(A){B[(A|=0)>>0]=0,B[A+1>>0]=0,B[A+2>>0]=0,B[A+3>>0]=0}function Og(A){Kg(A|=0),Sg(A+40|0),Sg(A+80|0),Kg(A+120|0)}function Zg(A){C[(A|=0)>>2]=0,C[A+4>>2]=0,C[A+8>>2]=0,C[A+12>>2]=0}function $g(A,I,g){!function(A,I,g){var B,C,Q;A|=0,I|=0,B=y,Q=y=y+63&-64,y=y+128|0,g=((g|=0)<<24>>24)-((0-(255&(C=0|function(A){return(255&(A|=0))>>>7|0}(g)))&g<<24>>24)<<1)&255,function(A){Sg(A|=0),Sg(A+40|0),Kg(A+80|0)}(A),hg(A,I,0|aB(g,1)),hg(A,I+120|0,0|aB(g,2)),hg(A,I+240|0,0|aB(g,3)),hg(A,I+360|0,0|aB(g,4)),hg(A,I+480|0,0|aB(g,5)),hg(A,I+600|0,0|aB(g,6)),hg(A,I+720|0,0|aB(g,7)),hg(A,I+840|0,0|aB(g,8)),OA(Q,A+40|0),OA(Q+40|0,A),xA(Q+80|0,A+80|0),hg(A,Q,C),y=B}(A|=0,1120+(960*(I|=0)|0)|0,g|=0)}function AB(A,I){return 0|QI(A|=0,I|=0)}function IB(A,I){!function(A,I){z(A|=0,I|=0)}(A|=0,I|=0)}function gB(A,I){!function(A,I){MA(A|=0,I|=0)}(A|=0,I|=0)}function BB(A,I,g){return 0|nI(A|=0,I|=0,g|=0)}function CB(A,I){return 0|function(A,I){return A|=0,Cg(I|=0,32),0|AB(A,I)}(A|=0,I|=0)}function QB(A,I,g){!function(A,I,g,B,C){var Q,E;A|=0,B|=0,Q=y,E=y=y+63&-64,y=y+64|0,0==(0|(I|=0))&0==(0|(g|=0))||($A(E,C|=0),_I(E,B,0),YA(0|A,0,64),M(E,A,A,64,0),MI(E,64)),y=Q}(A|=0,64,0,I|=0,g|=0)}function EB(A){1!=(-7&(A|=0)|0)&&SB()}function iB(A,I,g){!function(A,I,g){A|=0,I|=0;var B,C,Q,E,i,e,o,c,a,n,r,t=0,f=0,w=0,y=0,s=0,h=0,D=0,F=0,p=0,u=0,H=0,k=0,l=0,_=0,G=0,d=0,Y=0,M=0,S=0,U=0,v=0,b=0,J=0,P=0,R=0,N=0,m=0,L=0,x=0,K=0,X=0,j=0;r=0|Vg(g|=0),i=0|Vg(g+4|0),e=0|Vg(g+8|0),o=0|Vg(g+12|0),c=0|Vg(g+16|0),a=0|Vg(g+20|0),n=0|Vg(g+24|0),B=0|Vg(g+28|0),C=0|Vg(I),Q=0|Vg(I+4|0),E=0|Vg(I+8|0),g=0|Vg(I+12|0),I=0,t=1634760805,f=r,w=2036477234,y=c,s=a,h=n,D=B,F=1797285236,p=i,u=e,H=o,k=857760878,l=C,_=Q,G=E,d=g;do{x=(0|wB((U=(0|wB((J=(0|wB((N=(0|wB(t+s|0,7))^H)+t|0,9))^G)+N|0,13))^s)+J|0,18))^t,R=(0|wB((j=(0|wB((S=(0|wB((b=(0|wB(f+k|0,7))^d)+k|0,9))^h)+b|0,13))^f)+S|0,18))^k,v=(0|wB((L=(0|wB((X=(0|wB((M=(0|wB(l+w|0,7))^D)+w|0,9))^p)+M|0,13))^l)+X|0,18))^w,Y=(0|wB((P=(0|wB((m=(0|wB((K=(0|wB(y+F|0,7))^u)+F|0,9))^_)+K|0,13))^y)+m|0,18))^F,t=(0|wB((u=(0|wB((p=(0|wB((f=(0|wB(K+x|0,7))^j)+x|0,9))^X)+f|0,13))^K)+p|0,18))^x,k=(0|wB((H=(0|wB((_=(0|wB((l=(0|wB(R+N|0,7))^L)+R|0,9))^m)+l|0,13))^N)+_|0,18))^R,w=(0|wB((d=(0|wB((G=(0|wB((y=(0|wB(v+b|0,7))^P)+v|0,9))^J)+y|0,13))^b)+G|0,18))^v,F=(0|wB((D=(0|wB((h=(0|wB((s=(0|wB(Y+M|0,7))^U)+Y|0,9))^S)+s|0,13))^M)+h|0,18))^Y,I=I+2|0}while(I>>>0<20);Pg(A,t+1634760805|0),Pg(A+4|0,f+r|0),Pg(A+8|0,p+i|0),Pg(A+12|0,u+e|0),Pg(A+16|0,H+o|0),Pg(A+20|0,k+857760878|0),Pg(A+24|0,l+C|0),Pg(A+28|0,_+Q|0),Pg(A+32|0,G+E|0),Pg(A+36|0,d+g|0),Pg(A+40|0,w+2036477234|0),Pg(A+44|0,y+c|0),Pg(A+48|0,s+a|0),Pg(A+52|0,h+n|0),Pg(A+56|0,D+B|0),Pg(A+60|0,F+1797285236|0)}(A|=0,I|=0,g|=0)}function eB(A,I){return 0|AB(A|=0,I|=0)}function oB(A,I,g){return 0|EA(A|=0,I|=0,g|=0,2)}function cB(A,I,g){return 0|EA(A|=0,I|=0,g|=0,1)}function aB(A,I){return((255&((I|=0)^(A|=0)))-1|0)>>>31&255|0}function nB(A){return 0|((A|=0)?31-(0|i(A^A-1))|0:32)}function rB(A,I){return 0|eI(A|=0,I|=0,32)}function tB(A,I){return 0|eI(A|=0,I|=0,16)}function fB(A,I){BA(0|(A|=0),0|(I|=0),1024)}function wB(A,I){return(A|=0)>>>(32-(I|=0)|0)|A<<I|0}function yB(A){YA(0|(A|=0),0,1024)}function sB(A){Cg(A|=0,32)}function hB(){n(1)}function DB(){return 0|n(0)}function FB(){return-17}function pB(){return 3}function uB(){return 2}function HB(){return-1}function kB(){return 1}function lB(){return 8}function _B(){return 24}function GB(){return 16}function dB(){return 64}function YB(){return 32}function MB(){return 0}function SB(){a()}return{___errno_location:function(){return 34712},___muldi3:Qg,___uremdi3:Ag,_bitshift64Ashr:ig,_bitshift64Lshr:yg,_bitshift64Shl:rg,_crypto_aead_chacha20poly1305_abytes:GB,_crypto_aead_chacha20poly1305_decrypt:function(A,I,g,B,Q,E,i,e,c,a,n){I|=0,g|=0,B|=0,i|=0,e|=0,c|=0,a|=0,n|=0;var r=0,t=0;return(E|=0)>>>0>0|0==(0|E)&(Q|=0)>>>0>15?(E=0|sA(A|=0,0,B,g=0|vg(0|Q,0|E,-16,-1),r=0|o(),B+Q+-16|0,i,e,c,a,n),I&&(Q=0==(0|E)?g:0,g=0==(0|E)?r:0,t=4)):I?(Q=0,g=0,E=-1,t=4):E=-1,4==(0|t)&&(C[I>>2]=Q,C[I+4>>2]=g),0|E},_crypto_aead_chacha20poly1305_decrypt_detached:sA,_crypto_aead_chacha20poly1305_encrypt:function(A,I,g,B,Q,E,i,e,c,a,n){return A|=0,I|=0,g|=0,E|=0,i|=0,e|=0,c|=0,a|=0,n|=0,(Q|=0)>>>0>0|0==(0|Q)&(B|=0)>>>0>4294967279&&SB(),dA(A,A+B|0,0,g,B,Q,E,i,e,0,a,n),0|I&&(a=0|vg(0|B,0|Q,16,0),c=0|o(),C[I>>2]=a,C[I+4>>2]=c),0},_crypto_aead_chacha20poly1305_encrypt_detached:dA,_crypto_aead_chacha20poly1305_ietf_abytes:GB,_crypto_aead_chacha20poly1305_ietf_decrypt:function(A,I,g,B,Q,E,i,e,c,a,n){I|=0,g|=0,B|=0,i|=0,e|=0,c|=0,a|=0,n|=0;var r=0,t=0;return(E|=0)>>>0>0|0==(0|E)&(Q|=0)>>>0>15?(E=0|eA(A|=0,0,B,g=0|vg(0|Q,0|E,-16,-1),r=0|o(),B+Q+-16|0,i,e,c,a,n),I&&(Q=0==(0|E)?g:0,g=0==(0|E)?r:0,t=4)):I?(Q=0,g=0,E=-1,t=4):E=-1,4==(0|t)&&(C[I>>2]=Q,C[I+4>>2]=g),0|E},_crypto_aead_chacha20poly1305_ietf_decrypt_detached:eA,_crypto_aead_chacha20poly1305_ietf_encrypt:function(A,I,g,B,Q,E,i,e,c,a,n){return A|=0,I|=0,g|=0,E|=0,i|=0,e|=0,c|=0,a|=0,n|=0,(Q|=0)>>>0>0|0==(0|Q)&(B|=0)>>>0>4294967279&&SB(),fA(A,A+B|0,0,g,B,Q,E,i,e,0,a,n),0|I&&(a=0|vg(0|B,0|Q,16,0),c=0|o(),C[I>>2]=a,C[I+4>>2]=c),0},_crypto_aead_chacha20poly1305_ietf_encrypt_detached:fA,_crypto_aead_chacha20poly1305_ietf_keybytes:YB,_crypto_aead_chacha20poly1305_ietf_keygen:sB,_crypto_aead_chacha20poly1305_ietf_messagebytes_max:FB,_crypto_aead_chacha20poly1305_ietf_npubbytes:function(){return 12},_crypto_aead_chacha20poly1305_ietf_nsecbytes:MB,_crypto_aead_chacha20poly1305_keybytes:YB,_crypto_aead_chacha20poly1305_keygen:sB,_crypto_aead_chacha20poly1305_messagebytes_max:FB,_crypto_aead_chacha20poly1305_npubbytes:lB,_crypto_aead_chacha20poly1305_nsecbytes:MB,_crypto_aead_xchacha20poly1305_ietf_abytes:GB,_crypto_aead_xchacha20poly1305_ietf_decrypt:function(A,I,g,B,Q,E,i,e,c,a,n){I|=0,g|=0,B|=0,i|=0,e|=0,c|=0,a|=0,n|=0;var r=0,t=0;return(E|=0)>>>0>0|0==(0|E)&(Q|=0)>>>0>15?(E=0|PA(A|=0,0,B,g=0|vg(0|Q,0|E,-16,-1),r=0|o(),B+Q+-16|0,i,e,c,a,n),I&&(Q=0==(0|E)?g:0,g=0==(0|E)?r:0,t=4)):I?(Q=0,g=0,E=-1,t=4):E=-1,4==(0|t)&&(C[I>>2]=Q,C[I+4>>2]=g),0|E},_crypto_aead_xchacha20poly1305_ietf_decrypt_detached:PA,_crypto_aead_xchacha20poly1305_ietf_encrypt:function(A,I,g,B,Q,E,i,e,c,a,n){return A|=0,I|=0,g|=0,E|=0,i|=0,e|=0,c|=0,a|=0,n|=0,(Q|=0)>>>0>0|0==(0|Q)&(B|=0)>>>0>4294967279&&SB(),NA(A,A+B|0,0,g,B,Q,E,i,e,0,a,n),0|I&&(a=0|vg(0|B,0|Q,16,0),c=0|o(),C[I>>2]=a,C[I+4>>2]=c),0},_crypto_aead_xchacha20poly1305_ietf_encrypt_detached:NA,_crypto_aead_xchacha20poly1305_ietf_keybytes:YB,_crypto_aead_xchacha20poly1305_ietf_keygen:sB,_crypto_aead_xchacha20poly1305_ietf_messagebytes_max:FB,_crypto_aead_xchacha20poly1305_ietf_npubbytes:_B,_crypto_aead_xchacha20poly1305_ietf_nsecbytes:MB,_crypto_auth:function(A,I,g,B,C){return JI(A|=0,I|=0,g|=0,B|=0,C|=0),0},_crypto_auth_bytes:YB,_crypto_auth_keybytes:YB,_crypto_auth_keygen:sB,_crypto_auth_verify:function(A,I,g,B,C){return 0|function(A,I,g,B,C){var Q;return A|=0,Q=y,y=y+32|0,JI(Q,I|=0,g|=0,B|=0,C|=0),C=0|rB(A,Q),C=0|((0|Q)==(0|A)?-1:C)|EI(Q,A,32),y=Q,0|C}(A|=0,I|=0,g|=0,B|=0,C|=0)},_crypto_box_beforenm:jg,_crypto_box_beforenmbytes:YB,_crypto_box_detached:FI,_crypto_box_detached_afternm:tg,_crypto_box_easy:KI,_crypto_box_easy_afternm:function(A,I,g,B,C,Q){return A|=0,I|=0,C|=0,Q|=0,(B|=0)>>>0>0|0==(0|B)&(g|=0)>>>0>4294967279?(SB(),0):(tg(A+16|0,A,I,g,B,C,Q),0)},_crypto_box_keypair:CB,_crypto_box_macbytes:GB,_crypto_box_messagebytes_max:FB,_crypto_box_noncebytes:_B,_crypto_box_open_detached:DI,_crypto_box_open_detached_afternm:ng,_crypto_box_open_easy:dI,_crypto_box_open_easy_afternm:function(A,I,g,B,C,Q){return I|=0,C|=0,Q|=0,0|((B|=0)>>>0<0|0==(0|B)&(g|=0)>>>0<16?-1:0|ng(A|=0,I+16|0,I,g=0|vg(0|g,0|B,-16,-1),0|o(),C,Q))},_crypto_box_publickeybytes:YB,_crypto_box_seal:function(A,I,g,C,Q){A|=0,I|=0,g|=0,C|=0,Q|=0;var E,i=0,e=0,o=0;if(E=y,y=y+96|0,0|CB(E+32|0,E))g=-1;else{e=E+32|0,o=(i=A)+32|0;do{B[i>>0]=0|B[e>>0],i=i+1|0,e=e+1|0}while((0|i)<(0|o));GI(E+64|0,E+32|0,Q),g=0|KI(A+32|0,I,g,C,E+64|0,Q,E),MI(E,32),MI(E+32|0,32),MI(E+64|0,24)}return y=E,0|g},_crypto_box_seal_open:function(A,I,g,B,C,Q){var E,i;return A|=0,I|=0,C|=0,Q|=0,i=y,E=y=y+63&-64,y=y+32|0,(B|=0)>>>0<0|0==(0|B)&(g|=0)>>>0<48?g=-1:(B=0|vg(0|g,0|B,-32,-1),g=0|o(),GI(E,I,C),g=0|dI(A,I+32|0,B,g,E,I,Q)),y=i,0|g},_crypto_box_sealbytes:function(){return 48},_crypto_box_secretkeybytes:YB,_crypto_box_seed_keypair:function(A,I,g){return 0|tI(A|=0,I|=0,g|=0)},_crypto_box_seedbytes:YB,_crypto_generichash:Dg,_crypto_generichash_bytes:YB,_crypto_generichash_bytes_max:dB,_crypto_generichash_bytes_min:GB,_crypto_generichash_final:zg,_crypto_generichash_init:Lg,_crypto_generichash_keybytes:YB,_crypto_generichash_keybytes_max:dB,_crypto_generichash_keybytes_min:GB,_crypto_generichash_keygen:sB,_crypto_generichash_statebytes:function(){return 384},_crypto_generichash_update:Rg,_crypto_hash:function(A,I,g,B){return RI(A|=0,I|=0,g|=0,B|=0),0},_crypto_hash_bytes:dB,_crypto_kdf_bytes_max:dB,_crypto_kdf_bytes_min:GB,_crypto_kdf_contextbytes:lB,_crypto_kdf_derive_from_key:function(A,I,g,B,C,Q){return 0|JA(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0)},_crypto_kdf_keybytes:YB,_crypto_kdf_keygen:sB,_crypto_kx_client_session_keys:function(A,I,g,C,Q){var E,i,e;if(I|=0,g|=0,C|=0,Q|=0,e=y,i=y=y+63&-64,y=y+480|0,E=0==(0|(A|=0))?I:A,I=0==(0|I)?E:I,E||SB(),0|BB(i+448|0,C,Q))A=-1;else{Lg(i,0,0,64),Rg(i,i+448|0,32,0),MI(i+448|0,32),Rg(i,g,32,0),Rg(i,Q,32,0),zg(i,i+384|0,64),MI(i,384),A=0;do{B[E+A>>0]=0|B[i+384+A>>0],B[I+A>>0]=0|B[i+384+(A+32)>>0],A=A+1|0}while(32!=(0|A));MI(i+384|0,64),A=0}return y=e,0|A},_crypto_kx_keypair:function(A,I){return A|=0,Cg(I|=0,32),0|eB(A,I)},_crypto_kx_publickeybytes:YB,_crypto_kx_secretkeybytes:YB,_crypto_kx_seed_keypair:function(A,I,g){return A|=0,Dg(I|=0,32,g|=0,32,0,0,0),0|eB(A,I)},_crypto_kx_seedbytes:YB,_crypto_kx_server_session_keys:function(A,I,g,C,Q){var E,i,e;if(I|=0,g|=0,C|=0,Q|=0,e=y,i=y=y+63&-64,y=y+480|0,E=0==(0|(A|=0))?I:A,I=0==(0|I)?E:I,E||SB(),0|BB(i+448|0,C,Q))A=-1;else{Lg(i,0,0,64),Rg(i,i+448|0,32,0),MI(i+448|0,32),Rg(i,Q,32,0),Rg(i,g,32,0),zg(i,i+384|0,64),MI(i,384),A=0;do{B[I+A>>0]=0|B[i+384+A>>0],B[E+A>>0]=0|B[i+384+(A+32)>>0],A=A+1|0}while(32!=(0|A));MI(i+384|0,64),A=0}return y=e,0|A},_crypto_kx_sessionkeybytes:YB,_crypto_pwhash:function(A,I,g,B,Q,E,i,e,o,c,a){switch(A|=0,I|=0,g|=0,B|=0,Q|=0,E|=0,i|=0,e|=0,o|=0,c|=0,0|(a|=0)){case 1:I=0|function(A,I,g,B,Q,E,i,e,o,c){g|=0,B|=0,Q|=0,E|=0,i|=0,e|=0,o|=0,c|=0,YA(0|(A|=0),0,0|(I|=0));do{if(!(g>>>0>0|0==(0|g)&I>>>0>4294967295)){if(g>>>0<0|0==(0|g)&I>>>0<16){C[8678]=28,I=-1;break}if((o|E)>>>0>0|0==(o|E|0)&(e|Q)>>>0>4294967295|c>>>0>2147483648){C[8678]=22,I=-1;break}if(o>>>0<0|0==(0|o)&e>>>0<3|c>>>0<8192){C[8678]=28,I=-1;break}I=(0!=(0|pg(e,c>>>10,B,Q,i,A,I)))<<31>>31;break}C[8678]=22,I=-1}while(0);return 0|I}(A,I,g,B,Q,E,i,e,o,c);break;case 2:I=0|function(A,I,g,B,Q,E,i,e,o,c){g|=0,B|=0,Q|=0,E|=0,i|=0,e|=0,o|=0,c|=0,YA(0|(A|=0),0,0|(I|=0));do{if(!(g>>>0>0|0==(0|g)&I>>>0>4294967295)){if(g>>>0<0|0==(0|g)&I>>>0<16){C[8678]=28,I=-1;break}if((o|E)>>>0>0|0==(o|E|0)&(e|Q)>>>0>4294967295|c>>>0>2147483648){C[8678]=22,I=-1;break}if(0==(0|e)&0==(0|o)|c>>>0<8192){C[8678]=28,I=-1;break}I=(0!=(0|Fg(e,c>>>10,B,Q,i,A,I)))<<31>>31;break}C[8678]=22,I=-1}while(0);return 0|I}(A,I,g,B,Q,E,i,e,o,c);break;default:C[8678]=28,I=-1}return 0|I},_crypto_pwhash_alg_argon2i13:kB,_crypto_pwhash_alg_argon2id13:uB,_crypto_pwhash_alg_default:uB,_crypto_pwhash_bytes_max:HB,_crypto_pwhash_bytes_min:GB,_crypto_pwhash_memlimit_interactive:function(){return 67108864},_crypto_pwhash_memlimit_max:function(){return-2147483648},_crypto_pwhash_memlimit_min:function(){return 8192},_crypto_pwhash_memlimit_moderate:function(){return 268435456},_crypto_pwhash_memlimit_sensitive:function(){return 1073741824},_crypto_pwhash_opslimit_interactive:uB,_crypto_pwhash_opslimit_max:HB,_crypto_pwhash_opslimit_min:kB,_crypto_pwhash_opslimit_moderate:pB,_crypto_pwhash_opslimit_sensitive:function(){return 4},_crypto_pwhash_passwd_max:HB,_crypto_pwhash_passwd_min:MB,_crypto_pwhash_saltbytes:GB,_crypto_pwhash_str:function(A,I,g,B,C,Q,E){return 0|LA(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,E|=0)},_crypto_pwhash_str_alg:function(A,I,g,B,C,Q,E,i){A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0,E|=0;var e=0;switch(0|(i|=0)){case 1:e=0|RA(A,I,g,B,C,Q,E);break;case 2:e=0|LA(A,I,g,B,C,Q,E);break;default:SB()}return 0|e},_crypto_pwhash_str_needs_rehash:function(A,I,g,B){A|=0,I|=0,g|=0,B|=0;do{if(0|oI(A,33713,10)){if(0|oI(A,33724,9)){C[8678]=28,I=-1;break}I=0|mg(A,I,g,B);break}I=0|Ng(A,I,g,B)}while(0);return 0|I},_crypto_pwhash_str_verify:function(A,I,g,B){A|=0,I|=0,g|=0,B|=0;do{if(0|oI(A,33713,10)){if(0|oI(A,33724,9)){C[8678]=28,g=-1;break}g=0|hI(A,I,g,B);break}g=0|yI(A,I,g,B)}while(0);return 0|g},_crypto_pwhash_strbytes:function(){return 128},_crypto_pwhash_strprefix:function(){return 33713},_crypto_scalarmult:BB,_crypto_scalarmult_base:eB,_crypto_scalarmult_bytes:YB,_crypto_scalarmult_scalarbytes:YB,_crypto_secretbox_detached:Z,_crypto_secretbox_easy:function(A,I,g,B,C,Q){return A|=0,I|=0,C|=0,Q|=0,(B|=0)>>>0>0|0==(0|B)&(g|=0)>>>0>4294967279?(SB(),0):(Z(A+16|0,A,I,g,B,C,Q),0)},_crypto_secretbox_keybytes:YB,_crypto_secretbox_keygen:sB,_crypto_secretbox_macbytes:GB,_crypto_secretbox_messagebytes_max:FB,_crypto_secretbox_noncebytes:_B,_crypto_secretbox_open_detached:gA,_crypto_secretbox_open_easy:function(A,I,g,B,C,Q){return I|=0,C|=0,Q|=0,0|((B|=0)>>>0<0|0==(0|B)&(g|=0)>>>0<16?-1:0|gA(A|=0,I+16|0,I,g=0|vg(0|g,0|B,-16,-1),0|o(),C,Q))},_crypto_secretstream_xchacha20poly1305_abytes:function(){return 17},_crypto_secretstream_xchacha20poly1305_headerbytes:_B,_crypto_secretstream_xchacha20poly1305_init_pull:function(A,I,g){var C;return R(A|=0,I|=0,g|=0),Mg(A),C=Q[I+16>>0]|Q[I+16+1>>0]<<8|Q[I+16+2>>0]<<16|Q[I+16+3>>0]<<24,g=Q[I+16+4>>0]|Q[I+16+4+1>>0]<<8|Q[I+16+4+2>>0]<<16|Q[I+16+4+3>>0]<<24,B[A+36>>0]=C,B[A+36+1>>0]=C>>8,B[A+36+2>>0]=C>>16,B[A+36+3>>0]=C>>24,B[A+36+4>>0]=g,B[A+36+4+1>>0]=g>>8,B[A+36+4+2>>0]=g>>16,B[A+36+4+3>>0]=g>>24,B[A+44>>0]=0,B[A+44+1>>0]=0,B[A+44+2>>0]=0,B[A+44+3>>0]=0,B[A+44+4>>0]=0,B[A+44+4+1>>0]=0,B[A+44+4+2>>0]=0,B[A+44+4+3>>0]=0,0},_crypto_secretstream_xchacha20poly1305_init_push:function(A,I,g){return A|=0,g|=0,Cg(I|=0,24),R(A,I,g),Mg(A),g=Q[I+16>>0]|Q[I+16+1>>0]<<8|Q[I+16+2>>0]<<16|Q[I+16+3>>0]<<24,I=Q[I+16+4>>0]|Q[I+16+4+1>>0]<<8|Q[I+16+4+2>>0]<<16|Q[I+16+4+3>>0]<<24,B[A+36>>0]=g,B[A+36+1>>0]=g>>8,B[A+36+2>>0]=g>>16,B[A+36+3>>0]=g>>24,B[A+36+4>>0]=I,B[A+36+4+1>>0]=I>>8,B[A+36+4+2>>0]=I>>16,B[A+36+4+3>>0]=I>>24,B[A+44>>0]=0,B[A+44+1>>0]=0,B[A+44+2>>0]=0,B[A+44+3>>0]=0,B[A+44+4>>0]=0,B[A+44+4+1>>0]=0,B[A+44+4+2>>0]=0,B[A+44+4+3>>0]=0,0},_crypto_secretstream_xchacha20poly1305_keybytes:YB,_crypto_secretstream_xchacha20poly1305_keygen:sB,_crypto_secretstream_xchacha20poly1305_messagebytes_max:function(){return-18},_crypto_secretstream_xchacha20poly1305_pull:function(A,I,g,Q,E,i,e,c,a,n){A|=0,I|=0,Q|=0,E|=0,i|=0,e|=0,c|=0,a|=0,n|=0;var r,t,f=0,w=0,s=0;t=y,r=y=y+63&-64,y=y+352|0,0|(g|=0)&&(C[g>>2]=0,C[g+4>>2]=0),0|Q&&(B[Q>>0]=-1);do{if(e>>>0<0|0==(0|e)&i>>>0<17)c=-1;else{w=0|vg(0|i,0|e,-17,-1),(s=0|o())>>>0>0|0==(0|s)&w>>>0>4294967278&&SB(),OI(r+16|0,64,0,A+32|0,A),gB(r+80|0,r+16|0),MI(r+16|0,64),bg(r+80|0,c,a,n),c=0|Ug(0,0,0|a,0|n),o(),bg(r+80|0,34672,15&c,0),f=64+(c=r+16|0)|0;do{C[c>>2]=0,c=c+4|0}while((0|c)<(0|f));if(B[r+16>>0]=0|B[E>>0],rI(r+16|0,r+16|0,64,0,A+32|0,1,A),c=0|B[r+16>>0],B[r+16>>0]=0|B[E>>0],bg(r+80|0,r+16|0,64,0),bg(r+80|0,E+1|0,w,s),f=0|vg(0|i,0|e,15,0),o(),bg(r+80|0,34672,15&f,0),LI(r+336|0,a,n),bg(r+80|0,r+336|0,8,0),LI(r+336|0,n=0|vg(0|i,0|e,47,0),0|o()),bg(r+80|0,r+336|0,8,0),IB(r+80|0,r),MI(r+80|0,256),0|EI(r,E+1+w|0,16)){MI(r,16),c=-1;break}rI(I,E+1|0,w,s,A+32|0,2,A),ag(A+36|0,r),Ig(A+32|0),(0!=(2&c)||0|lI(A+32|0,4))&&wA(A),0|g&&(C[g>>2]=w,C[g+4>>2]=s),0|Q?(B[Q>>0]=c,c=0):c=0}}while(0);return y=t,0|c},_crypto_secretstream_xchacha20poly1305_push:function(A,I,g,Q,E,i,e,c,a,n){A|=0,I|=0,Q|=0,E|=0,i|=0,e|=0,c|=0,a|=0,n|=0;var r,t,f=0;t=y,f=y=y+63&-64,y=y+336|0,0|(g|=0)&&(C[g>>2]=0,C[g+4>>2]=0),i>>>0>0|0==(0|i)&E>>>0>4294967278&&SB(),OI(f,64,0,A+32|0,A),gB(f+64|0,f),MI(f,64),bg(f+64|0,e,c,a),e=0|Ug(0,0,0|c,0|a),o(),bg(f+64|0,34672,15&e,0),r=(e=f)+64|0;do{C[e>>2]=0,e=e+4|0}while((0|e)<(0|r));return B[f>>0]=n,rI(f,f,64,0,A+32|0,1,A),bg(f+64|0,f,64,0),B[I>>0]=0|B[f>>0],rI(I+1|0,Q,E,i,A+32|0,2,A),bg(f+64|0,I+1|0,E,i),bg(f+64|0,34672,15&E,0),LI(f+320|0,c,a),bg(f+64|0,f+320|0,8,0),LI(f+320|0,Q=0|vg(0|E,0|i,64,0),0|o()),bg(f+64|0,f+320|0,8,0),IB(f+64|0,I+1+E|0),MI(f+64|0,256),ag(A+36|0,I+1+E|0),Ig(A+32|0),(0!=(2&n)||0|lI(A+32|0,4))&&wA(A),0|g&&(n=0|vg(0|E,0|i,17,0),f=0|o(),C[g>>2]=n,C[g+4>>2]=f),y=t,0},_crypto_secretstream_xchacha20poly1305_rekey:wA,_crypto_secretstream_xchacha20poly1305_statebytes:function(){return 52},_crypto_secretstream_xchacha20poly1305_tag_final:pB,_crypto_secretstream_xchacha20poly1305_tag_message:MB,_crypto_secretstream_xchacha20poly1305_tag_push:kB,_crypto_secretstream_xchacha20poly1305_tag_rekey:uB,_crypto_shorthash:function(A,I,g,B,C){return G(A|=0,I|=0,g|=0,B|=0,C|=0),0},_crypto_shorthash_bytes:lB,_crypto_shorthash_keybytes:GB,_crypto_shorthash_keygen:function(A){Cg(A|=0,16)},_crypto_sign:function(A,I,g,B,C,Q){return 0|TA(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0)},_crypto_sign_bytes:dB,_crypto_sign_detached:function(A,I,g,B,C,Q){return kg(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0),0},_crypto_sign_ed25519_pk_to_curve25519:function(A,I){var g,B;return A|=0,B=y,g=y=y+63&-64,y=y+256|0,0==(0|GA(I|=0))&&0==(0|rA(g+88|0,I))&&0!=(0|function(A){var I,g;return I=y,g=y=y+63&-64,y=y+160|0,O(g,A|=0),A=0|cg(g),y=I,0|A}(g+88|0))?(Sg(g),lA(g,g,g+88+40|0),Sg(g+48|0),_A(g+48|0,g+48|0,g+88+40|0),W(g,g),u(g+48|0,g+48|0,g),CA(A,g+48|0),A=0):A=-1,y=B,0|A},_crypto_sign_ed25519_sk_to_curve25519:function(A,I){var g,C,Q;A|=0,C=y,Q=y=y+63&-64,y=y+64|0,RI(Q,I|=0,32,0),B[Q>>0]=-8&B[Q>>0],B[Q+31>>0]=63&B[Q+31>>0]|64,I=Q,g=A+32|0;do{B[A>>0]=0|B[I>>0],A=A+1|0,I=I+1|0}while((0|A)<(0|g));return MI(Q,64),y=C,0},_crypto_sign_final_create:function(A,I,g,B){return function(A,I,g,B){var C,Q;I|=0,g|=0,B|=0,C=y,Q=y=y+63&-64,y=y+64|0,VI(A|=0,Q),hA(I,g,Q,64,0,B,1),y=C}(A|=0,I|=0,g|=0,B|=0),0},_crypto_sign_final_verify:function(A,I,g){return 0|function(A,I,g){var B,C;return I|=0,g|=0,B=y,C=y=y+63&-64,y=y+64|0,VI(A|=0,C),A=0|uA(I,C,64,0,g,1),y=B,0|A}(A|=0,I|=0,g|=0)},_crypto_sign_init:function(A){return function(A){PI(A|=0)}(A|=0),0},_crypto_sign_keypair:function(A,I){return function(A,I){var g,B;A|=0,I|=0,g=y,B=y=y+63&-64,y=y+32|0,Cg(B,32),wI(A,I,B),MI(B,32),y=g}(A|=0,I|=0),0},_crypto_sign_messagebytes_max:function(){return-65},_crypto_sign_open:function(A,I,g,B,C,Q){return 0|SA(A|=0,I|=0,g|=0,B|=0,C|=0,Q|=0)},_crypto_sign_publickeybytes:YB,_crypto_sign_secretkeybytes:dB,_crypto_sign_seed_keypair:function(A,I,g){return wI(A|=0,I|=0,g|=0),0},_crypto_sign_seedbytes:YB,_crypto_sign_statebytes:function(){return 208},_crypto_sign_update:function(A,I,g,B){return xg(A|=0,I|=0,g|=0,B|=0),0},_crypto_sign_verify_detached:function(A,I,g,B,C){return 0|dg(A|=0,I|=0,g|=0,B|=0,C|=0)},_emscripten_get_sbrk_ptr:function(){return 35232},_emscripten_replace_memory:function(A){return B=new Int8Array(A),Q=new Uint8Array(A),C=new Int32Array(A),g=A,!0},_free:d,_i64Add:vg,_i64Subtract:Ug,_malloc:F,_memcpy:BA,_memmove:YI,_memset:YA,_randombytes:function(A,I,g){(g|=0)>>>0<1|1==(0|g)&(I|=0)>>>0<0?Cg(A|=0,I):c(34506,34526,197,34552)},_randombytes_buf:Cg,_randombytes_buf_deterministic:function(A,I,g){OI(A|=0,I|=0,0,34494,g|=0)},_randombytes_close:MB,_randombytes_random:DB,_randombytes_seedbytes:YB,_randombytes_stir:hB,_randombytes_uniform:function(A){var I=0;if((A|=0)>>>0<2)I=0;else{do{I=0|DB()}while(I>>>0<(((0-A|0)>>>0)%(A>>>0)|0)>>>0);I=(I>>>0)%(A>>>0)|0}return 0|I},_sodium_base642bin:m,_sodium_base64_encoded_len:function(A,I){var g;return A|=0,EB(I|=0),(((A>>>0)/3|0)<<2|1)+(4-(3-(g=(0|E((A>>>0)/3|0,-3))+A|0)&0-(I>>>1&1))&0-(1&(g>>>1|g)))|0},_sodium_bin2base64:q,_sodium_bin2hex:function(A,I,g,C){A|=0,g|=0;var E=0,i=0;if((C|=0)>>>0<2147483647&C<<1>>>0<(I|=0)>>>0||SB(),C){I=0;do{i=0|Q[g+I>>0],B[A+(E=I<<1)>>0]=87+(i>>>4)+((65526+(i>>>4)|0)>>>8&217),B[A+(1|E)>>0]=(22272+((15&i)<<8)+(65526+(15&i)&55552)|0)>>>8,I=I+1|0}while((0|I)!=(0|C));I=C<<1}else I=0;return B[A+I>>0]=0,0|A},_sodium_hex2bin:function(A,I,g,E,i,e,o){A|=0,I|=0,g|=0,E|=0,i|=0,e|=0,o|=0;var c=0,a=0,n=0,r=0,t=0,f=0,w=0;A:do{if(E){r=0,f=0,c=0,a=0;I:for(;;){for(;!(255&((t=(65526+(201+(223&(n=0|Q[g+c>>0]))&255)^65520+(201+(223&n)&255))>>>8)|(65526+(48^n)|0)>>>8)|0);){if(!(0!=(0|i)&a<<24>>24==0)){n=0;break I}if(!(0|qg(i,n))){a=r,w=17;break A}if(!((c=c+1|0)>>>0<E>>>0)){a=r,w=17;break A}a=0}if(n=t&201+(223&n)|(65526+(48^n)|0)>>>8&(48^n),r>>>0>=I>>>0){w=9;break}if(a<<24>>24?(B[A+r>>0]=n|255&f,r=r+1|0,n=f):n=n<<4&255,a=~a,!((c=c+1|0)>>>0<E>>>0)){n=0;break}f=n}if(9==(0|w)&&(C[8678]=68,n=-1),a<<24>>24){C[8678]=28,n=0,a=c+-1|0,c=-1;break}if(n){n=0,a=c,c=-1;break}a=r,w=17;break}a=0,c=0,w=17}while(0);return 17==(0|w)&&(n=a,a=c,c=0),o?C[o>>2]=g+a:(0|a)!=(0|E)&&(C[8678]=28,c=-1),0|e&&(C[e>>2]=n),0|c},_sodium_init:function(){var A=0;return 0|C[8676]?A=1:(function(){return A=y,I=y=y+63&-64,y=y+16|0,Zg(I),0|C[I>>2]&&Zg(I),void(y=A);var A,I}(),hB(),function(){var A=0;(0|(A=0|w(30)))>0?C[8677]=A:A=0|C[8677],A>>>0<16?SB():Cg(34688,16)}(),C[8676]=1,A=0),0|A},_sodium_library_minimal:kB,_sodium_library_version_major:function(){return 10},_sodium_library_version_minor:pB,_sodium_pad:function(A,I,g,E,i){A|=0,I|=0,g|=0,i|=0;var e,o,c=0,a=0;if(o=y,e=y=y+63&-64,y=y+16|0,E|=0)if((a=E+-1-(c=E+-1&E?(g>>>0)%(E>>>0)|0:E+-1&g)|0)>>>0>=~g>>>0&&SB(),(a+g|0)>>>0<i>>>0){0|A&&(C[A>>2]=a+g+1),B[e>>0]=0,c=0;do{A=((c^a)-1|0)>>>24,B[(i=I+(a+g)+(0-c)|0)>>0]=128&A|B[e>>0]&B[i>>0]&255,B[e>>0]=0|A|Q[e>>0],c=c+1|0}while((0|c)!=(0|E));c=0}else c=-1;else c=-1;return y=o,0|c},_sodium_unpad:function(A,I,g,B){A|=0,I|=0,g|=0,B|=0;var E,i,e=0,o=0,c=0,a=0,n=0;if(i=y,E=y=y+63&-64,y=y+16|0,C[E>>2]=0,(B+-1|0)>>>0<g>>>0){for(e=0,c=0,a=0;e&=255,o=0|Q[I+(g+-1)+(0-c)>>0],n=(511+(0|C[E>>2])&e+511&511+(128^o))>>>8&1,C[E>>2]=c&0-n|C[E>>2],a=n|255&a,(0|(c=c+1|0))!=(0|B);)e|=o;C[A>>2]=g+-1-(0|C[E>>2]),e=a+-1|0}else e=-1;return y=i,0|e},_sodium_version_string:function(){return 34617},establishStackSpace:function(A,I){y=A|=0},stackAlloc:function(A){var I;return I=y,y=15+(y=y+(A|=0)|0)&-16,0|I},stackRestore:function(A){y=A|=0},stackSave:function(){return 0|y}}}({Math:Math,Int8Array:Int8Array,Int32Array:Int32Array,Uint8Array:Uint8Array},{a:j,b:function(A){s=A},c:function(){return s},d:function(A,I,g,B){j("Assertion failed: "+d(A)+", at: "+[I?d(I):"unknown filename",g,B?d(B):"unknown function"])},e:BA,f:function(){j()},g:function(A){return O[A]()},h:IA,i:function(A,I,g){u.set(u.subarray(I,I+g),A)},j:function(A){var I=IA();if(A>2130706432)return!1;for(var g=Math.max(I,16777216);g<A;)g=g<=536870912?Y(2*g,16777216):Math.min(Y((3*g+2147483648)/4,16777216),2130706432);return!!gA(g)},k:function(A){switch(A){case 30:return 16384;case 85:return 130048;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"==typeof navigator&&navigator.hardwareConcurrency||1}return BA(28),-1},l:function(A){j("OOM")},m:Z,n:$,o:gA,p:AA,q:function(){var A=AA();return I.extraStackTrace&&(A+="\n"+I.extraStackTrace()),$(A)},r:35408},F),aA=(I.___errno_location=cA.___errno_location,I.___muldi3=cA.___muldi3,I.___uremdi3=cA.___uremdi3,I._bitshift64Ashr=cA._bitshift64Ashr,I._bitshift64Lshr=cA._bitshift64Lshr,I._bitshift64Shl=cA._bitshift64Shl,I._crypto_aead_chacha20poly1305_abytes=cA._crypto_aead_chacha20poly1305_abytes,I._crypto_aead_chacha20poly1305_decrypt=cA._crypto_aead_chacha20poly1305_decrypt,I._crypto_aead_chacha20poly1305_decrypt_detached=cA._crypto_aead_chacha20poly1305_decrypt_detached,I._crypto_aead_chacha20poly1305_encrypt=cA._crypto_aead_chacha20poly1305_encrypt,I._crypto_aead_chacha20poly1305_encrypt_detached=cA._crypto_aead_chacha20poly1305_encrypt_detached,I._crypto_aead_chacha20poly1305_ietf_abytes=cA._crypto_aead_chacha20poly1305_ietf_abytes,I._crypto_aead_chacha20poly1305_ietf_decrypt=cA._crypto_aead_chacha20poly1305_ietf_decrypt,I._crypto_aead_chacha20poly1305_ietf_decrypt_detached=cA._crypto_aead_chacha20poly1305_ietf_decrypt_detached,I._crypto_aead_chacha20poly1305_ietf_encrypt=cA._crypto_aead_chacha20poly1305_ietf_encrypt,I._crypto_aead_chacha20poly1305_ietf_encrypt_detached=cA._crypto_aead_chacha20poly1305_ietf_encrypt_detached,I._crypto_aead_chacha20poly1305_ietf_keybytes=cA._crypto_aead_chacha20poly1305_ietf_keybytes,I._crypto_aead_chacha20poly1305_ietf_keygen=cA._crypto_aead_chacha20poly1305_ietf_keygen,I._crypto_aead_chacha20poly1305_ietf_messagebytes_max=cA._crypto_aead_chacha20poly1305_ietf_messagebytes_max,I._crypto_aead_chacha20poly1305_ietf_npubbytes=cA._crypto_aead_chacha20poly1305_ietf_npubbytes,I._crypto_aead_chacha20poly1305_ietf_nsecbytes=cA._crypto_aead_chacha20poly1305_ietf_nsecbytes,I._crypto_aead_chacha20poly1305_keybytes=cA._crypto_aead_chacha20poly1305_keybytes,I._crypto_aead_chacha20poly1305_keygen=cA._crypto_aead_chacha20poly1305_keygen,I._crypto_aead_chacha20poly1305_messagebytes_max=cA._crypto_aead_chacha20poly1305_messagebytes_max,I._crypto_aead_chacha20poly1305_npubbytes=cA._crypto_aead_chacha20poly1305_npubbytes,I._crypto_aead_chacha20poly1305_nsecbytes=cA._crypto_aead_chacha20poly1305_nsecbytes,I._crypto_aead_xchacha20poly1305_ietf_abytes=cA._crypto_aead_xchacha20poly1305_ietf_abytes,I._crypto_aead_xchacha20poly1305_ietf_decrypt=cA._crypto_aead_xchacha20poly1305_ietf_decrypt,I._crypto_aead_xchacha20poly1305_ietf_decrypt_detached=cA._crypto_aead_xchacha20poly1305_ietf_decrypt_detached,I._crypto_aead_xchacha20poly1305_ietf_encrypt=cA._crypto_aead_xchacha20poly1305_ietf_encrypt,I._crypto_aead_xchacha20poly1305_ietf_encrypt_detached=cA._crypto_aead_xchacha20poly1305_ietf_encrypt_detached,I._crypto_aead_xchacha20poly1305_ietf_keybytes=cA._crypto_aead_xchacha20poly1305_ietf_keybytes,I._crypto_aead_xchacha20poly1305_ietf_keygen=cA._crypto_aead_xchacha20poly1305_ietf_keygen,I._crypto_aead_xchacha20poly1305_ietf_messagebytes_max=cA._crypto_aead_xchacha20poly1305_ietf_messagebytes_max,I._crypto_aead_xchacha20poly1305_ietf_npubbytes=cA._crypto_aead_xchacha20poly1305_ietf_npubbytes,I._crypto_aead_xchacha20poly1305_ietf_nsecbytes=cA._crypto_aead_xchacha20poly1305_ietf_nsecbytes,I._crypto_auth=cA._crypto_auth,I._crypto_auth_bytes=cA._crypto_auth_bytes,I._crypto_auth_keybytes=cA._crypto_auth_keybytes,I._crypto_auth_keygen=cA._crypto_auth_keygen,I._crypto_auth_verify=cA._crypto_auth_verify,I._crypto_box_beforenm=cA._crypto_box_beforenm,I._crypto_box_beforenmbytes=cA._crypto_box_beforenmbytes,I._crypto_box_detached=cA._crypto_box_detached,I._crypto_box_detached_afternm=cA._crypto_box_detached_afternm,I._crypto_box_easy=cA._crypto_box_easy,I._crypto_box_easy_afternm=cA._crypto_box_easy_afternm,I._crypto_box_keypair=cA._crypto_box_keypair,I._crypto_box_macbytes=cA._crypto_box_macbytes,I._crypto_box_messagebytes_max=cA._crypto_box_messagebytes_max,I._crypto_box_noncebytes=cA._crypto_box_noncebytes,I._crypto_box_open_detached=cA._crypto_box_open_detached,I._crypto_box_open_detached_afternm=cA._crypto_box_open_detached_afternm,I._crypto_box_open_easy=cA._crypto_box_open_easy,I._crypto_box_open_easy_afternm=cA._crypto_box_open_easy_afternm,I._crypto_box_publickeybytes=cA._crypto_box_publickeybytes,I._crypto_box_seal=cA._crypto_box_seal,I._crypto_box_seal_open=cA._crypto_box_seal_open,I._crypto_box_sealbytes=cA._crypto_box_sealbytes,I._crypto_box_secretkeybytes=cA._crypto_box_secretkeybytes,I._crypto_box_seed_keypair=cA._crypto_box_seed_keypair,I._crypto_box_seedbytes=cA._crypto_box_seedbytes,I._crypto_generichash=cA._crypto_generichash,I._crypto_generichash_bytes=cA._crypto_generichash_bytes,I._crypto_generichash_bytes_max=cA._crypto_generichash_bytes_max,I._crypto_generichash_bytes_min=cA._crypto_generichash_bytes_min,I._crypto_generichash_final=cA._crypto_generichash_final,I._crypto_generichash_init=cA._crypto_generichash_init,I._crypto_generichash_keybytes=cA._crypto_generichash_keybytes,I._crypto_generichash_keybytes_max=cA._crypto_generichash_keybytes_max,I._crypto_generichash_keybytes_min=cA._crypto_generichash_keybytes_min,I._crypto_generichash_keygen=cA._crypto_generichash_keygen,I._crypto_generichash_statebytes=cA._crypto_generichash_statebytes,I._crypto_generichash_update=cA._crypto_generichash_update,I._crypto_hash=cA._crypto_hash,I._crypto_hash_bytes=cA._crypto_hash_bytes,I._crypto_kdf_bytes_max=cA._crypto_kdf_bytes_max,I._crypto_kdf_bytes_min=cA._crypto_kdf_bytes_min,I._crypto_kdf_contextbytes=cA._crypto_kdf_contextbytes,I._crypto_kdf_derive_from_key=cA._crypto_kdf_derive_from_key,I._crypto_kdf_keybytes=cA._crypto_kdf_keybytes,I._crypto_kdf_keygen=cA._crypto_kdf_keygen,I._crypto_kx_client_session_keys=cA._crypto_kx_client_session_keys,I._crypto_kx_keypair=cA._crypto_kx_keypair,I._crypto_kx_publickeybytes=cA._crypto_kx_publickeybytes,I._crypto_kx_secretkeybytes=cA._crypto_kx_secretkeybytes,I._crypto_kx_seed_keypair=cA._crypto_kx_seed_keypair,I._crypto_kx_seedbytes=cA._crypto_kx_seedbytes,I._crypto_kx_server_session_keys=cA._crypto_kx_server_session_keys,I._crypto_kx_sessionkeybytes=cA._crypto_kx_sessionkeybytes,I._crypto_pwhash=cA._crypto_pwhash,I._crypto_pwhash_alg_argon2i13=cA._crypto_pwhash_alg_argon2i13,I._crypto_pwhash_alg_argon2id13=cA._crypto_pwhash_alg_argon2id13,I._crypto_pwhash_alg_default=cA._crypto_pwhash_alg_default,I._crypto_pwhash_bytes_max=cA._crypto_pwhash_bytes_max,I._crypto_pwhash_bytes_min=cA._crypto_pwhash_bytes_min,I._crypto_pwhash_memlimit_interactive=cA._crypto_pwhash_memlimit_interactive,I._crypto_pwhash_memlimit_max=cA._crypto_pwhash_memlimit_max,I._crypto_pwhash_memlimit_min=cA._crypto_pwhash_memlimit_min,I._crypto_pwhash_memlimit_moderate=cA._crypto_pwhash_memlimit_moderate,I._crypto_pwhash_memlimit_sensitive=cA._crypto_pwhash_memlimit_sensitive,I._crypto_pwhash_opslimit_interactive=cA._crypto_pwhash_opslimit_interactive,I._crypto_pwhash_opslimit_max=cA._crypto_pwhash_opslimit_max,I._crypto_pwhash_opslimit_min=cA._crypto_pwhash_opslimit_min,I._crypto_pwhash_opslimit_moderate=cA._crypto_pwhash_opslimit_moderate,I._crypto_pwhash_opslimit_sensitive=cA._crypto_pwhash_opslimit_sensitive,I._crypto_pwhash_passwd_max=cA._crypto_pwhash_passwd_max,I._crypto_pwhash_passwd_min=cA._crypto_pwhash_passwd_min,I._crypto_pwhash_saltbytes=cA._crypto_pwhash_saltbytes,I._crypto_pwhash_str=cA._crypto_pwhash_str,I._crypto_pwhash_str_alg=cA._crypto_pwhash_str_alg,I._crypto_pwhash_str_needs_rehash=cA._crypto_pwhash_str_needs_rehash,I._crypto_pwhash_str_verify=cA._crypto_pwhash_str_verify,I._crypto_pwhash_strbytes=cA._crypto_pwhash_strbytes,I._crypto_pwhash_strprefix=cA._crypto_pwhash_strprefix,I._crypto_scalarmult=cA._crypto_scalarmult,I._crypto_scalarmult_base=cA._crypto_scalarmult_base,I._crypto_scalarmult_bytes=cA._crypto_scalarmult_bytes,I._crypto_scalarmult_scalarbytes=cA._crypto_scalarmult_scalarbytes,I._crypto_secretbox_detached=cA._crypto_secretbox_detached,I._crypto_secretbox_easy=cA._crypto_secretbox_easy,I._crypto_secretbox_keybytes=cA._crypto_secretbox_keybytes,I._crypto_secretbox_keygen=cA._crypto_secretbox_keygen,I._crypto_secretbox_macbytes=cA._crypto_secretbox_macbytes,I._crypto_secretbox_messagebytes_max=cA._crypto_secretbox_messagebytes_max,I._crypto_secretbox_noncebytes=cA._crypto_secretbox_noncebytes,I._crypto_secretbox_open_detached=cA._crypto_secretbox_open_detached,I._crypto_secretbox_open_easy=cA._crypto_secretbox_open_easy,I._crypto_secretstream_xchacha20poly1305_abytes=cA._crypto_secretstream_xchacha20poly1305_abytes,I._crypto_secretstream_xchacha20poly1305_headerbytes=cA._crypto_secretstream_xchacha20poly1305_headerbytes,I._crypto_secretstream_xchacha20poly1305_init_pull=cA._crypto_secretstream_xchacha20poly1305_init_pull,I._crypto_secretstream_xchacha20poly1305_init_push=cA._crypto_secretstream_xchacha20poly1305_init_push,I._crypto_secretstream_xchacha20poly1305_keybytes=cA._crypto_secretstream_xchacha20poly1305_keybytes,I._crypto_secretstream_xchacha20poly1305_keygen=cA._crypto_secretstream_xchacha20poly1305_keygen,I._crypto_secretstream_xchacha20poly1305_messagebytes_max=cA._crypto_secretstream_xchacha20poly1305_messagebytes_max,I._crypto_secretstream_xchacha20poly1305_pull=cA._crypto_secretstream_xchacha20poly1305_pull,I._crypto_secretstream_xchacha20poly1305_push=cA._crypto_secretstream_xchacha20poly1305_push,I._crypto_secretstream_xchacha20poly1305_rekey=cA._crypto_secretstream_xchacha20poly1305_rekey,I._crypto_secretstream_xchacha20poly1305_statebytes=cA._crypto_secretstream_xchacha20poly1305_statebytes,I._crypto_secretstream_xchacha20poly1305_tag_final=cA._crypto_secretstream_xchacha20poly1305_tag_final,I._crypto_secretstream_xchacha20poly1305_tag_message=cA._crypto_secretstream_xchacha20poly1305_tag_message,I._crypto_secretstream_xchacha20poly1305_tag_push=cA._crypto_secretstream_xchacha20poly1305_tag_push,I._crypto_secretstream_xchacha20poly1305_tag_rekey=cA._crypto_secretstream_xchacha20poly1305_tag_rekey,I._crypto_shorthash=cA._crypto_shorthash,I._crypto_shorthash_bytes=cA._crypto_shorthash_bytes,I._crypto_shorthash_keybytes=cA._crypto_shorthash_keybytes,I._crypto_shorthash_keygen=cA._crypto_shorthash_keygen,I._crypto_sign=cA._crypto_sign,I._crypto_sign_bytes=cA._crypto_sign_bytes,I._crypto_sign_detached=cA._crypto_sign_detached,I._crypto_sign_ed25519_pk_to_curve25519=cA._crypto_sign_ed25519_pk_to_curve25519,I._crypto_sign_ed25519_sk_to_curve25519=cA._crypto_sign_ed25519_sk_to_curve25519,I._crypto_sign_final_create=cA._crypto_sign_final_create,I._crypto_sign_final_verify=cA._crypto_sign_final_verify,I._crypto_sign_init=cA._crypto_sign_init,I._crypto_sign_keypair=cA._crypto_sign_keypair,I._crypto_sign_messagebytes_max=cA._crypto_sign_messagebytes_max,I._crypto_sign_open=cA._crypto_sign_open,I._crypto_sign_publickeybytes=cA._crypto_sign_publickeybytes,I._crypto_sign_secretkeybytes=cA._crypto_sign_secretkeybytes,I._crypto_sign_seed_keypair=cA._crypto_sign_seed_keypair,I._crypto_sign_seedbytes=cA._crypto_sign_seedbytes,I._crypto_sign_statebytes=cA._crypto_sign_statebytes,I._crypto_sign_update=cA._crypto_sign_update,I._crypto_sign_verify_detached=cA._crypto_sign_verify_detached,I._emscripten_get_sbrk_ptr=cA._emscripten_get_sbrk_ptr,I._emscripten_replace_memory=cA._emscripten_replace_memory);if(I._free=cA._free,I._i64Add=cA._i64Add,I._i64Subtract=cA._i64Subtract,I._malloc=cA._malloc,I._memcpy=cA._memcpy,I._memmove=cA._memmove,I._memset=cA._memset,I._randombytes=cA._randombytes,I._randombytes_buf=cA._randombytes_buf,I._randombytes_buf_deterministic=cA._randombytes_buf_deterministic,I._randombytes_close=cA._randombytes_close,I._randombytes_random=cA._randombytes_random,I._randombytes_seedbytes=cA._randombytes_seedbytes,I._randombytes_stir=cA._randombytes_stir,I._randombytes_uniform=cA._randombytes_uniform,I._sodium_base642bin=cA._sodium_base642bin,I._sodium_base64_encoded_len=cA._sodium_base64_encoded_len,I._sodium_bin2base64=cA._sodium_bin2base64,I._sodium_bin2hex=cA._sodium_bin2hex,I._sodium_hex2bin=cA._sodium_hex2bin,I._sodium_init=cA._sodium_init,I._sodium_library_minimal=cA._sodium_library_minimal,I._sodium_library_version_major=cA._sodium_library_version_major,I._sodium_library_version_minor=cA._sodium_library_version_minor,I._sodium_pad=cA._sodium_pad,I._sodium_unpad=cA._sodium_unpad,I._sodium_version_string=cA._sodium_version_string,I.establishStackSpace=cA.establishStackSpace,I.stackAlloc=cA.stackAlloc,I.stackRestore=cA.stackRestore,I.stackSave=cA.stackSave,I.asm=cA,I.setValue=function(A,I,g,B){switch("*"===(g=g||"i8").charAt(g.length-1)&&(g="i32"),g){case"i1":case"i8":p[A>>0]=I;break;case"i16":H[A>>1]=I;break;case"i32":k[A>>2]=I;break;case"i64":q=[I>>>0,(T=I,+R(T)>=1?T>0?(0|L(+m(T/4294967296),4294967295))>>>0:~~+N((T-+(~~T>>>0))/4294967296)>>>0:0)],k[A>>2]=q[0],k[A+4>>2]=q[1];break;case"float":l[A>>2]=I;break;case"double":_[A>>3]=I;break;default:j("invalid type for setValue: "+g)}},I.getValue=function(A,I,g){switch("*"===(I=I||"i8").charAt(I.length-1)&&(I="i32"),I){case"i1":case"i8":return p[A>>0];case"i16":return H[A>>1];case"i32":case"i64":return k[A>>2];case"float":return l[A>>2];case"double":return _[A>>3];default:j("invalid type for getValue: "+I)}return null},I.UTF8ToString=d,V)if(W(V)||(eA=V,V=I.locateFile?I.locateFile(eA,f):f+eA),o||i){var nA=n(V);u.set(nA,8)}else{x++,I.monitorRunDependencies&&I.monitorRunDependencies(x);var rA=function(A){A.byteLength&&(A=new Uint8Array(A)),u.set(A,8),I.memoryInitializerRequest&&delete I.memoryInitializerRequest.response,function(A){if(x--,I.monitorRunDependencies&&I.monitorRunDependencies(x),0==x&&(null!==K&&(clearInterval(K),K=null),X)){var g=X;X=null,g()}}()},tA=function(){a(V,rA,function(){throw"could not load memory initializer "+V})},fA=iA(V);if(fA)rA(fA.buffer);else if(I.memoryInitializerRequest){var wA=function(){var A=I.memoryInitializerRequest,g=A.response;if(200!==A.status&&0!==A.status){var B=iA(I.memoryInitializerRequestURL);if(!B)return void tA();g=B.buffer}rA(g)};I.memoryInitializerRequest.response?setTimeout(wA,0):I.memoryInitializerRequest.addEventListener("load",wA)}else tA()}function yA(A){function g(){oA||(oA=!0,h||(U(b),U(J),I.onRuntimeInitialized&&I.onRuntimeInitialized(),function(){if(I.postRun)for("function"==typeof I.postRun&&(I.postRun=[I.postRun]);I.postRun.length;)A=I.postRun.shift(),P.unshift(A);var A;U(P)}()))}A=A||e,x>0||(function(){if(I.preRun)for("function"==typeof I.preRun&&(I.preRun=[I.preRun]);I.preRun.length;)A=I.preRun.shift(),v.unshift(A);var A;U(v)}(),x>0||(I.setStatus?(I.setStatus("Running..."),setTimeout(function(){setTimeout(function(){I.setStatus("")},1),g()},1)):g()))}if(X=function A(){oA||yA(),oA||(X=A)},I.run=yA,I.preInit)for("function"==typeof I.preInit&&(I.preInit=[I.preInit]);I.preInit.length>0;)I.preInit.pop()();yA(),Object.keys(B).forEach(function(A){"getRandomValue"!==A&&delete B[A]}),Object.keys(I).forEach(function(A){B[A]=I[A]})};var g,C=void 0!==C?C:{},Q={};for(g in C)C.hasOwnProperty(g)&&(Q[g]=C[g]);var E,i,e=[],o=!1,c=!1,a=!1;o="object"==typeof window,c="function"==typeof importScripts,E="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node,a=E&&!o&&!c,i=!o&&!a&&!c;var n,r,t,f,w="";a?(w=__dirname+"/",n=function(A,I){var g;return(g=eA(A))||(t||(t=require("fs")),f||(f=require("path")),A=f.normalize(A),g=t.readFileSync(A)),I?g:g.toString()},r=function(A){var I=n(A,!0);return I.buffer||(I=new Uint8Array(I)),H(I.buffer),I},process.argv.length>1&&process.argv[1].replace(/\\/g,"/"),e=process.argv.slice(2),"undefined"!=typeof module&&(module.exports=C),process.on("unhandledRejection",z),C.inspect=function(){return"[Emscripten Module object]"}):i?("undefined"!=typeof read&&(n=function(A){var I=eA(A);return I?EA(I):read(A)}),r=function(A){var I;return(I=eA(A))?I:"function"==typeof readbuffer?new Uint8Array(readbuffer(A)):(H("object"==typeof(I=read(A,"binary"))),I)},"undefined"!=typeof scriptArgs?e=scriptArgs:void 0!==arguments&&(e=arguments),"undefined"!=typeof print&&("undefined"==typeof console&&(console={}),console.log=print,console.warn=console.error="undefined"!=typeof printErr?printErr:print)):(o||c)&&(c?w=self.location.href:document.currentScript&&(w=document.currentScript.src),w=0!==w.indexOf("blob:")?w.substr(0,w.lastIndexOf("/")+1):"",n=function(A){try{var I=new XMLHttpRequest;return I.open("GET",A,!1),I.send(null),I.responseText}catch(I){var g=eA(A);if(g)return EA(g);throw I}},c&&(r=function(A){try{var I=new XMLHttpRequest;return I.open("GET",A,!1),I.responseType="arraybuffer",I.send(null),new Uint8Array(I.response)}catch(I){var g=eA(A);if(g)return g;throw I}}));var y=C.print||void 0,s=C.printErr||void 0;for(g in Q)Q.hasOwnProperty(g)&&(C[g]=Q[g]);Q=null,C.arguments&&(e=C.arguments),C.thisProgram&&C.thisProgram,C.quit&&C.quit;var h,D,F={"f64-rem":function(A,I){return A%I},debugger:function(){}};new Array(8),C.wasmBinary&&(h=C.wasmBinary),C.noExitRuntime&&C.noExitRuntime,"object"!=typeof WebAssembly&&s("no native wasm support detected");var p=new WebAssembly.Table({initial:0,maximum:0,element:"anyfunc"}),u=!1;function H(A,I){A||z("Assertion failed: "+I)}var k,l,_,G,d,Y,M,S="undefined"!=typeof TextDecoder?new TextDecoder("utf8"):void 0;function U(A,I){return A?function(A,I,g){for(var B=I+g,C=I;A[C]&&!(C>=B);)++C;if(C-I>16&&A.subarray&&S)return S.decode(A.subarray(I,C));for(var Q="";I<C;){var E=A[I++];if(128&E){var i=63&A[I++];if(192!=(224&E)){var e=63&A[I++];if((E=224==(240&E)?(15&E)<<12|i<<6|e:(7&E)<<18|i<<12|e<<6|63&A[I++])<65536)Q+=String.fromCharCode(E);else{var o=E-65536;Q+=String.fromCharCode(55296|o>>10,56320|1023&o)}}else Q+=String.fromCharCode((31&E)<<6|i)}else Q+=String.fromCharCode(E)}return Q}(_,A,I):""}function v(A,I){return A%I>0&&(A+=I-A%I),A}function b(A){k=A,C.HEAP8=l=new Int8Array(A),C.HEAP16=G=new Int16Array(A),C.HEAP32=d=new Int32Array(A),C.HEAPU8=_=new Uint8Array(A),C.HEAPU16=new Uint16Array(A),C.HEAPU32=new Uint32Array(A),C.HEAPF32=Y=new Float32Array(A),C.HEAPF64=M=new Float64Array(A)}"undefined"!=typeof TextDecoder&&new TextDecoder("utf-16le");var J=C.TOTAL_MEMORY||16777216;function P(A){for(;A.length>0;){var I=A.shift();if("function"!=typeof I){var g=I.func;"number"==typeof g?void 0===I.arg?C.dynCall_v(g):C.dynCall_vi(g,I.arg):g(void 0===I.arg?null:I.arg)}else I()}}(D=C.wasmMemory?C.wasmMemory:new WebAssembly.Memory({initial:J/65536}))&&(k=D.buffer),J=k.byteLength,b(k),d[9312]=5280320;var R=[],N=[],m=[],L=[],x=Math.abs,K=Math.ceil,X=Math.floor,j=Math.min,T=0,q=null,V=null;function z(A){throw C.onAbort&&C.onAbort(A),y(A+=""),s(A),u=!0,"abort("+A+"). Build with -s ASSERTIONS=1 for more info."}C.preloadedImages={},C.preloadedAudios={};var W="data:application/octet-stream;base64,";function O(A){return String.prototype.startsWith?A.startsWith(W):0===A.indexOf(W)}var Z,$,AA,IA="data:application/octet-stream;base64,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";function gA(){try{if(h)return new Uint8Array(h);var A=eA(IA);if(A)return A;if(r)return r(IA);throw"both async and sync fetching of the wasm failed"}catch(A){z(A)}}O(IA)||(Z=IA,IA=C.locateFile?C.locateFile(Z,w):w+Z),C.asm=function(){var A={env:cA,wasi_unstable:cA,global:{NaN:NaN,Infinity:1/0},"global.Math":Math,asm2wasm:F};function I(A,I){var g=A.exports;C.asm=g,function(A){if(T--,C.monitorRunDependencies&&C.monitorRunDependencies(T),0==T&&(null!==q&&(clearInterval(q),q=null),V)){var I=V;V=null,I()}}()}function g(A){I(A.instance)}function B(I){return(h||!o&&!c||"function"!=typeof fetch?new Promise(function(A,I){A(gA())}):fetch(IA,{credentials:"same-origin"}).then(function(A){if(!A.ok)throw"failed to load wasm binary file at '"+IA+"'";return A.arrayBuffer()}).catch(function(){return gA()})).then(function(I){return WebAssembly.instantiate(I,A)}).then(I,function(A){s("failed to asynchronously prepare wasm: "+A),z(A)})}if(T++,C.monitorRunDependencies&&C.monitorRunDependencies(T),C.instantiateWasm)try{return C.instantiateWasm(A,I)}catch(A){return s("Module.instantiateWasm callback failed with error: "+A),!1}return function(){if(h||"function"!=typeof WebAssembly.instantiateStreaming||O(IA)||"function"!=typeof fetch)return B(g);fetch(IA,{credentials:"same-origin"}).then(function(I){return WebAssembly.instantiateStreaming(I,A).then(g,function(A){s("wasm streaming compile failed: "+A),s("falling back to ArrayBuffer instantiation"),B(g)})})}(),{}};var BA=[function(){return C.getRandomValue()},function(){if(void 0===C.getRandomValue)try{var A="object"==typeof window?window:self,I=void 0!==A.crypto?A.crypto:A.msCrypto,g=function(){var A=new Uint32Array(1);return I.getRandomValues(A),A[0]>>>0};g(),C.getRandomValue=g}catch(A){try{var B=require("crypto"),Q=function(){var A=B.randomBytes(4);return(A[0]<<24|A[1]<<16|A[2]<<8|A[3])>>>0};Q(),C.getRandomValue=Q}catch(A){throw"No secure random number generator found"}}}];function CA(){return l.length}var QA=!1;function EA(A){for(var I=[],g=0;g<A.length;g++){var B=A[g];B>255&&(QA&&H(!1,"Character code "+B+" ("+String.fromCharCode(B)+")  at offset "+g+" not in 0x00-0xFF."),B&=255),I.push(String.fromCharCode(B))}return I.join("")}var iA="function"==typeof atob?atob:function(A){var I,g,B,C,Q,E,i="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",e="",o=0;A=A.replace(/[^A-Za-z0-9\+\/\=]/g,"");do{I=i.indexOf(A.charAt(o++))<<2|(C=i.indexOf(A.charAt(o++)))>>4,g=(15&C)<<4|(Q=i.indexOf(A.charAt(o++)))>>2,B=(3&Q)<<6|(E=i.indexOf(A.charAt(o++))),e+=String.fromCharCode(I),64!==Q&&(e+=String.fromCharCode(g)),64!==E&&(e+=String.fromCharCode(B))}while(o<A.length);return e};function eA(A){if(O(A))return function(A){if("boolean"==typeof a&&a){var I;try{I=Buffer.from(A,"base64")}catch(g){I=new Buffer(A,"base64")}return new Uint8Array(I.buffer,I.byteOffset,I.byteLength)}try{for(var g=iA(A),B=new Uint8Array(g.length),C=0;C<g.length;++C)B[C]=g.charCodeAt(C);return B}catch(A){throw new Error("Converting base64 string to bytes failed.")}}(A.slice(W.length))}var oA,cA={c:function(A,I,g,B){z("Assertion failed: "+U(A)+", at: "+[I?U(I):"unknown filename",g,B?U(B):"unknown function"])},__memory_base:1024,__table_base:0,a:function(){z()},b:function(A){return BA[A]()},g:CA,f:function(A,I,g){_.set(_.subarray(I,I+g),A)},e:function(A){var I=CA();if(A>2147418112)return!1;for(var g=Math.max(I,16777216);g<A;)g=g<=536870912?v(2*g,65536):Math.min(v((3*g+2147483648)/4,65536),2147418112);return!!function(A){try{return D.grow(A-k.byteLength+65535>>16),b(D.buffer),1}catch(A){}}(g)},d:function(A){switch(A){case 30:return 16384;case 85:return 131068;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:return"object"==typeof navigator&&navigator.hardwareConcurrency||1}return C.___errno_location&&(d[C.___errno_location()>>2]=28),-1},memory:D,table:p},aA=C.asm({},cA,k);function nA(A){function I(){oA||(oA=!0,u||(P(N),P(m),C.onRuntimeInitialized&&C.onRuntimeInitialized(),function(){if(C.postRun)for("function"==typeof C.postRun&&(C.postRun=[C.postRun]);C.postRun.length;)A=C.postRun.shift(),L.unshift(A);var A;P(L)}()))}A=A||e,T>0||(function(){if(C.preRun)for("function"==typeof C.preRun&&(C.preRun=[C.preRun]);C.preRun.length;)A=C.preRun.shift(),R.unshift(A);var A;P(R)}(),T>0||(C.setStatus?(C.setStatus("Running..."),setTimeout(function(){setTimeout(function(){C.setStatus("")},1),I()},1)):I()))}if(C.asm=aA,C.___errno_location=function(){return C.asm.h.apply(null,arguments)},C._crypto_aead_chacha20poly1305_abytes=function(){return C.asm.i.apply(null,arguments)},C._crypto_aead_chacha20poly1305_decrypt=function(){return C.asm.j.apply(null,arguments)},C._crypto_aead_chacha20poly1305_decrypt_detached=function(){return C.asm.k.apply(null,arguments)},C._crypto_aead_chacha20poly1305_encrypt=function(){return C.asm.l.apply(null,arguments)},C._crypto_aead_chacha20poly1305_encrypt_detached=function(){return C.asm.m.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_abytes=function(){return C.asm.n.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_decrypt=function(){return C.asm.o.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_decrypt_detached=function(){return C.asm.p.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_encrypt=function(){return C.asm.q.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_encrypt_detached=function(){return C.asm.r.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_keybytes=function(){return C.asm.s.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_keygen=function(){return C.asm.t.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_messagebytes_max=function(){return C.asm.u.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_npubbytes=function(){return C.asm.v.apply(null,arguments)},C._crypto_aead_chacha20poly1305_ietf_nsecbytes=function(){return C.asm.w.apply(null,arguments)},C._crypto_aead_chacha20poly1305_keybytes=function(){return C.asm.x.apply(null,arguments)},C._crypto_aead_chacha20poly1305_keygen=function(){return C.asm.y.apply(null,arguments)},C._crypto_aead_chacha20poly1305_messagebytes_max=function(){return C.asm.z.apply(null,arguments)},C._crypto_aead_chacha20poly1305_npubbytes=function(){return C.asm.A.apply(null,arguments)},C._crypto_aead_chacha20poly1305_nsecbytes=function(){return C.asm.B.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_abytes=function(){return C.asm.C.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_decrypt=function(){return C.asm.D.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_decrypt_detached=function(){return C.asm.E.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_encrypt=function(){return C.asm.F.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_encrypt_detached=function(){return C.asm.G.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_keybytes=function(){return C.asm.H.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_keygen=function(){return C.asm.I.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_messagebytes_max=function(){return C.asm.J.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_npubbytes=function(){return C.asm.K.apply(null,arguments)},C._crypto_aead_xchacha20poly1305_ietf_nsecbytes=function(){return C.asm.L.apply(null,arguments)},C._crypto_auth=function(){return C.asm.M.apply(null,arguments)},C._crypto_auth_bytes=function(){return C.asm.N.apply(null,arguments)},C._crypto_auth_keybytes=function(){return C.asm.O.apply(null,arguments)},C._crypto_auth_keygen=function(){return C.asm.P.apply(null,arguments)},C._crypto_auth_verify=function(){return C.asm.Q.apply(null,arguments)},C._crypto_box_beforenm=function(){return C.asm.R.apply(null,arguments)},C._crypto_box_beforenmbytes=function(){return C.asm.S.apply(null,arguments)},C._crypto_box_detached=function(){return C.asm.T.apply(null,arguments)},C._crypto_box_detached_afternm=function(){return C.asm.U.apply(null,arguments)},C._crypto_box_easy=function(){return C.asm.V.apply(null,arguments)},C._crypto_box_easy_afternm=function(){return C.asm.W.apply(null,arguments)},C._crypto_box_keypair=function(){return C.asm.X.apply(null,arguments)},C._crypto_box_macbytes=function(){return C.asm.Y.apply(null,arguments)},C._crypto_box_messagebytes_max=function(){return C.asm.Z.apply(null,arguments)},C._crypto_box_noncebytes=function(){return C.asm._.apply(null,arguments)},C._crypto_box_open_detached=function(){return C.asm.$.apply(null,arguments)},C._crypto_box_open_detached_afternm=function(){return C.asm.aa.apply(null,arguments)},C._crypto_box_open_easy=function(){return C.asm.ba.apply(null,arguments)},C._crypto_box_open_easy_afternm=function(){return C.asm.ca.apply(null,arguments)},C._crypto_box_publickeybytes=function(){return C.asm.da.apply(null,arguments)},C._crypto_box_seal=function(){return C.asm.ea.apply(null,arguments)},C._crypto_box_seal_open=function(){return C.asm.fa.apply(null,arguments)},C._crypto_box_sealbytes=function(){return C.asm.ga.apply(null,arguments)},C._crypto_box_secretkeybytes=function(){return C.asm.ha.apply(null,arguments)},C._crypto_box_seed_keypair=function(){return C.asm.ia.apply(null,arguments)},C._crypto_box_seedbytes=function(){return C.asm.ja.apply(null,arguments)},C._crypto_generichash=function(){return C.asm.ka.apply(null,arguments)},C._crypto_generichash_bytes=function(){return C.asm.la.apply(null,arguments)},C._crypto_generichash_bytes_max=function(){return C.asm.ma.apply(null,arguments)},C._crypto_generichash_bytes_min=function(){return C.asm.na.apply(null,arguments)},C._crypto_generichash_final=function(){return C.asm.oa.apply(null,arguments)},C._crypto_generichash_init=function(){return C.asm.pa.apply(null,arguments)},C._crypto_generichash_keybytes=function(){return C.asm.qa.apply(null,arguments)},C._crypto_generichash_keybytes_max=function(){return C.asm.ra.apply(null,arguments)},C._crypto_generichash_keybytes_min=function(){return C.asm.sa.apply(null,arguments)},C._crypto_generichash_keygen=function(){return C.asm.ta.apply(null,arguments)},C._crypto_generichash_statebytes=function(){return C.asm.ua.apply(null,arguments)},C._crypto_generichash_update=function(){return C.asm.va.apply(null,arguments)},C._crypto_hash=function(){return C.asm.wa.apply(null,arguments)},C._crypto_hash_bytes=function(){return C.asm.xa.apply(null,arguments)},C._crypto_kdf_bytes_max=function(){return C.asm.ya.apply(null,arguments)},C._crypto_kdf_bytes_min=function(){return C.asm.za.apply(null,arguments)},C._crypto_kdf_contextbytes=function(){return C.asm.Aa.apply(null,arguments)},C._crypto_kdf_derive_from_key=function(){return C.asm.Ba.apply(null,arguments)},C._crypto_kdf_keybytes=function(){return C.asm.Ca.apply(null,arguments)},C._crypto_kdf_keygen=function(){return C.asm.Da.apply(null,arguments)},C._crypto_kx_client_session_keys=function(){return C.asm.Ea.apply(null,arguments)},C._crypto_kx_keypair=function(){return C.asm.Fa.apply(null,arguments)},C._crypto_kx_publickeybytes=function(){return C.asm.Ga.apply(null,arguments)},C._crypto_kx_secretkeybytes=function(){return C.asm.Ha.apply(null,arguments)},C._crypto_kx_seed_keypair=function(){return C.asm.Ia.apply(null,arguments)},C._crypto_kx_seedbytes=function(){return C.asm.Ja.apply(null,arguments)},C._crypto_kx_server_session_keys=function(){return C.asm.Ka.apply(null,arguments)},C._crypto_kx_sessionkeybytes=function(){return C.asm.La.apply(null,arguments)},C._crypto_pwhash=function(){return C.asm.Ma.apply(null,arguments)},C._crypto_pwhash_alg_argon2i13=function(){return C.asm.Na.apply(null,arguments)},C._crypto_pwhash_alg_argon2id13=function(){return C.asm.Oa.apply(null,arguments)},C._crypto_pwhash_alg_default=function(){return C.asm.Pa.apply(null,arguments)},C._crypto_pwhash_bytes_max=function(){return C.asm.Qa.apply(null,arguments)},C._crypto_pwhash_bytes_min=function(){return C.asm.Ra.apply(null,arguments)},C._crypto_pwhash_memlimit_interactive=function(){return C.asm.Sa.apply(null,arguments)},C._crypto_pwhash_memlimit_max=function(){return C.asm.Ta.apply(null,arguments)},C._crypto_pwhash_memlimit_min=function(){return C.asm.Ua.apply(null,arguments)},C._crypto_pwhash_memlimit_moderate=function(){return C.asm.Va.apply(null,arguments)},C._crypto_pwhash_memlimit_sensitive=function(){return C.asm.Wa.apply(null,arguments)},C._crypto_pwhash_opslimit_interactive=function(){return C.asm.Xa.apply(null,arguments)},C._crypto_pwhash_opslimit_max=function(){return C.asm.Ya.apply(null,arguments)},C._crypto_pwhash_opslimit_min=function(){return C.asm.Za.apply(null,arguments)},C._crypto_pwhash_opslimit_moderate=function(){return C.asm._a.apply(null,arguments)},C._crypto_pwhash_opslimit_sensitive=function(){return C.asm.$a.apply(null,arguments)},C._crypto_pwhash_passwd_max=function(){return C.asm.ab.apply(null,arguments)},C._crypto_pwhash_passwd_min=function(){return C.asm.bb.apply(null,arguments)},C._crypto_pwhash_saltbytes=function(){return C.asm.cb.apply(null,arguments)},C._crypto_pwhash_str=function(){return C.asm.db.apply(null,arguments)},C._crypto_pwhash_str_alg=function(){return C.asm.eb.apply(null,arguments)},C._crypto_pwhash_str_needs_rehash=function(){return C.asm.fb.apply(null,arguments)},C._crypto_pwhash_str_verify=function(){return C.asm.gb.apply(null,arguments)},C._crypto_pwhash_strbytes=function(){return C.asm.hb.apply(null,arguments)},C._crypto_pwhash_strprefix=function(){return C.asm.ib.apply(null,arguments)},C._crypto_scalarmult=function(){return C.asm.jb.apply(null,arguments)},C._crypto_scalarmult_base=function(){return C.asm.kb.apply(null,arguments)},C._crypto_scalarmult_bytes=function(){return C.asm.lb.apply(null,arguments)},C._crypto_scalarmult_scalarbytes=function(){return C.asm.mb.apply(null,arguments)},C._crypto_secretbox_detached=function(){return C.asm.nb.apply(null,arguments)},C._crypto_secretbox_easy=function(){return C.asm.ob.apply(null,arguments)},C._crypto_secretbox_keybytes=function(){return C.asm.pb.apply(null,arguments)},C._crypto_secretbox_keygen=function(){return C.asm.qb.apply(null,arguments)},C._crypto_secretbox_macbytes=function(){return C.asm.rb.apply(null,arguments)},C._crypto_secretbox_messagebytes_max=function(){return C.asm.sb.apply(null,arguments)},C._crypto_secretbox_noncebytes=function(){return C.asm.tb.apply(null,arguments)},C._crypto_secretbox_open_detached=function(){return C.asm.ub.apply(null,arguments)},C._crypto_secretbox_open_easy=function(){return C.asm.vb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_abytes=function(){return C.asm.wb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_headerbytes=function(){return C.asm.xb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_init_pull=function(){return C.asm.yb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_init_push=function(){return C.asm.zb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_keybytes=function(){return C.asm.Ab.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_keygen=function(){return C.asm.Bb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_messagebytes_max=function(){return C.asm.Cb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_pull=function(){return C.asm.Db.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_push=function(){return C.asm.Eb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_rekey=function(){return C.asm.Fb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_statebytes=function(){return C.asm.Gb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_tag_final=function(){return C.asm.Hb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_tag_message=function(){return C.asm.Ib.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_tag_push=function(){return C.asm.Jb.apply(null,arguments)},C._crypto_secretstream_xchacha20poly1305_tag_rekey=function(){return C.asm.Kb.apply(null,arguments)},C._crypto_shorthash=function(){return C.asm.Lb.apply(null,arguments)},C._crypto_shorthash_bytes=function(){return C.asm.Mb.apply(null,arguments)},C._crypto_shorthash_keybytes=function(){return C.asm.Nb.apply(null,arguments)},C._crypto_shorthash_keygen=function(){return C.asm.Ob.apply(null,arguments)},C._crypto_sign=function(){return C.asm.Pb.apply(null,arguments)},C._crypto_sign_bytes=function(){return C.asm.Qb.apply(null,arguments)},C._crypto_sign_detached=function(){return C.asm.Rb.apply(null,arguments)},C._crypto_sign_ed25519_pk_to_curve25519=function(){return C.asm.Sb.apply(null,arguments)},C._crypto_sign_ed25519_sk_to_curve25519=function(){return C.asm.Tb.apply(null,arguments)},C._crypto_sign_final_create=function(){return C.asm.Ub.apply(null,arguments)},C._crypto_sign_final_verify=function(){return C.asm.Vb.apply(null,arguments)},C._crypto_sign_init=function(){return C.asm.Wb.apply(null,arguments)},C._crypto_sign_keypair=function(){return C.asm.Xb.apply(null,arguments)},C._crypto_sign_messagebytes_max=function(){return C.asm.Yb.apply(null,arguments)},C._crypto_sign_open=function(){return C.asm.Zb.apply(null,arguments)},C._crypto_sign_publickeybytes=function(){return C.asm._b.apply(null,arguments)},C._crypto_sign_secretkeybytes=function(){return C.asm.$b.apply(null,arguments)},C._crypto_sign_seed_keypair=function(){return C.asm.ac.apply(null,arguments)},C._crypto_sign_seedbytes=function(){return C.asm.bc.apply(null,arguments)},C._crypto_sign_statebytes=function(){return C.asm.cc.apply(null,arguments)},C._crypto_sign_update=function(){return C.asm.dc.apply(null,arguments)},C._crypto_sign_verify_detached=function(){return C.asm.ec.apply(null,arguments)},C._free=function(){return C.asm.fc.apply(null,arguments)},C._malloc=function(){return C.asm.gc.apply(null,arguments)},C._randombytes=function(){return C.asm.hc.apply(null,arguments)},C._randombytes_buf=function(){return C.asm.ic.apply(null,arguments)},C._randombytes_buf_deterministic=function(){return C.asm.jc.apply(null,arguments)},C._randombytes_close=function(){return C.asm.kc.apply(null,arguments)},C._randombytes_random=function(){return C.asm.lc.apply(null,arguments)},C._randombytes_seedbytes=function(){return C.asm.mc.apply(null,arguments)},C._randombytes_stir=function(){return C.asm.nc.apply(null,arguments)},C._randombytes_uniform=function(){return C.asm.oc.apply(null,arguments)},C._sodium_base642bin=function(){return C.asm.pc.apply(null,arguments)},C._sodium_base64_encoded_len=function(){return C.asm.qc.apply(null,arguments)},C._sodium_bin2base64=function(){return C.asm.rc.apply(null,arguments)},C._sodium_bin2hex=function(){return C.asm.sc.apply(null,arguments)},C._sodium_hex2bin=function(){return C.asm.tc.apply(null,arguments)},C._sodium_init=function(){return C.asm.uc.apply(null,arguments)},C._sodium_library_minimal=function(){return C.asm.vc.apply(null,arguments)},C._sodium_library_version_major=function(){return C.asm.wc.apply(null,arguments)},C._sodium_library_version_minor=function(){return C.asm.xc.apply(null,arguments)},C._sodium_pad=function(){return C.asm.yc.apply(null,arguments)},C._sodium_unpad=function(){return C.asm.zc.apply(null,arguments)},C._sodium_version_string=function(){return C.asm.Ac.apply(null,arguments)},C.asm=aA,C.setValue=function(A,I,g,B){switch("*"===(g=g||"i8").charAt(g.length-1)&&(g="i32"),g){case"i1":case"i8":l[A>>0]=I;break;case"i16":G[A>>1]=I;break;case"i32":d[A>>2]=I;break;case"i64":AA=[I>>>0,($=I,+x($)>=1?$>0?(0|j(+X($/4294967296),4294967295))>>>0:~~+K(($-+(~~$>>>0))/4294967296)>>>0:0)],d[A>>2]=AA[0],d[A+4>>2]=AA[1];break;case"float":Y[A>>2]=I;break;case"double":M[A>>3]=I;break;default:z("invalid type for setValue: "+g)}},C.getValue=function(A,I,g){switch("*"===(I=I||"i8").charAt(I.length-1)&&(I="i32"),I){case"i1":case"i8":return l[A>>0];case"i16":return G[A>>1];case"i32":case"i64":return d[A>>2];case"float":return Y[A>>2];case"double":return M[A>>3];default:z("invalid type for getValue: "+I)}return null},C.UTF8ToString=U,V=function A(){oA||nA(),oA||(V=A)},C.run=nA,C.preInit)for("function"==typeof C.preInit&&(C.preInit=[C.preInit]);C.preInit.length>0;)C.preInit.pop()();nA()}).catch(function(){B.useBackupModule()}),"object"==typeof process&&"function"==typeof process.removeAllListeners&&(process.removeAllListeners("uncaughtException"),process.removeAllListeners("unhandledRejection")),I}"function"==typeof define&&define.amd?define(["exports"],I):"object"==typeof exports&&"string"!=typeof exports.nodeName?I(exports):A.libsodium=I(A.libsodium_mod||(A.commonJsStrict={}))}(this);

}).call(this,require('_process'),typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {},require("buffer").Buffer,arguments[3],arguments[4],arguments[5],arguments[6],"/node_modules/libsodium/dist/modules")
},{"_process":145,"buffer":74,"crypto":82,"fs":45,"path":138}],22:[function(require,module,exports){
"use strict";

const Poly1305 = require('./lib/poly1305');

module.exports = Poly1305;

},{"./lib/poly1305":23}],23:[function(require,module,exports){
(function (Buffer){
"use strict";

const BigInteger = require('big-integer');
const crypto = require('crypto');
const Util = require('./util');

const BLOCK_SIZE = 16;

module.exports = class Poly1305
{
    /**
     * @param {Buffer} message
     * @param {Buffer} key
     * @return {Promise<Buffer>}
     */
    static async onetimeauth(message, key)
    {
        if (!Buffer.isBuffer(message)) {
            message = Buffer.from(message);
        }
        let self = new Poly1305(key);
        await self.update(message);
        return await self.finish();
    }

    /**
     * @param {Buffer} message
     * @param {Buffer} key
     * @param {Buffer} tag
     * @return {Promise<boolean>}
     */
    static async onetimeauth_verify(message, key, tag)
    {
        if (!Buffer.isBuffer(message)) {
            message = Buffer.from(message);
        }
        let self = new Poly1305(key);
        await self.update(message);
        let calc = await self.finish();
        return crypto.timingSafeEqual(calc, tag);
    }

    /**
     * @param {Buffer} key
     */
    constructor(key)
    {
        if (typeof (key) === 'undefined') {
            this.buffer = Buffer.alloc(16, 0);
            this.h = new Uint32Array(5);
            this.r = [0,0,0,0,0];
            this.pad = [0,0,0,0];
            this.leftover = 0;
            this.final = false;
            return;
        }
        if (!Buffer.isBuffer(key)) {
            throw new TypeError("Poly1305 key must be a Buffer (argument 1)");
        }
        if (key.length !== 32) {
            throw new Error("Poly1305 requires a 32-byte key");
        }
        this.buffer = Buffer.alloc(16, 0);

        this.r = [
            Util.load32_le(key.slice(0, 4))           & 0x03ffffff,
            (Util.load32_le(key.slice(3, 7)) >>> 2)   & 0x03ffff03,
            (Util.load32_le(key.slice(6, 10)) >>> 4)  & 0x03ffc0ff,
            (Util.load32_le(key.slice(9, 13)) >>> 6)  & 0x03f03fff,
            (Util.load32_le(key.slice(12, 16)) >>> 8) & 0x000fffff
        ];
        this.h = new Uint32Array(5);
        this.pad = [
            Util.load32_le(key.slice(16, 20)),
            Util.load32_le(key.slice(20, 24)),
            Util.load32_le(key.slice(24, 28)),
            Util.load32_le(key.slice(28, 32))
        ];

        this.leftover = 0;
        this.final = false;
    }

    /**
     * Inspired by PHP's hash_copy()
     *
     * @return {Poly1305}
     */
    clone()
    {
        let clone = new Poly1305();
        this.buffer.copy(clone.buffer, 0, 0, 16);
        clone.r = this.r;
        for (let i = 0; i < 5; i++) {
            clone.h[i] = this.h[i];
        }
        for (let i = 0; i < 4; i++) {
            clone.pad[i] = this.pad[i];
        }
        clone.leftover = this.leftover;
        clone.final = this.final;
        return clone;
    }

    /**
     *
     * @param {Buffer} message
     * @param {number} bytes
     * @return {Promise<void>}
     */
    async blocks(message, bytes)
    {
        if (message.length < 16) {
            throw new Error('Out of range exception');
        }

        let hibit = this.final ? 0 : 1 << 24;
        let [r0, r1, r2, r3, r4] = this.r;

        let s1 = r1 * 5;
        let s2 = r2 * 5;
        let s3 = r3 * 5;
        let s4 = r4 * 5;

        let h0 = BigInteger(this.h[0]);
        let h1 = BigInteger(this.h[1]);
        let h2 = BigInteger(this.h[2]);
        let h3 = BigInteger(this.h[3]);
        let h4 = BigInteger(this.h[4]);

        let offset = 0;
        let c, d0, d1, d2, d3, d4;
        while (bytes >= BLOCK_SIZE) {
            /* h += m[i] */
            h0 = h0.add((Util.load32_le(message.slice(offset,     offset + 4)))        & 0x03ffffff);
            h1 = h1.add((Util.load32_le(message.slice(offset + 3, offset + 7)) >>> 2)  & 0x03ffffff);
            h2 = h2.add((Util.load32_le(message.slice(offset + 6, offset + 10)) >>> 4) & 0x03ffffff);
            h3 = h3.add((Util.load32_le(message.slice(offset + 9, offset + 13)) >>> 6) & 0x03ffffff);
            h4 = h4.add((Util.load32_le(message.slice(offset + 12, offset + 16)) >>> 8) | hibit);

            /* h *= r */
            // d0 = ((h0 * r0) + (s4 * h1) + (s3 * h2) + (s2 * h3) + (s1 * h4));
            d0 = BigInteger(h0.times(BigInteger(r0)))
                .plus(BigInteger(s4).times(h1))
                .plus(BigInteger(s3).times(h2))
                .plus(BigInteger(s2).times(h3))
                .plus(BigInteger(s1).times(h4));

            // d1 = ((h0 * r1) + (h1 * r0) + (s4 * h2) + (s3 * h3) + (s2 * h4));
            d1 = BigInteger(h0.times(BigInteger(r1)))
                .plus(h1.times(BigInteger(r0)))
                .plus(BigInteger(s4).times(h2))
                .plus(BigInteger(s3).times(h3))
                .plus(BigInteger(s2).times(h4));

            // d2 = ((h0 * r2) + (h1 * r1) + (h2 * r0) + (s4 * h3) + (s3 * h4));
            d2 = BigInteger(h0.times(BigInteger(r2)))
                .plus(h1.times(BigInteger(r1)))
                .plus(h2.times(BigInteger(r0)))
                .plus(BigInteger(s4).times(h3))
                .plus(BigInteger(s3).times(h4));

            // d3 = ((h0 * r3) + (h1 * r2) + (h2 * r1) + (h3 * r0) + (s4 * h4));
            d3 = BigInteger(h0.times(BigInteger(r3)))
                .plus(h1.times(BigInteger(r2)))
                .plus(h2.times(BigInteger(r1)))
                .plus(h3.times(BigInteger(r0)))
                .plus(BigInteger(s4).times(h4));
            // d4 = ((h0 * r4) + (h1 * r3) + (h2 * r2) + (h3 * r1) + (h4 * r0));
            d4 = BigInteger(h0.times(BigInteger(r4)))
                .plus(h1.times(BigInteger(r3)))
                .plus(h2.times(BigInteger(r2)))
                .plus(h3.times(BigInteger(r1)))
                .plus(h4.times(BigInteger(r0)));

            /* (partial) h %= p */
            c = d0.shiftRight(26);
            h0 = d0.and(0x3ffffff);
            d1 = d1.add(c);
            c = d1.shiftRight(26);
            h1 = d1.and(0x3ffffff);
            d2 = d2.add(c);
            c = d2.shiftRight(26);
            h2 = d2.and(0x3ffffff);
            d3 = d3.add(c);
            c = d3.shiftRight(26);
            h3 = d3.and(0x3ffffff);
            d4 = d4.add(c);
            c = d4.shiftRight(26);
            h4 = d4.and(0x3ffffff);
            h0 = h0.add(c.multiply(5).toJSNumber());

            c = h0.shiftRight(26);
            h0 = h0.and(0x3ffffff);
            h1 = h1.add(c);

            offset += BLOCK_SIZE;
            bytes -= BLOCK_SIZE;
        }
        this.h[0] = h0.toJSNumber() >>> 0;
        this.h[1] = h1.toJSNumber() >>> 0;
        this.h[2] = h2.toJSNumber() >>> 0;
        this.h[3] = h3.toJSNumber() >>> 0;
        this.h[4] = h4.toJSNumber() >>> 0;
    }

    /**
     *
     * @param {Buffer} message
     * @return {Promise<Poly1305>}
     */
    async update(message)
    {
        let want;
        let bytes = message.length;

        if (this.leftover > 0) {
            want = BLOCK_SIZE - this.leftover;
            if (want > bytes) {
                want = bytes;
            }
            message.slice(0, want).copy(this.buffer, this.leftover, 0);
            this.leftover += want;
            if (this.leftover < BLOCK_SIZE) {
                // We still don't have enough to run this.blocks()
                return this;
            }
            await this.blocks(this.buffer, BLOCK_SIZE);
            this.leftover -= BLOCK_SIZE;
            bytes -= want;
            message = message.slice(want);
        }

        /* process full blocks */
        if (bytes >= BLOCK_SIZE) {
            want = bytes & ~(BLOCK_SIZE - 1);
            if (want >= BLOCK_SIZE) {
                await this.blocks(message.slice(0, want), want);
                message = message.slice(want);
                bytes = message.length;
            }
        }

        /* store leftover */
        if (bytes > 0) {
            message.slice(0, bytes).copy(this.buffer, this.leftover, 0);
            this.leftover += bytes;
        }
        return this;
    }

    /**
     * @return {Promise<Buffer>}
     */
    async finish()
    {
        let c, g0, g1, g2, g3, g4, h0, h1, h2, h3, h4, mask;
        if (this.leftover) {
            let i = this.leftover;
            this.buffer[i++] = 1;
            for (; i < BLOCK_SIZE; i++) {
                this.buffer[i] = 0;
            }
            this.final = true;
            await this.blocks(this.buffer, BLOCK_SIZE);
        }

        h0 = this.h[0];
        h1 = this.h[1];
        h2 = this.h[2];
        h3 = this.h[3];
        h4 = this.h[4];

        c = h1 >>> 26;
        h1 &= 0x3ffffff;
        h2 += c;
        c = h2 >>> 26;
        h2 &= 0x3ffffff;
        h3 += c;
        c = h3 >>> 26;
        h3 &= 0x3ffffff;
        h4 += c;
        c = h4 >>> 26;
        h4 &= 0x3ffffff;
        h0 += c * 5;
        c = h0 >>> 26;
        h0 &= 0x3ffffff;
        h1 += c;

        /* compute h + -p */
        g0 = h0 + 5;
        c = g0 >>> 26;
        g0 &= 0x3ffffff;

        g1 = h1 + c;
        c = g1 >>> 26;
        g1 &= 0x3ffffff;

        g2 = h2 + c;
        c = g2 >>> 26;
        g2 &= 0x3ffffff;

        g3 = h2 + c;
        c = g3 >>> 26;
        g3 &= 0x3ffffff;

        g4 = (h4 +c - (1 << 26)) >>> 0;

        /* select h if h < p, or h + -p if h >= p */
        mask = (g4 >>> 31) - 1;

        g0 &= mask;
        g1 &= mask;
        g2 &= mask;
        g3 &= mask;
        g4 &= mask;

        mask = ~mask >>> 0;
        h0 = (h0 & mask) | g0;
        h1 = (h1 & mask) | g1;
        h2 = (h2 & mask) | g2;
        h3 = (h3 & mask) | g3;
        h4 = (h4 & mask) | g4;

        /* h = h % (2^128) */
        h0 = ((h0) | (h1 << 26)) >>> 0;
        h1 = ((h1 >>>  6) | (h2 << 20)) >>> 0;
        h2 = ((h2 >>> 12) | (h3 << 14)) >>> 0;
        h3 = ((h3 >>> 18) | (h4 <<  8)) >>> 0;

        [h0, c] = Util.add_overflow(h0, this.pad[0]);
        [h1, c] = Util.add_overflow(h1, this.pad[1], c);
        [h2, c] = Util.add_overflow(h2, this.pad[2], c);
        [h3, c] = Util.add_overflow(h3, this.pad[3], c);

        return Buffer.concat([
            Util.store32_le(h0 >>> 0),
            Util.store32_le(h1 >>> 0),
            Util.store32_le(h2 >>> 0),
            Util.store32_le(h3 >>> 0)
        ]);
    }
};

}).call(this,require("buffer").Buffer)
},{"./util":24,"big-integer":16,"buffer":74,"crypto":82}],24:[function(require,module,exports){
(function (Buffer){
"use strict";

module.exports = class Util
{
    /**
     * Performs addition with overflow. Returns the sum and any carry bits.
     *
     * @param {number} a
     * @param {number} b
     * @param {number} extra (optional)
     * @return {number[]}
     */
    static add_overflow(a, b, extra = 0)
    {
        let c, x, y;
        x = (a & 0xffff) + (b & 0xffff) + (extra & 0xffff);
        c = x >>> 16;
        y = (a >>> 16) + (b >>> 16) + (extra >>> 16) + c;
        c = y >>> 16;
        return [y << 16 | (x & 0xffff), c];
    }

    /**
     * Node.js only supports 32-bit numbers so we discard the top 4 bytes.
     *
     * @param {Buffer} buf
     * @return {Number}
     */
    static load32_le(buf)
    {
        return buf.readInt32LE(0) >>> 0;
    }

    /**
     * Store a 32-bit integer as a buffer of length 4
     *
     * @param {Number} num
     * @return {Buffer}
     */
    static store32_le(num)
    {
        let result = Buffer.alloc(4, 0);
        result[0] = num & 0xff;
        result[1] = (num >>>  8) & 0xff;
        result[2] = (num >>> 16) & 0xff;
        result[3] = (num >>> 24) & 0xff;
        return result;
    }
};

}).call(this,require("buffer").Buffer)
},{"buffer":74}],25:[function(require,module,exports){
(function (Buffer){
/**
 * Convert a typed array to a Buffer without a copy
 *
 * Author:   Feross Aboukhadijeh <https://feross.org>
 * License:  MIT
 *
 * `npm install typedarray-to-buffer`
 */

var isTypedArray = require('is-typedarray').strict

module.exports = function typedarrayToBuffer (arr) {
  if (isTypedArray(arr)) {
    // To avoid a copy, use the typed array's underlying ArrayBuffer to back new Buffer
    var buf = Buffer.from(arr.buffer)
    if (arr.byteLength !== arr.buffer.byteLength) {
      // Respect the "view", i.e. byteOffset and byteLength, without doing a copy
      buf = buf.slice(arr.byteOffset, arr.byteOffset + arr.byteLength)
    }
    return buf
  } else {
    // Pass through all other types to `Buffer.from`
    return Buffer.from(arr)
  }
}

}).call(this,require("buffer").Buffer)
},{"buffer":74,"is-typedarray":19}],26:[function(require,module,exports){
var xsalsa20 = require('./xsalsa20')()

var SIGMA = new Uint8Array([101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107])
var head = 144
var top = head
var free = []

module.exports = XSalsa20

XSalsa20.NONCEBYTES = 24
XSalsa20.KEYBYTES = 32

XSalsa20.core_hsalsa20 = core_hsalsa20
XSalsa20.SIGMA = SIGMA

function XSalsa20 (nonce, key) {
  if (!(this instanceof XSalsa20)) return new XSalsa20(nonce, key)
  if (!nonce || nonce.length < 24) throw new Error('nonce must be at least 24 bytes')
  if (!key || key.length < 32) throw new Error('key must be at least 32 bytes')
  this._xor = xsalsa20 && xsalsa20.exports ? new WASM(nonce, key) : new Fallback(nonce, key)
}

XSalsa20.prototype.update = function (input, output) {
  if (!input) throw new Error('input must be Uint8Array or Buffer')
  if (!output) output = new Uint8Array(input.length)
  if (input.length) this._xor.update(input, output)
  return output
}

XSalsa20.prototype.final =
XSalsa20.prototype.finalize = function () {
  this._xor.finalize()
  this._xor = null
}

function WASM (nonce, key) {
  if (!free.length) {
    free.push(head)
    head += 64
  }

  this._pointer = free.pop()
  this._nonce = this._pointer + 8
  this._key = this._nonce + 24
  this._overflow = 0

  xsalsa20.memory.fill(0, this._pointer, this._pointer + 8)
  xsalsa20.memory.set(nonce, this._nonce)
  xsalsa20.memory.set(key, this._key)
}

WASM.prototype.update = function (input, output) {
  var len = this._overflow + input.length
  var start = head + this._overflow

  top = head + len
  if (top >= xsalsa20.memory.length) xsalsa20.realloc(top)

  xsalsa20.memory.set(input, start)
  xsalsa20.exports.xsalsa20_xor(this._pointer, head, head, len, this._nonce, this._key)
  output.set(xsalsa20.memory.subarray(start, head + len))

  this._overflow = len & 63
}

WASM.prototype.finalize = function () {
  xsalsa20.memory.fill(0, this._pointer, this._key + 32)
  if (top > head) {
    xsalsa20.memory.fill(0, head, top)
    top = 0
  }
  free.push(this._pointer)
}

function Fallback (nonce, key) {
  this._s = new Uint8Array(32)
  this._z = new Uint8Array(16)
  this._overflow = 0
  core_hsalsa20(this._s, nonce, key, SIGMA)
  for (var i = 0; i < 8; i++) this._z[i] = nonce[i + 16]
}

Fallback.prototype.update = function (input, output) {
  var x = new Uint8Array(64)
  var u = 0
  var i = this._overflow
  var b = input.length + this._overflow
  var z = this._z
  var mpos = -this._overflow
  var cpos = -this._overflow

  while (b >= 64) {
    core_salsa20(x, z, this._s, SIGMA)
    for (; i < 64; i++) output[cpos + i] = input[mpos + i] ^ x[i]
    u = 1
    for (i = 8; i < 16; i++) {
      u += (z[i] & 0xff) | 0
      z[i] = u & 0xff
      u >>>= 8
    }
    b -= 64
    cpos += 64
    mpos += 64
    i = 0
  }
  if (b > 0) {
    core_salsa20(x, z, this._s, SIGMA)
    for (; i < b; i++) output[cpos + i] = input[mpos + i] ^ x[i]
  }

  this._overflow = b & 63
}

Fallback.prototype.finalize = function () {
  this._s.fill(0)
  this._z.fill(0)
}

// below methods are ported from tweet nacl

function core_salsa20(o, p, k, c) {
  var j0  = c[ 0] & 0xff | (c[ 1] & 0xff) << 8 | (c[ 2] & 0xff) << 16 | (c[ 3] & 0xff) << 24,
      j1  = k[ 0] & 0xff | (k[ 1] & 0xff) << 8 | (k[ 2] & 0xff) << 16 | (k[ 3] & 0xff) << 24,
      j2  = k[ 4] & 0xff | (k[ 5] & 0xff) << 8 | (k[ 6] & 0xff) << 16 | (k[ 7] & 0xff) << 24,
      j3  = k[ 8] & 0xff | (k[ 9] & 0xff) << 8 | (k[10] & 0xff) << 16 | (k[11] & 0xff) << 24,
      j4  = k[12] & 0xff | (k[13] & 0xff) << 8 | (k[14] & 0xff) << 16 | (k[15] & 0xff) << 24,
      j5  = c[ 4] & 0xff | (c[ 5] & 0xff) << 8 | (c[ 6] & 0xff) << 16 | (c[ 7] & 0xff) << 24,
      j6  = p[ 0] & 0xff | (p[ 1] & 0xff) << 8 | (p[ 2] & 0xff) << 16 | (p[ 3] & 0xff) << 24,
      j7  = p[ 4] & 0xff | (p[ 5] & 0xff) << 8 | (p[ 6] & 0xff) << 16 | (p[ 7] & 0xff) << 24,
      j8  = p[ 8] & 0xff | (p[ 9] & 0xff) << 8 | (p[10] & 0xff) << 16 | (p[11] & 0xff) << 24,
      j9  = p[12] & 0xff | (p[13] & 0xff) << 8 | (p[14] & 0xff) << 16 | (p[15] & 0xff) << 24,
      j10 = c[ 8] & 0xff | (c[ 9] & 0xff) << 8 | (c[10] & 0xff) << 16 | (c[11] & 0xff) << 24,
      j11 = k[16] & 0xff | (k[17] & 0xff) << 8 | (k[18] & 0xff) << 16 | (k[19] & 0xff) << 24,
      j12 = k[20] & 0xff | (k[21] & 0xff) << 8 | (k[22] & 0xff) << 16 | (k[23] & 0xff) << 24,
      j13 = k[24] & 0xff | (k[25] & 0xff) << 8 | (k[26] & 0xff) << 16 | (k[27] & 0xff) << 24,
      j14 = k[28] & 0xff | (k[29] & 0xff) << 8 | (k[30] & 0xff) << 16 | (k[31] & 0xff) << 24,
      j15 = c[12] & 0xff | (c[13] & 0xff) << 8 | (c[14] & 0xff) << 16 | (c[15] & 0xff) << 24

  var x0 = j0, x1 = j1, x2 = j2, x3 = j3, x4 = j4, x5 = j5, x6 = j6, x7 = j7,
      x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14,
      x15 = j15, u

  for (var i = 0; i < 20; i += 2) {
    u = x0 + x12 | 0
    x4 ^= u << 7 | u >>> 25
    u = x4 + x0 | 0
    x8 ^= u << 9 | u >>> 23
    u = x8 + x4 | 0
    x12 ^= u << 13 | u >>> 19
    u = x12 + x8 | 0
    x0 ^= u << 18 | u >>> 14

    u = x5 + x1 | 0
    x9 ^= u << 7 | u >>> 25
    u = x9 + x5 | 0
    x13 ^= u << 9 | u >>> 23
    u = x13 + x9 | 0
    x1 ^= u << 13 | u >>> 19
    u = x1 + x13 | 0
    x5 ^= u << 18 | u >>> 14

    u = x10 + x6 | 0
    x14 ^= u << 7 | u >>> 25
    u = x14 + x10 | 0
    x2 ^= u << 9 | u >>> 23
    u = x2 + x14 | 0
    x6 ^= u << 13 | u >>> 19
    u = x6 + x2 | 0
    x10 ^= u << 18 | u >>> 14

    u = x15 + x11 | 0
    x3 ^= u << 7 | u >>> 25
    u = x3 + x15 | 0
    x7 ^= u << 9 | u >>> 23
    u = x7 + x3 | 0
    x11 ^= u << 13 | u >>> 19
    u = x11 + x7 | 0
    x15 ^= u << 18 | u >>> 14

    u = x0 + x3 | 0
    x1 ^= u << 7 | u >>> 25
    u = x1 + x0 | 0
    x2 ^= u << 9 | u >>> 23
    u = x2 + x1 | 0
    x3 ^= u << 13 | u >>> 19
    u = x3 + x2 | 0
    x0 ^= u << 18 | u >>> 14

    u = x5 + x4 | 0
    x6 ^= u << 7 | u >>> 25
    u = x6 + x5 | 0
    x7 ^= u << 9 | u >>> 23
    u = x7 + x6 | 0
    x4 ^= u << 13 | u >>> 19
    u = x4 + x7 | 0
    x5 ^= u << 18 | u >>> 14

    u = x10 + x9 | 0
    x11 ^= u << 7 | u >>> 25
    u = x11 + x10 | 0
    x8 ^= u << 9 | u >>> 23
    u = x8 + x11 | 0
    x9 ^= u << 13 | u >>> 19
    u = x9 + x8 | 0
    x10 ^= u << 18 | u >>> 14

    u = x15 + x14 | 0
    x12 ^= u << 7 | u >>> 25
    u = x12 + x15 | 0
    x13 ^= u << 9 | u >>> 23
    u = x13 + x12 | 0
    x14 ^= u << 13 | u >>> 19
    u = x14 + x13 | 0
    x15 ^= u << 18 | u >>> 14
  }
   x0 =  x0 +  j0 | 0
   x1 =  x1 +  j1 | 0
   x2 =  x2 +  j2 | 0
   x3 =  x3 +  j3 | 0
   x4 =  x4 +  j4 | 0
   x5 =  x5 +  j5 | 0
   x6 =  x6 +  j6 | 0
   x7 =  x7 +  j7 | 0
   x8 =  x8 +  j8 | 0
   x9 =  x9 +  j9 | 0
  x10 = x10 + j10 | 0
  x11 = x11 + j11 | 0
  x12 = x12 + j12 | 0
  x13 = x13 + j13 | 0
  x14 = x14 + j14 | 0
  x15 = x15 + j15 | 0

  o[ 0] = x0 >>>  0 & 0xff
  o[ 1] = x0 >>>  8 & 0xff
  o[ 2] = x0 >>> 16 & 0xff
  o[ 3] = x0 >>> 24 & 0xff

  o[ 4] = x1 >>>  0 & 0xff
  o[ 5] = x1 >>>  8 & 0xff
  o[ 6] = x1 >>> 16 & 0xff
  o[ 7] = x1 >>> 24 & 0xff

  o[ 8] = x2 >>>  0 & 0xff
  o[ 9] = x2 >>>  8 & 0xff
  o[10] = x2 >>> 16 & 0xff
  o[11] = x2 >>> 24 & 0xff

  o[12] = x3 >>>  0 & 0xff
  o[13] = x3 >>>  8 & 0xff
  o[14] = x3 >>> 16 & 0xff
  o[15] = x3 >>> 24 & 0xff

  o[16] = x4 >>>  0 & 0xff
  o[17] = x4 >>>  8 & 0xff
  o[18] = x4 >>> 16 & 0xff
  o[19] = x4 >>> 24 & 0xff

  o[20] = x5 >>>  0 & 0xff
  o[21] = x5 >>>  8 & 0xff
  o[22] = x5 >>> 16 & 0xff
  o[23] = x5 >>> 24 & 0xff

  o[24] = x6 >>>  0 & 0xff
  o[25] = x6 >>>  8 & 0xff
  o[26] = x6 >>> 16 & 0xff
  o[27] = x6 >>> 24 & 0xff

  o[28] = x7 >>>  0 & 0xff
  o[29] = x7 >>>  8 & 0xff
  o[30] = x7 >>> 16 & 0xff
  o[31] = x7 >>> 24 & 0xff

  o[32] = x8 >>>  0 & 0xff
  o[33] = x8 >>>  8 & 0xff
  o[34] = x8 >>> 16 & 0xff
  o[35] = x8 >>> 24 & 0xff

  o[36] = x9 >>>  0 & 0xff
  o[37] = x9 >>>  8 & 0xff
  o[38] = x9 >>> 16 & 0xff
  o[39] = x9 >>> 24 & 0xff

  o[40] = x10 >>>  0 & 0xff
  o[41] = x10 >>>  8 & 0xff
  o[42] = x10 >>> 16 & 0xff
  o[43] = x10 >>> 24 & 0xff

  o[44] = x11 >>>  0 & 0xff
  o[45] = x11 >>>  8 & 0xff
  o[46] = x11 >>> 16 & 0xff
  o[47] = x11 >>> 24 & 0xff

  o[48] = x12 >>>  0 & 0xff
  o[49] = x12 >>>  8 & 0xff
  o[50] = x12 >>> 16 & 0xff
  o[51] = x12 >>> 24 & 0xff

  o[52] = x13 >>>  0 & 0xff
  o[53] = x13 >>>  8 & 0xff
  o[54] = x13 >>> 16 & 0xff
  o[55] = x13 >>> 24 & 0xff

  o[56] = x14 >>>  0 & 0xff
  o[57] = x14 >>>  8 & 0xff
  o[58] = x14 >>> 16 & 0xff
  o[59] = x14 >>> 24 & 0xff

  o[60] = x15 >>>  0 & 0xff
  o[61] = x15 >>>  8 & 0xff
  o[62] = x15 >>> 16 & 0xff
  o[63] = x15 >>> 24 & 0xff
}

function core_hsalsa20(o,p,k,c) {
  var j0  = c[ 0] & 0xff | (c[ 1] & 0xff) << 8 | (c[ 2] & 0xff) << 16 | (c[ 3] & 0xff) << 24,
      j1  = k[ 0] & 0xff | (k[ 1] & 0xff) << 8 | (k[ 2] & 0xff) << 16 | (k[ 3] & 0xff) << 24,
      j2  = k[ 4] & 0xff | (k[ 5] & 0xff) << 8 | (k[ 6] & 0xff) << 16 | (k[ 7] & 0xff) << 24,
      j3  = k[ 8] & 0xff | (k[ 9] & 0xff) << 8 | (k[10] & 0xff) << 16 | (k[11] & 0xff) << 24,
      j4  = k[12] & 0xff | (k[13] & 0xff) << 8 | (k[14] & 0xff) << 16 | (k[15] & 0xff) << 24,
      j5  = c[ 4] & 0xff | (c[ 5] & 0xff) << 8 | (c[ 6] & 0xff) << 16 | (c[ 7] & 0xff) << 24,
      j6  = p[ 0] & 0xff | (p[ 1] & 0xff) << 8 | (p[ 2] & 0xff) << 16 | (p[ 3] & 0xff) << 24,
      j7  = p[ 4] & 0xff | (p[ 5] & 0xff) << 8 | (p[ 6] & 0xff) << 16 | (p[ 7] & 0xff) << 24,
      j8  = p[ 8] & 0xff | (p[ 9] & 0xff) << 8 | (p[10] & 0xff) << 16 | (p[11] & 0xff) << 24,
      j9  = p[12] & 0xff | (p[13] & 0xff) << 8 | (p[14] & 0xff) << 16 | (p[15] & 0xff) << 24,
      j10 = c[ 8] & 0xff | (c[ 9] & 0xff) << 8 | (c[10] & 0xff) << 16 | (c[11] & 0xff) << 24,
      j11 = k[16] & 0xff | (k[17] & 0xff) << 8 | (k[18] & 0xff) << 16 | (k[19] & 0xff) << 24,
      j12 = k[20] & 0xff | (k[21] & 0xff) << 8 | (k[22] & 0xff) << 16 | (k[23] & 0xff) << 24,
      j13 = k[24] & 0xff | (k[25] & 0xff) << 8 | (k[26] & 0xff) << 16 | (k[27] & 0xff) << 24,
      j14 = k[28] & 0xff | (k[29] & 0xff) << 8 | (k[30] & 0xff) << 16 | (k[31] & 0xff) << 24,
      j15 = c[12] & 0xff | (c[13] & 0xff) << 8 | (c[14] & 0xff) << 16 | (c[15] & 0xff) << 24

  var x0 = j0, x1 = j1, x2 = j2, x3 = j3, x4 = j4, x5 = j5, x6 = j6, x7 = j7,
      x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14,
      x15 = j15, u

  for (var i = 0; i < 20; i += 2) {
    u = x0 + x12 | 0
    x4 ^= u << 7 | u >>> 25
    u = x4 + x0 | 0
    x8 ^= u << 9 | u >>> 23
    u = x8 + x4 | 0
    x12 ^= u << 13 | u >>> 19
    u = x12 + x8 | 0
    x0 ^= u << 18 | u >>> 14

    u = x5 + x1 | 0
    x9 ^= u << 7 | u >>> 25
    u = x9 + x5 | 0
    x13 ^= u << 9 | u >>> 23
    u = x13 + x9 | 0
    x1 ^= u << 13 | u >>> 19
    u = x1 + x13 | 0
    x5 ^= u << 18 | u >>> 14

    u = x10 + x6 | 0
    x14 ^= u << 7 | u >>> 25
    u = x14 + x10 | 0
    x2 ^= u << 9 | u >>> 23
    u = x2 + x14 | 0
    x6 ^= u << 13 | u >>> 19
    u = x6 + x2 | 0
    x10 ^= u << 18 | u >>> 14

    u = x15 + x11 | 0
    x3 ^= u << 7 | u >>> 25
    u = x3 + x15 | 0
    x7 ^= u << 9 | u >>> 23
    u = x7 + x3 | 0
    x11 ^= u << 13 | u >>> 19
    u = x11 + x7 | 0
    x15 ^= u << 18 | u >>> 14

    u = x0 + x3 | 0
    x1 ^= u << 7 | u >>> 25
    u = x1 + x0 | 0
    x2 ^= u << 9 | u >>> 23
    u = x2 + x1 | 0
    x3 ^= u << 13 | u >>> 19
    u = x3 + x2 | 0
    x0 ^= u << 18 | u >>> 14

    u = x5 + x4 | 0
    x6 ^= u << 7 | u >>> 25
    u = x6 + x5 | 0
    x7 ^= u << 9 | u >>> 23
    u = x7 + x6 | 0
    x4 ^= u << 13 | u >>> 19
    u = x4 + x7 | 0
    x5 ^= u << 18 | u >>> 14

    u = x10 + x9 | 0
    x11 ^= u << 7 | u >>> 25
    u = x11 + x10 | 0
    x8 ^= u << 9 | u >>> 23
    u = x8 + x11 | 0
    x9 ^= u << 13 | u >>> 19
    u = x9 + x8 | 0
    x10 ^= u << 18 | u >>> 14

    u = x15 + x14 | 0
    x12 ^= u << 7 | u >>> 25
    u = x12 + x15 | 0
    x13 ^= u << 9 | u >>> 23
    u = x13 + x12 | 0
    x14 ^= u << 13 | u >>> 19
    u = x14 + x13 | 0
    x15 ^= u << 18 | u >>> 14
  }

  o[ 0] = x0 >>>  0 & 0xff
  o[ 1] = x0 >>>  8 & 0xff
  o[ 2] = x0 >>> 16 & 0xff
  o[ 3] = x0 >>> 24 & 0xff

  o[ 4] = x5 >>>  0 & 0xff
  o[ 5] = x5 >>>  8 & 0xff
  o[ 6] = x5 >>> 16 & 0xff
  o[ 7] = x5 >>> 24 & 0xff

  o[ 8] = x10 >>>  0 & 0xff
  o[ 9] = x10 >>>  8 & 0xff
  o[10] = x10 >>> 16 & 0xff
  o[11] = x10 >>> 24 & 0xff

  o[12] = x15 >>>  0 & 0xff
  o[13] = x15 >>>  8 & 0xff
  o[14] = x15 >>> 16 & 0xff
  o[15] = x15 >>> 24 & 0xff

  o[16] = x6 >>>  0 & 0xff
  o[17] = x6 >>>  8 & 0xff
  o[18] = x6 >>> 16 & 0xff
  o[19] = x6 >>> 24 & 0xff

  o[20] = x7 >>>  0 & 0xff
  o[21] = x7 >>>  8 & 0xff
  o[22] = x7 >>> 16 & 0xff
  o[23] = x7 >>> 24 & 0xff

  o[24] = x8 >>>  0 & 0xff
  o[25] = x8 >>>  8 & 0xff
  o[26] = x8 >>> 16 & 0xff
  o[27] = x8 >>> 24 & 0xff

  o[28] = x9 >>>  0 & 0xff
  o[29] = x9 >>>  8 & 0xff
  o[30] = x9 >>> 16 & 0xff
  o[31] = x9 >>> 24 & 0xff
}

},{"./xsalsa20":27}],27:[function(require,module,exports){

module.exports = loadWebAssembly

loadWebAssembly.supported = typeof WebAssembly !== 'undefined'

function loadWebAssembly (opts) {
  if (!loadWebAssembly.supported) return null

  var imp = opts && opts.imports
  var wasm = toUint8Array('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')
  var ready = null

  var mod = {
    buffer: wasm,
    memory: null,
    exports: null,
    realloc: realloc,
    onload: onload
  }

  onload(function () {})

  return mod

  function realloc (size) {
    mod.exports.memory.grow(Math.ceil(Math.abs(size - mod.memory.length) / 65536))
    mod.memory = new Uint8Array(mod.exports.memory.buffer)
  }

  function onload (cb) {
    if (mod.exports) return cb()

    if (ready) {
      ready.then(cb.bind(null, null)).catch(cb)
      return
    }

    try {
      if (opts && opts.async) throw new Error('async')
      setup({instance: new WebAssembly.Instance(new WebAssembly.Module(wasm), imp)})
    } catch (err) {
      ready = WebAssembly.instantiate(wasm, imp).then(setup)
    }

    onload(cb)
  }

  function setup (w) {
    mod.exports = w.instance.exports
    mod.memory = mod.exports.memory && mod.exports.memory.buffer && new Uint8Array(mod.exports.memory.buffer)
  }
}

function toUint8Array (s) {
  if (typeof atob === 'function') return new Uint8Array(atob(s).split('').map(charCodeAt))
  return new (require('buf' + 'fer').Buffer)(s, 'base64')
}

function charCodeAt (c) {
  return c.charCodeAt(0)
}

},{}],28:[function(require,module,exports){
var asn1 = exports;

asn1.bignum = require('bn.js');

asn1.define = require('./asn1/api').define;
asn1.base = require('./asn1/base');
asn1.constants = require('./asn1/constants');
asn1.decoders = require('./asn1/decoders');
asn1.encoders = require('./asn1/encoders');

},{"./asn1/api":29,"./asn1/base":31,"./asn1/constants":35,"./asn1/decoders":37,"./asn1/encoders":40,"bn.js":43}],29:[function(require,module,exports){
var asn1 = require('../asn1');
var inherits = require('inherits');

var api = exports;

api.define = function define(name, body) {
  return new Entity(name, body);
};

function Entity(name, body) {
  this.name = name;
  this.body = body;

  this.decoders = {};
  this.encoders = {};
};

Entity.prototype._createNamed = function createNamed(base) {
  var named;
  try {
    named = require('vm').runInThisContext(
      '(function ' + this.name + '(entity) {\n' +
      '  this._initNamed(entity);\n' +
      '})'
    );
  } catch (e) {
    named = function (entity) {
      this._initNamed(entity);
    };
  }
  inherits(named, base);
  named.prototype._initNamed = function initnamed(entity) {
    base.call(this, entity);
  };

  return new named(this);
};

Entity.prototype._getDecoder = function _getDecoder(enc) {
  enc = enc || 'der';
  // Lazily create decoder
  if (!this.decoders.hasOwnProperty(enc))
    this.decoders[enc] = this._createNamed(asn1.decoders[enc]);
  return this.decoders[enc];
};

Entity.prototype.decode = function decode(data, enc, options) {
  return this._getDecoder(enc).decode(data, options);
};

Entity.prototype._getEncoder = function _getEncoder(enc) {
  enc = enc || 'der';
  // Lazily create encoder
  if (!this.encoders.hasOwnProperty(enc))
    this.encoders[enc] = this._createNamed(asn1.encoders[enc]);
  return this.encoders[enc];
};

Entity.prototype.encode = function encode(data, enc, /* internal */ reporter) {
  return this._getEncoder(enc).encode(data, reporter);
};

},{"../asn1":28,"inherits":126,"vm":183}],30:[function(require,module,exports){
var inherits = require('inherits');
var Reporter = require('../base').Reporter;
var Buffer = require('buffer').Buffer;

function DecoderBuffer(base, options) {
  Reporter.call(this, options);
  if (!Buffer.isBuffer(base)) {
    this.error('Input not Buffer');
    return;
  }

  this.base = base;
  this.offset = 0;
  this.length = base.length;
}
inherits(DecoderBuffer, Reporter);
exports.DecoderBuffer = DecoderBuffer;

DecoderBuffer.prototype.save = function save() {
  return { offset: this.offset, reporter: Reporter.prototype.save.call(this) };
};

DecoderBuffer.prototype.restore = function restore(save) {
  // Return skipped data
  var res = new DecoderBuffer(this.base);
  res.offset = save.offset;
  res.length = this.offset;

  this.offset = save.offset;
  Reporter.prototype.restore.call(this, save.reporter);

  return res;
};

DecoderBuffer.prototype.isEmpty = function isEmpty() {
  return this.offset === this.length;
};

DecoderBuffer.prototype.readUInt8 = function readUInt8(fail) {
  if (this.offset + 1 <= this.length)
    return this.base.readUInt8(this.offset++, true);
  else
    return this.error(fail || 'DecoderBuffer overrun');
}

DecoderBuffer.prototype.skip = function skip(bytes, fail) {
  if (!(this.offset + bytes <= this.length))
    return this.error(fail || 'DecoderBuffer overrun');

  var res = new DecoderBuffer(this.base);

  // Share reporter state
  res._reporterState = this._reporterState;

  res.offset = this.offset;
  res.length = this.offset + bytes;
  this.offset += bytes;
  return res;
}

DecoderBuffer.prototype.raw = function raw(save) {
  return this.base.slice(save ? save.offset : this.offset, this.length);
}

function EncoderBuffer(value, reporter) {
  if (Array.isArray(value)) {
    this.length = 0;
    this.value = value.map(function(item) {
      if (!(item instanceof EncoderBuffer))
        item = new EncoderBuffer(item, reporter);
      this.length += item.length;
      return item;
    }, this);
  } else if (typeof value === 'number') {
    if (!(0 <= value && value <= 0xff))
      return reporter.error('non-byte EncoderBuffer value');
    this.value = value;
    this.length = 1;
  } else if (typeof value === 'string') {
    this.value = value;
    this.length = Buffer.byteLength(value);
  } else if (Buffer.isBuffer(value)) {
    this.value = value;
    this.length = value.length;
  } else {
    return reporter.error('Unsupported type: ' + typeof value);
  }
}
exports.EncoderBuffer = EncoderBuffer;

EncoderBuffer.prototype.join = function join(out, offset) {
  if (!out)
    out = new Buffer(this.length);
  if (!offset)
    offset = 0;

  if (this.length === 0)
    return out;

  if (Array.isArray(this.value)) {
    this.value.forEach(function(item) {
      item.join(out, offset);
      offset += item.length;
    });
  } else {
    if (typeof this.value === 'number')
      out[offset] = this.value;
    else if (typeof this.value === 'string')
      out.write(this.value, offset);
    else if (Buffer.isBuffer(this.value))
      this.value.copy(out, offset);
    offset += this.length;
  }

  return out;
};

},{"../base":31,"buffer":74,"inherits":126}],31:[function(require,module,exports){
var base = exports;

base.Reporter = require('./reporter').Reporter;
base.DecoderBuffer = require('./buffer').DecoderBuffer;
base.EncoderBuffer = require('./buffer').EncoderBuffer;
base.Node = require('./node');

},{"./buffer":30,"./node":32,"./reporter":33}],32:[function(require,module,exports){
var Reporter = require('../base').Reporter;
var EncoderBuffer = require('../base').EncoderBuffer;
var DecoderBuffer = require('../base').DecoderBuffer;
var assert = require('minimalistic-assert');

// Supported tags
var tags = [
  'seq', 'seqof', 'set', 'setof', 'objid', 'bool',
  'gentime', 'utctime', 'null_', 'enum', 'int', 'objDesc',
  'bitstr', 'bmpstr', 'charstr', 'genstr', 'graphstr', 'ia5str', 'iso646str',
  'numstr', 'octstr', 'printstr', 't61str', 'unistr', 'utf8str', 'videostr'
];

// Public methods list
var methods = [
  'key', 'obj', 'use', 'optional', 'explicit', 'implicit', 'def', 'choice',
  'any', 'contains'
].concat(tags);

// Overrided methods list
var overrided = [
  '_peekTag', '_decodeTag', '_use',
  '_decodeStr', '_decodeObjid', '_decodeTime',
  '_decodeNull', '_decodeInt', '_decodeBool', '_decodeList',

  '_encodeComposite', '_encodeStr', '_encodeObjid', '_encodeTime',
  '_encodeNull', '_encodeInt', '_encodeBool'
];

function Node(enc, parent) {
  var state = {};
  this._baseState = state;

  state.enc = enc;

  state.parent = parent || null;
  state.children = null;

  // State
  state.tag = null;
  state.args = null;
  state.reverseArgs = null;
  state.choice = null;
  state.optional = false;
  state.any = false;
  state.obj = false;
  state.use = null;
  state.useDecoder = null;
  state.key = null;
  state['default'] = null;
  state.explicit = null;
  state.implicit = null;
  state.contains = null;

  // Should create new instance on each method
  if (!state.parent) {
    state.children = [];
    this._wrap();
  }
}
module.exports = Node;

var stateProps = [
  'enc', 'parent', 'children', 'tag', 'args', 'reverseArgs', 'choice',
  'optional', 'any', 'obj', 'use', 'alteredUse', 'key', 'default', 'explicit',
  'implicit', 'contains'
];

Node.prototype.clone = function clone() {
  var state = this._baseState;
  var cstate = {};
  stateProps.forEach(function(prop) {
    cstate[prop] = state[prop];
  });
  var res = new this.constructor(cstate.parent);
  res._baseState = cstate;
  return res;
};

Node.prototype._wrap = function wrap() {
  var state = this._baseState;
  methods.forEach(function(method) {
    this[method] = function _wrappedMethod() {
      var clone = new this.constructor(this);
      state.children.push(clone);
      return clone[method].apply(clone, arguments);
    };
  }, this);
};

Node.prototype._init = function init(body) {
  var state = this._baseState;

  assert(state.parent === null);
  body.call(this);

  // Filter children
  state.children = state.children.filter(function(child) {
    return child._baseState.parent === this;
  }, this);
  assert.equal(state.children.length, 1, 'Root node can have only one child');
};

Node.prototype._useArgs = function useArgs(args) {
  var state = this._baseState;

  // Filter children and args
  var children = args.filter(function(arg) {
    return arg instanceof this.constructor;
  }, this);
  args = args.filter(function(arg) {
    return !(arg instanceof this.constructor);
  }, this);

  if (children.length !== 0) {
    assert(state.children === null);
    state.children = children;

    // Replace parent to maintain backward link
    children.forEach(function(child) {
      child._baseState.parent = this;
    }, this);
  }
  if (args.length !== 0) {
    assert(state.args === null);
    state.args = args;
    state.reverseArgs = args.map(function(arg) {
      if (typeof arg !== 'object' || arg.constructor !== Object)
        return arg;

      var res = {};
      Object.keys(arg).forEach(function(key) {
        if (key == (key | 0))
          key |= 0;
        var value = arg[key];
        res[value] = key;
      });
      return res;
    });
  }
};

//
// Overrided methods
//

overrided.forEach(function(method) {
  Node.prototype[method] = function _overrided() {
    var state = this._baseState;
    throw new Error(method + ' not implemented for encoding: ' + state.enc);
  };
});

//
// Public methods
//

tags.forEach(function(tag) {
  Node.prototype[tag] = function _tagMethod() {
    var state = this._baseState;
    var args = Array.prototype.slice.call(arguments);

    assert(state.tag === null);
    state.tag = tag;

    this._useArgs(args);

    return this;
  };
});

Node.prototype.use = function use(item) {
  assert(item);
  var state = this._baseState;

  assert(state.use === null);
  state.use = item;

  return this;
};

Node.prototype.optional = function optional() {
  var state = this._baseState;

  state.optional = true;

  return this;
};

Node.prototype.def = function def(val) {
  var state = this._baseState;

  assert(state['default'] === null);
  state['default'] = val;
  state.optional = true;

  return this;
};

Node.prototype.explicit = function explicit(num) {
  var state = this._baseState;

  assert(state.explicit === null && state.implicit === null);
  state.explicit = num;

  return this;
};

Node.prototype.implicit = function implicit(num) {
  var state = this._baseState;

  assert(state.explicit === null && state.implicit === null);
  state.implicit = num;

  return this;
};

Node.prototype.obj = function obj() {
  var state = this._baseState;
  var args = Array.prototype.slice.call(arguments);

  state.obj = true;

  if (args.length !== 0)
    this._useArgs(args);

  return this;
};

Node.prototype.key = function key(newKey) {
  var state = this._baseState;

  assert(state.key === null);
  state.key = newKey;

  return this;
};

Node.prototype.any = function any() {
  var state = this._baseState;

  state.any = true;

  return this;
};

Node.prototype.choice = function choice(obj) {
  var state = this._baseState;

  assert(state.choice === null);
  state.choice = obj;
  this._useArgs(Object.keys(obj).map(function(key) {
    return obj[key];
  }));

  return this;
};

Node.prototype.contains = function contains(item) {
  var state = this._baseState;

  assert(state.use === null);
  state.contains = item;

  return this;
};

//
// Decoding
//

Node.prototype._decode = function decode(input, options) {
  var state = this._baseState;

  // Decode root node
  if (state.parent === null)
    return input.wrapResult(state.children[0]._decode(input, options));

  var result = state['default'];
  var present = true;

  var prevKey = null;
  if (state.key !== null)
    prevKey = input.enterKey(state.key);

  // Check if tag is there
  if (state.optional) {
    var tag = null;
    if (state.explicit !== null)
      tag = state.explicit;
    else if (state.implicit !== null)
      tag = state.implicit;
    else if (state.tag !== null)
      tag = state.tag;

    if (tag === null && !state.any) {
      // Trial and Error
      var save = input.save();
      try {
        if (state.choice === null)
          this._decodeGeneric(state.tag, input, options);
        else
          this._decodeChoice(input, options);
        present = true;
      } catch (e) {
        present = false;
      }
      input.restore(save);
    } else {
      present = this._peekTag(input, tag, state.any);

      if (input.isError(present))
        return present;
    }
  }

  // Push object on stack
  var prevObj;
  if (state.obj && present)
    prevObj = input.enterObject();

  if (present) {
    // Unwrap explicit values
    if (state.explicit !== null) {
      var explicit = this._decodeTag(input, state.explicit);
      if (input.isError(explicit))
        return explicit;
      input = explicit;
    }

    var start = input.offset;

    // Unwrap implicit and normal values
    if (state.use === null && state.choice === null) {
      if (state.any)
        var save = input.save();
      var body = this._decodeTag(
        input,
        state.implicit !== null ? state.implicit : state.tag,
        state.any
      );
      if (input.isError(body))
        return body;

      if (state.any)
        result = input.raw(save);
      else
        input = body;
    }

    if (options && options.track && state.tag !== null)
      options.track(input.path(), start, input.length, 'tagged');

    if (options && options.track && state.tag !== null)
      options.track(input.path(), input.offset, input.length, 'content');

    // Select proper method for tag
    if (state.any)
      result = result;
    else if (state.choice === null)
      result = this._decodeGeneric(state.tag, input, options);
    else
      result = this._decodeChoice(input, options);

    if (input.isError(result))
      return result;

    // Decode children
    if (!state.any && state.choice === null && state.children !== null) {
      state.children.forEach(function decodeChildren(child) {
        // NOTE: We are ignoring errors here, to let parser continue with other
        // parts of encoded data
        child._decode(input, options);
      });
    }

    // Decode contained/encoded by schema, only in bit or octet strings
    if (state.contains && (state.tag === 'octstr' || state.tag === 'bitstr')) {
      var data = new DecoderBuffer(result);
      result = this._getUse(state.contains, input._reporterState.obj)
          ._decode(data, options);
    }
  }

  // Pop object
  if (state.obj && present)
    result = input.leaveObject(prevObj);

  // Set key
  if (state.key !== null && (result !== null || present === true))
    input.leaveKey(prevKey, state.key, result);
  else if (prevKey !== null)
    input.exitKey(prevKey);

  return result;
};

Node.prototype._decodeGeneric = function decodeGeneric(tag, input, options) {
  var state = this._baseState;

  if (tag === 'seq' || tag === 'set')
    return null;
  if (tag === 'seqof' || tag === 'setof')
    return this._decodeList(input, tag, state.args[0], options);
  else if (/str$/.test(tag))
    return this._decodeStr(input, tag, options);
  else if (tag === 'objid' && state.args)
    return this._decodeObjid(input, state.args[0], state.args[1], options);
  else if (tag === 'objid')
    return this._decodeObjid(input, null, null, options);
  else if (tag === 'gentime' || tag === 'utctime')
    return this._decodeTime(input, tag, options);
  else if (tag === 'null_')
    return this._decodeNull(input, options);
  else if (tag === 'bool')
    return this._decodeBool(input, options);
  else if (tag === 'objDesc')
    return this._decodeStr(input, tag, options);
  else if (tag === 'int' || tag === 'enum')
    return this._decodeInt(input, state.args && state.args[0], options);

  if (state.use !== null) {
    return this._getUse(state.use, input._reporterState.obj)
        ._decode(input, options);
  } else {
    return input.error('unknown tag: ' + tag);
  }
};

Node.prototype._getUse = function _getUse(entity, obj) {

  var state = this._baseState;
  // Create altered use decoder if implicit is set
  state.useDecoder = this._use(entity, obj);
  assert(state.useDecoder._baseState.parent === null);
  state.useDecoder = state.useDecoder._baseState.children[0];
  if (state.implicit !== state.useDecoder._baseState.implicit) {
    state.useDecoder = state.useDecoder.clone();
    state.useDecoder._baseState.implicit = state.implicit;
  }
  return state.useDecoder;
};

Node.prototype._decodeChoice = function decodeChoice(input, options) {
  var state = this._baseState;
  var result = null;
  var match = false;

  Object.keys(state.choice).some(function(key) {
    var save = input.save();
    var node = state.choice[key];
    try {
      var value = node._decode(input, options);
      if (input.isError(value))
        return false;

      result = { type: key, value: value };
      match = true;
    } catch (e) {
      input.restore(save);
      return false;
    }
    return true;
  }, this);

  if (!match)
    return input.error('Choice not matched');

  return result;
};

//
// Encoding
//

Node.prototype._createEncoderBuffer = function createEncoderBuffer(data) {
  return new EncoderBuffer(data, this.reporter);
};

Node.prototype._encode = function encode(data, reporter, parent) {
  var state = this._baseState;
  if (state['default'] !== null && state['default'] === data)
    return;

  var result = this._encodeValue(data, reporter, parent);
  if (result === undefined)
    return;

  if (this._skipDefault(result, reporter, parent))
    return;

  return result;
};

Node.prototype._encodeValue = function encode(data, reporter, parent) {
  var state = this._baseState;

  // Decode root node
  if (state.parent === null)
    return state.children[0]._encode(data, reporter || new Reporter());

  var result = null;

  // Set reporter to share it with a child class
  this.reporter = reporter;

  // Check if data is there
  if (state.optional && data === undefined) {
    if (state['default'] !== null)
      data = state['default']
    else
      return;
  }

  // Encode children first
  var content = null;
  var primitive = false;
  if (state.any) {
    // Anything that was given is translated to buffer
    result = this._createEncoderBuffer(data);
  } else if (state.choice) {
    result = this._encodeChoice(data, reporter);
  } else if (state.contains) {
    content = this._getUse(state.contains, parent)._encode(data, reporter);
    primitive = true;
  } else if (state.children) {
    content = state.children.map(function(child) {
      if (child._baseState.tag === 'null_')
        return child._encode(null, reporter, data);

      if (child._baseState.key === null)
        return reporter.error('Child should have a key');
      var prevKey = reporter.enterKey(child._baseState.key);

      if (typeof data !== 'object')
        return reporter.error('Child expected, but input is not object');

      var res = child._encode(data[child._baseState.key], reporter, data);
      reporter.leaveKey(prevKey);

      return res;
    }, this).filter(function(child) {
      return child;
    });
    content = this._createEncoderBuffer(content);
  } else {
    if (state.tag === 'seqof' || state.tag === 'setof') {
      // TODO(indutny): this should be thrown on DSL level
      if (!(state.args && state.args.length === 1))
        return reporter.error('Too many args for : ' + state.tag);

      if (!Array.isArray(data))
        return reporter.error('seqof/setof, but data is not Array');

      var child = this.clone();
      child._baseState.implicit = null;
      content = this._createEncoderBuffer(data.map(function(item) {
        var state = this._baseState;

        return this._getUse(state.args[0], data)._encode(item, reporter);
      }, child));
    } else if (state.use !== null) {
      result = this._getUse(state.use, parent)._encode(data, reporter);
    } else {
      content = this._encodePrimitive(state.tag, data);
      primitive = true;
    }
  }

  // Encode data itself
  var result;
  if (!state.any && state.choice === null) {
    var tag = state.implicit !== null ? state.implicit : state.tag;
    var cls = state.implicit === null ? 'universal' : 'context';

    if (tag === null) {
      if (state.use === null)
        reporter.error('Tag could be omitted only for .use()');
    } else {
      if (state.use === null)
        result = this._encodeComposite(tag, primitive, cls, content);
    }
  }

  // Wrap in explicit
  if (state.explicit !== null)
    result = this._encodeComposite(state.explicit, false, 'context', result);

  return result;
};

Node.prototype._encodeChoice = function encodeChoice(data, reporter) {
  var state = this._baseState;

  var node = state.choice[data.type];
  if (!node) {
    assert(
        false,
        data.type + ' not found in ' +
            JSON.stringify(Object.keys(state.choice)));
  }
  return node._encode(data.value, reporter);
};

Node.prototype._encodePrimitive = function encodePrimitive(tag, data) {
  var state = this._baseState;

  if (/str$/.test(tag))
    return this._encodeStr(data, tag);
  else if (tag === 'objid' && state.args)
    return this._encodeObjid(data, state.reverseArgs[0], state.args[1]);
  else if (tag === 'objid')
    return this._encodeObjid(data, null, null);
  else if (tag === 'gentime' || tag === 'utctime')
    return this._encodeTime(data, tag);
  else if (tag === 'null_')
    return this._encodeNull();
  else if (tag === 'int' || tag === 'enum')
    return this._encodeInt(data, state.args && state.reverseArgs[0]);
  else if (tag === 'bool')
    return this._encodeBool(data);
  else if (tag === 'objDesc')
    return this._encodeStr(data, tag);
  else
    throw new Error('Unsupported tag: ' + tag);
};

Node.prototype._isNumstr = function isNumstr(str) {
  return /^[0-9 ]*$/.test(str);
};

Node.prototype._isPrintstr = function isPrintstr(str) {
  return /^[A-Za-z0-9 '\(\)\+,\-\.\/:=\?]*$/.test(str);
};

},{"../base":31,"minimalistic-assert":131}],33:[function(require,module,exports){
var inherits = require('inherits');

function Reporter(options) {
  this._reporterState = {
    obj: null,
    path: [],
    options: options || {},
    errors: []
  };
}
exports.Reporter = Reporter;

Reporter.prototype.isError = function isError(obj) {
  return obj instanceof ReporterError;
};

Reporter.prototype.save = function save() {
  var state = this._reporterState;

  return { obj: state.obj, pathLen: state.path.length };
};

Reporter.prototype.restore = function restore(data) {
  var state = this._reporterState;

  state.obj = data.obj;
  state.path = state.path.slice(0, data.pathLen);
};

Reporter.prototype.enterKey = function enterKey(key) {
  return this._reporterState.path.push(key);
};

Reporter.prototype.exitKey = function exitKey(index) {
  var state = this._reporterState;

  state.path = state.path.slice(0, index - 1);
};

Reporter.prototype.leaveKey = function leaveKey(index, key, value) {
  var state = this._reporterState;

  this.exitKey(index);
  if (state.obj !== null)
    state.obj[key] = value;
};

Reporter.prototype.path = function path() {
  return this._reporterState.path.join('/');
};

Reporter.prototype.enterObject = function enterObject() {
  var state = this._reporterState;

  var prev = state.obj;
  state.obj = {};
  return prev;
};

Reporter.prototype.leaveObject = function leaveObject(prev) {
  var state = this._reporterState;

  var now = state.obj;
  state.obj = prev;
  return now;
};

Reporter.prototype.error = function error(msg) {
  var err;
  var state = this._reporterState;

  var inherited = msg instanceof ReporterError;
  if (inherited) {
    err = msg;
  } else {
    err = new ReporterError(state.path.map(function(elem) {
      return '[' + JSON.stringify(elem) + ']';
    }).join(''), msg.message || msg, msg.stack);
  }

  if (!state.options.partial)
    throw err;

  if (!inherited)
    state.errors.push(err);

  return err;
};

Reporter.prototype.wrapResult = function wrapResult(result) {
  var state = this._reporterState;
  if (!state.options.partial)
    return result;

  return {
    result: this.isError(result) ? null : result,
    errors: state.errors
  };
};

function ReporterError(path, msg) {
  this.path = path;
  this.rethrow(msg);
};
inherits(ReporterError, Error);

ReporterError.prototype.rethrow = function rethrow(msg) {
  this.message = msg + ' at: ' + (this.path || '(shallow)');
  if (Error.captureStackTrace)
    Error.captureStackTrace(this, ReporterError);

  if (!this.stack) {
    try {
      // IE only adds stack when thrown
      throw new Error(this.message);
    } catch (e) {
      this.stack = e.stack;
    }
  }
  return this;
};

},{"inherits":126}],34:[function(require,module,exports){
var constants = require('../constants');

exports.tagClass = {
  0: 'universal',
  1: 'application',
  2: 'context',
  3: 'private'
};
exports.tagClassByName = constants._reverse(exports.tagClass);

exports.tag = {
  0x00: 'end',
  0x01: 'bool',
  0x02: 'int',
  0x03: 'bitstr',
  0x04: 'octstr',
  0x05: 'null_',
  0x06: 'objid',
  0x07: 'objDesc',
  0x08: 'external',
  0x09: 'real',
  0x0a: 'enum',
  0x0b: 'embed',
  0x0c: 'utf8str',
  0x0d: 'relativeOid',
  0x10: 'seq',
  0x11: 'set',
  0x12: 'numstr',
  0x13: 'printstr',
  0x14: 't61str',
  0x15: 'videostr',
  0x16: 'ia5str',
  0x17: 'utctime',
  0x18: 'gentime',
  0x19: 'graphstr',
  0x1a: 'iso646str',
  0x1b: 'genstr',
  0x1c: 'unistr',
  0x1d: 'charstr',
  0x1e: 'bmpstr'
};
exports.tagByName = constants._reverse(exports.tag);

},{"../constants":35}],35:[function(require,module,exports){
var constants = exports;

// Helper
constants._reverse = function reverse(map) {
  var res = {};

  Object.keys(map).forEach(function(key) {
    // Convert key to integer if it is stringified
    if ((key | 0) == key)
      key = key | 0;

    var value = map[key];
    res[value] = key;
  });

  return res;
};

constants.der = require('./der');

},{"./der":34}],36:[function(require,module,exports){
var inherits = require('inherits');

var asn1 = require('../../asn1');
var base = asn1.base;
var bignum = asn1.bignum;

// Import DER constants
var der = asn1.constants.der;

function DERDecoder(entity) {
  this.enc = 'der';
  this.name = entity.name;
  this.entity = entity;

  // Construct base tree
  this.tree = new DERNode();
  this.tree._init(entity.body);
};
module.exports = DERDecoder;

DERDecoder.prototype.decode = function decode(data, options) {
  if (!(data instanceof base.DecoderBuffer))
    data = new base.DecoderBuffer(data, options);

  return this.tree._decode(data, options);
};

// Tree methods

function DERNode(parent) {
  base.Node.call(this, 'der', parent);
}
inherits(DERNode, base.Node);

DERNode.prototype._peekTag = function peekTag(buffer, tag, any) {
  if (buffer.isEmpty())
    return false;

  var state = buffer.save();
  var decodedTag = derDecodeTag(buffer, 'Failed to peek tag: "' + tag + '"');
  if (buffer.isError(decodedTag))
    return decodedTag;

  buffer.restore(state);

  return decodedTag.tag === tag || decodedTag.tagStr === tag ||
    (decodedTag.tagStr + 'of') === tag || any;
};

DERNode.prototype._decodeTag = function decodeTag(buffer, tag, any) {
  var decodedTag = derDecodeTag(buffer,
                                'Failed to decode tag of "' + tag + '"');
  if (buffer.isError(decodedTag))
    return decodedTag;

  var len = derDecodeLen(buffer,
                         decodedTag.primitive,
                         'Failed to get length of "' + tag + '"');

  // Failure
  if (buffer.isError(len))
    return len;

  if (!any &&
      decodedTag.tag !== tag &&
      decodedTag.tagStr !== tag &&
      decodedTag.tagStr + 'of' !== tag) {
    return buffer.error('Failed to match tag: "' + tag + '"');
  }

  if (decodedTag.primitive || len !== null)
    return buffer.skip(len, 'Failed to match body of: "' + tag + '"');

  // Indefinite length... find END tag
  var state = buffer.save();
  var res = this._skipUntilEnd(
      buffer,
      'Failed to skip indefinite length body: "' + this.tag + '"');
  if (buffer.isError(res))
    return res;

  len = buffer.offset - state.offset;
  buffer.restore(state);
  return buffer.skip(len, 'Failed to match body of: "' + tag + '"');
};

DERNode.prototype._skipUntilEnd = function skipUntilEnd(buffer, fail) {
  while (true) {
    var tag = derDecodeTag(buffer, fail);
    if (buffer.isError(tag))
      return tag;
    var len = derDecodeLen(buffer, tag.primitive, fail);
    if (buffer.isError(len))
      return len;

    var res;
    if (tag.primitive || len !== null)
      res = buffer.skip(len)
    else
      res = this._skipUntilEnd(buffer, fail);

    // Failure
    if (buffer.isError(res))
      return res;

    if (tag.tagStr === 'end')
      break;
  }
};

DERNode.prototype._decodeList = function decodeList(buffer, tag, decoder,
                                                    options) {
  var result = [];
  while (!buffer.isEmpty()) {
    var possibleEnd = this._peekTag(buffer, 'end');
    if (buffer.isError(possibleEnd))
      return possibleEnd;

    var res = decoder.decode(buffer, 'der', options);
    if (buffer.isError(res) && possibleEnd)
      break;
    result.push(res);
  }
  return result;
};

DERNode.prototype._decodeStr = function decodeStr(buffer, tag) {
  if (tag === 'bitstr') {
    var unused = buffer.readUInt8();
    if (buffer.isError(unused))
      return unused;
    return { unused: unused, data: buffer.raw() };
  } else if (tag === 'bmpstr') {
    var raw = buffer.raw();
    if (raw.length % 2 === 1)
      return buffer.error('Decoding of string type: bmpstr length mismatch');

    var str = '';
    for (var i = 0; i < raw.length / 2; i++) {
      str += String.fromCharCode(raw.readUInt16BE(i * 2));
    }
    return str;
  } else if (tag === 'numstr') {
    var numstr = buffer.raw().toString('ascii');
    if (!this._isNumstr(numstr)) {
      return buffer.error('Decoding of string type: ' +
                          'numstr unsupported characters');
    }
    return numstr;
  } else if (tag === 'octstr') {
    return buffer.raw();
  } else if (tag === 'objDesc') {
    return buffer.raw();
  } else if (tag === 'printstr') {
    var printstr = buffer.raw().toString('ascii');
    if (!this._isPrintstr(printstr)) {
      return buffer.error('Decoding of string type: ' +
                          'printstr unsupported characters');
    }
    return printstr;
  } else if (/str$/.test(tag)) {
    return buffer.raw().toString();
  } else {
    return buffer.error('Decoding of string type: ' + tag + ' unsupported');
  }
};

DERNode.prototype._decodeObjid = function decodeObjid(buffer, values, relative) {
  var result;
  var identifiers = [];
  var ident = 0;
  while (!buffer.isEmpty()) {
    var subident = buffer.readUInt8();
    ident <<= 7;
    ident |= subident & 0x7f;
    if ((subident & 0x80) === 0) {
      identifiers.push(ident);
      ident = 0;
    }
  }
  if (subident & 0x80)
    identifiers.push(ident);

  var first = (identifiers[0] / 40) | 0;
  var second = identifiers[0] % 40;

  if (relative)
    result = identifiers;
  else
    result = [first, second].concat(identifiers.slice(1));

  if (values) {
    var tmp = values[result.join(' ')];
    if (tmp === undefined)
      tmp = values[result.join('.')];
    if (tmp !== undefined)
      result = tmp;
  }

  return result;
};

DERNode.prototype._decodeTime = function decodeTime(buffer, tag) {
  var str = buffer.raw().toString();
  if (tag === 'gentime') {
    var year = str.slice(0, 4) | 0;
    var mon = str.slice(4, 6) | 0;
    var day = str.slice(6, 8) | 0;
    var hour = str.slice(8, 10) | 0;
    var min = str.slice(10, 12) | 0;
    var sec = str.slice(12, 14) | 0;
  } else if (tag === 'utctime') {
    var year = str.slice(0, 2) | 0;
    var mon = str.slice(2, 4) | 0;
    var day = str.slice(4, 6) | 0;
    var hour = str.slice(6, 8) | 0;
    var min = str.slice(8, 10) | 0;
    var sec = str.slice(10, 12) | 0;
    if (year < 70)
      year = 2000 + year;
    else
      year = 1900 + year;
  } else {
    return buffer.error('Decoding ' + tag + ' time is not supported yet');
  }

  return Date.UTC(year, mon - 1, day, hour, min, sec, 0);
};

DERNode.prototype._decodeNull = function decodeNull(buffer) {
  return null;
};

DERNode.prototype._decodeBool = function decodeBool(buffer) {
  var res = buffer.readUInt8();
  if (buffer.isError(res))
    return res;
  else
    return res !== 0;
};

DERNode.prototype._decodeInt = function decodeInt(buffer, values) {
  // Bigint, return as it is (assume big endian)
  var raw = buffer.raw();
  var res = new bignum(raw);

  if (values)
    res = values[res.toString(10)] || res;

  return res;
};

DERNode.prototype._use = function use(entity, obj) {
  if (typeof entity === 'function')
    entity = entity(obj);
  return entity._getDecoder('der').tree;
};

// Utility methods

function derDecodeTag(buf, fail) {
  var tag = buf.readUInt8(fail);
  if (buf.isError(tag))
    return tag;

  var cls = der.tagClass[tag >> 6];
  var primitive = (tag & 0x20) === 0;

  // Multi-octet tag - load
  if ((tag & 0x1f) === 0x1f) {
    var oct = tag;
    tag = 0;
    while ((oct & 0x80) === 0x80) {
      oct = buf.readUInt8(fail);
      if (buf.isError(oct))
        return oct;

      tag <<= 7;
      tag |= oct & 0x7f;
    }
  } else {
    tag &= 0x1f;
  }
  var tagStr = der.tag[tag];

  return {
    cls: cls,
    primitive: primitive,
    tag: tag,
    tagStr: tagStr
  };
}

function derDecodeLen(buf, primitive, fail) {
  var len = buf.readUInt8(fail);
  if (buf.isError(len))
    return len;

  // Indefinite form
  if (!primitive && len === 0x80)
    return null;

  // Definite form
  if ((len & 0x80) === 0) {
    // Short form
    return len;
  }

  // Long form
  var num = len & 0x7f;
  if (num > 4)
    return buf.error('length octect is too long');

  len = 0;
  for (var i = 0; i < num; i++) {
    len <<= 8;
    var j = buf.readUInt8(fail);
    if (buf.isError(j))
      return j;
    len |= j;
  }

  return len;
}

},{"../../asn1":28,"inherits":126}],37:[function(require,module,exports){
var decoders = exports;

decoders.der = require('./der');
decoders.pem = require('./pem');

},{"./der":36,"./pem":38}],38:[function(require,module,exports){
var inherits = require('inherits');
var Buffer = require('buffer').Buffer;

var DERDecoder = require('./der');

function PEMDecoder(entity) {
  DERDecoder.call(this, entity);
  this.enc = 'pem';
};
inherits(PEMDecoder, DERDecoder);
module.exports = PEMDecoder;

PEMDecoder.prototype.decode = function decode(data, options) {
  var lines = data.toString().split(/[\r\n]+/g);

  var label = options.label.toUpperCase();

  var re = /^-----(BEGIN|END) ([^-]+)-----$/;
  var start = -1;
  var end = -1;
  for (var i = 0; i < lines.length; i++) {
    var match = lines[i].match(re);
    if (match === null)
      continue;

    if (match[2] !== label)
      continue;

    if (start === -1) {
      if (match[1] !== 'BEGIN')
        break;
      start = i;
    } else {
      if (match[1] !== 'END')
        break;
      end = i;
      break;
    }
  }
  if (start === -1 || end === -1)
    throw new Error('PEM section not found for: ' + label);

  var base64 = lines.slice(start + 1, end).join('');
  // Remove excessive symbols
  base64.replace(/[^a-z0-9\+\/=]+/gi, '');

  var input = new Buffer(base64, 'base64');
  return DERDecoder.prototype.decode.call(this, input, options);
};

},{"./der":36,"buffer":74,"inherits":126}],39:[function(require,module,exports){
var inherits = require('inherits');
var Buffer = require('buffer').Buffer;

var asn1 = require('../../asn1');
var base = asn1.base;

// Import DER constants
var der = asn1.constants.der;

function DEREncoder(entity) {
  this.enc = 'der';
  this.name = entity.name;
  this.entity = entity;

  // Construct base tree
  this.tree = new DERNode();
  this.tree._init(entity.body);
};
module.exports = DEREncoder;

DEREncoder.prototype.encode = function encode(data, reporter) {
  return this.tree._encode(data, reporter).join();
};

// Tree methods

function DERNode(parent) {
  base.Node.call(this, 'der', parent);
}
inherits(DERNode, base.Node);

DERNode.prototype._encodeComposite = function encodeComposite(tag,
                                                              primitive,
                                                              cls,
                                                              content) {
  var encodedTag = encodeTag(tag, primitive, cls, this.reporter);

  // Short form
  if (content.length < 0x80) {
    var header = new Buffer(2);
    header[0] = encodedTag;
    header[1] = content.length;
    return this._createEncoderBuffer([ header, content ]);
  }

  // Long form
  // Count octets required to store length
  var lenOctets = 1;
  for (var i = content.length; i >= 0x100; i >>= 8)
    lenOctets++;

  var header = new Buffer(1 + 1 + lenOctets);
  header[0] = encodedTag;
  header[1] = 0x80 | lenOctets;

  for (var i = 1 + lenOctets, j = content.length; j > 0; i--, j >>= 8)
    header[i] = j & 0xff;

  return this._createEncoderBuffer([ header, content ]);
};

DERNode.prototype._encodeStr = function encodeStr(str, tag) {
  if (tag === 'bitstr') {
    return this._createEncoderBuffer([ str.unused | 0, str.data ]);
  } else if (tag === 'bmpstr') {
    var buf = new Buffer(str.length * 2);
    for (var i = 0; i < str.length; i++) {
      buf.writeUInt16BE(str.charCodeAt(i), i * 2);
    }
    return this._createEncoderBuffer(buf);
  } else if (tag === 'numstr') {
    if (!this._isNumstr(str)) {
      return this.reporter.error('Encoding of string type: numstr supports ' +
                                 'only digits and space');
    }
    return this._createEncoderBuffer(str);
  } else if (tag === 'printstr') {
    if (!this._isPrintstr(str)) {
      return this.reporter.error('Encoding of string type: printstr supports ' +
                                 'only latin upper and lower case letters, ' +
                                 'digits, space, apostrophe, left and rigth ' +
                                 'parenthesis, plus sign, comma, hyphen, ' +
                                 'dot, slash, colon, equal sign, ' +
                                 'question mark');
    }
    return this._createEncoderBuffer(str);
  } else if (/str$/.test(tag)) {
    return this._createEncoderBuffer(str);
  } else if (tag === 'objDesc') {
    return this._createEncoderBuffer(str);
  } else {
    return this.reporter.error('Encoding of string type: ' + tag +
                               ' unsupported');
  }
};

DERNode.prototype._encodeObjid = function encodeObjid(id, values, relative) {
  if (typeof id === 'string') {
    if (!values)
      return this.reporter.error('string objid given, but no values map found');
    if (!values.hasOwnProperty(id))
      return this.reporter.error('objid not found in values map');
    id = values[id].split(/[\s\.]+/g);
    for (var i = 0; i < id.length; i++)
      id[i] |= 0;
  } else if (Array.isArray(id)) {
    id = id.slice();
    for (var i = 0; i < id.length; i++)
      id[i] |= 0;
  }

  if (!Array.isArray(id)) {
    return this.reporter.error('objid() should be either array or string, ' +
                               'got: ' + JSON.stringify(id));
  }

  if (!relative) {
    if (id[1] >= 40)
      return this.reporter.error('Second objid identifier OOB');
    id.splice(0, 2, id[0] * 40 + id[1]);
  }

  // Count number of octets
  var size = 0;
  for (var i = 0; i < id.length; i++) {
    var ident = id[i];
    for (size++; ident >= 0x80; ident >>= 7)
      size++;
  }

  var objid = new Buffer(size);
  var offset = objid.length - 1;
  for (var i = id.length - 1; i >= 0; i--) {
    var ident = id[i];
    objid[offset--] = ident & 0x7f;
    while ((ident >>= 7) > 0)
      objid[offset--] = 0x80 | (ident & 0x7f);
  }

  return this._createEncoderBuffer(objid);
};

function two(num) {
  if (num < 10)
    return '0' + num;
  else
    return num;
}

DERNode.prototype._encodeTime = function encodeTime(time, tag) {
  var str;
  var date = new Date(time);

  if (tag === 'gentime') {
    str = [
      two(date.getFullYear()),
      two(date.getUTCMonth() + 1),
      two(date.getUTCDate()),
      two(date.getUTCHours()),
      two(date.getUTCMinutes()),
      two(date.getUTCSeconds()),
      'Z'
    ].join('');
  } else if (tag === 'utctime') {
    str = [
      two(date.getFullYear() % 100),
      two(date.getUTCMonth() + 1),
      two(date.getUTCDate()),
      two(date.getUTCHours()),
      two(date.getUTCMinutes()),
      two(date.getUTCSeconds()),
      'Z'
    ].join('');
  } else {
    this.reporter.error('Encoding ' + tag + ' time is not supported yet');
  }

  return this._encodeStr(str, 'octstr');
};

DERNode.prototype._encodeNull = function encodeNull() {
  return this._createEncoderBuffer('');
};

DERNode.prototype._encodeInt = function encodeInt(num, values) {
  if (typeof num === 'string') {
    if (!values)
      return this.reporter.error('String int or enum given, but no values map');
    if (!values.hasOwnProperty(num)) {
      return this.reporter.error('Values map doesn\'t contain: ' +
                                 JSON.stringify(num));
    }
    num = values[num];
  }

  // Bignum, assume big endian
  if (typeof num !== 'number' && !Buffer.isBuffer(num)) {
    var numArray = num.toArray();
    if (!num.sign && numArray[0] & 0x80) {
      numArray.unshift(0);
    }
    num = new Buffer(numArray);
  }

  if (Buffer.isBuffer(num)) {
    var size = num.length;
    if (num.length === 0)
      size++;

    var out = new Buffer(size);
    num.copy(out);
    if (num.length === 0)
      out[0] = 0
    return this._createEncoderBuffer(out);
  }

  if (num < 0x80)
    return this._createEncoderBuffer(num);

  if (num < 0x100)
    return this._createEncoderBuffer([0, num]);

  var size = 1;
  for (var i = num; i >= 0x100; i >>= 8)
    size++;

  var out = new Array(size);
  for (var i = out.length - 1; i >= 0; i--) {
    out[i] = num & 0xff;
    num >>= 8;
  }
  if(out[0] & 0x80) {
    out.unshift(0);
  }

  return this._createEncoderBuffer(new Buffer(out));
};

DERNode.prototype._encodeBool = function encodeBool(value) {
  return this._createEncoderBuffer(value ? 0xff : 0);
};

DERNode.prototype._use = function use(entity, obj) {
  if (typeof entity === 'function')
    entity = entity(obj);
  return entity._getEncoder('der').tree;
};

DERNode.prototype._skipDefault = function skipDefault(dataBuffer, reporter, parent) {
  var state = this._baseState;
  var i;
  if (state['default'] === null)
    return false;

  var data = dataBuffer.join();
  if (state.defaultBuffer === undefined)
    state.defaultBuffer = this._encodeValue(state['default'], reporter, parent).join();

  if (data.length !== state.defaultBuffer.length)
    return false;

  for (i=0; i < data.length; i++)
    if (data[i] !== state.defaultBuffer[i])
      return false;

  return true;
};

// Utility methods

function encodeTag(tag, primitive, cls, reporter) {
  var res;

  if (tag === 'seqof')
    tag = 'seq';
  else if (tag === 'setof')
    tag = 'set';

  if (der.tagByName.hasOwnProperty(tag))
    res = der.tagByName[tag];
  else if (typeof tag === 'number' && (tag | 0) === tag)
    res = tag;
  else
    return reporter.error('Unknown tag: ' + tag);

  if (res >= 0x1f)
    return reporter.error('Multi-octet tag encoding unsupported');

  if (!primitive)
    res |= 0x20;

  res |= (der.tagClassByName[cls || 'universal'] << 6);

  return res;
}

},{"../../asn1":28,"buffer":74,"inherits":126}],40:[function(require,module,exports){
var encoders = exports;

encoders.der = require('./der');
encoders.pem = require('./pem');

},{"./der":39,"./pem":41}],41:[function(require,module,exports){
var inherits = require('inherits');

var DEREncoder = require('./der');

function PEMEncoder(entity) {
  DEREncoder.call(this, entity);
  this.enc = 'pem';
};
inherits(PEMEncoder, DEREncoder);
module.exports = PEMEncoder;

PEMEncoder.prototype.encode = function encode(data, options) {
  var buf = DEREncoder.prototype.encode.call(this, data);

  var p = buf.toString('base64');
  var out = [ '-----BEGIN ' + options.label + '-----' ];
  for (var i = 0; i < p.length; i += 64)
    out.push(p.slice(i, i + 64));
  out.push('-----END ' + options.label + '-----');
  return out.join('\n');
};

},{"./der":39,"inherits":126}],42:[function(require,module,exports){
arguments[4][15][0].apply(exports,arguments)
},{"dup":15}],43:[function(require,module,exports){
(function (module, exports) {
  'use strict';

  // Utils
  function assert (val, msg) {
    if (!val) throw new Error(msg || 'Assertion failed');
  }

  // Could use `inherits` module, but don't want to move from single file
  // architecture yet.
  function inherits (ctor, superCtor) {
    ctor.super_ = superCtor;
    var TempCtor = function () {};
    TempCtor.prototype = superCtor.prototype;
    ctor.prototype = new TempCtor();
    ctor.prototype.constructor = ctor;
  }

  // BN

  function BN (number, base, endian) {
    if (BN.isBN(number)) {
      return number;
    }

    this.negative = 0;
    this.words = null;
    this.length = 0;

    // Reduction context
    this.red = null;

    if (number !== null) {
      if (base === 'le' || base === 'be') {
        endian = base;
        base = 10;
      }

      this._init(number || 0, base || 10, endian || 'be');
    }
  }
  if (typeof module === 'object') {
    module.exports = BN;
  } else {
    exports.BN = BN;
  }

  BN.BN = BN;
  BN.wordSize = 26;

  var Buffer;
  try {
    Buffer = require('buffer').Buffer;
  } catch (e) {
  }

  BN.isBN = function isBN (num) {
    if (num instanceof BN) {
      return true;
    }

    return num !== null && typeof num === 'object' &&
      num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);
  };

  BN.max = function max (left, right) {
    if (left.cmp(right) > 0) return left;
    return right;
  };

  BN.min = function min (left, right) {
    if (left.cmp(right) < 0) return left;
    return right;
  };

  BN.prototype._init = function init (number, base, endian) {
    if (typeof number === 'number') {
      return this._initNumber(number, base, endian);
    }

    if (typeof number === 'object') {
      return this._initArray(number, base, endian);
    }

    if (base === 'hex') {
      base = 16;
    }
    assert(base === (base | 0) && base >= 2 && base <= 36);

    number = number.toString().replace(/\s+/g, '');
    var start = 0;
    if (number[0] === '-') {
      start++;
    }

    if (base === 16) {
      this._parseHex(number, start);
    } else {
      this._parseBase(number, base, start);
    }

    if (number[0] === '-') {
      this.negative = 1;
    }

    this.strip();

    if (endian !== 'le') return;

    this._initArray(this.toArray(), base, endian);
  };

  BN.prototype._initNumber = function _initNumber (number, base, endian) {
    if (number < 0) {
      this.negative = 1;
      number = -number;
    }
    if (number < 0x4000000) {
      this.words = [ number & 0x3ffffff ];
      this.length = 1;
    } else if (number < 0x10000000000000) {
      this.words = [
        number & 0x3ffffff,
        (number / 0x4000000) & 0x3ffffff
      ];
      this.length = 2;
    } else {
      assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)
      this.words = [
        number & 0x3ffffff,
        (number / 0x4000000) & 0x3ffffff,
        1
      ];
      this.length = 3;
    }

    if (endian !== 'le') return;

    // Reverse the bytes
    this._initArray(this.toArray(), base, endian);
  };

  BN.prototype._initArray = function _initArray (number, base, endian) {
    // Perhaps a Uint8Array
    assert(typeof number.length === 'number');
    if (number.length <= 0) {
      this.words = [ 0 ];
      this.length = 1;
      return this;
    }

    this.length = Math.ceil(number.length / 3);
    this.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      this.words[i] = 0;
    }

    var j, w;
    var off = 0;
    if (endian === 'be') {
      for (i = number.length - 1, j = 0; i >= 0; i -= 3) {
        w = number[i] | (number[i - 1] << 8) | (number[i - 2] << 16);
        this.words[j] |= (w << off) & 0x3ffffff;
        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;
        off += 24;
        if (off >= 26) {
          off -= 26;
          j++;
        }
      }
    } else if (endian === 'le') {
      for (i = 0, j = 0; i < number.length; i += 3) {
        w = number[i] | (number[i + 1] << 8) | (number[i + 2] << 16);
        this.words[j] |= (w << off) & 0x3ffffff;
        this.words[j + 1] = (w >>> (26 - off)) & 0x3ffffff;
        off += 24;
        if (off >= 26) {
          off -= 26;
          j++;
        }
      }
    }
    return this.strip();
  };

  function parseHex (str, start, end) {
    var r = 0;
    var len = Math.min(str.length, end);
    for (var i = start; i < len; i++) {
      var c = str.charCodeAt(i) - 48;

      r <<= 4;

      // 'a' - 'f'
      if (c >= 49 && c <= 54) {
        r |= c - 49 + 0xa;

      // 'A' - 'F'
      } else if (c >= 17 && c <= 22) {
        r |= c - 17 + 0xa;

      // '0' - '9'
      } else {
        r |= c & 0xf;
      }
    }
    return r;
  }

  BN.prototype._parseHex = function _parseHex (number, start) {
    // Create possibly bigger array to ensure that it fits the number
    this.length = Math.ceil((number.length - start) / 6);
    this.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      this.words[i] = 0;
    }

    var j, w;
    // Scan 24-bit chunks and add them to the number
    var off = 0;
    for (i = number.length - 6, j = 0; i >= start; i -= 6) {
      w = parseHex(number, i, i + 6);
      this.words[j] |= (w << off) & 0x3ffffff;
      // NOTE: `0x3fffff` is intentional here, 26bits max shift + 24bit hex limb
      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;
      off += 24;
      if (off >= 26) {
        off -= 26;
        j++;
      }
    }
    if (i + 6 !== start) {
      w = parseHex(number, start, i + 6);
      this.words[j] |= (w << off) & 0x3ffffff;
      this.words[j + 1] |= w >>> (26 - off) & 0x3fffff;
    }
    this.strip();
  };

  function parseBase (str, start, end, mul) {
    var r = 0;
    var len = Math.min(str.length, end);
    for (var i = start; i < len; i++) {
      var c = str.charCodeAt(i) - 48;

      r *= mul;

      // 'a'
      if (c >= 49) {
        r += c - 49 + 0xa;

      // 'A'
      } else if (c >= 17) {
        r += c - 17 + 0xa;

      // '0' - '9'
      } else {
        r += c;
      }
    }
    return r;
  }

  BN.prototype._parseBase = function _parseBase (number, base, start) {
    // Initialize as zero
    this.words = [ 0 ];
    this.length = 1;

    // Find length of limb in base
    for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {
      limbLen++;
    }
    limbLen--;
    limbPow = (limbPow / base) | 0;

    var total = number.length - start;
    var mod = total % limbLen;
    var end = Math.min(total, total - mod) + start;

    var word = 0;
    for (var i = start; i < end; i += limbLen) {
      word = parseBase(number, i, i + limbLen, base);

      this.imuln(limbPow);
      if (this.words[0] + word < 0x4000000) {
        this.words[0] += word;
      } else {
        this._iaddn(word);
      }
    }

    if (mod !== 0) {
      var pow = 1;
      word = parseBase(number, i, number.length, base);

      for (i = 0; i < mod; i++) {
        pow *= base;
      }

      this.imuln(pow);
      if (this.words[0] + word < 0x4000000) {
        this.words[0] += word;
      } else {
        this._iaddn(word);
      }
    }
  };

  BN.prototype.copy = function copy (dest) {
    dest.words = new Array(this.length);
    for (var i = 0; i < this.length; i++) {
      dest.words[i] = this.words[i];
    }
    dest.length = this.length;
    dest.negative = this.negative;
    dest.red = this.red;
  };

  BN.prototype.clone = function clone () {
    var r = new BN(null);
    this.copy(r);
    return r;
  };

  BN.prototype._expand = function _expand (size) {
    while (this.length < size) {
      this.words[this.length++] = 0;
    }
    return this;
  };

  // Remove leading `0` from `this`
  BN.prototype.strip = function strip () {
    while (this.length > 1 && this.words[this.length - 1] === 0) {
      this.length--;
    }
    return this._normSign();
  };

  BN.prototype._normSign = function _normSign () {
    // -0 = 0
    if (this.length === 1 && this.words[0] === 0) {
      this.negative = 0;
    }
    return this;
  };

  BN.prototype.inspect = function inspect () {
    return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';
  };

  /*

  var zeros = [];
  var groupSizes = [];
  var groupBases = [];

  var s = '';
  var i = -1;
  while (++i < BN.wordSize) {
    zeros[i] = s;
    s += '0';
  }
  groupSizes[0] = 0;
  groupSizes[1] = 0;
  groupBases[0] = 0;
  groupBases[1] = 0;
  var base = 2 - 1;
  while (++base < 36 + 1) {
    var groupSize = 0;
    var groupBase = 1;
    while (groupBase < (1 << BN.wordSize) / base) {
      groupBase *= base;
      groupSize += 1;
    }
    groupSizes[base] = groupSize;
    groupBases[base] = groupBase;
  }

  */

  var zeros = [
    '',
    '0',
    '00',
    '000',
    '0000',
    '00000',
    '000000',
    '0000000',
    '00000000',
    '000000000',
    '0000000000',
    '00000000000',
    '000000000000',
    '0000000000000',
    '00000000000000',
    '000000000000000',
    '0000000000000000',
    '00000000000000000',
    '000000000000000000',
    '0000000000000000000',
    '00000000000000000000',
    '000000000000000000000',
    '0000000000000000000000',
    '00000000000000000000000',
    '000000000000000000000000',
    '0000000000000000000000000'
  ];

  var groupSizes = [
    0, 0,
    25, 16, 12, 11, 10, 9, 8,
    8, 7, 7, 7, 7, 6, 6,
    6, 6, 6, 6, 6, 5, 5,
    5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5
  ];

  var groupBases = [
    0, 0,
    33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216,
    43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625,
    16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632,
    6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149,
    24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176
  ];

  BN.prototype.toString = function toString (base, padding) {
    base = base || 10;
    padding = padding | 0 || 1;

    var out;
    if (base === 16 || base === 'hex') {
      out = '';
      var off = 0;
      var carry = 0;
      for (var i = 0; i < this.length; i++) {
        var w = this.words[i];
        var word = (((w << off) | carry) & 0xffffff).toString(16);
        carry = (w >>> (24 - off)) & 0xffffff;
        if (carry !== 0 || i !== this.length - 1) {
          out = zeros[6 - word.length] + word + out;
        } else {
          out = word + out;
        }
        off += 2;
        if (off >= 26) {
          off -= 26;
          i--;
        }
      }
      if (carry !== 0) {
        out = carry.toString(16) + out;
      }
      while (out.length % padding !== 0) {
        out = '0' + out;
      }
      if (this.negative !== 0) {
        out = '-' + out;
      }
      return out;
    }

    if (base === (base | 0) && base >= 2 && base <= 36) {
      // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));
      var groupSize = groupSizes[base];
      // var groupBase = Math.pow(base, groupSize);
      var groupBase = groupBases[base];
      out = '';
      var c = this.clone();
      c.negative = 0;
      while (!c.isZero()) {
        var r = c.modn(groupBase).toString(base);
        c = c.idivn(groupBase);

        if (!c.isZero()) {
          out = zeros[groupSize - r.length] + r + out;
        } else {
          out = r + out;
        }
      }
      if (this.isZero()) {
        out = '0' + out;
      }
      while (out.length % padding !== 0) {
        out = '0' + out;
      }
      if (this.negative !== 0) {
        out = '-' + out;
      }
      return out;
    }

    assert(false, 'Base should be between 2 and 36');
  };

  BN.prototype.toNumber = function toNumber () {
    var ret = this.words[0];
    if (this.length === 2) {
      ret += this.words[1] * 0x4000000;
    } else if (this.length === 3 && this.words[2] === 0x01) {
      // NOTE: at this stage it is known that the top bit is set
      ret += 0x10000000000000 + (this.words[1] * 0x4000000);
    } else if (this.length > 2) {
      assert(false, 'Number can only safely store up to 53 bits');
    }
    return (this.negative !== 0) ? -ret : ret;
  };

  BN.prototype.toJSON = function toJSON () {
    return this.toString(16);
  };

  BN.prototype.toBuffer = function toBuffer (endian, length) {
    assert(typeof Buffer !== 'undefined');
    return this.toArrayLike(Buffer, endian, length);
  };

  BN.prototype.toArray = function toArray (endian, length) {
    return this.toArrayLike(Array, endian, length);
  };

  BN.prototype.toArrayLike = function toArrayLike (ArrayType, endian, length) {
    var byteLength = this.byteLength();
    var reqLength = length || Math.max(1, byteLength);
    assert(byteLength <= reqLength, 'byte array longer than desired length');
    assert(reqLength > 0, 'Requested array length <= 0');

    this.strip();
    var littleEndian = endian === 'le';
    var res = new ArrayType(reqLength);

    var b, i;
    var q = this.clone();
    if (!littleEndian) {
      // Assume big-endian
      for (i = 0; i < reqLength - byteLength; i++) {
        res[i] = 0;
      }

      for (i = 0; !q.isZero(); i++) {
        b = q.andln(0xff);
        q.iushrn(8);

        res[reqLength - i - 1] = b;
      }
    } else {
      for (i = 0; !q.isZero(); i++) {
        b = q.andln(0xff);
        q.iushrn(8);

        res[i] = b;
      }

      for (; i < reqLength; i++) {
        res[i] = 0;
      }
    }

    return res;
  };

  if (Math.clz32) {
    BN.prototype._countBits = function _countBits (w) {
      return 32 - Math.clz32(w);
    };
  } else {
    BN.prototype._countBits = function _countBits (w) {
      var t = w;
      var r = 0;
      if (t >= 0x1000) {
        r += 13;
        t >>>= 13;
      }
      if (t >= 0x40) {
        r += 7;
        t >>>= 7;
      }
      if (t >= 0x8) {
        r += 4;
        t >>>= 4;
      }
      if (t >= 0x02) {
        r += 2;
        t >>>= 2;
      }
      return r + t;
    };
  }

  BN.prototype._zeroBits = function _zeroBits (w) {
    // Short-cut
    if (w === 0) return 26;

    var t = w;
    var r = 0;
    if ((t & 0x1fff) === 0) {
      r += 13;
      t >>>= 13;
    }
    if ((t & 0x7f) === 0) {
      r += 7;
      t >>>= 7;
    }
    if ((t & 0xf) === 0) {
      r += 4;
      t >>>= 4;
    }
    if ((t & 0x3) === 0) {
      r += 2;
      t >>>= 2;
    }
    if ((t & 0x1) === 0) {
      r++;
    }
    return r;
  };

  // Return number of used bits in a BN
  BN.prototype.bitLength = function bitLength () {
    var w = this.words[this.length - 1];
    var hi = this._countBits(w);
    return (this.length - 1) * 26 + hi;
  };

  function toBitArray (num) {
    var w = new Array(num.bitLength());

    for (var bit = 0; bit < w.length; bit++) {
      var off = (bit / 26) | 0;
      var wbit = bit % 26;

      w[bit] = (num.words[off] & (1 << wbit)) >>> wbit;
    }

    return w;
  }

  // Number of trailing zero bits
  BN.prototype.zeroBits = function zeroBits () {
    if (this.isZero()) return 0;

    var r = 0;
    for (var i = 0; i < this.length; i++) {
      var b = this._zeroBits(this.words[i]);
      r += b;
      if (b !== 26) break;
    }
    return r;
  };

  BN.prototype.byteLength = function byteLength () {
    return Math.ceil(this.bitLength() / 8);
  };

  BN.prototype.toTwos = function toTwos (width) {
    if (this.negative !== 0) {
      return this.abs().inotn(width).iaddn(1);
    }
    return this.clone();
  };

  BN.prototype.fromTwos = function fromTwos (width) {
    if (this.testn(width - 1)) {
      return this.notn(width).iaddn(1).ineg();
    }
    return this.clone();
  };

  BN.prototype.isNeg = function isNeg () {
    return this.negative !== 0;
  };

  // Return negative clone of `this`
  BN.prototype.neg = function neg () {
    return this.clone().ineg();
  };

  BN.prototype.ineg = function ineg () {
    if (!this.isZero()) {
      this.negative ^= 1;
    }

    return this;
  };

  // Or `num` with `this` in-place
  BN.prototype.iuor = function iuor (num) {
    while (this.length < num.length) {
      this.words[this.length++] = 0;
    }

    for (var i = 0; i < num.length; i++) {
      this.words[i] = this.words[i] | num.words[i];
    }

    return this.strip();
  };

  BN.prototype.ior = function ior (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuor(num);
  };

  // Or `num` with `this`
  BN.prototype.or = function or (num) {
    if (this.length > num.length) return this.clone().ior(num);
    return num.clone().ior(this);
  };

  BN.prototype.uor = function uor (num) {
    if (this.length > num.length) return this.clone().iuor(num);
    return num.clone().iuor(this);
  };

  // And `num` with `this` in-place
  BN.prototype.iuand = function iuand (num) {
    // b = min-length(num, this)
    var b;
    if (this.length > num.length) {
      b = num;
    } else {
      b = this;
    }

    for (var i = 0; i < b.length; i++) {
      this.words[i] = this.words[i] & num.words[i];
    }

    this.length = b.length;

    return this.strip();
  };

  BN.prototype.iand = function iand (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuand(num);
  };

  // And `num` with `this`
  BN.prototype.and = function and (num) {
    if (this.length > num.length) return this.clone().iand(num);
    return num.clone().iand(this);
  };

  BN.prototype.uand = function uand (num) {
    if (this.length > num.length) return this.clone().iuand(num);
    return num.clone().iuand(this);
  };

  // Xor `num` with `this` in-place
  BN.prototype.iuxor = function iuxor (num) {
    // a.length > b.length
    var a;
    var b;
    if (this.length > num.length) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    for (var i = 0; i < b.length; i++) {
      this.words[i] = a.words[i] ^ b.words[i];
    }

    if (this !== a) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    this.length = a.length;

    return this.strip();
  };

  BN.prototype.ixor = function ixor (num) {
    assert((this.negative | num.negative) === 0);
    return this.iuxor(num);
  };

  // Xor `num` with `this`
  BN.prototype.xor = function xor (num) {
    if (this.length > num.length) return this.clone().ixor(num);
    return num.clone().ixor(this);
  };

  BN.prototype.uxor = function uxor (num) {
    if (this.length > num.length) return this.clone().iuxor(num);
    return num.clone().iuxor(this);
  };

  // Not ``this`` with ``width`` bitwidth
  BN.prototype.inotn = function inotn (width) {
    assert(typeof width === 'number' && width >= 0);

    var bytesNeeded = Math.ceil(width / 26) | 0;
    var bitsLeft = width % 26;

    // Extend the buffer with leading zeroes
    this._expand(bytesNeeded);

    if (bitsLeft > 0) {
      bytesNeeded--;
    }

    // Handle complete words
    for (var i = 0; i < bytesNeeded; i++) {
      this.words[i] = ~this.words[i] & 0x3ffffff;
    }

    // Handle the residue
    if (bitsLeft > 0) {
      this.words[i] = ~this.words[i] & (0x3ffffff >> (26 - bitsLeft));
    }

    // And remove leading zeroes
    return this.strip();
  };

  BN.prototype.notn = function notn (width) {
    return this.clone().inotn(width);
  };

  // Set `bit` of `this`
  BN.prototype.setn = function setn (bit, val) {
    assert(typeof bit === 'number' && bit >= 0);

    var off = (bit / 26) | 0;
    var wbit = bit % 26;

    this._expand(off + 1);

    if (val) {
      this.words[off] = this.words[off] | (1 << wbit);
    } else {
      this.words[off] = this.words[off] & ~(1 << wbit);
    }

    return this.strip();
  };

  // Add `num` to `this` in-place
  BN.prototype.iadd = function iadd (num) {
    var r;

    // negative + positive
    if (this.negative !== 0 && num.negative === 0) {
      this.negative = 0;
      r = this.isub(num);
      this.negative ^= 1;
      return this._normSign();

    // positive + negative
    } else if (this.negative === 0 && num.negative !== 0) {
      num.negative = 0;
      r = this.isub(num);
      num.negative = 1;
      return r._normSign();
    }

    // a.length > b.length
    var a, b;
    if (this.length > num.length) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    var carry = 0;
    for (var i = 0; i < b.length; i++) {
      r = (a.words[i] | 0) + (b.words[i] | 0) + carry;
      this.words[i] = r & 0x3ffffff;
      carry = r >>> 26;
    }
    for (; carry !== 0 && i < a.length; i++) {
      r = (a.words[i] | 0) + carry;
      this.words[i] = r & 0x3ffffff;
      carry = r >>> 26;
    }

    this.length = a.length;
    if (carry !== 0) {
      this.words[this.length] = carry;
      this.length++;
    // Copy the rest of the words
    } else if (a !== this) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    return this;
  };

  // Add `num` to `this`
  BN.prototype.add = function add (num) {
    var res;
    if (num.negative !== 0 && this.negative === 0) {
      num.negative = 0;
      res = this.sub(num);
      num.negative ^= 1;
      return res;
    } else if (num.negative === 0 && this.negative !== 0) {
      this.negative = 0;
      res = num.sub(this);
      this.negative = 1;
      return res;
    }

    if (this.length > num.length) return this.clone().iadd(num);

    return num.clone().iadd(this);
  };

  // Subtract `num` from `this` in-place
  BN.prototype.isub = function isub (num) {
    // this - (-num) = this + num
    if (num.negative !== 0) {
      num.negative = 0;
      var r = this.iadd(num);
      num.negative = 1;
      return r._normSign();

    // -this - num = -(this + num)
    } else if (this.negative !== 0) {
      this.negative = 0;
      this.iadd(num);
      this.negative = 1;
      return this._normSign();
    }

    // At this point both numbers are positive
    var cmp = this.cmp(num);

    // Optimization - zeroify
    if (cmp === 0) {
      this.negative = 0;
      this.length = 1;
      this.words[0] = 0;
      return this;
    }

    // a > b
    var a, b;
    if (cmp > 0) {
      a = this;
      b = num;
    } else {
      a = num;
      b = this;
    }

    var carry = 0;
    for (var i = 0; i < b.length; i++) {
      r = (a.words[i] | 0) - (b.words[i] | 0) + carry;
      carry = r >> 26;
      this.words[i] = r & 0x3ffffff;
    }
    for (; carry !== 0 && i < a.length; i++) {
      r = (a.words[i] | 0) + carry;
      carry = r >> 26;
      this.words[i] = r & 0x3ffffff;
    }

    // Copy rest of the words
    if (carry === 0 && i < a.length && a !== this) {
      for (; i < a.length; i++) {
        this.words[i] = a.words[i];
      }
    }

    this.length = Math.max(this.length, i);

    if (a !== this) {
      this.negative = 1;
    }

    return this.strip();
  };

  // Subtract `num` from `this`
  BN.prototype.sub = function sub (num) {
    return this.clone().isub(num);
  };

  function smallMulTo (self, num, out) {
    out.negative = num.negative ^ self.negative;
    var len = (self.length + num.length) | 0;
    out.length = len;
    len = (len - 1) | 0;

    // Peel one iteration (compiler can't do it, because of code complexity)
    var a = self.words[0] | 0;
    var b = num.words[0] | 0;
    var r = a * b;

    var lo = r & 0x3ffffff;
    var carry = (r / 0x4000000) | 0;
    out.words[0] = lo;

    for (var k = 1; k < len; k++) {
      // Sum all words with the same `i + j = k` and accumulate `ncarry`,
      // note that ncarry could be >= 0x3ffffff
      var ncarry = carry >>> 26;
      var rword = carry & 0x3ffffff;
      var maxJ = Math.min(k, num.length - 1);
      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
        var i = (k - j) | 0;
        a = self.words[i] | 0;
        b = num.words[j] | 0;
        r = a * b + rword;
        ncarry += (r / 0x4000000) | 0;
        rword = r & 0x3ffffff;
      }
      out.words[k] = rword | 0;
      carry = ncarry | 0;
    }
    if (carry !== 0) {
      out.words[k] = carry | 0;
    } else {
      out.length--;
    }

    return out.strip();
  }

  // TODO(indutny): it may be reasonable to omit it for users who don't need
  // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit
  // multiplication (like elliptic secp256k1).
  var comb10MulTo = function comb10MulTo (self, num, out) {
    var a = self.words;
    var b = num.words;
    var o = out.words;
    var c = 0;
    var lo;
    var mid;
    var hi;
    var a0 = a[0] | 0;
    var al0 = a0 & 0x1fff;
    var ah0 = a0 >>> 13;
    var a1 = a[1] | 0;
    var al1 = a1 & 0x1fff;
    var ah1 = a1 >>> 13;
    var a2 = a[2] | 0;
    var al2 = a2 & 0x1fff;
    var ah2 = a2 >>> 13;
    var a3 = a[3] | 0;
    var al3 = a3 & 0x1fff;
    var ah3 = a3 >>> 13;
    var a4 = a[4] | 0;
    var al4 = a4 & 0x1fff;
    var ah4 = a4 >>> 13;
    var a5 = a[5] | 0;
    var al5 = a5 & 0x1fff;
    var ah5 = a5 >>> 13;
    var a6 = a[6] | 0;
    var al6 = a6 & 0x1fff;
    var ah6 = a6 >>> 13;
    var a7 = a[7] | 0;
    var al7 = a7 & 0x1fff;
    var ah7 = a7 >>> 13;
    var a8 = a[8] | 0;
    var al8 = a8 & 0x1fff;
    var ah8 = a8 >>> 13;
    var a9 = a[9] | 0;
    var al9 = a9 & 0x1fff;
    var ah9 = a9 >>> 13;
    var b0 = b[0] | 0;
    var bl0 = b0 & 0x1fff;
    var bh0 = b0 >>> 13;
    var b1 = b[1] | 0;
    var bl1 = b1 & 0x1fff;
    var bh1 = b1 >>> 13;
    var b2 = b[2] | 0;
    var bl2 = b2 & 0x1fff;
    var bh2 = b2 >>> 13;
    var b3 = b[3] | 0;
    var bl3 = b3 & 0x1fff;
    var bh3 = b3 >>> 13;
    var b4 = b[4] | 0;
    var bl4 = b4 & 0x1fff;
    var bh4 = b4 >>> 13;
    var b5 = b[5] | 0;
    var bl5 = b5 & 0x1fff;
    var bh5 = b5 >>> 13;
    var b6 = b[6] | 0;
    var bl6 = b6 & 0x1fff;
    var bh6 = b6 >>> 13;
    var b7 = b[7] | 0;
    var bl7 = b7 & 0x1fff;
    var bh7 = b7 >>> 13;
    var b8 = b[8] | 0;
    var bl8 = b8 & 0x1fff;
    var bh8 = b8 >>> 13;
    var b9 = b[9] | 0;
    var bl9 = b9 & 0x1fff;
    var bh9 = b9 >>> 13;

    out.negative = self.negative ^ num.negative;
    out.length = 19;
    /* k = 0 */
    lo = Math.imul(al0, bl0);
    mid = Math.imul(al0, bh0);
    mid = (mid + Math.imul(ah0, bl0)) | 0;
    hi = Math.imul(ah0, bh0);
    var w0 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w0 >>> 26)) | 0;
    w0 &= 0x3ffffff;
    /* k = 1 */
    lo = Math.imul(al1, bl0);
    mid = Math.imul(al1, bh0);
    mid = (mid + Math.imul(ah1, bl0)) | 0;
    hi = Math.imul(ah1, bh0);
    lo = (lo + Math.imul(al0, bl1)) | 0;
    mid = (mid + Math.imul(al0, bh1)) | 0;
    mid = (mid + Math.imul(ah0, bl1)) | 0;
    hi = (hi + Math.imul(ah0, bh1)) | 0;
    var w1 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w1 >>> 26)) | 0;
    w1 &= 0x3ffffff;
    /* k = 2 */
    lo = Math.imul(al2, bl0);
    mid = Math.imul(al2, bh0);
    mid = (mid + Math.imul(ah2, bl0)) | 0;
    hi = Math.imul(ah2, bh0);
    lo = (lo + Math.imul(al1, bl1)) | 0;
    mid = (mid + Math.imul(al1, bh1)) | 0;
    mid = (mid + Math.imul(ah1, bl1)) | 0;
    hi = (hi + Math.imul(ah1, bh1)) | 0;
    lo = (lo + Math.imul(al0, bl2)) | 0;
    mid = (mid + Math.imul(al0, bh2)) | 0;
    mid = (mid + Math.imul(ah0, bl2)) | 0;
    hi = (hi + Math.imul(ah0, bh2)) | 0;
    var w2 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w2 >>> 26)) | 0;
    w2 &= 0x3ffffff;
    /* k = 3 */
    lo = Math.imul(al3, bl0);
    mid = Math.imul(al3, bh0);
    mid = (mid + Math.imul(ah3, bl0)) | 0;
    hi = Math.imul(ah3, bh0);
    lo = (lo + Math.imul(al2, bl1)) | 0;
    mid = (mid + Math.imul(al2, bh1)) | 0;
    mid = (mid + Math.imul(ah2, bl1)) | 0;
    hi = (hi + Math.imul(ah2, bh1)) | 0;
    lo = (lo + Math.imul(al1, bl2)) | 0;
    mid = (mid + Math.imul(al1, bh2)) | 0;
    mid = (mid + Math.imul(ah1, bl2)) | 0;
    hi = (hi + Math.imul(ah1, bh2)) | 0;
    lo = (lo + Math.imul(al0, bl3)) | 0;
    mid = (mid + Math.imul(al0, bh3)) | 0;
    mid = (mid + Math.imul(ah0, bl3)) | 0;
    hi = (hi + Math.imul(ah0, bh3)) | 0;
    var w3 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w3 >>> 26)) | 0;
    w3 &= 0x3ffffff;
    /* k = 4 */
    lo = Math.imul(al4, bl0);
    mid = Math.imul(al4, bh0);
    mid = (mid + Math.imul(ah4, bl0)) | 0;
    hi = Math.imul(ah4, bh0);
    lo = (lo + Math.imul(al3, bl1)) | 0;
    mid = (mid + Math.imul(al3, bh1)) | 0;
    mid = (mid + Math.imul(ah3, bl1)) | 0;
    hi = (hi + Math.imul(ah3, bh1)) | 0;
    lo = (lo + Math.imul(al2, bl2)) | 0;
    mid = (mid + Math.imul(al2, bh2)) | 0;
    mid = (mid + Math.imul(ah2, bl2)) | 0;
    hi = (hi + Math.imul(ah2, bh2)) | 0;
    lo = (lo + Math.imul(al1, bl3)) | 0;
    mid = (mid + Math.imul(al1, bh3)) | 0;
    mid = (mid + Math.imul(ah1, bl3)) | 0;
    hi = (hi + Math.imul(ah1, bh3)) | 0;
    lo = (lo + Math.imul(al0, bl4)) | 0;
    mid = (mid + Math.imul(al0, bh4)) | 0;
    mid = (mid + Math.imul(ah0, bl4)) | 0;
    hi = (hi + Math.imul(ah0, bh4)) | 0;
    var w4 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w4 >>> 26)) | 0;
    w4 &= 0x3ffffff;
    /* k = 5 */
    lo = Math.imul(al5, bl0);
    mid = Math.imul(al5, bh0);
    mid = (mid + Math.imul(ah5, bl0)) | 0;
    hi = Math.imul(ah5, bh0);
    lo = (lo + Math.imul(al4, bl1)) | 0;
    mid = (mid + Math.imul(al4, bh1)) | 0;
    mid = (mid + Math.imul(ah4, bl1)) | 0;
    hi = (hi + Math.imul(ah4, bh1)) | 0;
    lo = (lo + Math.imul(al3, bl2)) | 0;
    mid = (mid + Math.imul(al3, bh2)) | 0;
    mid = (mid + Math.imul(ah3, bl2)) | 0;
    hi = (hi + Math.imul(ah3, bh2)) | 0;
    lo = (lo + Math.imul(al2, bl3)) | 0;
    mid = (mid + Math.imul(al2, bh3)) | 0;
    mid = (mid + Math.imul(ah2, bl3)) | 0;
    hi = (hi + Math.imul(ah2, bh3)) | 0;
    lo = (lo + Math.imul(al1, bl4)) | 0;
    mid = (mid + Math.imul(al1, bh4)) | 0;
    mid = (mid + Math.imul(ah1, bl4)) | 0;
    hi = (hi + Math.imul(ah1, bh4)) | 0;
    lo = (lo + Math.imul(al0, bl5)) | 0;
    mid = (mid + Math.imul(al0, bh5)) | 0;
    mid = (mid + Math.imul(ah0, bl5)) | 0;
    hi = (hi + Math.imul(ah0, bh5)) | 0;
    var w5 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w5 >>> 26)) | 0;
    w5 &= 0x3ffffff;
    /* k = 6 */
    lo = Math.imul(al6, bl0);
    mid = Math.imul(al6, bh0);
    mid = (mid + Math.imul(ah6, bl0)) | 0;
    hi = Math.imul(ah6, bh0);
    lo = (lo + Math.imul(al5, bl1)) | 0;
    mid = (mid + Math.imul(al5, bh1)) | 0;
    mid = (mid + Math.imul(ah5, bl1)) | 0;
    hi = (hi + Math.imul(ah5, bh1)) | 0;
    lo = (lo + Math.imul(al4, bl2)) | 0;
    mid = (mid + Math.imul(al4, bh2)) | 0;
    mid = (mid + Math.imul(ah4, bl2)) | 0;
    hi = (hi + Math.imul(ah4, bh2)) | 0;
    lo = (lo + Math.imul(al3, bl3)) | 0;
    mid = (mid + Math.imul(al3, bh3)) | 0;
    mid = (mid + Math.imul(ah3, bl3)) | 0;
    hi = (hi + Math.imul(ah3, bh3)) | 0;
    lo = (lo + Math.imul(al2, bl4)) | 0;
    mid = (mid + Math.imul(al2, bh4)) | 0;
    mid = (mid + Math.imul(ah2, bl4)) | 0;
    hi = (hi + Math.imul(ah2, bh4)) | 0;
    lo = (lo + Math.imul(al1, bl5)) | 0;
    mid = (mid + Math.imul(al1, bh5)) | 0;
    mid = (mid + Math.imul(ah1, bl5)) | 0;
    hi = (hi + Math.imul(ah1, bh5)) | 0;
    lo = (lo + Math.imul(al0, bl6)) | 0;
    mid = (mid + Math.imul(al0, bh6)) | 0;
    mid = (mid + Math.imul(ah0, bl6)) | 0;
    hi = (hi + Math.imul(ah0, bh6)) | 0;
    var w6 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w6 >>> 26)) | 0;
    w6 &= 0x3ffffff;
    /* k = 7 */
    lo = Math.imul(al7, bl0);
    mid = Math.imul(al7, bh0);
    mid = (mid + Math.imul(ah7, bl0)) | 0;
    hi = Math.imul(ah7, bh0);
    lo = (lo + Math.imul(al6, bl1)) | 0;
    mid = (mid + Math.imul(al6, bh1)) | 0;
    mid = (mid + Math.imul(ah6, bl1)) | 0;
    hi = (hi + Math.imul(ah6, bh1)) | 0;
    lo = (lo + Math.imul(al5, bl2)) | 0;
    mid = (mid + Math.imul(al5, bh2)) | 0;
    mid = (mid + Math.imul(ah5, bl2)) | 0;
    hi = (hi + Math.imul(ah5, bh2)) | 0;
    lo = (lo + Math.imul(al4, bl3)) | 0;
    mid = (mid + Math.imul(al4, bh3)) | 0;
    mid = (mid + Math.imul(ah4, bl3)) | 0;
    hi = (hi + Math.imul(ah4, bh3)) | 0;
    lo = (lo + Math.imul(al3, bl4)) | 0;
    mid = (mid + Math.imul(al3, bh4)) | 0;
    mid = (mid + Math.imul(ah3, bl4)) | 0;
    hi = (hi + Math.imul(ah3, bh4)) | 0;
    lo = (lo + Math.imul(al2, bl5)) | 0;
    mid = (mid + Math.imul(al2, bh5)) | 0;
    mid = (mid + Math.imul(ah2, bl5)) | 0;
    hi = (hi + Math.imul(ah2, bh5)) | 0;
    lo = (lo + Math.imul(al1, bl6)) | 0;
    mid = (mid + Math.imul(al1, bh6)) | 0;
    mid = (mid + Math.imul(ah1, bl6)) | 0;
    hi = (hi + Math.imul(ah1, bh6)) | 0;
    lo = (lo + Math.imul(al0, bl7)) | 0;
    mid = (mid + Math.imul(al0, bh7)) | 0;
    mid = (mid + Math.imul(ah0, bl7)) | 0;
    hi = (hi + Math.imul(ah0, bh7)) | 0;
    var w7 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w7 >>> 26)) | 0;
    w7 &= 0x3ffffff;
    /* k = 8 */
    lo = Math.imul(al8, bl0);
    mid = Math.imul(al8, bh0);
    mid = (mid + Math.imul(ah8, bl0)) | 0;
    hi = Math.imul(ah8, bh0);
    lo = (lo + Math.imul(al7, bl1)) | 0;
    mid = (mid + Math.imul(al7, bh1)) | 0;
    mid = (mid + Math.imul(ah7, bl1)) | 0;
    hi = (hi + Math.imul(ah7, bh1)) | 0;
    lo = (lo + Math.imul(al6, bl2)) | 0;
    mid = (mid + Math.imul(al6, bh2)) | 0;
    mid = (mid + Math.imul(ah6, bl2)) | 0;
    hi = (hi + Math.imul(ah6, bh2)) | 0;
    lo = (lo + Math.imul(al5, bl3)) | 0;
    mid = (mid + Math.imul(al5, bh3)) | 0;
    mid = (mid + Math.imul(ah5, bl3)) | 0;
    hi = (hi + Math.imul(ah5, bh3)) | 0;
    lo = (lo + Math.imul(al4, bl4)) | 0;
    mid = (mid + Math.imul(al4, bh4)) | 0;
    mid = (mid + Math.imul(ah4, bl4)) | 0;
    hi = (hi + Math.imul(ah4, bh4)) | 0;
    lo = (lo + Math.imul(al3, bl5)) | 0;
    mid = (mid + Math.imul(al3, bh5)) | 0;
    mid = (mid + Math.imul(ah3, bl5)) | 0;
    hi = (hi + Math.imul(ah3, bh5)) | 0;
    lo = (lo + Math.imul(al2, bl6)) | 0;
    mid = (mid + Math.imul(al2, bh6)) | 0;
    mid = (mid + Math.imul(ah2, bl6)) | 0;
    hi = (hi + Math.imul(ah2, bh6)) | 0;
    lo = (lo + Math.imul(al1, bl7)) | 0;
    mid = (mid + Math.imul(al1, bh7)) | 0;
    mid = (mid + Math.imul(ah1, bl7)) | 0;
    hi = (hi + Math.imul(ah1, bh7)) | 0;
    lo = (lo + Math.imul(al0, bl8)) | 0;
    mid = (mid + Math.imul(al0, bh8)) | 0;
    mid = (mid + Math.imul(ah0, bl8)) | 0;
    hi = (hi + Math.imul(ah0, bh8)) | 0;
    var w8 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w8 >>> 26)) | 0;
    w8 &= 0x3ffffff;
    /* k = 9 */
    lo = Math.imul(al9, bl0);
    mid = Math.imul(al9, bh0);
    mid = (mid + Math.imul(ah9, bl0)) | 0;
    hi = Math.imul(ah9, bh0);
    lo = (lo + Math.imul(al8, bl1)) | 0;
    mid = (mid + Math.imul(al8, bh1)) | 0;
    mid = (mid + Math.imul(ah8, bl1)) | 0;
    hi = (hi + Math.imul(ah8, bh1)) | 0;
    lo = (lo + Math.imul(al7, bl2)) | 0;
    mid = (mid + Math.imul(al7, bh2)) | 0;
    mid = (mid + Math.imul(ah7, bl2)) | 0;
    hi = (hi + Math.imul(ah7, bh2)) | 0;
    lo = (lo + Math.imul(al6, bl3)) | 0;
    mid = (mid + Math.imul(al6, bh3)) | 0;
    mid = (mid + Math.imul(ah6, bl3)) | 0;
    hi = (hi + Math.imul(ah6, bh3)) | 0;
    lo = (lo + Math.imul(al5, bl4)) | 0;
    mid = (mid + Math.imul(al5, bh4)) | 0;
    mid = (mid + Math.imul(ah5, bl4)) | 0;
    hi = (hi + Math.imul(ah5, bh4)) | 0;
    lo = (lo + Math.imul(al4, bl5)) | 0;
    mid = (mid + Math.imul(al4, bh5)) | 0;
    mid = (mid + Math.imul(ah4, bl5)) | 0;
    hi = (hi + Math.imul(ah4, bh5)) | 0;
    lo = (lo + Math.imul(al3, bl6)) | 0;
    mid = (mid + Math.imul(al3, bh6)) | 0;
    mid = (mid + Math.imul(ah3, bl6)) | 0;
    hi = (hi + Math.imul(ah3, bh6)) | 0;
    lo = (lo + Math.imul(al2, bl7)) | 0;
    mid = (mid + Math.imul(al2, bh7)) | 0;
    mid = (mid + Math.imul(ah2, bl7)) | 0;
    hi = (hi + Math.imul(ah2, bh7)) | 0;
    lo = (lo + Math.imul(al1, bl8)) | 0;
    mid = (mid + Math.imul(al1, bh8)) | 0;
    mid = (mid + Math.imul(ah1, bl8)) | 0;
    hi = (hi + Math.imul(ah1, bh8)) | 0;
    lo = (lo + Math.imul(al0, bl9)) | 0;
    mid = (mid + Math.imul(al0, bh9)) | 0;
    mid = (mid + Math.imul(ah0, bl9)) | 0;
    hi = (hi + Math.imul(ah0, bh9)) | 0;
    var w9 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w9 >>> 26)) | 0;
    w9 &= 0x3ffffff;
    /* k = 10 */
    lo = Math.imul(al9, bl1);
    mid = Math.imul(al9, bh1);
    mid = (mid + Math.imul(ah9, bl1)) | 0;
    hi = Math.imul(ah9, bh1);
    lo = (lo + Math.imul(al8, bl2)) | 0;
    mid = (mid + Math.imul(al8, bh2)) | 0;
    mid = (mid + Math.imul(ah8, bl2)) | 0;
    hi = (hi + Math.imul(ah8, bh2)) | 0;
    lo = (lo + Math.imul(al7, bl3)) | 0;
    mid = (mid + Math.imul(al7, bh3)) | 0;
    mid = (mid + Math.imul(ah7, bl3)) | 0;
    hi = (hi + Math.imul(ah7, bh3)) | 0;
    lo = (lo + Math.imul(al6, bl4)) | 0;
    mid = (mid + Math.imul(al6, bh4)) | 0;
    mid = (mid + Math.imul(ah6, bl4)) | 0;
    hi = (hi + Math.imul(ah6, bh4)) | 0;
    lo = (lo + Math.imul(al5, bl5)) | 0;
    mid = (mid + Math.imul(al5, bh5)) | 0;
    mid = (mid + Math.imul(ah5, bl5)) | 0;
    hi = (hi + Math.imul(ah5, bh5)) | 0;
    lo = (lo + Math.imul(al4, bl6)) | 0;
    mid = (mid + Math.imul(al4, bh6)) | 0;
    mid = (mid + Math.imul(ah4, bl6)) | 0;
    hi = (hi + Math.imul(ah4, bh6)) | 0;
    lo = (lo + Math.imul(al3, bl7)) | 0;
    mid = (mid + Math.imul(al3, bh7)) | 0;
    mid = (mid + Math.imul(ah3, bl7)) | 0;
    hi = (hi + Math.imul(ah3, bh7)) | 0;
    lo = (lo + Math.imul(al2, bl8)) | 0;
    mid = (mid + Math.imul(al2, bh8)) | 0;
    mid = (mid + Math.imul(ah2, bl8)) | 0;
    hi = (hi + Math.imul(ah2, bh8)) | 0;
    lo = (lo + Math.imul(al1, bl9)) | 0;
    mid = (mid + Math.imul(al1, bh9)) | 0;
    mid = (mid + Math.imul(ah1, bl9)) | 0;
    hi = (hi + Math.imul(ah1, bh9)) | 0;
    var w10 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w10 >>> 26)) | 0;
    w10 &= 0x3ffffff;
    /* k = 11 */
    lo = Math.imul(al9, bl2);
    mid = Math.imul(al9, bh2);
    mid = (mid + Math.imul(ah9, bl2)) | 0;
    hi = Math.imul(ah9, bh2);
    lo = (lo + Math.imul(al8, bl3)) | 0;
    mid = (mid + Math.imul(al8, bh3)) | 0;
    mid = (mid + Math.imul(ah8, bl3)) | 0;
    hi = (hi + Math.imul(ah8, bh3)) | 0;
    lo = (lo + Math.imul(al7, bl4)) | 0;
    mid = (mid + Math.imul(al7, bh4)) | 0;
    mid = (mid + Math.imul(ah7, bl4)) | 0;
    hi = (hi + Math.imul(ah7, bh4)) | 0;
    lo = (lo + Math.imul(al6, bl5)) | 0;
    mid = (mid + Math.imul(al6, bh5)) | 0;
    mid = (mid + Math.imul(ah6, bl5)) | 0;
    hi = (hi + Math.imul(ah6, bh5)) | 0;
    lo = (lo + Math.imul(al5, bl6)) | 0;
    mid = (mid + Math.imul(al5, bh6)) | 0;
    mid = (mid + Math.imul(ah5, bl6)) | 0;
    hi = (hi + Math.imul(ah5, bh6)) | 0;
    lo = (lo + Math.imul(al4, bl7)) | 0;
    mid = (mid + Math.imul(al4, bh7)) | 0;
    mid = (mid + Math.imul(ah4, bl7)) | 0;
    hi = (hi + Math.imul(ah4, bh7)) | 0;
    lo = (lo + Math.imul(al3, bl8)) | 0;
    mid = (mid + Math.imul(al3, bh8)) | 0;
    mid = (mid + Math.imul(ah3, bl8)) | 0;
    hi = (hi + Math.imul(ah3, bh8)) | 0;
    lo = (lo + Math.imul(al2, bl9)) | 0;
    mid = (mid + Math.imul(al2, bh9)) | 0;
    mid = (mid + Math.imul(ah2, bl9)) | 0;
    hi = (hi + Math.imul(ah2, bh9)) | 0;
    var w11 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w11 >>> 26)) | 0;
    w11 &= 0x3ffffff;
    /* k = 12 */
    lo = Math.imul(al9, bl3);
    mid = Math.imul(al9, bh3);
    mid = (mid + Math.imul(ah9, bl3)) | 0;
    hi = Math.imul(ah9, bh3);
    lo = (lo + Math.imul(al8, bl4)) | 0;
    mid = (mid + Math.imul(al8, bh4)) | 0;
    mid = (mid + Math.imul(ah8, bl4)) | 0;
    hi = (hi + Math.imul(ah8, bh4)) | 0;
    lo = (lo + Math.imul(al7, bl5)) | 0;
    mid = (mid + Math.imul(al7, bh5)) | 0;
    mid = (mid + Math.imul(ah7, bl5)) | 0;
    hi = (hi + Math.imul(ah7, bh5)) | 0;
    lo = (lo + Math.imul(al6, bl6)) | 0;
    mid = (mid + Math.imul(al6, bh6)) | 0;
    mid = (mid + Math.imul(ah6, bl6)) | 0;
    hi = (hi + Math.imul(ah6, bh6)) | 0;
    lo = (lo + Math.imul(al5, bl7)) | 0;
    mid = (mid + Math.imul(al5, bh7)) | 0;
    mid = (mid + Math.imul(ah5, bl7)) | 0;
    hi = (hi + Math.imul(ah5, bh7)) | 0;
    lo = (lo + Math.imul(al4, bl8)) | 0;
    mid = (mid + Math.imul(al4, bh8)) | 0;
    mid = (mid + Math.imul(ah4, bl8)) | 0;
    hi = (hi + Math.imul(ah4, bh8)) | 0;
    lo = (lo + Math.imul(al3, bl9)) | 0;
    mid = (mid + Math.imul(al3, bh9)) | 0;
    mid = (mid + Math.imul(ah3, bl9)) | 0;
    hi = (hi + Math.imul(ah3, bh9)) | 0;
    var w12 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w12 >>> 26)) | 0;
    w12 &= 0x3ffffff;
    /* k = 13 */
    lo = Math.imul(al9, bl4);
    mid = Math.imul(al9, bh4);
    mid = (mid + Math.imul(ah9, bl4)) | 0;
    hi = Math.imul(ah9, bh4);
    lo = (lo + Math.imul(al8, bl5)) | 0;
    mid = (mid + Math.imul(al8, bh5)) | 0;
    mid = (mid + Math.imul(ah8, bl5)) | 0;
    hi = (hi + Math.imul(ah8, bh5)) | 0;
    lo = (lo + Math.imul(al7, bl6)) | 0;
    mid = (mid + Math.imul(al7, bh6)) | 0;
    mid = (mid + Math.imul(ah7, bl6)) | 0;
    hi = (hi + Math.imul(ah7, bh6)) | 0;
    lo = (lo + Math.imul(al6, bl7)) | 0;
    mid = (mid + Math.imul(al6, bh7)) | 0;
    mid = (mid + Math.imul(ah6, bl7)) | 0;
    hi = (hi + Math.imul(ah6, bh7)) | 0;
    lo = (lo + Math.imul(al5, bl8)) | 0;
    mid = (mid + Math.imul(al5, bh8)) | 0;
    mid = (mid + Math.imul(ah5, bl8)) | 0;
    hi = (hi + Math.imul(ah5, bh8)) | 0;
    lo = (lo + Math.imul(al4, bl9)) | 0;
    mid = (mid + Math.imul(al4, bh9)) | 0;
    mid = (mid + Math.imul(ah4, bl9)) | 0;
    hi = (hi + Math.imul(ah4, bh9)) | 0;
    var w13 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w13 >>> 26)) | 0;
    w13 &= 0x3ffffff;
    /* k = 14 */
    lo = Math.imul(al9, bl5);
    mid = Math.imul(al9, bh5);
    mid = (mid + Math.imul(ah9, bl5)) | 0;
    hi = Math.imul(ah9, bh5);
    lo = (lo + Math.imul(al8, bl6)) | 0;
    mid = (mid + Math.imul(al8, bh6)) | 0;
    mid = (mid + Math.imul(ah8, bl6)) | 0;
    hi = (hi + Math.imul(ah8, bh6)) | 0;
    lo = (lo + Math.imul(al7, bl7)) | 0;
    mid = (mid + Math.imul(al7, bh7)) | 0;
    mid = (mid + Math.imul(ah7, bl7)) | 0;
    hi = (hi + Math.imul(ah7, bh7)) | 0;
    lo = (lo + Math.imul(al6, bl8)) | 0;
    mid = (mid + Math.imul(al6, bh8)) | 0;
    mid = (mid + Math.imul(ah6, bl8)) | 0;
    hi = (hi + Math.imul(ah6, bh8)) | 0;
    lo = (lo + Math.imul(al5, bl9)) | 0;
    mid = (mid + Math.imul(al5, bh9)) | 0;
    mid = (mid + Math.imul(ah5, bl9)) | 0;
    hi = (hi + Math.imul(ah5, bh9)) | 0;
    var w14 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w14 >>> 26)) | 0;
    w14 &= 0x3ffffff;
    /* k = 15 */
    lo = Math.imul(al9, bl6);
    mid = Math.imul(al9, bh6);
    mid = (mid + Math.imul(ah9, bl6)) | 0;
    hi = Math.imul(ah9, bh6);
    lo = (lo + Math.imul(al8, bl7)) | 0;
    mid = (mid + Math.imul(al8, bh7)) | 0;
    mid = (mid + Math.imul(ah8, bl7)) | 0;
    hi = (hi + Math.imul(ah8, bh7)) | 0;
    lo = (lo + Math.imul(al7, bl8)) | 0;
    mid = (mid + Math.imul(al7, bh8)) | 0;
    mid = (mid + Math.imul(ah7, bl8)) | 0;
    hi = (hi + Math.imul(ah7, bh8)) | 0;
    lo = (lo + Math.imul(al6, bl9)) | 0;
    mid = (mid + Math.imul(al6, bh9)) | 0;
    mid = (mid + Math.imul(ah6, bl9)) | 0;
    hi = (hi + Math.imul(ah6, bh9)) | 0;
    var w15 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w15 >>> 26)) | 0;
    w15 &= 0x3ffffff;
    /* k = 16 */
    lo = Math.imul(al9, bl7);
    mid = Math.imul(al9, bh7);
    mid = (mid + Math.imul(ah9, bl7)) | 0;
    hi = Math.imul(ah9, bh7);
    lo = (lo + Math.imul(al8, bl8)) | 0;
    mid = (mid + Math.imul(al8, bh8)) | 0;
    mid = (mid + Math.imul(ah8, bl8)) | 0;
    hi = (hi + Math.imul(ah8, bh8)) | 0;
    lo = (lo + Math.imul(al7, bl9)) | 0;
    mid = (mid + Math.imul(al7, bh9)) | 0;
    mid = (mid + Math.imul(ah7, bl9)) | 0;
    hi = (hi + Math.imul(ah7, bh9)) | 0;
    var w16 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w16 >>> 26)) | 0;
    w16 &= 0x3ffffff;
    /* k = 17 */
    lo = Math.imul(al9, bl8);
    mid = Math.imul(al9, bh8);
    mid = (mid + Math.imul(ah9, bl8)) | 0;
    hi = Math.imul(ah9, bh8);
    lo = (lo + Math.imul(al8, bl9)) | 0;
    mid = (mid + Math.imul(al8, bh9)) | 0;
    mid = (mid + Math.imul(ah8, bl9)) | 0;
    hi = (hi + Math.imul(ah8, bh9)) | 0;
    var w17 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w17 >>> 26)) | 0;
    w17 &= 0x3ffffff;
    /* k = 18 */
    lo = Math.imul(al9, bl9);
    mid = Math.imul(al9, bh9);
    mid = (mid + Math.imul(ah9, bl9)) | 0;
    hi = Math.imul(ah9, bh9);
    var w18 = (((c + lo) | 0) + ((mid & 0x1fff) << 13)) | 0;
    c = (((hi + (mid >>> 13)) | 0) + (w18 >>> 26)) | 0;
    w18 &= 0x3ffffff;
    o[0] = w0;
    o[1] = w1;
    o[2] = w2;
    o[3] = w3;
    o[4] = w4;
    o[5] = w5;
    o[6] = w6;
    o[7] = w7;
    o[8] = w8;
    o[9] = w9;
    o[10] = w10;
    o[11] = w11;
    o[12] = w12;
    o[13] = w13;
    o[14] = w14;
    o[15] = w15;
    o[16] = w16;
    o[17] = w17;
    o[18] = w18;
    if (c !== 0) {
      o[19] = c;
      out.length++;
    }
    return out;
  };

  // Polyfill comb
  if (!Math.imul) {
    comb10MulTo = smallMulTo;
  }

  function bigMulTo (self, num, out) {
    out.negative = num.negative ^ self.negative;
    out.length = self.length + num.length;

    var carry = 0;
    var hncarry = 0;
    for (var k = 0; k < out.length - 1; k++) {
      // Sum all words with the same `i + j = k` and accumulate `ncarry`,
      // note that ncarry could be >= 0x3ffffff
      var ncarry = hncarry;
      hncarry = 0;
      var rword = carry & 0x3ffffff;
      var maxJ = Math.min(k, num.length - 1);
      for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
        var i = k - j;
        var a = self.words[i] | 0;
        var b = num.words[j] | 0;
        var r = a * b;

        var lo = r & 0x3ffffff;
        ncarry = (ncarry + ((r / 0x4000000) | 0)) | 0;
        lo = (lo + rword) | 0;
        rword = lo & 0x3ffffff;
        ncarry = (ncarry + (lo >>> 26)) | 0;

        hncarry += ncarry >>> 26;
        ncarry &= 0x3ffffff;
      }
      out.words[k] = rword;
      carry = ncarry;
      ncarry = hncarry;
    }
    if (carry !== 0) {
      out.words[k] = carry;
    } else {
      out.length--;
    }

    return out.strip();
  }

  function jumboMulTo (self, num, out) {
    var fftm = new FFTM();
    return fftm.mulp(self, num, out);
  }

  BN.prototype.mulTo = function mulTo (num, out) {
    var res;
    var len = this.length + num.length;
    if (this.length === 10 && num.length === 10) {
      res = comb10MulTo(this, num, out);
    } else if (len < 63) {
      res = smallMulTo(this, num, out);
    } else if (len < 1024) {
      res = bigMulTo(this, num, out);
    } else {
      res = jumboMulTo(this, num, out);
    }

    return res;
  };

  // Cooley-Tukey algorithm for FFT
  // slightly revisited to rely on looping instead of recursion

  function FFTM (x, y) {
    this.x = x;
    this.y = y;
  }

  FFTM.prototype.makeRBT = function makeRBT (N) {
    var t = new Array(N);
    var l = BN.prototype._countBits(N) - 1;
    for (var i = 0; i < N; i++) {
      t[i] = this.revBin(i, l, N);
    }

    return t;
  };

  // Returns binary-reversed representation of `x`
  FFTM.prototype.revBin = function revBin (x, l, N) {
    if (x === 0 || x === N - 1) return x;

    var rb = 0;
    for (var i = 0; i < l; i++) {
      rb |= (x & 1) << (l - i - 1);
      x >>= 1;
    }

    return rb;
  };

  // Performs "tweedling" phase, therefore 'emulating'
  // behaviour of the recursive algorithm
  FFTM.prototype.permute = function permute (rbt, rws, iws, rtws, itws, N) {
    for (var i = 0; i < N; i++) {
      rtws[i] = rws[rbt[i]];
      itws[i] = iws[rbt[i]];
    }
  };

  FFTM.prototype.transform = function transform (rws, iws, rtws, itws, N, rbt) {
    this.permute(rbt, rws, iws, rtws, itws, N);

    for (var s = 1; s < N; s <<= 1) {
      var l = s << 1;

      var rtwdf = Math.cos(2 * Math.PI / l);
      var itwdf = Math.sin(2 * Math.PI / l);

      for (var p = 0; p < N; p += l) {
        var rtwdf_ = rtwdf;
        var itwdf_ = itwdf;

        for (var j = 0; j < s; j++) {
          var re = rtws[p + j];
          var ie = itws[p + j];

          var ro = rtws[p + j + s];
          var io = itws[p + j + s];

          var rx = rtwdf_ * ro - itwdf_ * io;

          io = rtwdf_ * io + itwdf_ * ro;
          ro = rx;

          rtws[p + j] = re + ro;
          itws[p + j] = ie + io;

          rtws[p + j + s] = re - ro;
          itws[p + j + s] = ie - io;

          /* jshint maxdepth : false */
          if (j !== l) {
            rx = rtwdf * rtwdf_ - itwdf * itwdf_;

            itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;
            rtwdf_ = rx;
          }
        }
      }
    }
  };

  FFTM.prototype.guessLen13b = function guessLen13b (n, m) {
    var N = Math.max(m, n) | 1;
    var odd = N & 1;
    var i = 0;
    for (N = N / 2 | 0; N; N = N >>> 1) {
      i++;
    }

    return 1 << i + 1 + odd;
  };

  FFTM.prototype.conjugate = function conjugate (rws, iws, N) {
    if (N <= 1) return;

    for (var i = 0; i < N / 2; i++) {
      var t = rws[i];

      rws[i] = rws[N - i - 1];
      rws[N - i - 1] = t;

      t = iws[i];

      iws[i] = -iws[N - i - 1];
      iws[N - i - 1] = -t;
    }
  };

  FFTM.prototype.normalize13b = function normalize13b (ws, N) {
    var carry = 0;
    for (var i = 0; i < N / 2; i++) {
      var w = Math.round(ws[2 * i + 1] / N) * 0x2000 +
        Math.round(ws[2 * i] / N) +
        carry;

      ws[i] = w & 0x3ffffff;

      if (w < 0x4000000) {
        carry = 0;
      } else {
        carry = w / 0x4000000 | 0;
      }
    }

    return ws;
  };

  FFTM.prototype.convert13b = function convert13b (ws, len, rws, N) {
    var carry = 0;
    for (var i = 0; i < len; i++) {
      carry = carry + (ws[i] | 0);

      rws[2 * i] = carry & 0x1fff; carry = carry >>> 13;
      rws[2 * i + 1] = carry & 0x1fff; carry = carry >>> 13;
    }

    // Pad with zeroes
    for (i = 2 * len; i < N; ++i) {
      rws[i] = 0;
    }

    assert(carry === 0);
    assert((carry & ~0x1fff) === 0);
  };

  FFTM.prototype.stub = function stub (N) {
    var ph = new Array(N);
    for (var i = 0; i < N; i++) {
      ph[i] = 0;
    }

    return ph;
  };

  FFTM.prototype.mulp = function mulp (x, y, out) {
    var N = 2 * this.guessLen13b(x.length, y.length);

    var rbt = this.makeRBT(N);

    var _ = this.stub(N);

    var rws = new Array(N);
    var rwst = new Array(N);
    var iwst = new Array(N);

    var nrws = new Array(N);
    var nrwst = new Array(N);
    var niwst = new Array(N);

    var rmws = out.words;
    rmws.length = N;

    this.convert13b(x.words, x.length, rws, N);
    this.convert13b(y.words, y.length, nrws, N);

    this.transform(rws, _, rwst, iwst, N, rbt);
    this.transform(nrws, _, nrwst, niwst, N, rbt);

    for (var i = 0; i < N; i++) {
      var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];
      iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];
      rwst[i] = rx;
    }

    this.conjugate(rwst, iwst, N);
    this.transform(rwst, iwst, rmws, _, N, rbt);
    this.conjugate(rmws, _, N);
    this.normalize13b(rmws, N);

    out.negative = x.negative ^ y.negative;
    out.length = x.length + y.length;
    return out.strip();
  };

  // Multiply `this` by `num`
  BN.prototype.mul = function mul (num) {
    var out = new BN(null);
    out.words = new Array(this.length + num.length);
    return this.mulTo(num, out);
  };

  // Multiply employing FFT
  BN.prototype.mulf = function mulf (num) {
    var out = new BN(null);
    out.words = new Array(this.length + num.length);
    return jumboMulTo(this, num, out);
  };

  // In-place Multiplication
  BN.prototype.imul = function imul (num) {
    return this.clone().mulTo(num, this);
  };

  BN.prototype.imuln = function imuln (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);

    // Carry
    var carry = 0;
    for (var i = 0; i < this.length; i++) {
      var w = (this.words[i] | 0) * num;
      var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);
      carry >>= 26;
      carry += (w / 0x4000000) | 0;
      // NOTE: lo is 27bit maximum
      carry += lo >>> 26;
      this.words[i] = lo & 0x3ffffff;
    }

    if (carry !== 0) {
      this.words[i] = carry;
      this.length++;
    }

    return this;
  };

  BN.prototype.muln = function muln (num) {
    return this.clone().imuln(num);
  };

  // `this` * `this`
  BN.prototype.sqr = function sqr () {
    return this.mul(this);
  };

  // `this` * `this` in-place
  BN.prototype.isqr = function isqr () {
    return this.imul(this.clone());
  };

  // Math.pow(`this`, `num`)
  BN.prototype.pow = function pow (num) {
    var w = toBitArray(num);
    if (w.length === 0) return new BN(1);

    // Skip leading zeroes
    var res = this;
    for (var i = 0; i < w.length; i++, res = res.sqr()) {
      if (w[i] !== 0) break;
    }

    if (++i < w.length) {
      for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {
        if (w[i] === 0) continue;

        res = res.mul(q);
      }
    }

    return res;
  };

  // Shift-left in-place
  BN.prototype.iushln = function iushln (bits) {
    assert(typeof bits === 'number' && bits >= 0);
    var r = bits % 26;
    var s = (bits - r) / 26;
    var carryMask = (0x3ffffff >>> (26 - r)) << (26 - r);
    var i;

    if (r !== 0) {
      var carry = 0;

      for (i = 0; i < this.length; i++) {
        var newCarry = this.words[i] & carryMask;
        var c = ((this.words[i] | 0) - newCarry) << r;
        this.words[i] = c | carry;
        carry = newCarry >>> (26 - r);
      }

      if (carry) {
        this.words[i] = carry;
        this.length++;
      }
    }

    if (s !== 0) {
      for (i = this.length - 1; i >= 0; i--) {
        this.words[i + s] = this.words[i];
      }

      for (i = 0; i < s; i++) {
        this.words[i] = 0;
      }

      this.length += s;
    }

    return this.strip();
  };

  BN.prototype.ishln = function ishln (bits) {
    // TODO(indutny): implement me
    assert(this.negative === 0);
    return this.iushln(bits);
  };

  // Shift-right in-place
  // NOTE: `hint` is a lowest bit before trailing zeroes
  // NOTE: if `extended` is present - it will be filled with destroyed bits
  BN.prototype.iushrn = function iushrn (bits, hint, extended) {
    assert(typeof bits === 'number' && bits >= 0);
    var h;
    if (hint) {
      h = (hint - (hint % 26)) / 26;
    } else {
      h = 0;
    }

    var r = bits % 26;
    var s = Math.min((bits - r) / 26, this.length);
    var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);
    var maskedWords = extended;

    h -= s;
    h = Math.max(0, h);

    // Extended mode, copy masked part
    if (maskedWords) {
      for (var i = 0; i < s; i++) {
        maskedWords.words[i] = this.words[i];
      }
      maskedWords.length = s;
    }

    if (s === 0) {
      // No-op, we should not move anything at all
    } else if (this.length > s) {
      this.length -= s;
      for (i = 0; i < this.length; i++) {
        this.words[i] = this.words[i + s];
      }
    } else {
      this.words[0] = 0;
      this.length = 1;
    }

    var carry = 0;
    for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {
      var word = this.words[i] | 0;
      this.words[i] = (carry << (26 - r)) | (word >>> r);
      carry = word & mask;
    }

    // Push carried bits as a mask
    if (maskedWords && carry !== 0) {
      maskedWords.words[maskedWords.length++] = carry;
    }

    if (this.length === 0) {
      this.words[0] = 0;
      this.length = 1;
    }

    return this.strip();
  };

  BN.prototype.ishrn = function ishrn (bits, hint, extended) {
    // TODO(indutny): implement me
    assert(this.negative === 0);
    return this.iushrn(bits, hint, extended);
  };

  // Shift-left
  BN.prototype.shln = function shln (bits) {
    return this.clone().ishln(bits);
  };

  BN.prototype.ushln = function ushln (bits) {
    return this.clone().iushln(bits);
  };

  // Shift-right
  BN.prototype.shrn = function shrn (bits) {
    return this.clone().ishrn(bits);
  };

  BN.prototype.ushrn = function ushrn (bits) {
    return this.clone().iushrn(bits);
  };

  // Test if n bit is set
  BN.prototype.testn = function testn (bit) {
    assert(typeof bit === 'number' && bit >= 0);
    var r = bit % 26;
    var s = (bit - r) / 26;
    var q = 1 << r;

    // Fast case: bit is much higher than all existing words
    if (this.length <= s) return false;

    // Check bit and return
    var w = this.words[s];

    return !!(w & q);
  };

  // Return only lowers bits of number (in-place)
  BN.prototype.imaskn = function imaskn (bits) {
    assert(typeof bits === 'number' && bits >= 0);
    var r = bits % 26;
    var s = (bits - r) / 26;

    assert(this.negative === 0, 'imaskn works only with positive numbers');

    if (this.length <= s) {
      return this;
    }

    if (r !== 0) {
      s++;
    }
    this.length = Math.min(s, this.length);

    if (r !== 0) {
      var mask = 0x3ffffff ^ ((0x3ffffff >>> r) << r);
      this.words[this.length - 1] &= mask;
    }

    return this.strip();
  };

  // Return only lowers bits of number
  BN.prototype.maskn = function maskn (bits) {
    return this.clone().imaskn(bits);
  };

  // Add plain number `num` to `this`
  BN.prototype.iaddn = function iaddn (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);
    if (num < 0) return this.isubn(-num);

    // Possible sign change
    if (this.negative !== 0) {
      if (this.length === 1 && (this.words[0] | 0) < num) {
        this.words[0] = num - (this.words[0] | 0);
        this.negative = 0;
        return this;
      }

      this.negative = 0;
      this.isubn(num);
      this.negative = 1;
      return this;
    }

    // Add without checks
    return this._iaddn(num);
  };

  BN.prototype._iaddn = function _iaddn (num) {
    this.words[0] += num;

    // Carry
    for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {
      this.words[i] -= 0x4000000;
      if (i === this.length - 1) {
        this.words[i + 1] = 1;
      } else {
        this.words[i + 1]++;
      }
    }
    this.length = Math.max(this.length, i + 1);

    return this;
  };

  // Subtract plain number `num` from `this`
  BN.prototype.isubn = function isubn (num) {
    assert(typeof num === 'number');
    assert(num < 0x4000000);
    if (num < 0) return this.iaddn(-num);

    if (this.negative !== 0) {
      this.negative = 0;
      this.iaddn(num);
      this.negative = 1;
      return this;
    }

    this.words[0] -= num;

    if (this.length === 1 && this.words[0] < 0) {
      this.words[0] = -this.words[0];
      this.negative = 1;
    } else {
      // Carry
      for (var i = 0; i < this.length && this.words[i] < 0; i++) {
        this.words[i] += 0x4000000;
        this.words[i + 1] -= 1;
      }
    }

    return this.strip();
  };

  BN.prototype.addn = function addn (num) {
    return this.clone().iaddn(num);
  };

  BN.prototype.subn = function subn (num) {
    return this.clone().isubn(num);
  };

  BN.prototype.iabs = function iabs () {
    this.negative = 0;

    return this;
  };

  BN.prototype.abs = function abs () {
    return this.clone().iabs();
  };

  BN.prototype._ishlnsubmul = function _ishlnsubmul (num, mul, shift) {
    var len = num.length + shift;
    var i;

    this._expand(len);

    var w;
    var carry = 0;
    for (i = 0; i < num.length; i++) {
      w = (this.words[i + shift] | 0) + carry;
      var right = (num.words[i] | 0) * mul;
      w -= right & 0x3ffffff;
      carry = (w >> 26) - ((right / 0x4000000) | 0);
      this.words[i + shift] = w & 0x3ffffff;
    }
    for (; i < this.length - shift; i++) {
      w = (this.words[i + shift] | 0) + carry;
      carry = w >> 26;
      this.words[i + shift] = w & 0x3ffffff;
    }

    if (carry === 0) return this.strip();

    // Subtraction overflow
    assert(carry === -1);
    carry = 0;
    for (i = 0; i < this.length; i++) {
      w = -(this.words[i] | 0) + carry;
      carry = w >> 26;
      this.words[i] = w & 0x3ffffff;
    }
    this.negative = 1;

    return this.strip();
  };

  BN.prototype._wordDiv = function _wordDiv (num, mode) {
    var shift = this.length - num.length;

    var a = this.clone();
    var b = num;

    // Normalize
    var bhi = b.words[b.length - 1] | 0;
    var bhiBits = this._countBits(bhi);
    shift = 26 - bhiBits;
    if (shift !== 0) {
      b = b.ushln(shift);
      a.iushln(shift);
      bhi = b.words[b.length - 1] | 0;
    }

    // Initialize quotient
    var m = a.length - b.length;
    var q;

    if (mode !== 'mod') {
      q = new BN(null);
      q.length = m + 1;
      q.words = new Array(q.length);
      for (var i = 0; i < q.length; i++) {
        q.words[i] = 0;
      }
    }

    var diff = a.clone()._ishlnsubmul(b, 1, m);
    if (diff.negative === 0) {
      a = diff;
      if (q) {
        q.words[m] = 1;
      }
    }

    for (var j = m - 1; j >= 0; j--) {
      var qj = (a.words[b.length + j] | 0) * 0x4000000 +
        (a.words[b.length + j - 1] | 0);

      // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max
      // (0x7ffffff)
      qj = Math.min((qj / bhi) | 0, 0x3ffffff);

      a._ishlnsubmul(b, qj, j);
      while (a.negative !== 0) {
        qj--;
        a.negative = 0;
        a._ishlnsubmul(b, 1, j);
        if (!a.isZero()) {
          a.negative ^= 1;
        }
      }
      if (q) {
        q.words[j] = qj;
      }
    }
    if (q) {
      q.strip();
    }
    a.strip();

    // Denormalize
    if (mode !== 'div' && shift !== 0) {
      a.iushrn(shift);
    }

    return {
      div: q || null,
      mod: a
    };
  };

  // NOTE: 1) `mode` can be set to `mod` to request mod only,
  //       to `div` to request div only, or be absent to
  //       request both div & mod
  //       2) `positive` is true if unsigned mod is requested
  BN.prototype.divmod = function divmod (num, mode, positive) {
    assert(!num.isZero());

    if (this.isZero()) {
      return {
        div: new BN(0),
        mod: new BN(0)
      };
    }

    var div, mod, res;
    if (this.negative !== 0 && num.negative === 0) {
      res = this.neg().divmod(num, mode);

      if (mode !== 'mod') {
        div = res.div.neg();
      }

      if (mode !== 'div') {
        mod = res.mod.neg();
        if (positive && mod.negative !== 0) {
          mod.iadd(num);
        }
      }

      return {
        div: div,
        mod: mod
      };
    }

    if (this.negative === 0 && num.negative !== 0) {
      res = this.divmod(num.neg(), mode);

      if (mode !== 'mod') {
        div = res.div.neg();
      }

      return {
        div: div,
        mod: res.mod
      };
    }

    if ((this.negative & num.negative) !== 0) {
      res = this.neg().divmod(num.neg(), mode);

      if (mode !== 'div') {
        mod = res.mod.neg();
        if (positive && mod.negative !== 0) {
          mod.isub(num);
        }
      }

      return {
        div: res.div,
        mod: mod
      };
    }

    // Both numbers are positive at this point

    // Strip both numbers to approximate shift value
    if (num.length > this.length || this.cmp(num) < 0) {
      return {
        div: new BN(0),
        mod: this
      };
    }

    // Very short reduction
    if (num.length === 1) {
      if (mode === 'div') {
        return {
          div: this.divn(num.words[0]),
          mod: null
        };
      }

      if (mode === 'mod') {
        return {
          div: null,
          mod: new BN(this.modn(num.words[0]))
        };
      }

      return {
        div: this.divn(num.words[0]),
        mod: new BN(this.modn(num.words[0]))
      };
    }

    return this._wordDiv(num, mode);
  };

  // Find `this` / `num`
  BN.prototype.div = function div (num) {
    return this.divmod(num, 'div', false).div;
  };

  // Find `this` % `num`
  BN.prototype.mod = function mod (num) {
    return this.divmod(num, 'mod', false).mod;
  };

  BN.prototype.umod = function umod (num) {
    return this.divmod(num, 'mod', true).mod;
  };

  // Find Round(`this` / `num`)
  BN.prototype.divRound = function divRound (num) {
    var dm = this.divmod(num);

    // Fast case - exact division
    if (dm.mod.isZero()) return dm.div;

    var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;

    var half = num.ushrn(1);
    var r2 = num.andln(1);
    var cmp = mod.cmp(half);

    // Round down
    if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;

    // Round up
    return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);
  };

  BN.prototype.modn = function modn (num) {
    assert(num <= 0x3ffffff);
    var p = (1 << 26) % num;

    var acc = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      acc = (p * acc + (this.words[i] | 0)) % num;
    }

    return acc;
  };

  // In-place division by number
  BN.prototype.idivn = function idivn (num) {
    assert(num <= 0x3ffffff);

    var carry = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      var w = (this.words[i] | 0) + carry * 0x4000000;
      this.words[i] = (w / num) | 0;
      carry = w % num;
    }

    return this.strip();
  };

  BN.prototype.divn = function divn (num) {
    return this.clone().idivn(num);
  };

  BN.prototype.egcd = function egcd (p) {
    assert(p.negative === 0);
    assert(!p.isZero());

    var x = this;
    var y = p.clone();

    if (x.negative !== 0) {
      x = x.umod(p);
    } else {
      x = x.clone();
    }

    // A * x + B * y = x
    var A = new BN(1);
    var B = new BN(0);

    // C * x + D * y = y
    var C = new BN(0);
    var D = new BN(1);

    var g = 0;

    while (x.isEven() && y.isEven()) {
      x.iushrn(1);
      y.iushrn(1);
      ++g;
    }

    var yp = y.clone();
    var xp = x.clone();

    while (!x.isZero()) {
      for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1);
      if (i > 0) {
        x.iushrn(i);
        while (i-- > 0) {
          if (A.isOdd() || B.isOdd()) {
            A.iadd(yp);
            B.isub(xp);
          }

          A.iushrn(1);
          B.iushrn(1);
        }
      }

      for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);
      if (j > 0) {
        y.iushrn(j);
        while (j-- > 0) {
          if (C.isOdd() || D.isOdd()) {
            C.iadd(yp);
            D.isub(xp);
          }

          C.iushrn(1);
          D.iushrn(1);
        }
      }

      if (x.cmp(y) >= 0) {
        x.isub(y);
        A.isub(C);
        B.isub(D);
      } else {
        y.isub(x);
        C.isub(A);
        D.isub(B);
      }
    }

    return {
      a: C,
      b: D,
      gcd: y.iushln(g)
    };
  };

  // This is reduced incarnation of the binary EEA
  // above, designated to invert members of the
  // _prime_ fields F(p) at a maximal speed
  BN.prototype._invmp = function _invmp (p) {
    assert(p.negative === 0);
    assert(!p.isZero());

    var a = this;
    var b = p.clone();

    if (a.negative !== 0) {
      a = a.umod(p);
    } else {
      a = a.clone();
    }

    var x1 = new BN(1);
    var x2 = new BN(0);

    var delta = b.clone();

    while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {
      for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1);
      if (i > 0) {
        a.iushrn(i);
        while (i-- > 0) {
          if (x1.isOdd()) {
            x1.iadd(delta);
          }

          x1.iushrn(1);
        }
      }

      for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1);
      if (j > 0) {
        b.iushrn(j);
        while (j-- > 0) {
          if (x2.isOdd()) {
            x2.iadd(delta);
          }

          x2.iushrn(1);
        }
      }

      if (a.cmp(b) >= 0) {
        a.isub(b);
        x1.isub(x2);
      } else {
        b.isub(a);
        x2.isub(x1);
      }
    }

    var res;
    if (a.cmpn(1) === 0) {
      res = x1;
    } else {
      res = x2;
    }

    if (res.cmpn(0) < 0) {
      res.iadd(p);
    }

    return res;
  };

  BN.prototype.gcd = function gcd (num) {
    if (this.isZero()) return num.abs();
    if (num.isZero()) return this.abs();

    var a = this.clone();
    var b = num.clone();
    a.negative = 0;
    b.negative = 0;

    // Remove common factor of two
    for (var shift = 0; a.isEven() && b.isEven(); shift++) {
      a.iushrn(1);
      b.iushrn(1);
    }

    do {
      while (a.isEven()) {
        a.iushrn(1);
      }
      while (b.isEven()) {
        b.iushrn(1);
      }

      var r = a.cmp(b);
      if (r < 0) {
        // Swap `a` and `b` to make `a` always bigger than `b`
        var t = a;
        a = b;
        b = t;
      } else if (r === 0 || b.cmpn(1) === 0) {
        break;
      }

      a.isub(b);
    } while (true);

    return b.iushln(shift);
  };

  // Invert number in the field F(num)
  BN.prototype.invm = function invm (num) {
    return this.egcd(num).a.umod(num);
  };

  BN.prototype.isEven = function isEven () {
    return (this.words[0] & 1) === 0;
  };

  BN.prototype.isOdd = function isOdd () {
    return (this.words[0] & 1) === 1;
  };

  // And first word and num
  BN.prototype.andln = function andln (num) {
    return this.words[0] & num;
  };

  // Increment at the bit position in-line
  BN.prototype.bincn = function bincn (bit) {
    assert(typeof bit === 'number');
    var r = bit % 26;
    var s = (bit - r) / 26;
    var q = 1 << r;

    // Fast case: bit is much higher than all existing words
    if (this.length <= s) {
      this._expand(s + 1);
      this.words[s] |= q;
      return this;
    }

    // Add bit and propagate, if needed
    var carry = q;
    for (var i = s; carry !== 0 && i < this.length; i++) {
      var w = this.words[i] | 0;
      w += carry;
      carry = w >>> 26;
      w &= 0x3ffffff;
      this.words[i] = w;
    }
    if (carry !== 0) {
      this.words[i] = carry;
      this.length++;
    }
    return this;
  };

  BN.prototype.isZero = function isZero () {
    return this.length === 1 && this.words[0] === 0;
  };

  BN.prototype.cmpn = function cmpn (num) {
    var negative = num < 0;

    if (this.negative !== 0 && !negative) return -1;
    if (this.negative === 0 && negative) return 1;

    this.strip();

    var res;
    if (this.length > 1) {
      res = 1;
    } else {
      if (negative) {
        num = -num;
      }

      assert(num <= 0x3ffffff, 'Number is too big');

      var w = this.words[0] | 0;
      res = w === num ? 0 : w < num ? -1 : 1;
    }
    if (this.negative !== 0) return -res | 0;
    return res;
  };

  // Compare two numbers and return:
  // 1 - if `this` > `num`
  // 0 - if `this` == `num`
  // -1 - if `this` < `num`
  BN.prototype.cmp = function cmp (num) {
    if (this.negative !== 0 && num.negative === 0) return -1;
    if (this.negative === 0 && num.negative !== 0) return 1;

    var res = this.ucmp(num);
    if (this.negative !== 0) return -res | 0;
    return res;
  };

  // Unsigned comparison
  BN.prototype.ucmp = function ucmp (num) {
    // At this point both numbers have the same sign
    if (this.length > num.length) return 1;
    if (this.length < num.length) return -1;

    var res = 0;
    for (var i = this.length - 1; i >= 0; i--) {
      var a = this.words[i] | 0;
      var b = num.words[i] | 0;

      if (a === b) continue;
      if (a < b) {
        res = -1;
      } else if (a > b) {
        res = 1;
      }
      break;
    }
    return res;
  };

  BN.prototype.gtn = function gtn (num) {
    return this.cmpn(num) === 1;
  };

  BN.prototype.gt = function gt (num) {
    return this.cmp(num) === 1;
  };

  BN.prototype.gten = function gten (num) {
    return this.cmpn(num) >= 0;
  };

  BN.prototype.gte = function gte (num) {
    return this.cmp(num) >= 0;
  };

  BN.prototype.ltn = function ltn (num) {
    return this.cmpn(num) === -1;
  };

  BN.prototype.lt = function lt (num) {
    return this.cmp(num) === -1;
  };

  BN.prototype.lten = function lten (num) {
    return this.cmpn(num) <= 0;
  };

  BN.prototype.lte = function lte (num) {
    return this.cmp(num) <= 0;
  };

  BN.prototype.eqn = function eqn (num) {
    return this.cmpn(num) === 0;
  };

  BN.prototype.eq = function eq (num) {
    return this.cmp(num) === 0;
  };

  //
  // A reduce context, could be using montgomery or something better, depending
  // on the `m` itself.
  //
  BN.red = function red (num) {
    return new Red(num);
  };

  BN.prototype.toRed = function toRed (ctx) {
    assert(!this.red, 'Already a number in reduction context');
    assert(this.negative === 0, 'red works only with positives');
    return ctx.convertTo(this)._forceRed(ctx);
  };

  BN.prototype.fromRed = function fromRed () {
    assert(this.red, 'fromRed works only with numbers in reduction context');
    return this.red.convertFrom(this);
  };

  BN.prototype._forceRed = function _forceRed (ctx) {
    this.red = ctx;
    return this;
  };

  BN.prototype.forceRed = function forceRed (ctx) {
    assert(!this.red, 'Already a number in reduction context');
    return this._forceRed(ctx);
  };

  BN.prototype.redAdd = function redAdd (num) {
    assert(this.red, 'redAdd works only with red numbers');
    return this.red.add(this, num);
  };

  BN.prototype.redIAdd = function redIAdd (num) {
    assert(this.red, 'redIAdd works only with red numbers');
    return this.red.iadd(this, num);
  };

  BN.prototype.redSub = function redSub (num) {
    assert(this.red, 'redSub works only with red numbers');
    return this.red.sub(this, num);
  };

  BN.prototype.redISub = function redISub (num) {
    assert(this.red, 'redISub works only with red numbers');
    return this.red.isub(this, num);
  };

  BN.prototype.redShl = function redShl (num) {
    assert(this.red, 'redShl works only with red numbers');
    return this.red.shl(this, num);
  };

  BN.prototype.redMul = function redMul (num) {
    assert(this.red, 'redMul works only with red numbers');
    this.red._verify2(this, num);
    return this.red.mul(this, num);
  };

  BN.prototype.redIMul = function redIMul (num) {
    assert(this.red, 'redMul works only with red numbers');
    this.red._verify2(this, num);
    return this.red.imul(this, num);
  };

  BN.prototype.redSqr = function redSqr () {
    assert(this.red, 'redSqr works only with red numbers');
    this.red._verify1(this);
    return this.red.sqr(this);
  };

  BN.prototype.redISqr = function redISqr () {
    assert(this.red, 'redISqr works only with red numbers');
    this.red._verify1(this);
    return this.red.isqr(this);
  };

  // Square root over p
  BN.prototype.redSqrt = function redSqrt () {
    assert(this.red, 'redSqrt works only with red numbers');
    this.red._verify1(this);
    return this.red.sqrt(this);
  };

  BN.prototype.redInvm = function redInvm () {
    assert(this.red, 'redInvm works only with red numbers');
    this.red._verify1(this);
    return this.red.invm(this);
  };

  // Return negative clone of `this` % `red modulo`
  BN.prototype.redNeg = function redNeg () {
    assert(this.red, 'redNeg works only with red numbers');
    this.red._verify1(this);
    return this.red.neg(this);
  };

  BN.prototype.redPow = function redPow (num) {
    assert(this.red && !num.red, 'redPow(normalNum)');
    this.red._verify1(this);
    return this.red.pow(this, num);
  };

  // Prime numbers with efficient reduction
  var primes = {
    k256: null,
    p224: null,
    p192: null,
    p25519: null
  };

  // Pseudo-Mersenne prime
  function MPrime (name, p) {
    // P = 2 ^ N - K
    this.name = name;
    this.p = new BN(p, 16);
    this.n = this.p.bitLength();
    this.k = new BN(1).iushln(this.n).isub(this.p);

    this.tmp = this._tmp();
  }

  MPrime.prototype._tmp = function _tmp () {
    var tmp = new BN(null);
    tmp.words = new Array(Math.ceil(this.n / 13));
    return tmp;
  };

  MPrime.prototype.ireduce = function ireduce (num) {
    // Assumes that `num` is less than `P^2`
    // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)
    var r = num;
    var rlen;

    do {
      this.split(r, this.tmp);
      r = this.imulK(r);
      r = r.iadd(this.tmp);
      rlen = r.bitLength();
    } while (rlen > this.n);

    var cmp = rlen < this.n ? -1 : r.ucmp(this.p);
    if (cmp === 0) {
      r.words[0] = 0;
      r.length = 1;
    } else if (cmp > 0) {
      r.isub(this.p);
    } else {
      r.strip();
    }

    return r;
  };

  MPrime.prototype.split = function split (input, out) {
    input.iushrn(this.n, 0, out);
  };

  MPrime.prototype.imulK = function imulK (num) {
    return num.imul(this.k);
  };

  function K256 () {
    MPrime.call(
      this,
      'k256',
      'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');
  }
  inherits(K256, MPrime);

  K256.prototype.split = function split (input, output) {
    // 256 = 9 * 26 + 22
    var mask = 0x3fffff;

    var outLen = Math.min(input.length, 9);
    for (var i = 0; i < outLen; i++) {
      output.words[i] = input.words[i];
    }
    output.length = outLen;

    if (input.length <= 9) {
      input.words[0] = 0;
      input.length = 1;
      return;
    }

    // Shift by 9 limbs
    var prev = input.words[9];
    output.words[output.length++] = prev & mask;

    for (i = 10; i < input.length; i++) {
      var next = input.words[i] | 0;
      input.words[i - 10] = ((next & mask) << 4) | (prev >>> 22);
      prev = next;
    }
    prev >>>= 22;
    input.words[i - 10] = prev;
    if (prev === 0 && input.length > 10) {
      input.length -= 10;
    } else {
      input.length -= 9;
    }
  };

  K256.prototype.imulK = function imulK (num) {
    // K = 0x1000003d1 = [ 0x40, 0x3d1 ]
    num.words[num.length] = 0;
    num.words[num.length + 1] = 0;
    num.length += 2;

    // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390
    var lo = 0;
    for (var i = 0; i < num.length; i++) {
      var w = num.words[i] | 0;
      lo += w * 0x3d1;
      num.words[i] = lo & 0x3ffffff;
      lo = w * 0x40 + ((lo / 0x4000000) | 0);
    }

    // Fast length reduction
    if (num.words[num.length - 1] === 0) {
      num.length--;
      if (num.words[num.length - 1] === 0) {
        num.length--;
      }
    }
    return num;
  };

  function P224 () {
    MPrime.call(
      this,
      'p224',
      'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');
  }
  inherits(P224, MPrime);

  function P192 () {
    MPrime.call(
      this,
      'p192',
      'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');
  }
  inherits(P192, MPrime);

  function P25519 () {
    // 2 ^ 255 - 19
    MPrime.call(
      this,
      '25519',
      '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');
  }
  inherits(P25519, MPrime);

  P25519.prototype.imulK = function imulK (num) {
    // K = 0x13
    var carry = 0;
    for (var i = 0; i < num.length; i++) {
      var hi = (num.words[i] | 0) * 0x13 + carry;
      var lo = hi & 0x3ffffff;
      hi >>>= 26;

      num.words[i] = lo;
      carry = hi;
    }
    if (carry !== 0) {
      num.words[num.length++] = carry;
    }
    return num;
  };

  // Exported mostly for testing purposes, use plain name instead
  BN._prime = function prime (name) {
    // Cached version of prime
    if (primes[name]) return primes[name];

    var prime;
    if (name === 'k256') {
      prime = new K256();
    } else if (name === 'p224') {
      prime = new P224();
    } else if (name === 'p192') {
      prime = new P192();
    } else if (name === 'p25519') {
      prime = new P25519();
    } else {
      throw new Error('Unknown prime ' + name);
    }
    primes[name] = prime;

    return prime;
  };

  //
  // Base reduction engine
  //
  function Red (m) {
    if (typeof m === 'string') {
      var prime = BN._prime(m);
      this.m = prime.p;
      this.prime = prime;
    } else {
      assert(m.gtn(1), 'modulus must be greater than 1');
      this.m = m;
      this.prime = null;
    }
  }

  Red.prototype._verify1 = function _verify1 (a) {
    assert(a.negative === 0, 'red works only with positives');
    assert(a.red, 'red works only with red numbers');
  };

  Red.prototype._verify2 = function _verify2 (a, b) {
    assert((a.negative | b.negative) === 0, 'red works only with positives');
    assert(a.red && a.red === b.red,
      'red works only with red numbers');
  };

  Red.prototype.imod = function imod (a) {
    if (this.prime) return this.prime.ireduce(a)._forceRed(this);
    return a.umod(this.m)._forceRed(this);
  };

  Red.prototype.neg = function neg (a) {
    if (a.isZero()) {
      return a.clone();
    }

    return this.m.sub(a)._forceRed(this);
  };

  Red.prototype.add = function add (a, b) {
    this._verify2(a, b);

    var res = a.add(b);
    if (res.cmp(this.m) >= 0) {
      res.isub(this.m);
    }
    return res._forceRed(this);
  };

  Red.prototype.iadd = function iadd (a, b) {
    this._verify2(a, b);

    var res = a.iadd(b);
    if (res.cmp(this.m) >= 0) {
      res.isub(this.m);
    }
    return res;
  };

  Red.prototype.sub = function sub (a, b) {
    this._verify2(a, b);

    var res = a.sub(b);
    if (res.cmpn(0) < 0) {
      res.iadd(this.m);
    }
    return res._forceRed(this);
  };

  Red.prototype.isub = function isub (a, b) {
    this._verify2(a, b);

    var res = a.isub(b);
    if (res.cmpn(0) < 0) {
      res.iadd(this.m);
    }
    return res;
  };

  Red.prototype.shl = function shl (a, num) {
    this._verify1(a);
    return this.imod(a.ushln(num));
  };

  Red.prototype.imul = function imul (a, b) {
    this._verify2(a, b);
    return this.imod(a.imul(b));
  };

  Red.prototype.mul = function mul (a, b) {
    this._verify2(a, b);
    return this.imod(a.mul(b));
  };

  Red.prototype.isqr = function isqr (a) {
    return this.imul(a, a.clone());
  };

  Red.prototype.sqr = function sqr (a) {
    return this.mul(a, a);
  };

  Red.prototype.sqrt = function sqrt (a) {
    if (a.isZero()) return a.clone();

    var mod3 = this.m.andln(3);
    assert(mod3 % 2 === 1);

    // Fast case
    if (mod3 === 3) {
      var pow = this.m.add(new BN(1)).iushrn(2);
      return this.pow(a, pow);
    }

    // Tonelli-Shanks algorithm (Totally unoptimized and slow)
    //
    // Find Q and S, that Q * 2 ^ S = (P - 1)
    var q = this.m.subn(1);
    var s = 0;
    while (!q.isZero() && q.andln(1) === 0) {
      s++;
      q.iushrn(1);
    }
    assert(!q.isZero());

    var one = new BN(1).toRed(this);
    var nOne = one.redNeg();

    // Find quadratic non-residue
    // NOTE: Max is such because of generalized Riemann hypothesis.
    var lpow = this.m.subn(1).iushrn(1);
    var z = this.m.bitLength();
    z = new BN(2 * z * z).toRed(this);

    while (this.pow(z, lpow).cmp(nOne) !== 0) {
      z.redIAdd(nOne);
    }

    var c = this.pow(z, q);
    var r = this.pow(a, q.addn(1).iushrn(1));
    var t = this.pow(a, q);
    var m = s;
    while (t.cmp(one) !== 0) {
      var tmp = t;
      for (var i = 0; tmp.cmp(one) !== 0; i++) {
        tmp = tmp.redSqr();
      }
      assert(i < m);
      var b = this.pow(c, new BN(1).iushln(m - i - 1));

      r = r.redMul(b);
      c = b.redSqr();
      t = t.redMul(c);
      m = i;
    }

    return r;
  };

  Red.prototype.invm = function invm (a) {
    var inv = a._invmp(this.m);
    if (inv.negative !== 0) {
      inv.negative = 0;
      return this.imod(inv).redNeg();
    } else {
      return this.imod(inv);
    }
  };

  Red.prototype.pow = function pow (a, num) {
    if (num.isZero()) return new BN(1).toRed(this);
    if (num.cmpn(1) === 0) return a.clone();

    var windowSize = 4;
    var wnd = new Array(1 << windowSize);
    wnd[0] = new BN(1).toRed(this);
    wnd[1] = a;
    for (var i = 2; i < wnd.length; i++) {
      wnd[i] = this.mul(wnd[i - 1], a);
    }

    var res = wnd[0];
    var current = 0;
    var currentLen = 0;
    var start = num.bitLength() % 26;
    if (start === 0) {
      start = 26;
    }

    for (i = num.length - 1; i >= 0; i--) {
      var word = num.words[i];
      for (var j = start - 1; j >= 0; j--) {
        var bit = (word >> j) & 1;
        if (res !== wnd[0]) {
          res = this.sqr(res);
        }

        if (bit === 0 && current === 0) {
          currentLen = 0;
          continue;
        }

        current <<= 1;
        current |= bit;
        currentLen++;
        if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;

        res = this.mul(res, wnd[current]);
        currentLen = 0;
        current = 0;
      }
      start = 26;
    }

    return res;
  };

  Red.prototype.convertTo = function convertTo (num) {
    var r = num.umod(this.m);

    return r === num ? r.clone() : r;
  };

  Red.prototype.convertFrom = function convertFrom (num) {
    var res = num.clone();
    res.red = null;
    return res;
  };

  //
  // Montgomery method engine
  //

  BN.mont = function mont (num) {
    return new Mont(num);
  };

  function Mont (m) {
    Red.call(this, m);

    this.shift = this.m.bitLength();
    if (this.shift % 26 !== 0) {
      this.shift += 26 - (this.shift % 26);
    }

    this.r = new BN(1).iushln(this.shift);
    this.r2 = this.imod(this.r.sqr());
    this.rinv = this.r._invmp(this.m);

    this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);
    this.minv = this.minv.umod(this.r);
    this.minv = this.r.sub(this.minv);
  }
  inherits(Mont, Red);

  Mont.prototype.convertTo = function convertTo (num) {
    return this.imod(num.ushln(this.shift));
  };

  Mont.prototype.convertFrom = function convertFrom (num) {
    var r = this.imod(num.mul(this.rinv));
    r.red = null;
    return r;
  };

  Mont.prototype.imul = function imul (a, b) {
    if (a.isZero() || b.isZero()) {
      a.words[0] = 0;
      a.length = 1;
      return a;
    }

    var t = a.imul(b);
    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
    var u = t.isub(c).iushrn(this.shift);
    var res = u;

    if (u.cmp(this.m) >= 0) {
      res = u.isub(this.m);
    } else if (u.cmpn(0) < 0) {
      res = u.iadd(this.m);
    }

    return res._forceRed(this);
  };

  Mont.prototype.mul = function mul (a, b) {
    if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);

    var t = a.mul(b);
    var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
    var u = t.isub(c).iushrn(this.shift);
    var res = u;
    if (u.cmp(this.m) >= 0) {
      res = u.isub(this.m);
    } else if (u.cmpn(0) < 0) {
      res = u.iadd(this.m);
    }

    return res._forceRed(this);
  };

  Mont.prototype.invm = function invm (a) {
    // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R
    var res = this.imod(a._invmp(this.m).mul(this.r2));
    return res._forceRed(this);
  };
})(typeof module === 'undefined' || module, this);

},{"buffer":45}],44:[function(require,module,exports){
var r;

module.exports = function rand(len) {
  if (!r)
    r = new Rand(null);

  return r.generate(len);
};

function Rand(rand) {
  this.rand = rand;
}
module.exports.Rand = Rand;

Rand.prototype.generate = function generate(len) {
  return this._rand(len);
};

// Emulate crypto API using randy
Rand.prototype._rand = function _rand(n) {
  if (this.rand.getBytes)
    return this.rand.getBytes(n);

  var res = new Uint8Array(n);
  for (var i = 0; i < res.length; i++)
    res[i] = this.rand.getByte();
  return res;
};

if (typeof self === 'object') {
  if (self.crypto && self.crypto.getRandomValues) {
    // Modern browsers
    Rand.prototype._rand = function _rand(n) {
      var arr = new Uint8Array(n);
      self.crypto.getRandomValues(arr);
      return arr;
    };
  } else if (self.msCrypto && self.msCrypto.getRandomValues) {
    // IE
    Rand.prototype._rand = function _rand(n) {
      var arr = new Uint8Array(n);
      self.msCrypto.getRandomValues(arr);
      return arr;
    };

  // Safari's WebWorkers do not have `crypto`
  } else if (typeof window === 'object') {
    // Old junk
    Rand.prototype._rand = function() {
      throw new Error('Not implemented yet');
    };
  }
} else {
  // Node.js or Web worker with no crypto support
  try {
    var crypto = require('crypto');
    if (typeof crypto.randomBytes !== 'function')
      throw new Error('Not supported');

    Rand.prototype._rand = function _rand(n) {
      return crypto.randomBytes(n);
    };
  } catch (e) {
  }
}

},{"crypto":45}],45:[function(require,module,exports){

},{}],46:[function(require,module,exports){
// based on the aes implimentation in triple sec
// https://github.com/keybase/triplesec
// which is in turn based on the one from crypto-js
// https://code.google.com/p/crypto-js/

var Buffer = require('safe-buffer').Buffer

function asUInt32Array (buf) {
  if (!Buffer.isBuffer(buf)) buf = Buffer.from(buf)

  var len = (buf.length / 4) | 0
  var out = new Array(len)

  for (var i = 0; i < len; i++) {
    out[i] = buf.readUInt32BE(i * 4)
  }

  return out
}

function scrubVec (v) {
  for (var i = 0; i < v.length; v++) {
    v[i] = 0
  }
}

function cryptBlock (M, keySchedule, SUB_MIX, SBOX, nRounds) {
  var SUB_MIX0 = SUB_MIX[0]
  var SUB_MIX1 = SUB_MIX[1]
  var SUB_MIX2 = SUB_MIX[2]
  var SUB_MIX3 = SUB_MIX[3]

  var s0 = M[0] ^ keySchedule[0]
  var s1 = M[1] ^ keySchedule[1]
  var s2 = M[2] ^ keySchedule[2]
  var s3 = M[3] ^ keySchedule[3]
  var t0, t1, t2, t3
  var ksRow = 4

  for (var round = 1; round < nRounds; round++) {
    t0 = SUB_MIX0[s0 >>> 24] ^ SUB_MIX1[(s1 >>> 16) & 0xff] ^ SUB_MIX2[(s2 >>> 8) & 0xff] ^ SUB_MIX3[s3 & 0xff] ^ keySchedule[ksRow++]
    t1 = SUB_MIX0[s1 >>> 24] ^ SUB_MIX1[(s2 >>> 16) & 0xff] ^ SUB_MIX2[(s3 >>> 8) & 0xff] ^ SUB_MIX3[s0 & 0xff] ^ keySchedule[ksRow++]
    t2 = SUB_MIX0[s2 >>> 24] ^ SUB_MIX1[(s3 >>> 16) & 0xff] ^ SUB_MIX2[(s0 >>> 8) & 0xff] ^ SUB_MIX3[s1 & 0xff] ^ keySchedule[ksRow++]
    t3 = SUB_MIX0[s3 >>> 24] ^ SUB_MIX1[(s0 >>> 16) & 0xff] ^ SUB_MIX2[(s1 >>> 8) & 0xff] ^ SUB_MIX3[s2 & 0xff] ^ keySchedule[ksRow++]
    s0 = t0
    s1 = t1
    s2 = t2
    s3 = t3
  }

  t0 = ((SBOX[s0 >>> 24] << 24) | (SBOX[(s1 >>> 16) & 0xff] << 16) | (SBOX[(s2 >>> 8) & 0xff] << 8) | SBOX[s3 & 0xff]) ^ keySchedule[ksRow++]
  t1 = ((SBOX[s1 >>> 24] << 24) | (SBOX[(s2 >>> 16) & 0xff] << 16) | (SBOX[(s3 >>> 8) & 0xff] << 8) | SBOX[s0 & 0xff]) ^ keySchedule[ksRow++]
  t2 = ((SBOX[s2 >>> 24] << 24) | (SBOX[(s3 >>> 16) & 0xff] << 16) | (SBOX[(s0 >>> 8) & 0xff] << 8) | SBOX[s1 & 0xff]) ^ keySchedule[ksRow++]
  t3 = ((SBOX[s3 >>> 24] << 24) | (SBOX[(s0 >>> 16) & 0xff] << 16) | (SBOX[(s1 >>> 8) & 0xff] << 8) | SBOX[s2 & 0xff]) ^ keySchedule[ksRow++]
  t0 = t0 >>> 0
  t1 = t1 >>> 0
  t2 = t2 >>> 0
  t3 = t3 >>> 0

  return [t0, t1, t2, t3]
}

// AES constants
var RCON = [0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1b, 0x36]
var G = (function () {
  // Compute double table
  var d = new Array(256)
  for (var j = 0; j < 256; j++) {
    if (j < 128) {
      d[j] = j << 1
    } else {
      d[j] = (j << 1) ^ 0x11b
    }
  }

  var SBOX = []
  var INV_SBOX = []
  var SUB_MIX = [[], [], [], []]
  var INV_SUB_MIX = [[], [], [], []]

  // Walk GF(2^8)
  var x = 0
  var xi = 0
  for (var i = 0; i < 256; ++i) {
    // Compute sbox
    var sx = xi ^ (xi << 1) ^ (xi << 2) ^ (xi << 3) ^ (xi << 4)
    sx = (sx >>> 8) ^ (sx & 0xff) ^ 0x63
    SBOX[x] = sx
    INV_SBOX[sx] = x

    // Compute multiplication
    var x2 = d[x]
    var x4 = d[x2]
    var x8 = d[x4]

    // Compute sub bytes, mix columns tables
    var t = (d[sx] * 0x101) ^ (sx * 0x1010100)
    SUB_MIX[0][x] = (t << 24) | (t >>> 8)
    SUB_MIX[1][x] = (t << 16) | (t >>> 16)
    SUB_MIX[2][x] = (t << 8) | (t >>> 24)
    SUB_MIX[3][x] = t

    // Compute inv sub bytes, inv mix columns tables
    t = (x8 * 0x1010101) ^ (x4 * 0x10001) ^ (x2 * 0x101) ^ (x * 0x1010100)
    INV_SUB_MIX[0][sx] = (t << 24) | (t >>> 8)
    INV_SUB_MIX[1][sx] = (t << 16) | (t >>> 16)
    INV_SUB_MIX[2][sx] = (t << 8) | (t >>> 24)
    INV_SUB_MIX[3][sx] = t

    if (x === 0) {
      x = xi = 1
    } else {
      x = x2 ^ d[d[d[x8 ^ x2]]]
      xi ^= d[d[xi]]
    }
  }

  return {
    SBOX: SBOX,
    INV_SBOX: INV_SBOX,
    SUB_MIX: SUB_MIX,
    INV_SUB_MIX: INV_SUB_MIX
  }
})()

function AES (key) {
  this._key = asUInt32Array(key)
  this._reset()
}

AES.blockSize = 4 * 4
AES.keySize = 256 / 8
AES.prototype.blockSize = AES.blockSize
AES.prototype.keySize = AES.keySize
AES.prototype._reset = function () {
  var keyWords = this._key
  var keySize = keyWords.length
  var nRounds = keySize + 6
  var ksRows = (nRounds + 1) * 4

  var keySchedule = []
  for (var k = 0; k < keySize; k++) {
    keySchedule[k] = keyWords[k]
  }

  for (k = keySize; k < ksRows; k++) {
    var t = keySchedule[k - 1]

    if (k % keySize === 0) {
      t = (t << 8) | (t >>> 24)
      t =
        (G.SBOX[t >>> 24] << 24) |
        (G.SBOX[(t >>> 16) & 0xff] << 16) |
        (G.SBOX[(t >>> 8) & 0xff] << 8) |
        (G.SBOX[t & 0xff])

      t ^= RCON[(k / keySize) | 0] << 24
    } else if (keySize > 6 && k % keySize === 4) {
      t =
        (G.SBOX[t >>> 24] << 24) |
        (G.SBOX[(t >>> 16) & 0xff] << 16) |
        (G.SBOX[(t >>> 8) & 0xff] << 8) |
        (G.SBOX[t & 0xff])
    }

    keySchedule[k] = keySchedule[k - keySize] ^ t
  }

  var invKeySchedule = []
  for (var ik = 0; ik < ksRows; ik++) {
    var ksR = ksRows - ik
    var tt = keySchedule[ksR - (ik % 4 ? 0 : 4)]

    if (ik < 4 || ksR <= 4) {
      invKeySchedule[ik] = tt
    } else {
      invKeySchedule[ik] =
        G.INV_SUB_MIX[0][G.SBOX[tt >>> 24]] ^
        G.INV_SUB_MIX[1][G.SBOX[(tt >>> 16) & 0xff]] ^
        G.INV_SUB_MIX[2][G.SBOX[(tt >>> 8) & 0xff]] ^
        G.INV_SUB_MIX[3][G.SBOX[tt & 0xff]]
    }
  }

  this._nRounds = nRounds
  this._keySchedule = keySchedule
  this._invKeySchedule = invKeySchedule
}

AES.prototype.encryptBlockRaw = function (M) {
  M = asUInt32Array(M)
  return cryptBlock(M, this._keySchedule, G.SUB_MIX, G.SBOX, this._nRounds)
}

AES.prototype.encryptBlock = function (M) {
  var out = this.encryptBlockRaw(M)
  var buf = Buffer.allocUnsafe(16)
  buf.writeUInt32BE(out[0], 0)
  buf.writeUInt32BE(out[1], 4)
  buf.writeUInt32BE(out[2], 8)
  buf.writeUInt32BE(out[3], 12)
  return buf
}

AES.prototype.decryptBlock = function (M) {
  M = asUInt32Array(M)

  // swap
  var m1 = M[1]
  M[1] = M[3]
  M[3] = m1

  var out = cryptBlock(M, this._invKeySchedule, G.INV_SUB_MIX, G.INV_SBOX, this._nRounds)
  var buf = Buffer.allocUnsafe(16)
  buf.writeUInt32BE(out[0], 0)
  buf.writeUInt32BE(out[3], 4)
  buf.writeUInt32BE(out[2], 8)
  buf.writeUInt32BE(out[1], 12)
  return buf
}

AES.prototype.scrub = function () {
  scrubVec(this._keySchedule)
  scrubVec(this._invKeySchedule)
  scrubVec(this._key)
}

module.exports.AES = AES

},{"safe-buffer":170}],47:[function(require,module,exports){
var aes = require('./aes')
var Buffer = require('safe-buffer').Buffer
var Transform = require('cipher-base')
var inherits = require('inherits')
var GHASH = require('./ghash')
var xor = require('buffer-xor')
var incr32 = require('./incr32')

function xorTest (a, b) {
  var out = 0
  if (a.length !== b.length) out++

  var len = Math.min(a.length, b.length)
  for (var i = 0; i < len; ++i) {
    out += (a[i] ^ b[i])
  }

  return out
}

function calcIv (self, iv, ck) {
  if (iv.length === 12) {
    self._finID = Buffer.concat([iv, Buffer.from([0, 0, 0, 1])])
    return Buffer.concat([iv, Buffer.from([0, 0, 0, 2])])
  }
  var ghash = new GHASH(ck)
  var len = iv.length
  var toPad = len % 16
  ghash.update(iv)
  if (toPad) {
    toPad = 16 - toPad
    ghash.update(Buffer.alloc(toPad, 0))
  }
  ghash.update(Buffer.alloc(8, 0))
  var ivBits = len * 8
  var tail = Buffer.alloc(8)
  tail.writeUIntBE(ivBits, 0, 8)
  ghash.update(tail)
  self._finID = ghash.state
  var out = Buffer.from(self._finID)
  incr32(out)
  return out
}
function StreamCipher (mode, key, iv, decrypt) {
  Transform.call(this)

  var h = Buffer.alloc(4, 0)

  this._cipher = new aes.AES(key)
  var ck = this._cipher.encryptBlock(h)
  this._ghash = new GHASH(ck)
  iv = calcIv(this, iv, ck)

  this._prev = Buffer.from(iv)
  this._cache = Buffer.allocUnsafe(0)
  this._secCache = Buffer.allocUnsafe(0)
  this._decrypt = decrypt
  this._alen = 0
  this._len = 0
  this._mode = mode

  this._authTag = null
  this._called = false
}

inherits(StreamCipher, Transform)

StreamCipher.prototype._update = function (chunk) {
  if (!this._called && this._alen) {
    var rump = 16 - (this._alen % 16)
    if (rump < 16) {
      rump = Buffer.alloc(rump, 0)
      this._ghash.update(rump)
    }
  }

  this._called = true
  var out = this._mode.encrypt(this, chunk)
  if (this._decrypt) {
    this._ghash.update(chunk)
  } else {
    this._ghash.update(out)
  }
  this._len += chunk.length
  return out
}

StreamCipher.prototype._final = function () {
  if (this._decrypt && !this._authTag) throw new Error('Unsupported state or unable to authenticate data')

  var tag = xor(this._ghash.final(this._alen * 8, this._len * 8), this._cipher.encryptBlock(this._finID))
  if (this._decrypt && xorTest(tag, this._authTag)) throw new Error('Unsupported state or unable to authenticate data')

  this._authTag = tag
  this._cipher.scrub()
}

StreamCipher.prototype.getAuthTag = function getAuthTag () {
  if (this._decrypt || !Buffer.isBuffer(this._authTag)) throw new Error('Attempting to get auth tag in unsupported state')

  return this._authTag
}

StreamCipher.prototype.setAuthTag = function setAuthTag (tag) {
  if (!this._decrypt) throw new Error('Attempting to set auth tag in unsupported state')

  this._authTag = tag
}

StreamCipher.prototype.setAAD = function setAAD (buf) {
  if (this._called) throw new Error('Attempting to set AAD in unsupported state')

  this._ghash.update(buf)
  this._alen += buf.length
}

module.exports = StreamCipher

},{"./aes":46,"./ghash":51,"./incr32":52,"buffer-xor":73,"cipher-base":75,"inherits":126,"safe-buffer":170}],48:[function(require,module,exports){
var ciphers = require('./encrypter')
var deciphers = require('./decrypter')
var modes = require('./modes/list.json')

function getCiphers () {
  return Object.keys(modes)
}

exports.createCipher = exports.Cipher = ciphers.createCipher
exports.createCipheriv = exports.Cipheriv = ciphers.createCipheriv
exports.createDecipher = exports.Decipher = deciphers.createDecipher
exports.createDecipheriv = exports.Decipheriv = deciphers.createDecipheriv
exports.listCiphers = exports.getCiphers = getCiphers

},{"./decrypter":49,"./encrypter":50,"./modes/list.json":60}],49:[function(require,module,exports){
var AuthCipher = require('./authCipher')
var Buffer = require('safe-buffer').Buffer
var MODES = require('./modes')
var StreamCipher = require('./streamCipher')
var Transform = require('cipher-base')
var aes = require('./aes')
var ebtk = require('evp_bytestokey')
var inherits = require('inherits')

function Decipher (mode, key, iv) {
  Transform.call(this)

  this._cache = new Splitter()
  this._last = void 0
  this._cipher = new aes.AES(key)
  this._prev = Buffer.from(iv)
  this._mode = mode
  this._autopadding = true
}

inherits(Decipher, Transform)

Decipher.prototype._update = function (data) {
  this._cache.add(data)
  var chunk
  var thing
  var out = []
  while ((chunk = this._cache.get(this._autopadding))) {
    thing = this._mode.decrypt(this, chunk)
    out.push(thing)
  }
  return Buffer.concat(out)
}

Decipher.prototype._final = function () {
  var chunk = this._cache.flush()
  if (this._autopadding) {
    return unpad(this._mode.decrypt(this, chunk))
  } else if (chunk) {
    throw new Error('data not multiple of block length')
  }
}

Decipher.prototype.setAutoPadding = function (setTo) {
  this._autopadding = !!setTo
  return this
}

function Splitter () {
  this.cache = Buffer.allocUnsafe(0)
}

Splitter.prototype.add = function (data) {
  this.cache = Buffer.concat([this.cache, data])
}

Splitter.prototype.get = function (autoPadding) {
  var out
  if (autoPadding) {
    if (this.cache.length > 16) {
      out = this.cache.slice(0, 16)
      this.cache = this.cache.slice(16)
      return out
    }
  } else {
    if (this.cache.length >= 16) {
      out = this.cache.slice(0, 16)
      this.cache = this.cache.slice(16)
      return out
    }
  }

  return null
}

Splitter.prototype.flush = function () {
  if (this.cache.length) return this.cache
}

function unpad (last) {
  var padded = last[15]
  if (padded < 1 || padded > 16) {
    throw new Error('unable to decrypt data')
  }
  var i = -1
  while (++i < padded) {
    if (last[(i + (16 - padded))] !== padded) {
      throw new Error('unable to decrypt data')
    }
  }
  if (padded === 16) return

  return last.slice(0, 16 - padded)
}

function createDecipheriv (suite, password, iv) {
  var config = MODES[suite.toLowerCase()]
  if (!config) throw new TypeError('invalid suite type')

  if (typeof iv === 'string') iv = Buffer.from(iv)
  if (config.mode !== 'GCM' && iv.length !== config.iv) throw new TypeError('invalid iv length ' + iv.length)

  if (typeof password === 'string') password = Buffer.from(password)
  if (password.length !== config.key / 8) throw new TypeError('invalid key length ' + password.length)

  if (config.type === 'stream') {
    return new StreamCipher(config.module, password, iv, true)
  } else if (config.type === 'auth') {
    return new AuthCipher(config.module, password, iv, true)
  }

  return new Decipher(config.module, password, iv)
}

function createDecipher (suite, password) {
  var config = MODES[suite.toLowerCase()]
  if (!config) throw new TypeError('invalid suite type')

  var keys = ebtk(password, false, config.key, config.iv)
  return createDecipheriv(suite, keys.key, keys.iv)
}

exports.createDecipher = createDecipher
exports.createDecipheriv = createDecipheriv

},{"./aes":46,"./authCipher":47,"./modes":59,"./streamCipher":62,"cipher-base":75,"evp_bytestokey":110,"inherits":126,"safe-buffer":170}],50:[function(require,module,exports){
var MODES = require('./modes')
var AuthCipher = require('./authCipher')
var Buffer = require('safe-buffer').Buffer
var StreamCipher = require('./streamCipher')
var Transform = require('cipher-base')
var aes = require('./aes')
var ebtk = require('evp_bytestokey')
var inherits = require('inherits')

function Cipher (mode, key, iv) {
  Transform.call(this)

  this._cache = new Splitter()
  this._cipher = new aes.AES(key)
  this._prev = Buffer.from(iv)
  this._mode = mode
  this._autopadding = true
}

inherits(Cipher, Transform)

Cipher.prototype._update = function (data) {
  this._cache.add(data)
  var chunk
  var thing
  var out = []

  while ((chunk = this._cache.get())) {
    thing = this._mode.encrypt(this, chunk)
    out.push(thing)
  }

  return Buffer.concat(out)
}

var PADDING = Buffer.alloc(16, 0x10)

Cipher.prototype._final = function () {
  var chunk = this._cache.flush()
  if (this._autopadding) {
    chunk = this._mode.encrypt(this, chunk)
    this._cipher.scrub()
    return chunk
  }

  if (!chunk.equals(PADDING)) {
    this._cipher.scrub()
    throw new Error('data not multiple of block length')
  }
}

Cipher.prototype.setAutoPadding = function (setTo) {
  this._autopadding = !!setTo
  return this
}

function Splitter () {
  this.cache = Buffer.allocUnsafe(0)
}

Splitter.prototype.add = function (data) {
  this.cache = Buffer.concat([this.cache, data])
}

Splitter.prototype.get = function () {
  if (this.cache.length > 15) {
    var out = this.cache.slice(0, 16)
    this.cache = this.cache.slice(16)
    return out
  }
  return null
}

Splitter.prototype.flush = function () {
  var len = 16 - this.cache.length
  var padBuff = Buffer.allocUnsafe(len)

  var i = -1
  while (++i < len) {
    padBuff.writeUInt8(len, i)
  }

  return Buffer.concat([this.cache, padBuff])
}

function createCipheriv (suite, password, iv) {
  var config = MODES[suite.toLowerCase()]
  if (!config) throw new TypeError('invalid suite type')

  if (typeof password === 'string') password = Buffer.from(password)
  if (password.length !== config.key / 8) throw new TypeError('invalid key length ' + password.length)

  if (typeof iv === 'string') iv = Buffer.from(iv)
  if (config.mode !== 'GCM' && iv.length !== config.iv) throw new TypeError('invalid iv length ' + iv.length)

  if (config.type === 'stream') {
    return new StreamCipher(config.module, password, iv)
  } else if (config.type === 'auth') {
    return new AuthCipher(config.module, password, iv)
  }

  return new Cipher(config.module, password, iv)
}

function createCipher (suite, password) {
  var config = MODES[suite.toLowerCase()]
  if (!config) throw new TypeError('invalid suite type')

  var keys = ebtk(password, false, config.key, config.iv)
  return createCipheriv(suite, keys.key, keys.iv)
}

exports.createCipheriv = createCipheriv
exports.createCipher = createCipher

},{"./aes":46,"./authCipher":47,"./modes":59,"./streamCipher":62,"cipher-base":75,"evp_bytestokey":110,"inherits":126,"safe-buffer":170}],51:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer
var ZEROES = Buffer.alloc(16, 0)

function toArray (buf) {
  return [
    buf.readUInt32BE(0),
    buf.readUInt32BE(4),
    buf.readUInt32BE(8),
    buf.readUInt32BE(12)
  ]
}

function fromArray (out) {
  var buf = Buffer.allocUnsafe(16)
  buf.writeUInt32BE(out[0] >>> 0, 0)
  buf.writeUInt32BE(out[1] >>> 0, 4)
  buf.writeUInt32BE(out[2] >>> 0, 8)
  buf.writeUInt32BE(out[3] >>> 0, 12)
  return buf
}

function GHASH (key) {
  this.h = key
  this.state = Buffer.alloc(16, 0)
  this.cache = Buffer.allocUnsafe(0)
}

// from http://bitwiseshiftleft.github.io/sjcl/doc/symbols/src/core_gcm.js.html
// by Juho Vähä-Herttua
GHASH.prototype.ghash = function (block) {
  var i = -1
  while (++i < block.length) {
    this.state[i] ^= block[i]
  }
  this._multiply()
}

GHASH.prototype._multiply = function () {
  var Vi = toArray(this.h)
  var Zi = [0, 0, 0, 0]
  var j, xi, lsbVi
  var i = -1
  while (++i < 128) {
    xi = (this.state[~~(i / 8)] & (1 << (7 - (i % 8)))) !== 0
    if (xi) {
      // Z_i+1 = Z_i ^ V_i
      Zi[0] ^= Vi[0]
      Zi[1] ^= Vi[1]
      Zi[2] ^= Vi[2]
      Zi[3] ^= Vi[3]
    }

    // Store the value of LSB(V_i)
    lsbVi = (Vi[3] & 1) !== 0

    // V_i+1 = V_i >> 1
    for (j = 3; j > 0; j--) {
      Vi[j] = (Vi[j] >>> 1) | ((Vi[j - 1] & 1) << 31)
    }
    Vi[0] = Vi[0] >>> 1

    // If LSB(V_i) is 1, V_i+1 = (V_i >> 1) ^ R
    if (lsbVi) {
      Vi[0] = Vi[0] ^ (0xe1 << 24)
    }
  }
  this.state = fromArray(Zi)
}

GHASH.prototype.update = function (buf) {
  this.cache = Buffer.concat([this.cache, buf])
  var chunk
  while (this.cache.length >= 16) {
    chunk = this.cache.slice(0, 16)
    this.cache = this.cache.slice(16)
    this.ghash(chunk)
  }
}

GHASH.prototype.final = function (abl, bl) {
  if (this.cache.length) {
    this.ghash(Buffer.concat([this.cache, ZEROES], 16))
  }

  this.ghash(fromArray([0, abl, 0, bl]))
  return this.state
}

module.exports = GHASH

},{"safe-buffer":170}],52:[function(require,module,exports){
function incr32 (iv) {
  var len = iv.length
  var item
  while (len--) {
    item = iv.readUInt8(len)
    if (item === 255) {
      iv.writeUInt8(0, len)
    } else {
      item++
      iv.writeUInt8(item, len)
      break
    }
  }
}
module.exports = incr32

},{}],53:[function(require,module,exports){
var xor = require('buffer-xor')

exports.encrypt = function (self, block) {
  var data = xor(block, self._prev)

  self._prev = self._cipher.encryptBlock(data)
  return self._prev
}

exports.decrypt = function (self, block) {
  var pad = self._prev

  self._prev = block
  var out = self._cipher.decryptBlock(block)

  return xor(out, pad)
}

},{"buffer-xor":73}],54:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer
var xor = require('buffer-xor')

function encryptStart (self, data, decrypt) {
  var len = data.length
  var out = xor(data, self._cache)
  self._cache = self._cache.slice(len)
  self._prev = Buffer.concat([self._prev, decrypt ? data : out])
  return out
}

exports.encrypt = function (self, data, decrypt) {
  var out = Buffer.allocUnsafe(0)
  var len

  while (data.length) {
    if (self._cache.length === 0) {
      self._cache = self._cipher.encryptBlock(self._prev)
      self._prev = Buffer.allocUnsafe(0)
    }

    if (self._cache.length <= data.length) {
      len = self._cache.length
      out = Buffer.concat([out, encryptStart(self, data.slice(0, len), decrypt)])
      data = data.slice(len)
    } else {
      out = Buffer.concat([out, encryptStart(self, data, decrypt)])
      break
    }
  }

  return out
}

},{"buffer-xor":73,"safe-buffer":170}],55:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer

function encryptByte (self, byteParam, decrypt) {
  var pad
  var i = -1
  var len = 8
  var out = 0
  var bit, value
  while (++i < len) {
    pad = self._cipher.encryptBlock(self._prev)
    bit = (byteParam & (1 << (7 - i))) ? 0x80 : 0
    value = pad[0] ^ bit
    out += ((value & 0x80) >> (i % 8))
    self._prev = shiftIn(self._prev, decrypt ? bit : value)
  }
  return out
}

function shiftIn (buffer, value) {
  var len = buffer.length
  var i = -1
  var out = Buffer.allocUnsafe(buffer.length)
  buffer = Buffer.concat([buffer, Buffer.from([value])])

  while (++i < len) {
    out[i] = buffer[i] << 1 | buffer[i + 1] >> (7)
  }

  return out
}

exports.encrypt = function (self, chunk, decrypt) {
  var len = chunk.length
  var out = Buffer.allocUnsafe(len)
  var i = -1

  while (++i < len) {
    out[i] = encryptByte(self, chunk[i], decrypt)
  }

  return out
}

},{"safe-buffer":170}],56:[function(require,module,exports){
var Buffer = require('safe-buffer').Buffer

function encryptByte (self, byteParam, decrypt) {
  var pad = self._cipher.encryptBlock(self._prev)
  var out = pad[0] ^ byteParam

  self._prev = Buffer.concat([
    self._prev.slice(1),
    Buffer.from([decrypt ? byteParam : out])
  ])

  return out
}

exports.encrypt = function (self, chunk, decrypt) {
  var len = chunk.length
  var out = Buffer.allocUnsafe(len)
  var i = -1

  while (++i < len) {
    out[i] = encryptByte(self, chunk[i], decrypt)
  }

  return out
}

},{"safe-buffer":170}],57:[function(require,module,exports){
var xor = require('buffer-xor')
var Buffer = require('safe-buffer').Buffer
var incr32 = require('../incr32')

function getBlock (self) {
  var out = self._cipher.encryptBlockRaw(self._prev)
  incr32(self._prev)
  return out
}

var blockSize = 16
exports.encrypt = function (self, chunk) {
  var chunkNum = Math.ceil(chunk.length / blockSize)
  var start = self._cache.length
  self._cache = Buffer.concat([
    self._cache,
    Buffer.allocUnsafe(chunkNum * blockSize)
  ])
  for (var i = 0; i < chunkNum; i++) {
    var out = getBlock(self)
    var offset = start + i * blockSize
    self._cache.writeUInt32BE(out[0], offset + 0)
    self._cache.writeUInt32BE(out[1], offset + 4)
    self._cache.writeUInt32BE(out[2], offset + 8)
    self._cache.writeUInt32BE(out[3], offset + 12)
  }
  var pad = self._cache.slice(0, chunk.length)
  self._cache = self._cache.slice(chunk.length)
  return xor(chunk, pad)
}

},{"../incr32":52,"buffer-xor":73,"safe-buffer":170}],58:[function(require,module,exports){
exports.encrypt = function (self, block) {
  return self._cipher.encryptBlock(block)
}

exports.decrypt = function (self, block) {
  return self._cipher.decryptBlock(block)
}

},{}],59:[function(require,module,exports){
var modeModules = {
  ECB: require('./ecb'),
  CBC: require('./cbc'),
  CFB: require('./cfb'),
  CFB8: require('./cfb8'),
  CFB1: require('./cfb1'),
  OFB: require('./ofb'),
  CTR: require('./ctr'),
  GCM: require('./ctr')
}

var modes = require('./list.json')

for (var key in modes) {
  modes[key].module = modeModules[modes[key].mode]
}

module.exports = modes

},{"./cbc":53,"./cfb":54,"./cfb1":55,"./cfb8":56,"./ctr":57,"./ecb":58,"./list.json":60,"./ofb":61}],60:[function(require,module,exports){
module.exports={
  "aes-128-ecb": {
    "cipher": "AES",
    "key": 128,
    "iv": 0,
    "mode": "ECB",
    "type": "block"
  },
  "aes-192-ecb": {
    "cipher": "AES",
    "key": 192,
    "iv": 0,
    "mode": "ECB",
    "type": "block"
  },
  "aes-256-ecb": {
    "cipher": "AES",
    "key": 256,
    "iv": 0,
    "mode": "ECB",
    "type": "block"
  },
  "aes-128-cbc": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes-192-cbc": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes-256-cbc": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes128": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes192": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes256": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CBC",
    "type": "block"
  },
  "aes-128-cfb": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CFB",
    "type": "stream"
  },
  "aes-192-cfb": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CFB",
    "type": "stream"
  },
  "aes-256-cfb": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CFB",
    "type": "stream"
  },
  "aes-128-cfb8": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CFB8",
    "type": "stream"
  },
  "aes-192-cfb8": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CFB8",
    "type": "stream"
  },
  "aes-256-cfb8": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CFB8",
    "type": "stream"
  },
  "aes-128-cfb1": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CFB1",
    "type": "stream"
  },
  "aes-192-cfb1": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CFB1",
    "type": "stream"
  },
  "aes-256-cfb1": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CFB1",
    "type": "stream"
  },
  "aes-128-ofb": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "OFB",
    "type": "stream"
  },
  "aes-192-ofb": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "OFB",
    "type": "stream"
  },
  "aes-256-ofb": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "OFB",
    "type": "stream"
  },
  "aes-128-ctr": {
    "cipher": "AES",
    "key": 128,
    "iv": 16,
    "mode": "CTR",
    "type": "stream"
  },
  "aes-192-ctr": {
    "cipher": "AES",
    "key": 192,
    "iv": 16,
    "mode": "CTR",
    "type": "stream"
  },
  "aes-256-ctr": {
    "cipher": "AES",
    "key": 256,
    "iv": 16,
    "mode": "CTR",
    "type": "stream"
  },
  "aes-128-gcm": {
    "cipher": "AES",
    "key": 128,
    "iv": 12,
    "mode": "GCM",
    "type": "auth"
  },
  "aes-192-gcm": {
    "cipher": "AES",
    "key": 192,
    "iv": 12,
    "mode": "GCM",
    "type": "auth"
  },
  "aes-256-gcm": {
    "cipher": "AES",
    "key": 256,
    "iv": 12,
    "mode": "GCM",
    "type": "auth"
  }
}

},{}],61:[function(require,module,exports){
(function (Buffer){
var xor = require('buffer-xor')

function getBlock (self) {
  self._prev = self._cipher.encryptBlock(self._prev)
  return self._prev
}

exports.encrypt = function (self, chunk) {
  while (self._cache.length < chunk.length) {
    self._cache = Buffer.concat([self._cache, getBlock(self)])
  }

  var pad = self._cache.slice(0, chunk.length)
  self._cache = self._cache.slice(chunk.length)
  return xor(chunk, pad)
}

}).call(this,require("buffer").Buffer)
},{"buffer":74,"buffer-xor":73}],62:[function(require,module,exports){
var aes = require('./aes')
var Buffer = require('safe-buffer').Buffer
var Transform = require('cipher-base')
var inherits = require('inherits')

function StreamCipher (mode, key, iv, decrypt) {
  Transform.call(this)

  this._cipher = new aes.AES(key)
  this._prev = Buffer.from(iv)
  this._cache = Buffer.allocUnsafe(0)
  this._secCache = Buffer.allocUnsafe(0)
  this._decrypt = decrypt
  this._mode = mode
}

inherits(StreamCipher, Transform)

StreamCipher.prototype._update = function (chunk) {
  return this._mode.encrypt(this, chunk, this._decrypt)
}

StreamCipher.prototype._final = function () {
  this._cipher.scrub()
}

module.exports = StreamCipher

},{"./aes":46,"cipher-base":75,"inherits":126,"safe-buffer":170}],63:[function(require,module,exports){
var DES = require('browserify-des')
var aes = require('browserify-aes/browser')
var aesModes = require('browserify-aes/modes')
var desModes = require('browserify-des/modes')
var ebtk = require('evp_bytestokey')

function createCipher (suite, password) {
  suite = suite.toLowerCase()

  var keyLen, ivLen
  if (aesModes[suite]) {
    keyLen = aesModes[suite].key
    ivLen = aesModes[suite].iv
  } else if (desModes[suite]) {
    keyLen = desModes[suite].key * 8
    ivLen = desModes[suite].iv
  } else {
    throw new TypeError('invalid suite type')
  }

  var keys = ebtk(password, false, keyLen, ivLen)
  return createCipheriv(suite, keys.key, keys.iv)
}

function createDecipher (suite, password) {
  suite = suite.toLowerCase()

  var keyLen, ivLen
  if (aesModes[suite]) {
    keyLen = aesModes[suite].key
    ivLen = aesModes[suite].iv
  } else if (desModes[suite]) {
    keyLen = desModes[suite].key * 8
    ivLen = desModes[suite].iv
  } else {
    throw new TypeError('invalid suite type')
  }

  var keys = ebtk(password, false, keyLen, ivLen)
  return createDecipheriv(suite, keys.key, keys.iv)
}

function createCipheriv (suite, key, iv) {
  suite = suite.toLowerCase()
  if (aesModes[suite]) return aes.createCipheriv(suite, key, iv)
  if (desModes[suite]) return new DES({ key: key, iv: iv, mode: suite })

  throw new TypeError('invalid suite type')
}

function createDecipheriv (suite, key, iv) {
  suite = suite.toLowerCase()
  if (aesModes[suite]) return aes.createDecipheriv(suite, key, iv)
  if (desModes[suite]) return new DES({ key: key, iv: iv, mode: suite, decrypt: true })

  throw new TypeError('invalid suite type')
}

function getCiphers () {
  return Object.keys(desModes).concat(aes.getCiphers())
}

exports.createCipher = exports.Cipher = createCipher
exports.createCipheriv = exports.Cipheriv = createCipheriv
exports.createDecipher = exports.Decipher = createDecipher
exports.createDecipheriv = exports.Decipheriv = createDecipheriv
exports.listCiphers = exports.getCiphers = getCiphers

},{"browserify-aes/browser":48,"browserify-aes/modes":59,"browserify-des":64,"browserify-des/modes":65,"evp_bytestokey":110}],64:[function(require,module,exports){
var CipherBase = require('cipher-base')
var des = require('des.js')
var inherits = require('inherits')
var Buffer = require('safe-buffer').Buffer

var modes = {
  'des-ede3-cbc': des.CBC.instantiate(des.EDE),
  'des-ede3': des.EDE,
  'des-ede-cbc': des.CBC.instantiate(des.EDE),
  'des-ede': des.EDE,
  'des-cbc': des.CBC.instantiate(des.DES),
  'des-ecb': des.DES
}
modes.des = modes['des-cbc']
modes.des3 = modes['des-ede3-cbc']
module.exports = DES
inherits(DES, CipherBase)
function DES (opts) {
  CipherBase.call(this)
  var modeName = opts.mode.toLowerCase()
  var mode = modes[modeName]
  var type
  if (opts.decrypt) {
    type = 'decrypt'
  } else {
    type = 'encrypt'
  }
  var key = opts.key
  if (!Buffer.isBuffer(key)) {
    key = Buffer.from(key)
  }
  if (modeName === 'des-ede' || modeName === 'des-ede-cbc') {
    key = Buffer.concat([key, key.slice(0, 8)])
  }
  var iv = opts.iv
  if (!Buffer.isBuffer(iv)) {
    iv = Buffer.from(iv)
  }
  this._des = mode.create({
    key: key,
    iv: iv,
    type: type
  })
}
DES.prototype._update = function (data) {
  return Buffer.from(this._des.update(data))
}
DES.prototype._final = function () {
  return Buffer.from(this._des.final())
}

},{"cipher-base":75,"des.js":83,"inherits":126,"safe-buffer":170}],65:[function(require,module,exports){
exports['des-ecb'] = {
  key: 8,
  iv: 0
}
exports['des-cbc'] = exports.des = {
  key: 8,
  iv: 8
}
exports['des-ede3-cbc'] = exports.des3 = {
  key: 24,
  iv: 8
}
exports['des-ede3'] = {
  key: 24,
  iv: 0
}
exports['des-ede-cbc'] = {
  key: 16,
  iv: 8
}
exports['des-ede'] = {
  key: 16,
  iv: 0
}

},{}],66:[function(require,module,exports){
(function (Buffer){
var bn = require('bn.js');
var randomBytes = require('randombytes');
module.exports = crt;
function blind(priv) {
  var r = getr(priv);
  var blinder = r.toRed(bn.mont(priv.modulus))
  .redPow(new bn(priv.publicExponent)).fromRed();
  return {
    blinder: blinder,
    unblinder:r.invm(priv.modulus)
  };
}
function crt(msg, priv) {
  var blinds = blind(priv);
  var len = priv.modulus.byteLength();
  var mod = bn.mont(priv.modulus);
  var blinded = new bn(msg).mul(blinds.blinder).umod(priv.modulus);
  var c1 = blinded.toRed(bn.mont(priv.prime1));
  var c2 = blinded.toRed(bn.mont(priv.prime2));
  var qinv = priv.coefficient;
  var p = priv.prime1;
  var q = priv.prime2;
  var m1 = c1.redPow(priv.exponent1);
  var m2 = c2.redPow(priv.exponent2);
  m1 = m1.fromRed();
  m2 = m2.fromRed();
  var h = m1.isub(m2).imul(qinv).umod(p);
  h.imul(q);
  m2.iadd(h);
  return new Buffer(m2.imul(blinds.unblinder).umod(priv.modulus).toArray(false, len));
}
crt.getr = getr;
function getr(priv) {
  var len = priv.modulus.byteLength();
  var r = new bn(randomBytes(len));
  while (r.cmp(priv.modulus) >=  0 || !r.umod(priv.prime1) || !r.umod(priv.prime2)) {
    r = new bn(randomBytes(len));
  }
  return r;
}

}).call(this,require("buffer").Buffer)
},{"bn.js":43,"buffer":74,"randombytes":152}],67:[function(require,module,exports){
module.exports = require('./browser/algorithms.json')

},{"./browser/algorithms.json":68}],68:[function(require,module,exports){
module.exports={
  "sha224WithRSAEncryption": {
    "sign": "rsa",
    "hash": "sha224",
    "id": "302d300d06096086480165030402040500041c"
  },
  "RSA-SHA224": {
    "sign": "ecdsa/rsa",
    "hash": "sha224",
    "id": "302d300d06096086480165030402040500041c"
  },
  "sha256WithRSAEncryption": {
    "sign": "rsa",
    "hash": "sha256",
    "id": "3031300d060960864801650304020105000420"
  },
  "RSA-SHA256": {
    "sign": "ecdsa/rsa",
    "hash": "sha256",
    "id": "3031300d060960864801650304020105000420"
  },
  "sha384WithRSAEncryption": {
    "sign": "rsa",
    "hash": "sha384",
    "id": "3041300d060960864801650304020205000430"
  },
  "RSA-SHA384": {
    "sign": "ecdsa/rsa",
    "hash": "sha384",
    "id": "3041300d060960864801650304020205000430"
  },
  "sha512WithRSAEncryption": {
    "sign": "rsa",
    "hash": "sha512",
    "id": "3051300d060960864801650304020305000440"
  },
  "RSA-SHA512": {
    "sign": "ecdsa/rsa",
    "hash": "sha512",
    "id": "3051300d060960864801650304020305000440"
  },
  "RSA-SHA1": {
    "sign": "rsa",
    "hash": "sha1",
    "id": "3021300906052b0e03021a05000414"
  },
  "ecdsa-with-SHA1": {
    "sign": "ecdsa",
    "hash": "sha1",
    "id": ""
  },
  "sha256": {
    "sign": "ecdsa",
    "hash": "sha256",
    "id": ""
  },
  "sha224": {
    "sign": "ecdsa",
    "hash": "sha224",
    "id": ""
  },
  "sha384": {
    "sign": "ecdsa",
    "hash": "sha384",
    "id": ""
  },
  "sha512": {
    "sign": "ecdsa",
    "hash": "sha512",
    "id": ""
  },
  "DSA-SHA": {
    "sign": "dsa",
    "hash": "sha1",
    "id": ""
  },
  "DSA-SHA1": {
    "sign": "dsa",
    "hash": "sha1",
    "id": ""
  },
  "DSA": {
    "sign": "dsa",
    "hash": "sha1",
    "id": ""
  },
  "DSA-WITH-SHA224": {
    "sign": "dsa",
    "hash": "sha224",
    "id": ""
  },
  "DSA-SHA224": {
    "sign": "dsa",
    "hash": "sha224",
    "id": ""
  },
  "DSA-WITH-SHA256": {
    "sign": "dsa",
    "hash": "sha256",
    "id": ""
  },
  "DSA-SHA256": {
    "sign": "dsa",
    "hash": "sha256",
    "id": ""
  },
  "DSA-WITH-SHA384": {
    "sign": "dsa",
    "hash": "sha384",
    "id": ""
  },
  "DSA-SHA384": {
    "sign": "dsa",
    "hash": "sha384",
    "id": ""
  },
  "DSA-WITH-SHA512": {
    "sign": "dsa",
    "hash": "sha512",
    "id": ""
  },
  "DSA-SHA512": {
    "sign": "dsa",
    "hash": "sha512",
    "id": ""
  },
  "DSA-RIPEMD160": {
    "sign": "dsa",
    "hash": "rmd160",
    "id": ""
  },
  "ripemd160WithRSA": {
    "sign": "rsa",
    "hash": "rmd160",
    "id": "3021300906052b2403020105000414"
  },
  "RSA-RIPEMD160": {
    "sign": "rsa",
    "hash": "rmd160",
    "id": "3021300906052b2403020105000414"
  },
  "md5WithRSAEncryption": {
    "sign": "rsa",
    "hash": "md5",
    "id": "3020300c06082a864886f70d020505000410"
  },
  "RSA-MD5": {
    "sign": "rsa",
    "hash": "md5",
    "id": "3020300c06082a864886f70d020505000410"
  }
}

},{}],69:[function(require,module,exports){
module.exports={
  "1.3.132.0.10": "secp256k1",
  "1.3.132.0.33": "p224",
  "1.2.840.10045.3.1.1": "p192",
  "1.2.840.10045.3.1.7": "p256",
  "1.3.132.0.34": "p384",
  "1.3.132.0.35": "p521"
}

},{}],70:[function(require,module,exports){
(function (Buffer){
var createHash = require('create-hash')
var stream = require('stream')
var inherits = require('inherits')
var sign = require('./sign')
var verify = require('./verify')

var algorithms = require('./algorithms.json')
Object.keys(algorithms).forEach(function (key) {
  algorithms[key].id = new Buffer(algorithms[key].id, 'hex')
  algorithms[key.toLowerCase()] = algorithms[key]
})

function Sign (algorithm) {
  stream.Writable.call(this)

  var data = algorithms[algorithm]
  if (!data) throw new Error('Unknown message digest')

  this._hashType = data.hash
  this._hash = createHash(data.hash)
  this._tag = data.id
  this._signType = data.sign
}
inherits(Sign, stream.Writable)

Sign.prototype._write = function _write (data, _, done) {
  this._hash.update(data)
  done()
}

Sign.prototype.update = function update (data, enc) {
  if (typeof data === 'string') data = new Buffer(data, enc)

  this._hash.update(data)
  return this
}

Sign.prototype.sign = function signMethod (key, enc) {
  this.end()
  var hash = this._hash.digest()
  var sig = sign(hash, key, this._hashType, this._signType, this._tag)

  return enc ? sig.toString(enc) : sig
}

function Verify (algorithm) {
  stream.Writable.call(this)

  var data = algorithms[algorithm]
  if (!data) throw new Error('Unknown message digest')

  this._hash = createHash(data.hash)
  this._tag = data.id
  this._signType = data.sign
}
inherits(Verify, stream.Writable)

Verify.prototype._write = function _write (data, _, done) {
  this._hash.update(data)
  done()
}

Verify.prototype.update = function update (data, enc) {
  if (typeof data === 'string') data = new Buffer(data, enc)

  this._hash.update(data)
  return this
}

Verify.prototype.verify = function verifyMethod (key, sig, enc) {
  if (typeof sig === 'string') sig = new Buffer(sig, enc)

  this.end()
  var hash = this._hash.digest()
  return verify(sig, hash, key, this._signType, this._tag)
}

function createSign (algorithm) {
  return new Sign(algorithm)
}

function createVerify (algorithm) {
  return new Verify(algorithm)
}

module.exports = {
  Sign: createSign,
  Verify: createVerify,
  createSign: createSign,
  createVerify: createVerify
}

}).call(this,require("buffer").Buffer)
},{"./algorithms.json":68,"./sign":71,"./verify":72,"buffer":74,"create-hash":78,"inherits":126,"stream":179}],71:[function(require,module,exports){
(function (Buffer){
// much of this based on https://github.com/indutny/self-signed/blob/gh-pages/lib/rsa.js
var createHmac = require('create-hmac')
var crt = require('browserify-rsa')
var EC = require('elliptic').ec
var BN = require('bn.js')
var parseKeys = require('parse-asn1')
var curves = require('./curves.json')

function sign (hash, key, hashType, signType, tag) {
  var priv = parseKeys(key)
  if (priv.curve) {
    // rsa keys can be interpreted as ecdsa ones in openssl
    if (signType !== 'ecdsa' && signType !== 'ecdsa/rsa') throw new Error('wrong private key type')
    return ecSign(hash, priv)
  } else if (priv.type === 'dsa') {
    if (signType !== 'dsa') throw new Error('wrong private key type')
    return dsaSign(hash, priv, hashType)
  } else {
    if (signType !== 'rsa' && signType !== 'ecdsa/rsa') throw new Error('wrong private key type')
  }
  hash = Buffer.concat([tag, hash])
  var len = priv.modulus.byteLength()
  var pad = [ 0, 1 ]
  while (hash.length + pad.length + 1 < len) pad.push(0xff)
  pad.push(0x00)
  var i = -1
  while (++i < hash.length) pad.push(hash[i])

  var out = crt(pad, priv)
  return out
}

function ecSign (hash, priv) {
  var curveId = curves[priv.curve.join('.')]
  if (!curveId) throw new Error('unknown curve ' + priv.curve.join('.'))

  var curve = new EC(curveId)
  var key = curve.keyFromPrivate(priv.privateKey)
  var out = key.sign(hash)

  return new Buffer(out.toDER())
}

function dsaSign (hash, priv, algo) {
  var x = priv.params.priv_key
  var p = priv.params.p
  var q = priv.params.q
  var g = priv.params.g
  var r = new BN(0)
  var k
  var H = bits2int(hash, q).mod(q)
  var s = false
  var kv = getKey(x, q, hash, algo)
  while (s === false) {
    k = makeKey(q, kv, algo)
    r = makeR(g, k, p, q)
    s = k.invm(q).imul(H.add(x.mul(r))).mod(q)
    if (s.cmpn(0) === 0) {
      s = false
      r = new BN(0)
    }
  }
  return toDER(r, s)
}

function toDER (r, s) {
  r = r.toArray()
  s = s.toArray()

  // Pad values
  if (r[0] & 0x80) r = [ 0 ].concat(r)
  if (s[0] & 0x80) s = [ 0 ].concat(s)

  var total = r.length + s.length + 4
  var res = [ 0x30, total, 0x02, r.length ]
  res = res.concat(r, [ 0x02, s.length ], s)
  return new Buffer(res)
}

function getKey (x, q, hash, algo) {
  x = new Buffer(x.toArray())
  if (x.length < q.byteLength()) {
    var zeros = new Buffer(q.byteLength() - x.length)
    zeros.fill(0)
    x = Buffer.concat([ zeros, x ])
  }
  var hlen = hash.length
  var hbits = bits2octets(hash, q)
  var v = new Buffer(hlen)
  v.fill(1)
  var k = new Buffer(hlen)
  k.fill(0)
  k = createHmac(algo, k).update(v).update(new Buffer([ 0 ])).update(x).update(hbits).digest()
  v = createHmac(algo, k).update(v).digest()
  k = createHmac(algo, k).update(v).update(new Buffer([ 1 ])).update(x).update(hbits).digest()
  v = createHmac(algo, k).update(v).digest()
  return { k: k, v: v }
}

function bits2int (obits, q) {
  var bits = new BN(obits)
  var shift = (obits.length << 3) - q.bitLength()
  if (shift > 0) bits.ishrn(shift)
  return bits
}

function bits2octets (bits, q) {
  bits = bits2int(bits, q)
  bits = bits.mod(q)
  var out = new Buffer(bits.toArray())
  if (out.length < q.byteLength()) {
    var zeros = new Buffer(q.byteLength() - out.length)
    zeros.fill(0)
    out = Buffer.concat([ zeros, out ])
  }
  return out
}

function makeKey (q, kv, algo) {
  var t
  var k

  do {
    t = new Buffer(0)

    while (t.length * 8 < q.bitLength()) {
      kv.v = createHmac(algo, kv.k).update(kv.v).digest()
      t = Buffer.concat([ t, kv.v ])
    }

    k = bits2int(t, q)
    kv.k = createHmac(algo, kv.k).update(kv.v).update(new Buffer([ 0 ])).digest()
    kv.v = createHmac(algo, kv.k).update(kv.v).digest()
  } while (k.cmp(q) !== -1)

  return k
}

function makeR (g, k, p, q) {
  return g.toRed(BN.mont(p)).redPow(k).fromRed().mod(q)
}

module.exports = sign
module.exports.getKey = getKey
module.exports.makeKey = makeKey

}).call(this,require("buffer").Buffer)
},{"./curves.json":69,"bn.js":43,"browserify-rsa":66,"buffer":74,"create-hmac":80,"elliptic":93,"parse-asn1":137}],72:[function(require,module,exports){
(function (Buffer){
// much of this based on https://github.com/indutny/self-signed/blob/gh-pages/lib/rsa.js
var BN = require('bn.js')
var EC = require('elliptic').ec
var parseKeys = require('parse-asn1')
var curves = require('./curves.json')

function verify (sig, hash, key, signType, tag) {
  var pub = parseKeys(key)
  if (pub.type === 'ec') {
    // rsa keys can be interpreted as ecdsa ones in openssl
    if (signType !== 'ecdsa' && signType !== 'ecdsa/rsa') throw new Error('wrong public key type')
    return ecVerify(sig, hash, pub)
  } else if (pub.type === 'dsa') {
    if (signType !== 'dsa') throw new Error('wrong public key type')
    return dsaVerify(sig, hash, pub)
  } else {
    if (signType !== 'rsa' && signType !== 'ecdsa/rsa') throw new Error('wrong public key type')
  }
  hash = Buffer.concat([tag, hash])
  var len = pub.modulus.byteLength()
  var pad = [ 1 ]
  var padNum = 0
  while (hash.length + pad.length + 2 < len) {
    pad.push(0xff)
    padNum++
  }
  pad.push(0x00)
  var i = -1
  while (++i < hash.length) {
    pad.push(hash[i])
  }
  pad = new Buffer(pad)
  var red = BN.mont(pub.modulus)
  sig = new BN(sig).toRed(red)

  sig = sig.redPow(new BN(pub.publicExponent))
  sig = new Buffer(sig.fromRed().toArray())
  var out = padNum < 8 ? 1 : 0
  len = Math.min(sig.length, pad.length)
  if (sig.length !== pad.length) out = 1

  i = -1
  while (++i < len) out |= sig[i] ^ pad[i]
  return out === 0
}

function ecVerify (sig, hash, pub) {
  var curveId = curves[pub.data.algorithm.curve.join('.')]
  if (!curveId) throw new Error('unknown curve ' + pub.data.algorithm.curve.join('.'))

  var curve = new EC(curveId)
  var pubkey = pub.data.subjectPrivateKey.data

  return curve.verify(hash, sig, pubkey)
}

function dsaVerify (sig, hash, pub) {
  var p = pub.data.p
  var q = pub.data.q
  var g = pub.data.g
  var y = pub.data.pub_key
  var unpacked = parseKeys.signature.decode(sig, 'der')
  var s = unpacked.s
  var r = unpacked.r
  checkValue(s, q)
  checkValue(r, q)
  var montp = BN.mont(p)
  var w = s.invm(q)
  var v = g.toRed(montp)
    .redPow(new BN(hash).mul(w).mod(q))
    .fromRed()
    .mul(y.toRed(montp).redPow(r.mul(w).mod(q)).fromRed())
    .mod(p)
    .mod(q)
  return v.cmp(r) === 0
}

function checkValue (b, q) {
  if (b.cmpn(0) <= 0) throw new Error('invalid sig')
  if (b.cmp(q) >= q) throw new Error('invalid sig')
}

module.exports = verify

}).call(this,require("buffer").Buffer)
},{"./curves.json":69,"bn.js":43,"buffer":74,"elliptic":93,"parse-asn1":137}],73:[function(require,module,exports){
(function (Buffer){
module.exports = function xor (a, b) {
  var length = Math.min(a.length, b.length)
  var buffer = new Buffer(length)

  for (var i = 0; i < length; ++i) {
    buffer[i] = a[i] ^ b[i]
  }

  return buffer
}

}).call(this,require("buffer").Buffer)
},{"buffer":74}],74:[function(require,module,exports){
(function (Buffer){
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */

'use strict'

var base64 = require('base64-js')
var ieee754 = require('ieee754')
var customInspectSymbol =
  (typeof Symbol === 'function' && typeof Symbol.for === 'function')
    ? Symbol.for('nodejs.util.inspect.custom')
    : null

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

var K_MAX_LENGTH = 0x7fffffff
exports.kMaxLength = K_MAX_LENGTH

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport()

if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
    typeof console.error === 'function') {
  console.error(
    'This browser lacks typed array (Uint8Array) support which is required by ' +
    '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
  )
}

function typedArraySupport () {
  // Can typed array instances can be augmented?
  try {
    var arr = new Uint8Array(1)
    var proto = { foo: function () { return 42 } }
    Object.setPrototypeOf(proto, Uint8Array.prototype)
    Object.setPrototypeOf(arr, proto)
    return arr.foo() === 42
  } catch (e) {
    return false
  }
}

Object.defineProperty(Buffer.prototype, 'parent', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.buffer
  }
})

Object.defineProperty(Buffer.prototype, 'offset', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.byteOffset
  }
})

function createBuffer (length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"')
  }
  // Return an augmented `Uint8Array` instance
  var buf = new Uint8Array(length)
  Object.setPrototypeOf(buf, Buffer.prototype)
  return buf
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new TypeError(
        'The "string" argument must be of type string. Received type number'
      )
    }
    return allocUnsafe(arg)
  }
  return from(arg, encodingOrOffset, length)
}

// Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
if (typeof Symbol !== 'undefined' && Symbol.species != null &&
    Buffer[Symbol.species] === Buffer) {
  Object.defineProperty(Buffer, Symbol.species, {
    value: null,
    configurable: true,
    enumerable: false,
    writable: false
  })
}

Buffer.poolSize = 8192 // not used by this implementation

function from (value, encodingOrOffset, length) {
  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset)
  }

  if (ArrayBuffer.isView(value)) {
    return fromArrayLike(value)
  }

  if (value == null) {
    throw new TypeError(
      'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
      'or Array-like Object. Received type ' + (typeof value)
    )
  }

  if (isInstance(value, ArrayBuffer) ||
      (value && isInstance(value.buffer, ArrayBuffer))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof value === 'number') {
    throw new TypeError(
      'The "value" argument must not be of type number. Received type number'
    )
  }

  var valueOf = value.valueOf && value.valueOf()
  if (valueOf != null && valueOf !== value) {
    return Buffer.from(valueOf, encodingOrOffset, length)
  }

  var b = fromObject(value)
  if (b) return b

  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
      typeof value[Symbol.toPrimitive] === 'function') {
    return Buffer.from(
      value[Symbol.toPrimitive]('string'), encodingOrOffset, length
    )
  }

  throw new TypeError(
    'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
    'or Array-like Object. Received type ' + (typeof value)
  )
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length)
}

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype)
Object.setPrototypeOf(Buffer, Uint8Array)

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be of type number')
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"')
  }
}

function alloc (size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(size).fill(fill, encoding)
      : createBuffer(size).fill(fill)
  }
  return createBuffer(size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(size, fill, encoding)
}

function allocUnsafe (size) {
  assertSize(size)
  return createBuffer(size < 0 ? 0 : checked(size) | 0)
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(size)
}

function fromString (string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('Unknown encoding: ' + encoding)
  }

  var length = byteLength(string, encoding) | 0
  var buf = createBuffer(length)

  var actual = buf.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    buf = buf.slice(0, actual)
  }

  return buf
}

function fromArrayLike (array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  var buf = createBuffer(length)
  for (var i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255
  }
  return buf
}

function fromArrayBuffer (array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds')
  }

  var buf
  if (byteOffset === undefined && length === undefined) {
    buf = new Uint8Array(array)
  } else if (length === undefined) {
    buf = new Uint8Array(array, byteOffset)
  } else {
    buf = new Uint8Array(array, byteOffset, length)
  }

  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(buf, Buffer.prototype)

  return buf
}

function fromObject (obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    var buf = createBuffer(len)

    if (buf.length === 0) {
      return buf
    }

    obj.copy(buf, 0, 0, len)
    return buf
  }

  if (obj.length !== undefined) {
    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
      return createBuffer(0)
    }
    return fromArrayLike(obj)
  }

  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data)
  }
}

function checked (length) {
  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= K_MAX_LENGTH) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return b != null && b._isBuffer === true &&
    b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
}

Buffer.compare = function compare (a, b) {
  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength)
  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength)
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError(
      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
    )
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (isInstance(buf, Uint8Array)) {
      buf = Buffer.from(buf)
    }
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    throw new TypeError(
      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
      'Received type ' + typeof string
    )
  }

  var len = string.length
  var mustMatch = (arguments.length > 2 && arguments[2] === true)
  if (!mustMatch && len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
        }
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')