# Installation
> `npm install --save @types/proxy-from-env`

# Summary
This package contains type definitions for proxy-from-env (https://github.com/Rob--W/proxy-from-env#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/proxy-from-env.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/proxy-from-env/index.d.ts)
````ts
/// <reference types="node" />

import { Url } from "url";

/**
 * Takes an input URL and returns the desired proxy URL. If no proxy is set, an
 * empty string is returned.
 * @param url The URL
 * @returns The URL of the proxy that should handle the request to the given
 *          URL.
 */
export function getProxyForUrl(url: string | Url): string;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:39 GMT
 * Dependencies: [@types/node](https://npmjs.com/package/@types/node)

# Credits
These definitions were written by [JasonHK](https://github.com/JasonHK), and [FloPes](https://github.com/flopes89).
