import { _isFormatByte } from "../../functional/_isFormatByte.mjs";

import { _isFormatDate } from "../../functional/_isFormatDate.mjs";

import { _isFormatDateTime } from "../../functional/_isFormatDateTime.mjs";

import { _isFormatDuration } from "../../functional/_isFormatDuration.mjs";

import { _isFormatEmail } from "../../functional/_isFormatEmail.mjs";

import { _isFormatHostname } from "../../functional/_isFormatHostname.mjs";

import { _isFormatIdnEmail } from "../../functional/_isFormatIdnEmail.mjs";

import { _isFormatIdnHostname } from "../../functional/_isFormatIdnHostname.mjs";

import { _isFormatIpv4 } from "../../functional/_isFormatIpv4.mjs";

import { _isFormatIpv6 } from "../../functional/_isFormatIpv6.mjs";

import { _isFormatIri } from "../../functional/_isFormatIri.mjs";

import { _isFormatIriReference } from "../../functional/_isFormatIriReference.mjs";

import { _isFormatJsonPointer } from "../../functional/_isFormatJsonPointer.mjs";

import { _isFormatRegex } from "../../functional/_isFormatRegex.mjs";

import { _isFormatRelativeJsonPointer } from "../../functional/_isFormatRelativeJsonPointer.mjs";

import { _isFormatTime } from "../../functional/_isFormatTime.mjs";

import { _isFormatUri } from "../../functional/_isFormatUri.mjs";

import { _isFormatUriReference } from "../../functional/_isFormatUriReference.mjs";

import { _isFormatUriTemplate } from "../../functional/_isFormatUriTemplate.mjs";

import { _isFormatUrl } from "../../functional/_isFormatUrl.mjs";

import { _isFormatUuid } from "../../functional/_isFormatUuid.mjs";

var OpenApiStringValidator;

(function(OpenApiStringValidator) {
    OpenApiStringValidator.validate = ctx => {
        if (typeof ctx.value !== "string") return ctx.report(ctx);
        return [ ctx.schema.minLength !== undefined ? ctx.value.length >= ctx.schema.minLength || ctx.report({
            ...ctx,
            expected: `string & MinLength<${ctx.schema.minLength}>`
        }) : true, ctx.schema.maxLength !== undefined ? ctx.value.length <= ctx.schema.maxLength || ctx.report({
            ...ctx,
            expected: `string & MaxLength<${ctx.schema.maxLength}>`
        }) : true, ctx.schema.pattern !== undefined ? new RegExp(ctx.schema.pattern).test(ctx.value) || ctx.report({
            ...ctx,
            expected: `string & Pattern<${JSON.stringify(ctx.schema.pattern)}>`
        }) : true, ctx.schema.format && FORMAT[ctx.schema.format] ? FORMAT[ctx.schema.format](ctx.value) || ctx.report({
            ...ctx,
            expected: `string & Format<${JSON.stringify(ctx.schema.format)}>`
        }) : true ].every((v => v)) || ctx.report(ctx);
    };
})(OpenApiStringValidator || (OpenApiStringValidator = {}));

const FORMAT = {
    byte: _isFormatByte,
    regex: _isFormatRegex,
    uuid: _isFormatUuid,
    email: _isFormatEmail,
    hostname: _isFormatHostname,
    "idn-email": _isFormatIdnEmail,
    "idn-hostname": _isFormatIdnHostname,
    iri: _isFormatIri,
    "iri-reference": _isFormatIriReference,
    ipv4: _isFormatIpv4,
    ipv6: _isFormatIpv6,
    uri: _isFormatUri,
    "uri-reference": _isFormatUriReference,
    "uri-template": _isFormatUriTemplate,
    url: _isFormatUrl,
    "date-time": _isFormatDateTime,
    date: _isFormatDate,
    time: _isFormatTime,
    duration: _isFormatDuration,
    "json-pointer": _isFormatJsonPointer,
    "relative-json-pointer": _isFormatRelativeJsonPointer
};

export { OpenApiStringValidator };
//# sourceMappingURL=OpenApiStringValidator.mjs.map
