import { OpenApiTypeCheckerBase } from "./internal/OpenApiTypeCheckerBase.mjs";

var LlmTypeCheckerV3;

(function(LlmTypeCheckerV3) {
    LlmTypeCheckerV3.visit = props => {
        const accessor = props.accessor ?? "$input.schema";
        props.closure(props.schema, accessor);
        if (LlmTypeCheckerV3.isOneOf(props.schema)) props.schema.oneOf.forEach(((s, i) => LlmTypeCheckerV3.visit({
            closure: props.closure,
            schema: s,
            accessor: `${accessor}.oneOf[${i}]`
        }))); else if (LlmTypeCheckerV3.isObject(props.schema)) {
            for (const [k, s] of Object.entries(props.schema.properties)) LlmTypeCheckerV3.visit({
                closure: props.closure,
                schema: s,
                accessor: `${accessor}.properties[${JSON.stringify(k)}]`
            });
            if (typeof props.schema.additionalProperties === "object" && props.schema.additionalProperties !== null) LlmTypeCheckerV3.visit({
                closure: props.closure,
                schema: props.schema.additionalProperties,
                accessor: `${accessor}.additionalProperties`
            });
        } else if (LlmTypeCheckerV3.isArray(props.schema)) LlmTypeCheckerV3.visit({
            closure: props.closure,
            schema: props.schema.items,
            accessor: `${accessor}.items`
        });
    };
    LlmTypeCheckerV3.covers = (x, y) => {
        const alpha = flatSchema(x);
        const beta = flatSchema(y);
        if (alpha.some((x => LlmTypeCheckerV3.isUnknown(x)))) return true; else if (beta.some((x => LlmTypeCheckerV3.isUnknown(x)))) return false;
        return beta.every((b => alpha.some((a => {
            if (a === b) return true; else if (LlmTypeCheckerV3.isUnknown(a)) return true; else if (LlmTypeCheckerV3.isUnknown(b)) return false; else if (LlmTypeCheckerV3.isNullOnly(a)) return LlmTypeCheckerV3.isNullOnly(b); else if (LlmTypeCheckerV3.isNullOnly(b)) return LlmTypeCheckerV3.isNullable(a); else if (LlmTypeCheckerV3.isNullable(a) && !LlmTypeCheckerV3.isNullable(b)) return false; else if (LlmTypeCheckerV3.isBoolean(a)) return LlmTypeCheckerV3.isBoolean(b) && coverBoolean(a, b); else if (LlmTypeCheckerV3.isInteger(a)) return LlmTypeCheckerV3.isInteger(b) && coverInteger(a, b); else if (LlmTypeCheckerV3.isNumber(a)) return (LlmTypeCheckerV3.isNumber(b) || LlmTypeCheckerV3.isInteger(b)) && coverNumber(a, b); else if (LlmTypeCheckerV3.isString(a)) return LlmTypeCheckerV3.isString(b) && covertString(a, b); else if (LlmTypeCheckerV3.isArray(a)) return LlmTypeCheckerV3.isArray(b) && coverArray(a, b); else if (LlmTypeCheckerV3.isObject(a)) return LlmTypeCheckerV3.isObject(b) && coverObject(a, b); else if (LlmTypeCheckerV3.isOneOf(a)) return false;
        }))));
    };
    const coverBoolean = (x, y) => x.enum === undefined || y.enum !== undefined && x.enum.every((v => y.enum.includes(v)));
    const coverInteger = (x, y) => {
        if (x.enum !== undefined) return y.enum !== undefined && x.enum.every((v => y.enum.includes(v)));
        return x.type === y.type && OpenApiTypeCheckerBase.coverNumericRange(x, y);
    };
    const coverNumber = (x, y) => {
        if (x.enum !== undefined) return y.enum !== undefined && x.enum.every((v => y.enum.includes(v)));
        return (x.type === y.type || x.type === "number" && y.type === "integer") && OpenApiTypeCheckerBase.coverNumericRange(x, y);
    };
    const covertString = (x, y) => {
        if (x.enum !== undefined) return y.enum !== undefined && x.enum.every((v => y.enum.includes(v)));
        return [ x.type === y.type, x.format === undefined || y.format !== undefined && coverFormat(x.format, y.format), x.pattern === undefined || x.pattern === y.pattern, x.minLength === undefined || y.minLength !== undefined && x.minLength <= y.minLength, x.maxLength === undefined || y.maxLength !== undefined && x.maxLength >= y.maxLength ].every((v => v));
    };
    const coverFormat = (x, y) => x === y || x === "idn-email" && y === "email" || x === "idn-hostname" && y === "hostname" || [ "uri", "iri" ].includes(x) && y === "url" || x === "iri" && y === "uri" || x === "iri-reference" && y === "uri-reference";
    const coverArray = (x, y) => LlmTypeCheckerV3.covers(x.items, y.items);
    const coverObject = (x, y) => {
        if (!x.additionalProperties && !!y.additionalProperties) return false; else if (!!x.additionalProperties && !!y.additionalProperties && typeof x.additionalProperties === "object" && y.additionalProperties === true || typeof x.additionalProperties === "object" && typeof y.additionalProperties === "object" && !LlmTypeCheckerV3.covers(x.additionalProperties, y.additionalProperties)) return false;
        return Object.entries(y.properties ?? {}).every((([key, b]) => {
            const a = x.properties?.[key];
            if (a === undefined) return false; else if ((x.required?.includes(key) ?? false) === true && (y.required?.includes(key) ?? false) === false) return false;
            return LlmTypeCheckerV3.covers(a, b);
        }));
    };
    const flatSchema = schema => LlmTypeCheckerV3.isOneOf(schema) ? schema.oneOf.flatMap(flatSchema) : [ schema ];
    LlmTypeCheckerV3.isOneOf = schema => schema.oneOf !== undefined;
    LlmTypeCheckerV3.isObject = schema => schema.type === "object";
    LlmTypeCheckerV3.isArray = schema => schema.type === "array";
    LlmTypeCheckerV3.isBoolean = schema => schema.type === "boolean";
    LlmTypeCheckerV3.isInteger = schema => schema.type === "integer";
    LlmTypeCheckerV3.isNumber = schema => schema.type === "number";
    LlmTypeCheckerV3.isString = schema => schema.type === "string";
    LlmTypeCheckerV3.isNullOnly = schema => schema.type === "null";
    LlmTypeCheckerV3.isNullable = schema => !LlmTypeCheckerV3.isUnknown(schema) && (LlmTypeCheckerV3.isNullOnly(schema) || (LlmTypeCheckerV3.isOneOf(schema) ? schema.oneOf.some(LlmTypeCheckerV3.isNullable) : schema.nullable === true));
    LlmTypeCheckerV3.isUnknown = schema => !LlmTypeCheckerV3.isOneOf(schema) && schema.type === undefined;
})(LlmTypeCheckerV3 || (LlmTypeCheckerV3 = {}));

export { LlmTypeCheckerV3 };
//# sourceMappingURL=LlmTypeCheckerV3.mjs.map
