import { ILlmFunction } from "../structures/ILlmFunction";
import { ILlmSchema } from "../structures/ILlmSchema";
/**
 * Data combiner for LLM function call.
 *
 * @author Samchon
 */
export declare namespace LlmDataMerger {
    /** Properties of {@link parameters} function. */
    interface IProps<Model extends ILlmSchema.Model> {
        /** Target function to call. */
        function: ILlmFunction<Model>;
        /** Arguments composed by LLM (Large Language Model). */
        llm: object | null;
        /** Arguments composed by human. */
        human: object | null;
    }
    /**
     * Combine LLM and human arguments into one.
     *
     * When you composes {@link IOpenAiDocument} with
     * {@link IOpenAiDocument.IOptions.separate} option, then the arguments of the
     * target function would be separated into two parts; LLM (Large Language
     * Model) and human.
     *
     * In that case, you can combine both LLM and human composed arguments into
     * one by utilizing this {@link LlmDataMerger.parameters} function, referencing
     * the target function metadata {@link IOpenAiFunction.separated}.
     *
     * @param props Properties to combine LLM and human arguments with metadata.
     * @returns Combined arguments
     */
    const parameters: <Model extends ILlmSchema.Model>(props: IProps<Model>) => object;
    /**
     * Combine two values into one.
     *
     * If both values are objects, then combines them in the properties level.
     *
     * Otherwise, returns the latter value if it's not null, otherwise the former
     * value
     *
     * - `return (y ?? x)`
     *
     * @param x Value X
     * @param y Value Y
     * @returns Combined value
     */
    const value: (x: unknown, y: unknown) => unknown;
}
