import { EndpointUtil } from "../../utils/EndpointUtil.mjs";

import { HttpMigrateRouteAccessor } from "./HttpMigrateRouteAccessor.mjs";

import { HttpMigrateRouteComposer } from "./HttpMigrateRouteComposer.mjs";

var HttpMigrateApplicationComposer;

(function(HttpMigrateApplicationComposer) {
    HttpMigrateApplicationComposer.compose = document => {
        const errors = [];
        const entire = Object.entries({
            ...document.paths ?? {},
            ...document.webhooks ?? {}
        }).map((([path, collection]) => [ "head", "get", "post", "put", "patch", "delete" ].filter((method => collection[method] !== undefined)).map((method => {
            const operation = collection[method];
            const migrated = HttpMigrateRouteComposer.compose({
                document,
                method,
                path,
                emendedPath: EndpointUtil.reJoinWithDecimalParameters(path),
                operation
            });
            if (Array.isArray(migrated)) {
                errors.push({
                    method,
                    path,
                    operation: () => operation,
                    messages: migrated
                });
                return null;
            }
            return migrated;
        })))).flat();
        const operations = entire.filter((o => !!o));
        HttpMigrateRouteAccessor.overwrite(operations);
        return {
            document: () => document,
            routes: operations,
            errors
        };
    };
})(HttpMigrateApplicationComposer || (HttpMigrateApplicationComposer = {}));

export { HttpMigrateApplicationComposer };
//# sourceMappingURL=HttpMigrateApplicationComposer.mjs.map
