"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LlmParametersFinder = void 0;
const OpenApiTypeChecker_1 = require("../../utils/OpenApiTypeChecker");
/** @internal */
var LlmParametersFinder;
(function (LlmParametersFinder) {
    LlmParametersFinder.parameters = (props) => {
        const entity = OpenApiTypeChecker_1.OpenApiTypeChecker.unreference(props);
        if (entity.success === false)
            return entity;
        else if (OpenApiTypeChecker_1.OpenApiTypeChecker.isObject(entity.value) === false)
            return reportError(Object.assign(Object.assign({}, props), { message: "LLM only accepts object type as parameters." }));
        else if (!!entity.value.additionalProperties)
            return reportError(Object.assign(Object.assign({}, props), { message: "LLM does not allow additional properties on parameters." }));
        return {
            success: true,
            value: entity.value,
        };
    };
    const reportError = (props) => {
        var _a;
        return ({
            success: false,
            error: {
                method: props.method,
                message: `failed to compose LLM schema.`,
                reasons: [
                    {
                        schema: props.schema,
                        message: props.message,
                        accessor: (_a = props.accessor) !== null && _a !== void 0 ? _a : "$input.schema",
                    },
                ],
            },
        });
    };
})(LlmParametersFinder || (exports.LlmParametersFinder = LlmParametersFinder = {}));
