import { OpenApi } from "../../OpenApi";
import { ILlamaSchema } from "../../structures/ILlamaSchema";
import { ILlmFunction } from "../../structures/ILlmFunction";
import { IOpenApiSchemaError } from "../../structures/IOpenApiSchemaError";
import { IResult } from "../../structures/IResult";
export declare namespace LlamaSchemaComposer {
    const DEFAULT_CONFIG: ILlamaSchema.IConfig;
    const parameters: (props: {
        config: ILlamaSchema.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema.IObject | OpenApi.IJsonSchema.IReference;
    }) => IResult<ILlamaSchema.IParameters, IOpenApiSchemaError>;
    const schema: (props: {
        config: ILlamaSchema.IConfig;
        components: OpenApi.IComponents;
        $defs: Record<string, ILlamaSchema>;
        schema: OpenApi.IJsonSchema;
    }) => IResult<ILlamaSchema, IOpenApiSchemaError>;
    const separateParameters: (props: {
        parameters: ILlamaSchema.IParameters;
        predicate: (schema: ILlamaSchema) => boolean;
        convention?: (key: string, type: "llm" | "human") => string;
        equals?: boolean;
    }) => ILlmFunction.ISeparated<"llama">;
    const invert: (props: {
        components: OpenApi.IComponents;
        schema: ILlamaSchema;
        $defs: Record<string, ILlamaSchema>;
    }) => OpenApi.IJsonSchema;
}
