import { OpenApi } from "../../OpenApi";
import { IDeepSeekSchema } from "../../structures/IDeepSeekSchema";
import { ILlmFunction } from "../../structures/ILlmFunction";
import { IOpenApiSchemaError } from "../../structures/IOpenApiSchemaError";
import { IResult } from "../../structures/IResult";
export declare namespace DeepSeekSchemaComposer {
    const DEFAULT_CONFIG: IDeepSeekSchema.IConfig;
    const parameters: (props: {
        config: IDeepSeekSchema.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema.IObject | OpenApi.IJsonSchema.IReference;
        accessor?: string;
        refAccessor?: string;
    }) => IResult<IDeepSeekSchema.IParameters, IOpenApiSchemaError>;
    const schema: (props: {
        config: IDeepSeekSchema.IConfig;
        components: OpenApi.IComponents;
        $defs: Record<string, IDeepSeekSchema>;
        schema: OpenApi.IJsonSchema;
        accessor?: string;
        refAccessor?: string;
    }) => IResult<IDeepSeekSchema, IOpenApiSchemaError>;
    const separateParameters: (props: {
        parameters: IDeepSeekSchema.IParameters;
        predicate: (schema: IDeepSeekSchema) => boolean;
        convention?: (key: string, type: "llm" | "human") => string;
        equals?: boolean;
    }) => ILlmFunction.ISeparated<"deepseek">;
    const invert: (props: {
        components: OpenApi.IComponents;
        schema: IDeepSeekSchema;
        $defs: Record<string, IDeepSeekSchema>;
    }) => OpenApi.IJsonSchema;
}
