import { OpenApi } from "../../OpenApi";
import { IClaudeSchema } from "../../structures/IClaudeSchema";
import { ILlmFunction } from "../../structures/ILlmFunction";
import { IOpenApiSchemaError } from "../../structures/IOpenApiSchemaError";
import { IResult } from "../../structures/IResult";
export declare namespace ClaudeSchemaComposer {
    const DEFAULT_CONFIG: IClaudeSchema.IConfig;
    const parameters: (props: {
        config: IClaudeSchema.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema.IObject | OpenApi.IJsonSchema.IReference;
        accessor?: string;
        refAccessor?: string;
    }) => IResult<IClaudeSchema.IParameters, IOpenApiSchemaError>;
    const schema: (props: {
        config: IClaudeSchema.IConfig;
        components: OpenApi.IComponents;
        $defs: Record<string, IClaudeSchema>;
        schema: OpenApi.IJsonSchema;
        accessor?: string;
        refAccessor?: string;
    }) => IResult<IClaudeSchema, IOpenApiSchemaError>;
    const separateParameters: (props: {
        parameters: IClaudeSchema.IParameters;
        predicate: (schema: IClaudeSchema) => boolean;
        convention?: (key: string, type: "llm" | "human") => string;
        equals?: boolean;
    }) => ILlmFunction.ISeparated<"claude">;
    const invert: (props: {
        components: OpenApi.IComponents;
        schema: IClaudeSchema;
        $defs: Record<string, IClaudeSchema>;
    }) => OpenApi.IJsonSchema;
}
