import { OpenApi } from "../../OpenApi";
import { IChatGptSchema } from "../../structures/IChatGptSchema";
import { ILlmFunction } from "../../structures/ILlmFunction";
import { IOpenApiSchemaError } from "../../structures/IOpenApiSchemaError";
import { IResult } from "../../structures/IResult";
export declare namespace ChatGptSchemaComposer {
    const DEFAULT_CONFIG: IChatGptSchema.IConfig;
    const parameters: (props: {
        config: IChatGptSchema.IConfig;
        components: OpenApi.IComponents;
        schema: OpenApi.IJsonSchema.IObject | OpenApi.IJsonSchema.IReference;
        accessor?: string;
        refAccessor?: string;
    }) => IResult<IChatGptSchema.IParameters, IOpenApiSchemaError>;
    const schema: (props: {
        config: IChatGptSchema.IConfig;
        components: OpenApi.IComponents;
        $defs: Record<string, IChatGptSchema>;
        schema: OpenApi.IJsonSchema;
        accessor?: string;
        refAccessor?: string;
    }) => IResult<IChatGptSchema, IOpenApiSchemaError>;
    const separateParameters: (props: {
        parameters: IChatGptSchema.IParameters;
        predicate: (schema: IChatGptSchema) => boolean;
        convention?: (key: string, type: "llm" | "human") => string;
        equals?: boolean;
    }) => ILlmFunction.ISeparated<"chatgpt">;
    const invert: (props: {
        components: OpenApi.IComponents;
        schema: IChatGptSchema;
        $defs: Record<string, IChatGptSchema>;
    }) => OpenApi.IJsonSchema;
}
