import { ChatGptTypeChecker } from "../utils/ChatGptTypeChecker.mjs";

import { ClaudeTypeChecker } from "../utils/ClaudeTypeChecker.mjs";

import { DeepSeekTypeChecker } from "../utils/DeepSeekTypeChecker.mjs";

import { GeminiTypeChecker } from "../utils/GeminiTypeChecker.mjs";

import { LlamaTypeChecker } from "../utils/LlamaTypeChecker.mjs";

import { LlmTypeCheckerV3 } from "../utils/LlmTypeCheckerV3.mjs";

import { LlmTypeCheckerV3_1 } from "../utils/LlmTypeCheckerV3_1.mjs";

import { ChatGptSchemaComposer } from "./llm/ChatGptSchemaComposer.mjs";

import { ClaudeSchemaComposer } from "./llm/ClaudeSchemaComposer.mjs";

import { DeepSeekSchemaComposer } from "./llm/DeepSeekSchemaComposer.mjs";

import { GeminiSchemaComposer } from "./llm/GeminiSchemaComposer.mjs";

import { LlamaSchemaComposer } from "./llm/LlamaSchemaComposer.mjs";

import { LlmSchemaV3Composer } from "./llm/LlmSchemaV3Composer.mjs";

import { LlmSchemaV3_1Composer } from "./llm/LlmSchemaV3_1Composer.mjs";

var LlmSchemaComposer;

(function(LlmSchemaComposer) {
    LlmSchemaComposer.parameters = model => PARAMETERS_CASTERS[model];
    LlmSchemaComposer.schema = model => SCHEMA_CASTERS[model];
    LlmSchemaComposer.defaultConfig = model => DEFAULT_CONFIGS[model];
    LlmSchemaComposer.typeChecker = model => TYPE_CHECKERS[model];
    LlmSchemaComposer.separateParameters = model => SEPARATE_PARAMETERS[model];
    LlmSchemaComposer.invert = model => INVERTS[model];
    LlmSchemaComposer.isDefs = model => IS_DEFS[model]();
})(LlmSchemaComposer || (LlmSchemaComposer = {}));

const PARAMETERS_CASTERS = {
    chatgpt: ChatGptSchemaComposer.parameters,
    claude: ClaudeSchemaComposer.parameters,
    deepseek: DeepSeekSchemaComposer.parameters,
    gemini: GeminiSchemaComposer.parameters,
    llama: LlamaSchemaComposer.parameters,
    "3.0": LlmSchemaV3Composer.parameters,
    3.1: LlmSchemaV3_1Composer.parameters
};

const SCHEMA_CASTERS = {
    chatgpt: ChatGptSchemaComposer.schema,
    claude: ClaudeSchemaComposer.schema,
    deepseek: DeepSeekSchemaComposer.schema,
    gemini: GeminiSchemaComposer.schema,
    llama: LlamaSchemaComposer.schema,
    "3.0": LlmSchemaV3Composer.schema,
    3.1: LlmSchemaV3_1Composer.schema
};

const SEPARATE_PARAMETERS = {
    chatgpt: ChatGptSchemaComposer.separateParameters,
    claude: ClaudeSchemaComposer.separateParameters,
    deepseek: DeepSeekSchemaComposer.separateParameters,
    gemini: GeminiSchemaComposer.separateParameters,
    llama: LlamaSchemaComposer.separateParameters,
    "3.0": LlmSchemaV3Composer.separateParameters,
    3.1: LlmSchemaV3_1Composer.separateParameters
};

const INVERTS = {
    chatgpt: ChatGptSchemaComposer.invert,
    claude: ClaudeSchemaComposer.invert,
    deepseek: DeepSeekSchemaComposer.invert,
    gemini: GeminiSchemaComposer.invert,
    llama: LlamaSchemaComposer.invert,
    "3.0": LlmSchemaV3Composer.invert,
    3.1: LlmSchemaV3_1Composer.invert
};

const DEFAULT_CONFIGS = {
    chatgpt: ChatGptSchemaComposer.DEFAULT_CONFIG,
    claude: ClaudeSchemaComposer.DEFAULT_CONFIG,
    deepseek: DeepSeekSchemaComposer.DEFAULT_CONFIG,
    gemini: GeminiSchemaComposer.DEFAULT_CONFIG,
    llama: LlamaSchemaComposer.DEFAULT_CONFIG,
    "3.0": LlmSchemaV3Composer.DEFAULT_CONFIG,
    3.1: LlmSchemaV3_1Composer.DEFAULT_CONFIG
};

const TYPE_CHECKERS = {
    chatgpt: ChatGptTypeChecker,
    claude: ClaudeTypeChecker,
    deepseek: DeepSeekTypeChecker,
    gemini: GeminiTypeChecker,
    llama: LlamaTypeChecker,
    "3.0": LlmTypeCheckerV3,
    3.1: LlmTypeCheckerV3_1
};

const IS_DEFS = {
    chatgpt: () => ChatGptSchemaComposer.IS_DEFS,
    claude: () => ClaudeSchemaComposer.IS_DEFS,
    deepseek: () => DeepSeekSchemaComposer.IS_DEFS,
    gemini: () => GeminiSchemaComposer.IS_DEFS,
    llama: () => LlamaSchemaComposer.IS_DEFS,
    "3.0": () => LlmSchemaV3Composer.IS_DEFS,
    3.1: () => LlmSchemaV3_1Composer.IS_DEFS
};

export { LlmSchemaComposer };
//# sourceMappingURL=LlmSchemaComposer.mjs.map
