"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LlmSchemaComposer = void 0;
const ChatGptTypeChecker_1 = require("../utils/ChatGptTypeChecker");
const ClaudeTypeChecker_1 = require("../utils/ClaudeTypeChecker");
const DeepSeekTypeChecker_1 = require("../utils/DeepSeekTypeChecker");
const GeminiTypeChecker_1 = require("../utils/GeminiTypeChecker");
const LlamaTypeChecker_1 = require("../utils/LlamaTypeChecker");
const LlmTypeCheckerV3_2 = require("../utils/LlmTypeCheckerV3");
const LlmTypeCheckerV3_1_1 = require("../utils/LlmTypeCheckerV3_1");
const ChatGptSchemaComposer_1 = require("./llm/ChatGptSchemaComposer");
const ClaudeSchemaComposer_1 = require("./llm/ClaudeSchemaComposer");
const DeepSeekSchemaComposer_1 = require("./llm/DeepSeekSchemaComposer");
const GeminiSchemaComposer_1 = require("./llm/GeminiSchemaComposer");
const LlamaSchemaComposer_1 = require("./llm/LlamaSchemaComposer");
const LlmSchemaV3Composer_1 = require("./llm/LlmSchemaV3Composer");
const LlmSchemaV3_1Composer_1 = require("./llm/LlmSchemaV3_1Composer");
var LlmSchemaComposer;
(function (LlmSchemaComposer) {
    LlmSchemaComposer.parameters = (model) => PARAMETERS_CASTERS[model];
    LlmSchemaComposer.schema = (model) => SCHEMA_CASTERS[model];
    LlmSchemaComposer.defaultConfig = (model) => DEFAULT_CONFIGS[model];
    LlmSchemaComposer.typeChecker = (model) => TYPE_CHECKERS[model];
    LlmSchemaComposer.separateParameters = (model) => SEPARATE_PARAMETERS[model];
    LlmSchemaComposer.invert = (model) => INVERTS[model];
    /** @internal */
    LlmSchemaComposer.isDefs = (model) => IS_DEFS[model]();
})(LlmSchemaComposer || (exports.LlmSchemaComposer = LlmSchemaComposer = {}));
const PARAMETERS_CASTERS = {
    chatgpt: ChatGptSchemaComposer_1.ChatGptSchemaComposer.parameters,
    claude: ClaudeSchemaComposer_1.ClaudeSchemaComposer.parameters,
    deepseek: DeepSeekSchemaComposer_1.DeepSeekSchemaComposer.parameters,
    gemini: GeminiSchemaComposer_1.GeminiSchemaComposer.parameters,
    llama: LlamaSchemaComposer_1.LlamaSchemaComposer.parameters,
    "3.0": LlmSchemaV3Composer_1.LlmSchemaV3Composer.parameters,
    "3.1": LlmSchemaV3_1Composer_1.LlmSchemaV3_1Composer.parameters,
};
const SCHEMA_CASTERS = {
    chatgpt: ChatGptSchemaComposer_1.ChatGptSchemaComposer.schema,
    claude: ClaudeSchemaComposer_1.ClaudeSchemaComposer.schema,
    deepseek: DeepSeekSchemaComposer_1.DeepSeekSchemaComposer.schema,
    gemini: GeminiSchemaComposer_1.GeminiSchemaComposer.schema,
    llama: LlamaSchemaComposer_1.LlamaSchemaComposer.schema,
    "3.0": LlmSchemaV3Composer_1.LlmSchemaV3Composer.schema,
    "3.1": LlmSchemaV3_1Composer_1.LlmSchemaV3_1Composer.schema,
};
const SEPARATE_PARAMETERS = {
    chatgpt: ChatGptSchemaComposer_1.ChatGptSchemaComposer.separateParameters,
    claude: ClaudeSchemaComposer_1.ClaudeSchemaComposer.separateParameters,
    deepseek: DeepSeekSchemaComposer_1.DeepSeekSchemaComposer.separateParameters,
    gemini: GeminiSchemaComposer_1.GeminiSchemaComposer.separateParameters,
    llama: LlamaSchemaComposer_1.LlamaSchemaComposer.separateParameters,
    "3.0": LlmSchemaV3Composer_1.LlmSchemaV3Composer.separateParameters,
    "3.1": LlmSchemaV3_1Composer_1.LlmSchemaV3_1Composer.separateParameters,
};
const INVERTS = {
    chatgpt: ChatGptSchemaComposer_1.ChatGptSchemaComposer.invert,
    claude: ClaudeSchemaComposer_1.ClaudeSchemaComposer.invert,
    deepseek: DeepSeekSchemaComposer_1.DeepSeekSchemaComposer.invert,
    gemini: GeminiSchemaComposer_1.GeminiSchemaComposer.invert,
    llama: LlamaSchemaComposer_1.LlamaSchemaComposer.invert,
    "3.0": LlmSchemaV3Composer_1.LlmSchemaV3Composer.invert,
    "3.1": LlmSchemaV3_1Composer_1.LlmSchemaV3_1Composer.invert,
};
const DEFAULT_CONFIGS = {
    chatgpt: ChatGptSchemaComposer_1.ChatGptSchemaComposer.DEFAULT_CONFIG,
    claude: ClaudeSchemaComposer_1.ClaudeSchemaComposer.DEFAULT_CONFIG,
    deepseek: DeepSeekSchemaComposer_1.DeepSeekSchemaComposer.DEFAULT_CONFIG,
    gemini: GeminiSchemaComposer_1.GeminiSchemaComposer.DEFAULT_CONFIG,
    llama: LlamaSchemaComposer_1.LlamaSchemaComposer.DEFAULT_CONFIG,
    "3.0": LlmSchemaV3Composer_1.LlmSchemaV3Composer.DEFAULT_CONFIG,
    "3.1": LlmSchemaV3_1Composer_1.LlmSchemaV3_1Composer.DEFAULT_CONFIG,
};
const TYPE_CHECKERS = {
    chatgpt: ChatGptTypeChecker_1.ChatGptTypeChecker,
    claude: ClaudeTypeChecker_1.ClaudeTypeChecker,
    deepseek: DeepSeekTypeChecker_1.DeepSeekTypeChecker,
    gemini: GeminiTypeChecker_1.GeminiTypeChecker,
    llama: LlamaTypeChecker_1.LlamaTypeChecker,
    "3.0": LlmTypeCheckerV3_2.LlmTypeCheckerV3,
    "3.1": LlmTypeCheckerV3_1_1.LlmTypeCheckerV3_1,
};
const IS_DEFS = {
    chatgpt: () => ChatGptSchemaComposer_1.ChatGptSchemaComposer.IS_DEFS,
    claude: () => ClaudeSchemaComposer_1.ClaudeSchemaComposer.IS_DEFS,
    deepseek: () => DeepSeekSchemaComposer_1.DeepSeekSchemaComposer.IS_DEFS,
    gemini: () => GeminiSchemaComposer_1.GeminiSchemaComposer.IS_DEFS,
    llama: () => LlamaSchemaComposer_1.LlamaSchemaComposer.IS_DEFS,
    "3.0": () => LlmSchemaV3Composer_1.LlmSchemaV3Composer.IS_DEFS,
    "3.1": () => LlmSchemaV3_1Composer_1.LlmSchemaV3_1Composer.IS_DEFS,
};
