import { ILlmSchema } from "../structures/ILlmSchema";
import { ChatGptTypeChecker } from "../utils/ChatGptTypeChecker";
import { GeminiTypeChecker } from "../utils/GeminiTypeChecker";
import { LlmTypeCheckerV3 } from "../utils/LlmTypeCheckerV3";
import { LlmTypeCheckerV3_1 } from "../utils/LlmTypeCheckerV3_1";
export declare namespace LlmSchemaComposer {
    const parameters: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: (props: {
            config: import("..").IChatGptSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").IChatGptSchema.IParameters, import("..").IOpenApiSchemaError>;
        claude: (props: {
            config: import("..").IClaudeSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").IClaudeSchema.IParameters, import("..").IOpenApiSchemaError>;
        deepseek: (props: {
            config: import("..").IDeepSeekSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").IDeepSeekSchema.IParameters, import("..").IOpenApiSchemaError>;
        gemini: (props: {
            config: import("..").IGeminiSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").IGeminiSchema.IParameters, import("..").IOpenApiSchemaError>;
        llama: (props: {
            config: import("..").ILlamaSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
        }) => import("..").IResult<import("..").ILlamaSchema.IParameters, import("..").IOpenApiSchemaError>;
        "3.0": (props: {
            config: import("..").ILlmSchemaV3.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            validate?: (schema: import("..").OpenApi.IJsonSchema, accessor: string) => import("..").IOpenApiSchemaError.IReason[];
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").ILlmSchemaV3.IParameters, import("..").IOpenApiSchemaError>;
        "3.1": (props: {
            config: import("..").ILlmSchemaV3_1.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema.IObject | import("..").OpenApi.IJsonSchema.IReference;
            errors?: string[];
            validate?: (input: import("..").OpenApi.IJsonSchema, accessor: string) => import("..").IOpenApiSchemaError.IReason[];
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").ILlmSchemaV3_1.IParameters, import("..").IOpenApiSchemaError>;
    }[Model];
    const schema: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: (props: {
            config: import("..").IChatGptSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, import("..").IChatGptSchema>;
            schema: import("..").OpenApi.IJsonSchema;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").IChatGptSchema, import("..").IOpenApiSchemaError>;
        claude: (props: {
            config: import("..").IClaudeSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, import("..").IClaudeSchema>;
            schema: import("..").OpenApi.IJsonSchema;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").IClaudeSchema, import("..").IOpenApiSchemaError>;
        deepseek: (props: {
            config: import("..").IDeepSeekSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, import("..").IDeepSeekSchema>;
            schema: import("..").OpenApi.IJsonSchema;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").IDeepSeekSchema, import("..").IOpenApiSchemaError>;
        gemini: (props: {
            config: import("..").IGeminiSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema;
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").IGeminiSchema, import("..").IOpenApiSchemaError>;
        llama: (props: {
            config: import("..").ILlamaSchema.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, import("..").ILlamaSchema>;
            schema: import("..").OpenApi.IJsonSchema;
        }) => import("..").IResult<import("..").ILlamaSchema, import("..").IOpenApiSchemaError>;
        "3.0": (props: {
            config: import("..").ILlmSchemaV3.IConfig;
            components: import("..").OpenApi.IComponents;
            schema: import("..").OpenApi.IJsonSchema;
            validate?: (schema: import("..").OpenApi.IJsonSchema, accessor: string) => import("..").IOpenApiSchemaError.IReason[];
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").ILlmSchemaV3, import("..").IOpenApiSchemaError>;
        "3.1": (props: {
            config: import("..").ILlmSchemaV3_1.IConfig;
            components: import("..").OpenApi.IComponents;
            $defs: Record<string, import("..").ILlmSchemaV3_1>;
            schema: import("..").OpenApi.IJsonSchema;
            validate?: (input: import("..").OpenApi.IJsonSchema, accessor: string) => import("..").IOpenApiSchemaError.IReason[];
            accessor?: string;
            refAccessor?: string;
        }) => import("..").IResult<import("..").ILlmSchemaV3_1, import("..").IOpenApiSchemaError>;
    }[Model];
    const defaultConfig: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: import("..").IChatGptSchema.IConfig;
        claude: import("..").IClaudeSchema.IConfig;
        deepseek: import("..").IDeepSeekSchema.IConfig;
        gemini: import("..").IGeminiSchema.IConfig;
        llama: import("..").ILlamaSchema.IConfig;
        "3.0": import("..").ILlmSchemaV3.IConfig;
        "3.1": import("..").ILlmSchemaV3_1.IConfig;
    }[Model];
    const typeChecker: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: typeof ChatGptTypeChecker;
        claude: typeof LlmTypeCheckerV3_1;
        deepseek: typeof LlmTypeCheckerV3_1;
        gemini: typeof GeminiTypeChecker;
        llama: typeof LlmTypeCheckerV3_1;
        "3.0": typeof LlmTypeCheckerV3;
        "3.1": typeof LlmTypeCheckerV3_1;
    }[Model];
    const separateParameters: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: (props: {
            parameters: import("..").IChatGptSchema.IParameters;
            predicate: (schema: import("..").IChatGptSchema) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
            equals?: boolean;
        }) => import("..").ILlmFunction.ISeparated<"chatgpt">;
        claude: (props: {
            parameters: import("..").IClaudeSchema.IParameters;
            predicate: (schema: import("..").IClaudeSchema) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
            equals?: boolean;
        }) => import("..").ILlmFunction.ISeparated<"claude">;
        deepseek: (props: {
            parameters: import("..").IDeepSeekSchema.IParameters;
            predicate: (schema: import("..").IDeepSeekSchema) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
            equals? /** @internal */: boolean;
        }) => import("..").ILlmFunction.ISeparated<"deepseek">;
        gemini: (props: {
            predicate: (schema: import("..").IGeminiSchema) => boolean;
            parameters: import("..").IGeminiSchema.IParameters;
            equals?: boolean;
        }) => import("..").ILlmFunction.ISeparated<"gemini">;
        llama: (props: {
            parameters: import("..").ILlamaSchema.IParameters;
            predicate: (schema: import("..").ILlamaSchema) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
            equals?: boolean;
        }) => import("..").ILlmFunction.ISeparated<"llama">;
        "3.0": (props: {
            predicate: (schema: import("..").ILlmSchemaV3) => boolean;
            parameters: import("..").ILlmSchemaV3.IParameters;
            equals?: boolean;
        }) => import("..").ILlmFunction.ISeparated<"3.0">;
        "3.1": (props: {
            parameters: import("..").ILlmSchemaV3_1.IParameters;
            predicate: (schema: import("..").ILlmSchemaV3_1) => boolean;
            convention?: (key: string, type: "llm" | "human") => string;
            equals?: boolean;
        }) => import("..").ILlmFunction.ISeparated<"3.1">;
    }[Model];
    const invert: <Model extends ILlmSchema.Model>(model: Model) => {
        chatgpt: (props: {
            components: import("..").OpenApi.IComponents;
            schema: import("..").IChatGptSchema;
            $defs: Record<string, import("..").IChatGptSchema>;
        }) => import("..").OpenApi.IJsonSchema;
        claude: (props: {
            components: import("..").OpenApi.IComponents;
            schema: import("..").IClaudeSchema;
            $defs: Record<string, import("..").IClaudeSchema>;
        }) => import("..").OpenApi.IJsonSchema;
        deepseek: (props: {
            components: import("..").OpenApi.IComponents;
            schema: import("..").IDeepSeekSchema;
            $defs: Record<string, import("..").IDeepSeekSchema>;
        }) => import("..").OpenApi.IJsonSchema;
        gemini: (props: {
            schema: import("..").IGeminiSchema;
        }) => import("..").OpenApi.IJsonSchema;
        llama: (props: {
            components: import("..").OpenApi.IComponents;
            schema: import("..").ILlamaSchema;
            $defs: Record<string, import("..").ILlamaSchema>;
        }) => import("..").OpenApi.IJsonSchema;
        "3.0": (props: {
            schema: import("..").ILlmSchemaV3;
        }) => import("..").OpenApi.IJsonSchema;
        "3.1": (props: {
            components: import("..").OpenApi.IComponents;
            schema: import("..").ILlmSchemaV3_1;
            $defs: Record<string, import("..").ILlmSchemaV3_1>;
        }) => import("..").OpenApi.IJsonSchema;
    }[Model];
}
