Package["core-runtime"].queue("null",function () {/* Imports for global scope */

Streamer = Package['rocketchat:streamer'].Streamer;
Accounts = Package['accounts-base'].Accounts;
Google = Package['google-oauth'].Google;
OAuth = Package.oauth.OAuth;
check = Package.check.check;
Match = Package.check.Match;
DDPRateLimiter = Package['ddp-rate-limiter'].DDPRateLimiter;
RateLimiter = Package['rate-limit'].RateLimiter;
Email = Package.email.Email;
EmailInternals = Package.email.EmailInternals;
DDPCommon = Package['ddp-common'].DDPCommon;
WebApp = Package.webapp.WebApp;
WebAppInternals = Package.webapp.WebAppInternals;
main = Package.webapp.main;
MongoInternals = Package.mongo.MongoInternals;
Mongo = Package.mongo.Mongo;
ServiceConfiguration = Package['service-configuration'].ServiceConfiguration;
Inject = Package['meteorhacks:inject-initial'].Inject;
RoutePolicy = Package.routepolicy.RoutePolicy;
WebAppHashing = Package['webapp-hashing'].WebAppHashing;
Facts = Package['facts-base'].Facts;
Tracker = Package.tracker.Tracker;
Deps = Package.tracker.Deps;
ReactiveDict = Package['reactive-dict'].ReactiveDict;
ReactiveVar = Package['reactive-var'].ReactiveVar;
Babel = Package['babel-compiler'].Babel;
BabelCompiler = Package['babel-compiler'].BabelCompiler;
SwcCompiler = Package['babel-compiler'].SwcCompiler;
ECMAScript = Package.ecmascript.ECMAScript;
Autoupdate = Package.autoupdate.Autoupdate;
Facebook = Package['facebook-oauth'].Facebook;
Github = Package['github-oauth'].Github;
MeteorDeveloperAccounts = Package['meteor-developer-oauth'].MeteorDeveloperAccounts;
Twitter = Package['twitter-oauth'].Twitter;
Meteor = Package.meteor.Meteor;
global = Package.meteor.global;
meteorEnv = Package.meteor.meteorEnv;
EmitterPromise = Package.meteor.EmitterPromise;
DDP = Package['ddp-client'].DDP;
DDPServer = Package['ddp-server'].DDPServer;
meteorInstall = Package.modules.meteorInstall;
Promise = Package.promise.Promise;

var require = meteorInstall({"ee":{"app":{"livechat-enterprise":{"server":{"api":{"lib":{"contacts.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/contacts.ts                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      changeContactBlockStatus: () => changeContactBlockStatus,
      ensureSingleContactLicense: () => ensureSingleContactLicense,
      closeBlockedRoom: () => closeBlockedRoom
    });
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let LivechatContacts, LivechatRooms, LivechatVisitors;
    module.link("@rocket.chat/models", {
      LivechatContacts(v) {
        LivechatContacts = v;
      },
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      LivechatVisitors(v) {
        LivechatVisitors = v;
      }
    }, 1);
    let closeRoom;
    module.link("../../../../../../app/livechat/server/lib/closeRoom", {
      closeRoom(v) {
        closeRoom = v;
      }
    }, 2);
    let i18n;
    module.link("../../../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function changeContactBlockStatus(_ref) {
      let {
        block,
        visitor
      } = _ref;
      const result = await LivechatContacts.setChannelBlockStatus(visitor, block);
      if (!result.modifiedCount) {
        throw new Error('error-contact-not-found');
      }
    }
    function ensureSingleContactLicense() {
      if (!License.hasModule('contact-id-verification')) {
        throw new Error('error-action-not-allowed');
      }
    }
    async function closeBlockedRoom(association, user) {
      const visitor = await LivechatVisitors.findOneById(association.visitorId);
      if (!visitor) {
        throw new Error('error-visitor-not-found');
      }
      const room = await LivechatRooms.findOneOpenByContactChannelVisitor(association);
      if (!room) {
        return;
      }
      return closeRoom({
        room,
        visitor,
        comment: i18n.t('close-blocked-room-comment'),
        user
      });
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"dashboards.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/dashboards.ts                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      findAllConversationsBySource: () => findAllConversationsBySource,
      findAllConversationsByStatus: () => findAllConversationsByStatus,
      findAllConversationsByDepartment: () => findAllConversationsByDepartment,
      findAllConversationsByTags: () => findAllConversationsByTags,
      findAllConversationsByAgents: () => findAllConversationsByAgents,
      findAllConversationsBySourceCached: () => findAllConversationsBySourceCached,
      findAllConversationsByStatusCached: () => findAllConversationsByStatusCached,
      findAllConversationsByDepartmentCached: () => findAllConversationsByDepartmentCached,
      findAllConversationsByTagsCached: () => findAllConversationsByTagsCached,
      findAllConversationsByAgentsCached: () => findAllConversationsByAgentsCached
    });
    let LivechatRooms;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      }
    }, 0);
    let mem;
    module.link("mem", {
      default(v) {
        mem = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const defaultValue = {
      data: [],
      total: 0
    };
    const findAllConversationsBySource = async _ref => {
      let {
        start,
        end,
        extraQuery
      } = _ref;
      return (await LivechatRooms.getConversationsBySource(start, end, extraQuery).toArray())[0] || defaultValue;
    };
    const findAllConversationsByStatus = async _ref2 => {
      let {
        start,
        end,
        extraQuery
      } = _ref2;
      return (await LivechatRooms.getConversationsByStatus(start, end, extraQuery).toArray())[0] || defaultValue;
    };
    const findAllConversationsByDepartment = async _ref3 => {
      let {
        start,
        end,
        sort,
        extraQuery
      } = _ref3;
      const [result, total] = await Promise.all([LivechatRooms.getConversationsByDepartment(start, end, sort, extraQuery).toArray(), LivechatRooms.getTotalConversationsWithoutDepartmentBetweenDates(start, end, extraQuery)]);
      return _objectSpread(_objectSpread({}, (result === null || result === void 0 ? void 0 : result[0]) || defaultValue), {}, {
        unspecified: total || 0
      });
    };
    const findAllConversationsByTags = async _ref4 => {
      let {
        start,
        end,
        sort,
        extraQuery
      } = _ref4;
      const [result, total] = await Promise.all([LivechatRooms.getConversationsByTags(start, end, sort, extraQuery).toArray(), LivechatRooms.getConversationsWithoutTagsBetweenDate(start, end, extraQuery)]);
      return _objectSpread(_objectSpread({}, (result === null || result === void 0 ? void 0 : result[0]) || defaultValue), {}, {
        unspecified: total || 0
      });
    };
    const findAllConversationsByAgents = async _ref5 => {
      let {
        start,
        end,
        sort,
        extraQuery
      } = _ref5;
      const [result, total] = await Promise.all([LivechatRooms.getConversationsByAgents(start, end, sort, extraQuery).toArray(), LivechatRooms.getTotalConversationsWithoutAgentsBetweenDate(start, end, extraQuery)]);
      return _objectSpread(_objectSpread({}, (result === null || result === void 0 ? void 0 : result[0]) || defaultValue), {}, {
        unspecified: total || 0
      });
    };
    const findAllConversationsBySourceCached = mem(findAllConversationsBySource, {
      maxAge: 60000,
      cacheKey: JSON.stringify
    });
    const findAllConversationsByStatusCached = mem(findAllConversationsByStatus, {
      maxAge: 60000,
      cacheKey: JSON.stringify
    });
    const findAllConversationsByDepartmentCached = mem(findAllConversationsByDepartment, {
      maxAge: 60000,
      cacheKey: JSON.stringify
    });
    const findAllConversationsByTagsCached = mem(findAllConversationsByTags, {
      maxAge: 60000,
      cacheKey: JSON.stringify
    });
    const findAllConversationsByAgentsCached = mem(findAllConversationsByAgents, {
      maxAge: 60000,
      cacheKey: JSON.stringify
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"departments.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/departments.ts                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      getDepartmentsWhichUserCanAccess: () => getDepartmentsWhichUserCanAccess,
      hasAccessToDepartment: () => hasAccessToDepartment
    });
    let LivechatDepartment, LivechatDepartmentAgents, LivechatUnit;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      LivechatDepartmentAgents(v) {
        LivechatDepartmentAgents = v;
      },
      LivechatUnit(v) {
        LivechatUnit = v;
      }
    }, 0);
    let helperLogger;
    module.link("../../lib/logger", {
      helperLogger(v) {
        helperLogger = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const getDepartmentsWhichUserCanAccess = async function (userId) {
      let includeDisabled = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      const departments = await LivechatDepartmentAgents.find({
        agentId: userId
      }, {
        projection: {
          departmentId: 1
        }
      }).toArray();
      const monitoredDepartments = await LivechatUnit.findMonitoredDepartmentsByMonitorId(userId, includeDisabled);
      const combinedDepartments = [...departments.map(department => department.departmentId), ...monitoredDepartments.map(department => department._id)];
      return [...new Set(combinedDepartments)];
    };
    const hasAccessToDepartment = async (userId, departmentId) => {
      const department = await LivechatDepartmentAgents.findOneByAgentIdAndDepartmentId(userId, departmentId, {
        projection: {
          _id: 1
        }
      });
      if (department) {
        helperLogger.debug("User ".concat(userId, " has access to department ").concat(departmentId, " because they are an agent"));
        return true;
      }
      const monitorAccess = await LivechatDepartment.checkIfMonitorIsMonitoringDepartmentById(userId, departmentId);
      helperLogger.debug("User ".concat(userId, " ").concat(monitorAccess ? 'has' : 'does not have', " access to department ").concat(departmentId, " because they are a monitor"));
      return monitorAccess;
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"inquiries.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/inquiries.ts                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      setSLAToInquiry: () => setSLAToInquiry
    });
    let LivechatInquiry, Users, OmnichannelServiceLevelAgreements;
    module.link("@rocket.chat/models", {
      LivechatInquiry(v) {
        LivechatInquiry = v;
      },
      Users(v) {
        Users = v;
      },
      OmnichannelServiceLevelAgreements(v) {
        OmnichannelServiceLevelAgreements = v;
      }
    }, 0);
    let updateRoomSLA;
    module.link("./sla", {
      updateRoomSLA(v) {
        updateRoomSLA = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function setSLAToInquiry(_ref) {
      let {
        userId,
        roomId,
        sla
      } = _ref;
      const inquiry = await LivechatInquiry.findOneByRoomId(roomId, {
        projection: {
          status: 1
        }
      });
      if (!inquiry || inquiry.status !== 'queued') {
        throw new Error('error-invalid-inquiry');
      }
      const slaData = sla && (await OmnichannelServiceLevelAgreements.findOneByIdOrName(sla));
      if (!slaData) {
        throw new Error('error-invalid-sla');
      }
      const user = await Users.findOneById(userId, {
        projection: {
          _id: 1,
          username: 1,
          name: 1
        }
      });
      if (!(user !== null && user !== void 0 && user.username)) {
        throw new Error('error-invalid-user');
      }
      await updateRoomSLA(roomId, {
        _id: user._id,
        name: user.name || '',
        username: user.username
      }, slaData);
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"monitors.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/monitors.ts                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      findMonitors: () => findMonitors,
      findMonitorByUsername: () => findMonitorByUsername
    });
    let Users;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      }
    }, 0);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function findMonitors(_ref) {
      let {
        text,
        pagination: {
          offset,
          count,
          sort
        }
      } = _ref;
      const query = {};
      if (text) {
        const filterReg = new RegExp(escapeRegExp(text), 'i');
        Object.assign(query, {
          $or: [{
            username: filterReg
          }, {
            name: filterReg
          }, {
            'emails.address': filterReg
          }]
        });
      }
      const {
        cursor,
        totalCount
      } = Users.findPaginatedUsersInRolesWithQuery('livechat-monitor', query, {
        sort: sort || {
          name: 1
        },
        skip: offset,
        limit: count,
        projection: {
          username: 1,
          name: 1,
          status: 1,
          statusLivechat: 1,
          emails: 1,
          livechat: 1
        }
      });
      const [monitors, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        monitors,
        count: monitors.length,
        offset,
        total
      };
    }
    async function findMonitorByUsername(_ref2) {
      let {
        username
      } = _ref2;
      const user = await Users.findOne({
        username,
        roles: 'livechat-monitor'
      }, {
        projection: {
          username: 1,
          name: 1,
          status: 1,
          statusLivechat: 1,
          emails: 1,
          livechat: 1
        }
      });
      if (!user) {
        throw new Error('invalid-user');
      }
      return user;
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"outbound.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/outbound.ts                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      OutboundMessageProviderService: () => OutboundMessageProviderService,
      outboundMessageProvider: () => outboundMessageProvider
    });
    let Apps;
    module.link("@rocket.chat/apps", {
      Apps(v) {
        Apps = v;
      }
    }, 0);
    let ValidOutboundProviderList;
    module.link("@rocket.chat/core-typings", {
      ValidOutboundProviderList(v) {
        ValidOutboundProviderList = v;
      }
    }, 1);
    let getOutboundService;
    module.link("../../../../../../app/livechat/server/lib/outboundcommunication", {
      getOutboundService(v) {
        getOutboundService = v;
      }
    }, 2);
    let OutboundMessageProvider;
    module.link("../../../../../../server/lib/OutboundMessageProvider", {
      OutboundMessageProvider(v) {
        OutboundMessageProvider = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class OutboundMessageProviderService {
      constructor() {
        this.provider = void 0;
        this.provider = new OutboundMessageProvider();
      }
      get outboundMessageProvider() {
        return this.provider;
      }
      isProviderValid(type) {
        return ValidOutboundProviderList.includes(type);
      }
      listOutboundProviders(type) {
        if (type !== undefined && !this.isProviderValid(type)) {
          throw new Error('Invalid type');
        }
        return this.provider.getOutboundMessageProviders(type);
      }
      getProviderMetadata(providerId) {
        const provider = this.provider.findOneByProviderId(providerId);
        if (!provider) {
          throw new Error('error-invalid-provider');
        }
        return this.getProviderManager().getProviderMetadata(provider.appId, provider.type);
      }
      getProviderManager() {
        var _Apps$self, _Apps$self2, _Apps$self2$getManage;
        if (!((_Apps$self = Apps.self) !== null && _Apps$self !== void 0 && _Apps$self.isLoaded())) {
          throw new Error('apps-engine-not-loaded');
        }
        const manager = (_Apps$self2 = Apps.self) === null || _Apps$self2 === void 0 ? void 0 : (_Apps$self2$getManage = _Apps$self2.getManager()) === null || _Apps$self2$getManage === void 0 ? void 0 : _Apps$self2$getManage.getOutboundCommunicationProviderManager();
        if (!manager) {
          throw new Error('apps-engine-not-configured-correctly');
        }
        return manager;
      }
      sendMessage(providerId, message) {
        const provider = this.provider.findOneByProviderId(providerId);
        if (!provider) {
          throw new Error('error-invalid-provider');
        }
        return this.getProviderManager().sendOutboundMessage(provider.appId, provider.type, message);
      }
    }
    const outboundMessageProvider = new OutboundMessageProviderService();
    getOutboundService.patch(() => {
      return outboundMessageProvider;
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"priorities.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/priorities.ts                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      findPriority: () => findPriority,
      updatePriority: () => updatePriority,
      updateRoomPriority: () => updateRoomPriority,
      removePriorityFromRoom: () => removePriorityFromRoom
    });
    let Message;
    module.link("@rocket.chat/core-services", {
      Message(v) {
        Message = v;
      }
    }, 0);
    let LivechatInquiry, LivechatPriority, LivechatRooms;
    module.link("@rocket.chat/models", {
      LivechatInquiry(v) {
        LivechatInquiry = v;
      },
      LivechatPriority(v) {
        LivechatPriority = v;
      },
      LivechatRooms(v) {
        LivechatRooms = v;
      }
    }, 1);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 2);
    let notifyOnLivechatInquiryChangedByRoom, notifyOnRoomChanged;
    module.link("../../../../../../app/lib/server/lib/notifyListener", {
      notifyOnLivechatInquiryChangedByRoom(v) {
        notifyOnLivechatInquiryChangedByRoom = v;
      },
      notifyOnRoomChanged(v) {
        notifyOnRoomChanged = v;
      }
    }, 3);
    let logger;
    module.link("../../lib/logger", {
      logger(v) {
        logger = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function findPriority(_ref) {
      let {
        text,
        pagination: {
          offset,
          count,
          sort
        }
      } = _ref;
      const query = _objectSpread({}, text && {
        $or: [{
          name: new RegExp(escapeRegExp(text), 'i')
        }, {
          description: new RegExp(escapeRegExp(text), 'i')
        }]
      });
      const {
        cursor,
        totalCount
      } = LivechatPriority.findPaginated(query, {
        sort: sort || {
          name: 1
        },
        skip: offset,
        limit: count
      });
      const [priorities, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        priorities,
        count: priorities.length,
        offset,
        total
      };
    }
    async function updatePriority(_id, data) {
      if (data.name) {
        // If we want to enforce translated duplicates we need to change this
        const priority = await LivechatPriority.findOneNameUsingRegex(data.name, {
          projection: {
            name: 1
          }
        });
        if (priority && priority._id !== _id) {
          throw new Error('error-duplicate-priority-name');
        }
      }
      const createdResult = await LivechatPriority.updatePriority(_id, data.reset || false, data.name);
      if (!createdResult) {
        logger.error("Error updating priority: ".concat(_id, ". Unsuccessful result from mongodb. Result"), createdResult);
        throw Error('error-unable-to-update-priority');
      }
      return createdResult;
    }
    const updateRoomPriority = async (rid, user, priorityId) => {
      const room = await LivechatRooms.findOneById(rid);
      if (!room) {
        throw new Error('error-room-does-not-exist');
      }
      const priority = await LivechatPriority.findOneById(priorityId);
      if (!priority) {
        throw new Error('error-invalid-priority');
      }
      await Promise.all([LivechatRooms.setPriorityByRoomId(rid, priority), LivechatInquiry.setPriorityForRoom(rid, priority), addPriorityChangeHistoryToRoom(room._id, user, priority)]);
      void notifyOnRoomChanged(_objectSpread(_objectSpread({}, room), {}, {
        priorityId: priority._id,
        priorityWeight: priority.sortItem
      }), 'updated');
      void notifyOnLivechatInquiryChangedByRoom(rid, 'updated');
    };
    const removePriorityFromRoom = async (rid, user) => {
      const room = await LivechatRooms.findOneById(rid, {
        projection: {
          priorityId: 0,
          priorityWeight: 0
        }
      });
      if (!room) {
        throw new Error('error-room-does-not-exist');
      }
      await Promise.all([LivechatRooms.unsetPriorityByRoomId(rid), LivechatInquiry.unsetPriorityForRoom(rid), addPriorityChangeHistoryToRoom(rid, user)]);
      void notifyOnRoomChanged(room, 'updated');
      void notifyOnLivechatInquiryChangedByRoom(rid, 'updated');
    };
    const addPriorityChangeHistoryToRoom = async (roomId, user, priority) => {
      await Message.saveSystemMessage('omnichannel_priority_change_history', roomId, '', user, {
        priorityData: _objectSpread({
          definedBy: {
            _id: user._id,
            username: user.username
          }
        }, priority && {
          priority
        })
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"sla.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/sla.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      findSLA: () => findSLA,
      updateRoomSLA: () => updateRoomSLA,
      removeRoomSLA: () => removeRoomSLA
    });
    let OmnichannelServiceLevelAgreements;
    module.link("@rocket.chat/models", {
      OmnichannelServiceLevelAgreements(v) {
        OmnichannelServiceLevelAgreements = v;
      }
    }, 0);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 1);
    let addSlaChangeHistoryToRoom, removeInquiryQueueSla, removeSlaFromRoom, updateInquiryQueueSla, updateRoomSlaWeights;
    module.link("../../lib/SlaHelper", {
      addSlaChangeHistoryToRoom(v) {
        addSlaChangeHistoryToRoom = v;
      },
      removeInquiryQueueSla(v) {
        removeInquiryQueueSla = v;
      },
      removeSlaFromRoom(v) {
        removeSlaFromRoom = v;
      },
      updateInquiryQueueSla(v) {
        updateInquiryQueueSla = v;
      },
      updateRoomSlaWeights(v) {
        updateRoomSlaWeights = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function findSLA(_ref) {
      let {
        text,
        pagination: {
          offset,
          count,
          sort
        }
      } = _ref;
      const query = _objectSpread({}, text && {
        $or: [{
          name: new RegExp(escapeRegExp(text), 'i')
        }, {
          description: new RegExp(escapeRegExp(text), 'i')
        }]
      });
      const {
        cursor,
        totalCount
      } = OmnichannelServiceLevelAgreements.findPaginated(query, {
        sort: sort || {
          name: 1
        },
        skip: offset,
        limit: count
      });
      const [sla, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        sla,
        count: sla.length,
        offset,
        total
      };
    }
    const updateRoomSLA = async (roomId, user, sla) => {
      await Promise.all([updateInquiryQueueSla(roomId, sla), updateRoomSlaWeights(roomId, sla), addSlaChangeHistoryToRoom(roomId, user, sla)]);
    };
    const removeRoomSLA = async (roomId, user) => {
      await Promise.all([removeInquiryQueueSla(roomId), removeSlaFromRoom(roomId), addSlaChangeHistoryToRoom(roomId, user)]);
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"tags.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/tags.ts                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      findTags: () => findTags,
      findTagById: () => findTagById
    });
    let LivechatTag;
    module.link("@rocket.chat/models", {
      LivechatTag(v) {
        LivechatTag = v;
      }
    }, 0);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 1);
    let getDepartmentsWhichUserCanAccess;
    module.link("./departments", {
      getDepartmentsWhichUserCanAccess(v) {
        getDepartmentsWhichUserCanAccess = v;
      }
    }, 2);
    let hasPermissionAsync;
    module.link("../../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 3);
    let helperLogger;
    module.link("../../lib/logger", {
      helperLogger(v) {
        helperLogger = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function findTags(_ref) {
      var _query$$and;
      let {
        userId,
        text,
        department,
        viewAll,
        pagination: {
          offset,
          count,
          sort
        }
      } = _ref;
      let filteredDepartmentIds = [];
      if (!(await hasPermissionAsync(userId, 'manage-livechat-tags'))) {
        if (viewAll) {
          viewAll = false;
        }
        // Get a list of all departments this user has access to and only
        // return tags that are associated with those departments
        filteredDepartmentIds = await getDepartmentsWhichUserCanAccess(userId);
        helperLogger.debug({
          msg: 'User does not have permission to manage livechat tags. Filtering tags by departments user has access to.',
          userId,
          accessibleDepartmentsLength: filteredDepartmentIds.length,
          top5AccessibleDepartments: filteredDepartmentIds.slice(0, 5)
        });
        if (department && !filteredDepartmentIds.includes(department)) {
          department = undefined;
        }
      }
      if (department) {
        // In certain cases, the user would only want to see tags for a specific department
        // EG: When closing the chat which is associated with a specific department
        // user get's to choose which tag to use to close the chat
        // (only tags associated with the department should be shown)
        filteredDepartmentIds = [department];
      }
      const query = {
        $and: [...(text ? [{
          $or: [{
            name: new RegExp(escapeRegExp(text), 'i')
          }, {
            description: new RegExp(escapeRegExp(text), 'i')
          }]
        }] : []), ...(!viewAll ? [{
          $or: [{
            departments: {
              $size: 0
            }
          }, ...(filteredDepartmentIds.length ? [{
            departments: {
              $in: filteredDepartmentIds
            }
          }] : [])]
        }] : [])]
      };
      if (!(query !== null && query !== void 0 && (_query$$and = query.$and) !== null && _query$$and !== void 0 && _query$$and.length)) {
        delete query.$and;
      }
      const {
        cursor,
        totalCount
      } = LivechatTag.findPaginated(query, {
        sort: sort || {
          name: 1
        },
        skip: offset,
        limit: count
      });
      const [tags, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        tags,
        count: tags.length,
        offset,
        total
      };
    }
    async function findTagById(_ref2) {
      let {
        tagId
      } = _ref2;
      return LivechatTag.findOneById(tagId);
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"triggers.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/triggers.ts                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      callTriggerExternalService: () => callTriggerExternalService
    });
    let fetch;
    module.link("@rocket.chat/server-fetch", {
      serverFetch(v) {
        fetch = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function callTriggerExternalService(_ref) {
      let {
        url,
        timeout,
        fallbackMessage,
        body,
        headers
      } = _ref;
      try {
        const response = await fetch(url, {
          timeout: timeout || 1000,
          body,
          headers,
          method: 'POST'
        });
        if (!response.ok || response.status !== 200) {
          const text = await response.text();
          throw new Error(text);
        }
        const data = await response.json();
        const {
          contents
        } = data;
        if (!Array.isArray(contents) || !contents.length || !contents.every(_ref2 => {
          let {
            msg,
            order
          } = _ref2;
          return typeof msg === 'string' && typeof order === 'number';
        })) {
          throw new Error('External service response does not match expected format');
        }
        return {
          response: {
            statusCode: response.status,
            contents: (data === null || data === void 0 ? void 0 : data.contents) || []
          }
        };
      } catch (error) {
        const isTimeout = error.message === 'The user aborted a request.';
        return {
          error: isTimeout ? 'error-timeout' : 'error-invalid-external-service-response',
          response: error.message,
          fallbackMessage
        };
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"units.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/lib/units.ts                                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      findUnitsOfUser: () => findUnitsOfUser,
      findUnits: () => findUnits,
      findUnitMonitors: () => findUnitMonitors,
      findUnitById: () => findUnitById
    });
    let LivechatUnitMonitors, LivechatUnit;
    module.link("@rocket.chat/models", {
      LivechatUnitMonitors(v) {
        LivechatUnitMonitors = v;
      },
      LivechatUnit(v) {
        LivechatUnit = v;
      }
    }, 0);
    let getUnitsFromUser;
    module.link("@rocket.chat/omni-core-ee", {
      getUnitsFromUser(v) {
        getUnitsFromUser = v;
      }
    }, 1);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function findUnitsOfUser(_ref) {
      let {
        text,
        userId,
        pagination: {
          offset,
          count,
          sort
        }
      } = _ref;
      const filter = text && new RegExp(escapeRegExp(text), 'i');
      // TODO: an aggregation woudl be faster? or nah?
      const myUnits = await LivechatUnitMonitors.findByMonitorId(userId).map(u => u.unitId).toArray();
      const query = _objectSpread({
        _id: {
          $in: myUnits
        }
      }, text && {
        $or: [{
          name: filter
        }]
      });
      const {
        cursor,
        totalCount
      } = LivechatUnit.findPaginatedUnits(query, {
        sort: sort || {
          name: 1
        },
        skip: offset,
        limit: count
      });
      const [units, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        units,
        count: units.length,
        offset,
        total
      };
    }
    async function findUnits(_ref2) {
      let {
        text,
        pagination: {
          offset,
          count,
          sort
        }
      } = _ref2;
      const filter = text && new RegExp(escapeRegExp(text), 'i');
      const query = _objectSpread({}, text && {
        $or: [{
          name: filter
        }]
      });
      const {
        cursor,
        totalCount
      } = LivechatUnit.findPaginatedUnits(query, {
        sort: sort || {
          name: 1
        },
        skip: offset,
        limit: count
      });
      const [units, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        units,
        count: units.length,
        offset,
        total
      };
    }
    async function findUnitMonitors(_ref3) {
      let {
        unitId
      } = _ref3;
      return LivechatUnitMonitors.find({
        unitId
      }).toArray();
    }
    async function findUnitById(_ref4) {
      let {
        unitId,
        userId
      } = _ref4;
      const unitsFromUser = await getUnitsFromUser(userId);
      return LivechatUnit.findOneById(unitId, {}, {
        unitsFromUser
      });
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"agents.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/agents.ts                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let isLivechatAnalyticsAgentsTotalServiceTimeProps, isLivechatAnalyticsAgentsAverageServiceTimeProps, isLivechatAnalyticsAgentsAvailableForServiceHistoryProps;
    module.link("@rocket.chat/rest-typings", {
      isLivechatAnalyticsAgentsTotalServiceTimeProps(v) {
        isLivechatAnalyticsAgentsTotalServiceTimeProps = v;
      },
      isLivechatAnalyticsAgentsAverageServiceTimeProps(v) {
        isLivechatAnalyticsAgentsAverageServiceTimeProps = v;
      },
      isLivechatAnalyticsAgentsAvailableForServiceHistoryProps(v) {
        isLivechatAnalyticsAgentsAvailableForServiceHistoryProps = v;
      }
    }, 0);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 2);
    let findAllAverageServiceTimeAsync, findAllServiceTimeAsync, findAvailableServiceTimeHistoryAsync;
    module.link("../../../../../app/livechat/server/lib/analytics/agents", {
      findAllAverageServiceTimeAsync(v) {
        findAllAverageServiceTimeAsync = v;
      },
      findAllServiceTimeAsync(v) {
        findAllServiceTimeAsync = v;
      },
      findAvailableServiceTimeHistoryAsync(v) {
        findAvailableServiceTimeHistoryAsync = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/analytics/agents/average-service-time', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsAgentsAverageServiceTimeProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          agents,
          total
        } = await findAllAverageServiceTimeAsync({
          start: startDate,
          end: endDate,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          agents,
          count: agents.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/agents/total-service-time', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsAgentsTotalServiceTimeProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          agents,
          total
        } = await findAllServiceTimeAsync({
          start: startDate,
          end: endDate,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          agents,
          count: agents.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/agents/available-for-service-history', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsAgentsAvailableForServiceHistoryProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          fullReport
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const {
          agents,
          total
        } = await findAvailableServiceTimeHistoryAsync({
          start,
          end,
          fullReport: fullReport === 'true',
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          agents,
          count: agents.length,
          offset,
          total
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"business-hours.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/business-hours.ts                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 0);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 1);
    let findBusinessHours;
    module.link("../business-hour/lib/business-hour", {
      findBusinessHours(v) {
        findBusinessHours = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/business-hours', {
      authRequired: true,
      permissionsRequired: ['view-livechat-business-hours'],
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          sort
        } = await this.parseJsonQuery();
        const {
          name
        } = this.queryParams;
        return API.v1.success(await findBusinessHours(this.userId, {
          offset,
          count,
          sort
        }, name));
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"contacts.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/contacts.ts                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let ContactVisitorAssociationSchema;
    module.link("@rocket.chat/rest-typings", {
      ContactVisitorAssociationSchema(v) {
        ContactVisitorAssociationSchema = v;
      }
    }, 0);
    let Ajv;
    module.link("ajv", {
      default(v) {
        Ajv = v;
      }
    }, 1);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 2);
    let logger;
    module.link("../lib/logger", {
      logger(v) {
        logger = v;
      }
    }, 3);
    let changeContactBlockStatus, closeBlockedRoom, ensureSingleContactLicense;
    module.link("./lib/contacts", {
      changeContactBlockStatus(v) {
        changeContactBlockStatus = v;
      },
      closeBlockedRoom(v) {
        closeBlockedRoom = v;
      },
      ensureSingleContactLicense(v) {
        ensureSingleContactLicense = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const ajv = new Ajv({
      coerceTypes: true
    });
    const blockContactSchema = {
      type: 'object',
      properties: {
        visitor: ContactVisitorAssociationSchema
      },
      required: ['visitor'],
      additionalProperties: false
    };
    const isBlockContactProps = ajv.compile(blockContactSchema);
    API.v1.addRoute('omnichannel/contacts.block', {
      authRequired: true,
      permissionsRequired: ['block-livechat-contact'],
      validateParams: isBlockContactProps,
      license: ['livechat-enterprise']
    }, {
      async post() {
        ensureSingleContactLicense();
        const {
          visitor
        } = this.bodyParams;
        const {
          user
        } = this;
        await changeContactBlockStatus({
          visitor,
          block: true
        });
        logger.info("Visitor with id ".concat(visitor.visitorId, " blocked by user with id ").concat(user._id));
        await closeBlockedRoom(visitor, user);
        return API.v1.success();
      }
    });
    API.v1.addRoute('omnichannel/contacts.unblock', {
      authRequired: true,
      permissionsRequired: ['unblock-livechat-contact'],
      validateParams: isBlockContactProps,
      license: ['livechat-enterprise']
    }, {
      async post() {
        ensureSingleContactLicense();
        const {
          visitor
        } = this.bodyParams;
        const {
          user
        } = this;
        await changeContactBlockStatus({
          visitor,
          block: false
        });
        logger.info("Visitor with id ".concat(visitor.visitorId, " unblocked by user with id ").concat(user._id));
        return API.v1.success();
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"departments.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/departments.ts                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let isLivechatAnalyticsDepartmentsAmountOfChatsProps, isLivechatAnalyticsDepartmentsAverageServiceTimeProps, isLivechatAnalyticsDepartmentsAverageChatDurationTimeProps, isLivechatAnalyticsDepartmentsTotalServiceTimeProps, isLivechatAnalyticsDepartmentsAverageWaitingTimeProps, isLivechatAnalyticsDepartmentsTotalTransferredChatsProps, isLivechatAnalyticsDepartmentsTotalAbandonedChatsProps, isLivechatAnalyticsDepartmentsPercentageAbandonedChatsProps;
    module.link("@rocket.chat/rest-typings", {
      isLivechatAnalyticsDepartmentsAmountOfChatsProps(v) {
        isLivechatAnalyticsDepartmentsAmountOfChatsProps = v;
      },
      isLivechatAnalyticsDepartmentsAverageServiceTimeProps(v) {
        isLivechatAnalyticsDepartmentsAverageServiceTimeProps = v;
      },
      isLivechatAnalyticsDepartmentsAverageChatDurationTimeProps(v) {
        isLivechatAnalyticsDepartmentsAverageChatDurationTimeProps = v;
      },
      isLivechatAnalyticsDepartmentsTotalServiceTimeProps(v) {
        isLivechatAnalyticsDepartmentsTotalServiceTimeProps = v;
      },
      isLivechatAnalyticsDepartmentsAverageWaitingTimeProps(v) {
        isLivechatAnalyticsDepartmentsAverageWaitingTimeProps = v;
      },
      isLivechatAnalyticsDepartmentsTotalTransferredChatsProps(v) {
        isLivechatAnalyticsDepartmentsTotalTransferredChatsProps = v;
      },
      isLivechatAnalyticsDepartmentsTotalAbandonedChatsProps(v) {
        isLivechatAnalyticsDepartmentsTotalAbandonedChatsProps = v;
      },
      isLivechatAnalyticsDepartmentsPercentageAbandonedChatsProps(v) {
        isLivechatAnalyticsDepartmentsPercentageAbandonedChatsProps = v;
      }
    }, 0);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 2);
    let findAllRoomsAsync, findAllAverageServiceTimeAsync, findAllServiceTimeAsync, findAllAverageWaitingTimeAsync, findAllNumberOfTransferredRoomsAsync, findAllNumberOfAbandonedRoomsAsync, findPercentageOfAbandonedRoomsAsync, findAllAverageOfChatDurationTimeAsync;
    module.link("../../../../../app/livechat/server/lib/analytics/departments", {
      findAllRoomsAsync(v) {
        findAllRoomsAsync = v;
      },
      findAllAverageServiceTimeAsync(v) {
        findAllAverageServiceTimeAsync = v;
      },
      findAllServiceTimeAsync(v) {
        findAllServiceTimeAsync = v;
      },
      findAllAverageWaitingTimeAsync(v) {
        findAllAverageWaitingTimeAsync = v;
      },
      findAllNumberOfTransferredRoomsAsync(v) {
        findAllNumberOfTransferredRoomsAsync = v;
      },
      findAllNumberOfAbandonedRoomsAsync(v) {
        findAllNumberOfAbandonedRoomsAsync = v;
      },
      findPercentageOfAbandonedRoomsAsync(v) {
        findPercentageOfAbandonedRoomsAsync = v;
      },
      findAllAverageOfChatDurationTimeAsync(v) {
        findAllAverageOfChatDurationTimeAsync = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/analytics/departments/amount-of-chats', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsDepartmentsAmountOfChatsProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          answered,
          departmentId
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          departments,
          total
        } = await findAllRoomsAsync({
          start: startDate,
          end: endDate,
          answered: answered === 'true',
          departmentId,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/departments/average-service-time', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsDepartmentsAverageServiceTimeProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          departmentId
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          departments,
          total
        } = await findAllAverageServiceTimeAsync({
          start: startDate,
          end: endDate,
          departmentId,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/departments/average-chat-duration-time', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsDepartmentsAverageChatDurationTimeProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          departmentId
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          departments,
          total
        } = await findAllAverageOfChatDurationTimeAsync({
          start: startDate,
          end: endDate,
          departmentId,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/departments/total-service-time', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsDepartmentsTotalServiceTimeProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          departmentId
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          departments,
          total
        } = await findAllServiceTimeAsync({
          start: startDate,
          end: endDate,
          departmentId,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/departments/average-waiting-time', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsDepartmentsAverageWaitingTimeProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          departmentId
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          departments,
          total
        } = await findAllAverageWaitingTimeAsync({
          start: startDate,
          end: endDate,
          departmentId,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/departments/total-transferred-chats', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsDepartmentsTotalTransferredChatsProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          departmentId
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          departments,
          total
        } = await findAllNumberOfTransferredRoomsAsync({
          start: startDate,
          end: endDate,
          departmentId,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/departments/total-abandoned-chats', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsDepartmentsTotalAbandonedChatsProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          departmentId
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          departments,
          total
        } = await findAllNumberOfAbandonedRoomsAsync({
          start: startDate,
          end: endDate,
          departmentId,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/analytics/departments/percentage-abandoned-chats', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatAnalyticsDepartmentsPercentageAbandonedChatsProps,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          start,
          end
        } = this.queryParams;
        const {
          departmentId
        } = this.queryParams;
        if (isNaN(Date.parse(start))) {
          return API.v1.failure('The "start" query parameter must be a valid date.');
        }
        const startDate = new Date(start);
        if (isNaN(Date.parse(end))) {
          return API.v1.failure('The "end" query parameter must be a valid date.');
        }
        const endDate = new Date(end);
        const {
          departments,
          total
        } = await findPercentageOfAbandonedRoomsAsync({
          start: startDate,
          end: endDate,
          departmentId,
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/index.ts                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./agents");
    module.link("./departments");
    module.link("./inquiries");
    module.link("./monitors");
    module.link("./sla");
    module.link("./priorities");
    module.link("./tags");
    module.link("./units");
    module.link("./business-hours");
    module.link("./rooms");
    module.link("./transcript");
    module.link("./reports");
    module.link("./triggers");
    module.link("./contacts");
    module.link("./outbound");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"inquiries.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/inquiries.ts                                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let setSLAToInquiry;
    module.link("./lib/inquiries", {
      setSLAToInquiry(v) {
        setSLAToInquiry = v;
      }
    }, 0);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/inquiry.setSLA', {
      authRequired: true,
      permissionsRequired: {
        PUT: {
          permissions: ['view-l-room', 'manage-livechat-sla'],
          operation: 'hasAny'
        }
      },
      license: ['livechat-enterprise']
    }, {
      async put() {
        const {
          roomId,
          sla
        } = this.bodyParams;
        if (!roomId) {
          return API.v1.failure("The 'roomId' param is required");
        }
        await setSLAToInquiry({
          userId: this.userId,
          roomId,
          sla
        });
        return API.v1.success();
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"monitors.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/monitors.ts                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let findMonitors, findMonitorByUsername;
    module.link("./lib/monitors", {
      findMonitors(v) {
        findMonitors = v;
      },
      findMonitorByUsername(v) {
        findMonitorByUsername = v;
      }
    }, 0);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/monitors', {
      authRequired: true,
      permissionsRequired: ['manage-livechat-monitors'],
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          sort
        } = await this.parseJsonQuery();
        const {
          text
        } = this.queryParams;
        return API.v1.success(await findMonitors({
          text,
          pagination: {
            offset,
            count,
            sort
          }
        }));
      }
    });
    API.v1.addRoute('livechat/monitors/:username', {
      authRequired: true,
      permissionsRequired: ['manage-livechat-monitors'],
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          username
        } = this.urlParams;
        return API.v1.success(await findMonitorByUsername({
          username
        }));
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"outbound.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/outbound.ts                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let canSendOutboundMessage;
    module.link("@rocket.chat/omni-core-ee", {
      canSendOutboundMessage(v) {
        canSendOutboundMessage = v;
      }
    }, 0);
    let validateBadRequestErrorResponse, validateForbiddenErrorResponse, validateUnauthorizedErrorResponse;
    module.link("@rocket.chat/rest-typings", {
      validateBadRequestErrorResponse(v) {
        validateBadRequestErrorResponse = v;
      },
      validateForbiddenErrorResponse(v) {
        validateForbiddenErrorResponse = v;
      },
      validateUnauthorizedErrorResponse(v) {
        validateUnauthorizedErrorResponse = v;
      }
    }, 1);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 2);
    let GETOutboundProvidersResponseSchema, GETOutboundProviderParamsSchema, GETOutboundProviderBadRequestErrorSchema, GETOutboundProviderMetadataSchema, POSTOutboundMessageParams, POSTOutboundMessageSuccessSchema;
    module.link("../outboundcomms/rest", {
      GETOutboundProvidersResponseSchema(v) {
        GETOutboundProvidersResponseSchema = v;
      },
      GETOutboundProviderParamsSchema(v) {
        GETOutboundProviderParamsSchema = v;
      },
      GETOutboundProviderBadRequestErrorSchema(v) {
        GETOutboundProviderBadRequestErrorSchema = v;
      },
      GETOutboundProviderMetadataSchema(v) {
        GETOutboundProviderMetadataSchema = v;
      },
      POSTOutboundMessageParams(v) {
        POSTOutboundMessageParams = v;
      },
      POSTOutboundMessageSuccessSchema(v) {
        POSTOutboundMessageSuccessSchema = v;
      }
    }, 3);
    let outboundMessageProvider;
    module.link("./lib/outbound", {
      outboundMessageProvider(v) {
        outboundMessageProvider = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const outboundCommsEndpoints = API.v1.get('omnichannel/outbound/providers', {
      response: {
        200: GETOutboundProvidersResponseSchema,
        400: GETOutboundProviderBadRequestErrorSchema,
        401: validateUnauthorizedErrorResponse,
        403: validateForbiddenErrorResponse
      },
      query: GETOutboundProviderParamsSchema,
      permissionsRequired: ['outbound.send-messages'],
      authRequired: true,
      license: ['outbound-messaging']
    }, async function action() {
      const {
        type
      } = this.queryParams;
      const providers = outboundMessageProvider.listOutboundProviders(type);
      return API.v1.success({
        providers
      });
    }).get('omnichannel/outbound/providers/:id/metadata', {
      response: {
        200: GETOutboundProviderMetadataSchema,
        400: GETOutboundProviderBadRequestErrorSchema,
        401: validateUnauthorizedErrorResponse,
        403: validateForbiddenErrorResponse
      },
      permissionsRequired: ['outbound.send-messages'],
      authRequired: true,
      license: ['outbound-messaging']
    }, async function action() {
      const {
        id
      } = this.urlParams;
      const providerMetadata = await outboundMessageProvider.getProviderMetadata(id);
      return API.v1.success({
        metadata: providerMetadata
      });
    }).post('omnichannel/outbound/providers/:id/message', {
      response: {
        200: POSTOutboundMessageSuccessSchema,
        400: validateBadRequestErrorResponse,
        401: validateUnauthorizedErrorResponse,
        403: validateForbiddenErrorResponse
      },
      authRequired: true,
      permissionsRequired: ['outbound.send-messages'],
      body: POSTOutboundMessageParams,
      license: ['outbound-messaging']
    }, async function action() {
      const {
        id
      } = this.urlParams;
      const {
        departmentId,
        agentId
      } = this.bodyParams;
      await canSendOutboundMessage(this.userId, agentId, departmentId);
      await outboundMessageProvider.sendMessage(id, this.bodyParams);
      return API.v1.success();
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"priorities.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/priorities.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let LivechatPriority;
    module.link("@rocket.chat/models", {
      LivechatPriority(v) {
        LivechatPriority = v;
      }
    }, 0);
    let isGETLivechatPrioritiesParams, isPUTLivechatPriority;
    module.link("@rocket.chat/rest-typings", {
      isGETLivechatPrioritiesParams(v) {
        isGETLivechatPrioritiesParams = v;
      },
      isPUTLivechatPriority(v) {
        isPUTLivechatPriority = v;
      }
    }, 1);
    let findPriority, updatePriority;
    module.link("./lib/priorities", {
      findPriority(v) {
        findPriority = v;
      },
      updatePriority(v) {
        updatePriority = v;
      }
    }, 2);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 3);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 4);
    let notifyOnLivechatPriorityChanged;
    module.link("../../../../../app/lib/server/lib/notifyListener", {
      notifyOnLivechatPriorityChanged(v) {
        notifyOnLivechatPriorityChanged = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/priorities', {
      authRequired: true,
      validateParams: isGETLivechatPrioritiesParams,
      permissionsRequired: {
        GET: {
          permissions: ['manage-livechat-priorities', 'view-l-room'],
          operation: 'hasAny'
        }
      },
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          sort
        } = await this.parseJsonQuery();
        const {
          text
        } = this.queryParams;
        return API.v1.success(await findPriority({
          text,
          pagination: {
            offset,
            count,
            sort
          }
        }));
      }
    });
    API.v1.addRoute('livechat/priorities/:priorityId', {
      authRequired: true,
      permissionsRequired: {
        GET: {
          permissions: ['manage-livechat-priorities', 'view-l-room'],
          operation: 'hasAny'
        },
        PUT: {
          permissions: ['manage-livechat-priorities'],
          operation: 'hasAny'
        }
      },
      validateParams: {
        PUT: isPUTLivechatPriority
      },
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          priorityId
        } = this.urlParams;
        const priority = await LivechatPriority.findOneById(priorityId);
        if (!priority) {
          return API.v1.notFound("Priority with id ".concat(priorityId, " not found"));
        }
        return API.v1.success(priority);
      },
      async put() {
        const {
          priorityId
        } = this.urlParams;
        await updatePriority(priorityId, this.bodyParams);
        void notifyOnLivechatPriorityChanged(_objectSpread({
          _id: priorityId
        }, this.bodyParams));
        return API.v1.success();
      }
    });
    API.v1.addRoute('livechat/priorities.reset', {
      authRequired: true,
      permissionsRequired: {
        POST: {
          permissions: ['manage-livechat-priorities'],
          operation: 'hasAny'
        },
        GET: {
          permissions: ['manage-livechat-priorities'],
          operation: 'hasAny'
        }
      },
      license: ['livechat-enterprise']
    }, {
      async post() {
        if (!(await LivechatPriority.canResetPriorities())) {
          return API.v1.failure();
        }
        const eligiblePriorities = (await LivechatPriority.findByDirty().toArray()).map(_ref => {
          let {
            _id
          } = _ref;
          return _id;
        });
        await LivechatPriority.resetPriorities(eligiblePriorities);
        eligiblePriorities.forEach(_id => notifyOnLivechatPriorityChanged({
          _id,
          name: undefined
        }));
        return API.v1.success();
      },
      async get() {
        return API.v1.success({
          reset: await LivechatPriority.canResetPriorities()
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"reports.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/reports.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let isGETDashboardConversationsByType;
    module.link("@rocket.chat/rest-typings", {
      isGETDashboardConversationsByType(v) {
        isGETDashboardConversationsByType = v;
      }
    }, 0);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 1);
    let findAllConversationsBySourceCached, findAllConversationsByStatusCached, findAllConversationsByDepartmentCached, findAllConversationsByTagsCached, findAllConversationsByAgentsCached;
    module.link("./lib/dashboards", {
      findAllConversationsBySourceCached(v) {
        findAllConversationsBySourceCached = v;
      },
      findAllConversationsByStatusCached(v) {
        findAllConversationsByStatusCached = v;
      },
      findAllConversationsByDepartmentCached(v) {
        findAllConversationsByDepartmentCached = v;
      },
      findAllConversationsByTagsCached(v) {
        findAllConversationsByTagsCached = v;
      },
      findAllConversationsByAgentsCached(v) {
        findAllConversationsByAgentsCached = v;
      }
    }, 2);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 3);
    let restrictQuery;
    module.link("../lib/restrictQuery", {
      restrictQuery(v) {
        restrictQuery = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const checkDates = (start, end) => {
      if (!start.isValid()) {
        throw new Error('The "start" query parameter must be a valid date.');
      }
      if (!end.isValid()) {
        throw new Error('The "end" query parameter must be a valid date.');
      }
      // Check dates are no more than 1 year apart using moment
      // 1.01 === "we allow to pass year by some hours/days"
      if (moment(end).startOf('day').diff(moment(start).startOf('day'), 'year', true) > 1.01) {
        throw new Error('The "start" and "end" query parameters must be less than 1 year apart.');
      }
      if (start.isAfter(end)) {
        throw new Error('The "start" query parameter must be before the "end" query parameter.');
      }
    };
    API.v1.addRoute('livechat/analytics/dashboards/conversations-by-source', {
      authRequired: true,
      permissionsRequired: ['view-livechat-reports'],
      validateParams: isGETDashboardConversationsByType,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          start,
          end
        } = this.queryParams;
        const startDate = moment(start);
        const endDate = moment(end);
        checkDates(startDate, endDate);
        const extraQuery = await restrictQuery({
          userId: this.userId
        });
        const result = await findAllConversationsBySourceCached({
          start: startDate.toDate(),
          end: endDate.toDate(),
          extraQuery
        });
        return API.v1.success(result);
      }
    });
    API.v1.addRoute('livechat/analytics/dashboards/conversations-by-status', {
      authRequired: true,
      permissionsRequired: ['view-livechat-reports'],
      validateParams: isGETDashboardConversationsByType,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          start,
          end
        } = this.queryParams;
        const startDate = moment(start);
        const endDate = moment(end);
        checkDates(startDate, endDate);
        const extraQuery = await restrictQuery({
          userId: this.userId
        });
        const result = await findAllConversationsByStatusCached({
          start: startDate.toDate(),
          end: endDate.toDate(),
          extraQuery
        });
        return API.v1.success(result);
      }
    });
    API.v1.addRoute('livechat/analytics/dashboards/conversations-by-department', {
      authRequired: true,
      permissionsRequired: ['view-livechat-reports'],
      validateParams: isGETDashboardConversationsByType,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          start,
          end
        } = this.queryParams;
        const {
          sort
        } = await this.parseJsonQuery();
        const startDate = moment(start);
        const endDate = moment(end);
        checkDates(startDate, endDate);
        const extraQuery = await restrictQuery({
          userId: this.userId
        });
        const result = await findAllConversationsByDepartmentCached({
          start: startDate.toDate(),
          end: endDate.toDate(),
          sort,
          extraQuery
        });
        return API.v1.success(result);
      }
    });
    API.v1.addRoute('livechat/analytics/dashboards/conversations-by-tags', {
      authRequired: true,
      permissionsRequired: ['view-livechat-reports'],
      validateParams: isGETDashboardConversationsByType,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          start,
          end
        } = this.queryParams;
        const {
          sort
        } = await this.parseJsonQuery();
        const startDate = moment(start);
        const endDate = moment(end);
        checkDates(startDate, endDate);
        const extraQuery = await restrictQuery({
          userId: this.userId
        });
        const result = await findAllConversationsByTagsCached({
          start: startDate.toDate(),
          end: endDate.toDate(),
          sort,
          extraQuery
        });
        return API.v1.success(result);
      }
    });
    API.v1.addRoute('livechat/analytics/dashboards/conversations-by-agent', {
      authRequired: true,
      permissionsRequired: ['view-livechat-reports'],
      validateParams: isGETDashboardConversationsByType,
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          start,
          end
        } = this.queryParams;
        const {
          sort
        } = await this.parseJsonQuery();
        const startDate = moment(start);
        const endDate = moment(end);
        checkDates(startDate, endDate);
        const extraQuery = await restrictQuery({
          userId: this.userId
        });
        const result = await findAllConversationsByAgentsCached({
          start: startDate.toDate(),
          end: endDate.toDate(),
          sort,
          extraQuery
        });
        return API.v1.success(result);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"rooms.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/rooms.ts                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let OmnichannelEEService;
    module.link("@rocket.chat/core-services", {
      OmnichannelEEService(v) {
        OmnichannelEEService = v;
      }
    }, 0);
    let LivechatRooms, Subscriptions;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      Subscriptions(v) {
        Subscriptions = v;
      }
    }, 1);
    let isLivechatRoomOnHoldProps, isLivechatRoomResumeOnHoldProps, isPOSTLivechatRoomPriorityParams;
    module.link("@rocket.chat/rest-typings", {
      isLivechatRoomOnHoldProps(v) {
        isLivechatRoomOnHoldProps = v;
      },
      isLivechatRoomResumeOnHoldProps(v) {
        isLivechatRoomResumeOnHoldProps = v;
      },
      isPOSTLivechatRoomPriorityParams(v) {
        isPOSTLivechatRoomPriorityParams = v;
      }
    }, 2);
    let removePriorityFromRoom, updateRoomPriority;
    module.link("./lib/priorities", {
      removePriorityFromRoom(v) {
        removePriorityFromRoom = v;
      },
      updateRoomPriority(v) {
        updateRoomPriority = v;
      }
    }, 3);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 4);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 5);
    let i18n;
    module.link("../../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/room.onHold', {
      authRequired: true,
      permissionsRequired: ['on-hold-livechat-room'],
      validateParams: isLivechatRoomOnHoldProps,
      license: ['livechat-enterprise']
    }, {
      async post() {
        const {
          roomId
        } = this.bodyParams;
        const room = await LivechatRooms.findOneById(roomId, {
          projection: {
            _id: 1,
            t: 1,
            open: 1,
            onHold: 1,
            u: 1,
            lastMessage: 1,
            servedBy: 1
          }
        });
        if (!room) {
          throw new Error('error-invalid-room');
        }
        const subscription = await Subscriptions.findOneByRoomIdAndUserId(roomId, this.userId, {
          projection: {
            _id: 1
          }
        });
        if (!subscription && !(await hasPermissionAsync(this.userId, 'on-hold-others-livechat-room'))) {
          throw new Error('Not_authorized');
        }
        const onHoldBy = {
          _id: this.userId,
          username: this.user.username,
          name: this.user.name
        };
        const comment = i18n.t('Omnichannel_On_Hold_manually', {
          user: onHoldBy.name || "@".concat(onHoldBy.username)
        });
        await OmnichannelEEService.placeRoomOnHold(room, comment, this.user);
        return API.v1.success();
      }
    });
    API.v1.addRoute('livechat/room.resumeOnHold', {
      authRequired: true,
      permissionsRequired: ['view-l-room'],
      validateParams: isLivechatRoomResumeOnHoldProps,
      license: ['livechat-enterprise']
    }, {
      async post() {
        const {
          roomId
        } = this.bodyParams;
        if (!roomId || roomId.trim() === '') {
          throw new Error('invalid-param');
        }
        const room = await LivechatRooms.findOneById(roomId, {
          projection: {
            t: 1,
            open: 1,
            onHold: 1,
            servedBy: 1
          }
        });
        if (!room) {
          throw new Error('error-invalid-room');
        }
        const subscription = await Subscriptions.findOneByRoomIdAndUserId(roomId, this.userId, {
          projection: {
            _id: 1
          }
        });
        if (!subscription && !(await hasPermissionAsync(this.userId, 'on-hold-others-livechat-room'))) {
          throw new Error('Not_authorized');
        }
        const {
          name,
          username,
          _id: userId
        } = this.user;
        const onHoldBy = {
          _id: userId,
          username,
          name
        };
        const comment = i18n.t('Omnichannel_on_hold_chat_resumed_manually', {
          user: onHoldBy.name || "@".concat(onHoldBy.username)
        });
        await OmnichannelEEService.resumeRoomOnHold(room, comment, this.user, true);
        return API.v1.success();
      }
    });
    API.v1.addRoute('livechat/room/:rid/priority', {
      authRequired: true,
      validateParams: {
        POST: isPOSTLivechatRoomPriorityParams
      },
      permissionsRequired: {
        POST: {
          permissions: ['view-l-room'],
          operation: 'hasAny'
        },
        DELETE: {
          permissions: ['view-l-room'],
          operation: 'hasAny'
        }
      },
      license: ['livechat-enterprise']
    }, {
      async post() {
        const {
          rid
        } = this.urlParams;
        const {
          priorityId
        } = this.bodyParams;
        if (!this.user.username) {
          return API.v1.failure('Invalid user');
        }
        await updateRoomPriority(rid, {
          _id: this.user._id,
          name: this.user.name || '',
          username: this.user.username
        }, priorityId);
        return API.v1.success();
      },
      async delete() {
        const {
          rid
        } = this.urlParams;
        if (!this.user.username) {
          return API.v1.failure('Invalid user');
        }
        await removePriorityFromRoom(rid, {
          _id: this.user._id,
          name: this.user.name || '',
          username: this.user.username
        });
        return API.v1.success();
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"sla.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/sla.ts                                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let OmnichannelServiceLevelAgreements;
    module.link("@rocket.chat/models", {
      OmnichannelServiceLevelAgreements(v) {
        OmnichannelServiceLevelAgreements = v;
      }
    }, 0);
    let isLivechatPrioritiesProps, isCreateOrUpdateLivechatSlaProps;
    module.link("@rocket.chat/rest-typings", {
      isLivechatPrioritiesProps(v) {
        isLivechatPrioritiesProps = v;
      },
      isCreateOrUpdateLivechatSlaProps(v) {
        isCreateOrUpdateLivechatSlaProps = v;
      }
    }, 1);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 2);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 3);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 4);
    let findSLA;
    module.link("./lib/sla", {
      findSLA(v) {
        findSLA = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/sla', {
      authRequired: true,
      permissionsRequired: {
        GET: {
          permissions: ['manage-livechat-sla', 'view-l-room'],
          operation: 'hasAny'
        },
        POST: {
          permissions: ['manage-livechat-sla'],
          operation: 'hasAny'
        }
      },
      validateParams: {
        GET: isLivechatPrioritiesProps,
        POST: isCreateOrUpdateLivechatSlaProps
      },
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          sort
        } = await this.parseJsonQuery();
        const {
          text
        } = this.queryParams;
        return API.v1.success(await findSLA({
          text,
          pagination: {
            offset,
            count,
            sort
          }
        }));
      },
      async post() {
        const {
          name,
          description,
          dueTimeInMinutes
        } = this.bodyParams;
        const newSla = await LivechatEnterprise.saveSLA(null, {
          name,
          description,
          dueTimeInMinutes
        }, this.userId);
        return API.v1.success({
          sla: newSla
        });
      }
    });
    API.v1.addRoute('livechat/sla/:slaId', {
      authRequired: true,
      permissionsRequired: {
        GET: {
          permissions: ['manage-livechat-sla', 'view-l-room'],
          operation: 'hasAny'
        },
        DELETE: {
          permissions: ['manage-livechat-sla'],
          operation: 'hasAny'
        },
        PUT: {
          permissions: ['manage-livechat-sla'],
          operation: 'hasAny'
        }
      },
      validateParams: {
        PUT: isCreateOrUpdateLivechatSlaProps
      },
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          slaId
        } = this.urlParams;
        const sla = await OmnichannelServiceLevelAgreements.findOneById(slaId);
        if (!sla) {
          return API.v1.notFound("SLA with id ".concat(slaId, " not found"));
        }
        return API.v1.success(sla);
      },
      async delete() {
        const {
          slaId
        } = this.urlParams;
        await LivechatEnterprise.removeSLA(this.userId, slaId);
        return API.v1.success();
      },
      async put() {
        const {
          name,
          description,
          dueTimeInMinutes
        } = this.bodyParams;
        const {
          slaId
        } = this.urlParams;
        const updatedSla = await LivechatEnterprise.saveSLA(slaId, {
          name,
          description,
          dueTimeInMinutes
        }, this.userId);
        return API.v1.success({
          sla: updatedSla
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"tags.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/tags.ts                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let isPOSTLivechatTagsRemoveParams, POSTLivechatTagsRemoveSuccessResponse, validateBadRequestErrorResponse, validateForbiddenErrorResponse, validateUnauthorizedErrorResponse;
    module.link("@rocket.chat/rest-typings", {
      isPOSTLivechatTagsRemoveParams(v) {
        isPOSTLivechatTagsRemoveParams = v;
      },
      POSTLivechatTagsRemoveSuccessResponse(v) {
        POSTLivechatTagsRemoveSuccessResponse = v;
      },
      validateBadRequestErrorResponse(v) {
        validateBadRequestErrorResponse = v;
      },
      validateForbiddenErrorResponse(v) {
        validateForbiddenErrorResponse = v;
      },
      validateUnauthorizedErrorResponse(v) {
        validateUnauthorizedErrorResponse = v;
      }
    }, 0);
    let findTags, findTagById;
    module.link("./lib/tags", {
      findTags(v) {
        findTags = v;
      },
      findTagById(v) {
        findTagById = v;
      }
    }, 1);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 2);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 3);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/tags', {
      authRequired: true,
      permissionsRequired: {
        GET: {
          permissions: ['view-l-room', 'manage-livechat-tags'],
          operation: 'hasAny'
        }
      },
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          sort
        } = await this.parseJsonQuery();
        const {
          text,
          viewAll,
          department
        } = this.queryParams;
        return API.v1.success(await findTags({
          userId: this.userId,
          text,
          department,
          viewAll: viewAll === 'true',
          pagination: {
            offset,
            count,
            sort: typeof sort === 'string' ? JSON.parse(sort || '{}') : sort
          }
        }));
      }
    });
    API.v1.addRoute('livechat/tags/:tagId', {
      authRequired: true,
      permissionsRequired: {
        GET: {
          permissions: ['view-l-room', 'manage-livechat-tags'],
          operation: 'hasAny'
        }
      },
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          tagId
        } = this.urlParams;
        const tag = await findTagById({
          userId: this.userId,
          tagId
        });
        if (!tag) {
          return API.v1.notFound('Tag not found');
        }
        return API.v1.success(tag);
      }
    });
    const livechatTagsEndpoints = API.v1.post('livechat/tags.delete', {
      response: {
        200: POSTLivechatTagsRemoveSuccessResponse,
        400: validateBadRequestErrorResponse,
        401: validateUnauthorizedErrorResponse,
        403: validateForbiddenErrorResponse
      },
      authRequired: true,
      permissions: ['manage-livechat-tags'],
      license: ['livechat-enterprise'],
      body: isPOSTLivechatTagsRemoveParams
    }, async function action() {
      const {
        id
      } = this.bodyParams;
      try {
        await LivechatEnterprise.removeTag(id);
        return API.v1.success();
      } catch (error) {
        if (error instanceof Meteor.Error) {
          return API.v1.failure(error.reason);
        }
        return API.v1.failure('error-removing-tag');
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"transcript.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/transcript.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatRooms;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      }
    }, 0);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    let canAccessRoomAsync;
    module.link("../../../../../app/authorization/server/functions/canAccessRoom", {
      canAccessRoomAsync(v) {
        canAccessRoomAsync = v;
      }
    }, 2);
    let requestPdfTranscript;
    module.link("../lib/requestPdfTranscript", {
      requestPdfTranscript(v) {
        requestPdfTranscript = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('omnichannel/:rid/request-transcript', {
      authRequired: true,
      permissionsRequired: ['request-pdf-transcript'],
      license: ['livechat-enterprise']
    }, {
      async post() {
        const room = await LivechatRooms.findOneById(this.urlParams.rid, {
          projection: {
            _id: 1,
            open: 1,
            v: 1,
            t: 1,
            pdfTranscriptFileId: 1
          }
        });
        if (!room) {
          throw new Error('error-invalid-room');
        }
        if (!(await canAccessRoomAsync(room, {
          _id: this.userId
        }))) {
          throw new Error('error-not-allowed');
        }
        // Flow is as follows:
        // 1. On Test Mode, call Transcript.workOnPdf directly
        // 2. On Normal Mode, call QueueWorker.queueWork to queue the work
        // 3. OmnichannelTranscript.workOnPdf will be called by the worker to generate the transcript
        // 4. We be happy :)
        await requestPdfTranscript(room, this.userId);
        return API.v1.success();
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"triggers.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/triggers.ts                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let isExternalServiceTrigger;
    module.link("@rocket.chat/core-typings", {
      isExternalServiceTrigger(v) {
        isExternalServiceTrigger = v;
      }
    }, 0);
    let LivechatTrigger;
    module.link("@rocket.chat/models", {
      LivechatTrigger(v) {
        LivechatTrigger = v;
      }
    }, 1);
    let isLivechatTriggerWebhookCallParams;
    module.link("@rocket.chat/rest-typings", {
      isLivechatTriggerWebhookCallParams(v) {
        isLivechatTriggerWebhookCallParams = v;
      }
    }, 2);
    let isLivechatTriggerWebhookTestParams;
    module.link("@rocket.chat/rest-typings/src/v1/omnichannel", {
      isLivechatTriggerWebhookTestParams(v) {
        isLivechatTriggerWebhookTestParams = v;
      }
    }, 3);
    let callTriggerExternalService;
    module.link("./lib/triggers", {
      callTriggerExternalService(v) {
        callTriggerExternalService = v;
      }
    }, 4);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 5);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/triggers/external-service/test', {
      authRequired: true,
      permissionsRequired: ['view-livechat-manager'],
      validateParams: isLivechatTriggerWebhookTestParams,
      rateLimiterOptions: {
        numRequestsAllowed: 15,
        intervalTimeInMS: 60000
      },
      license: ['livechat-enterprise']
    }, {
      async post() {
        const {
          webhookUrl,
          timeout,
          fallbackMessage,
          extraData: clientParams
        } = this.bodyParams;
        const token = settings.get('Livechat_secret_token');
        if (!token) {
          throw new Error('Livechat secret token is not configured');
        }
        const body = {
          metadata: clientParams,
          visitorToken: '1234567890'
        };
        const headers = {
          'Accept': 'application/json',
          'Content-Type': 'application/json',
          'X-RocketChat-Livechat-Token': token
        };
        const response = await callTriggerExternalService({
          url: webhookUrl,
          timeout,
          fallbackMessage,
          body,
          headers
        });
        if (response.error) {
          return API.v1.failure(_objectSpread({
            triggerId: 'test-trigger'
          }, response));
        }
        return API.v1.success(_objectSpread({
          triggerId: 'test-trigger'
        }, response));
      }
    });
    API.v1.addRoute('livechat/triggers/:_id/external-service/call', {
      authRequired: false,
      rateLimiterOptions: {
        numRequestsAllowed: 10,
        intervalTimeInMS: 60000
      },
      validateParams: isLivechatTriggerWebhookCallParams,
      license: ['livechat-enterprise']
    }, {
      async post() {
        const {
          _id: triggerId
        } = this.urlParams;
        const {
          token: visitorToken,
          extraData
        } = this.bodyParams;
        const trigger = await LivechatTrigger.findOneById(triggerId);
        if (!trigger) {
          throw new Error('Invalid trigger');
        }
        if (!(trigger !== null && trigger !== void 0 && trigger.actions.length) || !isExternalServiceTrigger(trigger)) {
          throw new Error('Trigger is not configured to use an external service');
        }
        const {
          params: {
            serviceTimeout = 5000,
            serviceUrl,
            serviceFallbackMessage = 'trigger-default-fallback-message'
          } = {}
        } = trigger.actions[0];
        if (!serviceUrl) {
          throw new Error('Invalid service URL');
        }
        const token = settings.get('Livechat_secret_token');
        if (!token) {
          throw new Error('Livechat secret token is not configured');
        }
        const body = {
          metadata: extraData,
          visitorToken
        };
        const headers = {
          'Accept': 'application/json',
          'Content-Type': 'application/json',
          'X-RocketChat-Livechat-Token': token
        };
        const response = await callTriggerExternalService({
          url: serviceUrl,
          timeout: serviceTimeout,
          fallbackMessage: serviceFallbackMessage,
          body,
          headers
        });
        if (response.error) {
          return API.v1.failure(_objectSpread({
            triggerId
          }, response));
        }
        return API.v1.success(_objectSpread({
          triggerId
        }, response));
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"units.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/api/units.ts                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 0);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 1);
    let findAllDepartmentsAvailable, findAllDepartmentsByUnit;
    module.link("../lib/Department", {
      findAllDepartmentsAvailable(v) {
        findAllDepartmentsAvailable = v;
      },
      findAllDepartmentsByUnit(v) {
        findAllDepartmentsByUnit = v;
      }
    }, 2);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 3);
    let findUnits, findUnitById, findUnitMonitors, findUnitsOfUser;
    module.link("./lib/units", {
      findUnits(v) {
        findUnits = v;
      },
      findUnitById(v) {
        findUnitById = v;
      },
      findUnitMonitors(v) {
        findUnitMonitors = v;
      },
      findUnitsOfUser(v) {
        findUnitsOfUser = v;
      }
    }, 4);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('livechat/units/:unitId/monitors', {
      authRequired: true,
      permissionsRequired: ['manage-livechat-monitors'],
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          unitId
        } = this.urlParams;
        if (!unitId) {
          return API.v1.failure('The "unitId" parameter is required');
        }
        return API.v1.success({
          monitors: await findUnitMonitors({
            unitId
          })
        });
      }
    });
    API.v1.addRoute('livechat/units', {
      authRequired: true,
      permissionsRequired: {
        POST: ['manage-livechat-units'],
        GET: []
      },
      license: ['livechat-enterprise']
    }, {
      async get() {
        const params = this.queryParams;
        const {
          offset,
          count
        } = await getPaginationItems(params);
        const {
          sort
        } = await this.parseJsonQuery();
        const {
          text
        } = this.queryParams;
        if (!(await hasPermissionAsync(this.userId, 'manage-livechat-units'))) {
          return API.v1.success(await findUnitsOfUser({
            text,
            userId: this.userId,
            pagination: {
              offset,
              count,
              sort
            }
          }));
        }
        return API.v1.success(await findUnits({
          text,
          pagination: {
            offset,
            count,
            sort
          }
        }));
      },
      async post() {
        const {
          unitData,
          unitMonitors,
          unitDepartments
        } = this.bodyParams;
        return API.v1.success(await LivechatEnterprise.saveUnit(null, unitData, unitMonitors, unitDepartments, this.userId));
      }
    });
    API.v1.addRoute('livechat/units/:id', {
      authRequired: true,
      permissionsRequired: ['manage-livechat-units'],
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          id
        } = this.urlParams;
        const unit = await findUnitById({
          unitId: id,
          userId: this.userId
        });
        return API.v1.success(unit);
      },
      async post() {
        const {
          unitData,
          unitMonitors,
          unitDepartments
        } = this.bodyParams;
        const {
          id
        } = this.urlParams;
        return API.v1.success(await LivechatEnterprise.saveUnit(id, unitData, unitMonitors, unitDepartments, this.userId));
      },
      async delete() {
        const {
          id
        } = this.urlParams;
        return API.v1.success((await LivechatEnterprise.removeUnit(id, this.userId)).deletedCount);
      }
    });
    API.v1.addRoute('livechat/units/:unitId/departments', {
      authRequired: true,
      permissionsRequired: ['manage-livechat-units'],
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          unitId
        } = this.urlParams;
        const {
          departments,
          total
        } = await findAllDepartmentsByUnit(unitId, offset, count);
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    API.v1.addRoute('livechat/units/:unitId/departments/available', {
      authRequired: true,
      permissionsRequired: ['manage-livechat-units'],
      license: ['livechat-enterprise']
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          unitId
        } = this.urlParams;
        const {
          text,
          onlyMyDepartments
        } = this.queryParams;
        const {
          departments,
          total
        } = await findAllDepartmentsAvailable(this.userId, unitId, offset, count, text, onlyMyDepartments === 'true');
        return API.v1.success({
          departments,
          count: departments.length,
          offset,
          total
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"business-hour":{"lib":{"business-hour.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/business-hour/lib/business-hour.ts                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      findBusinessHours: () => findBusinessHours
    });
    let LivechatBusinessHours, LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatBusinessHours(v) {
        LivechatBusinessHours = v;
      },
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 0);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 1);
    let hasPermissionAsync;
    module.link("../../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function findBusinessHours(userId, _ref, name) {
      let {
        offset,
        count,
        sort
      } = _ref;
      if (!(await hasPermissionAsync(userId, 'view-livechat-business-hours'))) {
        throw new Error('error-not-authorized');
      }
      const query = {};
      if (name) {
        const filterReg = new RegExp(escapeRegExp(name), 'i');
        Object.assign(query, {
          name: filterReg
        });
      }
      const {
        cursor,
        totalCount
      } = LivechatBusinessHours.findPaginated(query, {
        sort: sort || {
          name: 1
        },
        skip: offset,
        limit: count
      });
      const [businessHours, total] = await Promise.all([cursor.toArray(), totalCount]);
      // add departments to businessHours
      const businessHoursWithDepartments = await Promise.all(businessHours.map(async businessHour => {
        const currentDepartments = await LivechatDepartment.findByBusinessHourId(businessHour._id, {
          projection: {
            _id: 1
          }
        }).toArray();
        if (currentDepartments.length) {
          businessHour.departments = currentDepartments;
        }
        return businessHour;
      }));
      return {
        businessHours: businessHoursWithDepartments,
        count: businessHours.length,
        offset,
        total
      };
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"Custom.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/business-hour/Custom.ts                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let _objectWithoutProperties;
    module.link("@babel/runtime/helpers/objectWithoutProperties", {
      default(v) {
        _objectWithoutProperties = v;
      }
    }, 1);
    const _excluded = ["timezoneName", "departmentsToApplyBusinessHour"];
    let LivechatBusinessHourTypes;
    module.link("@rocket.chat/core-typings", {
      LivechatBusinessHourTypes(v) {
        LivechatBusinessHourTypes = v;
      }
    }, 0);
    let LivechatDepartment, LivechatDepartmentAgents, Users;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      LivechatDepartmentAgents(v) {
        LivechatDepartmentAgents = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let businessHourManager;
    module.link("../../../../../app/livechat/server/business-hour", {
      businessHourManager(v) {
        businessHourManager = v;
      }
    }, 2);
    let AbstractBusinessHourType;
    module.link("../../../../../app/livechat/server/business-hour/AbstractBusinessHour", {
      AbstractBusinessHourType(v) {
        AbstractBusinessHourType = v;
      }
    }, 3);
    let filterBusinessHoursThatMustBeOpened, makeAgentsUnavailableBasedOnBusinessHour;
    module.link("../../../../../app/livechat/server/business-hour/Helper", {
      filterBusinessHoursThatMustBeOpened(v) {
        filterBusinessHoursThatMustBeOpened = v;
      },
      makeAgentsUnavailableBasedOnBusinessHour(v) {
        makeAgentsUnavailableBasedOnBusinessHour = v;
      }
    }, 4);
    let bhLogger;
    module.link("../lib/logger", {
      bhLogger(v) {
        bhLogger = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class CustomBusinessHour extends AbstractBusinessHourType {
      constructor() {
        super(...arguments);
        this.name = LivechatBusinessHourTypes.CUSTOM;
      }
      async getBusinessHour(id) {
        if (!id) {
          return null;
        }
        const businessHour = await this.BusinessHourRepository.findOneById(id);
        if (!businessHour) {
          return null;
        }
        businessHour.departments = await LivechatDepartment.findByBusinessHourId(businessHour._id, {
          projection: {
            name: 1
          }
        }).toArray();
        return businessHour;
      }
      async saveBusinessHour(businessHour) {
        const existingBusinessHour = await this.BusinessHourRepository.findOne({
          name: businessHour.name
        }, {
          projection: {
            _id: 1
          }
        });
        if (existingBusinessHour && existingBusinessHour._id !== businessHour._id) {
          throw new Error('error-business-hour-name-already-in-use');
        }
        const {
            timezoneName,
            departmentsToApplyBusinessHour
          } = businessHour,
          businessHourData = _objectWithoutProperties(businessHour, _excluded);
        businessHourData.timezone = {
          name: timezoneName,
          utc: this.getUTCFromTimezone(timezoneName)
        };
        const departments = (departmentsToApplyBusinessHour === null || departmentsToApplyBusinessHour === void 0 ? void 0 : departmentsToApplyBusinessHour.split(',').filter(Boolean)) || [];
        const businessHourToReturn = _objectSpread(_objectSpread({}, businessHourData), {}, {
          departmentsToApplyBusinessHour
        });
        delete businessHourData.departments;
        const businessHourId = await this.baseSaveBusinessHour(businessHourData);
        const currentDepartments = (await LivechatDepartment.findByBusinessHourId(businessHourId, {
          projection: {
            _id: 1
          }
        }).toArray()).map(dept => dept._id);
        const toRemove = [...currentDepartments.filter(dept => !departments.includes(dept))];
        const toAdd = [...departments.filter(dept => !currentDepartments.includes(dept))];
        await this.removeBusinessHourFromDepartmentsIfNeeded(businessHourId, toRemove);
        // Now will check if the department which we're currently adding to BH is not
        // associated with any other BH. If it is, then it will remove the old BH from all user's
        // cache. It will not add the new BH right now as it will be done in afterSaveBusinessHour.
        await this.removeBHFromPreviouslyConnectedDepartmentAgentsIfRequired(toAdd);
        await this.addBusinessHourToDepartmentsIfNeeded(businessHourId, toAdd);
        businessHourToReturn._id = businessHourId;
        return businessHourToReturn;
      }
      async removeBusinessHourById(businessHourId) {
        const businessHour = await this.BusinessHourRepository.findOneById(businessHourId, {});
        if (!businessHour) {
          return;
        }
        await this.BusinessHourRepository.removeById(businessHourId);
        await this.removeBusinessHourFromAgents(businessHourId);
        await LivechatDepartment.removeBusinessHourFromDepartmentsByBusinessHourId(businessHourId);
        await makeAgentsUnavailableBasedOnBusinessHour();
      }
      async removeBusinessHourFromAgents(businessHourId) {
        const departmentIds = (await LivechatDepartment.findByBusinessHourId(businessHourId, {
          projection: {
            _id: 1
          }
        }).toArray()).map(dept => dept._id);
        const agentIds = (await LivechatDepartmentAgents.findByDepartmentIds(departmentIds, {
          projection: {
            agentId: 1
          }
        }).toArray()).map(dept => dept.agentId);
        this.UsersRepository.removeBusinessHourByAgentIds(agentIds, businessHourId);
      }
      async removeBusinessHourFromDepartmentsIfNeeded(businessHourId, departmentsToRemove) {
        if (!departmentsToRemove.length) {
          return;
        }
        await LivechatDepartment.removeBusinessHourFromDepartmentsByIdsAndBusinessHourId(departmentsToRemove, businessHourId);
      }
      async removeBHFromPreviouslyConnectedDepartmentAgentsIfRequired(departmentIds) {
        // we need to do 2 things here.
        // 1st is to check if any of the departments are associated with any BH. If they are, then we need to remove
        // that BH from all agents of that department.
        // 2nd is to check if any of the departments are not associated with BH, meaning default BH
        // is applied. So if default BH is open, then we need to remove it from all agents of that department.
        const bhIdsConnectedToDepartment = [];
        const departmentsWithoutBH = [];
        const departments = await LivechatDepartment.findInIds(departmentIds, {
          projection: {
            businessHourId: 1
          }
        }).toArray();
        for (const dept of departments) {
          if (dept !== null && dept !== void 0 && dept.businessHourId) {
            bhIdsConnectedToDepartment.push(dept.businessHourId);
          } else {
            departmentsWithoutBH.push(dept._id);
          }
        }
        await Users.closeAgentsBusinessHoursByBusinessHourIds(bhIdsConnectedToDepartment);
        // start of step 2
        const defaultBusinessHour = await this.BusinessHourRepository.findOneDefaultBusinessHour();
        if (!defaultBusinessHour) {
          bhLogger.error('No default business hour found');
          return;
        }
        const isDefaultBHActive = (await filterBusinessHoursThatMustBeOpened([defaultBusinessHour])).length > 0;
        if (!isDefaultBHActive) {
          bhLogger.debug('Default business hour is not active. No need to remove it from agents');
          return;
        }
        const agentsConnectedToDefaultBH = await (await LivechatDepartmentAgents.findByDepartmentIds(departmentIds, {
          projection: {
            agentId: 1
          }
        }).toArray()).map(dept => dept.agentId);
        await Users.removeBusinessHourByAgentIds(agentsConnectedToDefaultBH, defaultBusinessHour._id);
        await makeAgentsUnavailableBasedOnBusinessHour();
      }
      async addBusinessHourToDepartmentsIfNeeded(businessHourId, departmentsToAdd) {
        if (!departmentsToAdd.length) {
          return;
        }
        await LivechatDepartment.addBusinessHourToDepartmentsByIds(departmentsToAdd, businessHourId);
      }
    }
    businessHourManager.registerBusinessHourType(new CustomBusinessHour());
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"Helper.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/business-hour/Helper.ts                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      getAgentIdsToHandle: () => getAgentIdsToHandle,
      openBusinessHour: () => openBusinessHour,
      removeBusinessHourByAgentIds: () => removeBusinessHourByAgentIds
    });
    let LivechatBusinessHourTypes;
    module.link("@rocket.chat/core-typings", {
      LivechatBusinessHourTypes(v) {
        LivechatBusinessHourTypes = v;
      }
    }, 0);
    let LivechatDepartment, LivechatDepartmentAgents, Users;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      LivechatDepartmentAgents(v) {
        LivechatDepartmentAgents = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let makeAgentsUnavailableBasedOnBusinessHour, makeOnlineAgentsAvailable;
    module.link("../../../../../app/livechat/server/business-hour/Helper", {
      makeAgentsUnavailableBasedOnBusinessHour(v) {
        makeAgentsUnavailableBasedOnBusinessHour = v;
      },
      makeOnlineAgentsAvailable(v) {
        makeOnlineAgentsAvailable = v;
      }
    }, 2);
    let getAgentIdsForBusinessHour;
    module.link("../../../../../app/livechat/server/business-hour/getAgentIdsForBusinessHour", {
      getAgentIdsForBusinessHour(v) {
        getAgentIdsForBusinessHour = v;
      }
    }, 3);
    let businessHourLogger;
    module.link("../../../../../app/livechat/server/lib/logger", {
      businessHourLogger(v) {
        businessHourLogger = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const getAgentIdsToHandle = async businessHour => {
      if (businessHour.type === LivechatBusinessHourTypes.DEFAULT) {
        return getAgentIdsForBusinessHour();
      }
      const departmentIds = (await LivechatDepartment.findEnabledByBusinessHourId(businessHour._id, {
        projection: {
          _id: 1
        }
      }).toArray()).map(dept => dept._id);
      return (await LivechatDepartmentAgents.findByDepartmentIds(departmentIds, {
        projection: {
          agentId: 1
        }
      }).toArray()).map(dept => dept.agentId);
    };
    const openBusinessHour = async function (businessHour) {
      let updateLivechatStatus = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      const agentIds = await getAgentIdsToHandle(businessHour);
      businessHourLogger.debug({
        msg: 'Opening business hour',
        businessHour: businessHour._id,
        totalAgents: agentIds.length,
        top10AgentIds: agentIds.slice(0, 10)
      });
      await Users.addBusinessHourByAgentIds(agentIds, businessHour._id);
      await makeOnlineAgentsAvailable(agentIds);
      if (updateLivechatStatus) {
        await makeAgentsUnavailableBasedOnBusinessHour();
      }
    };
    const removeBusinessHourByAgentIds = async (agentIds, businessHourId) => {
      if (!agentIds.length) {
        return;
      }
      await Users.removeBusinessHourByAgentIds(agentIds, businessHourId);
      await makeAgentsUnavailableBasedOnBusinessHour();
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"Multiple.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/business-hour/Multiple.ts                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 0);
    module.export({
      MultipleBusinessHoursBehavior: () => MultipleBusinessHoursBehavior
    });
    let LivechatBusinessHourTypes;
    module.link("@rocket.chat/core-typings", {
      LivechatBusinessHourTypes(v) {
        LivechatBusinessHourTypes = v;
      }
    }, 0);
    let LivechatDepartment, LivechatDepartmentAgents, Users;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      LivechatDepartmentAgents(v) {
        LivechatDepartmentAgents = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 2);
    let openBusinessHour, removeBusinessHourByAgentIds;
    module.link("./Helper", {
      openBusinessHour(v) {
        openBusinessHour = v;
      },
      removeBusinessHourByAgentIds(v) {
        removeBusinessHourByAgentIds = v;
      }
    }, 3);
    let businessHourManager;
    module.link("../../../../../app/livechat/server/business-hour", {
      businessHourManager(v) {
        businessHourManager = v;
      }
    }, 4);
    let AbstractBusinessHourBehavior;
    module.link("../../../../../app/livechat/server/business-hour/AbstractBusinessHour", {
      AbstractBusinessHourBehavior(v) {
        AbstractBusinessHourBehavior = v;
      }
    }, 5);
    let filterBusinessHoursThatMustBeOpened, filterBusinessHoursThatMustBeOpenedByDay, makeOnlineAgentsAvailable, makeAgentsUnavailableBasedOnBusinessHour;
    module.link("../../../../../app/livechat/server/business-hour/Helper", {
      filterBusinessHoursThatMustBeOpened(v) {
        filterBusinessHoursThatMustBeOpened = v;
      },
      filterBusinessHoursThatMustBeOpenedByDay(v) {
        filterBusinessHoursThatMustBeOpenedByDay = v;
      },
      makeOnlineAgentsAvailable(v) {
        makeOnlineAgentsAvailable = v;
      },
      makeAgentsUnavailableBasedOnBusinessHour(v) {
        makeAgentsUnavailableBasedOnBusinessHour = v;
      }
    }, 6);
    let closeBusinessHour;
    module.link("../../../../../app/livechat/server/business-hour/closeBusinessHour", {
      closeBusinessHour(v) {
        closeBusinessHour = v;
      }
    }, 7);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 8);
    let isTruthy;
    module.link("../../../../../lib/isTruthy", {
      isTruthy(v) {
        isTruthy = v;
      }
    }, 9);
    let bhLogger;
    module.link("../lib/logger", {
      bhLogger(v) {
        bhLogger = v;
      }
    }, 10);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class MultipleBusinessHoursBehavior extends AbstractBusinessHourBehavior {
      constructor() {
        super();
        this.onAddAgentToDepartment = this.onAddAgentToDepartment.bind(this);
        this.onRemoveAgentFromDepartment = this.onRemoveAgentFromDepartment.bind(this);
        this.onRemoveDepartment = this.onRemoveDepartment.bind(this);
        this.onDepartmentArchived = this.onDepartmentArchived.bind(this);
        this.onDepartmentDisabled = this.onDepartmentDisabled.bind(this);
        this.onNewAgentCreated = this.onNewAgentCreated.bind(this);
      }
      async onStartBusinessHours() {
        await this.UsersRepository.removeBusinessHoursFromAllUsers();
        // TODO is this required? since we're calling `this.openBusinessHour(businessHour)` later on, which will call this again (kinda)
        await makeAgentsUnavailableBasedOnBusinessHour();
        const currentTime = moment.utc(moment().utc().format('dddd:HH:mm'), 'dddd:HH:mm');
        const day = currentTime.format('dddd');
        const activeBusinessHours = await this.BusinessHourRepository.findActiveAndOpenBusinessHoursByDay(day, {
          projection: {
            workHours: 1,
            timezone: 1,
            type: 1,
            active: 1
          }
        });
        const businessHoursToOpen = await filterBusinessHoursThatMustBeOpened(activeBusinessHours);
        bhLogger.info({
          msg: 'Starting Multiple Business Hours',
          totalBusinessHoursToOpen: businessHoursToOpen.length,
          top10BusinessHoursToOpen: businessHoursToOpen.slice(0, 10)
        });
        for (const businessHour of businessHoursToOpen) {
          void this.openBusinessHour(businessHour);
        }
      }
      async openBusinessHoursByDayAndHour(day, hour) {
        const businessHours = await this.BusinessHourRepository.findActiveBusinessHoursToOpen(day, hour, undefined, {
          projection: {
            _id: 1,
            type: 1
          }
        });
        for (const businessHour of businessHours) {
          void this.openBusinessHour(businessHour);
        }
      }
      async closeBusinessHoursByDayAndHour(day, hour) {
        const businessHours = await this.BusinessHourRepository.findActiveBusinessHoursToClose(day, hour, undefined, {
          projection: {
            _id: 1,
            type: 1
          }
        });
        for (const businessHour of businessHours) {
          void this.closeBusinessHour(businessHour);
        }
      }
      async afterSaveBusinessHours(businessHourData) {
        var _businessHourData$dep, _businessHourData$dep2;
        const departments = (_businessHourData$dep = businessHourData.departmentsToApplyBusinessHour) === null || _businessHourData$dep === void 0 ? void 0 : _businessHourData$dep.split(',').filter(Boolean);
        const currentDepartments = (_businessHourData$dep2 = businessHourData.departments) === null || _businessHourData$dep2 === void 0 ? void 0 : _businessHourData$dep2.map(dept => dept._id);
        const toRemove = [...(currentDepartments || []).filter(dept => !departments.includes(dept))];
        await this.removeBusinessHourFromRemovedDepartmentsUsersIfNeeded(businessHourData._id, toRemove);
        const businessHour = await this.BusinessHourRepository.findOneById(businessHourData._id);
        if (!businessHour) {
          return;
        }
        const businessHourIdToOpen = (await filterBusinessHoursThatMustBeOpened([businessHour])).map(businessHour => businessHour._id);
        if (!businessHourIdToOpen.length) {
          return closeBusinessHour(businessHour);
        }
        return openBusinessHour(businessHour);
      }
      async onAddAgentToDepartment(options) {
        const {
          departmentId,
          agentsId
        } = options;
        const department = await LivechatDepartment.findOneById(departmentId, {
          projection: {
            businessHourId: 1
          }
        });
        if (!department || !agentsId.length) {
          return options;
        }
        const defaultBusinessHour = await this.BusinessHourRepository.findOneDefaultBusinessHour();
        if (!defaultBusinessHour) {
          return options;
        }
        if (!department.businessHourId) {
          // If this department doesn't have a business hour, we need to apply default business hour to these agents
          // And then reset their status based on these BH
          const isDefaultBusinessHourActive = (await filterBusinessHoursThatMustBeOpened([defaultBusinessHour])).length > 0;
          if (!isDefaultBusinessHourActive) {
            bhLogger.debug('Default business hour is not active. No need to apply it to agents');
            return options;
          }
          await this.UsersRepository.addBusinessHourByAgentIds(agentsId, defaultBusinessHour._id);
          await makeOnlineAgentsAvailable(agentsId);
          return options;
        }
        // This department has a business hour, so we need to
        // 1. Remove default business hour from these agents if they have it
        // 2. Add this department's business hour to these agents
        // 3. Update their status based on these BH
        await removeBusinessHourByAgentIds(agentsId, defaultBusinessHour._id);
        const businessHour = await this.BusinessHourRepository.findOneById(department.businessHourId);
        if (!businessHour) {
          return options;
        }
        const businessHourToOpen = await filterBusinessHoursThatMustBeOpened([businessHour]);
        if (!businessHourToOpen.length) {
          return options;
        }
        await this.UsersRepository.addBusinessHourByAgentIds(agentsId, businessHour._id);
        await makeOnlineAgentsAvailable(agentsId);
        return options;
      }
      async onRemoveAgentFromDepartment() {
        let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        const {
          departmentId,
          agentsId
        } = options;
        const department = await LivechatDepartment.findOneById(departmentId, {
          projection: {
            businessHourId: 1
          }
        });
        if (!department || !agentsId.length) {
          return options;
        }
        return this.handleRemoveAgentsFromDepartments(department, agentsId, options);
      }
      async onRemoveDepartment(options) {
        const {
          department,
          agentsIds
        } = options;
        if (!department || !(agentsIds !== null && agentsIds !== void 0 && agentsIds.length)) {
          return options;
        }
        return this.onDepartmentDisabled(department);
      }
      async onDepartmentDisabled(department) {
        if (!department.businessHourId) {
          return;
        }
        // Get business hour
        let businessHour = await this.BusinessHourRepository.findOneById(department.businessHourId);
        if (!businessHour) {
          bhLogger.error({
            msg: 'onDepartmentDisabled: business hour not found',
            businessHourId: department.businessHourId
          });
          return;
        }
        // Unlink business hour from department
        await LivechatDepartment.removeBusinessHourFromDepartmentsByIdsAndBusinessHourId([department._id], businessHour._id);
        // cleanup user's cache for default business hour and this business hour
        const defaultBH = await this.BusinessHourRepository.findOneDefaultBusinessHour();
        if (!defaultBH) {
          throw new Error('Default business hour not found');
        }
        await this.UsersRepository.closeAgentsBusinessHoursByBusinessHourIds([businessHour._id, defaultBH._id]);
        // If i'm the only one, disable the business hour
        const imTheOnlyOne = !(await LivechatDepartment.countByBusinessHourIdExcludingDepartmentId(businessHour._id, department._id));
        if (imTheOnlyOne) {
          bhLogger.warn({
            msg: 'onDepartmentDisabled: department is the only one on business hour, disabling it',
            departmentId: department._id,
            businessHourId: businessHour._id
          });
          await this.BusinessHourRepository.disableBusinessHour(businessHour._id);
          businessHour = await this.BusinessHourRepository.findOneById(department.businessHourId);
          if (!businessHour) {
            throw new Error("Business hour ".concat(department.businessHourId, " not found"));
          }
        }
        // start default business hour and this BH if needed
        if (!settings.get('Livechat_enable_business_hours')) {
          return;
        }
        const businessHourToOpen = await filterBusinessHoursThatMustBeOpened([businessHour, defaultBH]);
        var _iteratorAbruptCompletion = false;
        var _didIteratorError = false;
        var _iteratorError;
        try {
          for (var _iterator = _asyncIterator(businessHourToOpen), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
            const bh = _step.value;
            {
              await openBusinessHour(bh, false);
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion && _iterator.return != null) {
              await _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
        await makeAgentsUnavailableBasedOnBusinessHour();
        await businessHourManager.restartCronJobsIfNecessary();
      }
      async onDepartmentArchived(department) {
        bhLogger.debug('Processing department archived event on multiple business hours', department);
        return this.onDepartmentDisabled(department);
      }
      allowAgentChangeServiceStatus(agentId) {
        return this.UsersRepository.isAgentWithinBusinessHours(agentId);
      }
      async onNewAgentCreated(agentId) {
        await this.applyAnyOpenBusinessHourToAgent(agentId);
        await makeAgentsUnavailableBasedOnBusinessHour([agentId]);
      }
      async applyAnyOpenBusinessHourToAgent(agentId) {
        const currentTime = moment().utc();
        const day = currentTime.format('dddd');
        const allActiveBusinessHoursForEntireWeek = await this.BusinessHourRepository.findActiveBusinessHours({
          projection: {
            workHours: 1,
            timezone: 1,
            type: 1,
            active: 1
          }
        });
        const openedBusinessHours = await filterBusinessHoursThatMustBeOpenedByDay(allActiveBusinessHoursForEntireWeek, day);
        if (!openedBusinessHours.length) {
          bhLogger.debug({
            msg: 'Business hour status check failed for agent. No opened business hour found for the current day',
            agentId
          });
          return;
        }
        const agentDepartments = await LivechatDepartmentAgents.find({
          departmentEnabled: true,
          agentId
        }, {
          projection: {
            agentId: 1,
            departmentId: 1
          }
        }).toArray();
        if (!agentDepartments.length) {
          // check if default businessHour is active
          const isDefaultBHActive = openedBusinessHours.find(_ref => {
            let {
              type
            } = _ref;
            return type === LivechatBusinessHourTypes.DEFAULT;
          });
          if (isDefaultBHActive !== null && isDefaultBHActive !== void 0 && isDefaultBHActive._id) {
            await Users.openAgentBusinessHoursByBusinessHourIdsAndAgentId([isDefaultBHActive._id], agentId);
            return;
          }
          bhLogger.debug({
            msg: 'Business hour status check failed for agent. Found default business hour to be inactive',
            agentId
          });
          return;
        }
        // check if any one these departments have a opened business hour linked to it
        const departments = await LivechatDepartment.findInIds(agentDepartments.map(_ref2 => {
          let {
            departmentId
          } = _ref2;
          return departmentId;
        }), {
          projection: {
            _id: 1,
            businessHourId: 1
          }
        }).toArray();
        const departmentsWithActiveBH = departments.filter(_ref3 => {
          let {
            businessHourId
          } = _ref3;
          return businessHourId && openedBusinessHours.findIndex(_ref4 => {
            let {
              _id
            } = _ref4;
            return _id === businessHourId;
          }) !== -1;
        });
        if (!departmentsWithActiveBH.length) {
          // No opened business hour found for any of the departments connected to the agent
          // check if this agent has any departments that is connected to any non-default business hour
          // if no such departments found then check default BH and if it is active, then allow the agent to change service status
          const hasAtLeastOneDepartmentWithNonDefaultBH = departments.some(_ref5 => {
            let {
              businessHourId
            } = _ref5;
            // check if business hour is active
            return businessHourId && allActiveBusinessHoursForEntireWeek.findIndex(_ref6 => {
              let {
                _id
              } = _ref6;
              return _id === businessHourId;
            }) !== -1;
          });
          if (!hasAtLeastOneDepartmentWithNonDefaultBH) {
            const isDefaultBHActive = openedBusinessHours.find(_ref7 => {
              let {
                type
              } = _ref7;
              return type === LivechatBusinessHourTypes.DEFAULT;
            });
            if (isDefaultBHActive !== null && isDefaultBHActive !== void 0 && isDefaultBHActive._id) {
              await Users.openAgentBusinessHoursByBusinessHourIdsAndAgentId([isDefaultBHActive._id], agentId);
              return;
            }
          }
          bhLogger.debug({
            msg: 'Business hour status check failed for agent. No opened business hour found for any of the departments connected to the agent',
            agentId
          });
          return;
        }
        const activeBusinessHoursForAgent = departmentsWithActiveBH.map(_ref8 => {
          let {
            businessHourId
          } = _ref8;
          return businessHourId;
        }).filter(isTruthy);
        await Users.openAgentBusinessHoursByBusinessHourIdsAndAgentId(activeBusinessHoursForAgent, agentId);
        bhLogger.debug({
          msg: "Business hour status check passed for agent. Found opened business hour for departments connected to the agent",
          activeBusinessHoursForAgent
        });
      }
      async handleRemoveAgentsFromDepartments(department, agentsIds, options) {
        const agentIdsWithoutDepartment = [];
        const agentIdsToRemoveCurrentBusinessHour = [];
        const [agentsWithDepartment, [agentsOfDepartment] = []] = await Promise.all([LivechatDepartmentAgents.findByAgentIds(agentsIds, {
          projection: {
            agentId: 1
          }
        }).toArray(), ...[department !== null && department !== void 0 && department.businessHourId ? LivechatDepartment.findAgentsByBusinessHourId(department.businessHourId).toArray() : []]]);
        for (const agentId of agentsIds) {
          var _agentsOfDepartment$a;
          if (!agentsWithDepartment.find(agent => agent.agentId === agentId)) {
            agentIdsWithoutDepartment.push(agentId);
          }
          if (!(agentsOfDepartment !== null && agentsOfDepartment !== void 0 && (_agentsOfDepartment$a = agentsOfDepartment.agentIds) !== null && _agentsOfDepartment$a !== void 0 && _agentsOfDepartment$a.find(agent => agent === agentId))) {
            agentIdsToRemoveCurrentBusinessHour.push(agentId);
          }
        }
        if (department.businessHourId) {
          await removeBusinessHourByAgentIds(agentIdsToRemoveCurrentBusinessHour, department.businessHourId);
        }
        if (!agentIdsWithoutDepartment.length) {
          return options;
        }
        const defaultBusinessHour = await this.BusinessHourRepository.findOneDefaultBusinessHour();
        if (!defaultBusinessHour) {
          return options;
        }
        const businessHourToOpen = await filterBusinessHoursThatMustBeOpened([defaultBusinessHour]);
        if (!businessHourToOpen.length) {
          return options;
        }
        await this.UsersRepository.addBusinessHourByAgentIds(agentIdsWithoutDepartment, defaultBusinessHour._id);
        return options;
      }
      async openBusinessHour(businessHour) {
        return openBusinessHour(businessHour);
      }
      async removeBusinessHourFromRemovedDepartmentsUsersIfNeeded(businessHourId, departmentsToRemove) {
        if (!departmentsToRemove.length) {
          return;
        }
        const agentIds = (await LivechatDepartmentAgents.findByDepartmentIds(departmentsToRemove, {
          projection: {
            agentId: 1
          }
        }).toArray()).map(dept => dept.agentId);
        await removeBusinessHourByAgentIds(agentIds, businessHourId);
      }
      async closeBusinessHour(businessHour) {
        await closeBusinessHour(businessHour);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/business-hour/index.ts                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./Custom");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"lib":{"routing":{"LoadBalancing.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/routing/LoadBalancing.ts                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let Users;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      }
    }, 0);
    let RoutingManager;
    module.link("../../../../../../app/livechat/server/lib/RoutingManager", {
      RoutingManager(v) {
        RoutingManager = v;
      }
    }, 1);
    let settings;
    module.link("../../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 2);
    let getChatLimitsQuery;
    module.link("../../hooks/applySimultaneousChatsRestrictions", {
      getChatLimitsQuery(v) {
        getChatLimitsQuery = v;
      }
    }, 3);
    let logger;
    module.link("../logger", {
      logger(v) {
        logger = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    /* Load Balancing Queuing method:
     *
     * default method where the agent with the least number
     * of open chats is paired with the incoming livechat
     */
    class LoadBalancing {
      constructor() {
        this._config = void 0;
        this._config = {
          previewRoom: false,
          showConnecting: false,
          showQueue: false,
          showQueueLink: false,
          returnQueue: false,
          enableTriggerAction: true,
          autoAssignAgent: true
        };
      }
      get config() {
        return this._config;
      }
      async getNextAgent(department, ignoreAgentId) {
        const extraQuery = await getChatLimitsQuery(department);
        const unavailableUsers = await Users.getUnavailableAgents(department, extraQuery);
        logger.debug({
          msg: 'Ignoring unavailable agents from assignment',
          unavailableUsers,
          department
        });
        const nextAgent = await Users.getNextLeastBusyAgent(department, ignoreAgentId, settings.get('Livechat_enabled_when_agent_idle'), unavailableUsers.map(u => u.username));
        if (!nextAgent) {
          return;
        }
        const {
          agentId,
          username
        } = nextAgent;
        return {
          agentId,
          username
        };
      }
    }
    RoutingManager.registerMethod('Load_Balancing', LoadBalancing);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"LoadRotation.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/routing/LoadRotation.ts                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let Users;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      }
    }, 0);
    let RoutingManager;
    module.link("../../../../../../app/livechat/server/lib/RoutingManager", {
      RoutingManager(v) {
        RoutingManager = v;
      }
    }, 1);
    let settings;
    module.link("../../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 2);
    let getChatLimitsQuery;
    module.link("../../hooks/applySimultaneousChatsRestrictions", {
      getChatLimitsQuery(v) {
        getChatLimitsQuery = v;
      }
    }, 3);
    let logger;
    module.link("../logger", {
      logger(v) {
        logger = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    /* Load Rotation Queuing method:
     * Routing method where the agent with the oldest routing time is the next agent to serve incoming chats
     */
    class LoadRotation {
      constructor() {
        this._config = void 0;
        this._config = {
          previewRoom: false,
          showConnecting: false,
          showQueue: false,
          showQueueLink: false,
          returnQueue: false,
          enableTriggerAction: true,
          autoAssignAgent: true
        };
      }
      get config() {
        return this._config;
      }
      async getNextAgent(department, ignoreAgentId) {
        const extraQuery = await getChatLimitsQuery(department);
        const unavailableUsers = await Users.getUnavailableAgents(department, extraQuery);
        logger.debug({
          msg: 'Ignoring unavailable agents from assignment',
          unavailableUsers,
          department
        });
        const nextAgent = await Users.getLastAvailableAgentRouted(department, ignoreAgentId, settings.get('Livechat_enabled_when_agent_idle'), unavailableUsers.map(user => user.username));
        if (!(nextAgent !== null && nextAgent !== void 0 && nextAgent.username)) {
          return;
        }
        const {
          agentId,
          username
        } = nextAgent;
        return {
          agentId,
          username
        };
      }
    }
    RoutingManager.registerMethod('Load_Rotation', LoadRotation);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"AutoCloseOnHoldScheduler.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/AutoCloseOnHoldScheduler.ts                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      AutoCloseOnHoldSchedulerClass: () => AutoCloseOnHoldSchedulerClass,
      AutoCloseOnHoldScheduler: () => AutoCloseOnHoldScheduler
    });
    let Agenda;
    module.link("@rocket.chat/agenda", {
      Agenda(v) {
        Agenda = v;
      }
    }, 0);
    let LivechatRooms, Users;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    let MongoInternals;
    module.link("meteor/mongo", {
      MongoInternals(v) {
        MongoInternals = v;
      }
    }, 3);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 4);
    let schedulerLogger;
    module.link("./logger", {
      schedulerLogger(v) {
        schedulerLogger = v;
      }
    }, 5);
    let closeRoom;
    module.link("../../../../../app/livechat/server/lib/closeRoom", {
      closeRoom(v) {
        closeRoom = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const SCHEDULER_NAME = 'omnichannel_auto_close_on_hold_scheduler';
    class AutoCloseOnHoldSchedulerClass {
      constructor() {
        this.scheduler = void 0;
        this.schedulerUser = void 0;
        this.running = void 0;
        this.logger = void 0;
        this.logger = schedulerLogger.section('AutoCloseOnHoldScheduler');
      }
      async init() {
        if (this.running) {
          return;
        }
        this.scheduler = new Agenda({
          mongo: MongoInternals.defaultRemoteCollectionDriver().mongo.client.db(),
          db: {
            collection: SCHEDULER_NAME
          },
          defaultConcurrency: 1,
          processEvery: process.env.TEST_MODE === 'true' ? '3 seconds' : '1 minute'
        });
        await this.scheduler.start();
        this.running = true;
        this.logger.info('Service started');
      }
      async scheduleRoom(roomId, timeout, comment) {
        if (!this.running) {
          throw new Error('AutoCloseOnHoldScheduler is not running');
        }
        this.logger.debug("Scheduling room ".concat(roomId, " to be closed in ").concat(timeout, " seconds"));
        await this.unscheduleRoom(roomId);
        const jobName = "".concat(SCHEDULER_NAME, "-").concat(roomId);
        const when = moment(new Date()).add(timeout, 's').toDate();
        this.scheduler.define(jobName, this.executeJob.bind(this));
        await this.scheduler.schedule(when, jobName, {
          roomId,
          comment
        });
      }
      async unscheduleRoom(roomId) {
        if (!this.running) {
          throw new Error('AutoCloseOnHoldScheduler is not running');
        }
        this.logger.debug("Unscheduling room ".concat(roomId));
        const jobName = "".concat(SCHEDULER_NAME, "-").concat(roomId);
        await this.scheduler.cancel({
          name: jobName
        });
      }
      async executeJob() {
        let {
          attrs: {
            data
          }
        } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        this.logger.debug("Executing job for room ".concat(data.roomId));
        const {
          roomId,
          comment
        } = data;
        const [room, user] = await Promise.all([LivechatRooms.findOneById(roomId), this.getSchedulerUser()]);
        if (!room || !user) {
          throw new Error("Unable to process AutoCloseOnHoldScheduler job because room or user not found for roomId: ".concat(roomId, " and userId: rocket.cat"));
        }
        const payload = {
          room,
          user,
          comment
        };
        await closeRoom(payload);
      }
      async getSchedulerUser() {
        if (!this.schedulerUser) {
          const schedulerUser = await Users.findOneById('rocket.cat');
          if (!schedulerUser) {
            throw new Error('Scheduler user not found');
          }
          this.schedulerUser = schedulerUser;
        }
        return this.schedulerUser;
      }
    }
    const AutoCloseOnHoldScheduler = new AutoCloseOnHoldSchedulerClass();
    Meteor.startup(() => {
      void AutoCloseOnHoldScheduler.init();
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"AutoTransferChatScheduler.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/AutoTransferChatScheduler.ts                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      AutoTransferChatSchedulerClass: () => AutoTransferChatSchedulerClass,
      AutoTransferChatScheduler: () => AutoTransferChatScheduler
    });
    let Agenda;
    module.link("@rocket.chat/agenda", {
      Agenda(v) {
        Agenda = v;
      }
    }, 0);
    let LivechatRooms, Users;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    let MongoInternals;
    module.link("meteor/mongo", {
      MongoInternals(v) {
        MongoInternals = v;
      }
    }, 3);
    let schedulerLogger;
    module.link("./logger", {
      schedulerLogger(v) {
        schedulerLogger = v;
      }
    }, 4);
    let forwardRoomToAgent;
    module.link("../../../../../app/livechat/server/lib/Helper", {
      forwardRoomToAgent(v) {
        forwardRoomToAgent = v;
      }
    }, 5);
    let RoutingManager;
    module.link("../../../../../app/livechat/server/lib/RoutingManager", {
      RoutingManager(v) {
        RoutingManager = v;
      }
    }, 6);
    let returnRoomAsInquiry;
    module.link("../../../../../app/livechat/server/lib/rooms", {
      returnRoomAsInquiry(v) {
        returnRoomAsInquiry = v;
      }
    }, 7);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 8);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const SCHEDULER_NAME = 'omnichannel_scheduler';
    class AutoTransferChatSchedulerClass {
      constructor() {
        this.scheduler = void 0;
        this.running = void 0;
        this.user = void 0;
        this.logger = void 0;
        this.logger = schedulerLogger.section('AutoTransferChatScheduler');
      }
      async init() {
        if (this.running) {
          return;
        }
        this.scheduler = new Agenda({
          mongo: MongoInternals.defaultRemoteCollectionDriver().mongo.client.db(),
          db: {
            collection: SCHEDULER_NAME
          },
          defaultConcurrency: 1,
          processEvery: process.env.TEST_MODE === 'true' ? '3 seconds' : '1 minute'
        });
        await this.scheduler.start();
        this.running = true;
        this.logger.info('Service started');
      }
      async getSchedulerUser() {
        const user = await Users.findOneById('rocket.cat');
        if (!user) {
          this.logger.error('Error while transferring room: user not found');
          throw new Error('error-no-cat');
        }
        return _objectSpread(_objectSpread({}, user), {}, {
          userType: 'user'
        });
      }
      async scheduleRoom(roomId, timeout) {
        this.logger.debug("Scheduling room ".concat(roomId, " to be transferred in ").concat(timeout, " seconds"));
        await this.unscheduleRoom(roomId);
        const jobName = "".concat(SCHEDULER_NAME, "-").concat(roomId);
        const when = new Date();
        when.setSeconds(when.getSeconds() + timeout);
        this.scheduler.define(jobName, this.executeJob.bind(this));
        await this.scheduler.schedule(when, jobName, {
          roomId
        });
        await LivechatRooms.setAutoTransferOngoingById(roomId);
      }
      async unscheduleRoom(roomId) {
        this.logger.debug("Unscheduling room ".concat(roomId));
        const jobName = "".concat(SCHEDULER_NAME, "-").concat(roomId);
        await LivechatRooms.unsetAutoTransferOngoingById(roomId);
        await this.scheduler.cancel({
          name: jobName
        });
      }
      async transferRoom(roomId) {
        var _room$servedBy, _RoutingManager$getCo;
        this.logger.debug("Transferring room ".concat(roomId));
        const room = await LivechatRooms.findOneById(roomId, {
          _id: 1,
          v: 1,
          servedBy: 1,
          open: 1,
          departmentId: 1
        });
        if (!(room !== null && room !== void 0 && room.open) || !(room !== null && room !== void 0 && (_room$servedBy = room.servedBy) !== null && _room$servedBy !== void 0 && _room$servedBy._id)) {
          throw new Error('Room is not open or is not being served by an agent');
        }
        const {
          departmentId,
          servedBy: {
            _id: ignoreAgentId
          }
        } = room;
        const timeoutDuration = settings.get('Livechat_auto_transfer_chat_timeout').toString();
        if (!((_RoutingManager$getCo = RoutingManager.getConfig()) !== null && _RoutingManager$getCo !== void 0 && _RoutingManager$getCo.autoAssignAgent)) {
          this.logger.debug("Auto-assign agent is disabled, returning room ".concat(roomId, " as inquiry"));
          await returnRoomAsInquiry(room, departmentId, {
            scope: 'autoTransferUnansweredChatsToQueue',
            comment: timeoutDuration,
            transferredBy: await this.getSchedulerUser()
          });
          return;
        }
        const agent = await RoutingManager.getNextAgent(departmentId, ignoreAgentId);
        if (!agent) {
          this.logger.error("No agent found to transfer room ".concat(room._id, " which hasn't been answered in ").concat(timeoutDuration, " seconds"));
          return;
        }
        this.logger.debug("Transferring room ".concat(roomId, " to agent ").concat(agent.agentId));
        const transferredBy = await this.getSchedulerUser();
        await forwardRoomToAgent(room, {
          userId: agent.agentId,
          transferredBy,
          transferredTo: agent,
          scope: 'autoTransferUnansweredChatsToAgent',
          comment: timeoutDuration
        });
      }
      async executeJob() {
        let {
          attrs: {
            data
          }
        } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        const {
          roomId
        } = data;
        try {
          await this.transferRoom(roomId);
          await Promise.all([LivechatRooms.setAutoTransferredAtById(roomId), this.unscheduleRoom(roomId)]);
        } catch (error) {
          this.logger.error("Error while executing job ".concat(SCHEDULER_NAME, " for room ").concat(roomId, ":"), error);
        }
      }
    }
    const AutoTransferChatScheduler = new AutoTransferChatSchedulerClass();
    Meteor.startup(() => {
      void AutoTransferChatScheduler.init();
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"Department.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/Department.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      findAllDepartmentsAvailable: () => findAllDepartmentsAvailable,
      findAllDepartmentsByUnit: () => findAllDepartmentsByUnit
    });
    let LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 0);
    let applyDepartmentRestrictions;
    module.link("@rocket.chat/omni-core", {
      applyDepartmentRestrictions(v) {
        applyDepartmentRestrictions = v;
      }
    }, 1);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const findAllDepartmentsAvailable = async function (uid, unitId, offset, count, text) {
      let onlyMyDepartments = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
      const filterReg = new RegExp(escapeRegExp(text || ''), 'i');
      let query = _objectSpread({
        type: {
          $ne: 'u'
        },
        $or: [{
          ancestors: {
            $in: [[unitId], undefined, []]
          }
        }, {
          ancestors: {
            $exists: false
          }
        }]
      }, text && {
        name: filterReg
      });
      if (onlyMyDepartments) {
        query = await applyDepartmentRestrictions(query, uid);
      }
      const {
        cursor,
        totalCount
      } = LivechatDepartment.findPaginated(query, {
        limit: count,
        offset,
        sort: {
          name: 1
        }
      });
      const [departments, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        departments,
        total
      };
    };
    const findAllDepartmentsByUnit = async (unitId, offset, count) => {
      const {
        cursor,
        totalCount
      } = LivechatDepartment.findPaginated({
        ancestors: {
          $in: [unitId]
        }
      }, {
        limit: count,
        offset
      });
      const [departments, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        departments,
        total
      };
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"Helper.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/Helper.ts                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      isAgentWithinChatLimits: () => isAgentWithinChatLimits,
      dispatchInquiryPosition: () => dispatchInquiryPosition,
      debouncedDispatchWaitingQueueStatus: () => debouncedDispatchWaitingQueueStatus,
      setPredictedVisitorAbandonmentTime: () => setPredictedVisitorAbandonmentTime,
      updatePredictedVisitorAbandonment: () => updatePredictedVisitorAbandonment,
      updateQueueInactivityTimeout: () => updateQueueInactivityTimeout,
      updateSLAInquiries: () => updateSLAInquiries,
      getLivechatCustomFields: () => getLivechatCustomFields,
      getLivechatQueueInfo: () => getLivechatQueueInfo
    });
    let api;
    module.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      }
    }, 0);
    let RoomRaw, LivechatRooms, LivechatDepartmentRaw, LivechatCustomField, LivechatInquiry, Users;
    module.link("@rocket.chat/models", {
      Rooms(v) {
        RoomRaw = v;
      },
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      LivechatDepartment(v) {
        LivechatDepartmentRaw = v;
      },
      LivechatCustomField(v) {
        LivechatCustomField = v;
      },
      LivechatInquiry(v) {
        LivechatInquiry = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 2);
    let OmnichannelQueueInactivityMonitor;
    module.link("./QueueInactivityMonitor", {
      OmnichannelQueueInactivityMonitor(v) {
        OmnichannelQueueInactivityMonitor = v;
      }
    }, 3);
    let updateInquiryQueueSla;
    module.link("./SlaHelper", {
      updateInquiryQueueSla(v) {
        updateInquiryQueueSla = v;
      }
    }, 4);
    let memoizeDebounce;
    module.link("./debounceByParams", {
      memoizeDebounce(v) {
        memoizeDebounce = v;
      }
    }, 5);
    let logger;
    module.link("./logger", {
      logger(v) {
        logger = v;
      }
    }, 6);
    let getOmniChatSortQuery;
    module.link("../../../../../app/livechat/lib/inquiries", {
      getOmniChatSortQuery(v) {
        getOmniChatSortQuery = v;
      }
    }, 7);
    let getInquirySortMechanismSetting;
    module.link("../../../../../app/livechat/server/lib/settings", {
      getInquirySortMechanismSetting(v) {
        getInquirySortMechanismSetting = v;
      }
    }, 8);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 9);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 10);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const isAgentWithinChatLimits = async _ref => {
      var _user$livechat;
      let {
        agentId,
        departmentId,
        totalChats,
        departmentChats
      } = _ref;
      let agentLimit = 0;
      let globalLimit = 0;
      const user = await Users.getAgentInfo(agentId, settings.get('Livechat_show_agent_info'));
      const rawAgentLimit = user === null || user === void 0 ? void 0 : (_user$livechat = user.livechat) === null || _user$livechat === void 0 ? void 0 : _user$livechat.maxNumberSimultaneousChat;
      if (rawAgentLimit !== undefined && rawAgentLimit !== null) {
        const numericAgentLimit = Number(rawAgentLimit);
        if (numericAgentLimit > 0) {
          agentLimit = numericAgentLimit;
        }
      }
      if (agentLimit === 0) {
        const settingLimit = settings.get('Livechat_maximum_chats_per_agent');
        if (settingLimit > 0) {
          globalLimit = settingLimit;
        }
      }
      if (departmentId) {
        const department = await LivechatDepartmentRaw.findOneById(departmentId, {
          projection: {
            maxNumberSimultaneousChat: 1
          }
        });
        let departmentLimit = 0;
        if ((department === null || department === void 0 ? void 0 : department.maxNumberSimultaneousChat) !== undefined && department.maxNumberSimultaneousChat !== null) {
          const numericDeptLimit = Number(department.maxNumberSimultaneousChat);
          if (numericDeptLimit > 0) {
            departmentLimit = numericDeptLimit;
          }
        }
        if (departmentLimit > 0) {
          if (agentLimit > 0) {
            logger.debug({
              msg: 'Applying chat limits',
              departmentId,
              agentId,
              limits: ['department', 'agent'],
              totalChats,
              departmentChats,
              agentLimit,
              departmentLimit
            });
            return departmentChats < departmentLimit && totalChats < agentLimit;
          }
          if (globalLimit > 0) {
            logger.debug({
              msg: 'Applying chat limits',
              departmentId,
              agentId,
              limits: ['department', 'global'],
              totalChats,
              departmentChats,
              globalLimit,
              departmentLimit
            });
            return departmentChats < departmentLimit && totalChats < globalLimit;
          }
          logger.debug({
            msg: 'Applying chat limits',
            departmentId,
            agentId,
            limits: ['department'],
            totalChats,
            departmentChats,
            departmentLimit
          });
          return departmentChats < departmentLimit;
        }
      }
      if (agentLimit > 0) {
        logger.debug({
          msg: 'Applying chat limits',
          departmentId,
          agentId,
          limits: ['agent'],
          totalChats,
          agentLimit
        });
        return totalChats < agentLimit;
      }
      if (globalLimit > 0) {
        logger.debug({
          msg: 'Applying chat limits',
          departmentId,
          agentId,
          limits: ['global'],
          totalChats,
          globalLimit
        });
        return totalChats < globalLimit;
      }
      logger.debug({
        msg: 'No applicable limit found for user',
        agentId
      });
      return true;
    };
    const getWaitingQueueMessage = async departmentId => {
      const department = departmentId ? await LivechatDepartmentRaw.findOneById(departmentId) : null;
      if (department !== null && department !== void 0 && department.waitingQueueMessage) {
        return department.waitingQueueMessage;
      }
      return settings.get('Livechat_waiting_queue_message');
    };
    const getQueueInfo = async department => {
      const numberMostRecentChats = settings.get('Livechat_number_most_recent_chats_estimate_wait_time');
      const statistics = await RoomRaw.getMostRecentAverageChatDurationTime(numberMostRecentChats, department);
      const text = await getWaitingQueueMessage(department);
      const message = {
        text,
        user: {
          _id: 'rocket.cat',
          username: 'rocket.cat'
        }
      };
      return {
        message,
        statistics,
        numberMostRecentChats
      };
    };
    const getSpotEstimatedWaitTime = (spot, maxNumberSimultaneousChat, avgChatDuration) => {
      if (!maxNumberSimultaneousChat || !avgChatDuration) {
        return;
      }
      // X = spot
      // N = maxNumberSimultaneousChat
      // Estimated Wait Time = ([(N-1)/X]+1) *Average Chat Time of Most Recent X(Default = 100) Chats
      return ((spot - 1) / maxNumberSimultaneousChat + 1) * avgChatDuration;
    };
    const normalizeQueueInfo = async _ref2 => {
      let {
        position,
        queueInfo,
        department
      } = _ref2;
      if (!queueInfo) {
        queueInfo = await getQueueInfo(department);
      }
      const {
        message,
        numberMostRecentChats,
        statistics: {
          avgChatDuration
        } = {}
      } = queueInfo;
      const spot = position + 1;
      const estimatedWaitTimeSeconds = getSpotEstimatedWaitTime(spot, numberMostRecentChats, avgChatDuration);
      return {
        spot,
        message,
        estimatedWaitTimeSeconds
      };
    };
    const dispatchInquiryPosition = async (inquiry, queueInfo) => {
      const {
        position,
        department
      } = inquiry;
      // Avoid broadcasting if no position was determined
      if (position === undefined) {
        return;
      }
      const data = await normalizeQueueInfo({
        position,
        queueInfo,
        department
      });
      return setTimeout(() => {
        void api.broadcast('omnichannel.room', inquiry.rid, {
          type: 'queueData',
          data
        });
      }, 1000);
    };
    const dispatchWaitingQueueStatus = async department => {
      if (!settings.get('Livechat_waiting_queue') && !settings.get('Omnichannel_calculate_dispatch_service_queue_statistics')) {
        return;
      }
      const queue = await LivechatInquiry.getCurrentSortedQueueAsync({
        department,
        queueSortBy: getOmniChatSortQuery(getInquirySortMechanismSetting())
      });
      if (!queue.length) {
        return;
      }
      const queueInfo = await getQueueInfo(department);
      queue.forEach(inquiry => {
        void dispatchInquiryPosition(inquiry, queueInfo);
      });
    };
    // When dealing with lots of queued items we need to make sure to notify their position
    // but we don't need to notify _each_ change that takes place, just their final position
    const debouncedDispatchWaitingQueueStatus = memoizeDebounce(dispatchWaitingQueueStatus, 1200);
    const setPredictedVisitorAbandonmentTime = async (room, roomUpdater) => {
      var _room$responseBy;
      if (!((_room$responseBy = room.responseBy) !== null && _room$responseBy !== void 0 && _room$responseBy.firstResponseTs) || !settings.get('Livechat_abandoned_rooms_action') || settings.get('Livechat_abandoned_rooms_action') === 'none') {
        return;
      }
      let secondsToAdd = settings.get('Livechat_visitor_inactivity_timeout');
      const department = room.departmentId ? await LivechatDepartmentRaw.findOneById(room.departmentId) : null;
      if (department !== null && department !== void 0 && department.visitorInactivityTimeoutInSeconds) {
        secondsToAdd = department.visitorInactivityTimeoutInSeconds;
      }
      if (secondsToAdd <= 0) {
        return;
      }
      const willBeAbandonedAt = moment(room.responseBy.firstResponseTs).add(Number(secondsToAdd), 'seconds').toDate();
      if (roomUpdater) {
        await LivechatRooms.getPredictedVisitorAbandonmentByRoomIdUpdateQuery(willBeAbandonedAt, roomUpdater);
      } else {
        await LivechatRooms.setPredictedVisitorAbandonmentByRoomId(room._id, willBeAbandonedAt);
      }
    };
    const updatePredictedVisitorAbandonment = async () => {
      if (!settings.get('Livechat_abandoned_rooms_action') || settings.get('Livechat_abandoned_rooms_action') === 'none') {
        await LivechatRooms.unsetAllPredictedVisitorAbandonment();
      } else {
        // Eng day: use a promise queue to update the predicted visitor abandonment time instead of all at once
        const extraQuery = await callbacks.run('livechat.applyRoomRestrictions', {});
        const promisesArray = [];
        await LivechatRooms.findOpen(extraQuery).forEach(room => {
          promisesArray.push(setPredictedVisitorAbandonmentTime(room));
        });
        await Promise.all(promisesArray);
      }
    };
    const updateQueueInactivityTimeout = async () => {
      const queueTimeout = settings.get('Livechat_max_queue_wait_time');
      if (queueTimeout <= 0) {
        await OmnichannelQueueInactivityMonitor.stop();
        return;
      }
      await LivechatInquiry.getQueuedInquiries({
        projection: {
          _updatedAt: 1
        }
      }).forEach(inq => {
        const aggregatedDate = moment(inq._updatedAt).add(queueTimeout, 'minutes');
        try {
          void OmnichannelQueueInactivityMonitor.scheduleInquiry(inq._id, new Date(aggregatedDate.format()));
        } catch (e) {
          // this will usually happen if other instance attempts to re-create a job
          logger.error({
            err: e
          });
        }
      });
    };
    const updateSLAInquiries = async (executedBy, sla) => {
      if (!sla) {
        return;
      }
      const {
        _id: slaId
      } = sla;
      const promises = [];
      const extraQuery = await callbacks.run('livechat.applyRoomRestrictions', {}, {
        userId: executedBy
      });
      await LivechatRooms.findOpenBySlaId(slaId, {}, extraQuery).forEach(room => {
        promises.push(updateInquiryQueueSla(room._id, sla));
      });
      await Promise.allSettled(promises);
    };
    const getLivechatCustomFields = async () => {
      const customFields = await LivechatCustomField.find({
        visibility: 'visible',
        scope: 'visitor',
        public: true
      }).toArray();
      return customFields.map(_ref3 => {
        let {
          _id,
          label,
          regexp,
          required = false,
          type,
          defaultValue = null,
          options
        } = _ref3;
        return _objectSpread({
          _id,
          label,
          regexp,
          required,
          type,
          defaultValue
        }, options && options !== '' && {
          options: options.split(',')
        });
      });
    };
    const getLivechatQueueInfo = async room => {
      if (!room) {
        return null;
      }
      if (!settings.get('Livechat_waiting_queue')) {
        return null;
      }
      if (!settings.get('Omnichannel_calculate_dispatch_service_queue_statistics')) {
        return null;
      }
      const {
        _id: rid,
        departmentId: department
      } = room;
      const inquiry = await LivechatInquiry.findOneByRoomId(rid, {
        projection: {
          _id: 1,
          status: 1
        }
      });
      if (!inquiry) {
        return null;
      }
      const {
        _id,
        status
      } = inquiry;
      if (status !== 'queued') {
        return null;
      }
      const [inq] = await LivechatInquiry.getCurrentSortedQueueAsync({
        inquiryId: _id,
        department,
        queueSortBy: getOmniChatSortQuery(getInquirySortMechanismSetting())
      });
      if (!inq) {
        return null;
      }
      return normalizeQueueInfo(inq);
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"LivechatEnterprise.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/LivechatEnterprise.ts                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      LivechatEnterprise: () => LivechatEnterprise
    });
    let Users, OmnichannelServiceLevelAgreements, LivechatTag, LivechatUnitMonitors, LivechatUnit;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      },
      OmnichannelServiceLevelAgreements(v) {
        OmnichannelServiceLevelAgreements = v;
      },
      LivechatTag(v) {
        LivechatTag = v;
      },
      LivechatUnitMonitors(v) {
        LivechatUnitMonitors = v;
      },
      LivechatUnit(v) {
        LivechatUnit = v;
      }
    }, 0);
    let getUnitsFromUser;
    module.link("@rocket.chat/omni-core-ee", {
      getUnitsFromUser(v) {
        getUnitsFromUser = v;
      }
    }, 1);
    let Match, check;
    module.link("meteor/check", {
      Match(v) {
        Match = v;
      },
      check(v) {
        check = v;
      }
    }, 2);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 3);
    let updateSLAInquiries;
    module.link("./Helper", {
      updateSLAInquiries(v) {
        updateSLAInquiries = v;
      }
    }, 4);
    let removeSLAFromRooms;
    module.link("./SlaHelper", {
      removeSLAFromRooms(v) {
        removeSLAFromRooms = v;
      }
    }, 5);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 6);
    let addUserRolesAsync;
    module.link("../../../../../server/lib/roles/addUserRoles", {
      addUserRolesAsync(v) {
        addUserRolesAsync = v;
      }
    }, 7);
    let removeUserFromRolesAsync;
    module.link("../../../../../server/lib/roles/removeUserFromRoles", {
      removeUserFromRolesAsync(v) {
        removeUserFromRolesAsync = v;
      }
    }, 8);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const LivechatEnterprise = {
      async addMonitor(username) {
        const user = await Users.findOneByUsername(username, {
          projection: {
            _id: 1,
            username: 1,
            roles: 1
          }
        });
        if (!user) {
          throw new Meteor.Error('error-invalid-user', 'Invalid user', {
            method: 'livechat:addMonitor'
          });
        }
        if (await addUserRolesAsync(user._id, ['livechat-monitor'])) {
          return user;
        }
        return false;
      },
      async removeMonitor(username) {
        const user = await Users.findOneByUsername(username, {
          projection: {
            _id: 1
          }
        });
        if (!user) {
          throw new Meteor.Error('error-invalid-user', 'Invalid user', {
            method: 'livechat:removeMonitor'
          });
        }
        if (!(await removeUserFromRolesAsync(user._id, ['livechat-monitor']))) {
          return false;
        }
        // remove this monitor from any unit it is assigned to
        await LivechatUnitMonitors.removeByMonitorId(user._id);
        return true;
      },
      async removeUnit(_id, userId) {
        check(_id, String);
        const unitsFromUser = await getUnitsFromUser(userId);
        const result = await LivechatUnit.removeByIdAndUnit(_id, unitsFromUser);
        if (!result.deletedCount) {
          throw new Meteor.Error('unit-not-found', 'Unit not found', {
            method: 'livechat:removeUnit'
          });
        }
        return result;
      },
      async saveUnit(_id, unitData, unitMonitors, unitDepartments, userId) {
        check(_id, Match.Maybe(String));
        check(unitData, {
          name: String,
          visibility: String,
          enabled: Match.Optional(Boolean),
          description: Match.Optional(String),
          email: Match.Optional(String),
          showOnOfflineForm: Match.Optional(Boolean)
        });
        check(unitMonitors, [Match.ObjectIncluding({
          monitorId: String,
          username: String
        })]);
        check(unitDepartments, [Match.ObjectIncluding({
          departmentId: String
        })]);
        let ancestors = [];
        if (_id) {
          const unitsFromUser = await getUnitsFromUser(userId);
          const unit = await LivechatUnit.findOneById(_id, {
            projection: {
              _id: 1,
              ancestors: 1
            }
          }, {
            unitsFromUser
          });
          if (!unit) {
            throw new Meteor.Error('error-unit-not-found', 'Unit not found', {
              method: 'livechat:saveUnit'
            });
          }
          ancestors = unit.ancestors || [];
        }
        const validUserMonitors = await Users.findUsersInRolesWithQuery('livechat-monitor', {
          _id: {
            $in: unitMonitors.map(_ref => {
              let {
                monitorId
              } = _ref;
              return monitorId;
            })
          }
        }, {
          projection: {
            _id: 1,
            username: 1
          }
        }).toArray();
        const monitors = validUserMonitors.map(_ref2 => {
          let {
            _id: monitorId,
            username
          } = _ref2;
          return {
            monitorId,
            username: username
          };
        });
        return LivechatUnit.createOrUpdateUnit(_id, unitData, ancestors, monitors, unitDepartments);
      },
      async removeTag(_id) {
        const tag = await LivechatTag.findOneById(_id, {
          projection: {
            _id: 1,
            name: 1
          }
        });
        if (!tag) {
          throw new Meteor.Error('tag-not-found', 'Tag not found', {
            method: 'livechat:removeTag'
          });
        }
        await callbacks.run('livechat.afterTagRemoved', tag);
        return LivechatTag.removeById(_id);
      },
      async saveTag(_id, tagData, tagDepartments) {
        return LivechatTag.createOrUpdateTag(_id, tagData, tagDepartments);
      },
      async saveSLA(_id, slaData, executedBy) {
        const oldSLA = _id && (await OmnichannelServiceLevelAgreements.findOneById(_id, {
          projection: {
            dueTimeInMinutes: 1
          }
        }));
        const exists = await OmnichannelServiceLevelAgreements.findDuplicate(_id, slaData.name, slaData.dueTimeInMinutes);
        if (exists) {
          throw new Error('error-duplicated-sla');
        }
        const sla = await OmnichannelServiceLevelAgreements.createOrUpdatePriority(slaData, _id);
        if (!oldSLA) {
          return sla;
        }
        const {
          dueTimeInMinutes: oldDueTimeInMinutes
        } = oldSLA;
        const {
          dueTimeInMinutes
        } = sla;
        if (oldDueTimeInMinutes !== dueTimeInMinutes) {
          await updateSLAInquiries(executedBy, sla);
        }
        return sla;
      },
      async removeSLA(executedBy, _id) {
        const removedResult = await OmnichannelServiceLevelAgreements.removeById(_id);
        if (!removedResult || removedResult.deletedCount !== 1) {
          throw new Error("SLA with id ".concat(_id, " not found"));
        }
        await removeSLAFromRooms(_id, executedBy);
      }
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"QueueInactivityMonitor.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/QueueInactivityMonitor.ts                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      OmnichannelQueueInactivityMonitorClass: () => OmnichannelQueueInactivityMonitorClass,
      OmnichannelQueueInactivityMonitor: () => OmnichannelQueueInactivityMonitor
    });
    let Agenda;
    module.link("@rocket.chat/agenda", {
      Agenda(v) {
        Agenda = v;
      }
    }, 0);
    let LivechatRooms, LivechatInquiryRaw, Users;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      LivechatInquiry(v) {
        LivechatInquiryRaw = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    let MongoInternals;
    module.link("meteor/mongo", {
      MongoInternals(v) {
        MongoInternals = v;
      }
    }, 3);
    let schedulerLogger;
    module.link("./logger", {
      schedulerLogger(v) {
        schedulerLogger = v;
      }
    }, 4);
    let closeRoom;
    module.link("../../../../../app/livechat/server/lib/closeRoom", {
      closeRoom(v) {
        closeRoom = v;
      }
    }, 5);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 6);
    let i18n;
    module.link("../../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 7);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const SCHEDULER_NAME = 'omnichannel_queue_inactivity_monitor';
    class OmnichannelQueueInactivityMonitorClass {
      constructor() {
        this.scheduler = void 0;
        this.running = void 0;
        this.logger = void 0;
        this._name = void 0;
        this.user = void 0;
        this.message = void 0;
        this._db = void 0;
        this.bindedCloseRoom = void 0;
        this._db = MongoInternals.defaultRemoteCollectionDriver().mongo.db;
        this.running = false;
        this._name = 'Omnichannel-Queue-Inactivity-Monitor';
        this.logger = schedulerLogger.section(this._name);
        this.scheduler = new Agenda({
          mongo: MongoInternals.defaultRemoteCollectionDriver().mongo.client.db(),
          db: {
            collection: SCHEDULER_NAME
          },
          defaultConcurrency: 1,
          processEvery: process.env.TEST_MODE === 'true' ? '3 seconds' : '1 minute'
        });
        this.createIndex();
        const language = settings.get('Language') || 'en';
        this.message = i18n.t('Closed_automatically_chat_queued_too_long', {
          lng: language
        });
        this.bindedCloseRoom = this.closeRoom.bind(this);
      }
      async getRocketCatUser() {
        return Users.findOneById('rocket.cat');
      }
      getName(inquiryId) {
        return "".concat(this._name, "-").concat(inquiryId);
      }
      createIndex() {
        void this._db.collection(SCHEDULER_NAME).createIndex({
          'data.inquiryId': 1
        }, {
          unique: true
        });
      }
      async start() {
        if (this.running) {
          return;
        }
        await this.scheduler.start();
        this.logger.info('Service started');
        this.running = true;
      }
      async scheduleInquiry(inquiryId, time) {
        await this.stopInquiry(inquiryId);
        this.logger.debug("Scheduling automatic close of inquiry ".concat(inquiryId, " at ").concat(time));
        const name = this.getName(inquiryId);
        this.scheduler.define(name, this.bindedCloseRoom);
        const job = this.scheduler.create(name, {
          inquiryId
        });
        job.schedule(time);
        job.unique({
          'data.inquiryId': inquiryId
        });
        await job.save();
      }
      async stop() {
        if (!this.running) {
          return;
        }
        await this.scheduler.cancel({});
        this.running = false;
      }
      async stopInquiry(inquiryId) {
        const name = this.getName(inquiryId);
        await this.scheduler.cancel({
          name
        });
      }
      async closeRoomAction(room) {
        const comment = this.message;
        return closeRoom({
          comment,
          room,
          user: await this.getRocketCatUser()
        });
      }
      async closeRoom() {
        let {
          attrs: {
            data
          }
        } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        const {
          inquiryId
        } = data;
        // TODO: add projection and maybe use findOneQueued to avoid fetching the whole inquiry
        const inquiry = await LivechatInquiryRaw.findOneById(inquiryId);
        if (!inquiry || inquiry.status !== 'queued') {
          return;
        }
        const room = await LivechatRooms.findOneById(inquiry.rid);
        if (!room) {
          this.logger.error("Unable to find room ".concat(inquiry.rid, " for inquiry ").concat(inquiryId, " to close in queue inactivity monitor"));
          return;
        }
        await Promise.all([this.closeRoomAction(room), this.stopInquiry(inquiryId)]);
        this.logger.info("Closed room ".concat(inquiry.rid, " for inquiry ").concat(inquiryId, " due to inactivity"));
      }
    }
    const OmnichannelQueueInactivityMonitor = new OmnichannelQueueInactivityMonitorClass();
    Meteor.startup(async () => {
      void OmnichannelQueueInactivityMonitor.start();
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"SlaHelper.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/SlaHelper.ts                                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      removeSLAFromRooms: () => removeSLAFromRooms,
      updateInquiryQueueSla: () => updateInquiryQueueSla,
      updateRoomSlaWeights: () => updateRoomSlaWeights,
      removeInquiryQueueSla: () => removeInquiryQueueSla,
      removeSlaFromRoom: () => removeSlaFromRoom,
      addSlaChangeHistoryToRoom: () => addSlaChangeHistoryToRoom
    });
    let Message;
    module.link("@rocket.chat/core-services", {
      Message(v) {
        Message = v;
      }
    }, 0);
    let LivechatInquiry, LivechatRooms;
    module.link("@rocket.chat/models", {
      LivechatInquiry(v) {
        LivechatInquiry = v;
      },
      LivechatRooms(v) {
        LivechatRooms = v;
      }
    }, 1);
    let notifyOnRoomChangedById, notifyOnLivechatInquiryChangedByRoom, notifyOnLivechatInquiryChanged;
    module.link("../../../../../app/lib/server/lib/notifyListener", {
      notifyOnRoomChangedById(v) {
        notifyOnRoomChangedById = v;
      },
      notifyOnLivechatInquiryChangedByRoom(v) {
        notifyOnLivechatInquiryChangedByRoom = v;
      },
      notifyOnLivechatInquiryChanged(v) {
        notifyOnLivechatInquiryChanged = v;
      }
    }, 2);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const removeSLAFromRooms = async (slaId, userId) => {
      const extraQuery = await callbacks.run('livechat.applyRoomRestrictions', {}, {
        userId
      });
      const openRooms = await LivechatRooms.findOpenBySlaId(slaId, {
        projection: {
          _id: 1
        }
      }, extraQuery).toArray();
      const openRoomIds = openRooms.map(_ref => {
        let {
          _id
        } = _ref;
        return _id;
      });
      if (openRooms.length) {
        await LivechatInquiry.bulkUnsetSla(openRoomIds);
        void notifyOnLivechatInquiryChangedByRoom(openRoomIds, 'updated');
      }
      await LivechatRooms.bulkRemoveSlaFromRoomsById(slaId);
      void notifyOnRoomChangedById(openRoomIds, 'updated');
    };
    const updateInquiryQueueSla = async (roomId, sla) => {
      const inquiry = await LivechatInquiry.findOneByRoomId(roomId);
      if (!inquiry) {
        return;
      }
      const {
        dueTimeInMinutes,
        _id: slaId
      } = sla;
      const estimatedWaitingTimeQueue = dueTimeInMinutes;
      await LivechatInquiry.setSlaForRoom(inquiry.rid, {
        slaId,
        estimatedWaitingTimeQueue
      });
      void notifyOnLivechatInquiryChanged(_objectSpread(_objectSpread({}, inquiry), {}, {
        slaId,
        estimatedWaitingTimeQueue,
        _updatedAt: new Date()
      }), 'updated');
    };
    const updateRoomSlaWeights = async (roomId, sla) => {
      await LivechatRooms.setSlaForRoomById(roomId, sla);
    };
    const removeInquiryQueueSla = async roomId => {
      await LivechatInquiry.unsetSlaForRoom(roomId);
    };
    const removeSlaFromRoom = async roomId => {
      await LivechatRooms.removeSlaFromRoomById(roomId);
    };
    const addSlaChangeHistoryToRoom = async (roomId, user, sla) => {
      await Message.saveSystemMessage('omnichannel_sla_change_history', roomId, '', user, {
        slaData: _objectSpread({
          definedBy: {
            _id: user._id,
            username: user.username
          }
        }, sla && {
          sla
        })
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"VisitorInactivityMonitor.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/VisitorInactivityMonitor.ts                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      VisitorInactivityMonitor: () => VisitorInactivityMonitor
    });
    let OmnichannelEEService;
    module.link("@rocket.chat/core-services", {
      OmnichannelEEService(v) {
        OmnichannelEEService = v;
      }
    }, 0);
    let cronJobs;
    module.link("@rocket.chat/cron", {
      cronJobs(v) {
        cronJobs = v;
      }
    }, 1);
    let LivechatVisitors, LivechatRooms, LivechatDepartment, Users;
    module.link("@rocket.chat/models", {
      LivechatVisitors(v) {
        LivechatVisitors = v;
      },
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      Users(v) {
        Users = v;
      }
    }, 2);
    let schedulerLogger;
    module.link("./logger", {
      schedulerLogger(v) {
        schedulerLogger = v;
      }
    }, 3);
    let notifyOnRoomChangedById;
    module.link("../../../../../app/lib/server/lib/notifyListener", {
      notifyOnRoomChangedById(v) {
        notifyOnRoomChangedById = v;
      }
    }, 4);
    let closeRoom;
    module.link("../../../../../app/livechat/server/lib/closeRoom", {
      closeRoom(v) {
        closeRoom = v;
      }
    }, 5);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 6);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 7);
    let i18n;
    module.link("../../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 8);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const isPromiseRejectedResult = result => result && result.status === 'rejected';
    class VisitorInactivityMonitor {
      constructor() {
        this._started = void 0;
        this._name = void 0;
        this.messageCache = void 0;
        this.user = void 0;
        this.logger = void 0;
        this.scheduler = cronJobs;
        this._started = false;
        this._name = 'Omnichannel Visitor Inactivity Monitor';
        this.messageCache = new Map();
        this.logger = schedulerLogger.section(this._name);
      }
      async start() {
        await this._startMonitoring();
        this._initializeMessageCache();
        const cat = await Users.findOneById('rocket.cat');
        if (cat) {
          this.user = cat;
        }
      }
      async _startMonitoring() {
        if (this.isRunning()) {
          this.logger.debug('Already running');
          return;
        }
        const everyMinute = '* * * * *';
        await this.scheduler.add(this._name, everyMinute, async () => this.handleAbandonedRooms());
        this._started = true;
        this.logger.info('Service started');
      }
      async stop() {
        if (!this.isRunning()) {
          return;
        }
        await this.scheduler.remove(this._name);
        this._started = false;
        this.logger.info('Service stopped');
      }
      isRunning() {
        return this._started;
      }
      _initializeMessageCache() {
        this.messageCache.clear();
      }
      async _getDepartmentAbandonedCustomMessage(departmentId) {
        if (this.messageCache.has(departmentId)) {
          return this.messageCache.get(departmentId);
        }
        const department = await LivechatDepartment.findOneById(departmentId, {
          projection: {
            _id: 1,
            abandonedRoomsCloseCustomMessage: 1
          }
        });
        if (!department) {
          this.logger.error("Department ".concat(departmentId, " not found"));
          return;
        }
        this.messageCache.set(department._id, department.abandonedRoomsCloseCustomMessage);
        return department.abandonedRoomsCloseCustomMessage;
      }
      async closeRooms(room) {
        let comment = await this.getDefaultAbandonedCustomMessage('close', room.v._id);
        if (room.departmentId) {
          comment = (await this._getDepartmentAbandonedCustomMessage(room.departmentId)) || comment;
        }
        await closeRoom({
          comment,
          room,
          user: this.user
        });
        void notifyOnRoomChangedById(room._id);
        this.logger.info("Room ".concat(room._id, " closed"));
      }
      async placeRoomOnHold(room) {
        const comment = await this.getDefaultAbandonedCustomMessage('on-hold', room.v._id);
        const result = await Promise.allSettled([OmnichannelEEService.placeRoomOnHold(room, comment, this.user), LivechatRooms.unsetPredictedVisitorAbandonmentByRoomId(room._id)]);
        const rejected = result.filter(isPromiseRejectedResult).map(r => r.reason);
        if (rejected.length) {
          this.logger.error({
            msg: 'Error placing room on hold',
            error: rejected
          });
          throw new Error('Error placing room on hold. Please check logs for more details.');
        }
        void notifyOnRoomChangedById(room._id);
      }
      async handleAbandonedRooms() {
        const action = settings.get('Livechat_abandoned_rooms_action');
        if (!action || action === 'none') {
          return;
        }
        const extraQuery = await callbacks.run('livechat.applyRoomRestrictions', {});
        const promises = [];
        await LivechatRooms.findAbandonedOpenRooms(new Date(), extraQuery).forEach(room => {
          switch (action) {
            case 'close':
              {
                this.logger.info("Closing room ".concat(room._id));
                promises.push(this.closeRooms(room));
                break;
              }
            case 'on-hold':
              {
                this.logger.info("Placing room ".concat(room._id, " on hold"));
                promises.push(this.placeRoomOnHold(room));
                break;
              }
          }
        });
        const result = await Promise.allSettled(promises);
        const errors = result.filter(isPromiseRejectedResult).map(r => r.reason);
        if (errors.length) {
          this.logger.error({
            msg: "Error while removing priority from ".concat(errors.length, " rooms"),
            reason: errors[0]
          });
        }
        this._initializeMessageCache();
      }
      async getDefaultAbandonedCustomMessage(abandonmentAction, visitorId) {
        const visitor = await LivechatVisitors.findOneEnabledById(visitorId, {
          projection: {
            name: 1,
            username: 1
          }
        });
        if (!visitor) {
          this.logger.error({
            msg: 'Error getting default abandoned custom message: visitor not found',
            visitorId
          });
          throw new Error('error-invalid_visitor');
        }
        const timeout = settings.get('Livechat_visitor_inactivity_timeout');
        const guest = visitor.name || visitor.username;
        if (abandonmentAction === 'on-hold') {
          return i18n.t('Omnichannel_On_Hold_due_to_inactivity', {
            guest,
            timeout
          });
        }
        return settings.get('Livechat_abandoned_rooms_closed_custom_message') || i18n.t('Omnichannel_chat_closed_due_to_inactivity', {
          guest,
          timeout
        });
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"debounceByParams.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/debounceByParams.ts                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      memoizeDebounce: () => memoizeDebounce
    });
    let debounce;
    module.link("lodash.debounce", {
      default(v) {
        debounce = v;
      }
    }, 0);
    let mem;
    module.link("mem", {
      default(v) {
        mem = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    function memoizeDebounce(func) {
      let wait = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      const debounceMemo = mem(
      // eslint-disable-next-line @typescript-eslint/no-unused-vars
      function () {
        return debounce(func, wait, options);
      });
      function wrappedFunction() {
        return debounceMemo(...arguments)(...arguments);
      }
      wrappedFunction.flush = function () {
        debounceMemo(...arguments).flush();
      };
      return wrappedFunction;
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"logger.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/logger.ts                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      logger: () => logger,
      queriesLogger: () => queriesLogger,
      helperLogger: () => helperLogger,
      cbLogger: () => cbLogger,
      bhLogger: () => bhLogger,
      contactLogger: () => contactLogger,
      schedulerLogger: () => schedulerLogger
    });
    let Logger;
    module.link("@rocket.chat/logger", {
      Logger(v) {
        Logger = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const logger = new Logger('LivechatEnterprise');
    const queriesLogger = logger.section('Queries');
    const helperLogger = logger.section('Helper');
    const cbLogger = logger.section('Callbacks');
    const bhLogger = logger.section('Business-Hours');
    const contactLogger = logger.section('Contacts');
    const schedulerLogger = new Logger('Scheduler');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"requestPdfTranscript.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/requestPdfTranscript.ts                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      requestPdfTranscript: () => requestPdfTranscript
    });
    let OmnichannelTranscript, QueueWorker;
    module.link("@rocket.chat/core-services", {
      OmnichannelTranscript(v) {
        OmnichannelTranscript = v;
      },
      QueueWorker(v) {
        QueueWorker = v;
      }
    }, 0);
    let ExpiryMap;
    module.link("expiry-map", {
      default(v) {
        ExpiryMap = v;
      }
    }, 1);
    let logger;
    module.link("./logger", {
      logger(v) {
        logger = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    // Allow to request a transcript again after 15 seconds, assuming the first one didn't complete
    // This won't prevent multiple transcript generated for the same room in a multi-instance deployment since state is not shared, but we're ok with the drawbacks
    const LockMap = new ExpiryMap(15000);
    const serviceName = 'omnichannel-transcript';
    const requestPdfTranscript = async (room, requestedBy) => {
      if (room.open) {
        throw new Error('room-still-open');
      }
      if (!room.v) {
        throw new Error('improper-room-state');
      }
      // Don't request a transcript if there's already one requested
      if (LockMap.has(room._id) || room.pdfTranscriptFileId) {
        // TODO: use logger
        logger.info({
          msg: "Transcript already requested",
          roomId: room._id
        });
        return;
      }
      LockMap.set(room._id, true);
      const details = {
        details: {
          rid: room._id,
          userId: requestedBy,
          from: serviceName
        }
      };
      // Make the whole process sync when running on test mode
      // This will prevent the usage of timeouts on the tests of this functionality :)
      if (process.env.TEST_MODE) {
        await OmnichannelTranscript.workOnPdf(details);
        return;
      }
      logger.info("Queuing work for room ".concat(room._id));
      await QueueWorker.queueWork('work', "".concat(serviceName, ".workOnPdf"), details);
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"restrictQuery.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/restrictQuery.ts                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      restrictQuery: () => restrictQuery
    });
    let LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 0);
    let getUnitsFromUser;
    module.link("@rocket.chat/omni-core-ee", {
      getUnitsFromUser(v) {
        getUnitsFromUser = v;
      }
    }, 1);
    let cbLogger;
    module.link("./logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const restrictQuery = async _ref => {
      let {
        originalQuery = {},
        unitsFilter,
        userId
      } = _ref;
      const query = _objectSpread({}, originalQuery);
      let userUnits = await getUnitsFromUser(userId);
      if (!Array.isArray(userUnits)) {
        if (Array.isArray(unitsFilter) && unitsFilter.length) {
          return _objectSpread(_objectSpread({}, query), {}, {
            departmentAncestors: {
              $in: unitsFilter
            }
          });
        }
        return query;
      }
      if (Array.isArray(unitsFilter) && unitsFilter.length) {
        const userUnit = new Set([...userUnits]);
        const filteredUnits = new Set(unitsFilter);
        // IF user is trying to filter by a unit he doens't have access to, apply empty filter (no matches)
        userUnits = [...userUnit.intersection(filteredUnits)];
      }
      const departments = await LivechatDepartment.find({
        $or: [{
          ancestors: {
            $in: userUnits
          }
        }, {
          _id: {
            $in: userUnits
          }
        }]
      }, {
        projection: {
          _id: 1
        }
      }).toArray();
      const expressions = query.$and || [];
      const condition = {
        $or: [{
          departmentAncestors: {
            $in: userUnits
          }
        }, {
          departmentId: {
            $in: departments.map(_ref2 => {
              let {
                _id
              } = _ref2;
              return _id;
            })
          }
        }, {
          departmentId: {
            $exists: false
          }
        }]
      };
      query.$and = [condition, ...expressions];
      cbLogger.debug({
        msg: 'Applying room query restrictions',
        userUnits,
        query
      });
      return query;
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"unit.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/lib/unit.ts                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatUnit;
    module.link("@rocket.chat/models", {
      LivechatUnit(v) {
        LivechatUnit = v;
      }
    }, 0);
    let getUnitsFromUser;
    module.link("@rocket.chat/omni-core-ee", {
      getUnitsFromUser(v) {
        getUnitsFromUser = v;
      }
    }, 1);
    let checkUnitsFromUser;
    module.link("../../../../../app/livechat/server/api/lib/livechat", {
      checkUnitsFromUser(v) {
        checkUnitsFromUser = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    checkUnitsFromUser.patch(async (_next, _ref) => {
      let {
        businessUnit,
        userId
      } = _ref;
      if (!businessUnit) {
        return;
      }
      const unitsFromUser = await getUnitsFromUser(userId);
      const unit = await LivechatUnit.findOneById(businessUnit, {
        projection: {
          _id: 1
        }
      }, {
        unitsFromUser
      });
      if (!unit) {
        throw new Meteor.Error('error-unit-not-found', "Error! No Active Business Unit found with id: ".concat(businessUnit));
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"hooks":{"addDepartmentAncestors.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/addDepartmentAncestors.ts                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatRooms, LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 0);
    let onNewRoom;
    module.link("../../../../../app/livechat/server/lib/hooks", {
      onNewRoom(v) {
        onNewRoom = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    onNewRoom.patch(async (originalFn, room) => {
      await originalFn(room);
      if (!room.departmentId) {
        return;
      }
      const department = await LivechatDepartment.findOneById(room.departmentId, {
        projection: {
          ancestors: 1
        }
      });
      if (!(department !== null && department !== void 0 && department.ancestors)) {
        return;
      }
      const {
        ancestors
      } = department;
      await LivechatRooms.updateDepartmentAncestorsById(room._id, ancestors);
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterForwardChatToAgent.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterForwardChatToAgent.ts                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatRooms;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.afterForwardChatToAgent', async function () {
      let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      const {
        rid
      } = options;
      if (!rid) {
        return options;
      }
      await LivechatRooms.unsetPredictedVisitorAbandonmentByRoomId(rid);
      return options;
    }, callbacks.priority.MEDIUM, 'livechat-after-forward-room-to-department');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterForwardChatToDepartment.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterForwardChatToDepartment.ts                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatRooms, LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    let cbLogger;
    module.link("../lib/logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.afterForwardChatToDepartment', async options => {
      const {
        rid,
        newDepartmentId
      } = options;
      const room = await LivechatRooms.findOneById(rid, {
        projection: {
          departmentAncestors: 1
        }
      });
      if (!room) {
        return options;
      }
      await LivechatRooms.unsetPredictedVisitorAbandonmentByRoomId(room._id);
      const department = await LivechatDepartment.findOneById(newDepartmentId, {
        projection: {
          ancestors: 1
        }
      });
      if (!department) {
        return options;
      }
      const {
        departmentAncestors
      } = room;
      const {
        ancestors
      } = department;
      if (!ancestors && !departmentAncestors) {
        return options;
      }
      cbLogger.debug("Updating department ".concat(newDepartmentId, " ancestors for room ").concat(rid));
      await LivechatRooms.updateDepartmentAncestorsById(room._id, ancestors);
      return options;
    }, callbacks.priority.MEDIUM, 'livechat-after-forward-room-to-department');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterInquiryQueued.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterInquiryQueued.ts                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      afterInquiryQueuedFunc: () => afterInquiryQueuedFunc
    });
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 0);
    let afterInquiryQueued;
    module.link("../../../../../app/livechat/server/lib/hooks", {
      afterInquiryQueued(v) {
        afterInquiryQueued = v;
      }
    }, 1);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 2);
    let OmnichannelQueueInactivityMonitor;
    module.link("../lib/QueueInactivityMonitor", {
      OmnichannelQueueInactivityMonitor(v) {
        OmnichannelQueueInactivityMonitor = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const afterInquiryQueuedFunc = async inquiry => {
      const timer = settings.get('Livechat_max_queue_wait_time');
      if (!(inquiry !== null && inquiry !== void 0 && inquiry._id) || !(inquiry !== null && inquiry !== void 0 && inquiry._updatedAt) || timer <= 0) {
        return void 0;
      }
      // schedule individual jobs instead of property for close inactivty
      const newQueueTime = moment(inquiry._updatedAt).add(timer, 'minutes');
      await OmnichannelQueueInactivityMonitor.scheduleInquiry(inquiry._id, new Date(newQueueTime.format()));
    };
    afterInquiryQueued.patch(async (originalFn, inquiry) => {
      await originalFn();
      return afterInquiryQueuedFunc(inquiry);
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterOnHold.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterOnHold.ts                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    let i18n;
    module.link("../../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 2);
    let AutoCloseOnHoldScheduler;
    module.link("../lib/AutoCloseOnHoldScheduler", {
      AutoCloseOnHoldScheduler(v) {
        AutoCloseOnHoldScheduler = v;
      }
    }, 3);
    let cbLogger;
    module.link("../lib/logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    let autoCloseOnHoldChatTimeout = 0;
    const handleAfterOnHold = async room => {
      const {
        _id: rid
      } = room;
      if (!rid) {
        return;
      }
      if (!autoCloseOnHoldChatTimeout || autoCloseOnHoldChatTimeout <= 0) {
        return;
      }
      cbLogger.debug("Scheduling room ".concat(rid, " to be closed in ").concat(autoCloseOnHoldChatTimeout, " seconds"));
      const closeComment = settings.get('Livechat_auto_close_on_hold_chats_custom_message') || i18n.t('Closed_automatically_because_chat_was_onhold_for_seconds', {
        onHoldTime: autoCloseOnHoldChatTimeout
      });
      await AutoCloseOnHoldScheduler.scheduleRoom(rid, autoCloseOnHoldChatTimeout, closeComment);
    };
    settings.watch('Livechat_auto_close_on_hold_chats_timeout', value => {
      autoCloseOnHoldChatTimeout = value;
      if (!value || value <= 0) {
        callbacks.remove('livechat:afterOnHold', 'livechat-auto-close-on-hold');
      }
      callbacks.add('livechat:afterOnHold', handleAfterOnHold, callbacks.priority.HIGH, 'livechat-auto-close-on-hold');
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterOnHoldChatResumed.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterOnHoldChatResumed.ts                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 0);
    let AutoCloseOnHoldScheduler;
    module.link("../lib/AutoCloseOnHoldScheduler", {
      AutoCloseOnHoldScheduler(v) {
        AutoCloseOnHoldScheduler = v;
      }
    }, 1);
    let cbLogger;
    module.link("../lib/logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const handleAfterOnHoldChatResumed = async room => {
      if (!(room !== null && room !== void 0 && room._id)) {
        return room;
      }
      const {
        _id: roomId
      } = room;
      cbLogger.debug("Removing current on hold timers for room ".concat(roomId));
      await AutoCloseOnHoldScheduler.unscheduleRoom(roomId);
      return room;
    };
    callbacks.add('livechat:afterOnHoldChatResumed', handleAfterOnHoldChatResumed, callbacks.priority.HIGH, 'livechat-after-on-hold-chat-resumed');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterRemoveDepartment.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterRemoveDepartment.ts                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatDepartment, LivechatUnit;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      LivechatUnit(v) {
        LivechatUnit = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    let cbLogger;
    module.link("../lib/logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const afterRemoveDepartment = async options => {
      if (!(options !== null && options !== void 0 && options.department)) {
        cbLogger.warn('No department found in options', options);
        return options;
      }
      const {
        department
      } = options;
      cbLogger.debug({
        msg: 'Post removal actions on EE code for department',
        department
      });
      await Promise.all([LivechatDepartment.removeDepartmentFromForwardListById(department._id), ...(department.parentId ? [LivechatUnit.decrementDepartmentsCount(department.parentId)] : [])]);
      return options;
    };
    callbacks.add('livechat.afterRemoveDepartment', options => afterRemoveDepartment(options), callbacks.priority.HIGH, 'livechat-after-remove-department');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterReturnRoomAsInquiry.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterReturnRoomAsInquiry.ts                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatRooms;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      }
    }, 0);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    settings.watch('Livechat_abandoned_rooms_action', value => {
      if (!value || value === 'none') {
        callbacks.remove('livechat:afterReturnRoomAsInquiry', 'livechat-after-return-room-as-inquiry');
        return;
      }
      callbacks.add('livechat:afterReturnRoomAsInquiry', _ref => {
        var _room$omnichannel;
        let {
          room
        } = _ref;
        if (!(room !== null && room !== void 0 && room._id) || !(room !== null && room !== void 0 && (_room$omnichannel = room.omnichannel) !== null && _room$omnichannel !== void 0 && _room$omnichannel.predictedVisitorAbandonmentAt)) {
          return;
        }
        return LivechatRooms.unsetPredictedVisitorAbandonmentByRoomId(room._id);
      }, callbacks.priority.HIGH, 'livechat-after-return-room-as-inquiry');
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterTagRemoved.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterTagRemoved.ts                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let CannedResponse;
    module.link("@rocket.chat/models", {
      CannedResponse(v) {
        CannedResponse = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.afterTagRemoved', async tag => {
      const {
        name
      } = tag;
      await CannedResponse.removeTagFromCannedResponses(name);
    }, callbacks.priority.MEDIUM, 'on-tag-removed-remove-references');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterTakeInquiry.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/afterTakeInquiry.ts                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let LivechatVisitors;
    module.link("@rocket.chat/models", {
      LivechatVisitors(v) {
        LivechatVisitors = v;
      }
    }, 0);
    let RoutingManager;
    module.link("../../../../../app/livechat/server/lib/RoutingManager", {
      RoutingManager(v) {
        RoutingManager = v;
      }
    }, 1);
    let afterTakeInquiry;
    module.link("../../../../../app/livechat/server/lib/hooks", {
      afterTakeInquiry(v) {
        afterTakeInquiry = v;
      }
    }, 2);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 3);
    let AutoTransferChatScheduler;
    module.link("../lib/AutoTransferChatScheduler", {
      AutoTransferChatScheduler(v) {
        AutoTransferChatScheduler = v;
      }
    }, 4);
    let debouncedDispatchWaitingQueueStatus;
    module.link("../lib/Helper", {
      debouncedDispatchWaitingQueueStatus(v) {
        debouncedDispatchWaitingQueueStatus = v;
      }
    }, 5);
    let OmnichannelQueueInactivityMonitor;
    module.link("../lib/QueueInactivityMonitor", {
      OmnichannelQueueInactivityMonitor(v) {
        OmnichannelQueueInactivityMonitor = v;
      }
    }, 6);
    let cbLogger;
    module.link("../lib/logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 7);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    afterTakeInquiry.patch(async (originalFn, _ref) => {
      var _RoutingManager$getCo;
      let {
        inquiry,
        room,
        agent
      } = _ref;
      await originalFn({
        inquiry,
        room,
        agent
      });
      if (!inquiry) {
        return;
      }
      if (settings.get('Livechat_waiting_queue')) {
        const {
          department
        } = inquiry;
        void debouncedDispatchWaitingQueueStatus(department);
        cbLogger.debug({
          msg: 'Queue status updated',
          queue: department || 'public'
        });
      }
      if (settings.get('Livechat_last_chatted_agent_routing') && agent && (_RoutingManager$getCo = RoutingManager.getConfig()) !== null && _RoutingManager$getCo !== void 0 && _RoutingManager$getCo.autoAssignAgent) {
        const {
          v: {
            token
          } = {}
        } = inquiry;
        if (token) {
          await LivechatVisitors.updateLastAgentByToken(token, _objectSpread(_objectSpread({}, agent), {}, {
            ts: new Date()
          }));
          cbLogger.info({
            msg: 'Updated last agent of visitor',
            token,
            newAgent: {
              _id: agent.agentId,
              username: agent.username
            }
          });
        }
      }
      const autoTransferTimeout = settings.get('Livechat_auto_transfer_chat_timeout');
      if (autoTransferTimeout && !(room !== null && room !== void 0 && room.autoTransferredAt) && !(room !== null && room !== void 0 && room.autoTransferOngoing)) {
        await AutoTransferChatScheduler.scheduleRoom(inquiry.rid, autoTransferTimeout);
      }
      const maxQueueWaitTime = settings.get('Livechat_max_queue_wait_time');
      if (maxQueueWaitTime > 0) {
        await OmnichannelQueueInactivityMonitor.stopInquiry(inquiry._id);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"applyRoomRestrictions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/applyRoomRestrictions.ts                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 0);
    let restrictQuery;
    module.link("../lib/restrictQuery", {
      restrictQuery(v) {
        restrictQuery = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.applyRoomRestrictions', async function () {
      let originalQuery = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      let {
        unitsFilter,
        userId
      } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return restrictQuery({
        originalQuery,
        unitsFilter,
        userId
      });
    }, callbacks.priority.HIGH, 'livechat-apply-room-restrictions');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"applySimultaneousChatsRestrictions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/applySimultaneousChatsRestrictions.ts                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      getChatLimitsQuery: () => getChatLimitsQuery
    });
    let LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 0);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function getChatLimitsQuery(departmentId) {
      const limitFilter = [];
      if (departmentId) {
        var _await$LivechatDepart;
        const departmentLimit = ((_await$LivechatDepart = await LivechatDepartment.findOneById(departmentId, {
          projection: {
            maxNumberSimultaneousChat: 1
          }
        })) === null || _await$LivechatDepart === void 0 ? void 0 : _await$LivechatDepart.maxNumberSimultaneousChat) || 0;
        if (departmentLimit > 0) {
          limitFilter.push({
            'queueInfo.chatsForDepartment': {
              $gte: Number(departmentLimit)
            }
          });
        }
      }
      limitFilter.push({
        $and: [{
          maxChatsForAgent: {
            $gt: 0
          }
        }, {
          $expr: {
            $gte: ['$queueInfo.chats', '$maxChatsForAgent']
          }
        }]
      });
      const maxChatsPerSetting = settings.get('Livechat_maximum_chats_per_agent');
      if (maxChatsPerSetting > 0) {
        limitFilter.push({
          $and: [{
            maxChatsForAgent: {
              $eq: 0
            }
          }, {
            'queueInfo.chats': {
              $gte: maxChatsPerSetting
            }
          }]
        });
      }
      return {
        $match: {
          $or: limitFilter
        }
      };
    }
    callbacks.add('livechat.applySimultaneousChatRestrictions', async function (_) {
      let {
        departmentId
      } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return getChatLimitsQuery(departmentId);
    }, callbacks.priority.HIGH, 'livechat-apply-simultaneous-restrictions');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"beforeForwardRoomToDepartment.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/beforeForwardRoomToDepartment.ts                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.beforeForwardRoomToDepartment', async options => {
      const {
        room,
        transferData
      } = options;
      if (!room || !transferData) {
        return options;
      }
      const {
        departmentId
      } = room;
      if (!departmentId) {
        return options;
      }
      const {
        department: departmentToTransfer
      } = transferData;
      const currentDepartment = await LivechatDepartment.findOneById(departmentId, {
        projection: {
          departmentsAllowedToForward: 1
        }
      });
      if (!currentDepartment) {
        return options;
      }
      const {
        departmentsAllowedToForward
      } = currentDepartment;
      const isAllowedToTransfer = !(departmentsAllowedToForward !== null && departmentsAllowedToForward !== void 0 && departmentsAllowedToForward.length) || Array.isArray(departmentsAllowedToForward) && departmentsAllowedToForward.includes(departmentToTransfer._id);
      if (isAllowedToTransfer) {
        return options;
      }
      throw new Meteor.Error('error-forwarding-department-target-not-allowed', 'The forwarding to the target department is not allowed.');
    }, callbacks.priority.HIGH, 'livechat-before-forward-room-to-department');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"beforeJoinRoom.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/beforeJoinRoom.ts                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let isOmnichannelRoom;
    module.link("@rocket.chat/core-typings", {
      isOmnichannelRoom(v) {
        isOmnichannelRoom = v;
      }
    }, 0);
    let Users;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      }
    }, 1);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 2);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 3);
    let isAgentWithinChatLimits;
    module.link("../lib/Helper", {
      isAgentWithinChatLimits(v) {
        isAgentWithinChatLimits = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('beforeJoinRoom', async (user, room) => {
      if (!settings.get('Livechat_waiting_queue')) {
        return user;
      }
      if (!room || !isOmnichannelRoom(room)) {
        return user;
      }
      const {
        departmentId
      } = room;
      const userSubs = await Users.getAgentAndAmountOngoingChats(user._id, departmentId);
      if (!userSubs) {
        return user;
      }
      const {
        queueInfo: {
          chats = 0,
          chatsForDepartment = 0
        } = {}
      } = userSubs;
      if (await isAgentWithinChatLimits({
        agentId: user._id,
        departmentId,
        totalChats: chats,
        departmentChats: chatsForDepartment
      })) {
        return user;
      }
      throw new Error('error-max-number-simultaneous-chats-reached');
    }, callbacks.priority.MEDIUM, 'livechat-before-join-room');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"beforeListTags.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/beforeListTags.ts                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatTag;
    module.link("@rocket.chat/models", {
      LivechatTag(v) {
        LivechatTag = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.beforeListTags', () => LivechatTag.find({}, {
      projection: {
        name: 1,
        departments: 1
      }
    }).toArray(), callbacks.priority.LOW, 'livechat-before-list-tags');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"beforeNewInquiry.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/beforeNewInquiry.ts                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let _objectWithoutProperties;
    module.link("@babel/runtime/helpers/objectWithoutProperties", {
      default(v) {
        _objectWithoutProperties = v;
      }
    }, 1);
    const _excluded = ["sla", "priority"];
    let LivechatPriority, OmnichannelServiceLevelAgreements;
    module.link("@rocket.chat/models", {
      LivechatPriority(v) {
        LivechatPriority = v;
      },
      OmnichannelServiceLevelAgreements(v) {
        OmnichannelServiceLevelAgreements = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.beforeInquiry', async extraData => {
      const {
          sla: slaSearchTerm,
          priority: prioritySearchTerm
        } = extraData,
        props = _objectWithoutProperties(extraData, _excluded);
      if (!slaSearchTerm && !prioritySearchTerm) {
        return extraData;
      }
      let sla = null;
      let priority = null;
      if (slaSearchTerm) {
        sla = await OmnichannelServiceLevelAgreements.findOneByIdOrName(slaSearchTerm, {
          projection: {
            dueTimeInMinutes: 1
          }
        });
        if (!sla) {
          throw new Meteor.Error('error-invalid-sla', 'Invalid sla', {
            function: 'livechat.beforeInquiry'
          });
        }
      }
      if (prioritySearchTerm) {
        priority = await LivechatPriority.findOneByIdOrName(prioritySearchTerm, {
          projection: {
            _id: 1,
            sortItem: 1
          }
        });
        if (!priority) {
          throw new Meteor.Error('error-invalid-priority', 'Invalid priority', {
            function: 'livechat.beforeInquiry'
          });
        }
      }
      const ts = new Date();
      const changes = {
        ts
      };
      if (sla) {
        changes.slaId = sla._id;
        changes.estimatedWaitingTimeQueue = sla.dueTimeInMinutes;
      }
      if (priority) {
        changes.priorityId = priority._id;
        changes.priorityWeight = priority.sortItem;
      }
      return _objectSpread(_objectSpread({}, props), changes);
    }, callbacks.priority.MEDIUM, 'livechat-before-new-inquiry');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"beforeNewRoom.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/beforeNewRoom.ts                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      beforeNewRoomPatched: () => beforeNewRoomPatched
    });
    let OmnichannelServiceLevelAgreements;
    module.link("@rocket.chat/models", {
      OmnichannelServiceLevelAgreements(v) {
        OmnichannelServiceLevelAgreements = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let beforeNewRoom;
    module.link("../../../../../app/livechat/server/lib/hooks", {
      beforeNewRoom(v) {
        beforeNewRoom = v;
      }
    }, 2);
    let isPlainObject;
    module.link("../../../../../lib/utils/isPlainObject", {
      isPlainObject(v) {
        isPlainObject = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const beforeNewRoomPatched = async (_next, roomInfo, extraData) => {
      if (!extraData) {
        return roomInfo;
      }
      const {
        sla: searchTerm,
        customFields
      } = extraData;
      const roomInfoWithExtraData = _objectSpread(_objectSpread({}, roomInfo), isPlainObject(customFields) && {
        customFields
      });
      if (!searchTerm) {
        return roomInfoWithExtraData;
      }
      const sla = await OmnichannelServiceLevelAgreements.findOneByIdOrName(searchTerm);
      if (!sla) {
        throw new Meteor.Error('error-invalid-sla', 'Invalid sla', {
          function: 'livechat.beforeRoom'
        });
      }
      const {
        _id: slaId
      } = sla;
      return _objectSpread(_objectSpread({}, roomInfoWithExtraData), {}, {
        slaId
      });
    };
    beforeNewRoom.patch(beforeNewRoomPatched);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"beforeRoutingChat.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/beforeRoutingChat.ts                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatDepartment, LivechatInquiry, LivechatRooms;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      LivechatInquiry(v) {
        LivechatInquiry = v;
      },
      LivechatRooms(v) {
        LivechatRooms = v;
      }
    }, 0);
    let notifyOnLivechatInquiryChanged, notifyOnRoomChangedById;
    module.link("../../../../../app/lib/server/lib/notifyListener", {
      notifyOnLivechatInquiryChanged(v) {
        notifyOnLivechatInquiryChanged = v;
      },
      notifyOnRoomChangedById(v) {
        notifyOnRoomChangedById = v;
      }
    }, 1);
    let allowAgentSkipQueue;
    module.link("../../../../../app/livechat/server/lib/Helper", {
      allowAgentSkipQueue(v) {
        allowAgentSkipQueue = v;
      }
    }, 2);
    let saveQueueInquiry;
    module.link("../../../../../app/livechat/server/lib/QueueManager", {
      saveQueueInquiry(v) {
        saveQueueInquiry = v;
      }
    }, 3);
    let setDepartmentForGuest;
    module.link("../../../../../app/livechat/server/lib/departmentsLib", {
      setDepartmentForGuest(v) {
        setDepartmentForGuest = v;
      }
    }, 4);
    let beforeRouteChat;
    module.link("../../../../../app/livechat/server/lib/hooks", {
      beforeRouteChat(v) {
        beforeRouteChat = v;
      }
    }, 5);
    let online;
    module.link("../../../../../app/livechat/server/lib/service-status", {
      online(v) {
        online = v;
      }
    }, 6);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 7);
    let cbLogger;
    module.link("../lib/logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 8);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    beforeRouteChat.patch(async (originalFn, inquiry, agent) => {
      var _inquiry;
      await originalFn(inquiry, agent);
      if (!inquiry) {
        return inquiry;
      }
      if ((_inquiry = inquiry) !== null && _inquiry !== void 0 && _inquiry.department && !(await online(inquiry.department, true, true))) {
        const department = await LivechatDepartment.findOneById(inquiry.department, {
          projection: {
            fallbackForwardDepartment: 1
          }
        });
        if (!department) {
          return inquiry;
        }
        if (department.fallbackForwardDepartment) {
          cbLogger.info({
            msg: 'Moving inquiry to fallback department',
            originalDepartment: inquiry.department,
            fallbackDepartment: department.fallbackForwardDepartment,
            inquiryId: inquiry._id
          });
          const [, updatedLivechatInquiry] = await Promise.all([setDepartmentForGuest({
            visitorId: inquiry.v._id,
            department: department.fallbackForwardDepartment
          }), LivechatInquiry.setDepartmentByInquiryId(inquiry._id, department.fallbackForwardDepartment), LivechatRooms.setDepartmentByRoomId(inquiry.rid, department.fallbackForwardDepartment)]);
          if (updatedLivechatInquiry) {
            void notifyOnLivechatInquiryChanged(updatedLivechatInquiry, 'updated', {
              department: updatedLivechatInquiry.department
            });
          }
          void notifyOnRoomChangedById(inquiry.rid, 'updated');
          inquiry = updatedLivechatInquiry !== null && updatedLivechatInquiry !== void 0 ? updatedLivechatInquiry : inquiry;
        }
      }
      if (!settings.get('Livechat_waiting_queue')) {
        return inquiry;
      }
      if (agent && (await allowAgentSkipQueue(agent))) {
        return inquiry;
      }
      return saveQueueInquiry(inquiry);
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"checkAgentBeforeTakeInquiry.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/checkAgentBeforeTakeInquiry.ts                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let Users;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      }
    }, 0);
    let allowAgentSkipQueue;
    module.link("../../../../../app/livechat/server/lib/Helper", {
      allowAgentSkipQueue(v) {
        allowAgentSkipQueue = v;
      }
    }, 1);
    let checkOnlineAgents;
    module.link("../../../../../app/livechat/server/lib/service-status", {
      checkOnlineAgents(v) {
        checkOnlineAgents = v;
      }
    }, 2);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 3);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 4);
    let isAgentWithinChatLimits;
    module.link("../lib/Helper", {
      isAgentWithinChatLimits(v) {
        isAgentWithinChatLimits = v;
      }
    }, 5);
    let cbLogger;
    module.link("../lib/logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const validateMaxChats = async _ref => {
      let {
        agent,
        inquiry
      } = _ref;
      if (!(inquiry !== null && inquiry !== void 0 && inquiry._id) || !(agent !== null && agent !== void 0 && agent.agentId)) {
        cbLogger.debug('No inquiry or agent provided');
        throw new Error('No inquiry or agent provided');
      }
      const {
        agentId
      } = agent;
      if (!(await checkOnlineAgents(undefined, agent))) {
        cbLogger.debug('Provided agent is not online');
        throw new Error('Provided agent is not online');
      }
      if (!settings.get('Livechat_waiting_queue')) {
        cbLogger.info("Chat can be taken by Agent ".concat(agentId, ": waiting queue is disabled"));
        return agent;
      }
      if (await allowAgentSkipQueue(agent)) {
        cbLogger.info("Chat can be taken by Agent ".concat(agentId, ": agent can skip queue"));
        return agent;
      }
      const {
        department: departmentId
      } = inquiry;
      const user = await Users.getAgentAndAmountOngoingChats(agentId, departmentId);
      if (!user) {
        cbLogger.debug({
          msg: 'No valid agent found',
          agentId
        });
        throw new Error('No valid agent found');
      }
      const {
        queueInfo: {
          chats = 0,
          chatsForDepartment = 0
        } = {}
      } = user;
      if (await isAgentWithinChatLimits({
        agentId,
        departmentId,
        totalChats: chats,
        departmentChats: chatsForDepartment
      })) {
        return user;
      }
      throw new Error('error-max-number-simultaneous-chats-reached');
    };
    callbacks.add('livechat.checkAgentBeforeTakeInquiry', validateMaxChats, callbacks.priority.MEDIUM, 'livechat-before-take-inquiry');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"handleNextAgentPreferredEvents.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/handleNextAgentPreferredEvents.ts                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatVisitors, LivechatContacts, LivechatInquiry, LivechatRooms, Users;
    module.link("@rocket.chat/models", {
      LivechatVisitors(v) {
        LivechatVisitors = v;
      },
      LivechatContacts(v) {
        LivechatContacts = v;
      },
      LivechatInquiry(v) {
        LivechatInquiry = v;
      },
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      Users(v) {
        Users = v;
      }
    }, 0);
    let notifyOnLivechatInquiryChanged;
    module.link("../../../../../app/lib/server/lib/notifyListener", {
      notifyOnLivechatInquiryChanged(v) {
        notifyOnLivechatInquiryChanged = v;
      }
    }, 1);
    let RoutingManager;
    module.link("../../../../../app/livechat/server/lib/RoutingManager", {
      RoutingManager(v) {
        RoutingManager = v;
      }
    }, 2);
    let migrateVisitorIfMissingContact;
    module.link("../../../../../app/livechat/server/lib/contacts/migrateVisitorIfMissingContact", {
      migrateVisitorIfMissingContact(v) {
        migrateVisitorIfMissingContact = v;
      }
    }, 3);
    let checkDefaultAgentOnNewRoom;
    module.link("../../../../../app/livechat/server/lib/hooks", {
      checkDefaultAgentOnNewRoom(v) {
        checkDefaultAgentOnNewRoom = v;
      }
    }, 4);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 5);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const normalizeDefaultAgent = agent => {
      if (!agent) {
        return undefined;
      }
      const {
        _id: agentId,
        username
      } = agent;
      return {
        agentId,
        username
      };
    };
    const getDefaultAgent = async _ref => {
      let {
        username,
        id
      } = _ref;
      if (!username && !id) {
        return undefined;
      }
      if (id) {
        const agent = await Users.findOneOnlineAgentById(id, settings.get('Livechat_enabled_when_agent_idle'), {
          projection: {
            _id: 1,
            username: 1
          }
        });
        if (agent) {
          return normalizeDefaultAgent(agent);
        }
        const offlineAgent = await Users.findOneAgentById(id, {
          projection: {
            _id: 1,
            username: 1
          }
        });
        if (offlineAgent && settings.get('Livechat_accept_chats_with_no_agents')) {
          return normalizeDefaultAgent(offlineAgent);
        }
        return undefined;
      }
      return normalizeDefaultAgent(await Users.findOneOnlineAgentByUserList(username || [], {
        projection: {
          _id: 1,
          username: 1
        }
      }, settings.get('Livechat_enabled_when_agent_idle')));
    };
    settings.watch('Livechat_last_chatted_agent_routing', value => {
      if (!value) {
        callbacks.remove('livechat.onMaxNumberSimultaneousChatsReached', 'livechat-on-max-number-simultaneous-chats-reached');
        return;
      }
      callbacks.add('livechat.onMaxNumberSimultaneousChatsReached', async inquiry => {
        var _RoutingManager$getCo;
        if (!(inquiry !== null && inquiry !== void 0 && inquiry.defaultAgent)) {
          return inquiry;
        }
        if (!((_RoutingManager$getCo = RoutingManager.getConfig()) !== null && _RoutingManager$getCo !== void 0 && _RoutingManager$getCo.autoAssignAgent)) {
          return inquiry;
        }
        await LivechatInquiry.removeDefaultAgentById(inquiry._id);
        void notifyOnLivechatInquiryChanged(inquiry, 'updated', {
          defaultAgent: undefined
        });
        return LivechatInquiry.findOneById(inquiry._id);
      }, callbacks.priority.MEDIUM, 'livechat-on-max-number-simultaneous-chats-reached');
    });
    checkDefaultAgentOnNewRoom.patch(async function (_next, defaultAgent) {
      let {
        visitorId,
        source
      } = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      if (!visitorId || !source) {
        return defaultAgent;
      }
      const guest = await LivechatVisitors.findOneEnabledById(visitorId, {
        projection: {
          lastAgent: 1,
          token: 1,
          contactManager: 1
        }
      });
      if (!guest) {
        return defaultAgent;
      }
      const hasDivergentContactManager = (defaultAgent === null || defaultAgent === void 0 ? void 0 : defaultAgent.agentId) !== (guest === null || guest === void 0 ? void 0 : guest.contactManager);
      if (!hasDivergentContactManager && defaultAgent) {
        return defaultAgent;
      }
      const contactId = await migrateVisitorIfMissingContact(visitorId, source);
      const contact = contactId ? await LivechatContacts.findOneEnabledById(contactId, {
        projection: {
          contactManager: 1
        }
      }) : undefined;
      const contactManagerPreferred = settings.get('Omnichannel_contact_manager_routing');
      const guestManager = contactManagerPreferred && (await getDefaultAgent({
        id: contact === null || contact === void 0 ? void 0 : contact.contactManager
      }));
      if (guestManager) {
        return guestManager;
      }
      if (!settings.get('Livechat_last_chatted_agent_routing')) {
        return defaultAgent;
      }
      const {
        lastAgent,
        token
      } = guest;
      const guestAgent = await getDefaultAgent({
        username: lastAgent === null || lastAgent === void 0 ? void 0 : lastAgent.username
      });
      if (guestAgent) {
        return guestAgent;
      }
      const room = await LivechatRooms.findOneLastServedAndClosedByVisitorToken(token, {
        projection: {
          servedBy: 1
        }
      });
      if (!(room !== null && room !== void 0 && room.servedBy)) {
        return defaultAgent;
      }
      const {
        servedBy: {
          username: usernameByRoom
        }
      } = room;
      if (!usernameByRoom) {
        return defaultAgent;
      }
      const lastRoomAgent = normalizeDefaultAgent(await Users.findOneOnlineAgentByUserList(usernameByRoom, {
        projection: {
          _id: 1,
          username: 1
        }
      }, settings.get('Livechat_enabled_when_agent_idle')));
      return lastRoomAgent;
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/index.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./addDepartmentAncestors");
    module.link("./afterForwardChatToDepartment");
    module.link("./beforeListTags");
    module.link("./beforeJoinRoom");
    module.link("./setPredictedVisitorAbandonmentTime");
    module.link("./beforeForwardRoomToDepartment");
    module.link("./afterRemoveDepartment");
    module.link("./onLoadForwardDepartmentRestrictions");
    module.link("./afterTakeInquiry");
    module.link("./beforeNewInquiry");
    module.link("./beforeNewRoom");
    module.link("./beforeRoutingChat");
    module.link("./checkAgentBeforeTakeInquiry");
    module.link("./onCloseLivechat");
    module.link("./onSaveVisitorInfo");
    module.link("./onBusinessHourStart");
    module.link("./onAgentAssignmentFailed");
    module.link("./afterOnHoldChatResumed");
    module.link("./afterReturnRoomAsInquiry");
    module.link("./afterForwardChatToAgent");
    module.link("./applySimultaneousChatsRestrictions");
    module.link("./afterInquiryQueued");
    module.link("./sendPdfTranscriptOnClose");
    module.link("./applyRoomRestrictions");
    module.link("./afterTagRemoved");
    module.link("./manageDepartmentUnit");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"manageDepartmentUnit.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/manageDepartmentUnit.ts                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      manageDepartmentUnit: () => manageDepartmentUnit
    });
    let LivechatDepartment, LivechatUnit;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      LivechatUnit(v) {
        LivechatUnit = v;
      }
    }, 0);
    let getUnitsFromUser;
    module.link("@rocket.chat/omni-core-ee", {
      getUnitsFromUser(v) {
        getUnitsFromUser = v;
      }
    }, 1);
    let hasAnyRoleAsync;
    module.link("../../../../../app/authorization/server/functions/hasRole", {
      hasAnyRoleAsync(v) {
        hasAnyRoleAsync = v;
      }
    }, 2);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const manageDepartmentUnit = async _ref => {
      var _department$ancestors;
      let {
        userId,
        departmentId,
        unitId
      } = _ref;
      const accessibleUnits = await getUnitsFromUser(userId);
      const isLivechatManager = await hasAnyRoleAsync(userId, ['admin', 'livechat-manager']);
      const department = await LivechatDepartment.findOneById(departmentId, {
        projection: {
          ancestors: 1,
          parentId: 1
        }
      });
      const isDepartmentAlreadyInUnit = unitId && (department === null || department === void 0 ? void 0 : (_department$ancestors = department.ancestors) === null || _department$ancestors === void 0 ? void 0 : _department$ancestors.includes(unitId));
      if (!department || isDepartmentAlreadyInUnit) {
        return;
      }
      const currentDepartmentUnitId = department.parentId;
      const canManageNewUnit = !unitId || isLivechatManager || Array.isArray(accessibleUnits) && accessibleUnits.includes(unitId);
      const canManageCurrentUnit = !currentDepartmentUnitId || isLivechatManager || Array.isArray(accessibleUnits) && accessibleUnits.includes(currentDepartmentUnitId);
      if (!canManageNewUnit || !canManageCurrentUnit) {
        return;
      }
      if (unitId) {
        const unit = await LivechatUnit.findOneById(unitId, {
          projection: {
            ancestors: 1
          }
        }, {
          unitsFromUser: accessibleUnits
        });
        if (!unit) {
          return;
        }
        if (currentDepartmentUnitId) {
          await LivechatUnit.decrementDepartmentsCount(currentDepartmentUnitId);
        }
        await LivechatDepartment.addDepartmentToUnit(departmentId, unitId, [unitId, ...(unit.ancestors || [])]);
        await LivechatUnit.incrementDepartmentsCount(unitId);
        return;
      }
      if (currentDepartmentUnitId) {
        await LivechatUnit.decrementDepartmentsCount(currentDepartmentUnitId);
      }
      await LivechatDepartment.removeDepartmentFromUnit(departmentId);
    };
    callbacks.add('livechat.manageDepartmentUnit', manageDepartmentUnit, callbacks.priority.HIGH, 'livechat-manage-department-unit');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onAgentAssignmentFailed.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/onAgentAssignmentFailed.ts                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const handleOnAgentAssignmentFailed = async (room, _ref) => {
      let {
        inquiry,
        options
      } = _ref;
      if (!inquiry || !room) {
        return;
      }
      if (!settings.get('Livechat_waiting_queue')) {
        return;
      }
      const {
        forwardingToDepartment: {
          oldDepartmentId
        } = {},
        forwardingToDepartment
      } = options;
      if (!forwardingToDepartment) {
        return;
      }
      const {
        department: newDepartmentId
      } = inquiry;
      if (!newDepartmentId || !oldDepartmentId || newDepartmentId === oldDepartmentId) {
        return;
      }
      return _objectSpread(_objectSpread({}, room), {}, {
        chatQueued: true
      });
    };
    callbacks.add('livechat.onAgentAssignmentFailed', handleOnAgentAssignmentFailed, callbacks.priority.HIGH, 'livechat-agent-assignment-failed');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onBusinessHourStart.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/onBusinessHourStart.ts                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatBusinessHourBehaviors;
    module.link("@rocket.chat/core-typings", {
      LivechatBusinessHourBehaviors(v) {
        LivechatBusinessHourBehaviors = v;
      }
    }, 0);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    let MultipleBusinessHoursBehavior;
    module.link("../business-hour/Multiple", {
      MultipleBusinessHoursBehavior(v) {
        MultipleBusinessHoursBehavior = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('on-business-hour-start', function () {
      let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      const {
        BusinessHourBehaviorClass
      } = options;
      if (!BusinessHourBehaviorClass) {
        return options;
      }
      if (settings.get('Livechat_business_hour_type') === LivechatBusinessHourBehaviors.SINGLE) {
        return options;
      }
      return {
        BusinessHourBehaviorClass: MultipleBusinessHoursBehavior
      };
    }, callbacks.priority.HIGH, 'livechat-on-business-hour-start');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onCheckRoomParamsApi.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/onCheckRoomParamsApi.ts                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let Match;
    module.link("meteor/check", {
      Match(v) {
        Match = v;
      }
    }, 0);
    let onCheckRoomParams;
    module.link("../../../../../app/livechat/server/api/lib/livechat", {
      onCheckRoomParams(v) {
        onCheckRoomParams = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    onCheckRoomParams.patch((_, params) => _objectSpread(_objectSpread({}, params), {}, {
      sla: Match.Maybe(String),
      priority: Match.Maybe(String)
    }));
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onCloseLivechat.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/onCloseLivechat.ts                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatRooms;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      }
    }, 0);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    let AutoCloseOnHoldScheduler;
    module.link("../lib/AutoCloseOnHoldScheduler", {
      AutoCloseOnHoldScheduler(v) {
        AutoCloseOnHoldScheduler = v;
      }
    }, 3);
    let debouncedDispatchWaitingQueueStatus;
    module.link("../lib/Helper", {
      debouncedDispatchWaitingQueueStatus(v) {
        debouncedDispatchWaitingQueueStatus = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const onCloseLivechat = async params => {
      const {
        room,
        room: {
          _id: roomId
        }
      } = params;
      await LivechatRooms.unsetOnHoldByRoomId(roomId);
      if (settings.get('Livechat_auto_close_on_hold_chats_timeout')) {
        await AutoCloseOnHoldScheduler.unscheduleRoom(roomId);
      }
      if (!settings.get('Livechat_waiting_queue')) {
        return params;
      }
      const {
        departmentId
      } = room || {};
      debouncedDispatchWaitingQueueStatus(departmentId);
      return params;
    };
    callbacks.add('livechat.closeRoom', params => onCloseLivechat(params), callbacks.priority.HIGH, 'livechat-on-close-livechat-remove-on-hold-and-dispatch-waiting-queue');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onLoadConfigApi.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/onLoadConfigApi.ts                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let getExtraConfigInfo;
    module.link("../../../../../app/livechat/server/api/lib/livechat", {
      getExtraConfigInfo(v) {
        getExtraConfigInfo = v;
      }
    }, 0);
    let getLivechatQueueInfo, getLivechatCustomFields;
    module.link("../lib/Helper", {
      getLivechatQueueInfo(v) {
        getLivechatQueueInfo = v;
      },
      getLivechatCustomFields(v) {
        getLivechatCustomFields = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    getExtraConfigInfo.patch(async (_, options) => {
      const {
        room
      } = options;
      const [queueInfo, customFields] = await Promise.all([getLivechatQueueInfo(room), getLivechatCustomFields()]);
      return _objectSpread(_objectSpread(_objectSpread({}, queueInfo && {
        queueInfo
      }), customFields && {
        customFields
      }), options);
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onLoadForwardDepartmentRestrictions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/onLoadForwardDepartmentRestrictions.ts                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.onLoadForwardDepartmentRestrictions', async options => {
      const {
        departmentId
      } = options;
      if (!departmentId) {
        return options;
      }
      const department = await LivechatDepartment.findOneById(departmentId, {
        projection: {
          departmentsAllowedToForward: 1
        }
      });
      if (!department) {
        return options;
      }
      const {
        departmentsAllowedToForward
      } = department;
      if (!departmentsAllowedToForward) {
        return options;
      }
      return Object.assign({
        restrictions: {
          _id: {
            $in: departmentsAllowedToForward
          }
        }
      }, options);
    }, callbacks.priority.MEDIUM, 'livechat-on-load-forward-department-restrictions');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onSaveVisitorInfo.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/onSaveVisitorInfo.ts                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let OmnichannelServiceLevelAgreements;
    module.link("@rocket.chat/models", {
      OmnichannelServiceLevelAgreements(v) {
        OmnichannelServiceLevelAgreements = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    let removePriorityFromRoom, updateRoomPriority;
    module.link("../api/lib/priorities", {
      removePriorityFromRoom(v) {
        removePriorityFromRoom = v;
      },
      updateRoomPriority(v) {
        updateRoomPriority = v;
      }
    }, 2);
    let removeRoomSLA, updateRoomSLA;
    module.link("../api/lib/sla", {
      removeRoomSLA(v) {
        removeRoomSLA = v;
      },
      updateRoomSLA(v) {
        updateRoomSLA = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const updateSLA = async (room, user, slaId) => {
      if (!slaId) {
        return removeRoomSLA(room._id, user);
      }
      const sla = await OmnichannelServiceLevelAgreements.findOneById(slaId, {
        projection: {
          _id: 1,
          name: 1,
          dueTimeInMinutes: 1
        }
      });
      if (!sla) {
        throw new Error("SLA not found with id: ".concat(slaId));
      }
      await updateRoomSLA(room._id, user, sla);
    };
    const updatePriority = async (room, user, priorityId) => {
      if (!priorityId) {
        return removePriorityFromRoom(room._id, user);
      }
      await updateRoomPriority(room._id, user, priorityId);
    };
    callbacks.add('livechat.saveInfo', async (room, _ref) => {
      let {
        user,
        oldRoom
      } = _ref;
      const {
        slaId: oldSlaId,
        priorityId: oldPriorityId
      } = oldRoom;
      const {
        slaId: newSlaId,
        priorityId: newPriorityId
      } = room;
      if (oldSlaId === newSlaId && oldPriorityId === newPriorityId) {
        return room;
      }
      if (oldSlaId === newSlaId && oldPriorityId !== newPriorityId) {
        await updatePriority(room, user, newPriorityId);
      } else if (oldSlaId !== newSlaId && oldPriorityId === newPriorityId) {
        await updateSLA(room, user, newSlaId);
      } else {
        await Promise.all([updateSLA(room, user, newSlaId), updatePriority(room, user, newPriorityId)]);
      }
      return room;
    }, callbacks.priority.HIGH, 'livechat-on-save-room-info');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onTransferFailure.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/onTransferFailure.ts                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let isOmnichannelRoom;
    module.link("@rocket.chat/core-typings", {
      isOmnichannelRoom(v) {
        isOmnichannelRoom = v;
      }
    }, 0);
    let LivechatDepartment;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      }
    }, 1);
    let forwardRoomToDepartment;
    module.link("../../../../../app/livechat/server/lib/Helper", {
      forwardRoomToDepartment(v) {
        forwardRoomToDepartment = v;
      }
    }, 2);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 3);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 4);
    let cbLogger;
    module.link("../lib/logger", {
      cbLogger(v) {
        cbLogger = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const onTransferFailure = async (room, _ref) => {
      var _department$fallbackF;
      let {
        guest,
        transferData,
        department
      } = _ref;
      if (!isOmnichannelRoom(room)) {
        return false;
      }
      if (!(department !== null && department !== void 0 && (_department$fallbackF = department.fallbackForwardDepartment) !== null && _department$fallbackF !== void 0 && _department$fallbackF.length)) {
        return false;
      }
      // TODO: find enabled not archived here
      const fallbackDepartment = await LivechatDepartment.findOneById(department.fallbackForwardDepartment, {
        projection: {
          name: 1,
          _id: 1
        }
      });
      if (!fallbackDepartment) {
        return false;
      }
      const {
        hops: currentHops = 1
      } = transferData;
      const maxHops = settings.get('Omnichannel_max_fallback_forward_depth');
      if (currentHops > maxHops) {
        cbLogger.debug({
          msg: 'Max fallback forward depth reached. Chat wont be transfered',
          roomId: room._id,
          hops: currentHops,
          maxHops,
          departmentId: department._id
        });
        return false;
      }
      const transferDataFallback = _objectSpread(_objectSpread({}, transferData), {}, {
        usingFallbackDep: true,
        prevDepartment: department.name,
        departmentId: department.fallbackForwardDepartment,
        department: fallbackDepartment,
        hops: currentHops + 1
      });
      const forwardSuccess = await forwardRoomToDepartment(room, guest, transferDataFallback);
      if (!forwardSuccess) {
        cbLogger.debug({
          msg: 'Fallback forward failed',
          departmentId: department._id,
          roomId: room._id,
          fallbackDepartmentId: department.fallbackForwardDepartment
        });
        return false;
      }
      cbLogger.info({
        msg: 'Fallback forward success',
        departmentId: department._id,
        roomId: room._id,
        fallbackDepartmentId: department.fallbackForwardDepartment
      });
      return true;
    };
    callbacks.add('livechat:onTransferFailure', onTransferFailure, callbacks.priority.HIGH);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"resumeOnHold.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/resumeOnHold.ts                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let OmnichannelEEService;
    module.link("@rocket.chat/core-services", {
      OmnichannelEEService(v) {
        OmnichannelEEService = v;
      }
    }, 0);
    let isMessageFromVisitor, isEditedMessage;
    module.link("@rocket.chat/core-typings", {
      isMessageFromVisitor(v) {
        isMessageFromVisitor = v;
      },
      isEditedMessage(v) {
        isEditedMessage = v;
      }
    }, 1);
    let LivechatRooms, LivechatVisitors, Users;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      LivechatVisitors(v) {
        LivechatVisitors = v;
      },
      Users(v) {
        Users = v;
      }
    }, 2);
    let callbackLogger;
    module.link("../../../../../app/livechat/server/lib/logger", {
      callbackLogger(v) {
        callbackLogger = v;
      }
    }, 3);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 4);
    let i18n;
    module.link("../../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const resumeOnHoldCommentAndUser = async room => {
      const {
        v: {
          _id: visitorId
        },
        _id: rid
      } = room;
      const visitor = await LivechatVisitors.findOneEnabledById(visitorId, {
        projection: {
          name: 1,
          username: 1
        }
      });
      if (!visitor) {
        callbackLogger.error("[afterOmnichannelSaveMessage] Visitor Not found for room ".concat(rid, " while trying to resume on hold"));
        throw new Error('Visitor not found while trying to resume on hold');
      }
      const guest = visitor.name || visitor.username;
      const resumeChatComment = i18n.t('Omnichannel_on_hold_chat_automatically', {
        guest
      });
      const resumedBy = await Users.findOneById('rocket.cat');
      if (!resumedBy) {
        callbackLogger.error("[afterOmnichannelSaveMessage] User Not found for room ".concat(rid, " while trying to resume on hold"));
        throw new Error("User not found while trying to resume on hold");
      }
      return {
        comment: resumeChatComment,
        resumedBy
      };
    };
    callbacks.add('afterOmnichannelSaveMessage', async (message, _ref) => {
      let {
        room
      } = _ref;
      if (isEditedMessage(message) || message.t) {
        return message;
      }
      const {
        _id: rid,
        v: roomVisitor
      } = room;
      if (!(roomVisitor !== null && roomVisitor !== void 0 && roomVisitor._id)) {
        return message;
      }
      // Need to read the room every time, the room object is not updated
      const updatedRoom = await LivechatRooms.findOneById(rid);
      if (!updatedRoom) {
        return message;
      }
      if (isMessageFromVisitor(message) && room.onHold) {
        callbackLogger.debug("[afterOmnichannelSaveMessage] Room ".concat(rid, " is on hold, resuming it now since visitor sent a message"));
        try {
          const {
            comment: resumeChatComment,
            resumedBy
          } = await resumeOnHoldCommentAndUser(updatedRoom);
          await OmnichannelEEService.resumeRoomOnHold(updatedRoom, resumeChatComment, resumedBy);
        } catch (error) {
          callbackLogger.error("[afterOmnichannelSaveMessage] Error while resuming room ".concat(rid, " on hold: Error: "), error);
          return message;
        }
      }
      return message;
    }, callbacks.priority.HIGH, 'livechat-resume-on-hold');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"scheduleAutoTransfer.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/scheduleAutoTransfer.ts                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    let AutoTransferChatScheduler;
    module.link("../lib/AutoTransferChatScheduler", {
      AutoTransferChatScheduler(v) {
        AutoTransferChatScheduler = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    let autoTransferTimeout = 0;
    const handleAfterCloseRoom = async params => {
      const {
        room
      } = params;
      const {
        _id: rid,
        autoTransferredAt,
        autoTransferOngoing
      } = room;
      if (!autoTransferTimeout || autoTransferTimeout <= 0) {
        return params;
      }
      if (autoTransferredAt) {
        return params;
      }
      if (!autoTransferOngoing) {
        return params;
      }
      await AutoTransferChatScheduler.unscheduleRoom(rid);
      return params;
    };
    settings.watch('Livechat_auto_transfer_chat_timeout', value => {
      autoTransferTimeout = value;
      if (!autoTransferTimeout || autoTransferTimeout === 0) {
        callbacks.remove('afterOmnichannelSaveMessage', 'livechat-cancel-auto-transfer-job-after-message');
        callbacks.remove('livechat.closeRoom', 'livechat-cancel-auto-transfer-on-close-room');
        return;
      }
      callbacks.add('afterOmnichannelSaveMessage', async (message, _ref) => {
        let {
          room
        } = _ref;
        const {
          _id: rid,
          autoTransferredAt,
          autoTransferOngoing
        } = room;
        const {
          token,
          t: messageType
        } = message;
        if (messageType) {
          // ignore system messages
          return message;
        }
        if (!autoTransferTimeout || autoTransferTimeout <= 0) {
          return message;
        }
        if (!message || token) {
          // ignore messages from visitors
          return message;
        }
        if (autoTransferredAt) {
          return message;
        }
        if (!autoTransferOngoing) {
          return message;
        }
        await AutoTransferChatScheduler.unscheduleRoom(rid);
        return message;
      }, callbacks.priority.HIGH, 'livechat-cancel-auto-transfer-job-after-message');
      callbacks.add('livechat.closeRoom', handleAfterCloseRoom, callbacks.priority.HIGH, 'livechat-cancel-auto-transfer-on-close-room');
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"sendPdfTranscriptOnClose.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/sendPdfTranscriptOnClose.ts                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let isOmnichannelRoom;
    module.link("@rocket.chat/core-typings", {
      isOmnichannelRoom(v) {
        isOmnichannelRoom = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    let requestPdfTranscript;
    module.link("../lib/requestPdfTranscript", {
      requestPdfTranscript(v) {
        requestPdfTranscript = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const sendPdfTranscriptOnClose = async params => {
      const {
        room,
        options
      } = params;
      if (!isOmnichannelRoom(room)) {
        return params;
      }
      const {
        pdfTranscript
      } = options || {};
      if (!pdfTranscript) {
        return params;
      }
      const {
        requestedBy
      } = pdfTranscript;
      await requestPdfTranscript(room, requestedBy);
      return params;
    };
    callbacks.add('livechat.closeRoom', sendPdfTranscriptOnClose, callbacks.priority.HIGH, 'livechat-send-pdf-transcript-on-close-room');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"setPredictedVisitorAbandonmentTime.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/hooks/setPredictedVisitorAbandonmentTime.ts                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let isEditedMessage, isMessageFromVisitor;
    module.link("@rocket.chat/core-typings", {
      isEditedMessage(v) {
        isEditedMessage = v;
      },
      isMessageFromVisitor(v) {
        isMessageFromVisitor = v;
      }
    }, 0);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 1);
    let markRoomResponded;
    module.link("../../../../../app/livechat/server/hooks/markRoomResponded", {
      markRoomResponded(v) {
        markRoomResponded = v;
      }
    }, 2);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 3);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 4);
    let setPredictedVisitorAbandonmentTime;
    module.link("../lib/Helper", {
      setPredictedVisitorAbandonmentTime(v) {
        setPredictedVisitorAbandonmentTime = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    function shouldSaveInactivity(message) {
      if (message.t || isEditedMessage(message) || isMessageFromVisitor(message)) {
        return false;
      }
      const abandonedRoomsAction = settings.get('Livechat_abandoned_rooms_action');
      const visitorInactivityTimeout = settings.get('Livechat_visitor_inactivity_timeout');
      if (!abandonedRoomsAction || abandonedRoomsAction === 'none' || visitorInactivityTimeout <= 0) {
        return false;
      }
      return true;
    }
    callbacks.remove('afterOmnichannelSaveMessage', 'markRoomResponded');
    callbacks.add('afterOmnichannelSaveMessage', async (message, _ref) => {
      let {
        room,
        roomUpdater
      } = _ref;
      const responseBy = await markRoomResponded(message, room, roomUpdater);
      if (!shouldSaveInactivity(message)) {
        return message;
      }
      if (!responseBy) {
        return;
      }
      if (moment(responseBy.firstResponseTs).isSame(moment(message.ts))) {
        await setPredictedVisitorAbandonmentTime(_objectSpread(_objectSpread({}, room), {}, {
          responseBy
        }), roomUpdater);
      }
    }, callbacks.priority.MEDIUM, 'save-visitor-inactivity');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"methods":{"addMonitor.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/addMonitor.ts                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 2);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      async 'livechat:addMonitor'(username) {
        const uid = Meteor.userId();
        if (!uid || !(await hasPermissionAsync(uid, 'manage-livechat-monitors'))) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'livechat:addMonitor'
          });
        }
        check(username, String);
        return LivechatEnterprise.addMonitor(username);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"getUnitsFromUserRoles.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/getUnitsFromUserRoles.ts                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let getUnitsFromUser;
    module.link("@rocket.chat/omni-core-ee", {
      getUnitsFromUser(v) {
        getUnitsFromUser = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let methodDeprecationLogger;
    module.link("../../../../../app/lib/server/lib/deprecationWarningLogger", {
      methodDeprecationLogger(v) {
        methodDeprecationLogger = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      async 'livechat:getUnitsFromUser'() {
        methodDeprecationLogger.method('livechat:getUnitsFromUser', '8.0.0', 'This functionality is no longer supported');
        const userId = Meteor.userId();
        if (!userId) {
          return;
        }
        return getUnitsFromUser(userId);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"removeBusinessHour.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/removeBusinessHour.ts                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 0);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 1);
    let businessHourManager;
    module.link("../../../../../app/livechat/server/business-hour", {
      businessHourManager(v) {
        businessHourManager = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      async 'livechat:removeBusinessHour'(id, type) {
        const userId = Meteor.userId();
        if (!userId || !(await hasPermissionAsync(userId, 'view-livechat-business-hours'))) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'livechat:removeBusinessHour'
          });
        }
        return businessHourManager.removeBusinessHourByIdAndType(id, type);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"removeMonitor.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/removeMonitor.ts                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 2);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      async 'livechat:removeMonitor'(username) {
        const uid = Meteor.userId();
        if (!uid || !(await hasPermissionAsync(uid, 'manage-livechat-monitors'))) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'livechat:removeMonitor'
          });
        }
        check(username, String);
        return LivechatEnterprise.removeMonitor(username);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"removeTag.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/removeTag.ts                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 2);
    let methodDeprecationLogger;
    module.link("../../../../../app/lib/server/lib/deprecationWarningLogger", {
      methodDeprecationLogger(v) {
        methodDeprecationLogger = v;
      }
    }, 3);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      async 'livechat:removeTag'(id) {
        methodDeprecationLogger.method('livechat:removeTag', '8.0.0', '/v1/livechat/tags.delete');
        const uid = Meteor.userId();
        if (!uid || !(await hasPermissionAsync(uid, 'manage-livechat-tags'))) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'livechat:removeTag'
          });
        }
        check(id, String);
        return (await LivechatEnterprise.removeTag(id)).deletedCount > 0;
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"removeUnit.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/removeUnit.ts                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 2);
    let methodDeprecationLogger;
    module.link("../../../../../app/lib/server/lib/deprecationWarningLogger", {
      methodDeprecationLogger(v) {
        methodDeprecationLogger = v;
      }
    }, 3);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      async 'livechat:removeUnit'(id) {
        methodDeprecationLogger.method('livechat:removeUnit', '8.0.0', 'DELETE /v1/livechat/units/:id');
        const uid = Meteor.userId();
        if (!uid || !(await hasPermissionAsync(uid, 'manage-livechat-units'))) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'livechat:removeUnit'
          });
        }
        check(id, String);
        return (await LivechatEnterprise.removeUnit(id, uid)).deletedCount > 0;
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"resumeOnHold.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/resumeOnHold.ts                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let Message;
    module.link("@rocket.chat/core-services", {
      Message(v) {
        Message = v;
      }
    }, 0);
    let isOmnichannelRoom;
    module.link("@rocket.chat/core-typings", {
      isOmnichannelRoom(v) {
        isOmnichannelRoom = v;
      }
    }, 1);
    let LivechatVisitors, LivechatInquiry, LivechatRooms, Users;
    module.link("@rocket.chat/models", {
      LivechatVisitors(v) {
        LivechatVisitors = v;
      },
      LivechatInquiry(v) {
        LivechatInquiry = v;
      },
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      Users(v) {
        Users = v;
      }
    }, 2);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 3);
    let methodDeprecationLogger;
    module.link("../../../../../app/lib/server/lib/deprecationWarningLogger", {
      methodDeprecationLogger(v) {
        methodDeprecationLogger = v;
      }
    }, 4);
    let RoutingManager;
    module.link("../../../../../app/livechat/server/lib/RoutingManager", {
      RoutingManager(v) {
        RoutingManager = v;
      }
    }, 5);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 6);
    let i18n;
    module.link("../../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 7);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function resolveOnHoldCommentInfo(options, room, onHoldChatResumedBy) {
      if (options.clientAction) {
        return i18n.t('Omnichannel_on_hold_chat_resumed_manually', {
          user: onHoldChatResumedBy.name || onHoldChatResumedBy.username
        });
      }
      const {
        v: {
          _id: visitorId
        }
      } = room;
      const visitor = await LivechatVisitors.findOneEnabledById(visitorId, {
        projection: {
          name: 1,
          username: 1
        }
      });
      if (!visitor) {
        throw new Meteor.Error('error-invalid_visitor', 'Visitor Not found');
      }
      const guest = visitor.name || visitor.username;
      return i18n.t('Omnichannel_on_hold_chat_automatically', {
        guest
      });
    }
    Meteor.methods({
      async 'livechat:resumeOnHold'(roomId) {
        let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
          clientAction: false
        };
        methodDeprecationLogger.warn('Method "livechat:resumeOnHold" is deprecated and will be removed in next major version. Please use "livechat/room.resumeOnHold" API instead.');
        const room = await LivechatRooms.findOneById(roomId);
        if (!room || !isOmnichannelRoom(room)) {
          throw new Meteor.Error('error-invalid-room', 'Invalid room', {
            method: 'livechat:resumeOnHold'
          });
        }
        if (!room.onHold) {
          throw new Meteor.Error('room-closed', 'Room is not OnHold', {
            method: 'livechat:resumeOnHold'
          });
        }
        const inquiry = await LivechatInquiry.findOneByRoomId(roomId, {});
        if (!inquiry) {
          throw new Meteor.Error('inquiry-not-found', 'Error! No inquiry found for this room', {
            method: 'livechat:resumeOnHold'
          });
        }
        if (!room.servedBy) {
          throw new Meteor.Error('error-unserved-rooms-cannot-be-placed-onhold', 'Error! Un-served rooms cannot be placed OnHold', {
            method: 'livechat:resumeOnHold'
          });
        }
        const {
          servedBy: {
            _id: agentId,
            username
          }
        } = room;
        await RoutingManager.takeInquiry(inquiry, {
          agentId,
          username
        }, options, room);
        const onHoldChatResumedBy = options.clientAction ? await Meteor.userAsync() : await Users.findOneById('rocket.cat');
        if (!onHoldChatResumedBy) {
          throw new Meteor.Error('error-invalid-user', 'Invalid user', {
            method: 'livechat:resumeOnHold'
          });
        }
        const comment = await resolveOnHoldCommentInfo(options, room, onHoldChatResumedBy);
        await Message.saveSystemMessage('omnichannel_on_hold_chat_resumed', roomId, '', onHoldChatResumedBy, {
          comment
        });
        setImmediate(() => callbacks.run('livechat:afterOnHoldChatResumed', room));
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"saveTag.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/saveTag.ts                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 2);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      async 'livechat:saveTag'(_id, tagData, tagDepartments) {
        const uid = Meteor.userId();
        if (!uid || !(await hasPermissionAsync(uid, 'manage-livechat-tags'))) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'livechat:saveTags'
          });
        }
        check(_id, Match.Maybe(String));
        check(tagData, {
          name: String,
          description: Match.Maybe(String)
        });
        check(tagDepartments, [String]);
        return LivechatEnterprise.saveTag(_id, tagData, tagDepartments);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"saveUnit.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/methods/saveUnit.ts                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 0);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 1);
    let methodDeprecationLogger;
    module.link("../../../../../app/lib/server/lib/deprecationWarningLogger", {
      methodDeprecationLogger(v) {
        methodDeprecationLogger = v;
      }
    }, 2);
    let LivechatEnterprise;
    module.link("../lib/LivechatEnterprise", {
      LivechatEnterprise(v) {
        LivechatEnterprise = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      async 'livechat:saveUnit'(_id, unitData, unitMonitors, unitDepartments) {
        methodDeprecationLogger.method('livechat:saveUnit', '8.0.0', '/v1/livechat/units');
        const uid = Meteor.userId();
        if (!uid || !(await hasPermissionAsync(uid, 'manage-livechat-units'))) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'livechat:saveUnit'
          });
        }
        return LivechatEnterprise.saveUnit(_id, unitData, unitMonitors, unitDepartments, uid);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"outboundcomms":{"rest.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/outboundcomms/rest.ts                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      GETOutboundProviderParamsSchema: () => GETOutboundProviderParamsSchema,
      GETOutboundProvidersResponseSchema: () => GETOutboundProvidersResponseSchema,
      GETOutboundProviderBadRequestErrorSchema: () => GETOutboundProviderBadRequestErrorSchema,
      POSTOutboundMessageParams: () => POSTOutboundMessageParams,
      POSTOutboundMessageSuccessSchema: () => POSTOutboundMessageSuccessSchema,
      GETOutboundProviderMetadataSchema: () => GETOutboundProviderMetadataSchema
    });
    let Ajv;
    module.link("ajv", {
      default(v) {
        Ajv = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const ajv = new Ajv({
      coerceTypes: true
    });
    const GETOutboundProviderSchema = {
      type: 'object',
      properties: {
        type: {
          type: 'string',
          enum: ['phone', 'email']
        }
      },
      required: [],
      additionalProperties: false
    };
    const GETOutboundProviderParamsSchema = ajv.compile(GETOutboundProviderSchema);
    const GETOutboundProvidersResponse = {
      type: 'object',
      properties: {
        providers: {
          type: 'array',
          items: {
            type: 'object',
            properties: {
              providerId: {
                type: 'string'
              },
              providerName: {
                type: 'string'
              },
              supportsTemplates: {
                type: 'boolean'
              },
              providerType: {
                type: 'string'
              }
            }
          }
        }
      }
    };
    const GETOutboundProvidersResponseSchema = ajv.compile(GETOutboundProvidersResponse);
    const GETOutboundProviderBadRequestError = {
      type: 'object',
      properties: {
        success: {
          type: 'boolean'
        },
        message: {
          type: 'string'
        }
      }
    };
    const GETOutboundProviderBadRequestErrorSchema = ajv.compile(GETOutboundProviderBadRequestError);
    const POSTOutboundMessageSchema = {
      type: 'object',
      required: ['to', 'type'],
      properties: {
        to: {
          type: 'string',
          minLength: 1
        },
        type: {
          type: 'string'
        },
        templateProviderPhoneNumber: {
          type: 'string'
        },
        template: {
          type: 'object',
          required: ['name', 'language'],
          properties: {
            name: {
              type: 'string'
            },
            language: {
              type: 'object',
              required: ['code'],
              properties: {
                code: {
                  type: 'string'
                },
                policy: {
                  type: 'string',
                  enum: ['deterministic', 'fallback']
                }
              },
              additionalProperties: false
            },
            components: {
              type: 'array',
              items: {
                type: 'object',
                required: ['type', 'parameters'],
                properties: {
                  type: {
                    type: 'string',
                    enum: ['header', 'body', 'footer', 'button']
                  },
                  parameters: {
                    type: 'array',
                    items: {
                      oneOf: [{
                        type: 'object',
                        required: ['type', 'text'],
                        properties: {
                          type: {
                            const: 'text'
                          },
                          text: {
                            type: 'string'
                          }
                        },
                        additionalProperties: false
                      }, {
                        type: 'object',
                        required: ['type', 'currency'],
                        properties: {
                          type: {
                            const: 'currency'
                          },
                          currency: {
                            type: 'object',
                            required: ['fallbackValue', 'code', 'amount1000'],
                            properties: {
                              fallbackValue: {
                                type: 'string'
                              },
                              code: {
                                type: 'string'
                              },
                              amount1000: {
                                type: 'number'
                              }
                            },
                            additionalProperties: false
                          }
                        },
                        additionalProperties: false
                      }, {
                        type: 'object',
                        required: ['type', 'dateTime'],
                        properties: {
                          type: {
                            const: 'date_time'
                          },
                          dateTime: {
                            type: 'object',
                            required: ['fallbackValue'],
                            properties: {
                              fallbackValue: {
                                type: 'string'
                              },
                              timestamp: {
                                type: 'number'
                              },
                              dayOfWeek: {
                                type: 'number'
                              },
                              dayOfMonth: {
                                type: 'number'
                              },
                              year: {
                                type: 'number'
                              },
                              month: {
                                type: 'number'
                              },
                              hour: {
                                type: 'number'
                              },
                              minute: {
                                type: 'number'
                              }
                            },
                            additionalProperties: false
                          }
                        },
                        additionalProperties: false
                      }, {
                        type: 'object',
                        required: ['type', 'link'],
                        properties: {
                          type: {
                            const: 'media'
                          },
                          link: {
                            type: 'string'
                          },
                          format: {
                            type: 'string',
                            enum: ['image', 'video', 'document']
                          }
                        },
                        additionalProperties: false
                      }]
                    }
                  }
                },
                additionalProperties: false
              }
            },
            namespace: {
              type: 'string'
            }
          },
          additionalProperties: false
        },
        agentId: {
          type: 'string'
        },
        departmentId: {
          type: 'string'
        }
      },
      additionalProperties: false
    };
    const POSTOutboundMessageParams = ajv.compile(POSTOutboundMessageSchema);
    const POSTOutboundMessageSuccess = {
      type: 'object',
      properties: {
        success: {
          type: 'boolean',
          enum: [true]
        }
      },
      additionalProperties: false
    };
    const POSTOutboundMessageSuccessSchema = ajv.compile(POSTOutboundMessageSuccess);
    const OutboundProviderMetadataSchema = {
      type: 'object',
      properties: {
        metadata: {
          type: 'object',
          properties: {
            providerId: {
              type: 'string'
            },
            providerName: {
              type: 'string'
            },
            supportsTemplates: {
              type: 'boolean'
            },
            providerType: {
              type: 'string',
              enum: ['phone', 'email']
            },
            templates: {
              type: 'object',
              additionalProperties: {
                type: 'array',
                items: {
                  type: 'object',
                  properties: {
                    id: {
                      type: 'string'
                    },
                    name: {
                      type: 'string'
                    },
                    language: {
                      type: 'string'
                    },
                    type: {
                      type: 'string'
                    },
                    category: {
                      type: 'string'
                    },
                    status: {
                      type: 'string'
                    },
                    qualityScore: {
                      type: 'object',
                      required: ['score', 'reasons'],
                      properties: {
                        score: {
                          type: 'string',
                          enum: ['GREEN', 'YELLOW', 'RED', 'UNKNOWN']
                        },
                        reasons: {
                          type: ['array', 'null'],
                          items: {
                            type: 'string'
                          }
                        }
                      }
                    },
                    components: {
                      type: 'array',
                      items: {
                        type: 'object',
                        oneOf: [{
                          properties: {
                            type: {
                              const: 'header'
                            },
                            format: {
                              type: 'string',
                              enum: ['text', 'image', 'video', 'document']
                            },
                            text: {
                              type: 'string'
                            },
                            example: {
                              type: 'object',
                              properties: {
                                headerText: {
                                  type: 'array',
                                  items: {
                                    type: 'string'
                                  }
                                }
                              }
                            }
                          }
                        }, {
                          properties: {
                            type: {
                              const: 'body'
                            },
                            text: {
                              type: 'string'
                            },
                            example: {
                              type: 'object',
                              properties: {
                                bodyText: {
                                  type: 'array',
                                  items: {
                                    type: 'array',
                                    items: {
                                      type: 'string'
                                    }
                                  }
                                }
                              }
                            }
                          },
                          required: ['type', 'text']
                        }, {
                          properties: {
                            type: {
                              const: 'footer'
                            },
                            text: {
                              type: 'string'
                            }
                          },
                          required: ['type', 'text']
                        }]
                      }
                    },
                    createdAt: {
                      type: 'string'
                    },
                    createdBy: {
                      type: 'string'
                    },
                    modifiedAt: {
                      type: 'string'
                    },
                    modifiedBy: {
                      type: 'string'
                    },
                    namespace: {
                      type: 'string'
                    },
                    wabaAccountId: {
                      type: 'string'
                    },
                    phoneNumber: {
                      type: 'string'
                    },
                    partnerId: {
                      type: 'string'
                    },
                    externalId: {
                      type: 'string'
                    },
                    updatedExternal: {
                      type: 'string'
                    },
                    rejectedReason: {
                      type: ['string', 'null']
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    const GETOutboundProviderMetadataSchema = ajv.compile(OutboundProviderMetadataSchema);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"services":{"omnichannel.internalService.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/services/omnichannel.internalService.ts                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      OmnichannelEE: () => OmnichannelEE
    });
    let ServiceClassInternal, Message;
    module.link("@rocket.chat/core-services", {
      ServiceClassInternal(v) {
        ServiceClassInternal = v;
      },
      Message(v) {
        Message = v;
      }
    }, 0);
    let isOmnichannelRoom, LivechatInquiryStatus;
    module.link("@rocket.chat/core-typings", {
      isOmnichannelRoom(v) {
        isOmnichannelRoom = v;
      },
      LivechatInquiryStatus(v) {
        LivechatInquiryStatus = v;
      }
    }, 1);
    let Logger;
    module.link("@rocket.chat/logger", {
      Logger(v) {
        Logger = v;
      }
    }, 2);
    let LivechatRooms, Subscriptions, LivechatInquiry;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      Subscriptions(v) {
        Subscriptions = v;
      },
      LivechatInquiry(v) {
        LivechatInquiry = v;
      }
    }, 3);
    let notifyOnSubscriptionChangedByRoomId, notifyOnLivechatInquiryChangedById, notifyOnRoomChangedById;
    module.link("../../../../../app/lib/server/lib/notifyListener", {
      notifyOnSubscriptionChangedByRoomId(v) {
        notifyOnSubscriptionChangedByRoomId = v;
      },
      notifyOnLivechatInquiryChangedById(v) {
        notifyOnLivechatInquiryChangedById = v;
      },
      notifyOnRoomChangedById(v) {
        notifyOnRoomChangedById = v;
      }
    }, 4);
    let dispatchAgentDelegated;
    module.link("../../../../../app/livechat/server/lib/Helper", {
      dispatchAgentDelegated(v) {
        dispatchAgentDelegated = v;
      }
    }, 5);
    let queueInquiry;
    module.link("../../../../../app/livechat/server/lib/QueueManager", {
      queueInquiry(v) {
        queueInquiry = v;
      }
    }, 6);
    let RoutingManager;
    module.link("../../../../../app/livechat/server/lib/RoutingManager", {
      RoutingManager(v) {
        RoutingManager = v;
      }
    }, 7);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 8);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 9);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class OmnichannelEE extends ServiceClassInternal {
      constructor() {
        super();
        this.name = 'omnichannel-ee';
        this.internal = true;
        this.logger = void 0;
        this.logger = new Logger('OmnichannelEE');
      }
      async placeRoomOnHold(room, comment, onHoldBy) {
        var _room$lastMessage;
        this.logger.debug("Attempting to place room ".concat(room._id, " on hold by user ").concat(onHoldBy === null || onHoldBy === void 0 ? void 0 : onHoldBy._id));
        const {
          _id: roomId
        } = room;
        if (!room || !isOmnichannelRoom(room)) {
          throw new Error('error-invalid-room');
        }
        if (!room.open) {
          throw new Error('error-room-already-closed');
        }
        if (room.onHold) {
          throw new Error('error-room-is-already-on-hold');
        }
        const restrictedOnHold = settings.get('Livechat_allow_manual_on_hold_upon_agent_engagement_only');
        const canRoomBePlacedOnHold = !room.onHold;
        const canAgentPlaceOnHold = !((_room$lastMessage = room.lastMessage) !== null && _room$lastMessage !== void 0 && _room$lastMessage.token);
        const canPlaceChatOnHold = canRoomBePlacedOnHold && (!restrictedOnHold || canAgentPlaceOnHold);
        if (!canPlaceChatOnHold) {
          throw new Error('error-cannot-place-chat-on-hold');
        }
        if (!room.servedBy) {
          throw new Error('error-unserved-rooms-cannot-be-placed-onhold');
        }
        const [roomResult, subsResult] = await Promise.all([LivechatRooms.setOnHoldByRoomId(roomId), Subscriptions.setOnHoldByRoomId(roomId), Message.saveSystemMessage('omnichannel_placed_chat_on_hold', roomId, '', onHoldBy, {
          comment
        })]);
        if (roomResult.modifiedCount) {
          void notifyOnRoomChangedById(roomId);
        }
        if (subsResult.modifiedCount) {
          void notifyOnSubscriptionChangedByRoomId(roomId);
        }
        await callbacks.run('livechat:afterOnHold', room);
      }
      async resumeRoomOnHold(room, comment, resumeBy) {
        let clientAction = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
        this.logger.debug("Attempting to resume room ".concat(room._id, " on hold by user ").concat(resumeBy === null || resumeBy === void 0 ? void 0 : resumeBy._id));
        if (!room || !isOmnichannelRoom(room)) {
          throw new Error('error-invalid-room');
        }
        if (!room.open) {
          throw new Error('This_conversation_is_already_closed');
        }
        if (!room.onHold) {
          throw new Error('error-room-not-on-hold');
        }
        const {
          _id: roomId,
          servedBy
        } = room;
        if (!servedBy) {
          this.logger.error("No serving agent found for room ".concat(roomId));
          throw new Error('error-room-not-served');
        }
        const inquiry = await LivechatInquiry.findOneByRoomId(roomId, {});
        if (!inquiry) {
          this.logger.error("No inquiry found for room ".concat(roomId));
          throw new Error('error-invalid-inquiry');
        }
        await this.attemptToAssignRoomToServingAgentElseQueueIt({
          room,
          inquiry,
          servingAgent: servedBy,
          clientAction
        });
        const [roomResult, subsResult] = await Promise.all([LivechatRooms.unsetOnHoldByRoomId(roomId), Subscriptions.unsetOnHoldByRoomId(roomId), Message.saveSystemMessage('omnichannel_on_hold_chat_resumed', roomId, '', resumeBy, {
          comment
        })]);
        if (roomResult.modifiedCount) {
          void notifyOnRoomChangedById(roomId);
        }
        if (subsResult.modifiedCount) {
          void notifyOnSubscriptionChangedByRoomId(roomId);
        }
        await callbacks.run('livechat:afterOnHoldChatResumed', room);
      }
      async attemptToAssignRoomToServingAgentElseQueueIt(_ref) {
        let {
          room,
          inquiry,
          servingAgent,
          clientAction
        } = _ref;
        try {
          const agent = {
            agentId: servingAgent._id,
            username: servingAgent.username
          };
          await callbacks.run('livechat.checkAgentBeforeTakeInquiry', {
            agent,
            inquiry,
            options: {}
          });
          return;
        } catch (e) {
          this.logger.error("Agent ".concat(servingAgent._id, " is not available to take the inquiry ").concat(inquiry._id), e);
          if (clientAction) {
            // if the action was triggered by the client, we should throw the error
            // so the client can handle it and show the error message to the user
            throw e;
          }
        }
        await this.removeCurrentAgentFromRoom({
          room,
          inquiry
        });
        const {
          _id: inquiryId
        } = inquiry;
        const newInquiry = await LivechatInquiry.findOneById(inquiryId);
        if (!newInquiry) {
          throw new Error('error-invalid-inquiry');
        }
        await queueInquiry(newInquiry);
      }
      async removeCurrentAgentFromRoom(_ref2) {
        let {
          room,
          inquiry
        } = _ref2;
        this.logger.debug("Attempting to remove current agent from room ".concat(room._id));
        const {
          _id: roomId
        } = room;
        const {
          _id: inquiryId
        } = inquiry;
        await Promise.all([LivechatRooms.removeAgentByRoomId(roomId), LivechatInquiry.queueInquiryAndRemoveDefaultAgent(inquiryId), RoutingManager.removeAllRoomSubscriptions(room)]);
        void notifyOnLivechatInquiryChangedById(inquiryId, 'updated', {
          status: LivechatInquiryStatus.QUEUED,
          queuedAt: new Date(),
          takenAt: undefined,
          defaultAgent: undefined
        });
        await dispatchAgentDelegated(roomId);
        void notifyOnRoomChangedById(roomId);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/index.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let patchOmniCore;
    module.link("@rocket.chat/omni-core-ee", {
      patchOmniCore(v) {
        patchOmniCore = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    module.link("./methods/addMonitor");
    module.link("./methods/getUnitsFromUserRoles");
    module.link("./methods/removeMonitor");
    module.link("./methods/removeTag");
    module.link("./methods/saveTag");
    module.link("./methods/removeUnit");
    module.link("./methods/saveUnit");
    module.link("./methods/removeBusinessHour");
    module.link("./methods/resumeOnHold");
    module.link("./hooks/afterTakeInquiry");
    module.link("./hooks/beforeNewInquiry");
    module.link("./hooks/beforeNewRoom");
    module.link("./hooks/beforeRoutingChat");
    module.link("./hooks/checkAgentBeforeTakeInquiry");
    module.link("./hooks/handleNextAgentPreferredEvents");
    module.link("./hooks/onCheckRoomParamsApi");
    module.link("./hooks/onLoadConfigApi");
    module.link("./hooks/onSaveVisitorInfo");
    module.link("./hooks/scheduleAutoTransfer");
    module.link("./hooks/resumeOnHold");
    module.link("./hooks/afterOnHold");
    module.link("./hooks/onTransferFailure");
    module.link("./lib/routing/LoadBalancing");
    module.link("./lib/routing/LoadRotation");
    module.link("./lib/AutoCloseOnHoldScheduler");
    module.link("./business-hour");
    module.link("./api");
    let createDefaultPriorities;
    module.link("./priorities", {
      createDefaultPriorities(v) {
        createDefaultPriorities = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    patchOmniCore();
    await License.onLicense('livechat-enterprise', async () => {
      require('./hooks');
      await module.dynamicImport('./startup');
      const {
        createPermissions
      } = await module.dynamicImport('./permissions');
      const {
        createSettings
      } = await module.dynamicImport('./settings');
      await module.dynamicImport('./lib/unit');
      Meteor.startup(() => {
        void createSettings();
        void createPermissions();
        void createDefaultPriorities();
      });
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"permissions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/permissions.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      omnichannelEEPermissions: () => omnichannelEEPermissions,
      createPermissions: () => createPermissions
    });
    let Permissions, Roles;
    module.link("@rocket.chat/models", {
      Permissions(v) {
        Permissions = v;
      },
      Roles(v) {
        Roles = v;
      }
    }, 0);
    let createOrUpdateProtectedRoleAsync;
    module.link("../../../../server/lib/roles/createOrUpdateProtectedRole", {
      createOrUpdateProtectedRoleAsync(v) {
        createOrUpdateProtectedRoleAsync = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const livechatMonitorRole = 'livechat-monitor';
    const livechatManagerRole = 'livechat-manager';
    const adminRole = 'admin';
    const livechatAgentRole = 'livechat-agent';
    const omnichannelEEPermissions = [{
      _id: 'manage-livechat-units',
      roles: [adminRole, livechatManagerRole]
    }, {
      _id: 'manage-livechat-monitors',
      roles: [adminRole, livechatManagerRole]
    }, {
      _id: 'manage-livechat-tags',
      roles: [adminRole, livechatManagerRole]
    }, {
      _id: 'manage-livechat-priorities',
      roles: [adminRole, livechatManagerRole]
    }, {
      _id: 'manage-livechat-sla',
      roles: [adminRole, livechatManagerRole]
    }, {
      _id: 'manage-livechat-canned-responses',
      roles: [adminRole, livechatManagerRole, livechatMonitorRole]
    }, {
      _id: 'spy-voip-calls',
      roles: [adminRole, livechatManagerRole, livechatMonitorRole]
    }, {
      _id: 'outbound-voip-calls',
      roles: [adminRole, livechatManagerRole]
    }, {
      _id: 'request-pdf-transcript',
      roles: [adminRole, livechatManagerRole, livechatMonitorRole, livechatAgentRole]
    }, {
      _id: 'view-livechat-reports',
      roles: [adminRole, livechatManagerRole, livechatMonitorRole]
    }, {
      _id: 'block-livechat-contact',
      roles: [adminRole, livechatManagerRole, livechatMonitorRole, livechatAgentRole]
    }, {
      _id: 'unblock-livechat-contact',
      roles: [adminRole, livechatManagerRole, livechatMonitorRole, livechatAgentRole]
    }, {
      _id: 'outbound.send-messages',
      roles: [adminRole, livechatManagerRole, livechatMonitorRole, livechatAgentRole]
    }, {
      _id: 'outbound.can-assign-queues',
      roles: [adminRole, livechatManagerRole]
    }, {
      _id: 'outbound.can-assign-any-agent',
      roles: [adminRole, livechatManagerRole, livechatMonitorRole]
    }, {
      _id: 'outbound.can-assign-self-only',
      roles: [livechatAgentRole]
    }];
    const createPermissions = async () => {
      const monitorRole = await Roles.findOneById(livechatMonitorRole, {
        projection: {
          _id: 1
        }
      });
      if (!monitorRole) {
        await createOrUpdateProtectedRoleAsync(livechatMonitorRole, {
          name: livechatMonitorRole
        });
      }
      await Promise.all(omnichannelEEPermissions.map(async permission => Permissions.create(permission._id, permission.roles)));
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"priorities.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/priorities.ts                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      createDefaultPriorities: () => createDefaultPriorities
    });
    let LivechatPriorityWeight;
    module.link("@rocket.chat/core-typings", {
      LivechatPriorityWeight(v) {
        LivechatPriorityWeight = v;
      }
    }, 0);
    let LivechatPriority;
    module.link("@rocket.chat/models", {
      LivechatPriority(v) {
        LivechatPriority = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const defaultPriorities = [{
      i18n: 'Lowest',
      sortItem: LivechatPriorityWeight.LOWEST,
      dirty: false
    }, {
      i18n: 'Low',
      sortItem: LivechatPriorityWeight.LOW,
      dirty: false
    }, {
      i18n: 'Medium',
      sortItem: LivechatPriorityWeight.MEDIUM,
      dirty: false
    }, {
      i18n: 'High',
      sortItem: LivechatPriorityWeight.HIGH,
      dirty: false
    }, {
      i18n: 'Highest',
      sortItem: LivechatPriorityWeight.HIGHEST,
      dirty: false
    }];
    const createDefaultPriorities = async () => {
      const priorities = await LivechatPriority.estimatedDocumentCount();
      if (!priorities) {
        await LivechatPriority.insertMany(defaultPriorities);
      }
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"settings.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/settings.ts                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      createSettings: () => createSettings
    });
    let OmnichannelSortingMechanismSettingType;
    module.link("@rocket.chat/core-typings", {
      OmnichannelSortingMechanismSettingType(v) {
        OmnichannelSortingMechanismSettingType = v;
      }
    }, 0);
    let Settings;
    module.link("@rocket.chat/models", {
      Settings(v) {
        Settings = v;
      }
    }, 1);
    let settingsRegistry;
    module.link("../../../../app/settings/server", {
      settingsRegistry(v) {
        settingsRegistry = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const omnichannelEnabledQuery = {
      _id: 'Livechat_enabled',
      value: true
    };
    const businessHoursEnabled = {
      _id: 'Livechat_enable_business_hours',
      value: true
    };
    const createSettings = async () => {
      await settingsRegistry.add('Livechat_abandoned_rooms_action', 'none', {
        type: 'select',
        group: 'Omnichannel',
        section: 'Sessions',
        values: [{
          key: 'none',
          i18nLabel: 'Do_Nothing'
        }, {
          key: 'close',
          i18nLabel: 'Livechat_close_chat'
        }, {
          key: 'on-hold',
          i18nLabel: 'Omnichannel_onHold_Chat'
        }],
        enterprise: true,
        public: true,
        invalidValue: 'none',
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.add('Livechat_abandoned_rooms_closed_custom_message', '', {
        type: 'string',
        group: 'Omnichannel',
        section: 'Sessions',
        i18nLabel: 'Livechat_abandoned_rooms_closed_custom_message',
        enableQuery: [{
          _id: 'Livechat_abandoned_rooms_action',
          value: 'close'
        }, omnichannelEnabledQuery],
        enterprise: true,
        invalidValue: '',
        modules: ['livechat-enterprise']
      });
      await settingsRegistry.add('Omnichannel_max_fallback_forward_depth', 3, {
        type: 'int',
        group: 'Omnichannel',
        section: 'Routing',
        i18nLabel: 'Omnichannel_max_fallback_forward_depth',
        enterprise: true,
        invalidValue: 0,
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.add('Livechat_last_chatted_agent_routing', false, {
        type: 'boolean',
        group: 'Omnichannel',
        section: 'Routing',
        enterprise: true,
        invalidValue: false,
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.addGroup('Omnichannel', async function () {
        await this.section('Business_Hours', async function () {
          await this.add('Livechat_business_hour_type', 'Single', {
            type: 'select',
            values: [{
              key: 'Single',
              i18nLabel: 'Single'
            }, {
              key: 'Multiple',
              i18nLabel: 'Multiple'
            }],
            public: true,
            i18nLabel: 'Livechat_business_hour_type',
            enterprise: true,
            invalidValue: 'Single',
            modules: ['livechat-enterprise'],
            enableQuery: [omnichannelEnabledQuery, businessHoursEnabled]
          });
        });
        await this.section('Queue_management', async function () {
          await this.add('Livechat_waiting_queue', false, {
            type: 'boolean',
            group: 'Omnichannel',
            section: 'Queue_management',
            i18nLabel: 'Waiting_queue',
            enterprise: true,
            invalidValue: false,
            modules: ['livechat-enterprise'],
            enableQuery: omnichannelEnabledQuery,
            public: true
          });
          await this.add('Livechat_waiting_queue_message', '', {
            type: 'string',
            group: 'Omnichannel',
            section: 'Queue_management',
            i18nLabel: 'Waiting_queue_message',
            i18nDescription: 'Waiting_queue_message_description',
            enableQuery: [{
              _id: 'Livechat_waiting_queue',
              value: true
            }, omnichannelEnabledQuery],
            enterprise: true,
            invalidValue: '',
            modules: ['livechat-enterprise']
          });
          await this.add('Livechat_maximum_chats_per_agent', 0, {
            type: 'int',
            group: 'Omnichannel',
            section: 'Queue_management',
            i18nLabel: 'Max_number_of_chats_per_agent',
            i18nDescription: 'Max_number_of_chats_per_agent_description',
            enableQuery: [{
              _id: 'Livechat_waiting_queue',
              value: true
            }, omnichannelEnabledQuery],
            enterprise: true,
            invalidValue: 0,
            modules: ['livechat-enterprise']
          });
          await this.add('Omnichannel_calculate_dispatch_service_queue_statistics', true, {
            type: 'boolean',
            group: 'Omnichannel',
            section: 'Queue_management',
            i18nLabel: 'Omnichannel_calculate_dispatch_service_queue_statistics',
            enableQuery: [{
              _id: 'Livechat_waiting_queue',
              value: true
            }, omnichannelEnabledQuery],
            enterprise: true,
            invalidValue: false,
            modules: ['livechat-enterprise']
          });
          await this.add('Livechat_number_most_recent_chats_estimate_wait_time', 100, {
            type: 'int',
            group: 'Omnichannel',
            section: 'Queue_management',
            i18nLabel: 'Number_of_most_recent_chats_estimate_wait_time',
            i18nDescription: 'Number_of_most_recent_chats_estimate_wait_time_description',
            enableQuery: [{
              _id: 'Livechat_waiting_queue',
              value: true
            }, omnichannelEnabledQuery],
            enterprise: true,
            invalidValue: 100,
            modules: ['livechat-enterprise']
          });
          await this.add('Livechat_max_queue_wait_time', -1, {
            type: 'int',
            group: 'Omnichannel',
            section: 'Queue_management',
            i18nLabel: 'Livechat_maximum_queue_wait_time',
            enableQuery: omnichannelEnabledQuery,
            i18nDescription: 'Livechat_maximum_queue_wait_time_description',
            enterprise: true,
            invalidValue: -1,
            modules: ['livechat-enterprise']
          });
          await this.add('Omnichannel_sorting_mechanism', 'Timestamp', {
            type: 'select',
            values: [{
              key: OmnichannelSortingMechanismSettingType.Timestamp,
              i18nLabel: 'Timestamp'
            }, {
              key: OmnichannelSortingMechanismSettingType.Priority,
              i18nLabel: 'Priorities'
            }, {
              key: OmnichannelSortingMechanismSettingType.SLAs,
              i18nLabel: 'SLA_Policies'
            }],
            group: 'Omnichannel',
            section: 'Queue_management',
            i18nLabel: 'Sorting_mechanism',
            enableQuery: [omnichannelEnabledQuery],
            enterprise: true,
            public: true,
            modules: ['livechat-enterprise'],
            invalidValue: ''
          });
        });
      });
      await settingsRegistry.add('Livechat_AdditionalWidgetScripts', '', {
        type: 'string',
        group: 'Omnichannel',
        section: 'Livechat',
        enterprise: true,
        invalidValue: '',
        multiline: true,
        i18nLabel: 'Livechat_AdditionalWidgetScripts',
        i18nDescription: 'Livechat_AdditionalWidgetScripts_Description',
        enableQuery: [omnichannelEnabledQuery],
        modules: ['livechat-enterprise']
      });
      await settingsRegistry.add('Livechat_WidgetLayoutClasses', '', {
        type: 'string',
        group: 'Omnichannel',
        section: 'Livechat',
        enterprise: true,
        invalidValue: '',
        multiline: true,
        i18nLabel: 'Livechat_WidgetLayoutClasses',
        i18nDescription: 'Livechat_WidgetLayoutClasses_Description',
        enableQuery: [omnichannelEnabledQuery],
        modules: ['livechat-enterprise']
      });
      await settingsRegistry.add('Livechat_widget_position', 'right', {
        type: 'select',
        group: 'Omnichannel',
        section: 'Livechat',
        i18nLabel: 'Livechat_widget_position_on_the_screen',
        public: true,
        values: [{
          key: 'left',
          i18nLabel: 'Left'
        }, {
          key: 'right',
          i18nLabel: 'Right'
        }],
        enterprise: true,
        invalidValue: 'right',
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.add('Livechat_background', '', {
        type: 'string',
        group: 'Omnichannel',
        section: 'Livechat',
        i18nDescription: 'Livechat_background_description',
        placeholder: '#FFFFFF',
        public: true,
        enterprise: true,
        invalidValue: '',
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.add('Livechat_hide_watermark', false, {
        type: 'boolean',
        group: 'Omnichannel',
        section: 'Livechat',
        invalidValue: false,
        enableQuery: omnichannelEnabledQuery,
        i18nDescription: 'Livechat_hide_watermark_description',
        enterprise: true,
        sorter: 999,
        modules: ['livechat-enterprise']
      });
      await settingsRegistry.add('Omnichannel_contact_manager_routing', true, {
        type: 'boolean',
        group: 'Omnichannel',
        section: 'Routing',
        enterprise: true,
        invalidValue: false,
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.add('Livechat_auto_close_on_hold_chats_timeout', 3600, {
        type: 'int',
        group: 'Omnichannel',
        section: 'Sessions',
        enterprise: true,
        invalidValue: 0,
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.add('Livechat_auto_close_on_hold_chats_custom_message', '', {
        type: 'string',
        group: 'Omnichannel',
        section: 'Sessions',
        enableQuery: [{
          _id: 'Livechat_auto_close_on_hold_chats_timeout',
          value: {
            $gte: 1
          }
        }, omnichannelEnabledQuery],
        enterprise: true,
        invalidValue: '',
        modules: ['livechat-enterprise']
      });
      await settingsRegistry.add('Livechat_allow_manual_on_hold', false, {
        type: 'boolean',
        group: 'Omnichannel',
        section: 'Sessions',
        enterprise: true,
        invalidValue: false,
        public: true,
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.add('Livechat_allow_manual_on_hold_upon_agent_engagement_only', true, {
        type: 'boolean',
        group: 'Omnichannel',
        section: 'Sessions',
        enterprise: true,
        invalidValue: false,
        public: true,
        modules: ['livechat-enterprise'],
        enableQuery: {
          _id: 'Livechat_allow_manual_on_hold',
          value: true
        }
      });
      await settingsRegistry.add('Livechat_auto_transfer_chat_timeout', 0, {
        type: 'int',
        group: 'Omnichannel',
        section: 'Sessions',
        i18nDescription: 'Livechat_auto_transfer_chat_timeout_description',
        enterprise: true,
        invalidValue: 0,
        modules: ['livechat-enterprise'],
        enableQuery: omnichannelEnabledQuery
      });
      await settingsRegistry.add('Accounts_Default_User_Preferences_omnichannelTranscriptPDF', false, {
        type: 'boolean',
        public: true,
        i18nLabel: 'Omnichannel_transcript_pdf'
      });
      await settingsRegistry.add('Livechat_hide_system_messages', ['uj', 'ul', 'livechat-close'], {
        type: 'multiSelect',
        group: 'Omnichannel',
        section: 'Livechat',
        enterprise: true,
        modules: ['livechat-enterprise'],
        invalidValue: ['uj', 'ul', 'livechat-close'],
        public: true,
        values: [{
          key: 'uj',
          i18nLabel: 'Message_HideType_uj'
        }, {
          key: 'ul',
          i18nLabel: 'Message_HideType_ul'
        }, {
          key: 'livechat-close',
          i18nLabel: 'Message_HideType_livechat_closed'
        }, {
          key: 'livechat-started',
          i18nLabel: 'Message_HideType_livechat_started'
        }, {
          key: 'livechat_transfer_history',
          i18nLabel: 'Message_HideType_livechat_transfer_history'
        }]
      });
      await Settings.addOptionValueById('Livechat_Routing_Method', {
        key: 'Load_Balancing',
        i18nLabel: 'Load_Balancing'
      });
      await Settings.addOptionValueById('Livechat_Routing_Method', {
        key: 'Load_Rotation',
        i18nLabel: 'Load_Rotation'
      });
      await settingsRegistry.add('Livechat_hide_expand_chat', false, {
        type: 'boolean',
        group: 'Omnichannel',
        section: 'Livechat',
        i18nDescription: 'Livechat_hide_expand_chat_description',
        invalidValue: false,
        modules: ['livechat-enterprise'],
        enterprise: false,
        public: false,
        enableQuery: omnichannelEnabledQuery
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"startup.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/livechat-enterprise/server/startup.ts                                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 0);
    let MultipleBusinessHoursBehavior;
    module.link("./business-hour/Multiple", {
      MultipleBusinessHoursBehavior(v) {
        MultipleBusinessHoursBehavior = v;
      }
    }, 1);
    let updatePredictedVisitorAbandonment, updateQueueInactivityTimeout;
    module.link("./lib/Helper", {
      updatePredictedVisitorAbandonment(v) {
        updatePredictedVisitorAbandonment = v;
      },
      updateQueueInactivityTimeout(v) {
        updateQueueInactivityTimeout = v;
      }
    }, 2);
    let VisitorInactivityMonitor;
    module.link("./lib/VisitorInactivityMonitor", {
      VisitorInactivityMonitor(v) {
        VisitorInactivityMonitor = v;
      }
    }, 3);
    let logger;
    module.link("./lib/logger", {
      logger(v) {
        logger = v;
      }
    }, 4);
    let businessHourManager;
    module.link("../../../../app/livechat/server/business-hour", {
      businessHourManager(v) {
        businessHourManager = v;
      }
    }, 5);
    let SingleBusinessHourBehavior;
    module.link("../../../../app/livechat/server/business-hour/Single", {
      SingleBusinessHourBehavior(v) {
        SingleBusinessHourBehavior = v;
      }
    }, 6);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 7);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const visitorActivityMonitor = new VisitorInactivityMonitor();
    const businessHours = {
      Multiple: new MultipleBusinessHoursBehavior(),
      Single: new SingleBusinessHourBehavior()
    };
    settings.change('Livechat_max_queue_wait_time', async () => {
      await updateQueueInactivityTimeout();
    });
    Meteor.startup(async () => {
      settings.watch('Livechat_abandoned_rooms_action', async value => {
        await updatePredictedVisitorAbandonment();
        if (!value || value === 'none') {
          return visitorActivityMonitor.stop();
        }
        await visitorActivityMonitor.start();
      });
      settings.change('Livechat_visitor_inactivity_timeout', async () => {
        await updatePredictedVisitorAbandonment();
      });
      settings.change('Livechat_business_hour_type', async value => {
        logger.debug("Changing business hour type to ".concat(value));
        if (!Object.keys(businessHours).includes(value)) {
          logger.error("Invalid business hour type ".concat(value));
          return;
        }
        businessHourManager.registerBusinessHourBehavior(businessHours[value]);
        if (settings.get('Livechat_enable_business_hours')) {
          await businessHourManager.restartManager();
          logger.debug("Business hour manager started");
        }
      });
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"api-enterprise":{"server":{"lib":{"canned-responses.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/api-enterprise/server/lib/canned-responses.js                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      findAllCannedResponses: () => findAllCannedResponses,
      findAllCannedResponsesFilter: () => findAllCannedResponsesFilter,
      findOneCannedResponse: () => findOneCannedResponse
    });
    let CannedResponse;
    module.link("@rocket.chat/models", {
      CannedResponse(v) {
        CannedResponse = v;
      }
    }, 0);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 1);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 2);
    let getDepartmentsWhichUserCanAccess;
    module.link("../../../livechat-enterprise/server/api/lib/departments", {
      getDepartmentsWhichUserCanAccess(v) {
        getDepartmentsWhichUserCanAccess = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function findAllCannedResponses(_ref) {
      let {
        userId
      } = _ref;
      // If the user is an admin or livechat manager, get his own responses and all responses from all departments
      if (await hasPermissionAsync(userId, 'view-all-canned-responses')) {
        const cannedResponses = await CannedResponse.find({
          $or: [{
            scope: 'user',
            userId
          }, {
            scope: 'department'
          }, {
            scope: 'global'
          }]
        }).toArray();
        return cannedResponses;
      }

      // Last scenario: user is an agent, so get his own responses and those from the departments he is in
      const accessibleDepartments = await getDepartmentsWhichUserCanAccess(userId, true);
      const cannedResponses = await CannedResponse.find({
        $or: [{
          scope: 'user',
          userId
        }, {
          scope: 'department',
          departmentId: {
            $in: accessibleDepartments
          }
        }, {
          scope: 'global'
        }]
      }).toArray();
      return cannedResponses;
    }
    async function findAllCannedResponsesFilter(_ref2) {
      let {
        userId,
        shortcut,
        text,
        departmentId,
        scope,
        createdBy,
        tags = [],
        options = {}
      } = _ref2;
      let extraFilter = [];
      // if user cannot see all, filter to private + public + departments user is in
      if (!(await hasPermissionAsync(userId, 'view-all-canned-responses'))) {
        const accessibleDepartments = await getDepartmentsWhichUserCanAccess(userId, true);
        const isDepartmentInScope = departmentId => !!accessibleDepartments.includes(departmentId);
        const departmentIds = departmentId && isDepartmentInScope(departmentId) ? [departmentId] : accessibleDepartments;
        extraFilter = [{
          $or: [{
            scope: 'user',
            userId
          }, {
            scope: 'department',
            departmentId: {
              $in: departmentIds
            }
          }, {
            scope: 'global'
          }]
        }];
      }
      if (departmentId) {
        extraFilter = [{
          departmentId
        }];
      }
      const textFilter = new RegExp(escapeRegExp(text), 'i');
      let filter = {
        $and: [...(shortcut ? [{
          shortcut
        }] : []), ...(text ? [{
          $or: [{
            shortcut: textFilter
          }, {
            text: textFilter
          }]
        }] : []), ...(scope ? [{
          scope
        }] : []), ...(createdBy ? [{
          'createdBy._id': createdBy
        }] : []), ...(tags.length ? [{
          tags: {
            $in: tags
          }
        }] : []), ...extraFilter]
      };
      if (!filter.$and.length) {
        filter = {};
      }
      const {
        cursor,
        totalCount
      } = CannedResponse.findPaginated(filter, {
        sort: options.sort || {
          shortcut: 1
        },
        skip: options.offset,
        limit: options.count
      });
      const [cannedResponses, total] = await Promise.all([cursor.toArray(), totalCount]);
      return {
        cannedResponses,
        total
      };
    }
    async function findOneCannedResponse(_ref3) {
      let {
        userId,
        _id
      } = _ref3;
      if (await hasPermissionAsync(userId, 'view-all-canned-responses')) {
        return CannedResponse.findOneById(_id);
      }
      const accessibleDepartments = await getDepartmentsWhichUserCanAccess(userId, true);
      const filter = {
        _id,
        $or: [{
          scope: 'user',
          userId
        }, {
          scope: 'department',
          departmentId: {
            $in: accessibleDepartments
          }
        }, {
          scope: 'global'
        }]
      };
      return CannedResponse.findOne(filter);
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"middlewares":{"license.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/api-enterprise/server/middlewares/license.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.export({
  license: () => license
});
const license = (options, licenseManager) => async (c, next) => {
  if (!options.license) {
    return next();
  }
  const license = options.license.every(license => licenseManager.hasModule(license));
  const failure = {
    statusCode: 400,
    body: {
      success: false,
      error: 'This is an enterprise feature [error-action-not-allowed]',
      errorType: 'error-action-not-allowed'
    }
  };
  if (!license) {
    return c.json(failure.body, failure.statusCode);
  }
  return next();
};
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"canned-responses.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/api-enterprise/server/canned-responses.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let isPOSTCannedResponsesProps, isCannedResponsesProps, isDELETECannedResponsesProps;
    module.link("@rocket.chat/rest-typings", {
      isPOSTCannedResponsesProps(v) {
        isPOSTCannedResponsesProps = v;
      },
      isCannedResponsesProps(v) {
        isCannedResponsesProps = v;
      },
      isDELETECannedResponsesProps(v) {
        isDELETECannedResponsesProps = v;
      }
    }, 0);
    let findAllCannedResponses, findAllCannedResponsesFilter, findOneCannedResponse;
    module.link("./lib/canned-responses", {
      findAllCannedResponses(v) {
        findAllCannedResponses = v;
      },
      findAllCannedResponsesFilter(v) {
        findAllCannedResponsesFilter = v;
      },
      findOneCannedResponse(v) {
        findOneCannedResponse = v;
      }
    }, 1);
    let API;
    module.link("../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 2);
    let getPaginationItems;
    module.link("../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 3);
    let removeCannedResponse;
    module.link("../../canned-responses/server/methods/removeCannedResponse", {
      removeCannedResponse(v) {
        removeCannedResponse = v;
      }
    }, 4);
    let saveCannedResponse;
    module.link("../../canned-responses/server/methods/saveCannedResponse", {
      saveCannedResponse(v) {
        saveCannedResponse = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('canned-responses.get', {
      authRequired: true,
      permissionsRequired: ['view-canned-responses'],
      license: ['canned-responses']
    }, {
      async get() {
        return API.v1.success({
          responses: await findAllCannedResponses({
            userId: this.userId
          })
        });
      }
    });
    /**
     * @deprecated
     * @openapi
     * /api/v1/canned-responses:
     *  delete:
     *  	deprecated: true
     *  	security:
     *    	$ref: '#/security/authenticated'
     *  	parameters:
     *    	- in: body
     *      	name: body
     *      	description: |
     *        	**_id** (required): Canned Response ID to be removed.
     *      	schema:
     *        	type: object
     *        	required:
     *          	- _id
     *        	properties:
     *          	_id:
     *            	type: string
     *  	tags:
     *    	- Canned_Responses
     *  	responses:
     *    	200:
     *      	description: Successful Response
     *      	schema:
     *        	type: object
     *        	properties:
     *          	status:
     *            	type: string
     *            	example: success
     *          	data:
     *            	type: object
     *            	description: The response data
     *            	properties:
     *              	success:
     *                	type: boolean
     *                	example: true
     *    	401:
     *      	$ref: '#/responses/Unauthorized'
     *    	403:
     *      	$ref: '#/responses/Forbidden'
     *    	404:
     *      	$ref: '#/responses/NotFound'
     *    	500:
     *      	$ref: '#/responses/InternalServerError'
     */
    API.v1.addRoute('canned-responses', {
      authRequired: true,
      permissionsRequired: {
        GET: ['view-canned-responses'],
        POST: ['save-canned-responses'],
        DELETE: ['remove-canned-responses']
      },
      validateParams: {
        POST: isPOSTCannedResponsesProps,
        DELETE: isDELETECannedResponsesProps,
        GET: isCannedResponsesProps
      },
      license: ['canned-responses'],
      deprecations: {
        DELETE: {
          version: '8.0.0',
          alternatives: ['/v1/canned-responses/:_id']
        }
      }
    }, {
      async get() {
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          sort,
          fields
        } = await this.parseJsonQuery();
        const {
          shortcut,
          text,
          scope,
          tags,
          departmentId,
          createdBy
        } = this.queryParams;
        const {
          cannedResponses,
          total
        } = await findAllCannedResponsesFilter({
          shortcut,
          text,
          scope,
          tags,
          departmentId,
          userId: this.userId,
          createdBy,
          options: {
            sort,
            offset,
            count,
            fields
          }
        });
        return API.v1.success({
          cannedResponses,
          count: cannedResponses.length,
          offset,
          total
        });
      },
      async post() {
        const {
          _id,
          shortcut,
          text,
          scope,
          departmentId,
          tags
        } = this.bodyParams;
        await saveCannedResponse(this.userId, _objectSpread(_objectSpread({
          shortcut,
          text,
          scope
        }, tags && {
          tags
        }), departmentId && {
          departmentId
        }), _id);
        return API.v1.success();
      },
      // deprecated
      async delete() {
        const {
          _id
        } = this.bodyParams;
        await removeCannedResponse(this.userId, _id);
        return API.v1.success();
      }
    });
    API.v1.addRoute('canned-responses/:_id', {
      authRequired: true,
      permissionsRequired: {
        GET: ['view-canned-responses'],
        DELETE: ['remove-canned-responses']
      },
      license: ['canned-responses']
    }, {
      async get() {
        const {
          _id
        } = this.urlParams;
        const cannedResponse = await findOneCannedResponse({
          userId: this.userId,
          _id
        });
        if (!cannedResponse) {
          return API.v1.notFound();
        }
        return API.v1.success({
          cannedResponse
        });
      },
      async delete() {
        const {
          _id
        } = this.urlParams;
        await removeCannedResponse(this.userId, _id);
        return API.v1.success();
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/api-enterprise/server/index.ts                                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./canned-responses");
    module.link("./voip-freeswitch");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"voip-freeswitch.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/api-enterprise/server/voip-freeswitch.ts                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let VoipFreeSwitch;
    module.link("@rocket.chat/core-services", {
      VoipFreeSwitch(v) {
        VoipFreeSwitch = v;
      }
    }, 0);
    let Users;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      }
    }, 1);
    let isVoipFreeSwitchExtensionAssignProps, isVoipFreeSwitchExtensionGetDetailsProps, isVoipFreeSwitchExtensionGetInfoProps, isVoipFreeSwitchExtensionListProps;
    module.link("@rocket.chat/rest-typings", {
      isVoipFreeSwitchExtensionAssignProps(v) {
        isVoipFreeSwitchExtensionAssignProps = v;
      },
      isVoipFreeSwitchExtensionGetDetailsProps(v) {
        isVoipFreeSwitchExtensionGetDetailsProps = v;
      },
      isVoipFreeSwitchExtensionGetInfoProps(v) {
        isVoipFreeSwitchExtensionGetInfoProps = v;
      },
      isVoipFreeSwitchExtensionListProps(v) {
        isVoipFreeSwitchExtensionListProps = v;
      }
    }, 2);
    let wrapExceptions;
    module.link("@rocket.chat/tools", {
      wrapExceptions(v) {
        wrapExceptions = v;
      }
    }, 3);
    let API;
    module.link("../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 4);
    let settings;
    module.link("../../../../app/settings/server/cached", {
      settings(v) {
        settings = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('voip-freeswitch.extension.list', {
      authRequired: true,
      permissionsRequired: ['manage-voip-extensions'],
      validateParams: isVoipFreeSwitchExtensionListProps,
      license: ['voip-enterprise']
    }, {
      async get() {
        if (!settings.get('VoIP_TeamCollab_Enabled')) {
          throw new Error('error-voip-disabled');
        }
        const {
          username,
          type = 'all'
        } = this.queryParams;
        const extensions = await wrapExceptions(() => VoipFreeSwitch.getExtensionList()).catch(() => {
          throw new Error('error-loading-extension-list');
        });
        if (type === 'all') {
          return API.v1.success({
            extensions
          });
        }
        const assignedExtensions = await Users.findAssignedFreeSwitchExtensions().toArray();
        switch (type) {
          case 'free':
            const freeExtensions = extensions.filter(_ref => {
              let {
                extension
              } = _ref;
              return !assignedExtensions.includes(extension);
            });
            return API.v1.success({
              extensions: freeExtensions
            });
          case 'allocated':
            // Extensions that are already assigned to some user
            const allocatedExtensions = extensions.filter(_ref2 => {
              let {
                extension
              } = _ref2;
              return assignedExtensions.includes(extension);
            });
            return API.v1.success({
              extensions: allocatedExtensions
            });
          case 'available':
            // Extensions that are free or assigned to the specified user
            const user = username && (await Users.findOneByUsername(username, {
              projection: {
                freeSwitchExtension: 1
              }
            })) || undefined;
            const currentExtension = user === null || user === void 0 ? void 0 : user.freeSwitchExtension;
            const availableExtensions = extensions.filter(_ref3 => {
              let {
                extension
              } = _ref3;
              return extension === currentExtension || !assignedExtensions.includes(extension);
            });
            return API.v1.success({
              extensions: availableExtensions
            });
        }
        return API.v1.success({
          extensions
        });
      }
    });
    API.v1.addRoute('voip-freeswitch.extension.assign', {
      authRequired: true,
      permissionsRequired: ['manage-voip-extensions'],
      validateParams: isVoipFreeSwitchExtensionAssignProps,
      deprecation: {
        version: '8.0.0',
        alternatives: ['/v1/users.update']
      },
      license: ['voip-enterprise']
    }, {
      async post() {
        if (!settings.get('VoIP_TeamCollab_Enabled')) {
          throw new Error('error-voip-disabled');
        }
        const {
          extension,
          username
        } = this.bodyParams;
        if (!username) {
          return API.v1.notFound();
        }
        const user = await Users.findOneByUsername(username, {
          projection: {
            freeSwitchExtension: 1
          }
        });
        if (!user) {
          return API.v1.notFound();
        }
        const existingUser = extension && (await Users.findOneByFreeSwitchExtension(extension, {
          projection: {
            _id: 1
          }
        }));
        if (existingUser && existingUser._id !== user._id) {
          throw new Error('error-extension-not-available');
        }
        if (extension && user.freeSwitchExtension === extension) {
          return API.v1.success();
        }
        await Users.setFreeSwitchExtension(user._id, extension);
        return API.v1.success();
      }
    });
    API.v1.addRoute('voip-freeswitch.extension.getDetails', {
      authRequired: true,
      permissionsRequired: ['view-voip-extension-details'],
      validateParams: isVoipFreeSwitchExtensionGetDetailsProps,
      license: ['voip-enterprise']
    }, {
      async get() {
        if (!settings.get('VoIP_TeamCollab_Enabled')) {
          throw new Error('error-voip-disabled');
        }
        const {
          extension,
          group
        } = this.queryParams;
        if (!extension) {
          throw new Error('error-invalid-params');
        }
        const extensionData = await wrapExceptions(() => VoipFreeSwitch.getExtensionDetails({
          extension,
          group
        })).suppress(() => undefined);
        if (!extensionData) {
          return API.v1.notFound();
        }
        const existingUser = await Users.findOneByFreeSwitchExtension(extensionData.extension, {
          projection: {
            username: 1,
            name: 1
          }
        });
        return API.v1.success(_objectSpread(_objectSpread({}, extensionData), existingUser && {
          userId: existingUser._id,
          name: existingUser.name,
          username: existingUser.username
        }));
      }
    });
    API.v1.addRoute('voip-freeswitch.extension.getRegistrationInfoByUserId', {
      authRequired: true,
      permissionsRequired: ['view-user-voip-extension'],
      validateParams: isVoipFreeSwitchExtensionGetInfoProps,
      license: ['voip-enterprise']
    }, {
      async get() {
        if (!settings.get('VoIP_TeamCollab_Enabled')) {
          throw new Error('error-voip-disabled');
        }
        const {
          userId
        } = this.queryParams;
        if (!userId) {
          throw new Error('error-invalid-params');
        }
        const user = await Users.findOneById(userId, {
          projection: {
            freeSwitchExtension: 1
          }
        });
        if (!user) {
          throw new Error('error-user-not-found');
        }
        const {
          freeSwitchExtension: extension
        } = user;
        if (!extension) {
          throw new Error('error-extension-not-assigned');
        }
        const extensionData = await wrapExceptions(() => VoipFreeSwitch.getExtensionDetails({
          extension
        })).suppress(() => undefined);
        if (!extensionData) {
          return API.v1.notFound('error-registration-not-found');
        }
        const password = await wrapExceptions(() => VoipFreeSwitch.getUserPassword(extension)).suppress(() => undefined);
        return API.v1.success({
          extension: extensionData,
          credentials: {
            websocketPath: settings.get('VoIP_TeamCollab_FreeSwitch_WebSocket_Path'),
            password
          }
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"license":{"server":{"lib":{"getAppCount.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/lib/getAppCount.ts                                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      getAppCount: () => getAppCount
    });
    let Apps;
    module.link("@rocket.chat/core-services", {
      Apps(v) {
        Apps = v;
      }
    }, 0);
    let getInstallationSourceFromAppStorageItem;
    module.link("../../../../../lib/apps/getInstallationSourceFromAppStorageItem", {
      getInstallationSourceFromAppStorageItem(v) {
        getInstallationSourceFromAppStorageItem = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function getAppCount(source) {
      if (!(await Apps.isInitialized())) {
        return 0;
      }
      const apps = await Apps.getApps({
        enabled: true
      });
      if (!apps || !Array.isArray(apps)) {
        return 0;
      }
      const storageItems = await Promise.all(apps.map(app => Apps.getAppStorageItemById(app.id)));
      const activeAppsFromSameSource = storageItems.filter(item => item && getInstallationSourceFromAppStorageItem(item) === source);
      return activeAppsFromSameSource.length;
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"airGappedRestrictions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/airGappedRestrictions.ts                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let AirGappedRestriction, License;
    module.link("@rocket.chat/license", {
      AirGappedRestriction(v) {
        AirGappedRestriction = v;
      },
      License(v) {
        License = v;
      }
    }, 0);
    let Settings, Statistics;
    module.link("@rocket.chat/models", {
      Settings(v) {
        Settings = v;
      },
      Statistics(v) {
        Statistics = v;
      }
    }, 1);
    let notifyOnSettingChangedById;
    module.link("../../../../app/lib/server/lib/notifyListener", {
      notifyOnSettingChangedById(v) {
        notifyOnSettingChangedById = v;
      }
    }, 2);
    let i18n;
    module.link("../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 3);
    let sendMessagesToAdmins;
    module.link("../../../../server/lib/sendMessagesToAdmins", {
      sendMessagesToAdmins(v) {
        sendMessagesToAdmins = v;
      }
    }, 4);
    let updateAuditedBySystem;
    module.link("../../../../server/settings/lib/auditedSettingUpdates", {
      updateAuditedBySystem(v) {
        updateAuditedBySystem = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const updateRestrictionSetting = async remainingDays => {
      await updateAuditedBySystem({
        reason: 'updateRestrictionSetting'
      })(Settings.updateValueById, 'Cloud_Workspace_AirGapped_Restrictions_Remaining_Days', remainingDays);
      void notifyOnSettingChangedById('Cloud_Workspace_AirGapped_Restrictions_Remaining_Days');
    };
    const sendRocketCatWarningToAdmins = async remainingDays => {
      const lastDayOrNoRestrictionsAtAll = remainingDays <= 0;
      if (lastDayOrNoRestrictionsAtAll) {
        return;
      }
      if (AirGappedRestriction.isWarningPeriod(remainingDays)) {
        await sendMessagesToAdmins({
          msgs: async _ref => {
            let {
              adminUser
            } = _ref;
            return {
              msg: i18n.t('AirGapped_Restriction_Warning', {
                lng: adminUser.language || 'en',
                remainingDays
              })
            };
          }
        });
      }
    };
    AirGappedRestriction.on('remainingDays', async _ref2 => {
      let {
        days
      } = _ref2;
      await updateRestrictionSetting(days);
      await sendRocketCatWarningToAdmins(days);
    });
    License.onValidateLicense(async () => {
      const token = await Statistics.findLastStatsToken();
      void AirGappedRestriction.computeRestriction(token);
    });
    License.onRemoveLicense(async () => {
      const token = await Statistics.findLastStatsToken();
      void AirGappedRestriction.computeRestriction(token);
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"canEnableApp.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/canEnableApp.ts                                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      _canEnableApp: () => _canEnableApp,
      canEnableApp: () => canEnableApp
    });
    let Apps;
    module.link("@rocket.chat/core-services", {
      Apps(v) {
        Apps = v;
      }
    }, 0);
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 1);
    let getInstallationSourceFromAppStorageItem;
    module.link("../../../../lib/apps/getInstallationSourceFromAppStorageItem", {
      getInstallationSourceFromAppStorageItem(v) {
        getInstallationSourceFromAppStorageItem = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const _canEnableApp = async (_ref, app) => {
      var _app$marketplaceInfo;
      let {
        Apps,
        License
      } = _ref;
      if (!(await Apps.isInitialized())) {
        throw new Error('apps-engine-not-initialized');
      }
      // Migrated apps were installed before the validation was implemented
      // so they're always allowed to be enabled
      if (app.migrated) {
        return;
      }
      if (app.info.addon && !License.hasModule(app.info.addon)) {
        throw new Error('app-addon-not-valid');
      }
      const source = getInstallationSourceFromAppStorageItem(app);
      switch (source) {
        case 'private':
          if (await License.shouldPreventAction('privateApps')) {
            throw new Error('license-prevented');
          }
          break;
        default:
          if (await License.shouldPreventAction('marketplaceApps')) {
            throw new Error('license-prevented');
          }
          const marketplaceInfo = (_app$marketplaceInfo = app.marketplaceInfo) === null || _app$marketplaceInfo === void 0 ? void 0 : _app$marketplaceInfo[0];
          if (marketplaceInfo !== null && marketplaceInfo !== void 0 && marketplaceInfo.isEnterpriseOnly && !License.hasValidLicense()) {
            throw new Error('invalid-license');
          }
          break;
      }
    };
    const canEnableApp = async app => _canEnableApp({
      Apps,
      License
    }, app);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"getSeatsRequestLink.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/getSeatsRequestLink.ts                                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      getSeatsRequestLink: () => getSeatsRequestLink
    });
    let Settings, Users;
    module.link("@rocket.chat/models", {
      Settings(v) {
        Settings = v;
      },
      Users(v) {
        Users = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const getSeatsRequestLink = async (url, params) => {
      const workspaceId = await Settings.findOneById('Cloud_Workspace_Id');
      const activeUsers = await Users.getActiveLocalUserCount();
      const wizardSettings = await Settings.findSetupWizardSettings().toArray();
      const newUrl = new URL(url);
      if (workspaceId !== null && workspaceId !== void 0 && workspaceId.value) {
        newUrl.searchParams.append('workspaceId', String(workspaceId.value));
      }
      if (activeUsers) {
        newUrl.searchParams.append('activeUsers', String(activeUsers));
      }
      wizardSettings.filter(_ref => {
        let {
          _id,
          value
        } = _ref;
        return ['Industry', 'Country', 'Size'].includes(_id) && value;
      }).forEach(setting => {
        newUrl.searchParams.append(setting._id.toLowerCase(), String(setting.value));
      });
      if (params) {
        Object.entries(params).forEach(_ref2 => {
          let [key, value] = _ref2;
          newUrl.searchParams.append(key, String(value));
        });
      }
      return newUrl.toString();
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/index.ts                                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./settings");
    module.link("./methods");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"license.internalService.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/license.internalService.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module1, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module1.export({
      LicenseService: () => LicenseService
    });
    let api, ServiceClassInternal;
    module1.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      },
      ServiceClassInternal(v) {
        ServiceClassInternal = v;
      }
    }, 0);
    let License;
    module1.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 1);
    let guestPermissions;
    module1.link("../../authorization/lib/guestPermissions", {
      guestPermissions(v) {
        guestPermissions = v;
      }
    }, 2);
    let resetEnterprisePermissions;
    module1.link("../../authorization/server/resetEnterprisePermissions", {
      resetEnterprisePermissions(v) {
        resetEnterprisePermissions = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class LicenseService extends ServiceClassInternal {
      constructor() {
        super();
        this.name = 'license';
        License.onValidateLicense(() => {
          if (!License.hasValidLicense()) {
            return;
          }
          void api.broadcast('authorization.guestPermissions', guestPermissions);
          void resetEnterprisePermissions();
        });
        License.onModule(licenseModule => {
          void api.broadcast('license.module', licenseModule);
        });
        this.onEvent('license.actions', preventedActions => License.syncShouldPreventActionResults(preventedActions));
        this.onEvent('license.sync', () => License.sync());
      }
      async started() {
        if (!License.hasValidLicense()) {
          return;
        }
        void api.broadcast('authorization.guestPermissions', guestPermissions);
        await resetEnterprisePermissions();
      }
      hasModule(feature) {
        return License.hasModule(feature);
      }
      hasValidLicense() {
        return License.hasValidLicense();
      }
      getModules() {
        return License.getModules();
      }
      getGuestPermissions() {
        return guestPermissions;
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"methods.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/methods.ts                                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.methods({
      'license:hasLicense'(feature) {
        check(feature, String);
        return License.hasModule(feature);
      },
      'license:getModules'() {
        return License.getModules();
      },
      'license:getTags'() {
        return License.getTags();
      },
      'license:isEnterprise'() {
        return License.hasValidLicense();
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"settings.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/settings.ts                                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let settingsRegistry;
    module.link("../../../../app/settings/server", {
      settingsRegistry(v) {
        settingsRegistry = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    // The proper name for this group is Premium, but we can't change it because it's already in use and we will break the settings
    // TODO: Keep this until next major updates
    await settingsRegistry.addGroup('Enterprise', async function () {
      await this.section('Enterprise', async function () {
        await this.add('Enterprise_License', '', {
          type: 'string',
          i18nLabel: 'Premium_License',
          alert: 'Premium_License_alert'
        });
        await this.add('Enterprise_License_Data', '', {
          type: 'string',
          hidden: true,
          public: false
        });
        await this.add('Enterprise_License_Status', '', {
          readonly: true,
          type: 'string',
          i18nLabel: 'Status'
        });
      });
      await this.add('Cloud_Workspace_AirGapped_Restrictions_Remaining_Days', -1, {
        type: 'int',
        readonly: true,
        public: true
      });
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"startup.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/license/server/startup.ts                                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      startLicense: () => startLicense
    });
    let api;
    module.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      }
    }, 0);
    let applyLicense, applyLicenseOrRemove, License;
    module.link("@rocket.chat/license", {
      applyLicense(v) {
        applyLicense = v;
      },
      applyLicenseOrRemove(v) {
        applyLicenseOrRemove = v;
      },
      License(v) {
        License = v;
      }
    }, 1);
    let Subscriptions, Users, Settings, LivechatContacts;
    module.link("@rocket.chat/models", {
      Subscriptions(v) {
        Subscriptions = v;
      },
      Users(v) {
        Users = v;
      },
      Settings(v) {
        Settings = v;
      },
      LivechatContacts(v) {
        LivechatContacts = v;
      }
    }, 2);
    let wrapExceptions;
    module.link("@rocket.chat/tools", {
      wrapExceptions(v) {
        wrapExceptions = v;
      }
    }, 3);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 4);
    let getAppCount;
    module.link("./lib/getAppCount", {
      getAppCount(v) {
        getAppCount = v;
      }
    }, 5);
    let syncWorkspace;
    module.link("../../../../app/cloud/server/functions/syncWorkspace", {
      syncWorkspace(v) {
        syncWorkspace = v;
      }
    }, 6);
    let notifyOnSettingChangedById;
    module.link("../../../../app/lib/server/lib/notifyListener", {
      notifyOnSettingChangedById(v) {
        notifyOnSettingChangedById = v;
      }
    }, 7);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 8);
    let callbacks;
    module.link("../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 9);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const startLicense = async () => {
      settings.watch('Site_Url', value => {
        if (value) {
          void License.setWorkspaceUrl(value);
        }
      });
      License.onValidateLicense(async () => {
        (await Settings.updateValueById('Enterprise_License', License.encryptedLicense)).modifiedCount && void notifyOnSettingChangedById('Enterprise_License');
        (await Settings.updateValueById('Enterprise_License_Status', 'Valid')).modifiedCount && void notifyOnSettingChangedById('Enterprise_License_Status');
      });
      License.onInvalidateLicense(async () => {
        (await Settings.updateValueById('Enterprise_License_Status', 'Invalid')).modifiedCount && void notifyOnSettingChangedById('Enterprise_License_Status');
      });
      License.onRemoveLicense(async () => {
        (await Settings.updateValueById('Enterprise_License', '')).modifiedCount && void notifyOnSettingChangedById('Enterprise_License_Status');
        (await Settings.updateValueById('Enterprise_License_Status', 'Invalid')).modifiedCount && void notifyOnSettingChangedById('Enterprise_License_Status');
      });
      /**
       * This is a debounced function that will sync the workspace data to the cloud.
       * it caches the context, waits for a second and then syncs the data.
       */
      const syncByTriggerDebounced = (() => {
        let timeout;
        const contexts = new Set();
        return async context => {
          contexts.add(context);
          if (timeout) {
            clearTimeout(timeout);
          }
          timeout = setTimeout(() => {
            timeout = undefined;
            void syncByTrigger([...contexts]);
            contexts.clear();
          }, 1000);
        };
      })();
      const syncByTrigger = async contexts => {
        var _wrapExceptions$catch;
        if (!License.encryptedLicense) {
          return;
        }
        const existingData = (_wrapExceptions$catch = wrapExceptions(() => JSON.parse(settings.get('Enterprise_License_Data'))).catch(() => ({}))) !== null && _wrapExceptions$catch !== void 0 ? _wrapExceptions$catch : {};
        const date = new Date();
        const day = date.getDate();
        const month = date.getMonth() + 1;
        const year = date.getFullYear();
        const period = "".concat(year, "-").concat(month, "-").concat(day);
        const [,, signed] = License.encryptedLicense.split('.');
        // Check if this sync has already been done. Based on License, behavior.
        if ([...contexts.values()].every(context => existingData.signed === signed && existingData[context] === period)) {
          return;
        }
        const obj = Object.fromEntries(contexts.map(context => [context, period]));
        (await Settings.updateValueById('Enterprise_License_Data', JSON.stringify(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, existingData.signed === signed && existingData), existingData), obj), {}, {
          signed
        })))).modifiedCount && void notifyOnSettingChangedById('Enterprise_License_Data');
        try {
          await syncWorkspace();
        } catch (error) {
          console.error(error);
        }
      };
      License.setLicenseLimitCounter('activeUsers', () => Users.getActiveLocalUserCount());
      License.setLicenseLimitCounter('guestUsers', () => Users.getActiveLocalGuestCount());
      License.setLicenseLimitCounter('roomsPerGuest', async context => context !== null && context !== void 0 && context.userId ? Subscriptions.countByUserId(context.userId) : 0);
      License.setLicenseLimitCounter('privateApps', () => getAppCount('private'));
      License.setLicenseLimitCounter('marketplaceApps', () => getAppCount('marketplace'));
      License.setLicenseLimitCounter('monthlyActiveContacts', () => LivechatContacts.countContactsOnPeriod(moment.utc().format('YYYY-MM')));
      return new Promise(resolve => {
        // When settings are loaded, apply the current license if there is one.
        settings.onReady(async () => {
          var _settings$get;
          module.dynamicImport('./airGappedRestrictions');
          if (!(await applyLicense((_settings$get = settings.get('Enterprise_License')) !== null && _settings$get !== void 0 ? _settings$get : '', false))) {
            // License from the envvar is always treated as new, because it would have been saved on the setting if it was already in use.
            if (process.env.ROCKETCHAT_LICENSE && !License.hasValidLicense()) {
              await applyLicense(process.env.ROCKETCHAT_LICENSE, true);
            }
          }
          // After the current license is already loaded, watch the setting value to react to new licenses being applied.
          settings.change('Enterprise_License', license => applyLicenseOrRemove(license, true));
          callbacks.add('workspaceLicenseRemoved', () => License.remove());
          callbacks.add('workspaceLicenseChanged', updatedLicense => applyLicense(updatedLicense, true));
          License.onInstall(async () => void api.broadcast('license.actions', {}));
          License.onInvalidate(async () => void api.broadcast('license.actions', {}));
          License.onBehaviorTriggered('prevent_action', context => syncByTriggerDebounced("prevent_action_".concat(context.limit)));
          License.onBehaviorTriggered('start_fair_policy', async context => syncByTriggerDebounced("start_fair_policy_".concat(context.limit)));
          License.onBehaviorTriggered('disable_modules', async context => syncByTriggerDebounced("disable_modules_".concat(context.limit)));
          License.onChange(() => api.broadcast('license.sync'));
          License.onBehaviorToggled('prevent_action', context => {
            if (!context.limit) {
              return;
            }
            void api.broadcast('license.actions', {
              [context.limit]: true
            });
          });
          License.onBehaviorToggled('allow_action', context => {
            if (!context.limit) {
              return;
            }
            void api.broadcast('license.actions', {
              [context.limit]: false
            });
          });
          resolve();
        });
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"voip-enterprise":{"server":{"lib":{"calculateOnHoldTimeForRoom.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/voip-enterprise/server/lib/calculateOnHoldTimeForRoom.ts                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      calculateOnHoldTimeForRoom: () => calculateOnHoldTimeForRoom
    });
    let PbxEvents;
    module.link("@rocket.chat/models", {
      PbxEvents(v) {
        PbxEvents = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const calculateOnHoldTimeForRoom = async (room, closedAt) => {
      if (!room.callUniqueId) {
        return 0;
      }
      const events = await PbxEvents.findByEvents(room.callUniqueId, ['Hold', 'Unhold']).toArray();
      if (!events.length) {
        // if there's no events, that means no hold time
        return 0;
      }
      if (events.length === 1 && events[0].event === 'Unhold') {
        // if the only event is an unhold event, something bad happened
        return 0;
      }
      if (events.length === 1 && events[0].event === 'Hold') {
        // if the only event is a hold event, the call was ended while on hold
        // hold time = room.closedAt - event.ts
        return closedAt.getTime() - events[0].ts.getTime();
      }
      let currentOnHoldTime = 0;
      for (let i = 0; i < events.length; i += 2) {
        var _events;
        const onHold = events[i].ts;
        const unHold = ((_events = events[i + 1]) === null || _events === void 0 ? void 0 : _events.ts) || closedAt;
        currentOnHoldTime += unHold.getTime() - onHold.getTime();
      }
      return currentOnHoldTime;
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"services":{"voipService.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/voip-enterprise/server/services/voipService.ts                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let OmnichannelVoipService;
    module.link("../../../../../server/services/omnichannel-voip/service", {
      OmnichannelVoipService(v) {
        OmnichannelVoipService = v;
      }
    }, 1);
    let calculateOnHoldTimeForRoom;
    module.link("../lib/calculateOnHoldTimeForRoom", {
      calculateOnHoldTimeForRoom(v) {
        calculateOnHoldTimeForRoom = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    await License.overwriteClassOnLicense('voip-enterprise', OmnichannelVoipService, {
      async getRoomClosingData(_originalFn, closeInfo, closeSystemMsgData, room, sysMessageId, options) {
        const {
          comment,
          tags
        } = options || {};
        if (comment) {
          closeSystemMsgData.msg = comment;
        }
        if (tags !== null && tags !== void 0 && tags.length) {
          closeInfo.tags = tags;
        }
        if (sysMessageId === 'voip-call-wrapup' && !comment) {
          closeSystemMsgData.t = 'voip-call-ended';
        }
        const now = new Date();
        const callTotalHoldTime = await calculateOnHoldTimeForRoom(room, now);
        closeInfo.callTotalHoldTime = callTotalHoldTime;
        return {
          closeInfo,
          closeSystemMsgData
        };
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/voip-enterprise/server/index.ts                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./services/voipService");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"authorization":{"lib":{"addRoleRestrictions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/authorization/lib/addRoleRestrictions.ts                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      addRoleRestrictions: () => addRoleRestrictions
    });
    let guestPermissions;
    module.link("./guestPermissions", {
      guestPermissions(v) {
        guestPermissions = v;
      }
    }, 0);
    let AuthorizationUtils;
    module.link("../../../../app/authorization/lib/AuthorizationUtils", {
      AuthorizationUtils(v) {
        AuthorizationUtils = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const addRoleRestrictions = function () {
      AuthorizationUtils.addRolePermissionWhiteList('guest', guestPermissions);
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"guestPermissions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/authorization/lib/guestPermissions.ts                                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.export({
  guestPermissions: () => guestPermissions
});
const guestPermissions = ['view-d-room', 'view-joined-room', 'view-p-room', 'start-discussion', 'mobile-upload-file'];
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"server":{"callback.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/authorization/server/callback.ts                                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let MeteorError;
    module.link("@rocket.chat/core-services", {
      MeteorError(v) {
        MeteorError = v;
      }
    }, 0);
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 1);
    let validateUserRoles;
    module.link("./validateUserRoles", {
      validateUserRoles(v) {
        validateUserRoles = v;
      }
    }, 2);
    let callbacks;
    module.link("../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 3);
    let i18n;
    module.link("../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    License.onInstall(() => {
      callbacks.add('beforeSaveUser', async _ref => {
        let {
          user,
          oldUser
        } = _ref;
        return validateUserRoles(user, oldUser);
      }, callbacks.priority.HIGH, 'validateUserRoles');
      callbacks.add('afterSaveUser', async user => {
        await License.shouldPreventAction('activeUsers');
        return user;
      }, callbacks.priority.HIGH, 'validateUserRoles');
      callbacks.add('afterDeleteUser', async user => {
        await License.shouldPreventAction('activeUsers');
        return user;
      }, callbacks.priority.HIGH, 'validateUserRoles');
      callbacks.add('afterDeactivateUser', async user => {
        await License.shouldPreventAction('activeUsers');
        return user;
      }, callbacks.priority.HIGH, 'validateUserStatus');
      callbacks.add('beforeActivateUser', async () => {
        if (await License.shouldPreventAction('activeUsers')) {
          throw new MeteorError('error-license-user-limit-reached', i18n.t('error-license-user-limit-reached'));
        }
        return undefined;
      }, callbacks.priority.HIGH, 'validateUserStatus');
    });
    License.onInvalidate(() => {
      callbacks.remove('beforeSaveUser', 'validateUserRoles');
      callbacks.remove('afterSaveUser', 'validateUserRoles');
      callbacks.remove('afterDeleteUser', 'validateUserRoles');
      callbacks.remove('afterDeactivateUser', 'validateUserStatus');
      callbacks.remove('beforeActivateUser', 'validateUserStatus');
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/authorization/server/index.ts                                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("../lib/addRoleRestrictions");
    module.link("./callback");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"resetEnterprisePermissions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/authorization/server/resetEnterprisePermissions.ts                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      resetEnterprisePermissions: () => resetEnterprisePermissions
    });
    let Permissions;
    module.link("@rocket.chat/models", {
      Permissions(v) {
        Permissions = v;
      }
    }, 0);
    let guestPermissions;
    module.link("../lib/guestPermissions", {
      guestPermissions(v) {
        guestPermissions = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const resetEnterprisePermissions = async function () {
      await Permissions.updateMany({
        _id: {
          $nin: guestPermissions
        },
        roles: 'guest'
      }, {
        $pull: {
          roles: 'guest'
        }
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"validateUserRoles.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/authorization/server/validateUserRoles.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      validateUserRoles: () => validateUserRoles
    });
    let MeteorError;
    module.link("@rocket.chat/core-services", {
      MeteorError(v) {
        MeteorError = v;
      }
    }, 0);
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 1);
    let i18n;
    module.link("../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function validateUserRoles(userData, currentUserData) {
      var _userData$roles, _currentUserData$role;
      const isApp = Boolean(userData.type === 'app');
      const wasApp = Boolean((currentUserData === null || currentUserData === void 0 ? void 0 : currentUserData.type) === 'app');
      const isBot = Boolean(userData.type === 'bot');
      const wasBot = Boolean((currentUserData === null || currentUserData === void 0 ? void 0 : currentUserData.type) === 'bot');
      const isGuest = Boolean(((_userData$roles = userData.roles) === null || _userData$roles === void 0 ? void 0 : _userData$roles.includes('guest')) && userData.roles.length === 1);
      const wasGuest = Boolean((currentUserData === null || currentUserData === void 0 ? void 0 : (_currentUserData$role = currentUserData.roles) === null || _currentUserData$role === void 0 ? void 0 : _currentUserData$role.includes('guest')) && currentUserData.roles.length === 1);
      const isSpecialType = isApp || isBot;
      const hasGuestToChanged = isGuest && !wasGuest;
      if (isSpecialType) {
        return;
      }
      if (hasGuestToChanged && (await License.shouldPreventAction('guestUsers'))) {
        throw new MeteorError('error-max-guests-number-reached', 'Maximum number of guests reached.', {
          method: 'insertOrUpdateUser',
          field: 'Assign_role'
        });
      }
      if (isGuest) {
        return;
      }
      const isActive = Boolean(userData.active !== false);
      const wasActive = currentUserData && (currentUserData === null || currentUserData === void 0 ? void 0 : currentUserData.active) !== false;
      const hasRemovedSpecialType = wasApp && !isApp || wasBot && !isBot;
      if (!isActive) {
        return;
      }
      if (!hasRemovedSpecialType && wasActive) {
        return;
      }
      if (await License.shouldPreventAction('activeUsers')) {
        throw new MeteorError('error-license-user-limit-reached', i18n.t('error-license-user-limit-reached'));
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"canned-responses":{"server":{"hooks":{"cannedResponses.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/canned-responses/server/hooks/cannedResponses.ts                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 1);
    let BeforeSaveCannedResponse;
    module.link("../../../../server/hooks/messages/BeforeSaveCannedResponse", {
      BeforeSaveCannedResponse(v) {
        BeforeSaveCannedResponse = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    void License.onToggledFeature('canned-responses', {
      up: () => {
        // when the license is enabled, we need to check if the feature is enabled
        BeforeSaveCannedResponse.enabled = settings.get('Canned_Responses_Enable');
      },
      down: () => {
        // when the license is disabled, we can just disable the feature
        BeforeSaveCannedResponse.enabled = false;
      }
    });
    // we also need to check if the feature is enabled via setting, which is only possible when there is a license
    settings.watch('Canned_Responses_Enable', value => {
      BeforeSaveCannedResponse.enabled = value;
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onRemoveAgentDepartment.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/canned-responses/server/hooks/onRemoveAgentDepartment.ts                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let CannedResponse;
    module.link("@rocket.chat/models", {
      CannedResponse(v) {
        CannedResponse = v;
      }
    }, 0);
    let notifications;
    module.link("../../../../../app/notifications/server/lib/Notifications", {
      default(v) {
        notifications = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.removeAgentDepartment', async options => {
      const {
        departmentId,
        agentsId
      } = options;
      await CannedResponse.findByDepartmentId(departmentId, {
        projection: {
          _id: 1
        }
      }).forEach(response => {
        const {
          _id
        } = response;
        notifications.streamCannedResponses.emit('canned-responses', {
          type: 'removed',
          _id
        }, {
          agentsId
        });
      });
      return options;
    }, callbacks.priority.HIGH, 'canned-responses-on-remove-agent-department');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"onSaveAgentDepartment.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/canned-responses/server/hooks/onSaveAgentDepartment.ts                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let CannedResponse;
    module.link("@rocket.chat/models", {
      CannedResponse(v) {
        CannedResponse = v;
      }
    }, 0);
    let notifications;
    module.link("../../../../../app/notifications/server/lib/Notifications", {
      default(v) {
        notifications = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('livechat.saveAgentDepartment', async options => {
      const {
        departmentId,
        agentsId
      } = options;
      await CannedResponse.findByDepartmentId(departmentId, {}).forEach(response => {
        notifications.streamCannedResponses.emit('canned-responses', _objectSpread({
          type: 'changed'
        }, response), {
          agentsId
        });
      });
      return options;
    }, callbacks.priority.HIGH, 'canned-responses-on-save-agent-department');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"methods":{"removeCannedResponse.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/canned-responses/server/methods/removeCannedResponse.ts                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      removeCannedResponse: () => removeCannedResponse
    });
    let CannedResponse;
    module.link("@rocket.chat/models", {
      CannedResponse(v) {
        CannedResponse = v;
      }
    }, 0);
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 3);
    let methodDeprecationLogger;
    module.link("../../../../../app/lib/server/lib/deprecationWarningLogger", {
      methodDeprecationLogger(v) {
        methodDeprecationLogger = v;
      }
    }, 4);
    let notifications;
    module.link("../../../../../app/notifications/server/lib/Notifications", {
      default(v) {
        notifications = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const removeCannedResponse = async (uid, _id) => {
      if (!(await hasPermissionAsync(uid, 'remove-canned-responses'))) {
        throw new Meteor.Error('error-not-allowed', 'Not allowed', {
          method: 'removeCannedResponse'
        });
      }
      check(_id, String);
      const cannedResponse = await CannedResponse.findOneById(_id);
      if (!cannedResponse) {
        throw new Meteor.Error('error-canned-response-not-found', 'Canned Response not found', {
          method: 'removeCannedResponse'
        });
      }
      notifications.streamCannedResponses.emit('canned-responses', {
        type: 'removed',
        _id
      });
      await CannedResponse.removeById(_id);
    };
    Meteor.methods({
      async removeCannedResponse(_id) {
        methodDeprecationLogger.method('removeCannedResponse', '8.0.0', 'DELETE /v1/canned-responses/:_id');
        const uid = Meteor.userId();
        if (!uid) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'removeCannedResponse'
          });
        }
        return removeCannedResponse(uid, _id);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"saveCannedResponse.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/canned-responses/server/methods/saveCannedResponse.ts                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      saveCannedResponse: () => saveCannedResponse
    });
    let LivechatDepartment, CannedResponse, Users;
    module.link("@rocket.chat/models", {
      LivechatDepartment(v) {
        LivechatDepartment = v;
      },
      CannedResponse(v) {
        CannedResponse = v;
      },
      Users(v) {
        Users = v;
      }
    }, 0);
    let Match, check;
    module.link("meteor/check", {
      Match(v) {
        Match = v;
      },
      check(v) {
        check = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    let hasPermissionAsync;
    module.link("../../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 3);
    let methodDeprecationLogger;
    module.link("../../../../../app/lib/server/lib/deprecationWarningLogger", {
      methodDeprecationLogger(v) {
        methodDeprecationLogger = v;
      }
    }, 4);
    let notifications;
    module.link("../../../../../app/notifications/server/lib/Notifications", {
      default(v) {
        notifications = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const saveCannedResponse = async (userId, responseData, _id) => {
      if (!(await hasPermissionAsync(userId, 'save-canned-responses'))) {
        throw new Meteor.Error('error-not-allowed', 'Not allowed', {
          method: 'saveCannedResponse'
        });
      }
      check(_id, Match.Maybe(String));
      check(responseData, {
        shortcut: String,
        text: String,
        scope: String,
        tags: Match.Maybe([String]),
        departmentId: Match.Maybe(String)
      });
      const canSaveAll = await hasPermissionAsync(userId, 'save-all-canned-responses');
      if (!canSaveAll && ['global'].includes(responseData.scope)) {
        throw new Meteor.Error('error-not-allowed', 'Not allowed to modify canned responses on *global* scope', {
          method: 'saveCannedResponse'
        });
      }
      const canSaveDepartment = await hasPermissionAsync(userId, 'save-department-canned-responses');
      if (!canSaveAll && !canSaveDepartment && ['department'].includes(responseData.scope)) {
        throw new Meteor.Error('error-not-allowed', 'Not allowed to modify canned responses on *department* scope', {
          method: 'saveCannedResponse'
        });
      }
      // to avoid inconsistencies
      if (responseData.scope === 'user') {
        delete responseData.departmentId;
      }
      // TODO: check if the department i'm trying to save is a department i can interact with
      // check if the response already exists and we're not updating one
      const duplicateShortcut = await CannedResponse.findOneByShortcut(responseData.shortcut, {
        projection: {
          _id: 1
        }
      });
      if (!_id && duplicateShortcut || _id && duplicateShortcut && duplicateShortcut._id !== _id) {
        throw new Meteor.Error('error-invalid-shortcut', 'Shortcut provided already exists', {
          method: 'saveCannedResponse'
        });
      }
      if (responseData.scope === 'department' && !responseData.departmentId) {
        throw new Meteor.Error('error-invalid-department', 'Invalid department', {
          method: 'saveCannedResponse'
        });
      }
      if (responseData.departmentId && !(await LivechatDepartment.findOneById(responseData.departmentId, {
        projection: {
          _id: 1
        }
      }))) {
        throw new Meteor.Error('error-invalid-department', 'Invalid department', {
          method: 'saveCannedResponse'
        });
      }
      let result;
      if (_id) {
        const cannedResponse = await CannedResponse.findOneById(_id);
        if (!cannedResponse) {
          throw new Meteor.Error('error-canned-response-not-found', 'Canned Response not found', {
            method: 'saveCannedResponse'
          });
        }
        result = await CannedResponse.updateCannedResponse(_id, _objectSpread(_objectSpread(_objectSpread({}, responseData), cannedResponse.scope === 'user' && {
          userId: cannedResponse.userId
        }), {}, {
          createdBy: cannedResponse.createdBy
        }));
      } else {
        const user = await Users.findOneById(userId);
        const data = _objectSpread(_objectSpread(_objectSpread({}, responseData), responseData.scope === 'user' && {
          userId: user === null || user === void 0 ? void 0 : user._id
        }), {}, {
          createdBy: {
            _id: (user === null || user === void 0 ? void 0 : user._id) || '',
            username: (user === null || user === void 0 ? void 0 : user.username) || ''
          },
          _createdAt: new Date()
        });
        result = await CannedResponse.createCannedResponse(data);
      }
      notifications.streamCannedResponses.emit('canned-responses', _objectSpread({
        type: 'changed'
      }, result));
      return result;
    };
    Meteor.methods({
      async saveCannedResponse(_id, responseData) {
        methodDeprecationLogger.method('saveCannedResponse', '8.0.0', 'POST /v1/canned-responses');
        const userId = Meteor.userId();
        if (!userId) {
          throw new Meteor.Error('error-not-allowed', 'Not allowed', {
            method: 'saveCannedResponse'
          });
        }
        return saveCannedResponse(userId, responseData, _id);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/canned-responses/server/index.ts                                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    await License.onLicense('canned-responses', async () => {
      const {
        createSettings
      } = await module.dynamicImport('./settings');
      await module.dynamicImport('./permissions');
      await module.dynamicImport('./hooks/onRemoveAgentDepartment');
      await module.dynamicImport('./hooks/onSaveAgentDepartment');
      await module.dynamicImport('./hooks/cannedResponses');
      await module.dynamicImport('./methods/saveCannedResponse');
      await module.dynamicImport('./methods/removeCannedResponse');
      await createSettings();
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"permissions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/canned-responses/server/permissions.ts                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let Permissions;
    module.link("@rocket.chat/models", {
      Permissions(v) {
        Permissions = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    Meteor.startup(async () => {
      await Permissions.create('view-canned-responses', ['livechat-agent', 'livechat-monitor', 'livechat-manager', 'admin']);
      await Permissions.create('view-all-canned-responses', ['livechat-manager', 'admin']);
      await Permissions.create('view-agent-canned-responses', ['livechat-agent']);
      await Permissions.create('save-canned-responses', ['livechat-agent', 'livechat-monitor', 'livechat-manager', 'admin']);
      await Permissions.create('save-all-canned-responses', ['livechat-manager', 'admin']);
      await Permissions.create('save-department-canned-responses', ['livechat-monitor']);
      await Permissions.create('remove-canned-responses', ['livechat-agent', 'livechat-monitor', 'livechat-manager', 'admin']);
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"settings.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/canned-responses/server/settings.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      createSettings: () => createSettings
    });
    let settingsRegistry;
    module.link("../../../../app/settings/server", {
      settingsRegistry(v) {
        settingsRegistry = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const omnichannelEnabledQuery = {
      _id: 'Livechat_enabled',
      value: true
    };
    const createSettings = async () => {
      await settingsRegistry.add('Canned_Responses_Enable', true, {
        group: 'Omnichannel',
        section: 'Canned_Responses',
        type: 'boolean',
        public: true,
        enterprise: true,
        invalidValue: false,
        modules: ['canned-responses'],
        enableQuery: omnichannelEnabledQuery
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"message-read-receipt":{"server":{"hooks":{"afterDeleteRoom.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/message-read-receipt/server/hooks/afterDeleteRoom.ts                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let ReadReceipts;
    module.link("@rocket.chat/models", {
      ReadReceipts(v) {
        ReadReceipts = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('afterDeleteRoom', async rid => {
      await ReadReceipts.removeByRoomId(rid);
      return rid;
    }, callbacks.priority.LOW, 'DeleteReadReceipts');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterReadMessages.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/message-read-receipt/server/hooks/afterReadMessages.ts                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let MessageReads;
    module.link("@rocket.chat/core-services", {
      MessageReads(v) {
        MessageReads = v;
      }
    }, 0);
    let settings;
    module.link("../../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    let ReadReceipt;
    module.link("../../../../server/lib/message-read-receipt/ReadReceipt", {
      ReadReceipt(v) {
        ReadReceipt = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('afterReadMessages', async (rid, params) => {
      if (!settings.get('Message_Read_Receipt_Enabled')) {
        return;
      }
      const {
        uid,
        lastSeen,
        tmid
      } = params;
      if (tmid) {
        await MessageReads.readThread(uid, tmid);
      } else if (lastSeen) {
        await ReadReceipt.markMessagesAsRead(rid, uid, lastSeen);
      }
    }, callbacks.priority.MEDIUM, 'message-read-receipt-afterReadMessages');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"afterSaveMessage.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/message-read-receipt/server/hooks/afterSaveMessage.ts                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let isEditedMessage;
    module.link("@rocket.chat/core-typings", {
      isEditedMessage(v) {
        isEditedMessage = v;
      }
    }, 0);
    let callbacks;
    module.link("../../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 1);
    let ReadReceipt;
    module.link("../../../../server/lib/message-read-receipt/ReadReceipt", {
      ReadReceipt(v) {
        ReadReceipt = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    callbacks.add('afterSaveMessage', async (message, _ref) => {
      let {
        room
      } = _ref;
      // skips this callback if the message was edited
      if (isEditedMessage(message)) {
        return message;
      }
      // mark message as read as well
      await ReadReceipt.markMessageAsReadBySender(message, room, message.u._id);
      return message;
    }, callbacks.priority.MEDIUM, 'message-read-receipt-afterSaveMessage');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/message-read-receipt/server/hooks/index.ts                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./afterReadMessages");
    module.link("./afterSaveMessage");
    module.link("./afterDeleteRoom");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/message-read-receipt/server/index.ts                                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    await License.onLicense('message-read-receipt', async () => {
      await module.dynamicImport('./hooks');
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"settings":{"server":{"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/settings/server/index.ts                                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./settings");
    module.link("./settings.internalService");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"settings.internalService.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/settings/server/settings.internalService.ts                                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      EnterpriseSettings: () => EnterpriseSettings
    });
    let ServiceClassInternal;
    module.link("@rocket.chat/core-services", {
      ServiceClassInternal(v) {
        ServiceClassInternal = v;
      }
    }, 0);
    let changeSettingValue;
    module.link("./settings", {
      changeSettingValue(v) {
        changeSettingValue = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class EnterpriseSettings extends ServiceClassInternal {
      constructor() {
        super(...arguments);
        this.name = 'ee-settings';
        this.internal = true;
      }
      changeSettingValue(record) {
        return changeSettingValue(record);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"settings.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/app/settings/server/settings.ts                                                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      changeSettingValue: () => changeSettingValue
    });
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let Settings;
    module.link("@rocket.chat/models", {
      Settings(v) {
        Settings = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    let settings, SettingsEvents;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      },
      SettingsEvents(v) {
        SettingsEvents = v;
      }
    }, 3);
    let use;
    module.link("../../../../app/settings/server/Middleware", {
      use(v) {
        use = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    function changeSettingValue(record) {
      var _record$modules;
      if (!record.enterprise) {
        return record.value;
      }
      if (!License.hasValidLicense()) {
        return record.invalidValue;
      }
      if (!((_record$modules = record.modules) !== null && _record$modules !== void 0 && _record$modules.length)) {
        return record.value;
      }
      for (const moduleName of record.modules) {
        if (!License.hasModule(moduleName)) {
          return record.invalidValue;
        }
      }
      return record.value;
    }
    settings.set = use(settings.set, (context, next) => {
      const [record] = context;
      if (!record.enterprise) {
        return next(...context);
      }
      const value = changeSettingValue(record);
      return next(_objectSpread(_objectSpread({}, record), {}, {
        value
      }));
    });
    SettingsEvents.on('fetch-settings', settings => {
      for (const setting of settings) {
        const changedValue = changeSettingValue(setting);
        if (changedValue === undefined) {
          continue;
        }
        setting.value = changedValue;
      }
    });
    async function updateSettings() {
      const enterpriseSettings = await Settings.findEnterpriseSettings();
      void enterpriseSettings.forEach(record => settings.set(record));
    }
    Meteor.startup(async () => {
      await updateSettings();
      License.onValidateLicense(updateSettings);
      License.onInvalidateLicense(updateSettings);
      License.onRemoveLicense(updateSettings);
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}}},"server":{"apps":{"communication":{"endpoints":{"lib":{"makeAppLogsQuery.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/endpoints/lib/makeAppLogsQuery.ts                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    module.export({
      makeAppLogsQuery: () => makeAppLogsQuery
    });
    function makeAppLogsQuery(queryParams) {
      const query = {};
      if (queryParams.appId) {
        query.appId = queryParams.appId;
      }
      if (queryParams.logLevel) {
        const queryLogLevel = Number(queryParams.logLevel);
        const logLevel = ['error'];
        if (queryLogLevel >= 1) {
          logLevel.push('warn', 'info', 'log');
        }
        if (queryLogLevel >= 2) {
          logLevel.push('debug', 'success');
        }
        query['entries.severity'] = {
          $in: logLevel
        };
      }
      if (queryParams.method) {
        query.method = queryParams.method;
      }
      if (queryParams.instanceId) {
        query.instanceId = queryParams.instanceId;
      }
      if (queryParams.startDate) {
        query._updatedAt = {
          $gte: new Date(queryParams.startDate)
        };
      }
      if (queryParams.endDate) {
        var _query$_updatedAt;
        const endDate = new Date(queryParams.endDate);
        if ((_query$_updatedAt = query._updatedAt) !== null && _query$_updatedAt !== void 0 && _query$_updatedAt.$gte && query._updatedAt.$gte >= endDate) {
          throw new Error('Invalid date range');
        }
        query._updatedAt = _objectSpread(_objectSpread({}, query._updatedAt || {}), {}, {
          $lte: endDate
        });
      }
      return query;
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"actionButtonsHandler.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/endpoints/actionButtonsHandler.ts                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      registerActionButtonsHandler: () => registerActionButtonsHandler
    });
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const registerActionButtonsHandler = _ref => {
      let {
        api,
        _manager
      } = _ref;
      return void api.addRoute('actionButtons', {
        authRequired: false
      }, {
        async get() {
          const buttons = await _manager.getUIActionButtonManager().getAllActionButtons();
          return API.v1.success(buttons);
        }
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"appGeneralLogsHandler.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/endpoints/appGeneralLogsHandler.ts                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      registerAppGeneralLogsHandler: () => registerAppGeneralLogsHandler
    });
    let isAppLogsProps;
    module.link("@rocket.chat/rest-typings", {
      isAppLogsProps(v) {
        isAppLogsProps = v;
      }
    }, 0);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 1);
    let makeAppLogsQuery;
    module.link("./lib/makeAppLogsQuery", {
      makeAppLogsQuery(v) {
        makeAppLogsQuery = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const registerAppGeneralLogsHandler = _ref => {
      let {
        api,
        _orch
      } = _ref;
      return void api.addRoute('logs', {
        authRequired: true,
        permissionRequired: ['manage-apps'],
        validateParams: isAppLogsProps
      }, {
        async get() {
          const {
            offset,
            count
          } = await getPaginationItems(this.queryParams);
          const {
            sort
          } = await this.parseJsonQuery();
          const options = {
            sort: sort || {
              _updatedAt: -1
            },
            skip: offset,
            limit: count
          };
          let query;
          try {
            query = makeAppLogsQuery(this.queryParams);
          } catch (error) {
            return api.failure({
              error: error instanceof Error ? error.message : 'Unknown error'
            });
          }
          const result = await _orch.getLogStorage().findPaginated(query, options);
          return api.success({
            offset,
            logs: result.logs,
            count: result.logs.length,
            total: result.total
          });
        }
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"appLogsDistinctInstanceHandler.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/endpoints/appLogsDistinctInstanceHandler.ts                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      registerAppLogsDistinctInstanceHandler: () => registerAppLogsDistinctInstanceHandler
    });
    let ajv;
    module.link("@rocket.chat/rest-typings", {
      ajv(v) {
        ajv = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    // This might be a good candidate for a default validator function exported by @rocket.chat/rest-typings
    const errorResponse = ajv.compile({
      additionalProperties: false,
      type: 'object',
      properties: {
        error: {
          type: 'string'
        },
        status: {
          type: 'string',
          nullable: true
        },
        message: {
          type: 'string',
          nullable: true
        },
        success: {
          type: 'boolean',
          description: 'Indicates if the request was successful.'
        }
      },
      required: ['success', 'error']
    });
    const registerAppLogsDistinctInstanceHandler = _ref => {
      let {
        api,
        _orch
      } = _ref;
      return void api.get(':id/logs/distinctValues', {
        authRequired: true,
        permissionsRequired: ['manage-apps'],
        response: {
          200: ajv.compile({
            type: 'object',
            properties: {
              instanceIds: {
                type: 'array',
                items: {
                  type: 'string'
                }
              },
              methods: {
                type: 'array',
                items: {
                  type: 'string'
                }
              },
              success: {
                type: 'boolean'
              }
            },
            required: ['instanceIds', 'methods', 'success'],
            additionalProperties: false
          }),
          401: errorResponse,
          403: errorResponse,
          404: errorResponse
        }
      }, async function action() {
        var _orch$getManager;
        const app = await ((_orch$getManager = _orch.getManager()) === null || _orch$getManager === void 0 ? void 0 : _orch$getManager.getOneById(this.urlParams.id));
        if (!app) {
          return api.notFound("No app found with id: ".concat(this.urlParams.id));
        }
        const result = await _orch.getLogStorage().distinctValues(this.urlParams.id);
        return api.success(result);
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"appLogsExportHandler.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/endpoints/appLogsExportHandler.ts                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      registerAppLogsExportHandler: () => registerAppLogsExportHandler
    });
    let isAppLogsExportProps;
    module.link("@rocket.chat/rest-typings", {
      isAppLogsExportProps(v) {
        isAppLogsExportProps = v;
      }
    }, 0);
    let ajv;
    module.link("@rocket.chat/rest-typings/src/v1/Ajv", {
      ajv(v) {
        ajv = v;
      }
    }, 1);
    let parse;
    module.link("cookie", {
      parse(v) {
        parse = v;
      }
    }, 2);
    let json2csv;
    module.link("json-2-csv", {
      json2csv(v) {
        json2csv = v;
      }
    }, 3);
    let makeAppLogsQuery;
    module.link("./lib/makeAppLogsQuery", {
      makeAppLogsQuery(v) {
        makeAppLogsQuery = v;
      }
    }, 4);
    let APIClass;
    module.link("../../../../../app/api/server/ApiClass", {
      APIClass(v) {
        APIClass = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const isErrorResponse = ajv.compile({
      type: 'object',
      properties: {
        success: {
          type: 'boolean',
          enum: [false]
        },
        error: {
          type: 'string'
        }
      }
    });
    class ExportHandlerAPI extends APIClass {
      async authenticatedRoute(req) {
        const {
          rc_uid,
          rc_token
        } = parse(req.headers.get('cookie') || '');
        if (rc_uid) {
          req.headers.set('x-user-id', rc_uid);
        }
        if (rc_token) {
          req.headers.set('x-auth-token', rc_token);
        }
        return super.authenticatedRoute(req);
      }
    }
    const adhocApi = new ExportHandlerAPI({
      useDefaultAuth: false,
      prettyJson: process.env.NODE_ENV !== 'development'
    });
    const registerAppLogsExportHandler = _ref => {
      let {
        api,
        _manager,
        _orch
      } = _ref;
      adhocApi.get(':id/export-logs', {
        authRequired: true,
        permissionsRequired: ['manage-apps'],
        query: isAppLogsExportProps,
        response: {
          200: ajv.compile({
            type: 'object',
            properties: {
              body: {
                type: 'string',
                format: 'binary',
                description: 'The content of the exported logs file, either in JSON or CSV format.'
              }
            }
          }),
          400: isErrorResponse,
          401: isErrorResponse,
          404: isErrorResponse
        }
      }, async function () {
        const proxiedApp = _manager.getOneById(this.urlParams.id);
        if (!proxiedApp) {
          return api.notFound("No App found by the id of: ".concat(this.urlParams.id));
        }
        let count = 100;
        if (this.queryParams.count !== undefined && this.queryParams.count !== null) {
          count = parseInt(String(this.queryParams.count || 100));
        }
        const {
          sort
        } = await this.parseJsonQuery();
        const options = {
          sort: sort || {
            _updatedAt: -1
          },
          skip: 0,
          limit: Math.min(count, 2000)
        };
        let query;
        try {
          query = makeAppLogsQuery(_objectSpread({
            appId: this.urlParams.id
          }, this.queryParams));
        } catch (error) {
          return api.failure({
            error: error instanceof Error ? error.message : 'Unknown error'
          });
        }
        const result = await _orch.getLogStorage().find(query, options);
        if (!result.length) {
          return api.failure({
            error: 'No logs found for the specified criteria'
          });
        }
        let fileContent;
        let filename;
        const timestamp = new Date().toISOString().replace(/[:.]/g, '-');
        if (this.queryParams.type === 'json') {
          fileContent = Buffer.from(JSON.stringify(result, null, 2), 'utf8');
          filename = "app-logs-".concat(this.urlParams.id, "-").concat(timestamp, ".json");
        } else {
          fileContent = Buffer.from(json2csv(result, {
            expandArrayObjects: true
          }), 'utf8');
          filename = "app-logs-".concat(this.urlParams.id, "-").concat(timestamp, ".csv");
        }
        return {
          body: fileContent,
          statusCode: 200,
          headers: {
            // 'application/json' here creates problems down the line with the router
            'Content-Type': 'text/plain',
            'Content-Disposition': "attachment; filename=\"".concat(filename, "\""),
            'Content-Length': fileContent.length.toString()
          }
        };
      });
      api.router.use(adhocApi.router);
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"appLogsHandler.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/endpoints/appLogsHandler.ts                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      registerAppLogsHandler: () => registerAppLogsHandler
    });
    let isAppLogsProps;
    module.link("@rocket.chat/rest-typings", {
      isAppLogsProps(v) {
        isAppLogsProps = v;
      }
    }, 0);
    let getPaginationItems;
    module.link("../../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 1);
    let makeAppLogsQuery;
    module.link("./lib/makeAppLogsQuery", {
      makeAppLogsQuery(v) {
        makeAppLogsQuery = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const registerAppLogsHandler = _ref => {
      let {
        api,
        _manager,
        _orch
      } = _ref;
      return void api.addRoute(':id/logs', {
        authRequired: true,
        permissionRequired: ['manage-apps'],
        validateParams: isAppLogsProps
      }, {
        async get() {
          const proxiedApp = _manager.getOneById(this.urlParams.id);
          if (!proxiedApp) {
            return api.notFound("No App found by the id of: ".concat(this.urlParams.id));
          }
          if (this.queryParams.appId && this.queryParams.appId !== this.urlParams.id) {
            return api.notFound("Invalid query parameter \"appId\": ".concat(this.queryParams.appId));
          }
          const {
            offset,
            count
          } = await getPaginationItems(this.queryParams);
          const {
            sort
          } = await this.parseJsonQuery();
          const options = {
            sort: sort || {
              _updatedAt: -1
            },
            skip: offset,
            limit: count
          };
          let query;
          try {
            query = makeAppLogsQuery(_objectSpread({
              appId: this.urlParams.id
            }, this.queryParams));
          } catch (error) {
            return api.failure({
              error: error instanceof Error ? error.message : 'Unknown error'
            });
          }
          const result = await _orch.getLogStorage().findPaginated(query, options);
          return api.success({
            offset,
            logs: result.logs,
            count: result.logs.length,
            total: result.total
          });
        }
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"appsCountHandler.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/endpoints/appsCountHandler.ts                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      registerAppsCountHandler: () => registerAppsCountHandler
    });
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let API;
    module.link("../../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    let getInstallationSourceFromAppStorageItem;
    module.link("../../../../../lib/apps/getInstallationSourceFromAppStorageItem", {
      getInstallationSourceFromAppStorageItem(v) {
        getInstallationSourceFromAppStorageItem = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const registerAppsCountHandler = _ref => {
      let {
        api,
        _manager
      } = _ref;
      return void api.addRoute('count', {
        authRequired: false
      }, {
        async get() {
          const manager = _manager;
          const apps = await manager.get({
            enabled: true
          });
          const {
            maxMarketplaceApps,
            maxPrivateApps
          } = License.getAppsConfig();
          return API.v1.success({
            totalMarketplaceEnabled: apps.filter(app => getInstallationSourceFromAppStorageItem(app.getStorageItem()) === 'marketplace').length,
            totalPrivateEnabled: apps.filter(app => getInstallationSourceFromAppStorageItem(app.getStorageItem()) === 'private').length,
            maxMarketplaceApps,
            maxPrivateApps
          });
        }
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"events.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/events.ts                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.export({
  AppEvents: () => AppEvents
});
var AppEvents;
(function (AppEvents) {
  AppEvents["APP_ADDED"] = "app/added";
  AppEvents["APP_REMOVED"] = "app/removed";
  AppEvents["APP_UPDATED"] = "app/updated";
  AppEvents["APP_STATUS_CHANGE"] = "app/statusUpdate";
  AppEvents["APP_SETTING_UPDATED"] = "app/settingUpdated";
  AppEvents["COMMAND_ADDED"] = "command/added";
  AppEvents["COMMAND_DISABLED"] = "command/disabled";
  AppEvents["COMMAND_UPDATED"] = "command/updated";
  AppEvents["COMMAND_REMOVED"] = "command/removed";
  AppEvents["ACTIONS_CHANGED"] = "actions/changed";
})(AppEvents || module.runSetters(AppEvents = {}, ["AppEvents"]));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/index.ts                                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      AppUIKitInteractionApi: () => AppUIKitInteractionApi,
      AppsRestApi: () => AppsRestApi,
      AppServerNotifier: () => AppServerNotifier
    });
    let AppsRestApi;
    module.link("./rest", {
      AppsRestApi(v) {
        AppsRestApi = v;
      }
    }, 0);
    let AppUIKitInteractionApi;
    module.link("./uikit", {
      AppUIKitInteractionApi(v) {
        AppUIKitInteractionApi = v;
      }
    }, 1);
    let AppServerNotifier;
    module.link("./websockets", {
      AppServerNotifier(v) {
        AppServerNotifier = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"rest.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/rest.ts                                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 1);
    module.export({
      AppsRestApi: () => AppsRestApi
    });
    let AppStatus, AppStatusUtils;
    module.link("@rocket.chat/apps-engine/definition/AppStatus", {
      AppStatus(v) {
        AppStatus = v;
      },
      AppStatusUtils(v) {
        AppStatusUtils = v;
      }
    }, 0);
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 1);
    let Logger;
    module.link("@rocket.chat/logger", {
      Logger(v) {
        Logger = v;
      }
    }, 2);
    let Settings, Users;
    module.link("@rocket.chat/models", {
      Settings(v) {
        Settings = v;
      },
      Users(v) {
        Users = v;
      }
    }, 3);
    let fetch;
    module.link("@rocket.chat/server-fetch", {
      serverFetch(v) {
        fetch = v;
      }
    }, 4);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 5);
    let ZodError;
    module.link("zod", {
      ZodError(v) {
        ZodError = v;
      }
    }, 6);
    let registerActionButtonsHandler;
    module.link("./endpoints/actionButtonsHandler", {
      registerActionButtonsHandler(v) {
        registerActionButtonsHandler = v;
      }
    }, 7);
    let registerAppGeneralLogsHandler;
    module.link("./endpoints/appGeneralLogsHandler", {
      registerAppGeneralLogsHandler(v) {
        registerAppGeneralLogsHandler = v;
      }
    }, 8);
    let registerAppLogsDistinctInstanceHandler;
    module.link("./endpoints/appLogsDistinctInstanceHandler", {
      registerAppLogsDistinctInstanceHandler(v) {
        registerAppLogsDistinctInstanceHandler = v;
      }
    }, 9);
    let registerAppLogsExportHandler;
    module.link("./endpoints/appLogsExportHandler", {
      registerAppLogsExportHandler(v) {
        registerAppLogsExportHandler = v;
      }
    }, 10);
    let registerAppLogsHandler;
    module.link("./endpoints/appLogsHandler", {
      registerAppLogsHandler(v) {
        registerAppLogsHandler = v;
      }
    }, 11);
    let registerAppsCountHandler;
    module.link("./endpoints/appsCountHandler", {
      registerAppsCountHandler(v) {
        registerAppsCountHandler = v;
      }
    }, 12);
    let API;
    module.link("../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 13);
    let getUploadFormData;
    module.link("../../../../app/api/server/lib/getUploadFormData", {
      getUploadFormData(v) {
        getUploadFormData = v;
      }
    }, 14);
    let loggerMiddleware;
    module.link("../../../../app/api/server/middlewares/logger", {
      loggerMiddleware(v) {
        loggerMiddleware = v;
      }
    }, 15);
    let metricsMiddleware;
    module.link("../../../../app/api/server/middlewares/metrics", {
      metricsMiddleware(v) {
        metricsMiddleware = v;
      }
    }, 16);
    let tracerSpanMiddleware;
    module.link("../../../../app/api/server/middlewares/tracer", {
      tracerSpanMiddleware(v) {
        tracerSpanMiddleware = v;
      }
    }, 17);
    let getWorkspaceAccessToken, getWorkspaceAccessTokenWithScope;
    module.link("../../../../app/cloud/server", {
      getWorkspaceAccessToken(v) {
        getWorkspaceAccessToken = v;
      },
      getWorkspaceAccessTokenWithScope(v) {
        getWorkspaceAccessTokenWithScope = v;
      }
    }, 18);
    let apiDeprecationLogger;
    module.link("../../../../app/lib/server/lib/deprecationWarningLogger", {
      apiDeprecationLogger(v) {
        apiDeprecationLogger = v;
      }
    }, 19);
    let metrics;
    module.link("../../../../app/metrics/server", {
      metrics(v) {
        metrics = v;
      }
    }, 20);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 21);
    let Info;
    module.link("../../../../app/utils/rocketchat.info", {
      Info(v) {
        Info = v;
      }
    }, 22);
    let i18n;
    module.link("../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 23);
    let sendMessagesToAdmins;
    module.link("../../../../server/lib/sendMessagesToAdmins", {
      sendMessagesToAdmins(v) {
        sendMessagesToAdmins = v;
      }
    }, 24);
    let AppsEngineNoNodesFoundError;
    module.link("../../../../server/services/apps-engine/service", {
      AppsEngineNoNodesFoundError(v) {
        AppsEngineNoNodesFoundError = v;
      }
    }, 25);
    let canEnableApp;
    module.link("../../../app/license/server/canEnableApp", {
      canEnableApp(v) {
        canEnableApp = v;
      }
    }, 26);
    let fetchAppsStatusFromCluster;
    module.link("../../../lib/misc/fetchAppsStatusFromCluster", {
      fetchAppsStatusFromCluster(v) {
        fetchAppsStatusFromCluster = v;
      }
    }, 27);
    let formatAppInstanceForRest;
    module.link("../../../lib/misc/formatAppInstanceForRest", {
      formatAppInstanceForRest(v) {
        formatAppInstanceForRest = v;
      }
    }, 28);
    let notifyMarketplace;
    module.link("../marketplace/appInstall", {
      notifyMarketplace(v) {
        notifyMarketplace = v;
      }
    }, 29);
    let fetchMarketplaceApps;
    module.link("../marketplace/fetchMarketplaceApps", {
      fetchMarketplaceApps(v) {
        fetchMarketplaceApps = v;
      }
    }, 30);
    let fetchMarketplaceCategories;
    module.link("../marketplace/fetchMarketplaceCategories", {
      fetchMarketplaceCategories(v) {
        fetchMarketplaceCategories = v;
      }
    }, 31);
    let MarketplaceAppsError, MarketplaceConnectionError, MarketplaceUnsupportedVersionError;
    module.link("../marketplace/marketplaceErrors", {
      MarketplaceAppsError(v) {
        MarketplaceAppsError = v;
      },
      MarketplaceConnectionError(v) {
        MarketplaceConnectionError = v;
      },
      MarketplaceUnsupportedVersionError(v) {
        MarketplaceUnsupportedVersionError = v;
      }
    }, 32);
    let Apps;
    module.link("../orchestrator", {
      Apps(v) {
        Apps = v;
      }
    }, 33);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const rocketChatVersion = Info.version;
    const appsEngineVersionForMarketplace = Info.marketplaceApiVersion.replace(/-.*/g, '');
    const getDefaultHeaders = () => ({
      'X-Apps-Engine-Version': appsEngineVersionForMarketplace
    });
    const purchaseTypes = new Set(['buy', 'subscription']);
    class AppsRestApi {
      constructor(orch, manager) {
        this.api = void 0;
        this._orch = void 0;
        this._manager = void 0;
        this._orch = orch;
        this._manager = manager;
        void this.loadAPI();
      }
      async loadAPI() {
        this.api = new API.ApiClass({
          apiPath: '',
          useDefaultAuth: true,
          prettyJson: false,
          enableCors: false,
          version: 'apps'
        });
        const logger = new Logger('APPS');
        this.api.router.use(loggerMiddleware(logger)).use(metricsMiddleware({
          basePathRegex: new RegExp(/^\/api\/apps\//),
          api: this.api,
          settings,
          summary: metrics.rocketchatRestApi
        })).use(tracerSpanMiddleware);
        this.addManagementRoutes();
        // Using the same instance of the existing API for now, to be able to use the same api prefix(/api)
        API.api.use(this.api.router);
      }
      addManagementRoutes() {
        const orchestrator = this._orch;
        const manager = this._manager;
        const handleError = (message, e) => {
          // when there is no `response` field in the error, it means the request
          // couldn't even make it to the server
          if (!e.hasOwnProperty('response')) {
            orchestrator.getRocketChatLogger().warn(message, e.message);
            return API.v1.internalError('Could not reach the Marketplace');
          }
          orchestrator.getRocketChatLogger().error(message, e.response.data);
          if (e.response.statusCode >= 500 && e.response.statusCode <= 599) {
            return API.v1.internalError();
          }
          if (e.response.statusCode === 404) {
            return API.v1.notFound();
          }
          return API.v1.failure();
        };
        registerActionButtonsHandler(this);
        registerAppsCountHandler(this);
        registerAppLogsDistinctInstanceHandler(this);
        registerAppLogsHandler(this);
        registerAppLogsExportHandler(this);
        registerAppGeneralLogsHandler(this);
        this.api.addRoute('incompatibleModal', {
          authRequired: true
        }, {
          async get() {
            const baseUrl = orchestrator.getMarketplaceClient().getMarketplaceUrl();
            const workspaceId = settings.get('Cloud_Workspace_Id');
            const {
              action,
              appId,
              appVersion
            } = this.queryParams;
            return API.v1.success({
              url: "".concat(baseUrl, "/apps/").concat(appId, "/incompatible/").concat(appVersion, "/").concat(action, "?workspaceId=").concat(workspaceId, "&rocketChatVersion=").concat(rocketChatVersion)
            });
          }
        });
        this.api.addRoute('marketplace', {
          authRequired: true
        }, {
          async get() {
            try {
              const apps = await fetchMarketplaceApps(_objectSpread({}, this.queryParams.isAdminUser === 'false' && {
                endUserID: this.user._id
              }));
              return API.v1.success(apps);
            } catch (err) {
              if (err instanceof MarketplaceConnectionError) {
                return handleError('Unable to access Marketplace. Does the server has access to the internet?', err);
              }
              if (err instanceof MarketplaceAppsError || err instanceof MarketplaceUnsupportedVersionError) {
                return API.v1.failure({
                  error: err.message
                });
              }
              if (err instanceof ZodError) {
                orchestrator.getRocketChatLogger().error('Error parsing the Marketplace Apps:', err.issues);
                return API.v1.failure({
                  error: i18n.t('Marketplace_Failed_To_Fetch_Apps')
                });
              }
              return API.v1.internalError();
            }
          }
        });
        this.api.addRoute('categories', {
          authRequired: true
        }, {
          async get() {
            try {
              const categories = await fetchMarketplaceCategories();
              return API.v1.success(categories);
            } catch (err) {
              orchestrator.getRocketChatLogger().error('Error getting the categories from the Marketplace:', err);
              if (err instanceof MarketplaceConnectionError) {
                return handleError('Unable to access Marketplace. Does the server has access to the internet?', err);
              }
              if (err instanceof MarketplaceAppsError || err instanceof MarketplaceUnsupportedVersionError) {
                return API.v1.failure({
                  error: err.message
                });
              }
              if (err instanceof ZodError) {
                orchestrator.getRocketChatLogger().error('Error validating the response from the Marketplace:', err.issues);
                return API.v1.failure({
                  error: i18n.t('Marketplace_Failed_To_Fetch_Categories')
                });
              }
              return API.v1.internalError();
            }
          }
        });
        this.api.addRoute('buildExternalUrl', {
          authRequired: true
        }, {
          async get() {
            const baseUrl = orchestrator.getMarketplaceClient().getMarketplaceUrl();
            const workspaceId = settings.get('Cloud_Workspace_Id');
            if (!this.queryParams.purchaseType || !purchaseTypes.has(this.queryParams.purchaseType)) {
              return API.v1.failure({
                error: 'Invalid purchase type'
              });
            }
            const response = await getWorkspaceAccessTokenWithScope({
              scope: 'marketplace:purchase'
            });
            if (!response.token) {
              return API.v1.failure({
                error: 'Unauthorized'
              });
            }
            const subscribeRoute = this.queryParams.details === 'true' ? 'subscribe/details' : 'subscribe';
            const seats = await Users.getActiveLocalUserCount();
            return API.v1.success({
              url: "".concat(baseUrl, "/apps/").concat(this.queryParams.appId, "/").concat(this.queryParams.purchaseType === 'buy' ? this.queryParams.purchaseType : subscribeRoute, "?workspaceId=").concat(workspaceId, "&token=").concat(response.token, "&seats=").concat(seats)
            });
          }
        });
        this.api.addRoute('installed', {
          authRequired: true
        }, {
          async get() {
            const apps = await manager.get();
            let clusterStatus;
            if (this.queryParams.includeClusterStatus === 'true') {
              try {
                clusterStatus = await fetchAppsStatusFromCluster();
              } catch (error) {
                if (!(error instanceof AppsEngineNoNodesFoundError)) {
                  throw error;
                }
                orchestrator.getRocketChatLogger().debug('Request to /apps/installed with includeClusterStatus=true, but no cluster nodes found');
              }
            }
            const formatted = await Promise.all(apps.map(app => formatAppInstanceForRest(app, clusterStatus)));
            return API.v1.success({
              apps: formatted
            });
          }
        });
        // WE NEED TO MOVE EACH ENDPOINT HANDLER TO IT'S OWN FILE
        this.api.addRoute('', {
          authRequired: true,
          permissionsRequired: ['manage-apps']
        }, {
          async get() {
            // Gets the Apps from the marketplace
            if ('marketplace' in this.queryParams && this.queryParams.marketplace) {
              apiDeprecationLogger.endpoint(this.route, '7.0.0', this.response, 'Use /apps/marketplace to get the apps list.');
              try {
                const apps = await fetchMarketplaceApps();
                return API.v1.success(apps);
              } catch (e) {
                if (e instanceof MarketplaceConnectionError) {
                  return handleError('Unable to access Marketplace. Does the server has access to the internet?', e);
                }
                if (e instanceof MarketplaceAppsError || e instanceof MarketplaceUnsupportedVersionError) {
                  return API.v1.failure({
                    error: e.message
                  });
                }
                if (e instanceof ZodError) {
                  orchestrator.getRocketChatLogger().error('Error parsing the Marketplace Apps:', e.issues);
                  return API.v1.failure({
                    error: i18n.t('Marketplace_Failed_To_Fetch_Apps')
                  });
                }
                return API.v1.internalError();
              }
            }
            if ('categories' in this.queryParams && this.queryParams.categories) {
              apiDeprecationLogger.endpoint(this.route, '7.0.0', this.response, 'Use /apps/categories to get the categories list.');
              try {
                const categories = await fetchMarketplaceCategories();
                return API.v1.success(categories);
              } catch (err) {
                orchestrator.getRocketChatLogger().error('Error getting the categories from the Marketplace:', err);
                if (err instanceof MarketplaceConnectionError) {
                  return handleError('Unable to access Marketplace. Does the server has access to the internet?', err);
                }
                if (err instanceof MarketplaceAppsError || err instanceof MarketplaceUnsupportedVersionError) {
                  return API.v1.failure({
                    error: err.message
                  });
                }
                if (err instanceof ZodError) {
                  orchestrator.getRocketChatLogger().error('Error validating the response from the Marketplace:', err.issues);
                  return API.v1.failure({
                    error: i18n.t('Marketplace_Failed_To_Fetch_Categories')
                  });
                }
                return API.v1.internalError();
              }
            }
            if ('buildExternalUrl' in this.queryParams && 'appId' in this.queryParams && this.queryParams.buildExternalUrl && this.queryParams.appId) {
              apiDeprecationLogger.endpoint(this.route, '7.0.0', this.response, 'Use /apps/buildExternalUrl to get the modal URLs.');
              const workspaceId = settings.get('Cloud_Workspace_Id');
              if (!this.queryParams.purchaseType || !purchaseTypes.has(this.queryParams.purchaseType)) {
                return API.v1.failure({
                  error: 'Invalid purchase type'
                });
              }
              const token = await getWorkspaceAccessTokenWithScope({
                scope: 'marketplace:purchase'
              });
              if (!token) {
                return API.v1.failure({
                  error: 'Unauthorized'
                });
              }
              const subscribeRoute = this.queryParams.details === 'true' ? 'subscribe/details' : 'subscribe';
              const seats = await Users.getActiveLocalUserCount();
              const baseUrl = orchestrator.getMarketplaceClient().getMarketplaceUrl();
              return API.v1.success({
                url: "".concat(baseUrl, "/apps/").concat(this.queryParams.appId, "/").concat(this.queryParams.purchaseType === 'buy' ? this.queryParams.purchaseType : subscribeRoute, "?workspaceId=").concat(workspaceId, "&token=").concat(token.token, "&seats=").concat(seats)
              });
            }
            apiDeprecationLogger.endpoint(this.route, '7.0.0', this.response, 'Use /apps/installed to get the installed apps list.');
            const proxiedApps = await manager.get();
            const apps = await Promise.all(proxiedApps.map(app => formatAppInstanceForRest(app)));
            return API.v1.success({
              apps
            });
          },
          async post() {
            var _orchestrator$getConv, _orchestrator$getConv2;
            let buff;
            let marketplaceInfo;
            let permissionsGranted;
            if (this.bodyParams.url) {
              try {
                const response = await fetch(this.bodyParams.url);
                if (response.status !== 200 || response.headers.get('content-type') !== 'application/zip') {
                  return API.v1.failure({
                    error: 'Invalid url. It doesn\'t exist or is not "application/zip".'
                  });
                }
                buff = await response.buffer();
              } catch (e) {
                orchestrator.getRocketChatLogger().error('Error getting the app from url:', e.response.data);
                return API.v1.internalError();
              }
            } else if ('appId' in this.bodyParams && this.bodyParams.appId && this.bodyParams.marketplace && this.bodyParams.version) {
              const headers = getDefaultHeaders();
              try {
                var _marketplaceInfo;
                const downloadToken = await getWorkspaceAccessToken(true, 'marketplace:download', false);
                const marketplaceToken = await getWorkspaceAccessToken();
                const [downloadResponse, marketplaceResponse] = await Promise.all([Apps.getMarketplaceClient().fetch("v2/apps/".concat(this.bodyParams.appId, "/download/").concat(this.bodyParams.version, "?token=").concat(downloadToken), {
                  headers
                }).catch(cause => {
                  throw new Error('App package download failed', {
                    cause
                  });
                }), Apps.getMarketplaceClient().fetch("v1/apps/".concat(this.bodyParams.appId, "?appVersion=").concat(this.bodyParams.version), {
                  headers: _objectSpread({
                    Authorization: "Bearer ".concat(marketplaceToken)
                  }, headers)
                }).catch(cause => {
                  throw new Error('App metadata download failed', {
                    cause
                  });
                })]);
                if (downloadResponse.headers.get('content-type') !== 'application/zip') {
                  throw new Error('Invalid url. It doesn\'t exist or is not "application/zip".');
                }
                buff = Buffer.from(await downloadResponse.arrayBuffer());
                marketplaceInfo = await marketplaceResponse.json();
                // Note: marketplace responds with an array of the marketplace info on the app, but it is expected
                // to always have one element since we are fetching a specific app version.
                if (!Array.isArray(marketplaceInfo) || ((_marketplaceInfo = marketplaceInfo) === null || _marketplaceInfo === void 0 ? void 0 : _marketplaceInfo.length) !== 1) {
                  orchestrator.getRocketChatLogger().error('Error getting the App information from the Marketplace:', marketplaceInfo);
                  throw new Error('Invalid response from the Marketplace');
                }
                permissionsGranted = this.bodyParams.permissionsGranted;
              } catch (err) {
                let message;
                if (err instanceof Error) {
                  orchestrator.getRocketChatLogger().error('Error installing app from marketplace: ', err.message, err.cause);
                  message = err.message;
                } else {
                  message = err;
                }
                return API.v1.failure({
                  error: message
                });
              }
            } else {
              const app = await getUploadFormData({
                request: this.request
              }, {
                field: 'app',
                sizeLimit: settings.get('FileUpload_MaxFileSize')
              });
              const {
                fields: formData
              } = app;
              buff = app.fileBuffer;
              permissionsGranted = (() => {
                try {
                  const permissions = JSON.parse((formData === null || formData === void 0 ? void 0 : formData.permissions) || '');
                  return permissions.length ? permissions : undefined;
                } catch (_unused) {
                  return undefined;
                }
              })();
            }
            if (!buff) {
              return API.v1.failure({
                error: 'app_file_error',
                message: 'Failed to get a file to install for the App. '
              });
            }
            // Used mostly in Cloud hosting for security reasons
            if (!marketplaceInfo && orchestrator.shouldDisablePrivateAppInstallation()) {
              return API.v1.internalError('private_app_install_disabled');
            }
            const user = orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$getConv = orchestrator.getConverters()) === null || _orchestrator$getConv === void 0 ? void 0 : (_orchestrator$getConv2 = _orchestrator$getConv.get('users')) === null || _orchestrator$getConv2 === void 0 ? void 0 : _orchestrator$getConv2.convertToApp(await Meteor.userAsync());
            const aff = await manager.add(buff, _objectSpread(_objectSpread({}, marketplaceInfo && {
              marketplaceInfo
            }), {}, {
              permissionsGranted,
              enable: false,
              user
            }));
            const info = aff.getAppInfo();
            if (aff.hasStorageError()) {
              return API.v1.failure({
                error: 'app_storage_error',
                status: 'storage_error',
                messages: [aff.getStorageError()]
              });
            }
            if (aff.hasAppUserError()) {
              return API.v1.failure({
                error: 'app_user_error',
                status: 'app_user_error',
                messages: [aff.getAppUserError().message],
                payload: {
                  username: aff.getAppUserError().username
                }
              });
            }
            info.status = await aff.getApp().getStatus();
            void notifyMarketplace('install', info);
            try {
              await canEnableApp(aff.getApp().getStorageItem());
              const success = await manager.changeStatus(info.id, AppStatus.MANUALLY_ENABLED);
              info.status = await success.getStatus();
            } catch (error) {
              orchestrator.getRocketChatLogger().warn("App \"".concat(info.id, "\" was installed but could not be enabled: "), error);
            }
            void orchestrator.getNotifier().appAdded(info.id);
            return API.v1.success({
              app: info,
              implemented: aff.getImplementedInferfaces(),
              licenseValidation: aff.getLicenseValidationResult()
            });
          }
        });
        this.api.addRoute('buildExternalAppRequest', {
          authRequired: true
        }, {
          async get() {
            var _this$user, _this$user$emails;
            if (!this.queryParams.appId) {
              return API.v1.failure({
                error: 'Invalid request. Please ensure an appId is attached to the request.'
              });
            }
            const baseUrl = orchestrator.getMarketplaceClient().getMarketplaceUrl();
            const workspaceId = settings.get('Cloud_Workspace_Id');
            const requester = {
              id: this.user._id,
              username: this.user.username,
              name: this.user.name,
              nickname: this.user.nickname,
              emails: (_this$user = this.user) === null || _this$user === void 0 ? void 0 : (_this$user$emails = _this$user.emails) === null || _this$user$emails === void 0 ? void 0 : _this$user$emails.map(e => e.address)
            };
            let admins = [];
            try {
              const adminsRaw = await Users.findUsersInRoles(['admin'], undefined, {
                projection: {
                  _id: 1,
                  username: 1,
                  name: 1,
                  nickname: 1
                }
              }).toArray();
              admins = adminsRaw.map(a => {
                return {
                  id: a._id,
                  username: a.username,
                  name: a.name,
                  nickname: a.nickname
                };
              });
            } catch (e) {
              orchestrator.getRocketChatLogger().error('Error getting the admins to request an app be installed:', e);
            }
            const queryParams = new URLSearchParams();
            queryParams.set('workspaceId', workspaceId);
            queryParams.set('frameworkVersion', appsEngineVersionForMarketplace);
            queryParams.set('requester', Buffer.from(JSON.stringify(requester)).toString('base64'));
            queryParams.set('admins', Buffer.from(JSON.stringify(admins)).toString('base64'));
            return API.v1.success({
              url: "".concat(baseUrl, "/apps/").concat(this.queryParams.appId, "/requestAccess?").concat(queryParams.toString())
            });
          }
        });
        this.api.addRoute('externalComponents', {
          authRequired: false
        }, {
          get() {
            const externalComponents = orchestrator.getProvidedComponents();
            return API.v1.success({
              externalComponents
            });
          }
        });
        this.api.addRoute('languages', {
          authRequired: false
        }, {
          async get() {
            const apps = (await manager.get()).map(prl => ({
              id: prl.getID(),
              languages: prl.getStorageItem().languageContent
            }));
            return API.v1.success({
              apps
            });
          }
        });
        this.api.addRoute('externalComponentEvent', {
          authRequired: true
        }, {
          post() {
            if (!this.bodyParams.externalComponent || !this.bodyParams.event || !['IPostExternalComponentOpened', 'IPostExternalComponentClosed'].includes(this.bodyParams.event)) {
              return API.v1.failure({
                error: 'Event and externalComponent must be provided.'
              });
            }
            try {
              var _Apps$getBridges;
              const {
                event,
                externalComponent
              } = this.bodyParams;
              const result = ((_Apps$getBridges = Apps.getBridges()) === null || _Apps$getBridges === void 0 ? void 0 : _Apps$getBridges.getListenerBridge()).externalComponentEvent(event, externalComponent);
              return API.v1.success({
                result
              });
            } catch (e) {
              orchestrator.getRocketChatLogger().error("Error triggering external components' events ".concat(e.response.data));
              return API.v1.internalError();
            }
          }
        });
        this.api.addRoute('bundles/:id/apps', {
          authRequired: true,
          permissionsRequired: ['manage-apps']
        }, {
          async get() {
            const headers = {};
            const token = await getWorkspaceAccessToken();
            if (token) {
              headers.Authorization = "Bearer ".concat(token);
            }
            let result;
            try {
              const request = await orchestrator.getMarketplaceClient().fetch("v1/bundles/".concat(this.urlParams.id, "/apps"), {
                headers
              });
              if (request.status !== 200) {
                orchestrator.getRocketChatLogger().error("Error getting the Bundle's Apps from the Marketplace:", await request.json());
                return API.v1.failure();
              }
              result = await request.json();
            } catch (e) {
              orchestrator.getRocketChatLogger().error("Error getting the Bundle's Apps from the Marketplace:", e.response.data);
              return API.v1.internalError();
            }
            return API.v1.success({
              apps: result
            });
          }
        });
        this.api.addRoute('featured-apps', {
          authRequired: true
        }, {
          async get() {
            const headers = getDefaultHeaders();
            const token = await getWorkspaceAccessToken();
            if (token) {
              headers.Authorization = "Bearer ".concat(token);
            }
            let result;
            try {
              const request = await orchestrator.getMarketplaceClient().fetch("v1/featured-apps", {
                headers
              });
              if (request.status !== 200) {
                orchestrator.getRocketChatLogger().error('Error getting the Featured Apps from the Marketplace:', await request.json());
                return API.v1.failure();
              }
              result = await request.json();
            } catch (e) {
              return handleError('Unable to access Marketplace. Does the server has access to the internet?', e);
            }
            return API.v1.success(result);
          }
        });
        this.api.addRoute('app-request', {
          authRequired: true
        }, {
          async get() {
            const {
              appId,
              q = '',
              sort = '',
              limit = 25,
              offset = 0
            } = this.queryParams;
            const headers = getDefaultHeaders();
            const token = await getWorkspaceAccessToken();
            if (token) {
              headers.Authorization = "Bearer ".concat(token);
            }
            try {
              const request = await orchestrator.getMarketplaceClient().fetch("v1/app-request?appId=".concat(appId, "&q=").concat(q, "&sort=").concat(sort, "&limit=").concat(limit, "&offset=").concat(offset), {
                headers
              });
              const result = await request.json();
              if (!request.ok) {
                throw new Error(result.error);
              }
              return API.v1.success(result);
            } catch (e) {
              orchestrator.getRocketChatLogger().error('Error getting all non sent app requests from the Marketplace:', e.message);
              return API.v1.failure(e.message);
            }
          }
        });
        this.api.addRoute('app-request/stats', {
          authRequired: true
        }, {
          async get() {
            const headers = getDefaultHeaders();
            const token = await getWorkspaceAccessToken();
            if (token) {
              headers.Authorization = "Bearer ".concat(token);
            }
            try {
              const request = await orchestrator.getMarketplaceClient().fetch("v1/app-request/stats", {
                headers
              });
              const result = await request.json();
              if (!request.ok) {
                throw new Error(result.error);
              }
              return API.v1.success(result);
            } catch (e) {
              orchestrator.getRocketChatLogger().error('Error getting the app requests stats from marketplace', e.message);
              return API.v1.failure(e.message);
            }
          }
        });
        this.api.addRoute('app-request/markAsSeen', {
          authRequired: true
        }, {
          async post() {
            const headers = getDefaultHeaders();
            const token = await getWorkspaceAccessToken();
            if (token) {
              headers.Authorization = "Bearer ".concat(token);
            }
            const {
              unseenRequests
            } = this.bodyParams;
            try {
              const request = await orchestrator.getMarketplaceClient().fetch("v1/app-request/markAsSeen", {
                method: 'POST',
                headers,
                body: {
                  ids: unseenRequests
                }
              });
              const result = await request.json();
              if (!request.ok) {
                throw new Error(result.error);
              }
              return API.v1.success(result);
            } catch (e) {
              orchestrator.getRocketChatLogger().error('Error marking app requests as seen', e.message);
              return API.v1.failure(e.message);
            }
          }
        });
        this.api.addRoute('notify-admins', {
          authRequired: true
        }, {
          async post() {
            const {
              appId,
              appName,
              appVersion,
              message
            } = this.bodyParams;
            const workspaceUrl = settings.get('Site_Url');
            const regex = new RegExp('\\/$', 'gm');
            const safeWorkspaceUrl = workspaceUrl.replace(regex, '');
            const learnMore = "".concat(safeWorkspaceUrl, "/marketplace/explore/info/").concat(appId, "/").concat(appVersion, "/requests");
            try {
              const msgs = async _ref => {
                let {
                  adminUser
                } = _ref;
                return {
                  msg: i18n.t('App_Request_Admin_Message', {
                    admin_name: adminUser.name || '',
                    app_name: appName || '',
                    user_name: "@".concat(this.user.username),
                    message: message || '',
                    learn_more: learnMore,
                    interpolation: {
                      escapeValue: false
                    }
                  })
                };
              };
              await sendMessagesToAdmins({
                msgs
              });
              return API.v1.success();
            } catch (e) {
              orchestrator.getRocketChatLogger().error('Error when notifying admins that an user requested an app:', e);
              return API.v1.failure();
            }
          }
        });
        this.api.addRoute(':id', {
          authRequired: true,
          permissionsRequired: ['manage-apps']
        }, {
          async get() {
            if (this.queryParams.marketplace && this.queryParams.version) {
              const headers = {}; // DO NOT ATTACH THE FRAMEWORK/ENGINE VERSION HERE.
              const token = await getWorkspaceAccessToken();
              if (token) {
                headers.Authorization = "Bearer ".concat(token);
              }
              let result;
              try {
                const request = await orchestrator.getMarketplaceClient().fetch("v1/apps/".concat(this.urlParams.id, "?appVersion=").concat(this.queryParams.version), {
                  headers
                });
                if (request.status !== 200) {
                  orchestrator.getRocketChatLogger().error('Error getting the App information from the Marketplace:', await request.json());
                  return API.v1.failure();
                }
                result = await request.json();
              } catch (e) {
                return handleError('Unable to access Marketplace. Does the server has access to the internet?', e);
              }
              return API.v1.success({
                app: result[0]
              });
            }
            if (this.queryParams.marketplace && this.queryParams.update && this.queryParams.appVersion) {
              const headers = getDefaultHeaders();
              const token = await getWorkspaceAccessToken();
              if (token) {
                headers.Authorization = "Bearer ".concat(token);
              }
              let result;
              try {
                const request = await orchestrator.getMarketplaceClient().fetch("v1/apps/".concat(this.urlParams.id, "/latest?appVersion=").concat(this.queryParams.appVersion), {
                  headers
                });
                if (request.status !== 200) {
                  orchestrator.getRocketChatLogger().error('Error getting the App update info from the Marketplace:', await request.json());
                  return API.v1.failure();
                }
                result = await request.json();
              } catch (e) {
                return handleError('Unable to access Marketplace. Does the server has access to the internet?', e);
              }
              return API.v1.success({
                app: result
              });
            }
            const app = manager.getOneById(this.urlParams.id);
            if (!app) {
              return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
            }
            return API.v1.success({
              app: await formatAppInstanceForRest(app)
            });
          },
          async post() {
            var _orchestrator$getConv3, _orchestrator$getConv4;
            let buff;
            let permissionsGranted;
            let isPrivateAppUpload = false;
            if (this.bodyParams.url) {
              const response = await fetch(this.bodyParams.url);
              if (response.status !== 200 || response.headers.get('content-type') !== 'application/zip') {
                return API.v1.failure({
                  error: 'Invalid url. It doesn\'t exist or is not "application/zip".'
                });
              }
              buff = Buffer.from(await response.arrayBuffer());
            } else if (this.bodyParams.appId && this.bodyParams.marketplace && this.bodyParams.version) {
              const headers = getDefaultHeaders();
              const token = await getWorkspaceAccessToken(true, 'marketplace:download', false);
              try {
                const response = await orchestrator.getMarketplaceClient().fetch("v2/apps/".concat(this.bodyParams.appId, "/download/").concat(this.bodyParams.version, "?token=").concat(token), {
                  headers
                });
                if (response.status !== 200) {
                  orchestrator.getRocketChatLogger().error('Error getting the App from the Marketplace:', await response.text());
                  return API.v1.failure();
                }
                if (response.headers.get('content-type') !== 'application/zip') {
                  return API.v1.failure({
                    error: 'Invalid url. It doesn\'t exist or is not "application/zip".'
                  });
                }
                buff = Buffer.from(await response.arrayBuffer());
              } catch (e) {
                orchestrator.getRocketChatLogger().error('Error getting the App from the Marketplace:', e.response.data);
                return API.v1.internalError();
              }
              permissionsGranted = this.bodyParams.permissionsGranted;
            } else {
              isPrivateAppUpload = true;
              const app = await getUploadFormData({
                request: this.request
              }, {
                field: 'app',
                sizeLimit: settings.get('FileUpload_MaxFileSize')
              });
              const {
                fields: formData
              } = app;
              buff = app.fileBuffer;
              permissionsGranted = (() => {
                try {
                  const permissions = JSON.parse((formData === null || formData === void 0 ? void 0 : formData.permissions) || '');
                  return permissions.length ? permissions : undefined;
                } catch (_unused2) {
                  return undefined;
                }
              })();
            }
            if (!buff) {
              return API.v1.failure({
                error: 'Failed to get a file to install for the App. '
              });
            }
            if (isPrivateAppUpload && orchestrator.shouldDisablePrivateAppInstallation()) {
              return API.v1.internalError('private_app_install_disabled');
            }
            const isCommunityWorkspace = !License.hasValidLicense();
            // Note: exempt apps happen when a private app was uploaded to a community workspace before
            //       the private app restriction was enforced. We still allow the users to use their
            //       exempt apps, but they can't update them, since they could just upload a new version
            //       containing a totally different app under the same id :(
            const isExemptApp = isPrivateAppUpload && isCommunityWorkspace;
            if (isExemptApp) {
              return API.v1.failure({
                error: 'Cannot_Update_Exempt_App'
              });
            }
            const user = orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$getConv3 = orchestrator.getConverters()) === null || _orchestrator$getConv3 === void 0 ? void 0 : (_orchestrator$getConv4 = _orchestrator$getConv3.get('users')) === null || _orchestrator$getConv4 === void 0 ? void 0 : _orchestrator$getConv4.convertToApp(await Meteor.userAsync());
            const aff = await manager.update(buff, permissionsGranted, {
              user,
              loadApp: true
            });
            const info = aff.getAppInfo();
            if (aff.hasStorageError()) {
              return API.v1.failure({
                status: 'storage_error',
                messages: [aff.getStorageError()]
              });
            }
            if (aff.hasAppUserError()) {
              return API.v1.failure({
                status: 'app_user_error',
                messages: [aff.getAppUserError().message],
                payload: {
                  username: aff.getAppUserError().username
                }
              });
            }
            info.status = await aff.getApp().getStatus();
            void notifyMarketplace('update', info);
            void orchestrator.getNotifier().appUpdated(info.id);
            return API.v1.success({
              app: info,
              implemented: aff.getImplementedInferfaces(),
              licenseValidation: aff.getLicenseValidationResult()
            });
          },
          async delete() {
            var _orchestrator$getConv5;
            const prl = manager.getOneById(this.urlParams.id);
            if (!prl) {
              return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
            }
            const user = orchestrator === null || orchestrator === void 0 ? void 0 : (_orchestrator$getConv5 = orchestrator.getConverters()) === null || _orchestrator$getConv5 === void 0 ? void 0 : _orchestrator$getConv5.get('users').convertToApp(await Meteor.userAsync());
            const info = prl.getInfo();
            try {
              await manager.remove(prl.getID(), {
                user
              });
              info.status = AppStatus.DISABLED;
            } catch (e) {
              info.status = await prl.getStatus();
              return API.v1.failure({
                app: info
              });
            }
            void notifyMarketplace('uninstall', info);
            return API.v1.success({
              app: info
            });
          }
        });
        this.api.addRoute(':id/versions', {
          authRequired: true
        }, {
          async get() {
            const headers = {}; // DO NOT ATTACH THE FRAMEWORK/ENGINE VERSION HERE.
            const token = await getWorkspaceAccessToken();
            if (token) {
              headers.Authorization = "Bearer ".concat(token);
            }
            let result;
            let statusCode;
            try {
              const request = await orchestrator.getMarketplaceClient().fetch("v1/apps/".concat(this.urlParams.id), {
                headers
              });
              statusCode = request.status;
              result = await request.json();
              if (!request.ok) {
                throw new Error(result.error);
              }
            } catch (e) {
              return handleError('Unable to access Marketplace. Does the server has access to the internet?', e);
            }
            if (!result || statusCode !== 200) {
              orchestrator.getRocketChatLogger().error('Error getting the App versions from the Marketplace:', result);
              return API.v1.failure();
            }
            return API.v1.success({
              apps: result
            });
          }
        });
        this.api.addRoute(':id/sync', {
          authRequired: true,
          permissionsRequired: ['manage-apps']
        }, {
          async post() {
            const headers = getDefaultHeaders();
            const token = await getWorkspaceAccessToken();
            if (token) {
              headers.Authorization = "Bearer ".concat(token);
            }
            const workspaceIdSetting = await Settings.findOneById('Cloud_Workspace_Id');
            if (!workspaceIdSetting) {
              return API.v1.failure('No workspace id found');
            }
            let result;
            let statusCode;
            try {
              const request = await orchestrator.getMarketplaceClient().fetch("v1/workspaces/".concat(workspaceIdSetting.value, "/apps/").concat(this.urlParams.id), {
                headers
              });
              statusCode = request.status;
              result = await request.json();
              if (!request.ok) {
                throw new Error(result.error);
              }
            } catch (e) {
              orchestrator.getRocketChatLogger().error('Error syncing the App from the Marketplace:', e);
              return API.v1.internalError();
            }
            if (statusCode !== 200) {
              orchestrator.getRocketChatLogger().error('Error syncing the App from the Marketplace:', result);
              return API.v1.failure();
            }
            await Apps.updateAppsMarketplaceInfo([result]);
            return API.v1.success({
              app: result
            });
          }
        });
        this.api.addRoute(':id/icon', {
          authRequired: false
        }, {
          get() {
            const prl = manager.getOneById(this.urlParams.id);
            if (!prl) {
              return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
            }
            const info = prl.getInfo();
            if (!(info !== null && info !== void 0 && info.iconFileContent)) {
              return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
            }
            const imageData = info.iconFileContent.split(';base64,');
            const buf = Buffer.from(imageData[1], 'base64');
            return {
              statusCode: 200,
              headers: {
                'Content-Length': String(buf.length),
                'Content-Type': imageData[0].replace('data:', '')
              },
              body: buf
            };
          }
        });
        this.api.addRoute(':id/screenshots', {
          authRequired: false
        }, {
          async get() {
            const appId = this.urlParams.id;
            const headers = getDefaultHeaders();
            try {
              const request = await orchestrator.getMarketplaceClient().fetch("v1/apps/".concat(appId, "/screenshots"), {
                headers
              });
              const data = await request.json();
              return API.v1.success({
                screenshots: data
              });
            } catch (e) {
              orchestrator.getRocketChatLogger().error('Error getting the screenshots from the Marketplace:', e.message);
              return API.v1.failure(e.message);
            }
          }
        });
        this.api.addRoute(':id/languages', {
          authRequired: false
        }, {
          get() {
            const prl = manager.getOneById(this.urlParams.id);
            if (prl) {
              const languages = prl.getStorageItem().languageContent || {};
              return API.v1.success({
                languages
              });
            }
            return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
          }
        });
        this.api.addRoute(':id/settings', {
          authRequired: true,
          permissionsRequired: ['manage-apps']
        }, {
          get() {
            const prl = manager.getOneById(this.urlParams.id);
            if (prl) {
              const settings = Object.assign({}, prl.getStorageItem().settings);
              Object.keys(settings).forEach(k => {
                if (settings[k].hidden) {
                  delete settings[k];
                }
              });
              return API.v1.success({
                settings
              });
            }
            return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
          },
          async post() {
            var _this$bodyParams;
            if (!((_this$bodyParams = this.bodyParams) !== null && _this$bodyParams !== void 0 && _this$bodyParams.settings)) {
              return API.v1.failure('The settings to update must be present.');
            }
            const prl = manager.getOneById(this.urlParams.id);
            if (!prl) {
              return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
            }
            const {
              settings
            } = prl.getStorageItem();
            const updated = [];
            var _iteratorAbruptCompletion = false;
            var _didIteratorError = false;
            var _iteratorError;
            try {
              for (var _iterator = _asyncIterator(this.bodyParams.settings), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
                const s = _step.value;
                {
                  if (settings[s.id] && settings[s.id].value !== s.value) {
                    await manager.getSettingsManager().updateAppSetting(this.urlParams.id, s);
                    // Updating?
                    updated.push(s);
                  }
                }
              }
            } catch (err) {
              _didIteratorError = true;
              _iteratorError = err;
            } finally {
              try {
                if (_iteratorAbruptCompletion && _iterator.return != null) {
                  await _iterator.return();
                }
              } finally {
                if (_didIteratorError) {
                  throw _iteratorError;
                }
              }
            }
            return API.v1.success({
              updated
            });
          }
        });
        this.api.addRoute(':id/settings/:settingId', {
          authRequired: true,
          permissionsRequired: ['manage-apps']
        }, {
          get() {
            try {
              const setting = manager.getSettingsManager().getAppSetting(this.urlParams.id, this.urlParams.settingId);
              return API.v1.success({
                setting
              });
            } catch (e) {
              if (e.message.includes('No setting found')) {
                return API.v1.notFound("No Setting found on the App by the id of: \"".concat(this.urlParams.settingId, "\""));
              }
              if (e.message.includes('No App found')) {
                return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
              }
              return API.v1.failure(e.message);
            }
          },
          async post() {
            if (!this.bodyParams.setting) {
              return API.v1.failure('Setting to update to must be present on the posted body.');
            }
            try {
              await manager.getSettingsManager().updateAppSetting(this.urlParams.id, this.bodyParams.setting);
              return API.v1.success();
            } catch (e) {
              if (e.message.includes('No setting found')) {
                return API.v1.notFound("No Setting found on the App by the id of: \"".concat(this.urlParams.settingId, "\""));
              }
              if (e.message.includes('No App found')) {
                return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
              }
              return API.v1.failure(e.message);
            }
          }
        });
        this.api.addRoute(':id/apis', {
          authRequired: true,
          permissionsRequired: ['manage-apps']
        }, {
          get() {
            const prl = manager.getOneById(this.urlParams.id);
            if (prl) {
              return API.v1.success({
                apis: manager.apiManager.listApis(this.urlParams.id) // TODO: this is accessing a private property from the manager, we should expose a method to get the list of APIs
              });
            }
            return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
          }
        });
        this.api.addRoute(':id/status', {
          authRequired: true,
          permissionsRequired: ['manage-apps']
        }, {
          async get() {
            const app = manager.getOneById(this.urlParams.id);
            if (!app) {
              return API.v1.notFound("No App found by the id of: ".concat(this.urlParams.id));
            }
            const response = {
              status: await app.getStatus()
            };
            try {
              const clusterStatus = await fetchAppsStatusFromCluster();
              if (clusterStatus !== null && clusterStatus !== void 0 && clusterStatus[app.getID()]) {
                response.clusterStatus = clusterStatus[app.getID()];
              }
            } catch (e) {
              orchestrator.getRocketChatLogger().warn('App status endpoint: could not fetch status across cluster', e);
            }
            return API.v1.success(response);
          },
          async post() {
            const {
              id: appId
            } = this.urlParams;
            const {
              status
            } = this.bodyParams;
            if (!status || typeof status !== 'string') {
              return API.v1.failure('Invalid status provided, it must be "status" field and a string.');
            }
            const prl = manager.getOneById(appId);
            if (!prl) {
              return API.v1.notFound("No App found by the id of: ".concat(appId));
            }
            if (AppStatusUtils.isEnabled(status)) {
              try {
                await canEnableApp(prl.getStorageItem());
              } catch (error) {
                return API.v1.failure(error.message);
              }
            }
            const result = await manager.changeStatus(prl.getID(), status);
            return API.v1.success({
              status: result.getStatus()
            });
          }
        });
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"uikit.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/uikit.ts                                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      AppUIKitInteractionApi: () => AppUIKitInteractionApi
    });
    let UiKitCoreApp;
    module.link("@rocket.chat/core-services", {
      UiKitCoreApp(v) {
        UiKitCoreApp = v;
      }
    }, 0);
    let bodyParser;
    module.link("body-parser", {
      default(v) {
        bodyParser = v;
      }
    }, 1);
    let cors;
    module.link("cors", {
      default(v) {
        cors = v;
      }
    }, 2);
    let express;
    module.link("express", {
      default(v) {
        express = v;
      }
    }, 3);
    let rateLimit;
    module.link("express-rate-limit", {
      default(v) {
        rateLimit = v;
      }
    }, 4);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 5);
    let WebApp;
    module.link("meteor/webapp", {
      WebApp(v) {
        WebApp = v;
      }
    }, 6);
    let authenticationMiddleware;
    module.link("../../../../app/api/server/middlewares/authentication", {
      authenticationMiddleware(v) {
        authenticationMiddleware = v;
      }
    }, 7);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 8);
    let Apps;
    module.link("../orchestrator", {
      Apps(v) {
        Apps = v;
      }
    }, 9);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const apiServer = express();
    apiServer.disable('x-powered-by');
    let corsEnabled = false;
    let allowListOrigins = [];
    settings.watch('API_Enable_CORS', value => {
      corsEnabled = value;
    });
    settings.watch('API_CORS_Origin', value => {
      allowListOrigins = value ? value.trim().split(',').map(origin => String(origin).trim().toLocaleLowerCase()) : [];
    });
    WebApp.rawConnectHandlers.use(apiServer);
    // eslint-disable-next-line new-cap
    const router = express.Router();
    const unauthorized = res => res.status(401).send({
      status: 'error',
      message: 'You must be logged in to do this.'
    });
    Meteor.startup(() => {
      // use specific rate limit of 600 (which is 60 times the default limits) requests per minute (around 10/second)
      const apiLimiter = rateLimit({
        windowMs: settings.get('API_Enable_Rate_Limiter_Limit_Time_Default'),
        max: settings.get('API_Enable_Rate_Limiter_Limit_Calls_Default') * 60,
        skip: () => settings.get('API_Enable_Rate_Limiter') !== true || process.env.NODE_ENV === 'development' && settings.get('API_Enable_Rate_Limiter_Dev') !== true
      });
      router.use(apiLimiter);
    });
    router.use(authenticationMiddleware({
      rejectUnauthorized: false
    }));
    router.use(async (req, res, next) => {
      const {
        'x-visitor-token': visitorToken
      } = req.headers;
      if (visitorToken) {
        var _Apps$getConverters;
        req.body.visitor = await ((_Apps$getConverters = Apps.getConverters()) === null || _Apps$getConverters === void 0 ? void 0 : _Apps$getConverters.get('visitors').convertByToken(visitorToken));
      }
      if (!req.user && !req.body.visitor) {
        return unauthorized(res);
      }
      next();
    });
    const corsOptions = {
      origin: (origin, callback) => {
        if (!origin || !corsEnabled || allowListOrigins.includes('*') || allowListOrigins.includes(origin) || origin === settings.get('Site_Url')) {
          callback(null, true);
        } else {
          callback(new Error('Not allowed by CORS'), false);
        }
      }
    };
    apiServer.use('/api/apps/ui.interaction/', bodyParser.json(), cors(corsOptions), router); // didn't have the rateLimiter option
    const getCoreAppPayload = req => {
      const {
        id: appId
      } = req.params;
      if (req.body.type === 'blockAction') {
        const {
          user
        } = req;
        const {
          type,
          actionId,
          triggerId,
          payload,
          container,
          visitor
        } = req.body;
        const message = 'mid' in req.body ? req.body.mid : undefined;
        const room = 'rid' in req.body ? req.body.rid : undefined;
        return {
          appId,
          type,
          actionId,
          triggerId,
          container,
          message,
          payload,
          user,
          visitor,
          room
        };
      }
      if (req.body.type === 'viewClosed') {
        const {
          user
        } = req;
        const {
          type,
          payload: {
            view,
            isCleared
          },
          triggerId
        } = req.body;
        return {
          appId,
          triggerId,
          type,
          user,
          payload: {
            view,
            isCleared
          }
        };
      }
      if (req.body.type === 'viewSubmit') {
        const {
          user
        } = req;
        const {
          type,
          actionId,
          triggerId,
          payload
        } = req.body;
        return {
          appId,
          type,
          actionId,
          triggerId,
          payload,
          user
        };
      }
      throw new Error('Type not supported');
    };
    router.post('/:id', async (req, res, next) => {
      const {
        id: appId
      } = req.params;
      const isCoreApp = await UiKitCoreApp.isRegistered(appId);
      if (!isCoreApp) {
        return next();
      }
      try {
        const payload = getCoreAppPayload(req);
        const result = await UiKitCoreApp[payload.type](payload);
        // Using ?? to always send something in the response, even if the app had no result.
        res.send(result !== null && result !== void 0 ? result : {});
      } catch (e) {
        const error = e instanceof Error ? e.message : e;
        res.status(500).send({
          error
        });
      }
    });
    class AppUIKitInteractionApi {
      constructor(_orch) {
        this.orch = void 0;
        this.routeHandler = async (req, res) => {
          const {
            orch
          } = this;
          const {
            id: appId
          } = req.params;
          switch (req.body.type) {
            case 'blockAction':
              {
                var _orch$getConverters, _orch$getConverters2, _orch$getConverters3;
                const {
                  type,
                  actionId,
                  triggerId,
                  payload,
                  container
                } = req.body;
                const mid = 'mid' in req.body ? req.body.mid : undefined;
                const rid = 'rid' in req.body ? req.body.rid : undefined;
                const {
                  visitor
                } = req.body;
                const room = await ((_orch$getConverters = orch.getConverters()) === null || _orch$getConverters === void 0 ? void 0 : _orch$getConverters.get('rooms').convertById(rid));
                const user = (_orch$getConverters2 = orch.getConverters()) === null || _orch$getConverters2 === void 0 ? void 0 : _orch$getConverters2.get('users').convertToApp(req.user);
                const message = mid && (await ((_orch$getConverters3 = orch.getConverters()) === null || _orch$getConverters3 === void 0 ? void 0 : _orch$getConverters3.get('messages').convertById(mid)));
                const action = {
                  type,
                  container,
                  appId,
                  actionId,
                  message,
                  triggerId,
                  payload,
                  user,
                  visitor,
                  room
                };
                try {
                  const eventInterface = !visitor ? 'IUIKitInteractionHandler' : 'IUIKitLivechatInteractionHandler';
                  const result = await orch.triggerEvent(eventInterface, action);
                  res.send(result);
                } catch (e) {
                  const error = e instanceof Error ? e.message : e;
                  res.status(500).send({
                    error
                  });
                }
                break;
              }
            case 'viewClosed':
              {
                var _orch$getConverters4;
                const {
                  type,
                  payload: {
                    view,
                    isCleared
                  }
                } = req.body;
                const user = (_orch$getConverters4 = orch.getConverters()) === null || _orch$getConverters4 === void 0 ? void 0 : _orch$getConverters4.get('users').convertToApp(req.user);
                const action = {
                  type,
                  appId,
                  user,
                  payload: {
                    view,
                    isCleared
                  }
                };
                try {
                  const result = await orch.triggerEvent('IUIKitInteractionHandler', action);
                  res.send(result);
                } catch (e) {
                  const error = e instanceof Error ? e.message : e;
                  res.status(500).send({
                    error
                  });
                }
                break;
              }
            case 'viewSubmit':
              {
                var _orch$getConverters5;
                const {
                  type,
                  actionId,
                  triggerId,
                  payload
                } = req.body;
                const user = (_orch$getConverters5 = orch.getConverters()) === null || _orch$getConverters5 === void 0 ? void 0 : _orch$getConverters5.get('users').convertToApp(req.user);
                const action = {
                  type,
                  appId,
                  actionId,
                  triggerId,
                  payload,
                  user
                };
                try {
                  const result = await orch.triggerEvent('IUIKitInteractionHandler', action);
                  res.send(result);
                } catch (e) {
                  const error = e instanceof Error ? e.message : e;
                  res.status(500).send({
                    error
                  });
                }
                break;
              }
            case 'actionButton':
              {
                var _orch$getConverters6, _orch$getConverters7, _orch$getConverters8;
                const {
                  type,
                  actionId,
                  triggerId,
                  rid,
                  mid,
                  tmid,
                  payload: {
                    context,
                    message: msgText
                  }
                } = req.body;
                const room = await ((_orch$getConverters6 = orch.getConverters()) === null || _orch$getConverters6 === void 0 ? void 0 : _orch$getConverters6.get('rooms').convertById(rid));
                const user = (_orch$getConverters7 = orch.getConverters()) === null || _orch$getConverters7 === void 0 ? void 0 : _orch$getConverters7.get('users').convertToApp(req.user);
                const message = mid && (await ((_orch$getConverters8 = orch.getConverters()) === null || _orch$getConverters8 === void 0 ? void 0 : _orch$getConverters8.get('messages').convertById(mid)));
                const action = {
                  type,
                  appId,
                  actionId,
                  triggerId,
                  user,
                  room,
                  message,
                  tmid,
                  payload: _objectSpread({
                    context
                  }, msgText ? {
                    message: msgText
                  } : {})
                };
                try {
                  const result = await orch.triggerEvent('IUIKitInteractionHandler', action);
                  res.send(result);
                } catch (e) {
                  const error = e instanceof Error ? e.message : e;
                  res.status(500).send({
                    error
                  });
                }
                break;
              }
            default:
              {
                res.status(400).send({
                  error: 'Unknown action'
                });
              }
          }
          // TODO: validate payloads per type
        };
        this.orch = _orch;
        router.post('/:id', this.routeHandler);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"websockets.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/communication/websockets.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      AppEvents: () => AppEvents,
      AppServerListener: () => AppServerListener,
      AppServerNotifier: () => AppServerNotifier
    });
    let AppStatusUtils;
    module.link("@rocket.chat/apps-engine/definition/AppStatus", {
      AppStatusUtils(v) {
        AppStatusUtils = v;
      }
    }, 0);
    let api;
    module.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      }
    }, 1);
    let notifications;
    module.link("../../../../app/notifications/server/lib/Notifications", {
      default(v) {
        notifications = v;
      }
    }, 2);
    let SystemLogger;
    module.link("../../../../server/lib/logger/system", {
      SystemLogger(v) {
        SystemLogger = v;
      }
    }, 3);
    let AppEvents;
    module.link("./events", {
      AppEvents(v) {
        AppEvents = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class AppServerListener {
      constructor(orch, engineStreamer, clientStreamer, received) {
        this.orch = void 0;
        this.engineStreamer = void 0;
        this.clientStreamer = void 0;
        this.received = void 0;
        this.orch = orch;
        this.engineStreamer = engineStreamer;
        this.clientStreamer = clientStreamer;
        this.received = received;
        this.engineStreamer.on(AppEvents.APP_STATUS_CHANGE, this.onAppStatusUpdated.bind(this));
        this.engineStreamer.on(AppEvents.APP_REMOVED, this.onAppRemoved.bind(this));
        this.engineStreamer.on(AppEvents.APP_UPDATED, this.onAppUpdated.bind(this));
        this.engineStreamer.on(AppEvents.APP_ADDED, this.onAppAdded.bind(this));
        this.engineStreamer.on(AppEvents.ACTIONS_CHANGED, this.onActionsChanged.bind(this));
        this.engineStreamer.on(AppEvents.APP_SETTING_UPDATED, this.onAppSettingUpdated.bind(this));
        this.engineStreamer.on(AppEvents.COMMAND_ADDED, this.onCommandAdded.bind(this));
        this.engineStreamer.on(AppEvents.COMMAND_DISABLED, this.onCommandDisabled.bind(this));
        this.engineStreamer.on(AppEvents.COMMAND_UPDATED, this.onCommandUpdated.bind(this));
        this.engineStreamer.on(AppEvents.COMMAND_REMOVED, this.onCommandRemoved.bind(this));
      }
      async onAppAdded(appId) {
        await this.orch.getManager().addLocal(appId); // TO-DO: fix type
        this.clientStreamer.emitWithoutBroadcast(AppEvents.APP_ADDED, appId);
      }
      async onAppStatusUpdated(_ref) {
        var _this$orch$getManager;
        let {
          appId,
          status
        } = _ref;
        const app = (_this$orch$getManager = this.orch.getManager()) === null || _this$orch$getManager === void 0 ? void 0 : _this$orch$getManager.getOneById(appId);
        if (!app || (await app.getStatus()) === status) {
          return;
        }
        this.received.set("".concat(AppEvents.APP_STATUS_CHANGE, "_").concat(appId), {
          appId,
          status,
          when: new Date()
        });
        if (AppStatusUtils.isEnabled(status)) {
          var _this$orch$getManager2;
          await ((_this$orch$getManager2 = this.orch.getManager()) === null || _this$orch$getManager2 === void 0 ? void 0 : _this$orch$getManager2.enable(appId).catch(SystemLogger.error));
          this.clientStreamer.emitWithoutBroadcast(AppEvents.APP_STATUS_CHANGE, {
            appId,
            status
          });
        } else if (AppStatusUtils.isDisabled(status)) {
          var _this$orch$getManager3;
          await ((_this$orch$getManager3 = this.orch.getManager()) === null || _this$orch$getManager3 === void 0 ? void 0 : _this$orch$getManager3.disable(appId, status, true).catch(SystemLogger.error));
          this.clientStreamer.emitWithoutBroadcast(AppEvents.APP_STATUS_CHANGE, {
            appId,
            status
          });
        }
      }
      async onAppSettingUpdated(_ref2) {
        let {
          appId,
          setting
        } = _ref2;
        this.received.set("".concat(AppEvents.APP_SETTING_UPDATED, "_").concat(appId, "_").concat(setting.id), {
          appId,
          setting,
          when: new Date()
        });
        await this.orch.getManager().getSettingsManager().updateAppSetting(appId, setting); // TO-DO: fix type of `setting`
        this.clientStreamer.emitWithoutBroadcast(AppEvents.APP_SETTING_UPDATED, {
          appId,
          setting
        });
      }
      async onAppUpdated(appId) {
        this.received.set("".concat(AppEvents.APP_UPDATED, "_").concat(appId), {
          appId,
          when: new Date()
        });
        const storageItem = await this.orch.getStorage().retrieveOne(appId);
        const appPackage = await this.orch.getAppSourceStorage().fetch(storageItem);
        const isEnabled = AppStatusUtils.isEnabled(storageItem.status);
        if (isEnabled) {
          await this.orch.getManager().updateAndStartupLocal(storageItem, appPackage);
        } else {
          await this.orch.getManager().updateAndInitializeLocal(storageItem, appPackage);
        }
        this.clientStreamer.emitWithoutBroadcast(AppEvents.APP_UPDATED, appId);
      }
      async onAppRemoved(appId) {
        const app = this.orch.getManager().getOneById(appId);
        if (!app) {
          return;
        }
        await this.orch.getManager().removeLocal(appId);
        this.clientStreamer.emitWithoutBroadcast(AppEvents.APP_REMOVED, appId);
      }
      async onCommandAdded(command) {
        this.clientStreamer.emitWithoutBroadcast(AppEvents.COMMAND_ADDED, command);
      }
      async onCommandDisabled(command) {
        this.clientStreamer.emitWithoutBroadcast(AppEvents.COMMAND_DISABLED, command);
      }
      async onCommandUpdated(command) {
        this.clientStreamer.emitWithoutBroadcast(AppEvents.COMMAND_UPDATED, command);
      }
      async onCommandRemoved(command) {
        this.clientStreamer.emitWithoutBroadcast(AppEvents.COMMAND_REMOVED, command);
      }
      async onActionsChanged() {
        this.clientStreamer.emitWithoutBroadcast(AppEvents.ACTIONS_CHANGED);
      }
    }
    class AppServerNotifier {
      constructor(orch) {
        this.engineStreamer = void 0;
        this.clientStreamer = void 0;
        this.received = void 0;
        this.listener = void 0;
        this.engineStreamer = notifications.streamAppsEngine;
        // This is used to broadcast to the web clients
        this.clientStreamer = notifications.streamApps;
        this.received = new Map();
        this.listener = new AppServerListener(orch, this.engineStreamer, this.clientStreamer, this.received);
      }
      async appAdded(appId) {
        void api.broadcast('apps.added', appId);
      }
      async appRemoved(appId) {
        void api.broadcast('apps.removed', appId);
      }
      async appUpdated(appId) {
        if (this.received.has("".concat(AppEvents.APP_UPDATED, "_").concat(appId))) {
          this.received.delete("".concat(AppEvents.APP_UPDATED, "_").concat(appId));
          return;
        }
        void api.broadcast('apps.updated', appId);
      }
      async appStatusUpdated(appId, status) {
        if (this.received.has("".concat(AppEvents.APP_STATUS_CHANGE, "_").concat(appId))) {
          const details = this.received.get("".concat(AppEvents.APP_STATUS_CHANGE, "_").concat(appId));
          if (details.status === status) {
            this.received.delete("".concat(AppEvents.APP_STATUS_CHANGE, "_").concat(appId));
            return;
          }
        }
        void api.broadcast('apps.statusUpdate', appId, status);
      }
      async appSettingsChange(appId, setting) {
        if (this.received.has("".concat(AppEvents.APP_SETTING_UPDATED, "_").concat(appId, "_").concat(setting.id))) {
          this.received.delete("".concat(AppEvents.APP_SETTING_UPDATED, "_").concat(appId, "_").concat(setting.id));
          return;
        }
        void api.broadcast('apps.settingUpdated', appId, setting);
      }
      async commandAdded(command) {
        void api.broadcast('command.added', command);
      }
      async commandDisabled(command) {
        void api.broadcast('command.disabled', command);
      }
      async commandUpdated(command) {
        void api.broadcast('command.updated', command);
      }
      async commandRemoved(command) {
        void api.broadcast('command.removed', command);
      }
      async actionsChanged() {
        void api.broadcast('actions.changed');
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"marketplace":{"MarketplaceAPIClient.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/marketplace/MarketplaceAPIClient.ts                                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _classPrivateFieldLooseBase;
    module.link("@babel/runtime/helpers/classPrivateFieldLooseBase", {
      default(v) {
        _classPrivateFieldLooseBase = v;
      }
    }, 0);
    let _classPrivateFieldLooseKey;
    module.link("@babel/runtime/helpers/classPrivateFieldLooseKey", {
      default(v) {
        _classPrivateFieldLooseKey = v;
      }
    }, 1);
    module.export({
      MarketplaceAPIClient: () => MarketplaceAPIClient
    });
    let Response, serverFetch;
    module.link("@rocket.chat/server-fetch", {
      Response(v) {
        Response = v;
      },
      serverFetch(v) {
        serverFetch = v;
      }
    }, 0);
    let isTesting;
    module.link("./isTesting", {
      isTesting(v) {
        isTesting = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    var _fetchStrategy = /*#__PURE__*/_classPrivateFieldLooseKey("fetchStrategy");
    var _marketplaceUrl = /*#__PURE__*/_classPrivateFieldLooseKey("marketplaceUrl");
    class MarketplaceAPIClient {
      constructor() {
        Object.defineProperty(this, _fetchStrategy, {
          writable: true,
          value: void 0
        });
        Object.defineProperty(this, _marketplaceUrl, {
          writable: true,
          value: void 0
        });
        if (typeof process.env.OVERWRITE_INTERNAL_MARKETPLACE_URL === 'string' && process.env.OVERWRITE_INTERNAL_MARKETPLACE_URL !== '') {
          _classPrivateFieldLooseBase(this, _marketplaceUrl)[_marketplaceUrl] = process.env.OVERWRITE_INTERNAL_MARKETPLACE_URL;
        } else {
          _classPrivateFieldLooseBase(this, _marketplaceUrl)[_marketplaceUrl] = 'https://marketplace.rocket.chat';
        }
        if (isTesting()) {
          _classPrivateFieldLooseBase(this, _fetchStrategy)[_fetchStrategy] = mockMarketplaceFetch;
        } else {
          _classPrivateFieldLooseBase(this, _fetchStrategy)[_fetchStrategy] = serverFetch;
        }
      }
      getMarketplaceUrl() {
        return _classPrivateFieldLooseBase(this, _marketplaceUrl)[_marketplaceUrl];
      }
      setStrategy(strategyName) {
        switch (strategyName) {
          case 'default':
            _classPrivateFieldLooseBase(this, _fetchStrategy)[_fetchStrategy] = serverFetch;
            break;
          case 'mock':
            _classPrivateFieldLooseBase(this, _fetchStrategy)[_fetchStrategy] = mockMarketplaceFetch;
            break;
          default:
            throw new Error('Unknown strategy');
        }
      }
      fetch(input, options, allowSelfSignedCerts) {
        if (!input.startsWith('http://') && !input.startsWith('https://')) {
          input = this.getMarketplaceUrl().concat(!input.startsWith('/') ? '/' : '', input);
        }
        return _classPrivateFieldLooseBase(this, _fetchStrategy)[_fetchStrategy](input, options, allowSelfSignedCerts);
      }
    }
    /**
     * Provide mocked HTTP responses for supported Marketplace API endpoints.
     *
     * This allows us to prevent actual calls to Marketplace service
     * during TEST_MODE (CI, local tests, etc.), i.e., remove our dependency
     * an external unrelated service
     *
     * The response content provided has minimal structure to allow for the program
     * to not crash by receiving something different from the expected structure
     *
     * @param input - The request URL or path used to determine which mock response to return
     * @returns A `Response` with status 200 and a JSON body corresponding to the requested marketplace endpoint
     * @throws Error when `input` does not match any supported mock endpoint
     */
    function mockMarketplaceFetch(input, _options, _allowSelfSignedCerts) {
      let content;
      switch (true) {
        // This is not an exhaustive list of endpoints
        case input.indexOf('v1/apps') !== -1:
        case input.indexOf('v1/categories') !== -1:
        case input.indexOf('v1/bundles') !== -1:
          content = '[]';
          break;
        case input.indexOf('v1/featured-apps') !== -1:
          content = '{"sections":[]}';
          break;
        case input.indexOf('v1/app-request/stats') !== -1:
          content = '{"data":{"totalSeen":0,"totalUnseen":0}}';
          break;
        case input.indexOf('v1/app-request/markAsSeen') !== -1:
          content = '{"success":false}';
          break;
        case input.indexOf('v1/app-request') !== -1:
          content = '{"data":[],"meta":{"limit":25,"offset":0,"sort":"","filter":"","total":0}}';
          break;
        case input.indexOf('v1/workspaces') !== -1:
          content = '{}';
          break;
        default:
          throw new Error("Invalid marketplace mock request ".concat(input));
      }
      const response = new Response(Buffer.from(content), {
        headers: {
          'content-type': 'application/json'
        },
        status: 200
      });
      return Promise.resolve(response);
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"appInstall.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/marketplace/appInstall.ts                                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      notifyMarketplace: () => notifyMarketplace
    });
    let getWorkspaceAccessToken;
    module.link("../../../../app/cloud/server", {
      getWorkspaceAccessToken(v) {
        getWorkspaceAccessToken = v;
      }
    }, 0);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 1);
    let Info;
    module.link("../../../../app/utils/rocketchat.info", {
      Info(v) {
        Info = v;
      }
    }, 2);
    let Apps;
    module.link("../orchestrator", {
      Apps(v) {
        Apps = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function notifyMarketplace(action, appInfo) {
      const headers = {};
      try {
        const token = await getWorkspaceAccessToken();
        headers.Authorization = "Bearer ".concat(token);
        // eslint-disable-next-line no-empty
      } catch (_unused) {}
      let siteUrl = '';
      try {
        siteUrl = settings.get('Site_Url');
        // eslint-disable-next-line no-empty
      } catch (_unused2) {}
      const data = {
        action,
        appName: appInfo.name,
        appSlug: appInfo.nameSlug,
        appVersion: appInfo.version,
        rocketChatVersion: Info.version,
        engineVersion: Info.marketplaceApiVersion,
        siteUrl
      };
      const pendingSentUrl = "v1/apps/".concat(appInfo.id, "/install");
      try {
        await Apps.getMarketplaceClient().fetch(pendingSentUrl, {
          method: 'POST',
          headers,
          body: data
        });
        // eslint-disable-next-line no-empty
      } catch (_unused3) {}
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"appRequestNotifyUsers.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/marketplace/appRequestNotifyUsers.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 0);
    module.export({
      appRequestNotififyForUsers: () => appRequestNotififyForUsers
    });
    let fetch;
    module.link("@rocket.chat/server-fetch", {
      serverFetch(v) {
        fetch = v;
      }
    }, 0);
    let getWorkspaceAccessToken;
    module.link("../../../../app/cloud/server", {
      getWorkspaceAccessToken(v) {
        getWorkspaceAccessToken = v;
      }
    }, 1);
    let i18n;
    module.link("../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 2);
    let sendDirectMessageToUsers;
    module.link("../../../../server/lib/sendDirectMessageToUsers", {
      sendDirectMessageToUsers(v) {
        sendDirectMessageToUsers = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const ROCKET_CAT_USERID = 'rocket.cat';
    const DEFAULT_LIMIT = 100;
    const notifyBatchOfUsersError = error => {
      return new Error("could not notify the batch of users. Error ".concat(error));
    };
    const notifyBatchOfUsers = async (appName, learnMoreUrl, appRequests) => {
      const batchRequesters = appRequests.reduce((acc, appRequest) => {
        // Prevent duplicate requesters
        if (!acc.includes(appRequest.requester.id)) {
          acc.push(appRequest.requester.id);
        }
        return acc;
      }, []);
      const msgFn = user => {
        const defaultLang = user.language || 'en';
        const msg = "".concat(i18n.t('App_request_enduser_message', {
          appName,
          learnmore: learnMoreUrl,
          lng: defaultLang
        }));
        return msg;
      };
      try {
        return await sendDirectMessageToUsers(ROCKET_CAT_USERID, batchRequesters, msgFn);
      } catch (e) {
        throw e;
      }
    };
    const appRequestNotififyForUsers = async (marketplaceBaseUrl, workspaceUrl, appId, appName) => {
      try {
        const token = await getWorkspaceAccessToken();
        const headers = {
          Authorization: "Bearer ".concat(token)
        };
        // First request
        const pagination = {
          limit: DEFAULT_LIMIT,
          offset: 0
        };
        // First request to get the total and the first batch
        const response = await fetch("".concat(marketplaceBaseUrl, "/v1/app-request"), {
          headers,
          params: {
            appId,
            q: 'notification-not-sent',
            limit: pagination.limit,
            offset: pagination.offset
          }
        });
        const data = await response.json();
        const {
          total
        } = data.meta;
        if (total === undefined || total === 0) {
          return [];
        }
        // Calculate the number of loops - 1 because the first request was already made
        const loops = Math.ceil(total / pagination.limit) - 1;
        const requestsCollection = [];
        const learnMore = "".concat(workspaceUrl, "marketplace/explore/info/").concat(appId);
        // Notify first batch
        requestsCollection.push(notifyBatchOfUsers(appName, learnMore, data.data).catch(notifyBatchOfUsersError));
        // Batch requests
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        var _iteratorAbruptCompletion = false;
        var _didIteratorError = false;
        var _iteratorError;
        try {
          for (var _iterator = _asyncIterator(Array.from({
              length: loops
            })), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
            const _i = _step.value;
            {
              pagination.offset += pagination.limit;
              const request = await fetch("".concat(marketplaceBaseUrl, "/v1/app-request?appId=").concat(appId, "&q=notification-not-sent&limit=").concat(pagination.limit, "&offset=").concat(pagination.offset), {
                headers
              });
              const {
                data
              } = await request.json();
              requestsCollection.push(notifyBatchOfUsers(appName, learnMore, data));
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion && _iterator.return != null) {
              await _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
        const finalResult = await Promise.all(requestsCollection);
        // Return the list of users that were notified
        return finalResult.flat();
      } catch (e) {
        throw e;
      }
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"fetchMarketplaceApps.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/marketplace/fetchMarketplaceApps.ts                                                                  //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      fetchMarketplaceApps: () => fetchMarketplaceApps
    });
    let z;
    module.link("zod", {
      z(v) {
        z = v;
      }
    }, 0);
    let getMarketplaceHeaders;
    module.link("./getMarketplaceHeaders", {
      getMarketplaceHeaders(v) {
        getMarketplaceHeaders = v;
      }
    }, 1);
    let getWorkspaceAccessToken;
    module.link("../../../../app/cloud/server", {
      getWorkspaceAccessToken(v) {
        getWorkspaceAccessToken = v;
      }
    }, 2);
    let Apps;
    module.link("../orchestrator", {
      Apps(v) {
        Apps = v;
      }
    }, 3);
    let MarketplaceAppsError, MarketplaceConnectionError, MarketplaceUnsupportedVersionError;
    module.link("./marketplaceErrors", {
      MarketplaceAppsError(v) {
        MarketplaceAppsError = v;
      },
      MarketplaceConnectionError(v) {
        MarketplaceConnectionError = v;
      },
      MarketplaceUnsupportedVersionError(v) {
        MarketplaceUnsupportedVersionError = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const markdownObject = z.object({
      raw: z.string().optional(),
      rendered: z.string().optional()
    });
    const fetchMarketplaceAppsSchema = z.array(z.object({
      appId: z.string(),
      latest: z.object({
        internalId: z.string(),
        id: z.string(),
        name: z.string(),
        nameSlug: z.string(),
        version: z.string(),
        categories: z.array(z.string()),
        languages: z.array(z.string()).optional(),
        shortDescription: z.string().optional(),
        description: z.string(),
        privacyPolicySummary: z.string().optional(),
        documentationUrl: z.string().optional(),
        detailedDescription: markdownObject,
        detailedChangelog: markdownObject,
        requiredApiVersion: z.string(),
        versionIncompatible: z.boolean().optional(),
        permissions: z.array(z.object({
          name: z.string(),
          domains: z.array(z.string()).optional(),
          scopes: z.array(z.string()).optional()
        })).optional(),
        addon: z.string().optional(),
        author: z.object({
          name: z.string(),
          support: z.string(),
          homepage: z.string()
        }),
        classFile: z.string(),
        iconFile: z.string(),
        iconFileData: z.string(),
        status: z.enum(['submitted', 'author-rejected', 'author-approved', 'rejected', 'approved', 'published']),
        reviewedNote: z.string().optional(),
        rejectionNote: z.string().optional(),
        changesNote: z.string().optional(),
        internalChangesNote: z.string().optional(),
        isVisible: z.boolean(),
        createdDate: z.string(),
        modifiedDate: z.string()
      }),
      isAddon: z.boolean(),
      addonId: z.string().optional(),
      isEnterpriseOnly: z.boolean(),
      isBundle: z.boolean(),
      bundledAppsIn: z.array(z.string()).optional(),
      bundledIn: z.array(z.object({
        bundleId: z.string(),
        bundleName: z.string(),
        addonTierId: z.string().optional()
      })),
      isPurchased: z.boolean(),
      isSubscribed: z.boolean(),
      subscriptionInfo: z.object({
        typeOf: z.enum(['app', 'service', '']),
        status: z.enum(['trialing', 'active', 'cancelled', 'cancelling', 'pastDue', '']),
        statusFromBilling: z.boolean(),
        isSeatBased: z.boolean(),
        seats: z.number(),
        maxSeats: z.number(),
        license: z.object({
          license: z.string(),
          version: z.number(),
          expireDate: z.string()
        }),
        startDate: z.string(),
        periodEnd: z.string(),
        endDate: z.string().optional(),
        externallyManaged: z.boolean(),
        isSubscribedViaBundle: z.boolean()
      }).optional(),
      price: z.number(),
      purchaseType: z.enum(['', 'buy', 'subscription']),
      pricingPlans: z.array(z.object({
        id: z.string(),
        enabled: z.boolean(),
        price: z.number(),
        trialDays: z.number(),
        strategy: z.enum(['once', 'monthly', 'yearly']),
        isPerSeat: z.boolean(),
        tiers: z.array(z.object({
          perUnit: z.boolean(),
          minimum: z.number(),
          maximum: z.number(),
          price: z.number(),
          refId: z.string().optional()
        })).optional()
      })).optional(),
      isUsageBased: z.boolean().optional(),
      requestedEndUser: z.boolean().optional(),
      requested: z.boolean().optional(),
      appRequestStats: z.object({}).optional(),
      createdAt: z.string(),
      modifiedAt: z.string()
    }));
    /**
     * Fetches marketplace apps available to the workspace.
     *
     * @param endUserID - Optional end-user identifier used to filter apps returned by the marketplace.
     * @returns An array of marketplace `App` objects describing available apps and their latest release metadata.
     * @throws MarketplaceConnectionError when the marketplace cannot be reached.
     * @throws MarketplaceUnsupportedVersionError when the marketplace reports an unsupported client version.
     * @throws MarketplaceAppsError for marketplace-side errors, including invalid apps engine version, internal marketplace errors, or a generic failure to fetch apps.
     */
    async function fetchMarketplaceApps() {
      let {
        endUserID
      } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      const headers = getMarketplaceHeaders();
      const token = await getWorkspaceAccessToken();
      if (token) {
        headers.Authorization = "Bearer ".concat(token);
      }
      let request;
      try {
        request = await Apps.getMarketplaceClient().fetch("v1/apps", {
          headers,
          params: _objectSpread({}, endUserID && {
            endUserID
          })
        });
      } catch (error) {
        throw new MarketplaceConnectionError('Marketplace_Bad_Marketplace_Connection');
      }
      if (request.status === 200) {
        const response = await request.json();
        fetchMarketplaceAppsSchema.parse(response);
        return response;
      }
      const response = await request.json();
      Apps.getRocketChatLogger().error('Failed to fetch marketplace apps', response);
      // TODO: Refactor cloud to return a proper error code on unsupported version
      if (request.status === 426 && 'errorMsg' in response && response.errorMsg === 'unsupported version') {
        throw new MarketplaceUnsupportedVersionError();
      }
      if (request.status === 400 && response.code === 200) {
        throw new MarketplaceAppsError('Marketplace_Invalid_Apps_Engine_Version');
      }
      const INTERNAL_MARKETPLACE_ERROR_CODES = [266, 256, 166, 221, 257, 320];
      if (request.status === 500 && INTERNAL_MARKETPLACE_ERROR_CODES.includes(response.code)) {
        throw new MarketplaceAppsError('Marketplace_Internal_Error');
      }
      throw new MarketplaceAppsError('Marketplace_Failed_To_Fetch_Apps');
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"fetchMarketplaceCategories.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/marketplace/fetchMarketplaceCategories.ts                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      fetchMarketplaceCategories: () => fetchMarketplaceCategories
    });
    let z;
    module.link("zod", {
      z(v) {
        z = v;
      }
    }, 0);
    let getMarketplaceHeaders;
    module.link("./getMarketplaceHeaders", {
      getMarketplaceHeaders(v) {
        getMarketplaceHeaders = v;
      }
    }, 1);
    let getWorkspaceAccessToken;
    module.link("../../../../app/cloud/server", {
      getWorkspaceAccessToken(v) {
        getWorkspaceAccessToken = v;
      }
    }, 2);
    let Apps;
    module.link("../orchestrator", {
      Apps(v) {
        Apps = v;
      }
    }, 3);
    let MarketplaceAppsError, MarketplaceConnectionError, MarketplaceUnsupportedVersionError;
    module.link("./marketplaceErrors", {
      MarketplaceAppsError(v) {
        MarketplaceAppsError = v;
      },
      MarketplaceConnectionError(v) {
        MarketplaceConnectionError = v;
      },
      MarketplaceUnsupportedVersionError(v) {
        MarketplaceUnsupportedVersionError = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const fetchMarketplaceCategoriesSchema = z.array(z.object({
      id: z.string(),
      title: z.string(),
      description: z.string(),
      hidden: z.boolean(),
      createdDate: z.string(),
      modifiedDate: z.string()
    }));
    /**
     * Fetches marketplace categories from the marketplace API.
     *
     * @returns An array of marketplace categories (`AppCategory[]`).
     * @throws MarketplaceConnectionError when the HTTP request cannot be made.
     * @throws MarketplaceUnsupportedVersionError when the marketplace responds with status 426 and `errorMsg` equals `"unsupported version"`.
     * @throws MarketplaceAppsError when the marketplace returns an internal error (specific internal codes) or any other non-successful response.
     */
    async function fetchMarketplaceCategories() {
      const headers = getMarketplaceHeaders();
      const token = await getWorkspaceAccessToken();
      if (token) {
        headers.Authorization = "Bearer ".concat(token);
      }
      let request;
      try {
        request = await Apps.getMarketplaceClient().fetch("v1/categories", {
          headers
        });
      } catch (error) {
        throw new MarketplaceConnectionError('Marketplace_Bad_Marketplace_Connection');
      }
      if (request.status === 200) {
        const response = await request.json();
        fetchMarketplaceCategoriesSchema.parse(response);
        return response;
      }
      const response = await request.json();
      Apps.getRocketChatLogger().error('Failed to fetch marketplace categories', response);
      // TODO: Refactor cloud to return a proper error code on unsupported version
      if (request.status === 426 && 'errorMsg' in response && response.errorMsg === 'unsupported version') {
        throw new MarketplaceUnsupportedVersionError();
      }
      const INTERNAL_MARKETPLACE_ERROR_CODES = [189, 266];
      if (request.status === 500 && INTERNAL_MARKETPLACE_ERROR_CODES.includes(response.code)) {
        throw new MarketplaceAppsError('Marketplace_Internal_Error');
      }
      throw new MarketplaceAppsError('Marketplace_Failed_To_Fetch_Categories');
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"getMarketplaceHeaders.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/marketplace/getMarketplaceHeaders.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      getMarketplaceHeaders: () => getMarketplaceHeaders
    });
    let Info;
    module.link("../../../../app/utils/rocketchat.info", {
      Info(v) {
        Info = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    function getMarketplaceHeaders() {
      return {
        'X-Apps-Engine-Version': Info.marketplaceApiVersion.replace(/-.*/g, '')
      };
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"isTesting.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/marketplace/isTesting.ts                                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.export({
  isTesting: () => isTesting
});
function isTesting() {
  return process.env.TEST_MODE === 'true';
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"marketplaceErrors.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/marketplace/marketplaceErrors.ts                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.export({
  MarketplaceAppsError: () => MarketplaceAppsError,
  MarketplaceConnectionError: () => MarketplaceConnectionError,
  MarketplaceUnsupportedVersionError: () => MarketplaceUnsupportedVersionError
});
class MarketplaceAppsError extends Error {
  constructor(message) {
    super(message);
  }
}
class MarketplaceConnectionError extends Error {
  constructor(message) {
    super(message);
  }
}
class MarketplaceUnsupportedVersionError extends Error {
  constructor() {
    super('Marketplace_Unsupported_Version');
  }
}
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"storage":{"AppFileSystemSourceStorage.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/storage/AppFileSystemSourceStorage.ts                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      AppFileSystemSourceStorage: () => AppFileSystemSourceStorage
    });
    let fs;
    module.link("fs", {
      promises(v) {
        fs = v;
      }
    }, 0);
    let join, normalize;
    module.link("path", {
      join(v) {
        join = v;
      },
      normalize(v) {
        normalize = v;
      }
    }, 1);
    let AppSourceStorage;
    module.link("@rocket.chat/apps-engine/server/storage", {
      AppSourceStorage(v) {
        AppSourceStorage = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class AppFileSystemSourceStorage extends AppSourceStorage {
      constructor() {
        super(...arguments);
        this.pathPrefix = 'fs:/';
        this.path = void 0;
      }
      setPath(path) {
        this.path = path;
      }
      checkPath() {
        if (!this.path) {
          throw new Error('Invalid path configured for file system App storage');
        }
      }
      async store(item, zip) {
        this.checkPath();
        const filePath = this.itemToFilename(item);
        await fs.writeFile(filePath, zip);
        return this.filenameToSourcePath(filePath);
      }
      async fetch(item) {
        if (!item.sourcePath) {
          throw new Error('Invalid source path');
        }
        return fs.readFile(this.sourcePathToFilename(item.sourcePath));
      }
      async update(item, zip) {
        this.checkPath();
        const filePath = this.itemToFilename(item);
        await fs.writeFile(filePath, zip);
        return this.filenameToSourcePath(filePath);
      }
      async remove(item) {
        if (!item.sourcePath) {
          return;
        }
        return fs.unlink(this.sourcePathToFilename(item.sourcePath));
      }
      itemToFilename(item) {
        return "".concat(normalize(join(this.path, item.id)), ".zip");
      }
      filenameToSourcePath(filename) {
        return this.pathPrefix + filename;
      }
      sourcePathToFilename(sourcePath) {
        return sourcePath.substring(this.pathPrefix.length);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"AppGridFSSourceStorage.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/storage/AppGridFSSourceStorage.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      AppGridFSSourceStorage: () => AppGridFSSourceStorage
    });
    let AppSourceStorage;
    module.link("@rocket.chat/apps-engine/server/storage", {
      AppSourceStorage(v) {
        AppSourceStorage = v;
      }
    }, 0);
    let MongoInternals;
    module.link("meteor/mongo", {
      MongoInternals(v) {
        MongoInternals = v;
      }
    }, 1);
    let NpmModuleMongodb;
    module.link("meteor/npm-mongo", {
      NpmModuleMongodb(v) {
        NpmModuleMongodb = v;
      }
    }, 2);
    let ObjectId;
    module.link("mongodb", {
      ObjectId(v) {
        ObjectId = v;
      }
    }, 3);
    let streamToBuffer;
    module.link("../../../../app/file-upload/server/lib/streamToBuffer", {
      streamToBuffer(v) {
        streamToBuffer = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class AppGridFSSourceStorage extends AppSourceStorage {
      constructor() {
        super();
        this.pathPrefix = 'GridFS:/';
        this.bucket = void 0;
        const {
          db
        } = MongoInternals.defaultRemoteCollectionDriver().mongo;
        this.bucket = new NpmModuleMongodb.GridFSBucket(db, {
          bucketName: 'rocketchat_apps_packages',
          chunkSizeBytes: 1024 * 255
        });
      }
      async store(item, zip) {
        return new Promise((resolve, reject) => {
          const filename = this.itemToFilename(item);
          const writeStream = this.bucket.openUploadStream(filename).on('finish', () => resolve(this.idToPath(writeStream.id))).on('error', error => reject(error));
          writeStream.write(zip);
          writeStream.end();
        });
      }
      async fetch(item) {
        return streamToBuffer(this.bucket.openDownloadStream(this.itemToObjectId(item)));
      }
      async update(item, zip) {
        return new Promise((resolve, reject) => {
          const fileId = this.itemToFilename(item);
          const writeStream = this.bucket.openUploadStream(fileId).on('finish', () => {
            resolve(this.idToPath(writeStream.id));
            // An error in the following line would not cause the update process to fail
            // eslint-disable-next-line @typescript-eslint/no-empty-function
            this.remove(item).catch(() => {});
          }).on('error', error => reject(error));
          writeStream.write(zip);
          writeStream.end();
        });
      }
      async remove(item) {
        try {
          await this.bucket.delete(this.itemToObjectId(item));
        } catch (error) {
          if (error.message.includes('File not found for id')) {
            console.warn("This instance could not remove the ".concat(item.info.name, " app package. If you are running Rocket.Chat in a cluster with multiple instances, possibly other instance removed the package. If this is not the case, it is possible that the file in the database got renamed or removed manually."));
            return;
          }
          throw error;
        }
      }
      itemToFilename(item) {
        return "".concat(item.info.nameSlug, "-").concat(item.info.version, ".package");
      }
      idToPath(id) {
        return this.pathPrefix + id;
      }
      itemToObjectId(item) {
        var _item$sourcePath;
        return new ObjectId((_item$sourcePath = item.sourcePath) === null || _item$sourcePath === void 0 ? void 0 : _item$sourcePath.substring(this.pathPrefix.length));
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"AppRealLogStorage.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/storage/AppRealLogStorage.ts                                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      AppRealLogStorage: () => AppRealLogStorage
    });
    let AppLogStorage;
    module.link("@rocket.chat/apps-engine/server/storage", {
      AppLogStorage(v) {
        AppLogStorage = v;
      }
    }, 0);
    let InstanceStatus;
    module.link("@rocket.chat/instance-status", {
      InstanceStatus(v) {
        InstanceStatus = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class AppRealLogStorage extends AppLogStorage {
      constructor(db) {
        super('mongodb');
        this.db = void 0;
        this.db = db;
      }
      async find(query, options) {
        return this.db.find(query, options).toArray();
      }
      async findPaginated(query, options) {
        const {
          cursor,
          totalCount
        } = this.db.findPaginated(query, options);
        const [logs, total] = await Promise.all([cursor.toArray(), totalCount]);
        return {
          logs,
          total
        };
      }
      async distinctValues(appId) {
        return this.db.getDistinctFieldsForFilters(appId);
      }
      async storeEntries(logEntry) {
        logEntry.instanceId = InstanceStatus.id();
        const id = (await this.db.insertOne(logEntry)).insertedId;
        return this.db.findOneById(id);
      }
      async getEntriesFor(appId) {
        return this.db.find({
          appId
        }).toArray();
      }
      async removeEntriesFor(appId) {
        await this.db.deleteOne({
          appId
        });
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"AppRealStorage.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/storage/AppRealStorage.ts                                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectWithoutProperties;
    module.link("@babel/runtime/helpers/objectWithoutProperties", {
      default(v) {
        _objectWithoutProperties = v;
      }
    }, 0);
    const _excluded = ["_id"];
    module.export({
      AppRealStorage: () => AppRealStorage
    });
    let AppMetadataStorage;
    module.link("@rocket.chat/apps-engine/server/storage", {
      AppMetadataStorage(v) {
        AppMetadataStorage = v;
      }
    }, 0);
    let removeEmpty;
    module.link("@rocket.chat/tools", {
      removeEmpty(v) {
        removeEmpty = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class AppRealStorage extends AppMetadataStorage {
      constructor(db) {
        super('mongodb');
        this.db = void 0;
        this.db = db;
      }
      async create(item) {
        item.createdAt = new Date();
        item.updatedAt = new Date();
        const doc = await this.db.findOne({
          $or: [{
            id: item.id
          }, {
            'info.nameSlug': item.info.nameSlug
          }]
        });
        if (doc) {
          throw new Error('App already exists.');
        }
        const nonEmptyItem = removeEmpty(item);
        const id = (await this.db.insertOne(nonEmptyItem)).insertedId;
        nonEmptyItem._id = id;
        return nonEmptyItem;
      }
      async retrieveOne(id) {
        return this.db.findOne({
          $or: [{
            _id: id
          }, {
            id
          }]
        });
      }
      async retrieveAll() {
        const docs = await this.db.find({}).toArray();
        const items = new Map();
        docs.forEach(i => items.set(i.id, i));
        return items;
      }
      async retrieveAllPrivate() {
        const docs = await this.db.find({
          installationSource: 'private'
        }).toArray();
        const items = new Map();
        docs.forEach(i => items.set(i.id, i));
        return items;
      }
      async remove(id) {
        await this.db.deleteOne({
          id
        });
        return {
          success: true
        };
      }
      async updatePartialAndReturnDocument(_ref) {
        let {
          unsetPermissionsGranted = false
        } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        let {
            _id
          } = _ref,
          item = _objectWithoutProperties(_ref, _excluded);
        if (!_id) {
          throw new Error('Property _id is required to update an app storage item');
        }
        const updateQuery = {
          $set: item
        };
        if (unsetPermissionsGranted) {
          delete item.permissionsGranted;
          updateQuery.$unset = {
            permissionsGranted: 1
          };
        }
        return this.db.findOneAndUpdate({
          _id
        }, updateQuery, {
          returnDocument: 'after'
        });
      }
      async updateStatus(_id, status) {
        const result = await this.db.updateOne({
          _id
        }, {
          $set: {
            status
          }
        });
        return result.modifiedCount > 0;
      }
      async updateSetting(_id, setting) {
        const result = await this.db.updateOne({
          _id
        }, {
          $set: {
            ["settings.".concat(setting.id)]: setting
          }
        });
        return result.modifiedCount > 0;
      }
      async updateAppInfo(_id, info) {
        const result = await this.db.updateOne({
          _id
        }, {
          $set: {
            info
          }
        });
        return result.modifiedCount > 0;
      }
      async updateMarketplaceInfo(_id, marketplaceInfo) {
        const result = await this.db.updateOne({
          _id
        }, {
          $set: {
            marketplaceInfo
          }
        });
        return result.modifiedCount > 0;
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"ConfigurableAppSourceStorage.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/storage/ConfigurableAppSourceStorage.ts                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      ConfigurableAppSourceStorage: () => ConfigurableAppSourceStorage
    });
    let AppSourceStorage;
    module.link("@rocket.chat/apps-engine/server/storage", {
      AppSourceStorage(v) {
        AppSourceStorage = v;
      }
    }, 0);
    let AppFileSystemSourceStorage;
    module.link("./AppFileSystemSourceStorage", {
      AppFileSystemSourceStorage(v) {
        AppFileSystemSourceStorage = v;
      }
    }, 1);
    let AppGridFSSourceStorage;
    module.link("./AppGridFSSourceStorage", {
      AppGridFSSourceStorage(v) {
        AppGridFSSourceStorage = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class ConfigurableAppSourceStorage extends AppSourceStorage {
      constructor(storageType, filesystemStoragePath) {
        super();
        this.storageType = void 0;
        this.filesystem = void 0;
        this.gridfs = void 0;
        this.storage = void 0;
        this.storageType = storageType;
        this.filesystem = new AppFileSystemSourceStorage();
        this.gridfs = new AppGridFSSourceStorage();
        this.setStorage(storageType);
        this.setFileSystemStoragePath(filesystemStoragePath);
      }
      setStorage(type) {
        switch (type) {
          case 'filesystem':
            this.storage = this.filesystem;
            break;
          case 'gridfs':
            this.storage = this.gridfs;
            break;
        }
      }
      setFileSystemStoragePath(path) {
        this.filesystem.setPath(path);
      }
      async store(item, zip) {
        return this.storage.store(item, zip);
      }
      async fetch(item) {
        return this.storage.fetch(item);
      }
      async update(item, zip) {
        return this.storage.update(item, zip);
      }
      async remove(item) {
        return this.storage.remove(item);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/storage/index.ts                                                                                     //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./AppFileSystemSourceStorage");
    module.link("./AppGridFSSourceStorage");
    module.link("./AppRealLogStorage", {
      AppRealLogStorage: "AppRealLogStorage"
    }, 0);
    module.link("./AppRealStorage", {
      AppRealStorage: "AppRealStorage"
    }, 1);
    module.link("./ConfigurableAppSourceStorage", {
      ConfigurableAppSourceStorage: "ConfigurableAppSourceStorage"
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"appRequestsCron.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/appRequestsCron.ts                                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 1);
    let cronJobs;
    module.link("@rocket.chat/cron", {
      cronJobs(v) {
        cronJobs = v;
      }
    }, 0);
    let appRequestNotififyForUsers;
    module.link("./marketplace/appRequestNotifyUsers", {
      appRequestNotififyForUsers(v) {
        appRequestNotififyForUsers = v;
      }
    }, 1);
    let Apps;
    module.link("./orchestrator", {
      Apps(v) {
        Apps = v;
      }
    }, 2);
    let getWorkspaceAccessToken;
    module.link("../../../app/cloud/server", {
      getWorkspaceAccessToken(v) {
        getWorkspaceAccessToken = v;
      }
    }, 3);
    let settings;
    module.link("../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 4);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const appsNotifyAppRequests = async function _appsNotifyAppRequests() {
      try {
        const installedApps = await Apps.installedApps({
          enabled: true
        });
        if (!installedApps || installedApps.length === 0) {
          return;
        }
        const workspaceUrl = settings.get('Site_Url');
        const token = await getWorkspaceAccessToken();
        if (!token) {
          Apps.debugLog("could not load workspace token to send app requests notifications");
          return;
        }
        const options = {
          headers: {
            Authorization: "Bearer ".concat(token)
          }
        };
        const pendingSentUrl = "v1/app-request/sent/pending";
        const result = await Apps.getMarketplaceClient().fetch(pendingSentUrl, options);
        const {
          data
        } = await result.json();
        const filtered = installedApps.filter(app => data.indexOf(app.getID()) !== -1);
        var _iteratorAbruptCompletion = false;
        var _didIteratorError = false;
        var _iteratorError;
        try {
          for (var _iterator = _asyncIterator(filtered), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
            const app = _step.value;
            {
              const appId = app.getID();
              const appName = app.getName();
              const usersNotified = await appRequestNotififyForUsers(Apps.getMarketplaceClient().getMarketplaceUrl(), workspaceUrl, appId, appName).then(async response => {
                // Mark all app requests as sent
                await Apps.getMarketplaceClient().fetch("v1/app-request/markAsSent/".concat(appId), _objectSpread(_objectSpread({}, options), {}, {
                  method: 'POST'
                }));
                return response;
              }).catch(err => {
                Apps.debugLog("could not send app request notifications for app ".concat(appId, ". Error: ").concat(err));
                return err;
              });
              const errors = usersNotified.filter(batch => batch instanceof Error);
              if (errors.length > 0) {
                Apps.debugLog("Some batches of users could not be notified for app ".concat(appId, ". Errors: ").concat(errors));
              }
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion && _iterator.return != null) {
              await _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      } catch (err) {
        Apps.debugLog(err);
      }
    };
    await cronJobs.add('Apps-Request-End-Users:notify', '0 */12 * * *', async () => appsNotifyAppRequests());
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"cron.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/cron.ts                                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let AppStatus;
    module.link("@rocket.chat/apps-engine/definition/AppStatus", {
      AppStatus(v) {
        AppStatus = v;
      }
    }, 0);
    let cronJobs;
    module.link("@rocket.chat/cron", {
      cronJobs(v) {
        cronJobs = v;
      }
    }, 1);
    let Settings, Users;
    module.link("@rocket.chat/models", {
      Settings(v) {
        Settings = v;
      },
      Users(v) {
        Users = v;
      }
    }, 2);
    let Apps;
    module.link("./orchestrator", {
      Apps(v) {
        Apps = v;
      }
    }, 3);
    let getWorkspaceAccessToken;
    module.link("../../../app/cloud/server", {
      getWorkspaceAccessToken(v) {
        getWorkspaceAccessToken = v;
      }
    }, 4);
    let i18n;
    module.link("../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 5);
    let sendMessagesToAdmins;
    module.link("../../../server/lib/sendMessagesToAdmins", {
      sendMessagesToAdmins(v) {
        sendMessagesToAdmins = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const notifyAdminsAboutInvalidApps = async function _notifyAdminsAboutInvalidApps(apps) {
      if (!apps) {
        return;
      }
      const hasInvalidApps = !!apps.find(app => app.getLatestLicenseValidationResult().hasErrors);
      if (!hasInvalidApps) {
        return;
      }
      const id = 'someAppInInvalidState';
      const title = 'Warning';
      const link = '/marketplace/installed';
      await sendMessagesToAdmins({
        msgs: async _ref => {
          let {
            adminUser
          } = _ref;
          return {
            msg: "*".concat(i18n.t(title, {
              lng: adminUser.language || 'en'
            }), "*\n").concat(i18n.t('Invalid_apps_admin_message', {
              lng: adminUser.language || 'en',
              marketplace: i18n.t('Marketplace', {
                lng: adminUser.language || 'en'
              }),
              installed: i18n.t('Installed', {
                lng: adminUser.language || 'en'
              })
            }))
          };
        },
        banners: async _ref2 => {
          let {
            adminUser
          } = _ref2;
          await Users.removeBannerById(adminUser._id, id);
          return [{
            id,
            priority: 10,
            title,
            text: i18n.t('Invalid_apps_banner_text', {
              lng: adminUser.language || 'en'
            }),
            modifiers: ['danger'],
            link
          }];
        }
      });
      return apps;
    };
    const notifyAdminsAboutRenewedApps = async function _notifyAdminsAboutRenewedApps(apps) {
      if (!apps) {
        return;
      }
      const renewedApps = apps.filter(async app => (await app.getStatus()) === AppStatus.DISABLED && app.getPreviousStatus() === AppStatus.INVALID_LICENSE_DISABLED);
      if (renewedApps.length === 0) {
        return;
      }
      await sendMessagesToAdmins({
        msgs: async _ref3 => {
          let {
            adminUser
          } = _ref3;
          return {
            msg: i18n.t('Disabled_apps_admin_message', {
              lng: adminUser.language || 'en',
              marketplace: i18n.t('Marketplace', {
                lng: adminUser.language || 'en'
              }),
              installed: i18n.t('Installed', {
                lng: adminUser.language || 'en'
              })
            })
          };
        }
      });
    };
    const appsUpdateMarketplaceInfo = async function _appsUpdateMarketplaceInfo() {
      const token = await getWorkspaceAccessToken();
      const workspaceIdSetting = await Settings.getValueById('Cloud_Workspace_Id');
      const currentSeats = await Users.getActiveLocalUserCount();
      const fullUrl = "v1/workspaces/".concat(workspaceIdSetting, "/apps");
      const options = {
        headers: {
          Authorization: "Bearer ".concat(token)
        },
        params: {
          seats: currentSeats
        }
      };
      let data = [];
      try {
        const response = await Apps.getMarketplaceClient().fetch(fullUrl, options);
        const result = await response.json();
        if (Array.isArray(result)) {
          data = result;
        }
      } catch (err) {
        Apps.debugLog(err);
      }
      await Apps.updateAppsMarketplaceInfo(data).then(notifyAdminsAboutInvalidApps).then(notifyAdminsAboutRenewedApps);
    };
    await cronJobs.add('Apps-Engine:check', '0 4 * * *', async () => appsUpdateMarketplaceInfo());
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: true
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/index.ts                                                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./cron");
    module.link("./appRequestsCron");
    module.link("./orchestrator", {
      Apps: "Apps"
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"orchestrator.js":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/orchestrator.js                                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 0);
    module.export({
      AppServerOrchestrator: () => AppServerOrchestrator,
      Apps: () => Apps
    });
    let registerOrchestrator;
    module.link("@rocket.chat/apps", {
      registerOrchestrator(v) {
        registerOrchestrator = v;
      }
    }, 0);
    let EssentialAppDisabledException;
    module.link("@rocket.chat/apps-engine/definition/exceptions", {
      EssentialAppDisabledException(v) {
        EssentialAppDisabledException = v;
      }
    }, 1);
    let AppManager;
    module.link("@rocket.chat/apps-engine/server/AppManager", {
      AppManager(v) {
        AppManager = v;
      }
    }, 2);
    let Logger;
    module.link("@rocket.chat/logger", {
      Logger(v) {
        Logger = v;
      }
    }, 3);
    let AppLogs, AppsModel, AppsPersistence, Statistics;
    module.link("@rocket.chat/models", {
      AppLogs(v) {
        AppLogs = v;
      },
      Apps(v) {
        AppsModel = v;
      },
      AppsPersistence(v) {
        AppsPersistence = v;
      },
      Statistics(v) {
        Statistics = v;
      }
    }, 4);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 5);
    let AppServerNotifier, AppsRestApi, AppUIKitInteractionApi;
    module.link("./communication", {
      AppServerNotifier(v) {
        AppServerNotifier = v;
      },
      AppsRestApi(v) {
        AppsRestApi = v;
      },
      AppUIKitInteractionApi(v) {
        AppUIKitInteractionApi = v;
      }
    }, 6);
    let MarketplaceAPIClient;
    module.link("./marketplace/MarketplaceAPIClient", {
      MarketplaceAPIClient(v) {
        MarketplaceAPIClient = v;
      }
    }, 7);
    let isTesting;
    module.link("./marketplace/isTesting", {
      isTesting(v) {
        isTesting = v;
      }
    }, 8);
    let AppRealLogStorage, AppRealStorage, ConfigurableAppSourceStorage;
    module.link("./storage", {
      AppRealLogStorage(v) {
        AppRealLogStorage = v;
      },
      AppRealStorage(v) {
        AppRealStorage = v;
      },
      ConfigurableAppSourceStorage(v) {
        ConfigurableAppSourceStorage = v;
      }
    }, 9);
    let RealAppBridges;
    module.link("../../../app/apps/server/bridges", {
      RealAppBridges(v) {
        RealAppBridges = v;
      }
    }, 10);
    let AppMessagesConverter, AppRoomsConverter, AppSettingsConverter, AppUsersConverter, AppVideoConferencesConverter, AppDepartmentsConverter, AppUploadsConverter, AppVisitorsConverter, AppRolesConverter, AppContactsConverter;
    module.link("../../../app/apps/server/converters", {
      AppMessagesConverter(v) {
        AppMessagesConverter = v;
      },
      AppRoomsConverter(v) {
        AppRoomsConverter = v;
      },
      AppSettingsConverter(v) {
        AppSettingsConverter = v;
      },
      AppUsersConverter(v) {
        AppUsersConverter = v;
      },
      AppVideoConferencesConverter(v) {
        AppVideoConferencesConverter = v;
      },
      AppDepartmentsConverter(v) {
        AppDepartmentsConverter = v;
      },
      AppUploadsConverter(v) {
        AppUploadsConverter = v;
      },
      AppVisitorsConverter(v) {
        AppVisitorsConverter = v;
      },
      AppRolesConverter(v) {
        AppRolesConverter = v;
      },
      AppContactsConverter(v) {
        AppContactsConverter = v;
      }
    }, 11);
    let AppThreadsConverter;
    module.link("../../../app/apps/server/converters/threads", {
      AppThreadsConverter(v) {
        AppThreadsConverter = v;
      }
    }, 12);
    let settings;
    module.link("../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 13);
    let canEnableApp;
    module.link("../../app/license/server/canEnableApp", {
      canEnableApp(v) {
        canEnableApp = v;
      }
    }, 14);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const DISABLED_PRIVATE_APP_INSTALLATION = ['yes', 'true'].includes(String(process.env.DISABLE_PRIVATE_APP_INSTALLATION).toLowerCase());
    class AppServerOrchestrator {
      constructor() {
        this._isInitialized = false;
        this.marketplaceClient = new MarketplaceAPIClient();
      }
      initialize() {
        if (this._isInitialized) {
          return;
        }
        this._rocketchatLogger = new Logger('Rocket.Chat Apps');
        this._model = AppsModel;
        this._logModel = AppLogs;
        this._persistModel = AppsPersistence;
        this._statisticsModel = Statistics;
        this._storage = new AppRealStorage(this._model);
        this._logStorage = new AppRealLogStorage(this._logModel);
        this._appSourceStorage = new ConfigurableAppSourceStorage(settings.get('Apps_Framework_Source_Package_Storage_Type'), settings.get('Apps_Framework_Source_Package_Storage_FileSystem_Path'));
        this._converters = new Map();
        this._converters.set('messages', new AppMessagesConverter(this));
        this._converters.set('rooms', new AppRoomsConverter(this));
        this._converters.set('settings', new AppSettingsConverter(this));
        this._converters.set('users', new AppUsersConverter(this));
        this._converters.set('visitors', new AppVisitorsConverter(this));
        this._converters.set('contacts', new AppContactsConverter(this));
        this._converters.set('departments', new AppDepartmentsConverter(this));
        this._converters.set('uploads', new AppUploadsConverter(this));
        this._converters.set('videoConferences', new AppVideoConferencesConverter());
        this._converters.set('threads', new AppThreadsConverter(this));
        this._converters.set('roles', new AppRolesConverter(this));
        this._bridges = new RealAppBridges(this);
        this._manager = new AppManager({
          metadataStorage: this._storage,
          logStorage: this._logStorage,
          bridges: this._bridges,
          sourceStorage: this._appSourceStorage
        });
        this._communicators = new Map();
        this._communicators.set('notifier', new AppServerNotifier(this));
        this._communicators.set('restapi', new AppsRestApi(this, this._manager));
        this._communicators.set('uikit', new AppUIKitInteractionApi(this));
        this._isInitialized = true;
      }
      getMarketplaceClient() {
        return this.marketplaceClient;
      }
      getModel() {
        return this._model;
      }

      /**
       * @returns {AppsPersistenceModel}
       */
      getPersistenceModel() {
        return this._persistModel;
      }
      getStatisticsModel() {
        return this._statisticsModel;
      }
      getStorage() {
        return this._storage;
      }
      getLogStorage() {
        if (!this._logStorage) {
          throw new Error('Apps-Engine not yet fully initialized');
        }
        return this._logStorage;
      }
      getConverters() {
        return this._converters;
      }
      getBridges() {
        return this._bridges;
      }
      getNotifier() {
        return this._communicators.get('notifier');
      }
      getManager() {
        return this._manager;
      }
      getProvidedComponents() {
        return this._manager.getExternalComponentManager().getProvidedComponents();
      }
      getAppSourceStorage() {
        return this._appSourceStorage;
      }
      isInitialized() {
        return this._isInitialized;
      }
      isLoaded() {
        return this.getManager().areAppsLoaded();
      }
      isDebugging() {
        return !isTesting();
      }
      shouldDisablePrivateAppInstallation() {
        return DISABLED_PRIVATE_APP_INSTALLATION;
      }

      /**
       * @returns {Logger}
       */
      getRocketChatLogger() {
        return this._rocketchatLogger;
      }
      debugLog() {
        if (this.isDebugging()) {
          this.getRocketChatLogger().debug(...arguments);
        }
      }
      async load() {
        // Don't try to load it again if it has
        // already been loaded
        if (this.isLoaded()) {
          return;
        }
        await this.getManager().load();

        // Before enabling each app we verify if there is still room for it
        const apps = await this.getManager().get();

        // This needs to happen sequentially to keep track of app limits
        var _iteratorAbruptCompletion = false;
        var _didIteratorError = false;
        var _iteratorError;
        try {
          for (var _iterator = _asyncIterator(apps), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
            const app = _step.value;
            {
              try {
                await canEnableApp(app.getStorageItem());
                await this.getManager().loadOne(app.getID(), true);
              } catch (error) {
                this._rocketchatLogger.warn("App \"".concat(app.getInfo().name, "\" could not be enabled: "), error.message);
              }
            }
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion && _iterator.return != null) {
              await _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
        await this.getBridges().getSchedulerBridge().startScheduler();
        const appCount = (await this.getManager().get({
          enabled: true
        })).length;
        this._rocketchatLogger.info("Loaded the Apps Framework and loaded a total of ".concat(appCount, " Apps!"));
      }
      async migratePrivateApps() {
        const apps = await this.getManager().get({
          installationSource: 'private'
        });
        await Promise.all(apps.map(app => this.getManager().migrate(app.getID())));
        await Promise.all(apps.map(app => this.getNotifier().appUpdated(app.getID())));
      }
      async findMajorVersionUpgradeDate() {
        let targetVersion = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 7;
        let upgradeToV7Date = null;
        let hadPreTargetVersion = false;
        try {
          const statistics = await this.getStatisticsModel().findInstallationDates();
          if (!statistics || statistics.length === 0) {
            this._rocketchatLogger.info('No statistics found');
            return upgradeToV7Date;
          }
          const statsAscendingByInstallDate = statistics.sort((a, b) => new Date(a.installedAt) - new Date(b.installedAt));
          for (const stat of statsAscendingByInstallDate) {
            const version = stat.version || '';
            if (!version) {
              continue;
            }
            const majorVersion = parseInt(version.split('.')[0], 10);
            if (isNaN(majorVersion)) {
              continue;
            }
            if (majorVersion < targetVersion) {
              hadPreTargetVersion = true;
            }
            if (hadPreTargetVersion && majorVersion >= targetVersion) {
              upgradeToV7Date = new Date(stat.installedAt);
              this._rocketchatLogger.info("Found upgrade to v".concat(targetVersion, " date: ").concat(upgradeToV7Date.toISOString()));
              break;
            }
          }
        } catch (error) {
          this._rocketchatLogger.error('Error checking statistics for version history:', error.message);
        }
        return upgradeToV7Date;
      }
      async disableMarketplaceApps() {
        return this.disableApps('marketplace', false, 5);
      }
      async disablePrivateApps() {
        return this.disableApps('private', true, 0);
      }
      async disableApps(installationSource, grandfatherApps, maxApps) {
        const upgradeToV7Date = await this.findMajorVersionUpgradeDate();
        const apps = await this.getManager().get({
          installationSource
        });
        const grandfathered = [];
        const toKeep = [];
        const toDisable = [];
        for (const app of apps) {
          const storageItem = app.getStorageItem();
          const isEnabled = ['enabled', 'manually_enabled', 'auto_enabled'].includes(storageItem.status);
          const marketplaceInfo = storageItem.marketplaceInfo && storageItem.marketplaceInfo[0];
          const wasInstalledBeforeV7 = upgradeToV7Date && storageItem.createdAt && new Date(storageItem.createdAt) < upgradeToV7Date;
          if (wasInstalledBeforeV7 && isEnabled && grandfatherApps) {
            grandfathered.push(app);
            continue;
          }
          if ((marketplaceInfo === null || marketplaceInfo === void 0 ? void 0 : marketplaceInfo.isEnterpriseOnly) === true && installationSource === 'marketplace') {
            toDisable.push(app);
            continue;
          }
          if (isEnabled) {
            toKeep.push(app);
          }
        }
        toKeep.sort((a, b) => new Date(a.getStorageItem().createdAt || 0) - new Date(b.getStorageItem().createdAt || 0));
        if (toKeep.length > maxApps) {
          toDisable.push(...toKeep.splice(maxApps));
        }
        if (toDisable.length === 0) {
          return;
        }
        const disablePromises = toDisable.map(app => {
          const appId = app.getID();
          return this.getManager().disable(appId);
        });
        try {
          await Promise.all(disablePromises);
          this._rocketchatLogger.info("".concat(installationSource, " apps processing complete - kept ").concat(grandfathered.length + toKeep.length, ", disabled ").concat(toDisable.length));
        } catch (error) {
          this._rocketchatLogger.error('Error disabling apps:', error.message);
        }
      }
      async unload() {
        // Don't try to unload it if it's already been
        // unlaoded or wasn't unloaded to start with
        if (!this.isLoaded()) {
          return;
        }
        return this._manager.unload().then(() => this._rocketchatLogger.info('Unloaded the Apps Framework.')).catch(err => this._rocketchatLogger.error({
          msg: 'Failed to unload the Apps Framework!',
          err
        }));
      }
      async updateAppsMarketplaceInfo() {
        let apps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        if (!this.isLoaded()) {
          return;
        }
        return this._manager.updateAppsMarketplaceInfo(apps).then(() => this._manager.get());
      }
      async installedApps() {
        let filter = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        if (!this.isLoaded()) {
          return;
        }
        return this._manager.get(filter);
      }
      async triggerEvent(event) {
        if (!this.isLoaded()) {
          return;
        }
        for (var _len = arguments.length, payload = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          payload[_key - 1] = arguments[_key];
        }
        return this.getBridges().getListenerBridge().handleEvent(event, ...payload).catch(error => {
          if (error instanceof EssentialAppDisabledException) {
            throw new Meteor.Error('error-essential-app-disabled');
          }
          throw error;
        });
      }
    }
    const Apps = new AppServerOrchestrator();
    registerOrchestrator(Apps);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"startup.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/apps/startup.ts                                                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      startupApp: () => startupApp
    });
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let Apps;
    module.link("./orchestrator", {
      Apps(v) {
        Apps = v;
      }
    }, 1);
    let settings, settingsRegistry;
    module.link("../../../app/settings/server", {
      settings(v) {
        settings = v;
      },
      settingsRegistry(v) {
        settingsRegistry = v;
      }
    }, 2);
    let disableAppsWithAddonsCallback;
    module.link("../lib/apps/disableAppsWithAddonsCallback", {
      disableAppsWithAddonsCallback(v) {
        disableAppsWithAddonsCallback = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const startupApp = async function startupApp() {
      await settingsRegistry.addGroup('General', async function () {
        await this.section('Apps', async function () {
          await this.add('Apps_Logs_TTL', '30_days', {
            type: 'select',
            values: [{
              key: '7_days',
              i18nLabel: 'Apps_Logs_TTL_7days'
            }, {
              key: '14_days',
              i18nLabel: 'Apps_Logs_TTL_14days'
            }, {
              key: '30_days',
              i18nLabel: 'Apps_Logs_TTL_30days'
            }],
            public: true,
            hidden: true,
            alert: 'Apps_Logs_TTL_Alert'
          });
          await this.add('Apps_Framework_Source_Package_Storage_Type', 'gridfs', {
            type: 'select',
            values: [{
              key: 'gridfs',
              i18nLabel: 'GridFS'
            }, {
              key: 'filesystem',
              i18nLabel: 'FileSystem'
            }],
            public: true,
            hidden: false,
            alert: 'Apps_Framework_Source_Package_Storage_Type_Alert'
          });
          await this.add('Apps_Framework_Source_Package_Storage_FileSystem_Path', '', {
            type: 'string',
            public: true,
            enableQuery: {
              _id: 'Apps_Framework_Source_Package_Storage_Type',
              value: 'filesystem'
            },
            alert: 'Apps_Framework_Source_Package_Storage_FileSystem_Alert'
          });
        });
      });
      async function migratePrivateAppsCallback() {
        void Apps.migratePrivateApps();
        void Apps.disablePrivateApps();
        void Apps.disableMarketplaceApps();
      }
      License.onInvalidateLicense(migratePrivateAppsCallback);
      License.onRemoveLicense(migratePrivateAppsCallback);
      // Disable apps that depend on add-ons (external modules) if they are invalidated
      License.onModule(disableAppsWithAddonsCallback);
      Apps.initialize();
      void Apps.load();
      settings.change('Apps_Framework_Source_Package_Storage_Type', value => {
        var _Apps$getAppSourceSto;
        return (_Apps$getAppSourceSto = Apps.getAppSourceStorage()) === null || _Apps$getAppSourceSto === void 0 ? void 0 : _Apps$getAppSourceSto.setStorage(value);
      });
      settings.change('Apps_Framework_Source_Package_Storage_FileSystem_Path', value => {
        var _Apps$getAppSourceSto2;
        return (_Apps$getAppSourceSto2 = Apps.getAppSourceStorage()) === null || _Apps$getAppSourceSto2 === void 0 ? void 0 : _Apps$getAppSourceSto2.setFileSystemStoragePath(value);
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"lib":{"apps":{"disableAppsWithAddonsCallback.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/apps/disableAppsWithAddonsCallback.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module1, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module1.export({
      _disableAppsWithAddonsCallback: () => _disableAppsWithAddonsCallback,
      disableAppsWithAddonsCallback: () => disableAppsWithAddonsCallback
    });
    let AppStatus;
    module1.link("@rocket.chat/apps-engine/definition/AppStatus", {
      AppStatus(v) {
        AppStatus = v;
      }
    }, 0);
    let i18n;
    module1.link("../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 1);
    let sendMessagesToAdmins;
    module1.link("../../../../server/lib/sendMessagesToAdmins", {
      sendMessagesToAdmins(v) {
        sendMessagesToAdmins = v;
      }
    }, 2);
    let Apps;
    module1.link("../../apps", {
      Apps(v) {
        Apps = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    async function _disableAppsWithAddonsCallback(deps, _ref) {
      let {
        module,
        external,
        valid
      } = _ref;
      if (!external || valid) return;
      const enabledApps = await deps.Apps.installedApps({
        enabled: true
      });
      if (!enabledApps) return;
      const affectedApps = [];
      await Promise.all(enabledApps.map(async app => {
        var _deps$Apps$getManager;
        if (app.getInfo().addon !== module) return;
        affectedApps.push(app.getName());
        return (_deps$Apps$getManager = deps.Apps.getManager()) === null || _deps$Apps$getManager === void 0 ? void 0 : _deps$Apps$getManager.disable(app.getID(), AppStatus.DISABLED, false);
      }));
      if (!affectedApps.length) return;
      await deps.sendMessagesToAdmins({
        msgs: async _ref2 => {
          let {
            adminUser
          } = _ref2;
          return {
            msg: i18n.t('App_has_been_disabled_addon_message', {
              lng: adminUser.language || 'en',
              count: affectedApps.length,
              appNames: affectedApps
            })
          };
        }
      });
    }
    const disableAppsWithAddonsCallback = ctx => _disableAppsWithAddonsCallback({
      Apps,
      sendMessagesToAdmins
    }, ctx);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"audit":{"methods.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/audit/methods.ts                                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let LivechatRooms, Messages, Rooms, Users, AuditLog;
    module.link("@rocket.chat/models", {
      LivechatRooms(v) {
        LivechatRooms = v;
      },
      Messages(v) {
        Messages = v;
      },
      Rooms(v) {
        Rooms = v;
      },
      Users(v) {
        Users = v;
      },
      AuditLog(v) {
        AuditLog = v;
      }
    }, 0);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 1);
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 2);
    let DDPRateLimiter;
    module.link("meteor/ddp-rate-limiter", {
      DDPRateLimiter(v) {
        DDPRateLimiter = v;
      }
    }, 3);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 4);
    let hasPermissionAsync;
    module.link("../../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 5);
    let updateCounter;
    module.link("../../../../app/statistics/server", {
      updateCounter(v) {
        updateCounter = v;
      }
    }, 6);
    let callbacks;
    module.link("../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 7);
    let isTruthy;
    module.link("../../../../lib/isTruthy", {
      isTruthy(v) {
        isTruthy = v;
      }
    }, 8);
    let i18n;
    module.link("../../../../server/lib/i18n", {
      i18n(v) {
        i18n = v;
      }
    }, 9);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const getValue = room => room && {
      rids: [room._id],
      name: room.name
    };
    const getUsersIdFromUserName = async usernames => {
      const users = usernames ? await Users.findByUsernames(usernames.filter(isTruthy)).toArray() : undefined;
      return users === null || users === void 0 ? void 0 : users.filter(isTruthy).map(userId => userId._id);
    };
    const getRoomInfoByAuditParams = async _ref => {
      let {
        type,
        roomId: rid,
        users: usernames,
        visitor,
        agent,
        userId
      } = _ref;
      if (rid) {
        return getValue(await Rooms.findOne({
          _id: rid
        }));
      }
      if (type === 'd') {
        return getValue(await Rooms.findDirectRoomContainingAllUsernames(usernames));
      }
      if (type === 'l') {
        console.warn('Deprecation Warning! This method will be removed in the next version (4.0.0)');
        const extraQuery = await callbacks.run('livechat.applyRoomRestrictions', {}, {
          userId
        });
        const rooms = await LivechatRooms.findByVisitorIdAndAgentId(visitor, agent, {
          projection: {
            _id: 1
          }
        }, extraQuery).toArray();
        return rooms !== null && rooms !== void 0 && rooms.length ? {
          rids: rooms.map(_ref2 => {
            let {
              _id
            } = _ref2;
            return _id;
          }),
          name: i18n.t('Omnichannel')
        } : undefined;
      }
    };
    Meteor.methods({
      async auditGetOmnichannelMessages(_ref3) {
        let {
          startDate,
          endDate,
          users: usernames,
          msg,
          type,
          visitor,
          agent
        } = _ref3;
        check(startDate, Date);
        check(endDate, Date);
        const user = await Meteor.userAsync();
        if (!user || !(await hasPermissionAsync(user._id, 'can-audit'))) {
          throw new Meteor.Error('Not allowed');
        }
        const userFields = _objectSpread(_objectSpread({
          _id: user._id,
          username: user.username
        }, user.name && {
          name: user.name
        }), user.avatarETag && {
          avatarETag: user.avatarETag
        });
        const rooms = await LivechatRooms.findByVisitorIdAndAgentId(visitor, agent, {
          projection: {
            _id: 1
          }
        }).toArray();
        const rids = rooms !== null && rooms !== void 0 && rooms.length ? rooms.map(_ref4 => {
          let {
            _id
          } = _ref4;
          return _id;
        }) : undefined;
        const name = i18n.t('Omnichannel');
        const query = {
          rid: {
            $in: rids
          },
          ts: {
            $gt: startDate,
            $lt: endDate
          }
        };
        if (msg) {
          const regex = new RegExp(escapeRegExp(msg).trim(), 'i');
          query.msg = regex;
        }
        const messages = await Messages.find(query).toArray();
        // Once the filter is applied, messages will be shown and a log containing all filters will be saved for further auditing.
        await AuditLog.insertOne({
          ts: new Date(),
          results: messages.length,
          u: userFields,
          fields: {
            msg,
            users: usernames,
            rids,
            room: name,
            startDate,
            endDate,
            type,
            visitor,
            agent
          }
        });
        return messages;
      },
      async auditGetMessages(_ref5) {
        let {
          rid,
          startDate,
          endDate,
          users: usernames,
          msg,
          type,
          visitor,
          agent
        } = _ref5;
        check(startDate, Date);
        check(endDate, Date);
        const user = await Meteor.userAsync();
        if (!user || !(await hasPermissionAsync(user._id, 'can-audit'))) {
          throw new Meteor.Error('Not allowed');
        }
        const userFields = _objectSpread(_objectSpread({
          _id: user._id,
          username: user.username
        }, user.name && {
          name: user.name
        }), user.avatarETag && {
          avatarETag: user.avatarETag
        });
        let rids;
        let name;
        const query = {
          ts: {
            $gt: startDate,
            $lt: endDate
          }
        };
        if (type === 'u') {
          const usersId = await getUsersIdFromUserName(usernames);
          query['u._id'] = {
            $in: usersId
          };
        } else {
          const roomInfo = await getRoomInfoByAuditParams({
            type,
            roomId: rid,
            users: usernames,
            visitor,
            agent,
            userId: user._id
          });
          if (!roomInfo) {
            throw new Meteor.Error('Room doesn`t exist');
          }
          rids = roomInfo.rids;
          name = roomInfo.name;
          query.rid = {
            $in: rids
          };
        }
        if (msg) {
          const regex = new RegExp(escapeRegExp(msg).trim(), 'i');
          query.msg = regex;
        }
        const messages = await Messages.find(query).toArray();
        // Once the filter is applied, messages will be shown and a log containing all filters will be saved for further auditing.
        await AuditLog.insertOne({
          ts: new Date(),
          results: messages.length,
          u: userFields,
          fields: {
            msg,
            users: usernames,
            rids,
            room: name,
            startDate,
            endDate,
            type,
            visitor,
            agent
          }
        });
        updateCounter({
          settingsId: 'Message_Auditing_Panel_Load_Count'
        });
        return messages;
      },
      async auditGetAuditions(_ref6) {
        let {
          startDate,
          endDate
        } = _ref6;
        check(startDate, Date);
        check(endDate, Date);
        const uid = Meteor.userId();
        if (!uid || !(await hasPermissionAsync(uid, 'can-audit-log'))) {
          throw new Meteor.Error('Not allowed');
        }
        return AuditLog.find({
          // 'u._id': userId,
          ts: {
            $gt: startDate,
            $lt: endDate
          }
        }, {
          projection: {
            'u.services': 0,
            'u.roles': 0,
            'u.lastLogin': 0,
            'u.statusConnection': 0,
            'u.emails': 0
          }
        }).toArray();
      }
    });
    DDPRateLimiter.addRule({
      type: 'method',
      name: 'auditGetAuditions',
      userId(/* userId*/
      ) {
        return true;
      }
    }, 10, 60000);
    DDPRateLimiter.addRule({
      type: 'method',
      name: 'auditGetMessages',
      userId(/* userId*/
      ) {
        return true;
      }
    }, 10, 60000);
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"startup.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/audit/startup.ts                                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      createPermissions: () => createPermissions
    });
    let Permissions;
    module.link("@rocket.chat/models", {
      Permissions(v) {
        Permissions = v;
      }
    }, 0);
    let createOrUpdateProtectedRoleAsync;
    module.link("../../../../server/lib/roles/createOrUpdateProtectedRole", {
      createOrUpdateProtectedRoleAsync(v) {
        createOrUpdateProtectedRoleAsync = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const createPermissions = async () => {
      const permissions = [{
        _id: 'can-audit',
        roles: ['admin', 'auditor']
      }, {
        _id: 'can-audit-log',
        roles: ['admin', 'auditor-log']
      }, {
        _id: 'view-members-list-all-rooms',
        roles: ['admin', 'auditor']
      }];
      const defaultRoles = [{
        name: 'auditor',
        scope: 'Users'
      }, {
        name: 'auditor-log',
        scope: 'Users'
      }];
      for (const permission of permissions) {
        void Permissions.create(permission._id, permission.roles);
      }
      return Promise.all(defaultRoles.map(role => createOrUpdateProtectedRoleAsync(role.name, role)));
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"deviceManagement":{"session.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/deviceManagement/session.ts                                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      listenSessionLogin: () => listenSessionLogin
    });
    let Users;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      }
    }, 0);
    let Accounts;
    module.link("meteor/accounts-base", {
      Accounts(v) {
        Accounts = v;
      }
    }, 1);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 2);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 3);
    let UAParser;
    module.link("ua-parser-js", {
      UAParser(v) {
        UAParser = v;
      }
    }, 4);
    let Mailer;
    module.link("../../../../app/mailer/server/api", {
      "*"(v) {
        Mailer = v;
      }
    }, 5);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 6);
    let UAParserDesktop, UAParserMobile;
    module.link("../../../../app/statistics/server/lib/UAParserCustom", {
      UAParserDesktop(v) {
        UAParserDesktop = v;
      },
      UAParserMobile(v) {
        UAParserMobile = v;
      }
    }, 7);
    let t;
    module.link("../../../../app/utils/lib/i18n", {
      t(v) {
        t = v;
      }
    }, 8);
    let getUserPreference;
    module.link("../../../../app/utils/server/lib/getUserPreference", {
      getUserPreference(v) {
        getUserPreference = v;
      }
    }, 9);
    let deviceManagementEvents;
    module.link("../../../../server/services/device-management/events", {
      deviceManagementEvents(v) {
        deviceManagementEvents = v;
      }
    }, 10);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    let mailTemplates;
    Meteor.startup(() => {
      Mailer.getTemplate('Device_Management_Email_Body', template => {
        mailTemplates = template;
      });
    });
    const uaParser = async uaString => {
      const ua = new UAParser(uaString);
      return _objectSpread(_objectSpread(_objectSpread({}, ua.getResult()), uaString && UAParserMobile.isMobileApp(uaString) && UAParserMobile.uaObject(uaString)), uaString && UAParserDesktop.isDesktopApp(uaString) && UAParserDesktop.uaObject(uaString));
    };
    const listenSessionLogin = () => {
      return deviceManagementEvents.on('device-login', async _ref => {
        var _user$emails, _connection$httpHeade, _connection$httpHeade2;
        let {
          userId,
          connection
        } = _ref;
        const deviceEnabled = settings.get('Device_Management_Enable_Login_Emails');
        if (!deviceEnabled) {
          return;
        }
        if (connection.loginToken) {
          return;
        }
        const user = await Users.findOneByIdWithEmailAddress(userId, {
          projection: {
            'name': 1,
            'username': 1,
            'emails': 1,
            'settings.preferences.receiveLoginDetectionEmail': 1
          }
        });
        if (!(user !== null && user !== void 0 && (_user$emails = user.emails) !== null && _user$emails !== void 0 && _user$emails.length)) {
          return;
        }
        const userReceiveLoginEmailPreference = !settings.get('Device_Management_Allow_Login_Email_preference') || (await getUserPreference(userId, 'receiveLoginDetectionEmail', true));
        if (!userReceiveLoginEmailPreference) {
          return;
        }
        const dateFormat = settings.get('Message_TimeAndDateFormat');
        const {
          name,
          username,
          emails: [{
            address: email
          }]
        } = user;
        const userAgentString = connection.httpHeaders instanceof Headers ? (_connection$httpHeade = connection.httpHeaders.get('user-agent')) !== null && _connection$httpHeade !== void 0 ? _connection$httpHeade : '' : (_connection$httpHeade2 = connection.httpHeaders['user-agent']) !== null && _connection$httpHeade2 !== void 0 ? _connection$httpHeade2 : '';
        const {
          browser,
          os,
          device,
          cpu,
          app
        } = await uaParser(userAgentString);
        const mailData = {
          name,
          username,
          browserInfo: "".concat(browser.name, " ").concat(browser.version),
          osInfo: "".concat(os.name),
          deviceInfo: "".concat(device.type || t('Device_Management_Device_Unknown'), " ").concat(device.vendor || '', " ").concat(device.model || '', " ").concat(cpu.architecture || ''),
          ipInfo: connection.clientAddress,
          userAgent: '',
          date: moment().format(String(dateFormat))
        };
        switch (device.type) {
          case 'mobile':
          case 'tablet':
          case 'smarttv':
            mailData.browserInfo = "".concat(browser.name, " ").concat(browser.version);
            mailData.osInfo = "".concat(os.name);
            mailData.deviceInfo = "".concat(device.type, " ").concat(device.vendor || '', " ").concat(device.model || '', " ").concat(cpu.architecture || '');
            break;
          case 'mobile-app':
            mailData.browserInfo = "Rocket.Chat App ".concat((app === null || app === void 0 ? void 0 : app.bundle) || (app === null || app === void 0 ? void 0 : app.version));
            mailData.osInfo = "".concat(os.name);
            mailData.deviceInfo = 'Mobile App';
            break;
          case 'desktop-app':
            mailData.browserInfo = "Rocket.Chat ".concat((app === null || app === void 0 ? void 0 : app.name) || browser.name, " ").concat((app === null || app === void 0 ? void 0 : app.bundle) || (app === null || app === void 0 ? void 0 : app.version) || browser.version);
            mailData.osInfo = "".concat(os.name);
            mailData.deviceInfo = "Desktop App ".concat(cpu.architecture || '');
            break;
          default:
            mailData.userAgent = connection.httpHeaders['user-agent'] || '';
            break;
        }
        try {
          await Mailer.send({
            to: "".concat(name, " <").concat(email, ">"),
            from: Accounts.emailTemplates.from,
            subject: settings.get('Device_Management_Email_Subject'),
            html: mailTemplates,
            data: mailData
          });
        } catch ({
          message
        }) {
          throw new Meteor.Error('error-email-send-failed', "Error trying to send email: ".concat(message), {
            method: 'listenSessionLogin',
            message
          });
        }
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"startup.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/deviceManagement/startup.ts                                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      createPermissions: () => createPermissions,
      createEmailTemplates: () => createEmailTemplates
    });
    let Permissions;
    module.link("@rocket.chat/models", {
      Permissions(v) {
        Permissions = v;
      }
    }, 0);
    let settingsRegistry;
    module.link("../../../../app/settings/server/index", {
      settingsRegistry(v) {
        settingsRegistry = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const createPermissions = async () => {
      await Promise.all([Permissions.create('logout-device-management', ['admin']), Permissions.create('block-ip-device-management', ['admin'])]);
    };
    const createEmailTemplates = async () => {
      await settingsRegistry.addGroup('Email', async function () {
        await this.section('Device Management - Login Detected', async function () {
          await this.add('Device_Management_Email_Subject', '{Device_Management_Email_Subject}', {
            type: 'string',
            i18nLabel: 'Subject'
          });
          await this.add('Device_Management_Email_Body', '<h2 class="rc-color">{Login_Detected}</h2><p><strong>[name] ([username]) {Logged_In_Via}</strong></p><p><strong>{Device_Management_Client}:</strong> [browserInfo]<br><strong>{Device_Management_OS}:</strong> [osInfo]<br><strong>{Device_Management_Device}:</strong> [deviceInfo]<br><strong>{Device_Management_IP}:</strong>[ipInfo]<br><strong>{Date}:</strong> [date]</p><p><small>[userAgent]</small></p><a class="btn" href="[Site_URL]">{Access_Your_Account}</a><p>{Or_Copy_And_Paste_This_URL_Into_A_Tab_Of_Your_Browser}<br><a href="[Site_URL]">[SITE_URL]</a></p><p>{Thank_You_For_Choosing_RocketChat}</p>', {
            type: 'code',
            code: 'text/html',
            multiline: true,
            i18nLabel: 'Body',
            i18nDescription: 'Device_Management_Email_Body'
          });
        });
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"engagementDashboard":{"channels.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/engagementDashboard/channels.ts                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      findChannelsWithNumberOfMessages: () => findChannelsWithNumberOfMessages,
      findAllChannelsWithNumberOfMessages: () => findAllChannelsWithNumberOfMessages
    });
    let Analytics, Rooms;
    module.link("@rocket.chat/models", {
      Analytics(v) {
        Analytics = v;
      },
      Rooms(v) {
        Rooms = v;
      }
    }, 0);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 1);
    let convertDateToInt, diffBetweenDaysInclusive;
    module.link("./date", {
      convertDateToInt(v) {
        convertDateToInt = v;
      },
      diffBetweenDaysInclusive(v) {
        diffBetweenDaysInclusive = v;
      }
    }, 2);
    let roomCoordinator;
    module.link("../../../../server/lib/rooms/roomCoordinator", {
      roomCoordinator(v) {
        roomCoordinator = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const findChannelsWithNumberOfMessages = async _ref => {
      let {
        start,
        end,
        hideRoomsWithNoActivity,
        options = {}
      } = _ref;
      if (!hideRoomsWithNoActivity) {
        return findAllChannelsWithNumberOfMessages({
          start,
          end,
          options
        });
      }
      const daysBetweenDates = diffBetweenDaysInclusive(end, start);
      const endOfLastWeek = moment(start).subtract(1, 'days').toDate();
      const startOfLastWeek = moment(endOfLastWeek).subtract(daysBetweenDates, 'days').toDate();
      const roomTypes = roomCoordinator.getTypesToShowOnDashboard();
      const aggregationResult = await Analytics.findRoomsByTypesWithNumberOfMessagesBetweenDate({
        types: roomTypes,
        start: convertDateToInt(start),
        end: convertDateToInt(end),
        startOfLastWeek: convertDateToInt(startOfLastWeek),
        endOfLastWeek: convertDateToInt(endOfLastWeek),
        options
      }).toArray();
      // The aggregation result may be undefined if there are no matching analytics or corresponding rooms in the period
      if (!aggregationResult.length) {
        return {
          channels: [],
          total: 0
        };
      }
      const [{
        channels,
        total
      }] = aggregationResult;
      return {
        channels,
        total
      };
    };
    const findAllChannelsWithNumberOfMessages = async _ref2 => {
      let {
        start,
        end,
        options = {}
      } = _ref2;
      const daysBetweenDates = diffBetweenDaysInclusive(end, start);
      const endOfLastWeek = moment(start).subtract(1, 'days').toDate();
      const startOfLastWeek = moment(endOfLastWeek).subtract(daysBetweenDates, 'days').toDate();
      const roomTypes = roomCoordinator.getTypesToShowOnDashboard();
      const channels = await Rooms.findChannelsByTypesWithNumberOfMessagesBetweenDate({
        types: roomTypes,
        start: convertDateToInt(start),
        end: convertDateToInt(end),
        startOfLastWeek: convertDateToInt(startOfLastWeek),
        endOfLastWeek: convertDateToInt(endOfLastWeek),
        options
      }).toArray();
      const total = await Rooms.countDocuments({
        t: {
          $in: roomTypes
        }
      });
      return {
        channels,
        total
      };
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"date.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/engagementDashboard/date.ts                                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      isDateISOString: () => isDateISOString,
      mapDateForAPI: () => mapDateForAPI,
      convertDateToInt: () => convertDateToInt,
      convertIntToDate: () => convertIntToDate,
      diffBetweenDaysInclusive: () => diffBetweenDaysInclusive,
      getTotalOfWeekItems: () => getTotalOfWeekItems,
      transformDatesForAPI: () => transformDatesForAPI
    });
    let mem;
    module.link("mem", {
      default(v) {
        mem = v;
      }
    }, 0);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const isDateISOString = mem(input => {
      const timestamp = Date.parse(input);
      return !Number.isNaN(timestamp) && new Date(timestamp).toISOString() === input;
    }, {
      maxAge: 10000
    });
    const mapDateForAPI = input => {
      if (!isDateISOString(input)) {
        throw new Error('invalid ISO 8601 date');
      }
      return new Date(Date.parse(input));
    };
    const convertDateToInt = date => parseInt(moment(date).clone().format('YYYYMMDD'), 10);
    const convertIntToDate = intValue => moment(intValue, 'YYYYMMDD').clone().toDate();
    const diffBetweenDays = (start, end) => moment(new Date(start)).clone().diff(new Date(end), 'days');
    const diffBetweenDaysInclusive = (start, end) => diffBetweenDays(start, end) + 1;
    const getTotalOfWeekItems = (weekItems, property) => weekItems.reduce((acc, item) => {
      acc += item[property];
      return acc;
    }, 0);
    function transformDatesForAPI(start, end) {
      return {
        start: mapDateForAPI(start),
        end: end ? mapDateForAPI(end) : undefined
      };
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"messages.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/engagementDashboard/messages.ts                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      handleMessagesSent: () => handleMessagesSent,
      handleMessagesDeleted: () => handleMessagesDeleted,
      fillFirstDaysOfMessagesIfNeeded: () => fillFirstDaysOfMessagesIfNeeded,
      findWeeklyMessagesSentData: () => findWeeklyMessagesSentData,
      findMessagesSentOrigin: () => findMessagesSentOrigin,
      findTopFivePopularChannelsByMessageSentQuantity: () => findTopFivePopularChannelsByMessageSentQuantity
    });
    let Messages, Analytics;
    module.link("@rocket.chat/models", {
      Messages(v) {
        Messages = v;
      },
      Analytics(v) {
        Analytics = v;
      }
    }, 0);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 1);
    let convertDateToInt, diffBetweenDaysInclusive, convertIntToDate, getTotalOfWeekItems;
    module.link("./date", {
      convertDateToInt(v) {
        convertDateToInt = v;
      },
      diffBetweenDaysInclusive(v) {
        diffBetweenDaysInclusive = v;
      },
      convertIntToDate(v) {
        convertIntToDate = v;
      },
      getTotalOfWeekItems(v) {
        getTotalOfWeekItems = v;
      }
    }, 2);
    let roomCoordinator;
    module.link("../../../../server/lib/rooms/roomCoordinator", {
      roomCoordinator(v) {
        roomCoordinator = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const handleMessagesSent = async (message, _ref) => {
      let {
        room
      } = _ref;
      const roomTypesToShow = roomCoordinator.getTypesToShowOnDashboard();
      if (!room || !roomTypesToShow.includes(room.t)) {
        return message;
      }
      await Analytics.saveMessageSent({
        date: convertDateToInt(message.ts),
        room
      });
      return message;
    };
    const handleMessagesDeleted = async (message, _ref2) => {
      let {
        room
      } = _ref2;
      const roomTypesToShow = roomCoordinator.getTypesToShowOnDashboard();
      if (!room || !roomTypesToShow.includes(room.t)) {
        return message;
      }
      await Analytics.saveMessageDeleted({
        date: convertDateToInt(message.ts),
        room
      });
      return message;
    };
    const fillFirstDaysOfMessagesIfNeeded = async date => {
      const messagesFromAnalytics = await Analytics.findByTypeBeforeDate({
        type: 'messages',
        date: convertDateToInt(date)
      }).toArray();
      if (!messagesFromAnalytics.length) {
        const startOfPeriod = moment(date).subtract(90, 'days').toDate();
        const messages = await Messages.getTotalOfMessagesSentByDate({
          start: startOfPeriod,
          end: date
        });
        await Promise.all(messages.map(message => Analytics.insertOne(_objectSpread(_objectSpread({}, message), {}, {
          date: parseInt(message.date)
        }))));
      }
    };
    const findWeeklyMessagesSentData = async _ref3 => {
      var _currentPeriodMessage, _currentPeriodMessage2;
      let {
        start,
        end
      } = _ref3;
      const daysBetweenDates = diffBetweenDaysInclusive(end, start);
      const endOfLastWeek = moment(start).clone().subtract(1, 'days').toDate();
      const startOfLastWeek = moment(endOfLastWeek).clone().subtract(daysBetweenDates, 'days').toDate();
      const today = convertDateToInt(end);
      const yesterday = convertDateToInt(moment(end).clone().subtract(1, 'days').toDate());
      const currentPeriodMessages = await Analytics.getMessagesSentTotalByDate({
        start: convertDateToInt(start),
        end: convertDateToInt(end),
        options: {
          count: daysBetweenDates,
          sort: {
            _id: -1
          }
        }
      }).toArray();
      const lastPeriodMessages = await Analytics.getMessagesSentTotalByDate({
        start: convertDateToInt(startOfLastWeek),
        end: convertDateToInt(endOfLastWeek),
        options: {
          count: daysBetweenDates,
          sort: {
            _id: -1
          }
        }
      }).toArray();
      const yesterdayMessages = ((_currentPeriodMessage = currentPeriodMessages.find(item => item._id === yesterday)) === null || _currentPeriodMessage === void 0 ? void 0 : _currentPeriodMessage.messages) || 0;
      const todayMessages = ((_currentPeriodMessage2 = currentPeriodMessages.find(item => item._id === today)) === null || _currentPeriodMessage2 === void 0 ? void 0 : _currentPeriodMessage2.messages) || 0;
      const currentPeriodTotalOfMessages = getTotalOfWeekItems(currentPeriodMessages, 'messages');
      const lastPeriodTotalOfMessages = getTotalOfWeekItems(lastPeriodMessages, 'messages');
      return {
        days: currentPeriodMessages.map(day => ({
          day: convertIntToDate(day._id),
          messages: day.messages
        })),
        period: {
          count: currentPeriodTotalOfMessages,
          variation: currentPeriodTotalOfMessages - lastPeriodTotalOfMessages
        },
        yesterday: {
          count: yesterdayMessages,
          variation: todayMessages - yesterdayMessages
        }
      };
    };
    const findMessagesSentOrigin = async _ref4 => {
      let {
        start,
        end
      } = _ref4;
      const origins = await Analytics.getMessagesOrigin({
        start: convertDateToInt(start),
        end: convertDateToInt(end)
      }).toArray();
      const roomTypesToShow = roomCoordinator.getTypesToShowOnDashboard();
      const responseTypes = origins.map(origin => origin.t);
      const missingTypes = roomTypesToShow.filter(type => !responseTypes.includes(type));
      if (missingTypes.length) {
        missingTypes.forEach(type => origins.push({
          messages: 0,
          t: type
        }));
      }
      return {
        origins
      };
    };
    const findTopFivePopularChannelsByMessageSentQuantity = async _ref5 => {
      let {
        start,
        end
      } = _ref5;
      const channels = await Analytics.getMostPopularChannelsByMessagesSentQuantity({
        start: convertDateToInt(start),
        end: convertDateToInt(end),
        options: {
          count: 5,
          sort: {
            messages: -1
          }
        }
      }).toArray();
      return {
        channels
      };
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"startup.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/engagementDashboard/startup.ts                                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      attachCallbacks: () => attachCallbacks,
      detachCallbacks: () => detachCallbacks,
      prepareAnalytics: () => prepareAnalytics
    });
    let fillFirstDaysOfMessagesIfNeeded, handleMessagesDeleted, handleMessagesSent;
    module.link("./messages", {
      fillFirstDaysOfMessagesIfNeeded(v) {
        fillFirstDaysOfMessagesIfNeeded = v;
      },
      handleMessagesDeleted(v) {
        handleMessagesDeleted = v;
      },
      handleMessagesSent(v) {
        handleMessagesSent = v;
      }
    }, 0);
    let fillFirstDaysOfUsersIfNeeded, handleUserCreated;
    module.link("./users", {
      fillFirstDaysOfUsersIfNeeded(v) {
        fillFirstDaysOfUsersIfNeeded = v;
      },
      handleUserCreated(v) {
        handleUserCreated = v;
      }
    }, 1);
    let callbacks;
    module.link("../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const attachCallbacks = () => {
      callbacks.add('afterSaveMessage', (message, _ref) => {
        let {
          room
        } = _ref;
        return handleMessagesSent(message, {
          room
        });
      }, callbacks.priority.MEDIUM, 'engagementDashboard.afterSaveMessage');
      callbacks.add('afterDeleteMessage', handleMessagesDeleted, callbacks.priority.MEDIUM, 'engagementDashboard.afterDeleteMessage');
      callbacks.add('afterCreateUser', handleUserCreated, callbacks.priority.MEDIUM, 'engagementDashboard.afterCreateUser');
    };
    const detachCallbacks = () => {
      callbacks.remove('afterSaveMessage', 'engagementDashboard.afterSaveMessage');
      callbacks.remove('afterDeleteMessage', 'engagementDashboard.afterDeleteMessage');
      callbacks.remove('afterCreateUser', 'engagementDashboard.afterCreateUser');
    };
    const prepareAnalytics = async () => {
      const now = new Date();
      await Promise.all([fillFirstDaysOfUsersIfNeeded(now), fillFirstDaysOfMessagesIfNeeded(now)]);
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"users.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/engagementDashboard/users.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      handleUserCreated: () => handleUserCreated,
      fillFirstDaysOfUsersIfNeeded: () => fillFirstDaysOfUsersIfNeeded,
      findWeeklyUsersRegisteredData: () => findWeeklyUsersRegisteredData,
      findActiveUsersMonthlyData: () => findActiveUsersMonthlyData,
      findBusiestsChatsInADayByHours: () => findBusiestsChatsInADayByHours,
      findBusiestsChatsWithinAWeek: () => findBusiestsChatsWithinAWeek,
      findUserSessionsByHourWithinAWeek: () => findUserSessionsByHourWithinAWeek
    });
    let Users, Analytics, Sessions;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      },
      Analytics(v) {
        Analytics = v;
      },
      Sessions(v) {
        Sessions = v;
      }
    }, 0);
    let moment;
    module.link("moment", {
      default(v) {
        moment = v;
      }
    }, 1);
    let convertDateToInt, diffBetweenDaysInclusive, getTotalOfWeekItems, convertIntToDate;
    module.link("./date", {
      convertDateToInt(v) {
        convertDateToInt = v;
      },
      diffBetweenDaysInclusive(v) {
        diffBetweenDaysInclusive = v;
      },
      getTotalOfWeekItems(v) {
        getTotalOfWeekItems = v;
      },
      convertIntToDate(v) {
        convertIntToDate = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const handleUserCreated = async user => {
      var _user$roles;
      if ((_user$roles = user.roles) !== null && _user$roles !== void 0 && _user$roles.includes('anonymous')) {
        return user;
      }
      await Analytics.saveUserData({
        date: convertDateToInt(user.createdAt)
      });
      return user;
    };
    const fillFirstDaysOfUsersIfNeeded = async date => {
      const usersFromAnalytics = await Analytics.findByTypeBeforeDate({
        type: 'users',
        date: convertDateToInt(date)
      }).toArray();
      if (!usersFromAnalytics.length) {
        const startOfPeriod = moment(date).subtract(90, 'days').toDate();
        const users = await Users.getTotalOfRegisteredUsersByDate({
          start: startOfPeriod,
          end: date
        });
        users.forEach(user => Analytics.insertOne(_objectSpread(_objectSpread({}, user), {}, {
          date: parseInt(user.date)
        })));
      }
    };
    const findWeeklyUsersRegisteredData = async _ref => {
      var _currentPeriodUsers$f, _currentPeriodUsers$f2;
      let {
        start,
        end
      } = _ref;
      const daysBetweenDates = diffBetweenDaysInclusive(end, start);
      const endOfLastWeek = moment(start).clone().subtract(1, 'days').toDate();
      const startOfLastWeek = moment(endOfLastWeek).clone().subtract(daysBetweenDates, 'days').toDate();
      const today = convertDateToInt(end);
      const yesterday = convertDateToInt(moment(end).clone().subtract(1, 'days').toDate());
      const currentPeriodUsers = await Analytics.getTotalOfRegisteredUsersByDate({
        start: convertDateToInt(start),
        end: convertDateToInt(end),
        options: {
          count: daysBetweenDates,
          sort: {
            _id: -1
          }
        }
      }).toArray();
      const lastPeriodUsers = await Analytics.getTotalOfRegisteredUsersByDate({
        start: convertDateToInt(startOfLastWeek),
        end: convertDateToInt(endOfLastWeek),
        options: {
          count: daysBetweenDates,
          sort: {
            _id: -1
          }
        }
      }).toArray();
      const yesterdayUsers = ((_currentPeriodUsers$f = currentPeriodUsers.find(item => item._id === yesterday)) === null || _currentPeriodUsers$f === void 0 ? void 0 : _currentPeriodUsers$f.users) || 0;
      const todayUsers = ((_currentPeriodUsers$f2 = currentPeriodUsers.find(item => item._id === today)) === null || _currentPeriodUsers$f2 === void 0 ? void 0 : _currentPeriodUsers$f2.users) || 0;
      const currentPeriodTotalUsers = getTotalOfWeekItems(currentPeriodUsers, 'users');
      const lastPeriodTotalUsers = getTotalOfWeekItems(lastPeriodUsers, 'users');
      return {
        days: currentPeriodUsers.map(day => ({
          day: convertIntToDate(day._id),
          users: day.users
        })),
        period: {
          count: currentPeriodTotalUsers,
          variation: currentPeriodTotalUsers - lastPeriodTotalUsers
        },
        yesterday: {
          count: yesterdayUsers,
          variation: todayUsers - yesterdayUsers
        }
      };
    };
    const createDestructuredDate = input => {
      const date = moment(input);
      return {
        year: date.year(),
        month: date.month() + 1,
        day: date.date()
      };
    };
    const findActiveUsersMonthlyData = async _ref2 => {
      let {
        start,
        end
      } = _ref2;
      return {
        month: await Sessions.getActiveUsersOfPeriodByDayBetweenDates({
          start: createDestructuredDate(start),
          end: createDestructuredDate(end)
        })
      };
    };
    const findBusiestsChatsInADayByHours = async _ref3 => {
      let {
        start
      } = _ref3;
      return {
        hours: await Sessions.getBusiestTimeWithinHoursPeriod({
          start: moment(start).subtract(24, 'hours').toDate(),
          end: start,
          groupSize: 2
        })
      };
    };
    const findBusiestsChatsWithinAWeek = async _ref4 => {
      let {
        start
      } = _ref4;
      return {
        month: await Sessions.getTotalOfSessionsByDayBetweenDates({
          start: createDestructuredDate(moment(start).subtract(7, 'days')),
          end: createDestructuredDate(start)
        })
      };
    };
    const findUserSessionsByHourWithinAWeek = async _ref5 => {
      let {
        start,
        end
      } = _ref5;
      return {
        week: await Sessions.getTotalOfSessionByHourAndDayBetweenDates({
          start,
          end
        })
      };
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"ldap":{"Manager.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/ldap/Manager.ts                                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 0);
    module.export({
      LDAPEEManager: () => LDAPEEManager
    });
    let Team;
    module.link("@rocket.chat/core-services", {
      Team(v) {
        Team = v;
      }
    }, 0);
    let Users, Roles, SubscriptionsRaw, Rooms;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      },
      Roles(v) {
        Roles = v;
      },
      Subscriptions(v) {
        SubscriptionsRaw = v;
      },
      Rooms(v) {
        Rooms = v;
      }
    }, 1);
    let addUserToRoom;
    module.link("../../../../app/lib/server/functions/addUserToRoom", {
      addUserToRoom(v) {
        addUserToRoom = v;
      }
    }, 2);
    let createRoom;
    module.link("../../../../app/lib/server/functions/createRoom", {
      createRoom(v) {
        createRoom = v;
      }
    }, 3);
    let removeUserFromRoom;
    module.link("../../../../app/lib/server/functions/removeUserFromRoom", {
      removeUserFromRoom(v) {
        removeUserFromRoom = v;
      }
    }, 4);
    let setUserActiveStatus;
    module.link("../../../../app/lib/server/functions/setUserActiveStatus", {
      setUserActiveStatus(v) {
        setUserActiveStatus = v;
      }
    }, 5);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 6);
    let getValidRoomName;
    module.link("../../../../app/utils/server/lib/getValidRoomName", {
      getValidRoomName(v) {
        getValidRoomName = v;
      }
    }, 7);
    let ensureArray;
    module.link("../../../../lib/utils/arrayUtils", {
      ensureArray(v) {
        ensureArray = v;
      }
    }, 8);
    let LDAPConnection;
    module.link("../../../../server/lib/ldap/Connection", {
      LDAPConnection(v) {
        LDAPConnection = v;
      }
    }, 9);
    let logger, searchLogger, mapLogger;
    module.link("../../../../server/lib/ldap/Logger", {
      logger(v) {
        logger = v;
      },
      searchLogger(v) {
        searchLogger = v;
      },
      mapLogger(v) {
        mapLogger = v;
      }
    }, 10);
    let LDAPManager;
    module.link("../../../../server/lib/ldap/Manager", {
      LDAPManager(v) {
        LDAPManager = v;
      }
    }, 11);
    let LDAPUserConverter;
    module.link("../../../../server/lib/ldap/UserConverter", {
      LDAPUserConverter(v) {
        LDAPUserConverter = v;
      }
    }, 12);
    let syncUserRoles;
    module.link("../syncUserRoles", {
      syncUserRoles(v) {
        syncUserRoles = v;
      }
    }, 13);
    let copyCustomFieldsLDAP;
    module.link("./copyCustomFieldsLDAP", {
      copyCustomFieldsLDAP(v) {
        copyCustomFieldsLDAP = v;
      }
    }, 14);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class LDAPEEManager extends LDAPManager {
      static async sync() {
        var _settings$get, _settings$get2, _settings$get3, _settings$get4;
        if (settings.get('LDAP_Enable') !== true || settings.get('LDAP_Background_Sync') !== true) {
          return;
        }
        const createNewUsers = (_settings$get = settings.get('LDAP_Background_Sync_Import_New_Users')) !== null && _settings$get !== void 0 ? _settings$get : true;
        const updateExistingUsers = (_settings$get2 = settings.get('LDAP_Background_Sync_Keep_Existant_Users_Updated')) !== null && _settings$get2 !== void 0 ? _settings$get2 : true;
        let disableMissingUsers = updateExistingUsers && ((_settings$get3 = settings.get('LDAP_Background_Sync_Disable_Missing_Users')) !== null && _settings$get3 !== void 0 ? _settings$get3 : false);
        const mergeExistingUsers = (_settings$get4 = settings.get('LDAP_Background_Sync_Merge_Existent_Users')) !== null && _settings$get4 !== void 0 ? _settings$get4 : false;
        const options = this.getConverterOptions();
        options.skipExistingUsers = !updateExistingUsers;
        options.skipNewUsers = !createNewUsers;
        const ldap = new LDAPConnection();
        const converter = new LDAPUserConverter(options);
        const touchedUsers = new Set();
        try {
          await ldap.connect();
          if (createNewUsers || mergeExistingUsers) {
            await this.importNewUsers(ldap, converter);
          } else if (updateExistingUsers) {
            await this.updateExistingUsers(ldap, converter, disableMissingUsers);
            // Missing users will have been disabled automatically by the update operation, so no need to do a separate query for them
            disableMissingUsers = false;
          }
          const membersOfGroupFilter = await ldap.searchMembersOfGroupFilter();
          await converter.convertData({
            beforeImportFn: async _ref => {
              var _ldap$options$groupFi;
              let {
                options
              } = _ref;
              if (!ldap.options.groupFilterEnabled || !ldap.options.groupFilterGroupMemberFormat) {
                return true;
              }
              const memberFormat = (_ldap$options$groupFi = ldap.options.groupFilterGroupMemberFormat) === null || _ldap$options$groupFi === void 0 ? void 0 : _ldap$options$groupFi.replace(/#{username}/g, (options === null || options === void 0 ? void 0 : options.username) || '#{username}').replace(/#{userdn}/g, (options === null || options === void 0 ? void 0 : options.dn) || '#{userdn}');
              return membersOfGroupFilter.includes(memberFormat);
            },
            afterImportFn: async (_ref2, isNewRecord) => {
              let {
                data
              } = _ref2;
              if (data._id) {
                touchedUsers.add(data._id);
              }
              await this.advancedSync(ldap, data, converter, isNewRecord);
            }
          });
          if (disableMissingUsers) {
            await this.disableMissingUsers([...touchedUsers]);
          }
        } catch (error) {
          logger.error(error);
        }
        ldap.disconnect();
      }
      static async syncAvatars() {
        if (settings.get('LDAP_Enable') !== true || settings.get('LDAP_Background_Sync_Avatars') !== true) {
          return;
        }
        try {
          const ldap = new LDAPConnection();
          await ldap.connect();
          try {
            await this.updateUserAvatars(ldap);
          } finally {
            ldap.disconnect();
          }
        } catch (error) {
          logger.error(error);
        }
      }
      static validateLDAPTeamsMappingChanges(json) {
        if (!json) {
          return;
        }
        const mustBeAnArrayOfStrings = array => Boolean(Array.isArray(array) && array.length && array.every(item => typeof item === 'string'));
        const mappedTeams = this.parseJson(json);
        if (!mappedTeams) {
          return;
        }
        const mappedRocketChatTeams = Object.values(mappedTeams);
        const validStructureMapping = mappedRocketChatTeams.every(mustBeAnArrayOfStrings);
        if (!validStructureMapping) {
          throw new Error('Please verify your mapping for LDAP X RocketChat Teams. The structure is invalid, the structure should be an object like: {key: LdapTeam, value: [An array of rocket.chat teams]}');
        }
      }
      static async syncLogout() {
        if (settings.get('LDAP_Enable') !== true || settings.get('LDAP_Sync_AutoLogout_Enabled') !== true) {
          return;
        }
        try {
          const ldap = new LDAPConnection();
          await ldap.connect();
          try {
            await this.logoutDeactivatedUsers(ldap);
          } finally {
            ldap.disconnect();
          }
        } catch (error) {
          logger.error(error);
        }
      }
      static async advancedSyncForUser(ldap, user, isNewRecord, dn) {
        try {
          await this.syncUserRoles(ldap, user, dn);
          await this.syncUserChannels(ldap, user, dn);
          await this.syncUserTeams(ldap, user, dn, isNewRecord);
        } catch (e) {
          logger.debug("Advanced Sync failed for user: ".concat(dn));
          logger.error(e);
        }
      }
      static async advancedSync(ldap, importUser, converter, isNewRecord) {
        const user = await converter.findExistingUser(importUser);
        if (!(user !== null && user !== void 0 && user.username)) {
          return;
        }
        const dn = importUser.importIds[0];
        return this.advancedSyncForUser(ldap, user, isNewRecord, dn);
      }
      static async isUserInGroup(ldap, baseDN, filter, _ref3, groupName) {
        let {
          dn,
          username
        } = _ref3;
        if (!filter || !baseDN) {
          logger.error('Please setup LDAP Group Filter and LDAP Group BaseDN in LDAP Settings.');
          return false;
        }
        const searchOptions = {
          filter: filter.replace(/#{username}/g, username).replace(/#{groupName}/g, groupName).replace(/#{userdn}/g, dn.replace(/\\/g, '\\5c')),
          scope: 'sub'
        };
        const result = await ldap.searchRaw(baseDN, searchOptions);
        if (!Array.isArray(result) || result.length === 0) {
          logger.debug("".concat(username, " is not in ").concat(groupName, " group!!!"));
        } else {
          logger.debug("".concat(username, " is in ").concat(groupName, " group."));
          return true;
        }
        return false;
      }
      static parseJson(json) {
        try {
          return JSON.parse(json);
        } catch (err) {
          logger.error({
            msg: 'Unexpected error',
            err
          });
        }
      }
      static async syncUserRoles(ldap, user, dn) {
        var _settings$get5, _settings$get6, _settings$get7, _settings$get8, _settings$get9;
        const {
          username
        } = user;
        if (!username) {
          logger.debug('User has no username');
          return;
        }
        const shouldSyncUserRoles = (_settings$get5 = settings.get('LDAP_Sync_User_Data_Roles')) !== null && _settings$get5 !== void 0 ? _settings$get5 : false;
        const syncUserRolesAutoRemove = (_settings$get6 = settings.get('LDAP_Sync_User_Data_Roles_AutoRemove')) !== null && _settings$get6 !== void 0 ? _settings$get6 : false;
        const syncUserRolesFieldMap = ((_settings$get7 = settings.get('LDAP_Sync_User_Data_RolesMap')) !== null && _settings$get7 !== void 0 ? _settings$get7 : '').trim();
        const syncUserRolesFilter = ((_settings$get8 = settings.get('LDAP_Sync_User_Data_Roles_Filter')) !== null && _settings$get8 !== void 0 ? _settings$get8 : '').trim();
        const syncUserRolesBaseDN = ((_settings$get9 = settings.get('LDAP_Sync_User_Data_Roles_BaseDN')) !== null && _settings$get9 !== void 0 ? _settings$get9 : '').trim();
        const searchStrategy = settings.get('LDAP_Sync_User_Data_Roles_GroupMembershipValidationStrategy');
        if (!shouldSyncUserRoles || !syncUserRolesFieldMap) {
          logger.debug('not syncing user roles');
          return;
        }
        const roles = await Roles.find({}, {
          projection: {
            _id: 1,
            name: 1
          }
        }).toArray();
        if (!roles) {
          return;
        }
        const groupsToRolesMap = this.parseJson(syncUserRolesFieldMap);
        if (!groupsToRolesMap) {
          logger.debug('missing group role mapping');
          return;
        }
        const ldapGroups = Object.keys(groupsToRolesMap);
        const roleList = [];
        const roleIdsList = [];
        const allowedRoles = this.getDataMappedByLdapGroups(groupsToRolesMap, ldapGroups).map(role => role.split(/\.(.+)/)[0]).reduce((allowedRolesIds, roleIdOrName) => {
          var _roles$find;
          const role = (_roles$find = roles.find(role => role._id === roleIdOrName)) !== null && _roles$find !== void 0 ? _roles$find : roles.find(role => role.name === roleIdOrName);
          if (role) {
            allowedRolesIds.push(role._id);
          }
          return allowedRolesIds;
        }, []);
        if (searchStrategy === 'once') {
          const ldapUserGroups = await this.getLdapGroupsByUsername(ldap, username, dn, syncUserRolesBaseDN, syncUserRolesFilter);
          roleList.push(...this.getDataMappedByLdapGroups(groupsToRolesMap, ldapUserGroups));
        } else if (searchStrategy === 'each_group') {
          var _iteratorAbruptCompletion = false;
          var _didIteratorError = false;
          var _iteratorError;
          try {
            for (var _iterator = _asyncIterator(ldapGroups), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
              const ldapGroup = _step.value;
              {
                if (await this.isUserInGroup(ldap, syncUserRolesBaseDN, syncUserRolesFilter, {
                  dn,
                  username
                }, ldapGroup)) {
                  roleList.push(...ensureArray(groupsToRolesMap[ldapGroup]));
                }
              }
            }
          } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
          } finally {
            try {
              if (_iteratorAbruptCompletion && _iterator.return != null) {
                await _iterator.return();
              }
            } finally {
              if (_didIteratorError) {
                throw _iteratorError;
              }
            }
          }
        }
        var _iteratorAbruptCompletion2 = false;
        var _didIteratorError2 = false;
        var _iteratorError2;
        try {
          for (var _iterator2 = _asyncIterator(roleList), _step2; _iteratorAbruptCompletion2 = !(_step2 = await _iterator2.next()).done; _iteratorAbruptCompletion2 = false) {
            const nonValidatedRole = _step2.value;
            {
              var _roles$find2;
              const [roleIdOrName] = nonValidatedRole.split(/\.(.+)/);
              const role = (_roles$find2 = roles.find(role => role._id === roleIdOrName)) !== null && _roles$find2 !== void 0 ? _roles$find2 : roles.find(role => role.name === roleIdOrName);
              if (role) {
                roleIdsList.push(role._id);
              }
            }
          }
        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion2 && _iterator2.return != null) {
              await _iterator2.return();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }
        await syncUserRoles(user._id, roleIdsList, {
          allowedRoles,
          skipRemovingRoles: !syncUserRolesAutoRemove
        });
      }
      static async createRoomForSync(channel) {
        logger.debug("Channel '".concat(channel, "' doesn't exist, creating it."));
        const roomOwner = settings.get('LDAP_Sync_User_Data_Channels_Admin') || '';
        const user = await Users.findOneByUsernameIgnoringCase(roomOwner);
        if (!user) {
          logger.error("Unable to find user '".concat(roomOwner, "' to be the owner of the channel '").concat(channel, "'."));
          return;
        }
        const room = await createRoom('c', channel, user, [], false, false, {
          customFields: {
            ldap: true
          }
        });
        if (!(room !== null && room !== void 0 && room.rid)) {
          logger.error("Unable to auto-create channel '".concat(channel, "' during ldap sync."));
          return;
        }
        room._id = room.rid;
        return room;
      }
      static async syncUserChannels(ldap, user, dn) {
        var _settings$get0, _settings$get1, _settings$get10, _settings$get11, _settings$get12;
        const syncUserChannels = (_settings$get0 = settings.get('LDAP_Sync_User_Data_Channels')) !== null && _settings$get0 !== void 0 ? _settings$get0 : false;
        const syncUserChannelsRemove = (_settings$get1 = settings.get('LDAP_Sync_User_Data_Channels_Enforce_AutoChannels')) !== null && _settings$get1 !== void 0 ? _settings$get1 : false;
        const syncUserChannelsFieldMap = ((_settings$get10 = settings.get('LDAP_Sync_User_Data_ChannelsMap')) !== null && _settings$get10 !== void 0 ? _settings$get10 : '').trim();
        const syncUserChannelsFilter = ((_settings$get11 = settings.get('LDAP_Sync_User_Data_Channels_Filter')) !== null && _settings$get11 !== void 0 ? _settings$get11 : '').trim();
        const syncUserChannelsBaseDN = ((_settings$get12 = settings.get('LDAP_Sync_User_Data_Channels_BaseDN')) !== null && _settings$get12 !== void 0 ? _settings$get12 : '').trim();
        const searchStrategy = settings.get('LDAP_Sync_User_Data_Channels_GroupMembershipValidationStrategy');
        if (!syncUserChannels || !syncUserChannelsFieldMap) {
          logger.debug('not syncing groups to channels');
          return;
        }
        const groupsToRoomsMap = this.parseJson(syncUserChannelsFieldMap);
        if (!groupsToRoomsMap) {
          logger.debug('missing group channel mapping');
          return;
        }
        const {
          username
        } = user;
        if (!username) {
          return;
        }
        logger.debug('syncing user channels');
        const ldapGroups = Object.keys(groupsToRoomsMap);
        const ldapUserGroups = [];
        const channelsToAdd = new Set();
        const userChannelsNames = [];
        if (searchStrategy === 'once') {
          ldapUserGroups.push(...(await this.getLdapGroupsByUsername(ldap, username, dn, syncUserChannelsBaseDN, syncUserChannelsFilter)));
          userChannelsNames.push(...this.getDataMappedByLdapGroups(groupsToRoomsMap, ldapUserGroups));
        } else if (searchStrategy === 'each_group') {
          var _iteratorAbruptCompletion3 = false;
          var _didIteratorError3 = false;
          var _iteratorError3;
          try {
            for (var _iterator3 = _asyncIterator(ldapGroups), _step3; _iteratorAbruptCompletion3 = !(_step3 = await _iterator3.next()).done; _iteratorAbruptCompletion3 = false) {
              const ldapGroup = _step3.value;
              {
                if (await this.isUserInGroup(ldap, syncUserChannelsBaseDN, syncUserChannelsFilter, {
                  dn,
                  username
                }, ldapGroup)) {
                  userChannelsNames.push(...ensureArray(groupsToRoomsMap[ldapGroup]));
                  ldapUserGroups.push(ldapGroup);
                }
              }
            }
          } catch (err) {
            _didIteratorError3 = true;
            _iteratorError3 = err;
          } finally {
            try {
              if (_iteratorAbruptCompletion3 && _iterator3.return != null) {
                await _iterator3.return();
              }
            } finally {
              if (_didIteratorError3) {
                throw _iteratorError3;
              }
            }
          }
        }
        var _iteratorAbruptCompletion4 = false;
        var _didIteratorError4 = false;
        var _iteratorError4;
        try {
          for (var _iterator4 = _asyncIterator(userChannelsNames), _step4; _iteratorAbruptCompletion4 = !(_step4 = await _iterator4.next()).done; _iteratorAbruptCompletion4 = false) {
            const userChannelName = _step4.value;
            {
              try {
                const name = await getValidRoomName(userChannelName.trim(), undefined, {
                  allowDuplicates: true
                });
                const room = (await Rooms.findOneByNonValidatedName(name)) || (await this.createRoomForSync(userChannelName));
                if (!room) {
                  return;
                }
                if (room.teamMain) {
                  logger.error("Can't add user to channel ".concat(userChannelName, " because it is a team."));
                } else {
                  channelsToAdd.add(room._id);
                  await addUserToRoom(room._id, user);
                  logger.debug("Synced user channel ".concat(room._id, " from LDAP for ").concat(username));
                }
              } catch (e) {
                logger.debug("Failed to sync user room, user = ".concat(username, ", channel = ").concat(userChannelName));
                logger.error(e);
              }
            }
          }
        } catch (err) {
          _didIteratorError4 = true;
          _iteratorError4 = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion4 && _iterator4.return != null) {
              await _iterator4.return();
            }
          } finally {
            if (_didIteratorError4) {
              throw _iteratorError4;
            }
          }
        }
        if (syncUserChannelsRemove) {
          const notInUserGroups = ldapGroups.filter(ldapGroup => !ldapUserGroups.includes(ldapGroup));
          const notMappedRooms = this.getDataMappedByLdapGroups(groupsToRoomsMap, notInUserGroups);
          const roomsToRemove = new Set(notMappedRooms);
          var _iteratorAbruptCompletion5 = false;
          var _didIteratorError5 = false;
          var _iteratorError5;
          try {
            for (var _iterator5 = _asyncIterator(roomsToRemove), _step5; _iteratorAbruptCompletion5 = !(_step5 = await _iterator5.next()).done; _iteratorAbruptCompletion5 = false) {
              const roomName = _step5.value;
              {
                const name = await getValidRoomName(roomName.trim(), undefined, {
                  allowDuplicates: true
                });
                const room = await Rooms.findOneByNonValidatedName(name);
                if (!room || room.teamMain || channelsToAdd.has(room._id)) {
                  return;
                }
                const subscription = await SubscriptionsRaw.findOneByRoomIdAndUserId(room._id, user._id);
                if (subscription) {
                  await removeUserFromRoom(room._id, user);
                  logger.debug("Removed user ".concat(username, " from channel ").concat(room._id));
                }
              }
            }
          } catch (err) {
            _didIteratorError5 = true;
            _iteratorError5 = err;
          } finally {
            try {
              if (_iteratorAbruptCompletion5 && _iterator5.return != null) {
                await _iterator5.return();
              }
            } finally {
              if (_didIteratorError5) {
                throw _iteratorError5;
              }
            }
          }
        }
      }
      static async syncUserTeams(ldap, user, dn, isNewRecord) {
        var _settings$get13;
        if (!user.username) {
          return;
        }
        const mapTeams = settings.get('LDAP_Enable_LDAP_Groups_To_RC_Teams') && (isNewRecord || settings.get('LDAP_Validate_Teams_For_Each_Login'));
        if (!mapTeams) {
          return;
        }
        const baseDN = ((_settings$get13 = settings.get('LDAP_Teams_BaseDN')) !== null && _settings$get13 !== void 0 ? _settings$get13 : '').trim() || ldap.options.baseDN;
        const filter = settings.get('LDAP_Query_To_Get_User_Teams');
        const groupAttributeName = settings.get('LDAP_Teams_Name_Field');
        const ldapUserTeams = await this.getLdapGroupsByUsername(ldap, user.username, dn, baseDN, filter, groupAttributeName);
        const mapJson = settings.get('LDAP_Groups_To_Rocket_Chat_Teams');
        if (!mapJson) {
          return;
        }
        const map = this.parseJson(mapJson);
        if (!map) {
          return;
        }
        const teamNames = this.getDataMappedByLdapGroups(map, ldapUserTeams);
        const allTeamNames = [...new Set(Object.values(map).flat())];
        const allTeams = await Team.listByNames(allTeamNames, {
          projection: {
            _id: 1,
            name: 1
          }
        });
        const inTeamIds = allTeams.filter(_ref4 => {
          let {
            name
          } = _ref4;
          return teamNames.includes(name);
        }).map(_ref5 => {
          let {
            _id
          } = _ref5;
          return _id;
        });
        const notInTeamIds = allTeams.filter(_ref6 => {
          let {
            name
          } = _ref6;
          return !teamNames.includes(name);
        }).map(_ref7 => {
          let {
            _id
          } = _ref7;
          return _id;
        });
        const currentTeams = await Team.listTeamsBySubscriberUserId(user._id, {
          projection: {
            teamId: 1
          }
        });
        const currentTeamIds = currentTeams === null || currentTeams === void 0 ? void 0 : currentTeams.map(_ref8 => {
          let {
            teamId
          } = _ref8;
          return teamId;
        });
        const teamsToRemove = currentTeamIds === null || currentTeamIds === void 0 ? void 0 : currentTeamIds.filter(teamId => notInTeamIds.includes(teamId));
        const teamsToAdd = inTeamIds.filter(teamId => !(currentTeamIds !== null && currentTeamIds !== void 0 && currentTeamIds.includes(teamId)));
        await Team.insertMemberOnTeams(user._id, teamsToAdd);
        if (teamsToRemove) {
          await Team.removeMemberFromTeams(user._id, teamsToRemove);
        }
      }
      static getDataMappedByLdapGroups(map, ldapGroups) {
        const mappedLdapGroups = Object.keys(map);
        const filteredMappedLdapGroups = ldapGroups.filter(ldapGroup => mappedLdapGroups.includes(ldapGroup));
        if (filteredMappedLdapGroups.length < ldapGroups.length) {
          const unmappedLdapGroups = ldapGroups.filter(ldapGroup => !mappedLdapGroups.includes(ldapGroup));
          logger.error("The following LDAP groups are not mapped in Rocket.Chat: \"".concat(unmappedLdapGroups.join(', '), "\"."));
        }
        if (!filteredMappedLdapGroups.length) {
          return [];
        }
        return [...new Set(filteredMappedLdapGroups.map(ldapGroup => map[ldapGroup]).flat())];
      }
      static async getLdapGroupsByUsername(ldap, username, userDN, baseDN, filter, groupAttributeName) {
        if (!filter) {
          return [];
        }
        const searchOptions = {
          filter: filter.replace(/#{username}/g, username).replace(/#{userdn}/g, userDN.replace(/\\/g, '\\5c')),
          scope: ldap.options.userSearchScope || 'sub',
          sizeLimit: ldap.options.searchSizeLimit
        };
        const attributeNames = groupAttributeName ? groupAttributeName.split(',').map(attributeName => attributeName.trim()) : ['ou', 'cn'];
        const ldapUserGroups = await ldap.searchRaw(baseDN, searchOptions);
        if (!Array.isArray(ldapUserGroups)) {
          return [];
        }
        return ldapUserGroups.map(entry => {
          if (!(entry !== null && entry !== void 0 && entry.raw)) {
            return undefined;
          }
          for (const attributeName of attributeNames) {
            if (entry.raw[attributeName]) {
              return ldap.extractLdapAttribute(entry.raw[attributeName]);
            }
          }
          return undefined;
        }).filter(entry => Boolean(entry)).flat();
      }
      static isUserDeactivated(ldapUser) {
        // Account locked by "Draft-behera-ldap-password-policy"
        if (ldapUser.pwdAccountLockedTime) {
          mapLogger.debug('User account is locked by password policy (attribute pwdAccountLockedTime)');
          return true;
        }
        // EDirectory: Account manually disabled by an admin
        if (ldapUser.loginDisabled) {
          mapLogger.debug('User account was manually disabled by an admin (attribute loginDisabled)');
          return true;
        }
        // Oracle: Account must not be allowed to authenticate
        if (ldapUser.orclIsEnabled && ldapUser.orclIsEnabled !== 'ENABLED') {
          mapLogger.debug('User must not be allowed to authenticate (attribute orclIsEnabled)');
          return true;
        }
        // Active Directory - Account locked automatically by security policies
        if (ldapUser.lockoutTime && ldapUser.lockoutTime !== '0') {
          const lockoutTimeValue = Number(ldapUser.lockoutTime);
          if (lockoutTimeValue && !isNaN(lockoutTimeValue)) {
            // Automatic unlock is disabled
            if (!ldapUser.lockoutDuration) {
              mapLogger.debug('User account locked indefinitely by security policy (attribute lockoutTime)');
              return true;
            }
            const lockoutTime = new Date(lockoutTimeValue);
            lockoutTime.setMinutes(lockoutTime.getMinutes() + Number(ldapUser.lockoutDuration));
            // Account has not unlocked itself yet
            if (lockoutTime.valueOf() > Date.now()) {
              mapLogger.debug('User account locked temporarily by security policy (attribute lockoutTime)');
              return true;
            }
          }
        }
        // Active Directory - Account disabled by an Admin
        if (ldapUser.userAccountControl && (ldapUser.userAccountControl & 2) === 2) {
          mapLogger.debug('User account disabled by an admin (attribute userAccountControl)');
          return true;
        }
        return false;
      }
      static copyActiveState(ldapUser, userData) {
        if (!ldapUser) {
          return;
        }
        const syncUserState = settings.get('LDAP_Sync_User_Active_State');
        if (syncUserState === 'none') {
          return;
        }
        const deleted = this.isUserDeactivated(ldapUser);
        if (deleted === userData.deleted) {
          return;
        }
        if (syncUserState === 'disable' && !deleted) {
          return;
        }
        if (syncUserState === 'enable' && deleted) {
          return;
        }
        userData.deleted = deleted;
        logger.info("".concat(deleted ? 'Deactivating' : 'Activating', " user ").concat(userData.name, " (").concat(userData.username, ")"));
      }
      static copyCustomFields(ldapUser, userData) {
        return copyCustomFieldsLDAP({
          ldapUser,
          userData,
          customFieldsSettings: settings.get('Accounts_CustomFields'),
          customFieldsMap: settings.get('LDAP_CustomFieldMap'),
          syncCustomFields: settings.get('LDAP_Sync_Custom_Fields')
        }, logger);
      }
      static async importNewUsers(ldap, converter) {
        return new Promise((resolve, reject) => {
          let count = 0;
          void ldap.searchAllUsers({
            entryCallback: entry => {
              const data = ldap.extractLdapEntryData(entry);
              count++;
              const userData = this.mapUserData(data);
              converter.addObjectToMemory(userData, {
                dn: data.dn,
                username: this.getLdapUsername(data)
              });
              return userData;
            },
            endCallback: error => {
              if (error) {
                logger.error(error);
                reject(error);
                return;
              }
              logger.info('LDAP finished loading users. Users added to importer: ', count);
              resolve();
            }
          });
        });
      }
      static async updateExistingUsers(ldap, converter) {
        let disableMissingUsers = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
        const users = await Users.findLDAPUsers().toArray();
        var _iteratorAbruptCompletion6 = false;
        var _didIteratorError6 = false;
        var _iteratorError6;
        try {
          for (var _iterator6 = _asyncIterator(users), _step6; _iteratorAbruptCompletion6 = !(_step6 = await _iterator6.next()).done; _iteratorAbruptCompletion6 = false) {
            const user = _step6.value;
            {
              const ldapUser = await this.findLDAPUser(ldap, user);
              if (ldapUser) {
                const userData = this.mapUserData(ldapUser, user.username);
                converter.addObjectToMemory(userData, {
                  dn: ldapUser.dn,
                  username: this.getLdapUsername(ldapUser)
                });
              } else if (disableMissingUsers && user.active) {
                await setUserActiveStatus(user._id, false, true);
              }
            }
          }
        } catch (err) {
          _didIteratorError6 = true;
          _iteratorError6 = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion6 && _iterator6.return != null) {
              await _iterator6.return();
            }
          } finally {
            if (_didIteratorError6) {
              throw _iteratorError6;
            }
          }
        }
      }
      static async disableMissingUsers(foundUsers) {
        const userIds = (await Users.findActiveLDAPUsersExceptIds(foundUsers, {
          projection: {
            _id: 1
          }
        }).toArray()).map(_ref9 => {
          let {
            _id
          } = _ref9;
          return _id;
        });
        await Promise.allSettled(userIds.map(id => setUserActiveStatus(id, false, true)));
      }
      static async updateUserAvatars(ldap) {
        const users = await Users.findLDAPUsers().toArray();
        var _iteratorAbruptCompletion7 = false;
        var _didIteratorError7 = false;
        var _iteratorError7;
        try {
          for (var _iterator7 = _asyncIterator(users), _step7; _iteratorAbruptCompletion7 = !(_step7 = await _iterator7.next()).done; _iteratorAbruptCompletion7 = false) {
            const user = _step7.value;
            {
              const ldapUser = await this.findLDAPUser(ldap, user);
              if (!ldapUser) {
                continue;
              }
              await LDAPManager.syncUserAvatar(user, ldapUser);
            }
          }
        } catch (err) {
          _didIteratorError7 = true;
          _iteratorError7 = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion7 && _iterator7.return != null) {
              await _iterator7.return();
            }
          } finally {
            if (_didIteratorError7) {
              throw _iteratorError7;
            }
          }
        }
      }
      static async findLDAPUser(ldap, user) {
        var _user$services, _user$services$ldap, _user$services2, _user$services2$ldap, _user$services3, _user$services3$ldap;
        if ((_user$services = user.services) !== null && _user$services !== void 0 && (_user$services$ldap = _user$services.ldap) !== null && _user$services$ldap !== void 0 && _user$services$ldap.id) {
          return ldap.findOneById(user.services.ldap.id, user.services.ldap.idAttribute);
        }
        if (user.username) {
          return ldap.findOneByUsername(user.username);
        }
        searchLogger.debug({
          msg: 'existing LDAP user not found during Sync',
          ldapId: (_user$services2 = user.services) === null || _user$services2 === void 0 ? void 0 : (_user$services2$ldap = _user$services2.ldap) === null || _user$services2$ldap === void 0 ? void 0 : _user$services2$ldap.id,
          ldapAttribute: (_user$services3 = user.services) === null || _user$services3 === void 0 ? void 0 : (_user$services3$ldap = _user$services3.ldap) === null || _user$services3$ldap === void 0 ? void 0 : _user$services3$ldap.idAttribute,
          username: user.username
        });
      }
      static async logoutDeactivatedUsers(ldap) {
        const users = await Users.findConnectedLDAPUsers().toArray();
        var _iteratorAbruptCompletion8 = false;
        var _didIteratorError8 = false;
        var _iteratorError8;
        try {
          for (var _iterator8 = _asyncIterator(users), _step8; _iteratorAbruptCompletion8 = !(_step8 = await _iterator8.next()).done; _iteratorAbruptCompletion8 = false) {
            const user = _step8.value;
            {
              const ldapUser = await this.findLDAPUser(ldap, user);
              if (!ldapUser) {
                continue;
              }
              if (this.isUserDeactivated(ldapUser)) {
                await Users.unsetLoginTokens(user._id);
              }
            }
          }
        } catch (err) {
          _didIteratorError8 = true;
          _iteratorError8 = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion8 && _iterator8.return != null) {
              await _iterator8.return();
            }
          } finally {
            if (_didIteratorError8) {
              throw _iteratorError8;
            }
          }
        }
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"copyCustomFieldsLDAP.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/ldap/copyCustomFieldsLDAP.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      copyCustomFieldsLDAP: () => copyCustomFieldsLDAP
    });
    let replacesNestedValues;
    module.link("./replacesNestedValues", {
      replacesNestedValues(v) {
        replacesNestedValues = v;
      }
    }, 0);
    let templateVarHandler;
    module.link("../../../../app/utils/lib/templateVarHandler", {
      templateVarHandler(v) {
        templateVarHandler = v;
      }
    }, 1);
    let getNestedProp;
    module.link("../../../../server/lib/getNestedProp", {
      getNestedProp(v) {
        getNestedProp = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const copyCustomFieldsLDAP = (_ref, logger) => {
      let {
        ldapUser,
        userData,
        customFieldsSettings,
        customFieldsMap,
        syncCustomFields
      } = _ref;
      if (!syncCustomFields) {
        return;
      }
      if (!customFieldsMap || !customFieldsSettings) {
        if (customFieldsMap) {
          logger.debug('Skipping LDAP custom fields because there are no custom map fields configured.');
          return;
        }
        logger.debug('Skipping LDAP custom fields because there are no custom fields configured.');
        return;
      }
      const map = (() => {
        try {
          return JSON.parse(customFieldsMap);
        } catch (err) {
          logger.error({
            msg: 'Error parsing LDAP custom fields map.',
            err
          });
        }
      })();
      if (!map) {
        return;
      }
      let customFields;
      try {
        customFields = JSON.parse(customFieldsSettings);
      } catch (err) {
        logger.error({
          msg: 'Failed to parse Custom Fields',
          err
        });
        return;
      }
      Object.entries(map).forEach(_ref2 => {
        let [ldapField, userField] = _ref2;
        if (!getNestedProp(customFields, userField)) {
          logger.debug("User attribute does not exist: ".concat(userField));
          return;
        }
        const value = templateVarHandler(ldapField, ldapUser);
        if (!value) {
          return;
        }
        userData.customFields = replacesNestedValues(_objectSpread({}, userData.customFields), userField, value);
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"replacesNestedValues.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/ldap/replacesNestedValues.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    module.export({
      replacesNestedValues: () => replacesNestedValues
    });
    const replacesNestedValues = (obj, key, value) => {
      const keys = key.split('.');
      const lastKey = keys.shift();
      if (!lastKey) {
        throw new Error("Failed to assign custom field: ".concat(key));
      }
      if (keys.length && obj[lastKey] !== undefined && (typeof obj[lastKey] !== 'object' || Array.isArray(obj[lastKey]))) {
        throw new Error("Failed to assign custom field: ".concat(key));
      }
      if (keys.length === 0 && typeof obj[lastKey] === 'object') {
        throw new Error("Failed to assign custom field: ".concat(key));
      }
      return _objectSpread(_objectSpread(_objectSpread({}, obj), keys.length === 0 && {
        [lastKey]: value
      }), keys.length > 0 && {
        [lastKey]: replacesNestedValues(obj[lastKey], keys.join('.'), value)
      });
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"message-read-receipt":{"ReadReceipt.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/message-read-receipt/ReadReceipt.ts                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      ReadReceipt: () => ReadReceipt
    });
    let api;
    module.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      }
    }, 0);
    let LivechatVisitors, ReadReceipts, Messages, Rooms, Subscriptions, Users;
    module.link("@rocket.chat/models", {
      LivechatVisitors(v) {
        LivechatVisitors = v;
      },
      ReadReceipts(v) {
        ReadReceipts = v;
      },
      Messages(v) {
        Messages = v;
      },
      Rooms(v) {
        Rooms = v;
      },
      Subscriptions(v) {
        Subscriptions = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let Random;
    module.link("@rocket.chat/random", {
      Random(v) {
        Random = v;
      }
    }, 2);
    let notifyOnRoomChangedById, notifyOnMessageChange;
    module.link("../../../../app/lib/server/lib/notifyListener", {
      notifyOnRoomChangedById(v) {
        notifyOnRoomChangedById = v;
      },
      notifyOnMessageChange(v) {
        notifyOnMessageChange = v;
      }
    }, 3);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 4);
    let SystemLogger;
    module.link("../../../../server/lib/logger/system", {
      SystemLogger(v) {
        SystemLogger = v;
      }
    }, 5);
    let roomCoordinator;
    module.link("../../../../server/lib/rooms/roomCoordinator", {
      roomCoordinator(v) {
        roomCoordinator = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    // debounced function by roomId, so multiple calls within 2 seconds to same roomId runs only once
    const list = {};
    const debounceByRoomId = function (fn) {
      return function (room) {
        clearTimeout(list[room._id]);
        list[room._id] = setTimeout(() => {
          void fn.call(this, room);
          delete list[room._id];
        }, 2000);
      };
    };
    const updateMessages = debounceByRoomId(async _ref => {
      let {
        _id,
        lm
      } = _ref;
      // @TODO maybe store firstSubscription in room object so we don't need to call the above update method
      const firstSubscription = await Subscriptions.getMinimumLastSeenByRoomId(_id);
      if (!(firstSubscription !== null && firstSubscription !== void 0 && firstSubscription.ls)) {
        return;
      }
      const result = await Messages.setVisibleMessagesAsRead(_id, firstSubscription.ls);
      if (result.modifiedCount > 0) {
        void api.broadcast('notify.messagesRead', {
          rid: _id,
          until: firstSubscription.ls
        });
      }
      if (lm && lm <= firstSubscription.ls) {
        await Rooms.setLastMessageAsRead(_id);
        void notifyOnRoomChangedById(_id);
      }
    });
    class ReadReceiptClass {
      async markMessagesAsRead(roomId, userId, userLastSeen) {
        if (!settings.get('Message_Read_Receipt_Enabled')) {
          return;
        }
        const room = await Rooms.findOneById(roomId, {
          projection: {
            lm: 1
          }
        });
        // if users last seen is greater than room's last message, it means the user already have this room marked as read
        if (!room || room.lm && userLastSeen > room.lm) {
          return;
        }
        void this.storeReadReceipts(() => {
          return Messages.findVisibleUnreadMessagesByRoomAndDate(roomId, userLastSeen).toArray();
        }, roomId, userId);
        updateMessages(room);
      }
      async markMessageAsReadBySender(message, _ref2, userId) {
        let {
          _id: roomId,
          t
        } = _ref2;
        if (!settings.get('Message_Read_Receipt_Enabled')) {
          return;
        }
        if (!message.unread) {
          return;
        }
        // mark message as read if the sender is the only one in the room
        const isUserAlone = (await Subscriptions.countByRoomIdAndNotUserId(roomId, userId)) === 0;
        if (isUserAlone) {
          const result = await Messages.setAsReadById(message._id);
          if (result.modifiedCount > 0) {
            void notifyOnMessageChange({
              id: message._id
            });
          }
        }
        const extraData = roomCoordinator.getRoomDirectives(t).getReadReceiptsExtraData(message);
        void this.storeReadReceipts(() => {
          return Promise.resolve([message]);
        }, roomId, userId, extraData);
      }
      async storeThreadMessagesReadReceipts(tmid, userId, userLastSeen) {
        if (!settings.get('Message_Read_Receipt_Enabled')) {
          return;
        }
        const message = await Messages.findOneById(tmid, {
          projection: {
            tlm: 1,
            rid: 1
          }
        });
        // if users last seen is greater than thread's last message, it means the user has already marked this thread as read
        if (!message || message.tlm && userLastSeen > message.tlm) {
          return;
        }
        void this.storeReadReceipts(() => {
          return Messages.findUnreadThreadMessagesByDate(message.rid, tmid, userId, userLastSeen).toArray();
        }, message.rid, userId);
      }
      async storeReadReceipts(getMessages, roomId, userId) {
        let extraData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
        if (settings.get('Message_Read_Receipt_Store_Users')) {
          const ts = new Date();
          const receipts = (await getMessages()).map(message => _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({
            _id: Random.id(),
            roomId,
            userId,
            messageId: message._id,
            ts
          }, message.t && {
            t: message.t
          }), message.pinned && {
            pinned: true
          }), message.drid && {
            drid: message.drid
          }), message.tmid && {
            tmid: message.tmid
          }), extraData));
          if (receipts.length === 0) {
            return;
          }
          try {
            await ReadReceipts.insertMany(receipts);
          } catch (err) {
            SystemLogger.error({
              msg: 'Error inserting read receipts per user',
              err
            });
          }
        }
      }
      async getReceipts(message) {
        const receipts = await ReadReceipts.findByMessageId(message._id).toArray();
        return Promise.all(receipts.map(async receipt => _objectSpread(_objectSpread({}, receipt), {}, {
          user: receipt.token ? await LivechatVisitors.getVisitorByToken(receipt.token, {
            projection: {
              username: 1,
              name: 1
            }
          }) : await Users.findOneById(receipt.userId, {
            projection: {
              username: 1,
              name: 1,
              token: 1
            }
          })
        })));
      }
    }
    const ReadReceipt = new ReadReceiptClass();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"oauth":{"Manager.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/oauth/Manager.ts                                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _asyncIterator;
    module.link("@babel/runtime/helpers/asyncIterator", {
      default(v) {
        _asyncIterator = v;
      }
    }, 0);
    module.export({
      OAuthEEManager: () => OAuthEEManager
    });
    let Logger;
    module.link("@rocket.chat/logger", {
      Logger(v) {
        Logger = v;
      }
    }, 0);
    let Roles, Rooms, Users;
    module.link("@rocket.chat/models", {
      Roles(v) {
        Roles = v;
      },
      Rooms(v) {
        Rooms = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let addUserToRoom;
    module.link("../../../../app/lib/server/functions/addUserToRoom", {
      addUserToRoom(v) {
        addUserToRoom = v;
      }
    }, 2);
    let createRoom;
    module.link("../../../../app/lib/server/functions/createRoom", {
      createRoom(v) {
        createRoom = v;
      }
    }, 3);
    let getValidRoomName;
    module.link("../../../../app/utils/server/lib/getValidRoomName", {
      getValidRoomName(v) {
        getValidRoomName = v;
      }
    }, 4);
    let syncUserRoles;
    module.link("../syncUserRoles", {
      syncUserRoles(v) {
        syncUserRoles = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const logger = new Logger('OAuth');
    class OAuthEEManager {
      static async mapSSOGroupsToChannels(user, identity, groupClaimName, channelsMap, channelsAdmin) {
        if (channelsMap && user && identity && groupClaimName) {
          const groupsFromSSO = identity[groupClaimName] || [];
          const userChannelAdmin = await Users.findOneByUsernameIgnoringCase(channelsAdmin);
          if (!userChannelAdmin) {
            logger.error("could not create channel, user not found: ".concat(channelsAdmin));
            return;
          }
          var _iteratorAbruptCompletion = false;
          var _didIteratorError = false;
          var _iteratorError;
          try {
            for (var _iterator = _asyncIterator(Object.keys(channelsMap)), _step; _iteratorAbruptCompletion = !(_step = await _iterator.next()).done; _iteratorAbruptCompletion = false) {
              const ssoGroup = _step.value;
              {
                if (typeof ssoGroup === 'string') {
                  let channels = channelsMap[ssoGroup];
                  if (!Array.isArray(channels)) {
                    channels = [channels];
                  }
                  var _iteratorAbruptCompletion2 = false;
                  var _didIteratorError2 = false;
                  var _iteratorError2;
                  try {
                    for (var _iterator2 = _asyncIterator(channels), _step2; _iteratorAbruptCompletion2 = !(_step2 = await _iterator2.next()).done; _iteratorAbruptCompletion2 = false) {
                      const channel = _step2.value;
                      {
                        const name = await getValidRoomName(channel.trim(), undefined, {
                          allowDuplicates: true
                        });
                        let room = await Rooms.findOneByNonValidatedName(name);
                        if (!room) {
                          const createdRoom = await createRoom('c', channel, userChannelAdmin, [], false, false);
                          if (!(createdRoom !== null && createdRoom !== void 0 && createdRoom.rid)) {
                            logger.error("could not create channel ".concat(channel));
                            return;
                          }
                          room = createdRoom;
                        }
                        if (room && Array.isArray(groupsFromSSO) && groupsFromSSO.includes(ssoGroup)) {
                          await addUserToRoom(room._id, user);
                        }
                      }
                    }
                  } catch (err) {
                    _didIteratorError2 = true;
                    _iteratorError2 = err;
                  } finally {
                    try {
                      if (_iteratorAbruptCompletion2 && _iterator2.return != null) {
                        await _iterator2.return();
                      }
                    } finally {
                      if (_didIteratorError2) {
                        throw _iteratorError2;
                      }
                    }
                  }
                }
              }
            }
          } catch (err) {
            _didIteratorError = true;
            _iteratorError = err;
          } finally {
            try {
              if (_iteratorAbruptCompletion && _iterator.return != null) {
                await _iterator.return();
              }
            } finally {
              if (_didIteratorError) {
                throw _iteratorError;
              }
            }
          }
        }
      }
      static async updateRolesFromSSO(user, identity, roleClaimName, rolesToSync) {
        if (user && identity && roleClaimName) {
          const rolesFromSSO = await this.mapRolesFromSSO(identity, roleClaimName);
          if (!Array.isArray(user.roles)) {
            user.roles = [];
          }
          const rolesIdsFromSSO = (await Roles.findInIdsOrNames(rolesFromSSO).toArray()).map(role => role._id);
          const allowedRoles = (await Roles.findInIdsOrNames(rolesToSync).toArray()).map(role => role._id);
          await syncUserRoles(user._id, rolesIdsFromSSO, {
            allowedRoles
          });
        }
      }
      // Returns list of roles from SSO identity
      static async mapRolesFromSSO(identity, roleClaimName) {
        if (!identity || !roleClaimName || !identity[roleClaimName] || !Array.isArray(identity[roleClaimName])) {
          return [];
        }
        const baseRoles = identity[roleClaimName];
        const filteredRoles = baseRoles.filter(val => val !== 'offline_access' && val !== 'uma_authorization');
        const validRoleList = [];
        var _iteratorAbruptCompletion3 = false;
        var _didIteratorError3 = false;
        var _iteratorError3;
        try {
          for (var _iterator3 = _asyncIterator(filteredRoles), _step3; _iteratorAbruptCompletion3 = !(_step3 = await _iterator3.next()).done; _iteratorAbruptCompletion3 = false) {
            const role = _step3.value;
            {
              if (await Roles.findOneByIdOrName(role)) {
                validRoleList.push(role);
              }
            }
          }
        } catch (err) {
          _didIteratorError3 = true;
          _iteratorError3 = err;
        } finally {
          try {
            if (_iteratorAbruptCompletion3 && _iterator3.return != null) {
              await _iterator3.return();
            }
          } finally {
            if (_didIteratorError3) {
              throw _iteratorError3;
            }
          }
        }
        return validRoleList;
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"roles":{"insertRole.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/roles/insertRole.ts                                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      insertRoleAsync: () => insertRoleAsync
    });
    let api, MeteorError;
    module.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      },
      MeteorError(v) {
        MeteorError = v;
      }
    }, 0);
    let Roles;
    module.link("@rocket.chat/models", {
      Roles(v) {
        Roles = v;
      }
    }, 1);
    let notifyOnRoleChanged;
    module.link("../../../../app/lib/server/lib/notifyListener", {
      notifyOnRoleChanged(v) {
        notifyOnRoleChanged = v;
      }
    }, 2);
    let isValidRoleScope;
    module.link("../../../../lib/roles/isValidRoleScope", {
      isValidRoleScope(v) {
        isValidRoleScope = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const insertRoleAsync = async function (roleData) {
      let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      const {
        name,
        scope,
        description,
        mandatory2fa
      } = roleData;
      if (await Roles.findOneByName(name)) {
        throw new MeteorError('error-duplicate-role-names-not-allowed', 'Role name already exists');
      }
      if (!isValidRoleScope(scope)) {
        throw new MeteorError('error-invalid-scope', 'Invalid scope');
      }
      const role = await Roles.createWithRandomId(name, scope, description, false, mandatory2fa);
      void notifyOnRoleChanged(role);
      if (options.broadcastUpdate) {
        void api.broadcast('user.roleUpdate', {
          type: 'changed',
          _id: role._id
        });
      }
      return role;
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"updateRole.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/roles/updateRole.ts                                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      updateRole: () => updateRole
    });
    let api, MeteorError;
    module.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      },
      MeteorError(v) {
        MeteorError = v;
      }
    }, 0);
    let Roles;
    module.link("@rocket.chat/models", {
      Roles(v) {
        Roles = v;
      }
    }, 1);
    let notifyOnRoleChangedById;
    module.link("../../../../app/lib/server/lib/notifyListener", {
      notifyOnRoleChangedById(v) {
        notifyOnRoleChangedById = v;
      }
    }, 2);
    let isValidRoleScope;
    module.link("../../../../lib/roles/isValidRoleScope", {
      isValidRoleScope(v) {
        isValidRoleScope = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const updateRole = async function (roleId, roleData) {
      let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      const role = await Roles.findOneById(roleId);
      if (!role) {
        throw new MeteorError('error-invalid-roleId', 'This role does not exist');
      }
      if (role.protected && (roleData.name && roleData.name !== role.name || roleData.scope && roleData.scope !== role.scope)) {
        throw new MeteorError('error-role-protected', 'Role is protected');
      }
      if (roleData.name) {
        const otherRole = await Roles.findOneByName(roleData.name, {
          projection: {
            _id: 1
          }
        });
        if (otherRole && otherRole._id !== role._id) {
          throw new MeteorError('error-duplicate-role-names-not-allowed', 'Role name already exists');
        }
      } else {
        roleData.name = role.name;
      }
      if (roleData.scope) {
        if (!isValidRoleScope(roleData.scope)) {
          throw new MeteorError('error-invalid-scope', 'Invalid scope');
        }
      } else {
        roleData.scope = role.scope;
      }
      await Roles.updateById(roleId, roleData.name, roleData.scope, roleData.description, roleData.mandatory2fa);
      void notifyOnRoleChangedById(roleId);
      if (options.broadcastUpdate) {
        void api.broadcast('user.roleUpdate', {
          type: 'changed',
          _id: roleId,
          scope: roleData.scope
        });
      }
      const updatedRole = await Roles.findOneById(roleId);
      if (!updatedRole) {
        throw new MeteorError('error-role-not-found', 'Role not found');
      }
      return updatedRole;
    };
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"constants.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/constants.ts                                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
module.export({
  MAX_ROOM_SIZE_CHECK_INDIVIDUAL_READ_RECEIPTS: () => MAX_ROOM_SIZE_CHECK_INDIVIDUAL_READ_RECEIPTS
});
const MAX_ROOM_SIZE_CHECK_INDIVIDUAL_READ_RECEIPTS = 50;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"syncUserRoles.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/lib/syncUserRoles.ts                                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      syncUserRoles: () => syncUserRoles
    });
    let api;
    module.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      }
    }, 0);
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 1);
    let Users;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      }
    }, 2);
    let settings;
    module.link("../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 3);
    let addUserRolesAsync;
    module.link("../../../server/lib/roles/addUserRoles", {
      addUserRolesAsync(v) {
        addUserRolesAsync = v;
      }
    }, 4);
    let removeUserFromRolesAsync;
    module.link("../../../server/lib/roles/removeUserFromRoles", {
      removeUserFromRolesAsync(v) {
        removeUserFromRolesAsync = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    function filterRoleList(roleList, rolesToFilterOut, rolesToFilterIn) {
      const filteredRoles = roleList.filter(roleId => !rolesToFilterOut.includes(roleId));
      if (!rolesToFilterIn) {
        return filteredRoles;
      }
      return filteredRoles.filter(roleId => rolesToFilterIn.includes(roleId));
    }
    function broadcastRoleChange(type, roleList, user) {
      if (!settings.get('UI_DisplayRoles')) {
        return;
      }
      const {
        _id,
        username
      } = user;
      for (const roleId of roleList) {
        void api.broadcast('user.roleUpdate', {
          type,
          _id: roleId,
          u: {
            _id,
            username
          }
        });
      }
    }
    async function syncUserRoles(uid, newRoleList, _ref) {
      let {
        allowedRoles,
        skipRemovingRoles,
        scope
      } = _ref;
      const user = await Users.findOneById(uid, {
        projection: {
          username: 1,
          roles: 1
        }
      });
      if (!user) {
        throw new Error('error-user-not-found');
      }
      const existingRoles = user.roles;
      const rolesToAdd = filterRoleList(newRoleList, existingRoles, allowedRoles);
      const rolesToRemove = filterRoleList(existingRoles, newRoleList, allowedRoles);
      if (!rolesToAdd.length && !rolesToRemove.length) {
        return;
      }
      const wasGuest = existingRoles.length === 1 && existingRoles[0] === 'guest';
      if (wasGuest && (await License.shouldPreventAction('activeUsers'))) {
        throw new Error('error-license-user-limit-reached');
      }
      if (rolesToAdd.length && (await addUserRolesAsync(uid, rolesToAdd, scope))) {
        broadcastRoleChange('added', rolesToAdd, user);
      }
      if (skipRemovingRoles || !rolesToRemove.length) {
        return;
      }
      if (await removeUserFromRolesAsync(uid, rolesToRemove, scope)) {
        broadcastRoleChange('removed', rolesToRemove, user);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"api":{"engagementDashboard":{"channels.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/engagementDashboard/channels.ts                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let check, Match;
    module.link("meteor/check", {
      check(v) {
        check = v;
      },
      Match(v) {
        Match = v;
      }
    }, 0);
    let API;
    module.link("../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    let getPaginationItems;
    module.link("../../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 2);
    let apiDeprecationLogger;
    module.link("../../../../app/lib/server/lib/deprecationWarningLogger", {
      apiDeprecationLogger(v) {
        apiDeprecationLogger = v;
      }
    }, 3);
    let findChannelsWithNumberOfMessages;
    module.link("../../lib/engagementDashboard/channels", {
      findChannelsWithNumberOfMessages(v) {
        findChannelsWithNumberOfMessages = v;
      }
    }, 4);
    let isDateISOString, mapDateForAPI;
    module.link("../../lib/engagementDashboard/date", {
      isDateISOString(v) {
        isDateISOString = v;
      },
      mapDateForAPI(v) {
        mapDateForAPI = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('engagement-dashboard/channels/list', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString),
          end: Match.Where(isDateISOString),
          hideRoomsWithNoActivity: Match.Maybe(String),
          offset: Match.Maybe(String),
          count: Match.Maybe(String)
        }));
        const {
          start,
          end,
          hideRoomsWithNoActivity
        } = this.queryParams;
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        if (hideRoomsWithNoActivity === undefined) {
          apiDeprecationLogger.deprecatedParameterUsage(this.route, 'hideRoomsWithNoActivity', '7.0.0', this.response, _ref => {
            let {
              parameter,
              endpoint,
              version
            } = _ref;
            return "Returning rooms that had no activity in ".concat(endpoint, " is deprecated and will be removed on version ").concat(version, " along with the `").concat(parameter, "` param. Set `").concat(parameter, "` as `true` to check how the endpoint will behave starting on ").concat(version);
          });
        }
        const {
          channels,
          total
        } = await findChannelsWithNumberOfMessages({
          start: mapDateForAPI(start),
          end: mapDateForAPI(end),
          hideRoomsWithNoActivity: hideRoomsWithNoActivity === 'true',
          options: {
            offset,
            count
          }
        });
        return API.v1.success({
          channels,
          total,
          offset,
          count: channels.length
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/engagementDashboard/index.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./messages");
    module.link("./channels");
    module.link("./users");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"messages.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/engagementDashboard/messages.ts                                                                       //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let check, Match;
    module.link("meteor/check", {
      check(v) {
        check = v;
      },
      Match(v) {
        Match = v;
      }
    }, 0);
    let API;
    module.link("../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    let isDateISOString, transformDatesForAPI;
    module.link("../../lib/engagementDashboard/date", {
      isDateISOString(v) {
        isDateISOString = v;
      },
      transformDatesForAPI(v) {
        transformDatesForAPI = v;
      }
    }, 2);
    let findWeeklyMessagesSentData, findMessagesSentOrigin, findTopFivePopularChannelsByMessageSentQuantity;
    module.link("../../lib/engagementDashboard/messages", {
      findWeeklyMessagesSentData(v) {
        findWeeklyMessagesSentData = v;
      },
      findMessagesSentOrigin(v) {
        findMessagesSentOrigin = v;
      },
      findTopFivePopularChannelsByMessageSentQuantity(v) {
        findTopFivePopularChannelsByMessageSentQuantity = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('engagement-dashboard/messages/messages-sent', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString),
          end: Match.Where(isDateISOString)
        }));
        const {
          start,
          end
        } = this.queryParams;
        const data = await findWeeklyMessagesSentData(transformDatesForAPI(start, end));
        return API.v1.success(data);
      }
    });
    API.v1.addRoute('engagement-dashboard/messages/origin', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString),
          end: Match.Where(isDateISOString)
        }));
        const {
          start,
          end
        } = this.queryParams;
        const data = await findMessagesSentOrigin(transformDatesForAPI(start, end));
        return API.v1.success(data);
      }
    });
    API.v1.addRoute('engagement-dashboard/messages/top-five-popular-channels', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString),
          end: Match.Where(isDateISOString)
        }));
        const {
          start,
          end
        } = this.queryParams;
        const data = await findTopFivePopularChannelsByMessageSentQuantity(transformDatesForAPI(start, end));
        return API.v1.success(data);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"users.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/engagementDashboard/users.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let check, Match;
    module.link("meteor/check", {
      check(v) {
        check = v;
      },
      Match(v) {
        Match = v;
      }
    }, 0);
    let API;
    module.link("../../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 1);
    let isDateISOString, transformDatesForAPI;
    module.link("../../lib/engagementDashboard/date", {
      isDateISOString(v) {
        isDateISOString = v;
      },
      transformDatesForAPI(v) {
        transformDatesForAPI = v;
      }
    }, 2);
    let findWeeklyUsersRegisteredData, findActiveUsersMonthlyData, findBusiestsChatsInADayByHours, findBusiestsChatsWithinAWeek, findUserSessionsByHourWithinAWeek;
    module.link("../../lib/engagementDashboard/users", {
      findWeeklyUsersRegisteredData(v) {
        findWeeklyUsersRegisteredData = v;
      },
      findActiveUsersMonthlyData(v) {
        findActiveUsersMonthlyData = v;
      },
      findBusiestsChatsInADayByHours(v) {
        findBusiestsChatsInADayByHours = v;
      },
      findBusiestsChatsWithinAWeek(v) {
        findBusiestsChatsWithinAWeek = v;
      },
      findUserSessionsByHourWithinAWeek(v) {
        findUserSessionsByHourWithinAWeek = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('engagement-dashboard/users/new-users', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString),
          end: Match.Where(isDateISOString)
        }));
        const {
          start,
          end
        } = this.queryParams;
        const data = await findWeeklyUsersRegisteredData(transformDatesForAPI(start, end));
        return API.v1.success(data);
      }
    });
    API.v1.addRoute('engagement-dashboard/users/active-users', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString),
          end: Match.Where(isDateISOString)
        }));
        const {
          start,
          end
        } = this.queryParams;
        const data = await findActiveUsersMonthlyData(transformDatesForAPI(start, end));
        return API.v1.success(data);
      }
    });
    API.v1.addRoute('engagement-dashboard/users/chat-busier/hourly-data', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString)
        }));
        const {
          start
        } = this.queryParams;
        const data = await findBusiestsChatsInADayByHours(transformDatesForAPI(start));
        return API.v1.success(data);
      }
    });
    API.v1.addRoute('engagement-dashboard/users/chat-busier/weekly-data', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString)
        }));
        const {
          start
        } = this.queryParams;
        const data = await findBusiestsChatsWithinAWeek(transformDatesForAPI(start));
        return API.v1.success(data);
      }
    });
    API.v1.addRoute('engagement-dashboard/users/users-by-time-of-the-day-in-a-week', {
      authRequired: true,
      permissionsRequired: ['view-engagement-dashboard'],
      license: ['engagement-dashboard']
    }, {
      async get() {
        check(this.queryParams, Match.ObjectIncluding({
          start: Match.Where(isDateISOString),
          end: Match.Where(isDateISOString)
        }));
        const {
          start,
          end
        } = this.queryParams;
        const data = await findUserSessionsByHourWithinAWeek(transformDatesForAPI(start, end));
        return API.v1.success(data);
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"api.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/api.ts                                                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let API;
    module.link("../../../app/api/server/api", {
      API(v) {
        API = v;
      }
    }, 1);
    let use;
    module.link("../../../app/settings/server/Middleware", {
      use(v) {
        use = v;
      }
    }, 2);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    // Overwrites two factor method to enforce 2FA check for enterprise APIs when
    // no license was provided to prevent abuse on enterprise APIs.
    const isNonEnterpriseTwoFactorOptions = options => !!options && 'forceTwoFactorAuthenticationForNonEnterprise' in options && Boolean(options.forceTwoFactorAuthenticationForNonEnterprise);
    API.v1.processTwoFactor = use(API.v1.processTwoFactor, (_ref, next) => {
      let [params, ...context] = _ref;
      if (isNonEnterpriseTwoFactorOptions(params.options) && !License.hasValidLicense()) {
        const options = _objectSpread(_objectSpread({}, params.options), {}, {
          twoFactorOptions: {
            disableRememberMe: true,
            requireSecondFactor: true,
            disablePasswordFallback: false
          },
          twoFactorRequired: true,
          authRequired: true
        });
        return next(_objectSpread(_objectSpread({}, params), {}, {
          options
        }), ...context);
      }
      return next(params, ...context);
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"audit.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/audit.ts                                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      isAuditRoomMembersProps: () => isAuditRoomMembersProps
    });
    let Rooms, AuditLog, ServerEvents;
    module.link("@rocket.chat/models", {
      Rooms(v) {
        Rooms = v;
      },
      AuditLog(v) {
        AuditLog = v;
      },
      ServerEvents(v) {
        ServerEvents = v;
      }
    }, 0);
    let isServerEventsAuditSettingsProps;
    module.link("@rocket.chat/rest-typings", {
      isServerEventsAuditSettingsProps(v) {
        isServerEventsAuditSettingsProps = v;
      }
    }, 1);
    let convertSubObjectsIntoPaths;
    module.link("@rocket.chat/tools", {
      convertSubObjectsIntoPaths(v) {
        convertSubObjectsIntoPaths = v;
      }
    }, 2);
    let Ajv;
    module.link("ajv", {
      default(v) {
        Ajv = v;
      }
    }, 3);
    let API;
    module.link("../../../app/api/server/api", {
      API(v) {
        API = v;
      }
    }, 4);
    let getPaginationItems;
    module.link("../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 5);
    let findUsersOfRoom;
    module.link("../../../server/lib/findUsersOfRoom", {
      findUsersOfRoom(v) {
        findUsersOfRoom = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const ajv = new Ajv({
      coerceTypes: true
    });
    const auditRoomMembersSchema = {
      type: 'object',
      properties: {
        roomId: {
          type: 'string',
          minLength: 1
        },
        filter: {
          type: 'string'
        },
        count: {
          type: 'number'
        },
        offset: {
          type: 'number'
        },
        sort: {
          type: 'string'
        }
      },
      required: ['roomId'],
      additionalProperties: false
    };
    const isAuditRoomMembersProps = ajv.compile(auditRoomMembersSchema);
    API.v1.addRoute('audit/rooms.members', {
      authRequired: true,
      permissionsRequired: ['view-members-list-all-rooms'],
      validateParams: isAuditRoomMembersProps,
      license: ['auditing']
    }, {
      async get() {
        const {
          roomId,
          filter
        } = this.queryParams;
        const {
          count: limit,
          offset: skip
        } = await getPaginationItems(this.queryParams);
        const {
          sort
        } = await this.parseJsonQuery();
        const room = await Rooms.findOneById(roomId, {
          projection: {
            _id: 1,
            name: 1,
            fname: 1
          }
        });
        if (!room) {
          return API.v1.notFound();
        }
        const {
          cursor,
          totalCount
        } = findUsersOfRoom(_objectSpread({
          rid: room._id,
          filter,
          skip,
          limit
        }, (sort === null || sort === void 0 ? void 0 : sort.username) && {
          sort: {
            username: sort.username
          }
        }));
        const [members, total] = await Promise.all([cursor.toArray(), totalCount]);
        await AuditLog.insertOne({
          ts: new Date(),
          results: total,
          u: _objectSpread({
            _id: this.user._id,
            username: this.user.username,
            name: this.user.name
          }, this.user.avatarETag && {
            avatarETag: this.user.avatarETag
          }),
          fields: {
            msg: 'Room_members_list',
            rids: [room._id],
            type: 'room_member_list',
            room: room.name || room.fname,
            filters: filter
          }
        });
        return API.v1.success({
          members,
          count: members.length,
          offset: skip,
          total
        });
      }
    });
    API.v1.get('audit.settings', {
      response: {
        200: ajv.compile({
          additionalProperties: false,
          type: 'object',
          properties: {
            events: {
              type: 'array',
              items: {
                type: 'object'
              }
            },
            count: {
              type: 'number',
              description: 'The number of events returned in this response.'
            },
            offset: {
              type: 'number',
              description: 'The number of events that were skipped in this response.'
            },
            total: {
              type: 'number',
              description: 'The total number of events that match the query.'
            },
            success: {
              type: 'boolean',
              description: 'Indicates if the request was successful.'
            }
          },
          required: ['events', 'count', 'offset', 'total', 'success']
        }),
        400: ajv.compile({
          type: 'object',
          properties: {
            success: {
              type: 'boolean',
              enum: [false]
            },
            error: {
              type: 'string'
            },
            errorType: {
              type: 'string'
            }
          },
          required: ['success', 'error']
        })
      },
      query: isServerEventsAuditSettingsProps,
      authRequired: true,
      permissionsRequired: ['can-audit'],
      license: ['auditing']
    }, async function action() {
      const {
        start,
        end,
        settingId,
        actor
      } = this.queryParams;
      if (start && isNaN(Date.parse(start))) {
        return API.v1.failure('The "start" query parameter must be a valid date.');
      }
      if (end && isNaN(Date.parse(end))) {
        return API.v1.failure('The "end" query parameter must be a valid date.');
      }
      const {
        offset,
        count
      } = await getPaginationItems(this.queryParams);
      const {
        sort
      } = await this.parseJsonQuery();
      const _sort = {
        ts: sort !== null && sort !== void 0 && sort.ts ? sort === null || sort === void 0 ? void 0 : sort.ts : -1
      };
      const {
        cursor,
        totalCount
      } = ServerEvents.findPaginated(_objectSpread(_objectSpread(_objectSpread({}, settingId && {
        'data.key': 'id',
        'data.value': settingId
      }), actor && convertSubObjectsIntoPaths({
        actor
      })), {}, {
        ts: {
          $gte: start ? new Date(start) : new Date(0),
          $lte: end ? new Date(end) : new Date()
        },
        t: 'settings.changed'
      }), {
        sort: _sort,
        skip: offset,
        limit: count,
        allowDiskUse: true
      });
      const [events, total] = await Promise.all([cursor.toArray(), totalCount]);
      return API.v1.success({
        events,
        count: events.length,
        offset,
        total
      });
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"chat.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/chat.ts                                                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let Meteor;
    module.link("meteor/meteor", {
      Meteor(v) {
        Meteor = v;
      }
    }, 1);
    let API;
    module.link("../../../app/api/server/api", {
      API(v) {
        API = v;
      }
    }, 2);
    let getReadReceiptsFunction;
    module.link("../methods/getReadReceipts", {
      getReadReceiptsFunction(v) {
        getReadReceiptsFunction = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('chat.getMessageReadReceipts', {
      authRequired: true
      // license: ['message-read-receipt']
    }, {
      async get() {
        if (!License.hasModule('message-read-receipt')) {
          throw new Meteor.Error('error-action-not-allowed', 'This is an enterprise feature');
        }
        const {
          messageId
        } = this.queryParams;
        if (!messageId) {
          return API.v1.failure({
            error: "The required 'messageId' param is missing."
          });
        }
        return API.v1.success({
          receipts: await getReadReceiptsFunction(messageId, this.userId)
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"federation.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/federation.ts                                                                                         //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      registerFederationRoutes: () => registerFederationRoutes
    });
    let FederationMatrix;
    module.link("@rocket.chat/core-services", {
      FederationMatrix(v) {
        FederationMatrix = v;
      }
    }, 0);
    let getFederationRoutes;
    module.link("@rocket.chat/federation-matrix", {
      getFederationRoutes(v) {
        getFederationRoutes = v;
      }
    }, 1);
    let Logger;
    module.link("@rocket.chat/logger", {
      Logger(v) {
        Logger = v;
      }
    }, 2);
    let ajv;
    module.link("@rocket.chat/rest-typings", {
      ajv(v) {
        ajv = v;
      }
    }, 3);
    let WebApp;
    module.link("meteor/webapp", {
      WebApp(v) {
        WebApp = v;
      }
    }, 4);
    let API;
    module.link("../../../app/api/server", {
      API(v) {
        API = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const logger = new Logger('FederationRoutes');
    API.v1.get('/federation/matrixIds.verify', {
      authRequired: true,
      query: ajv.compile({
        type: 'object',
        properties: {
          matrixIds: {
            type: 'array',
            items: {
              type: 'string'
            }
          }
        }
      }),
      response: {
        200: ajv.compile({
          type: 'object',
          properties: {
            results: {
              type: 'object',
              additionalProperties: {
                type: 'string'
              }
            }
          }
        })
      }
    }, async function () {
      const {
        matrixIds
      } = this.queryParams;
      return API.v1.success({
        results: await FederationMatrix.verifyMatrixIds(matrixIds)
      });
    });
    async function registerFederationRoutes() {
      try {
        const routes = getFederationRoutes();
        WebApp.rawConnectHandlers.use(routes.matrix.router).use(routes.wellKnown.router);
      } catch (error) {
        logger.error({
          msg: '[Federation] Failed to register routes:',
          err: error
        });
        throw error;
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/index.ts                                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.link("./api");
    module.link("./ldap");
    module.link("./licenses");
    module.link("./sessions");
    module.link("./chat");
    module.link("./roles");
    module.link("../apps/communication/uikit");
    module.link("./engagementDashboard");
    module.link("./audit");
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"ldap.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/ldap.ts                                                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let API;
    module.link("../../../app/api/server/api", {
      API(v) {
        API = v;
      }
    }, 0);
    let hasPermissionAsync;
    module.link("../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 1);
    let settings;
    module.link("../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 2);
    let LDAPEE;
    module.link("../sdk", {
      LDAPEE(v) {
        LDAPEE = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('ldap.syncNow', {
      authRequired: true,
      forceTwoFactorAuthenticationForNonEnterprise: true,
      twoFactorRequired: true
      // license: ['ldap-enterprise'],
    }, {
      async post() {
        if (!this.userId) {
          throw new Error('error-invalid-user');
        }
        if (!(await hasPermissionAsync(this.userId, 'sync-auth-services-users'))) {
          throw new Error('error-not-authorized');
        }
        if (settings.get('LDAP_Enable') !== true) {
          throw new Error('LDAP_disabled');
        }
        await LDAPEE.sync();
        await LDAPEE.syncAvatars();
        return API.v1.success({
          message: 'Sync_in_progress'
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"licenses.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/licenses.ts                                                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let Settings, Users;
    module.link("@rocket.chat/models", {
      Settings(v) {
        Settings = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let isLicensesInfoProps;
    module.link("@rocket.chat/rest-typings", {
      isLicensesInfoProps(v) {
        isLicensesInfoProps = v;
      }
    }, 2);
    let check;
    module.link("meteor/check", {
      check(v) {
        check = v;
      }
    }, 3);
    let API;
    module.link("../../../app/api/server/api", {
      API(v) {
        API = v;
      }
    }, 4);
    let hasPermissionAsync;
    module.link("../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 5);
    let notifyOnSettingChangedById;
    module.link("../../../app/lib/server/lib/notifyListener", {
      notifyOnSettingChangedById(v) {
        notifyOnSettingChangedById = v;
      }
    }, 6);
    let settings;
    module.link("../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 7);
    let updateAuditedByUser;
    module.link("../../../server/settings/lib/auditedSettingUpdates", {
      updateAuditedByUser(v) {
        updateAuditedByUser = v;
      }
    }, 8);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    API.v1.addRoute('licenses.info', {
      authRequired: true,
      validateParams: isLicensesInfoProps
    }, {
      async get() {
        const unrestrictedAccess = await hasPermissionAsync(this.userId, 'view-privileged-setting');
        const loadCurrentValues = unrestrictedAccess && Boolean(this.queryParams.loadValues);
        const license = await License.getInfo({
          limits: unrestrictedAccess,
          license: unrestrictedAccess,
          currentValues: loadCurrentValues
        });
        try {
          var _settings$get;
          // TODO: Remove this logic after setting type object is implemented.
          const cloudSyncAnnouncement = JSON.parse((_settings$get = settings.get('Cloud_Sync_Announcement_Payload')) !== null && _settings$get !== void 0 ? _settings$get : null);
          const canManageCloud = await hasPermissionAsync(this.userId, 'manage-cloud');
          return API.v1.success(_objectSpread({
            license
          }, canManageCloud && cloudSyncAnnouncement && {
            cloudSyncAnnouncement
          }));
        } catch (error) {
          console.error('Unable to parse Cloud_Sync_Announcement_Payload');
        }
        return API.v1.success({
          license
        });
      }
    });
    API.v1.addRoute('licenses.add', {
      authRequired: true,
      permissionsRequired: ['edit-privileged-setting']
    }, {
      async post() {
        check(this.bodyParams, {
          license: String
        });
        const {
          license
        } = this.bodyParams;
        if (!(await License.validateFormat(license))) {
          return API.v1.failure('Invalid license');
        }
        const auditSettingOperation = updateAuditedByUser({
          _id: this.userId,
          username: this.user.username,
          ip: this.requestIp,
          useragent: this.request.headers.get('user-agent') || ''
        });
        (await auditSettingOperation(Settings.updateValueById, 'Enterprise_License', license)).modifiedCount && void notifyOnSettingChangedById('Enterprise_License');
        return API.v1.success();
      }
    });
    API.v1.addRoute('licenses.maxActiveUsers', {
      authRequired: true
    }, {
      async get() {
        const maxActiveUsers = License.getMaxActiveUsers();
        const activeUsers = await Users.getActiveLocalUserCount();
        return API.v1.success({
          maxActiveUsers: maxActiveUsers > 0 ? maxActiveUsers : null,
          activeUsers
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"roles.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/roles.ts                                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      isRoleCreateProps: () => isRoleCreateProps,
      isRoleUpdateProps: () => isRoleUpdateProps
    });
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 0);
    let Roles;
    module.link("@rocket.chat/models", {
      Roles(v) {
        Roles = v;
      }
    }, 1);
    let Ajv;
    module.link("ajv", {
      default(v) {
        Ajv = v;
      }
    }, 2);
    let API;
    module.link("../../../app/api/server/api", {
      API(v) {
        API = v;
      }
    }, 3);
    let hasPermissionAsync;
    module.link("../../../app/authorization/server/functions/hasPermission", {
      hasPermissionAsync(v) {
        hasPermissionAsync = v;
      }
    }, 4);
    let settings;
    module.link("../../../app/settings/server/index", {
      settings(v) {
        settings = v;
      }
    }, 5);
    let insertRoleAsync;
    module.link("../lib/roles/insertRole", {
      insertRoleAsync(v) {
        insertRoleAsync = v;
      }
    }, 6);
    let updateRole;
    module.link("../lib/roles/updateRole", {
      updateRole(v) {
        updateRole = v;
      }
    }, 7);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const ajv = new Ajv({
      coerceTypes: true
    });
    const roleCreatePropsSchema = {
      type: 'object',
      properties: {
        name: {
          type: 'string'
        },
        description: {
          type: 'string',
          nullable: true
        },
        scope: {
          type: 'string',
          enum: ['Users', 'Subscriptions'],
          nullable: true
        },
        mandatory2fa: {
          type: 'boolean',
          nullable: true
        }
      },
      required: ['name'],
      additionalProperties: false
    };
    const isRoleCreateProps = ajv.compile(roleCreatePropsSchema);
    const roleUpdatePropsSchema = {
      type: 'object',
      properties: {
        roleId: {
          type: 'string'
        },
        name: {
          type: 'string'
        },
        description: {
          type: 'string',
          nullable: true
        },
        scope: {
          type: 'string',
          enum: ['Users', 'Subscriptions'],
          nullable: true
        },
        mandatory2fa: {
          type: 'boolean',
          nullable: true
        }
      },
      required: ['roleId', 'name'],
      additionalProperties: false
    };
    const isRoleUpdateProps = ajv.compile(roleUpdatePropsSchema);
    API.v1.addRoute('roles.create', {
      authRequired: true,
      license: ['custom-roles']
    }, {
      async post() {
        if (!License.hasModule('custom-roles')) {
          throw new Meteor.Error('error-action-not-allowed', 'This is an enterprise feature');
        }
        if (!isRoleCreateProps(this.bodyParams)) {
          throw new Meteor.Error('error-invalid-role-properties', 'The role properties are invalid.');
        }
        const userId = Meteor.userId();
        if (!userId || !(await hasPermissionAsync(userId, 'access-permissions'))) {
          throw new Meteor.Error('error-action-not-allowed', 'Accessing permissions is not allowed');
        }
        const {
          name,
          scope,
          description,
          mandatory2fa
        } = this.bodyParams;
        if (await Roles.findOneByIdOrName(name)) {
          throw new Meteor.Error('error-duplicate-role-names-not-allowed', 'Role name already exists');
        }
        const roleData = _objectSpread(_objectSpread({
          description: description || ''
        }, mandatory2fa !== undefined && {
          mandatory2fa
        }), {}, {
          name,
          scope: scope || 'Users',
          protected: false
        });
        const options = {
          broadcastUpdate: settings.get('UI_DisplayRoles')
        };
        const role = await insertRoleAsync(roleData, options);
        return API.v1.success({
          role
        });
      }
    });
    API.v1.addRoute('roles.update', {
      authRequired: true,
      license: ['custom-roles']
    }, {
      async post() {
        if (!isRoleUpdateProps(this.bodyParams)) {
          throw new Meteor.Error('error-invalid-role-properties', 'The role properties are invalid.');
        }
        if (!(await hasPermissionAsync(this.userId, 'access-permissions'))) {
          throw new Meteor.Error('error-action-not-allowed', 'Accessing permissions is not allowed');
        }
        const {
          roleId,
          name,
          scope,
          description,
          mandatory2fa
        } = this.bodyParams;
        const role = await Roles.findOne(roleId);
        if (!License.hasModule('custom-roles') && !(role !== null && role !== void 0 && role.protected)) {
          throw new Meteor.Error('error-action-not-allowed', 'This is an enterprise feature');
        }
        const roleData = _objectSpread(_objectSpread({
          description: description || ''
        }, mandatory2fa !== undefined && {
          mandatory2fa
        }), {}, {
          name,
          scope: scope || 'Users',
          protected: false
        });
        const options = {
          broadcastUpdate: settings.get('UI_DisplayRoles')
        };
        const updatedRole = await updateRole(roleId, roleData, options);
        return API.v1.success({
          role: updatedRole
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"sessions.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/api/sessions.ts                                                                                           //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let api;
    module.link("@rocket.chat/core-services", {
      api(v) {
        api = v;
      }
    }, 0);
    let License;
    module.link("@rocket.chat/license", {
      License(v) {
        License = v;
      }
    }, 1);
    let Users, Sessions;
    module.link("@rocket.chat/models", {
      Users(v) {
        Users = v;
      },
      Sessions(v) {
        Sessions = v;
      }
    }, 2);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 3);
    let Ajv;
    module.link("ajv", {
      default(v) {
        Ajv = v;
      }
    }, 4);
    let API;
    module.link("../../../app/api/server/api", {
      API(v) {
        API = v;
      }
    }, 5);
    let getPaginationItems;
    module.link("../../../app/api/server/helpers/getPaginationItems", {
      getPaginationItems(v) {
        getPaginationItems = v;
      }
    }, 6);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const ajv = new Ajv({
      coerceTypes: true
    });
    const isSessionsProps = ajv.compile({
      type: 'object',
      properties: {
        sessionId: {
          type: 'string'
        }
      },
      required: ['sessionId'],
      additionalProperties: false
    });
    const isSessionsPaginateProps = ajv.compile({
      type: 'object',
      properties: {
        offset: {
          type: 'number'
        },
        count: {
          type: 'number'
        },
        filter: {
          type: 'string'
        },
        sort: {
          type: 'string'
        }
      },
      required: [],
      additionalProperties: false
    });
    const validateSortKeys = sortKeys => {
      const validSortKeys = ['loginAt', 'device.name', 'device.os.name', 'device.os.version', '_user.name', '_user.username'];
      return sortKeys.every(s => validSortKeys.includes(s));
    };
    API.v1.addRoute('sessions/list', {
      authRequired: true,
      validateParams: isSessionsPaginateProps,
      license: ['device-management']
    }, {
      async get() {
        var _this$queryParams;
        if (!License.hasModule('device-management')) {
          return API.v1.forbidden();
        }
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          sort = {
            loginAt: -1
          }
        } = await this.parseJsonQuery();
        const search = escapeRegExp(((_this$queryParams = this.queryParams) === null || _this$queryParams === void 0 ? void 0 : _this$queryParams.filter) || '');
        if (!validateSortKeys(Object.keys(sort))) {
          return API.v1.failure('error-invalid-sort-keys');
        }
        const sessions = await Sessions.aggregateSessionsByUserId({
          uid: this.userId,
          search,
          sort,
          offset,
          count
        });
        return API.v1.success(sessions);
      }
    });
    API.v1.addRoute('sessions/info', {
      authRequired: true,
      validateParams: isSessionsProps,
      license: ['device-management']
    }, {
      async get() {
        if (!License.hasModule('device-management')) {
          return API.v1.forbidden();
        }
        const {
          sessionId
        } = this.queryParams;
        const sessions = await Sessions.findOneBySessionIdAndUserId(sessionId, this.userId);
        if (!sessions) {
          return API.v1.notFound('Session not found');
        }
        return API.v1.success(sessions);
      }
    });
    API.v1.addRoute('sessions/logout.me', {
      authRequired: true,
      validateParams: isSessionsProps,
      license: ['device-management']
    }, {
      async post() {
        if (!License.hasModule('device-management')) {
          return API.v1.forbidden();
        }
        const {
          sessionId
        } = this.bodyParams;
        const sessionObj = await Sessions.findOneBySessionIdAndUserId(sessionId, this.userId);
        if (!(sessionObj !== null && sessionObj !== void 0 && sessionObj.loginToken)) {
          return API.v1.notFound('Session not found');
        }
        await Promise.all([Users.unsetOneLoginToken(this.userId, sessionObj.loginToken), Sessions.logoutByloginTokenAndUserId({
          loginToken: sessionObj.loginToken,
          userId: this.userId
        })]);
        return API.v1.success({
          sessionId
        });
      }
    });
    API.v1.addRoute('sessions/list.all', {
      authRequired: true,
      twoFactorRequired: true,
      validateParams: isSessionsPaginateProps,
      permissionsRequired: ['view-device-management'],
      license: ['device-management']
    }, {
      async get() {
        var _this$queryParams2;
        if (!License.hasModule('device-management')) {
          return API.v1.forbidden();
        }
        const {
          offset,
          count
        } = await getPaginationItems(this.queryParams);
        const {
          sort = {
            loginAt: -1
          }
        } = await this.parseJsonQuery();
        const filter = escapeRegExp(((_this$queryParams2 = this.queryParams) === null || _this$queryParams2 === void 0 ? void 0 : _this$queryParams2.filter) || '');
        if (!validateSortKeys(Object.keys(sort))) {
          return API.v1.failure('error-invalid-sort-keys');
        }
        const search = [];
        if (filter) {
          search.push(filter);
          search.push(...(await Users.findActiveByUsernameOrNameRegexWithExceptionsAndConditions({
            $regex: filter,
            $options: 'i'
          }, [], {}, {
            projection: {
              _id: 1
            },
            limit: 5
          }).map(el => el._id).toArray()));
        }
        const sessions = await Sessions.aggregateSessionsAndPopulate({
          search: search.join('|'),
          sort,
          offset,
          count
        });
        return API.v1.success(sessions);
      }
    });
    API.v1.addRoute('sessions/info.admin', {
      authRequired: true,
      twoFactorRequired: true,
      validateParams: isSessionsProps,
      permissionsRequired: ['view-device-management'],
      license: ['device-management']
    }, {
      async get() {
        var _this$queryParams3;
        if (!License.hasModule('device-management')) {
          return API.v1.forbidden();
        }
        const sessionId = (_this$queryParams3 = this.queryParams) === null || _this$queryParams3 === void 0 ? void 0 : _this$queryParams3.sessionId;
        const {
          sessions
        } = await Sessions.aggregateSessionsAndPopulate({
          search: sessionId,
          count: 1
        });
        if (!(sessions !== null && sessions !== void 0 && sessions.length)) {
          return API.v1.notFound('Session not found');
        }
        return API.v1.success(sessions[0]);
      }
    });
    API.v1.addRoute('sessions/logout', {
      authRequired: true,
      twoFactorRequired: true,
      validateParams: isSessionsProps,
      permissionsRequired: ['logout-device-management'],
      license: ['device-management']
    }, {
      async post() {
        if (!License.hasModule('device-management')) {
          return API.v1.forbidden();
        }
        const {
          sessionId
        } = this.bodyParams;
        const sessionObj = await Sessions.findOneBySessionId(sessionId);
        if (!(sessionObj !== null && sessionObj !== void 0 && sessionObj.loginToken)) {
          return API.v1.notFound('Session not found');
        }
        await api.broadcast('user.forceLogout', sessionObj.userId);
        await Promise.all([Users.unsetOneLoginToken(sessionObj.userId, sessionObj.loginToken), Sessions.logoutByloginTokenAndUserId({
          loginToken: sessionObj.loginToken,
          userId: sessionObj.userId,
          logoutBy: this.userId
        })]);
        return API.v1.success({
          sessionId
        });
      }
    });
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"hooks":{"federation":{"index.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/hooks/federation/index.ts                                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let FederationMatrix, Authorization, MeteorError;
    module.link("@rocket.chat/core-services", {
      FederationMatrix(v) {
        FederationMatrix = v;
      },
      Authorization(v) {
        Authorization = v;
      },
      MeteorError(v) {
        MeteorError = v;
      }
    }, 0);
    let isEditedMessage;
    module.link("@rocket.chat/core-typings", {
      isEditedMessage(v) {
        isEditedMessage = v;
      }
    }, 1);
    let Rooms;
    module.link("@rocket.chat/models", {
      Rooms(v) {
        Rooms = v;
      }
    }, 2);
    let callbacks;
    module.link("../../../../lib/callbacks", {
      callbacks(v) {
        callbacks = v;
      }
    }, 3);
    let afterLeaveRoomCallback;
    module.link("../../../../lib/callbacks/afterLeaveRoomCallback", {
      afterLeaveRoomCallback(v) {
        afterLeaveRoomCallback = v;
      }
    }, 4);
    let afterRemoveFromRoomCallback;
    module.link("../../../../lib/callbacks/afterRemoveFromRoomCallback", {
      afterRemoveFromRoomCallback(v) {
        afterRemoveFromRoomCallback = v;
      }
    }, 5);
    let beforeAddUsersToRoom, beforeAddUserToRoom;
    module.link("../../../../lib/callbacks/beforeAddUserToRoom", {
      beforeAddUsersToRoom(v) {
        beforeAddUsersToRoom = v;
      },
      beforeAddUserToRoom(v) {
        beforeAddUserToRoom = v;
      }
    }, 6);
    let beforeChangeRoomRole;
    module.link("../../../../lib/callbacks/beforeChangeRoomRole", {
      beforeChangeRoomRole(v) {
        beforeChangeRoomRole = v;
      }
    }, 7);
    let FederationActions;
    module.link("../../../../server/services/room/hooks/BeforeFederationActions", {
      FederationActions(v) {
        FederationActions = v;
      }
    }, 8);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    // callbacks.add('federation-event-example', async () => FederationMatrix.handleExample(), callbacks.priority.MEDIUM, 'federation-event-example-handler');
    // TODO: move this to the hooks folder
    callbacks.add('federation.afterCreateFederatedRoom', async (room, _ref) => {
      let {
        owner,
        originalMemberList: members,
        options
      } = _ref;
      if (FederationActions.shouldPerformFederationAction(room)) {
        const federatedRoomId = options === null || options === void 0 ? void 0 : options.federatedRoomId;
        if (!federatedRoomId) {
          // if room exists, we don't want to create it again
          // adds bridge record
          await FederationMatrix.createRoom(room, owner, members);
        } else {
          // matrix room was already created and passed
          const fromServer = federatedRoomId.split(':')[1];
          await Rooms.setAsFederated(room._id, {
            mrid: federatedRoomId,
            origin: fromServer
          });
        }
      }
    });
    callbacks.add('afterSaveMessage', async (message, _ref2) => {
      let {
        room,
        user
      } = _ref2;
      if (!FederationActions.shouldPerformFederationAction(room)) {
        return;
      }
      try {
        var _message$federation;
        // TODO: Check if message already exists in the database, if it does, don't send it to the federation to avoid loops
        // If message is federated, it will save external_message_id like into the message object
        // if this prop exists here it should not be sent to the federation to avoid loops
        if (!((_message$federation = message.federation) !== null && _message$federation !== void 0 && _message$federation.eventId)) {
          await FederationMatrix.sendMessage(message, room, user);
        }
      } catch (error) {
        // Log the error but don't prevent the message from being sent locally
        console.error('[sendMessage] Failed to send message to Native Federation:', error);
      }
    }, callbacks.priority.HIGH, 'native-federation-after-room-message-sent');
    callbacks.add('afterDeleteMessage', async (message, _ref3) => {
      var _message$federation2;
      let {
        room
      } = _ref3;
      if (!((_message$federation2 = message.federation) !== null && _message$federation2 !== void 0 && _message$federation2.eventId)) {
        return;
      }
      if (FederationActions.shouldPerformFederationAction(room)) {
        await FederationMatrix.deleteMessage(room.federation.mrid, message);
      }
    }, callbacks.priority.MEDIUM, 'native-federation-after-delete-message');
    beforeAddUsersToRoom.add(async (_ref4, room) => {
      let {
        usernames
      } = _ref4;
      if (FederationActions.shouldPerformFederationAction(room)) {
        await FederationMatrix.ensureFederatedUsersExistLocally(usernames);
      }
    });
    beforeAddUserToRoom.add(async (_ref5, room) => {
      let {
        user,
        inviter
      } = _ref5;
      if (!user.username || !inviter) {
        return;
      }
      if (FederationActions.shouldPerformFederationAction(room)) {
        if (!(await Authorization.hasPermission(user._id, 'access-federation'))) {
          throw new MeteorError('error-not-authorized-federation', 'Not authorized to access federation');
        }
        await FederationMatrix.inviteUsersToRoom(room, [user.username], inviter);
      }
    }, callbacks.priority.MEDIUM, 'native-federation-on-before-add-users-to-room');
    callbacks.add('afterSetReaction', async (message, params) => {
      var _params$user$username;
      // Don't federate reactions that came from Matrix
      if ((_params$user$username = params.user.username) !== null && _params$user$username !== void 0 && _params$user$username.includes(':')) {
        return;
      }
      if (FederationActions.shouldPerformFederationAction(params.room)) {
        await FederationMatrix.sendReaction(message._id, params.reaction, params.user);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-after-set-reaction');
    callbacks.add('afterUnsetReaction', async (_message, params) => {
      var _params$user$username2;
      // Don't federate reactions that came from Matrix
      if ((_params$user$username2 = params.user.username) !== null && _params$user$username2 !== void 0 && _params$user$username2.includes(':')) {
        return;
      }
      if (FederationActions.shouldPerformFederationAction(params.room)) {
        await FederationMatrix.removeReaction(params.oldMessage._id, params.reaction, params.user, params.oldMessage);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-after-unset-reaction');
    afterLeaveRoomCallback.add(async (_ref6, room) => {
      let {
        user,
        kicker
      } = _ref6;
      if (FederationActions.shouldPerformFederationAction(room)) {
        await FederationMatrix.leaveRoom(room._id, user, kicker);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-after-leave-room');
    afterRemoveFromRoomCallback.add(async (data, room) => {
      if (FederationActions.shouldPerformFederationAction(room)) {
        await FederationMatrix.kickUser(room, data.removedUser, data.userWhoRemoved);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-after-remove-from-room');
    callbacks.add('afterRoomNameChange', async _ref7 => {
      let {
        room,
        name,
        user
      } = _ref7;
      if (FederationActions.shouldPerformFederationAction(room)) {
        await FederationMatrix.updateRoomName(room._id, name, user);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-after-room-name-changed');
    callbacks.add('afterRoomTopicChange', async (_, _ref8) => {
      let {
        room,
        topic,
        user
      } = _ref8;
      if (FederationActions.shouldPerformFederationAction(room)) {
        await FederationMatrix.updateRoomTopic(room, topic, user);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-after-room-topic-changed');
    callbacks.add('afterSaveMessage', async (message, _ref9) => {
      let {
        room
      } = _ref9;
      if (FederationActions.shouldPerformFederationAction(room)) {
        if (!isEditedMessage(message)) {
          return;
        }
        await FederationMatrix.updateMessage(room, message);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-after-room-message-updated');
    beforeChangeRoomRole.add(async params => {
      if (FederationActions.shouldPerformFederationAction(params.room)) {
        await FederationMatrix.addUserRoleRoomScoped(params.room, params.fromUserId, params.userId, params.role);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-before-change-room-role');
    callbacks.add('beforeCreateDirectRoom', async (members, room) => {
      if (FederationActions.shouldPerformFederationAction(room)) {
        await FederationMatrix.ensureFederatedUsersExistLocally(members);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-before-create-direct-room');
    callbacks.add('afterCreateDirectRoom', async (room, params) => {
      if (params.mrid) {
        await Rooms.setAsFederated(room._id, {
          mrid: params.mrid,
          origin: params.mrid.split(':').pop()
        });
        return;
      }
      if (FederationActions.shouldPerformFederationAction(room)) {
        await FederationMatrix.createDirectMessageRoom(room, params.members, params.creatorId);
      }
    }, callbacks.priority.HIGH, 'federation-matrix-after-create-direct-room');
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"messages":{"BeforeSaveCannedResponse.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/hooks/messages/BeforeSaveCannedResponse.ts                                                                //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      BeforeSaveCannedResponse: () => BeforeSaveCannedResponse
    });
    let isILivechatVisitor, isOmnichannelRoom;
    module.link("@rocket.chat/core-typings", {
      isILivechatVisitor(v) {
        isILivechatVisitor = v;
      },
      isOmnichannelRoom(v) {
        isOmnichannelRoom = v;
      }
    }, 0);
    let LivechatVisitors, Users;
    module.link("@rocket.chat/models", {
      LivechatVisitors(v) {
        LivechatVisitors = v;
      },
      Users(v) {
        Users = v;
      }
    }, 1);
    let get;
    module.link("lodash.get", {
      default(v) {
        get = v;
      }
    }, 2);
    let mem;
    module.link("mem", {
      default(v) {
        mem = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const placeholderFields = {
      'contact.name': {
        from: 'visitor',
        dataKey: 'name'
      },
      'contact.email': {
        from: 'visitor',
        dataKey: 'visitorEmails[0].address'
      },
      'contact.phone': {
        from: 'visitor',
        dataKey: 'phone[0].phoneNumber'
      },
      'agent.name': {
        from: 'agent',
        dataKey: 'name'
      },
      'agent.email': {
        from: 'agent',
        dataKey: 'emails[0].address'
      }
    };
    class BeforeSaveCannedResponse {
      constructor() {
        this.getUser = mem(userId => Users.findOneById(userId, {
          projection: {
            name: 1,
            _id: 1,
            emails: 1
          }
        }), {
          maxAge: 1000 * 30
        });
        this.getVisitor = mem(visitorId => LivechatVisitors.findOneEnabledById(visitorId), {
          maxAge: 1000 * 30
        });
      }
      async replacePlaceholders(_ref) {
        var _room$servedBy;
        let {
          message,
          room,
          user
        } = _ref;
        // If the feature is disabled, return the message as is
        if (!BeforeSaveCannedResponse.enabled) {
          return message;
        }
        if (!message.msg || message.msg === '') {
          return message;
        }
        if (!isOmnichannelRoom(room)) {
          return message;
        }
        // do not replace placeholders for visitors
        if (!user || isILivechatVisitor(user)) {
          return message;
        }
        const agentId = room === null || room === void 0 ? void 0 : (_room$servedBy = room.servedBy) === null || _room$servedBy === void 0 ? void 0 : _room$servedBy._id;
        if (!agentId) {
          return message;
        }
        const getAgent = agentId => {
          if (agentId === user._id) {
            return user;
          }
          return this.getUser(agentId);
        };
        message.msg = await Object.keys(placeholderFields).reduce(async (messageText, field) => {
          const placeholderConfig = placeholderFields[field];
          const from = placeholderConfig.from === 'agent' ? await getAgent(agentId) : await this.getVisitor(room.v._id);
          const data = get(from, placeholderConfig.dataKey, '');
          return (await messageText).replace(new RegExp("{{".concat(field, "}}"), 'g'), data);
        }, Promise.resolve(message.msg));
        return message;
      }
    }
    BeforeSaveCannedResponse.enabled = false;
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"local-services":{"instance":{"getLogger.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/local-services/instance/getLogger.ts                                                                      //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      getLogger: () => getLogger
    });
    let pino;
    module.link("pino", {
      pino(v) {
        pino = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    function getLogger() {
      let {
        MOLECULER_LOG_LEVEL: level,
        NODE_ENV: mode
      } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (!level || typeof level !== 'string') {
        return {};
      }
      if (!['fatal', 'error', 'warn', 'info', 'debug', 'trace'].includes(level)) {
        return {};
      }
      return {
        logger: {
          type: 'Pino',
          options: {
            level,
            pino: {
              options: _objectSpread({
                timestamp: pino.stdTimeFunctions.isoTime
              }, mode !== 'production' ? {
                transport: {
                  target: 'pino-pretty',
                  options: {
                    colorize: true
                  }
                }
              } : {})
            }
          }
        }
      };
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"getTransporter.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/local-services/instance/getTransporter.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    module.export({
      getTransporter: () => getTransporter
    });
    function getTransporter() {
      let {
        transporter,
        port,
        extra
      } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (transporter) {
        if (!transporter.match(/^(?:monolith\+)/)) {
          throw new Error('invalid transporter');
        }
        const [, ...url] = transporter.split('+');
        return url.join('');
      }
      return _objectSpread({
        port: port ? port.trim() : 0,
        udpDiscovery: false,
        useHostname: false
      }, extra ? JSON.parse(extra) : {});
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"service.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/local-services/instance/service.ts                                                                        //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module1, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module1.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module1.export({
      InstanceService: () => InstanceService
    });
    let os;
    module1.link("os", {
      default(v) {
        os = v;
      }
    }, 0);
    let Apps, License, ServiceClassInternal;
    module1.link("@rocket.chat/core-services", {
      Apps(v) {
        Apps = v;
      },
      License(v) {
        License = v;
      },
      ServiceClassInternal(v) {
        ServiceClassInternal = v;
      }
    }, 1);
    let InstanceStatus, defaultPingInterval, indexExpire;
    module1.link("@rocket.chat/instance-status", {
      InstanceStatus(v) {
        InstanceStatus = v;
      },
      defaultPingInterval(v) {
        defaultPingInterval = v;
      },
      indexExpire(v) {
        indexExpire = v;
      }
    }, 2);
    let InstanceStatusRaw;
    module1.link("@rocket.chat/models", {
      InstanceStatus(v) {
        InstanceStatusRaw = v;
      }
    }, 3);
    let EJSON;
    module1.link("ejson", {
      default(v) {
        EJSON = v;
      }
    }, 4);
    let ServiceBroker, Transporters, Serializers;
    module1.link("moleculer", {
      ServiceBroker(v) {
        ServiceBroker = v;
      },
      Transporters(v) {
        Transporters = v;
      },
      Serializers(v) {
        Serializers = v;
      }
    }, 5);
    let getLogger;
    module1.link("./getLogger", {
      getLogger(v) {
        getLogger = v;
      }
    }, 6);
    let getTransporter;
    module1.link("./getTransporter", {
      getTransporter(v) {
        getTransporter = v;
      }
    }, 7);
    let SystemLogger;
    module1.link("../../../../server/lib/logger/system", {
      SystemLogger(v) {
        SystemLogger = v;
      }
    }, 8);
    let StreamerCentral;
    module1.link("../../../../server/modules/streamer/streamer.module", {
      StreamerCentral(v) {
        StreamerCentral = v;
      }
    }, 9);
    let AppsEngineNoNodesFoundError;
    module1.link("../../../../server/services/apps-engine/service", {
      AppsEngineNoNodesFoundError(v) {
        AppsEngineNoNodesFoundError = v;
      }
    }, 10);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    const hostIP = process.env.INSTANCE_IP ? String(process.env.INSTANCE_IP).trim() : 'localhost';
    const {
      Base
    } = Serializers;
    class EJSONSerializer extends Base {
      serialize(obj) {
        return Buffer.from(EJSON.stringify(obj));
      }
      deserialize(buf) {
        return EJSON.parse(buf.toString());
      }
    }
    class InstanceService extends ServiceClassInternal {
      constructor() {
        super();
        this.name = 'instance';
        this.broadcastStarted = false;
        this.transporter = void 0;
        this.broker = void 0;
        this.troubleshootDisableInstanceBroadcast = false;
        this.onEvent('license.module', async _ref => {
          let {
            module,
            valid
          } = _ref;
          if (module === 'scalability' && valid) {
            await this.startBroadcast();
          }
        });
        this.onEvent('watch.settings', async _ref2 => {
          let {
            clientAction,
            setting
          } = _ref2;
          if (clientAction === 'removed') {
            return;
          }
          const {
            _id,
            value
          } = setting;
          if (_id !== 'Troubleshoot_Disable_Instance_Broadcast') {
            return;
          }
          if (typeof value !== 'boolean') {
            return;
          }
          if (this.troubleshootDisableInstanceBroadcast === value) {
            return;
          }
          this.troubleshootDisableInstanceBroadcast = value;
        });
      }
      async created() {
        const transporter = getTransporter({
          transporter: process.env.TRANSPORTER,
          port: process.env.TCP_PORT,
          extra: process.env.TRANSPORTER_EXTRA
        });
        const isTransporterTCP = typeof transporter !== 'string';
        this.transporter = isTransporterTCP ? new Transporters.TCP(transporter) : new Transporters.NATS({
          url: transporter
        });
        this.broker = new ServiceBroker(_objectSpread({
          nodeID: InstanceStatus.id(),
          transporter: this.transporter,
          serializer: new EJSONSerializer(),
          heartbeatInterval: defaultPingInterval,
          heartbeatTimeout: indexExpire
        }, getLogger(process.env)));
        this.broker.createService({
          name: 'matrix',
          events: {
            broadcast(ctx) {
              const {
                eventName,
                streamName,
                args
              } = ctx.params;
              const {
                nodeID
              } = ctx;
              const fromLocalNode = nodeID === InstanceStatus.id();
              if (fromLocalNode) {
                return;
              }
              const instance = StreamerCentral.instances[streamName];
              if (!instance) {
                // return 'stream-not-exists';
                return;
              }
              if (instance.serverOnly) {
                instance.__emit(eventName, ...args);
              } else {
                // @ts-expect-error not sure why it thinks _emit needs an extra argument
                StreamerCentral.instances[streamName]._emit(eventName, args);
              }
            }
          },
          actions: {
            getAppsStatus(_ctx) {
              return Apps.getAppsStatusLocal();
            }
          }
        });
        if (isTransporterTCP) {
          const changeStream = InstanceStatusRaw.watchActiveInstances();
          changeStream.on('change', change => {
            var _change$fullDocument, _change$fullDocument$;
            if (change.operationType === 'update') {
              return;
            }
            if (change.operationType === 'insert' && (_change$fullDocument = change.fullDocument) !== null && _change$fullDocument !== void 0 && (_change$fullDocument$ = _change$fullDocument.extraInformation) !== null && _change$fullDocument$ !== void 0 && _change$fullDocument$.tcpPort) {
              this.connectNode(change.fullDocument);
              return;
            }
            if (change.operationType === 'delete') {
              this.disconnectNode(change.documentKey._id);
            }
          }).once('error', err => {
            SystemLogger.error({
              msg: 'Error in InstanceStatus change stream:',
              err
            });
          });
        }
      }
      connectNode(record) {
        var _this$broker, _this$broker$transit;
        if (record._id === InstanceStatus.id()) {
          return;
        }
        const {
          host,
          tcpPort
        } = record.extraInformation;
        ((_this$broker = this.broker) === null || _this$broker === void 0 ? void 0 : (_this$broker$transit = _this$broker.transit) === null || _this$broker$transit === void 0 ? void 0 : _this$broker$transit.tx).addOfflineNode(record._id, host, tcpPort);
      }
      disconnectNode(nodeId) {
        var _this$broker$transit2, _this$broker$transit3;
        ((_this$broker$transit2 = this.broker.transit) === null || _this$broker$transit2 === void 0 ? void 0 : _this$broker$transit2.tx).nodes.disconnected(nodeId, false);
        ((_this$broker$transit3 = this.broker.transit) === null || _this$broker$transit3 === void 0 ? void 0 : _this$broker$transit3.tx).nodes.nodes.delete(nodeId);
      }
      async started() {
        var _this$broker$transit4, _this$broker$transit5, _this$broker$transit6, _this$broker$transit7;
        await this.broker.start();
        const instance = {
          host: hostIP,
          port: String(process.env.PORT).trim(),
          tcpPort: (_this$broker$transit4 = this.broker.transit) === null || _this$broker$transit4 === void 0 ? void 0 : (_this$broker$transit5 = _this$broker$transit4.tx) === null || _this$broker$transit5 === void 0 ? void 0 : (_this$broker$transit6 = _this$broker$transit5.nodes) === null || _this$broker$transit6 === void 0 ? void 0 : (_this$broker$transit7 = _this$broker$transit6.localNode) === null || _this$broker$transit7 === void 0 ? void 0 : _this$broker$transit7.port,
          os: {
            type: os.type(),
            platform: os.platform(),
            arch: os.arch(),
            release: os.release(),
            uptime: os.uptime(),
            loadavg: os.loadavg(),
            totalmem: os.totalmem(),
            freemem: os.freemem(),
            cpus: os.cpus().length
          },
          nodeVersion: process.version
        };
        await InstanceStatus.registerInstance('rocket.chat', instance);
        try {
          const hasLicense = await License.hasModule('scalability');
          if (!hasLicense) {
            return;
          }
          await this.startBroadcast();
        } catch (error) {
          console.error('Instance service did not start correctly', error);
        }
      }
      async startBroadcast() {
        if (this.broadcastStarted) {
          return;
        }
        this.broadcastStarted = true;
        StreamerCentral.on('broadcast', this.sendBroadcast.bind(this));
      }
      sendBroadcast(streamName, eventName, args) {
        if (this.troubleshootDisableInstanceBroadcast) {
          return;
        }
        void this.broker.broadcast('broadcast', {
          streamName,
          eventName,
          args
        });
      }
      async getInstances() {
        return this.broker.call('$node.list', {
          onlyAvailable: true
        });
      }
      async getAppsStatusInInstances() {
        const instances = await this.getInstances();
        if (instances.length < 2) {
          throw new AppsEngineNoNodesFoundError();
        }
        const control = [];
        const statusByApp = {};
        instances.forEach(instance => {
          const {
            id: instanceId
          } = instance;
          control.push((async () => {
            const appsStatus = await this.broker.call('matrix.getAppsStatus', null, {
              nodeID: instanceId
            });
            if (!appsStatus) {
              throw new Error("Failed to get apps status from instance ".concat(instanceId));
            }
            appsStatus.forEach(_ref3 => {
              let {
                status,
                appId
              } = _ref3;
              if (!statusByApp[appId]) {
                statusByApp[appId] = [];
              }
              statusByApp[appId].push({
                instanceId,
                isLocal: instance.local,
                status
              });
            });
          })());
        });
        await Promise.all(control);
        return statusByApp;
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"ldap":{"service.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/local-services/ldap/service.ts                                                                            //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      LDAPEEService: () => LDAPEEService
    });
    let ServiceClassInternal;
    module.link("@rocket.chat/core-services", {
      ServiceClassInternal(v) {
        ServiceClassInternal = v;
      }
    }, 0);
    let LDAPEEManager;
    module.link("../../lib/ldap/Manager", {
      LDAPEEManager(v) {
        LDAPEEManager = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class LDAPEEService extends ServiceClassInternal {
      constructor() {
        super(...arguments);
        this.name = 'ldap-enterprise';
      }
      async sync() {
        return LDAPEEManager.sync();
      }
      async syncAvatars() {
        return LDAPEEManager.syncAvatars();
      }
      async syncLogout() {
        return LDAPEEManager.syncLogout();
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"message-reads":{"service.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/local-services/message-reads/service.ts                                                                   //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      MessageReadsService: () => MessageReadsService
    });
    let ServiceClassInternal, api;
    module.link("@rocket.chat/core-services", {
      ServiceClassInternal(v) {
        ServiceClassInternal = v;
      },
      api(v) {
        api = v;
      }
    }, 0);
    let Messages, MessageReads, Subscriptions;
    module.link("@rocket.chat/models", {
      Messages(v) {
        Messages = v;
      },
      MessageReads(v) {
        MessageReads = v;
      },
      Subscriptions(v) {
        Subscriptions = v;
      }
    }, 1);
    let MAX_ROOM_SIZE_CHECK_INDIVIDUAL_READ_RECEIPTS;
    module.link("../../lib/constants", {
      MAX_ROOM_SIZE_CHECK_INDIVIDUAL_READ_RECEIPTS(v) {
        MAX_ROOM_SIZE_CHECK_INDIVIDUAL_READ_RECEIPTS = v;
      }
    }, 2);
    let ReadReceipt;
    module.link("../../lib/message-read-receipt/ReadReceipt", {
      ReadReceipt(v) {
        ReadReceipt = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class MessageReadsService extends ServiceClassInternal {
      constructor() {
        super(...arguments);
        this.name = 'message-reads';
      }
      async readThread(userId, tmid) {
        const read = await MessageReads.findOneByUserIdAndThreadId(userId, tmid);
        const threadMessage = await Messages.findOneById(tmid, {
          projection: {
            ts: 1,
            tlm: 1,
            rid: 1
          }
        });
        if (!(threadMessage !== null && threadMessage !== void 0 && threadMessage.tlm)) {
          return;
        }
        await MessageReads.updateReadTimestampByUserIdAndThreadId(userId, tmid);
        await ReadReceipt.storeThreadMessagesReadReceipts(tmid, userId, (read === null || read === void 0 ? void 0 : read.ls) || threadMessage.ts);
        // doesn't mark as read if not all room members have read the thread
        const membersCount = await Subscriptions.countUnarchivedByRoomId(threadMessage.rid);
        if (membersCount <= MAX_ROOM_SIZE_CHECK_INDIVIDUAL_READ_RECEIPTS) {
          const subscriptions = await Subscriptions.findUnarchivedByRoomId(threadMessage.rid, {
            projection: {
              'u._id': 1
            }
          }).toArray();
          const members = subscriptions.map(s => s.u._id);
          const totalMessageReads = await MessageReads.countByThreadAndUserIds(tmid, members);
          if (totalMessageReads < membersCount) {
            return;
          }
        } else {
          // for large rooms, mark as read if there are as many reads as room members to improve performance (instead of checking each read)
          const totalMessageReads = await MessageReads.countByThreadId(tmid);
          if (totalMessageReads < membersCount) {
            return;
          }
        }
        const firstRead = await MessageReads.getMinimumLastSeenByThreadId(tmid);
        if (firstRead !== null && firstRead !== void 0 && firstRead.ls) {
          const result = await Messages.setThreadMessagesAsRead(threadMessage.rid, tmid, firstRead.ls);
          if (result.modifiedCount > 0) {
            void api.broadcast('notify.messagesRead', {
              rid: threadMessage.rid,
              tmid,
              until: firstRead.ls
            });
          }
        }
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}},"voip-freeswitch":{"service.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/local-services/voip-freeswitch/service.ts                                                                 //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      VoipFreeSwitchService: () => VoipFreeSwitchService
    });
    let ServiceClassInternal, ServiceStarter;
    module.link("@rocket.chat/core-services", {
      ServiceClassInternal(v) {
        ServiceClassInternal = v;
      },
      ServiceStarter(v) {
        ServiceStarter = v;
      }
    }, 0);
    let getDomain, getUserPassword, getExtensionList, getExtensionDetails, parseEventData, computeChannelFromEvents, logger, FreeSwitchEventClient;
    module.link("@rocket.chat/freeswitch", {
      getDomain(v) {
        getDomain = v;
      },
      getUserPassword(v) {
        getUserPassword = v;
      },
      getExtensionList(v) {
        getExtensionList = v;
      },
      getExtensionDetails(v) {
        getExtensionDetails = v;
      },
      parseEventData(v) {
        parseEventData = v;
      },
      computeChannelFromEvents(v) {
        computeChannelFromEvents = v;
      },
      logger(v) {
        logger = v;
      },
      FreeSwitchEventClient(v) {
        FreeSwitchEventClient = v;
      }
    }, 1);
    let FreeSwitchChannel, FreeSwitchChannelEvent, FreeSwitchChannelEventDelta;
    module.link("@rocket.chat/models", {
      FreeSwitchChannel(v) {
        FreeSwitchChannel = v;
      },
      FreeSwitchChannelEvent(v) {
        FreeSwitchChannelEvent = v;
      },
      FreeSwitchChannelEventDelta(v) {
        FreeSwitchChannelEventDelta = v;
      }
    }, 2);
    let wrapExceptions;
    module.link("@rocket.chat/tools", {
      wrapExceptions(v) {
        wrapExceptions = v;
      }
    }, 3);
    let MongoError;
    module.link("mongodb", {
      MongoError(v) {
        MongoError = v;
      }
    }, 4);
    let settings;
    module.link("../../../../app/settings/server", {
      settings(v) {
        settings = v;
      }
    }, 5);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class VoipFreeSwitchService extends ServiceClassInternal {
      constructor() {
        super();
        this.name = 'voip-freeswitch';
        this.serviceStarter = void 0;
        this.eventClient = null;
        this.wasEverConnected = false;
        this.serviceStarter = new ServiceStarter(async () => {
          // Delay start to ensure setting values are up-to-date in the cache
          setImmediate(() => this.startEvents());
        }, async () => this.stopEvents());
        this.onEvent('watch.settings', async _ref => {
          let {
            setting
          } = _ref;
          if (setting._id === 'VoIP_TeamCollab_Enabled') {
            if (setting.value !== true) {
              void this.serviceStarter.stop();
              return;
            }
            if (setting.value === true) {
              void this.serviceStarter.start();
              return;
            }
          }
          if (setting._id === 'VoIP_TeamCollab_FreeSwitch_Host') {
            // Re-connect if the host changes
            if (this.eventClient && this.eventClient.host !== setting.value) {
              this.stopEvents();
            }
            if (setting.value) {
              void this.serviceStarter.start();
            }
          }
          // If any other freeswitch setting changes, only reconnect if it's not yet connected
          if (setting._id.startsWith('VoIP_TeamCollab_FreeSwitch_')) {
            var _this$eventClient;
            if (!((_this$eventClient = this.eventClient) !== null && _this$eventClient !== void 0 && _this$eventClient.isReady())) {
              this.stopEvents();
              void this.serviceStarter.start();
            }
          }
        });
      }
      async started() {
        void this.serviceStarter.start();
      }
      async startEvents() {
        if (this.eventClient) {
          if (!this.eventClient.isDone()) {
            return;
          }
          const client = this.eventClient;
          this.eventClient = null;
          client.endConnection();
        }
        const options = wrapExceptions(() => this.getConnectionSettings()).suppress();
        if (!options) {
          this.wasEverConnected = false;
          return;
        }
        this.initializeEventClient(options);
      }
      retryEventsLater() {
        // Try to re-establish connection after some time
        setTimeout(() => {
          void this.startEvents();
        }, this.wasEverConnected ? 3000 : 20_000);
      }
      initializeEventClient(options) {
        const client = FreeSwitchEventClient.listenToEvents(options);
        this.eventClient = client;
        client.on('ready', () => {
          if (this.eventClient !== client) {
            return;
          }
          this.wasEverConnected = true;
        });
        client.on('end', () => {
          if (this.eventClient && this.eventClient !== client) {
            return;
          }
          this.eventClient = null;
          this.retryEventsLater();
        });
        client.on('event', async _ref2 => {
          let {
            eventName,
            eventData
          } = _ref2;
          if (this.eventClient !== client) {
            return;
          }
          await wrapExceptions(() => this.onFreeSwitchEvent(eventName, eventData)).suppress();
        });
      }
      stopEvents() {
        if (!this.eventClient) {
          return;
        }
        this.eventClient.endConnection();
        this.wasEverConnected = false;
        this.eventClient = null;
      }
      getConnectionSettings() {
        if (!settings.get('VoIP_TeamCollab_Enabled')) {
          throw new Error('VoIP is disabled.');
        }
        const host = settings.get('VoIP_TeamCollab_FreeSwitch_Host');
        if (!host) {
          throw new Error('VoIP is not properly configured.');
        }
        const port = settings.get('VoIP_TeamCollab_FreeSwitch_Port') || 8021;
        const timeout = settings.get('VoIP_TeamCollab_FreeSwitch_Timeout') || 3000;
        const password = settings.get('VoIP_TeamCollab_FreeSwitch_Password');
        return {
          socketOptions: {
            host,
            port
          },
          password,
          timeout
        };
      }
      async onFreeSwitchEvent(eventName, data) {
        const event = parseEventData(eventName, data);
        if (!event) {
          return;
        }
        await this.registerEvent(event);
      }
      async registerRecord(registerFn) {
        try {
          await registerFn();
        } catch (error) {
          // avoid logging that an event was duplicated from mongo
          if (error instanceof MongoError && error.code === 11000) {
            return;
          }
          logger.error(error);
          throw error;
        }
      }
      async registerEvent(event) {
        const {
          channelUniqueId,
          eventName
        } = event;
        if (eventName === 'CHANNEL_DESTROY' && channelUniqueId) {
          // #TODO: Replace with a proper background process, also make it not rely on the CHANNEL_DESTROY event.
          setTimeout(() => {
            this.computeChannel(channelUniqueId).catch(reason => {
              logger.error({
                msg: 'Failed to compute channel data ',
                reason,
                channelUniqueId
              });
            });
          }, 2000);
        }
        return this.registerRecord(() => FreeSwitchChannelEvent.registerEvent(event));
      }
      async registerChannel(channel) {
        return this.registerRecord(() => FreeSwitchChannel.registerChannel(channel));
      }
      async registerChannelDelta(record) {
        return this.registerRecord(() => FreeSwitchChannelEventDelta.registerDelta(record));
      }
      async computeChannel(channelUniqueId) {
        const allEvents = await FreeSwitchChannelEvent.findAllByChannelUniqueId(channelUniqueId).toArray();
        const result = await computeChannelFromEvents(allEvents);
        if (result !== null && result !== void 0 && result.channel) {
          const {
            channel,
            deltas
          } = result;
          await this.registerChannel(channel);
          await Promise.allSettled(deltas.map(async delta => this.registerChannelDelta(_objectSpread({
            channelUniqueId: channel.uniqueId
          }, delta))));
        }
      }
      async getDomain() {
        const options = this.getConnectionSettings();
        return getDomain(options);
      }
      async getUserPassword(user) {
        const options = this.getConnectionSettings();
        return getUserPassword(options, user);
      }
      async getExtensionList() {
        const options = this.getConnectionSettings();
        return getExtensionList(options);
      }
      async getExtensionDetails(requestParams) {
        const options = this.getConnectionSettings();
        return getExtensionDetails(options, requestParams);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}}},"models":{"raw":{"AuditLog.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/models/raw/AuditLog.ts                                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      AuditLogRaw: () => AuditLogRaw
    });
    let BaseRaw;
    module.link("@rocket.chat/models", {
      BaseRaw(v) {
        BaseRaw = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class AuditLogRaw extends BaseRaw {
      constructor(db, trash) {
        super(db, 'audit_log', trash);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"CannedResponse.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/models/raw/CannedResponse.ts                                                                              //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      CannedResponseRaw: () => CannedResponseRaw
    });
    let BaseRaw;
    module.link("@rocket.chat/models", {
      BaseRaw(v) {
        BaseRaw = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class CannedResponseRaw extends BaseRaw {
      constructor(db) {
        super(db, 'canned_response');
      }
      modelIndexes() {
        return [{
          key: {
            shortcut: 1
          },
          unique: true
        }];
      }
      async updateCannedResponse(_id, _ref) {
        let {
          shortcut,
          text,
          tags,
          scope,
          userId,
          departmentId,
          createdBy
        } = _ref;
        const record = {
          shortcut,
          text,
          scope,
          tags,
          userId,
          departmentId,
          createdBy
        };
        await this.updateOne({
          _id
        }, {
          $set: record
        });
        return Object.assign(record, {
          _id
        });
      }
      async createCannedResponse(_ref2) {
        let {
          shortcut,
          text,
          tags,
          scope,
          userId,
          departmentId,
          createdBy,
          _createdAt
        } = _ref2;
        const record = {
          shortcut,
          text,
          scope,
          tags,
          userId,
          departmentId,
          createdBy,
          _createdAt
        };
        const _id = (await this.insertOne(record)).insertedId;
        return Object.assign(record, {
          _id
        });
      }
      findOneById(_id, options) {
        const query = {
          _id
        };
        return this.findOne(query, options);
      }
      findOneByShortcut(shortcut, options) {
        const query = {
          shortcut
        };
        return this.findOne(query, options);
      }
      findByCannedResponseId(_id, options) {
        const query = {
          _id
        };
        return this.find(query, options);
      }
      findByDepartmentId(departmentId, options) {
        const query = {
          scope: 'department',
          departmentId
        };
        return this.find(query, options);
      }
      findByShortcut(shortcut, options) {
        const query = {
          shortcut
        };
        return this.find(query, options);
      }
      // REMOVE
      removeById(_id) {
        const query = {
          _id
        };
        return this.deleteOne(query);
      }
      removeTagFromCannedResponses(tagId) {
        const update = {
          $pull: {
            tags: tagId
          }
        };
        return this.updateMany({
          tags: tagId
        }, update);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"LivechatDepartment.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/models/raw/LivechatDepartment.ts                                                                          //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      LivechatDepartmentEE: () => LivechatDepartmentEE
    });
    let LivechatDepartmentRaw;
    module.link("@rocket.chat/models", {
      LivechatDepartmentRaw(v) {
        LivechatDepartmentRaw = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class LivechatDepartmentEE extends LivechatDepartmentRaw {
      constructor(db, trash) {
        super(db, trash);
      }
      async removeDepartmentFromForwardListById(departmentId) {
        await this.updateMany({
          departmentsAllowedToForward: departmentId
        }, {
          $pull: {
            departmentsAllowedToForward: departmentId
          }
        });
      }
      unfilteredFind(query, options) {
        return this.col.find(query, options);
      }
      unfilteredFindOne(query, options) {
        return this.col.findOne(query, options);
      }
      unfilteredUpdate(query, update, options) {
        return this.col.updateOne(query, update, options);
      }
      unfilteredRemove(query) {
        return this.col.deleteOne(query);
      }
      createOrUpdateDepartment(_id, data) {
        return super.createOrUpdateDepartment(_id, _objectSpread(_objectSpread({}, data), {}, {
          type: 'd'
        }));
      }
      removeParentAndAncestorById(id) {
        return this.updateMany({
          parentId: id
        }, {
          $unset: {
            parentId: 1
          },
          $pull: {
            ancestors: id
          }
        });
      }
      findActiveByUnitIds(unitIds) {
        let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
        const query = {
          enabled: true,
          numAgents: {
            $gt: 0
          },
          parentId: {
            $exists: true,
            $in: unitIds
          }
        };
        return this.find(query, options);
      }
      findEnabledWithAgentsAndBusinessUnit(businessUnit, projection) {
        if (!businessUnit) {
          return super.findEnabledWithAgents(projection);
        }
        return this.findActiveByUnitIds([businessUnit], {
          projection
        });
      }
      findByParentId(parentId, options) {
        return this.col.find({
          parentId
        }, options);
      }
      findAgentsByBusinessHourId(businessHourId) {
        return this.col.aggregate([[{
          $match: {
            businessHourId
          }
        }, {
          $lookup: {
            from: 'rocketchat_livechat_department_agents',
            localField: '_id',
            foreignField: 'departmentId',
            as: 'agents'
          }
        }, {
          $unwind: '$agents'
        }, {
          $group: {
            _id: null,
            agentIds: {
              $addToSet: '$agents.agentId'
            }
          }
        }]]);
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"LivechatDepartmentAgents.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/models/raw/LivechatDepartmentAgents.ts                                                                    //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      LivechatDepartmentAgents: () => LivechatDepartmentAgents
    });
    let LivechatDepartmentAgentsRaw;
    module.link("@rocket.chat/models", {
      LivechatDepartmentAgentsRaw(v) {
        LivechatDepartmentAgentsRaw = v;
      }
    }, 0);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class LivechatDepartmentAgents extends LivechatDepartmentAgentsRaw {
      findAgentsByAgentIdAndBusinessHourId(agentId, businessHourId) {
        const match = {
          $match: {
            agentId
          }
        };
        const lookup = {
          $lookup: {
            from: 'rocketchat_livechat_department',
            localField: 'departmentId',
            foreignField: '_id',
            as: 'departments'
          }
        };
        const unwind = {
          $unwind: {
            path: '$departments',
            preserveNullAndEmptyArrays: true
          }
        };
        const withBusinessHourId = {
          $match: {
            'departments.businessHourId': businessHourId
          }
        };
        const project = {
          $project: {
            departments: 0
          }
        };
        return this.col.aggregate([match, lookup, unwind, withBusinessHourId, project]).toArray();
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"LivechatInquiry.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/models/raw/LivechatInquiry.ts                                                                             //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    module.export({
      LivechatInquiryRawEE: () => LivechatInquiryRawEE
    });
    let DEFAULT_SLA_CONFIG, LivechatPriorityWeight;
    module.link("@rocket.chat/core-typings", {
      DEFAULT_SLA_CONFIG(v) {
        DEFAULT_SLA_CONFIG = v;
      },
      LivechatPriorityWeight(v) {
        LivechatPriorityWeight = v;
      }
    }, 0);
    let LivechatInquiryRaw;
    module.link("@rocket.chat/models", {
      LivechatInquiryRaw(v) {
        LivechatInquiryRaw = v;
      }
    }, 1);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class LivechatInquiryRawEE extends LivechatInquiryRaw {
      setSlaForRoom(rid, sla) {
        const {
          estimatedWaitingTimeQueue,
          slaId
        } = sla;
        return this.findOneAndUpdate({
          rid
        }, {
          $set: {
            slaId,
            estimatedWaitingTimeQueue
          }
        });
      }
      unsetSlaForRoom(rid) {
        return this.findOneAndUpdate({
          rid
        }, {
          $unset: {
            slaId: 1
          },
          $set: {
            estimatedWaitingTimeQueue: DEFAULT_SLA_CONFIG.ESTIMATED_WAITING_TIME_QUEUE
          }
        });
      }
      bulkUnsetSla(roomIds) {
        return this.updateMany({
          rid: {
            $in: roomIds
          }
        }, {
          $unset: {
            slaId: 1
          },
          $set: {
            estimatedWaitingTimeQueue: DEFAULT_SLA_CONFIG.ESTIMATED_WAITING_TIME_QUEUE
          }
        });
      }
      setPriorityForRoom(rid, priority) {
        return this.findOneAndUpdate({
          rid
        }, {
          $set: {
            priorityId: priority._id,
            priorityWeight: priority.sortItem
          }
        });
      }
      unsetPriorityForRoom(rid) {
        return this.findOneAndUpdate({
          rid
        }, {
          $unset: {
            priorityId: 1
          },
          $set: {
            priorityWeight: LivechatPriorityWeight.NOT_SPECIFIED
          }
        });
      }
    }
    __reify_async_result__();
  } catch (_reifyError) {
    return __reify_async_result__(_reifyError);
  }
  __reify_async_result__()
}, {
  self: this,
  async: false
});
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

},"LivechatRooms.ts":function module(require,exports,module){

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                                                                                                     //
// ee/server/models/raw/LivechatRooms.ts                                                                               //
//                                                                                                                     //
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                                                                                                       //
!module.wrapAsync(async function (module, __reifyWaitForDeps__, __reify_async_result__) {
  "use strict";
  try {
    let _objectSpread;
    module.link("@babel/runtime/helpers/objectSpread2", {
      default(v) {
        _objectSpread = v;
      }
    }, 0);
    module.export({
      LivechatRoomsRawEE: () => LivechatRoomsRawEE
    });
    let LivechatPriorityWeight, DEFAULT_SLA_CONFIG;
    module.link("@rocket.chat/core-typings", {
      LivechatPriorityWeight(v) {
        LivechatPriorityWeight = v;
      },
      DEFAULT_SLA_CONFIG(v) {
        DEFAULT_SLA_CONFIG = v;
      }
    }, 0);
    let LivechatRoomsRaw;
    module.link("@rocket.chat/models", {
      LivechatRoomsRaw(v) {
        LivechatRoomsRaw = v;
      }
    }, 1);
    let escapeRegExp;
    module.link("@rocket.chat/string-helpers", {
      escapeRegExp(v) {
        escapeRegExp = v;
      }
    }, 2);
    let readSecondaryPreferred;
    module.link("../../../../server/database/readSecondaryPreferred", {
      readSecondaryPreferred(v) {
        readSecondaryPreferred = v;
      }
    }, 3);
    if (__reifyWaitForDeps__()) (await __reifyWaitForDeps__())();
    class LivechatRoomsRawEE extends LivechatRoomsRaw {
      constructor(db, trash) {
        super(db, trash);
      }
      countPrioritizedRooms() {
        return this.countDocuments({
          priorityId: {
            $exists: true
          }
        });
      }
      countRoomsWithSla() {
        return this.countDocuments({
          slaId: {
            $exists: true
          }
        });
      }
      countRoomsWithTranscriptSent() {
        return this.countDocuments({
          pdfTranscriptFileId: {
            $exists: true
          }
        });
      }
      async unsetAllPredictedVisitorAbandonment() {
        return this.updateMany({
          'open': true,
          't': 'l',
          'omnichannel.predictedVisitorAbandonmentAt': {
            $exists: true
          }
        }, {
          $unset: {
            'omnichannel.predictedVisitorAbandonmentAt': 1
          }
        }).then();
      }
      setOnHoldByRoomId(roomId) {
        return this.updateOne({
          _id: roomId
        }, {
          $set: {
            onHold: true
          }
        });
      }
      unsetOnHoldByRoomId(roomId) {
        return this.updateOne({
          _id: roomId
        }, {
          $unset: {
            onHold: 1
          }
        });
      }
      unsetOnHoldAndPredictedVisitorAbandonmentByRoomId(roomId) {
        return this.updateOne({
          _id: roomId
        }, {
          $unset: {
            'omnichannel.predictedVisitorAbandonmentAt': 1,
            'onHold': 1
          }
        });
      }
      setSlaForRoomById(roomId, sla) {
        const {
          _id: slaId,
          dueTimeInMinutes
        } = sla;
        return this.updateOne({
          _id: roomId
        }, {
          $set: {
            slaId,
            estimatedWaitingTimeQueue: dueTimeInMinutes
          }
        });
      }
      removeSlaFromRoomById(roomId) {
        return this.updateOne({
          _id: roomId
        }, {
          $unset: {
            slaId: 1
          },
          $set: {
            estimatedWaitingTimeQueue: DEFAULT_SLA_CONFIG.ESTIMATED_WAITING_TIME_QUEUE
          }
        });
      }
      bulkRemoveSlaFromRoomsById(slaId) {
        return this.updateMany({
          open: true,
          t: 'l',
          slaId
        }, {
          $unset: {
            slaId: 1
          },
          $set: {
            estimatedWaitingTimeQueue: DEFAULT_SLA_CONFIG.ESTIMATED_WAITING_TIME_QUEUE
          }
        });
      }
      findOpenBySlaId(slaId, options, extraQuery) {
        const query = _objectSpread({
          t: 'l',
          open: true,
          slaId
        }, extraQuery);
        return this.find(query, options);
      }
      async setPriorityByRoomId(roomId, priority) {
        const {
          _id: priorityId,
          sortItem: priorityWeight
        } = priority;
        return this.updateOne({
          _id: roomId
        }, {
          $set: {
            priorityId,
            priorityWeight
          }
        });
      }
      async unsetPriorityByRoomId(roomId) {
        return this.updateOne({
          _id: roomId
        }, {
          $unset: {
            priorityId: 1
          },
          $set: {
            priorityWeight: LivechatPriorityWeight.NOT_SPECIFIED
          }
        });
      }
      getPredictedVisitorAbandonmentByRoomIdUpdateQuery(date) {
        let roomUpdater = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.getUpdater();
        return roomUpdater.set('omnichannel.predictedVisitorAbandonmentAt', date);
      }
      setPredictedVisitorAbandonmentByRoomId(rid, willBeAbandonedAt) {
        const query = {
          _id: rid
        };
        const update = {
          $set: {
            'omnichannel.predictedVisitorAbandonmentAt': willBeAbandonedAt
          }
        };
        return this.updateOne(query, update);
      }
      findAbandonedOpenRooms(date, extraQuery) {
        return this.find(_objectSpread({
          'omnichannel.predictedVisitorAbandonmentAt': {
            $lte: date
          },
          'waitingResponse': {
            $exists: false
          },
          'closedAt': {
            $exists: false
          },
          'open': true
        }, extraQuery));
      }
      async unsetPredictedVisitorAbandonmentByRoomId(roomId) {
        return this.updateOne({
          _id: roomId
        }, {
          $unset: {
            'omnichannel.predictedVisitorAbandonmentAt': 1
          }
        });
      }
      async associateRoomsWithDepartmentToUnit(departments, unitId) {
        const query = {
          $and: [{
            departmentId: {
              $in: departments
            }
          }, {
            $or: [{
              departmentAncestors: {
                $exists: false
              }
            }, {
              $and: [{
                departmentAncestors: {
                  $exists: true
                }
              }, {
                departmentAncestors: {
                  $ne: unitId
                }
              }]
            }]
          }]
        };
        const update = {
          $set: {
            departmentAncestors: [unitId]
          }
        };
        await this.updateMany(query, update);
        const queryToDisassociateOldRoomsConnectedToUnit = {
          departmentAncestors: unitId,
          departmentId: {
            $nin: departments
          }
        };
        const updateToDisassociateRooms = {
          $unset: {
            departmentAncestors: 1
          }
        };
        await this.updateMany(queryToDisassociateOldRoomsConnectedToUnit, updateToDisassociateRooms);
      }
      async removeUnitAssociationFromRooms(unitId) {
        const query = {
          departmentAncestors: unitId
        };
        const update = {
          $unset: {
            departmentAncestors: 1
          }
        };
        await this.updateMany(query, update);
      }
      async updateDepartmentAncestorsById(rid, departmentAncestors) {
        const query = {
          _id: rid
        };
        const update = departmentAncestors ? {
          $set: {
            departmentAncestors
          }
        } : {
          $unset: {
            departmentAncestors: 1
          }
        };
        return this.updateOne(query, update);
      }
      getConversationsBySource(start, end, extraQuery) {
        return this.col.aggregate([{
          $match: _objectSpread({
            source: {
              $exists: true
            },
            t: 'l',
            ts: {
              $gte: start,
              $lt: end
            }
          }, extraQuery)
        }, {
          $group: {
            _id: {
              type: '$source.type',
              alias: '$source.alias'
            },
            value: {
              $sum: 1
            }
          }
        }, {
          $sort: {
            value: -1
          }
        }, {
          $group: {
            _id: null,
            total: {
              $sum: '$value'
            },
            data: {
              $push: {
                label: {
                  $ifNull: ['$_id.alias', '$_id.type']
                },
                value: '$value'
              }
            }
          }
        }, {
          $project: {
            _id: 0
          }
        }], {
          hint: 'source_1_ts_1',
          readPreference: readSecondaryPreferred()
        });
      }
      getConversationsByStatus(start, end, extraQuery) {
        return this.col.aggregate([{
          $match: _objectSpread({
            t: 'l',
            ts: {
              $gte: start,
              $lt: end
            }
          }, extraQuery)
        }, {
          $group: {
            _id: null,
            total: {
              $sum: 1
            },
            open: {
              $sum: {
                $cond: [{
                  $and: [{
                    $eq: ['$open', true]
                  }, {
                    $or: [{
                      $not: ['$onHold']
                    }, {
                      $eq: ['$onHold', 