# -*- coding: utf-8 -*-
from setuphelpers import *
import jinja2
from waptcrypto import SSLCertificate, SSLPrivateKey
import time


front_web = 'nginx' # nginx,none
rocketchat_url = 'https://rocketchat.yourdomain.com'
generate_ssl_cert = True # Values : True / False. Use False if you use commercial, Let's Encrypt or your PKI certificate.
# In this case, please configure "ssl_certificate_path" and "ssl_key_path" around line 220.
ssl_certificate_path = None # Set None if generate_ssl_cert = True
ssl_key_path = None # Set None if generate_ssl_cert = True

def systemd_enable_start_service(servicename):
    return run('LANG=C systemctl enable --now %s' % (servicename))


def install():
    print('Install dependances')
    install_apt('curl')
    install_apt('build-essential')
    install_apt('graphicsmagick')
    install_apt('sudo')

    print('If upgrade, stop Rocket.Chat')
    try:
        systemd_stop_service('rocketchat')
        first_install = False
    except:
        print("It's the first install")
        first_install = True

    print('Stop MongoDB Server')
    systemd_stop_service('mongod')

    print('Extact archive')
    run('tar xzf rocket.chat.tgz -C /tmp')

    print('Install node dependancies')
    print(run('(cd /tmp/bundle/programs/server; npm i)'))

    if not first_install:
        print('Remove old files')
        remove_tree('/opt/Rocket.Chat')

    print('Move files')
    copytree2('/tmp/bundle','/opt/Rocket.Chat')

    if first_install:
        print('Create rocketchat user')
        run('sudo useradd -M rocketchat && sudo usermod -L rocketchat')

    print('Set user rights')
    run('sudo chown -R rocketchat:rocketchat /opt/Rocket.Chat')

    node_path = run('which node').split('\n')[0]

    if first_install:
        print('Create service file')
        service = f"""[Unit]
Description=The Rocket.Chat server
After=network.target remote-fs.target nss-lookup.target nginx.service mongod.service
[Service]
Environment=ROOT_URL=http://localhost:3000
Environment=PORT=3000
Environment=MONGO_URL=mongodb://localhost:27017/rocketchat?replicaSet=rs01
Environment=MONGO_OPLOG_URL=mongodb://localhost:27017/local?replicaSet=rs01
ExecStart={node_path} /opt/Rocket.Chat/main.js
StandardOutput=syslog
StandardError=syslog
SyslogIdentifier=rocketchat
User=rocketchat
[Install]
WantedBy=multi-user.target
"""

        with open('/lib/systemd/system/rocketchat.service','w') as service_file:
            service_file.write(service)
           
        run('systemctl daemon-reload')

    #if first_install:
    print('Configure MongoDB Server for Rocket.Chat')
    filecopyto('files/mongod.conf','/etc/mongod.conf')
        
    print('Start MongoDB Server')
    systemd_start_service('mongod')

    if first_install:
        time.sleep(10)
        print('Create the replicaset')
        run('mongosh --eval "printjson(rs.initiate())"')

    systemd_enable_start_service('rocketchat')

    if first_install:
        if front_web == 'nginx':
            print('Install Nginx')
            install_apt('nginx')

            jinja_env = jinja2.Environment(loader=jinja2.FileSystemLoader('templates'))
            template = jinja_env.get_template('nginx.conf.j2')

            print('Generate dhparam')
            run('openssl dhparam -out /etc/nginx/dhparam 2048')

            if generate_ssl_cert:
                print('Generate SSL key and certificate')
                ap_ssl_dir = makepath('/etc','ssl')
                mkdirs(ap_ssl_dir)
                key_fn = os.path.join(ap_ssl_dir,'private','rocketchat_key.pem')
                key = SSLPrivateKey(key_fn)
                if not os.path.isfile(key_fn):
                    print('Create SSL RSA Key %s' % key_fn)
                    key.create()
                    key.save_as_pem()

                cert_fn = os.path.join(ap_ssl_dir,'certs','rocketchat_cert.pem')
                if os.path.isfile(cert_fn):
                    crt = SSLCertificate(cert_fn)
                    if os.path.isfile(cert_fn):
                        crt = SSLCertificate(cert_fn)
                        if crt.cn != get_fqdn():
                            os.rename(cert_fn,"%s-%s.old" % (cert_fn,'{:%Y%m%d-%Hh%Mm%Ss}'.format(datetime.datetime.now())))
                            crt = key.build_sign_certificate(cn=get_fqdn(),is_code_signing=False)
                            print('Create X509 cert %s' % cert_fn)
                            crt.save_as_pem(cert_fn)
                else:
                    crt = key.build_sign_certificate(cn=get_fqdn(),is_code_signing=False)
                    print('Create X509 cert %s' % cert_fn)
                    crt.save_as_pem(cert_fn)

                template_variables = {
                    'rocketchat_url': rocketchat_url.replace('https://','').replace('http://',''),
                    'ssl_certificate_path': cert_fn.replace('\\','/'),
                    'ssl_key_path': key_fn.replace('\\','/')
                }
            else:
                template_variables = {
                    'rocketchat_url': rocketchat_url.replace('https://','').replace('http://',''),
                    'ssl_certificate_path': makepath('/etc','ssl','certs','rocketchat_cert.pem'),
                    'ssl_key_path': makepath('/etc','ssl','private','rocketchat_key.pem')
                }

            config_string = template.render(template_variables)
            print('Create Nginx configuration file %s' % makepath('/etc','nginx','sites-avalables','rocketchat.conf'))
            with open(makepath('/etc','nginx','sites-available','rocketchat.conf'), 'wt') as dst_file:
                dst_file.write(config_string)

            print('Create symlink to activate rocketchat site')
            if not os.path.exists('/etc/nginx/sites-enabled/rocketchat.conf'):
                print(run('ln -s /etc/nginx/sites-available/rocketchat.conf /etc/nginx/sites-enabled/rocketchat.conf'))

            print('Test Nginx configuration and start nginx')
            print(run('nginx -t'))
            print(run('systemctl restart nginx'))
            print(run('systemctl enable nginx'))

        else:
            print('No front web selected.')
