# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    bin_name = glob.glob('RoboForm-*-Setup.exe')[0]

    # Installing the software
    install_exe_if_needed(bin_name,
        silentflags='/silent /unatt',
        key='AI RoboForm',
        min_version= control.get_software_version(),
    )
    
    uninstallkey.clear()

def uninstall():
        for to_uninstall in installed_softwares('AI RoboForm'):
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            quiet_uninstall_string = (installed_softwares(uninstallkey=to_uninstall["key"])[0]["uninstall_string"] + r' /silent /unatt')
            run(quiet_uninstall_string)
            wait_uninstallkey_absent(to_uninstall["key"])

# def uninstall() :
#     run('"C:\\Program Files (x86)\\Siber Systems\\AI RoboForm\\rfwipeout.exe\" /silent /unatt')

def audit():
    if not uninstall_key_exists("AI RoboForm"):
        print('uninstallkey RoboForm  not found')
        return "ERROR"
    else:
        return "OK"