# -*- coding: utf-8 -*-
from setuphelpers import *
import glob
import os

app_name = "ripgrep"
app_dir = makepath(programfiles, app_name)
app_path = makepath(app_dir,  "rg.exe")
audit_version = False

def get_installed_version(app_path):
    return get_file_properties(app_path).get("FileVersion", "")

def install():
    # Find the zip file
    zip_name = glob.glob(f"{app_name}*.zip")[0]
    unzip_dest = makepath(".", "temp_dezip")
    
    # Remove the temporary directory if it already exists
    if isdir(unzip_dest):
        remove_tree(unzip_dest)
    
    # Extract the zip file
    print(f"Extracting: {zip_name} to: {unzip_dest}")
    unzip(zip_name, unzip_dest)
    
    # Find the name of the extracted directory
    unzipped_dir = makepath(unzip_dest, os.listdir(unzip_dest)[0])
    
    # Remove the old application directory if it exists
    if isdir(app_dir):
        remove_tree(app_dir)
    
    # Move the new extracted directory to the final installation directory
    copytree2(unzipped_dir, app_dir, onreplace=default_overwrite)
    
    # Remove the temporary directory
    remove_tree(unzip_dest)
    
    # Create custom shortcuts
    create_desktop_shortcut(app_name, target=app_path)
    create_programs_menu_shortcut(app_name, target=app_path)

def audit():
    # Auditing software
    audit_status = "OK"
    installed_version = get_installed_version(app_path)
    if Version(installed_version) < Version(control.get_software_version()) and audit_version:
        print("%s is installed in version (%s) instead of (%s)" % (app_name, installed_version, control.get_software_version()))
        audit_status = "WARNING"
    elif isdir(app_dir) and not dir_is_empty(app_dir):
        print("%s (%s) is installed" % (app_name, installed_version))
        audit_status = "OK"
    else:
        print("%s is not installed" % app_name)
        audit_status = "ERROR"
    return audit_status

def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)
