# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2023
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *

from setuphelpers import *


bin_path = makepath("/", "usr", "local", "bin")
app_path = "/opt/rg"

def install():
    # Extraction and copying to /opt/typst
    extract_path = glob.glob("*.tar.gz")[0]
    run(f"tar -xzvf {extract_path}")
    char_len = len(extract_path) - len('.tar.gz')
    extract_path = extract_path[:char_len]
    bin_name = os.path.join(extract_path, "rg")
    print(f"copying ripgrep to {app_path}")
    if not isdir(app_path):
        mkdirs(app_path)
    filecopyto(bin_name, app_path)
    # Creation of symlink
    if not isfile(f"{bin_path}/rg"):
        print("create rg alias in path")
        os.symlink(f"{app_path}/rg", f"{bin_path}/rg")
    if isdir(extract_path):
        remove_tree(extract_path)

def uninstall():
    # Removing of symlink
    if isfile(f"{bin_path}/rg"):
        remove_file(f"{bin_path}/rg")
    # Removing of the software 
    if isdir(app_path):
        remove_tree(app_path)