from setuphelpers import *
import requests
import re
import json

def update_package():
    # Déclarer les variables locales
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    git_repo = "BurntSushi/ripgrep"
    dict_arch ={
        "x64":".deb",
        #"x86": "-686-pc-windows-msvc"
    }
    url_api = f"https://api.github.com/repos/{git_repo}/releases/latest"
    
    # Getting latest version information from official sources
    print("API used is: %s" % url_api)
    json_load = json.loads(wgets(url_api, proxies=proxies))

    for download in json_load["assets"]:
        if download["browser_download_url"].endswith('.deb') and dict_arch[control.architecture] in download["browser_download_url"]:
            url_dl = download["browser_download_url"]
            version = json_load["tag_name"].replace("v","")
            filename = download["name"]
            break

    if not isfile(filename):
        package_updated = True
        wget(url_dl,filename,proxies=proxies)

    #nettoyer les fichiers temporaires
    for f in glob.glob('*.deb'):
        if f != filename:
            remove_file(f)
    
    control.set_software_version(version)
    control.save_control_to_wapt()