# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob

def update_package():
    # Declaring local variables
    package_updated = False

    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

    download_url = "https://app.ringcentral.com/download/RingCentral-x64.msi"
    latest_bin = download_url.split('/')[-1]

    wget(download_url, latest_bin, proxies=proxies)

    # Deleting outdated binaries
    for f in glob.glob('*.msi'):
        if f != latest_bin:
            remove_file(f)

    version = get_version_from_binary(latest_bin)
    # Mettre à jour le package
    control.set_software_version(version)
    control.save_control_to_wapt()


