# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    download_url = "https://wapt.tranquil.it/wapt/releases/latest/bin/linux-x64/wapttftpserver"
    latest_bin = "wapttftpserver.bin"
    version = json.loads(wgets("https://wapt.tranquil.it/wapt/releases/latest/wapt_agent_list.json", proxies=proxies))[0]["wapt_version"]

    # Deleting binaries
    for f in glob.glob("*.exe") + glob.glob("*.msi") + glob.glob("*.bin"):
        print("Removing: %s" % f)
        remove_file(f)

    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating or not update-package-sources
    return package_updated
