# -*- coding: utf-8 -*-
from setuphelpers import *

bin_contains = "R-"
app_path = "/Applications/R.app"


def install():
    # Declaring local variables
    package_version = control.get_software_version()
    bin_name = glob.glob("*%s*.pkg" % bin_contains)[0]

    # check if app is already installed
    if isdir(app_path):
        if is_local_app_installed(app_path, check_version=package_version):
            print("App already installed or newer version present")
        else:
            # remove previous version
            print("Removing old app")
            remove_tree(app_path)
            # Installing the package
            print("Installing: %s" % bin_name)
            install_pkg(bin_name, re)

    else:
        # Installing the package
        print("Installing: %s" % bin_name)
        install_pkg(bin_name)


def uninstall():
    # Uninstalling package
    print("Uninstalling: %s" % app_path)
    remove_tree(app_path)
    uninstall_pkg("org.R-project.R.GUI.pkg")
    uninstall_pkg("org.r-project.x86_64.texinfo")
    uninstall_pkg("org.R-project.R.fw.pkg")
    uninstall_pkg("org.r-project.x86_64.tcltk")
    uninstall_pkg("org.R-project.x86_64.R.fw.pkg")
    uninstall_pkg("org.R-project.x86_64.R.GUI.pkg")


def audit():
    package_version = control.get_software_version()
    if isdir(app_path):
        if is_local_app_installed(app_path, check_version=package_version):
            print("%s is present with proper version" % app_path)
            return "OK"
        else:
            print("%s version is outdated " % app_path)
            return "WARNING"
    else:
        print("%s is missing " % app_path)
        return "ERROR"
