# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():

    proxies = {}
    if isfile(makepath(application_data(), "waptconsole", "waptconsole.ini")):
        proxywapt = inifile_readstring(makepath(user_local_appdata(), "waptconsole", "waptconsole.ini"), "global", "http_proxy")
        if proxywapt:
            proxies = {"http": proxywapt, "https": proxywapt}

    binaryfile, urlfile = [
        (str(p["name"]), str(p["browser_download_url"]))
        for p in json.loads(wgets("https://api.github.com/repos/pyzo/pyzo/releases/latest", proxies=proxies))["assets"]
        if "exe" in p["name"]
        if not "windows10" in p["name"]
    ][0]
    lastversion = binaryfile.split("-")[1]

    for exe in glob.glob("*.exe"):
        if exe != binaryfile:
            remove_file(exe)

    if not isfile(binaryfile):
        wget(urlfile, binaryfile, proxies=proxies)

    os.chdir(os.path.dirname(__file__))
    from waptpackage import PackageEntry

    pe = PackageEntry()
    pe.load_control_from_wapt(os.getcwd())

    print("Last Version %s" % lastversion)
    pe.version = lastversion + "-0"
    pe.save_control_to_wapt(os.getcwd())
