# -*- coding: utf-8 -*-
from setuphelpers import *
import requests


def update_package():
    print("Download/Update package content from upstream binary sources")

    # Initializing variables
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    version_url = "https://sourceforge.net/projects/pyscripter/files/"
    
    # Getting URL to find PyScripter 4 directory
    print("URL used is: %s" % version_url)
    for bs_search in bs_find_all(version_url, "span", "class", proxies=proxies):
        if "PyScripter-v5" in bs_search.get_text():
            url = version_url + bs_search.get_text()
            break

    #Getting download_url of exe 
    for bs_search in bs_find_all(url, "a", "href", proxies=proxies):
        if "PyScripter-5" in bs_search["href"] and "-x86-Setup.exe" in bs_search["href"]:
            download_url = bs_search["href"]
            latest_bin = bs_search["href"].rsplit("/",2)[-2]
            version = latest_bin.split("-")[1]
            break

    exes = glob.glob("*.exe")
    for fn in exes:
        if fn != latest_bin:
            remove_file(fn)

    if not isfile(latest_bin):
        print("Downloading %s from %s" % (latest_bin, download_url))
        wget(download_url, latest_bin, proxies=proxies)
    
    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))

    # Changing version of the package
    control.version = "%s-%s" % (version, control.version.split("-", 1)[-1])
    control.save_control_to_wapt()
    print("Changing package version to: %s in WAPT\\control" % control.version)

    # Deleting outdated binaries
    remove_outdated_binaries(version)
